/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.util;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.intercept.web.FilterInvocation;
import org.springframework.util.Assert;

public final class FilterInvocationUtils {
    private FilterInvocationUtils() {
    }

    public static FilterInvocation create(String contextPath, String uri) {
        Assert.hasText((String)contextPath, (String)"contextPath required");
        Assert.hasText((String)uri, (String)"URI required");
        MockHttpServletRequest req = new MockHttpServletRequest();
        req.setRequestURI(contextPath + uri);
        req.setContextPath(contextPath);
        req.setServletPath(null);
        FilterInvocation fi = new FilterInvocation((ServletRequest)req, (ServletResponse)new MockHttpServletResponse(), new FilterChain(){

            public void doFilter(ServletRequest arg0, ServletResponse arg1) throws IOException, ServletException {
                throw new UnsupportedOperationException("WebInvocationPrivilegeEvaluator does not support filter chains");
            }
        });
        return fi;
    }

    public static FilterInvocation create(String uri) {
        return FilterInvocationUtils.create("/notused", uri);
    }
}

