/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.ldap;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.ldap.core.AuthenticationSource;
import org.springframework.security.Authentication;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.security.providers.anonymous.AnonymousAuthenticationToken;
import org.springframework.security.userdetails.ldap.LdapUserDetails;

public class SpringSecurityAuthenticationSource
implements AuthenticationSource {
    private static final Log log = LogFactory.getLog((Class)(class$org$springframework$security$ldap$SpringSecurityAuthenticationSource == null ? (class$org$springframework$security$ldap$SpringSecurityAuthenticationSource = SpringSecurityAuthenticationSource.class$("org.springframework.security.ldap.SpringSecurityAuthenticationSource")) : class$org$springframework$security$ldap$SpringSecurityAuthenticationSource));
    static /* synthetic */ Class class$org$springframework$security$ldap$SpringSecurityAuthenticationSource;

    public String getPrincipal() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null) {
            log.warn((Object)"No Authentication object set in SecurityContext - returning empty String as Principal");
            return "";
        }
        Object principal = authentication.getPrincipal();
        if (principal instanceof LdapUserDetails) {
            LdapUserDetails details = (LdapUserDetails)principal;
            return details.getDn();
        }
        if (authentication instanceof AnonymousAuthenticationToken) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Anonymous Authentication, returning empty String as Principal");
            }
            return "";
        }
        throw new IllegalArgumentException("The principal property of the authentication objectneeds to be an LdapUserDetails.");
    }

    public String getCredentials() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null) {
            log.warn((Object)"No Authentication object set in SecurityContext - returning empty String as Credentials");
            return "";
        }
        return (String)authentication.getCredentials();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

