/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.heapwalk.details.api;

import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.JavaClass;

public final class StringDecoder {
    private static final Map<Heap, int[]> CACHE = new WeakHashMap<Heap, int[]>();
    private final byte coder;
    private final List<String> values;
    private int HI_BYTE_SHIFT;
    private int LO_BYTE_SHIFT;

    public StringDecoder(Heap heap, byte c, List<String> val) {
        this.coder = c;
        this.values = val;
        if (this.coder == 1) {
            int[] shiftBytes = CACHE.get(heap);
            if (shiftBytes == null) {
                JavaClass utf16Class = heap.getJavaClassByName("java.lang.StringUTF16");
                Integer hiShift = (Integer)utf16Class.getValueOfStaticField("HI_BYTE_SHIFT");
                Integer loShift = (Integer)utf16Class.getValueOfStaticField("LO_BYTE_SHIFT");
                shiftBytes = hiShift != null && loShift != null ? new int[]{hiShift, loShift} : new int[]{0, 8};
                CACHE.put(heap, shiftBytes);
            }
            this.HI_BYTE_SHIFT = shiftBytes[0];
            this.LO_BYTE_SHIFT = shiftBytes[1];
        }
    }

    public int getStringLength() {
        int size = this.values.size();
        switch (this.coder) {
            case -1: {
                return size;
            }
            case 0: {
                return size;
            }
            case 1: {
                return size / 2;
            }
        }
        return size;
    }

    public String getValueAt(int index) {
        switch (this.coder) {
            case -1: {
                return this.values.get(index);
            }
            case 0: {
                char ch = (char)(Byte.valueOf(this.values.get(index)) & 0xFF);
                return String.valueOf(ch);
            }
            case 1: {
                byte hiByte = Byte.valueOf(this.values.get(index *= 2));
                byte lowByte = Byte.valueOf(this.values.get(index + 1));
                char ch = (char)((hiByte & 0xFF) << this.HI_BYTE_SHIFT | (lowByte & 0xFF) << this.LO_BYTE_SHIFT);
                return String.valueOf(ch);
            }
        }
        return "?";
    }
}

