/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.levels;

import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Mob;
import com.shatteredpixel.shatteredpixeldungeon.items.Generator;
import com.shatteredpixel.shatteredpixeldungeon.items.Heap;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.armor.Armor;
import com.shatteredpixel.shatteredpixeldungeon.items.wands.WandOfRegrowth;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.MeleeWeapon;
import com.shatteredpixel.shatteredpixeldungeon.levels.CityLevel;
import com.shatteredpixel.shatteredpixeldungeon.levels.builders.Builder;
import com.shatteredpixel.shatteredpixeldungeon.levels.builders.GridBuilder;
import com.shatteredpixel.shatteredpixeldungeon.levels.features.LevelTransition;
import com.shatteredpixel.shatteredpixeldungeon.levels.rooms.Room;
import com.shatteredpixel.shatteredpixeldungeon.levels.rooms.quest.vault.VaultCircleRoom;
import com.shatteredpixel.shatteredpixeldungeon.levels.rooms.quest.vault.VaultCrossRoom;
import com.shatteredpixel.shatteredpixeldungeon.levels.rooms.quest.vault.VaultEnemyCenterRoom;
import com.shatteredpixel.shatteredpixeldungeon.levels.rooms.quest.vault.VaultEntranceRoom;
import com.shatteredpixel.shatteredpixeldungeon.levels.rooms.quest.vault.VaultFinalRoom;
import com.shatteredpixel.shatteredpixeldungeon.levels.rooms.quest.vault.VaultLongRoom;
import com.shatteredpixel.shatteredpixeldungeon.levels.rooms.quest.vault.VaultQuadrantsRoom;
import com.shatteredpixel.shatteredpixeldungeon.levels.rooms.quest.vault.VaultRingRoom;
import com.shatteredpixel.shatteredpixeldungeon.levels.rooms.quest.vault.VaultRingsRoom;
import com.shatteredpixel.shatteredpixeldungeon.levels.rooms.quest.vault.VaultSimpleEnemyTreasureRoom;
import com.watabou.utils.Random;
import java.util.ArrayList;

public class VaultLevel
extends CityLevel {
    @Override
    protected ArrayList<Room> initRooms() {
        ArrayList<Room> initRooms = new ArrayList<Room>();
        this.roomEntrance = new VaultEntranceRoom();
        initRooms.add(this.roomEntrance);
        for (int i = 0; i < 2; ++i) {
            initRooms.add(new VaultRingRoom());
            initRooms.add(new VaultCircleRoom());
            initRooms.add(new VaultCrossRoom());
            initRooms.add(new VaultQuadrantsRoom());
            initRooms.add(new VaultEnemyCenterRoom());
            initRooms.add(new VaultRingsRoom());
            initRooms.add(new VaultSimpleEnemyTreasureRoom());
        }
        initRooms.add(new VaultLongRoom());
        initRooms.add(new VaultLongRoom());
        initRooms.add(new VaultFinalRoom());
        return initRooms;
    }

    @Override
    protected Builder builder() {
        return new GridBuilder();
    }

    @Override
    protected int nTraps() {
        return 0;
    }

    @Override
    public boolean activateTransition(Hero hero, LevelTransition transition) {
        return false;
    }

    @Override
    public Mob createMob() {
        return null;
    }

    @Override
    protected void createMobs() {
    }

    @Override
    public Actor addRespawner() {
        return null;
    }

    @Override
    protected void createItems() {
        for (int i = 0; i < 20; ++i) {
            Item item = Generator.randomUsingDefaults(Random.oneOf(Generator.Category.WEAPON, Generator.Category.WEAPON, Generator.Category.WEAPON, Generator.Category.ARMOR, Generator.Category.WAND, Generator.Category.RING));
            if (item instanceof WandOfRegrowth) continue;
            if (item.cursed) {
                item.cursed = false;
                if (item instanceof MeleeWeapon && ((MeleeWeapon)item).hasCurseEnchant()) {
                    ((MeleeWeapon)item).enchant(null);
                } else if (item instanceof Armor && ((Armor)item).hasCurseGlyph()) {
                    ((Armor)item).inscribe(null);
                }
            }
            item.cursedKnown = true;
            item.levelKnown = true;
            this.addItemToSpawn(item);
        }
        for (Item item : this.itemsToSpawn) {
            int cell = this.randomDropCell();
            this.drop((Item)item, (int)cell).type = Heap.Type.HEAP;
            if (this.map[cell] != 15 && this.map[cell] != 30) continue;
            this.map[cell] = 2;
            this.losBlocking[cell] = false;
        }
    }

    @Override
    public int randomRespawnCell(Char ch) {
        return this.entrance() - this.width();
    }
}

