/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.ui.progress;

import java.util.ArrayList;
import java.util.List;
import org.protege.editor.core.ui.progress.BackgroundTask;
import org.protege.editor.core.ui.progress.BackgroundTaskListener;

public class BackgroundTaskManager {
    private List<BackgroundTaskListener> listeners = new ArrayList<BackgroundTaskListener>();
    private List<BackgroundTask> runningTasks = new ArrayList<BackgroundTask>();

    public void addBusyListener(BackgroundTaskListener listener) {
        this.listeners.add(listener);
    }

    public void removeBusyListener(BackgroundTaskListener listener) {
        this.listeners.remove(listener);
    }

    public void startTask(BackgroundTask task) {
        this.runningTasks.add(task);
        for (BackgroundTaskListener l : this.listeners) {
            l.startTask(task);
        }
    }

    public BackgroundTask startTask(final String taskName) {
        BackgroundTask t = new BackgroundTask(){
            final /* synthetic */ BackgroundTaskManager this$0;
            {
                this.this$0 = this$0;
            }

            public String toString() {
                return taskName;
            }
        };
        this.startTask(t);
        return t;
    }

    public void endTask(BackgroundTask task) {
        this.runningTasks.remove(task);
        for (BackgroundTaskListener l : this.listeners) {
            l.endTask(task);
        }
    }

    public List<BackgroundTask> getRunningTasks() {
        return new ArrayList<BackgroundTask>(this.runningTasks);
    }

    public boolean isBusy() {
        return !this.runningTasks.isEmpty();
    }
}

