"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatsAstBuilder = void 0;
var _lodash = require("lodash");
var _AbstractParseTreeVisitor = require("antlr4ts/tree/AbstractParseTreeVisitor");
var _node = require("../node");
var _aggragations = require("../tree/aggragations");
var _expression = require("../expression");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

class StatsAstBuilder extends _AbstractParseTreeVisitor.AbstractParseTreeVisitor {
  defaultResult() {
    return new _node.PPLNode('default', []);
  }
  visitRoot(ctx) {
    if (!ctx.pplStatement()) return this.defaultResult();
    return this.visitPplStatement(ctx.pplStatement());
  }
  visitPplStatement(ctx) {
    let statsTree = this.defaultResult();
    ctx.commands().map(pplCommandContext => {
      if ((0, _lodash.isFunction)(this.visitChildren(pplCommandContext).getName) && (0, _lodash.isEqual)(this.visitChildren(pplCommandContext).getName(), 'stats_command')) statsTree = this.visitChildren(pplCommandContext);
    });
    return statsTree;
  }
  visitCommands(ctx) {
    if (ctx.statsCommand()) {
      return this.visitStatsCommand(ctx.statsCommand());
    }
    return this.defaultResult();
  }

  /**
   * Stats command
   */
  visitStatsCommand(ctx) {
    var _ctx$PARTITIONS, _ctx$integerLiteral, _ctx$ALLNUM, _ctx$DELIM, _ctx$DEDUP_SPLITVALUE, _ctx$stop;
    return new _aggragations.Aggregations('stats_command', [], ctx.PARTITIONS() && ctx.integerLiteral() ? {
      keyword: (_ctx$PARTITIONS = ctx.PARTITIONS()) === null || _ctx$PARTITIONS === void 0 ? void 0 : _ctx$PARTITIONS.text,
      sign: '=',
      value: (_ctx$integerLiteral = ctx.integerLiteral()) === null || _ctx$integerLiteral === void 0 ? void 0 : _ctx$integerLiteral.text
    } : {},
    // visit partitions partial
    ctx.ALLNUM() && ctx.booleanLiteral() ? {
      keyword: (_ctx$ALLNUM = ctx.ALLNUM()) === null || _ctx$ALLNUM === void 0 ? void 0 : _ctx$ALLNUM.text,
      sign: '=',
      value: this.visitBooleanLiteral(ctx.booleanLiteral()[0])
    } : {},
    // visit allnum partial
    ctx.DELIM() && ctx.stringLiteral() ? {
      keyword: (_ctx$DELIM = ctx.DELIM()) === null || _ctx$DELIM === void 0 ? void 0 : _ctx$DELIM.text,
      sign: '=',
      value: this.visitStringLiteral(ctx.stringLiteral())
    } : '',
    // visit delim partial
    ctx.statsAggTerm().map(aggTermAlternative => this.visitStatsAggTerm(aggTermAlternative)),
    // visit statsAggTerm
    ctx.statsByClause() ? this.visitStatsByClause(ctx.statsByClause()) : {},
    // visit group list
    ctx.DEDUP_SPLITVALUES() && ctx.booleanLiteral() ? {
      keyword: (_ctx$DEDUP_SPLITVALUE = ctx.DEDUP_SPLITVALUES()) === null || _ctx$DEDUP_SPLITVALUE === void 0 ? void 0 : _ctx$DEDUP_SPLITVALUE.text,
      sign: '=',
      value: this.visitBooleanLiteral(ctx.booleanLiteral()[1])
    } : '',
    // visit dedup split value
    {
      start: ctx.start.startIndex,
      end: (_ctx$stop = ctx.stop) === null || _ctx$stop === void 0 ? void 0 : _ctx$stop.stopIndex
    } // stats start/end indices in query for later query concatenation
    );
  }

  visitIntegerLiteral(ctx) {
    return ctx.text;
  }
  visitBooleanLiteral(ctx) {
    return ctx.text;
  }
  visitStringLiteral(ctx) {
    return ctx.text;
  }
  visitStatsAggTerm(ctx) {
    return new _expression.AggregateTerm('stats_agg_term', [], this.visitStatsFunction(ctx.statsFunction()), ctx.wcFieldExpression() ? this.visitWcFieldExpression(ctx.wcFieldExpression()) : '');
  }
  visitWcFieldExpression(ctx) {
    // return only text from here to all its chilren for now
    return ctx.wcQualifiedName().text;
  }
  visitStatsByClause(ctx) {
    return new _expression.GroupBy('stats_by_clause', [], ctx.fieldList() ? this.visitFieldList(ctx.fieldList()) : [], ctx.bySpanClause() ? this.visitBySpanClause(ctx.bySpanClause()) : this.defaultResult());
  }
  visitBySpanClause(ctx) {
    return new _expression.Span('span_clause', [], this.visitSpanClause(ctx.spanClause()), ctx.qualifiedName() ? this.visitQualifiedName(ctx.qualifiedName()) : '');
  }
  visitSpanClause(ctx) {
    return new _expression.SpanExpression('span_expression', [], this.visitFieldExpression(ctx.fieldExpression()), this.visitLiteralValue(ctx.literalValue()), ctx.timespanUnit() ? this.visitTimespanUnit(ctx.timespanUnit()) : '');
  }
  visitLiteralValue(ctx) {
    return ctx.text;
  }
  visitTimespanUnit(ctx) {
    return ctx.text;
  }
  visitStatsFunction(ctx) {
    let funcName = '';
    let valueExpr = '';
    if ((0, _lodash.isFunction)(ctx.valueExpression)) {
      valueExpr = this.visitValueExpression(ctx.valueExpression());
      if ((0, _lodash.isFunction)(ctx.statsFunctionName)) {
        funcName = this.visitStatsFunctionName(ctx.statsFunctionName());
      } else {
        funcName = ctx.DISTINCT_COUNT() ? ctx.DISTINCT_COUNT().text : ctx.DC().text;
      }
    } else if ((0, _lodash.isFunction)(ctx.percentileAggFunction)) {
      // for now just return plain text
    } else if ((0, _lodash.isFunction)(ctx.COUNT)) {
      funcName = ctx.COUNT().text;
    }
    return new _expression.AggregateFunction('stats_function', [], funcName, valueExpr, (0, _lodash.isFunction)(ctx.percentileAggFunction) ? ctx.text : '');
  }
  visitValueExpression(ctx) {
    return ctx.text;
  }
  visitStatsFunctionName(ctx) {
    return ctx.text;
  }
  visitFieldList(ctx) {
    return ctx.fieldExpression().map(fieldExprAlternative => {
      return new _expression.Field('field_expression', [], this.visitFieldExpression(fieldExprAlternative));
    });
  }
  visitFieldExpression(ctx) {
    return this.visitQualifiedName(ctx.qualifiedName());
  }
  visitQualifiedName(ctx) {
    return ctx.text;
  }
}
exports.StatsAstBuilder = StatsAstBuilder;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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