/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_ar extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "\u0627\u0644\u0639\u0631\u0628\u064a\u0629";
        final String metaValue_pi = "\u0627\u0644\u0628\u0627\u0644\u064a\u0629";
        final String metaValue_bn = "\u0627\u0644\u0628\u0646\u063a\u0627\u0644\u064a\u0629";
        final String metaValue_chr = "\u0627\u0644\u0634\u064a\u0631\u0648\u0643\u064a";
        final String metaValue_cop = "\u0627\u0644\u0642\u0628\u0637\u064a\u0629";
        final String metaValue_ka = "\u0627\u0644\u062c\u0648\u0631\u062c\u064a\u0629";
        final String metaValue_got = "\u0627\u0644\u0642\u0648\u0637\u064a\u0629";
        final String metaValue_el = "\u0627\u0644\u064a\u0648\u0646\u0627\u0646\u064a\u0629";
        final String metaValue_he = "\u0627\u0644\u0639\u0628\u0631\u064a\u0629";
        final String metaValue_jv = "\u0627\u0644\u062c\u0627\u0648\u064a\u0629";
        final String metaValue_ja = "\u0627\u0644\u064a\u0627\u0628\u0627\u0646\u064a\u0629";
        final String metaValue_km = "\u0627\u0644\u062e\u0645\u064a\u0631\u064a\u0629";
        final String metaValue_kn = "\u0627\u0644\u0643\u0627\u0646\u0627\u062f\u0627";
        final String metaValue_ko = "\u0627\u0644\u0643\u0648\u0631\u064a\u0629";
        final String metaValue_la = "\u0627\u0644\u0644\u0627\u062a\u064a\u0646\u064a\u0629";
        final String metaValue_nqo = "\u0623\u0646\u0643\u0648";
        final String metaValue_phn = "\u0627\u0644\u0641\u064a\u0646\u064a\u0642\u064a\u0629";
        final String metaValue_su = "\u0627\u0644\u0633\u0648\u0646\u062f\u0627\u0646\u064a\u0629";
        final String metaValue_syr = "\u0627\u0644\u0633\u0631\u064a\u0627\u0646\u064a\u0629";
        final String metaValue_ta = "\u0627\u0644\u062a\u0627\u0645\u064a\u0644\u064a\u0629";
        final String metaValue_th = "\u0627\u0644\u062a\u0627\u064a\u0644\u0627\u0646\u062f\u064a\u0629";
        final String metaValue_bo = "\u0627\u0644\u062a\u0628\u062a\u064a\u0629";
        final String metaValue_vai = "\u0627\u0644\u0641\u0627\u064a";
        final String metaValue_peo = "\u0627\u0644\u0641\u0627\u0631\u0633\u064a\u0629 \u0627\u0644\u0642\u062f\u064a\u0645\u0629";
        final Object[][] data = new Object[][] {
            { "001", "\u0627\u0644\u0639\u0627\u0644\u0645" },
            { "002", "\u0623\u0641\u0631\u064a\u0642\u064a\u0627" },
            { "003", "\u0623\u0645\u0631\u064a\u0643\u0627 \u0627\u0644\u0634\u0645\u0627\u0644\u064a\u0629" },
            { "005", "\u0623\u0645\u0631\u064a\u0643\u0627 \u0627\u0644\u062c\u0646\u0648\u0628\u064a\u0629" },
            { "009", "\u0623\u0648\u0642\u064a\u0627\u0646\u0648\u0633\u064a\u0627" },
            { "011", "\u063a\u0631\u0628 \u0623\u0641\u0631\u064a\u0642\u064a\u0627" },
            { "013", "\u0623\u0645\u0631\u064a\u0643\u0627 \u0627\u0644\u0648\u0633\u0637\u0649" },
            { "014", "\u0634\u0631\u0642 \u0623\u0641\u0631\u064a\u0642\u064a\u0627" },
            { "015", "\u0634\u0645\u0627\u0644 \u0623\u0641\u0631\u064a\u0642\u064a\u0627" },
            { "017", "\u0648\u0633\u0637 \u0623\u0641\u0631\u064a\u0642\u064a\u0627" },
            { "018", "\u0623\u0641\u0631\u064a\u0642\u064a\u0627 \u0627\u0644\u062c\u0646\u0648\u0628\u064a\u0629" },
            { "019", "\u0627\u0644\u0623\u0645\u0631\u064a\u0643\u062a\u0627\u0646" },
            { "021", "\u0634\u0645\u0627\u0644 \u0623\u0645\u0631\u064a\u0643\u0627" },
            { "029", "\u0627\u0644\u0643\u0627\u0631\u064a\u0628\u064a" },
            { "030", "\u0634\u0631\u0642 \u0622\u0633\u064a\u0627" },
            { "034", "\u062c\u0646\u0648\u0628 \u0622\u0633\u064a\u0627" },
            { "035", "\u062c\u0646\u0648\u0628 \u0634\u0631\u0642 \u0622\u0633\u064a\u0627" },
            { "039", "\u062c\u0646\u0648\u0628 \u0623\u0648\u0631\u0648\u0628\u0627" },
            { "053", "\u0623\u0633\u062a\u0631\u0627\u0644\u0627\u0633\u064a\u0627" },
            { "054", "\u0645\u064a\u0644\u0627\u0646\u064a\u0632\u064a\u0627" },
            { "057", "\u0627\u0644\u062c\u0632\u0631 \u0627\u0644\u0645\u064a\u0643\u0631\u0648\u0646\u064a\u0632\u064a\u0629" },
            { "061", "\u0628\u0648\u0644\u064a\u0646\u064a\u0632\u064a\u0627" },
            { "142", "\u0622\u0633\u064a\u0627" },
            { "143", "\u0648\u0633\u0637 \u0622\u0633\u064a\u0627" },
            { "145", "\u063a\u0631\u0628 \u0622\u0633\u064a\u0627" },
            { "150", "\u0623\u0648\u0631\u0648\u0628\u0627" },
            { "151", "\u0634\u0631\u0642 \u0623\u0648\u0631\u0648\u0628\u0627" },
            { "154", "\u0634\u0645\u0627\u0644 \u0623\u0648\u0631\u0648\u0628\u0627" },
            { "155", "\u063a\u0631\u0628 \u0623\u0648\u0631\u0648\u0628\u0627" },
            { "202", "\u0623\u0641\u0631\u064a\u0642\u064a\u0627 \u062c\u0646\u0648\u0628 \u0627\u0644\u0635\u062d\u0631\u0627\u0621 \u0627\u0644\u0643\u0628\u0631\u0649" },
            { "419", "\u0623\u0645\u0631\u064a\u0643\u0627 \u0627\u0644\u0644\u0627\u062a\u064a\u0646\u064a\u0629" },
            { "AC", "\u062c\u0632\u064a\u0631\u0629 \u0623\u0633\u064a\u0646\u0634\u064a\u0648\u0646" },
            { "AD", "\u0623\u0646\u062f\u0648\u0631\u0627" },
            { "AE", "\u0627\u0644\u0625\u0645\u0627\u0631\u0627\u062a \u0627\u0644\u0639\u0631\u0628\u064a\u0629 \u0627\u0644\u0645\u062a\u062d\u062f\u0629" },
            { "AF", "\u0623\u0641\u063a\u0627\u0646\u0633\u062a\u0627\u0646" },
            { "AG", "\u0623\u0646\u062a\u064a\u063a\u0648\u0627 \u0648\u0628\u0631\u0628\u0648\u062f\u0627" },
            { "AI", "\u0623\u0646\u063a\u0648\u064a\u0644\u0627" },
            { "AL", "\u0623\u0644\u0628\u0627\u0646\u064a\u0627" },
            { "AM", "\u0623\u0631\u0645\u064a\u0646\u064a\u0627" },
            { "AO", "\u0623\u0646\u063a\u0648\u0644\u0627" },
            { "AQ", "\u0623\u0646\u062a\u0627\u0631\u0643\u062a\u064a\u0643\u0627" },
            { "AR", "\u0627\u0644\u0623\u0631\u062c\u0646\u062a\u064a\u0646" },
            { "AS", "\u0633\u0627\u0645\u0648\u0627 \u0627\u0644\u0623\u0645\u0631\u064a\u0643\u064a\u0629" },
            { "AT", "\u0627\u0644\u0646\u0645\u0633\u0627" },
            { "AU", "\u0623\u0633\u062a\u0631\u0627\u0644\u064a\u0627" },
            { "AW", "\u0623\u0631\u0648\u0628\u0627" },
            { "AX", "\u062c\u0632\u0631 \u0622\u0644\u0627\u0646\u062f" },
            { "AZ", "\u0623\u0630\u0631\u0628\u064a\u062c\u0627\u0646" },
            { "BA", "\u0627\u0644\u0628\u0648\u0633\u0646\u0629 \u0648\u0627\u0644\u0647\u0631\u0633\u0643" },
            { "BB", "\u0628\u0631\u0628\u0627\u062f\u0648\u0633" },
            { "BD", "\u0628\u0646\u063a\u0644\u0627\u062f\u064a\u0634" },
            { "BE", "\u0628\u0644\u062c\u064a\u0643\u0627" },
            { "BF", "\u0628\u0648\u0631\u0643\u064a\u0646\u0627 \u0641\u0627\u0633\u0648" },
            { "BG", "\u0628\u0644\u063a\u0627\u0631\u064a\u0627" },
            { "BH", "\u0627\u0644\u0628\u062d\u0631\u064a\u0646" },
            { "BI", "\u0628\u0648\u0631\u0648\u0646\u062f\u064a" },
            { "BJ", "\u0628\u0646\u064a\u0646" },
            { "BL", "\u0633\u0627\u0646 \u0628\u0627\u0631\u062a\u0644\u064a\u0645\u064a" },
            { "BM", "\u0628\u0631\u0645\u0648\u062f\u0627" },
            { "BN", "\u0628\u0631\u0648\u0646\u0627\u064a" },
            { "BO", "\u0628\u0648\u0644\u064a\u0641\u064a\u0627" },
            { "BQ", "\u0647\u0648\u0644\u0646\u062f\u0627 \u0627\u0644\u0643\u0627\u0631\u064a\u0628\u064a\u0629" },
            { "BR", "\u0627\u0644\u0628\u0631\u0627\u0632\u064a\u0644" },
            { "BS", "\u062c\u0632\u0631 \u0627\u0644\u0628\u0647\u0627\u0645\u0627" },
            { "BT", "\u0628\u0648\u062a\u0627\u0646" },
            { "BV", "\u062c\u0632\u064a\u0631\u0629 \u0628\u0648\u0641\u064a\u0647" },
            { "BW", "\u0628\u0648\u062a\u0633\u0648\u0627\u0646\u0627" },
            { "BY", "\u0628\u064a\u0644\u0627\u0631\u0648\u0633" },
            { "BZ", "\u0628\u0644\u064a\u0632" },
            { "CA", "\u0643\u0646\u062f\u0627" },
            { "CC", "\u062c\u0632\u0631 \u0643\u0648\u0643\u0648\u0633 (\u0643\u064a\u0644\u064a\u0646\u063a)" },
            { "CD", "\u0627\u0644\u0643\u0648\u0646\u063a\u0648 - \u0643\u064a\u0646\u0634\u0627\u0633\u0627" },
            { "CF", "\u062c\u0645\u0647\u0648\u0631\u064a\u0629 \u0623\u0641\u0631\u064a\u0642\u064a\u0627 \u0627\u0644\u0648\u0633\u0637\u0649" },
            { "CG", "\u0627\u0644\u0643\u0648\u0646\u063a\u0648 - \u0628\u0631\u0627\u0632\u0627\u0641\u064a\u0644" },
            { "CH", "\u0633\u0648\u064a\u0633\u0631\u0627" },
            { "CI", "\u0633\u0627\u062d\u0644 \u0627\u0644\u0639\u0627\u062c" },
            { "CK", "\u062c\u0632\u0631 \u0643\u0648\u0643" },
            { "CL", "\u062a\u0634\u064a\u0644\u064a" },
            { "CM", "\u0627\u0644\u0643\u0627\u0645\u064a\u0631\u0648\u0646" },
            { "CN", "\u0627\u0644\u0635\u064a\u0646" },
            { "CO", "\u0643\u0648\u0644\u0648\u0645\u0628\u064a\u0627" },
            { "CP", "\u062c\u0632\u064a\u0631\u0629 \u0643\u0644\u064a\u0628\u064a\u0631\u062a\u0648\u0646" },
            { "CR", "\u0643\u0648\u0633\u062a\u0627\u0631\u064a\u0643\u0627" },
            { "CU", "\u0643\u0648\u0628\u0627" },
            { "CV", "\u0627\u0644\u0631\u0623\u0633 \u0627\u0644\u0623\u062e\u0636\u0631" },
            { "CW", "\u0643\u0648\u0631\u0627\u0633\u0627\u0648" },
            { "CX", "\u062c\u0632\u064a\u0631\u0629 \u0643\u0631\u064a\u0633\u0645\u0627\u0633" },
            { "CY", "\u0642\u0628\u0631\u0635" },
            { "CZ", "\u0627\u0644\u062a\u0634\u064a\u0643" },
            { "DE", "\u0623\u0644\u0645\u0627\u0646\u064a\u0627" },
            { "DG", "\u062f\u064a\u064a\u063a\u0648 \u063a\u0627\u0631\u0633\u064a\u0627" },
            { "DJ", "\u062c\u064a\u0628\u0648\u062a\u064a" },
            { "DK", "\u0627\u0644\u062f\u0627\u0646\u0645\u0631\u0643" },
            { "DM", "\u062f\u0648\u0645\u064a\u0646\u064a\u0643\u0627" },
            { "DO", "\u062c\u0645\u0647\u0648\u0631\u064a\u0629 \u0627\u0644\u062f\u0648\u0645\u064a\u0646\u064a\u0643\u0627\u0646" },
            { "DZ", "\u0627\u0644\u062c\u0632\u0627\u0626\u0631" },
            { "EA", "\u0633\u064a\u0648\u062a\u0627 \u0648\u0645\u064a\u0644\u064a\u0644\u0627" },
            { "EC", "\u0627\u0644\u0625\u0643\u0648\u0627\u062f\u0648\u0631" },
            { "EE", "\u0625\u0633\u062a\u0648\u0646\u064a\u0627" },
            { "EG", "\u0645\u0635\u0631" },
            { "EH", "\u0627\u0644\u0635\u062d\u0631\u0627\u0621 \u0627\u0644\u063a\u0631\u0628\u064a\u0629" },
            { "ER", "\u0625\u0631\u064a\u062a\u0631\u064a\u0627" },
            { "ES", "\u0625\u0633\u0628\u0627\u0646\u064a\u0627" },
            { "ET", "\u0625\u062b\u064a\u0648\u0628\u064a\u0627" },
            { "EU", "\u0627\u0644\u0627\u062a\u062d\u0627\u062f \u0627\u0644\u0623\u0648\u0631\u0648\u0628\u064a" },
            { "EZ", "\u0645\u0646\u0637\u0642\u0629 \u0627\u0644\u064a\u0648\u0631\u0648" },
            { "FI", "\u0641\u0646\u0644\u0646\u062f\u0627" },
            { "FJ", "\u0641\u064a\u062c\u064a" },
            { "FK", "\u062c\u0632\u0631 \u0641\u0648\u0643\u0644\u0627\u0646\u062f" },
            { "FM", "\u0645\u064a\u0643\u0631\u0648\u0646\u064a\u0632\u064a\u0627" },
            { "FO", "\u062c\u0632\u0631 \u0641\u0627\u0631\u0648" },
            { "FR", "\u0641\u0631\u0646\u0633\u0627" },
            { "GA", "\u0627\u0644\u063a\u0627\u0628\u0648\u0646" },
            { "GB", "\u0627\u0644\u0645\u0645\u0644\u0643\u0629 \u0627\u0644\u0645\u062a\u062d\u062f\u0629" },
            { "GD", "\u063a\u0631\u064a\u0646\u0627\u062f\u0627" },
            { "GE", "\u062c\u0648\u0631\u062c\u064a\u0627" },
            { "GF", "\u063a\u0648\u064a\u0627\u0646\u0627 \u0627\u0644\u0641\u0631\u0646\u0633\u064a\u0629" },
            { "GG", "\u063a\u064a\u0631\u0646\u0632\u064a" },
            { "GH", "\u063a\u0627\u0646\u0627" },
            { "GI", "\u062c\u0628\u0644 \u0637\u0627\u0631\u0642" },
            { "GL", "\u063a\u0631\u064a\u0646\u0644\u0627\u0646\u062f" },
            { "GM", "\u063a\u0627\u0645\u0628\u064a\u0627" },
            { "GN", "\u063a\u064a\u0646\u064a\u0627" },
            { "GP", "\u063a\u0648\u0627\u062f\u0644\u0648\u0628" },
            { "GQ", "\u063a\u064a\u0646\u064a\u0627 \u0627\u0644\u0627\u0633\u062a\u0648\u0627\u0626\u064a\u0629" },
            { "GR", "\u0627\u0644\u064a\u0648\u0646\u0627\u0646" },
            { "GS", "\u062c\u0648\u0631\u062c\u064a\u0627 \u0627\u0644\u062c\u0646\u0648\u0628\u064a\u0629 \u0648\u062c\u0632\u0631 \u0633\u0627\u0646\u062f\u0648\u064a\u062a\u0634 \u0627\u0644\u062c\u0646\u0648\u0628\u064a\u0629" },
            { "GT", "\u063a\u0648\u0627\u062a\u064a\u0645\u0627\u0644\u0627" },
            { "GU", "\u063a\u0648\u0627\u0645" },
            { "GW", "\u063a\u064a\u0646\u064a\u0627 \u0628\u064a\u0633\u0627\u0648" },
            { "GY", "\u063a\u064a\u0627\u0646\u0627" },
            { "HK", "\u0647\u0648\u0646\u063a \u0643\u0648\u0646\u063a \u0627\u0644\u0635\u064a\u0646\u064a\u0629 (\u0645\u0646\u0637\u0642\u0629 \u0625\u062f\u0627\u0631\u064a\u0629 \u062e\u0627\u0635\u0629)" },
            { "HM", "\u062c\u0632\u064a\u0631\u0629 \u0647\u064a\u0631\u062f \u0648\u062c\u0632\u0631 \u0645\u0627\u0643\u062f\u0648\u0646\u0627\u0644\u062f" },
            { "HN", "\u0647\u0646\u062f\u0648\u0631\u0627\u0633" },
            { "HR", "\u0643\u0631\u0648\u0627\u062a\u064a\u0627" },
            { "HT", "\u0647\u0627\u064a\u062a\u064a" },
            { "HU", "\u0647\u0646\u063a\u0627\u0631\u064a\u0627" },
            { "IC", "\u062c\u0632\u0631 \u0627\u0644\u0643\u0646\u0627\u0631\u064a" },
            { "ID", "\u0625\u0646\u062f\u0648\u0646\u064a\u0633\u064a\u0627" },
            { "IE", "\u0623\u064a\u0631\u0644\u0646\u062f\u0627" },
            { "IL", "\u0625\u0633\u0631\u0627\u0626\u064a\u0644" },
            { "IM", "\u062c\u0632\u064a\u0631\u0629 \u0645\u0627\u0646" },
            { "IN", "\u0627\u0644\u0647\u0646\u062f" },
            { "IO", "\u0627\u0644\u0625\u0642\u0644\u064a\u0645 \u0627\u0644\u0628\u0631\u064a\u0637\u0627\u0646\u064a \u0641\u064a \u0627\u0644\u0645\u062d\u064a\u0637 \u0627\u0644\u0647\u0646\u062f\u064a" },
            { "IQ", "\u0627\u0644\u0639\u0631\u0627\u0642" },
            { "IR", "\u0625\u064a\u0631\u0627\u0646" },
            { "IS", "\u0622\u064a\u0633\u0644\u0646\u062f\u0627" },
            { "IT", "\u0625\u064a\u0637\u0627\u0644\u064a\u0627" },
            { "JE", "\u062c\u064a\u0631\u0633\u064a" },
            { "JM", "\u062c\u0627\u0645\u0627\u064a\u0643\u0627" },
            { "JO", "\u0627\u0644\u0623\u0631\u062f\u0646" },
            { "JP", "\u0627\u0644\u064a\u0627\u0628\u0627\u0646" },
            { "KE", "\u0643\u064a\u0646\u064a\u0627" },
            { "KG", "\u0642\u064a\u0631\u063a\u064a\u0632\u0633\u062a\u0627\u0646" },
            { "KH", "\u0643\u0645\u0628\u0648\u062f\u064a\u0627" },
            { "KI", "\u0643\u064a\u0631\u064a\u0628\u0627\u062a\u064a" },
            { "KM", "\u062c\u0632\u0631 \u0627\u0644\u0642\u0645\u0631" },
            { "KN", "\u0633\u0627\u0646\u062a \u0643\u064a\u062a\u0633 \u0648\u0646\u064a\u0641\u064a\u0633" },
            { "KP", "\u0643\u0648\u0631\u064a\u0627 \u0627\u0644\u0634\u0645\u0627\u0644\u064a\u0629" },
            { "KR", "\u0643\u0648\u0631\u064a\u0627 \u0627\u0644\u062c\u0646\u0648\u0628\u064a\u0629" },
            { "KW", "\u0627\u0644\u0643\u0648\u064a\u062a" },
            { "KY", "\u062c\u0632\u0631 \u0643\u0627\u064a\u0645\u0627\u0646" },
            { "KZ", "\u0643\u0627\u0632\u0627\u062e\u0633\u062a\u0627\u0646" },
            { "LA", "\u0644\u0627\u0648\u0633" },
            { "LB", "\u0644\u0628\u0646\u0627\u0646" },
            { "LC", "\u0633\u0627\u0646\u062a \u0644\u0648\u0633\u064a\u0627" },
            { "LI", "\u0644\u064a\u062e\u062a\u0646\u0634\u062a\u0627\u064a\u0646" },
            { "LK", "\u0633\u0631\u064a\u0644\u0627\u0646\u0643\u0627" },
            { "LR", "\u0644\u064a\u0628\u064a\u0631\u064a\u0627" },
            { "LS", "\u0644\u064a\u0633\u0648\u062a\u0648" },
            { "LT", "\u0644\u064a\u062a\u0648\u0627\u0646\u064a\u0627" },
            { "LU", "\u0644\u0648\u0643\u0633\u0645\u0628\u0648\u0631\u063a" },
            { "LV", "\u0644\u0627\u062a\u0641\u064a\u0627" },
            { "LY", "\u0644\u064a\u0628\u064a\u0627" },
            { "MA", "\u0627\u0644\u0645\u063a\u0631\u0628" },
            { "MC", "\u0645\u0648\u0646\u0627\u0643\u0648" },
            { "MD", "\u0645\u0648\u0644\u062f\u0648\u0641\u0627" },
            { "ME", "\u0627\u0644\u062c\u0628\u0644 \u0627\u0644\u0623\u0633\u0648\u062f" },
            { "MF", "\u0633\u0627\u0646 \u0645\u0627\u0631\u062a\u0646" },
            { "MG", "\u0645\u062f\u063a\u0634\u0642\u0631" },
            { "MH", "\u062c\u0632\u0631 \u0645\u0627\u0631\u0634\u0627\u0644" },
            { "MK", "\u0645\u0642\u062f\u0648\u0646\u064a\u0627 \u0627\u0644\u0634\u0645\u0627\u0644\u064a\u0629" },
            { "ML", "\u0645\u0627\u0644\u064a" },
            { "MM", "\u0645\u064a\u0627\u0646\u0645\u0627\u0631 (\u0628\u0648\u0631\u0645\u0627)" },
            { "MN", "\u0645\u0646\u063a\u0648\u0644\u064a\u0627" },
            { "MO", "\u0645\u0646\u0637\u0642\u0629 \u0645\u0627\u0643\u0627\u0648 \u0627\u0644\u0625\u062f\u0627\u0631\u064a\u0629 \u0627\u0644\u062e\u0627\u0635\u0629" },
            { "MP", "\u062c\u0632\u0631 \u0645\u0627\u0631\u064a\u0627\u0646\u0627 \u0627\u0644\u0634\u0645\u0627\u0644\u064a\u0629" },
            { "MQ", "\u062c\u0632\u0631 \u0627\u0644\u0645\u0627\u0631\u062a\u064a\u0646\u064a\u0643" },
            { "MR", "\u0645\u0648\u0631\u064a\u062a\u0627\u0646\u064a\u0627" },
            { "MS", "\u0645\u0648\u0646\u062a\u0633\u0631\u0627\u062a" },
            { "MT", "\u0645\u0627\u0644\u0637\u0627" },
            { "MU", "\u0645\u0648\u0631\u064a\u0634\u064a\u0648\u0633" },
            { "MV", "\u062c\u0632\u0631 \u0627\u0644\u0645\u0627\u0644\u062f\u064a\u0641" },
            { "MW", "\u0645\u0644\u0627\u0648\u064a" },
            { "MX", "\u0627\u0644\u0645\u0643\u0633\u064a\u0643" },
            { "MY", "\u0645\u0627\u0644\u064a\u0632\u064a\u0627" },
            { "MZ", "\u0645\u0648\u0632\u0645\u0628\u064a\u0642" },
            { "NA", "\u0646\u0627\u0645\u064a\u0628\u064a\u0627" },
            { "NC", "\u0643\u0627\u0644\u064a\u062f\u0648\u0646\u064a\u0627 \u0627\u0644\u062c\u062f\u064a\u062f\u0629" },
            { "NE", "\u0627\u0644\u0646\u064a\u062c\u0631" },
            { "NF", "\u062c\u0632\u064a\u0631\u0629 \u0646\u0648\u0631\u0641\u0648\u0644\u0643" },
            { "NG", "\u0646\u064a\u062c\u064a\u0631\u064a\u0627" },
            { "NI", "\u0646\u064a\u0643\u0627\u0631\u0627\u063a\u0648\u0627" },
            { "NL", "\u0647\u0648\u0644\u0646\u062f\u0627" },
            { "NO", "\u0627\u0644\u0646\u0631\u0648\u064a\u062c" },
            { "NP", "\u0646\u064a\u0628\u0627\u0644" },
            { "NR", "\u0646\u0627\u0648\u0631\u0648" },
            { "NU", "\u0646\u064a\u0648\u064a" },
            { "NZ", "\u0646\u064a\u0648\u0632\u064a\u0644\u0646\u062f\u0627" },
            { "OM", "\u0639\u064f\u0645\u0627\u0646" },
            { "PA", "\u0628\u0646\u0645\u0627" },
            { "PE", "\u0628\u064a\u0631\u0648" },
            { "PF", "\u0628\u0648\u0644\u064a\u0646\u064a\u0632\u064a\u0627 \u0627\u0644\u0641\u0631\u0646\u0633\u064a\u0629" },
            { "PG", "\u0628\u0627\u0628\u0648\u0627 \u063a\u064a\u0646\u064a\u0627 \u0627\u0644\u062c\u062f\u064a\u062f\u0629" },
            { "PH", "\u0627\u0644\u0641\u0644\u0628\u064a\u0646" },
            { "PK", "\u0628\u0627\u0643\u0633\u062a\u0627\u0646" },
            { "PL", "\u0628\u0648\u0644\u0646\u062f\u0627" },
            { "PM", "\u0633\u0627\u0646 \u0628\u064a\u064a\u0631 \u0648\u0645\u0643\u0648\u064a\u0644\u0648\u0646" },
            { "PN", "\u062c\u0632\u0631 \u0628\u064a\u062a\u0643\u064a\u0631\u0646" },
            { "PR", "\u0628\u0648\u0631\u062a\u0648\u0631\u064a\u0643\u0648" },
            { "PS", "\u0627\u0644\u0623\u0631\u0627\u0636\u064a \u0627\u0644\u0641\u0644\u0633\u0637\u064a\u0646\u064a\u0629" },
            { "PT", "\u0627\u0644\u0628\u0631\u062a\u063a\u0627\u0644" },
            { "PW", "\u0628\u0627\u0644\u0627\u0648" },
            { "PY", "\u0628\u0627\u0631\u0627\u063a\u0648\u0627\u064a" },
            { "QA", "\u0642\u0637\u0631" },
            { "QO", "\u0623\u0648\u0642\u064a\u0627\u0646\u0648\u0633\u064a\u0627 \u0627\u0644\u0646\u0627\u0626\u064a\u0629" },
            { "RE", "\u0631\u0648\u064a\u0646\u064a\u0648\u0646" },
            { "RO", "\u0631\u0648\u0645\u0627\u0646\u064a\u0627" },
            { "RS", "\u0635\u0631\u0628\u064a\u0627" },
            { "RU", "\u0631\u0648\u0633\u064a\u0627" },
            { "RW", "\u0631\u0648\u0627\u0646\u062f\u0627" },
            { "SA", "\u0627\u0644\u0645\u0645\u0644\u0643\u0629 \u0627\u0644\u0639\u0631\u0628\u064a\u0629 \u0627\u0644\u0633\u0639\u0648\u062f\u064a\u0629" },
            { "SB", "\u062c\u0632\u0631 \u0633\u0644\u064a\u0645\u0627\u0646" },
            { "SC", "\u0633\u064a\u0634\u0644" },
            { "SD", "\u0627\u0644\u0633\u0648\u062f\u0627\u0646" },
            { "SE", "\u0627\u0644\u0633\u0648\u064a\u062f" },
            { "SG", "\u0633\u0646\u063a\u0627\u0641\u0648\u0631\u0629" },
            { "SH", "\u0633\u0627\u0646\u062a \u0647\u064a\u0644\u064a\u0646\u0627" },
            { "SI", "\u0633\u0644\u0648\u0641\u064a\u0646\u064a\u0627" },
            { "SJ", "\u0633\u0641\u0627\u0644\u0628\u0627\u0631\u062f \u0648\u062c\u0627\u0646 \u0645\u0627\u064a\u0646" },
            { "SK", "\u0633\u0644\u0648\u0641\u0627\u0643\u064a\u0627" },
            { "SL", "\u0633\u064a\u0631\u0627\u0644\u064a\u0648\u0646" },
            { "SM", "\u0633\u0627\u0646 \u0645\u0627\u0631\u064a\u0646\u0648" },
            { "SN", "\u0627\u0644\u0633\u0646\u063a\u0627\u0644" },
            { "SO", "\u0627\u0644\u0635\u0648\u0645\u0627\u0644" },
            { "SR", "\u0633\u0648\u0631\u064a\u0646\u0627\u0645" },
            { "SS", "\u062c\u0646\u0648\u0628 \u0627\u0644\u0633\u0648\u062f\u0627\u0646" },
            { "ST", "\u0633\u0627\u0648 \u062a\u0648\u0645\u064a \u0648\u0628\u0631\u064a\u0646\u0633\u064a\u0628\u064a" },
            { "SV", "\u0627\u0644\u0633\u0644\u0641\u0627\u062f\u0648\u0631" },
            { "SX", "\u0633\u0627\u0646\u062a \u0645\u0627\u0631\u062a\u0646" },
            { "SY", "\u0633\u0648\u0631\u064a\u0627" },
            { "SZ", "\u0625\u0633\u0648\u0627\u062a\u064a\u0646\u064a" },
            { "TA", "\u062a\u0631\u064a\u0633\u062a\u0627\u0646 \u062f\u0627 \u0643\u0648\u0646\u0627" },
            { "TC", "\u062c\u0632\u0631 \u062a\u0648\u0631\u0643\u0633 \u0648\u0643\u0627\u064a\u0643\u0648\u0633" },
            { "TD", "\u062a\u0634\u0627\u062f" },
            { "TF", "\u0627\u0644\u0623\u0642\u0627\u0644\u064a\u0645 \u0627\u0644\u062c\u0646\u0648\u0628\u064a\u0629 \u0627\u0644\u0641\u0631\u0646\u0633\u064a\u0629" },
            { "TG", "\u062a\u0648\u063a\u0648" },
            { "TH", "\u062a\u0627\u064a\u0644\u0627\u0646\u062f" },
            { "TJ", "\u0637\u0627\u062c\u064a\u0643\u0633\u062a\u0627\u0646" },
            { "TK", "\u062a\u0648\u0643\u064a\u0644\u0648" },
            { "TL", "\u062a\u064a\u0645\u0648\u0631 - \u0644\u064a\u0634\u062a\u064a" },
            { "TM", "\u062a\u0631\u0643\u0645\u0627\u0646\u0633\u062a\u0627\u0646" },
            { "TN", "\u062a\u0648\u0646\u0633" },
            { "TO", "\u062a\u0648\u0646\u063a\u0627" },
            { "TR", "\u062a\u0631\u0643\u064a\u0627" },
            { "TT", "\u062a\u0631\u064a\u0646\u064a\u062f\u0627\u062f \u0648\u062a\u0648\u0628\u0627\u063a\u0648" },
            { "TV", "\u062a\u0648\u0641\u0627\u0644\u0648" },
            { "TW", "\u062a\u0627\u064a\u0648\u0627\u0646" },
            { "TZ", "\u062a\u0646\u0632\u0627\u0646\u064a\u0627" },
            { "UA", "\u0623\u0648\u0643\u0631\u0627\u0646\u064a\u0627" },
            { "UG", "\u0623\u0648\u063a\u0646\u062f\u0627" },
            { "UM", "\u062c\u0632\u0631 \u0627\u0644\u0648\u0644\u0627\u064a\u0627\u062a \u0627\u0644\u0645\u062a\u062d\u062f\u0629 \u0627\u0644\u0646\u0627\u0626\u064a\u0629" },
            { "UN", "\u0627\u0644\u0623\u0645\u0645 \u0627\u0644\u0645\u062a\u062d\u062f\u0629" },
            { "US", "\u0627\u0644\u0648\u0644\u0627\u064a\u0627\u062a \u0627\u0644\u0645\u062a\u062d\u062f\u0629" },
            { "UY", "\u0623\u0648\u0631\u063a\u0648\u0627\u064a" },
            { "UZ", "\u0623\u0648\u0632\u0628\u0643\u0633\u062a\u0627\u0646" },
            { "VA", "\u0627\u0644\u0641\u0627\u062a\u064a\u0643\u0627\u0646" },
            { "VC", "\u0633\u0627\u0646\u062a \u0641\u0646\u0633\u0646\u062a \u0648\u062c\u0632\u0631 \u063a\u0631\u064a\u0646\u0627\u062f\u064a\u0646" },
            { "VE", "\u0641\u0646\u0632\u0648\u064a\u0644\u0627" },
            { "VG", "\u062c\u0632\u0631 \u0641\u064a\u0631\u062c\u0646 \u0627\u0644\u0628\u0631\u064a\u0637\u0627\u0646\u064a\u0629" },
            { "VI", "\u062c\u0632\u0631 \u0641\u064a\u0631\u062c\u0646 \u0627\u0644\u062a\u0627\u0628\u0639\u0629 \u0644\u0644\u0648\u0644\u0627\u064a\u0627\u062a \u0627\u0644\u0645\u062a\u062d\u062f\u0629" },
            { "VN", "\u0641\u064a\u062a\u0646\u0627\u0645" },
            { "VU", "\u0641\u0627\u0646\u0648\u0627\u062a\u0648" },
            { "WF", "\u062c\u0632\u0631 \u0648\u0627\u0644\u0633 \u0648\u0641\u0648\u062a\u0648\u0646\u0627" },
            { "WS", "\u0633\u0627\u0645\u0648\u0627" },
            { "XA", "\u0644\u0643\u0646\u0627\u062a \u062a\u062c\u0631\u064a\u0628\u064a\u0629 \u063a\u064a\u0631 \u0623\u0635\u0644\u064a\u0629" },
            { "XB", "\u0644\u0643\u0646\u0627\u062a \u062a\u062c\u0631\u064a\u0628\u064a\u0629 \u062b\u0646\u0627\u0626\u064a\u0629 \u0627\u0644\u0627\u062a\u062c\u0627\u0647" },
            { "XK", "\u0643\u0648\u0633\u0648\u0641\u0648" },
            { "YE", "\u0627\u0644\u064a\u0645\u0646" },
            { "YT", "\u0645\u0627\u064a\u0648\u062a" },
            { "ZA", "\u062c\u0646\u0648\u0628 \u0623\u0641\u0631\u064a\u0642\u064a\u0627" },
            { "ZM", "\u0632\u0627\u0645\u0628\u064a\u0627" },
            { "ZW", "\u0632\u064a\u0645\u0628\u0627\u0628\u0648\u064a" },
            { "ZZ", "\u0645\u0646\u0637\u0642\u0629 \u063a\u064a\u0631 \u0645\u0639\u0631\u0648\u0641\u0629" },
            { "aa", "\u0627\u0644\u0623\u0641\u0627\u0631\u064a\u0629" },
            { "ab", "\u0627\u0644\u0623\u0628\u062e\u0627\u0632\u064a\u0629" },
            { "ae", "\u0627\u0644\u0623\u0641\u0633\u062a\u064a\u0629" },
            { "af", "\u0627\u0644\u0623\u0641\u0631\u064a\u0642\u0627\u0646\u064a\u0629" },
            { "ak", "\u0627\u0644\u0623\u0643\u0627\u0646\u064a\u0629" },
            { "am", "\u0627\u0644\u0623\u0645\u0647\u0631\u064a\u0629" },
            { "an", "\u0627\u0644\u0623\u0631\u0627\u063a\u0648\u0646\u064a\u0629" },
            { "ar", metaValue_ar },
            { "as", "\u0627\u0644\u0623\u0633\u0627\u0645\u064a\u0629" },
            { "av", "\u0627\u0644\u0623\u0648\u0627\u0631\u064a\u0629" },
            { "ay", "\u0627\u0644\u0623\u064a\u0645\u0627\u0631\u0627" },
            { "az", "\u0627\u0644\u0623\u0630\u0631\u0628\u064a\u062c\u0627\u0646\u064a\u0629" },
            { "ba", "\u0627\u0644\u0628\u0627\u0634\u0643\u064a\u0631\u064a\u0629" },
            { "be", "\u0627\u0644\u0628\u064a\u0644\u0627\u0631\u0648\u0633\u064a\u0629" },
            { "bg", "\u0627\u0644\u0628\u0644\u063a\u0627\u0631\u064a\u0629" },
            { "bi", "\u0627\u0644\u0628\u064a\u0633\u0644\u0627\u0645\u064a\u0629" },
            { "bm", "\u0627\u0644\u0628\u0627\u0645\u0628\u0627\u0631\u0627" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "br", "\u0627\u0644\u0628\u0631\u064a\u062a\u0648\u0646\u064a\u0629" },
            { "bs", "\u0627\u0644\u0628\u0648\u0633\u0646\u064a\u0629" },
            { "ca", "\u0627\u0644\u0643\u062a\u0627\u0644\u0627\u0646\u064a\u0629" },
            { "ce", "\u0627\u0644\u0634\u064a\u0634\u0627\u0646\u064a\u0629" },
            { "ch", "\u0627\u0644\u062a\u0634\u0627\u0645\u0648\u0631\u0648" },
            { "co", "\u0627\u0644\u0643\u0648\u0631\u0633\u064a\u0643\u064a\u0629" },
            { "cr", "\u0627\u0644\u0643\u0631\u0649" },
            { "cs", "\u0627\u0644\u062a\u0634\u064a\u0643\u064a\u0629" },
            { "cu", "\u0633\u0644\u0627\u0641\u064a\u0629 \u0643\u0646\u0633\u064a\u0629" },
            { "cv", "\u0627\u0644\u062a\u0634\u0648\u0641\u0627\u0634\u064a" },
            { "cy", "\u0627\u0644\u0648\u064a\u0644\u0632\u064a\u0629" },
            { "da", "\u0627\u0644\u062f\u0627\u0646\u0645\u0631\u0643\u064a\u0629" },
            { "de", "\u0627\u0644\u0623\u0644\u0645\u0627\u0646\u064a\u0629" },
            { "dv", "\u0627\u0644\u0645\u0627\u0644\u062f\u064a\u0641\u064a\u0629" },
            { "dz", "\u0627\u0644\u0632\u0648\u0646\u062e\u0627\u064a\u0629" },
            { "ee", "\u0627\u0644\u0625\u064a\u0648\u064a" },
            { "el", metaValue_el },
            { "en", "\u0627\u0644\u0625\u0646\u062c\u0644\u064a\u0632\u064a\u0629" },
            { "eo", "\u0627\u0644\u0625\u0633\u0628\u0631\u0627\u0646\u062a\u0648" },
            { "es", "\u0627\u0644\u0625\u0633\u0628\u0627\u0646\u064a\u0629" },
            { "et", "\u0627\u0644\u0625\u0633\u062a\u0648\u0646\u064a\u0629" },
            { "eu", "\u0627\u0644\u0628\u0627\u0633\u0643\u064a\u0629" },
            { "fa", "\u0627\u0644\u0641\u0627\u0631\u0633\u064a\u0629" },
            { "ff", "\u0627\u0644\u0641\u0648\u0644\u0627\u0646\u064a\u0629" },
            { "fi", "\u0627\u0644\u0641\u0646\u0644\u0646\u062f\u064a\u0629" },
            { "fj", "\u0627\u0644\u0641\u064a\u062c\u064a\u0629" },
            { "fo", "\u0627\u0644\u0641\u0627\u0631\u0648\u064a\u0629" },
            { "fr", "\u0627\u0644\u0641\u0631\u0646\u0633\u064a\u0629" },
            { "fy", "\u0627\u0644\u0641\u0631\u064a\u0632\u064a\u0627\u0646" },
            { "ga", "\u0627\u0644\u0623\u064a\u0631\u0644\u0646\u062f\u064a\u0629" },
            { "gd", "\u0627\u0644\u063a\u064a\u0644\u064a\u0629 \u0627\u0644\u0623\u0633\u0643\u062a\u0644\u0646\u062f\u064a\u0629" },
            { "gl", "\u0627\u0644\u062c\u0627\u0644\u064a\u0643\u064a\u0629" },
            { "gn", "\u0627\u0644\u063a\u0648\u0627\u0631\u0627\u0646\u064a\u0629" },
            { "gu", "\u0627\u0644\u063a\u0648\u062c\u0627\u0631\u0627\u062a\u064a\u0629" },
            { "gv", "\u0627\u0644\u0645\u0646\u0643\u064a\u0629" },
            { "ha", "\u0627\u0644\u0647\u0648\u0633\u0627" },
            { "he", metaValue_he },
            { "hi", "\u0627\u0644\u0647\u0646\u062f\u064a\u0629" },
            { "ho", "\u0627\u0644\u0647\u064a\u0631\u064a \u0645\u0648\u062a\u0648" },
            { "hr", "\u0627\u0644\u0643\u0631\u0648\u0627\u062a\u064a\u0629" },
            { "ht", "\u0627\u0644\u0643\u0631\u064a\u0648\u0644\u064a\u0629 \u0627\u0644\u0647\u0627\u064a\u062a\u064a\u0629" },
            { "hu", "\u0627\u0644\u0647\u0646\u063a\u0627\u0631\u064a\u0629" },
            { "hy", "\u0627\u0644\u0623\u0631\u0645\u0646\u064a\u0629" },
            { "hz", "\u0627\u0644\u0647\u064a\u0631\u064a\u0631\u0648" },
            { "ia", "\u0627\u0644\u0644\u0651\u063a\u0629 \u0627\u0644\u0648\u0633\u064a\u0637\u0629" },
            { "id", "\u0627\u0644\u0625\u0646\u062f\u0648\u0646\u064a\u0633\u064a\u0629" },
            { "ie", "\u0627\u0644\u0625\u0646\u062a\u0631\u0644\u064a\u0646\u062c" },
            { "ig", "\u0627\u0644\u0625\u064a\u062c\u0628\u0648" },
            { "ii", "\u0627\u0644\u0633\u064a\u062a\u0634\u064a\u0648\u0646 \u064a\u064a" },
            { "ik", "\u0627\u0644\u0625\u064a\u0646\u0628\u064a\u0627\u0643" },
            { "io", "\u0627\u0644\u0625\u064a\u062f\u0648" },
            { "is", "\u0627\u0644\u0623\u064a\u0633\u0644\u0646\u062f\u064a\u0629" },
            { "it", "\u0627\u0644\u0625\u064a\u0637\u0627\u0644\u064a\u0629" },
            { "iu", "\u0627\u0644\u0625\u064a\u0646\u0643\u062a\u064a\u062a\u062a" },
            { "ja", metaValue_ja },
            { "jv", metaValue_jv },
            { "ka", metaValue_ka },
            { "kg", "\u0627\u0644\u0643\u0648\u0646\u063a\u0648" },
            { "ki", "\u0627\u0644\u0643\u064a\u0643\u064a\u0648" },
            { "kj", "\u0627\u0644\u0643\u064a\u0648\u0646\u064a\u0627\u0645\u0627" },
            { "kk", "\u0627\u0644\u0643\u0627\u0632\u0627\u062e\u0633\u062a\u0627\u0646\u064a\u0629" },
            { "kl", "\u0627\u0644\u0643\u0627\u0644\u0627\u0644\u064a\u0633\u062a" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "\u0627\u0644\u0643\u0627\u0646\u0648\u0631\u064a" },
            { "ks", "\u0627\u0644\u0643\u0634\u0645\u064a\u0631\u064a\u0629" },
            { "ku", "\u0627\u0644\u0643\u0631\u062f\u064a\u0629" },
            { "kv", "\u0627\u0644\u0643\u0648\u0645\u064a" },
            { "kw", "\u0627\u0644\u0643\u0648\u0631\u0646\u064a\u0629" },
            { "ky", "\u0627\u0644\u0642\u064a\u0631\u063a\u064a\u0632\u064a\u0629" },
            { "la", metaValue_la },
            { "lb", "\u0627\u0644\u0644\u0643\u0633\u0645\u0628\u0648\u0631\u063a\u064a\u0629" },
            { "lg", "\u0627\u0644\u063a\u0627\u0646\u062f\u0627" },
            { "li", "\u0627\u0644\u0644\u064a\u0645\u0628\u0648\u0631\u063a\u064a\u0629" },
            { "ln", "\u0627\u0644\u0644\u064a\u0646\u062c\u0627\u0644\u0627" },
            { "lo", "\u0627\u0644\u0644\u0627\u0648\u064a\u0629" },
            { "lt", "\u0627\u0644\u0644\u064a\u062a\u0648\u0627\u0646\u064a\u0629" },
            { "lu", "\u0627\u0644\u0644\u0648\u0628\u0627 \u0643\u0627\u062a\u0627\u0646\u063a\u0627" },
            { "lv", "\u0627\u0644\u0644\u0627\u062a\u0641\u064a\u0629" },
            { "mg", "\u0627\u0644\u0645\u0644\u063a\u0627\u0634\u064a" },
            { "mh", "\u0627\u0644\u0645\u0627\u0631\u0634\u0627\u0644\u064a\u0629" },
            { "mi", "\u0627\u0644\u0645\u0627\u0648\u0631\u064a\u0629" },
            { "mk", "\u0627\u0644\u0645\u0642\u062f\u0648\u0646\u064a\u0629" },
            { "ml", "\u0627\u0644\u0645\u0627\u0644\u0627\u064a\u0627\u0644\u0627\u0645\u064a\u0629" },
            { "mn", "\u0627\u0644\u0645\u0646\u063a\u0648\u0644\u064a\u0629" },
            { "mr", "\u0627\u0644\u0645\u0627\u0631\u0627\u062b\u064a\u0629" },
            { "ms", "\u0627\u0644\u0645\u0627\u0644\u064a\u0632\u064a\u0629" },
            { "mt", "\u0627\u0644\u0645\u0627\u0644\u0637\u064a\u0629" },
            { "my", "\u0627\u0644\u0628\u0648\u0631\u0645\u064a\u0629" },
            { "na", "\u0627\u0644\u0646\u0648\u0631\u0648" },
            { "nb", "\u0627\u0644\u0646\u0631\u0648\u064a\u062c\u064a\u0629 \u0628\u0648\u0643\u0645\u0627\u0644" },
            { "nd", "\u0627\u0644\u0646\u062f\u064a\u0628\u064a\u0644 \u0627\u0644\u0634\u0645\u0627\u0644\u064a\u0629" },
            { "ne", "\u0627\u0644\u0646\u064a\u0628\u0627\u0644\u064a\u0629" },
            { "ng", "\u0627\u0644\u0646\u062f\u0648\u0646\u062c\u0627" },
            { "nl", "\u0627\u0644\u0647\u0648\u0644\u0646\u062f\u064a\u0629" },
            { "nn", "\u0627\u0644\u0646\u0631\u0648\u064a\u062c\u064a\u0629 \u0646\u064a\u0646\u0648\u0631\u0633\u0643" },
            { "no", "\u0627\u0644\u0646\u0631\u0648\u064a\u062c\u064a\u0629" },
            { "nr", "\u0627\u0644\u0646\u062f\u064a\u0628\u064a\u0644 \u0627\u0644\u062c\u0646\u0648\u0628\u064a" },
            { "nv", "\u0627\u0644\u0646\u0627\u0641\u0627\u062c\u0648" },
            { "ny", "\u0627\u0644\u0646\u064a\u0627\u0646\u062c\u0627" },
            { "oc", "\u0627\u0644\u0623\u0648\u0643\u0633\u064a\u062a\u0627\u0646\u064a\u0629" },
            { "oj", "\u0627\u0644\u0623\u0648\u062c\u064a\u0628\u0648\u0627" },
            { "om", "\u0627\u0644\u0623\u0648\u0631\u0648\u0645\u064a\u0629" },
            { "or", "\u0627\u0644\u0623\u0648\u0631\u064a\u0629" },
            { "os", "\u0627\u0644\u0623\u0648\u0633\u064a\u062a\u064a\u0643" },
            { "pa", "\u0627\u0644\u0628\u0646\u062c\u0627\u0628\u064a\u0629" },
            { "pi", metaValue_pi },
            { "pl", "\u0627\u0644\u0628\u0648\u0644\u0646\u062f\u064a\u0629" },
            { "ps", "\u0627\u0644\u0628\u0634\u062a\u0648" },
            { "pt", "\u0627\u0644\u0628\u0631\u062a\u063a\u0627\u0644\u064a\u0629" },
            { "qu", "\u0627\u0644\u0643\u0648\u064a\u062a\u0634\u0648\u0627" },
            { "rm", "\u0627\u0644\u0631\u0648\u0645\u0627\u0646\u0634\u064a\u0629" },
            { "rn", "\u0627\u0644\u0631\u0646\u062f\u064a" },
            { "ro", "\u0627\u0644\u0631\u0648\u0645\u0627\u0646\u064a\u0629" },
            { "ru", "\u0627\u0644\u0631\u0648\u0633\u064a\u0629" },
            { "rw", "\u0627\u0644\u0643\u064a\u0646\u064a\u0627\u0631\u0648\u0627\u0646\u062f\u0627" },
            { "sa", "\u0627\u0644\u0633\u0646\u0633\u0643\u0631\u064a\u062a\u064a\u0629" },
            { "sc", "\u0627\u0644\u0633\u0631\u062f\u064a\u0646\u064a\u0629" },
            { "sd", "\u0627\u0644\u0633\u0646\u062f\u064a\u0629" },
            { "se", "\u0633\u0627\u0645\u064a \u0627\u0644\u0634\u0645\u0627\u0644\u064a\u0629" },
            { "sg", "\u0627\u0644\u0633\u0627\u0646\u062c\u0648" },
            { "sh", "\u0635\u0631\u0628\u064a\u0629-\u0643\u0631\u0648\u0627\u062a\u064a\u0629" },
            { "si", "\u0627\u0644\u0633\u0646\u0647\u0627\u0644\u064a\u0629" },
            { "sk", "\u0627\u0644\u0633\u0644\u0648\u0641\u0627\u0643\u064a\u0629" },
            { "sl", "\u0627\u0644\u0633\u0644\u0648\u0641\u0627\u0646\u064a\u0629" },
            { "sm", "\u0627\u0644\u0633\u0627\u0645\u0648\u0627\u0626\u064a\u0629" },
            { "sn", "\u0627\u0644\u0634\u0648\u0646\u0627" },
            { "so", "\u0627\u0644\u0635\u0648\u0645\u0627\u0644\u064a\u0629" },
            { "sq", "\u0627\u0644\u0623\u0644\u0628\u0627\u0646\u064a\u0629" },
            { "sr", "\u0627\u0644\u0635\u0631\u0628\u064a\u0629" },
            { "ss", "\u0627\u0644\u0633\u0648\u0627\u062a\u064a" },
            { "st", "\u0627\u0644\u0633\u0648\u062a\u0648 \u0627\u0644\u062c\u0646\u0648\u0628\u064a\u0629" },
            { "su", metaValue_su },
            { "sv", "\u0627\u0644\u0633\u0648\u064a\u062f\u064a\u0629" },
            { "sw", "\u0627\u0644\u0633\u0648\u0627\u062d\u0644\u064a\u0629" },
            { "ta", metaValue_ta },
            { "te", "\u0627\u0644\u062a\u064a\u0644\u0648\u063a\u0648\u064a\u0629" },
            { "tg", "\u0627\u0644\u0637\u0627\u062c\u064a\u0643\u064a\u0629" },
            { "th", metaValue_th },
            { "ti", "\u0627\u0644\u062a\u063a\u0631\u064a\u0646\u064a\u0629" },
            { "tk", "\u0627\u0644\u062a\u0631\u0643\u0645\u0627\u0646\u064a\u0629" },
            { "tl", "\u0627\u0644\u062a\u0627\u063a\u0627\u0644\u0648\u063a\u064a\u0629" },
            { "tn", "\u0627\u0644\u062a\u0633\u0648\u0627\u0646\u064a\u0629" },
            { "to", "\u0627\u0644\u062a\u0648\u0646\u063a\u064a\u0629" },
            { "tr", "\u0627\u0644\u062a\u0631\u0643\u064a\u0629" },
            { "ts", "\u0627\u0644\u0633\u0648\u0646\u062c\u0627" },
            { "tt", "\u0627\u0644\u062a\u062a\u0631\u064a\u0629" },
            { "tw", "\u0627\u0644\u062a\u0648\u064a" },
            { "ty", "\u0627\u0644\u062a\u0627\u0647\u064a\u062a\u064a\u0629" },
            { "ug", "\u0627\u0644\u0623\u0648\u064a\u063a\u0648\u0631\u064a\u0629" },
            { "uk", "\u0627\u0644\u0623\u0648\u0643\u0631\u0627\u0646\u064a\u0629" },
            { "ur", "\u0627\u0644\u0623\u0648\u0631\u062f\u064a\u0629" },
            { "uz", "\u0627\u0644\u0623\u0648\u0632\u0628\u0643\u064a\u0629" },
            { "ve", "\u0627\u0644\u0641\u064a\u0646\u062f\u0627" },
            { "vi", "\u0627\u0644\u0641\u064a\u062a\u0646\u0627\u0645\u064a\u0629" },
            { "vo", "\u0644\u063a\u0629 \u0627\u0644\u0641\u0648\u0644\u0627\u0628\u0648\u0643" },
            { "wa", "\u0627\u0644\u0648\u0644\u0648\u0646\u064a\u0629" },
            { "wo", "\u0627\u0644\u0648\u0644\u0648\u0641\u064a\u0629" },
            { "xh", "\u0627\u0644\u062e\u0648\u0633\u0627" },
            { "yi", "\u0627\u0644\u064a\u062f\u064a\u0634\u064a\u0629" },
            { "yo", "\u0627\u0644\u064a\u0648\u0631\u0648\u0628\u0627" },
            { "za", "\u0627\u0644\u0632\u0647\u064a\u0648\u0646\u062c" },
            { "zh", "\u0627\u0644\u0635\u064a\u0646\u064a\u0629" },
            { "zu", "\u0627\u0644\u0632\u0648\u0644\u0648" },
            { "ace", "\u0627\u0644\u0623\u062a\u0634\u064a\u0646\u064a\u0632\u064a\u0629" },
            { "ach", "\u0627\u0644\u0623\u0643\u0648\u0644\u064a\u0629" },
            { "ada", "\u0627\u0644\u0623\u062f\u0627\u0646\u062c\u0645\u064a\u0629" },
            { "ady", "\u0627\u0644\u0623\u062f\u064a\u063a\u0629" },
            { "afh", "\u0627\u0644\u0623\u0641\u0631\u064a\u0647\u064a\u0644\u064a\u0629" },
            { "agq", "\u0627\u0644\u0623\u063a\u0645" },
            { "ain", "\u0627\u0644\u0622\u064a\u0646\u0648\u064a\u0629" },
            { "akk", "\u0627\u0644\u0623\u0643\u0627\u062f\u064a\u0629" },
            { "ale", "\u0627\u0644\u0623\u0644\u064a\u0648\u062a\u064a\u0629" },
            { "alt", "\u0627\u0644\u0623\u0644\u0637\u0627\u0626\u064a\u0629 \u0627\u0644\u062c\u0646\u0648\u0628\u064a\u0629" },
            { "ang", "\u0627\u0644\u0625\u0646\u062c\u0644\u064a\u0632\u064a\u0629 \u0627\u0644\u0642\u062f\u064a\u0645\u0629" },
            { "ann", "\u0623\u0648\u0628\u0644\u0648" },
            { "anp", "\u0627\u0644\u0623\u0646\u062c\u064a\u0643\u0627" },
            { "arc", "\u0627\u0644\u0622\u0631\u0627\u0645\u064a\u0629" },
            { "arn", "\u0627\u0644\u0645\u0627\u0628\u0648\u062f\u0648\u0646\u063a\u0648\u0646\u064a\u0629" },
            { "arp", "\u0627\u0644\u0623\u0631\u0627\u0628\u0627\u0647\u0648" },
            { "ars", "\u0627\u0644\u0644\u0647\u062c\u0629 \u0627\u0644\u0646\u062c\u062f\u064a\u0629" },
            { "arw", "\u0627\u0644\u0623\u0631\u0627\u0648\u0627\u0643\u064a\u0629" },
            { "asa", "\u0627\u0644\u0622\u0633\u0648" },
            { "ast", "\u0627\u0644\u0623\u0633\u062a\u0631\u064a\u0629" },
            { "atj", "\u0627\u0644\u0623\u062a\u064a\u0643\u0627\u0645\u064a\u0643\u0648" },
            { "awa", "\u0627\u0644\u0623\u0648\u0627\u062f\u064a\u0629" },
            { "bal", "\u0627\u0644\u0628\u0644\u0648\u0634\u064a\u0629" },
            { "ban", "\u0627\u0644\u0628\u0627\u0644\u064a\u0646\u064a\u0629" },
            { "bas", "\u0627\u0644\u0628\u0627\u0633\u0627" },
            { "bax", "\u0628\u0627\u0645\u0646" },
            { "bbj", "\u0644\u063a\u0629 \u0627\u0644\u063a\u0648\u0645\u0627\u0644\u0627" },
            { "bej", "\u0627\u0644\u0628\u064a\u062c\u0627" },
            { "bem", "\u0627\u0644\u0628\u064a\u0645\u0628\u0627" },
            { "bez", "\u0628\u064a\u0646\u0627" },
            { "bfd", "\u0644\u063a\u0629 \u0627\u0644\u0628\u0627\u0641\u0648\u062a" },
            { "bgn", "\u0627\u0644\u0628\u0644\u0648\u0634\u064a\u0629 \u0627\u0644\u063a\u0631\u0628\u064a\u0629" },
            { "bho", "\u0627\u0644\u0628\u0647\u0648\u062c\u0628\u0648\u0631\u064a\u0629" },
            { "bik", "\u0627\u0644\u0628\u064a\u0643\u0648\u0644\u064a\u0629" },
            { "bin", "\u0627\u0644\u0628\u064a\u0646\u064a\u0629" },
            { "bkm", "\u0644\u063a\u0629 \u0627\u0644\u0643\u0648\u0645" },
            { "bla", "\u0627\u0644\u0633\u064a\u0643\u0633\u064a\u0643\u064a\u0629" },
            { "bra", "\u0627\u0644\u0628\u0631\u0627\u062c\u064a\u0629" },
            { "brx", "\u0627\u0644\u0628\u0648\u062f\u0648" },
            { "bss", "\u0623\u0643\u0648\u0633" },
            { "bua", "\u0627\u0644\u0628\u0631\u064a\u0627\u062a\u064a\u0629" },
            { "bug", "\u0627\u0644\u0628\u062c\u064a\u0646\u064a\u0632\u064a\u0629" },
            { "bum", "\u0644\u063a\u0629 \u0627\u0644\u0628\u0648\u0644\u0648" },
            { "byn", "\u0627\u0644\u0628\u0644\u064a\u0646\u064a\u0629" },
            { "byv", "\u0644\u063a\u0629 \u0627\u0644\u0645\u064a\u062f\u0648\u0645\u0628\u0627" },
            { "cad", "\u0627\u0644\u0643\u0627\u062f\u0648" },
            { "car", "\u0627\u0644\u0643\u0627\u0631\u064a\u0628\u064a\u0629" },
            { "cay", "\u0627\u0644\u0643\u0627\u064a\u0648\u062c\u064a\u0629" },
            { "cch", "\u0627\u0644\u0623\u062a\u0633\u0627\u0645" },
            { "ccp", "\u062a\u0634\u0627\u0643\u0645\u0627" },
            { "ceb", "\u0627\u0644\u0633\u064a\u0628\u064a\u0648\u0627\u0646\u064a\u0629" },
            { "cgg", "\u062a\u0634\u064a\u063a\u0627" },
            { "chb", "\u0627\u0644\u062a\u0634\u064a\u0628\u0634\u0627" },
            { "chg", "\u0627\u0644\u062a\u0634\u0627\u062c\u0627\u062a\u0627\u064a" },
            { "chk", "\u0627\u0644\u062a\u0634\u0643\u064a\u0632\u064a\u0629" },
            { "chm", "\u0627\u0644\u0645\u0627\u0631\u064a" },
            { "chn", "\u0627\u0644\u0634\u064a\u0646\u0648\u0643 \u062c\u0627\u0631\u062c\u0648\u0646" },
            { "cho", "\u0627\u0644\u0634\u0648\u0643\u062a\u0648" },
            { "chp", "\u0627\u0644\u0634\u064a\u0628\u0627\u0648\u0627\u064a\u0627\u0646" },
            { "chr", metaValue_chr },
            { "chy", "\u0627\u0644\u0634\u0627\u064a\u0627\u0646" },
            { "ckb", "\u0627\u0644\u0633\u0648\u0631\u0627\u0646\u064a\u0629 \u0627\u0644\u0643\u0631\u062f\u064a\u0629" },
            { "clc", "\u062a\u0633\u064a\u0644\u0643\u0648\u062a\u064a\u0646" },
            { "cop", metaValue_cop },
            { "crg", "\u0627\u0644\u0645\u064a\u062a\u0634\u064a\u0641" },
            { "crh", "\u0644\u063a\u0629 \u062a\u062a\u0627\u0631 \u0627\u0644\u0642\u0631\u0645" },
            { "crj", "\u0627\u0644\u0643\u0631\u064a \u0627\u0644\u062c\u0646\u0648\u0628 \u0634\u0631\u0642\u064a\u0629" },
            { "crk", "\u0627\u0644\u0628\u0644\u064a\u0646\u0632-\u0643\u0631\u064a" },
            { "crl", "\u0627\u0644\u0643\u0631\u064a \u0634\u0645\u0627\u0644 \u0627\u0644\u0634\u0631\u0642\u064a\u0629" },
            { "crm", "\u0627\u0644\u0645\u0648\u0633-\u0643\u0631\u064a" },
            { "crr", "\u0627\u0644\u0623\u0644\u063a\u0648\u0646\u0643\u0648\u064a\u0629 \u0643\u0627\u0631\u0648\u0644\u064a\u0646\u0627" },
            { "crs", "\u0627\u0644\u0641\u0631\u0646\u0633\u064a\u0629 \u0627\u0644\u0643\u0631\u064a\u0648\u0644\u064a\u0629 \u0627\u0644\u0633\u064a\u0634\u064a\u0644\u064a\u0629" },
            { "csb", "\u0627\u0644\u0643\u0627\u0634\u0628\u0627\u064a\u0627\u0646" },
            { "csw", "\u0627\u0644\u0633\u0648\u0627\u0645\u0628\u064a-\u0643\u0631\u064a" },
            { "dak", "\u0627\u0644\u062f\u0627\u0643\u0648\u062a\u0627" },
            { "dar", "\u0627\u0644\u062f\u0627\u0631\u062c\u0648\u0627" },
            { "dav", "\u062a\u064a\u062a\u0627" },
            { "del", "\u0627\u0644\u062f\u064a\u0644\u0648\u064a\u0631" },
            { "den", "\u0627\u0644\u0633\u0644\u0627\u0641\u064a\u0629" },
            { "dgr", "\u0627\u0644\u062f\u0648\u062c\u0631\u064a\u0628" },
            { "din", "\u0627\u0644\u062f\u0646\u0643\u0627" },
            { "dje", "\u0627\u0644\u0632\u0627\u0631\u0645\u064a\u0629" },
            { "doi", "\u0627\u0644\u062f\u0648\u062c\u0631\u064a\u0629" },
            { "dsb", "\u0635\u0648\u0631\u0628\u064a\u0627 \u0627\u0644\u0633\u0641\u0644\u0649" },
            { "dua", "\u0627\u0644\u062f\u064a\u0648\u0644\u0627" },
            { "dum", "\u0627\u0644\u0647\u0648\u0644\u0646\u062f\u064a\u0629 \u0627\u0644\u0648\u0633\u0637\u0649" },
            { "dyo", "\u062c\u0648\u0644\u0627 \u0641\u0648\u0646\u064a\u0627" },
            { "dyu", "\u0627\u0644\u062f\u0627\u064a\u0644\u0627" },
            { "dzg", "\u0627\u0644\u0642\u0631\u0639\u0627\u0646\u064a\u0629" },
            { "ebu", "\u0625\u0645\u0628\u0648" },
            { "efi", "\u0627\u0644\u0625\u0641\u064a\u0643" },
            { "egy", "\u0627\u0644\u0645\u0635\u0631\u064a\u0629 \u0627\u0644\u0642\u062f\u064a\u0645\u0629" },
            { "eka", "\u0627\u0644\u0625\u0643\u0627\u062c\u0643" },
            { "elx", "\u0627\u0644\u0625\u0645\u0627\u064a\u062a" },
            { "enm", "\u0627\u0644\u0625\u0646\u062c\u0644\u064a\u0632\u064a\u0629 \u0627\u0644\u0648\u0633\u0637\u0649" },
            { "ewo", "\u0627\u0644\u0625\u064a\u0648\u0646\u062f\u0648" },
            { "fan", "\u0627\u0644\u0641\u0627\u0646\u062c" },
            { "fat", "\u0627\u0644\u0641\u0627\u0646\u062a\u064a" },
            { "fil", "\u0627\u0644\u0641\u0644\u0628\u064a\u0646\u064a\u0629" },
            { "fon", "\u0627\u0644\u0641\u0648\u0646" },
            { "frc", "\u0627\u0644\u0641\u0631\u0646\u0633\u064a\u0629 \u0627\u0644\u0643\u0627\u062c\u0648\u0646\u064a\u0629" },
            { "frm", "\u0627\u0644\u0641\u0631\u0646\u0633\u064a\u0629 \u0627\u0644\u0648\u0633\u0637\u0649" },
            { "fro", "\u0627\u0644\u0641\u0631\u0646\u0633\u064a\u0629 \u0627\u0644\u0642\u062f\u064a\u0645\u0629" },
            { "frr", "\u0627\u0644\u0641\u0631\u064a\u0632\u064a\u0646\u064a\u0629 \u0627\u0644\u0634\u0645\u0627\u0644\u064a\u0629" },
            { "frs", "\u0627\u0644\u0641\u0631\u064a\u0632\u064a\u0646\u064a\u0629 \u0627\u0644\u0634\u0631\u0642\u064a\u0629" },
            { "fur", "\u0627\u0644\u0641\u0631\u064a\u0644\u0627\u064a\u0627\u0646" },
            { "gaa", "\u0627\u0644\u062c\u0627" },
            { "gag", "\u0627\u0644\u063a\u0627\u063a\u0648\u0632" },
            { "gan", "\u0627\u0644\u063a\u0627\u0646 \u0627\u0644\u0635\u064a\u0646\u064a\u0629" },
            { "gay", "\u0627\u0644\u062c\u0627\u064a\u0648" },
            { "gba", "\u0627\u0644\u062c\u0628\u064a\u0627" },
            { "gez", "\u0627\u0644\u062c\u0639\u0632\u064a\u0629" },
            { "gil", "\u0644\u063a\u0629 \u0623\u0647\u0644 \u062c\u0628\u0644 \u0637\u0627\u0631\u0642" },
            { "gmh", "\u0627\u0644\u0623\u0644\u0645\u0627\u0646\u064a\u0629 \u0627\u0644\u0639\u0644\u064a\u0627 \u0627\u0644\u0648\u0633\u0637\u0649" },
            { "goh", "\u0627\u0644\u0623\u0644\u0645\u0627\u0646\u064a\u0629 \u0627\u0644\u0639\u0644\u064a\u0627 \u0627\u0644\u0642\u062f\u064a\u0645\u0629" },
            { "gon", "\u0627\u0644\u062c\u0646\u062f\u064a" },
            { "gor", "\u0627\u0644\u062c\u0648\u0631\u0648\u0646\u062a\u0627\u0644\u0648" },
            { "got", metaValue_got },
            { "grb", "\u0627\u0644\u062c\u0631\u064a\u0628\u0648" },
            { "grc", "\u0627\u0644\u064a\u0648\u0646\u0627\u0646\u064a\u0629 \u0627\u0644\u0642\u062f\u064a\u0645\u0629" },
            { "gsw", "\u0627\u0644\u0623\u0644\u0645\u0627\u0646\u064a\u0629 \u0627\u0644\u0633\u0648\u064a\u0633\u0631\u064a\u0629" },
            { "guz", "\u0627\u0644\u063a\u064a\u0632\u064a\u0629" },
            { "gwi", "\u063a\u0648\u062a\u0634\u0646" },
            { "hai", "\u0627\u0644\u0647\u064a\u062f\u0627" },
            { "hak", "\u0627\u0644\u0647\u0627\u0643\u0627 \u0627\u0644\u0635\u064a\u0646\u064a\u0629" },
            { "haw", "\u0644\u063a\u0629 \u0647\u0627\u0648\u0627\u064a" },
            { "hax", "\u0647\u0627\u064a\u062f\u0627 \u0627\u0644\u062c\u0646\u0648\u0628\u064a\u0629" },
            { "hil", "\u0627\u0644\u0647\u064a\u0644\u064a\u062c\u064a\u0646\u0648\u0646" },
            { "hit", "\u0627\u0644\u062d\u062b\u064a\u0629" },
            { "hmn", "\u0627\u0644\u0647\u0645\u0648\u0646\u062c\u064a\u0629" },
            { "hsb", "\u0627\u0644\u0635\u0648\u0631\u0628\u064a\u0629 \u0627\u0644\u0639\u0644\u064a\u0627" },
            { "hsn", "\u0634\u064a\u0627\u0646\u063a \u0627\u0644\u0635\u064a\u0646\u064a\u0629" },
            { "hup", "\u0627\u0644\u0647\u0628\u0627" },
            { "hur", "\u0627\u0644\u0647\u0627\u0644\u0643\u0648\u0645\u064a\u0644\u064a\u0645" },
            { "iba", "\u0627\u0644\u0625\u064a\u0628\u0627\u0646" },
            { "ibb", "\u0627\u0644\u0625\u064a\u0628\u064a\u0628\u064a\u0648" },
            { "ikt", "\u0627\u0644\u0625\u0646\u0643\u062a\u064a\u062a\u0648\u062a\u064a\u0629 \u0627\u0644\u0643\u0646\u062f\u064a\u0629 \u0627\u0644\u063a\u0631\u0628\u064a\u0629" },
            { "ilo", "\u0627\u0644\u0625\u064a\u0644\u0648\u0643\u0648" },
            { "inh", "\u0627\u0644\u0625\u0646\u062c\u0648\u0634\u064a\u0629" },
            { "jbo", "\u0627\u0644\u0644\u0648\u062c\u0628\u0627\u0646" },
            { "jgo", "\u0646\u063a\u0648\u0645\u0628\u0627" },
            { "jmc", "\u0627\u0644\u0645\u0627\u062a\u0634\u0627\u0645\u064a\u0629" },
            { "jpr", "\u0627\u0644\u0641\u0627\u0631\u0633\u064a\u0629 \u0627\u0644\u064a\u0647\u0648\u062f\u064a\u0629" },
            { "jrb", "\u0627\u0644\u0639\u0631\u0628\u064a\u0629 \u0627\u0644\u064a\u0647\u0648\u062f\u064a\u0629" },
            { "kaa", "\u0627\u0644\u0643\u0627\u0631\u0627-\u0643\u0627\u0644\u0628\u0627\u0643" },
            { "kab", "\u0627\u0644\u0642\u0628\u064a\u0644\u064a\u0629" },
            { "kac", "\u0627\u0644\u0643\u0627\u062a\u0634\u064a\u0646" },
            { "kaj", "\u0627\u0644\u062c\u0648" },
            { "kam", "\u0627\u0644\u0643\u0627\u0645\u0628\u0627" },
            { "kaw", "\u0627\u0644\u0643\u0648\u064a" },
            { "kbd", "\u0627\u0644\u0643\u0627\u0628\u0627\u0631\u062f\u0627\u064a\u0627\u0646" },
            { "kbl", "\u0643\u0627\u0646\u0645\u0628\u0648" },
            { "kcg", "\u0627\u0644\u062a\u0627\u064a\u0627\u0628\u064a\u0629" },
            { "kde", "\u0645\u0627\u0643\u0648\u0646\u062f\u0647" },
            { "kea", "\u0643\u0627\u0628\u0648\u0641\u064a\u0631\u062f\u064a\u0627\u0646\u0648" },
            { "kfo", "\u0627\u0644\u0643\u0648\u0631\u0648" },
            { "kgp", "\u0627\u0644\u0643\u0627\u064a\u0646\u063a\u0627\u0646\u063a" },
            { "kha", "\u0627\u0644\u0643\u0627\u0632\u064a\u0629" },
            { "kho", "\u0627\u0644\u062e\u0648\u062a\u0627\u0646\u064a\u0632" },
            { "khq", "\u0643\u0648\u064a\u0631\u0627 \u062a\u0634\u064a\u0646\u064a" },
            { "kkj", "\u0644\u063a\u0629 \u0627\u0644\u0643\u0627\u0643\u0648" },
            { "kln", "\u0643\u0627\u0644\u064a\u0646\u062c\u064a\u0646" },
            { "kmb", "\u0627\u0644\u0643\u064a\u0645\u0628\u0646\u062f\u0648" },
            { "koi", "\u0643\u0648\u0645\u064a-\u0628\u064a\u0631\u0645\u0627\u064a\u0627\u0643" },
            { "kok", "\u0627\u0644\u0643\u0648\u0646\u0643\u0627\u0646\u064a\u0629" },
            { "kos", "\u0627\u0644\u0643\u0648\u0633\u0631\u0627\u064a\u0646" },
            { "kpe", "\u0627\u0644\u0643\u0628\u064a\u0644" },
            { "krc", "\u0627\u0644\u0643\u0627\u0631\u0627\u062a\u0634\u0627\u064a-\u0628\u0627\u0644\u0643\u0627\u0631" },
            { "krl", "\u0627\u0644\u0643\u0627\u0631\u064a\u0644\u064a\u0629" },
            { "kru", "\u0627\u0644\u0643\u0648\u0631\u0648\u062e" },
            { "ksb", "\u0634\u0627\u0645\u0628\u0627\u0644\u0627" },
            { "ksf", "\u0644\u063a\u0629 \u0627\u0644\u0628\u0627\u0641\u064a\u0627" },
            { "ksh", "\u0644\u063a\u0629 \u0627\u0644\u0643\u0648\u0644\u0648\u0646\u064a\u0627\u0646" },
            { "kum", "\u0627\u0644\u0642\u0645\u0648\u0642\u064a\u0629" },
            { "kut", "\u0627\u0644\u0643\u062a\u064a\u0646\u0627\u064a" },
            { "kwk", "\u0627\u0644\u0643\u0648\u0627\u0643\u0648\u0627\u0644\u0627" },
            { "lad", "\u0627\u0644\u0644\u0627\u062f\u064a\u0646\u0648" },
            { "lag", "\u0644\u0627\u0646\u062c\u064a" },
            { "lah", "\u0627\u0644\u0644\u0627\u0647\u0646\u062f\u0627" },
            { "lam", "\u0627\u0644\u0644\u0627\u0645\u0628\u0627" },
            { "lez", "\u0627\u0644\u0644\u064a\u0632\u062c\u064a\u0629" },
            { "lil", "\u0627\u0644\u0644\u064a\u0644\u0648\u064a\u062a\u064a\u0629" },
            { "lkt", "\u0644\u0627\u0643\u0648\u062a\u0627" },
            { "lmo", "\u0627\u0644\u0644\u0648\u0645\u0628\u0631\u062f\u064a\u0629" },
            { "lol", "\u0645\u0646\u063a\u0648\u0644\u0649" },
            { "lou", "\u0627\u0644\u0643\u0631\u064a\u0648\u0644\u064a\u0629 \u0627\u0644\u0644\u0648\u064a\u0632\u064a\u0627\u0646\u064a\u0629" },
            { "loz", "\u0627\u0644\u0644\u0648\u0632\u064a" },
            { "lrc", "\u0627\u0644\u0644\u0631\u064a\u0629 \u0627\u0644\u0634\u0645\u0627\u0644\u064a\u0629" },
            { "lsm", "\u0627\u0644\u0633\u0627\u0645\u064a\u0627" },
            { "lua", "\u0627\u0644\u0644\u0628\u0627-\u0644\u0624\u0644\u0624" },
            { "lui", "\u0627\u0644\u0644\u0648\u0633\u064a\u0646\u0648" },
            { "lun", "\u0627\u0644\u0644\u0648\u0646\u062f\u0627" },
            { "luo", "\u0627\u0644\u0644\u0648" },
            { "lus", "\u0627\u0644\u0645\u064a\u0632\u0648" },
            { "luy", "\u0644\u063a\u0629 \u0627\u0644\u0644\u0648\u064a\u0627" },
            { "mad", "\u0627\u0644\u0645\u0627\u062f\u0631\u064a\u0632" },
            { "mag", "\u0627\u0644\u0645\u0627\u062c\u0627" },
            { "mai", "\u0627\u0644\u0645\u0627\u064a\u062b\u064a\u0644\u064a" },
            { "mak", "\u0627\u0644\u0645\u0627\u0643\u0627\u0633\u0627\u0631" },
            { "man", "\u0627\u0644\u0645\u0627\u0646\u062f\u064a\u0646\u063a" },
            { "mas", "\u0627\u0644\u0645\u0627\u0633\u0627\u064a" },
            { "mde", "\u0645\u0627\u0628\u0627" },
            { "mdf", "\u0627\u0644\u0645\u0648\u0643\u0634\u0627" },
            { "mdr", "\u0627\u0644\u0645\u0627\u0646\u062f\u0627\u0631" },
            { "men", "\u0627\u0644\u0645\u064a\u0646\u062f" },
            { "mer", "\u0627\u0644\u0645\u064a\u0631\u0648" },
            { "mfe", "\u0627\u0644\u0645\u0648\u0631\u0633\u064a\u0627\u0646\u064a\u0629" },
            { "mga", "\u0627\u0644\u0623\u064a\u0631\u0644\u0646\u062f\u064a\u0629 \u0627\u0644\u0648\u0633\u0637\u0649" },
            { "mgh", "\u0645\u0627\u062e\u0627\u0648\u0627-\u0645\u064a\u062a\u0648" },
            { "mgo", "\u0645\u064a\u062a\u0627" },
            { "mic", "\u0627\u0644\u0645\u064a\u0643\u0645\u0627\u0643\u064a\u0648\u0646\u064a\u0629" },
            { "min", "\u0627\u0644\u0645\u064a\u0646\u0627\u0646\u062c\u0643\u0627\u0628\u0627\u0648" },
            { "mnc", "\u0627\u0644\u0645\u0627\u0646\u0634\u0648" },
            { "mni", "\u0627\u0644\u0645\u0627\u0646\u064a\u0628\u0648\u0631\u064a\u0629" },
            { "moe", "\u0625\u064a\u0646\u0648-\u0627\u064a\u0645\u0648\u0646" },
            { "moh", "\u0627\u0644\u0645\u0648\u0647\u0648\u0643" },
            { "mos", "\u0627\u0644\u0645\u0648\u0633\u064a" },
            { "mua", "\u0645\u0646\u062f\u0646\u062c" },
            { "mul", "\u0644\u063a\u0627\u062a \u0645\u062a\u0639\u062f\u062f\u0629" },
            { "mus", "\u0627\u0644\u0643\u0631\u064a\u0643" },
            { "mwl", "\u0627\u0644\u0645\u064a\u0631\u0627\u0646\u062f\u064a\u0632" },
            { "mwr", "\u0627\u0644\u0645\u0627\u0631\u0648\u0627\u0631\u064a\u0629" },
            { "myv", "\u0627\u0644\u0623\u0631\u0632\u064a\u0629" },
            { "mzn", "\u0627\u0644\u0645\u0627\u0632\u0646\u062f\u0631\u0627\u0646\u064a\u0629" },
            { "nan", "\u0645\u064a\u0646-\u0646\u0627\u0646 \u0627\u0644\u0635\u064a\u0646\u064a\u0629" },
            { "nap", "\u0627\u0644\u0646\u0627\u0628\u0648\u0644\u064a\u0629" },
            { "naq", "\u0644\u063a\u0629 \u0627\u0644\u0646\u0627\u0645\u0627" },
            { "nds", "\u0627\u0644\u0623\u0644\u0645\u0627\u0646\u064a\u0629 \u0627\u0644\u0633\u0641\u0644\u0649" },
            { "new", "\u0627\u0644\u0646\u0648\u0627\u0631\u064a\u0629" },
            { "nia", "\u0627\u0644\u0646\u064a\u0627\u0633" },
            { "niu", "\u0627\u0644\u0646\u064a\u0648\u064a" },
            { "nmg", "\u0643\u0648\u0627\u0633\u064a\u0648" },
            { "nnh", "\u0644\u063a\u0629 \u0627\u0644\u0646\u062c\u064a\u0645\u0628\u0648\u0646" },
            { "nog", "\u0627\u0644\u0646\u0648\u062c\u0627\u064a" },
            { "non", "\u0627\u0644\u0646\u0648\u0631\u0633 \u0627\u0644\u0642\u062f\u064a\u0645" },
            { "nqo", metaValue_nqo },
            { "nso", "\u0627\u0644\u0633\u0648\u062a\u0648 \u0627\u0644\u0634\u0645\u0627\u0644\u064a\u0629" },
            { "nus", "\u0627\u0644\u0646\u0648\u064a\u0631" },
            { "nwc", "\u0627\u0644\u0646\u0648\u0627\u0631\u064a\u0629 \u0627\u0644\u062a\u0642\u0644\u064a\u062f\u064a\u0629" },
            { "nym", "\u0627\u0644\u0646\u064a\u0627\u0645\u0648\u064a\u0632\u064a" },
            { "nyn", "\u0627\u0644\u0646\u064a\u0627\u0646\u0643\u0648\u0644" },
            { "nyo", "\u0627\u0644\u0646\u064a\u0648\u0631\u0648" },
            { "nzi", "\u0627\u0644\u0646\u0632\u064a\u0645\u0627" },
            { "ojb", "\u0623\u0648\u062c\u064a\u0628\u0648\u0627 \u0627\u0644\u0634\u0645\u0627\u0644\u064a\u0629 \u0627\u0644\u063a\u0631\u0628\u064a\u0629" },
            { "ojc", "\u0623\u0648\u062c\u064a\u0628\u0648\u0627 \u0627\u0644\u0648\u0633\u0637\u0649" },
            { "ojs", "\u0627\u0644\u0623\u0648\u062c\u064a-\u0643\u0631\u064a" },
            { "ojw", "\u0627\u0644\u0623\u0648\u062c\u064a\u0628\u0648\u0627 \u0627\u0644\u063a\u0631\u0628\u064a\u0629" },
            { "oka", "\u0627\u0644\u0623\u0648\u0643\u0627\u0646\u0627\u063a\u0627\u0646\u064a\u0629" },
            { "osa", "\u0627\u0644\u0623\u0648\u0633\u0627\u062c" },
            { "ota", "\u0627\u0644\u062a\u0631\u0643\u064a\u0629 \u0627\u0644\u0639\u062b\u0645\u0627\u0646\u064a\u0629" },
            { "pag", "\u0627\u0644\u0628\u0627\u0646\u062c\u0627\u0633\u064a\u0646\u0627\u0646" },
            { "pal", "\u0627\u0644\u0628\u0647\u0644\u0648\u064a\u0629" },
            { "pam", "\u0627\u0644\u0628\u0627\u0645\u0628\u0627\u0646\u062c\u0627" },
            { "pap", "\u0627\u0644\u0628\u0627\u0628\u064a\u0627\u0645\u064a\u0646\u062a\u0648" },
            { "pau", "\u0627\u0644\u0628\u0627\u0644\u0648\u0627\u0646" },
            { "pcm", "\u0627\u0644\u0628\u062f\u062c\u0646\u064a\u0629 \u0627\u0644\u0646\u064a\u062c\u064a\u0631\u064a\u0629" },
            { "peo", metaValue_peo },
            { "phn", metaValue_phn },
            { "pis", "\u0628\u064a\u062c\u064a\u0646" },
            { "pon", "\u0627\u0644\u0628\u0648\u0647\u0646\u0628\u064a\u0627\u064a\u0627\u0646" },
            { "pqm", "\u0627\u0644\u0645\u0627\u0644\u064a\u0632\u064a\u062a-\u0628\u0627\u0633\u0627\u0645\u0627\u0643\u0648\u062f\u064a" },
            { "prg", "\u0627\u0644\u0628\u0631\u0648\u0633\u064a\u0627\u0648\u064a\u0629" },
            { "pro", "\u0627\u0644\u0628\u0631\u0648\u0641\u0627\u0646\u0633\u064a\u0629 \u0627\u0644\u0642\u062f\u064a\u0645\u0629" },
            { "quc", "\u0627\u0644\u0643\u064a\u0634\u064a\u0629" },
            { "raj", "\u0627\u0644\u0631\u0627\u062c\u0627\u0633\u062b\u0627\u0646\u064a\u0629" },
            { "rap", "\u0627\u0644\u0631\u0627\u0628\u0627\u0646\u064a" },
            { "rar", "\u0627\u0644\u0631\u0627\u0631\u0648\u062a\u0648\u0646\u062c\u0627\u0646\u064a" },
            { "rhg", "\u0627\u0644\u0631\u0648\u0647\u064a\u0646\u063a\u064a\u0629" },
            { "rof", "\u0627\u0644\u0631\u0648\u0645\u0628\u0648" },
            { "rom", "\u0627\u0644\u063a\u062c\u0631\u064a\u0629" },
            { "rup", "\u0627\u0644\u0623\u0631\u0648\u0645\u0627\u0646\u064a\u0627\u0646" },
            { "rwk", "\u0627\u0644\u0631\u0648\u0627" },
            { "sad", "\u0627\u0644\u0633\u0627\u0646\u062f\u0627\u0648\u064a" },
            { "sah", "\u0627\u0644\u0633\u0627\u062e\u064a\u0651\u0629" },
            { "sam", "\u0627\u0644\u0622\u0631\u0627\u0645\u064a\u0629 \u0627\u0644\u0633\u0627\u0645\u0631\u064a\u0629" },
            { "saq", "\u0633\u0627\u0645\u0628\u0648\u0631\u0648" },
            { "sas", "\u0627\u0644\u0633\u0627\u0633\u0627\u0643" },
            { "sat", "\u0627\u0644\u0633\u0627\u0646\u062a\u0627\u0644\u064a\u0629" },
            { "sba", "\u0646\u0627\u0645\u0628\u064a" },
            { "sbp", "\u0633\u0627\u0646\u063a\u0648" },
            { "scn", "\u0627\u0644\u0635\u0642\u0644\u064a\u0629" },
            { "sco", "\u0627\u0644\u0623\u0633\u0643\u062a\u0644\u0646\u062f\u064a\u0629" },
            { "sdh", "\u0627\u0644\u0643\u0631\u062f\u064a\u0629 \u0627\u0644\u062c\u0646\u0648\u0628\u064a\u0629" },
            { "see", "\u0627\u0644\u0633\u0646\u064a\u0643\u0627" },
            { "seh", "\u0633\u064a\u0646\u0627" },
            { "sel", "\u0627\u0644\u0633\u064a\u0644\u0643\u0628" },
            { "ses", "\u0643\u0648\u064a\u0631\u0627\u0628\u0648\u0631\u0648 \u0633\u064a\u0646\u064a" },
            { "sga", "\u0627\u0644\u0623\u064a\u0631\u0644\u0646\u062f\u064a\u0629 \u0627\u0644\u0642\u062f\u064a\u0645\u0629" },
            { "shi", "\u062a\u0634\u0644\u062d\u064a\u062a" },
            { "shn", "\u0627\u0644\u0634\u0627\u0646" },
            { "shu", "\u0627\u0644\u0639\u0631\u0628\u064a\u0629 \u0627\u0644\u062a\u0634\u0627\u062f\u064a\u0629" },
            { "sid", "\u0627\u0644\u0633\u064a\u062f\u0627\u0645\u0648" },
            { "slh", "\u0644\u0648\u0634\u0648\u062a\u0633\u064a\u062f \u0627\u0644\u062c\u0646\u0648\u0628\u064a\u0629" },
            { "sma", "\u0627\u0644\u0633\u0627\u0645\u064a \u0627\u0644\u062c\u0646\u0648\u0628\u064a" },
            { "smj", "\u0627\u0644\u0644\u0648\u0644 \u0633\u0627\u0645\u064a" },
            { "smn", "\u0627\u0644\u0625\u064a\u0646\u0627\u0631\u064a \u0633\u0627\u0645\u064a" },
            { "sms", "\u0627\u0644\u0633\u0643\u0648\u0644\u062a \u0633\u0627\u0645\u064a" },
            { "snk", "\u0627\u0644\u0633\u0648\u0646\u064a\u0646\u0643" },
            { "sog", "\u0627\u0644\u0633\u0648\u062c\u062f\u064a\u0646" },
            { "srn", "\u0627\u0644\u0633\u0631\u0627\u0646\u0627\u0646 \u062a\u0648\u0646\u062c\u0648" },
            { "srr", "\u0627\u0644\u0633\u0631\u0631" },
            { "ssy", "\u0644\u063a\u0629 \u0627\u0644\u0633\u0627\u0647\u0648" },
            { "str", "\u0633\u062a\u0631\u0627\u064a\u062a\u0633 \u0633\u0627\u0644\u064a\u0634" },
            { "suk", "\u0627\u0644\u0633\u0648\u0643\u0648\u0645\u0627" },
            { "sus", "\u0627\u0644\u0633\u0648\u0633\u0648" },
            { "sux", "\u0627\u0644\u0633\u0648\u0645\u0627\u0631\u064a\u0629" },
            { "swb", "\u0627\u0644\u0642\u0645\u0631\u064a\u0629" },
            { "syc", "\u0633\u0631\u064a\u0627\u0646\u064a\u0629 \u062a\u0642\u0644\u064a\u062f\u064a\u0629" },
            { "syr", metaValue_syr },
            { "tce", "\u0627\u0644\u062a\u0648\u062a\u0634\u0648\u0646 \u0627\u0644\u062c\u0646\u0648\u0628\u064a\u0629" },
            { "tem", "\u0627\u0644\u062a\u064a\u0645\u0646" },
            { "teo", "\u062a\u064a\u0633\u0648" },
            { "ter", "\u0627\u0644\u062a\u064a\u0631\u064a\u0646\u0648" },
            { "tet", "\u0627\u0644\u062a\u064a\u062a\u0645" },
            { "tgx", "\u0627\u0644\u062a\u0627\u063a\u064a\u0634" },
            { "tht", "\u0627\u0644\u062a\u0627\u0644\u062a\u0627\u0646" },
            { "tig", "\u0627\u0644\u062a\u064a\u063a\u0631\u064a\u0629" },
            { "tiv", "\u0627\u0644\u062a\u064a\u0641" },
            { "tkl", "\u0627\u0644\u062a\u0648\u0643\u064a\u0644\u0627\u0648" },
            { "tlh", "\u0627\u0644\u0643\u0644\u064a\u0646\u062c\u0648\u0646" },
            { "tli", "\u0627\u0644\u062a\u0644\u064a\u0646\u063a\u064a\u062a\u064a\u0629" },
            { "tmh", "\u0627\u0644\u062a\u0627\u0645\u0627\u0634\u064a\u0643" },
            { "tog", "\u062a\u0648\u0646\u062c\u0627 - \u0646\u064a\u0627\u0633\u0627" },
            { "tok", "\u0627\u0644\u062a\u0648\u0643\u064a-\u0628\u0648\u0646\u0627" },
            { "tpi", "\u0627\u0644\u062a\u0648\u0643 \u0628\u064a\u0633\u064a\u0646" },
            { "trv", "\u0644\u063a\u0629 \u0627\u0644\u062a\u0627\u0631\u0648\u0643\u0648" },
            { "tsi", "\u0627\u0644\u062a\u0633\u064a\u0645\u0634\u064a\u0627\u0646" },
            { "ttm", "\u0627\u0644\u062a\u0648\u062a\u0634\u0648\u0646 \u0627\u0644\u0634\u0645\u0627\u0644\u064a\u0629" },
            { "tum", "\u0627\u0644\u062a\u0627\u0645\u0628\u0648\u0643\u0627" },
            { "tvl", "\u0627\u0644\u062a\u0648\u0641\u0627\u0644\u0648" },
            { "twq", "\u062a\u0627\u0633\u0627\u0648\u0627\u0642" },
            { "tyv", "\u0627\u0644\u062a\u0648\u0641\u064a\u0629" },
            { "tzm", "\u0627\u0644\u0623\u0645\u0627\u0632\u064a\u063a\u064a\u0629 \u0648\u0633\u0637 \u0627\u0644\u0623\u0637\u0644\u0633" },
            { "udm", "\u0627\u0644\u0623\u062f\u0645\u0631\u062a" },
            { "uga", "\u0627\u0644\u064a\u062c\u0627\u0631\u064a\u062a\u064a\u0643" },
            { "umb", "\u0627\u0644\u0623\u0645\u0628\u0646\u062f\u0648" },
            { "und", "\u0644\u063a\u0629 \u063a\u064a\u0631 \u0645\u0639\u0631\u0648\u0641\u0629" },
            { "vai", metaValue_vai },
            { "vot", "\u0627\u0644\u0641\u0648\u062a\u064a\u0643" },
            { "vun", "\u0627\u0644\u0641\u0648\u0646\u062c\u0648" },
            { "wae", "\u0627\u0644\u0648\u0627\u0644\u0633\u0631" },
            { "wal", "\u0627\u0644\u0648\u0644\u0627\u064a\u0627\u062a\u0627" },
            { "war", "\u0627\u0644\u0648\u0627\u0631\u0627\u064a" },
            { "was", "\u0627\u0644\u0648\u0627\u0634\u0648" },
            { "wbp", "\u0648\u0627\u0631\u0644\u0628\u064a\u0631\u064a" },
            { "wuu", "\u0627\u0644\u0648\u0648 \u0627\u0644\u0635\u064a\u0646\u064a\u0629" },
            { "xal", "\u0627\u0644\u0643\u0627\u0644\u0645\u064a\u0643" },
            { "xog", "\u0627\u0644\u0633\u0648\u063a\u0627" },
            { "yao", "\u0627\u0644\u064a\u0627\u0648" },
            { "yap", "\u0627\u0644\u064a\u0627\u0628\u064a\u0632" },
            { "yav", "\u064a\u0627\u0646\u062c\u0628\u0646" },
            { "ybb", "\u064a\u0645\u0628\u0627" },
            { "yrl", "\u0627\u0644\u0646\u064a\u064a\u0646\u062c\u0627\u062a\u0648" },
            { "yue", "\u0627\u0644\u0643\u064e\u0646\u0652\u062a\u064f\u0648\u0646\u064a\u0629" },
            { "zap", "\u0627\u0644\u0632\u0627\u0628\u0648\u062a\u064a\u0643" },
            { "zbl", "\u0631\u0645\u0648\u0632 \u0627\u0644\u0645\u0639\u0627\u064a\u064a\u0631 \u0627\u0644\u0623\u0633\u0627\u0633\u064a\u0629" },
            { "zen", "\u0627\u0644\u0632\u064a\u0646\u0627\u062c\u0627" },
            { "zgh", "\u0627\u0644\u062a\u0645\u0627\u0632\u064a\u063a\u064a\u0629 \u0627\u0644\u0645\u063a\u0631\u0628\u064a\u0629 \u0627\u0644\u0642\u064a\u0627\u0633\u064a\u0629" },
            { "zun", "\u0627\u0644\u0632\u0648\u0646\u064a\u0629" },
            { "zxx", "\u0628\u062f\u0648\u0646 \u0645\u062d\u062a\u0648\u0649 \u0644\u063a\u0648\u064a" },
            { "zza", "\u0632\u0627\u0632\u0627" },
            { "Adlm", "\u0623\u062f\u0644\u0645" },
            { "Arab", metaValue_ar },
            { "Aran", "\u0646\u0633\u062a\u0639\u0644\u064a\u0642" },
            { "Armn", "\u0627\u0644\u0623\u0631\u0645\u064a\u0646\u064a\u0629" },
            { "Bali", metaValue_pi },
            { "Batk", "\u0627\u0644\u0628\u0627\u062a\u0627\u0643" },
            { "Beng", metaValue_bn },
            { "Blis", "\u0631\u0645\u0648\u0632 \u0628\u0644\u064a\u0633" },
            { "Bopo", "\u0627\u0644\u0628\u0648\u0628\u0648\u0645\u0648\u0641\u0648" },
            { "Brah", "\u0627\u0644\u0647\u0646\u062f\u0648\u0633\u064a\u0629" },
            { "Brai", "\u0627\u0644\u0628\u0631\u0627\u064a\u0644" },
            { "Bugi", "\u0627\u0644\u0628\u062c\u064a\u0646\u064a\u0632" },
            { "Buhd", "\u0627\u0644\u0628\u0647\u064a\u062f\u064a\u0629" },
            { "Cakm", "\u0634\u0627\u0643\u0645\u0627" },
            { "Cans", "\u0645\u0642\u0627\u0637\u0639 \u0643\u0646\u062f\u064a\u0629 \u0623\u0635\u0644\u064a\u0629 \u0645\u0648\u062d\u062f\u0629" },
            { "Cari", "\u0627\u0644\u0643\u0627\u0631\u064a\u0629" },
            { "Cham", "\u0627\u0644\u062a\u0634\u0627\u0645\u064a\u0629" },
            { "Cher", metaValue_chr },
            { "Cirt", "\u0627\u0644\u0633\u064a\u0631\u062b" },
            { "Copt", metaValue_cop },
            { "Cprt", "\u0627\u0644\u0642\u0628\u0631\u0635\u064a\u0629" },
            { "Cyrl", "\u0627\u0644\u0633\u064a\u0631\u064a\u0644\u064a\u0629" },
            { "Cyrs", "\u0627\u0644\u0633\u064a\u0631\u064a\u0644\u064a\u0629 \u0627\u0644\u0633\u0644\u0627\u0641\u064a\u0629 \u0627\u0644\u0643\u0646\u0633\u064a\u0629 \u0627\u0644\u0642\u062f\u064a\u0645\u0629" },
            { "Deva", "\u0627\u0644\u062f\u064a\u0641\u0627\u0646\u0627\u062c\u0627\u0631\u064a" },
            { "Dsrt", "\u0627\u0644\u062f\u064a\u0633\u064a\u0631\u064a\u062a" },
            { "Egyd", "\u0627\u0644\u062f\u064a\u0645\u0648\u0637\u064a\u0642\u064a\u0629" },
            { "Egyh", "\u0627\u0644\u0647\u064a\u0631\u0627\u0637\u064a\u0642\u064a\u0629" },
            { "Egyp", "\u0627\u0644\u0647\u064a\u0631\u0648\u063a\u0644\u064a\u0641\u064a\u0629" },
            { "Ethi", "\u0627\u0644\u0623\u062b\u064a\u0648\u0628\u064a\u0629" },
            { "Geok", "\u0627\u0644\u0623\u0628\u062c\u062f\u064a\u0629 \u0627\u0644\u062c\u0648\u0631\u062c\u064a\u0629 - \u0623\u0633\u0648\u0645\u062a\u0627\u0641\u0631\u0644\u064a \u0648 \u0646\u0633\u062e\u0631\u064a" },
            { "Geor", metaValue_ka },
            { "Glag", "\u0627\u0644\u062c\u0644\u0627\u062c\u0648\u0644\u064a\u062a\u064a\u0643" },
            { "Goth", metaValue_got },
            { "Grek", metaValue_el },
            { "Gujr", "\u0627\u0644\u062a\u0627\u063a\u062c\u0631\u0627\u062a\u064a\u0629" },
            { "Guru", "\u0627\u0644\u062c\u0631\u0645\u062e\u064a" },
            { "Hanb", "\u0647\u0627\u0646\u0628" },
            { "Hang", "\u0627\u0644\u0647\u0627\u0646\u063a\u0648\u0644" },
            { "Hani", "\u0627\u0644\u0647\u0627\u0646" },
            { "Hano", "\u0627\u0644\u0647\u0627\u0646\u0648\u0646\u0648" },
            { "Hans", "\u0627\u0644\u0645\u0628\u0633\u0637\u0629" },
            { "Hant", "\u0627\u0644\u062a\u0642\u0644\u064a\u062f\u064a\u0629" },
            { "Hebr", metaValue_he },
            { "Hira", "\u0627\u0644\u0647\u064a\u0631\u0627\u062c\u0627\u0646\u0627" },
            { "Hmng", "\u0627\u0644\u0628\u0627\u0647\u0648\u0647 \u0647\u0645\u0648\u0646\u062c" },
            { "Hrkt", "\u0623\u0628\u062c\u062f\u064a\u0629 \u0645\u0642\u0637\u0639\u064a\u0629 \u064a\u0627\u0628\u0627\u0646\u064a\u0629" },
            { "Hung", "\u0627\u0644\u0645\u062c\u0631\u064a\u0629 \u0627\u0644\u0642\u062f\u064a\u0645\u0629" },
            { "Inds", "\u0627\u0646\u062f\u0633 - \u0647\u0627\u0631\u0627\u0628\u0627\u0646" },
            { "Ital", "\u0627\u0644\u0625\u064a\u0637\u0627\u0644\u064a\u0629 \u0627\u0644\u0642\u062f\u064a\u0645\u0629" },
            { "Jamo", "\u062c\u0627\u0645\u0648" },
            { "Java", metaValue_jv },
            { "Jpan", metaValue_ja },
            { "Kali", "\u0627\u0644\u0643\u064a\u0627\u0647 \u0644\u0649" },
            { "Kana", "\u0627\u0644\u0643\u062a\u0643\u0627\u0646\u0627" },
            { "Khar", "\u0627\u0644\u062e\u0627\u0631\u0648\u0634\u062a\u0649" },
            { "Khmr", metaValue_km },
            { "Knda", metaValue_kn },
            { "Kore", metaValue_ko },
            { "Lana", "\u0627\u0644\u0627\u0646\u0627" },
            { "Laoo", "\u0627\u0644\u0644\u0627\u0648" },
            { "Latf", "\u0627\u0644\u0644\u0627\u062a\u064a\u0646\u064a\u0629 - \u0645\u062a\u063a\u064a\u0631 \u0641\u0631\u0627\u0643\u062a\u0631" },
            { "Latg", "\u0627\u0644\u0644\u0627\u062a\u064a\u0646\u064a\u0629 - \u0645\u062a\u063a\u064a\u0631 \u063a\u064a\u0644\u0649" },
            { "Latn", metaValue_la },
            { "Lepc", "\u0627\u0644\u0644\u064a\u0628\u062a\u0634\u0627 - \u0631\u0648\u0646\u062c" },
            { "Limb", "\u0627\u0644\u0644\u064a\u0645\u0628\u0648" },
            { "Lina", "\u0627\u0644\u062e\u0637\u064a\u0629 \u0623" },
            { "Linb", "\u0627\u0644\u062e\u0637\u064a\u0629 \u0628" },
            { "Lyci", "\u0627\u0644\u0644\u064a\u0633\u064a\u0629" },
            { "Lydi", "\u0627\u0644\u0644\u064a\u062f\u064a\u0629" },
            { "Mand", "\u0627\u0644\u0645\u0627\u0646\u062f\u0627\u064a\u0646\u064a\u0629" },
            { "Maya", "\u0627\u0644\u0645\u0627\u064a\u0627 \u0627\u0644\u0647\u064a\u0631\u0648\u063a\u0644\u064a\u0641\u064a\u0629" },
            { "Mero", "\u0627\u0644\u0645\u064a\u0631\u0648\u064a\u062a\u064a\u0643" },
            { "Mlym", "\u0627\u0644\u0645\u0627\u0644\u064a\u0627\u0644\u0627\u0645" },
            { "Mong", "\u0627\u0644\u0645\u063a\u0648\u0644\u064a\u0629" },
            { "Moon", "\u0645\u0648\u0646" },
            { "Mtei", "\u0645\u064a\u062a\u064a \u0645\u0627\u064a\u064a\u0643" },
            { "Mymr", "\u0627\u0644\u0645\u064a\u0627\u0646\u0645\u0627\u0631" },
            { "Narb", "\u0627\u0644\u0639\u0631\u0628\u064a\u0629 \u0627\u0644\u0634\u0645\u0627\u0644\u064a\u0629 \u0627\u0644\u0642\u062f\u064a\u0645\u0629" },
            { "Nkoo", metaValue_nqo },
            { "Ogam", "\u0627\u0644\u0623\u0648\u062c\u0647\u0627\u0645" },
            { "Olck", "\u0623\u0648\u0644 \u062a\u0634\u064a\u0643\u064a" },
            { "Orkh", "\u0627\u0644\u0623\u0648\u0631\u062e\u0648\u0646" },
            { "Orya", "\u0627\u0644\u0623\u0648\u0631\u064a\u0627" },
            { "Osma", "\u0627\u0644\u0623\u0648\u0633\u0645\u0627\u0646\u064a\u0627" },
            { "Perm", "\u0627\u0644\u0628\u064a\u0631\u0645\u064a\u0643\u064a\u0629 \u0627\u0644\u0642\u062f\u064a\u0645\u0629" },
            { "Phag", "\u0627\u0644\u0641\u0627\u062c\u0633\u0628\u0627" },
            { "Phnx", metaValue_phn },
            { "Plrd", "\u0627\u0644\u0635\u0648\u062a\u064a\u0627\u062a \u0627\u0644\u062c\u0645\u0627\u0621" },
            { "Qaag", "\u0632\u0648\u062c\u064a\u064a" },
            { "Rohg", "\u0627\u0644\u062d\u0646\u064a\u0641\u064a" },
            { "Roro", "\u0631\u0646\u062c\u0648\u0631\u0646\u062c\u0648" },
            { "Runr", "\u0627\u0644\u0631\u0648\u0646\u064a" },
            { "Sara", "\u0627\u0644\u0633\u0627\u0631\u0627\u062a\u064a" },
            { "Sarb", "\u0627\u0644\u0639\u0631\u0628\u064a\u0629 \u0627\u0644\u062c\u0646\u0648\u0628\u064a\u0629 \u0627\u0644\u0642\u062f\u064a\u0645\u0629" },
            { "Shaw", "\u0627\u0644\u0634\u0648\u0627\u0646\u064a" },
            { "Sinh", "\u0627\u0644\u0633\u064a\u0646\u0647\u0627\u0644\u0627" },
            { "Sund", metaValue_su },
            { "Sylo", "\u0627\u0644\u0633\u064a\u0644\u0648\u062a\u064a \u0646\u0627\u063a\u0631\u064a" },
            { "Syrc", metaValue_syr },
            { "Syre", "\u0627\u0644\u0633\u0631\u064a\u0627\u0646\u064a\u0629 \u0627\u0644\u0623\u0633\u062a\u0631\u0646\u062c\u064a\u0644\u064a\u0629" },
            { "Syrj", "\u0627\u0644\u0633\u0631\u064a\u0627\u0646\u064a\u0629 \u0627\u0644\u063a\u0631\u0628\u064a\u0629" },
            { "Syrn", "\u0627\u0644\u0633\u0631\u064a\u0627\u0646\u064a\u0629 \u0627\u0644\u0634\u0631\u0642\u064a\u0629" },
            { "Tagb", "\u0627\u0644\u062a\u0627\u062c\u0628\u0627\u0646\u0648\u0627" },
            { "Tale", "\u0627\u0644\u062a\u0627\u064a \u0644\u064a" },
            { "Talu", "\u0627\u0644\u062a\u0627\u0649 \u0644\u0649 \u0627\u0644\u062c\u062f\u064a\u062f" },
            { "Taml", metaValue_ta },
            { "Telu", "\u0627\u0644\u062a\u064a\u0644\u062c\u0648" },
            { "Teng", "\u0627\u0644\u062a\u064a\u0646\u062c\u0648\u0627\u0631" },
            { "Tfng", "\u0627\u0644\u062a\u064a\u0641\u064a\u0646\u0627\u063a" },
            { "Tglg", "\u0627\u0644\u062a\u063a\u0627\u0644\u0648\u063a\u064a\u0629" },
            { "Thaa", "\u0627\u0644\u062b\u0639\u0646\u0629" },
            { "Thai", metaValue_th },
            { "Tibt", metaValue_bo },
            { "Ugar", "\u0627\u0644\u0623\u062c\u0627\u0631\u064a\u062a\u064a\u0643\u064a\u0629" },
            { "Vaii", metaValue_vai },
            { "Visp", "\u0627\u0644\u0643\u0644\u0627\u0645 \u0627\u0644\u0645\u0631\u0626\u064a" },
            { "Xpeo", metaValue_peo },
            { "Xsux", "\u0627\u0644\u0643\u062a\u0627\u0628\u0629 \u0627\u0644\u0645\u0633\u0645\u0627\u0631\u064a\u0629 \u0627\u0644\u0623\u0643\u062f\u064a\u0629 \u0627\u0644\u0633\u0648\u0645\u0631\u064a\u0629" },
            { "Yiii", "\u0627\u0644\u064a\u064a" },
            { "Zinh", "\u0627\u0644\u0645\u0648\u0631\u0648\u062b" },
            { "Zmth", "\u062a\u062f\u0648\u064a\u0646 \u0631\u064a\u0627\u0636\u064a" },
            { "Zsye", "\u0625\u064a\u0645\u0648\u062c\u064a" },
            { "Zsym", "\u0631\u0645\u0648\u0632" },
            { "Zxxx", "\u063a\u064a\u0631 \u0645\u0643\u062a\u0648\u0628" },
            { "Zyyy", "\u0639\u0627\u0645" },
            { "Zzzz", "\u0646\u0638\u0627\u0645 \u0643\u062a\u0627\u0628\u0629 \u063a\u064a\u0631 \u0645\u0639\u0631\u0648\u0641" },
            { "de_AT", "\u0627\u0644\u0623\u0644\u0645\u0627\u0646\u064a\u0629 \u0627\u0644\u0646\u0645\u0633\u0627\u0648\u064a\u0629" },
            { "de_CH", "\u0627\u0644\u0623\u0644\u0645\u0627\u0646\u064a\u0629 \u0627\u0644\u0639\u0644\u064a\u0627 \u0627\u0644\u0633\u0648\u064a\u0633\u0631\u064a\u0629" },
            { "en_AU", "\u0627\u0644\u0625\u0646\u062c\u0644\u064a\u0632\u064a\u0629 \u0627\u0644\u0623\u0633\u062a\u0631\u0627\u0644\u064a\u0629" },
            { "en_CA", "\u0627\u0644\u0625\u0646\u062c\u0644\u064a\u0632\u064a\u0629 \u0627\u0644\u0643\u0646\u062f\u064a\u0629" },
            { "en_GB", "\u0627\u0644\u0625\u0646\u062c\u0644\u064a\u0632\u064a\u0629 \u0627\u0644\u0628\u0631\u064a\u0637\u0627\u0646\u064a\u0629" },
            { "en_US", "\u0627\u0644\u0625\u0646\u062c\u0644\u064a\u0632\u064a\u0629 \u0627\u0644\u0623\u0645\u0631\u064a\u0643\u064a\u0629" },
            { "es_ES", "\u0627\u0644\u0625\u0633\u0628\u0627\u0646\u064a\u0629 \u0627\u0644\u0623\u0648\u0631\u0648\u0628\u064a\u0629" },
            { "es_MX", "\u0627\u0644\u0625\u0633\u0628\u0627\u0646\u064a\u0629 \u0627\u0644\u0645\u0643\u0633\u064a\u0643\u064a\u0629" },
            { "fa_AF", "\u0627\u0644\u062f\u0627\u0631\u064a\u0629" },
            { "fr_CA", "\u0627\u0644\u0641\u0631\u0646\u0633\u064a\u0629 \u0627\u0644\u0643\u0646\u062f\u064a\u0629" },
            { "fr_CH", "\u0627\u0644\u0641\u0631\u0646\u0633\u064a\u0629 \u0627\u0644\u0633\u0648\u064a\u0633\u0631\u064a\u0629" },
            { "nl_BE", "\u0627\u0644\u0641\u0644\u0645\u0646\u0643\u064a\u0629" },
            { "pt_BR", "\u0627\u0644\u0628\u0631\u062a\u063a\u0627\u0644\u064a\u0629 \u0627\u0644\u0628\u0631\u0627\u0632\u064a\u0644\u064a\u0629" },
            { "pt_PT", "\u0627\u0644\u0628\u0631\u062a\u063a\u0627\u0644\u064a\u0629 \u0627\u0644\u0623\u0648\u0631\u0648\u0628\u064a\u0629" },
            { "ro_MD", "\u0627\u0644\u0645\u0648\u0644\u062f\u0648\u0641\u064a\u0629" },
            { "sw_CD", "\u0627\u0644\u0643\u0648\u0646\u063a\u0648 \u0627\u0644\u0633\u0648\u0627\u062d\u0644\u064a\u0629" },
            { "%%1901", "\u0627\u0644\u062a\u0647\u062c\u0626\u0629 \u0627\u0644\u0623\u0644\u0645\u0627\u0646\u064a\u0629 \u0627\u0644\u062a\u0642\u0644\u064a\u062f\u064a\u0629" },
            { "%%1996", "\u0627\u0644\u062a\u0647\u062c\u0626\u0629 \u0627\u0644\u0623\u0644\u0645\u0627\u0646\u064a\u0629 \u0644\u0639\u0627\u0645 1996" },
            { "ar_001", "\u0627\u0644\u0639\u0631\u0628\u064a\u0629 \u0627\u0644\u0641\u0635\u062d\u0649 \u0627\u0644\u062d\u062f\u064a\u062b\u0629" },
            { "es_419", "\u0627\u0644\u0625\u0633\u0628\u0627\u0646\u064a\u0629 \u0623\u0645\u0631\u064a\u0643\u0627 \u0627\u0644\u0644\u0627\u062a\u064a\u0646\u064a\u0629" },
            { "key.ca", "\u0627\u0644\u062a\u0642\u0648\u064a\u0645" },
            { "key.cf", "\u062a\u0646\u0633\u064a\u0642 \u0627\u0644\u0639\u0645\u0644\u0629" },
            { "key.co", "\u062a\u0631\u062a\u064a\u0628 \u0627\u0644\u0641\u0631\u0632" },
            { "key.cu", "\u0627\u0644\u0639\u0645\u0644\u0629" },
            { "key.hc", "\u0646\u0638\u0627\u0645 \u0627\u0644\u062a\u0648\u0642\u064a\u062a (12 \u0645\u0642\u0627\u0628\u0644 24)" },
            { "key.lb", "\u0646\u0645\u0637 \u0641\u0635\u0644 \u0627\u0644\u0633\u0637\u0648\u0631" },
            { "key.ms", "\u0646\u0638\u0627\u0645 \u0627\u0644\u0642\u064a\u0627\u0633" },
            { "key.nu", "\u0627\u0644\u0623\u0631\u0642\u0627\u0645" },
            { "key.tz", "\u0627\u0644\u0645\u0646\u0637\u0642\u0629 \u0627\u0644\u0632\u0645\u0646\u064a\u0629" },
            { "key.va", "\u0645\u062a\u063a\u064a\u0631\u0627\u062a \u0627\u0644\u0644\u063a\u0629" },
            { "nds_NL", "\u0627\u0644\u0633\u0643\u0633\u0648\u0646\u064a\u0629 \u0627\u0644\u0633\u0641\u0644\u0649" },
            { "%%KKCOR", "\u0627\u0644\u062a\u0647\u062c\u0626\u0629 \u0627\u0644\u0639\u0627\u0645\u0629" },
            { "%%NEDIS", "\u0644\u0647\u062c\u0629 \u0646\u0627\u062a\u064a\u0633\u0648\u0646" },
            { "%%POSIX", "\u062d\u0627\u0633\u0648\u0628" },
            { "%%UCCOR", "\u0627\u0644\u062a\u0647\u062c\u0626\u0629 \u0627\u0644\u0645\u0648\u062d\u062f\u0629" },
            { "zh_Hans", "\u0627\u0644\u0635\u064a\u0646\u064a\u0629 \u0627\u0644\u0645\u0628\u0633\u0637\u0629" },
            { "zh_Hant", "\u0627\u0644\u0635\u064a\u0646\u064a\u0629 \u0627\u0644\u062a\u0642\u0644\u064a\u062f\u064a\u0629" },
            { "%%PINYIN", "\u0628\u064a\u0646\u064a\u064a\u0646 \u0628\u0627\u0644\u0644\u0627\u062a\u064a\u0646\u064a\u0629" },
            { "%%UCRCOR", "\u0627\u0644\u062a\u0647\u062c\u0626\u0629 \u0627\u0644\u0645\u0631\u0627\u062c\u0639\u0629 \u0627\u0644\u0645\u0648\u062d\u062f\u0629" },
            { "%%AREVELA", "\u0623\u0631\u0645\u0646\u064a\u0629 \u0634\u0631\u0642\u064a\u0629" },
            { "%%AREVMDA", "\u0623\u0631\u0645\u0646\u064a\u0629 \u063a\u0631\u0628\u064a\u0629" },
            { "%%MONOTON", "\u0623\u062d\u0627\u062f\u064a \u0627\u0644\u0646\u063a\u0645\u0629" },
            { "%%POLYTON", "\u0645\u062a\u0639\u062f\u062f \u0627\u0644\u0646\u063a\u0645\u0627\u062a" },
            { "%%REVISED", "\u062a\u0647\u062c\u0626\u0629 \u062a\u0645\u062a \u0645\u0631\u0627\u062c\u0639\u062a\u0647\u0627" },
            { "%%1959ACAD", "\u0623\u0643\u0627\u062f\u064a\u0645\u064a" },
            { "%%BAKU1926", "\u0627\u0644\u0623\u0628\u062c\u062f\u064a\u0629 \u0627\u0644\u062a\u0631\u0643\u064a\u0629 \u0627\u0644\u0644\u0627\u062a\u064a\u0646\u064a\u0629 \u0627\u0644\u0645\u0648\u062d\u062f\u0629" },
            { "%%SCOTLAND", "\u0627\u0644\u0625\u0646\u062c\u0644\u064a\u0632\u064a\u0629 \u0627\u0644\u0623\u0633\u0643\u062a\u0644\u0646\u062f\u0646\u064a\u0629 \u0627\u0644\u0631\u0633\u0645\u064a\u0629" },
            { "%%VALENCIA", "\u0628\u0644\u0646\u0633\u064a\u0629" },
            { "%%WADEGILE", "\u0627\u0644\u0645\u0646\u062f\u0631\u064a\u0646 \u0628\u0627\u0644\u0644\u0627\u062a\u064a\u0646\u064a\u0629 - \u0648\u064a\u062f\u2013\u062c\u064a\u0644\u0632" },
            { "type.ca.roc", "\u062a\u0642\u0648\u064a\u0645 \u0645\u064a\u0646\u062c\u0648" },
            { "type.hc.h11", "\u0646\u0638\u0627\u0645 12 \u0633\u0627\u0639\u0629 (0\u201311)" },
            { "type.hc.h12", "\u0646\u0638\u0627\u0645 12 \u0633\u0627\u0639\u0629 (1\u201312)" },
            { "type.hc.h23", "\u0646\u0638\u0627\u0645 24 \u0633\u0627\u0639\u0629 (0\u201323)" },
            { "type.hc.h24", "\u0646\u0638\u0627\u0645 24 \u0633\u0627\u0639\u0629 (1\u201324)" },
            { "type.m0.bgn", "\u0628\u064a \u062c\u064a \u0625\u0646" },
            { "type.nu.arab", "\u0627\u0644\u0623\u0631\u0642\u0627\u0645 \u0627\u0644\u0639\u0631\u0628\u064a\u0629 \u0627\u0644\u0647\u0646\u062f\u064a\u0629" },
            { "type.nu.armn", "\u0627\u0644\u0623\u0631\u0642\u0627\u0645 \u0627\u0644\u0623\u0631\u0645\u064a\u0646\u064a\u0629" },
            { "type.nu.beng", "\u0627\u0644\u0623\u0631\u0642\u0627\u0645 \u0627\u0644\u0628\u0646\u063a\u0627\u0644\u064a\u0629" },
            { "type.nu.cakm", "\u0623\u0631\u0642\u0627\u0645 \u062a\u0634\u0627\u0643\u0645\u0627" },
            { "type.nu.deva", "\u0627\u0644\u0623\u0631\u0642\u0627\u0645 \u0627\u0644\u062f\u064a\u0641\u0627\u0646\u063a\u0627\u0631\u064a\u0629" },
            { "type.nu.ethi", "\u0627\u0644\u0623\u0631\u0642\u0627\u0645 \u0627\u0644\u0625\u062b\u064a\u0648\u0628\u064a\u0629" },
            { "type.nu.geor", "\u0627\u0644\u0623\u0631\u0642\u0627\u0645 \u0627\u0644\u062c\u0648\u0631\u062c\u064a\u0629" },
            { "type.nu.grek", "\u0627\u0644\u0623\u0631\u0642\u0627\u0645 \u0627\u0644\u064a\u0648\u0646\u0627\u0646\u064a\u0629" },
            { "type.nu.gujr", "\u0627\u0644\u0623\u0631\u0642\u0627\u0645 \u0627\u0644\u063a\u0648\u062c\u0627\u0631\u0627\u062a\u064a\u0629" },
            { "type.nu.guru", "\u0627\u0644\u0623\u0631\u0642\u0627\u0645 \u0627\u0644\u063a\u0648\u0631\u0645\u0648\u062e\u064a\u0629" },
            { "type.nu.hans", "\u0627\u0644\u0623\u0631\u0642\u0627\u0645 \u0627\u0644\u0635\u064a\u0646\u064a\u0629 \u0627\u0644\u0645\u0628\u0633\u0637\u0629" },
            { "type.nu.hant", "\u0627\u0644\u0623\u0631\u0642\u0627\u0645 \u0627\u0644\u0635\u064a\u0646\u064a\u0629 \u0627\u0644\u062a\u0642\u0644\u064a\u062f\u064a\u0629" },
            { "type.nu.hebr", "\u0627\u0644\u0623\u0631\u0642\u0627\u0645 \u0627\u0644\u0639\u0628\u0631\u064a\u0629" },
            { "type.nu.java", "\u0627\u0644\u0623\u0631\u0642\u0627\u0645 \u0627\u0644\u062c\u0627\u0648\u064a\u0629" },
            { "type.nu.jpan", "\u0627\u0644\u0623\u0631\u0642\u0627\u0645 \u0627\u0644\u064a\u0627\u0628\u0627\u0646\u064a\u0629" },
            { "type.nu.khmr", "\u0627\u0644\u0623\u0631\u0642\u0627\u0645 \u0627\u0644\u062e\u064a\u0645\u0631\u064a\u0629" },
            { "type.nu.knda", "\u0623\u0631\u0642\u0627\u0645 \u0627\u0644\u0643\u0627\u0646\u0627\u062f\u0627" },
            { "type.nu.laoo", "\u0627\u0644\u0623\u0631\u0642\u0627\u0645 \u0627\u0644\u0644\u0627\u0648\u064a\u0629" },
            { "type.nu.latn", "\u0627\u0644\u0623\u0631\u0642\u0627\u0645 \u0627\u0644\u063a\u0631\u0628\u064a\u0629" },
            { "type.nu.mlym", "\u0627\u0644\u0623\u0631\u0642\u0627\u0645 \u0627\u0644\u0645\u0644\u0627\u064a\u0644\u0627\u0645\u064a\u0629" },
            { "type.nu.mong", "\u0627\u0644\u0623\u0631\u0642\u0627\u0645 \u0627\u0644\u0645\u063a\u0648\u0644\u064a\u0629" },
            { "type.nu.mtei", "\u0623\u0631\u0642\u0627\u0645 \u0645\u064a\u062a\u064a" },
            { "type.nu.mymr", "\u0623\u0631\u0642\u0627\u0645 \u0645\u064a\u0627\u0646\u0645\u0627\u0631" },
            { "type.nu.olck", "\u0623\u0631\u0642\u0627\u0645 \u0623\u064f\u0648\u0644 \u062a\u0634\u064a\u0643\u064a" },
            { "type.nu.orya", "\u0623\u0631\u0642\u0627\u0645 \u0627\u0644\u0623\u0648\u0631\u064a\u0627" },
            { "type.nu.taml", "\u0627\u0644\u0623\u0631\u0642\u0627\u0645 \u0627\u0644\u062a\u0627\u0645\u064a\u0644\u064a\u0629 \u0627\u0644\u062a\u0642\u0644\u064a\u062f\u064a\u0629" },
            { "type.nu.telu", "\u0627\u0644\u0623\u0631\u0642\u0627\u0645 \u0627\u0644\u062a\u064a\u0644\u0648\u063a\u0648\u064a\u0629" },
            { "type.nu.thai", "\u0627\u0644\u0623\u0631\u0642\u0627\u0645 \u0627\u0644\u062a\u0627\u064a\u0644\u0627\u0646\u062f\u064a\u0629" },
            { "type.nu.tibt", "\u0627\u0644\u0623\u0631\u0642\u0627\u0645 \u0627\u0644\u062a\u0628\u062a\u064a\u0629" },
            { "type.nu.vaii", "\u0623\u0631\u0642\u0627\u0645 \u0641\u0627\u064a" },
            { "type.ca.dangi", "\u062a\u0642\u0648\u064a\u0645 \u062f\u0627\u0646\u062c\u064a" },
            { "type.co.ducet", "\u062a\u0631\u062a\u064a\u0628 \u0641\u0631\u0632 Unicode \u0627\u0644\u0627\u0641\u062a\u0631\u0627\u0636\u064a" },
            { "type.lb.loose", "\u0646\u0645\u0637 \u0641\u0635\u0644 \u0627\u0644\u0633\u0637\u0648\u0631: \u0645\u062a\u0628\u0627\u0639\u062f" },
            { "type.nu.roman", "\u0627\u0644\u0623\u0631\u0642\u0627\u0645 \u0627\u0644\u0631\u0648\u0645\u0627\u0646\u064a\u0629" },
            { "type.ca.coptic", "\u0627\u0644\u062a\u0642\u0648\u064a\u0645 \u0627\u0644\u0642\u0628\u0637\u064a" },
            { "type.ca.hebrew", "\u0627\u0644\u062a\u0642\u0648\u064a\u0645 \u0627\u0644\u0639\u0628\u0631\u064a" },
            { "type.ca.indian", "\u0627\u0644\u062a\u0642\u0648\u064a\u0645 \u0627\u0644\u0642\u0648\u0645\u064a \u0627\u0644\u0647\u0646\u062f\u064a" },
            { "type.co.compat", "\u062a\u0631\u062a\u064a\u0628 \u0627\u0644\u0641\u0631\u0632 \u0627\u0644\u0633\u0627\u0628\u0642: \u0644\u0644\u062a\u0648\u0627\u0641\u0642" },
            { "type.co.pinyin", "\u0627\u0644\u062a\u0631\u062a\u064a\u0628 \u062d\u0633\u0628 \u0646\u0638\u0627\u0645 \u0628\u0646\u064a\u064a\u0646 \u0627\u0644\u0635\u064a\u0646\u064a" },
            { "type.co.search", "\u0628\u062d\u062b \u0644\u0623\u063a\u0631\u0627\u0636 \u0639\u0627\u0645\u0629" },
            { "type.co.stroke", "\u0627\u0644\u062a\u0631\u062a\u064a\u0628 \u062d\u0633\u0628 \u0646\u0638\u0627\u0645 \u0643\u062a\u0627\u0628\u0629 \u0627\u0644\u0645\u062c\u0645\u0648\u0639 \u0627\u0644\u0635\u064a\u0646\u064a" },
            { "type.co.unihan", "\u0627\u0644\u062a\u0631\u062a\u064a\u0628 \u062d\u0633\u0628 \u0646\u0638\u0627\u0645 \u0627\u0644\u0643\u062a\u0627\u0628\u0629 \u0628\u0627\u0644\u062c\u0630\u0631 \u0648\u0627\u0644\u0645\u062c\u0645\u0648\u0639" },
            { "type.co.zhuyin", "\u0627\u0644\u062a\u0631\u062a\u064a\u0628 \u062d\u0633\u0628 \u0646\u0638\u0627\u0645 \u0628\u0648\u0628\u0648\u0645\u0648\u0641\u0648" },
            { "type.d0.fwidth", "\u0639\u0631\u0636 \u0643\u0627\u0645\u0644" },
            { "type.d0.hwidth", "\u0646\u0635\u0641 \u0627\u0644\u0639\u0631\u0636" },
            { "type.lb.normal", "\u0646\u0645\u0637 \u0641\u0635\u0644 \u0627\u0644\u0633\u0637\u0648\u0631: \u0639\u0627\u062f\u064a" },
            { "type.lb.strict", "\u0646\u0645\u0637 \u0641\u0635\u0644 \u0627\u0644\u0633\u0637\u0648\u0631: \u0645\u062a\u0642\u0627\u0631\u0628" },
            { "type.m0.ungegn", "\u064a\u0648 \u0625\u0646 \u062c\u064a \u0625\u064a \u062c\u064a \u0625\u0646" },
            { "type.ms.metric", "\u0627\u0644\u0646\u0638\u0627\u0645 \u0627\u0644\u0645\u062a\u0631\u064a" },
            { "type.nu.native", "\u0627\u0644\u0623\u0631\u0642\u0627\u0645 \u0627\u0644\u0623\u0635\u0644\u064a\u0629" },
            { "type.ca.chinese", "\u0627\u0644\u062a\u0642\u0648\u064a\u0645 \u0627\u0644\u0635\u064a\u0646\u064a" },
            { "type.ca.islamic", "\u0627\u0644\u062a\u0642\u0648\u064a\u0645 \u0627\u0644\u0647\u062c\u0631\u064a" },
            { "type.ca.iso8601", "\u062a\u0642\u0648\u064a\u0645 ISO-8601" },
            { "type.ca.persian", "\u0627\u0644\u062a\u0642\u0648\u064a\u0645 \u0627\u0644\u0641\u0627\u0631\u0633\u064a" },
            { "type.cf.account", "\u062a\u0646\u0633\u064a\u0642 \u0627\u0644\u0639\u0645\u0644\u0629 \u0644\u0644\u062d\u0633\u0627\u0628\u0627\u062a" },
            { "type.co.big5han", "\u0627\u0644\u062a\u0631\u062a\u064a\u0628 \u062d\u0633\u0628 \u0627\u0644\u0644\u063a\u0629 \u0627\u0644\u0635\u064a\u0646\u064a\u0629 \u0627\u0644\u062a\u0642\u0644\u064a\u062f\u064a\u0629 (Big5)" },
            { "type.d0.npinyin", "\u0631\u0642\u0645\u064a" },
            { "type.nu.arabext", "\u0627\u0644\u0623\u0631\u0642\u0627\u0645 \u0627\u0644\u0639\u0631\u0628\u064a\u0629 \u0627\u0644\u0647\u0646\u062f\u064a\u0629 \u0627\u0644\u0645\u0645\u062a\u062f\u0629" },
            { "type.nu.armnlow", "\u0627\u0644\u0623\u0631\u0642\u0627\u0645 \u0627\u0644\u0623\u0631\u0645\u064a\u0646\u064a\u0629 \u0627\u0644\u0635\u063a\u064a\u0631\u0629" },
            { "type.nu.finance", "\u0627\u0644\u0623\u0631\u0642\u0627\u0645 \u0627\u0644\u0645\u0627\u0644\u064a\u0629" },
            { "type.nu.greklow", "\u0627\u0644\u0623\u0631\u0642\u0627\u0645 \u0627\u0644\u064a\u0648\u0646\u0627\u0646\u064a\u0629 \u0627\u0644\u0635\u063a\u064a\u0631\u0629" },
            { "type.nu.hanidec", "\u0627\u0644\u0623\u0631\u0642\u0627\u0645 \u0627\u0644\u0639\u0634\u0631\u064a\u0629 \u0627\u0644\u0635\u064a\u0646\u064a\u0629" },
            { "type.nu.hansfin", "\u0627\u0644\u0623\u0631\u0642\u0627\u0645 \u0627\u0644\u0645\u0627\u0644\u064a\u0629 \u0627\u0644\u0635\u064a\u0646\u064a\u0629 \u0627\u0644\u0645\u0628\u0633\u0637\u0629" },
            { "type.nu.hantfin", "\u0627\u0644\u0623\u0631\u0642\u0627\u0645 \u0627\u0644\u0645\u0627\u0644\u064a\u0629 \u0627\u0644\u0635\u064a\u0646\u064a\u0629 \u0627\u0644\u062a\u0642\u0644\u064a\u062f\u064a\u0629" },
            { "type.nu.jpanfin", "\u0627\u0644\u0623\u0631\u0642\u0627\u0645 \u0627\u0644\u0645\u0627\u0644\u064a\u0629 \u0627\u0644\u064a\u0627\u0628\u0627\u0646\u064a\u0629" },
            { "type.nu.tamldec", "\u0627\u0644\u0623\u0631\u0642\u0627\u0645 \u0627\u0644\u062a\u0627\u0645\u064a\u0644\u064a\u0629" },
            { "type.ca.buddhist", "\u0627\u0644\u062a\u0642\u0648\u064a\u0645 \u0627\u0644\u0628\u0648\u0630\u064a" },
            { "type.ca.ethiopic", "\u0627\u0644\u062a\u0642\u0648\u064a\u0645 \u0627\u0644\u0625\u062b\u064a\u0648\u0628\u064a" },
            { "type.ca.japanese", "\u0627\u0644\u062a\u0642\u0648\u064a\u0645 \u0627\u0644\u064a\u0627\u0628\u0627\u0646\u064a" },
            { "type.cf.standard", "\u062a\u0646\u0633\u064a\u0642 \u0627\u0644\u0639\u0645\u0644\u0629 \u0627\u0644\u0642\u064a\u0627\u0633\u064a" },
            { "type.co.phonetic", "\u0627\u0644\u062a\u0631\u062a\u064a\u0628 \u062d\u0633\u0628 \u0627\u0644\u0644\u0641\u0638" },
            { "type.co.reformed", "\u0627\u0644\u062a\u0631\u062a\u064a\u0628 \u0627\u0644\u0645\u062d\u0633\u064e\u0651\u0646" },
            { "type.co.searchjl", "\u0628\u062d\u062b \u0628\u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u062d\u0631\u0641 \u0627\u0644\u0647\u0627\u0646\u063a\u0648\u0644 \u0627\u0644\u0633\u0627\u0643\u0646 \u0627\u0644\u0623\u0648\u0644" },
            { "type.co.standard", "\u062a\u0631\u062a\u064a\u0628 \u0627\u0644\u0641\u0631\u0632 \u0627\u0644\u0642\u064a\u0627\u0633\u064a" },
            { "type.ms.uksystem", "\u0646\u0638\u0627\u0645 \u0627\u0644\u0642\u064a\u0627\u0633 \u0627\u0644\u0628\u0631\u064a\u0637\u0627\u0646\u064a" },
            { "type.ms.ussystem", "\u0646\u0638\u0627\u0645 \u0627\u0644\u0642\u064a\u0627\u0633 \u0627\u0644\u0623\u0645\u0631\u064a\u0643\u064a" },
            { "type.nu.fullwide", "\u0623\u0631\u0642\u0627\u0645 \u0643\u0627\u0645\u0644\u0629 \u0627\u0644\u0639\u0631\u0636" },
            { "type.nu.romanlow", "\u0627\u0644\u0623\u0631\u0642\u0627\u0645 \u0627\u0644\u0631\u0648\u0645\u0627\u0646\u064a\u0629 \u0627\u0644\u0635\u063a\u064a\u0631\u0629" },
            { "type.ca.gregorian", "\u0627\u0644\u062a\u0642\u0648\u064a\u0645 \u0627\u0644\u0645\u064a\u0644\u0627\u062f\u064a" },
            { "type.co.gb2312han", "\u0627\u0644\u062a\u0631\u062a\u064a\u0628 \u062d\u0633\u0628 \u0627\u0644\u0644\u063a\u0629 \u0627\u0644\u0635\u064a\u0646\u064a\u0629 \u0627\u0644\u0645\u0628\u0633\u0651\u0637\u0629 (GB2312)" },
            { "type.co.phonebook", "\u0627\u0644\u062a\u0631\u062a\u064a\u0628 \u062d\u0633\u0628 \u062f\u0644\u064a\u0644 \u0627\u0644\u0647\u0627\u062a\u0641" },
            { "type.co.dictionary", "\u0627\u0644\u062a\u0631\u062a\u064a\u0628 \u062d\u0633\u0628 \u0627\u0644\u0642\u0627\u0645\u0648\u0633" },
            { "type.co.traditional", "\u062a\u0631\u062a\u064a\u0628 \u062a\u0642\u0644\u064a\u062f\u064a" },
            { "type.nu.traditional", "\u0623\u0631\u0642\u0627\u0645 \u062a\u0642\u0644\u064a\u062f\u064a\u0629" },
            { "type.ca.islamic-rgsa", "\u0627\u0644\u062a\u0642\u0648\u064a\u0645 \u0627\u0644\u0625\u0633\u0644\u0627\u0645\u064a (\u0627\u0644\u0633\u0639\u0648\u062f\u064a\u0629 - \u0627\u0644\u0631\u0624\u064a\u0629)" },
            { "type.ca.islamic-tbla", "\u0627\u0644\u062a\u0642\u0648\u064a\u0645 \u0627\u0644\u0625\u0633\u0644\u0627\u0645\u064a (\u0627\u0644\u062d\u0633\u0627\u0628\u0627\u062a \u0627\u0644\u0641\u0644\u0643\u064a\u0629)" },
            { "type.ca.islamic-civil", "\u0627\u0644\u062a\u0642\u0648\u064a\u0645 \u0627\u0644\u0625\u0633\u0644\u0627\u0645\u064a \u0627\u0644\u0645\u062f\u0646\u064a" },
            { "ListCompositionPattern", "{0}\u060c {1}" },
            { "type.ca.islamic-umalqura", "\u0627\u0644\u062a\u0642\u0648\u064a\u0645 \u0627\u0644\u0625\u0633\u0644\u0627\u0645\u064a (\u0623\u0645 \u0627\u0644\u0642\u0631\u0649)" },
            { "type.ca.ethiopic-amete-alem", "\u062a\u0642\u0648\u064a\u0645 \u0623\u0645\u064a\u062a\u064a \u0623\u0644\u064a\u0645 \u0627\u0644\u0625\u062b\u064a\u0648\u0628\u064a" },
        };
        return data;
    }
}
