
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// This file is generated by the Perl script ssqls.pl.  Do not modify
// it directly.  Change the script instead.
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

#if !defined(MYSQLPP_SSQLS_H)
#define MYSQLPP_SSQLS_H

#include "noexceptions.h"
#include "sql_types.h"

#if !defined(MYSQLPP_SSQLS_COMPATIBLE)
#	error Your compiler is not compatible with the SSQLS feature!
#endif

#include <string>

#include <math.h>

// Smallest difference between two floating point numbers recognized
// in making comparisons.  If the absolute delta is under this
// threshold, the two values are considered equal.  You can either
// override this permanently by changing ssqls.pl, or you can do it
// on a case-by-case basis at compile time by defining this to another
// value before #including this header.
#if !defined(MYSQLPP_FP_MIN_DELTA)
#	define MYSQLPP_FP_MIN_DELTA 0.00001
#endif

namespace mysqlpp {

enum sql_dummy_type { sql_dummy };

#ifdef MYSQLPP_SSQLS_NO_STATICS
#	define MYSQLPP_SSQLS_CONDITIONAL_STATICS(...)
#else
#	define MYSQLPP_SSQLS_CONDITIONAL_STATICS(...) __VA_ARGS__
#endif

#define MYSQLPP_SSQLS_MAX_MEMBERS 25


inline int sql_cmp(const Date& a, const Date& b)
{
	return a.compare(b);
}

inline int sql_cmp(const DateTime& a, const DateTime& b)
{
	return a.compare(b);
}

inline int sql_cmp(const Time& a, const Time& b)
{
	return a.compare(b);
}

inline int sql_cmp(const String& a, const String& b)
{
	return a.compare(b);
}

inline int sql_cmp(const std::string& a, const std::string& b)
{
	return a.compare(b);
}

inline int sql_cmp(signed char a, signed char b)
{
	return a - b;
}

inline int sql_cmp(unsigned char a, unsigned char b)
{
	return a - b;
}

inline int sql_cmp(sql_tinyint a, sql_tinyint b)
{
	return a - b;
}

inline int sql_cmp(sql_tinyint_unsigned a, sql_tinyint_unsigned b)
{
	return a - b;
}

inline int sql_cmp(signed int a, signed int b)
{
	return a - b;
}

inline int sql_cmp(unsigned a, unsigned b)
{
	return a - b;
}

inline int sql_cmp(signed short a, signed short b)
{
	return a - b;
}

inline int sql_cmp(unsigned short a, unsigned short b)
{
	return a - b;
}

inline int sql_cmp(signed long a, signed long b)
{
	return a - b;
}

inline int sql_cmp(unsigned long a, unsigned long b)
{
	return a - b;
}

inline int sql_cmp(longlong a, longlong b) 
{
	if (a == b) return 0;
	if (a <  b) return -1;
	return 1;
}

inline int sql_cmp(ulonglong a, ulonglong b) 
{
	if (a == b) return 0;
	if (a <  b) return -1;
	return 1;
}

inline int sql_cmp(double a, double b) 
{
	if (fabs(a - b) < MYSQLPP_FP_MIN_DELTA) return 0;
	if (a <  b) return -1;
	return 1;
}

inline int sql_cmp(float a, float b) 
{
	if (fabs(a - b) < MYSQLPP_FP_MIN_DELTA) return 0;
	if (a <  b) return -1;
	return 1;
}

template <typename T>
inline int sql_cmp(const mysqlpp::Null<T>& a, const mysqlpp::Null<T>& b) 
{
	if (a == b) return 0;
	if (a <  b) return -1;
	return 1;
}


// ---------------------------------------------------
//                Begin Mandatory Compare 
// ---------------------------------------------------

#define sql_compare_define(NAME) \
	bool operator == (const NAME &other) const \
		{return sql_compare_##NAME<mysqlpp::sql_dummy>(*this,other) == 0;} \
	bool operator != (const NAME &other) const \
		{return sql_compare_##NAME<mysqlpp::sql_dummy>(*this,other) != 0;} \
	bool operator > (const NAME &other) const \
		{return sql_compare_##NAME<mysqlpp::sql_dummy>(*this,other) >  0;} \
	bool operator < (const NAME &other) const \
		{return sql_compare_##NAME<mysqlpp::sql_dummy>(*this,other) <  0;} \
	bool operator >= (const NAME &other) const \
		{return sql_compare_##NAME<mysqlpp::sql_dummy>(*this,other) >= 0;} \
	bool operator <= (const NAME &other) const \
		{return sql_compare_##NAME<mysqlpp::sql_dummy>(*this,other) <= 0;} \
	int cmp (const NAME &other) const \
		{return sql_compare_##NAME<mysqlpp::sql_dummy>(*this,other);} \
	int compare (const NAME &other) const \
		{return sql_compare_##NAME<mysqlpp::sql_dummy>(*this,other);}

#define sql_compare_define_0(NAME, T1, C1, T2, C2, T3, C3, T4, C4, T5, C5, T6, C6, T7, C7, T8, C8, T9, C9, T10, C10, T11, C11, T12, C12, T13, C13, T14, C14, T15, C15, T16, C16, T17, C17, T18, C18, T19, C19, T20, C20, T21, C21, T22, C22, T23, C23, T24, C24, T25, C25)

#define sql_construct_define_0(NAME, T1, C1, T2, C2, T3, C3, T4, C4, T5, C5, T6, C6, T7, C7, T8, C8, T9, C9, T10, C10, T11, C11, T12, C12, T13, C13, T14, C14, T15, C15, T16, C16, T17, C17, T18, C18, T19, C19, T20, C20, T21, C21, T22, C22, T23, C23, T24, C24, T25, C25)

#define sql_COMPARE__0(NAME, C1, C2, C3, C4, C5, C6, C7, C8, C9, C10, C11, C12, C13, C14, C15, C16, C17, C18, C19, C20, C21, C22, C23, C24, C25)

#define sql_compare_type_def_0(NAME, WHAT, NUM) \
	sql_compare_type_def_##NUM(NAME, WHAT, NUM)

#define sql_compare_type_defe_0(NAME, WHAT, NUM) \
	sql_compare_type_defe_##NUM(NAME, WHAT, NUM)

// ---------------------------------------------------
//                 End Mandatory Compare 
// ---------------------------------------------------

// ---------------------------------------------------
//                   Begin Compare 1
// ---------------------------------------------------

#define sql_compare_define_1(NAME, T1, C1, T2, C2, T3, C3, T4, C4, T5, C5, T6, C6, T7, C7, T8, C8, T9, C9, T10, C10, T11, C11, T12, C12, T13, C13, T14, C14, T15, C15, T16, C16, T17, C17, T18, C18, T19, C19, T20, C20, T21, C21, T22, C22, T23, C23, T24, C24, T25, C25) \
	NAME(const T1 &p1) : C1 (p1), table_override_(0) {} \
	void set(const T1 &p1) { \
	table_override_ = 0; \
    C1 = p1;\
 \
	} \
	sql_compare_define(NAME)

#define sql_construct_define_1(NAME, T1, C1, T2, C2, T3, C3, T4, C4, T5, C5, T6, C6, T7, C7, T8, C8, T9, C9, T10, C10, T11, C11, T12, C12, T13, C13, T14, C14, T15, C15, T16, C16, T17, C17, T18, C18, T19, C19, T20, C20, T21, C21, T22, C22, T23, C23, T24, C24, T25, C25) \
	void set(const T1 &p1) { \
	table_override_ = 0; \
    C1 = p1;\
 \
	} \
	NAME(const T1 &p1) : C1 (p1), table_override_(0) {}

#define sql_compare_type_def_1(NAME, WHAT, NUM) \
	return WHAT##_list(d, m, true)

#define sql_compare_type_defe_1(NAME, WHAT, NUM) \
	return WHAT##_list(d, c, m, true)

#define sql_COMPARE__1(NAME, C1, C2, C3, C4, C5, C6, C7, C8, C9, C10, C11, C12, C13, C14, C15, C16, C17, C18, C19, C20, C21, C22, C23, C24, C25) \
	template <mysqlpp::sql_dummy_type dummy> \
	int sql_compare_##NAME(const NAME &x, const NAME &y) { \
    return mysqlpp::sql_cmp(x.C1 , y.C1 ); \
	} \
	template <mysqlpp::sql_dummy_type dummy> \
	int compare (const NAME &x, const NAME &y) { \
    return mysqlpp::sql_cmp(x.C1 , y.C1 ); \
	}

// ---------------------------------------------------
//                   End Compare 1
// ---------------------------------------------------


// ---------------------------------------------------
//                   Begin Compare 2
// ---------------------------------------------------

#define sql_compare_define_2(NAME, T1, C1, T2, C2, T3, C3, T4, C4, T5, C5, T6, C6, T7, C7, T8, C8, T9, C9, T10, C10, T11, C11, T12, C12, T13, C13, T14, C14, T15, C15, T16, C16, T17, C17, T18, C18, T19, C19, T20, C20, T21, C21, T22, C22, T23, C23, T24, C24, T25, C25) \
	NAME(const T1 &p1, const T2 &p2) : C1 (p1), C2 (p2), table_override_(0) {} \
	void set(const T1 &p1, const T2 &p2) { \
	table_override_ = 0; \
    C1 = p1;\
    C2 = p2;\
 \
	} \
	sql_compare_define(NAME)

#define sql_construct_define_2(NAME, T1, C1, T2, C2, T3, C3, T4, C4, T5, C5, T6, C6, T7, C7, T8, C8, T9, C9, T10, C10, T11, C11, T12, C12, T13, C13, T14, C14, T15, C15, T16, C16, T17, C17, T18, C18, T19, C19, T20, C20, T21, C21, T22, C22, T23, C23, T24, C24, T25, C25) \
	void set(const T1 &p1, const T2 &p2) { \
	table_override_ = 0; \
    C1 = p1;\
    C2 = p2;\
 \
	} \
	NAME(const T1 &p1, const T2 &p2) : C1 (p1), C2 (p2), table_override_(0) {}

#define sql_compare_type_def_2(NAME, WHAT, NUM) \
	return WHAT##_list(d, m, true, true)

#define sql_compare_type_defe_2(NAME, WHAT, NUM) \
	return WHAT##_list(d, c, m, true, true)

#define sql_COMPARE__2(NAME, C1, C2, C3, C4, C5, C6, C7, C8, C9, C10, C11, C12, C13, C14, C15, C16, C17, C18, C19, C20, C21, C22, C23, C24, C25) \
	template <mysqlpp::sql_dummy_type dummy> \
	int sql_compare_##NAME(const NAME &x, const NAME &y) { \
    int cmp; \
    cmp = mysqlpp::sql_cmp(x.C1 , y.C1 ); \
    if (cmp) return cmp; \
    return mysqlpp::sql_cmp(x.C2 , y.C2 ); \
	} \
	template <mysqlpp::sql_dummy_type dummy> \
	int compare (const NAME &x, const NAME &y) { \
    int cmp; \
    cmp = mysqlpp::sql_cmp(x.C1 , y.C1 ); \
    if (cmp) return cmp; \
    return mysqlpp::sql_cmp(x.C2 , y.C2 ); \
	}

// ---------------------------------------------------
//                   End Compare 2
// ---------------------------------------------------


// ---------------------------------------------------
//                   Begin Compare 3
// ---------------------------------------------------

#define sql_compare_define_3(NAME, T1, C1, T2, C2, T3, C3, T4, C4, T5, C5, T6, C6, T7, C7, T8, C8, T9, C9, T10, C10, T11, C11, T12, C12, T13, C13, T14, C14, T15, C15, T16, C16, T17, C17, T18, C18, T19, C19, T20, C20, T21, C21, T22, C22, T23, C23, T24, C24, T25, C25) \
	NAME(const T1 &p1, const T2 &p2, const T3 &p3) : C1 (p1), C2 (p2), C3 (p3), table_override_(0) {} \
	void set(const T1 &p1, const T2 &p2, const T3 &p3) { \
	table_override_ = 0; \
    C1 = p1;\
    C2 = p2;\
    C3 = p3;\
 \
	} \
	sql_compare_define(NAME)

#define sql_construct_define_3(NAME, T1, C1, T2, C2, T3, C3, T4, C4, T5, C5, T6, C6, T7, C7, T8, C8, T9, C9, T10, C10, T11, C11, T12, C12, T13, C13, T14, C14, T15, C15, T16, C16, T17, C17, T18, C18, T19, C19, T20, C20, T21, C21, T22, C22, T23, C23, T24, C24, T25, C25) \
	void set(const T1 &p1, const T2 &p2, const T3 &p3) { \
	table_override_ = 0; \
    C1 = p1;\
    C2 = p2;\
    C3 = p3;\
 \
	} \
	NAME(const T1 &p1, const T2 &p2, const T3 &p3) : C1 (p1), C2 (p2), C3 (p3), table_override_(0) {}

#define sql_compare_type_def_3(NAME, WHAT, NUM) \
	return WHAT##_list(d, m, true, true, true)

#define sql_compare_type_defe_3(NAME, WHAT, NUM) \
	return WHAT##_list(d, c, m, true, true, true)

#define sql_COMPARE__3(NAME, C1, C2, C3, C4, C5, C6, C7, C8, C9, C10, C11, C12, C13, C14, C15, C16, C17, C18, C19, C20, C21, C22, C23, C24, C25) \
	template <mysqlpp::sql_dummy_type dummy> \
	int sql_compare_##NAME(const NAME &x, const NAME &y) { \
    int cmp; \
    cmp = mysqlpp::sql_cmp(x.C1 , y.C1 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C2 , y.C2 ); \
    if (cmp) return cmp; \
    return mysqlpp::sql_cmp(x.C3 , y.C3 ); \
	} \
	template <mysqlpp::sql_dummy_type dummy> \
	int compare (const NAME &x, const NAME &y) { \
    int cmp; \
    cmp = mysqlpp::sql_cmp(x.C1 , y.C1 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C2 , y.C2 ); \
    if (cmp) return cmp; \
    return mysqlpp::sql_cmp(x.C3 , y.C3 ); \
	}

// ---------------------------------------------------
//                   End Compare 3
// ---------------------------------------------------


// ---------------------------------------------------
//                   Begin Compare 4
// ---------------------------------------------------

#define sql_compare_define_4(NAME, T1, C1, T2, C2, T3, C3, T4, C4, T5, C5, T6, C6, T7, C7, T8, C8, T9, C9, T10, C10, T11, C11, T12, C12, T13, C13, T14, C14, T15, C15, T16, C16, T17, C17, T18, C18, T19, C19, T20, C20, T21, C21, T22, C22, T23, C23, T24, C24, T25, C25) \
	NAME(const T1 &p1, const T2 &p2, const T3 &p3, const T4 &p4) : C1 (p1), C2 (p2), C3 (p3), C4 (p4), table_override_(0) {} \
	void set(const T1 &p1, const T2 &p2, const T3 &p3, const T4 &p4) { \
	table_override_ = 0; \
    C1 = p1;\
    C2 = p2;\
    C3 = p3;\
    C4 = p4;\
 \
	} \
	sql_compare_define(NAME)

#define sql_construct_define_4(NAME, T1, C1, T2, C2, T3, C3, T4, C4, T5, C5, T6, C6, T7, C7, T8, C8, T9, C9, T10, C10, T11, C11, T12, C12, T13, C13, T14, C14, T15, C15, T16, C16, T17, C17, T18, C18, T19, C19, T20, C20, T21, C21, T22, C22, T23, C23, T24, C24, T25, C25) \
	void set(const T1 &p1, const T2 &p2, const T3 &p3, const T4 &p4) { \
	table_override_ = 0; \
    C1 = p1;\
    C2 = p2;\
    C3 = p3;\
    C4 = p4;\
 \
	} \
	NAME(const T1 &p1, const T2 &p2, const T3 &p3, const T4 &p4) : C1 (p1), C2 (p2), C3 (p3), C4 (p4), table_override_(0) {}

#define sql_compare_type_def_4(NAME, WHAT, NUM) \
	return WHAT##_list(d, m, true, true, true, true)

#define sql_compare_type_defe_4(NAME, WHAT, NUM) \
	return WHAT##_list(d, c, m, true, true, true, true)

#define sql_COMPARE__4(NAME, C1, C2, C3, C4, C5, C6, C7, C8, C9, C10, C11, C12, C13, C14, C15, C16, C17, C18, C19, C20, C21, C22, C23, C24, C25) \
	template <mysqlpp::sql_dummy_type dummy> \
	int sql_compare_##NAME(const NAME &x, const NAME &y) { \
    int cmp; \
    cmp = mysqlpp::sql_cmp(x.C1 , y.C1 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C2 , y.C2 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C3 , y.C3 ); \
    if (cmp) return cmp; \
    return mysqlpp::sql_cmp(x.C4 , y.C4 ); \
	} \
	template <mysqlpp::sql_dummy_type dummy> \
	int compare (const NAME &x, const NAME &y) { \
    int cmp; \
    cmp = mysqlpp::sql_cmp(x.C1 , y.C1 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C2 , y.C2 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C3 , y.C3 ); \
    if (cmp) return cmp; \
    return mysqlpp::sql_cmp(x.C4 , y.C4 ); \
	}

// ---------------------------------------------------
//                   End Compare 4
// ---------------------------------------------------


// ---------------------------------------------------
//                   Begin Compare 5
// ---------------------------------------------------

#define sql_compare_define_5(NAME, T1, C1, T2, C2, T3, C3, T4, C4, T5, C5, T6, C6, T7, C7, T8, C8, T9, C9, T10, C10, T11, C11, T12, C12, T13, C13, T14, C14, T15, C15, T16, C16, T17, C17, T18, C18, T19, C19, T20, C20, T21, C21, T22, C22, T23, C23, T24, C24, T25, C25) \
	NAME(const T1 &p1, const T2 &p2, const T3 &p3, const T4 &p4, const T5 &p5) : C1 (p1), C2 (p2), C3 (p3), C4 (p4), C5 (p5), table_override_(0) {} \
	void set(const T1 &p1, const T2 &p2, const T3 &p3, const T4 &p4, const T5 &p5) { \
	table_override_ = 0; \
    C1 = p1;\
    C2 = p2;\
    C3 = p3;\
    C4 = p4;\
    C5 = p5;\
 \
	} \
	sql_compare_define(NAME)

#define sql_construct_define_5(NAME, T1, C1, T2, C2, T3, C3, T4, C4, T5, C5, T6, C6, T7, C7, T8, C8, T9, C9, T10, C10, T11, C11, T12, C12, T13, C13, T14, C14, T15, C15, T16, C16, T17, C17, T18, C18, T19, C19, T20, C20, T21, C21, T22, C22, T23, C23, T24, C24, T25, C25) \
	void set(const T1 &p1, const T2 &p2, const T3 &p3, const T4 &p4, const T5 &p5) { \
	table_override_ = 0; \
    C1 = p1;\
    C2 = p2;\
    C3 = p3;\
    C4 = p4;\
    C5 = p5;\
 \
	} \
	NAME(const T1 &p1, const T2 &p2, const T3 &p3, const T4 &p4, const T5 &p5) : C1 (p1), C2 (p2), C3 (p3), C4 (p4), C5 (p5), table_override_(0) {}

#define sql_compare_type_def_5(NAME, WHAT, NUM) \
	return WHAT##_list(d, m, true, true, true, true, true)

#define sql_compare_type_defe_5(NAME, WHAT, NUM) \
	return WHAT##_list(d, c, m, true, true, true, true, true)

#define sql_COMPARE__5(NAME, C1, C2, C3, C4, C5, C6, C7, C8, C9, C10, C11, C12, C13, C14, C15, C16, C17, C18, C19, C20, C21, C22, C23, C24, C25) \
	template <mysqlpp::sql_dummy_type dummy> \
	int sql_compare_##NAME(const NAME &x, const NAME &y) { \
    int cmp; \
    cmp = mysqlpp::sql_cmp(x.C1 , y.C1 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C2 , y.C2 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C3 , y.C3 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C4 , y.C4 ); \
    if (cmp) return cmp; \
    return mysqlpp::sql_cmp(x.C5 , y.C5 ); \
	} \
	template <mysqlpp::sql_dummy_type dummy> \
	int compare (const NAME &x, const NAME &y) { \
    int cmp; \
    cmp = mysqlpp::sql_cmp(x.C1 , y.C1 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C2 , y.C2 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C3 , y.C3 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C4 , y.C4 ); \
    if (cmp) return cmp; \
    return mysqlpp::sql_cmp(x.C5 , y.C5 ); \
	}

// ---------------------------------------------------
//                   End Compare 5
// ---------------------------------------------------


// ---------------------------------------------------
//                   Begin Compare 6
// ---------------------------------------------------

#define sql_compare_define_6(NAME, T1, C1, T2, C2, T3, C3, T4, C4, T5, C5, T6, C6, T7, C7, T8, C8, T9, C9, T10, C10, T11, C11, T12, C12, T13, C13, T14, C14, T15, C15, T16, C16, T17, C17, T18, C18, T19, C19, T20, C20, T21, C21, T22, C22, T23, C23, T24, C24, T25, C25) \
	NAME(const T1 &p1, const T2 &p2, const T3 &p3, const T4 &p4, const T5 &p5, const T6 &p6) : C1 (p1), C2 (p2), C3 (p3), C4 (p4), C5 (p5), C6 (p6), table_override_(0) {} \
	void set(const T1 &p1, const T2 &p2, const T3 &p3, const T4 &p4, const T5 &p5, const T6 &p6) { \
	table_override_ = 0; \
    C1 = p1;\
    C2 = p2;\
    C3 = p3;\
    C4 = p4;\
    C5 = p5;\
    C6 = p6;\
 \
	} \
	sql_compare_define(NAME)

#define sql_construct_define_6(NAME, T1, C1, T2, C2, T3, C3, T4, C4, T5, C5, T6, C6, T7, C7, T8, C8, T9, C9, T10, C10, T11, C11, T12, C12, T13, C13, T14, C14, T15, C15, T16, C16, T17, C17, T18, C18, T19, C19, T20, C20, T21, C21, T22, C22, T23, C23, T24, C24, T25, C25) \
	void set(const T1 &p1, const T2 &p2, const T3 &p3, const T4 &p4, const T5 &p5, const T6 &p6) { \
	table_override_ = 0; \
    C1 = p1;\
    C2 = p2;\
    C3 = p3;\
    C4 = p4;\
    C5 = p5;\
    C6 = p6;\
 \
	} \
	NAME(const T1 &p1, const T2 &p2, const T3 &p3, const T4 &p4, const T5 &p5, const T6 &p6) : C1 (p1), C2 (p2), C3 (p3), C4 (p4), C5 (p5), C6 (p6), table_override_(0) {}

#define sql_compare_type_def_6(NAME, WHAT, NUM) \
	return WHAT##_list(d, m, true, true, true, true, true, true)

#define sql_compare_type_defe_6(NAME, WHAT, NUM) \
	return WHAT##_list(d, c, m, true, true, true, true, true, true)

#define sql_COMPARE__6(NAME, C1, C2, C3, C4, C5, C6, C7, C8, C9, C10, C11, C12, C13, C14, C15, C16, C17, C18, C19, C20, C21, C22, C23, C24, C25) \
	template <mysqlpp::sql_dummy_type dummy> \
	int sql_compare_##NAME(const NAME &x, const NAME &y) { \
    int cmp; \
    cmp = mysqlpp::sql_cmp(x.C1 , y.C1 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C2 , y.C2 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C3 , y.C3 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C4 , y.C4 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C5 , y.C5 ); \
    if (cmp) return cmp; \
    return mysqlpp::sql_cmp(x.C6 , y.C6 ); \
	} \
	template <mysqlpp::sql_dummy_type dummy> \
	int compare (const NAME &x, const NAME &y) { \
    int cmp; \
    cmp = mysqlpp::sql_cmp(x.C1 , y.C1 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C2 , y.C2 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C3 , y.C3 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C4 , y.C4 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C5 , y.C5 ); \
    if (cmp) return cmp; \
    return mysqlpp::sql_cmp(x.C6 , y.C6 ); \
	}

// ---------------------------------------------------
//                   End Compare 6
// ---------------------------------------------------


// ---------------------------------------------------
//                   Begin Compare 7
// ---------------------------------------------------

#define sql_compare_define_7(NAME, T1, C1, T2, C2, T3, C3, T4, C4, T5, C5, T6, C6, T7, C7, T8, C8, T9, C9, T10, C10, T11, C11, T12, C12, T13, C13, T14, C14, T15, C15, T16, C16, T17, C17, T18, C18, T19, C19, T20, C20, T21, C21, T22, C22, T23, C23, T24, C24, T25, C25) \
	NAME(const T1 &p1, const T2 &p2, const T3 &p3, const T4 &p4, const T5 &p5, const T6 &p6, const T7 &p7) : C1 (p1), C2 (p2), C3 (p3), C4 (p4), C5 (p5), C6 (p6), C7 (p7), table_override_(0) {} \
	void set(const T1 &p1, const T2 &p2, const T3 &p3, const T4 &p4, const T5 &p5, const T6 &p6, const T7 &p7) { \
	table_override_ = 0; \
    C1 = p1;\
    C2 = p2;\
    C3 = p3;\
    C4 = p4;\
    C5 = p5;\
    C6 = p6;\
    C7 = p7;\
 \
	} \
	sql_compare_define(NAME)

#define sql_construct_define_7(NAME, T1, C1, T2, C2, T3, C3, T4, C4, T5, C5, T6, C6, T7, C7, T8, C8, T9, C9, T10, C10, T11, C11, T12, C12, T13, C13, T14, C14, T15, C15, T16, C16, T17, C17, T18, C18, T19, C19, T20, C20, T21, C21, T22, C22, T23, C23, T24, C24, T25, C25) \
	void set(const T1 &p1, const T2 &p2, const T3 &p3, const T4 &p4, const T5 &p5, const T6 &p6, const T7 &p7) { \
	table_override_ = 0; \
    C1 = p1;\
    C2 = p2;\
    C3 = p3;\
    C4 = p4;\
    C5 = p5;\
    C6 = p6;\
    C7 = p7;\
 \
	} \
	NAME(const T1 &p1, const T2 &p2, const T3 &p3, const T4 &p4, const T5 &p5, const T6 &p6, const T7 &p7) : C1 (p1), C2 (p2), C3 (p3), C4 (p4), C5 (p5), C6 (p6), C7 (p7), table_override_(0) {}

#define sql_compare_type_def_7(NAME, WHAT, NUM) \
	return WHAT##_list(d, m, true, true, true, true, true, true, true)

#define sql_compare_type_defe_7(NAME, WHAT, NUM) \
	return WHAT##_list(d, c, m, true, true, true, true, true, true, true)

#define sql_COMPARE__7(NAME, C1, C2, C3, C4, C5, C6, C7, C8, C9, C10, C11, C12, C13, C14, C15, C16, C17, C18, C19, C20, C21, C22, C23, C24, C25) \
	template <mysqlpp::sql_dummy_type dummy> \
	int sql_compare_##NAME(const NAME &x, const NAME &y) { \
    int cmp; \
    cmp = mysqlpp::sql_cmp(x.C1 , y.C1 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C2 , y.C2 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C3 , y.C3 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C4 , y.C4 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C5 , y.C5 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C6 , y.C6 ); \
    if (cmp) return cmp; \
    return mysqlpp::sql_cmp(x.C7 , y.C7 ); \
	} \
	template <mysqlpp::sql_dummy_type dummy> \
	int compare (const NAME &x, const NAME &y) { \
    int cmp; \
    cmp = mysqlpp::sql_cmp(x.C1 , y.C1 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C2 , y.C2 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C3 , y.C3 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C4 , y.C4 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C5 , y.C5 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C6 , y.C6 ); \
    if (cmp) return cmp; \
    return mysqlpp::sql_cmp(x.C7 , y.C7 ); \
	}

// ---------------------------------------------------
//                   End Compare 7
// ---------------------------------------------------


// ---------------------------------------------------
//                   Begin Compare 8
// ---------------------------------------------------

#define sql_compare_define_8(NAME, T1, C1, T2, C2, T3, C3, T4, C4, T5, C5, T6, C6, T7, C7, T8, C8, T9, C9, T10, C10, T11, C11, T12, C12, T13, C13, T14, C14, T15, C15, T16, C16, T17, C17, T18, C18, T19, C19, T20, C20, T21, C21, T22, C22, T23, C23, T24, C24, T25, C25) \
	NAME(const T1 &p1, const T2 &p2, const T3 &p3, const T4 &p4, const T5 &p5, const T6 &p6, const T7 &p7, const T8 &p8) : C1 (p1), C2 (p2), C3 (p3), C4 (p4), C5 (p5), C6 (p6), C7 (p7), C8 (p8), table_override_(0) {} \
	void set(const T1 &p1, const T2 &p2, const T3 &p3, const T4 &p4, const T5 &p5, const T6 &p6, const T7 &p7, const T8 &p8) { \
	table_override_ = 0; \
    C1 = p1;\
    C2 = p2;\
    C3 = p3;\
    C4 = p4;\
    C5 = p5;\
    C6 = p6;\
    C7 = p7;\
    C8 = p8;\
 \
	} \
	sql_compare_define(NAME)

#define sql_construct_define_8(NAME, T1, C1, T2, C2, T3, C3, T4, C4, T5, C5, T6, C6, T7, C7, T8, C8, T9, C9, T10, C10, T11, C11, T12, C12, T13, C13, T14, C14, T15, C15, T16, C16, T17, C17, T18, C18, T19, C19, T20, C20, T21, C21, T22, C22, T23, C23, T24, C24, T25, C25) \
	void set(const T1 &p1, const T2 &p2, const T3 &p3, const T4 &p4, const T5 &p5, const T6 &p6, const T7 &p7, const T8 &p8) { \
	table_override_ = 0; \
    C1 = p1;\
    C2 = p2;\
    C3 = p3;\
    C4 = p4;\
    C5 = p5;\
    C6 = p6;\
    C7 = p7;\
    C8 = p8;\
 \
	} \
	NAME(const T1 &p1, const T2 &p2, const T3 &p3, const T4 &p4, const T5 &p5, const T6 &p6, const T7 &p7, const T8 &p8) : C1 (p1), C2 (p2), C3 (p3), C4 (p4), C5 (p5), C6 (p6), C7 (p7), C8 (p8), table_override_(0) {}

#define sql_compare_type_def_8(NAME, WHAT, NUM) \
	return WHAT##_list(d, m, true, true, true, true, true, true, true, true)

#define sql_compare_type_defe_8(NAME, WHAT, NUM) \
	return WHAT##_list(d, c, m, true, true, true, true, true, true, true, true)

#define sql_COMPARE__8(NAME, C1, C2, C3, C4, C5, C6, C7, C8, C9, C10, C11, C12, C13, C14, C15, C16, C17, C18, C19, C20, C21, C22, C23, C24, C25) \
	template <mysqlpp::sql_dummy_type dummy> \
	int sql_compare_##NAME(const NAME &x, const NAME &y) { \
    int cmp; \
    cmp = mysqlpp::sql_cmp(x.C1 , y.C1 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C2 , y.C2 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C3 , y.C3 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C4 , y.C4 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C5 , y.C5 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C6 , y.C6 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C7 , y.C7 ); \
    if (cmp) return cmp; \
    return mysqlpp::sql_cmp(x.C8 , y.C8 ); \
	} \
	template <mysqlpp::sql_dummy_type dummy> \
	int compare (const NAME &x, const NAME &y) { \
    int cmp; \
    cmp = mysqlpp::sql_cmp(x.C1 , y.C1 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C2 , y.C2 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C3 , y.C3 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C4 , y.C4 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C5 , y.C5 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C6 , y.C6 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C7 , y.C7 ); \
    if (cmp) return cmp; \
    return mysqlpp::sql_cmp(x.C8 , y.C8 ); \
	}

// ---------------------------------------------------
//                   End Compare 8
// ---------------------------------------------------


// ---------------------------------------------------
//                   Begin Compare 9
// ---------------------------------------------------

#define sql_compare_define_9(NAME, T1, C1, T2, C2, T3, C3, T4, C4, T5, C5, T6, C6, T7, C7, T8, C8, T9, C9, T10, C10, T11, C11, T12, C12, T13, C13, T14, C14, T15, C15, T16, C16, T17, C17, T18, C18, T19, C19, T20, C20, T21, C21, T22, C22, T23, C23, T24, C24, T25, C25) \
	NAME(const T1 &p1, const T2 &p2, const T3 &p3, const T4 &p4, const T5 &p5, const T6 &p6, const T7 &p7, const T8 &p8, const T9 &p9) : C1 (p1), C2 (p2), C3 (p3), C4 (p4), C5 (p5), C6 (p6), C7 (p7), C8 (p8), C9 (p9), table_override_(0) {} \
	void set(const T1 &p1, const T2 &p2, const T3 &p3, const T4 &p4, const T5 &p5, const T6 &p6, const T7 &p7, const T8 &p8, const T9 &p9) { \
	table_override_ = 0; \
    C1 = p1;\
    C2 = p2;\
    C3 = p3;\
    C4 = p4;\
    C5 = p5;\
    C6 = p6;\
    C7 = p7;\
    C8 = p8;\
    C9 = p9;\
 \
	} \
	sql_compare_define(NAME)

#define sql_construct_define_9(NAME, T1, C1, T2, C2, T3, C3, T4, C4, T5, C5, T6, C6, T7, C7, T8, C8, T9, C9, T10, C10, T11, C11, T12, C12, T13, C13, T14, C14, T15, C15, T16, C16, T17, C17, T18, C18, T19, C19, T20, C20, T21, C21, T22, C22, T23, C23, T24, C24, T25, C25) \
	void set(const T1 &p1, const T2 &p2, const T3 &p3, const T4 &p4, const T5 &p5, const T6 &p6, const T7 &p7, const T8 &p8, const T9 &p9) { \
	table_override_ = 0; \
    C1 = p1;\
    C2 = p2;\
    C3 = p3;\
    C4 = p4;\
    C5 = p5;\
    C6 = p6;\
    C7 = p7;\
    C8 = p8;\
    C9 = p9;\
 \
	} \
	NAME(const T1 &p1, const T2 &p2, const T3 &p3, const T4 &p4, const T5 &p5, const T6 &p6, const T7 &p7, const T8 &p8, const T9 &p9) : C1 (p1), C2 (p2), C3 (p3), C4 (p4), C5 (p5), C6 (p6), C7 (p7), C8 (p8), C9 (p9), table_override_(0) {}

#define sql_compare_type_def_9(NAME, WHAT, NUM) \
	return WHAT##_list(d, m, true, true, true, true, true, true, true, true, true)

#define sql_compare_type_defe_9(NAME, WHAT, NUM) \
	return WHAT##_list(d, c, m, true, true, true, true, true, true, true, true, true)

#define sql_COMPARE__9(NAME, C1, C2, C3, C4, C5, C6, C7, C8, C9, C10, C11, C12, C13, C14, C15, C16, C17, C18, C19, C20, C21, C22, C23, C24, C25) \
	template <mysqlpp::sql_dummy_type dummy> \
	int sql_compare_##NAME(const NAME &x, const NAME &y) { \
    int cmp; \
    cmp = mysqlpp::sql_cmp(x.C1 , y.C1 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C2 , y.C2 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C3 , y.C3 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C4 , y.C4 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C5 , y.C5 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C6 , y.C6 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C7 , y.C7 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C8 , y.C8 ); \
    if (cmp) return cmp; \
    return mysqlpp::sql_cmp(x.C9 , y.C9 ); \
	} \
	template <mysqlpp::sql_dummy_type dummy> \
	int compare (const NAME &x, const NAME &y) { \
    int cmp; \
    cmp = mysqlpp::sql_cmp(x.C1 , y.C1 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C2 , y.C2 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C3 , y.C3 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C4 , y.C4 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C5 , y.C5 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C6 , y.C6 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C7 , y.C7 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C8 , y.C8 ); \
    if (cmp) return cmp; \
    return mysqlpp::sql_cmp(x.C9 , y.C9 ); \
	}

// ---------------------------------------------------
//                   End Compare 9
// ---------------------------------------------------


// ---------------------------------------------------
//                   Begin Compare 10
// ---------------------------------------------------

#define sql_compare_define_10(NAME, T1, C1, T2, C2, T3, C3, T4, C4, T5, C5, T6, C6, T7, C7, T8, C8, T9, C9, T10, C10, T11, C11, T12, C12, T13, C13, T14, C14, T15, C15, T16, C16, T17, C17, T18, C18, T19, C19, T20, C20, T21, C21, T22, C22, T23, C23, T24, C24, T25, C25) \
	NAME(const T1 &p1, const T2 &p2, const T3 &p3, const T4 &p4, const T5 &p5, const T6 &p6, const T7 &p7, const T8 &p8, const T9 &p9, const T10 &p10) : C1 (p1), C2 (p2), C3 (p3), C4 (p4), C5 (p5), C6 (p6), C7 (p7), C8 (p8), C9 (p9), C10 (p10), table_override_(0) {} \
	void set(const T1 &p1, const T2 &p2, const T3 &p3, const T4 &p4, const T5 &p5, const T6 &p6, const T7 &p7, const T8 &p8, const T9 &p9, const T10 &p10) { \
	table_override_ = 0; \
    C1 = p1;\
    C2 = p2;\
    C3 = p3;\
    C4 = p4;\
    C5 = p5;\
    C6 = p6;\
    C7 = p7;\
    C8 = p8;\
    C9 = p9;\
    C10 = p10;\
 \
	} \
	sql_compare_define(NAME)

#define sql_construct_define_10(NAME, T1, C1, T2, C2, T3, C3, T4, C4, T5, C5, T6, C6, T7, C7, T8, C8, T9, C9, T10, C10, T11, C11, T12, C12, T13, C13, T14, C14, T15, C15, T16, C16, T17, C17, T18, C18, T19, C19, T20, C20, T21, C21, T22, C22, T23, C23, T24, C24, T25, C25) \
	void set(const T1 &p1, const T2 &p2, const T3 &p3, const T4 &p4, const T5 &p5, const T6 &p6, const T7 &p7, const T8 &p8, const T9 &p9, const T10 &p10) { \
	table_override_ = 0; \
    C1 = p1;\
    C2 = p2;\
    C3 = p3;\
    C4 = p4;\
    C5 = p5;\
    C6 = p6;\
    C7 = p7;\
    C8 = p8;\
    C9 = p9;\
    C10 = p10;\
 \
	} \
	NAME(const T1 &p1, const T2 &p2, const T3 &p3, const T4 &p4, const T5 &p5, const T6 &p6, const T7 &p7, const T8 &p8, const T9 &p9, const T10 &p10) : C1 (p1), C2 (p2), C3 (p3), C4 (p4), C5 (p5), C6 (p6), C7 (p7), C8 (p8), C9 (p9), C10 (p10), table_override_(0) {}

#define sql_compare_type_def_10(NAME, WHAT, NUM) \
	return WHAT##_list(d, m, true, true, true, true, true, true, true, true, true, true)

#define sql_compare_type_defe_10(NAME, WHAT, NUM) \
	return WHAT##_list(d, c, m, true, true, true, true, true, true, true, true, true, true)

#define sql_COMPARE__10(NAME, C1, C2, C3, C4, C5, C6, C7, C8, C9, C10, C11, C12, C13, C14, C15, C16, C17, C18, C19, C20, C21, C22, C23, C24, C25) \
	template <mysqlpp::sql_dummy_type dummy> \
	int sql_compare_##NAME(const NAME &x, const NAME &y) { \
    int cmp; \
    cmp = mysqlpp::sql_cmp(x.C1 , y.C1 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C2 , y.C2 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C3 , y.C3 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C4 , y.C4 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C5 , y.C5 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C6 , y.C6 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C7 , y.C7 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C8 , y.C8 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C9 , y.C9 ); \
    if (cmp) return cmp; \
    return mysqlpp::sql_cmp(x.C10 , y.C10 ); \
	} \
	template <mysqlpp::sql_dummy_type dummy> \
	int compare (const NAME &x, const NAME &y) { \
    int cmp; \
    cmp = mysqlpp::sql_cmp(x.C1 , y.C1 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C2 , y.C2 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C3 , y.C3 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C4 , y.C4 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C5 , y.C5 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C6 , y.C6 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C7 , y.C7 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C8 , y.C8 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C9 , y.C9 ); \
    if (cmp) return cmp; \
    return mysqlpp::sql_cmp(x.C10 , y.C10 ); \
	}

// ---------------------------------------------------
//                   End Compare 10
// ---------------------------------------------------


// ---------------------------------------------------
//                   Begin Compare 11
// ---------------------------------------------------

#define sql_compare_define_11(NAME, T1, C1, T2, C2, T3, C3, T4, C4, T5, C5, T6, C6, T7, C7, T8, C8, T9, C9, T10, C10, T11, C11, T12, C12, T13, C13, T14, C14, T15, C15, T16, C16, T17, C17, T18, C18, T19, C19, T20, C20, T21, C21, T22, C22, T23, C23, T24, C24, T25, C25) \
	NAME(const T1 &p1, const T2 &p2, const T3 &p3, const T4 &p4, const T5 &p5, const T6 &p6, const T7 &p7, const T8 &p8, const T9 &p9, const T10 &p10, const T11 &p11) : C1 (p1), C2 (p2), C3 (p3), C4 (p4), C5 (p5), C6 (p6), C7 (p7), C8 (p8), C9 (p9), C10 (p10), C11 (p11), table_override_(0) {} \
	void set(const T1 &p1, const T2 &p2, const T3 &p3, const T4 &p4, const T5 &p5, const T6 &p6, const T7 &p7, const T8 &p8, const T9 &p9, const T10 &p10, const T11 &p11) { \
	table_override_ = 0; \
    C1 = p1;\
    C2 = p2;\
    C3 = p3;\
    C4 = p4;\
    C5 = p5;\
    C6 = p6;\
    C7 = p7;\
    C8 = p8;\
    C9 = p9;\
    C10 = p10;\
    C11 = p11;\
 \
	} \
	sql_compare_define(NAME)

#define sql_construct_define_11(NAME, T1, C1, T2, C2, T3, C3, T4, C4, T5, C5, T6, C6, T7, C7, T8, C8, T9, C9, T10, C10, T11, C11, T12, C12, T13, C13, T14, C14, T15, C15, T16, C16, T17, C17, T18, C18, T19, C19, T20, C20, T21, C21, T22, C22, T23, C23, T24, C24, T25, C25) \
	void set(const T1 &p1, const T2 &p2, const T3 &p3, const T4 &p4, const T5 &p5, const T6 &p6, const T7 &p7, const T8 &p8, const T9 &p9, const T10 &p10, const T11 &p11) { \
	table_override_ = 0; \
    C1 = p1;\
    C2 = p2;\
    C3 = p3;\
    C4 = p4;\
    C5 = p5;\
    C6 = p6;\
    C7 = p7;\
    C8 = p8;\
    C9 = p9;\
    C10 = p10;\
    C11 = p11;\
 \
	} \
	NAME(const T1 &p1, const T2 &p2, const T3 &p3, const T4 &p4, const T5 &p5, const T6 &p6, const T7 &p7, const T8 &p8, const T9 &p9, const T10 &p10, const T11 &p11) : C1 (p1), C2 (p2), C3 (p3), C4 (p4), C5 (p5), C6 (p6), C7 (p7), C8 (p8), C9 (p9), C10 (p10), C11 (p11), table_override_(0) {}

#define sql_compare_type_def_11(NAME, WHAT, NUM) \
	return WHAT##_list(d, m, true, true, true, true, true, true, true, true, true, true, true)

#define sql_compare_type_defe_11(NAME, WHAT, NUM) \
	return WHAT##_list(d, c, m, true, true, true, true, true, true, true, true, true, true, true)

#define sql_COMPARE__11(NAME, C1, C2, C3, C4, C5, C6, C7, C8, C9, C10, C11, C12, C13, C14, C15, C16, C17, C18, C19, C20, C21, C22, C23, C24, C25) \
	template <mysqlpp::sql_dummy_type dummy> \
	int sql_compare_##NAME(const NAME &x, const NAME &y) { \
    int cmp; \
    cmp = mysqlpp::sql_cmp(x.C1 , y.C1 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C2 , y.C2 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C3 , y.C3 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C4 , y.C4 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C5 , y.C5 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C6 , y.C6 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C7 , y.C7 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C8 , y.C8 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C9 , y.C9 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C10 , y.C10 ); \
    if (cmp) return cmp; \
    return mysqlpp::sql_cmp(x.C11 , y.C11 ); \
	} \
	template <mysqlpp::sql_dummy_type dummy> \
	int compare (const NAME &x, const NAME &y) { \
    int cmp; \
    cmp = mysqlpp::sql_cmp(x.C1 , y.C1 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C2 , y.C2 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C3 , y.C3 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C4 , y.C4 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C5 , y.C5 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C6 , y.C6 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C7 , y.C7 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C8 , y.C8 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C9 , y.C9 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C10 , y.C10 ); \
    if (cmp) return cmp; \
    return mysqlpp::sql_cmp(x.C11 , y.C11 ); \
	}

// ---------------------------------------------------
//                   End Compare 11
// ---------------------------------------------------


// ---------------------------------------------------
//                   Begin Compare 12
// ---------------------------------------------------

#define sql_compare_define_12(NAME, T1, C1, T2, C2, T3, C3, T4, C4, T5, C5, T6, C6, T7, C7, T8, C8, T9, C9, T10, C10, T11, C11, T12, C12, T13, C13, T14, C14, T15, C15, T16, C16, T17, C17, T18, C18, T19, C19, T20, C20, T21, C21, T22, C22, T23, C23, T24, C24, T25, C25) \
	NAME(const T1 &p1, const T2 &p2, const T3 &p3, const T4 &p4, const T5 &p5, const T6 &p6, const T7 &p7, const T8 &p8, const T9 &p9, const T10 &p10, const T11 &p11, const T12 &p12) : C1 (p1), C2 (p2), C3 (p3), C4 (p4), C5 (p5), C6 (p6), C7 (p7), C8 (p8), C9 (p9), C10 (p10), C11 (p11), C12 (p12), table_override_(0) {} \
	void set(const T1 &p1, const T2 &p2, const T3 &p3, const T4 &p4, const T5 &p5, const T6 &p6, const T7 &p7, const T8 &p8, const T9 &p9, const T10 &p10, const T11 &p11, const T12 &p12) { \
	table_override_ = 0; \
    C1 = p1;\
    C2 = p2;\
    C3 = p3;\
    C4 = p4;\
    C5 = p5;\
    C6 = p6;\
    C7 = p7;\
    C8 = p8;\
    C9 = p9;\
    C10 = p10;\
    C11 = p11;\
    C12 = p12;\
 \
	} \
	sql_compare_define(NAME)

#define sql_construct_define_12(NAME, T1, C1, T2, C2, T3, C3, T4, C4, T5, C5, T6, C6, T7, C7, T8, C8, T9, C9, T10, C10, T11, C11, T12, C12, T13, C13, T14, C14, T15, C15, T16, C16, T17, C17, T18, C18, T19, C19, T20, C20, T21, C21, T22, C22, T23, C23, T24, C24, T25, C25) \
	void set(const T1 &p1, const T2 &p2, const T3 &p3, const T4 &p4, const T5 &p5, const T6 &p6, const T7 &p7, const T8 &p8, const T9 &p9, const T10 &p10, const T11 &p11, const T12 &p12) { \
	table_override_ = 0; \
    C1 = p1;\
    C2 = p2;\
    C3 = p3;\
    C4 = p4;\
    C5 = p5;\
    C6 = p6;\
    C7 = p7;\
    C8 = p8;\
    C9 = p9;\
    C10 = p10;\
    C11 = p11;\
    C12 = p12;\
 \
	} \
	NAME(const T1 &p1, const T2 &p2, const T3 &p3, const T4 &p4, const T5 &p5, const T6 &p6, const T7 &p7, const T8 &p8, const T9 &p9, const T10 &p10, const T11 &p11, const T12 &p12) : C1 (p1), C2 (p2), C3 (p3), C4 (p4), C5 (p5), C6 (p6), C7 (p7), C8 (p8), C9 (p9), C10 (p10), C11 (p11), C12 (p12), table_override_(0) {}

#define sql_compare_type_def_12(NAME, WHAT, NUM) \
	return WHAT##_list(d, m, true, true, true, true, true, true, true, true, true, true, true, true)

#define sql_compare_type_defe_12(NAME, WHAT, NUM) \
	return WHAT##_list(d, c, m, true, true, true, true, true, true, true, true, true, true, true, true)

#define sql_COMPARE__12(NAME, C1, C2, C3, C4, C5, C6, C7, C8, C9, C10, C11, C12, C13, C14, C15, C16, C17, C18, C19, C20, C21, C22, C23, C24, C25) \
	template <mysqlpp::sql_dummy_type dummy> \
	int sql_compare_##NAME(const NAME &x, const NAME &y) { \
    int cmp; \
    cmp = mysqlpp::sql_cmp(x.C1 , y.C1 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C2 , y.C2 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C3 , y.C3 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C4 , y.C4 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C5 , y.C5 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C6 , y.C6 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C7 , y.C7 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C8 , y.C8 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C9 , y.C9 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C10 , y.C10 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C11 , y.C11 ); \
    if (cmp) return cmp; \
    return mysqlpp::sql_cmp(x.C12 , y.C12 ); \
	} \
	template <mysqlpp::sql_dummy_type dummy> \
	int compare (const NAME &x, const NAME &y) { \
    int cmp; \
    cmp = mysqlpp::sql_cmp(x.C1 , y.C1 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C2 , y.C2 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C3 , y.C3 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C4 , y.C4 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C5 , y.C5 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C6 , y.C6 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C7 , y.C7 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C8 , y.C8 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C9 , y.C9 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C10 , y.C10 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C11 , y.C11 ); \
    if (cmp) return cmp; \
    return mysqlpp::sql_cmp(x.C12 , y.C12 ); \
	}

// ---------------------------------------------------
//                   End Compare 12
// ---------------------------------------------------


// ---------------------------------------------------
//                   Begin Compare 13
// ---------------------------------------------------

#define sql_compare_define_13(NAME, T1, C1, T2, C2, T3, C3, T4, C4, T5, C5, T6, C6, T7, C7, T8, C8, T9, C9, T10, C10, T11, C11, T12, C12, T13, C13, T14, C14, T15, C15, T16, C16, T17, C17, T18, C18, T19, C19, T20, C20, T21, C21, T22, C22, T23, C23, T24, C24, T25, C25) \
	NAME(const T1 &p1, const T2 &p2, const T3 &p3, const T4 &p4, const T5 &p5, const T6 &p6, const T7 &p7, const T8 &p8, const T9 &p9, const T10 &p10, const T11 &p11, const T12 &p12, const T13 &p13) : C1 (p1), C2 (p2), C3 (p3), C4 (p4), C5 (p5), C6 (p6), C7 (p7), C8 (p8), C9 (p9), C10 (p10), C11 (p11), C12 (p12), C13 (p13), table_override_(0) {} \
	void set(const T1 &p1, const T2 &p2, const T3 &p3, const T4 &p4, const T5 &p5, const T6 &p6, const T7 &p7, const T8 &p8, const T9 &p9, const T10 &p10, const T11 &p11, const T12 &p12, const T13 &p13) { \
	table_override_ = 0; \
    C1 = p1;\
    C2 = p2;\
    C3 = p3;\
    C4 = p4;\
    C5 = p5;\
    C6 = p6;\
    C7 = p7;\
    C8 = p8;\
    C9 = p9;\
    C10 = p10;\
    C11 = p11;\
    C12 = p12;\
    C13 = p13;\
 \
	} \
	sql_compare_define(NAME)

#define sql_construct_define_13(NAME, T1, C1, T2, C2, T3, C3, T4, C4, T5, C5, T6, C6, T7, C7, T8, C8, T9, C9, T10, C10, T11, C11, T12, C12, T13, C13, T14, C14, T15, C15, T16, C16, T17, C17, T18, C18, T19, C19, T20, C20, T21, C21, T22, C22, T23, C23, T24, C24, T25, C25) \
	void set(const T1 &p1, const T2 &p2, const T3 &p3, const T4 &p4, const T5 &p5, const T6 &p6, const T7 &p7, const T8 &p8, const T9 &p9, const T10 &p10, const T11 &p11, const T12 &p12, const T13 &p13) { \
	table_override_ = 0; \
    C1 = p1;\
    C2 = p2;\
    C3 = p3;\
    C4 = p4;\
    C5 = p5;\
    C6 = p6;\
    C7 = p7;\
    C8 = p8;\
    C9 = p9;\
    C10 = p10;\
    C11 = p11;\
    C12 = p12;\
    C13 = p13;\
 \
	} \
	NAME(const T1 &p1, const T2 &p2, const T3 &p3, const T4 &p4, const T5 &p5, const T6 &p6, const T7 &p7, const T8 &p8, const T9 &p9, const T10 &p10, const T11 &p11, const T12 &p12, const T13 &p13) : C1 (p1), C2 (p2), C3 (p3), C4 (p4), C5 (p5), C6 (p6), C7 (p7), C8 (p8), C9 (p9), C10 (p10), C11 (p11), C12 (p12), C13 (p13), table_override_(0) {}

#define sql_compare_type_def_13(NAME, WHAT, NUM) \
	return WHAT##_list(d, m, true, true, true, true, true, true, true, true, true, true, true, true, true)

#define sql_compare_type_defe_13(NAME, WHAT, NUM) \
	return WHAT##_list(d, c, m, true, true, true, true, true, true, true, true, true, true, true, true, true)

#define sql_COMPARE__13(NAME, C1, C2, C3, C4, C5, C6, C7, C8, C9, C10, C11, C12, C13, C14, C15, C16, C17, C18, C19, C20, C21, C22, C23, C24, C25) \
	template <mysqlpp::sql_dummy_type dummy> \
	int sql_compare_##NAME(const NAME &x, const NAME &y) { \
    int cmp; \
    cmp = mysqlpp::sql_cmp(x.C1 , y.C1 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C2 , y.C2 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C3 , y.C3 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C4 , y.C4 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C5 , y.C5 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C6 , y.C6 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C7 , y.C7 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C8 , y.C8 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C9 , y.C9 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C10 , y.C10 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C11 , y.C11 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C12 , y.C12 ); \
    if (cmp) return cmp; \
    return mysqlpp::sql_cmp(x.C13 , y.C13 ); \
	} \
	template <mysqlpp::sql_dummy_type dummy> \
	int compare (const NAME &x, const NAME &y) { \
    int cmp; \
    cmp = mysqlpp::sql_cmp(x.C1 , y.C1 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C2 , y.C2 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C3 , y.C3 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C4 , y.C4 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C5 , y.C5 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C6 , y.C6 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C7 , y.C7 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C8 , y.C8 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C9 , y.C9 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C10 , y.C10 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C11 , y.C11 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C12 , y.C12 ); \
    if (cmp) return cmp; \
    return mysqlpp::sql_cmp(x.C13 , y.C13 ); \
	}

// ---------------------------------------------------
//                   End Compare 13
// ---------------------------------------------------


// ---------------------------------------------------
//                   Begin Compare 14
// ---------------------------------------------------

#define sql_compare_define_14(NAME, T1, C1, T2, C2, T3, C3, T4, C4, T5, C5, T6, C6, T7, C7, T8, C8, T9, C9, T10, C10, T11, C11, T12, C12, T13, C13, T14, C14, T15, C15, T16, C16, T17, C17, T18, C18, T19, C19, T20, C20, T21, C21, T22, C22, T23, C23, T24, C24, T25, C25) \
	NAME(const T1 &p1, const T2 &p2, const T3 &p3, const T4 &p4, const T5 &p5, const T6 &p6, const T7 &p7, const T8 &p8, const T9 &p9, const T10 &p10, const T11 &p11, const T12 &p12, const T13 &p13, const T14 &p14) : C1 (p1), C2 (p2), C3 (p3), C4 (p4), C5 (p5), C6 (p6), C7 (p7), C8 (p8), C9 (p9), C10 (p10), C11 (p11), C12 (p12), C13 (p13), C14 (p14), table_override_(0) {} \
	void set(const T1 &p1, const T2 &p2, const T3 &p3, const T4 &p4, const T5 &p5, const T6 &p6, const T7 &p7, const T8 &p8, const T9 &p9, const T10 &p10, const T11 &p11, const T12 &p12, const T13 &p13, const T14 &p14) { \
	table_override_ = 0; \
    C1 = p1;\
    C2 = p2;\
    C3 = p3;\
    C4 = p4;\
    C5 = p5;\
    C6 = p6;\
    C7 = p7;\
    C8 = p8;\
    C9 = p9;\
    C10 = p10;\
    C11 = p11;\
    C12 = p12;\
    C13 = p13;\
    C14 = p14;\
 \
	} \
	sql_compare_define(NAME)

#define sql_construct_define_14(NAME, T1, C1, T2, C2, T3, C3, T4, C4, T5, C5, T6, C6, T7, C7, T8, C8, T9, C9, T10, C10, T11, C11, T12, C12, T13, C13, T14, C14, T15, C15, T16, C16, T17, C17, T18, C18, T19, C19, T20, C20, T21, C21, T22, C22, T23, C23, T24, C24, T25, C25) \
	void set(const T1 &p1, const T2 &p2, const T3 &p3, const T4 &p4, const T5 &p5, const T6 &p6, const T7 &p7, const T8 &p8, const T9 &p9, const T10 &p10, const T11 &p11, const T12 &p12, const T13 &p13, const T14 &p14) { \
	table_override_ = 0; \
    C1 = p1;\
    C2 = p2;\
    C3 = p3;\
    C4 = p4;\
    C5 = p5;\
    C6 = p6;\
    C7 = p7;\
    C8 = p8;\
    C9 = p9;\
    C10 = p10;\
    C11 = p11;\
    C12 = p12;\
    C13 = p13;\
    C14 = p14;\
 \
	} \
	NAME(const T1 &p1, const T2 &p2, const T3 &p3, const T4 &p4, const T5 &p5, const T6 &p6, const T7 &p7, const T8 &p8, const T9 &p9, const T10 &p10, const T11 &p11, const T12 &p12, const T13 &p13, const T14 &p14) : C1 (p1), C2 (p2), C3 (p3), C4 (p4), C5 (p5), C6 (p6), C7 (p7), C8 (p8), C9 (p9), C10 (p10), C11 (p11), C12 (p12), C13 (p13), C14 (p14), table_override_(0) {}

#define sql_compare_type_def_14(NAME, WHAT, NUM) \
	return WHAT##_list(d, m, true, true, true, true, true, true, true, true, true, true, true, true, true, true)

#define sql_compare_type_defe_14(NAME, WHAT, NUM) \
	return WHAT##_list(d, c, m, true, true, true, true, true, true, true, true, true, true, true, true, true, true)

#define sql_COMPARE__14(NAME, C1, C2, C3, C4, C5, C6, C7, C8, C9, C10, C11, C12, C13, C14, C15, C16, C17, C18, C19, C20, C21, C22, C23, C24, C25) \
	template <mysqlpp::sql_dummy_type dummy> \
	int sql_compare_##NAME(const NAME &x, const NAME &y) { \
    int cmp; \
    cmp = mysqlpp::sql_cmp(x.C1 , y.C1 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C2 , y.C2 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C3 , y.C3 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C4 , y.C4 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C5 , y.C5 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C6 , y.C6 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C7 , y.C7 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C8 , y.C8 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C9 , y.C9 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C10 , y.C10 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C11 , y.C11 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C12 , y.C12 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C13 , y.C13 ); \
    if (cmp) return cmp; \
    return mysqlpp::sql_cmp(x.C14 , y.C14 ); \
	} \
	template <mysqlpp::sql_dummy_type dummy> \
	int compare (const NAME &x, const NAME &y) { \
    int cmp; \
    cmp = mysqlpp::sql_cmp(x.C1 , y.C1 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C2 , y.C2 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C3 , y.C3 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C4 , y.C4 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C5 , y.C5 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C6 , y.C6 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C7 , y.C7 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C8 , y.C8 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C9 , y.C9 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C10 , y.C10 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C11 , y.C11 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C12 , y.C12 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C13 , y.C13 ); \
    if (cmp) return cmp; \
    return mysqlpp::sql_cmp(x.C14 , y.C14 ); \
	}

// ---------------------------------------------------
//                   End Compare 14
// ---------------------------------------------------


// ---------------------------------------------------
//                   Begin Compare 15
// ---------------------------------------------------

#define sql_compare_define_15(NAME, T1, C1, T2, C2, T3, C3, T4, C4, T5, C5, T6, C6, T7, C7, T8, C8, T9, C9, T10, C10, T11, C11, T12, C12, T13, C13, T14, C14, T15, C15, T16, C16, T17, C17, T18, C18, T19, C19, T20, C20, T21, C21, T22, C22, T23, C23, T24, C24, T25, C25) \
	NAME(const T1 &p1, const T2 &p2, const T3 &p3, const T4 &p4, const T5 &p5, const T6 &p6, const T7 &p7, const T8 &p8, const T9 &p9, const T10 &p10, const T11 &p11, const T12 &p12, const T13 &p13, const T14 &p14, const T15 &p15) : C1 (p1), C2 (p2), C3 (p3), C4 (p4), C5 (p5), C6 (p6), C7 (p7), C8 (p8), C9 (p9), C10 (p10), C11 (p11), C12 (p12), C13 (p13), C14 (p14), C15 (p15), table_override_(0) {} \
	void set(const T1 &p1, const T2 &p2, const T3 &p3, const T4 &p4, const T5 &p5, const T6 &p6, const T7 &p7, const T8 &p8, const T9 &p9, const T10 &p10, const T11 &p11, const T12 &p12, const T13 &p13, const T14 &p14, const T15 &p15) { \
	table_override_ = 0; \
    C1 = p1;\
    C2 = p2;\
    C3 = p3;\
    C4 = p4;\
    C5 = p5;\
    C6 = p6;\
    C7 = p7;\
    C8 = p8;\
    C9 = p9;\
    C10 = p10;\
    C11 = p11;\
    C12 = p12;\
    C13 = p13;\
    C14 = p14;\
    C15 = p15;\
 \
	} \
	sql_compare_define(NAME)

#define sql_construct_define_15(NAME, T1, C1, T2, C2, T3, C3, T4, C4, T5, C5, T6, C6, T7, C7, T8, C8, T9, C9, T10, C10, T11, C11, T12, C12, T13, C13, T14, C14, T15, C15, T16, C16, T17, C17, T18, C18, T19, C19, T20, C20, T21, C21, T22, C22, T23, C23, T24, C24, T25, C25) \
	void set(const T1 &p1, const T2 &p2, const T3 &p3, const T4 &p4, const T5 &p5, const T6 &p6, const T7 &p7, const T8 &p8, const T9 &p9, const T10 &p10, const T11 &p11, const T12 &p12, const T13 &p13, const T14 &p14, const T15 &p15) { \
	table_override_ = 0; \
    C1 = p1;\
    C2 = p2;\
    C3 = p3;\
    C4 = p4;\
    C5 = p5;\
    C6 = p6;\
    C7 = p7;\
    C8 = p8;\
    C9 = p9;\
    C10 = p10;\
    C11 = p11;\
    C12 = p12;\
    C13 = p13;\
    C14 = p14;\
    C15 = p15;\
 \
	} \
	NAME(const T1 &p1, const T2 &p2, const T3 &p3, const T4 &p4, const T5 &p5, const T6 &p6, const T7 &p7, const T8 &p8, const T9 &p9, const T10 &p10, const T11 &p11, const T12 &p12, const T13 &p13, const T14 &p14, const T15 &p15) : C1 (p1), C2 (p2), C3 (p3), C4 (p4), C5 (p5), C6 (p6), C7 (p7), C8 (p8), C9 (p9), C10 (p10), C11 (p11), C12 (p12), C13 (p13), C14 (p14), C15 (p15), table_override_(0) {}

#define sql_compare_type_def_15(NAME, WHAT, NUM) \
	return WHAT##_list(d, m, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true)

#define sql_compare_type_defe_15(NAME, WHAT, NUM) \
	return WHAT##_list(d, c, m, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true)

#define sql_COMPARE__15(NAME, C1, C2, C3, C4, C5, C6, C7, C8, C9, C10, C11, C12, C13, C14, C15, C16, C17, C18, C19, C20, C21, C22, C23, C24, C25) \
	template <mysqlpp::sql_dummy_type dummy> \
	int sql_compare_##NAME(const NAME &x, const NAME &y) { \
    int cmp; \
    cmp = mysqlpp::sql_cmp(x.C1 , y.C1 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C2 , y.C2 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C3 , y.C3 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C4 , y.C4 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C5 , y.C5 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C6 , y.C6 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C7 , y.C7 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C8 , y.C8 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C9 , y.C9 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C10 , y.C10 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C11 , y.C11 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C12 , y.C12 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C13 , y.C13 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C14 , y.C14 ); \
    if (cmp) return cmp; \
    return mysqlpp::sql_cmp(x.C15 , y.C15 ); \
	} \
	template <mysqlpp::sql_dummy_type dummy> \
	int compare (const NAME &x, const NAME &y) { \
    int cmp; \
    cmp = mysqlpp::sql_cmp(x.C1 , y.C1 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C2 , y.C2 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C3 , y.C3 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C4 , y.C4 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C5 , y.C5 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C6 , y.C6 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C7 , y.C7 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C8 , y.C8 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C9 , y.C9 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C10 , y.C10 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C11 , y.C11 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C12 , y.C12 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C13 , y.C13 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C14 , y.C14 ); \
    if (cmp) return cmp; \
    return mysqlpp::sql_cmp(x.C15 , y.C15 ); \
	}

// ---------------------------------------------------
//                   End Compare 15
// ---------------------------------------------------


// ---------------------------------------------------
//                   Begin Compare 16
// ---------------------------------------------------

#define sql_compare_define_16(NAME, T1, C1, T2, C2, T3, C3, T4, C4, T5, C5, T6, C6, T7, C7, T8, C8, T9, C9, T10, C10, T11, C11, T12, C12, T13, C13, T14, C14, T15, C15, T16, C16, T17, C17, T18, C18, T19, C19, T20, C20, T21, C21, T22, C22, T23, C23, T24, C24, T25, C25) \
	NAME(const T1 &p1, const T2 &p2, const T3 &p3, const T4 &p4, const T5 &p5, const T6 &p6, const T7 &p7, const T8 &p8, const T9 &p9, const T10 &p10, const T11 &p11, const T12 &p12, const T13 &p13, const T14 &p14, const T15 &p15, const T16 &p16) : C1 (p1), C2 (p2), C3 (p3), C4 (p4), C5 (p5), C6 (p6), C7 (p7), C8 (p8), C9 (p9), C10 (p10), C11 (p11), C12 (p12), C13 (p13), C14 (p14), C15 (p15), C16 (p16), table_override_(0) {} \
	void set(const T1 &p1, const T2 &p2, const T3 &p3, const T4 &p4, const T5 &p5, const T6 &p6, const T7 &p7, const T8 &p8, const T9 &p9, const T10 &p10, const T11 &p11, const T12 &p12, const T13 &p13, const T14 &p14, const T15 &p15, const T16 &p16) { \
	table_override_ = 0; \
    C1 = p1;\
    C2 = p2;\
    C3 = p3;\
    C4 = p4;\
    C5 = p5;\
    C6 = p6;\
    C7 = p7;\
    C8 = p8;\
    C9 = p9;\
    C10 = p10;\
    C11 = p11;\
    C12 = p12;\
    C13 = p13;\
    C14 = p14;\
    C15 = p15;\
    C16 = p16;\
 \
	} \
	sql_compare_define(NAME)

#define sql_construct_define_16(NAME, T1, C1, T2, C2, T3, C3, T4, C4, T5, C5, T6, C6, T7, C7, T8, C8, T9, C9, T10, C10, T11, C11, T12, C12, T13, C13, T14, C14, T15, C15, T16, C16, T17, C17, T18, C18, T19, C19, T20, C20, T21, C21, T22, C22, T23, C23, T24, C24, T25, C25) \
	void set(const T1 &p1, const T2 &p2, const T3 &p3, const T4 &p4, const T5 &p5, const T6 &p6, const T7 &p7, const T8 &p8, const T9 &p9, const T10 &p10, const T11 &p11, const T12 &p12, const T13 &p13, const T14 &p14, const T15 &p15, const T16 &p16) { \
	table_override_ = 0; \
    C1 = p1;\
    C2 = p2;\
    C3 = p3;\
    C4 = p4;\
    C5 = p5;\
    C6 = p6;\
    C7 = p7;\
    C8 = p8;\
    C9 = p9;\
    C10 = p10;\
    C11 = p11;\
    C12 = p12;\
    C13 = p13;\
    C14 = p14;\
    C15 = p15;\
    C16 = p16;\
 \
	} \
	NAME(const T1 &p1, const T2 &p2, const T3 &p3, const T4 &p4, const T5 &p5, const T6 &p6, const T7 &p7, const T8 &p8, const T9 &p9, const T10 &p10, const T11 &p11, const T12 &p12, const T13 &p13, const T14 &p14, const T15 &p15, const T16 &p16) : C1 (p1), C2 (p2), C3 (p3), C4 (p4), C5 (p5), C6 (p6), C7 (p7), C8 (p8), C9 (p9), C10 (p10), C11 (p11), C12 (p12), C13 (p13), C14 (p14), C15 (p15), C16 (p16), table_override_(0) {}

#define sql_compare_type_def_16(NAME, WHAT, NUM) \
	return WHAT##_list(d, m, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true)

#define sql_compare_type_defe_16(NAME, WHAT, NUM) \
	return WHAT##_list(d, c, m, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true)

#define sql_COMPARE__16(NAME, C1, C2, C3, C4, C5, C6, C7, C8, C9, C10, C11, C12, C13, C14, C15, C16, C17, C18, C19, C20, C21, C22, C23, C24, C25) \
	template <mysqlpp::sql_dummy_type dummy> \
	int sql_compare_##NAME(const NAME &x, const NAME &y) { \
    int cmp; \
    cmp = mysqlpp::sql_cmp(x.C1 , y.C1 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C2 , y.C2 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C3 , y.C3 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C4 , y.C4 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C5 , y.C5 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C6 , y.C6 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C7 , y.C7 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C8 , y.C8 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C9 , y.C9 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C10 , y.C10 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C11 , y.C11 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C12 , y.C12 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C13 , y.C13 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C14 , y.C14 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C15 , y.C15 ); \
    if (cmp) return cmp; \
    return mysqlpp::sql_cmp(x.C16 , y.C16 ); \
	} \
	template <mysqlpp::sql_dummy_type dummy> \
	int compare (const NAME &x, const NAME &y) { \
    int cmp; \
    cmp = mysqlpp::sql_cmp(x.C1 , y.C1 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C2 , y.C2 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C3 , y.C3 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C4 , y.C4 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C5 , y.C5 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C6 , y.C6 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C7 , y.C7 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C8 , y.C8 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C9 , y.C9 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C10 , y.C10 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C11 , y.C11 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C12 , y.C12 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C13 , y.C13 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C14 , y.C14 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C15 , y.C15 ); \
    if (cmp) return cmp; \
    return mysqlpp::sql_cmp(x.C16 , y.C16 ); \
	}

// ---------------------------------------------------
//                   End Compare 16
// ---------------------------------------------------


// ---------------------------------------------------
//                   Begin Compare 17
// ---------------------------------------------------

#define sql_compare_define_17(NAME, T1, C1, T2, C2, T3, C3, T4, C4, T5, C5, T6, C6, T7, C7, T8, C8, T9, C9, T10, C10, T11, C11, T12, C12, T13, C13, T14, C14, T15, C15, T16, C16, T17, C17, T18, C18, T19, C19, T20, C20, T21, C21, T22, C22, T23, C23, T24, C24, T25, C25) \
	NAME(const T1 &p1, const T2 &p2, const T3 &p3, const T4 &p4, const T5 &p5, const T6 &p6, const T7 &p7, const T8 &p8, const T9 &p9, const T10 &p10, const T11 &p11, const T12 &p12, const T13 &p13, const T14 &p14, const T15 &p15, const T16 &p16, const T17 &p17) : C1 (p1), C2 (p2), C3 (p3), C4 (p4), C5 (p5), C6 (p6), C7 (p7), C8 (p8), C9 (p9), C10 (p10), C11 (p11), C12 (p12), C13 (p13), C14 (p14), C15 (p15), C16 (p16), C17 (p17), table_override_(0) {} \
	void set(const T1 &p1, const T2 &p2, const T3 &p3, const T4 &p4, const T5 &p5, const T6 &p6, const T7 &p7, const T8 &p8, const T9 &p9, const T10 &p10, const T11 &p11, const T12 &p12, const T13 &p13, const T14 &p14, const T15 &p15, const T16 &p16, const T17 &p17) { \
	table_override_ = 0; \
    C1 = p1;\
    C2 = p2;\
    C3 = p3;\
    C4 = p4;\
    C5 = p5;\
    C6 = p6;\
    C7 = p7;\
    C8 = p8;\
    C9 = p9;\
    C10 = p10;\
    C11 = p11;\
    C12 = p12;\
    C13 = p13;\
    C14 = p14;\
    C15 = p15;\
    C16 = p16;\
    C17 = p17;\
 \
	} \
	sql_compare_define(NAME)

#define sql_construct_define_17(NAME, T1, C1, T2, C2, T3, C3, T4, C4, T5, C5, T6, C6, T7, C7, T8, C8, T9, C9, T10, C10, T11, C11, T12, C12, T13, C13, T14, C14, T15, C15, T16, C16, T17, C17, T18, C18, T19, C19, T20, C20, T21, C21, T22, C22, T23, C23, T24, C24, T25, C25) \
	void set(const T1 &p1, const T2 &p2, const T3 &p3, const T4 &p4, const T5 &p5, const T6 &p6, const T7 &p7, const T8 &p8, const T9 &p9, const T10 &p10, const T11 &p11, const T12 &p12, const T13 &p13, const T14 &p14, const T15 &p15, const T16 &p16, const T17 &p17) { \
	table_override_ = 0; \
    C1 = p1;\
    C2 = p2;\
    C3 = p3;\
    C4 = p4;\
    C5 = p5;\
    C6 = p6;\
    C7 = p7;\
    C8 = p8;\
    C9 = p9;\
    C10 = p10;\
    C11 = p11;\
    C12 = p12;\
    C13 = p13;\
    C14 = p14;\
    C15 = p15;\
    C16 = p16;\
    C17 = p17;\
 \
	} \
	NAME(const T1 &p1, const T2 &p2, const T3 &p3, const T4 &p4, const T5 &p5, const T6 &p6, const T7 &p7, const T8 &p8, const T9 &p9, const T10 &p10, const T11 &p11, const T12 &p12, const T13 &p13, const T14 &p14, const T15 &p15, const T16 &p16, const T17 &p17) : C1 (p1), C2 (p2), C3 (p3), C4 (p4), C5 (p5), C6 (p6), C7 (p7), C8 (p8), C9 (p9), C10 (p10), C11 (p11), C12 (p12), C13 (p13), C14 (p14), C15 (p15), C16 (p16), C17 (p17), table_override_(0) {}

#define sql_compare_type_def_17(NAME, WHAT, NUM) \
	return WHAT##_list(d, m, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true)

#define sql_compare_type_defe_17(NAME, WHAT, NUM) \
	return WHAT##_list(d, c, m, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true)

#define sql_COMPARE__17(NAME, C1, C2, C3, C4, C5, C6, C7, C8, C9, C10, C11, C12, C13, C14, C15, C16, C17, C18, C19, C20, C21, C22, C23, C24, C25) \
	template <mysqlpp::sql_dummy_type dummy> \
	int sql_compare_##NAME(const NAME &x, const NAME &y) { \
    int cmp; \
    cmp = mysqlpp::sql_cmp(x.C1 , y.C1 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C2 , y.C2 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C3 , y.C3 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C4 , y.C4 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C5 , y.C5 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C6 , y.C6 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C7 , y.C7 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C8 , y.C8 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C9 , y.C9 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C10 , y.C10 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C11 , y.C11 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C12 , y.C12 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C13 , y.C13 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C14 , y.C14 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C15 , y.C15 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C16 , y.C16 ); \
    if (cmp) return cmp; \
    return mysqlpp::sql_cmp(x.C17 , y.C17 ); \
	} \
	template <mysqlpp::sql_dummy_type dummy> \
	int compare (const NAME &x, const NAME &y) { \
    int cmp; \
    cmp = mysqlpp::sql_cmp(x.C1 , y.C1 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C2 , y.C2 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C3 , y.C3 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C4 , y.C4 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C5 , y.C5 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C6 , y.C6 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C7 , y.C7 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C8 , y.C8 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C9 , y.C9 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C10 , y.C10 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C11 , y.C11 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C12 , y.C12 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C13 , y.C13 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C14 , y.C14 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C15 , y.C15 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C16 , y.C16 ); \
    if (cmp) return cmp; \
    return mysqlpp::sql_cmp(x.C17 , y.C17 ); \
	}

// ---------------------------------------------------
//                   End Compare 17
// ---------------------------------------------------


// ---------------------------------------------------
//                   Begin Compare 18
// ---------------------------------------------------

#define sql_compare_define_18(NAME, T1, C1, T2, C2, T3, C3, T4, C4, T5, C5, T6, C6, T7, C7, T8, C8, T9, C9, T10, C10, T11, C11, T12, C12, T13, C13, T14, C14, T15, C15, T16, C16, T17, C17, T18, C18, T19, C19, T20, C20, T21, C21, T22, C22, T23, C23, T24, C24, T25, C25) \
	NAME(const T1 &p1, const T2 &p2, const T3 &p3, const T4 &p4, const T5 &p5, const T6 &p6, const T7 &p7, const T8 &p8, const T9 &p9, const T10 &p10, const T11 &p11, const T12 &p12, const T13 &p13, const T14 &p14, const T15 &p15, const T16 &p16, const T17 &p17, const T18 &p18) : C1 (p1), C2 (p2), C3 (p3), C4 (p4), C5 (p5), C6 (p6), C7 (p7), C8 (p8), C9 (p9), C10 (p10), C11 (p11), C12 (p12), C13 (p13), C14 (p14), C15 (p15), C16 (p16), C17 (p17), C18 (p18), table_override_(0) {} \
	void set(const T1 &p1, const T2 &p2, const T3 &p3, const T4 &p4, const T5 &p5, const T6 &p6, const T7 &p7, const T8 &p8, const T9 &p9, const T10 &p10, const T11 &p11, const T12 &p12, const T13 &p13, const T14 &p14, const T15 &p15, const T16 &p16, const T17 &p17, const T18 &p18) { \
	table_override_ = 0; \
    C1 = p1;\
    C2 = p2;\
    C3 = p3;\
    C4 = p4;\
    C5 = p5;\
    C6 = p6;\
    C7 = p7;\
    C8 = p8;\
    C9 = p9;\
    C10 = p10;\
    C11 = p11;\
    C12 = p12;\
    C13 = p13;\
    C14 = p14;\
    C15 = p15;\
    C16 = p16;\
    C17 = p17;\
    C18 = p18;\
 \
	} \
	sql_compare_define(NAME)

#define sql_construct_define_18(NAME, T1, C1, T2, C2, T3, C3, T4, C4, T5, C5, T6, C6, T7, C7, T8, C8, T9, C9, T10, C10, T11, C11, T12, C12, T13, C13, T14, C14, T15, C15, T16, C16, T17, C17, T18, C18, T19, C19, T20, C20, T21, C21, T22, C22, T23, C23, T24, C24, T25, C25) \
	void set(const T1 &p1, const T2 &p2, const T3 &p3, const T4 &p4, const T5 &p5, const T6 &p6, const T7 &p7, const T8 &p8, const T9 &p9, const T10 &p10, const T11 &p11, const T12 &p12, const T13 &p13, const T14 &p14, const T15 &p15, const T16 &p16, const T17 &p17, const T18 &p18) { \
	table_override_ = 0; \
    C1 = p1;\
    C2 = p2;\
    C3 = p3;\
    C4 = p4;\
    C5 = p5;\
    C6 = p6;\
    C7 = p7;\
    C8 = p8;\
    C9 = p9;\
    C10 = p10;\
    C11 = p11;\
    C12 = p12;\
    C13 = p13;\
    C14 = p14;\
    C15 = p15;\
    C16 = p16;\
    C17 = p17;\
    C18 = p18;\
 \
	} \
	NAME(const T1 &p1, const T2 &p2, const T3 &p3, const T4 &p4, const T5 &p5, const T6 &p6, const T7 &p7, const T8 &p8, const T9 &p9, const T10 &p10, const T11 &p11, const T12 &p12, const T13 &p13, const T14 &p14, const T15 &p15, const T16 &p16, const T17 &p17, const T18 &p18) : C1 (p1), C2 (p2), C3 (p3), C4 (p4), C5 (p5), C6 (p6), C7 (p7), C8 (p8), C9 (p9), C10 (p10), C11 (p11), C12 (p12), C13 (p13), C14 (p14), C15 (p15), C16 (p16), C17 (p17), C18 (p18), table_override_(0) {}

#define sql_compare_type_def_18(NAME, WHAT, NUM) \
	return WHAT##_list(d, m, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true)

#define sql_compare_type_defe_18(NAME, WHAT, NUM) \
	return WHAT##_list(d, c, m, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true)

#define sql_COMPARE__18(NAME, C1, C2, C3, C4, C5, C6, C7, C8, C9, C10, C11, C12, C13, C14, C15, C16, C17, C18, C19, C20, C21, C22, C23, C24, C25) \
	template <mysqlpp::sql_dummy_type dummy> \
	int sql_compare_##NAME(const NAME &x, const NAME &y) { \
    int cmp; \
    cmp = mysqlpp::sql_cmp(x.C1 , y.C1 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C2 , y.C2 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C3 , y.C3 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C4 , y.C4 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C5 , y.C5 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C6 , y.C6 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C7 , y.C7 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C8 , y.C8 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C9 , y.C9 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C10 , y.C10 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C11 , y.C11 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C12 , y.C12 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C13 , y.C13 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C14 , y.C14 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C15 , y.C15 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C16 , y.C16 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C17 , y.C17 ); \
    if (cmp) return cmp; \
    return mysqlpp::sql_cmp(x.C18 , y.C18 ); \
	} \
	template <mysqlpp::sql_dummy_type dummy> \
	int compare (const NAME &x, const NAME &y) { \
    int cmp; \
    cmp = mysqlpp::sql_cmp(x.C1 , y.C1 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C2 , y.C2 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C3 , y.C3 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C4 , y.C4 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C5 , y.C5 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C6 , y.C6 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C7 , y.C7 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C8 , y.C8 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C9 , y.C9 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C10 , y.C10 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C11 , y.C11 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C12 , y.C12 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C13 , y.C13 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C14 , y.C14 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C15 , y.C15 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C16 , y.C16 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C17 , y.C17 ); \
    if (cmp) return cmp; \
    return mysqlpp::sql_cmp(x.C18 , y.C18 ); \
	}

// ---------------------------------------------------
//                   End Compare 18
// ---------------------------------------------------


// ---------------------------------------------------
//                   Begin Compare 19
// ---------------------------------------------------

#define sql_compare_define_19(NAME, T1, C1, T2, C2, T3, C3, T4, C4, T5, C5, T6, C6, T7, C7, T8, C8, T9, C9, T10, C10, T11, C11, T12, C12, T13, C13, T14, C14, T15, C15, T16, C16, T17, C17, T18, C18, T19, C19, T20, C20, T21, C21, T22, C22, T23, C23, T24, C24, T25, C25) \
	NAME(const T1 &p1, const T2 &p2, const T3 &p3, const T4 &p4, const T5 &p5, const T6 &p6, const T7 &p7, const T8 &p8, const T9 &p9, const T10 &p10, const T11 &p11, const T12 &p12, const T13 &p13, const T14 &p14, const T15 &p15, const T16 &p16, const T17 &p17, const T18 &p18, const T19 &p19) : C1 (p1), C2 (p2), C3 (p3), C4 (p4), C5 (p5), C6 (p6), C7 (p7), C8 (p8), C9 (p9), C10 (p10), C11 (p11), C12 (p12), C13 (p13), C14 (p14), C15 (p15), C16 (p16), C17 (p17), C18 (p18), C19 (p19), table_override_(0) {} \
	void set(const T1 &p1, const T2 &p2, const T3 &p3, const T4 &p4, const T5 &p5, const T6 &p6, const T7 &p7, const T8 &p8, const T9 &p9, const T10 &p10, const T11 &p11, const T12 &p12, const T13 &p13, const T14 &p14, const T15 &p15, const T16 &p16, const T17 &p17, const T18 &p18, const T19 &p19) { \
	table_override_ = 0; \
    C1 = p1;\
    C2 = p2;\
    C3 = p3;\
    C4 = p4;\
    C5 = p5;\
    C6 = p6;\
    C7 = p7;\
    C8 = p8;\
    C9 = p9;\
    C10 = p10;\
    C11 = p11;\
    C12 = p12;\
    C13 = p13;\
    C14 = p14;\
    C15 = p15;\
    C16 = p16;\
    C17 = p17;\
    C18 = p18;\
    C19 = p19;\
 \
	} \
	sql_compare_define(NAME)

#define sql_construct_define_19(NAME, T1, C1, T2, C2, T3, C3, T4, C4, T5, C5, T6, C6, T7, C7, T8, C8, T9, C9, T10, C10, T11, C11, T12, C12, T13, C13, T14, C14, T15, C15, T16, C16, T17, C17, T18, C18, T19, C19, T20, C20, T21, C21, T22, C22, T23, C23, T24, C24, T25, C25) \
	void set(const T1 &p1, const T2 &p2, const T3 &p3, const T4 &p4, const T5 &p5, const T6 &p6, const T7 &p7, const T8 &p8, const T9 &p9, const T10 &p10, const T11 &p11, const T12 &p12, const T13 &p13, const T14 &p14, const T15 &p15, const T16 &p16, const T17 &p17, const T18 &p18, const T19 &p19) { \
	table_override_ = 0; \
    C1 = p1;\
    C2 = p2;\
    C3 = p3;\
    C4 = p4;\
    C5 = p5;\
    C6 = p6;\
    C7 = p7;\
    C8 = p8;\
    C9 = p9;\
    C10 = p10;\
    C11 = p11;\
    C12 = p12;\
    C13 = p13;\
    C14 = p14;\
    C15 = p15;\
    C16 = p16;\
    C17 = p17;\
    C18 = p18;\
    C19 = p19;\
 \
	} \
	NAME(const T1 &p1, const T2 &p2, const T3 &p3, const T4 &p4, const T5 &p5, const T6 &p6, const T7 &p7, const T8 &p8, const T9 &p9, const T10 &p10, const T11 &p11, const T12 &p12, const T13 &p13, const T14 &p14, const T15 &p15, const T16 &p16, const T17 &p17, const T18 &p18, const T19 &p19) : C1 (p1), C2 (p2), C3 (p3), C4 (p4), C5 (p5), C6 (p6), C7 (p7), C8 (p8), C9 (p9), C10 (p10), C11 (p11), C12 (p12), C13 (p13), C14 (p14), C15 (p15), C16 (p16), C17 (p17), C18 (p18), C19 (p19), table_override_(0) {}

#define sql_compare_type_def_19(NAME, WHAT, NUM) \
	return WHAT##_list(d, m, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true)

#define sql_compare_type_defe_19(NAME, WHAT, NUM) \
	return WHAT##_list(d, c, m, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true)

#define sql_COMPARE__19(NAME, C1, C2, C3, C4, C5, C6, C7, C8, C9, C10, C11, C12, C13, C14, C15, C16, C17, C18, C19, C20, C21, C22, C23, C24, C25) \
	template <mysqlpp::sql_dummy_type dummy> \
	int sql_compare_##NAME(const NAME &x, const NAME &y) { \
    int cmp; \
    cmp = mysqlpp::sql_cmp(x.C1 , y.C1 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C2 , y.C2 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C3 , y.C3 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C4 , y.C4 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C5 , y.C5 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C6 , y.C6 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C7 , y.C7 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C8 , y.C8 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C9 , y.C9 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C10 , y.C10 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C11 , y.C11 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C12 , y.C12 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C13 , y.C13 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C14 , y.C14 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C15 , y.C15 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C16 , y.C16 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C17 , y.C17 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C18 , y.C18 ); \
    if (cmp) return cmp; \
    return mysqlpp::sql_cmp(x.C19 , y.C19 ); \
	} \
	template <mysqlpp::sql_dummy_type dummy> \
	int compare (const NAME &x, const NAME &y) { \
    int cmp; \
    cmp = mysqlpp::sql_cmp(x.C1 , y.C1 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C2 , y.C2 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C3 , y.C3 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C4 , y.C4 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C5 , y.C5 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C6 , y.C6 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C7 , y.C7 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C8 , y.C8 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C9 , y.C9 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C10 , y.C10 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C11 , y.C11 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C12 , y.C12 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C13 , y.C13 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C14 , y.C14 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C15 , y.C15 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C16 , y.C16 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C17 , y.C17 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C18 , y.C18 ); \
    if (cmp) return cmp; \
    return mysqlpp::sql_cmp(x.C19 , y.C19 ); \
	}

// ---------------------------------------------------
//                   End Compare 19
// ---------------------------------------------------


// ---------------------------------------------------
//                   Begin Compare 20
// ---------------------------------------------------

#define sql_compare_define_20(NAME, T1, C1, T2, C2, T3, C3, T4, C4, T5, C5, T6, C6, T7, C7, T8, C8, T9, C9, T10, C10, T11, C11, T12, C12, T13, C13, T14, C14, T15, C15, T16, C16, T17, C17, T18, C18, T19, C19, T20, C20, T21, C21, T22, C22, T23, C23, T24, C24, T25, C25) \
	NAME(const T1 &p1, const T2 &p2, const T3 &p3, const T4 &p4, const T5 &p5, const T6 &p6, const T7 &p7, const T8 &p8, const T9 &p9, const T10 &p10, const T11 &p11, const T12 &p12, const T13 &p13, const T14 &p14, const T15 &p15, const T16 &p16, const T17 &p17, const T18 &p18, const T19 &p19, const T20 &p20) : C1 (p1), C2 (p2), C3 (p3), C4 (p4), C5 (p5), C6 (p6), C7 (p7), C8 (p8), C9 (p9), C10 (p10), C11 (p11), C12 (p12), C13 (p13), C14 (p14), C15 (p15), C16 (p16), C17 (p17), C18 (p18), C19 (p19), C20 (p20), table_override_(0) {} \
	void set(const T1 &p1, const T2 &p2, const T3 &p3, const T4 &p4, const T5 &p5, const T6 &p6, const T7 &p7, const T8 &p8, const T9 &p9, const T10 &p10, const T11 &p11, const T12 &p12, const T13 &p13, const T14 &p14, const T15 &p15, const T16 &p16, const T17 &p17, const T18 &p18, const T19 &p19, const T20 &p20) { \
	table_override_ = 0; \
    C1 = p1;\
    C2 = p2;\
    C3 = p3;\
    C4 = p4;\
    C5 = p5;\
    C6 = p6;\
    C7 = p7;\
    C8 = p8;\
    C9 = p9;\
    C10 = p10;\
    C11 = p11;\
    C12 = p12;\
    C13 = p13;\
    C14 = p14;\
    C15 = p15;\
    C16 = p16;\
    C17 = p17;\
    C18 = p18;\
    C19 = p19;\
    C20 = p20;\
 \
	} \
	sql_compare_define(NAME)

#define sql_construct_define_20(NAME, T1, C1, T2, C2, T3, C3, T4, C4, T5, C5, T6, C6, T7, C7, T8, C8, T9, C9, T10, C10, T11, C11, T12, C12, T13, C13, T14, C14, T15, C15, T16, C16, T17, C17, T18, C18, T19, C19, T20, C20, T21, C21, T22, C22, T23, C23, T24, C24, T25, C25) \
	void set(const T1 &p1, const T2 &p2, const T3 &p3, const T4 &p4, const T5 &p5, const T6 &p6, const T7 &p7, const T8 &p8, const T9 &p9, const T10 &p10, const T11 &p11, const T12 &p12, const T13 &p13, const T14 &p14, const T15 &p15, const T16 &p16, const T17 &p17, const T18 &p18, const T19 &p19, const T20 &p20) { \
	table_override_ = 0; \
    C1 = p1;\
    C2 = p2;\
    C3 = p3;\
    C4 = p4;\
    C5 = p5;\
    C6 = p6;\
    C7 = p7;\
    C8 = p8;\
    C9 = p9;\
    C10 = p10;\
    C11 = p11;\
    C12 = p12;\
    C13 = p13;\
    C14 = p14;\
    C15 = p15;\
    C16 = p16;\
    C17 = p17;\
    C18 = p18;\
    C19 = p19;\
    C20 = p20;\
 \
	} \
	NAME(const T1 &p1, const T2 &p2, const T3 &p3, const T4 &p4, const T5 &p5, const T6 &p6, const T7 &p7, const T8 &p8, const T9 &p9, const T10 &p10, const T11 &p11, const T12 &p12, const T13 &p13, const T14 &p14, const T15 &p15, const T16 &p16, const T17 &p17, const T18 &p18, const T19 &p19, const T20 &p20) : C1 (p1), C2 (p2), C3 (p3), C4 (p4), C5 (p5), C6 (p6), C7 (p7), C8 (p8), C9 (p9), C10 (p10), C11 (p11), C12 (p12), C13 (p13), C14 (p14), C15 (p15), C16 (p16), C17 (p17), C18 (p18), C19 (p19), C20 (p20), table_override_(0) {}

#define sql_compare_type_def_20(NAME, WHAT, NUM) \
	return WHAT##_list(d, m, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true)

#define sql_compare_type_defe_20(NAME, WHAT, NUM) \
	return WHAT##_list(d, c, m, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true)

#define sql_COMPARE__20(NAME, C1, C2, C3, C4, C5, C6, C7, C8, C9, C10, C11, C12, C13, C14, C15, C16, C17, C18, C19, C20, C21, C22, C23, C24, C25) \
	template <mysqlpp::sql_dummy_type dummy> \
	int sql_compare_##NAME(const NAME &x, const NAME &y) { \
    int cmp; \
    cmp = mysqlpp::sql_cmp(x.C1 , y.C1 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C2 , y.C2 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C3 , y.C3 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C4 , y.C4 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C5 , y.C5 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C6 , y.C6 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C7 , y.C7 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C8 , y.C8 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C9 , y.C9 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C10 , y.C10 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C11 , y.C11 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C12 , y.C12 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C13 , y.C13 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C14 , y.C14 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C15 , y.C15 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C16 , y.C16 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C17 , y.C17 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C18 , y.C18 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C19 , y.C19 ); \
    if (cmp) return cmp; \
    return mysqlpp::sql_cmp(x.C20 , y.C20 ); \
	} \
	template <mysqlpp::sql_dummy_type dummy> \
	int compare (const NAME &x, const NAME &y) { \
    int cmp; \
    cmp = mysqlpp::sql_cmp(x.C1 , y.C1 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C2 , y.C2 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C3 , y.C3 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C4 , y.C4 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C5 , y.C5 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C6 , y.C6 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C7 , y.C7 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C8 , y.C8 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C9 , y.C9 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C10 , y.C10 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C11 , y.C11 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C12 , y.C12 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C13 , y.C13 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C14 , y.C14 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C15 , y.C15 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C16 , y.C16 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C17 , y.C17 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C18 , y.C18 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C19 , y.C19 ); \
    if (cmp) return cmp; \
    return mysqlpp::sql_cmp(x.C20 , y.C20 ); \
	}

// ---------------------------------------------------
//                   End Compare 20
// ---------------------------------------------------


// ---------------------------------------------------
//                   Begin Compare 21
// ---------------------------------------------------

#define sql_compare_define_21(NAME, T1, C1, T2, C2, T3, C3, T4, C4, T5, C5, T6, C6, T7, C7, T8, C8, T9, C9, T10, C10, T11, C11, T12, C12, T13, C13, T14, C14, T15, C15, T16, C16, T17, C17, T18, C18, T19, C19, T20, C20, T21, C21, T22, C22, T23, C23, T24, C24, T25, C25) \
	NAME(const T1 &p1, const T2 &p2, const T3 &p3, const T4 &p4, const T5 &p5, const T6 &p6, const T7 &p7, const T8 &p8, const T9 &p9, const T10 &p10, const T11 &p11, const T12 &p12, const T13 &p13, const T14 &p14, const T15 &p15, const T16 &p16, const T17 &p17, const T18 &p18, const T19 &p19, const T20 &p20, const T21 &p21) : C1 (p1), C2 (p2), C3 (p3), C4 (p4), C5 (p5), C6 (p6), C7 (p7), C8 (p8), C9 (p9), C10 (p10), C11 (p11), C12 (p12), C13 (p13), C14 (p14), C15 (p15), C16 (p16), C17 (p17), C18 (p18), C19 (p19), C20 (p20), C21 (p21), table_override_(0) {} \
	void set(const T1 &p1, const T2 &p2, const T3 &p3, const T4 &p4, const T5 &p5, const T6 &p6, const T7 &p7, const T8 &p8, const T9 &p9, const T10 &p10, const T11 &p11, const T12 &p12, const T13 &p13, const T14 &p14, const T15 &p15, const T16 &p16, const T17 &p17, const T18 &p18, const T19 &p19, const T20 &p20, const T21 &p21) { \
	table_override_ = 0; \
    C1 = p1;\
    C2 = p2;\
    C3 = p3;\
    C4 = p4;\
    C5 = p5;\
    C6 = p6;\
    C7 = p7;\
    C8 = p8;\
    C9 = p9;\
    C10 = p10;\
    C11 = p11;\
    C12 = p12;\
    C13 = p13;\
    C14 = p14;\
    C15 = p15;\
    C16 = p16;\
    C17 = p17;\
    C18 = p18;\
    C19 = p19;\
    C20 = p20;\
    C21 = p21;\
 \
	} \
	sql_compare_define(NAME)

#define sql_construct_define_21(NAME, T1, C1, T2, C2, T3, C3, T4, C4, T5, C5, T6, C6, T7, C7, T8, C8, T9, C9, T10, C10, T11, C11, T12, C12, T13, C13, T14, C14, T15, C15, T16, C16, T17, C17, T18, C18, T19, C19, T20, C20, T21, C21, T22, C22, T23, C23, T24, C24, T25, C25) \
	void set(const T1 &p1, const T2 &p2, const T3 &p3, const T4 &p4, const T5 &p5, const T6 &p6, const T7 &p7, const T8 &p8, const T9 &p9, const T10 &p10, const T11 &p11, const T12 &p12, const T13 &p13, const T14 &p14, const T15 &p15, const T16 &p16, const T17 &p17, const T18 &p18, const T19 &p19, const T20 &p20, const T21 &p21) { \
	table_override_ = 0; \
    C1 = p1;\
    C2 = p2;\
    C3 = p3;\
    C4 = p4;\
    C5 = p5;\
    C6 = p6;\
    C7 = p7;\
    C8 = p8;\
    C9 = p9;\
    C10 = p10;\
    C11 = p11;\
    C12 = p12;\
    C13 = p13;\
    C14 = p14;\
    C15 = p15;\
    C16 = p16;\
    C17 = p17;\
    C18 = p18;\
    C19 = p19;\
    C20 = p20;\
    C21 = p21;\
 \
	} \
	NAME(const T1 &p1, const T2 &p2, const T3 &p3, const T4 &p4, const T5 &p5, const T6 &p6, const T7 &p7, const T8 &p8, const T9 &p9, const T10 &p10, const T11 &p11, const T12 &p12, const T13 &p13, const T14 &p14, const T15 &p15, const T16 &p16, const T17 &p17, const T18 &p18, const T19 &p19, const T20 &p20, const T21 &p21) : C1 (p1), C2 (p2), C3 (p3), C4 (p4), C5 (p5), C6 (p6), C7 (p7), C8 (p8), C9 (p9), C10 (p10), C11 (p11), C12 (p12), C13 (p13), C14 (p14), C15 (p15), C16 (p16), C17 (p17), C18 (p18), C19 (p19), C20 (p20), C21 (p21), table_override_(0) {}

#define sql_compare_type_def_21(NAME, WHAT, NUM) \
	return WHAT##_list(d, m, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true)

#define sql_compare_type_defe_21(NAME, WHAT, NUM) \
	return WHAT##_list(d, c, m, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true)

#define sql_COMPARE__21(NAME, C1, C2, C3, C4, C5, C6, C7, C8, C9, C10, C11, C12, C13, C14, C15, C16, C17, C18, C19, C20, C21, C22, C23, C24, C25) \
	template <mysqlpp::sql_dummy_type dummy> \
	int sql_compare_##NAME(const NAME &x, const NAME &y) { \
    int cmp; \
    cmp = mysqlpp::sql_cmp(x.C1 , y.C1 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C2 , y.C2 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C3 , y.C3 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C4 , y.C4 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C5 , y.C5 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C6 , y.C6 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C7 , y.C7 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C8 , y.C8 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C9 , y.C9 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C10 , y.C10 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C11 , y.C11 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C12 , y.C12 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C13 , y.C13 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C14 , y.C14 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C15 , y.C15 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C16 , y.C16 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C17 , y.C17 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C18 , y.C18 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C19 , y.C19 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C20 , y.C20 ); \
    if (cmp) return cmp; \
    return mysqlpp::sql_cmp(x.C21 , y.C21 ); \
	} \
	template <mysqlpp::sql_dummy_type dummy> \
	int compare (const NAME &x, const NAME &y) { \
    int cmp; \
    cmp = mysqlpp::sql_cmp(x.C1 , y.C1 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C2 , y.C2 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C3 , y.C3 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C4 , y.C4 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C5 , y.C5 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C6 , y.C6 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C7 , y.C7 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C8 , y.C8 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C9 , y.C9 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C10 , y.C10 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C11 , y.C11 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C12 , y.C12 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C13 , y.C13 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C14 , y.C14 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C15 , y.C15 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C16 , y.C16 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C17 , y.C17 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C18 , y.C18 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C19 , y.C19 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C20 , y.C20 ); \
    if (cmp) return cmp; \
    return mysqlpp::sql_cmp(x.C21 , y.C21 ); \
	}

// ---------------------------------------------------
//                   End Compare 21
// ---------------------------------------------------


// ---------------------------------------------------
//                   Begin Compare 22
// ---------------------------------------------------

#define sql_compare_define_22(NAME, T1, C1, T2, C2, T3, C3, T4, C4, T5, C5, T6, C6, T7, C7, T8, C8, T9, C9, T10, C10, T11, C11, T12, C12, T13, C13, T14, C14, T15, C15, T16, C16, T17, C17, T18, C18, T19, C19, T20, C20, T21, C21, T22, C22, T23, C23, T24, C24, T25, C25) \
	NAME(const T1 &p1, const T2 &p2, const T3 &p3, const T4 &p4, const T5 &p5, const T6 &p6, const T7 &p7, const T8 &p8, const T9 &p9, const T10 &p10, const T11 &p11, const T12 &p12, const T13 &p13, const T14 &p14, const T15 &p15, const T16 &p16, const T17 &p17, const T18 &p18, const T19 &p19, const T20 &p20, const T21 &p21, const T22 &p22) : C1 (p1), C2 (p2), C3 (p3), C4 (p4), C5 (p5), C6 (p6), C7 (p7), C8 (p8), C9 (p9), C10 (p10), C11 (p11), C12 (p12), C13 (p13), C14 (p14), C15 (p15), C16 (p16), C17 (p17), C18 (p18), C19 (p19), C20 (p20), C21 (p21), C22 (p22), table_override_(0) {} \
	void set(const T1 &p1, const T2 &p2, const T3 &p3, const T4 &p4, const T5 &p5, const T6 &p6, const T7 &p7, const T8 &p8, const T9 &p9, const T10 &p10, const T11 &p11, const T12 &p12, const T13 &p13, const T14 &p14, const T15 &p15, const T16 &p16, const T17 &p17, const T18 &p18, const T19 &p19, const T20 &p20, const T21 &p21, const T22 &p22) { \
	table_override_ = 0; \
    C1 = p1;\
    C2 = p2;\
    C3 = p3;\
    C4 = p4;\
    C5 = p5;\
    C6 = p6;\
    C7 = p7;\
    C8 = p8;\
    C9 = p9;\
    C10 = p10;\
    C11 = p11;\
    C12 = p12;\
    C13 = p13;\
    C14 = p14;\
    C15 = p15;\
    C16 = p16;\
    C17 = p17;\
    C18 = p18;\
    C19 = p19;\
    C20 = p20;\
    C21 = p21;\
    C22 = p22;\
 \
	} \
	sql_compare_define(NAME)

#define sql_construct_define_22(NAME, T1, C1, T2, C2, T3, C3, T4, C4, T5, C5, T6, C6, T7, C7, T8, C8, T9, C9, T10, C10, T11, C11, T12, C12, T13, C13, T14, C14, T15, C15, T16, C16, T17, C17, T18, C18, T19, C19, T20, C20, T21, C21, T22, C22, T23, C23, T24, C24, T25, C25) \
	void set(const T1 &p1, const T2 &p2, const T3 &p3, const T4 &p4, const T5 &p5, const T6 &p6, const T7 &p7, const T8 &p8, const T9 &p9, const T10 &p10, const T11 &p11, const T12 &p12, const T13 &p13, const T14 &p14, const T15 &p15, const T16 &p16, const T17 &p17, const T18 &p18, const T19 &p19, const T20 &p20, const T21 &p21, const T22 &p22) { \
	table_override_ = 0; \
    C1 = p1;\
    C2 = p2;\
    C3 = p3;\
    C4 = p4;\
    C5 = p5;\
    C6 = p6;\
    C7 = p7;\
    C8 = p8;\
    C9 = p9;\
    C10 = p10;\
    C11 = p11;\
    C12 = p12;\
    C13 = p13;\
    C14 = p14;\
    C15 = p15;\
    C16 = p16;\
    C17 = p17;\
    C18 = p18;\
    C19 = p19;\
    C20 = p20;\
    C21 = p21;\
    C22 = p22;\
 \
	} \
	NAME(const T1 &p1, const T2 &p2, const T3 &p3, const T4 &p4, const T5 &p5, const T6 &p6, const T7 &p7, const T8 &p8, const T9 &p9, const T10 &p10, const T11 &p11, const T12 &p12, const T13 &p13, const T14 &p14, const T15 &p15, const T16 &p16, const T17 &p17, const T18 &p18, const T19 &p19, const T20 &p20, const T21 &p21, const T22 &p22) : C1 (p1), C2 (p2), C3 (p3), C4 (p4), C5 (p5), C6 (p6), C7 (p7), C8 (p8), C9 (p9), C10 (p10), C11 (p11), C12 (p12), C13 (p13), C14 (p14), C15 (p15), C16 (p16), C17 (p17), C18 (p18), C19 (p19), C20 (p20), C21 (p21), C22 (p22), table_override_(0) {}

#define sql_compare_type_def_22(NAME, WHAT, NUM) \
	return WHAT##_list(d, m, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true)

#define sql_compare_type_defe_22(NAME, WHAT, NUM) \
	return WHAT##_list(d, c, m, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true)

#define sql_COMPARE__22(NAME, C1, C2, C3, C4, C5, C6, C7, C8, C9, C10, C11, C12, C13, C14, C15, C16, C17, C18, C19, C20, C21, C22, C23, C24, C25) \
	template <mysqlpp::sql_dummy_type dummy> \
	int sql_compare_##NAME(const NAME &x, const NAME &y) { \
    int cmp; \
    cmp = mysqlpp::sql_cmp(x.C1 , y.C1 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C2 , y.C2 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C3 , y.C3 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C4 , y.C4 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C5 , y.C5 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C6 , y.C6 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C7 , y.C7 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C8 , y.C8 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C9 , y.C9 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C10 , y.C10 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C11 , y.C11 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C12 , y.C12 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C13 , y.C13 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C14 , y.C14 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C15 , y.C15 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C16 , y.C16 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C17 , y.C17 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C18 , y.C18 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C19 , y.C19 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C20 , y.C20 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C21 , y.C21 ); \
    if (cmp) return cmp; \
    return mysqlpp::sql_cmp(x.C22 , y.C22 ); \
	} \
	template <mysqlpp::sql_dummy_type dummy> \
	int compare (const NAME &x, const NAME &y) { \
    int cmp; \
    cmp = mysqlpp::sql_cmp(x.C1 , y.C1 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C2 , y.C2 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C3 , y.C3 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C4 , y.C4 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C5 , y.C5 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C6 , y.C6 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C7 , y.C7 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C8 , y.C8 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C9 , y.C9 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C10 , y.C10 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C11 , y.C11 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C12 , y.C12 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C13 , y.C13 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C14 , y.C14 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C15 , y.C15 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C16 , y.C16 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C17 , y.C17 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C18 , y.C18 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C19 , y.C19 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C20 , y.C20 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C21 , y.C21 ); \
    if (cmp) return cmp; \
    return mysqlpp::sql_cmp(x.C22 , y.C22 ); \
	}

// ---------------------------------------------------
//                   End Compare 22
// ---------------------------------------------------


// ---------------------------------------------------
//                   Begin Compare 23
// ---------------------------------------------------

#define sql_compare_define_23(NAME, T1, C1, T2, C2, T3, C3, T4, C4, T5, C5, T6, C6, T7, C7, T8, C8, T9, C9, T10, C10, T11, C11, T12, C12, T13, C13, T14, C14, T15, C15, T16, C16, T17, C17, T18, C18, T19, C19, T20, C20, T21, C21, T22, C22, T23, C23, T24, C24, T25, C25) \
	NAME(const T1 &p1, const T2 &p2, const T3 &p3, const T4 &p4, const T5 &p5, const T6 &p6, const T7 &p7, const T8 &p8, const T9 &p9, const T10 &p10, const T11 &p11, const T12 &p12, const T13 &p13, const T14 &p14, const T15 &p15, const T16 &p16, const T17 &p17, const T18 &p18, const T19 &p19, const T20 &p20, const T21 &p21, const T22 &p22, const T23 &p23) : C1 (p1), C2 (p2), C3 (p3), C4 (p4), C5 (p5), C6 (p6), C7 (p7), C8 (p8), C9 (p9), C10 (p10), C11 (p11), C12 (p12), C13 (p13), C14 (p14), C15 (p15), C16 (p16), C17 (p17), C18 (p18), C19 (p19), C20 (p20), C21 (p21), C22 (p22), C23 (p23), table_override_(0) {} \
	void set(const T1 &p1, const T2 &p2, const T3 &p3, const T4 &p4, const T5 &p5, const T6 &p6, const T7 &p7, const T8 &p8, const T9 &p9, const T10 &p10, const T11 &p11, const T12 &p12, const T13 &p13, const T14 &p14, const T15 &p15, const T16 &p16, const T17 &p17, const T18 &p18, const T19 &p19, const T20 &p20, const T21 &p21, const T22 &p22, const T23 &p23) { \
	table_override_ = 0; \
    C1 = p1;\
    C2 = p2;\
    C3 = p3;\
    C4 = p4;\
    C5 = p5;\
    C6 = p6;\
    C7 = p7;\
    C8 = p8;\
    C9 = p9;\
    C10 = p10;\
    C11 = p11;\
    C12 = p12;\
    C13 = p13;\
    C14 = p14;\
    C15 = p15;\
    C16 = p16;\
    C17 = p17;\
    C18 = p18;\
    C19 = p19;\
    C20 = p20;\
    C21 = p21;\
    C22 = p22;\
    C23 = p23;\
 \
	} \
	sql_compare_define(NAME)

#define sql_construct_define_23(NAME, T1, C1, T2, C2, T3, C3, T4, C4, T5, C5, T6, C6, T7, C7, T8, C8, T9, C9, T10, C10, T11, C11, T12, C12, T13, C13, T14, C14, T15, C15, T16, C16, T17, C17, T18, C18, T19, C19, T20, C20, T21, C21, T22, C22, T23, C23, T24, C24, T25, C25) \
	void set(const T1 &p1, const T2 &p2, const T3 &p3, const T4 &p4, const T5 &p5, const T6 &p6, const T7 &p7, const T8 &p8, const T9 &p9, const T10 &p10, const T11 &p11, const T12 &p12, const T13 &p13, const T14 &p14, const T15 &p15, const T16 &p16, const T17 &p17, const T18 &p18, const T19 &p19, const T20 &p20, const T21 &p21, const T22 &p22, const T23 &p23) { \
	table_override_ = 0; \
    C1 = p1;\
    C2 = p2;\
    C3 = p3;\
    C4 = p4;\
    C5 = p5;\
    C6 = p6;\
    C7 = p7;\
    C8 = p8;\
    C9 = p9;\
    C10 = p10;\
    C11 = p11;\
    C12 = p12;\
    C13 = p13;\
    C14 = p14;\
    C15 = p15;\
    C16 = p16;\
    C17 = p17;\
    C18 = p18;\
    C19 = p19;\
    C20 = p20;\
    C21 = p21;\
    C22 = p22;\
    C23 = p23;\
 \
	} \
	NAME(const T1 &p1, const T2 &p2, const T3 &p3, const T4 &p4, const T5 &p5, const T6 &p6, const T7 &p7, const T8 &p8, const T9 &p9, const T10 &p10, const T11 &p11, const T12 &p12, const T13 &p13, const T14 &p14, const T15 &p15, const T16 &p16, const T17 &p17, const T18 &p18, const T19 &p19, const T20 &p20, const T21 &p21, const T22 &p22, const T23 &p23) : C1 (p1), C2 (p2), C3 (p3), C4 (p4), C5 (p5), C6 (p6), C7 (p7), C8 (p8), C9 (p9), C10 (p10), C11 (p11), C12 (p12), C13 (p13), C14 (p14), C15 (p15), C16 (p16), C17 (p17), C18 (p18), C19 (p19), C20 (p20), C21 (p21), C22 (p22), C23 (p23), table_override_(0) {}

#define sql_compare_type_def_23(NAME, WHAT, NUM) \
	return WHAT##_list(d, m, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true)

#define sql_compare_type_defe_23(NAME, WHAT, NUM) \
	return WHAT##_list(d, c, m, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true)

#define sql_COMPARE__23(NAME, C1, C2, C3, C4, C5, C6, C7, C8, C9, C10, C11, C12, C13, C14, C15, C16, C17, C18, C19, C20, C21, C22, C23, C24, C25) \
	template <mysqlpp::sql_dummy_type dummy> \
	int sql_compare_##NAME(const NAME &x, const NAME &y) { \
    int cmp; \
    cmp = mysqlpp::sql_cmp(x.C1 , y.C1 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C2 , y.C2 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C3 , y.C3 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C4 , y.C4 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C5 , y.C5 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C6 , y.C6 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C7 , y.C7 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C8 , y.C8 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C9 , y.C9 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C10 , y.C10 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C11 , y.C11 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C12 , y.C12 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C13 , y.C13 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C14 , y.C14 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C15 , y.C15 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C16 , y.C16 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C17 , y.C17 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C18 , y.C18 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C19 , y.C19 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C20 , y.C20 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C21 , y.C21 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C22 , y.C22 ); \
    if (cmp) return cmp; \
    return mysqlpp::sql_cmp(x.C23 , y.C23 ); \
	} \
	template <mysqlpp::sql_dummy_type dummy> \
	int compare (const NAME &x, const NAME &y) { \
    int cmp; \
    cmp = mysqlpp::sql_cmp(x.C1 , y.C1 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C2 , y.C2 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C3 , y.C3 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C4 , y.C4 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C5 , y.C5 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C6 , y.C6 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C7 , y.C7 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C8 , y.C8 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C9 , y.C9 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C10 , y.C10 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C11 , y.C11 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C12 , y.C12 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C13 , y.C13 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C14 , y.C14 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C15 , y.C15 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C16 , y.C16 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C17 , y.C17 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C18 , y.C18 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C19 , y.C19 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C20 , y.C20 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C21 , y.C21 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C22 , y.C22 ); \
    if (cmp) return cmp; \
    return mysqlpp::sql_cmp(x.C23 , y.C23 ); \
	}

// ---------------------------------------------------
//                   End Compare 23
// ---------------------------------------------------


// ---------------------------------------------------
//                   Begin Compare 24
// ---------------------------------------------------

#define sql_compare_define_24(NAME, T1, C1, T2, C2, T3, C3, T4, C4, T5, C5, T6, C6, T7, C7, T8, C8, T9, C9, T10, C10, T11, C11, T12, C12, T13, C13, T14, C14, T15, C15, T16, C16, T17, C17, T18, C18, T19, C19, T20, C20, T21, C21, T22, C22, T23, C23, T24, C24, T25, C25) \
	NAME(const T1 &p1, const T2 &p2, const T3 &p3, const T4 &p4, const T5 &p5, const T6 &p6, const T7 &p7, const T8 &p8, const T9 &p9, const T10 &p10, const T11 &p11, const T12 &p12, const T13 &p13, const T14 &p14, const T15 &p15, const T16 &p16, const T17 &p17, const T18 &p18, const T19 &p19, const T20 &p20, const T21 &p21, const T22 &p22, const T23 &p23, const T24 &p24) : C1 (p1), C2 (p2), C3 (p3), C4 (p4), C5 (p5), C6 (p6), C7 (p7), C8 (p8), C9 (p9), C10 (p10), C11 (p11), C12 (p12), C13 (p13), C14 (p14), C15 (p15), C16 (p16), C17 (p17), C18 (p18), C19 (p19), C20 (p20), C21 (p21), C22 (p22), C23 (p23), C24 (p24), table_override_(0) {} \
	void set(const T1 &p1, const T2 &p2, const T3 &p3, const T4 &p4, const T5 &p5, const T6 &p6, const T7 &p7, const T8 &p8, const T9 &p9, const T10 &p10, const T11 &p11, const T12 &p12, const T13 &p13, const T14 &p14, const T15 &p15, const T16 &p16, const T17 &p17, const T18 &p18, const T19 &p19, const T20 &p20, const T21 &p21, const T22 &p22, const T23 &p23, const T24 &p24) { \
	table_override_ = 0; \
    C1 = p1;\
    C2 = p2;\
    C3 = p3;\
    C4 = p4;\
    C5 = p5;\
    C6 = p6;\
    C7 = p7;\
    C8 = p8;\
    C9 = p9;\
    C10 = p10;\
    C11 = p11;\
    C12 = p12;\
    C13 = p13;\
    C14 = p14;\
    C15 = p15;\
    C16 = p16;\
    C17 = p17;\
    C18 = p18;\
    C19 = p19;\
    C20 = p20;\
    C21 = p21;\
    C22 = p22;\
    C23 = p23;\
    C24 = p24;\
 \
	} \
	sql_compare_define(NAME)

#define sql_construct_define_24(NAME, T1, C1, T2, C2, T3, C3, T4, C4, T5, C5, T6, C6, T7, C7, T8, C8, T9, C9, T10, C10, T11, C11, T12, C12, T13, C13, T14, C14, T15, C15, T16, C16, T17, C17, T18, C18, T19, C19, T20, C20, T21, C21, T22, C22, T23, C23, T24, C24, T25, C25) \
	void set(const T1 &p1, const T2 &p2, const T3 &p3, const T4 &p4, const T5 &p5, const T6 &p6, const T7 &p7, const T8 &p8, const T9 &p9, const T10 &p10, const T11 &p11, const T12 &p12, const T13 &p13, const T14 &p14, const T15 &p15, const T16 &p16, const T17 &p17, const T18 &p18, const T19 &p19, const T20 &p20, const T21 &p21, const T22 &p22, const T23 &p23, const T24 &p24) { \
	table_override_ = 0; \
    C1 = p1;\
    C2 = p2;\
    C3 = p3;\
    C4 = p4;\
    C5 = p5;\
    C6 = p6;\
    C7 = p7;\
    C8 = p8;\
    C9 = p9;\
    C10 = p10;\
    C11 = p11;\
    C12 = p12;\
    C13 = p13;\
    C14 = p14;\
    C15 = p15;\
    C16 = p16;\
    C17 = p17;\
    C18 = p18;\
    C19 = p19;\
    C20 = p20;\
    C21 = p21;\
    C22 = p22;\
    C23 = p23;\
    C24 = p24;\
 \
	} \
	NAME(const T1 &p1, const T2 &p2, const T3 &p3, const T4 &p4, const T5 &p5, const T6 &p6, const T7 &p7, const T8 &p8, const T9 &p9, const T10 &p10, const T11 &p11, const T12 &p12, const T13 &p13, const T14 &p14, const T15 &p15, const T16 &p16, const T17 &p17, const T18 &p18, const T19 &p19, const T20 &p20, const T21 &p21, const T22 &p22, const T23 &p23, const T24 &p24) : C1 (p1), C2 (p2), C3 (p3), C4 (p4), C5 (p5), C6 (p6), C7 (p7), C8 (p8), C9 (p9), C10 (p10), C11 (p11), C12 (p12), C13 (p13), C14 (p14), C15 (p15), C16 (p16), C17 (p17), C18 (p18), C19 (p19), C20 (p20), C21 (p21), C22 (p22), C23 (p23), C24 (p24), table_override_(0) {}

#define sql_compare_type_def_24(NAME, WHAT, NUM) \
	return WHAT##_list(d, m, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true)

#define sql_compare_type_defe_24(NAME, WHAT, NUM) \
	return WHAT##_list(d, c, m, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true)

#define sql_COMPARE__24(NAME, C1, C2, C3, C4, C5, C6, C7, C8, C9, C10, C11, C12, C13, C14, C15, C16, C17, C18, C19, C20, C21, C22, C23, C24, C25) \
	template <mysqlpp::sql_dummy_type dummy> \
	int sql_compare_##NAME(const NAME &x, const NAME &y) { \
    int cmp; \
    cmp = mysqlpp::sql_cmp(x.C1 , y.C1 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C2 , y.C2 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C3 , y.C3 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C4 , y.C4 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C5 , y.C5 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C6 , y.C6 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C7 , y.C7 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C8 , y.C8 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C9 , y.C9 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C10 , y.C10 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C11 , y.C11 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C12 , y.C12 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C13 , y.C13 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C14 , y.C14 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C15 , y.C15 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C16 , y.C16 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C17 , y.C17 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C18 , y.C18 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C19 , y.C19 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C20 , y.C20 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C21 , y.C21 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C22 , y.C22 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C23 , y.C23 ); \
    if (cmp) return cmp; \
    return mysqlpp::sql_cmp(x.C24 , y.C24 ); \
	} \
	template <mysqlpp::sql_dummy_type dummy> \
	int compare (const NAME &x, const NAME &y) { \
    int cmp; \
    cmp = mysqlpp::sql_cmp(x.C1 , y.C1 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C2 , y.C2 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C3 , y.C3 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C4 , y.C4 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C5 , y.C5 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C6 , y.C6 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C7 , y.C7 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C8 , y.C8 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C9 , y.C9 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C10 , y.C10 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C11 , y.C11 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C12 , y.C12 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C13 , y.C13 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C14 , y.C14 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C15 , y.C15 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C16 , y.C16 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C17 , y.C17 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C18 , y.C18 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C19 , y.C19 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C20 , y.C20 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C21 , y.C21 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C22 , y.C22 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C23 , y.C23 ); \
    if (cmp) return cmp; \
    return mysqlpp::sql_cmp(x.C24 , y.C24 ); \
	}

// ---------------------------------------------------
//                   End Compare 24
// ---------------------------------------------------


// ---------------------------------------------------
//                   Begin Compare 25
// ---------------------------------------------------

#define sql_compare_define_25(NAME, T1, C1, T2, C2, T3, C3, T4, C4, T5, C5, T6, C6, T7, C7, T8, C8, T9, C9, T10, C10, T11, C11, T12, C12, T13, C13, T14, C14, T15, C15, T16, C16, T17, C17, T18, C18, T19, C19, T20, C20, T21, C21, T22, C22, T23, C23, T24, C24, T25, C25) \
	NAME(const T1 &p1, const T2 &p2, const T3 &p3, const T4 &p4, const T5 &p5, const T6 &p6, const T7 &p7, const T8 &p8, const T9 &p9, const T10 &p10, const T11 &p11, const T12 &p12, const T13 &p13, const T14 &p14, const T15 &p15, const T16 &p16, const T17 &p17, const T18 &p18, const T19 &p19, const T20 &p20, const T21 &p21, const T22 &p22, const T23 &p23, const T24 &p24, const T25 &p25) : C1 (p1), C2 (p2), C3 (p3), C4 (p4), C5 (p5), C6 (p6), C7 (p7), C8 (p8), C9 (p9), C10 (p10), C11 (p11), C12 (p12), C13 (p13), C14 (p14), C15 (p15), C16 (p16), C17 (p17), C18 (p18), C19 (p19), C20 (p20), C21 (p21), C22 (p22), C23 (p23), C24 (p24), C25 (p25), table_override_(0) {} \
	void set(const T1 &p1, const T2 &p2, const T3 &p3, const T4 &p4, const T5 &p5, const T6 &p6, const T7 &p7, const T8 &p8, const T9 &p9, const T10 &p10, const T11 &p11, const T12 &p12, const T13 &p13, const T14 &p14, const T15 &p15, const T16 &p16, const T17 &p17, const T18 &p18, const T19 &p19, const T20 &p20, const T21 &p21, const T22 &p22, const T23 &p23, const T24 &p24, const T25 &p25) { \
	table_override_ = 0; \
    C1 = p1;\
    C2 = p2;\
    C3 = p3;\
    C4 = p4;\
    C5 = p5;\
    C6 = p6;\
    C7 = p7;\
    C8 = p8;\
    C9 = p9;\
    C10 = p10;\
    C11 = p11;\
    C12 = p12;\
    C13 = p13;\
    C14 = p14;\
    C15 = p15;\
    C16 = p16;\
    C17 = p17;\
    C18 = p18;\
    C19 = p19;\
    C20 = p20;\
    C21 = p21;\
    C22 = p22;\
    C23 = p23;\
    C24 = p24;\
    C25 = p25;\
 \
	} \
	sql_compare_define(NAME)

#define sql_construct_define_25(NAME, T1, C1, T2, C2, T3, C3, T4, C4, T5, C5, T6, C6, T7, C7, T8, C8, T9, C9, T10, C10, T11, C11, T12, C12, T13, C13, T14, C14, T15, C15, T16, C16, T17, C17, T18, C18, T19, C19, T20, C20, T21, C21, T22, C22, T23, C23, T24, C24, T25, C25) \
	void set(const T1 &p1, const T2 &p2, const T3 &p3, const T4 &p4, const T5 &p5, const T6 &p6, const T7 &p7, const T8 &p8, const T9 &p9, const T10 &p10, const T11 &p11, const T12 &p12, const T13 &p13, const T14 &p14, const T15 &p15, const T16 &p16, const T17 &p17, const T18 &p18, const T19 &p19, const T20 &p20, const T21 &p21, const T22 &p22, const T23 &p23, const T24 &p24, const T25 &p25) { \
	table_override_ = 0; \
    C1 = p1;\
    C2 = p2;\
    C3 = p3;\
    C4 = p4;\
    C5 = p5;\
    C6 = p6;\
    C7 = p7;\
    C8 = p8;\
    C9 = p9;\
    C10 = p10;\
    C11 = p11;\
    C12 = p12;\
    C13 = p13;\
    C14 = p14;\
    C15 = p15;\
    C16 = p16;\
    C17 = p17;\
    C18 = p18;\
    C19 = p19;\
    C20 = p20;\
    C21 = p21;\
    C22 = p22;\
    C23 = p23;\
    C24 = p24;\
    C25 = p25;\
 \
	} \
	NAME(const T1 &p1, const T2 &p2, const T3 &p3, const T4 &p4, const T5 &p5, const T6 &p6, const T7 &p7, const T8 &p8, const T9 &p9, const T10 &p10, const T11 &p11, const T12 &p12, const T13 &p13, const T14 &p14, const T15 &p15, const T16 &p16, const T17 &p17, const T18 &p18, const T19 &p19, const T20 &p20, const T21 &p21, const T22 &p22, const T23 &p23, const T24 &p24, const T25 &p25) : C1 (p1), C2 (p2), C3 (p3), C4 (p4), C5 (p5), C6 (p6), C7 (p7), C8 (p8), C9 (p9), C10 (p10), C11 (p11), C12 (p12), C13 (p13), C14 (p14), C15 (p15), C16 (p16), C17 (p17), C18 (p18), C19 (p19), C20 (p20), C21 (p21), C22 (p22), C23 (p23), C24 (p24), C25 (p25), table_override_(0) {}

#define sql_compare_type_def_25(NAME, WHAT, NUM) \
	return WHAT##_list(d, m, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true)

#define sql_compare_type_defe_25(NAME, WHAT, NUM) \
	return WHAT##_list(d, c, m, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true)

#define sql_COMPARE__25(NAME, C1, C2, C3, C4, C5, C6, C7, C8, C9, C10, C11, C12, C13, C14, C15, C16, C17, C18, C19, C20, C21, C22, C23, C24, C25) \
	template <mysqlpp::sql_dummy_type dummy> \
	int sql_compare_##NAME(const NAME &x, const NAME &y) { \
    int cmp; \
    cmp = mysqlpp::sql_cmp(x.C1 , y.C1 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C2 , y.C2 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C3 , y.C3 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C4 , y.C4 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C5 , y.C5 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C6 , y.C6 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C7 , y.C7 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C8 , y.C8 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C9 , y.C9 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C10 , y.C10 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C11 , y.C11 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C12 , y.C12 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C13 , y.C13 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C14 , y.C14 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C15 , y.C15 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C16 , y.C16 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C17 , y.C17 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C18 , y.C18 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C19 , y.C19 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C20 , y.C20 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C21 , y.C21 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C22 , y.C22 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C23 , y.C23 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C24 , y.C24 ); \
    if (cmp) return cmp; \
    return mysqlpp::sql_cmp(x.C25 , y.C25 ); \
	} \
	template <mysqlpp::sql_dummy_type dummy> \
	int compare (const NAME &x, const NAME &y) { \
    int cmp; \
    cmp = mysqlpp::sql_cmp(x.C1 , y.C1 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C2 , y.C2 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C3 , y.C3 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C4 , y.C4 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C5 , y.C5 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C6 , y.C6 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C7 , y.C7 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C8 , y.C8 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C9 , y.C9 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C10 , y.C10 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C11 , y.C11 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C12 , y.C12 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C13 , y.C13 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C14 , y.C14 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C15 , y.C15 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C16 , y.C16 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C17 , y.C17 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C18 , y.C18 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C19 , y.C19 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C20 , y.C20 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C21 , y.C21 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C22 , y.C22 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C23 , y.C23 ); \
    if (cmp) return cmp; \
    cmp = mysqlpp::sql_cmp(x.C24 , y.C24 ); \
    if (cmp) return cmp; \
    return mysqlpp::sql_cmp(x.C25 , y.C25 ); \
	}

// ---------------------------------------------------
//                   End Compare 25
// ---------------------------------------------------

// ---------------------------------------------------
//                  Begin Create 1
// ---------------------------------------------------
#define sql_create_complete_1(NAME, CMP, CONTR, T1, I1, N1) \
	struct NAME; \
	enum NAME##_enum { \
    NAME##_##I1 \
	,NAME##_NULL \
	}; \
	template <class Manip>\
	class NAME##_value_list { \
	public: \
	const NAME* obj;\
	const char* delim;\
	Manip manip;\
	public: \
	NAME##_value_list (const NAME* o, const char* d, Manip m) :\
	obj(o), delim(d), manip(m) { } \
	};\
	template <class Manip>\
	class NAME##_##field_list {\
	public: \
	const NAME* obj; \
	const char* delim;\
	Manip manip;\
	public: \
	NAME##_field_list (const NAME* o, const char* d, Manip m) :\
	obj(o), delim(d), manip(m) { } \
	};\
	template <class Manip>\
	class NAME##_equal_list { \
	public: \
	const NAME* obj;\
	const char* delim;\
	const char* comp;\
	Manip manip;\
	public: \
	NAME##_equal_list (const NAME* o, const char* d, const char* c, Manip m) :\
	obj(o), delim(d), comp(c), manip(m) { }\
	};\
	template <class Manip>\
	class NAME##_cus_value_list {\
	public:\
	const NAME* obj;\
	std::vector<bool> *include;\
	bool del_vector;\
	const char* delim;\
	Manip manip;\
	public: \
	~NAME##_cus_value_list () {if (del_vector) delete include;} \
	NAME##_cus_value_list (const NAME* o, const char* d, Manip m, bool i1);\
	NAME##_cus_value_list (const NAME* o, const char* d, Manip m, NAME##_enum i1); \
	NAME##_cus_value_list (const NAME* o, const char* d, Manip m ,std::vector<bool>* i) :\
	obj(o), include(i), del_vector(false), delim(d), manip(m) { }\
	};\
	template <class Manip>\
	class NAME##_cus_field_list { \
	public:\
	const NAME* obj; \
	std::vector<bool> *include; \
	bool del_vector; \
	const char* delim;\
	Manip manip;\
	public: \
	~NAME##_cus_field_list () {if (del_vector) delete include;} \
	NAME##_cus_field_list (const NAME* o, const char* d, Manip m, bool i1); \
	NAME##_cus_field_list (const NAME* o, const char* d, Manip m, NAME##_enum i1); \
	NAME##_cus_field_list (const NAME* o, const char* d, Manip m, std::vector<bool> *i) :\
	obj(o), include(i), del_vector(false), delim(d), manip(m) { }\
	};\
	template <class Manip>\
	class NAME##_cus_equal_list {\
	public:\
	const NAME* obj;\
	std::vector<bool> *include;\
	bool del_vector;\
	const char* delim;\
	const char* comp;\
	Manip manip;\
	public:\
	~NAME##_##cus_equal_list () {if (del_vector) delete include;}\
	NAME##_##cus_equal_list (const NAME* o, const char* d, const char* c, Manip m, bool i1); \
	NAME##_##cus_equal_list (const NAME* o, const char* d, const char* c, Manip m, NAME##_enum i1); \
	NAME##_##cus_equal_list (const NAME* o, const char* d, const char* c, Manip m, std::vector<bool> *i) :\
	obj(o), include(i), del_vector(false), delim(d), comp(c), manip(m) { }\
	};\
	template <mysqlpp::sql_dummy_type dummy> int sql_compare_##NAME(const NAME&, const NAME&);\
	struct NAME {\
    T1 I1; \
	NAME() : table_override_(0) { }\
	NAME(const mysqlpp::Row& row);\
	void set(const mysqlpp::Row &row);\
	sql_compare_define_##CMP(NAME, T1, I1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)\
	sql_construct_define_##CONTR(NAME, T1, I1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)\
	static const char* names[];\
	static void table(const char* t) { table_ = t; }\
	const char* table() const\
			{ return table_override_ ? table_override_ : NAME::table_; }\
	void instance_table(const char* t) { table_override_ = t; }\
	NAME##_value_list<mysqlpp::quote_type0> value_list() const {\
		return value_list(",", mysqlpp::quote);}\
	NAME##_value_list<mysqlpp::quote_type0> value_list(const char* d) const {\
		return value_list(d, mysqlpp::quote);}\
	template <class Manip>\
	NAME##_value_list<Manip> value_list(const char* d, Manip m) const;\
	NAME##_field_list<mysqlpp::do_nothing_type0> field_list() const {\
		return field_list(",", mysqlpp::do_nothing);}\
	NAME##_field_list<mysqlpp::do_nothing_type0> field_list(const char* d) const {\
		return field_list(d, mysqlpp::do_nothing);}\
	template <class Manip>\
	NAME##_field_list<Manip> field_list(const char* d, Manip m) const;\
	NAME##_equal_list<mysqlpp::quote_type0> equal_list(const char* d = ",",\
			const char* c = " = ") const\
			{ return equal_list(d, c, mysqlpp::quote); }\
	template <class Manip>\
	NAME##_equal_list<Manip> equal_list(const char* d, const char* c, Manip m) const;\
	/* cus_data */\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(bool i1) const\
			{ return value_list(",", mysqlpp::quote, i1); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(NAME##_enum i1) const\
			{ return value_list(",", mysqlpp::quote, i1); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(std::vector<bool> *i) const\
			{ return value_list(",", mysqlpp::quote, i); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(mysqlpp::sql_cmp_type sc) const\
			{ return value_list(",", mysqlpp::quote, sc); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(const char* d, bool i1) const\
			{ return value_list(d, mysqlpp::quote, i1); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(const char* d, NAME##_enum i1) const\
			{ return value_list(d, mysqlpp::quote, i1); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(const char* d,\
			std::vector<bool> *i) const\
			{ return value_list(d, mysqlpp::quote, i); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(const char* d,\
			mysqlpp::sql_cmp_type sc) const\
			{ return value_list(d, mysqlpp::quote, sc); }\
	template <class Manip>\
	NAME##_cus_value_list<Manip> value_list(const char* d, Manip m,\
			bool i1) const;\
	template <class Manip>\
	NAME##_cus_value_list<Manip> value_list(const char* d, Manip m,\
			NAME##_enum i1) const;\
	template <class Manip>\
	NAME##_cus_value_list<Manip> value_list(const char* d, Manip m,\
			std::vector<bool>* i) const;\
	template <class Manip>\
	NAME##_cus_value_list<Manip> value_list(const char* d, Manip m, \
			mysqlpp::sql_cmp_type sc) const;\
	/* cus field */\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(bool i1) const \
			{ return field_list(",", mysqlpp::do_nothing, i1); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(NAME##_enum i1) const\
			{ return field_list(",", mysqlpp::do_nothing, i1); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(std::vector<bool> *i) const\
			{ return field_list(",", mysqlpp::do_nothing, i); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(mysqlpp::sql_cmp_type sc) const\
			{ return field_list(",", mysqlpp::do_nothing, sc); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(const char* d,\
			bool i1) const\
			{ return field_list(d, mysqlpp::do_nothing, i1); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(const char* d,\
			NAME##_enum i1) const\
			{ return field_list(d, mysqlpp::do_nothing, i1); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(const char* d,\
			std::vector<bool>* i) const\
			{ return field_list(d, mysqlpp::do_nothing, i); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(const char* d,\
			mysqlpp::sql_cmp_type sc) const\
			{ return field_list(d, mysqlpp::do_nothing, sc); }\
	template <class Manip>\
	NAME##_cus_field_list<Manip> field_list(const char* d, Manip m,\
			bool i1) const;\
	template <class Manip>\
	NAME##_cus_field_list<Manip> field_list(const char* d, Manip m,\
			NAME##_enum i1) const;\
	template <class Manip>\
	NAME##_cus_field_list<Manip> field_list(const char* d, Manip m,\
			std::vector<bool> *i) const;\
	template <class Manip>\
	NAME##_cus_field_list<Manip> field_list(const char* d, Manip m,\
			mysqlpp::sql_cmp_type sc) const;\
	/* cus equal */\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(bool i1) const\
			{ return equal_list(",", " = ", mysqlpp::quote, i1); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(NAME##_enum i1) const\
			{ return equal_list(",", " = ", mysqlpp::quote, i1); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(std::vector<bool>* i) const\
			{ return equal_list(",", " = ", mysqlpp::quote, i); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(mysqlpp::sql_cmp_type sc) const\
			{ return equal_list(",", " = ", mysqlpp::quote, sc); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, bool i1) const\
			{ return equal_list(d, " = ", mysqlpp::quote, i1); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, NAME##_enum i1) const\
			{ return equal_list(d, " = ", mysqlpp::quote, i1); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d,\
			std::vector<bool> *i) const\
			{ return equal_list(d, " = ", mysqlpp::quote, i); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d,\
			mysqlpp::sql_cmp_type sc) const\
			{ return equal_list(d, " = ", mysqlpp::quote, sc); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, const char* c,\
			bool i1) const\
			{ return equal_list(d, c, mysqlpp::quote, i1); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, const char* c,\
			NAME##_enum i1) const\
			{ return equal_list(d, c, mysqlpp::quote, i1); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, const char* c,\
			std::vector<bool> *i) const\
			{ return equal_list(d, c, mysqlpp::quote, i); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, const char* c,\
			mysqlpp::sql_cmp_type sc) const\
			{ return equal_list(d, c, mysqlpp::quote, sc); }\
	template <class Manip>\
	NAME##_cus_equal_list<Manip> equal_list(const char* d, const char* c, Manip m, \
						bool i1) const;\
	template <class Manip>\
	NAME##_cus_equal_list<Manip> equal_list(const char* d, const char* c, Manip m, \
						NAME##_enum i1) const;\
	template <class Manip>\
	NAME##_cus_equal_list<Manip> equal_list(const char* d, const char* c, Manip m, \
						std::vector<bool> *i) const;\
	template <class Manip>\
	NAME##_cus_equal_list<Manip> equal_list(const char* d, const char* c, Manip m, \
						mysqlpp::sql_cmp_type sc) const;\
	private:\
	static const char* table_;\
	const char* table_override_;\
	};\
	MYSQLPP_SSQLS_CONDITIONAL_STATICS(\
		const char* NAME::names[] = {\
			    N1 \
		};\
		const char* NAME::table_ = #NAME;\
	)\
	template <class Manip>\
	NAME##_cus_value_list<Manip>::NAME##_cus_value_list\
			(const NAME* o, const char* d, Manip m, bool i1)\
	{\
		delim = d;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(1, false);\
    if (i1) (*include)[0]=true;\
	}\
	template <class Manip>\
	NAME##_cus_value_list<Manip>::NAME##_cus_value_list\
			(const NAME* o, const char* d, Manip m, NAME##_enum i1)\
	{\
		delim = d;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(1, false);\
    (*include)[i1]=true;\
	}\
	template <class Manip>\
	NAME##_cus_field_list<Manip>::NAME##_cus_field_list\
			(const NAME* o, const char* d, Manip m, bool i1)\
	{\
		delim = d;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(1, false);\
    if (i1) (*include)[0]=true;\
	}\
	template <class Manip>\
	NAME##_cus_field_list<Manip>::NAME##_cus_field_list\
			(const NAME* o, const char* d, Manip m, NAME##_enum i1)\
	{\
		delim = d;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(1, false);\
    (*include)[i1]=true;\
	}\
	template <class Manip>\
	NAME##_cus_equal_list<Manip>::NAME##_cus_equal_list\
			(const NAME* o, const char* d, const char* c, Manip m, bool i1)\
	{\
		delim = d;\
		comp = c;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(1, false);\
    if (i1) (*include)[0]=true;\
	}\
	template <class Manip>\
	NAME##_cus_equal_list<Manip>::NAME##_cus_equal_list\
			(const NAME* o, const char* d, const char* c, Manip m, NAME##_enum i1)\
	{\
		delim = d;\
		comp = c;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(1, false);\
    (*include)[i1]=true;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_value_list<Manip>& obj)\
	{\
    s << obj.manip << obj.obj->I1;\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_field_list<Manip>& obj)\
	{\
    s << obj.manip << '`' << obj.obj->names[0] << '`';\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_equal_list<Manip>& obj)\
	{\
    s << '`' << obj.obj->names[0] << '`' << obj.comp << obj.manip << obj.obj->I1;\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_cus_value_list<Manip>& obj)\
	{\
		bool before = false;\
    if ((*obj.include)[0]) { \
      s << obj.manip << obj.obj->I1;\
     } \
        (void)before;\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_cus_field_list<Manip>& obj)\
	{\
		bool before = false;\
    if ((*obj.include)[0]) { \
      s << obj.manip << '`' << obj.obj->names[0] << '`';\
     } \
        (void)before;\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_cus_equal_list<Manip>& obj)\
	{\
		bool before = false;\
    if ((*obj.include)[0]) { \
      s << '`' << obj.obj->names[0] << '`' << obj.comp << obj.manip << obj.obj->I1;\
     } \
        (void)before;\
		return s;\
	}\
	template <class Manip>\
	inline NAME##_value_list<Manip> NAME::value_list(const char* d, Manip m) const\
			{ return NAME##_value_list<Manip> (this, d, m); } \
	template <class Manip>\
	inline NAME##_field_list<Manip> NAME::field_list(const char* d, Manip m) const\
			{ return NAME##_field_list<Manip> (this, d, m); } \
	template <class Manip>\
	inline NAME##_equal_list<Manip> NAME::equal_list(const char* d, const char* c, Manip m) const\
			{ return NAME##_equal_list<Manip> (this, d, c, m); } \
	template <class Manip>\
	inline NAME##_cus_value_list<Manip> NAME::value_list(const char* d, Manip m,\
			bool i1) const\
			{ return NAME##_cus_value_list<Manip> (this, d, m, i1); }\
	template <class Manip>\
	inline NAME##_cus_field_list<Manip> NAME::field_list(const char* d, Manip m,\
			bool i1) const\
			{ return NAME##_cus_field_list<Manip> (this, d, m, i1); }\
	template <class Manip>\
	inline NAME##_cus_equal_list<Manip> NAME::equal_list(const char* d, const char* c, Manip m,\
			bool i1) const\
			{ return NAME##_cus_equal_list<Manip> (this, d, c, m, i1); } \
	template <class Manip>\
	inline NAME##_cus_value_list<Manip> NAME::value_list(const char* d, Manip m,\
			NAME##_enum i1) const\
			{ return NAME##_cus_value_list<Manip> (this, d, m, i1); } \
	template <class Manip>\
	inline NAME##_cus_field_list<Manip> NAME::field_list(const char* d, Manip m,\
			NAME##_enum i1) const\
			{ return NAME##_cus_field_list<Manip> (this, d, m, i1); } \
	template <class Manip>\
	inline NAME##_cus_equal_list<Manip> NAME::equal_list(const char* d, const char* c, Manip m, \
			NAME##_enum i1) const\
			{ return NAME##_cus_equal_list<Manip> (this, d, c, m, i1); } \
	template <class Manip>\
	inline NAME##_cus_value_list<Manip> NAME::value_list(const char* d, Manip m,\
			std::vector<bool> *i) const\
			{ return NAME##_cus_value_list<Manip> (this, d, m, i); }\
	template <class Manip>\
	inline NAME##_cus_field_list<Manip> NAME::field_list(const char* d, Manip m,\
			std::vector<bool> *i) const\
			{ return NAME##_cus_field_list<Manip> (this, d, m, i); }\
	template <class Manip>\
	inline NAME##_cus_equal_list<Manip> NAME::equal_list(const char* d, const char* c, Manip m,\
			std::vector<bool> *i) const\
			{ return NAME##_cus_equal_list<Manip> (this, d, c, m, i); }\
	template <class Manip>\
	inline NAME##_cus_value_list<Manip> \
	NAME::value_list(const char* d, Manip m, mysqlpp::sql_cmp_type /*sc*/) const\
			{ sql_compare_type_def_##CMP(NAME, value, NUM); }\
	template <class Manip>\
	inline NAME##_cus_field_list<Manip> \
	NAME::field_list(const char* d, Manip m, mysqlpp::sql_cmp_type /*sc*/) const\
			{ sql_compare_type_def_##CMP(NAME, field, NUM); }\
	template <class Manip>\
	inline NAME##_cus_equal_list<Manip> \
	NAME::equal_list(const char* d, const char* c, Manip m, mysqlpp::sql_cmp_type /*sc*/) const\
			{ sql_compare_type_defe_##CMP(NAME, equal, NUM); }\
	template <mysqlpp::sql_dummy_type dummy>\
	void populate_##NAME(NAME *s, const mysqlpp::Row &row)\
	{\
		mysqlpp::NoExceptions ignore_schema_mismatches(row);\
    s->I1 = row[N1].conv(T1());\
	}\
	inline NAME::NAME(const mysqlpp::Row& row) :\
	table_override_(0)\
			{ populate_##NAME<mysqlpp::sql_dummy>(this, row); }\
	inline void NAME::set(const mysqlpp::Row& row)\
	{\
		table_override_ = 0;\
		populate_##NAME<mysqlpp::sql_dummy>(this, row);\
	}\
	sql_COMPARE__##CMP(NAME, I1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 )

#define sql_create_1(NAME, CMP, CONTR, T1, I1) \
		sql_create_complete_1(NAME, CMP, CONTR, T1, I1, #I1) \

// ---------------------------------------------------
//                  End Create 1
// ---------------------------------------------------

// ---------------------------------------------------
//                  Begin Create 2
// ---------------------------------------------------
#define sql_create_complete_2(NAME, CMP, CONTR, T1, I1, N1, T2, I2, N2) \
	struct NAME; \
	enum NAME##_enum { \
    NAME##_##I1,\
    NAME##_##I2 \
	,NAME##_NULL \
	}; \
	template <class Manip>\
	class NAME##_value_list { \
	public: \
	const NAME* obj;\
	const char* delim;\
	Manip manip;\
	public: \
	NAME##_value_list (const NAME* o, const char* d, Manip m) :\
	obj(o), delim(d), manip(m) { } \
	};\
	template <class Manip>\
	class NAME##_##field_list {\
	public: \
	const NAME* obj; \
	const char* delim;\
	Manip manip;\
	public: \
	NAME##_field_list (const NAME* o, const char* d, Manip m) :\
	obj(o), delim(d), manip(m) { } \
	};\
	template <class Manip>\
	class NAME##_equal_list { \
	public: \
	const NAME* obj;\
	const char* delim;\
	const char* comp;\
	Manip manip;\
	public: \
	NAME##_equal_list (const NAME* o, const char* d, const char* c, Manip m) :\
	obj(o), delim(d), comp(c), manip(m) { }\
	};\
	template <class Manip>\
	class NAME##_cus_value_list {\
	public:\
	const NAME* obj;\
	std::vector<bool> *include;\
	bool del_vector;\
	const char* delim;\
	Manip manip;\
	public: \
	~NAME##_cus_value_list () {if (del_vector) delete include;} \
	NAME##_cus_value_list (const NAME* o, const char* d, Manip m, bool i1, bool i2);\
	NAME##_cus_value_list (const NAME* o, const char* d, Manip m, NAME##_enum i1, NAME##_enum i2); \
	NAME##_cus_value_list (const NAME* o, const char* d, Manip m ,std::vector<bool>* i) :\
	obj(o), include(i), del_vector(false), delim(d), manip(m) { }\
	};\
	template <class Manip>\
	class NAME##_cus_field_list { \
	public:\
	const NAME* obj; \
	std::vector<bool> *include; \
	bool del_vector; \
	const char* delim;\
	Manip manip;\
	public: \
	~NAME##_cus_field_list () {if (del_vector) delete include;} \
	NAME##_cus_field_list (const NAME* o, const char* d, Manip m, bool i1, bool i2); \
	NAME##_cus_field_list (const NAME* o, const char* d, Manip m, NAME##_enum i1, NAME##_enum i2); \
	NAME##_cus_field_list (const NAME* o, const char* d, Manip m, std::vector<bool> *i) :\
	obj(o), include(i), del_vector(false), delim(d), manip(m) { }\
	};\
	template <class Manip>\
	class NAME##_cus_equal_list {\
	public:\
	const NAME* obj;\
	std::vector<bool> *include;\
	bool del_vector;\
	const char* delim;\
	const char* comp;\
	Manip manip;\
	public:\
	~NAME##_##cus_equal_list () {if (del_vector) delete include;}\
	NAME##_##cus_equal_list (const NAME* o, const char* d, const char* c, Manip m, bool i1, bool i2); \
	NAME##_##cus_equal_list (const NAME* o, const char* d, const char* c, Manip m, NAME##_enum i1, NAME##_enum i2); \
	NAME##_##cus_equal_list (const NAME* o, const char* d, const char* c, Manip m, std::vector<bool> *i) :\
	obj(o), include(i), del_vector(false), delim(d), comp(c), manip(m) { }\
	};\
	template <mysqlpp::sql_dummy_type dummy> int sql_compare_##NAME(const NAME&, const NAME&);\
	struct NAME {\
    T1 I1;\
    T2 I2; \
	NAME() : table_override_(0) { }\
	NAME(const mysqlpp::Row& row);\
	void set(const mysqlpp::Row &row);\
	sql_compare_define_##CMP(NAME, T1, I1, T2, I2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)\
	sql_construct_define_##CONTR(NAME, T1, I1, T2, I2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)\
	static const char* names[];\
	static void table(const char* t) { table_ = t; }\
	const char* table() const\
			{ return table_override_ ? table_override_ : NAME::table_; }\
	void instance_table(const char* t) { table_override_ = t; }\
	NAME##_value_list<mysqlpp::quote_type0> value_list() const {\
		return value_list(",", mysqlpp::quote);}\
	NAME##_value_list<mysqlpp::quote_type0> value_list(const char* d) const {\
		return value_list(d, mysqlpp::quote);}\
	template <class Manip>\
	NAME##_value_list<Manip> value_list(const char* d, Manip m) const;\
	NAME##_field_list<mysqlpp::do_nothing_type0> field_list() const {\
		return field_list(",", mysqlpp::do_nothing);}\
	NAME##_field_list<mysqlpp::do_nothing_type0> field_list(const char* d) const {\
		return field_list(d, mysqlpp::do_nothing);}\
	template <class Manip>\
	NAME##_field_list<Manip> field_list(const char* d, Manip m) const;\
	NAME##_equal_list<mysqlpp::quote_type0> equal_list(const char* d = ",",\
			const char* c = " = ") const\
			{ return equal_list(d, c, mysqlpp::quote); }\
	template <class Manip>\
	NAME##_equal_list<Manip> equal_list(const char* d, const char* c, Manip m) const;\
	/* cus_data */\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(bool i1, bool i2 = false) const\
			{ return value_list(",", mysqlpp::quote, i1, i2); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(NAME##_enum i1, NAME##_enum i2 = NAME##_NULL) const\
			{ return value_list(",", mysqlpp::quote, i1, i2); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(std::vector<bool> *i) const\
			{ return value_list(",", mysqlpp::quote, i); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(mysqlpp::sql_cmp_type sc) const\
			{ return value_list(",", mysqlpp::quote, sc); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(const char* d, bool i1, bool i2 = false) const\
			{ return value_list(d, mysqlpp::quote, i1, i2); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(const char* d, NAME##_enum i1, NAME##_enum i2 = NAME##_NULL) const\
			{ return value_list(d, mysqlpp::quote, i1, i2); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(const char* d,\
			std::vector<bool> *i) const\
			{ return value_list(d, mysqlpp::quote, i); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(const char* d,\
			mysqlpp::sql_cmp_type sc) const\
			{ return value_list(d, mysqlpp::quote, sc); }\
	template <class Manip>\
	NAME##_cus_value_list<Manip> value_list(const char* d, Manip m,\
			bool i1, bool i2 = false) const;\
	template <class Manip>\
	NAME##_cus_value_list<Manip> value_list(const char* d, Manip m,\
			NAME##_enum i1, NAME##_enum i2 = NAME##_NULL) const;\
	template <class Manip>\
	NAME##_cus_value_list<Manip> value_list(const char* d, Manip m,\
			std::vector<bool>* i) const;\
	template <class Manip>\
	NAME##_cus_value_list<Manip> value_list(const char* d, Manip m, \
			mysqlpp::sql_cmp_type sc) const;\
	/* cus field */\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(bool i1, bool i2 = false) const \
			{ return field_list(",", mysqlpp::do_nothing, i1, i2); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(NAME##_enum i1, NAME##_enum i2 = NAME##_NULL) const\
			{ return field_list(",", mysqlpp::do_nothing, i1, i2); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(std::vector<bool> *i) const\
			{ return field_list(",", mysqlpp::do_nothing, i); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(mysqlpp::sql_cmp_type sc) const\
			{ return field_list(",", mysqlpp::do_nothing, sc); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(const char* d,\
			bool i1, bool i2 = false) const\
			{ return field_list(d, mysqlpp::do_nothing, i1, i2); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(const char* d,\
			NAME##_enum i1, NAME##_enum i2 = NAME##_NULL) const\
			{ return field_list(d, mysqlpp::do_nothing, i1, i2); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(const char* d,\
			std::vector<bool>* i) const\
			{ return field_list(d, mysqlpp::do_nothing, i); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(const char* d,\
			mysqlpp::sql_cmp_type sc) const\
			{ return field_list(d, mysqlpp::do_nothing, sc); }\
	template <class Manip>\
	NAME##_cus_field_list<Manip> field_list(const char* d, Manip m,\
			bool i1, bool i2 = false) const;\
	template <class Manip>\
	NAME##_cus_field_list<Manip> field_list(const char* d, Manip m,\
			NAME##_enum i1, NAME##_enum i2 = NAME##_NULL) const;\
	template <class Manip>\
	NAME##_cus_field_list<Manip> field_list(const char* d, Manip m,\
			std::vector<bool> *i) const;\
	template <class Manip>\
	NAME##_cus_field_list<Manip> field_list(const char* d, Manip m,\
			mysqlpp::sql_cmp_type sc) const;\
	/* cus equal */\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(bool i1, bool i2 = false) const\
			{ return equal_list(",", " = ", mysqlpp::quote, i1, i2); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(NAME##_enum i1, NAME##_enum i2 = NAME##_NULL) const\
			{ return equal_list(",", " = ", mysqlpp::quote, i1, i2); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(std::vector<bool>* i) const\
			{ return equal_list(",", " = ", mysqlpp::quote, i); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(mysqlpp::sql_cmp_type sc) const\
			{ return equal_list(",", " = ", mysqlpp::quote, sc); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, bool i1, bool i2 = false) const\
			{ return equal_list(d, " = ", mysqlpp::quote, i1, i2); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, NAME##_enum i1, NAME##_enum i2 = NAME##_NULL) const\
			{ return equal_list(d, " = ", mysqlpp::quote, i1, i2); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d,\
			std::vector<bool> *i) const\
			{ return equal_list(d, " = ", mysqlpp::quote, i); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d,\
			mysqlpp::sql_cmp_type sc) const\
			{ return equal_list(d, " = ", mysqlpp::quote, sc); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, const char* c,\
			bool i1, bool i2 = false) const\
			{ return equal_list(d, c, mysqlpp::quote, i1, i2); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, const char* c,\
			NAME##_enum i1, NAME##_enum i2 = NAME##_NULL) const\
			{ return equal_list(d, c, mysqlpp::quote, i1, i2); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, const char* c,\
			std::vector<bool> *i) const\
			{ return equal_list(d, c, mysqlpp::quote, i); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, const char* c,\
			mysqlpp::sql_cmp_type sc) const\
			{ return equal_list(d, c, mysqlpp::quote, sc); }\
	template <class Manip>\
	NAME##_cus_equal_list<Manip> equal_list(const char* d, const char* c, Manip m, \
						bool i1, bool i2 = false) const;\
	template <class Manip>\
	NAME##_cus_equal_list<Manip> equal_list(const char* d, const char* c, Manip m, \
						NAME##_enum i1, NAME##_enum i2 = NAME##_NULL) const;\
	template <class Manip>\
	NAME##_cus_equal_list<Manip> equal_list(const char* d, const char* c, Manip m, \
						std::vector<bool> *i) const;\
	template <class Manip>\
	NAME##_cus_equal_list<Manip> equal_list(const char* d, const char* c, Manip m, \
						mysqlpp::sql_cmp_type sc) const;\
	private:\
	static const char* table_;\
	const char* table_override_;\
	};\
	MYSQLPP_SSQLS_CONDITIONAL_STATICS(\
		const char* NAME::names[] = {\
			    N1 ,\
    N2 \
		};\
		const char* NAME::table_ = #NAME;\
	)\
	template <class Manip>\
	NAME##_cus_value_list<Manip>::NAME##_cus_value_list\
			(const NAME* o, const char* d, Manip m, bool i1, bool i2)\
	{\
		delim = d;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(2, false);\
    if (i1) (*include)[0]=true;\
    if (i2) (*include)[1]=true;\
	}\
	template <class Manip>\
	NAME##_cus_value_list<Manip>::NAME##_cus_value_list\
			(const NAME* o, const char* d, Manip m, NAME##_enum i1, NAME##_enum i2)\
	{\
		delim = d;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(2, false);\
    if (i1 == NAME##_NULL) return;\
    (*include)[i1]=true;\
    if (i2 == NAME##_NULL) return;\
    (*include)[i2]=true;\
	}\
	template <class Manip>\
	NAME##_cus_field_list<Manip>::NAME##_cus_field_list\
			(const NAME* o, const char* d, Manip m, bool i1, bool i2)\
	{\
		delim = d;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(2, false);\
    if (i1) (*include)[0]=true;\
    if (i2) (*include)[1]=true;\
	}\
	template <class Manip>\
	NAME##_cus_field_list<Manip>::NAME##_cus_field_list\
			(const NAME* o, const char* d, Manip m, NAME##_enum i1, NAME##_enum i2)\
	{\
		delim = d;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(2, false);\
    if (i1 == NAME##_NULL) return;\
    (*include)[i1]=true;\
    if (i2 == NAME##_NULL) return;\
    (*include)[i2]=true;\
	}\
	template <class Manip>\
	NAME##_cus_equal_list<Manip>::NAME##_cus_equal_list\
			(const NAME* o, const char* d, const char* c, Manip m, bool i1, bool i2)\
	{\
		delim = d;\
		comp = c;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(2, false);\
    if (i1) (*include)[0]=true;\
    if (i2) (*include)[1]=true;\
	}\
	template <class Manip>\
	NAME##_cus_equal_list<Manip>::NAME##_cus_equal_list\
			(const NAME* o, const char* d, const char* c, Manip m, NAME##_enum i1, NAME##_enum i2)\
	{\
		delim = d;\
		comp = c;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(2, false);\
    if (i1 == NAME##_NULL) return;\
    (*include)[i1]=true;\
    if (i2 == NAME##_NULL) return;\
    (*include)[i2]=true;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_value_list<Manip>& obj)\
	{\
    s << obj.manip << obj.obj->I1 << obj.delim;\
    s << obj.manip << obj.obj->I2;\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_field_list<Manip>& obj)\
	{\
    s << obj.manip << '`' << obj.obj->names[0] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[1] << '`';\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_equal_list<Manip>& obj)\
	{\
    s << '`' << obj.obj->names[0] << '`' << obj.comp << obj.manip << obj.obj->I1 << obj.delim;\
    s << '`' << obj.obj->names[1] << '`' << obj.comp << obj.manip << obj.obj->I2;\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_cus_value_list<Manip>& obj)\
	{\
		bool before = false;\
    if ((*obj.include)[0]) { \
      s << obj.manip << obj.obj->I1;\
      before = true; \
     } \
    if ((*obj.include)[1]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I2;\
     } \
        (void)before;\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_cus_field_list<Manip>& obj)\
	{\
		bool before = false;\
    if ((*obj.include)[0]) { \
      s << obj.manip << '`' << obj.obj->names[0] << '`';\
      before = true; \
     } \
    if ((*obj.include)[1]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[1] << '`';\
     } \
        (void)before;\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_cus_equal_list<Manip>& obj)\
	{\
		bool before = false;\
    if ((*obj.include)[0]) { \
      s << '`' << obj.obj->names[0] << '`' << obj.comp << obj.manip << obj.obj->I1;\
      before = true; \
     } \
    if ((*obj.include)[1]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[1] << '`' << obj.comp << obj.manip << obj.obj->I2;\
     } \
        (void)before;\
		return s;\
	}\
	template <class Manip>\
	inline NAME##_value_list<Manip> NAME::value_list(const char* d, Manip m) const\
			{ return NAME##_value_list<Manip> (this, d, m); } \
	template <class Manip>\
	inline NAME##_field_list<Manip> NAME::field_list(const char* d, Manip m) const\
			{ return NAME##_field_list<Manip> (this, d, m); } \
	template <class Manip>\
	inline NAME##_equal_list<Manip> NAME::equal_list(const char* d, const char* c, Manip m) const\
			{ return NAME##_equal_list<Manip> (this, d, c, m); } \
	template <class Manip>\
	inline NAME##_cus_value_list<Manip> NAME::value_list(const char* d, Manip m,\
			bool i1, bool i2) const\
			{ return NAME##_cus_value_list<Manip> (this, d, m, i1, i2); }\
	template <class Manip>\
	inline NAME##_cus_field_list<Manip> NAME::field_list(const char* d, Manip m,\
			bool i1, bool i2) const\
			{ return NAME##_cus_field_list<Manip> (this, d, m, i1, i2); }\
	template <class Manip>\
	inline NAME##_cus_equal_list<Manip> NAME::equal_list(const char* d, const char* c, Manip m,\
			bool i1, bool i2) const\
			{ return NAME##_cus_equal_list<Manip> (this, d, c, m, i1, i2); } \
	template <class Manip>\
	inline NAME##_cus_value_list<Manip> NAME::value_list(const char* d, Manip m,\
			NAME##_enum i1, NAME##_enum i2) const\
			{ return NAME##_cus_value_list<Manip> (this, d, m, i1, i2); } \
	template <class Manip>\
	inline NAME##_cus_field_list<Manip> NAME::field_list(const char* d, Manip m,\
			NAME##_enum i1, NAME##_enum i2) const\
			{ return NAME##_cus_field_list<Manip> (this, d, m, i1, i2); } \
	template <class Manip>\
	inline NAME##_cus_equal_list<Manip> NAME::equal_list(const char* d, const char* c, Manip m, \
			NAME##_enum i1, NAME##_enum i2) const\
			{ return NAME##_cus_equal_list<Manip> (this, d, c, m, i1, i2); } \
	template <class Manip>\
	inline NAME##_cus_value_list<Manip> NAME::value_list(const char* d, Manip m,\
			std::vector<bool> *i) const\
			{ return NAME##_cus_value_list<Manip> (this, d, m, i); }\
	template <class Manip>\
	inline NAME##_cus_field_list<Manip> NAME::field_list(const char* d, Manip m,\
			std::vector<bool> *i) const\
			{ return NAME##_cus_field_list<Manip> (this, d, m, i); }\
	template <class Manip>\
	inline NAME##_cus_equal_list<Manip> NAME::equal_list(const char* d, const char* c, Manip m,\
			std::vector<bool> *i) const\
			{ return NAME##_cus_equal_list<Manip> (this, d, c, m, i); }\
	template <class Manip>\
	inline NAME##_cus_value_list<Manip> \
	NAME::value_list(const char* d, Manip m, mysqlpp::sql_cmp_type /*sc*/) const\
			{ sql_compare_type_def_##CMP(NAME, value, NUM); }\
	template <class Manip>\
	inline NAME##_cus_field_list<Manip> \
	NAME::field_list(const char* d, Manip m, mysqlpp::sql_cmp_type /*sc*/) const\
			{ sql_compare_type_def_##CMP(NAME, field, NUM); }\
	template <class Manip>\
	inline NAME##_cus_equal_list<Manip> \
	NAME::equal_list(const char* d, const char* c, Manip m, mysqlpp::sql_cmp_type /*sc*/) const\
			{ sql_compare_type_defe_##CMP(NAME, equal, NUM); }\
	template <mysqlpp::sql_dummy_type dummy>\
	void populate_##NAME(NAME *s, const mysqlpp::Row &row)\
	{\
		mysqlpp::NoExceptions ignore_schema_mismatches(row);\
    s->I1 = row[N1].conv(T1());\
    s->I2 = row[N2].conv(T2());\
	}\
	inline NAME::NAME(const mysqlpp::Row& row) :\
	table_override_(0)\
			{ populate_##NAME<mysqlpp::sql_dummy>(this, row); }\
	inline void NAME::set(const mysqlpp::Row& row)\
	{\
		table_override_ = 0;\
		populate_##NAME<mysqlpp::sql_dummy>(this, row);\
	}\
	sql_COMPARE__##CMP(NAME, I1, I2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 )

#define sql_create_2(NAME, CMP, CONTR, T1, I1, T2, I2) \
		sql_create_complete_2(NAME, CMP, CONTR, T1, I1, #I1, T2, I2, #I2) \

// ---------------------------------------------------
//                  End Create 2
// ---------------------------------------------------

// ---------------------------------------------------
//                  Begin Create 3
// ---------------------------------------------------
#define sql_create_complete_3(NAME, CMP, CONTR, T1, I1, N1, T2, I2, N2, T3, I3, N3) \
	struct NAME; \
	enum NAME##_enum { \
    NAME##_##I1,\
    NAME##_##I2,\
    NAME##_##I3 \
	,NAME##_NULL \
	}; \
	template <class Manip>\
	class NAME##_value_list { \
	public: \
	const NAME* obj;\
	const char* delim;\
	Manip manip;\
	public: \
	NAME##_value_list (const NAME* o, const char* d, Manip m) :\
	obj(o), delim(d), manip(m) { } \
	};\
	template <class Manip>\
	class NAME##_##field_list {\
	public: \
	const NAME* obj; \
	const char* delim;\
	Manip manip;\
	public: \
	NAME##_field_list (const NAME* o, const char* d, Manip m) :\
	obj(o), delim(d), manip(m) { } \
	};\
	template <class Manip>\
	class NAME##_equal_list { \
	public: \
	const NAME* obj;\
	const char* delim;\
	const char* comp;\
	Manip manip;\
	public: \
	NAME##_equal_list (const NAME* o, const char* d, const char* c, Manip m) :\
	obj(o), delim(d), comp(c), manip(m) { }\
	};\
	template <class Manip>\
	class NAME##_cus_value_list {\
	public:\
	const NAME* obj;\
	std::vector<bool> *include;\
	bool del_vector;\
	const char* delim;\
	Manip manip;\
	public: \
	~NAME##_cus_value_list () {if (del_vector) delete include;} \
	NAME##_cus_value_list (const NAME* o, const char* d, Manip m, bool i1, bool i2, bool i3);\
	NAME##_cus_value_list (const NAME* o, const char* d, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3); \
	NAME##_cus_value_list (const NAME* o, const char* d, Manip m ,std::vector<bool>* i) :\
	obj(o), include(i), del_vector(false), delim(d), manip(m) { }\
	};\
	template <class Manip>\
	class NAME##_cus_field_list { \
	public:\
	const NAME* obj; \
	std::vector<bool> *include; \
	bool del_vector; \
	const char* delim;\
	Manip manip;\
	public: \
	~NAME##_cus_field_list () {if (del_vector) delete include;} \
	NAME##_cus_field_list (const NAME* o, const char* d, Manip m, bool i1, bool i2, bool i3); \
	NAME##_cus_field_list (const NAME* o, const char* d, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3); \
	NAME##_cus_field_list (const NAME* o, const char* d, Manip m, std::vector<bool> *i) :\
	obj(o), include(i), del_vector(false), delim(d), manip(m) { }\
	};\
	template <class Manip>\
	class NAME##_cus_equal_list {\
	public:\
	const NAME* obj;\
	std::vector<bool> *include;\
	bool del_vector;\
	const char* delim;\
	const char* comp;\
	Manip manip;\
	public:\
	~NAME##_##cus_equal_list () {if (del_vector) delete include;}\
	NAME##_##cus_equal_list (const NAME* o, const char* d, const char* c, Manip m, bool i1, bool i2, bool i3); \
	NAME##_##cus_equal_list (const NAME* o, const char* d, const char* c, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3); \
	NAME##_##cus_equal_list (const NAME* o, const char* d, const char* c, Manip m, std::vector<bool> *i) :\
	obj(o), include(i), del_vector(false), delim(d), comp(c), manip(m) { }\
	};\
	template <mysqlpp::sql_dummy_type dummy> int sql_compare_##NAME(const NAME&, const NAME&);\
	struct NAME {\
    T1 I1;\
    T2 I2;\
    T3 I3; \
	NAME() : table_override_(0) { }\
	NAME(const mysqlpp::Row& row);\
	void set(const mysqlpp::Row &row);\
	sql_compare_define_##CMP(NAME, T1, I1, T2, I2, T3, I3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)\
	sql_construct_define_##CONTR(NAME, T1, I1, T2, I2, T3, I3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)\
	static const char* names[];\
	static void table(const char* t) { table_ = t; }\
	const char* table() const\
			{ return table_override_ ? table_override_ : NAME::table_; }\
	void instance_table(const char* t) { table_override_ = t; }\
	NAME##_value_list<mysqlpp::quote_type0> value_list() const {\
		return value_list(",", mysqlpp::quote);}\
	NAME##_value_list<mysqlpp::quote_type0> value_list(const char* d) const {\
		return value_list(d, mysqlpp::quote);}\
	template <class Manip>\
	NAME##_value_list<Manip> value_list(const char* d, Manip m) const;\
	NAME##_field_list<mysqlpp::do_nothing_type0> field_list() const {\
		return field_list(",", mysqlpp::do_nothing);}\
	NAME##_field_list<mysqlpp::do_nothing_type0> field_list(const char* d) const {\
		return field_list(d, mysqlpp::do_nothing);}\
	template <class Manip>\
	NAME##_field_list<Manip> field_list(const char* d, Manip m) const;\
	NAME##_equal_list<mysqlpp::quote_type0> equal_list(const char* d = ",",\
			const char* c = " = ") const\
			{ return equal_list(d, c, mysqlpp::quote); }\
	template <class Manip>\
	NAME##_equal_list<Manip> equal_list(const char* d, const char* c, Manip m) const;\
	/* cus_data */\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(bool i1, bool i2 = false, bool i3 = false) const\
			{ return value_list(",", mysqlpp::quote, i1, i2, i3); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL) const\
			{ return value_list(",", mysqlpp::quote, i1, i2, i3); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(std::vector<bool> *i) const\
			{ return value_list(",", mysqlpp::quote, i); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(mysqlpp::sql_cmp_type sc) const\
			{ return value_list(",", mysqlpp::quote, sc); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(const char* d, bool i1, bool i2 = false, bool i3 = false) const\
			{ return value_list(d, mysqlpp::quote, i1, i2, i3); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(const char* d, NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL) const\
			{ return value_list(d, mysqlpp::quote, i1, i2, i3); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(const char* d,\
			std::vector<bool> *i) const\
			{ return value_list(d, mysqlpp::quote, i); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(const char* d,\
			mysqlpp::sql_cmp_type sc) const\
			{ return value_list(d, mysqlpp::quote, sc); }\
	template <class Manip>\
	NAME##_cus_value_list<Manip> value_list(const char* d, Manip m,\
			bool i1, bool i2 = false, bool i3 = false) const;\
	template <class Manip>\
	NAME##_cus_value_list<Manip> value_list(const char* d, Manip m,\
			NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL) const;\
	template <class Manip>\
	NAME##_cus_value_list<Manip> value_list(const char* d, Manip m,\
			std::vector<bool>* i) const;\
	template <class Manip>\
	NAME##_cus_value_list<Manip> value_list(const char* d, Manip m, \
			mysqlpp::sql_cmp_type sc) const;\
	/* cus field */\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(bool i1, bool i2 = false, bool i3 = false) const \
			{ return field_list(",", mysqlpp::do_nothing, i1, i2, i3); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL) const\
			{ return field_list(",", mysqlpp::do_nothing, i1, i2, i3); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(std::vector<bool> *i) const\
			{ return field_list(",", mysqlpp::do_nothing, i); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(mysqlpp::sql_cmp_type sc) const\
			{ return field_list(",", mysqlpp::do_nothing, sc); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(const char* d,\
			bool i1, bool i2 = false, bool i3 = false) const\
			{ return field_list(d, mysqlpp::do_nothing, i1, i2, i3); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(const char* d,\
			NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL) const\
			{ return field_list(d, mysqlpp::do_nothing, i1, i2, i3); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(const char* d,\
			std::vector<bool>* i) const\
			{ return field_list(d, mysqlpp::do_nothing, i); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(const char* d,\
			mysqlpp::sql_cmp_type sc) const\
			{ return field_list(d, mysqlpp::do_nothing, sc); }\
	template <class Manip>\
	NAME##_cus_field_list<Manip> field_list(const char* d, Manip m,\
			bool i1, bool i2 = false, bool i3 = false) const;\
	template <class Manip>\
	NAME##_cus_field_list<Manip> field_list(const char* d, Manip m,\
			NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL) const;\
	template <class Manip>\
	NAME##_cus_field_list<Manip> field_list(const char* d, Manip m,\
			std::vector<bool> *i) const;\
	template <class Manip>\
	NAME##_cus_field_list<Manip> field_list(const char* d, Manip m,\
			mysqlpp::sql_cmp_type sc) const;\
	/* cus equal */\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(bool i1, bool i2 = false, bool i3 = false) const\
			{ return equal_list(",", " = ", mysqlpp::quote, i1, i2, i3); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL) const\
			{ return equal_list(",", " = ", mysqlpp::quote, i1, i2, i3); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(std::vector<bool>* i) const\
			{ return equal_list(",", " = ", mysqlpp::quote, i); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(mysqlpp::sql_cmp_type sc) const\
			{ return equal_list(",", " = ", mysqlpp::quote, sc); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, bool i1, bool i2 = false, bool i3 = false) const\
			{ return equal_list(d, " = ", mysqlpp::quote, i1, i2, i3); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL) const\
			{ return equal_list(d, " = ", mysqlpp::quote, i1, i2, i3); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d,\
			std::vector<bool> *i) const\
			{ return equal_list(d, " = ", mysqlpp::quote, i); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d,\
			mysqlpp::sql_cmp_type sc) const\
			{ return equal_list(d, " = ", mysqlpp::quote, sc); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, const char* c,\
			bool i1, bool i2 = false, bool i3 = false) const\
			{ return equal_list(d, c, mysqlpp::quote, i1, i2, i3); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, const char* c,\
			NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL) const\
			{ return equal_list(d, c, mysqlpp::quote, i1, i2, i3); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, const char* c,\
			std::vector<bool> *i) const\
			{ return equal_list(d, c, mysqlpp::quote, i); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, const char* c,\
			mysqlpp::sql_cmp_type sc) const\
			{ return equal_list(d, c, mysqlpp::quote, sc); }\
	template <class Manip>\
	NAME##_cus_equal_list<Manip> equal_list(const char* d, const char* c, Manip m, \
						bool i1, bool i2 = false, bool i3 = false) const;\
	template <class Manip>\
	NAME##_cus_equal_list<Manip> equal_list(const char* d, const char* c, Manip m, \
						NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL) const;\
	template <class Manip>\
	NAME##_cus_equal_list<Manip> equal_list(const char* d, const char* c, Manip m, \
						std::vector<bool> *i) const;\
	template <class Manip>\
	NAME##_cus_equal_list<Manip> equal_list(const char* d, const char* c, Manip m, \
						mysqlpp::sql_cmp_type sc) const;\
	private:\
	static const char* table_;\
	const char* table_override_;\
	};\
	MYSQLPP_SSQLS_CONDITIONAL_STATICS(\
		const char* NAME::names[] = {\
			    N1 ,\
    N2 ,\
    N3 \
		};\
		const char* NAME::table_ = #NAME;\
	)\
	template <class Manip>\
	NAME##_cus_value_list<Manip>::NAME##_cus_value_list\
			(const NAME* o, const char* d, Manip m, bool i1, bool i2, bool i3)\
	{\
		delim = d;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(3, false);\
    if (i1) (*include)[0]=true;\
    if (i2) (*include)[1]=true;\
    if (i3) (*include)[2]=true;\
	}\
	template <class Manip>\
	NAME##_cus_value_list<Manip>::NAME##_cus_value_list\
			(const NAME* o, const char* d, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3)\
	{\
		delim = d;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(3, false);\
    if (i1 == NAME##_NULL) return;\
    (*include)[i1]=true;\
    if (i2 == NAME##_NULL) return;\
    (*include)[i2]=true;\
    if (i3 == NAME##_NULL) return;\
    (*include)[i3]=true;\
	}\
	template <class Manip>\
	NAME##_cus_field_list<Manip>::NAME##_cus_field_list\
			(const NAME* o, const char* d, Manip m, bool i1, bool i2, bool i3)\
	{\
		delim = d;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(3, false);\
    if (i1) (*include)[0]=true;\
    if (i2) (*include)[1]=true;\
    if (i3) (*include)[2]=true;\
	}\
	template <class Manip>\
	NAME##_cus_field_list<Manip>::NAME##_cus_field_list\
			(const NAME* o, const char* d, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3)\
	{\
		delim = d;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(3, false);\
    if (i1 == NAME##_NULL) return;\
    (*include)[i1]=true;\
    if (i2 == NAME##_NULL) return;\
    (*include)[i2]=true;\
    if (i3 == NAME##_NULL) return;\
    (*include)[i3]=true;\
	}\
	template <class Manip>\
	NAME##_cus_equal_list<Manip>::NAME##_cus_equal_list\
			(const NAME* o, const char* d, const char* c, Manip m, bool i1, bool i2, bool i3)\
	{\
		delim = d;\
		comp = c;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(3, false);\
    if (i1) (*include)[0]=true;\
    if (i2) (*include)[1]=true;\
    if (i3) (*include)[2]=true;\
	}\
	template <class Manip>\
	NAME##_cus_equal_list<Manip>::NAME##_cus_equal_list\
			(const NAME* o, const char* d, const char* c, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3)\
	{\
		delim = d;\
		comp = c;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(3, false);\
    if (i1 == NAME##_NULL) return;\
    (*include)[i1]=true;\
    if (i2 == NAME##_NULL) return;\
    (*include)[i2]=true;\
    if (i3 == NAME##_NULL) return;\
    (*include)[i3]=true;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_value_list<Manip>& obj)\
	{\
    s << obj.manip << obj.obj->I1 << obj.delim;\
    s << obj.manip << obj.obj->I2 << obj.delim;\
    s << obj.manip << obj.obj->I3;\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_field_list<Manip>& obj)\
	{\
    s << obj.manip << '`' << obj.obj->names[0] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[1] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[2] << '`';\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_equal_list<Manip>& obj)\
	{\
    s << '`' << obj.obj->names[0] << '`' << obj.comp << obj.manip << obj.obj->I1 << obj.delim;\
    s << '`' << obj.obj->names[1] << '`' << obj.comp << obj.manip << obj.obj->I2 << obj.delim;\
    s << '`' << obj.obj->names[2] << '`' << obj.comp << obj.manip << obj.obj->I3;\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_cus_value_list<Manip>& obj)\
	{\
		bool before = false;\
    if ((*obj.include)[0]) { \
      s << obj.manip << obj.obj->I1;\
      before = true; \
     } \
    if ((*obj.include)[1]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I2;\
      before = true; \
     } \
    if ((*obj.include)[2]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I3;\
     } \
        (void)before;\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_cus_field_list<Manip>& obj)\
	{\
		bool before = false;\
    if ((*obj.include)[0]) { \
      s << obj.manip << '`' << obj.obj->names[0] << '`';\
      before = true; \
     } \
    if ((*obj.include)[1]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[1] << '`';\
      before = true; \
     } \
    if ((*obj.include)[2]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[2] << '`';\
     } \
        (void)before;\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_cus_equal_list<Manip>& obj)\
	{\
		bool before = false;\
    if ((*obj.include)[0]) { \
      s << '`' << obj.obj->names[0] << '`' << obj.comp << obj.manip << obj.obj->I1;\
      before = true; \
     } \
    if ((*obj.include)[1]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[1] << '`' << obj.comp << obj.manip << obj.obj->I2;\
      before = true; \
     } \
    if ((*obj.include)[2]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[2] << '`' << obj.comp << obj.manip << obj.obj->I3;\
     } \
        (void)before;\
		return s;\
	}\
	template <class Manip>\
	inline NAME##_value_list<Manip> NAME::value_list(const char* d, Manip m) const\
			{ return NAME##_value_list<Manip> (this, d, m); } \
	template <class Manip>\
	inline NAME##_field_list<Manip> NAME::field_list(const char* d, Manip m) const\
			{ return NAME##_field_list<Manip> (this, d, m); } \
	template <class Manip>\
	inline NAME##_equal_list<Manip> NAME::equal_list(const char* d, const char* c, Manip m) const\
			{ return NAME##_equal_list<Manip> (this, d, c, m); } \
	template <class Manip>\
	inline NAME##_cus_value_list<Manip> NAME::value_list(const char* d, Manip m,\
			bool i1, bool i2, bool i3) const\
			{ return NAME##_cus_value_list<Manip> (this, d, m, i1, i2, i3); }\
	template <class Manip>\
	inline NAME##_cus_field_list<Manip> NAME::field_list(const char* d, Manip m,\
			bool i1, bool i2, bool i3) const\
			{ return NAME##_cus_field_list<Manip> (this, d, m, i1, i2, i3); }\
	template <class Manip>\
	inline NAME##_cus_equal_list<Manip> NAME::equal_list(const char* d, const char* c, Manip m,\
			bool i1, bool i2, bool i3) const\
			{ return NAME##_cus_equal_list<Manip> (this, d, c, m, i1, i2, i3); } \
	template <class Manip>\
	inline NAME##_cus_value_list<Manip> NAME::value_list(const char* d, Manip m,\
			NAME##_enum i1, NAME##_enum i2, NAME##_enum i3) const\
			{ return NAME##_cus_value_list<Manip> (this, d, m, i1, i2, i3); } \
	template <class Manip>\
	inline NAME##_cus_field_list<Manip> NAME::field_list(const char* d, Manip m,\
			NAME##_enum i1, NAME##_enum i2, NAME##_enum i3) const\
			{ return NAME##_cus_field_list<Manip> (this, d, m, i1, i2, i3); } \
	template <class Manip>\
	inline NAME##_cus_equal_list<Manip> NAME::equal_list(const char* d, const char* c, Manip m, \
			NAME##_enum i1, NAME##_enum i2, NAME##_enum i3) const\
			{ return NAME##_cus_equal_list<Manip> (this, d, c, m, i1, i2, i3); } \
	template <class Manip>\
	inline NAME##_cus_value_list<Manip> NAME::value_list(const char* d, Manip m,\
			std::vector<bool> *i) const\
			{ return NAME##_cus_value_list<Manip> (this, d, m, i); }\
	template <class Manip>\
	inline NAME##_cus_field_list<Manip> NAME::field_list(const char* d, Manip m,\
			std::vector<bool> *i) const\
			{ return NAME##_cus_field_list<Manip> (this, d, m, i); }\
	template <class Manip>\
	inline NAME##_cus_equal_list<Manip> NAME::equal_list(const char* d, const char* c, Manip m,\
			std::vector<bool> *i) const\
			{ return NAME##_cus_equal_list<Manip> (this, d, c, m, i); }\
	template <class Manip>\
	inline NAME##_cus_value_list<Manip> \
	NAME::value_list(const char* d, Manip m, mysqlpp::sql_cmp_type /*sc*/) const\
			{ sql_compare_type_def_##CMP(NAME, value, NUM); }\
	template <class Manip>\
	inline NAME##_cus_field_list<Manip> \
	NAME::field_list(const char* d, Manip m, mysqlpp::sql_cmp_type /*sc*/) const\
			{ sql_compare_type_def_##CMP(NAME, field, NUM); }\
	template <class Manip>\
	inline NAME##_cus_equal_list<Manip> \
	NAME::equal_list(const char* d, const char* c, Manip m, mysqlpp::sql_cmp_type /*sc*/) const\
			{ sql_compare_type_defe_##CMP(NAME, equal, NUM); }\
	template <mysqlpp::sql_dummy_type dummy>\
	void populate_##NAME(NAME *s, const mysqlpp::Row &row)\
	{\
		mysqlpp::NoExceptions ignore_schema_mismatches(row);\
    s->I1 = row[N1].conv(T1());\
    s->I2 = row[N2].conv(T2());\
    s->I3 = row[N3].conv(T3());\
	}\
	inline NAME::NAME(const mysqlpp::Row& row) :\
	table_override_(0)\
			{ populate_##NAME<mysqlpp::sql_dummy>(this, row); }\
	inline void NAME::set(const mysqlpp::Row& row)\
	{\
		table_override_ = 0;\
		populate_##NAME<mysqlpp::sql_dummy>(this, row);\
	}\
	sql_COMPARE__##CMP(NAME, I1, I2, I3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 )

#define sql_create_3(NAME, CMP, CONTR, T1, I1, T2, I2, T3, I3) \
		sql_create_complete_3(NAME, CMP, CONTR, T1, I1, #I1, T2, I2, #I2, T3, I3, #I3) \

// ---------------------------------------------------
//                  End Create 3
// ---------------------------------------------------

// ---------------------------------------------------
//                  Begin Create 4
// ---------------------------------------------------
#define sql_create_complete_4(NAME, CMP, CONTR, T1, I1, N1, T2, I2, N2, T3, I3, N3, T4, I4, N4) \
	struct NAME; \
	enum NAME##_enum { \
    NAME##_##I1,\
    NAME##_##I2,\
    NAME##_##I3,\
    NAME##_##I4 \
	,NAME##_NULL \
	}; \
	template <class Manip>\
	class NAME##_value_list { \
	public: \
	const NAME* obj;\
	const char* delim;\
	Manip manip;\
	public: \
	NAME##_value_list (const NAME* o, const char* d, Manip m) :\
	obj(o), delim(d), manip(m) { } \
	};\
	template <class Manip>\
	class NAME##_##field_list {\
	public: \
	const NAME* obj; \
	const char* delim;\
	Manip manip;\
	public: \
	NAME##_field_list (const NAME* o, const char* d, Manip m) :\
	obj(o), delim(d), manip(m) { } \
	};\
	template <class Manip>\
	class NAME##_equal_list { \
	public: \
	const NAME* obj;\
	const char* delim;\
	const char* comp;\
	Manip manip;\
	public: \
	NAME##_equal_list (const NAME* o, const char* d, const char* c, Manip m) :\
	obj(o), delim(d), comp(c), manip(m) { }\
	};\
	template <class Manip>\
	class NAME##_cus_value_list {\
	public:\
	const NAME* obj;\
	std::vector<bool> *include;\
	bool del_vector;\
	const char* delim;\
	Manip manip;\
	public: \
	~NAME##_cus_value_list () {if (del_vector) delete include;} \
	NAME##_cus_value_list (const NAME* o, const char* d, Manip m, bool i1, bool i2, bool i3, bool i4);\
	NAME##_cus_value_list (const NAME* o, const char* d, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4); \
	NAME##_cus_value_list (const NAME* o, const char* d, Manip m ,std::vector<bool>* i) :\
	obj(o), include(i), del_vector(false), delim(d), manip(m) { }\
	};\
	template <class Manip>\
	class NAME##_cus_field_list { \
	public:\
	const NAME* obj; \
	std::vector<bool> *include; \
	bool del_vector; \
	const char* delim;\
	Manip manip;\
	public: \
	~NAME##_cus_field_list () {if (del_vector) delete include;} \
	NAME##_cus_field_list (const NAME* o, const char* d, Manip m, bool i1, bool i2, bool i3, bool i4); \
	NAME##_cus_field_list (const NAME* o, const char* d, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4); \
	NAME##_cus_field_list (const NAME* o, const char* d, Manip m, std::vector<bool> *i) :\
	obj(o), include(i), del_vector(false), delim(d), manip(m) { }\
	};\
	template <class Manip>\
	class NAME##_cus_equal_list {\
	public:\
	const NAME* obj;\
	std::vector<bool> *include;\
	bool del_vector;\
	const char* delim;\
	const char* comp;\
	Manip manip;\
	public:\
	~NAME##_##cus_equal_list () {if (del_vector) delete include;}\
	NAME##_##cus_equal_list (const NAME* o, const char* d, const char* c, Manip m, bool i1, bool i2, bool i3, bool i4); \
	NAME##_##cus_equal_list (const NAME* o, const char* d, const char* c, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4); \
	NAME##_##cus_equal_list (const NAME* o, const char* d, const char* c, Manip m, std::vector<bool> *i) :\
	obj(o), include(i), del_vector(false), delim(d), comp(c), manip(m) { }\
	};\
	template <mysqlpp::sql_dummy_type dummy> int sql_compare_##NAME(const NAME&, const NAME&);\
	struct NAME {\
    T1 I1;\
    T2 I2;\
    T3 I3;\
    T4 I4; \
	NAME() : table_override_(0) { }\
	NAME(const mysqlpp::Row& row);\
	void set(const mysqlpp::Row &row);\
	sql_compare_define_##CMP(NAME, T1, I1, T2, I2, T3, I3, T4, I4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)\
	sql_construct_define_##CONTR(NAME, T1, I1, T2, I2, T3, I3, T4, I4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)\
	static const char* names[];\
	static void table(const char* t) { table_ = t; }\
	const char* table() const\
			{ return table_override_ ? table_override_ : NAME::table_; }\
	void instance_table(const char* t) { table_override_ = t; }\
	NAME##_value_list<mysqlpp::quote_type0> value_list() const {\
		return value_list(",", mysqlpp::quote);}\
	NAME##_value_list<mysqlpp::quote_type0> value_list(const char* d) const {\
		return value_list(d, mysqlpp::quote);}\
	template <class Manip>\
	NAME##_value_list<Manip> value_list(const char* d, Manip m) const;\
	NAME##_field_list<mysqlpp::do_nothing_type0> field_list() const {\
		return field_list(",", mysqlpp::do_nothing);}\
	NAME##_field_list<mysqlpp::do_nothing_type0> field_list(const char* d) const {\
		return field_list(d, mysqlpp::do_nothing);}\
	template <class Manip>\
	NAME##_field_list<Manip> field_list(const char* d, Manip m) const;\
	NAME##_equal_list<mysqlpp::quote_type0> equal_list(const char* d = ",",\
			const char* c = " = ") const\
			{ return equal_list(d, c, mysqlpp::quote); }\
	template <class Manip>\
	NAME##_equal_list<Manip> equal_list(const char* d, const char* c, Manip m) const;\
	/* cus_data */\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(bool i1, bool i2 = false, bool i3 = false, bool i4 = false) const\
			{ return value_list(",", mysqlpp::quote, i1, i2, i3, i4); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL) const\
			{ return value_list(",", mysqlpp::quote, i1, i2, i3, i4); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(std::vector<bool> *i) const\
			{ return value_list(",", mysqlpp::quote, i); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(mysqlpp::sql_cmp_type sc) const\
			{ return value_list(",", mysqlpp::quote, sc); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(const char* d, bool i1, bool i2 = false, bool i3 = false, bool i4 = false) const\
			{ return value_list(d, mysqlpp::quote, i1, i2, i3, i4); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(const char* d, NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL) const\
			{ return value_list(d, mysqlpp::quote, i1, i2, i3, i4); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(const char* d,\
			std::vector<bool> *i) const\
			{ return value_list(d, mysqlpp::quote, i); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(const char* d,\
			mysqlpp::sql_cmp_type sc) const\
			{ return value_list(d, mysqlpp::quote, sc); }\
	template <class Manip>\
	NAME##_cus_value_list<Manip> value_list(const char* d, Manip m,\
			bool i1, bool i2 = false, bool i3 = false, bool i4 = false) const;\
	template <class Manip>\
	NAME##_cus_value_list<Manip> value_list(const char* d, Manip m,\
			NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL) const;\
	template <class Manip>\
	NAME##_cus_value_list<Manip> value_list(const char* d, Manip m,\
			std::vector<bool>* i) const;\
	template <class Manip>\
	NAME##_cus_value_list<Manip> value_list(const char* d, Manip m, \
			mysqlpp::sql_cmp_type sc) const;\
	/* cus field */\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(bool i1, bool i2 = false, bool i3 = false, bool i4 = false) const \
			{ return field_list(",", mysqlpp::do_nothing, i1, i2, i3, i4); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL) const\
			{ return field_list(",", mysqlpp::do_nothing, i1, i2, i3, i4); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(std::vector<bool> *i) const\
			{ return field_list(",", mysqlpp::do_nothing, i); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(mysqlpp::sql_cmp_type sc) const\
			{ return field_list(",", mysqlpp::do_nothing, sc); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(const char* d,\
			bool i1, bool i2 = false, bool i3 = false, bool i4 = false) const\
			{ return field_list(d, mysqlpp::do_nothing, i1, i2, i3, i4); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(const char* d,\
			NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL) const\
			{ return field_list(d, mysqlpp::do_nothing, i1, i2, i3, i4); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(const char* d,\
			std::vector<bool>* i) const\
			{ return field_list(d, mysqlpp::do_nothing, i); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(const char* d,\
			mysqlpp::sql_cmp_type sc) const\
			{ return field_list(d, mysqlpp::do_nothing, sc); }\
	template <class Manip>\
	NAME##_cus_field_list<Manip> field_list(const char* d, Manip m,\
			bool i1, bool i2 = false, bool i3 = false, bool i4 = false) const;\
	template <class Manip>\
	NAME##_cus_field_list<Manip> field_list(const char* d, Manip m,\
			NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL) const;\
	template <class Manip>\
	NAME##_cus_field_list<Manip> field_list(const char* d, Manip m,\
			std::vector<bool> *i) const;\
	template <class Manip>\
	NAME##_cus_field_list<Manip> field_list(const char* d, Manip m,\
			mysqlpp::sql_cmp_type sc) const;\
	/* cus equal */\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(bool i1, bool i2 = false, bool i3 = false, bool i4 = false) const\
			{ return equal_list(",", " = ", mysqlpp::quote, i1, i2, i3, i4); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL) const\
			{ return equal_list(",", " = ", mysqlpp::quote, i1, i2, i3, i4); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(std::vector<bool>* i) const\
			{ return equal_list(",", " = ", mysqlpp::quote, i); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(mysqlpp::sql_cmp_type sc) const\
			{ return equal_list(",", " = ", mysqlpp::quote, sc); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, bool i1, bool i2 = false, bool i3 = false, bool i4 = false) const\
			{ return equal_list(d, " = ", mysqlpp::quote, i1, i2, i3, i4); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL) const\
			{ return equal_list(d, " = ", mysqlpp::quote, i1, i2, i3, i4); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d,\
			std::vector<bool> *i) const\
			{ return equal_list(d, " = ", mysqlpp::quote, i); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d,\
			mysqlpp::sql_cmp_type sc) const\
			{ return equal_list(d, " = ", mysqlpp::quote, sc); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, const char* c,\
			bool i1, bool i2 = false, bool i3 = false, bool i4 = false) const\
			{ return equal_list(d, c, mysqlpp::quote, i1, i2, i3, i4); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, const char* c,\
			NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL) const\
			{ return equal_list(d, c, mysqlpp::quote, i1, i2, i3, i4); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, const char* c,\
			std::vector<bool> *i) const\
			{ return equal_list(d, c, mysqlpp::quote, i); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, const char* c,\
			mysqlpp::sql_cmp_type sc) const\
			{ return equal_list(d, c, mysqlpp::quote, sc); }\
	template <class Manip>\
	NAME##_cus_equal_list<Manip> equal_list(const char* d, const char* c, Manip m, \
						bool i1, bool i2 = false, bool i3 = false, bool i4 = false) const;\
	template <class Manip>\
	NAME##_cus_equal_list<Manip> equal_list(const char* d, const char* c, Manip m, \
						NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL) const;\
	template <class Manip>\
	NAME##_cus_equal_list<Manip> equal_list(const char* d, const char* c, Manip m, \
						std::vector<bool> *i) const;\
	template <class Manip>\
	NAME##_cus_equal_list<Manip> equal_list(const char* d, const char* c, Manip m, \
						mysqlpp::sql_cmp_type sc) const;\
	private:\
	static const char* table_;\
	const char* table_override_;\
	};\
	MYSQLPP_SSQLS_CONDITIONAL_STATICS(\
		const char* NAME::names[] = {\
			    N1 ,\
    N2 ,\
    N3 ,\
    N4 \
		};\
		const char* NAME::table_ = #NAME;\
	)\
	template <class Manip>\
	NAME##_cus_value_list<Manip>::NAME##_cus_value_list\
			(const NAME* o, const char* d, Manip m, bool i1, bool i2, bool i3, bool i4)\
	{\
		delim = d;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(4, false);\
    if (i1) (*include)[0]=true;\
    if (i2) (*include)[1]=true;\
    if (i3) (*include)[2]=true;\
    if (i4) (*include)[3]=true;\
	}\
	template <class Manip>\
	NAME##_cus_value_list<Manip>::NAME##_cus_value_list\
			(const NAME* o, const char* d, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4)\
	{\
		delim = d;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(4, false);\
    if (i1 == NAME##_NULL) return;\
    (*include)[i1]=true;\
    if (i2 == NAME##_NULL) return;\
    (*include)[i2]=true;\
    if (i3 == NAME##_NULL) return;\
    (*include)[i3]=true;\
    if (i4 == NAME##_NULL) return;\
    (*include)[i4]=true;\
	}\
	template <class Manip>\
	NAME##_cus_field_list<Manip>::NAME##_cus_field_list\
			(const NAME* o, const char* d, Manip m, bool i1, bool i2, bool i3, bool i4)\
	{\
		delim = d;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(4, false);\
    if (i1) (*include)[0]=true;\
    if (i2) (*include)[1]=true;\
    if (i3) (*include)[2]=true;\
    if (i4) (*include)[3]=true;\
	}\
	template <class Manip>\
	NAME##_cus_field_list<Manip>::NAME##_cus_field_list\
			(const NAME* o, const char* d, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4)\
	{\
		delim = d;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(4, false);\
    if (i1 == NAME##_NULL) return;\
    (*include)[i1]=true;\
    if (i2 == NAME##_NULL) return;\
    (*include)[i2]=true;\
    if (i3 == NAME##_NULL) return;\
    (*include)[i3]=true;\
    if (i4 == NAME##_NULL) return;\
    (*include)[i4]=true;\
	}\
	template <class Manip>\
	NAME##_cus_equal_list<Manip>::NAME##_cus_equal_list\
			(const NAME* o, const char* d, const char* c, Manip m, bool i1, bool i2, bool i3, bool i4)\
	{\
		delim = d;\
		comp = c;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(4, false);\
    if (i1) (*include)[0]=true;\
    if (i2) (*include)[1]=true;\
    if (i3) (*include)[2]=true;\
    if (i4) (*include)[3]=true;\
	}\
	template <class Manip>\
	NAME##_cus_equal_list<Manip>::NAME##_cus_equal_list\
			(const NAME* o, const char* d, const char* c, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4)\
	{\
		delim = d;\
		comp = c;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(4, false);\
    if (i1 == NAME##_NULL) return;\
    (*include)[i1]=true;\
    if (i2 == NAME##_NULL) return;\
    (*include)[i2]=true;\
    if (i3 == NAME##_NULL) return;\
    (*include)[i3]=true;\
    if (i4 == NAME##_NULL) return;\
    (*include)[i4]=true;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_value_list<Manip>& obj)\
	{\
    s << obj.manip << obj.obj->I1 << obj.delim;\
    s << obj.manip << obj.obj->I2 << obj.delim;\
    s << obj.manip << obj.obj->I3 << obj.delim;\
    s << obj.manip << obj.obj->I4;\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_field_list<Manip>& obj)\
	{\
    s << obj.manip << '`' << obj.obj->names[0] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[1] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[2] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[3] << '`';\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_equal_list<Manip>& obj)\
	{\
    s << '`' << obj.obj->names[0] << '`' << obj.comp << obj.manip << obj.obj->I1 << obj.delim;\
    s << '`' << obj.obj->names[1] << '`' << obj.comp << obj.manip << obj.obj->I2 << obj.delim;\
    s << '`' << obj.obj->names[2] << '`' << obj.comp << obj.manip << obj.obj->I3 << obj.delim;\
    s << '`' << obj.obj->names[3] << '`' << obj.comp << obj.manip << obj.obj->I4;\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_cus_value_list<Manip>& obj)\
	{\
		bool before = false;\
    if ((*obj.include)[0]) { \
      s << obj.manip << obj.obj->I1;\
      before = true; \
     } \
    if ((*obj.include)[1]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I2;\
      before = true; \
     } \
    if ((*obj.include)[2]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I3;\
      before = true; \
     } \
    if ((*obj.include)[3]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I4;\
     } \
        (void)before;\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_cus_field_list<Manip>& obj)\
	{\
		bool before = false;\
    if ((*obj.include)[0]) { \
      s << obj.manip << '`' << obj.obj->names[0] << '`';\
      before = true; \
     } \
    if ((*obj.include)[1]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[1] << '`';\
      before = true; \
     } \
    if ((*obj.include)[2]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[2] << '`';\
      before = true; \
     } \
    if ((*obj.include)[3]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[3] << '`';\
     } \
        (void)before;\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_cus_equal_list<Manip>& obj)\
	{\
		bool before = false;\
    if ((*obj.include)[0]) { \
      s << '`' << obj.obj->names[0] << '`' << obj.comp << obj.manip << obj.obj->I1;\
      before = true; \
     } \
    if ((*obj.include)[1]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[1] << '`' << obj.comp << obj.manip << obj.obj->I2;\
      before = true; \
     } \
    if ((*obj.include)[2]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[2] << '`' << obj.comp << obj.manip << obj.obj->I3;\
      before = true; \
     } \
    if ((*obj.include)[3]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[3] << '`' << obj.comp << obj.manip << obj.obj->I4;\
     } \
        (void)before;\
		return s;\
	}\
	template <class Manip>\
	inline NAME##_value_list<Manip> NAME::value_list(const char* d, Manip m) const\
			{ return NAME##_value_list<Manip> (this, d, m); } \
	template <class Manip>\
	inline NAME##_field_list<Manip> NAME::field_list(const char* d, Manip m) const\
			{ return NAME##_field_list<Manip> (this, d, m); } \
	template <class Manip>\
	inline NAME##_equal_list<Manip> NAME::equal_list(const char* d, const char* c, Manip m) const\
			{ return NAME##_equal_list<Manip> (this, d, c, m); } \
	template <class Manip>\
	inline NAME##_cus_value_list<Manip> NAME::value_list(const char* d, Manip m,\
			bool i1, bool i2, bool i3, bool i4) const\
			{ return NAME##_cus_value_list<Manip> (this, d, m, i1, i2, i3, i4); }\
	template <class Manip>\
	inline NAME##_cus_field_list<Manip> NAME::field_list(const char* d, Manip m,\
			bool i1, bool i2, bool i3, bool i4) const\
			{ return NAME##_cus_field_list<Manip> (this, d, m, i1, i2, i3, i4); }\
	template <class Manip>\
	inline NAME##_cus_equal_list<Manip> NAME::equal_list(const char* d, const char* c, Manip m,\
			bool i1, bool i2, bool i3, bool i4) const\
			{ return NAME##_cus_equal_list<Manip> (this, d, c, m, i1, i2, i3, i4); } \
	template <class Manip>\
	inline NAME##_cus_value_list<Manip> NAME::value_list(const char* d, Manip m,\
			NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4) const\
			{ return NAME##_cus_value_list<Manip> (this, d, m, i1, i2, i3, i4); } \
	template <class Manip>\
	inline NAME##_cus_field_list<Manip> NAME::field_list(const char* d, Manip m,\
			NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4) const\
			{ return NAME##_cus_field_list<Manip> (this, d, m, i1, i2, i3, i4); } \
	template <class Manip>\
	inline NAME##_cus_equal_list<Manip> NAME::equal_list(const char* d, const char* c, Manip m, \
			NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4) const\
			{ return NAME##_cus_equal_list<Manip> (this, d, c, m, i1, i2, i3, i4); } \
	template <class Manip>\
	inline NAME##_cus_value_list<Manip> NAME::value_list(const char* d, Manip m,\
			std::vector<bool> *i) const\
			{ return NAME##_cus_value_list<Manip> (this, d, m, i); }\
	template <class Manip>\
	inline NAME##_cus_field_list<Manip> NAME::field_list(const char* d, Manip m,\
			std::vector<bool> *i) const\
			{ return NAME##_cus_field_list<Manip> (this, d, m, i); }\
	template <class Manip>\
	inline NAME##_cus_equal_list<Manip> NAME::equal_list(const char* d, const char* c, Manip m,\
			std::vector<bool> *i) const\
			{ return NAME##_cus_equal_list<Manip> (this, d, c, m, i); }\
	template <class Manip>\
	inline NAME##_cus_value_list<Manip> \
	NAME::value_list(const char* d, Manip m, mysqlpp::sql_cmp_type /*sc*/) const\
			{ sql_compare_type_def_##CMP(NAME, value, NUM); }\
	template <class Manip>\
	inline NAME##_cus_field_list<Manip> \
	NAME::field_list(const char* d, Manip m, mysqlpp::sql_cmp_type /*sc*/) const\
			{ sql_compare_type_def_##CMP(NAME, field, NUM); }\
	template <class Manip>\
	inline NAME##_cus_equal_list<Manip> \
	NAME::equal_list(const char* d, const char* c, Manip m, mysqlpp::sql_cmp_type /*sc*/) const\
			{ sql_compare_type_defe_##CMP(NAME, equal, NUM); }\
	template <mysqlpp::sql_dummy_type dummy>\
	void populate_##NAME(NAME *s, const mysqlpp::Row &row)\
	{\
		mysqlpp::NoExceptions ignore_schema_mismatches(row);\
    s->I1 = row[N1].conv(T1());\
    s->I2 = row[N2].conv(T2());\
    s->I3 = row[N3].conv(T3());\
    s->I4 = row[N4].conv(T4());\
	}\
	inline NAME::NAME(const mysqlpp::Row& row) :\
	table_override_(0)\
			{ populate_##NAME<mysqlpp::sql_dummy>(this, row); }\
	inline void NAME::set(const mysqlpp::Row& row)\
	{\
		table_override_ = 0;\
		populate_##NAME<mysqlpp::sql_dummy>(this, row);\
	}\
	sql_COMPARE__##CMP(NAME, I1, I2, I3, I4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 )

#define sql_create_4(NAME, CMP, CONTR, T1, I1, T2, I2, T3, I3, T4, I4) \
		sql_create_complete_4(NAME, CMP, CONTR, T1, I1, #I1, T2, I2, #I2, T3, I3, #I3, T4, I4, #I4) \

// ---------------------------------------------------
//                  End Create 4
// ---------------------------------------------------

// ---------------------------------------------------
//                  Begin Create 5
// ---------------------------------------------------
#define sql_create_complete_5(NAME, CMP, CONTR, T1, I1, N1, T2, I2, N2, T3, I3, N3, T4, I4, N4, T5, I5, N5) \
	struct NAME; \
	enum NAME##_enum { \
    NAME##_##I1,\
    NAME##_##I2,\
    NAME##_##I3,\
    NAME##_##I4,\
    NAME##_##I5 \
	,NAME##_NULL \
	}; \
	template <class Manip>\
	class NAME##_value_list { \
	public: \
	const NAME* obj;\
	const char* delim;\
	Manip manip;\
	public: \
	NAME##_value_list (const NAME* o, const char* d, Manip m) :\
	obj(o), delim(d), manip(m) { } \
	};\
	template <class Manip>\
	class NAME##_##field_list {\
	public: \
	const NAME* obj; \
	const char* delim;\
	Manip manip;\
	public: \
	NAME##_field_list (const NAME* o, const char* d, Manip m) :\
	obj(o), delim(d), manip(m) { } \
	};\
	template <class Manip>\
	class NAME##_equal_list { \
	public: \
	const NAME* obj;\
	const char* delim;\
	const char* comp;\
	Manip manip;\
	public: \
	NAME##_equal_list (const NAME* o, const char* d, const char* c, Manip m) :\
	obj(o), delim(d), comp(c), manip(m) { }\
	};\
	template <class Manip>\
	class NAME##_cus_value_list {\
	public:\
	const NAME* obj;\
	std::vector<bool> *include;\
	bool del_vector;\
	const char* delim;\
	Manip manip;\
	public: \
	~NAME##_cus_value_list () {if (del_vector) delete include;} \
	NAME##_cus_value_list (const NAME* o, const char* d, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5);\
	NAME##_cus_value_list (const NAME* o, const char* d, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5); \
	NAME##_cus_value_list (const NAME* o, const char* d, Manip m ,std::vector<bool>* i) :\
	obj(o), include(i), del_vector(false), delim(d), manip(m) { }\
	};\
	template <class Manip>\
	class NAME##_cus_field_list { \
	public:\
	const NAME* obj; \
	std::vector<bool> *include; \
	bool del_vector; \
	const char* delim;\
	Manip manip;\
	public: \
	~NAME##_cus_field_list () {if (del_vector) delete include;} \
	NAME##_cus_field_list (const NAME* o, const char* d, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5); \
	NAME##_cus_field_list (const NAME* o, const char* d, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5); \
	NAME##_cus_field_list (const NAME* o, const char* d, Manip m, std::vector<bool> *i) :\
	obj(o), include(i), del_vector(false), delim(d), manip(m) { }\
	};\
	template <class Manip>\
	class NAME##_cus_equal_list {\
	public:\
	const NAME* obj;\
	std::vector<bool> *include;\
	bool del_vector;\
	const char* delim;\
	const char* comp;\
	Manip manip;\
	public:\
	~NAME##_##cus_equal_list () {if (del_vector) delete include;}\
	NAME##_##cus_equal_list (const NAME* o, const char* d, const char* c, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5); \
	NAME##_##cus_equal_list (const NAME* o, const char* d, const char* c, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5); \
	NAME##_##cus_equal_list (const NAME* o, const char* d, const char* c, Manip m, std::vector<bool> *i) :\
	obj(o), include(i), del_vector(false), delim(d), comp(c), manip(m) { }\
	};\
	template <mysqlpp::sql_dummy_type dummy> int sql_compare_##NAME(const NAME&, const NAME&);\
	struct NAME {\
    T1 I1;\
    T2 I2;\
    T3 I3;\
    T4 I4;\
    T5 I5; \
	NAME() : table_override_(0) { }\
	NAME(const mysqlpp::Row& row);\
	void set(const mysqlpp::Row &row);\
	sql_compare_define_##CMP(NAME, T1, I1, T2, I2, T3, I3, T4, I4, T5, I5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)\
	sql_construct_define_##CONTR(NAME, T1, I1, T2, I2, T3, I3, T4, I4, T5, I5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)\
	static const char* names[];\
	static void table(const char* t) { table_ = t; }\
	const char* table() const\
			{ return table_override_ ? table_override_ : NAME::table_; }\
	void instance_table(const char* t) { table_override_ = t; }\
	NAME##_value_list<mysqlpp::quote_type0> value_list() const {\
		return value_list(",", mysqlpp::quote);}\
	NAME##_value_list<mysqlpp::quote_type0> value_list(const char* d) const {\
		return value_list(d, mysqlpp::quote);}\
	template <class Manip>\
	NAME##_value_list<Manip> value_list(const char* d, Manip m) const;\
	NAME##_field_list<mysqlpp::do_nothing_type0> field_list() const {\
		return field_list(",", mysqlpp::do_nothing);}\
	NAME##_field_list<mysqlpp::do_nothing_type0> field_list(const char* d) const {\
		return field_list(d, mysqlpp::do_nothing);}\
	template <class Manip>\
	NAME##_field_list<Manip> field_list(const char* d, Manip m) const;\
	NAME##_equal_list<mysqlpp::quote_type0> equal_list(const char* d = ",",\
			const char* c = " = ") const\
			{ return equal_list(d, c, mysqlpp::quote); }\
	template <class Manip>\
	NAME##_equal_list<Manip> equal_list(const char* d, const char* c, Manip m) const;\
	/* cus_data */\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false) const\
			{ return value_list(",", mysqlpp::quote, i1, i2, i3, i4, i5); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL) const\
			{ return value_list(",", mysqlpp::quote, i1, i2, i3, i4, i5); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(std::vector<bool> *i) const\
			{ return value_list(",", mysqlpp::quote, i); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(mysqlpp::sql_cmp_type sc) const\
			{ return value_list(",", mysqlpp::quote, sc); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(const char* d, bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false) const\
			{ return value_list(d, mysqlpp::quote, i1, i2, i3, i4, i5); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(const char* d, NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL) const\
			{ return value_list(d, mysqlpp::quote, i1, i2, i3, i4, i5); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(const char* d,\
			std::vector<bool> *i) const\
			{ return value_list(d, mysqlpp::quote, i); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(const char* d,\
			mysqlpp::sql_cmp_type sc) const\
			{ return value_list(d, mysqlpp::quote, sc); }\
	template <class Manip>\
	NAME##_cus_value_list<Manip> value_list(const char* d, Manip m,\
			bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false) const;\
	template <class Manip>\
	NAME##_cus_value_list<Manip> value_list(const char* d, Manip m,\
			NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL) const;\
	template <class Manip>\
	NAME##_cus_value_list<Manip> value_list(const char* d, Manip m,\
			std::vector<bool>* i) const;\
	template <class Manip>\
	NAME##_cus_value_list<Manip> value_list(const char* d, Manip m, \
			mysqlpp::sql_cmp_type sc) const;\
	/* cus field */\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false) const \
			{ return field_list(",", mysqlpp::do_nothing, i1, i2, i3, i4, i5); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL) const\
			{ return field_list(",", mysqlpp::do_nothing, i1, i2, i3, i4, i5); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(std::vector<bool> *i) const\
			{ return field_list(",", mysqlpp::do_nothing, i); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(mysqlpp::sql_cmp_type sc) const\
			{ return field_list(",", mysqlpp::do_nothing, sc); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(const char* d,\
			bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false) const\
			{ return field_list(d, mysqlpp::do_nothing, i1, i2, i3, i4, i5); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(const char* d,\
			NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL) const\
			{ return field_list(d, mysqlpp::do_nothing, i1, i2, i3, i4, i5); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(const char* d,\
			std::vector<bool>* i) const\
			{ return field_list(d, mysqlpp::do_nothing, i); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(const char* d,\
			mysqlpp::sql_cmp_type sc) const\
			{ return field_list(d, mysqlpp::do_nothing, sc); }\
	template <class Manip>\
	NAME##_cus_field_list<Manip> field_list(const char* d, Manip m,\
			bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false) const;\
	template <class Manip>\
	NAME##_cus_field_list<Manip> field_list(const char* d, Manip m,\
			NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL) const;\
	template <class Manip>\
	NAME##_cus_field_list<Manip> field_list(const char* d, Manip m,\
			std::vector<bool> *i) const;\
	template <class Manip>\
	NAME##_cus_field_list<Manip> field_list(const char* d, Manip m,\
			mysqlpp::sql_cmp_type sc) const;\
	/* cus equal */\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false) const\
			{ return equal_list(",", " = ", mysqlpp::quote, i1, i2, i3, i4, i5); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL) const\
			{ return equal_list(",", " = ", mysqlpp::quote, i1, i2, i3, i4, i5); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(std::vector<bool>* i) const\
			{ return equal_list(",", " = ", mysqlpp::quote, i); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(mysqlpp::sql_cmp_type sc) const\
			{ return equal_list(",", " = ", mysqlpp::quote, sc); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false) const\
			{ return equal_list(d, " = ", mysqlpp::quote, i1, i2, i3, i4, i5); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL) const\
			{ return equal_list(d, " = ", mysqlpp::quote, i1, i2, i3, i4, i5); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d,\
			std::vector<bool> *i) const\
			{ return equal_list(d, " = ", mysqlpp::quote, i); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d,\
			mysqlpp::sql_cmp_type sc) const\
			{ return equal_list(d, " = ", mysqlpp::quote, sc); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, const char* c,\
			bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false) const\
			{ return equal_list(d, c, mysqlpp::quote, i1, i2, i3, i4, i5); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, const char* c,\
			NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL) const\
			{ return equal_list(d, c, mysqlpp::quote, i1, i2, i3, i4, i5); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, const char* c,\
			std::vector<bool> *i) const\
			{ return equal_list(d, c, mysqlpp::quote, i); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, const char* c,\
			mysqlpp::sql_cmp_type sc) const\
			{ return equal_list(d, c, mysqlpp::quote, sc); }\
	template <class Manip>\
	NAME##_cus_equal_list<Manip> equal_list(const char* d, const char* c, Manip m, \
						bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false) const;\
	template <class Manip>\
	NAME##_cus_equal_list<Manip> equal_list(const char* d, const char* c, Manip m, \
						NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL) const;\
	template <class Manip>\
	NAME##_cus_equal_list<Manip> equal_list(const char* d, const char* c, Manip m, \
						std::vector<bool> *i) const;\
	template <class Manip>\
	NAME##_cus_equal_list<Manip> equal_list(const char* d, const char* c, Manip m, \
						mysqlpp::sql_cmp_type sc) const;\
	private:\
	static const char* table_;\
	const char* table_override_;\
	};\
	MYSQLPP_SSQLS_CONDITIONAL_STATICS(\
		const char* NAME::names[] = {\
			    N1 ,\
    N2 ,\
    N3 ,\
    N4 ,\
    N5 \
		};\
		const char* NAME::table_ = #NAME;\
	)\
	template <class Manip>\
	NAME##_cus_value_list<Manip>::NAME##_cus_value_list\
			(const NAME* o, const char* d, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5)\
	{\
		delim = d;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(5, false);\
    if (i1) (*include)[0]=true;\
    if (i2) (*include)[1]=true;\
    if (i3) (*include)[2]=true;\
    if (i4) (*include)[3]=true;\
    if (i5) (*include)[4]=true;\
	}\
	template <class Manip>\
	NAME##_cus_value_list<Manip>::NAME##_cus_value_list\
			(const NAME* o, const char* d, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5)\
	{\
		delim = d;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(5, false);\
    if (i1 == NAME##_NULL) return;\
    (*include)[i1]=true;\
    if (i2 == NAME##_NULL) return;\
    (*include)[i2]=true;\
    if (i3 == NAME##_NULL) return;\
    (*include)[i3]=true;\
    if (i4 == NAME##_NULL) return;\
    (*include)[i4]=true;\
    if (i5 == NAME##_NULL) return;\
    (*include)[i5]=true;\
	}\
	template <class Manip>\
	NAME##_cus_field_list<Manip>::NAME##_cus_field_list\
			(const NAME* o, const char* d, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5)\
	{\
		delim = d;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(5, false);\
    if (i1) (*include)[0]=true;\
    if (i2) (*include)[1]=true;\
    if (i3) (*include)[2]=true;\
    if (i4) (*include)[3]=true;\
    if (i5) (*include)[4]=true;\
	}\
	template <class Manip>\
	NAME##_cus_field_list<Manip>::NAME##_cus_field_list\
			(const NAME* o, const char* d, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5)\
	{\
		delim = d;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(5, false);\
    if (i1 == NAME##_NULL) return;\
    (*include)[i1]=true;\
    if (i2 == NAME##_NULL) return;\
    (*include)[i2]=true;\
    if (i3 == NAME##_NULL) return;\
    (*include)[i3]=true;\
    if (i4 == NAME##_NULL) return;\
    (*include)[i4]=true;\
    if (i5 == NAME##_NULL) return;\
    (*include)[i5]=true;\
	}\
	template <class Manip>\
	NAME##_cus_equal_list<Manip>::NAME##_cus_equal_list\
			(const NAME* o, const char* d, const char* c, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5)\
	{\
		delim = d;\
		comp = c;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(5, false);\
    if (i1) (*include)[0]=true;\
    if (i2) (*include)[1]=true;\
    if (i3) (*include)[2]=true;\
    if (i4) (*include)[3]=true;\
    if (i5) (*include)[4]=true;\
	}\
	template <class Manip>\
	NAME##_cus_equal_list<Manip>::NAME##_cus_equal_list\
			(const NAME* o, const char* d, const char* c, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5)\
	{\
		delim = d;\
		comp = c;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(5, false);\
    if (i1 == NAME##_NULL) return;\
    (*include)[i1]=true;\
    if (i2 == NAME##_NULL) return;\
    (*include)[i2]=true;\
    if (i3 == NAME##_NULL) return;\
    (*include)[i3]=true;\
    if (i4 == NAME##_NULL) return;\
    (*include)[i4]=true;\
    if (i5 == NAME##_NULL) return;\
    (*include)[i5]=true;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_value_list<Manip>& obj)\
	{\
    s << obj.manip << obj.obj->I1 << obj.delim;\
    s << obj.manip << obj.obj->I2 << obj.delim;\
    s << obj.manip << obj.obj->I3 << obj.delim;\
    s << obj.manip << obj.obj->I4 << obj.delim;\
    s << obj.manip << obj.obj->I5;\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_field_list<Manip>& obj)\
	{\
    s << obj.manip << '`' << obj.obj->names[0] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[1] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[2] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[3] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[4] << '`';\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_equal_list<Manip>& obj)\
	{\
    s << '`' << obj.obj->names[0] << '`' << obj.comp << obj.manip << obj.obj->I1 << obj.delim;\
    s << '`' << obj.obj->names[1] << '`' << obj.comp << obj.manip << obj.obj->I2 << obj.delim;\
    s << '`' << obj.obj->names[2] << '`' << obj.comp << obj.manip << obj.obj->I3 << obj.delim;\
    s << '`' << obj.obj->names[3] << '`' << obj.comp << obj.manip << obj.obj->I4 << obj.delim;\
    s << '`' << obj.obj->names[4] << '`' << obj.comp << obj.manip << obj.obj->I5;\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_cus_value_list<Manip>& obj)\
	{\
		bool before = false;\
    if ((*obj.include)[0]) { \
      s << obj.manip << obj.obj->I1;\
      before = true; \
     } \
    if ((*obj.include)[1]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I2;\
      before = true; \
     } \
    if ((*obj.include)[2]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I3;\
      before = true; \
     } \
    if ((*obj.include)[3]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I4;\
      before = true; \
     } \
    if ((*obj.include)[4]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I5;\
     } \
        (void)before;\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_cus_field_list<Manip>& obj)\
	{\
		bool before = false;\
    if ((*obj.include)[0]) { \
      s << obj.manip << '`' << obj.obj->names[0] << '`';\
      before = true; \
     } \
    if ((*obj.include)[1]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[1] << '`';\
      before = true; \
     } \
    if ((*obj.include)[2]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[2] << '`';\
      before = true; \
     } \
    if ((*obj.include)[3]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[3] << '`';\
      before = true; \
     } \
    if ((*obj.include)[4]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[4] << '`';\
     } \
        (void)before;\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_cus_equal_list<Manip>& obj)\
	{\
		bool before = false;\
    if ((*obj.include)[0]) { \
      s << '`' << obj.obj->names[0] << '`' << obj.comp << obj.manip << obj.obj->I1;\
      before = true; \
     } \
    if ((*obj.include)[1]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[1] << '`' << obj.comp << obj.manip << obj.obj->I2;\
      before = true; \
     } \
    if ((*obj.include)[2]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[2] << '`' << obj.comp << obj.manip << obj.obj->I3;\
      before = true; \
     } \
    if ((*obj.include)[3]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[3] << '`' << obj.comp << obj.manip << obj.obj->I4;\
      before = true; \
     } \
    if ((*obj.include)[4]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[4] << '`' << obj.comp << obj.manip << obj.obj->I5;\
     } \
        (void)before;\
		return s;\
	}\
	template <class Manip>\
	inline NAME##_value_list<Manip> NAME::value_list(const char* d, Manip m) const\
			{ return NAME##_value_list<Manip> (this, d, m); } \
	template <class Manip>\
	inline NAME##_field_list<Manip> NAME::field_list(const char* d, Manip m) const\
			{ return NAME##_field_list<Manip> (this, d, m); } \
	template <class Manip>\
	inline NAME##_equal_list<Manip> NAME::equal_list(const char* d, const char* c, Manip m) const\
			{ return NAME##_equal_list<Manip> (this, d, c, m); } \
	template <class Manip>\
	inline NAME##_cus_value_list<Manip> NAME::value_list(const char* d, Manip m,\
			bool i1, bool i2, bool i3, bool i4, bool i5) const\
			{ return NAME##_cus_value_list<Manip> (this, d, m, i1, i2, i3, i4, i5); }\
	template <class Manip>\
	inline NAME##_cus_field_list<Manip> NAME::field_list(const char* d, Manip m,\
			bool i1, bool i2, bool i3, bool i4, bool i5) const\
			{ return NAME##_cus_field_list<Manip> (this, d, m, i1, i2, i3, i4, i5); }\
	template <class Manip>\
	inline NAME##_cus_equal_list<Manip> NAME::equal_list(const char* d, const char* c, Manip m,\
			bool i1, bool i2, bool i3, bool i4, bool i5) const\
			{ return NAME##_cus_equal_list<Manip> (this, d, c, m, i1, i2, i3, i4, i5); } \
	template <class Manip>\
	inline NAME##_cus_value_list<Manip> NAME::value_list(const char* d, Manip m,\
			NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5) const\
			{ return NAME##_cus_value_list<Manip> (this, d, m, i1, i2, i3, i4, i5); } \
	template <class Manip>\
	inline NAME##_cus_field_list<Manip> NAME::field_list(const char* d, Manip m,\
			NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5) const\
			{ return NAME##_cus_field_list<Manip> (this, d, m, i1, i2, i3, i4, i5); } \
	template <class Manip>\
	inline NAME##_cus_equal_list<Manip> NAME::equal_list(const char* d, const char* c, Manip m, \
			NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5) const\
			{ return NAME##_cus_equal_list<Manip> (this, d, c, m, i1, i2, i3, i4, i5); } \
	template <class Manip>\
	inline NAME##_cus_value_list<Manip> NAME::value_list(const char* d, Manip m,\
			std::vector<bool> *i) const\
			{ return NAME##_cus_value_list<Manip> (this, d, m, i); }\
	template <class Manip>\
	inline NAME##_cus_field_list<Manip> NAME::field_list(const char* d, Manip m,\
			std::vector<bool> *i) const\
			{ return NAME##_cus_field_list<Manip> (this, d, m, i); }\
	template <class Manip>\
	inline NAME##_cus_equal_list<Manip> NAME::equal_list(const char* d, const char* c, Manip m,\
			std::vector<bool> *i) const\
			{ return NAME##_cus_equal_list<Manip> (this, d, c, m, i); }\
	template <class Manip>\
	inline NAME##_cus_value_list<Manip> \
	NAME::value_list(const char* d, Manip m, mysqlpp::sql_cmp_type /*sc*/) const\
			{ sql_compare_type_def_##CMP(NAME, value, NUM); }\
	template <class Manip>\
	inline NAME##_cus_field_list<Manip> \
	NAME::field_list(const char* d, Manip m, mysqlpp::sql_cmp_type /*sc*/) const\
			{ sql_compare_type_def_##CMP(NAME, field, NUM); }\
	template <class Manip>\
	inline NAME##_cus_equal_list<Manip> \
	NAME::equal_list(const char* d, const char* c, Manip m, mysqlpp::sql_cmp_type /*sc*/) const\
			{ sql_compare_type_defe_##CMP(NAME, equal, NUM); }\
	template <mysqlpp::sql_dummy_type dummy>\
	void populate_##NAME(NAME *s, const mysqlpp::Row &row)\
	{\
		mysqlpp::NoExceptions ignore_schema_mismatches(row);\
    s->I1 = row[N1].conv(T1());\
    s->I2 = row[N2].conv(T2());\
    s->I3 = row[N3].conv(T3());\
    s->I4 = row[N4].conv(T4());\
    s->I5 = row[N5].conv(T5());\
	}\
	inline NAME::NAME(const mysqlpp::Row& row) :\
	table_override_(0)\
			{ populate_##NAME<mysqlpp::sql_dummy>(this, row); }\
	inline void NAME::set(const mysqlpp::Row& row)\
	{\
		table_override_ = 0;\
		populate_##NAME<mysqlpp::sql_dummy>(this, row);\
	}\
	sql_COMPARE__##CMP(NAME, I1, I2, I3, I4, I5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 )

#define sql_create_5(NAME, CMP, CONTR, T1, I1, T2, I2, T3, I3, T4, I4, T5, I5) \
		sql_create_complete_5(NAME, CMP, CONTR, T1, I1, #I1, T2, I2, #I2, T3, I3, #I3, T4, I4, #I4, T5, I5, #I5) \

// ---------------------------------------------------
//                  End Create 5
// ---------------------------------------------------

// ---------------------------------------------------
//                  Begin Create 6
// ---------------------------------------------------
#define sql_create_complete_6(NAME, CMP, CONTR, T1, I1, N1, T2, I2, N2, T3, I3, N3, T4, I4, N4, T5, I5, N5, T6, I6, N6) \
	struct NAME; \
	enum NAME##_enum { \
    NAME##_##I1,\
    NAME##_##I2,\
    NAME##_##I3,\
    NAME##_##I4,\
    NAME##_##I5,\
    NAME##_##I6 \
	,NAME##_NULL \
	}; \
	template <class Manip>\
	class NAME##_value_list { \
	public: \
	const NAME* obj;\
	const char* delim;\
	Manip manip;\
	public: \
	NAME##_value_list (const NAME* o, const char* d, Manip m) :\
	obj(o), delim(d), manip(m) { } \
	};\
	template <class Manip>\
	class NAME##_##field_list {\
	public: \
	const NAME* obj; \
	const char* delim;\
	Manip manip;\
	public: \
	NAME##_field_list (const NAME* o, const char* d, Manip m) :\
	obj(o), delim(d), manip(m) { } \
	};\
	template <class Manip>\
	class NAME##_equal_list { \
	public: \
	const NAME* obj;\
	const char* delim;\
	const char* comp;\
	Manip manip;\
	public: \
	NAME##_equal_list (const NAME* o, const char* d, const char* c, Manip m) :\
	obj(o), delim(d), comp(c), manip(m) { }\
	};\
	template <class Manip>\
	class NAME##_cus_value_list {\
	public:\
	const NAME* obj;\
	std::vector<bool> *include;\
	bool del_vector;\
	const char* delim;\
	Manip manip;\
	public: \
	~NAME##_cus_value_list () {if (del_vector) delete include;} \
	NAME##_cus_value_list (const NAME* o, const char* d, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6);\
	NAME##_cus_value_list (const NAME* o, const char* d, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6); \
	NAME##_cus_value_list (const NAME* o, const char* d, Manip m ,std::vector<bool>* i) :\
	obj(o), include(i), del_vector(false), delim(d), manip(m) { }\
	};\
	template <class Manip>\
	class NAME##_cus_field_list { \
	public:\
	const NAME* obj; \
	std::vector<bool> *include; \
	bool del_vector; \
	const char* delim;\
	Manip manip;\
	public: \
	~NAME##_cus_field_list () {if (del_vector) delete include;} \
	NAME##_cus_field_list (const NAME* o, const char* d, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6); \
	NAME##_cus_field_list (const NAME* o, const char* d, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6); \
	NAME##_cus_field_list (const NAME* o, const char* d, Manip m, std::vector<bool> *i) :\
	obj(o), include(i), del_vector(false), delim(d), manip(m) { }\
	};\
	template <class Manip>\
	class NAME##_cus_equal_list {\
	public:\
	const NAME* obj;\
	std::vector<bool> *include;\
	bool del_vector;\
	const char* delim;\
	const char* comp;\
	Manip manip;\
	public:\
	~NAME##_##cus_equal_list () {if (del_vector) delete include;}\
	NAME##_##cus_equal_list (const NAME* o, const char* d, const char* c, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6); \
	NAME##_##cus_equal_list (const NAME* o, const char* d, const char* c, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6); \
	NAME##_##cus_equal_list (const NAME* o, const char* d, const char* c, Manip m, std::vector<bool> *i) :\
	obj(o), include(i), del_vector(false), delim(d), comp(c), manip(m) { }\
	};\
	template <mysqlpp::sql_dummy_type dummy> int sql_compare_##NAME(const NAME&, const NAME&);\
	struct NAME {\
    T1 I1;\
    T2 I2;\
    T3 I3;\
    T4 I4;\
    T5 I5;\
    T6 I6; \
	NAME() : table_override_(0) { }\
	NAME(const mysqlpp::Row& row);\
	void set(const mysqlpp::Row &row);\
	sql_compare_define_##CMP(NAME, T1, I1, T2, I2, T3, I3, T4, I4, T5, I5, T6, I6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)\
	sql_construct_define_##CONTR(NAME, T1, I1, T2, I2, T3, I3, T4, I4, T5, I5, T6, I6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)\
	static const char* names[];\
	static void table(const char* t) { table_ = t; }\
	const char* table() const\
			{ return table_override_ ? table_override_ : NAME::table_; }\
	void instance_table(const char* t) { table_override_ = t; }\
	NAME##_value_list<mysqlpp::quote_type0> value_list() const {\
		return value_list(",", mysqlpp::quote);}\
	NAME##_value_list<mysqlpp::quote_type0> value_list(const char* d) const {\
		return value_list(d, mysqlpp::quote);}\
	template <class Manip>\
	NAME##_value_list<Manip> value_list(const char* d, Manip m) const;\
	NAME##_field_list<mysqlpp::do_nothing_type0> field_list() const {\
		return field_list(",", mysqlpp::do_nothing);}\
	NAME##_field_list<mysqlpp::do_nothing_type0> field_list(const char* d) const {\
		return field_list(d, mysqlpp::do_nothing);}\
	template <class Manip>\
	NAME##_field_list<Manip> field_list(const char* d, Manip m) const;\
	NAME##_equal_list<mysqlpp::quote_type0> equal_list(const char* d = ",",\
			const char* c = " = ") const\
			{ return equal_list(d, c, mysqlpp::quote); }\
	template <class Manip>\
	NAME##_equal_list<Manip> equal_list(const char* d, const char* c, Manip m) const;\
	/* cus_data */\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false) const\
			{ return value_list(",", mysqlpp::quote, i1, i2, i3, i4, i5, i6); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL) const\
			{ return value_list(",", mysqlpp::quote, i1, i2, i3, i4, i5, i6); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(std::vector<bool> *i) const\
			{ return value_list(",", mysqlpp::quote, i); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(mysqlpp::sql_cmp_type sc) const\
			{ return value_list(",", mysqlpp::quote, sc); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(const char* d, bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false) const\
			{ return value_list(d, mysqlpp::quote, i1, i2, i3, i4, i5, i6); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(const char* d, NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL) const\
			{ return value_list(d, mysqlpp::quote, i1, i2, i3, i4, i5, i6); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(const char* d,\
			std::vector<bool> *i) const\
			{ return value_list(d, mysqlpp::quote, i); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(const char* d,\
			mysqlpp::sql_cmp_type sc) const\
			{ return value_list(d, mysqlpp::quote, sc); }\
	template <class Manip>\
	NAME##_cus_value_list<Manip> value_list(const char* d, Manip m,\
			bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false) const;\
	template <class Manip>\
	NAME##_cus_value_list<Manip> value_list(const char* d, Manip m,\
			NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL) const;\
	template <class Manip>\
	NAME##_cus_value_list<Manip> value_list(const char* d, Manip m,\
			std::vector<bool>* i) const;\
	template <class Manip>\
	NAME##_cus_value_list<Manip> value_list(const char* d, Manip m, \
			mysqlpp::sql_cmp_type sc) const;\
	/* cus field */\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false) const \
			{ return field_list(",", mysqlpp::do_nothing, i1, i2, i3, i4, i5, i6); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL) const\
			{ return field_list(",", mysqlpp::do_nothing, i1, i2, i3, i4, i5, i6); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(std::vector<bool> *i) const\
			{ return field_list(",", mysqlpp::do_nothing, i); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(mysqlpp::sql_cmp_type sc) const\
			{ return field_list(",", mysqlpp::do_nothing, sc); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(const char* d,\
			bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false) const\
			{ return field_list(d, mysqlpp::do_nothing, i1, i2, i3, i4, i5, i6); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(const char* d,\
			NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL) const\
			{ return field_list(d, mysqlpp::do_nothing, i1, i2, i3, i4, i5, i6); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(const char* d,\
			std::vector<bool>* i) const\
			{ return field_list(d, mysqlpp::do_nothing, i); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(const char* d,\
			mysqlpp::sql_cmp_type sc) const\
			{ return field_list(d, mysqlpp::do_nothing, sc); }\
	template <class Manip>\
	NAME##_cus_field_list<Manip> field_list(const char* d, Manip m,\
			bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false) const;\
	template <class Manip>\
	NAME##_cus_field_list<Manip> field_list(const char* d, Manip m,\
			NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL) const;\
	template <class Manip>\
	NAME##_cus_field_list<Manip> field_list(const char* d, Manip m,\
			std::vector<bool> *i) const;\
	template <class Manip>\
	NAME##_cus_field_list<Manip> field_list(const char* d, Manip m,\
			mysqlpp::sql_cmp_type sc) const;\
	/* cus equal */\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false) const\
			{ return equal_list(",", " = ", mysqlpp::quote, i1, i2, i3, i4, i5, i6); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL) const\
			{ return equal_list(",", " = ", mysqlpp::quote, i1, i2, i3, i4, i5, i6); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(std::vector<bool>* i) const\
			{ return equal_list(",", " = ", mysqlpp::quote, i); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(mysqlpp::sql_cmp_type sc) const\
			{ return equal_list(",", " = ", mysqlpp::quote, sc); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false) const\
			{ return equal_list(d, " = ", mysqlpp::quote, i1, i2, i3, i4, i5, i6); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL) const\
			{ return equal_list(d, " = ", mysqlpp::quote, i1, i2, i3, i4, i5, i6); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d,\
			std::vector<bool> *i) const\
			{ return equal_list(d, " = ", mysqlpp::quote, i); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d,\
			mysqlpp::sql_cmp_type sc) const\
			{ return equal_list(d, " = ", mysqlpp::quote, sc); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, const char* c,\
			bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false) const\
			{ return equal_list(d, c, mysqlpp::quote, i1, i2, i3, i4, i5, i6); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, const char* c,\
			NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL) const\
			{ return equal_list(d, c, mysqlpp::quote, i1, i2, i3, i4, i5, i6); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, const char* c,\
			std::vector<bool> *i) const\
			{ return equal_list(d, c, mysqlpp::quote, i); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, const char* c,\
			mysqlpp::sql_cmp_type sc) const\
			{ return equal_list(d, c, mysqlpp::quote, sc); }\
	template <class Manip>\
	NAME##_cus_equal_list<Manip> equal_list(const char* d, const char* c, Manip m, \
						bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false) const;\
	template <class Manip>\
	NAME##_cus_equal_list<Manip> equal_list(const char* d, const char* c, Manip m, \
						NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL) const;\
	template <class Manip>\
	NAME##_cus_equal_list<Manip> equal_list(const char* d, const char* c, Manip m, \
						std::vector<bool> *i) const;\
	template <class Manip>\
	NAME##_cus_equal_list<Manip> equal_list(const char* d, const char* c, Manip m, \
						mysqlpp::sql_cmp_type sc) const;\
	private:\
	static const char* table_;\
	const char* table_override_;\
	};\
	MYSQLPP_SSQLS_CONDITIONAL_STATICS(\
		const char* NAME::names[] = {\
			    N1 ,\
    N2 ,\
    N3 ,\
    N4 ,\
    N5 ,\
    N6 \
		};\
		const char* NAME::table_ = #NAME;\
	)\
	template <class Manip>\
	NAME##_cus_value_list<Manip>::NAME##_cus_value_list\
			(const NAME* o, const char* d, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6)\
	{\
		delim = d;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(6, false);\
    if (i1) (*include)[0]=true;\
    if (i2) (*include)[1]=true;\
    if (i3) (*include)[2]=true;\
    if (i4) (*include)[3]=true;\
    if (i5) (*include)[4]=true;\
    if (i6) (*include)[5]=true;\
	}\
	template <class Manip>\
	NAME##_cus_value_list<Manip>::NAME##_cus_value_list\
			(const NAME* o, const char* d, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6)\
	{\
		delim = d;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(6, false);\
    if (i1 == NAME##_NULL) return;\
    (*include)[i1]=true;\
    if (i2 == NAME##_NULL) return;\
    (*include)[i2]=true;\
    if (i3 == NAME##_NULL) return;\
    (*include)[i3]=true;\
    if (i4 == NAME##_NULL) return;\
    (*include)[i4]=true;\
    if (i5 == NAME##_NULL) return;\
    (*include)[i5]=true;\
    if (i6 == NAME##_NULL) return;\
    (*include)[i6]=true;\
	}\
	template <class Manip>\
	NAME##_cus_field_list<Manip>::NAME##_cus_field_list\
			(const NAME* o, const char* d, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6)\
	{\
		delim = d;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(6, false);\
    if (i1) (*include)[0]=true;\
    if (i2) (*include)[1]=true;\
    if (i3) (*include)[2]=true;\
    if (i4) (*include)[3]=true;\
    if (i5) (*include)[4]=true;\
    if (i6) (*include)[5]=true;\
	}\
	template <class Manip>\
	NAME##_cus_field_list<Manip>::NAME##_cus_field_list\
			(const NAME* o, const char* d, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6)\
	{\
		delim = d;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(6, false);\
    if (i1 == NAME##_NULL) return;\
    (*include)[i1]=true;\
    if (i2 == NAME##_NULL) return;\
    (*include)[i2]=true;\
    if (i3 == NAME##_NULL) return;\
    (*include)[i3]=true;\
    if (i4 == NAME##_NULL) return;\
    (*include)[i4]=true;\
    if (i5 == NAME##_NULL) return;\
    (*include)[i5]=true;\
    if (i6 == NAME##_NULL) return;\
    (*include)[i6]=true;\
	}\
	template <class Manip>\
	NAME##_cus_equal_list<Manip>::NAME##_cus_equal_list\
			(const NAME* o, const char* d, const char* c, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6)\
	{\
		delim = d;\
		comp = c;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(6, false);\
    if (i1) (*include)[0]=true;\
    if (i2) (*include)[1]=true;\
    if (i3) (*include)[2]=true;\
    if (i4) (*include)[3]=true;\
    if (i5) (*include)[4]=true;\
    if (i6) (*include)[5]=true;\
	}\
	template <class Manip>\
	NAME##_cus_equal_list<Manip>::NAME##_cus_equal_list\
			(const NAME* o, const char* d, const char* c, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6)\
	{\
		delim = d;\
		comp = c;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(6, false);\
    if (i1 == NAME##_NULL) return;\
    (*include)[i1]=true;\
    if (i2 == NAME##_NULL) return;\
    (*include)[i2]=true;\
    if (i3 == NAME##_NULL) return;\
    (*include)[i3]=true;\
    if (i4 == NAME##_NULL) return;\
    (*include)[i4]=true;\
    if (i5 == NAME##_NULL) return;\
    (*include)[i5]=true;\
    if (i6 == NAME##_NULL) return;\
    (*include)[i6]=true;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_value_list<Manip>& obj)\
	{\
    s << obj.manip << obj.obj->I1 << obj.delim;\
    s << obj.manip << obj.obj->I2 << obj.delim;\
    s << obj.manip << obj.obj->I3 << obj.delim;\
    s << obj.manip << obj.obj->I4 << obj.delim;\
    s << obj.manip << obj.obj->I5 << obj.delim;\
    s << obj.manip << obj.obj->I6;\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_field_list<Manip>& obj)\
	{\
    s << obj.manip << '`' << obj.obj->names[0] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[1] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[2] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[3] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[4] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[5] << '`';\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_equal_list<Manip>& obj)\
	{\
    s << '`' << obj.obj->names[0] << '`' << obj.comp << obj.manip << obj.obj->I1 << obj.delim;\
    s << '`' << obj.obj->names[1] << '`' << obj.comp << obj.manip << obj.obj->I2 << obj.delim;\
    s << '`' << obj.obj->names[2] << '`' << obj.comp << obj.manip << obj.obj->I3 << obj.delim;\
    s << '`' << obj.obj->names[3] << '`' << obj.comp << obj.manip << obj.obj->I4 << obj.delim;\
    s << '`' << obj.obj->names[4] << '`' << obj.comp << obj.manip << obj.obj->I5 << obj.delim;\
    s << '`' << obj.obj->names[5] << '`' << obj.comp << obj.manip << obj.obj->I6;\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_cus_value_list<Manip>& obj)\
	{\
		bool before = false;\
    if ((*obj.include)[0]) { \
      s << obj.manip << obj.obj->I1;\
      before = true; \
     } \
    if ((*obj.include)[1]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I2;\
      before = true; \
     } \
    if ((*obj.include)[2]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I3;\
      before = true; \
     } \
    if ((*obj.include)[3]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I4;\
      before = true; \
     } \
    if ((*obj.include)[4]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I5;\
      before = true; \
     } \
    if ((*obj.include)[5]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I6;\
     } \
        (void)before;\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_cus_field_list<Manip>& obj)\
	{\
		bool before = false;\
    if ((*obj.include)[0]) { \
      s << obj.manip << '`' << obj.obj->names[0] << '`';\
      before = true; \
     } \
    if ((*obj.include)[1]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[1] << '`';\
      before = true; \
     } \
    if ((*obj.include)[2]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[2] << '`';\
      before = true; \
     } \
    if ((*obj.include)[3]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[3] << '`';\
      before = true; \
     } \
    if ((*obj.include)[4]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[4] << '`';\
      before = true; \
     } \
    if ((*obj.include)[5]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[5] << '`';\
     } \
        (void)before;\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_cus_equal_list<Manip>& obj)\
	{\
		bool before = false;\
    if ((*obj.include)[0]) { \
      s << '`' << obj.obj->names[0] << '`' << obj.comp << obj.manip << obj.obj->I1;\
      before = true; \
     } \
    if ((*obj.include)[1]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[1] << '`' << obj.comp << obj.manip << obj.obj->I2;\
      before = true; \
     } \
    if ((*obj.include)[2]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[2] << '`' << obj.comp << obj.manip << obj.obj->I3;\
      before = true; \
     } \
    if ((*obj.include)[3]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[3] << '`' << obj.comp << obj.manip << obj.obj->I4;\
      before = true; \
     } \
    if ((*obj.include)[4]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[4] << '`' << obj.comp << obj.manip << obj.obj->I5;\
      before = true; \
     } \
    if ((*obj.include)[5]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[5] << '`' << obj.comp << obj.manip << obj.obj->I6;\
     } \
        (void)before;\
		return s;\
	}\
	template <class Manip>\
	inline NAME##_value_list<Manip> NAME::value_list(const char* d, Manip m) const\
			{ return NAME##_value_list<Manip> (this, d, m); } \
	template <class Manip>\
	inline NAME##_field_list<Manip> NAME::field_list(const char* d, Manip m) const\
			{ return NAME##_field_list<Manip> (this, d, m); } \
	template <class Manip>\
	inline NAME##_equal_list<Manip> NAME::equal_list(const char* d, const char* c, Manip m) const\
			{ return NAME##_equal_list<Manip> (this, d, c, m); } \
	template <class Manip>\
	inline NAME##_cus_value_list<Manip> NAME::value_list(const char* d, Manip m,\
			bool i1, bool i2, bool i3, bool i4, bool i5, bool i6) const\
			{ return NAME##_cus_value_list<Manip> (this, d, m, i1, i2, i3, i4, i5, i6); }\
	template <class Manip>\
	inline NAME##_cus_field_list<Manip> NAME::field_list(const char* d, Manip m,\
			bool i1, bool i2, bool i3, bool i4, bool i5, bool i6) const\
			{ return NAME##_cus_field_list<Manip> (this, d, m, i1, i2, i3, i4, i5, i6); }\
	template <class Manip>\
	inline NAME##_cus_equal_list<Manip> NAME::equal_list(const char* d, const char* c, Manip m,\
			bool i1, bool i2, bool i3, bool i4, bool i5, bool i6) const\
			{ return NAME##_cus_equal_list<Manip> (this, d, c, m, i1, i2, i3, i4, i5, i6); } \
	template <class Manip>\
	inline NAME##_cus_value_list<Manip> NAME::value_list(const char* d, Manip m,\
			NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6) const\
			{ return NAME##_cus_value_list<Manip> (this, d, m, i1, i2, i3, i4, i5, i6); } \
	template <class Manip>\
	inline NAME##_cus_field_list<Manip> NAME::field_list(const char* d, Manip m,\
			NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6) const\
			{ return NAME##_cus_field_list<Manip> (this, d, m, i1, i2, i3, i4, i5, i6); } \
	template <class Manip>\
	inline NAME##_cus_equal_list<Manip> NAME::equal_list(const char* d, const char* c, Manip m, \
			NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6) const\
			{ return NAME##_cus_equal_list<Manip> (this, d, c, m, i1, i2, i3, i4, i5, i6); } \
	template <class Manip>\
	inline NAME##_cus_value_list<Manip> NAME::value_list(const char* d, Manip m,\
			std::vector<bool> *i) const\
			{ return NAME##_cus_value_list<Manip> (this, d, m, i); }\
	template <class Manip>\
	inline NAME##_cus_field_list<Manip> NAME::field_list(const char* d, Manip m,\
			std::vector<bool> *i) const\
			{ return NAME##_cus_field_list<Manip> (this, d, m, i); }\
	template <class Manip>\
	inline NAME##_cus_equal_list<Manip> NAME::equal_list(const char* d, const char* c, Manip m,\
			std::vector<bool> *i) const\
			{ return NAME##_cus_equal_list<Manip> (this, d, c, m, i); }\
	template <class Manip>\
	inline NAME##_cus_value_list<Manip> \
	NAME::value_list(const char* d, Manip m, mysqlpp::sql_cmp_type /*sc*/) const\
			{ sql_compare_type_def_##CMP(NAME, value, NUM); }\
	template <class Manip>\
	inline NAME##_cus_field_list<Manip> \
	NAME::field_list(const char* d, Manip m, mysqlpp::sql_cmp_type /*sc*/) const\
			{ sql_compare_type_def_##CMP(NAME, field, NUM); }\
	template <class Manip>\
	inline NAME##_cus_equal_list<Manip> \
	NAME::equal_list(const char* d, const char* c, Manip m, mysqlpp::sql_cmp_type /*sc*/) const\
			{ sql_compare_type_defe_##CMP(NAME, equal, NUM); }\
	template <mysqlpp::sql_dummy_type dummy>\
	void populate_##NAME(NAME *s, const mysqlpp::Row &row)\
	{\
		mysqlpp::NoExceptions ignore_schema_mismatches(row);\
    s->I1 = row[N1].conv(T1());\
    s->I2 = row[N2].conv(T2());\
    s->I3 = row[N3].conv(T3());\
    s->I4 = row[N4].conv(T4());\
    s->I5 = row[N5].conv(T5());\
    s->I6 = row[N6].conv(T6());\
	}\
	inline NAME::NAME(const mysqlpp::Row& row) :\
	table_override_(0)\
			{ populate_##NAME<mysqlpp::sql_dummy>(this, row); }\
	inline void NAME::set(const mysqlpp::Row& row)\
	{\
		table_override_ = 0;\
		populate_##NAME<mysqlpp::sql_dummy>(this, row);\
	}\
	sql_COMPARE__##CMP(NAME, I1, I2, I3, I4, I5, I6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 )

#define sql_create_6(NAME, CMP, CONTR, T1, I1, T2, I2, T3, I3, T4, I4, T5, I5, T6, I6) \
		sql_create_complete_6(NAME, CMP, CONTR, T1, I1, #I1, T2, I2, #I2, T3, I3, #I3, T4, I4, #I4, T5, I5, #I5, T6, I6, #I6) \

// ---------------------------------------------------
//                  End Create 6
// ---------------------------------------------------

// ---------------------------------------------------
//                  Begin Create 7
// ---------------------------------------------------
#define sql_create_complete_7(NAME, CMP, CONTR, T1, I1, N1, T2, I2, N2, T3, I3, N3, T4, I4, N4, T5, I5, N5, T6, I6, N6, T7, I7, N7) \
	struct NAME; \
	enum NAME##_enum { \
    NAME##_##I1,\
    NAME##_##I2,\
    NAME##_##I3,\
    NAME##_##I4,\
    NAME##_##I5,\
    NAME##_##I6,\
    NAME##_##I7 \
	,NAME##_NULL \
	}; \
	template <class Manip>\
	class NAME##_value_list { \
	public: \
	const NAME* obj;\
	const char* delim;\
	Manip manip;\
	public: \
	NAME##_value_list (const NAME* o, const char* d, Manip m) :\
	obj(o), delim(d), manip(m) { } \
	};\
	template <class Manip>\
	class NAME##_##field_list {\
	public: \
	const NAME* obj; \
	const char* delim;\
	Manip manip;\
	public: \
	NAME##_field_list (const NAME* o, const char* d, Manip m) :\
	obj(o), delim(d), manip(m) { } \
	};\
	template <class Manip>\
	class NAME##_equal_list { \
	public: \
	const NAME* obj;\
	const char* delim;\
	const char* comp;\
	Manip manip;\
	public: \
	NAME##_equal_list (const NAME* o, const char* d, const char* c, Manip m) :\
	obj(o), delim(d), comp(c), manip(m) { }\
	};\
	template <class Manip>\
	class NAME##_cus_value_list {\
	public:\
	const NAME* obj;\
	std::vector<bool> *include;\
	bool del_vector;\
	const char* delim;\
	Manip manip;\
	public: \
	~NAME##_cus_value_list () {if (del_vector) delete include;} \
	NAME##_cus_value_list (const NAME* o, const char* d, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7);\
	NAME##_cus_value_list (const NAME* o, const char* d, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7); \
	NAME##_cus_value_list (const NAME* o, const char* d, Manip m ,std::vector<bool>* i) :\
	obj(o), include(i), del_vector(false), delim(d), manip(m) { }\
	};\
	template <class Manip>\
	class NAME##_cus_field_list { \
	public:\
	const NAME* obj; \
	std::vector<bool> *include; \
	bool del_vector; \
	const char* delim;\
	Manip manip;\
	public: \
	~NAME##_cus_field_list () {if (del_vector) delete include;} \
	NAME##_cus_field_list (const NAME* o, const char* d, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7); \
	NAME##_cus_field_list (const NAME* o, const char* d, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7); \
	NAME##_cus_field_list (const NAME* o, const char* d, Manip m, std::vector<bool> *i) :\
	obj(o), include(i), del_vector(false), delim(d), manip(m) { }\
	};\
	template <class Manip>\
	class NAME##_cus_equal_list {\
	public:\
	const NAME* obj;\
	std::vector<bool> *include;\
	bool del_vector;\
	const char* delim;\
	const char* comp;\
	Manip manip;\
	public:\
	~NAME##_##cus_equal_list () {if (del_vector) delete include;}\
	NAME##_##cus_equal_list (const NAME* o, const char* d, const char* c, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7); \
	NAME##_##cus_equal_list (const NAME* o, const char* d, const char* c, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7); \
	NAME##_##cus_equal_list (const NAME* o, const char* d, const char* c, Manip m, std::vector<bool> *i) :\
	obj(o), include(i), del_vector(false), delim(d), comp(c), manip(m) { }\
	};\
	template <mysqlpp::sql_dummy_type dummy> int sql_compare_##NAME(const NAME&, const NAME&);\
	struct NAME {\
    T1 I1;\
    T2 I2;\
    T3 I3;\
    T4 I4;\
    T5 I5;\
    T6 I6;\
    T7 I7; \
	NAME() : table_override_(0) { }\
	NAME(const mysqlpp::Row& row);\
	void set(const mysqlpp::Row &row);\
	sql_compare_define_##CMP(NAME, T1, I1, T2, I2, T3, I3, T4, I4, T5, I5, T6, I6, T7, I7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)\
	sql_construct_define_##CONTR(NAME, T1, I1, T2, I2, T3, I3, T4, I4, T5, I5, T6, I6, T7, I7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)\
	static const char* names[];\
	static void table(const char* t) { table_ = t; }\
	const char* table() const\
			{ return table_override_ ? table_override_ : NAME::table_; }\
	void instance_table(const char* t) { table_override_ = t; }\
	NAME##_value_list<mysqlpp::quote_type0> value_list() const {\
		return value_list(",", mysqlpp::quote);}\
	NAME##_value_list<mysqlpp::quote_type0> value_list(const char* d) const {\
		return value_list(d, mysqlpp::quote);}\
	template <class Manip>\
	NAME##_value_list<Manip> value_list(const char* d, Manip m) const;\
	NAME##_field_list<mysqlpp::do_nothing_type0> field_list() const {\
		return field_list(",", mysqlpp::do_nothing);}\
	NAME##_field_list<mysqlpp::do_nothing_type0> field_list(const char* d) const {\
		return field_list(d, mysqlpp::do_nothing);}\
	template <class Manip>\
	NAME##_field_list<Manip> field_list(const char* d, Manip m) const;\
	NAME##_equal_list<mysqlpp::quote_type0> equal_list(const char* d = ",",\
			const char* c = " = ") const\
			{ return equal_list(d, c, mysqlpp::quote); }\
	template <class Manip>\
	NAME##_equal_list<Manip> equal_list(const char* d, const char* c, Manip m) const;\
	/* cus_data */\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false) const\
			{ return value_list(",", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL) const\
			{ return value_list(",", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(std::vector<bool> *i) const\
			{ return value_list(",", mysqlpp::quote, i); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(mysqlpp::sql_cmp_type sc) const\
			{ return value_list(",", mysqlpp::quote, sc); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(const char* d, bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false) const\
			{ return value_list(d, mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(const char* d, NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL) const\
			{ return value_list(d, mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(const char* d,\
			std::vector<bool> *i) const\
			{ return value_list(d, mysqlpp::quote, i); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(const char* d,\
			mysqlpp::sql_cmp_type sc) const\
			{ return value_list(d, mysqlpp::quote, sc); }\
	template <class Manip>\
	NAME##_cus_value_list<Manip> value_list(const char* d, Manip m,\
			bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false) const;\
	template <class Manip>\
	NAME##_cus_value_list<Manip> value_list(const char* d, Manip m,\
			NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL) const;\
	template <class Manip>\
	NAME##_cus_value_list<Manip> value_list(const char* d, Manip m,\
			std::vector<bool>* i) const;\
	template <class Manip>\
	NAME##_cus_value_list<Manip> value_list(const char* d, Manip m, \
			mysqlpp::sql_cmp_type sc) const;\
	/* cus field */\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false) const \
			{ return field_list(",", mysqlpp::do_nothing, i1, i2, i3, i4, i5, i6, i7); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL) const\
			{ return field_list(",", mysqlpp::do_nothing, i1, i2, i3, i4, i5, i6, i7); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(std::vector<bool> *i) const\
			{ return field_list(",", mysqlpp::do_nothing, i); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(mysqlpp::sql_cmp_type sc) const\
			{ return field_list(",", mysqlpp::do_nothing, sc); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(const char* d,\
			bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false) const\
			{ return field_list(d, mysqlpp::do_nothing, i1, i2, i3, i4, i5, i6, i7); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(const char* d,\
			NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL) const\
			{ return field_list(d, mysqlpp::do_nothing, i1, i2, i3, i4, i5, i6, i7); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(const char* d,\
			std::vector<bool>* i) const\
			{ return field_list(d, mysqlpp::do_nothing, i); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(const char* d,\
			mysqlpp::sql_cmp_type sc) const\
			{ return field_list(d, mysqlpp::do_nothing, sc); }\
	template <class Manip>\
	NAME##_cus_field_list<Manip> field_list(const char* d, Manip m,\
			bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false) const;\
	template <class Manip>\
	NAME##_cus_field_list<Manip> field_list(const char* d, Manip m,\
			NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL) const;\
	template <class Manip>\
	NAME##_cus_field_list<Manip> field_list(const char* d, Manip m,\
			std::vector<bool> *i) const;\
	template <class Manip>\
	NAME##_cus_field_list<Manip> field_list(const char* d, Manip m,\
			mysqlpp::sql_cmp_type sc) const;\
	/* cus equal */\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false) const\
			{ return equal_list(",", " = ", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL) const\
			{ return equal_list(",", " = ", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(std::vector<bool>* i) const\
			{ return equal_list(",", " = ", mysqlpp::quote, i); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(mysqlpp::sql_cmp_type sc) const\
			{ return equal_list(",", " = ", mysqlpp::quote, sc); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false) const\
			{ return equal_list(d, " = ", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL) const\
			{ return equal_list(d, " = ", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d,\
			std::vector<bool> *i) const\
			{ return equal_list(d, " = ", mysqlpp::quote, i); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d,\
			mysqlpp::sql_cmp_type sc) const\
			{ return equal_list(d, " = ", mysqlpp::quote, sc); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, const char* c,\
			bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false) const\
			{ return equal_list(d, c, mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, const char* c,\
			NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL) const\
			{ return equal_list(d, c, mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, const char* c,\
			std::vector<bool> *i) const\
			{ return equal_list(d, c, mysqlpp::quote, i); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, const char* c,\
			mysqlpp::sql_cmp_type sc) const\
			{ return equal_list(d, c, mysqlpp::quote, sc); }\
	template <class Manip>\
	NAME##_cus_equal_list<Manip> equal_list(const char* d, const char* c, Manip m, \
						bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false) const;\
	template <class Manip>\
	NAME##_cus_equal_list<Manip> equal_list(const char* d, const char* c, Manip m, \
						NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL) const;\
	template <class Manip>\
	NAME##_cus_equal_list<Manip> equal_list(const char* d, const char* c, Manip m, \
						std::vector<bool> *i) const;\
	template <class Manip>\
	NAME##_cus_equal_list<Manip> equal_list(const char* d, const char* c, Manip m, \
						mysqlpp::sql_cmp_type sc) const;\
	private:\
	static const char* table_;\
	const char* table_override_;\
	};\
	MYSQLPP_SSQLS_CONDITIONAL_STATICS(\
		const char* NAME::names[] = {\
			    N1 ,\
    N2 ,\
    N3 ,\
    N4 ,\
    N5 ,\
    N6 ,\
    N7 \
		};\
		const char* NAME::table_ = #NAME;\
	)\
	template <class Manip>\
	NAME##_cus_value_list<Manip>::NAME##_cus_value_list\
			(const NAME* o, const char* d, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7)\
	{\
		delim = d;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(7, false);\
    if (i1) (*include)[0]=true;\
    if (i2) (*include)[1]=true;\
    if (i3) (*include)[2]=true;\
    if (i4) (*include)[3]=true;\
    if (i5) (*include)[4]=true;\
    if (i6) (*include)[5]=true;\
    if (i7) (*include)[6]=true;\
	}\
	template <class Manip>\
	NAME##_cus_value_list<Manip>::NAME##_cus_value_list\
			(const NAME* o, const char* d, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7)\
	{\
		delim = d;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(7, false);\
    if (i1 == NAME##_NULL) return;\
    (*include)[i1]=true;\
    if (i2 == NAME##_NULL) return;\
    (*include)[i2]=true;\
    if (i3 == NAME##_NULL) return;\
    (*include)[i3]=true;\
    if (i4 == NAME##_NULL) return;\
    (*include)[i4]=true;\
    if (i5 == NAME##_NULL) return;\
    (*include)[i5]=true;\
    if (i6 == NAME##_NULL) return;\
    (*include)[i6]=true;\
    if (i7 == NAME##_NULL) return;\
    (*include)[i7]=true;\
	}\
	template <class Manip>\
	NAME##_cus_field_list<Manip>::NAME##_cus_field_list\
			(const NAME* o, const char* d, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7)\
	{\
		delim = d;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(7, false);\
    if (i1) (*include)[0]=true;\
    if (i2) (*include)[1]=true;\
    if (i3) (*include)[2]=true;\
    if (i4) (*include)[3]=true;\
    if (i5) (*include)[4]=true;\
    if (i6) (*include)[5]=true;\
    if (i7) (*include)[6]=true;\
	}\
	template <class Manip>\
	NAME##_cus_field_list<Manip>::NAME##_cus_field_list\
			(const NAME* o, const char* d, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7)\
	{\
		delim = d;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(7, false);\
    if (i1 == NAME##_NULL) return;\
    (*include)[i1]=true;\
    if (i2 == NAME##_NULL) return;\
    (*include)[i2]=true;\
    if (i3 == NAME##_NULL) return;\
    (*include)[i3]=true;\
    if (i4 == NAME##_NULL) return;\
    (*include)[i4]=true;\
    if (i5 == NAME##_NULL) return;\
    (*include)[i5]=true;\
    if (i6 == NAME##_NULL) return;\
    (*include)[i6]=true;\
    if (i7 == NAME##_NULL) return;\
    (*include)[i7]=true;\
	}\
	template <class Manip>\
	NAME##_cus_equal_list<Manip>::NAME##_cus_equal_list\
			(const NAME* o, const char* d, const char* c, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7)\
	{\
		delim = d;\
		comp = c;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(7, false);\
    if (i1) (*include)[0]=true;\
    if (i2) (*include)[1]=true;\
    if (i3) (*include)[2]=true;\
    if (i4) (*include)[3]=true;\
    if (i5) (*include)[4]=true;\
    if (i6) (*include)[5]=true;\
    if (i7) (*include)[6]=true;\
	}\
	template <class Manip>\
	NAME##_cus_equal_list<Manip>::NAME##_cus_equal_list\
			(const NAME* o, const char* d, const char* c, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7)\
	{\
		delim = d;\
		comp = c;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(7, false);\
    if (i1 == NAME##_NULL) return;\
    (*include)[i1]=true;\
    if (i2 == NAME##_NULL) return;\
    (*include)[i2]=true;\
    if (i3 == NAME##_NULL) return;\
    (*include)[i3]=true;\
    if (i4 == NAME##_NULL) return;\
    (*include)[i4]=true;\
    if (i5 == NAME##_NULL) return;\
    (*include)[i5]=true;\
    if (i6 == NAME##_NULL) return;\
    (*include)[i6]=true;\
    if (i7 == NAME##_NULL) return;\
    (*include)[i7]=true;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_value_list<Manip>& obj)\
	{\
    s << obj.manip << obj.obj->I1 << obj.delim;\
    s << obj.manip << obj.obj->I2 << obj.delim;\
    s << obj.manip << obj.obj->I3 << obj.delim;\
    s << obj.manip << obj.obj->I4 << obj.delim;\
    s << obj.manip << obj.obj->I5 << obj.delim;\
    s << obj.manip << obj.obj->I6 << obj.delim;\
    s << obj.manip << obj.obj->I7;\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_field_list<Manip>& obj)\
	{\
    s << obj.manip << '`' << obj.obj->names[0] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[1] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[2] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[3] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[4] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[5] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[6] << '`';\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_equal_list<Manip>& obj)\
	{\
    s << '`' << obj.obj->names[0] << '`' << obj.comp << obj.manip << obj.obj->I1 << obj.delim;\
    s << '`' << obj.obj->names[1] << '`' << obj.comp << obj.manip << obj.obj->I2 << obj.delim;\
    s << '`' << obj.obj->names[2] << '`' << obj.comp << obj.manip << obj.obj->I3 << obj.delim;\
    s << '`' << obj.obj->names[3] << '`' << obj.comp << obj.manip << obj.obj->I4 << obj.delim;\
    s << '`' << obj.obj->names[4] << '`' << obj.comp << obj.manip << obj.obj->I5 << obj.delim;\
    s << '`' << obj.obj->names[5] << '`' << obj.comp << obj.manip << obj.obj->I6 << obj.delim;\
    s << '`' << obj.obj->names[6] << '`' << obj.comp << obj.manip << obj.obj->I7;\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_cus_value_list<Manip>& obj)\
	{\
		bool before = false;\
    if ((*obj.include)[0]) { \
      s << obj.manip << obj.obj->I1;\
      before = true; \
     } \
    if ((*obj.include)[1]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I2;\
      before = true; \
     } \
    if ((*obj.include)[2]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I3;\
      before = true; \
     } \
    if ((*obj.include)[3]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I4;\
      before = true; \
     } \
    if ((*obj.include)[4]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I5;\
      before = true; \
     } \
    if ((*obj.include)[5]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I6;\
      before = true; \
     } \
    if ((*obj.include)[6]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I7;\
     } \
        (void)before;\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_cus_field_list<Manip>& obj)\
	{\
		bool before = false;\
    if ((*obj.include)[0]) { \
      s << obj.manip << '`' << obj.obj->names[0] << '`';\
      before = true; \
     } \
    if ((*obj.include)[1]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[1] << '`';\
      before = true; \
     } \
    if ((*obj.include)[2]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[2] << '`';\
      before = true; \
     } \
    if ((*obj.include)[3]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[3] << '`';\
      before = true; \
     } \
    if ((*obj.include)[4]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[4] << '`';\
      before = true; \
     } \
    if ((*obj.include)[5]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[5] << '`';\
      before = true; \
     } \
    if ((*obj.include)[6]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[6] << '`';\
     } \
        (void)before;\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_cus_equal_list<Manip>& obj)\
	{\
		bool before = false;\
    if ((*obj.include)[0]) { \
      s << '`' << obj.obj->names[0] << '`' << obj.comp << obj.manip << obj.obj->I1;\
      before = true; \
     } \
    if ((*obj.include)[1]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[1] << '`' << obj.comp << obj.manip << obj.obj->I2;\
      before = true; \
     } \
    if ((*obj.include)[2]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[2] << '`' << obj.comp << obj.manip << obj.obj->I3;\
      before = true; \
     } \
    if ((*obj.include)[3]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[3] << '`' << obj.comp << obj.manip << obj.obj->I4;\
      before = true; \
     } \
    if ((*obj.include)[4]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[4] << '`' << obj.comp << obj.manip << obj.obj->I5;\
      before = true; \
     } \
    if ((*obj.include)[5]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[5] << '`' << obj.comp << obj.manip << obj.obj->I6;\
      before = true; \
     } \
    if ((*obj.include)[6]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[6] << '`' << obj.comp << obj.manip << obj.obj->I7;\
     } \
        (void)before;\
		return s;\
	}\
	template <class Manip>\
	inline NAME##_value_list<Manip> NAME::value_list(const char* d, Manip m) const\
			{ return NAME##_value_list<Manip> (this, d, m); } \
	template <class Manip>\
	inline NAME##_field_list<Manip> NAME::field_list(const char* d, Manip m) const\
			{ return NAME##_field_list<Manip> (this, d, m); } \
	template <class Manip>\
	inline NAME##_equal_list<Manip> NAME::equal_list(const char* d, const char* c, Manip m) const\
			{ return NAME##_equal_list<Manip> (this, d, c, m); } \
	template <class Manip>\
	inline NAME##_cus_value_list<Manip> NAME::value_list(const char* d, Manip m,\
			bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7) const\
			{ return NAME##_cus_value_list<Manip> (this, d, m, i1, i2, i3, i4, i5, i6, i7); }\
	template <class Manip>\
	inline NAME##_cus_field_list<Manip> NAME::field_list(const char* d, Manip m,\
			bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7) const\
			{ return NAME##_cus_field_list<Manip> (this, d, m, i1, i2, i3, i4, i5, i6, i7); }\
	template <class Manip>\
	inline NAME##_cus_equal_list<Manip> NAME::equal_list(const char* d, const char* c, Manip m,\
			bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7) const\
			{ return NAME##_cus_equal_list<Manip> (this, d, c, m, i1, i2, i3, i4, i5, i6, i7); } \
	template <class Manip>\
	inline NAME##_cus_value_list<Manip> NAME::value_list(const char* d, Manip m,\
			NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7) const\
			{ return NAME##_cus_value_list<Manip> (this, d, m, i1, i2, i3, i4, i5, i6, i7); } \
	template <class Manip>\
	inline NAME##_cus_field_list<Manip> NAME::field_list(const char* d, Manip m,\
			NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7) const\
			{ return NAME##_cus_field_list<Manip> (this, d, m, i1, i2, i3, i4, i5, i6, i7); } \
	template <class Manip>\
	inline NAME##_cus_equal_list<Manip> NAME::equal_list(const char* d, const char* c, Manip m, \
			NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7) const\
			{ return NAME##_cus_equal_list<Manip> (this, d, c, m, i1, i2, i3, i4, i5, i6, i7); } \
	template <class Manip>\
	inline NAME##_cus_value_list<Manip> NAME::value_list(const char* d, Manip m,\
			std::vector<bool> *i) const\
			{ return NAME##_cus_value_list<Manip> (this, d, m, i); }\
	template <class Manip>\
	inline NAME##_cus_field_list<Manip> NAME::field_list(const char* d, Manip m,\
			std::vector<bool> *i) const\
			{ return NAME##_cus_field_list<Manip> (this, d, m, i); }\
	template <class Manip>\
	inline NAME##_cus_equal_list<Manip> NAME::equal_list(const char* d, const char* c, Manip m,\
			std::vector<bool> *i) const\
			{ return NAME##_cus_equal_list<Manip> (this, d, c, m, i); }\
	template <class Manip>\
	inline NAME##_cus_value_list<Manip> \
	NAME::value_list(const char* d, Manip m, mysqlpp::sql_cmp_type /*sc*/) const\
			{ sql_compare_type_def_##CMP(NAME, value, NUM); }\
	template <class Manip>\
	inline NAME##_cus_field_list<Manip> \
	NAME::field_list(const char* d, Manip m, mysqlpp::sql_cmp_type /*sc*/) const\
			{ sql_compare_type_def_##CMP(NAME, field, NUM); }\
	template <class Manip>\
	inline NAME##_cus_equal_list<Manip> \
	NAME::equal_list(const char* d, const char* c, Manip m, mysqlpp::sql_cmp_type /*sc*/) const\
			{ sql_compare_type_defe_##CMP(NAME, equal, NUM); }\
	template <mysqlpp::sql_dummy_type dummy>\
	void populate_##NAME(NAME *s, const mysqlpp::Row &row)\
	{\
		mysqlpp::NoExceptions ignore_schema_mismatches(row);\
    s->I1 = row[N1].conv(T1());\
    s->I2 = row[N2].conv(T2());\
    s->I3 = row[N3].conv(T3());\
    s->I4 = row[N4].conv(T4());\
    s->I5 = row[N5].conv(T5());\
    s->I6 = row[N6].conv(T6());\
    s->I7 = row[N7].conv(T7());\
	}\
	inline NAME::NAME(const mysqlpp::Row& row) :\
	table_override_(0)\
			{ populate_##NAME<mysqlpp::sql_dummy>(this, row); }\
	inline void NAME::set(const mysqlpp::Row& row)\
	{\
		table_override_ = 0;\
		populate_##NAME<mysqlpp::sql_dummy>(this, row);\
	}\
	sql_COMPARE__##CMP(NAME, I1, I2, I3, I4, I5, I6, I7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 )

#define sql_create_7(NAME, CMP, CONTR, T1, I1, T2, I2, T3, I3, T4, I4, T5, I5, T6, I6, T7, I7) \
		sql_create_complete_7(NAME, CMP, CONTR, T1, I1, #I1, T2, I2, #I2, T3, I3, #I3, T4, I4, #I4, T5, I5, #I5, T6, I6, #I6, T7, I7, #I7) \

// ---------------------------------------------------
//                  End Create 7
// ---------------------------------------------------

// ---------------------------------------------------
//                  Begin Create 8
// ---------------------------------------------------
#define sql_create_complete_8(NAME, CMP, CONTR, T1, I1, N1, T2, I2, N2, T3, I3, N3, T4, I4, N4, T5, I5, N5, T6, I6, N6, T7, I7, N7, T8, I8, N8) \
	struct NAME; \
	enum NAME##_enum { \
    NAME##_##I1,\
    NAME##_##I2,\
    NAME##_##I3,\
    NAME##_##I4,\
    NAME##_##I5,\
    NAME##_##I6,\
    NAME##_##I7,\
    NAME##_##I8 \
	,NAME##_NULL \
	}; \
	template <class Manip>\
	class NAME##_value_list { \
	public: \
	const NAME* obj;\
	const char* delim;\
	Manip manip;\
	public: \
	NAME##_value_list (const NAME* o, const char* d, Manip m) :\
	obj(o), delim(d), manip(m) { } \
	};\
	template <class Manip>\
	class NAME##_##field_list {\
	public: \
	const NAME* obj; \
	const char* delim;\
	Manip manip;\
	public: \
	NAME##_field_list (const NAME* o, const char* d, Manip m) :\
	obj(o), delim(d), manip(m) { } \
	};\
	template <class Manip>\
	class NAME##_equal_list { \
	public: \
	const NAME* obj;\
	const char* delim;\
	const char* comp;\
	Manip manip;\
	public: \
	NAME##_equal_list (const NAME* o, const char* d, const char* c, Manip m) :\
	obj(o), delim(d), comp(c), manip(m) { }\
	};\
	template <class Manip>\
	class NAME##_cus_value_list {\
	public:\
	const NAME* obj;\
	std::vector<bool> *include;\
	bool del_vector;\
	const char* delim;\
	Manip manip;\
	public: \
	~NAME##_cus_value_list () {if (del_vector) delete include;} \
	NAME##_cus_value_list (const NAME* o, const char* d, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8);\
	NAME##_cus_value_list (const NAME* o, const char* d, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8); \
	NAME##_cus_value_list (const NAME* o, const char* d, Manip m ,std::vector<bool>* i) :\
	obj(o), include(i), del_vector(false), delim(d), manip(m) { }\
	};\
	template <class Manip>\
	class NAME##_cus_field_list { \
	public:\
	const NAME* obj; \
	std::vector<bool> *include; \
	bool del_vector; \
	const char* delim;\
	Manip manip;\
	public: \
	~NAME##_cus_field_list () {if (del_vector) delete include;} \
	NAME##_cus_field_list (const NAME* o, const char* d, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8); \
	NAME##_cus_field_list (const NAME* o, const char* d, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8); \
	NAME##_cus_field_list (const NAME* o, const char* d, Manip m, std::vector<bool> *i) :\
	obj(o), include(i), del_vector(false), delim(d), manip(m) { }\
	};\
	template <class Manip>\
	class NAME##_cus_equal_list {\
	public:\
	const NAME* obj;\
	std::vector<bool> *include;\
	bool del_vector;\
	const char* delim;\
	const char* comp;\
	Manip manip;\
	public:\
	~NAME##_##cus_equal_list () {if (del_vector) delete include;}\
	NAME##_##cus_equal_list (const NAME* o, const char* d, const char* c, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8); \
	NAME##_##cus_equal_list (const NAME* o, const char* d, const char* c, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8); \
	NAME##_##cus_equal_list (const NAME* o, const char* d, const char* c, Manip m, std::vector<bool> *i) :\
	obj(o), include(i), del_vector(false), delim(d), comp(c), manip(m) { }\
	};\
	template <mysqlpp::sql_dummy_type dummy> int sql_compare_##NAME(const NAME&, const NAME&);\
	struct NAME {\
    T1 I1;\
    T2 I2;\
    T3 I3;\
    T4 I4;\
    T5 I5;\
    T6 I6;\
    T7 I7;\
    T8 I8; \
	NAME() : table_override_(0) { }\
	NAME(const mysqlpp::Row& row);\
	void set(const mysqlpp::Row &row);\
	sql_compare_define_##CMP(NAME, T1, I1, T2, I2, T3, I3, T4, I4, T5, I5, T6, I6, T7, I7, T8, I8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)\
	sql_construct_define_##CONTR(NAME, T1, I1, T2, I2, T3, I3, T4, I4, T5, I5, T6, I6, T7, I7, T8, I8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)\
	static const char* names[];\
	static void table(const char* t) { table_ = t; }\
	const char* table() const\
			{ return table_override_ ? table_override_ : NAME::table_; }\
	void instance_table(const char* t) { table_override_ = t; }\
	NAME##_value_list<mysqlpp::quote_type0> value_list() const {\
		return value_list(",", mysqlpp::quote);}\
	NAME##_value_list<mysqlpp::quote_type0> value_list(const char* d) const {\
		return value_list(d, mysqlpp::quote);}\
	template <class Manip>\
	NAME##_value_list<Manip> value_list(const char* d, Manip m) const;\
	NAME##_field_list<mysqlpp::do_nothing_type0> field_list() const {\
		return field_list(",", mysqlpp::do_nothing);}\
	NAME##_field_list<mysqlpp::do_nothing_type0> field_list(const char* d) const {\
		return field_list(d, mysqlpp::do_nothing);}\
	template <class Manip>\
	NAME##_field_list<Manip> field_list(const char* d, Manip m) const;\
	NAME##_equal_list<mysqlpp::quote_type0> equal_list(const char* d = ",",\
			const char* c = " = ") const\
			{ return equal_list(d, c, mysqlpp::quote); }\
	template <class Manip>\
	NAME##_equal_list<Manip> equal_list(const char* d, const char* c, Manip m) const;\
	/* cus_data */\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false) const\
			{ return value_list(",", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL) const\
			{ return value_list(",", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(std::vector<bool> *i) const\
			{ return value_list(",", mysqlpp::quote, i); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(mysqlpp::sql_cmp_type sc) const\
			{ return value_list(",", mysqlpp::quote, sc); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(const char* d, bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false) const\
			{ return value_list(d, mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(const char* d, NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL) const\
			{ return value_list(d, mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(const char* d,\
			std::vector<bool> *i) const\
			{ return value_list(d, mysqlpp::quote, i); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(const char* d,\
			mysqlpp::sql_cmp_type sc) const\
			{ return value_list(d, mysqlpp::quote, sc); }\
	template <class Manip>\
	NAME##_cus_value_list<Manip> value_list(const char* d, Manip m,\
			bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false) const;\
	template <class Manip>\
	NAME##_cus_value_list<Manip> value_list(const char* d, Manip m,\
			NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL) const;\
	template <class Manip>\
	NAME##_cus_value_list<Manip> value_list(const char* d, Manip m,\
			std::vector<bool>* i) const;\
	template <class Manip>\
	NAME##_cus_value_list<Manip> value_list(const char* d, Manip m, \
			mysqlpp::sql_cmp_type sc) const;\
	/* cus field */\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false) const \
			{ return field_list(",", mysqlpp::do_nothing, i1, i2, i3, i4, i5, i6, i7, i8); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL) const\
			{ return field_list(",", mysqlpp::do_nothing, i1, i2, i3, i4, i5, i6, i7, i8); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(std::vector<bool> *i) const\
			{ return field_list(",", mysqlpp::do_nothing, i); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(mysqlpp::sql_cmp_type sc) const\
			{ return field_list(",", mysqlpp::do_nothing, sc); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(const char* d,\
			bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false) const\
			{ return field_list(d, mysqlpp::do_nothing, i1, i2, i3, i4, i5, i6, i7, i8); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(const char* d,\
			NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL) const\
			{ return field_list(d, mysqlpp::do_nothing, i1, i2, i3, i4, i5, i6, i7, i8); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(const char* d,\
			std::vector<bool>* i) const\
			{ return field_list(d, mysqlpp::do_nothing, i); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(const char* d,\
			mysqlpp::sql_cmp_type sc) const\
			{ return field_list(d, mysqlpp::do_nothing, sc); }\
	template <class Manip>\
	NAME##_cus_field_list<Manip> field_list(const char* d, Manip m,\
			bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false) const;\
	template <class Manip>\
	NAME##_cus_field_list<Manip> field_list(const char* d, Manip m,\
			NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL) const;\
	template <class Manip>\
	NAME##_cus_field_list<Manip> field_list(const char* d, Manip m,\
			std::vector<bool> *i) const;\
	template <class Manip>\
	NAME##_cus_field_list<Manip> field_list(const char* d, Manip m,\
			mysqlpp::sql_cmp_type sc) const;\
	/* cus equal */\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false) const\
			{ return equal_list(",", " = ", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL) const\
			{ return equal_list(",", " = ", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(std::vector<bool>* i) const\
			{ return equal_list(",", " = ", mysqlpp::quote, i); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(mysqlpp::sql_cmp_type sc) const\
			{ return equal_list(",", " = ", mysqlpp::quote, sc); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false) const\
			{ return equal_list(d, " = ", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL) const\
			{ return equal_list(d, " = ", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d,\
			std::vector<bool> *i) const\
			{ return equal_list(d, " = ", mysqlpp::quote, i); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d,\
			mysqlpp::sql_cmp_type sc) const\
			{ return equal_list(d, " = ", mysqlpp::quote, sc); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, const char* c,\
			bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false) const\
			{ return equal_list(d, c, mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, const char* c,\
			NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL) const\
			{ return equal_list(d, c, mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, const char* c,\
			std::vector<bool> *i) const\
			{ return equal_list(d, c, mysqlpp::quote, i); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, const char* c,\
			mysqlpp::sql_cmp_type sc) const\
			{ return equal_list(d, c, mysqlpp::quote, sc); }\
	template <class Manip>\
	NAME##_cus_equal_list<Manip> equal_list(const char* d, const char* c, Manip m, \
						bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false) const;\
	template <class Manip>\
	NAME##_cus_equal_list<Manip> equal_list(const char* d, const char* c, Manip m, \
						NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL) const;\
	template <class Manip>\
	NAME##_cus_equal_list<Manip> equal_list(const char* d, const char* c, Manip m, \
						std::vector<bool> *i) const;\
	template <class Manip>\
	NAME##_cus_equal_list<Manip> equal_list(const char* d, const char* c, Manip m, \
						mysqlpp::sql_cmp_type sc) const;\
	private:\
	static const char* table_;\
	const char* table_override_;\
	};\
	MYSQLPP_SSQLS_CONDITIONAL_STATICS(\
		const char* NAME::names[] = {\
			    N1 ,\
    N2 ,\
    N3 ,\
    N4 ,\
    N5 ,\
    N6 ,\
    N7 ,\
    N8 \
		};\
		const char* NAME::table_ = #NAME;\
	)\
	template <class Manip>\
	NAME##_cus_value_list<Manip>::NAME##_cus_value_list\
			(const NAME* o, const char* d, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8)\
	{\
		delim = d;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(8, false);\
    if (i1) (*include)[0]=true;\
    if (i2) (*include)[1]=true;\
    if (i3) (*include)[2]=true;\
    if (i4) (*include)[3]=true;\
    if (i5) (*include)[4]=true;\
    if (i6) (*include)[5]=true;\
    if (i7) (*include)[6]=true;\
    if (i8) (*include)[7]=true;\
	}\
	template <class Manip>\
	NAME##_cus_value_list<Manip>::NAME##_cus_value_list\
			(const NAME* o, const char* d, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8)\
	{\
		delim = d;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(8, false);\
    if (i1 == NAME##_NULL) return;\
    (*include)[i1]=true;\
    if (i2 == NAME##_NULL) return;\
    (*include)[i2]=true;\
    if (i3 == NAME##_NULL) return;\
    (*include)[i3]=true;\
    if (i4 == NAME##_NULL) return;\
    (*include)[i4]=true;\
    if (i5 == NAME##_NULL) return;\
    (*include)[i5]=true;\
    if (i6 == NAME##_NULL) return;\
    (*include)[i6]=true;\
    if (i7 == NAME##_NULL) return;\
    (*include)[i7]=true;\
    if (i8 == NAME##_NULL) return;\
    (*include)[i8]=true;\
	}\
	template <class Manip>\
	NAME##_cus_field_list<Manip>::NAME##_cus_field_list\
			(const NAME* o, const char* d, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8)\
	{\
		delim = d;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(8, false);\
    if (i1) (*include)[0]=true;\
    if (i2) (*include)[1]=true;\
    if (i3) (*include)[2]=true;\
    if (i4) (*include)[3]=true;\
    if (i5) (*include)[4]=true;\
    if (i6) (*include)[5]=true;\
    if (i7) (*include)[6]=true;\
    if (i8) (*include)[7]=true;\
	}\
	template <class Manip>\
	NAME##_cus_field_list<Manip>::NAME##_cus_field_list\
			(const NAME* o, const char* d, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8)\
	{\
		delim = d;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(8, false);\
    if (i1 == NAME##_NULL) return;\
    (*include)[i1]=true;\
    if (i2 == NAME##_NULL) return;\
    (*include)[i2]=true;\
    if (i3 == NAME##_NULL) return;\
    (*include)[i3]=true;\
    if (i4 == NAME##_NULL) return;\
    (*include)[i4]=true;\
    if (i5 == NAME##_NULL) return;\
    (*include)[i5]=true;\
    if (i6 == NAME##_NULL) return;\
    (*include)[i6]=true;\
    if (i7 == NAME##_NULL) return;\
    (*include)[i7]=true;\
    if (i8 == NAME##_NULL) return;\
    (*include)[i8]=true;\
	}\
	template <class Manip>\
	NAME##_cus_equal_list<Manip>::NAME##_cus_equal_list\
			(const NAME* o, const char* d, const char* c, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8)\
	{\
		delim = d;\
		comp = c;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(8, false);\
    if (i1) (*include)[0]=true;\
    if (i2) (*include)[1]=true;\
    if (i3) (*include)[2]=true;\
    if (i4) (*include)[3]=true;\
    if (i5) (*include)[4]=true;\
    if (i6) (*include)[5]=true;\
    if (i7) (*include)[6]=true;\
    if (i8) (*include)[7]=true;\
	}\
	template <class Manip>\
	NAME##_cus_equal_list<Manip>::NAME##_cus_equal_list\
			(const NAME* o, const char* d, const char* c, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8)\
	{\
		delim = d;\
		comp = c;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(8, false);\
    if (i1 == NAME##_NULL) return;\
    (*include)[i1]=true;\
    if (i2 == NAME##_NULL) return;\
    (*include)[i2]=true;\
    if (i3 == NAME##_NULL) return;\
    (*include)[i3]=true;\
    if (i4 == NAME##_NULL) return;\
    (*include)[i4]=true;\
    if (i5 == NAME##_NULL) return;\
    (*include)[i5]=true;\
    if (i6 == NAME##_NULL) return;\
    (*include)[i6]=true;\
    if (i7 == NAME##_NULL) return;\
    (*include)[i7]=true;\
    if (i8 == NAME##_NULL) return;\
    (*include)[i8]=true;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_value_list<Manip>& obj)\
	{\
    s << obj.manip << obj.obj->I1 << obj.delim;\
    s << obj.manip << obj.obj->I2 << obj.delim;\
    s << obj.manip << obj.obj->I3 << obj.delim;\
    s << obj.manip << obj.obj->I4 << obj.delim;\
    s << obj.manip << obj.obj->I5 << obj.delim;\
    s << obj.manip << obj.obj->I6 << obj.delim;\
    s << obj.manip << obj.obj->I7 << obj.delim;\
    s << obj.manip << obj.obj->I8;\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_field_list<Manip>& obj)\
	{\
    s << obj.manip << '`' << obj.obj->names[0] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[1] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[2] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[3] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[4] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[5] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[6] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[7] << '`';\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_equal_list<Manip>& obj)\
	{\
    s << '`' << obj.obj->names[0] << '`' << obj.comp << obj.manip << obj.obj->I1 << obj.delim;\
    s << '`' << obj.obj->names[1] << '`' << obj.comp << obj.manip << obj.obj->I2 << obj.delim;\
    s << '`' << obj.obj->names[2] << '`' << obj.comp << obj.manip << obj.obj->I3 << obj.delim;\
    s << '`' << obj.obj->names[3] << '`' << obj.comp << obj.manip << obj.obj->I4 << obj.delim;\
    s << '`' << obj.obj->names[4] << '`' << obj.comp << obj.manip << obj.obj->I5 << obj.delim;\
    s << '`' << obj.obj->names[5] << '`' << obj.comp << obj.manip << obj.obj->I6 << obj.delim;\
    s << '`' << obj.obj->names[6] << '`' << obj.comp << obj.manip << obj.obj->I7 << obj.delim;\
    s << '`' << obj.obj->names[7] << '`' << obj.comp << obj.manip << obj.obj->I8;\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_cus_value_list<Manip>& obj)\
	{\
		bool before = false;\
    if ((*obj.include)[0]) { \
      s << obj.manip << obj.obj->I1;\
      before = true; \
     } \
    if ((*obj.include)[1]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I2;\
      before = true; \
     } \
    if ((*obj.include)[2]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I3;\
      before = true; \
     } \
    if ((*obj.include)[3]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I4;\
      before = true; \
     } \
    if ((*obj.include)[4]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I5;\
      before = true; \
     } \
    if ((*obj.include)[5]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I6;\
      before = true; \
     } \
    if ((*obj.include)[6]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I7;\
      before = true; \
     } \
    if ((*obj.include)[7]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I8;\
     } \
        (void)before;\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_cus_field_list<Manip>& obj)\
	{\
		bool before = false;\
    if ((*obj.include)[0]) { \
      s << obj.manip << '`' << obj.obj->names[0] << '`';\
      before = true; \
     } \
    if ((*obj.include)[1]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[1] << '`';\
      before = true; \
     } \
    if ((*obj.include)[2]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[2] << '`';\
      before = true; \
     } \
    if ((*obj.include)[3]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[3] << '`';\
      before = true; \
     } \
    if ((*obj.include)[4]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[4] << '`';\
      before = true; \
     } \
    if ((*obj.include)[5]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[5] << '`';\
      before = true; \
     } \
    if ((*obj.include)[6]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[6] << '`';\
      before = true; \
     } \
    if ((*obj.include)[7]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[7] << '`';\
     } \
        (void)before;\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_cus_equal_list<Manip>& obj)\
	{\
		bool before = false;\
    if ((*obj.include)[0]) { \
      s << '`' << obj.obj->names[0] << '`' << obj.comp << obj.manip << obj.obj->I1;\
      before = true; \
     } \
    if ((*obj.include)[1]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[1] << '`' << obj.comp << obj.manip << obj.obj->I2;\
      before = true; \
     } \
    if ((*obj.include)[2]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[2] << '`' << obj.comp << obj.manip << obj.obj->I3;\
      before = true; \
     } \
    if ((*obj.include)[3]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[3] << '`' << obj.comp << obj.manip << obj.obj->I4;\
      before = true; \
     } \
    if ((*obj.include)[4]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[4] << '`' << obj.comp << obj.manip << obj.obj->I5;\
      before = true; \
     } \
    if ((*obj.include)[5]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[5] << '`' << obj.comp << obj.manip << obj.obj->I6;\
      before = true; \
     } \
    if ((*obj.include)[6]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[6] << '`' << obj.comp << obj.manip << obj.obj->I7;\
      before = true; \
     } \
    if ((*obj.include)[7]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[7] << '`' << obj.comp << obj.manip << obj.obj->I8;\
     } \
        (void)before;\
		return s;\
	}\
	template <class Manip>\
	inline NAME##_value_list<Manip> NAME::value_list(const char* d, Manip m) const\
			{ return NAME##_value_list<Manip> (this, d, m); } \
	template <class Manip>\
	inline NAME##_field_list<Manip> NAME::field_list(const char* d, Manip m) const\
			{ return NAME##_field_list<Manip> (this, d, m); } \
	template <class Manip>\
	inline NAME##_equal_list<Manip> NAME::equal_list(const char* d, const char* c, Manip m) const\
			{ return NAME##_equal_list<Manip> (this, d, c, m); } \
	template <class Manip>\
	inline NAME##_cus_value_list<Manip> NAME::value_list(const char* d, Manip m,\
			bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8) const\
			{ return NAME##_cus_value_list<Manip> (this, d, m, i1, i2, i3, i4, i5, i6, i7, i8); }\
	template <class Manip>\
	inline NAME##_cus_field_list<Manip> NAME::field_list(const char* d, Manip m,\
			bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8) const\
			{ return NAME##_cus_field_list<Manip> (this, d, m, i1, i2, i3, i4, i5, i6, i7, i8); }\
	template <class Manip>\
	inline NAME##_cus_equal_list<Manip> NAME::equal_list(const char* d, const char* c, Manip m,\
			bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8) const\
			{ return NAME##_cus_equal_list<Manip> (this, d, c, m, i1, i2, i3, i4, i5, i6, i7, i8); } \
	template <class Manip>\
	inline NAME##_cus_value_list<Manip> NAME::value_list(const char* d, Manip m,\
			NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8) const\
			{ return NAME##_cus_value_list<Manip> (this, d, m, i1, i2, i3, i4, i5, i6, i7, i8); } \
	template <class Manip>\
	inline NAME##_cus_field_list<Manip> NAME::field_list(const char* d, Manip m,\
			NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8) const\
			{ return NAME##_cus_field_list<Manip> (this, d, m, i1, i2, i3, i4, i5, i6, i7, i8); } \
	template <class Manip>\
	inline NAME##_cus_equal_list<Manip> NAME::equal_list(const char* d, const char* c, Manip m, \
			NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8) const\
			{ return NAME##_cus_equal_list<Manip> (this, d, c, m, i1, i2, i3, i4, i5, i6, i7, i8); } \
	template <class Manip>\
	inline NAME##_cus_value_list<Manip> NAME::value_list(const char* d, Manip m,\
			std::vector<bool> *i) const\
			{ return NAME##_cus_value_list<Manip> (this, d, m, i); }\
	template <class Manip>\
	inline NAME##_cus_field_list<Manip> NAME::field_list(const char* d, Manip m,\
			std::vector<bool> *i) const\
			{ return NAME##_cus_field_list<Manip> (this, d, m, i); }\
	template <class Manip>\
	inline NAME##_cus_equal_list<Manip> NAME::equal_list(const char* d, const char* c, Manip m,\
			std::vector<bool> *i) const\
			{ return NAME##_cus_equal_list<Manip> (this, d, c, m, i); }\
	template <class Manip>\
	inline NAME##_cus_value_list<Manip> \
	NAME::value_list(const char* d, Manip m, mysqlpp::sql_cmp_type /*sc*/) const\
			{ sql_compare_type_def_##CMP(NAME, value, NUM); }\
	template <class Manip>\
	inline NAME##_cus_field_list<Manip> \
	NAME::field_list(const char* d, Manip m, mysqlpp::sql_cmp_type /*sc*/) const\
			{ sql_compare_type_def_##CMP(NAME, field, NUM); }\
	template <class Manip>\
	inline NAME##_cus_equal_list<Manip> \
	NAME::equal_list(const char* d, const char* c, Manip m, mysqlpp::sql_cmp_type /*sc*/) const\
			{ sql_compare_type_defe_##CMP(NAME, equal, NUM); }\
	template <mysqlpp::sql_dummy_type dummy>\
	void populate_##NAME(NAME *s, const mysqlpp::Row &row)\
	{\
		mysqlpp::NoExceptions ignore_schema_mismatches(row);\
    s->I1 = row[N1].conv(T1());\
    s->I2 = row[N2].conv(T2());\
    s->I3 = row[N3].conv(T3());\
    s->I4 = row[N4].conv(T4());\
    s->I5 = row[N5].conv(T5());\
    s->I6 = row[N6].conv(T6());\
    s->I7 = row[N7].conv(T7());\
    s->I8 = row[N8].conv(T8());\
	}\
	inline NAME::NAME(const mysqlpp::Row& row) :\
	table_override_(0)\
			{ populate_##NAME<mysqlpp::sql_dummy>(this, row); }\
	inline void NAME::set(const mysqlpp::Row& row)\
	{\
		table_override_ = 0;\
		populate_##NAME<mysqlpp::sql_dummy>(this, row);\
	}\
	sql_COMPARE__##CMP(NAME, I1, I2, I3, I4, I5, I6, I7, I8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 )

#define sql_create_8(NAME, CMP, CONTR, T1, I1, T2, I2, T3, I3, T4, I4, T5, I5, T6, I6, T7, I7, T8, I8) \
		sql_create_complete_8(NAME, CMP, CONTR, T1, I1, #I1, T2, I2, #I2, T3, I3, #I3, T4, I4, #I4, T5, I5, #I5, T6, I6, #I6, T7, I7, #I7, T8, I8, #I8) \

// ---------------------------------------------------
//                  End Create 8
// ---------------------------------------------------

// ---------------------------------------------------
//                  Begin Create 9
// ---------------------------------------------------
#define sql_create_complete_9(NAME, CMP, CONTR, T1, I1, N1, T2, I2, N2, T3, I3, N3, T4, I4, N4, T5, I5, N5, T6, I6, N6, T7, I7, N7, T8, I8, N8, T9, I9, N9) \
	struct NAME; \
	enum NAME##_enum { \
    NAME##_##I1,\
    NAME##_##I2,\
    NAME##_##I3,\
    NAME##_##I4,\
    NAME##_##I5,\
    NAME##_##I6,\
    NAME##_##I7,\
    NAME##_##I8,\
    NAME##_##I9 \
	,NAME##_NULL \
	}; \
	template <class Manip>\
	class NAME##_value_list { \
	public: \
	const NAME* obj;\
	const char* delim;\
	Manip manip;\
	public: \
	NAME##_value_list (const NAME* o, const char* d, Manip m) :\
	obj(o), delim(d), manip(m) { } \
	};\
	template <class Manip>\
	class NAME##_##field_list {\
	public: \
	const NAME* obj; \
	const char* delim;\
	Manip manip;\
	public: \
	NAME##_field_list (const NAME* o, const char* d, Manip m) :\
	obj(o), delim(d), manip(m) { } \
	};\
	template <class Manip>\
	class NAME##_equal_list { \
	public: \
	const NAME* obj;\
	const char* delim;\
	const char* comp;\
	Manip manip;\
	public: \
	NAME##_equal_list (const NAME* o, const char* d, const char* c, Manip m) :\
	obj(o), delim(d), comp(c), manip(m) { }\
	};\
	template <class Manip>\
	class NAME##_cus_value_list {\
	public:\
	const NAME* obj;\
	std::vector<bool> *include;\
	bool del_vector;\
	const char* delim;\
	Manip manip;\
	public: \
	~NAME##_cus_value_list () {if (del_vector) delete include;} \
	NAME##_cus_value_list (const NAME* o, const char* d, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9);\
	NAME##_cus_value_list (const NAME* o, const char* d, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9); \
	NAME##_cus_value_list (const NAME* o, const char* d, Manip m ,std::vector<bool>* i) :\
	obj(o), include(i), del_vector(false), delim(d), manip(m) { }\
	};\
	template <class Manip>\
	class NAME##_cus_field_list { \
	public:\
	const NAME* obj; \
	std::vector<bool> *include; \
	bool del_vector; \
	const char* delim;\
	Manip manip;\
	public: \
	~NAME##_cus_field_list () {if (del_vector) delete include;} \
	NAME##_cus_field_list (const NAME* o, const char* d, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9); \
	NAME##_cus_field_list (const NAME* o, const char* d, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9); \
	NAME##_cus_field_list (const NAME* o, const char* d, Manip m, std::vector<bool> *i) :\
	obj(o), include(i), del_vector(false), delim(d), manip(m) { }\
	};\
	template <class Manip>\
	class NAME##_cus_equal_list {\
	public:\
	const NAME* obj;\
	std::vector<bool> *include;\
	bool del_vector;\
	const char* delim;\
	const char* comp;\
	Manip manip;\
	public:\
	~NAME##_##cus_equal_list () {if (del_vector) delete include;}\
	NAME##_##cus_equal_list (const NAME* o, const char* d, const char* c, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9); \
	NAME##_##cus_equal_list (const NAME* o, const char* d, const char* c, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9); \
	NAME##_##cus_equal_list (const NAME* o, const char* d, const char* c, Manip m, std::vector<bool> *i) :\
	obj(o), include(i), del_vector(false), delim(d), comp(c), manip(m) { }\
	};\
	template <mysqlpp::sql_dummy_type dummy> int sql_compare_##NAME(const NAME&, const NAME&);\
	struct NAME {\
    T1 I1;\
    T2 I2;\
    T3 I3;\
    T4 I4;\
    T5 I5;\
    T6 I6;\
    T7 I7;\
    T8 I8;\
    T9 I9; \
	NAME() : table_override_(0) { }\
	NAME(const mysqlpp::Row& row);\
	void set(const mysqlpp::Row &row);\
	sql_compare_define_##CMP(NAME, T1, I1, T2, I2, T3, I3, T4, I4, T5, I5, T6, I6, T7, I7, T8, I8, T9, I9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)\
	sql_construct_define_##CONTR(NAME, T1, I1, T2, I2, T3, I3, T4, I4, T5, I5, T6, I6, T7, I7, T8, I8, T9, I9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)\
	static const char* names[];\
	static void table(const char* t) { table_ = t; }\
	const char* table() const\
			{ return table_override_ ? table_override_ : NAME::table_; }\
	void instance_table(const char* t) { table_override_ = t; }\
	NAME##_value_list<mysqlpp::quote_type0> value_list() const {\
		return value_list(",", mysqlpp::quote);}\
	NAME##_value_list<mysqlpp::quote_type0> value_list(const char* d) const {\
		return value_list(d, mysqlpp::quote);}\
	template <class Manip>\
	NAME##_value_list<Manip> value_list(const char* d, Manip m) const;\
	NAME##_field_list<mysqlpp::do_nothing_type0> field_list() const {\
		return field_list(",", mysqlpp::do_nothing);}\
	NAME##_field_list<mysqlpp::do_nothing_type0> field_list(const char* d) const {\
		return field_list(d, mysqlpp::do_nothing);}\
	template <class Manip>\
	NAME##_field_list<Manip> field_list(const char* d, Manip m) const;\
	NAME##_equal_list<mysqlpp::quote_type0> equal_list(const char* d = ",",\
			const char* c = " = ") const\
			{ return equal_list(d, c, mysqlpp::quote); }\
	template <class Manip>\
	NAME##_equal_list<Manip> equal_list(const char* d, const char* c, Manip m) const;\
	/* cus_data */\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false) const\
			{ return value_list(",", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL) const\
			{ return value_list(",", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(std::vector<bool> *i) const\
			{ return value_list(",", mysqlpp::quote, i); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(mysqlpp::sql_cmp_type sc) const\
			{ return value_list(",", mysqlpp::quote, sc); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(const char* d, bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false) const\
			{ return value_list(d, mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(const char* d, NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL) const\
			{ return value_list(d, mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(const char* d,\
			std::vector<bool> *i) const\
			{ return value_list(d, mysqlpp::quote, i); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(const char* d,\
			mysqlpp::sql_cmp_type sc) const\
			{ return value_list(d, mysqlpp::quote, sc); }\
	template <class Manip>\
	NAME##_cus_value_list<Manip> value_list(const char* d, Manip m,\
			bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false) const;\
	template <class Manip>\
	NAME##_cus_value_list<Manip> value_list(const char* d, Manip m,\
			NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL) const;\
	template <class Manip>\
	NAME##_cus_value_list<Manip> value_list(const char* d, Manip m,\
			std::vector<bool>* i) const;\
	template <class Manip>\
	NAME##_cus_value_list<Manip> value_list(const char* d, Manip m, \
			mysqlpp::sql_cmp_type sc) const;\
	/* cus field */\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false) const \
			{ return field_list(",", mysqlpp::do_nothing, i1, i2, i3, i4, i5, i6, i7, i8, i9); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL) const\
			{ return field_list(",", mysqlpp::do_nothing, i1, i2, i3, i4, i5, i6, i7, i8, i9); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(std::vector<bool> *i) const\
			{ return field_list(",", mysqlpp::do_nothing, i); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(mysqlpp::sql_cmp_type sc) const\
			{ return field_list(",", mysqlpp::do_nothing, sc); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(const char* d,\
			bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false) const\
			{ return field_list(d, mysqlpp::do_nothing, i1, i2, i3, i4, i5, i6, i7, i8, i9); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(const char* d,\
			NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL) const\
			{ return field_list(d, mysqlpp::do_nothing, i1, i2, i3, i4, i5, i6, i7, i8, i9); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(const char* d,\
			std::vector<bool>* i) const\
			{ return field_list(d, mysqlpp::do_nothing, i); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(const char* d,\
			mysqlpp::sql_cmp_type sc) const\
			{ return field_list(d, mysqlpp::do_nothing, sc); }\
	template <class Manip>\
	NAME##_cus_field_list<Manip> field_list(const char* d, Manip m,\
			bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false) const;\
	template <class Manip>\
	NAME##_cus_field_list<Manip> field_list(const char* d, Manip m,\
			NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL) const;\
	template <class Manip>\
	NAME##_cus_field_list<Manip> field_list(const char* d, Manip m,\
			std::vector<bool> *i) const;\
	template <class Manip>\
	NAME##_cus_field_list<Manip> field_list(const char* d, Manip m,\
			mysqlpp::sql_cmp_type sc) const;\
	/* cus equal */\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false) const\
			{ return equal_list(",", " = ", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL) const\
			{ return equal_list(",", " = ", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(std::vector<bool>* i) const\
			{ return equal_list(",", " = ", mysqlpp::quote, i); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(mysqlpp::sql_cmp_type sc) const\
			{ return equal_list(",", " = ", mysqlpp::quote, sc); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false) const\
			{ return equal_list(d, " = ", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL) const\
			{ return equal_list(d, " = ", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d,\
			std::vector<bool> *i) const\
			{ return equal_list(d, " = ", mysqlpp::quote, i); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d,\
			mysqlpp::sql_cmp_type sc) const\
			{ return equal_list(d, " = ", mysqlpp::quote, sc); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, const char* c,\
			bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false) const\
			{ return equal_list(d, c, mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, const char* c,\
			NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL) const\
			{ return equal_list(d, c, mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, const char* c,\
			std::vector<bool> *i) const\
			{ return equal_list(d, c, mysqlpp::quote, i); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, const char* c,\
			mysqlpp::sql_cmp_type sc) const\
			{ return equal_list(d, c, mysqlpp::quote, sc); }\
	template <class Manip>\
	NAME##_cus_equal_list<Manip> equal_list(const char* d, const char* c, Manip m, \
						bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false) const;\
	template <class Manip>\
	NAME##_cus_equal_list<Manip> equal_list(const char* d, const char* c, Manip m, \
						NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL) const;\
	template <class Manip>\
	NAME##_cus_equal_list<Manip> equal_list(const char* d, const char* c, Manip m, \
						std::vector<bool> *i) const;\
	template <class Manip>\
	NAME##_cus_equal_list<Manip> equal_list(const char* d, const char* c, Manip m, \
						mysqlpp::sql_cmp_type sc) const;\
	private:\
	static const char* table_;\
	const char* table_override_;\
	};\
	MYSQLPP_SSQLS_CONDITIONAL_STATICS(\
		const char* NAME::names[] = {\
			    N1 ,\
    N2 ,\
    N3 ,\
    N4 ,\
    N5 ,\
    N6 ,\
    N7 ,\
    N8 ,\
    N9 \
		};\
		const char* NAME::table_ = #NAME;\
	)\
	template <class Manip>\
	NAME##_cus_value_list<Manip>::NAME##_cus_value_list\
			(const NAME* o, const char* d, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9)\
	{\
		delim = d;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(9, false);\
    if (i1) (*include)[0]=true;\
    if (i2) (*include)[1]=true;\
    if (i3) (*include)[2]=true;\
    if (i4) (*include)[3]=true;\
    if (i5) (*include)[4]=true;\
    if (i6) (*include)[5]=true;\
    if (i7) (*include)[6]=true;\
    if (i8) (*include)[7]=true;\
    if (i9) (*include)[8]=true;\
	}\
	template <class Manip>\
	NAME##_cus_value_list<Manip>::NAME##_cus_value_list\
			(const NAME* o, const char* d, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9)\
	{\
		delim = d;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(9, false);\
    if (i1 == NAME##_NULL) return;\
    (*include)[i1]=true;\
    if (i2 == NAME##_NULL) return;\
    (*include)[i2]=true;\
    if (i3 == NAME##_NULL) return;\
    (*include)[i3]=true;\
    if (i4 == NAME##_NULL) return;\
    (*include)[i4]=true;\
    if (i5 == NAME##_NULL) return;\
    (*include)[i5]=true;\
    if (i6 == NAME##_NULL) return;\
    (*include)[i6]=true;\
    if (i7 == NAME##_NULL) return;\
    (*include)[i7]=true;\
    if (i8 == NAME##_NULL) return;\
    (*include)[i8]=true;\
    if (i9 == NAME##_NULL) return;\
    (*include)[i9]=true;\
	}\
	template <class Manip>\
	NAME##_cus_field_list<Manip>::NAME##_cus_field_list\
			(const NAME* o, const char* d, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9)\
	{\
		delim = d;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(9, false);\
    if (i1) (*include)[0]=true;\
    if (i2) (*include)[1]=true;\
    if (i3) (*include)[2]=true;\
    if (i4) (*include)[3]=true;\
    if (i5) (*include)[4]=true;\
    if (i6) (*include)[5]=true;\
    if (i7) (*include)[6]=true;\
    if (i8) (*include)[7]=true;\
    if (i9) (*include)[8]=true;\
	}\
	template <class Manip>\
	NAME##_cus_field_list<Manip>::NAME##_cus_field_list\
			(const NAME* o, const char* d, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9)\
	{\
		delim = d;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(9, false);\
    if (i1 == NAME##_NULL) return;\
    (*include)[i1]=true;\
    if (i2 == NAME##_NULL) return;\
    (*include)[i2]=true;\
    if (i3 == NAME##_NULL) return;\
    (*include)[i3]=true;\
    if (i4 == NAME##_NULL) return;\
    (*include)[i4]=true;\
    if (i5 == NAME##_NULL) return;\
    (*include)[i5]=true;\
    if (i6 == NAME##_NULL) return;\
    (*include)[i6]=true;\
    if (i7 == NAME##_NULL) return;\
    (*include)[i7]=true;\
    if (i8 == NAME##_NULL) return;\
    (*include)[i8]=true;\
    if (i9 == NAME##_NULL) return;\
    (*include)[i9]=true;\
	}\
	template <class Manip>\
	NAME##_cus_equal_list<Manip>::NAME##_cus_equal_list\
			(const NAME* o, const char* d, const char* c, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9)\
	{\
		delim = d;\
		comp = c;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(9, false);\
    if (i1) (*include)[0]=true;\
    if (i2) (*include)[1]=true;\
    if (i3) (*include)[2]=true;\
    if (i4) (*include)[3]=true;\
    if (i5) (*include)[4]=true;\
    if (i6) (*include)[5]=true;\
    if (i7) (*include)[6]=true;\
    if (i8) (*include)[7]=true;\
    if (i9) (*include)[8]=true;\
	}\
	template <class Manip>\
	NAME##_cus_equal_list<Manip>::NAME##_cus_equal_list\
			(const NAME* o, const char* d, const char* c, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9)\
	{\
		delim = d;\
		comp = c;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(9, false);\
    if (i1 == NAME##_NULL) return;\
    (*include)[i1]=true;\
    if (i2 == NAME##_NULL) return;\
    (*include)[i2]=true;\
    if (i3 == NAME##_NULL) return;\
    (*include)[i3]=true;\
    if (i4 == NAME##_NULL) return;\
    (*include)[i4]=true;\
    if (i5 == NAME##_NULL) return;\
    (*include)[i5]=true;\
    if (i6 == NAME##_NULL) return;\
    (*include)[i6]=true;\
    if (i7 == NAME##_NULL) return;\
    (*include)[i7]=true;\
    if (i8 == NAME##_NULL) return;\
    (*include)[i8]=true;\
    if (i9 == NAME##_NULL) return;\
    (*include)[i9]=true;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_value_list<Manip>& obj)\
	{\
    s << obj.manip << obj.obj->I1 << obj.delim;\
    s << obj.manip << obj.obj->I2 << obj.delim;\
    s << obj.manip << obj.obj->I3 << obj.delim;\
    s << obj.manip << obj.obj->I4 << obj.delim;\
    s << obj.manip << obj.obj->I5 << obj.delim;\
    s << obj.manip << obj.obj->I6 << obj.delim;\
    s << obj.manip << obj.obj->I7 << obj.delim;\
    s << obj.manip << obj.obj->I8 << obj.delim;\
    s << obj.manip << obj.obj->I9;\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_field_list<Manip>& obj)\
	{\
    s << obj.manip << '`' << obj.obj->names[0] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[1] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[2] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[3] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[4] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[5] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[6] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[7] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[8] << '`';\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_equal_list<Manip>& obj)\
	{\
    s << '`' << obj.obj->names[0] << '`' << obj.comp << obj.manip << obj.obj->I1 << obj.delim;\
    s << '`' << obj.obj->names[1] << '`' << obj.comp << obj.manip << obj.obj->I2 << obj.delim;\
    s << '`' << obj.obj->names[2] << '`' << obj.comp << obj.manip << obj.obj->I3 << obj.delim;\
    s << '`' << obj.obj->names[3] << '`' << obj.comp << obj.manip << obj.obj->I4 << obj.delim;\
    s << '`' << obj.obj->names[4] << '`' << obj.comp << obj.manip << obj.obj->I5 << obj.delim;\
    s << '`' << obj.obj->names[5] << '`' << obj.comp << obj.manip << obj.obj->I6 << obj.delim;\
    s << '`' << obj.obj->names[6] << '`' << obj.comp << obj.manip << obj.obj->I7 << obj.delim;\
    s << '`' << obj.obj->names[7] << '`' << obj.comp << obj.manip << obj.obj->I8 << obj.delim;\
    s << '`' << obj.obj->names[8] << '`' << obj.comp << obj.manip << obj.obj->I9;\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_cus_value_list<Manip>& obj)\
	{\
		bool before = false;\
    if ((*obj.include)[0]) { \
      s << obj.manip << obj.obj->I1;\
      before = true; \
     } \
    if ((*obj.include)[1]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I2;\
      before = true; \
     } \
    if ((*obj.include)[2]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I3;\
      before = true; \
     } \
    if ((*obj.include)[3]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I4;\
      before = true; \
     } \
    if ((*obj.include)[4]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I5;\
      before = true; \
     } \
    if ((*obj.include)[5]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I6;\
      before = true; \
     } \
    if ((*obj.include)[6]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I7;\
      before = true; \
     } \
    if ((*obj.include)[7]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I8;\
      before = true; \
     } \
    if ((*obj.include)[8]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I9;\
     } \
        (void)before;\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_cus_field_list<Manip>& obj)\
	{\
		bool before = false;\
    if ((*obj.include)[0]) { \
      s << obj.manip << '`' << obj.obj->names[0] << '`';\
      before = true; \
     } \
    if ((*obj.include)[1]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[1] << '`';\
      before = true; \
     } \
    if ((*obj.include)[2]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[2] << '`';\
      before = true; \
     } \
    if ((*obj.include)[3]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[3] << '`';\
      before = true; \
     } \
    if ((*obj.include)[4]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[4] << '`';\
      before = true; \
     } \
    if ((*obj.include)[5]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[5] << '`';\
      before = true; \
     } \
    if ((*obj.include)[6]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[6] << '`';\
      before = true; \
     } \
    if ((*obj.include)[7]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[7] << '`';\
      before = true; \
     } \
    if ((*obj.include)[8]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[8] << '`';\
     } \
        (void)before;\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_cus_equal_list<Manip>& obj)\
	{\
		bool before = false;\
    if ((*obj.include)[0]) { \
      s << '`' << obj.obj->names[0] << '`' << obj.comp << obj.manip << obj.obj->I1;\
      before = true; \
     } \
    if ((*obj.include)[1]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[1] << '`' << obj.comp << obj.manip << obj.obj->I2;\
      before = true; \
     } \
    if ((*obj.include)[2]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[2] << '`' << obj.comp << obj.manip << obj.obj->I3;\
      before = true; \
     } \
    if ((*obj.include)[3]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[3] << '`' << obj.comp << obj.manip << obj.obj->I4;\
      before = true; \
     } \
    if ((*obj.include)[4]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[4] << '`' << obj.comp << obj.manip << obj.obj->I5;\
      before = true; \
     } \
    if ((*obj.include)[5]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[5] << '`' << obj.comp << obj.manip << obj.obj->I6;\
      before = true; \
     } \
    if ((*obj.include)[6]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[6] << '`' << obj.comp << obj.manip << obj.obj->I7;\
      before = true; \
     } \
    if ((*obj.include)[7]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[7] << '`' << obj.comp << obj.manip << obj.obj->I8;\
      before = true; \
     } \
    if ((*obj.include)[8]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[8] << '`' << obj.comp << obj.manip << obj.obj->I9;\
     } \
        (void)before;\
		return s;\
	}\
	template <class Manip>\
	inline NAME##_value_list<Manip> NAME::value_list(const char* d, Manip m) const\
			{ return NAME##_value_list<Manip> (this, d, m); } \
	template <class Manip>\
	inline NAME##_field_list<Manip> NAME::field_list(const char* d, Manip m) const\
			{ return NAME##_field_list<Manip> (this, d, m); } \
	template <class Manip>\
	inline NAME##_equal_list<Manip> NAME::equal_list(const char* d, const char* c, Manip m) const\
			{ return NAME##_equal_list<Manip> (this, d, c, m); } \
	template <class Manip>\
	inline NAME##_cus_value_list<Manip> NAME::value_list(const char* d, Manip m,\
			bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9) const\
			{ return NAME##_cus_value_list<Manip> (this, d, m, i1, i2, i3, i4, i5, i6, i7, i8, i9); }\
	template <class Manip>\
	inline NAME##_cus_field_list<Manip> NAME::field_list(const char* d, Manip m,\
			bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9) const\
			{ return NAME##_cus_field_list<Manip> (this, d, m, i1, i2, i3, i4, i5, i6, i7, i8, i9); }\
	template <class Manip>\
	inline NAME##_cus_equal_list<Manip> NAME::equal_list(const char* d, const char* c, Manip m,\
			bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9) const\
			{ return NAME##_cus_equal_list<Manip> (this, d, c, m, i1, i2, i3, i4, i5, i6, i7, i8, i9); } \
	template <class Manip>\
	inline NAME##_cus_value_list<Manip> NAME::value_list(const char* d, Manip m,\
			NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9) const\
			{ return NAME##_cus_value_list<Manip> (this, d, m, i1, i2, i3, i4, i5, i6, i7, i8, i9); } \
	template <class Manip>\
	inline NAME##_cus_field_list<Manip> NAME::field_list(const char* d, Manip m,\
			NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9) const\
			{ return NAME##_cus_field_list<Manip> (this, d, m, i1, i2, i3, i4, i5, i6, i7, i8, i9); } \
	template <class Manip>\
	inline NAME##_cus_equal_list<Manip> NAME::equal_list(const char* d, const char* c, Manip m, \
			NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9) const\
			{ return NAME##_cus_equal_list<Manip> (this, d, c, m, i1, i2, i3, i4, i5, i6, i7, i8, i9); } \
	template <class Manip>\
	inline NAME##_cus_value_list<Manip> NAME::value_list(const char* d, Manip m,\
			std::vector<bool> *i) const\
			{ return NAME##_cus_value_list<Manip> (this, d, m, i); }\
	template <class Manip>\
	inline NAME##_cus_field_list<Manip> NAME::field_list(const char* d, Manip m,\
			std::vector<bool> *i) const\
			{ return NAME##_cus_field_list<Manip> (this, d, m, i); }\
	template <class Manip>\
	inline NAME##_cus_equal_list<Manip> NAME::equal_list(const char* d, const char* c, Manip m,\
			std::vector<bool> *i) const\
			{ return NAME##_cus_equal_list<Manip> (this, d, c, m, i); }\
	template <class Manip>\
	inline NAME##_cus_value_list<Manip> \
	NAME::value_list(const char* d, Manip m, mysqlpp::sql_cmp_type /*sc*/) const\
			{ sql_compare_type_def_##CMP(NAME, value, NUM); }\
	template <class Manip>\
	inline NAME##_cus_field_list<Manip> \
	NAME::field_list(const char* d, Manip m, mysqlpp::sql_cmp_type /*sc*/) const\
			{ sql_compare_type_def_##CMP(NAME, field, NUM); }\
	template <class Manip>\
	inline NAME##_cus_equal_list<Manip> \
	NAME::equal_list(const char* d, const char* c, Manip m, mysqlpp::sql_cmp_type /*sc*/) const\
			{ sql_compare_type_defe_##CMP(NAME, equal, NUM); }\
	template <mysqlpp::sql_dummy_type dummy>\
	void populate_##NAME(NAME *s, const mysqlpp::Row &row)\
	{\
		mysqlpp::NoExceptions ignore_schema_mismatches(row);\
    s->I1 = row[N1].conv(T1());\
    s->I2 = row[N2].conv(T2());\
    s->I3 = row[N3].conv(T3());\
    s->I4 = row[N4].conv(T4());\
    s->I5 = row[N5].conv(T5());\
    s->I6 = row[N6].conv(T6());\
    s->I7 = row[N7].conv(T7());\
    s->I8 = row[N8].conv(T8());\
    s->I9 = row[N9].conv(T9());\
	}\
	inline NAME::NAME(const mysqlpp::Row& row) :\
	table_override_(0)\
			{ populate_##NAME<mysqlpp::sql_dummy>(this, row); }\
	inline void NAME::set(const mysqlpp::Row& row)\
	{\
		table_override_ = 0;\
		populate_##NAME<mysqlpp::sql_dummy>(this, row);\
	}\
	sql_COMPARE__##CMP(NAME, I1, I2, I3, I4, I5, I6, I7, I8, I9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 )

#define sql_create_9(NAME, CMP, CONTR, T1, I1, T2, I2, T3, I3, T4, I4, T5, I5, T6, I6, T7, I7, T8, I8, T9, I9) \
		sql_create_complete_9(NAME, CMP, CONTR, T1, I1, #I1, T2, I2, #I2, T3, I3, #I3, T4, I4, #I4, T5, I5, #I5, T6, I6, #I6, T7, I7, #I7, T8, I8, #I8, T9, I9, #I9) \

// ---------------------------------------------------
//                  End Create 9
// ---------------------------------------------------

// ---------------------------------------------------
//                  Begin Create 10
// ---------------------------------------------------
#define sql_create_complete_10(NAME, CMP, CONTR, T1, I1, N1, T2, I2, N2, T3, I3, N3, T4, I4, N4, T5, I5, N5, T6, I6, N6, T7, I7, N7, T8, I8, N8, T9, I9, N9, T10, I10, N10) \
	struct NAME; \
	enum NAME##_enum { \
    NAME##_##I1,\
    NAME##_##I2,\
    NAME##_##I3,\
    NAME##_##I4,\
    NAME##_##I5,\
    NAME##_##I6,\
    NAME##_##I7,\
    NAME##_##I8,\
    NAME##_##I9,\
    NAME##_##I10 \
	,NAME##_NULL \
	}; \
	template <class Manip>\
	class NAME##_value_list { \
	public: \
	const NAME* obj;\
	const char* delim;\
	Manip manip;\
	public: \
	NAME##_value_list (const NAME* o, const char* d, Manip m) :\
	obj(o), delim(d), manip(m) { } \
	};\
	template <class Manip>\
	class NAME##_##field_list {\
	public: \
	const NAME* obj; \
	const char* delim;\
	Manip manip;\
	public: \
	NAME##_field_list (const NAME* o, const char* d, Manip m) :\
	obj(o), delim(d), manip(m) { } \
	};\
	template <class Manip>\
	class NAME##_equal_list { \
	public: \
	const NAME* obj;\
	const char* delim;\
	const char* comp;\
	Manip manip;\
	public: \
	NAME##_equal_list (const NAME* o, const char* d, const char* c, Manip m) :\
	obj(o), delim(d), comp(c), manip(m) { }\
	};\
	template <class Manip>\
	class NAME##_cus_value_list {\
	public:\
	const NAME* obj;\
	std::vector<bool> *include;\
	bool del_vector;\
	const char* delim;\
	Manip manip;\
	public: \
	~NAME##_cus_value_list () {if (del_vector) delete include;} \
	NAME##_cus_value_list (const NAME* o, const char* d, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10);\
	NAME##_cus_value_list (const NAME* o, const char* d, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10); \
	NAME##_cus_value_list (const NAME* o, const char* d, Manip m ,std::vector<bool>* i) :\
	obj(o), include(i), del_vector(false), delim(d), manip(m) { }\
	};\
	template <class Manip>\
	class NAME##_cus_field_list { \
	public:\
	const NAME* obj; \
	std::vector<bool> *include; \
	bool del_vector; \
	const char* delim;\
	Manip manip;\
	public: \
	~NAME##_cus_field_list () {if (del_vector) delete include;} \
	NAME##_cus_field_list (const NAME* o, const char* d, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10); \
	NAME##_cus_field_list (const NAME* o, const char* d, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10); \
	NAME##_cus_field_list (const NAME* o, const char* d, Manip m, std::vector<bool> *i) :\
	obj(o), include(i), del_vector(false), delim(d), manip(m) { }\
	};\
	template <class Manip>\
	class NAME##_cus_equal_list {\
	public:\
	const NAME* obj;\
	std::vector<bool> *include;\
	bool del_vector;\
	const char* delim;\
	const char* comp;\
	Manip manip;\
	public:\
	~NAME##_##cus_equal_list () {if (del_vector) delete include;}\
	NAME##_##cus_equal_list (const NAME* o, const char* d, const char* c, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10); \
	NAME##_##cus_equal_list (const NAME* o, const char* d, const char* c, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10); \
	NAME##_##cus_equal_list (const NAME* o, const char* d, const char* c, Manip m, std::vector<bool> *i) :\
	obj(o), include(i), del_vector(false), delim(d), comp(c), manip(m) { }\
	};\
	template <mysqlpp::sql_dummy_type dummy> int sql_compare_##NAME(const NAME&, const NAME&);\
	struct NAME {\
    T1 I1;\
    T2 I2;\
    T3 I3;\
    T4 I4;\
    T5 I5;\
    T6 I6;\
    T7 I7;\
    T8 I8;\
    T9 I9;\
    T10 I10; \
	NAME() : table_override_(0) { }\
	NAME(const mysqlpp::Row& row);\
	void set(const mysqlpp::Row &row);\
	sql_compare_define_##CMP(NAME, T1, I1, T2, I2, T3, I3, T4, I4, T5, I5, T6, I6, T7, I7, T8, I8, T9, I9, T10, I10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)\
	sql_construct_define_##CONTR(NAME, T1, I1, T2, I2, T3, I3, T4, I4, T5, I5, T6, I6, T7, I7, T8, I8, T9, I9, T10, I10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)\
	static const char* names[];\
	static void table(const char* t) { table_ = t; }\
	const char* table() const\
			{ return table_override_ ? table_override_ : NAME::table_; }\
	void instance_table(const char* t) { table_override_ = t; }\
	NAME##_value_list<mysqlpp::quote_type0> value_list() const {\
		return value_list(",", mysqlpp::quote);}\
	NAME##_value_list<mysqlpp::quote_type0> value_list(const char* d) const {\
		return value_list(d, mysqlpp::quote);}\
	template <class Manip>\
	NAME##_value_list<Manip> value_list(const char* d, Manip m) const;\
	NAME##_field_list<mysqlpp::do_nothing_type0> field_list() const {\
		return field_list(",", mysqlpp::do_nothing);}\
	NAME##_field_list<mysqlpp::do_nothing_type0> field_list(const char* d) const {\
		return field_list(d, mysqlpp::do_nothing);}\
	template <class Manip>\
	NAME##_field_list<Manip> field_list(const char* d, Manip m) const;\
	NAME##_equal_list<mysqlpp::quote_type0> equal_list(const char* d = ",",\
			const char* c = " = ") const\
			{ return equal_list(d, c, mysqlpp::quote); }\
	template <class Manip>\
	NAME##_equal_list<Manip> equal_list(const char* d, const char* c, Manip m) const;\
	/* cus_data */\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false) const\
			{ return value_list(",", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL) const\
			{ return value_list(",", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(std::vector<bool> *i) const\
			{ return value_list(",", mysqlpp::quote, i); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(mysqlpp::sql_cmp_type sc) const\
			{ return value_list(",", mysqlpp::quote, sc); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(const char* d, bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false) const\
			{ return value_list(d, mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(const char* d, NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL) const\
			{ return value_list(d, mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(const char* d,\
			std::vector<bool> *i) const\
			{ return value_list(d, mysqlpp::quote, i); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(const char* d,\
			mysqlpp::sql_cmp_type sc) const\
			{ return value_list(d, mysqlpp::quote, sc); }\
	template <class Manip>\
	NAME##_cus_value_list<Manip> value_list(const char* d, Manip m,\
			bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false) const;\
	template <class Manip>\
	NAME##_cus_value_list<Manip> value_list(const char* d, Manip m,\
			NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL) const;\
	template <class Manip>\
	NAME##_cus_value_list<Manip> value_list(const char* d, Manip m,\
			std::vector<bool>* i) const;\
	template <class Manip>\
	NAME##_cus_value_list<Manip> value_list(const char* d, Manip m, \
			mysqlpp::sql_cmp_type sc) const;\
	/* cus field */\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false) const \
			{ return field_list(",", mysqlpp::do_nothing, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL) const\
			{ return field_list(",", mysqlpp::do_nothing, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(std::vector<bool> *i) const\
			{ return field_list(",", mysqlpp::do_nothing, i); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(mysqlpp::sql_cmp_type sc) const\
			{ return field_list(",", mysqlpp::do_nothing, sc); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(const char* d,\
			bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false) const\
			{ return field_list(d, mysqlpp::do_nothing, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(const char* d,\
			NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL) const\
			{ return field_list(d, mysqlpp::do_nothing, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(const char* d,\
			std::vector<bool>* i) const\
			{ return field_list(d, mysqlpp::do_nothing, i); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(const char* d,\
			mysqlpp::sql_cmp_type sc) const\
			{ return field_list(d, mysqlpp::do_nothing, sc); }\
	template <class Manip>\
	NAME##_cus_field_list<Manip> field_list(const char* d, Manip m,\
			bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false) const;\
	template <class Manip>\
	NAME##_cus_field_list<Manip> field_list(const char* d, Manip m,\
			NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL) const;\
	template <class Manip>\
	NAME##_cus_field_list<Manip> field_list(const char* d, Manip m,\
			std::vector<bool> *i) const;\
	template <class Manip>\
	NAME##_cus_field_list<Manip> field_list(const char* d, Manip m,\
			mysqlpp::sql_cmp_type sc) const;\
	/* cus equal */\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false) const\
			{ return equal_list(",", " = ", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL) const\
			{ return equal_list(",", " = ", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(std::vector<bool>* i) const\
			{ return equal_list(",", " = ", mysqlpp::quote, i); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(mysqlpp::sql_cmp_type sc) const\
			{ return equal_list(",", " = ", mysqlpp::quote, sc); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false) const\
			{ return equal_list(d, " = ", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL) const\
			{ return equal_list(d, " = ", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d,\
			std::vector<bool> *i) const\
			{ return equal_list(d, " = ", mysqlpp::quote, i); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d,\
			mysqlpp::sql_cmp_type sc) const\
			{ return equal_list(d, " = ", mysqlpp::quote, sc); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, const char* c,\
			bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false) const\
			{ return equal_list(d, c, mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, const char* c,\
			NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL) const\
			{ return equal_list(d, c, mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, const char* c,\
			std::vector<bool> *i) const\
			{ return equal_list(d, c, mysqlpp::quote, i); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, const char* c,\
			mysqlpp::sql_cmp_type sc) const\
			{ return equal_list(d, c, mysqlpp::quote, sc); }\
	template <class Manip>\
	NAME##_cus_equal_list<Manip> equal_list(const char* d, const char* c, Manip m, \
						bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false) const;\
	template <class Manip>\
	NAME##_cus_equal_list<Manip> equal_list(const char* d, const char* c, Manip m, \
						NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL) const;\
	template <class Manip>\
	NAME##_cus_equal_list<Manip> equal_list(const char* d, const char* c, Manip m, \
						std::vector<bool> *i) const;\
	template <class Manip>\
	NAME##_cus_equal_list<Manip> equal_list(const char* d, const char* c, Manip m, \
						mysqlpp::sql_cmp_type sc) const;\
	private:\
	static const char* table_;\
	const char* table_override_;\
	};\
	MYSQLPP_SSQLS_CONDITIONAL_STATICS(\
		const char* NAME::names[] = {\
			    N1 ,\
    N2 ,\
    N3 ,\
    N4 ,\
    N5 ,\
    N6 ,\
    N7 ,\
    N8 ,\
    N9 ,\
    N10 \
		};\
		const char* NAME::table_ = #NAME;\
	)\
	template <class Manip>\
	NAME##_cus_value_list<Manip>::NAME##_cus_value_list\
			(const NAME* o, const char* d, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10)\
	{\
		delim = d;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(10, false);\
    if (i1) (*include)[0]=true;\
    if (i2) (*include)[1]=true;\
    if (i3) (*include)[2]=true;\
    if (i4) (*include)[3]=true;\
    if (i5) (*include)[4]=true;\
    if (i6) (*include)[5]=true;\
    if (i7) (*include)[6]=true;\
    if (i8) (*include)[7]=true;\
    if (i9) (*include)[8]=true;\
    if (i10) (*include)[9]=true;\
	}\
	template <class Manip>\
	NAME##_cus_value_list<Manip>::NAME##_cus_value_list\
			(const NAME* o, const char* d, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10)\
	{\
		delim = d;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(10, false);\
    if (i1 == NAME##_NULL) return;\
    (*include)[i1]=true;\
    if (i2 == NAME##_NULL) return;\
    (*include)[i2]=true;\
    if (i3 == NAME##_NULL) return;\
    (*include)[i3]=true;\
    if (i4 == NAME##_NULL) return;\
    (*include)[i4]=true;\
    if (i5 == NAME##_NULL) return;\
    (*include)[i5]=true;\
    if (i6 == NAME##_NULL) return;\
    (*include)[i6]=true;\
    if (i7 == NAME##_NULL) return;\
    (*include)[i7]=true;\
    if (i8 == NAME##_NULL) return;\
    (*include)[i8]=true;\
    if (i9 == NAME##_NULL) return;\
    (*include)[i9]=true;\
    if (i10 == NAME##_NULL) return;\
    (*include)[i10]=true;\
	}\
	template <class Manip>\
	NAME##_cus_field_list<Manip>::NAME##_cus_field_list\
			(const NAME* o, const char* d, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10)\
	{\
		delim = d;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(10, false);\
    if (i1) (*include)[0]=true;\
    if (i2) (*include)[1]=true;\
    if (i3) (*include)[2]=true;\
    if (i4) (*include)[3]=true;\
    if (i5) (*include)[4]=true;\
    if (i6) (*include)[5]=true;\
    if (i7) (*include)[6]=true;\
    if (i8) (*include)[7]=true;\
    if (i9) (*include)[8]=true;\
    if (i10) (*include)[9]=true;\
	}\
	template <class Manip>\
	NAME##_cus_field_list<Manip>::NAME##_cus_field_list\
			(const NAME* o, const char* d, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10)\
	{\
		delim = d;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(10, false);\
    if (i1 == NAME##_NULL) return;\
    (*include)[i1]=true;\
    if (i2 == NAME##_NULL) return;\
    (*include)[i2]=true;\
    if (i3 == NAME##_NULL) return;\
    (*include)[i3]=true;\
    if (i4 == NAME##_NULL) return;\
    (*include)[i4]=true;\
    if (i5 == NAME##_NULL) return;\
    (*include)[i5]=true;\
    if (i6 == NAME##_NULL) return;\
    (*include)[i6]=true;\
    if (i7 == NAME##_NULL) return;\
    (*include)[i7]=true;\
    if (i8 == NAME##_NULL) return;\
    (*include)[i8]=true;\
    if (i9 == NAME##_NULL) return;\
    (*include)[i9]=true;\
    if (i10 == NAME##_NULL) return;\
    (*include)[i10]=true;\
	}\
	template <class Manip>\
	NAME##_cus_equal_list<Manip>::NAME##_cus_equal_list\
			(const NAME* o, const char* d, const char* c, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10)\
	{\
		delim = d;\
		comp = c;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(10, false);\
    if (i1) (*include)[0]=true;\
    if (i2) (*include)[1]=true;\
    if (i3) (*include)[2]=true;\
    if (i4) (*include)[3]=true;\
    if (i5) (*include)[4]=true;\
    if (i6) (*include)[5]=true;\
    if (i7) (*include)[6]=true;\
    if (i8) (*include)[7]=true;\
    if (i9) (*include)[8]=true;\
    if (i10) (*include)[9]=true;\
	}\
	template <class Manip>\
	NAME##_cus_equal_list<Manip>::NAME##_cus_equal_list\
			(const NAME* o, const char* d, const char* c, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10)\
	{\
		delim = d;\
		comp = c;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(10, false);\
    if (i1 == NAME##_NULL) return;\
    (*include)[i1]=true;\
    if (i2 == NAME##_NULL) return;\
    (*include)[i2]=true;\
    if (i3 == NAME##_NULL) return;\
    (*include)[i3]=true;\
    if (i4 == NAME##_NULL) return;\
    (*include)[i4]=true;\
    if (i5 == NAME##_NULL) return;\
    (*include)[i5]=true;\
    if (i6 == NAME##_NULL) return;\
    (*include)[i6]=true;\
    if (i7 == NAME##_NULL) return;\
    (*include)[i7]=true;\
    if (i8 == NAME##_NULL) return;\
    (*include)[i8]=true;\
    if (i9 == NAME##_NULL) return;\
    (*include)[i9]=true;\
    if (i10 == NAME##_NULL) return;\
    (*include)[i10]=true;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_value_list<Manip>& obj)\
	{\
    s << obj.manip << obj.obj->I1 << obj.delim;\
    s << obj.manip << obj.obj->I2 << obj.delim;\
    s << obj.manip << obj.obj->I3 << obj.delim;\
    s << obj.manip << obj.obj->I4 << obj.delim;\
    s << obj.manip << obj.obj->I5 << obj.delim;\
    s << obj.manip << obj.obj->I6 << obj.delim;\
    s << obj.manip << obj.obj->I7 << obj.delim;\
    s << obj.manip << obj.obj->I8 << obj.delim;\
    s << obj.manip << obj.obj->I9 << obj.delim;\
    s << obj.manip << obj.obj->I10;\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_field_list<Manip>& obj)\
	{\
    s << obj.manip << '`' << obj.obj->names[0] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[1] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[2] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[3] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[4] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[5] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[6] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[7] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[8] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[9] << '`';\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_equal_list<Manip>& obj)\
	{\
    s << '`' << obj.obj->names[0] << '`' << obj.comp << obj.manip << obj.obj->I1 << obj.delim;\
    s << '`' << obj.obj->names[1] << '`' << obj.comp << obj.manip << obj.obj->I2 << obj.delim;\
    s << '`' << obj.obj->names[2] << '`' << obj.comp << obj.manip << obj.obj->I3 << obj.delim;\
    s << '`' << obj.obj->names[3] << '`' << obj.comp << obj.manip << obj.obj->I4 << obj.delim;\
    s << '`' << obj.obj->names[4] << '`' << obj.comp << obj.manip << obj.obj->I5 << obj.delim;\
    s << '`' << obj.obj->names[5] << '`' << obj.comp << obj.manip << obj.obj->I6 << obj.delim;\
    s << '`' << obj.obj->names[6] << '`' << obj.comp << obj.manip << obj.obj->I7 << obj.delim;\
    s << '`' << obj.obj->names[7] << '`' << obj.comp << obj.manip << obj.obj->I8 << obj.delim;\
    s << '`' << obj.obj->names[8] << '`' << obj.comp << obj.manip << obj.obj->I9 << obj.delim;\
    s << '`' << obj.obj->names[9] << '`' << obj.comp << obj.manip << obj.obj->I10;\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_cus_value_list<Manip>& obj)\
	{\
		bool before = false;\
    if ((*obj.include)[0]) { \
      s << obj.manip << obj.obj->I1;\
      before = true; \
     } \
    if ((*obj.include)[1]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I2;\
      before = true; \
     } \
    if ((*obj.include)[2]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I3;\
      before = true; \
     } \
    if ((*obj.include)[3]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I4;\
      before = true; \
     } \
    if ((*obj.include)[4]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I5;\
      before = true; \
     } \
    if ((*obj.include)[5]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I6;\
      before = true; \
     } \
    if ((*obj.include)[6]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I7;\
      before = true; \
     } \
    if ((*obj.include)[7]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I8;\
      before = true; \
     } \
    if ((*obj.include)[8]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I9;\
      before = true; \
     } \
    if ((*obj.include)[9]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I10;\
     } \
        (void)before;\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_cus_field_list<Manip>& obj)\
	{\
		bool before = false;\
    if ((*obj.include)[0]) { \
      s << obj.manip << '`' << obj.obj->names[0] << '`';\
      before = true; \
     } \
    if ((*obj.include)[1]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[1] << '`';\
      before = true; \
     } \
    if ((*obj.include)[2]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[2] << '`';\
      before = true; \
     } \
    if ((*obj.include)[3]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[3] << '`';\
      before = true; \
     } \
    if ((*obj.include)[4]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[4] << '`';\
      before = true; \
     } \
    if ((*obj.include)[5]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[5] << '`';\
      before = true; \
     } \
    if ((*obj.include)[6]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[6] << '`';\
      before = true; \
     } \
    if ((*obj.include)[7]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[7] << '`';\
      before = true; \
     } \
    if ((*obj.include)[8]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[8] << '`';\
      before = true; \
     } \
    if ((*obj.include)[9]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[9] << '`';\
     } \
        (void)before;\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_cus_equal_list<Manip>& obj)\
	{\
		bool before = false;\
    if ((*obj.include)[0]) { \
      s << '`' << obj.obj->names[0] << '`' << obj.comp << obj.manip << obj.obj->I1;\
      before = true; \
     } \
    if ((*obj.include)[1]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[1] << '`' << obj.comp << obj.manip << obj.obj->I2;\
      before = true; \
     } \
    if ((*obj.include)[2]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[2] << '`' << obj.comp << obj.manip << obj.obj->I3;\
      before = true; \
     } \
    if ((*obj.include)[3]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[3] << '`' << obj.comp << obj.manip << obj.obj->I4;\
      before = true; \
     } \
    if ((*obj.include)[4]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[4] << '`' << obj.comp << obj.manip << obj.obj->I5;\
      before = true; \
     } \
    if ((*obj.include)[5]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[5] << '`' << obj.comp << obj.manip << obj.obj->I6;\
      before = true; \
     } \
    if ((*obj.include)[6]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[6] << '`' << obj.comp << obj.manip << obj.obj->I7;\
      before = true; \
     } \
    if ((*obj.include)[7]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[7] << '`' << obj.comp << obj.manip << obj.obj->I8;\
      before = true; \
     } \
    if ((*obj.include)[8]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[8] << '`' << obj.comp << obj.manip << obj.obj->I9;\
      before = true; \
     } \
    if ((*obj.include)[9]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[9] << '`' << obj.comp << obj.manip << obj.obj->I10;\
     } \
        (void)before;\
		return s;\
	}\
	template <class Manip>\
	inline NAME##_value_list<Manip> NAME::value_list(const char* d, Manip m) const\
			{ return NAME##_value_list<Manip> (this, d, m); } \
	template <class Manip>\
	inline NAME##_field_list<Manip> NAME::field_list(const char* d, Manip m) const\
			{ return NAME##_field_list<Manip> (this, d, m); } \
	template <class Manip>\
	inline NAME##_equal_list<Manip> NAME::equal_list(const char* d, const char* c, Manip m) const\
			{ return NAME##_equal_list<Manip> (this, d, c, m); } \
	template <class Manip>\
	inline NAME##_cus_value_list<Manip> NAME::value_list(const char* d, Manip m,\
			bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10) const\
			{ return NAME##_cus_value_list<Manip> (this, d, m, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10); }\
	template <class Manip>\
	inline NAME##_cus_field_list<Manip> NAME::field_list(const char* d, Manip m,\
			bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10) const\
			{ return NAME##_cus_field_list<Manip> (this, d, m, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10); }\
	template <class Manip>\
	inline NAME##_cus_equal_list<Manip> NAME::equal_list(const char* d, const char* c, Manip m,\
			bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10) const\
			{ return NAME##_cus_equal_list<Manip> (this, d, c, m, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10); } \
	template <class Manip>\
	inline NAME##_cus_value_list<Manip> NAME::value_list(const char* d, Manip m,\
			NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10) const\
			{ return NAME##_cus_value_list<Manip> (this, d, m, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10); } \
	template <class Manip>\
	inline NAME##_cus_field_list<Manip> NAME::field_list(const char* d, Manip m,\
			NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10) const\
			{ return NAME##_cus_field_list<Manip> (this, d, m, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10); } \
	template <class Manip>\
	inline NAME##_cus_equal_list<Manip> NAME::equal_list(const char* d, const char* c, Manip m, \
			NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10) const\
			{ return NAME##_cus_equal_list<Manip> (this, d, c, m, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10); } \
	template <class Manip>\
	inline NAME##_cus_value_list<Manip> NAME::value_list(const char* d, Manip m,\
			std::vector<bool> *i) const\
			{ return NAME##_cus_value_list<Manip> (this, d, m, i); }\
	template <class Manip>\
	inline NAME##_cus_field_list<Manip> NAME::field_list(const char* d, Manip m,\
			std::vector<bool> *i) const\
			{ return NAME##_cus_field_list<Manip> (this, d, m, i); }\
	template <class Manip>\
	inline NAME##_cus_equal_list<Manip> NAME::equal_list(const char* d, const char* c, Manip m,\
			std::vector<bool> *i) const\
			{ return NAME##_cus_equal_list<Manip> (this, d, c, m, i); }\
	template <class Manip>\
	inline NAME##_cus_value_list<Manip> \
	NAME::value_list(const char* d, Manip m, mysqlpp::sql_cmp_type /*sc*/) const\
			{ sql_compare_type_def_##CMP(NAME, value, NUM); }\
	template <class Manip>\
	inline NAME##_cus_field_list<Manip> \
	NAME::field_list(const char* d, Manip m, mysqlpp::sql_cmp_type /*sc*/) const\
			{ sql_compare_type_def_##CMP(NAME, field, NUM); }\
	template <class Manip>\
	inline NAME##_cus_equal_list<Manip> \
	NAME::equal_list(const char* d, const char* c, Manip m, mysqlpp::sql_cmp_type /*sc*/) const\
			{ sql_compare_type_defe_##CMP(NAME, equal, NUM); }\
	template <mysqlpp::sql_dummy_type dummy>\
	void populate_##NAME(NAME *s, const mysqlpp::Row &row)\
	{\
		mysqlpp::NoExceptions ignore_schema_mismatches(row);\
    s->I1 = row[N1].conv(T1());\
    s->I2 = row[N2].conv(T2());\
    s->I3 = row[N3].conv(T3());\
    s->I4 = row[N4].conv(T4());\
    s->I5 = row[N5].conv(T5());\
    s->I6 = row[N6].conv(T6());\
    s->I7 = row[N7].conv(T7());\
    s->I8 = row[N8].conv(T8());\
    s->I9 = row[N9].conv(T9());\
    s->I10 = row[N10].conv(T10());\
	}\
	inline NAME::NAME(const mysqlpp::Row& row) :\
	table_override_(0)\
			{ populate_##NAME<mysqlpp::sql_dummy>(this, row); }\
	inline void NAME::set(const mysqlpp::Row& row)\
	{\
		table_override_ = 0;\
		populate_##NAME<mysqlpp::sql_dummy>(this, row);\
	}\
	sql_COMPARE__##CMP(NAME, I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 )

#define sql_create_10(NAME, CMP, CONTR, T1, I1, T2, I2, T3, I3, T4, I4, T5, I5, T6, I6, T7, I7, T8, I8, T9, I9, T10, I10) \
		sql_create_complete_10(NAME, CMP, CONTR, T1, I1, #I1, T2, I2, #I2, T3, I3, #I3, T4, I4, #I4, T5, I5, #I5, T6, I6, #I6, T7, I7, #I7, T8, I8, #I8, T9, I9, #I9, T10, I10, #I10) \

// ---------------------------------------------------
//                  End Create 10
// ---------------------------------------------------

// ---------------------------------------------------
//                  Begin Create 11
// ---------------------------------------------------
#define sql_create_complete_11(NAME, CMP, CONTR, T1, I1, N1, T2, I2, N2, T3, I3, N3, T4, I4, N4, T5, I5, N5, T6, I6, N6, T7, I7, N7, T8, I8, N8, T9, I9, N9, T10, I10, N10, T11, I11, N11) \
	struct NAME; \
	enum NAME##_enum { \
    NAME##_##I1,\
    NAME##_##I2,\
    NAME##_##I3,\
    NAME##_##I4,\
    NAME##_##I5,\
    NAME##_##I6,\
    NAME##_##I7,\
    NAME##_##I8,\
    NAME##_##I9,\
    NAME##_##I10,\
    NAME##_##I11 \
	,NAME##_NULL \
	}; \
	template <class Manip>\
	class NAME##_value_list { \
	public: \
	const NAME* obj;\
	const char* delim;\
	Manip manip;\
	public: \
	NAME##_value_list (const NAME* o, const char* d, Manip m) :\
	obj(o), delim(d), manip(m) { } \
	};\
	template <class Manip>\
	class NAME##_##field_list {\
	public: \
	const NAME* obj; \
	const char* delim;\
	Manip manip;\
	public: \
	NAME##_field_list (const NAME* o, const char* d, Manip m) :\
	obj(o), delim(d), manip(m) { } \
	};\
	template <class Manip>\
	class NAME##_equal_list { \
	public: \
	const NAME* obj;\
	const char* delim;\
	const char* comp;\
	Manip manip;\
	public: \
	NAME##_equal_list (const NAME* o, const char* d, const char* c, Manip m) :\
	obj(o), delim(d), comp(c), manip(m) { }\
	};\
	template <class Manip>\
	class NAME##_cus_value_list {\
	public:\
	const NAME* obj;\
	std::vector<bool> *include;\
	bool del_vector;\
	const char* delim;\
	Manip manip;\
	public: \
	~NAME##_cus_value_list () {if (del_vector) delete include;} \
	NAME##_cus_value_list (const NAME* o, const char* d, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11);\
	NAME##_cus_value_list (const NAME* o, const char* d, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11); \
	NAME##_cus_value_list (const NAME* o, const char* d, Manip m ,std::vector<bool>* i) :\
	obj(o), include(i), del_vector(false), delim(d), manip(m) { }\
	};\
	template <class Manip>\
	class NAME##_cus_field_list { \
	public:\
	const NAME* obj; \
	std::vector<bool> *include; \
	bool del_vector; \
	const char* delim;\
	Manip manip;\
	public: \
	~NAME##_cus_field_list () {if (del_vector) delete include;} \
	NAME##_cus_field_list (const NAME* o, const char* d, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11); \
	NAME##_cus_field_list (const NAME* o, const char* d, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11); \
	NAME##_cus_field_list (const NAME* o, const char* d, Manip m, std::vector<bool> *i) :\
	obj(o), include(i), del_vector(false), delim(d), manip(m) { }\
	};\
	template <class Manip>\
	class NAME##_cus_equal_list {\
	public:\
	const NAME* obj;\
	std::vector<bool> *include;\
	bool del_vector;\
	const char* delim;\
	const char* comp;\
	Manip manip;\
	public:\
	~NAME##_##cus_equal_list () {if (del_vector) delete include;}\
	NAME##_##cus_equal_list (const NAME* o, const char* d, const char* c, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11); \
	NAME##_##cus_equal_list (const NAME* o, const char* d, const char* c, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11); \
	NAME##_##cus_equal_list (const NAME* o, const char* d, const char* c, Manip m, std::vector<bool> *i) :\
	obj(o), include(i), del_vector(false), delim(d), comp(c), manip(m) { }\
	};\
	template <mysqlpp::sql_dummy_type dummy> int sql_compare_##NAME(const NAME&, const NAME&);\
	struct NAME {\
    T1 I1;\
    T2 I2;\
    T3 I3;\
    T4 I4;\
    T5 I5;\
    T6 I6;\
    T7 I7;\
    T8 I8;\
    T9 I9;\
    T10 I10;\
    T11 I11; \
	NAME() : table_override_(0) { }\
	NAME(const mysqlpp::Row& row);\
	void set(const mysqlpp::Row &row);\
	sql_compare_define_##CMP(NAME, T1, I1, T2, I2, T3, I3, T4, I4, T5, I5, T6, I6, T7, I7, T8, I8, T9, I9, T10, I10, T11, I11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)\
	sql_construct_define_##CONTR(NAME, T1, I1, T2, I2, T3, I3, T4, I4, T5, I5, T6, I6, T7, I7, T8, I8, T9, I9, T10, I10, T11, I11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)\
	static const char* names[];\
	static void table(const char* t) { table_ = t; }\
	const char* table() const\
			{ return table_override_ ? table_override_ : NAME::table_; }\
	void instance_table(const char* t) { table_override_ = t; }\
	NAME##_value_list<mysqlpp::quote_type0> value_list() const {\
		return value_list(",", mysqlpp::quote);}\
	NAME##_value_list<mysqlpp::quote_type0> value_list(const char* d) const {\
		return value_list(d, mysqlpp::quote);}\
	template <class Manip>\
	NAME##_value_list<Manip> value_list(const char* d, Manip m) const;\
	NAME##_field_list<mysqlpp::do_nothing_type0> field_list() const {\
		return field_list(",", mysqlpp::do_nothing);}\
	NAME##_field_list<mysqlpp::do_nothing_type0> field_list(const char* d) const {\
		return field_list(d, mysqlpp::do_nothing);}\
	template <class Manip>\
	NAME##_field_list<Manip> field_list(const char* d, Manip m) const;\
	NAME##_equal_list<mysqlpp::quote_type0> equal_list(const char* d = ",",\
			const char* c = " = ") const\
			{ return equal_list(d, c, mysqlpp::quote); }\
	template <class Manip>\
	NAME##_equal_list<Manip> equal_list(const char* d, const char* c, Manip m) const;\
	/* cus_data */\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false) const\
			{ return value_list(",", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL) const\
			{ return value_list(",", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(std::vector<bool> *i) const\
			{ return value_list(",", mysqlpp::quote, i); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(mysqlpp::sql_cmp_type sc) const\
			{ return value_list(",", mysqlpp::quote, sc); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(const char* d, bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false) const\
			{ return value_list(d, mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(const char* d, NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL) const\
			{ return value_list(d, mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(const char* d,\
			std::vector<bool> *i) const\
			{ return value_list(d, mysqlpp::quote, i); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(const char* d,\
			mysqlpp::sql_cmp_type sc) const\
			{ return value_list(d, mysqlpp::quote, sc); }\
	template <class Manip>\
	NAME##_cus_value_list<Manip> value_list(const char* d, Manip m,\
			bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false) const;\
	template <class Manip>\
	NAME##_cus_value_list<Manip> value_list(const char* d, Manip m,\
			NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL) const;\
	template <class Manip>\
	NAME##_cus_value_list<Manip> value_list(const char* d, Manip m,\
			std::vector<bool>* i) const;\
	template <class Manip>\
	NAME##_cus_value_list<Manip> value_list(const char* d, Manip m, \
			mysqlpp::sql_cmp_type sc) const;\
	/* cus field */\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false) const \
			{ return field_list(",", mysqlpp::do_nothing, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL) const\
			{ return field_list(",", mysqlpp::do_nothing, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(std::vector<bool> *i) const\
			{ return field_list(",", mysqlpp::do_nothing, i); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(mysqlpp::sql_cmp_type sc) const\
			{ return field_list(",", mysqlpp::do_nothing, sc); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(const char* d,\
			bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false) const\
			{ return field_list(d, mysqlpp::do_nothing, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(const char* d,\
			NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL) const\
			{ return field_list(d, mysqlpp::do_nothing, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(const char* d,\
			std::vector<bool>* i) const\
			{ return field_list(d, mysqlpp::do_nothing, i); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(const char* d,\
			mysqlpp::sql_cmp_type sc) const\
			{ return field_list(d, mysqlpp::do_nothing, sc); }\
	template <class Manip>\
	NAME##_cus_field_list<Manip> field_list(const char* d, Manip m,\
			bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false) const;\
	template <class Manip>\
	NAME##_cus_field_list<Manip> field_list(const char* d, Manip m,\
			NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL) const;\
	template <class Manip>\
	NAME##_cus_field_list<Manip> field_list(const char* d, Manip m,\
			std::vector<bool> *i) const;\
	template <class Manip>\
	NAME##_cus_field_list<Manip> field_list(const char* d, Manip m,\
			mysqlpp::sql_cmp_type sc) const;\
	/* cus equal */\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false) const\
			{ return equal_list(",", " = ", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL) const\
			{ return equal_list(",", " = ", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(std::vector<bool>* i) const\
			{ return equal_list(",", " = ", mysqlpp::quote, i); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(mysqlpp::sql_cmp_type sc) const\
			{ return equal_list(",", " = ", mysqlpp::quote, sc); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false) const\
			{ return equal_list(d, " = ", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL) const\
			{ return equal_list(d, " = ", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d,\
			std::vector<bool> *i) const\
			{ return equal_list(d, " = ", mysqlpp::quote, i); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d,\
			mysqlpp::sql_cmp_type sc) const\
			{ return equal_list(d, " = ", mysqlpp::quote, sc); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, const char* c,\
			bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false) const\
			{ return equal_list(d, c, mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, const char* c,\
			NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL) const\
			{ return equal_list(d, c, mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, const char* c,\
			std::vector<bool> *i) const\
			{ return equal_list(d, c, mysqlpp::quote, i); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, const char* c,\
			mysqlpp::sql_cmp_type sc) const\
			{ return equal_list(d, c, mysqlpp::quote, sc); }\
	template <class Manip>\
	NAME##_cus_equal_list<Manip> equal_list(const char* d, const char* c, Manip m, \
						bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false) const;\
	template <class Manip>\
	NAME##_cus_equal_list<Manip> equal_list(const char* d, const char* c, Manip m, \
						NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL) const;\
	template <class Manip>\
	NAME##_cus_equal_list<Manip> equal_list(const char* d, const char* c, Manip m, \
						std::vector<bool> *i) const;\
	template <class Manip>\
	NAME##_cus_equal_list<Manip> equal_list(const char* d, const char* c, Manip m, \
						mysqlpp::sql_cmp_type sc) const;\
	private:\
	static const char* table_;\
	const char* table_override_;\
	};\
	MYSQLPP_SSQLS_CONDITIONAL_STATICS(\
		const char* NAME::names[] = {\
			    N1 ,\
    N2 ,\
    N3 ,\
    N4 ,\
    N5 ,\
    N6 ,\
    N7 ,\
    N8 ,\
    N9 ,\
    N10 ,\
    N11 \
		};\
		const char* NAME::table_ = #NAME;\
	)\
	template <class Manip>\
	NAME##_cus_value_list<Manip>::NAME##_cus_value_list\
			(const NAME* o, const char* d, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11)\
	{\
		delim = d;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(11, false);\
    if (i1) (*include)[0]=true;\
    if (i2) (*include)[1]=true;\
    if (i3) (*include)[2]=true;\
    if (i4) (*include)[3]=true;\
    if (i5) (*include)[4]=true;\
    if (i6) (*include)[5]=true;\
    if (i7) (*include)[6]=true;\
    if (i8) (*include)[7]=true;\
    if (i9) (*include)[8]=true;\
    if (i10) (*include)[9]=true;\
    if (i11) (*include)[10]=true;\
	}\
	template <class Manip>\
	NAME##_cus_value_list<Manip>::NAME##_cus_value_list\
			(const NAME* o, const char* d, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11)\
	{\
		delim = d;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(11, false);\
    if (i1 == NAME##_NULL) return;\
    (*include)[i1]=true;\
    if (i2 == NAME##_NULL) return;\
    (*include)[i2]=true;\
    if (i3 == NAME##_NULL) return;\
    (*include)[i3]=true;\
    if (i4 == NAME##_NULL) return;\
    (*include)[i4]=true;\
    if (i5 == NAME##_NULL) return;\
    (*include)[i5]=true;\
    if (i6 == NAME##_NULL) return;\
    (*include)[i6]=true;\
    if (i7 == NAME##_NULL) return;\
    (*include)[i7]=true;\
    if (i8 == NAME##_NULL) return;\
    (*include)[i8]=true;\
    if (i9 == NAME##_NULL) return;\
    (*include)[i9]=true;\
    if (i10 == NAME##_NULL) return;\
    (*include)[i10]=true;\
    if (i11 == NAME##_NULL) return;\
    (*include)[i11]=true;\
	}\
	template <class Manip>\
	NAME##_cus_field_list<Manip>::NAME##_cus_field_list\
			(const NAME* o, const char* d, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11)\
	{\
		delim = d;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(11, false);\
    if (i1) (*include)[0]=true;\
    if (i2) (*include)[1]=true;\
    if (i3) (*include)[2]=true;\
    if (i4) (*include)[3]=true;\
    if (i5) (*include)[4]=true;\
    if (i6) (*include)[5]=true;\
    if (i7) (*include)[6]=true;\
    if (i8) (*include)[7]=true;\
    if (i9) (*include)[8]=true;\
    if (i10) (*include)[9]=true;\
    if (i11) (*include)[10]=true;\
	}\
	template <class Manip>\
	NAME##_cus_field_list<Manip>::NAME##_cus_field_list\
			(const NAME* o, const char* d, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11)\
	{\
		delim = d;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(11, false);\
    if (i1 == NAME##_NULL) return;\
    (*include)[i1]=true;\
    if (i2 == NAME##_NULL) return;\
    (*include)[i2]=true;\
    if (i3 == NAME##_NULL) return;\
    (*include)[i3]=true;\
    if (i4 == NAME##_NULL) return;\
    (*include)[i4]=true;\
    if (i5 == NAME##_NULL) return;\
    (*include)[i5]=true;\
    if (i6 == NAME##_NULL) return;\
    (*include)[i6]=true;\
    if (i7 == NAME##_NULL) return;\
    (*include)[i7]=true;\
    if (i8 == NAME##_NULL) return;\
    (*include)[i8]=true;\
    if (i9 == NAME##_NULL) return;\
    (*include)[i9]=true;\
    if (i10 == NAME##_NULL) return;\
    (*include)[i10]=true;\
    if (i11 == NAME##_NULL) return;\
    (*include)[i11]=true;\
	}\
	template <class Manip>\
	NAME##_cus_equal_list<Manip>::NAME##_cus_equal_list\
			(const NAME* o, const char* d, const char* c, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11)\
	{\
		delim = d;\
		comp = c;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(11, false);\
    if (i1) (*include)[0]=true;\
    if (i2) (*include)[1]=true;\
    if (i3) (*include)[2]=true;\
    if (i4) (*include)[3]=true;\
    if (i5) (*include)[4]=true;\
    if (i6) (*include)[5]=true;\
    if (i7) (*include)[6]=true;\
    if (i8) (*include)[7]=true;\
    if (i9) (*include)[8]=true;\
    if (i10) (*include)[9]=true;\
    if (i11) (*include)[10]=true;\
	}\
	template <class Manip>\
	NAME##_cus_equal_list<Manip>::NAME##_cus_equal_list\
			(const NAME* o, const char* d, const char* c, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11)\
	{\
		delim = d;\
		comp = c;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(11, false);\
    if (i1 == NAME##_NULL) return;\
    (*include)[i1]=true;\
    if (i2 == NAME##_NULL) return;\
    (*include)[i2]=true;\
    if (i3 == NAME##_NULL) return;\
    (*include)[i3]=true;\
    if (i4 == NAME##_NULL) return;\
    (*include)[i4]=true;\
    if (i5 == NAME##_NULL) return;\
    (*include)[i5]=true;\
    if (i6 == NAME##_NULL) return;\
    (*include)[i6]=true;\
    if (i7 == NAME##_NULL) return;\
    (*include)[i7]=true;\
    if (i8 == NAME##_NULL) return;\
    (*include)[i8]=true;\
    if (i9 == NAME##_NULL) return;\
    (*include)[i9]=true;\
    if (i10 == NAME##_NULL) return;\
    (*include)[i10]=true;\
    if (i11 == NAME##_NULL) return;\
    (*include)[i11]=true;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_value_list<Manip>& obj)\
	{\
    s << obj.manip << obj.obj->I1 << obj.delim;\
    s << obj.manip << obj.obj->I2 << obj.delim;\
    s << obj.manip << obj.obj->I3 << obj.delim;\
    s << obj.manip << obj.obj->I4 << obj.delim;\
    s << obj.manip << obj.obj->I5 << obj.delim;\
    s << obj.manip << obj.obj->I6 << obj.delim;\
    s << obj.manip << obj.obj->I7 << obj.delim;\
    s << obj.manip << obj.obj->I8 << obj.delim;\
    s << obj.manip << obj.obj->I9 << obj.delim;\
    s << obj.manip << obj.obj->I10 << obj.delim;\
    s << obj.manip << obj.obj->I11;\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_field_list<Manip>& obj)\
	{\
    s << obj.manip << '`' << obj.obj->names[0] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[1] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[2] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[3] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[4] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[5] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[6] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[7] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[8] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[9] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[10] << '`';\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_equal_list<Manip>& obj)\
	{\
    s << '`' << obj.obj->names[0] << '`' << obj.comp << obj.manip << obj.obj->I1 << obj.delim;\
    s << '`' << obj.obj->names[1] << '`' << obj.comp << obj.manip << obj.obj->I2 << obj.delim;\
    s << '`' << obj.obj->names[2] << '`' << obj.comp << obj.manip << obj.obj->I3 << obj.delim;\
    s << '`' << obj.obj->names[3] << '`' << obj.comp << obj.manip << obj.obj->I4 << obj.delim;\
    s << '`' << obj.obj->names[4] << '`' << obj.comp << obj.manip << obj.obj->I5 << obj.delim;\
    s << '`' << obj.obj->names[5] << '`' << obj.comp << obj.manip << obj.obj->I6 << obj.delim;\
    s << '`' << obj.obj->names[6] << '`' << obj.comp << obj.manip << obj.obj->I7 << obj.delim;\
    s << '`' << obj.obj->names[7] << '`' << obj.comp << obj.manip << obj.obj->I8 << obj.delim;\
    s << '`' << obj.obj->names[8] << '`' << obj.comp << obj.manip << obj.obj->I9 << obj.delim;\
    s << '`' << obj.obj->names[9] << '`' << obj.comp << obj.manip << obj.obj->I10 << obj.delim;\
    s << '`' << obj.obj->names[10] << '`' << obj.comp << obj.manip << obj.obj->I11;\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_cus_value_list<Manip>& obj)\
	{\
		bool before = false;\
    if ((*obj.include)[0]) { \
      s << obj.manip << obj.obj->I1;\
      before = true; \
     } \
    if ((*obj.include)[1]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I2;\
      before = true; \
     } \
    if ((*obj.include)[2]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I3;\
      before = true; \
     } \
    if ((*obj.include)[3]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I4;\
      before = true; \
     } \
    if ((*obj.include)[4]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I5;\
      before = true; \
     } \
    if ((*obj.include)[5]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I6;\
      before = true; \
     } \
    if ((*obj.include)[6]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I7;\
      before = true; \
     } \
    if ((*obj.include)[7]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I8;\
      before = true; \
     } \
    if ((*obj.include)[8]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I9;\
      before = true; \
     } \
    if ((*obj.include)[9]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I10;\
      before = true; \
     } \
    if ((*obj.include)[10]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I11;\
     } \
        (void)before;\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_cus_field_list<Manip>& obj)\
	{\
		bool before = false;\
    if ((*obj.include)[0]) { \
      s << obj.manip << '`' << obj.obj->names[0] << '`';\
      before = true; \
     } \
    if ((*obj.include)[1]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[1] << '`';\
      before = true; \
     } \
    if ((*obj.include)[2]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[2] << '`';\
      before = true; \
     } \
    if ((*obj.include)[3]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[3] << '`';\
      before = true; \
     } \
    if ((*obj.include)[4]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[4] << '`';\
      before = true; \
     } \
    if ((*obj.include)[5]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[5] << '`';\
      before = true; \
     } \
    if ((*obj.include)[6]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[6] << '`';\
      before = true; \
     } \
    if ((*obj.include)[7]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[7] << '`';\
      before = true; \
     } \
    if ((*obj.include)[8]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[8] << '`';\
      before = true; \
     } \
    if ((*obj.include)[9]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[9] << '`';\
      before = true; \
     } \
    if ((*obj.include)[10]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[10] << '`';\
     } \
        (void)before;\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_cus_equal_list<Manip>& obj)\
	{\
		bool before = false;\
    if ((*obj.include)[0]) { \
      s << '`' << obj.obj->names[0] << '`' << obj.comp << obj.manip << obj.obj->I1;\
      before = true; \
     } \
    if ((*obj.include)[1]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[1] << '`' << obj.comp << obj.manip << obj.obj->I2;\
      before = true; \
     } \
    if ((*obj.include)[2]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[2] << '`' << obj.comp << obj.manip << obj.obj->I3;\
      before = true; \
     } \
    if ((*obj.include)[3]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[3] << '`' << obj.comp << obj.manip << obj.obj->I4;\
      before = true; \
     } \
    if ((*obj.include)[4]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[4] << '`' << obj.comp << obj.manip << obj.obj->I5;\
      before = true; \
     } \
    if ((*obj.include)[5]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[5] << '`' << obj.comp << obj.manip << obj.obj->I6;\
      before = true; \
     } \
    if ((*obj.include)[6]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[6] << '`' << obj.comp << obj.manip << obj.obj->I7;\
      before = true; \
     } \
    if ((*obj.include)[7]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[7] << '`' << obj.comp << obj.manip << obj.obj->I8;\
      before = true; \
     } \
    if ((*obj.include)[8]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[8] << '`' << obj.comp << obj.manip << obj.obj->I9;\
      before = true; \
     } \
    if ((*obj.include)[9]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[9] << '`' << obj.comp << obj.manip << obj.obj->I10;\
      before = true; \
     } \
    if ((*obj.include)[10]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[10] << '`' << obj.comp << obj.manip << obj.obj->I11;\
     } \
        (void)before;\
		return s;\
	}\
	template <class Manip>\
	inline NAME##_value_list<Manip> NAME::value_list(const char* d, Manip m) const\
			{ return NAME##_value_list<Manip> (this, d, m); } \
	template <class Manip>\
	inline NAME##_field_list<Manip> NAME::field_list(const char* d, Manip m) const\
			{ return NAME##_field_list<Manip> (this, d, m); } \
	template <class Manip>\
	inline NAME##_equal_list<Manip> NAME::equal_list(const char* d, const char* c, Manip m) const\
			{ return NAME##_equal_list<Manip> (this, d, c, m); } \
	template <class Manip>\
	inline NAME##_cus_value_list<Manip> NAME::value_list(const char* d, Manip m,\
			bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11) const\
			{ return NAME##_cus_value_list<Manip> (this, d, m, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11); }\
	template <class Manip>\
	inline NAME##_cus_field_list<Manip> NAME::field_list(const char* d, Manip m,\
			bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11) const\
			{ return NAME##_cus_field_list<Manip> (this, d, m, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11); }\
	template <class Manip>\
	inline NAME##_cus_equal_list<Manip> NAME::equal_list(const char* d, const char* c, Manip m,\
			bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11) const\
			{ return NAME##_cus_equal_list<Manip> (this, d, c, m, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11); } \
	template <class Manip>\
	inline NAME##_cus_value_list<Manip> NAME::value_list(const char* d, Manip m,\
			NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11) const\
			{ return NAME##_cus_value_list<Manip> (this, d, m, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11); } \
	template <class Manip>\
	inline NAME##_cus_field_list<Manip> NAME::field_list(const char* d, Manip m,\
			NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11) const\
			{ return NAME##_cus_field_list<Manip> (this, d, m, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11); } \
	template <class Manip>\
	inline NAME##_cus_equal_list<Manip> NAME::equal_list(const char* d, const char* c, Manip m, \
			NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11) const\
			{ return NAME##_cus_equal_list<Manip> (this, d, c, m, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11); } \
	template <class Manip>\
	inline NAME##_cus_value_list<Manip> NAME::value_list(const char* d, Manip m,\
			std::vector<bool> *i) const\
			{ return NAME##_cus_value_list<Manip> (this, d, m, i); }\
	template <class Manip>\
	inline NAME##_cus_field_list<Manip> NAME::field_list(const char* d, Manip m,\
			std::vector<bool> *i) const\
			{ return NAME##_cus_field_list<Manip> (this, d, m, i); }\
	template <class Manip>\
	inline NAME##_cus_equal_list<Manip> NAME::equal_list(const char* d, const char* c, Manip m,\
			std::vector<bool> *i) const\
			{ return NAME##_cus_equal_list<Manip> (this, d, c, m, i); }\
	template <class Manip>\
	inline NAME##_cus_value_list<Manip> \
	NAME::value_list(const char* d, Manip m, mysqlpp::sql_cmp_type /*sc*/) const\
			{ sql_compare_type_def_##CMP(NAME, value, NUM); }\
	template <class Manip>\
	inline NAME##_cus_field_list<Manip> \
	NAME::field_list(const char* d, Manip m, mysqlpp::sql_cmp_type /*sc*/) const\
			{ sql_compare_type_def_##CMP(NAME, field, NUM); }\
	template <class Manip>\
	inline NAME##_cus_equal_list<Manip> \
	NAME::equal_list(const char* d, const char* c, Manip m, mysqlpp::sql_cmp_type /*sc*/) const\
			{ sql_compare_type_defe_##CMP(NAME, equal, NUM); }\
	template <mysqlpp::sql_dummy_type dummy>\
	void populate_##NAME(NAME *s, const mysqlpp::Row &row)\
	{\
		mysqlpp::NoExceptions ignore_schema_mismatches(row);\
    s->I1 = row[N1].conv(T1());\
    s->I2 = row[N2].conv(T2());\
    s->I3 = row[N3].conv(T3());\
    s->I4 = row[N4].conv(T4());\
    s->I5 = row[N5].conv(T5());\
    s->I6 = row[N6].conv(T6());\
    s->I7 = row[N7].conv(T7());\
    s->I8 = row[N8].conv(T8());\
    s->I9 = row[N9].conv(T9());\
    s->I10 = row[N10].conv(T10());\
    s->I11 = row[N11].conv(T11());\
	}\
	inline NAME::NAME(const mysqlpp::Row& row) :\
	table_override_(0)\
			{ populate_##NAME<mysqlpp::sql_dummy>(this, row); }\
	inline void NAME::set(const mysqlpp::Row& row)\
	{\
		table_override_ = 0;\
		populate_##NAME<mysqlpp::sql_dummy>(this, row);\
	}\
	sql_COMPARE__##CMP(NAME, I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 )

#define sql_create_11(NAME, CMP, CONTR, T1, I1, T2, I2, T3, I3, T4, I4, T5, I5, T6, I6, T7, I7, T8, I8, T9, I9, T10, I10, T11, I11) \
		sql_create_complete_11(NAME, CMP, CONTR, T1, I1, #I1, T2, I2, #I2, T3, I3, #I3, T4, I4, #I4, T5, I5, #I5, T6, I6, #I6, T7, I7, #I7, T8, I8, #I8, T9, I9, #I9, T10, I10, #I10, T11, I11, #I11) \

// ---------------------------------------------------
//                  End Create 11
// ---------------------------------------------------

// ---------------------------------------------------
//                  Begin Create 12
// ---------------------------------------------------
#define sql_create_complete_12(NAME, CMP, CONTR, T1, I1, N1, T2, I2, N2, T3, I3, N3, T4, I4, N4, T5, I5, N5, T6, I6, N6, T7, I7, N7, T8, I8, N8, T9, I9, N9, T10, I10, N10, T11, I11, N11, T12, I12, N12) \
	struct NAME; \
	enum NAME##_enum { \
    NAME##_##I1,\
    NAME##_##I2,\
    NAME##_##I3,\
    NAME##_##I4,\
    NAME##_##I5,\
    NAME##_##I6,\
    NAME##_##I7,\
    NAME##_##I8,\
    NAME##_##I9,\
    NAME##_##I10,\
    NAME##_##I11,\
    NAME##_##I12 \
	,NAME##_NULL \
	}; \
	template <class Manip>\
	class NAME##_value_list { \
	public: \
	const NAME* obj;\
	const char* delim;\
	Manip manip;\
	public: \
	NAME##_value_list (const NAME* o, const char* d, Manip m) :\
	obj(o), delim(d), manip(m) { } \
	};\
	template <class Manip>\
	class NAME##_##field_list {\
	public: \
	const NAME* obj; \
	const char* delim;\
	Manip manip;\
	public: \
	NAME##_field_list (const NAME* o, const char* d, Manip m) :\
	obj(o), delim(d), manip(m) { } \
	};\
	template <class Manip>\
	class NAME##_equal_list { \
	public: \
	const NAME* obj;\
	const char* delim;\
	const char* comp;\
	Manip manip;\
	public: \
	NAME##_equal_list (const NAME* o, const char* d, const char* c, Manip m) :\
	obj(o), delim(d), comp(c), manip(m) { }\
	};\
	template <class Manip>\
	class NAME##_cus_value_list {\
	public:\
	const NAME* obj;\
	std::vector<bool> *include;\
	bool del_vector;\
	const char* delim;\
	Manip manip;\
	public: \
	~NAME##_cus_value_list () {if (del_vector) delete include;} \
	NAME##_cus_value_list (const NAME* o, const char* d, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12);\
	NAME##_cus_value_list (const NAME* o, const char* d, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12); \
	NAME##_cus_value_list (const NAME* o, const char* d, Manip m ,std::vector<bool>* i) :\
	obj(o), include(i), del_vector(false), delim(d), manip(m) { }\
	};\
	template <class Manip>\
	class NAME##_cus_field_list { \
	public:\
	const NAME* obj; \
	std::vector<bool> *include; \
	bool del_vector; \
	const char* delim;\
	Manip manip;\
	public: \
	~NAME##_cus_field_list () {if (del_vector) delete include;} \
	NAME##_cus_field_list (const NAME* o, const char* d, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12); \
	NAME##_cus_field_list (const NAME* o, const char* d, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12); \
	NAME##_cus_field_list (const NAME* o, const char* d, Manip m, std::vector<bool> *i) :\
	obj(o), include(i), del_vector(false), delim(d), manip(m) { }\
	};\
	template <class Manip>\
	class NAME##_cus_equal_list {\
	public:\
	const NAME* obj;\
	std::vector<bool> *include;\
	bool del_vector;\
	const char* delim;\
	const char* comp;\
	Manip manip;\
	public:\
	~NAME##_##cus_equal_list () {if (del_vector) delete include;}\
	NAME##_##cus_equal_list (const NAME* o, const char* d, const char* c, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12); \
	NAME##_##cus_equal_list (const NAME* o, const char* d, const char* c, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12); \
	NAME##_##cus_equal_list (const NAME* o, const char* d, const char* c, Manip m, std::vector<bool> *i) :\
	obj(o), include(i), del_vector(false), delim(d), comp(c), manip(m) { }\
	};\
	template <mysqlpp::sql_dummy_type dummy> int sql_compare_##NAME(const NAME&, const NAME&);\
	struct NAME {\
    T1 I1;\
    T2 I2;\
    T3 I3;\
    T4 I4;\
    T5 I5;\
    T6 I6;\
    T7 I7;\
    T8 I8;\
    T9 I9;\
    T10 I10;\
    T11 I11;\
    T12 I12; \
	NAME() : table_override_(0) { }\
	NAME(const mysqlpp::Row& row);\
	void set(const mysqlpp::Row &row);\
	sql_compare_define_##CMP(NAME, T1, I1, T2, I2, T3, I3, T4, I4, T5, I5, T6, I6, T7, I7, T8, I8, T9, I9, T10, I10, T11, I11, T12, I12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)\
	sql_construct_define_##CONTR(NAME, T1, I1, T2, I2, T3, I3, T4, I4, T5, I5, T6, I6, T7, I7, T8, I8, T9, I9, T10, I10, T11, I11, T12, I12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)\
	static const char* names[];\
	static void table(const char* t) { table_ = t; }\
	const char* table() const\
			{ return table_override_ ? table_override_ : NAME::table_; }\
	void instance_table(const char* t) { table_override_ = t; }\
	NAME##_value_list<mysqlpp::quote_type0> value_list() const {\
		return value_list(",", mysqlpp::quote);}\
	NAME##_value_list<mysqlpp::quote_type0> value_list(const char* d) const {\
		return value_list(d, mysqlpp::quote);}\
	template <class Manip>\
	NAME##_value_list<Manip> value_list(const char* d, Manip m) const;\
	NAME##_field_list<mysqlpp::do_nothing_type0> field_list() const {\
		return field_list(",", mysqlpp::do_nothing);}\
	NAME##_field_list<mysqlpp::do_nothing_type0> field_list(const char* d) const {\
		return field_list(d, mysqlpp::do_nothing);}\
	template <class Manip>\
	NAME##_field_list<Manip> field_list(const char* d, Manip m) const;\
	NAME##_equal_list<mysqlpp::quote_type0> equal_list(const char* d = ",",\
			const char* c = " = ") const\
			{ return equal_list(d, c, mysqlpp::quote); }\
	template <class Manip>\
	NAME##_equal_list<Manip> equal_list(const char* d, const char* c, Manip m) const;\
	/* cus_data */\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false) const\
			{ return value_list(",", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL) const\
			{ return value_list(",", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(std::vector<bool> *i) const\
			{ return value_list(",", mysqlpp::quote, i); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(mysqlpp::sql_cmp_type sc) const\
			{ return value_list(",", mysqlpp::quote, sc); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(const char* d, bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false) const\
			{ return value_list(d, mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(const char* d, NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL) const\
			{ return value_list(d, mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(const char* d,\
			std::vector<bool> *i) const\
			{ return value_list(d, mysqlpp::quote, i); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(const char* d,\
			mysqlpp::sql_cmp_type sc) const\
			{ return value_list(d, mysqlpp::quote, sc); }\
	template <class Manip>\
	NAME##_cus_value_list<Manip> value_list(const char* d, Manip m,\
			bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false) const;\
	template <class Manip>\
	NAME##_cus_value_list<Manip> value_list(const char* d, Manip m,\
			NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL) const;\
	template <class Manip>\
	NAME##_cus_value_list<Manip> value_list(const char* d, Manip m,\
			std::vector<bool>* i) const;\
	template <class Manip>\
	NAME##_cus_value_list<Manip> value_list(const char* d, Manip m, \
			mysqlpp::sql_cmp_type sc) const;\
	/* cus field */\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false) const \
			{ return field_list(",", mysqlpp::do_nothing, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL) const\
			{ return field_list(",", mysqlpp::do_nothing, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(std::vector<bool> *i) const\
			{ return field_list(",", mysqlpp::do_nothing, i); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(mysqlpp::sql_cmp_type sc) const\
			{ return field_list(",", mysqlpp::do_nothing, sc); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(const char* d,\
			bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false) const\
			{ return field_list(d, mysqlpp::do_nothing, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(const char* d,\
			NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL) const\
			{ return field_list(d, mysqlpp::do_nothing, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(const char* d,\
			std::vector<bool>* i) const\
			{ return field_list(d, mysqlpp::do_nothing, i); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(const char* d,\
			mysqlpp::sql_cmp_type sc) const\
			{ return field_list(d, mysqlpp::do_nothing, sc); }\
	template <class Manip>\
	NAME##_cus_field_list<Manip> field_list(const char* d, Manip m,\
			bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false) const;\
	template <class Manip>\
	NAME##_cus_field_list<Manip> field_list(const char* d, Manip m,\
			NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL) const;\
	template <class Manip>\
	NAME##_cus_field_list<Manip> field_list(const char* d, Manip m,\
			std::vector<bool> *i) const;\
	template <class Manip>\
	NAME##_cus_field_list<Manip> field_list(const char* d, Manip m,\
			mysqlpp::sql_cmp_type sc) const;\
	/* cus equal */\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false) const\
			{ return equal_list(",", " = ", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL) const\
			{ return equal_list(",", " = ", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(std::vector<bool>* i) const\
			{ return equal_list(",", " = ", mysqlpp::quote, i); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(mysqlpp::sql_cmp_type sc) const\
			{ return equal_list(",", " = ", mysqlpp::quote, sc); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false) const\
			{ return equal_list(d, " = ", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL) const\
			{ return equal_list(d, " = ", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d,\
			std::vector<bool> *i) const\
			{ return equal_list(d, " = ", mysqlpp::quote, i); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d,\
			mysqlpp::sql_cmp_type sc) const\
			{ return equal_list(d, " = ", mysqlpp::quote, sc); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, const char* c,\
			bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false) const\
			{ return equal_list(d, c, mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, const char* c,\
			NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL) const\
			{ return equal_list(d, c, mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, const char* c,\
			std::vector<bool> *i) const\
			{ return equal_list(d, c, mysqlpp::quote, i); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, const char* c,\
			mysqlpp::sql_cmp_type sc) const\
			{ return equal_list(d, c, mysqlpp::quote, sc); }\
	template <class Manip>\
	NAME##_cus_equal_list<Manip> equal_list(const char* d, const char* c, Manip m, \
						bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false) const;\
	template <class Manip>\
	NAME##_cus_equal_list<Manip> equal_list(const char* d, const char* c, Manip m, \
						NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL) const;\
	template <class Manip>\
	NAME##_cus_equal_list<Manip> equal_list(const char* d, const char* c, Manip m, \
						std::vector<bool> *i) const;\
	template <class Manip>\
	NAME##_cus_equal_list<Manip> equal_list(const char* d, const char* c, Manip m, \
						mysqlpp::sql_cmp_type sc) const;\
	private:\
	static const char* table_;\
	const char* table_override_;\
	};\
	MYSQLPP_SSQLS_CONDITIONAL_STATICS(\
		const char* NAME::names[] = {\
			    N1 ,\
    N2 ,\
    N3 ,\
    N4 ,\
    N5 ,\
    N6 ,\
    N7 ,\
    N8 ,\
    N9 ,\
    N10 ,\
    N11 ,\
    N12 \
		};\
		const char* NAME::table_ = #NAME;\
	)\
	template <class Manip>\
	NAME##_cus_value_list<Manip>::NAME##_cus_value_list\
			(const NAME* o, const char* d, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12)\
	{\
		delim = d;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(12, false);\
    if (i1) (*include)[0]=true;\
    if (i2) (*include)[1]=true;\
    if (i3) (*include)[2]=true;\
    if (i4) (*include)[3]=true;\
    if (i5) (*include)[4]=true;\
    if (i6) (*include)[5]=true;\
    if (i7) (*include)[6]=true;\
    if (i8) (*include)[7]=true;\
    if (i9) (*include)[8]=true;\
    if (i10) (*include)[9]=true;\
    if (i11) (*include)[10]=true;\
    if (i12) (*include)[11]=true;\
	}\
	template <class Manip>\
	NAME##_cus_value_list<Manip>::NAME##_cus_value_list\
			(const NAME* o, const char* d, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12)\
	{\
		delim = d;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(12, false);\
    if (i1 == NAME##_NULL) return;\
    (*include)[i1]=true;\
    if (i2 == NAME##_NULL) return;\
    (*include)[i2]=true;\
    if (i3 == NAME##_NULL) return;\
    (*include)[i3]=true;\
    if (i4 == NAME##_NULL) return;\
    (*include)[i4]=true;\
    if (i5 == NAME##_NULL) return;\
    (*include)[i5]=true;\
    if (i6 == NAME##_NULL) return;\
    (*include)[i6]=true;\
    if (i7 == NAME##_NULL) return;\
    (*include)[i7]=true;\
    if (i8 == NAME##_NULL) return;\
    (*include)[i8]=true;\
    if (i9 == NAME##_NULL) return;\
    (*include)[i9]=true;\
    if (i10 == NAME##_NULL) return;\
    (*include)[i10]=true;\
    if (i11 == NAME##_NULL) return;\
    (*include)[i11]=true;\
    if (i12 == NAME##_NULL) return;\
    (*include)[i12]=true;\
	}\
	template <class Manip>\
	NAME##_cus_field_list<Manip>::NAME##_cus_field_list\
			(const NAME* o, const char* d, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12)\
	{\
		delim = d;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(12, false);\
    if (i1) (*include)[0]=true;\
    if (i2) (*include)[1]=true;\
    if (i3) (*include)[2]=true;\
    if (i4) (*include)[3]=true;\
    if (i5) (*include)[4]=true;\
    if (i6) (*include)[5]=true;\
    if (i7) (*include)[6]=true;\
    if (i8) (*include)[7]=true;\
    if (i9) (*include)[8]=true;\
    if (i10) (*include)[9]=true;\
    if (i11) (*include)[10]=true;\
    if (i12) (*include)[11]=true;\
	}\
	template <class Manip>\
	NAME##_cus_field_list<Manip>::NAME##_cus_field_list\
			(const NAME* o, const char* d, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12)\
	{\
		delim = d;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(12, false);\
    if (i1 == NAME##_NULL) return;\
    (*include)[i1]=true;\
    if (i2 == NAME##_NULL) return;\
    (*include)[i2]=true;\
    if (i3 == NAME##_NULL) return;\
    (*include)[i3]=true;\
    if (i4 == NAME##_NULL) return;\
    (*include)[i4]=true;\
    if (i5 == NAME##_NULL) return;\
    (*include)[i5]=true;\
    if (i6 == NAME##_NULL) return;\
    (*include)[i6]=true;\
    if (i7 == NAME##_NULL) return;\
    (*include)[i7]=true;\
    if (i8 == NAME##_NULL) return;\
    (*include)[i8]=true;\
    if (i9 == NAME##_NULL) return;\
    (*include)[i9]=true;\
    if (i10 == NAME##_NULL) return;\
    (*include)[i10]=true;\
    if (i11 == NAME##_NULL) return;\
    (*include)[i11]=true;\
    if (i12 == NAME##_NULL) return;\
    (*include)[i12]=true;\
	}\
	template <class Manip>\
	NAME##_cus_equal_list<Manip>::NAME##_cus_equal_list\
			(const NAME* o, const char* d, const char* c, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12)\
	{\
		delim = d;\
		comp = c;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(12, false);\
    if (i1) (*include)[0]=true;\
    if (i2) (*include)[1]=true;\
    if (i3) (*include)[2]=true;\
    if (i4) (*include)[3]=true;\
    if (i5) (*include)[4]=true;\
    if (i6) (*include)[5]=true;\
    if (i7) (*include)[6]=true;\
    if (i8) (*include)[7]=true;\
    if (i9) (*include)[8]=true;\
    if (i10) (*include)[9]=true;\
    if (i11) (*include)[10]=true;\
    if (i12) (*include)[11]=true;\
	}\
	template <class Manip>\
	NAME##_cus_equal_list<Manip>::NAME##_cus_equal_list\
			(const NAME* o, const char* d, const char* c, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12)\
	{\
		delim = d;\
		comp = c;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(12, false);\
    if (i1 == NAME##_NULL) return;\
    (*include)[i1]=true;\
    if (i2 == NAME##_NULL) return;\
    (*include)[i2]=true;\
    if (i3 == NAME##_NULL) return;\
    (*include)[i3]=true;\
    if (i4 == NAME##_NULL) return;\
    (*include)[i4]=true;\
    if (i5 == NAME##_NULL) return;\
    (*include)[i5]=true;\
    if (i6 == NAME##_NULL) return;\
    (*include)[i6]=true;\
    if (i7 == NAME##_NULL) return;\
    (*include)[i7]=true;\
    if (i8 == NAME##_NULL) return;\
    (*include)[i8]=true;\
    if (i9 == NAME##_NULL) return;\
    (*include)[i9]=true;\
    if (i10 == NAME##_NULL) return;\
    (*include)[i10]=true;\
    if (i11 == NAME##_NULL) return;\
    (*include)[i11]=true;\
    if (i12 == NAME##_NULL) return;\
    (*include)[i12]=true;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_value_list<Manip>& obj)\
	{\
    s << obj.manip << obj.obj->I1 << obj.delim;\
    s << obj.manip << obj.obj->I2 << obj.delim;\
    s << obj.manip << obj.obj->I3 << obj.delim;\
    s << obj.manip << obj.obj->I4 << obj.delim;\
    s << obj.manip << obj.obj->I5 << obj.delim;\
    s << obj.manip << obj.obj->I6 << obj.delim;\
    s << obj.manip << obj.obj->I7 << obj.delim;\
    s << obj.manip << obj.obj->I8 << obj.delim;\
    s << obj.manip << obj.obj->I9 << obj.delim;\
    s << obj.manip << obj.obj->I10 << obj.delim;\
    s << obj.manip << obj.obj->I11 << obj.delim;\
    s << obj.manip << obj.obj->I12;\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_field_list<Manip>& obj)\
	{\
    s << obj.manip << '`' << obj.obj->names[0] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[1] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[2] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[3] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[4] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[5] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[6] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[7] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[8] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[9] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[10] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[11] << '`';\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_equal_list<Manip>& obj)\
	{\
    s << '`' << obj.obj->names[0] << '`' << obj.comp << obj.manip << obj.obj->I1 << obj.delim;\
    s << '`' << obj.obj->names[1] << '`' << obj.comp << obj.manip << obj.obj->I2 << obj.delim;\
    s << '`' << obj.obj->names[2] << '`' << obj.comp << obj.manip << obj.obj->I3 << obj.delim;\
    s << '`' << obj.obj->names[3] << '`' << obj.comp << obj.manip << obj.obj->I4 << obj.delim;\
    s << '`' << obj.obj->names[4] << '`' << obj.comp << obj.manip << obj.obj->I5 << obj.delim;\
    s << '`' << obj.obj->names[5] << '`' << obj.comp << obj.manip << obj.obj->I6 << obj.delim;\
    s << '`' << obj.obj->names[6] << '`' << obj.comp << obj.manip << obj.obj->I7 << obj.delim;\
    s << '`' << obj.obj->names[7] << '`' << obj.comp << obj.manip << obj.obj->I8 << obj.delim;\
    s << '`' << obj.obj->names[8] << '`' << obj.comp << obj.manip << obj.obj->I9 << obj.delim;\
    s << '`' << obj.obj->names[9] << '`' << obj.comp << obj.manip << obj.obj->I10 << obj.delim;\
    s << '`' << obj.obj->names[10] << '`' << obj.comp << obj.manip << obj.obj->I11 << obj.delim;\
    s << '`' << obj.obj->names[11] << '`' << obj.comp << obj.manip << obj.obj->I12;\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_cus_value_list<Manip>& obj)\
	{\
		bool before = false;\
    if ((*obj.include)[0]) { \
      s << obj.manip << obj.obj->I1;\
      before = true; \
     } \
    if ((*obj.include)[1]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I2;\
      before = true; \
     } \
    if ((*obj.include)[2]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I3;\
      before = true; \
     } \
    if ((*obj.include)[3]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I4;\
      before = true; \
     } \
    if ((*obj.include)[4]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I5;\
      before = true; \
     } \
    if ((*obj.include)[5]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I6;\
      before = true; \
     } \
    if ((*obj.include)[6]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I7;\
      before = true; \
     } \
    if ((*obj.include)[7]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I8;\
      before = true; \
     } \
    if ((*obj.include)[8]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I9;\
      before = true; \
     } \
    if ((*obj.include)[9]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I10;\
      before = true; \
     } \
    if ((*obj.include)[10]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I11;\
      before = true; \
     } \
    if ((*obj.include)[11]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I12;\
     } \
        (void)before;\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_cus_field_list<Manip>& obj)\
	{\
		bool before = false;\
    if ((*obj.include)[0]) { \
      s << obj.manip << '`' << obj.obj->names[0] << '`';\
      before = true; \
     } \
    if ((*obj.include)[1]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[1] << '`';\
      before = true; \
     } \
    if ((*obj.include)[2]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[2] << '`';\
      before = true; \
     } \
    if ((*obj.include)[3]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[3] << '`';\
      before = true; \
     } \
    if ((*obj.include)[4]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[4] << '`';\
      before = true; \
     } \
    if ((*obj.include)[5]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[5] << '`';\
      before = true; \
     } \
    if ((*obj.include)[6]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[6] << '`';\
      before = true; \
     } \
    if ((*obj.include)[7]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[7] << '`';\
      before = true; \
     } \
    if ((*obj.include)[8]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[8] << '`';\
      before = true; \
     } \
    if ((*obj.include)[9]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[9] << '`';\
      before = true; \
     } \
    if ((*obj.include)[10]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[10] << '`';\
      before = true; \
     } \
    if ((*obj.include)[11]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[11] << '`';\
     } \
        (void)before;\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_cus_equal_list<Manip>& obj)\
	{\
		bool before = false;\
    if ((*obj.include)[0]) { \
      s << '`' << obj.obj->names[0] << '`' << obj.comp << obj.manip << obj.obj->I1;\
      before = true; \
     } \
    if ((*obj.include)[1]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[1] << '`' << obj.comp << obj.manip << obj.obj->I2;\
      before = true; \
     } \
    if ((*obj.include)[2]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[2] << '`' << obj.comp << obj.manip << obj.obj->I3;\
      before = true; \
     } \
    if ((*obj.include)[3]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[3] << '`' << obj.comp << obj.manip << obj.obj->I4;\
      before = true; \
     } \
    if ((*obj.include)[4]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[4] << '`' << obj.comp << obj.manip << obj.obj->I5;\
      before = true; \
     } \
    if ((*obj.include)[5]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[5] << '`' << obj.comp << obj.manip << obj.obj->I6;\
      before = true; \
     } \
    if ((*obj.include)[6]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[6] << '`' << obj.comp << obj.manip << obj.obj->I7;\
      before = true; \
     } \
    if ((*obj.include)[7]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[7] << '`' << obj.comp << obj.manip << obj.obj->I8;\
      before = true; \
     } \
    if ((*obj.include)[8]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[8] << '`' << obj.comp << obj.manip << obj.obj->I9;\
      before = true; \
     } \
    if ((*obj.include)[9]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[9] << '`' << obj.comp << obj.manip << obj.obj->I10;\
      before = true; \
     } \
    if ((*obj.include)[10]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[10] << '`' << obj.comp << obj.manip << obj.obj->I11;\
      before = true; \
     } \
    if ((*obj.include)[11]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[11] << '`' << obj.comp << obj.manip << obj.obj->I12;\
     } \
        (void)before;\
		return s;\
	}\
	template <class Manip>\
	inline NAME##_value_list<Manip> NAME::value_list(const char* d, Manip m) const\
			{ return NAME##_value_list<Manip> (this, d, m); } \
	template <class Manip>\
	inline NAME##_field_list<Manip> NAME::field_list(const char* d, Manip m) const\
			{ return NAME##_field_list<Manip> (this, d, m); } \
	template <class Manip>\
	inline NAME##_equal_list<Manip> NAME::equal_list(const char* d, const char* c, Manip m) const\
			{ return NAME##_equal_list<Manip> (this, d, c, m); } \
	template <class Manip>\
	inline NAME##_cus_value_list<Manip> NAME::value_list(const char* d, Manip m,\
			bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12) const\
			{ return NAME##_cus_value_list<Manip> (this, d, m, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12); }\
	template <class Manip>\
	inline NAME##_cus_field_list<Manip> NAME::field_list(const char* d, Manip m,\
			bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12) const\
			{ return NAME##_cus_field_list<Manip> (this, d, m, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12); }\
	template <class Manip>\
	inline NAME##_cus_equal_list<Manip> NAME::equal_list(const char* d, const char* c, Manip m,\
			bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12) const\
			{ return NAME##_cus_equal_list<Manip> (this, d, c, m, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12); } \
	template <class Manip>\
	inline NAME##_cus_value_list<Manip> NAME::value_list(const char* d, Manip m,\
			NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12) const\
			{ return NAME##_cus_value_list<Manip> (this, d, m, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12); } \
	template <class Manip>\
	inline NAME##_cus_field_list<Manip> NAME::field_list(const char* d, Manip m,\
			NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12) const\
			{ return NAME##_cus_field_list<Manip> (this, d, m, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12); } \
	template <class Manip>\
	inline NAME##_cus_equal_list<Manip> NAME::equal_list(const char* d, const char* c, Manip m, \
			NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12) const\
			{ return NAME##_cus_equal_list<Manip> (this, d, c, m, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12); } \
	template <class Manip>\
	inline NAME##_cus_value_list<Manip> NAME::value_list(const char* d, Manip m,\
			std::vector<bool> *i) const\
			{ return NAME##_cus_value_list<Manip> (this, d, m, i); }\
	template <class Manip>\
	inline NAME##_cus_field_list<Manip> NAME::field_list(const char* d, Manip m,\
			std::vector<bool> *i) const\
			{ return NAME##_cus_field_list<Manip> (this, d, m, i); }\
	template <class Manip>\
	inline NAME##_cus_equal_list<Manip> NAME::equal_list(const char* d, const char* c, Manip m,\
			std::vector<bool> *i) const\
			{ return NAME##_cus_equal_list<Manip> (this, d, c, m, i); }\
	template <class Manip>\
	inline NAME##_cus_value_list<Manip> \
	NAME::value_list(const char* d, Manip m, mysqlpp::sql_cmp_type /*sc*/) const\
			{ sql_compare_type_def_##CMP(NAME, value, NUM); }\
	template <class Manip>\
	inline NAME##_cus_field_list<Manip> \
	NAME::field_list(const char* d, Manip m, mysqlpp::sql_cmp_type /*sc*/) const\
			{ sql_compare_type_def_##CMP(NAME, field, NUM); }\
	template <class Manip>\
	inline NAME##_cus_equal_list<Manip> \
	NAME::equal_list(const char* d, const char* c, Manip m, mysqlpp::sql_cmp_type /*sc*/) const\
			{ sql_compare_type_defe_##CMP(NAME, equal, NUM); }\
	template <mysqlpp::sql_dummy_type dummy>\
	void populate_##NAME(NAME *s, const mysqlpp::Row &row)\
	{\
		mysqlpp::NoExceptions ignore_schema_mismatches(row);\
    s->I1 = row[N1].conv(T1());\
    s->I2 = row[N2].conv(T2());\
    s->I3 = row[N3].conv(T3());\
    s->I4 = row[N4].conv(T4());\
    s->I5 = row[N5].conv(T5());\
    s->I6 = row[N6].conv(T6());\
    s->I7 = row[N7].conv(T7());\
    s->I8 = row[N8].conv(T8());\
    s->I9 = row[N9].conv(T9());\
    s->I10 = row[N10].conv(T10());\
    s->I11 = row[N11].conv(T11());\
    s->I12 = row[N12].conv(T12());\
	}\
	inline NAME::NAME(const mysqlpp::Row& row) :\
	table_override_(0)\
			{ populate_##NAME<mysqlpp::sql_dummy>(this, row); }\
	inline void NAME::set(const mysqlpp::Row& row)\
	{\
		table_override_ = 0;\
		populate_##NAME<mysqlpp::sql_dummy>(this, row);\
	}\
	sql_COMPARE__##CMP(NAME, I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 )

#define sql_create_12(NAME, CMP, CONTR, T1, I1, T2, I2, T3, I3, T4, I4, T5, I5, T6, I6, T7, I7, T8, I8, T9, I9, T10, I10, T11, I11, T12, I12) \
		sql_create_complete_12(NAME, CMP, CONTR, T1, I1, #I1, T2, I2, #I2, T3, I3, #I3, T4, I4, #I4, T5, I5, #I5, T6, I6, #I6, T7, I7, #I7, T8, I8, #I8, T9, I9, #I9, T10, I10, #I10, T11, I11, #I11, T12, I12, #I12) \

// ---------------------------------------------------
//                  End Create 12
// ---------------------------------------------------

// ---------------------------------------------------
//                  Begin Create 13
// ---------------------------------------------------
#define sql_create_complete_13(NAME, CMP, CONTR, T1, I1, N1, T2, I2, N2, T3, I3, N3, T4, I4, N4, T5, I5, N5, T6, I6, N6, T7, I7, N7, T8, I8, N8, T9, I9, N9, T10, I10, N10, T11, I11, N11, T12, I12, N12, T13, I13, N13) \
	struct NAME; \
	enum NAME##_enum { \
    NAME##_##I1,\
    NAME##_##I2,\
    NAME##_##I3,\
    NAME##_##I4,\
    NAME##_##I5,\
    NAME##_##I6,\
    NAME##_##I7,\
    NAME##_##I8,\
    NAME##_##I9,\
    NAME##_##I10,\
    NAME##_##I11,\
    NAME##_##I12,\
    NAME##_##I13 \
	,NAME##_NULL \
	}; \
	template <class Manip>\
	class NAME##_value_list { \
	public: \
	const NAME* obj;\
	const char* delim;\
	Manip manip;\
	public: \
	NAME##_value_list (const NAME* o, const char* d, Manip m) :\
	obj(o), delim(d), manip(m) { } \
	};\
	template <class Manip>\
	class NAME##_##field_list {\
	public: \
	const NAME* obj; \
	const char* delim;\
	Manip manip;\
	public: \
	NAME##_field_list (const NAME* o, const char* d, Manip m) :\
	obj(o), delim(d), manip(m) { } \
	};\
	template <class Manip>\
	class NAME##_equal_list { \
	public: \
	const NAME* obj;\
	const char* delim;\
	const char* comp;\
	Manip manip;\
	public: \
	NAME##_equal_list (const NAME* o, const char* d, const char* c, Manip m) :\
	obj(o), delim(d), comp(c), manip(m) { }\
	};\
	template <class Manip>\
	class NAME##_cus_value_list {\
	public:\
	const NAME* obj;\
	std::vector<bool> *include;\
	bool del_vector;\
	const char* delim;\
	Manip manip;\
	public: \
	~NAME##_cus_value_list () {if (del_vector) delete include;} \
	NAME##_cus_value_list (const NAME* o, const char* d, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13);\
	NAME##_cus_value_list (const NAME* o, const char* d, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13); \
	NAME##_cus_value_list (const NAME* o, const char* d, Manip m ,std::vector<bool>* i) :\
	obj(o), include(i), del_vector(false), delim(d), manip(m) { }\
	};\
	template <class Manip>\
	class NAME##_cus_field_list { \
	public:\
	const NAME* obj; \
	std::vector<bool> *include; \
	bool del_vector; \
	const char* delim;\
	Manip manip;\
	public: \
	~NAME##_cus_field_list () {if (del_vector) delete include;} \
	NAME##_cus_field_list (const NAME* o, const char* d, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13); \
	NAME##_cus_field_list (const NAME* o, const char* d, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13); \
	NAME##_cus_field_list (const NAME* o, const char* d, Manip m, std::vector<bool> *i) :\
	obj(o), include(i), del_vector(false), delim(d), manip(m) { }\
	};\
	template <class Manip>\
	class NAME##_cus_equal_list {\
	public:\
	const NAME* obj;\
	std::vector<bool> *include;\
	bool del_vector;\
	const char* delim;\
	const char* comp;\
	Manip manip;\
	public:\
	~NAME##_##cus_equal_list () {if (del_vector) delete include;}\
	NAME##_##cus_equal_list (const NAME* o, const char* d, const char* c, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13); \
	NAME##_##cus_equal_list (const NAME* o, const char* d, const char* c, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13); \
	NAME##_##cus_equal_list (const NAME* o, const char* d, const char* c, Manip m, std::vector<bool> *i) :\
	obj(o), include(i), del_vector(false), delim(d), comp(c), manip(m) { }\
	};\
	template <mysqlpp::sql_dummy_type dummy> int sql_compare_##NAME(const NAME&, const NAME&);\
	struct NAME {\
    T1 I1;\
    T2 I2;\
    T3 I3;\
    T4 I4;\
    T5 I5;\
    T6 I6;\
    T7 I7;\
    T8 I8;\
    T9 I9;\
    T10 I10;\
    T11 I11;\
    T12 I12;\
    T13 I13; \
	NAME() : table_override_(0) { }\
	NAME(const mysqlpp::Row& row);\
	void set(const mysqlpp::Row &row);\
	sql_compare_define_##CMP(NAME, T1, I1, T2, I2, T3, I3, T4, I4, T5, I5, T6, I6, T7, I7, T8, I8, T9, I9, T10, I10, T11, I11, T12, I12, T13, I13, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)\
	sql_construct_define_##CONTR(NAME, T1, I1, T2, I2, T3, I3, T4, I4, T5, I5, T6, I6, T7, I7, T8, I8, T9, I9, T10, I10, T11, I11, T12, I12, T13, I13, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)\
	static const char* names[];\
	static void table(const char* t) { table_ = t; }\
	const char* table() const\
			{ return table_override_ ? table_override_ : NAME::table_; }\
	void instance_table(const char* t) { table_override_ = t; }\
	NAME##_value_list<mysqlpp::quote_type0> value_list() const {\
		return value_list(",", mysqlpp::quote);}\
	NAME##_value_list<mysqlpp::quote_type0> value_list(const char* d) const {\
		return value_list(d, mysqlpp::quote);}\
	template <class Manip>\
	NAME##_value_list<Manip> value_list(const char* d, Manip m) const;\
	NAME##_field_list<mysqlpp::do_nothing_type0> field_list() const {\
		return field_list(",", mysqlpp::do_nothing);}\
	NAME##_field_list<mysqlpp::do_nothing_type0> field_list(const char* d) const {\
		return field_list(d, mysqlpp::do_nothing);}\
	template <class Manip>\
	NAME##_field_list<Manip> field_list(const char* d, Manip m) const;\
	NAME##_equal_list<mysqlpp::quote_type0> equal_list(const char* d = ",",\
			const char* c = " = ") const\
			{ return equal_list(d, c, mysqlpp::quote); }\
	template <class Manip>\
	NAME##_equal_list<Manip> equal_list(const char* d, const char* c, Manip m) const;\
	/* cus_data */\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false) const\
			{ return value_list(",", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL) const\
			{ return value_list(",", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(std::vector<bool> *i) const\
			{ return value_list(",", mysqlpp::quote, i); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(mysqlpp::sql_cmp_type sc) const\
			{ return value_list(",", mysqlpp::quote, sc); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(const char* d, bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false) const\
			{ return value_list(d, mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(const char* d, NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL) const\
			{ return value_list(d, mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(const char* d,\
			std::vector<bool> *i) const\
			{ return value_list(d, mysqlpp::quote, i); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(const char* d,\
			mysqlpp::sql_cmp_type sc) const\
			{ return value_list(d, mysqlpp::quote, sc); }\
	template <class Manip>\
	NAME##_cus_value_list<Manip> value_list(const char* d, Manip m,\
			bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false) const;\
	template <class Manip>\
	NAME##_cus_value_list<Manip> value_list(const char* d, Manip m,\
			NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL) const;\
	template <class Manip>\
	NAME##_cus_value_list<Manip> value_list(const char* d, Manip m,\
			std::vector<bool>* i) const;\
	template <class Manip>\
	NAME##_cus_value_list<Manip> value_list(const char* d, Manip m, \
			mysqlpp::sql_cmp_type sc) const;\
	/* cus field */\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false) const \
			{ return field_list(",", mysqlpp::do_nothing, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL) const\
			{ return field_list(",", mysqlpp::do_nothing, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(std::vector<bool> *i) const\
			{ return field_list(",", mysqlpp::do_nothing, i); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(mysqlpp::sql_cmp_type sc) const\
			{ return field_list(",", mysqlpp::do_nothing, sc); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(const char* d,\
			bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false) const\
			{ return field_list(d, mysqlpp::do_nothing, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(const char* d,\
			NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL) const\
			{ return field_list(d, mysqlpp::do_nothing, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(const char* d,\
			std::vector<bool>* i) const\
			{ return field_list(d, mysqlpp::do_nothing, i); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(const char* d,\
			mysqlpp::sql_cmp_type sc) const\
			{ return field_list(d, mysqlpp::do_nothing, sc); }\
	template <class Manip>\
	NAME##_cus_field_list<Manip> field_list(const char* d, Manip m,\
			bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false) const;\
	template <class Manip>\
	NAME##_cus_field_list<Manip> field_list(const char* d, Manip m,\
			NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL) const;\
	template <class Manip>\
	NAME##_cus_field_list<Manip> field_list(const char* d, Manip m,\
			std::vector<bool> *i) const;\
	template <class Manip>\
	NAME##_cus_field_list<Manip> field_list(const char* d, Manip m,\
			mysqlpp::sql_cmp_type sc) const;\
	/* cus equal */\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false) const\
			{ return equal_list(",", " = ", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL) const\
			{ return equal_list(",", " = ", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(std::vector<bool>* i) const\
			{ return equal_list(",", " = ", mysqlpp::quote, i); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(mysqlpp::sql_cmp_type sc) const\
			{ return equal_list(",", " = ", mysqlpp::quote, sc); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false) const\
			{ return equal_list(d, " = ", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL) const\
			{ return equal_list(d, " = ", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d,\
			std::vector<bool> *i) const\
			{ return equal_list(d, " = ", mysqlpp::quote, i); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d,\
			mysqlpp::sql_cmp_type sc) const\
			{ return equal_list(d, " = ", mysqlpp::quote, sc); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, const char* c,\
			bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false) const\
			{ return equal_list(d, c, mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, const char* c,\
			NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL) const\
			{ return equal_list(d, c, mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, const char* c,\
			std::vector<bool> *i) const\
			{ return equal_list(d, c, mysqlpp::quote, i); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, const char* c,\
			mysqlpp::sql_cmp_type sc) const\
			{ return equal_list(d, c, mysqlpp::quote, sc); }\
	template <class Manip>\
	NAME##_cus_equal_list<Manip> equal_list(const char* d, const char* c, Manip m, \
						bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false) const;\
	template <class Manip>\
	NAME##_cus_equal_list<Manip> equal_list(const char* d, const char* c, Manip m, \
						NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL) const;\
	template <class Manip>\
	NAME##_cus_equal_list<Manip> equal_list(const char* d, const char* c, Manip m, \
						std::vector<bool> *i) const;\
	template <class Manip>\
	NAME##_cus_equal_list<Manip> equal_list(const char* d, const char* c, Manip m, \
						mysqlpp::sql_cmp_type sc) const;\
	private:\
	static const char* table_;\
	const char* table_override_;\
	};\
	MYSQLPP_SSQLS_CONDITIONAL_STATICS(\
		const char* NAME::names[] = {\
			    N1 ,\
    N2 ,\
    N3 ,\
    N4 ,\
    N5 ,\
    N6 ,\
    N7 ,\
    N8 ,\
    N9 ,\
    N10 ,\
    N11 ,\
    N12 ,\
    N13 \
		};\
		const char* NAME::table_ = #NAME;\
	)\
	template <class Manip>\
	NAME##_cus_value_list<Manip>::NAME##_cus_value_list\
			(const NAME* o, const char* d, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13)\
	{\
		delim = d;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(13, false);\
    if (i1) (*include)[0]=true;\
    if (i2) (*include)[1]=true;\
    if (i3) (*include)[2]=true;\
    if (i4) (*include)[3]=true;\
    if (i5) (*include)[4]=true;\
    if (i6) (*include)[5]=true;\
    if (i7) (*include)[6]=true;\
    if (i8) (*include)[7]=true;\
    if (i9) (*include)[8]=true;\
    if (i10) (*include)[9]=true;\
    if (i11) (*include)[10]=true;\
    if (i12) (*include)[11]=true;\
    if (i13) (*include)[12]=true;\
	}\
	template <class Manip>\
	NAME##_cus_value_list<Manip>::NAME##_cus_value_list\
			(const NAME* o, const char* d, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13)\
	{\
		delim = d;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(13, false);\
    if (i1 == NAME##_NULL) return;\
    (*include)[i1]=true;\
    if (i2 == NAME##_NULL) return;\
    (*include)[i2]=true;\
    if (i3 == NAME##_NULL) return;\
    (*include)[i3]=true;\
    if (i4 == NAME##_NULL) return;\
    (*include)[i4]=true;\
    if (i5 == NAME##_NULL) return;\
    (*include)[i5]=true;\
    if (i6 == NAME##_NULL) return;\
    (*include)[i6]=true;\
    if (i7 == NAME##_NULL) return;\
    (*include)[i7]=true;\
    if (i8 == NAME##_NULL) return;\
    (*include)[i8]=true;\
    if (i9 == NAME##_NULL) return;\
    (*include)[i9]=true;\
    if (i10 == NAME##_NULL) return;\
    (*include)[i10]=true;\
    if (i11 == NAME##_NULL) return;\
    (*include)[i11]=true;\
    if (i12 == NAME##_NULL) return;\
    (*include)[i12]=true;\
    if (i13 == NAME##_NULL) return;\
    (*include)[i13]=true;\
	}\
	template <class Manip>\
	NAME##_cus_field_list<Manip>::NAME##_cus_field_list\
			(const NAME* o, const char* d, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13)\
	{\
		delim = d;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(13, false);\
    if (i1) (*include)[0]=true;\
    if (i2) (*include)[1]=true;\
    if (i3) (*include)[2]=true;\
    if (i4) (*include)[3]=true;\
    if (i5) (*include)[4]=true;\
    if (i6) (*include)[5]=true;\
    if (i7) (*include)[6]=true;\
    if (i8) (*include)[7]=true;\
    if (i9) (*include)[8]=true;\
    if (i10) (*include)[9]=true;\
    if (i11) (*include)[10]=true;\
    if (i12) (*include)[11]=true;\
    if (i13) (*include)[12]=true;\
	}\
	template <class Manip>\
	NAME##_cus_field_list<Manip>::NAME##_cus_field_list\
			(const NAME* o, const char* d, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13)\
	{\
		delim = d;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(13, false);\
    if (i1 == NAME##_NULL) return;\
    (*include)[i1]=true;\
    if (i2 == NAME##_NULL) return;\
    (*include)[i2]=true;\
    if (i3 == NAME##_NULL) return;\
    (*include)[i3]=true;\
    if (i4 == NAME##_NULL) return;\
    (*include)[i4]=true;\
    if (i5 == NAME##_NULL) return;\
    (*include)[i5]=true;\
    if (i6 == NAME##_NULL) return;\
    (*include)[i6]=true;\
    if (i7 == NAME##_NULL) return;\
    (*include)[i7]=true;\
    if (i8 == NAME##_NULL) return;\
    (*include)[i8]=true;\
    if (i9 == NAME##_NULL) return;\
    (*include)[i9]=true;\
    if (i10 == NAME##_NULL) return;\
    (*include)[i10]=true;\
    if (i11 == NAME##_NULL) return;\
    (*include)[i11]=true;\
    if (i12 == NAME##_NULL) return;\
    (*include)[i12]=true;\
    if (i13 == NAME##_NULL) return;\
    (*include)[i13]=true;\
	}\
	template <class Manip>\
	NAME##_cus_equal_list<Manip>::NAME##_cus_equal_list\
			(const NAME* o, const char* d, const char* c, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13)\
	{\
		delim = d;\
		comp = c;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(13, false);\
    if (i1) (*include)[0]=true;\
    if (i2) (*include)[1]=true;\
    if (i3) (*include)[2]=true;\
    if (i4) (*include)[3]=true;\
    if (i5) (*include)[4]=true;\
    if (i6) (*include)[5]=true;\
    if (i7) (*include)[6]=true;\
    if (i8) (*include)[7]=true;\
    if (i9) (*include)[8]=true;\
    if (i10) (*include)[9]=true;\
    if (i11) (*include)[10]=true;\
    if (i12) (*include)[11]=true;\
    if (i13) (*include)[12]=true;\
	}\
	template <class Manip>\
	NAME##_cus_equal_list<Manip>::NAME##_cus_equal_list\
			(const NAME* o, const char* d, const char* c, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13)\
	{\
		delim = d;\
		comp = c;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(13, false);\
    if (i1 == NAME##_NULL) return;\
    (*include)[i1]=true;\
    if (i2 == NAME##_NULL) return;\
    (*include)[i2]=true;\
    if (i3 == NAME##_NULL) return;\
    (*include)[i3]=true;\
    if (i4 == NAME##_NULL) return;\
    (*include)[i4]=true;\
    if (i5 == NAME##_NULL) return;\
    (*include)[i5]=true;\
    if (i6 == NAME##_NULL) return;\
    (*include)[i6]=true;\
    if (i7 == NAME##_NULL) return;\
    (*include)[i7]=true;\
    if (i8 == NAME##_NULL) return;\
    (*include)[i8]=true;\
    if (i9 == NAME##_NULL) return;\
    (*include)[i9]=true;\
    if (i10 == NAME##_NULL) return;\
    (*include)[i10]=true;\
    if (i11 == NAME##_NULL) return;\
    (*include)[i11]=true;\
    if (i12 == NAME##_NULL) return;\
    (*include)[i12]=true;\
    if (i13 == NAME##_NULL) return;\
    (*include)[i13]=true;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_value_list<Manip>& obj)\
	{\
    s << obj.manip << obj.obj->I1 << obj.delim;\
    s << obj.manip << obj.obj->I2 << obj.delim;\
    s << obj.manip << obj.obj->I3 << obj.delim;\
    s << obj.manip << obj.obj->I4 << obj.delim;\
    s << obj.manip << obj.obj->I5 << obj.delim;\
    s << obj.manip << obj.obj->I6 << obj.delim;\
    s << obj.manip << obj.obj->I7 << obj.delim;\
    s << obj.manip << obj.obj->I8 << obj.delim;\
    s << obj.manip << obj.obj->I9 << obj.delim;\
    s << obj.manip << obj.obj->I10 << obj.delim;\
    s << obj.manip << obj.obj->I11 << obj.delim;\
    s << obj.manip << obj.obj->I12 << obj.delim;\
    s << obj.manip << obj.obj->I13;\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_field_list<Manip>& obj)\
	{\
    s << obj.manip << '`' << obj.obj->names[0] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[1] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[2] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[3] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[4] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[5] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[6] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[7] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[8] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[9] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[10] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[11] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[12] << '`';\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_equal_list<Manip>& obj)\
	{\
    s << '`' << obj.obj->names[0] << '`' << obj.comp << obj.manip << obj.obj->I1 << obj.delim;\
    s << '`' << obj.obj->names[1] << '`' << obj.comp << obj.manip << obj.obj->I2 << obj.delim;\
    s << '`' << obj.obj->names[2] << '`' << obj.comp << obj.manip << obj.obj->I3 << obj.delim;\
    s << '`' << obj.obj->names[3] << '`' << obj.comp << obj.manip << obj.obj->I4 << obj.delim;\
    s << '`' << obj.obj->names[4] << '`' << obj.comp << obj.manip << obj.obj->I5 << obj.delim;\
    s << '`' << obj.obj->names[5] << '`' << obj.comp << obj.manip << obj.obj->I6 << obj.delim;\
    s << '`' << obj.obj->names[6] << '`' << obj.comp << obj.manip << obj.obj->I7 << obj.delim;\
    s << '`' << obj.obj->names[7] << '`' << obj.comp << obj.manip << obj.obj->I8 << obj.delim;\
    s << '`' << obj.obj->names[8] << '`' << obj.comp << obj.manip << obj.obj->I9 << obj.delim;\
    s << '`' << obj.obj->names[9] << '`' << obj.comp << obj.manip << obj.obj->I10 << obj.delim;\
    s << '`' << obj.obj->names[10] << '`' << obj.comp << obj.manip << obj.obj->I11 << obj.delim;\
    s << '`' << obj.obj->names[11] << '`' << obj.comp << obj.manip << obj.obj->I12 << obj.delim;\
    s << '`' << obj.obj->names[12] << '`' << obj.comp << obj.manip << obj.obj->I13;\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_cus_value_list<Manip>& obj)\
	{\
		bool before = false;\
    if ((*obj.include)[0]) { \
      s << obj.manip << obj.obj->I1;\
      before = true; \
     } \
    if ((*obj.include)[1]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I2;\
      before = true; \
     } \
    if ((*obj.include)[2]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I3;\
      before = true; \
     } \
    if ((*obj.include)[3]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I4;\
      before = true; \
     } \
    if ((*obj.include)[4]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I5;\
      before = true; \
     } \
    if ((*obj.include)[5]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I6;\
      before = true; \
     } \
    if ((*obj.include)[6]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I7;\
      before = true; \
     } \
    if ((*obj.include)[7]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I8;\
      before = true; \
     } \
    if ((*obj.include)[8]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I9;\
      before = true; \
     } \
    if ((*obj.include)[9]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I10;\
      before = true; \
     } \
    if ((*obj.include)[10]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I11;\
      before = true; \
     } \
    if ((*obj.include)[11]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I12;\
      before = true; \
     } \
    if ((*obj.include)[12]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I13;\
     } \
        (void)before;\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_cus_field_list<Manip>& obj)\
	{\
		bool before = false;\
    if ((*obj.include)[0]) { \
      s << obj.manip << '`' << obj.obj->names[0] << '`';\
      before = true; \
     } \
    if ((*obj.include)[1]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[1] << '`';\
      before = true; \
     } \
    if ((*obj.include)[2]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[2] << '`';\
      before = true; \
     } \
    if ((*obj.include)[3]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[3] << '`';\
      before = true; \
     } \
    if ((*obj.include)[4]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[4] << '`';\
      before = true; \
     } \
    if ((*obj.include)[5]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[5] << '`';\
      before = true; \
     } \
    if ((*obj.include)[6]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[6] << '`';\
      before = true; \
     } \
    if ((*obj.include)[7]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[7] << '`';\
      before = true; \
     } \
    if ((*obj.include)[8]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[8] << '`';\
      before = true; \
     } \
    if ((*obj.include)[9]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[9] << '`';\
      before = true; \
     } \
    if ((*obj.include)[10]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[10] << '`';\
      before = true; \
     } \
    if ((*obj.include)[11]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[11] << '`';\
      before = true; \
     } \
    if ((*obj.include)[12]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[12] << '`';\
     } \
        (void)before;\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_cus_equal_list<Manip>& obj)\
	{\
		bool before = false;\
    if ((*obj.include)[0]) { \
      s << '`' << obj.obj->names[0] << '`' << obj.comp << obj.manip << obj.obj->I1;\
      before = true; \
     } \
    if ((*obj.include)[1]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[1] << '`' << obj.comp << obj.manip << obj.obj->I2;\
      before = true; \
     } \
    if ((*obj.include)[2]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[2] << '`' << obj.comp << obj.manip << obj.obj->I3;\
      before = true; \
     } \
    if ((*obj.include)[3]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[3] << '`' << obj.comp << obj.manip << obj.obj->I4;\
      before = true; \
     } \
    if ((*obj.include)[4]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[4] << '`' << obj.comp << obj.manip << obj.obj->I5;\
      before = true; \
     } \
    if ((*obj.include)[5]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[5] << '`' << obj.comp << obj.manip << obj.obj->I6;\
      before = true; \
     } \
    if ((*obj.include)[6]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[6] << '`' << obj.comp << obj.manip << obj.obj->I7;\
      before = true; \
     } \
    if ((*obj.include)[7]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[7] << '`' << obj.comp << obj.manip << obj.obj->I8;\
      before = true; \
     } \
    if ((*obj.include)[8]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[8] << '`' << obj.comp << obj.manip << obj.obj->I9;\
      before = true; \
     } \
    if ((*obj.include)[9]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[9] << '`' << obj.comp << obj.manip << obj.obj->I10;\
      before = true; \
     } \
    if ((*obj.include)[10]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[10] << '`' << obj.comp << obj.manip << obj.obj->I11;\
      before = true; \
     } \
    if ((*obj.include)[11]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[11] << '`' << obj.comp << obj.manip << obj.obj->I12;\
      before = true; \
     } \
    if ((*obj.include)[12]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[12] << '`' << obj.comp << obj.manip << obj.obj->I13;\
     } \
        (void)before;\
		return s;\
	}\
	template <class Manip>\
	inline NAME##_value_list<Manip> NAME::value_list(const char* d, Manip m) const\
			{ return NAME##_value_list<Manip> (this, d, m); } \
	template <class Manip>\
	inline NAME##_field_list<Manip> NAME::field_list(const char* d, Manip m) const\
			{ return NAME##_field_list<Manip> (this, d, m); } \
	template <class Manip>\
	inline NAME##_equal_list<Manip> NAME::equal_list(const char* d, const char* c, Manip m) const\
			{ return NAME##_equal_list<Manip> (this, d, c, m); } \
	template <class Manip>\
	inline NAME##_cus_value_list<Manip> NAME::value_list(const char* d, Manip m,\
			bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13) const\
			{ return NAME##_cus_value_list<Manip> (this, d, m, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13); }\
	template <class Manip>\
	inline NAME##_cus_field_list<Manip> NAME::field_list(const char* d, Manip m,\
			bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13) const\
			{ return NAME##_cus_field_list<Manip> (this, d, m, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13); }\
	template <class Manip>\
	inline NAME##_cus_equal_list<Manip> NAME::equal_list(const char* d, const char* c, Manip m,\
			bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13) const\
			{ return NAME##_cus_equal_list<Manip> (this, d, c, m, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13); } \
	template <class Manip>\
	inline NAME##_cus_value_list<Manip> NAME::value_list(const char* d, Manip m,\
			NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13) const\
			{ return NAME##_cus_value_list<Manip> (this, d, m, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13); } \
	template <class Manip>\
	inline NAME##_cus_field_list<Manip> NAME::field_list(const char* d, Manip m,\
			NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13) const\
			{ return NAME##_cus_field_list<Manip> (this, d, m, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13); } \
	template <class Manip>\
	inline NAME##_cus_equal_list<Manip> NAME::equal_list(const char* d, const char* c, Manip m, \
			NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13) const\
			{ return NAME##_cus_equal_list<Manip> (this, d, c, m, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13); } \
	template <class Manip>\
	inline NAME##_cus_value_list<Manip> NAME::value_list(const char* d, Manip m,\
			std::vector<bool> *i) const\
			{ return NAME##_cus_value_list<Manip> (this, d, m, i); }\
	template <class Manip>\
	inline NAME##_cus_field_list<Manip> NAME::field_list(const char* d, Manip m,\
			std::vector<bool> *i) const\
			{ return NAME##_cus_field_list<Manip> (this, d, m, i); }\
	template <class Manip>\
	inline NAME##_cus_equal_list<Manip> NAME::equal_list(const char* d, const char* c, Manip m,\
			std::vector<bool> *i) const\
			{ return NAME##_cus_equal_list<Manip> (this, d, c, m, i); }\
	template <class Manip>\
	inline NAME##_cus_value_list<Manip> \
	NAME::value_list(const char* d, Manip m, mysqlpp::sql_cmp_type /*sc*/) const\
			{ sql_compare_type_def_##CMP(NAME, value, NUM); }\
	template <class Manip>\
	inline NAME##_cus_field_list<Manip> \
	NAME::field_list(const char* d, Manip m, mysqlpp::sql_cmp_type /*sc*/) const\
			{ sql_compare_type_def_##CMP(NAME, field, NUM); }\
	template <class Manip>\
	inline NAME##_cus_equal_list<Manip> \
	NAME::equal_list(const char* d, const char* c, Manip m, mysqlpp::sql_cmp_type /*sc*/) const\
			{ sql_compare_type_defe_##CMP(NAME, equal, NUM); }\
	template <mysqlpp::sql_dummy_type dummy>\
	void populate_##NAME(NAME *s, const mysqlpp::Row &row)\
	{\
		mysqlpp::NoExceptions ignore_schema_mismatches(row);\
    s->I1 = row[N1].conv(T1());\
    s->I2 = row[N2].conv(T2());\
    s->I3 = row[N3].conv(T3());\
    s->I4 = row[N4].conv(T4());\
    s->I5 = row[N5].conv(T5());\
    s->I6 = row[N6].conv(T6());\
    s->I7 = row[N7].conv(T7());\
    s->I8 = row[N8].conv(T8());\
    s->I9 = row[N9].conv(T9());\
    s->I10 = row[N10].conv(T10());\
    s->I11 = row[N11].conv(T11());\
    s->I12 = row[N12].conv(T12());\
    s->I13 = row[N13].conv(T13());\
	}\
	inline NAME::NAME(const mysqlpp::Row& row) :\
	table_override_(0)\
			{ populate_##NAME<mysqlpp::sql_dummy>(this, row); }\
	inline void NAME::set(const mysqlpp::Row& row)\
	{\
		table_override_ = 0;\
		populate_##NAME<mysqlpp::sql_dummy>(this, row);\
	}\
	sql_COMPARE__##CMP(NAME, I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 )

#define sql_create_13(NAME, CMP, CONTR, T1, I1, T2, I2, T3, I3, T4, I4, T5, I5, T6, I6, T7, I7, T8, I8, T9, I9, T10, I10, T11, I11, T12, I12, T13, I13) \
		sql_create_complete_13(NAME, CMP, CONTR, T1, I1, #I1, T2, I2, #I2, T3, I3, #I3, T4, I4, #I4, T5, I5, #I5, T6, I6, #I6, T7, I7, #I7, T8, I8, #I8, T9, I9, #I9, T10, I10, #I10, T11, I11, #I11, T12, I12, #I12, T13, I13, #I13) \

// ---------------------------------------------------
//                  End Create 13
// ---------------------------------------------------

// ---------------------------------------------------
//                  Begin Create 14
// ---------------------------------------------------
#define sql_create_complete_14(NAME, CMP, CONTR, T1, I1, N1, T2, I2, N2, T3, I3, N3, T4, I4, N4, T5, I5, N5, T6, I6, N6, T7, I7, N7, T8, I8, N8, T9, I9, N9, T10, I10, N10, T11, I11, N11, T12, I12, N12, T13, I13, N13, T14, I14, N14) \
	struct NAME; \
	enum NAME##_enum { \
    NAME##_##I1,\
    NAME##_##I2,\
    NAME##_##I3,\
    NAME##_##I4,\
    NAME##_##I5,\
    NAME##_##I6,\
    NAME##_##I7,\
    NAME##_##I8,\
    NAME##_##I9,\
    NAME##_##I10,\
    NAME##_##I11,\
    NAME##_##I12,\
    NAME##_##I13,\
    NAME##_##I14 \
	,NAME##_NULL \
	}; \
	template <class Manip>\
	class NAME##_value_list { \
	public: \
	const NAME* obj;\
	const char* delim;\
	Manip manip;\
	public: \
	NAME##_value_list (const NAME* o, const char* d, Manip m) :\
	obj(o), delim(d), manip(m) { } \
	};\
	template <class Manip>\
	class NAME##_##field_list {\
	public: \
	const NAME* obj; \
	const char* delim;\
	Manip manip;\
	public: \
	NAME##_field_list (const NAME* o, const char* d, Manip m) :\
	obj(o), delim(d), manip(m) { } \
	};\
	template <class Manip>\
	class NAME##_equal_list { \
	public: \
	const NAME* obj;\
	const char* delim;\
	const char* comp;\
	Manip manip;\
	public: \
	NAME##_equal_list (const NAME* o, const char* d, const char* c, Manip m) :\
	obj(o), delim(d), comp(c), manip(m) { }\
	};\
	template <class Manip>\
	class NAME##_cus_value_list {\
	public:\
	const NAME* obj;\
	std::vector<bool> *include;\
	bool del_vector;\
	const char* delim;\
	Manip manip;\
	public: \
	~NAME##_cus_value_list () {if (del_vector) delete include;} \
	NAME##_cus_value_list (const NAME* o, const char* d, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13, bool i14);\
	NAME##_cus_value_list (const NAME* o, const char* d, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13, NAME##_enum i14); \
	NAME##_cus_value_list (const NAME* o, const char* d, Manip m ,std::vector<bool>* i) :\
	obj(o), include(i), del_vector(false), delim(d), manip(m) { }\
	};\
	template <class Manip>\
	class NAME##_cus_field_list { \
	public:\
	const NAME* obj; \
	std::vector<bool> *include; \
	bool del_vector; \
	const char* delim;\
	Manip manip;\
	public: \
	~NAME##_cus_field_list () {if (del_vector) delete include;} \
	NAME##_cus_field_list (const NAME* o, const char* d, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13, bool i14); \
	NAME##_cus_field_list (const NAME* o, const char* d, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13, NAME##_enum i14); \
	NAME##_cus_field_list (const NAME* o, const char* d, Manip m, std::vector<bool> *i) :\
	obj(o), include(i), del_vector(false), delim(d), manip(m) { }\
	};\
	template <class Manip>\
	class NAME##_cus_equal_list {\
	public:\
	const NAME* obj;\
	std::vector<bool> *include;\
	bool del_vector;\
	const char* delim;\
	const char* comp;\
	Manip manip;\
	public:\
	~NAME##_##cus_equal_list () {if (del_vector) delete include;}\
	NAME##_##cus_equal_list (const NAME* o, const char* d, const char* c, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13, bool i14); \
	NAME##_##cus_equal_list (const NAME* o, const char* d, const char* c, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13, NAME##_enum i14); \
	NAME##_##cus_equal_list (const NAME* o, const char* d, const char* c, Manip m, std::vector<bool> *i) :\
	obj(o), include(i), del_vector(false), delim(d), comp(c), manip(m) { }\
	};\
	template <mysqlpp::sql_dummy_type dummy> int sql_compare_##NAME(const NAME&, const NAME&);\
	struct NAME {\
    T1 I1;\
    T2 I2;\
    T3 I3;\
    T4 I4;\
    T5 I5;\
    T6 I6;\
    T7 I7;\
    T8 I8;\
    T9 I9;\
    T10 I10;\
    T11 I11;\
    T12 I12;\
    T13 I13;\
    T14 I14; \
	NAME() : table_override_(0) { }\
	NAME(const mysqlpp::Row& row);\
	void set(const mysqlpp::Row &row);\
	sql_compare_define_##CMP(NAME, T1, I1, T2, I2, T3, I3, T4, I4, T5, I5, T6, I6, T7, I7, T8, I8, T9, I9, T10, I10, T11, I11, T12, I12, T13, I13, T14, I14, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)\
	sql_construct_define_##CONTR(NAME, T1, I1, T2, I2, T3, I3, T4, I4, T5, I5, T6, I6, T7, I7, T8, I8, T9, I9, T10, I10, T11, I11, T12, I12, T13, I13, T14, I14, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)\
	static const char* names[];\
	static void table(const char* t) { table_ = t; }\
	const char* table() const\
			{ return table_override_ ? table_override_ : NAME::table_; }\
	void instance_table(const char* t) { table_override_ = t; }\
	NAME##_value_list<mysqlpp::quote_type0> value_list() const {\
		return value_list(",", mysqlpp::quote);}\
	NAME##_value_list<mysqlpp::quote_type0> value_list(const char* d) const {\
		return value_list(d, mysqlpp::quote);}\
	template <class Manip>\
	NAME##_value_list<Manip> value_list(const char* d, Manip m) const;\
	NAME##_field_list<mysqlpp::do_nothing_type0> field_list() const {\
		return field_list(",", mysqlpp::do_nothing);}\
	NAME##_field_list<mysqlpp::do_nothing_type0> field_list(const char* d) const {\
		return field_list(d, mysqlpp::do_nothing);}\
	template <class Manip>\
	NAME##_field_list<Manip> field_list(const char* d, Manip m) const;\
	NAME##_equal_list<mysqlpp::quote_type0> equal_list(const char* d = ",",\
			const char* c = " = ") const\
			{ return equal_list(d, c, mysqlpp::quote); }\
	template <class Manip>\
	NAME##_equal_list<Manip> equal_list(const char* d, const char* c, Manip m) const;\
	/* cus_data */\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false) const\
			{ return value_list(",", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL) const\
			{ return value_list(",", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(std::vector<bool> *i) const\
			{ return value_list(",", mysqlpp::quote, i); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(mysqlpp::sql_cmp_type sc) const\
			{ return value_list(",", mysqlpp::quote, sc); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(const char* d, bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false) const\
			{ return value_list(d, mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(const char* d, NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL) const\
			{ return value_list(d, mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(const char* d,\
			std::vector<bool> *i) const\
			{ return value_list(d, mysqlpp::quote, i); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(const char* d,\
			mysqlpp::sql_cmp_type sc) const\
			{ return value_list(d, mysqlpp::quote, sc); }\
	template <class Manip>\
	NAME##_cus_value_list<Manip> value_list(const char* d, Manip m,\
			bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false) const;\
	template <class Manip>\
	NAME##_cus_value_list<Manip> value_list(const char* d, Manip m,\
			NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL) const;\
	template <class Manip>\
	NAME##_cus_value_list<Manip> value_list(const char* d, Manip m,\
			std::vector<bool>* i) const;\
	template <class Manip>\
	NAME##_cus_value_list<Manip> value_list(const char* d, Manip m, \
			mysqlpp::sql_cmp_type sc) const;\
	/* cus field */\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false) const \
			{ return field_list(",", mysqlpp::do_nothing, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL) const\
			{ return field_list(",", mysqlpp::do_nothing, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(std::vector<bool> *i) const\
			{ return field_list(",", mysqlpp::do_nothing, i); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(mysqlpp::sql_cmp_type sc) const\
			{ return field_list(",", mysqlpp::do_nothing, sc); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(const char* d,\
			bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false) const\
			{ return field_list(d, mysqlpp::do_nothing, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(const char* d,\
			NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL) const\
			{ return field_list(d, mysqlpp::do_nothing, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(const char* d,\
			std::vector<bool>* i) const\
			{ return field_list(d, mysqlpp::do_nothing, i); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(const char* d,\
			mysqlpp::sql_cmp_type sc) const\
			{ return field_list(d, mysqlpp::do_nothing, sc); }\
	template <class Manip>\
	NAME##_cus_field_list<Manip> field_list(const char* d, Manip m,\
			bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false) const;\
	template <class Manip>\
	NAME##_cus_field_list<Manip> field_list(const char* d, Manip m,\
			NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL) const;\
	template <class Manip>\
	NAME##_cus_field_list<Manip> field_list(const char* d, Manip m,\
			std::vector<bool> *i) const;\
	template <class Manip>\
	NAME##_cus_field_list<Manip> field_list(const char* d, Manip m,\
			mysqlpp::sql_cmp_type sc) const;\
	/* cus equal */\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false) const\
			{ return equal_list(",", " = ", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL) const\
			{ return equal_list(",", " = ", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(std::vector<bool>* i) const\
			{ return equal_list(",", " = ", mysqlpp::quote, i); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(mysqlpp::sql_cmp_type sc) const\
			{ return equal_list(",", " = ", mysqlpp::quote, sc); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false) const\
			{ return equal_list(d, " = ", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL) const\
			{ return equal_list(d, " = ", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d,\
			std::vector<bool> *i) const\
			{ return equal_list(d, " = ", mysqlpp::quote, i); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d,\
			mysqlpp::sql_cmp_type sc) const\
			{ return equal_list(d, " = ", mysqlpp::quote, sc); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, const char* c,\
			bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false) const\
			{ return equal_list(d, c, mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, const char* c,\
			NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL) const\
			{ return equal_list(d, c, mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, const char* c,\
			std::vector<bool> *i) const\
			{ return equal_list(d, c, mysqlpp::quote, i); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, const char* c,\
			mysqlpp::sql_cmp_type sc) const\
			{ return equal_list(d, c, mysqlpp::quote, sc); }\
	template <class Manip>\
	NAME##_cus_equal_list<Manip> equal_list(const char* d, const char* c, Manip m, \
						bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false) const;\
	template <class Manip>\
	NAME##_cus_equal_list<Manip> equal_list(const char* d, const char* c, Manip m, \
						NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL) const;\
	template <class Manip>\
	NAME##_cus_equal_list<Manip> equal_list(const char* d, const char* c, Manip m, \
						std::vector<bool> *i) const;\
	template <class Manip>\
	NAME##_cus_equal_list<Manip> equal_list(const char* d, const char* c, Manip m, \
						mysqlpp::sql_cmp_type sc) const;\
	private:\
	static const char* table_;\
	const char* table_override_;\
	};\
	MYSQLPP_SSQLS_CONDITIONAL_STATICS(\
		const char* NAME::names[] = {\
			    N1 ,\
    N2 ,\
    N3 ,\
    N4 ,\
    N5 ,\
    N6 ,\
    N7 ,\
    N8 ,\
    N9 ,\
    N10 ,\
    N11 ,\
    N12 ,\
    N13 ,\
    N14 \
		};\
		const char* NAME::table_ = #NAME;\
	)\
	template <class Manip>\
	NAME##_cus_value_list<Manip>::NAME##_cus_value_list\
			(const NAME* o, const char* d, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13, bool i14)\
	{\
		delim = d;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(14, false);\
    if (i1) (*include)[0]=true;\
    if (i2) (*include)[1]=true;\
    if (i3) (*include)[2]=true;\
    if (i4) (*include)[3]=true;\
    if (i5) (*include)[4]=true;\
    if (i6) (*include)[5]=true;\
    if (i7) (*include)[6]=true;\
    if (i8) (*include)[7]=true;\
    if (i9) (*include)[8]=true;\
    if (i10) (*include)[9]=true;\
    if (i11) (*include)[10]=true;\
    if (i12) (*include)[11]=true;\
    if (i13) (*include)[12]=true;\
    if (i14) (*include)[13]=true;\
	}\
	template <class Manip>\
	NAME##_cus_value_list<Manip>::NAME##_cus_value_list\
			(const NAME* o, const char* d, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13, NAME##_enum i14)\
	{\
		delim = d;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(14, false);\
    if (i1 == NAME##_NULL) return;\
    (*include)[i1]=true;\
    if (i2 == NAME##_NULL) return;\
    (*include)[i2]=true;\
    if (i3 == NAME##_NULL) return;\
    (*include)[i3]=true;\
    if (i4 == NAME##_NULL) return;\
    (*include)[i4]=true;\
    if (i5 == NAME##_NULL) return;\
    (*include)[i5]=true;\
    if (i6 == NAME##_NULL) return;\
    (*include)[i6]=true;\
    if (i7 == NAME##_NULL) return;\
    (*include)[i7]=true;\
    if (i8 == NAME##_NULL) return;\
    (*include)[i8]=true;\
    if (i9 == NAME##_NULL) return;\
    (*include)[i9]=true;\
    if (i10 == NAME##_NULL) return;\
    (*include)[i10]=true;\
    if (i11 == NAME##_NULL) return;\
    (*include)[i11]=true;\
    if (i12 == NAME##_NULL) return;\
    (*include)[i12]=true;\
    if (i13 == NAME##_NULL) return;\
    (*include)[i13]=true;\
    if (i14 == NAME##_NULL) return;\
    (*include)[i14]=true;\
	}\
	template <class Manip>\
	NAME##_cus_field_list<Manip>::NAME##_cus_field_list\
			(const NAME* o, const char* d, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13, bool i14)\
	{\
		delim = d;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(14, false);\
    if (i1) (*include)[0]=true;\
    if (i2) (*include)[1]=true;\
    if (i3) (*include)[2]=true;\
    if (i4) (*include)[3]=true;\
    if (i5) (*include)[4]=true;\
    if (i6) (*include)[5]=true;\
    if (i7) (*include)[6]=true;\
    if (i8) (*include)[7]=true;\
    if (i9) (*include)[8]=true;\
    if (i10) (*include)[9]=true;\
    if (i11) (*include)[10]=true;\
    if (i12) (*include)[11]=true;\
    if (i13) (*include)[12]=true;\
    if (i14) (*include)[13]=true;\
	}\
	template <class Manip>\
	NAME##_cus_field_list<Manip>::NAME##_cus_field_list\
			(const NAME* o, const char* d, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13, NAME##_enum i14)\
	{\
		delim = d;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(14, false);\
    if (i1 == NAME##_NULL) return;\
    (*include)[i1]=true;\
    if (i2 == NAME##_NULL) return;\
    (*include)[i2]=true;\
    if (i3 == NAME##_NULL) return;\
    (*include)[i3]=true;\
    if (i4 == NAME##_NULL) return;\
    (*include)[i4]=true;\
    if (i5 == NAME##_NULL) return;\
    (*include)[i5]=true;\
    if (i6 == NAME##_NULL) return;\
    (*include)[i6]=true;\
    if (i7 == NAME##_NULL) return;\
    (*include)[i7]=true;\
    if (i8 == NAME##_NULL) return;\
    (*include)[i8]=true;\
    if (i9 == NAME##_NULL) return;\
    (*include)[i9]=true;\
    if (i10 == NAME##_NULL) return;\
    (*include)[i10]=true;\
    if (i11 == NAME##_NULL) return;\
    (*include)[i11]=true;\
    if (i12 == NAME##_NULL) return;\
    (*include)[i12]=true;\
    if (i13 == NAME##_NULL) return;\
    (*include)[i13]=true;\
    if (i14 == NAME##_NULL) return;\
    (*include)[i14]=true;\
	}\
	template <class Manip>\
	NAME##_cus_equal_list<Manip>::NAME##_cus_equal_list\
			(const NAME* o, const char* d, const char* c, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13, bool i14)\
	{\
		delim = d;\
		comp = c;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(14, false);\
    if (i1) (*include)[0]=true;\
    if (i2) (*include)[1]=true;\
    if (i3) (*include)[2]=true;\
    if (i4) (*include)[3]=true;\
    if (i5) (*include)[4]=true;\
    if (i6) (*include)[5]=true;\
    if (i7) (*include)[6]=true;\
    if (i8) (*include)[7]=true;\
    if (i9) (*include)[8]=true;\
    if (i10) (*include)[9]=true;\
    if (i11) (*include)[10]=true;\
    if (i12) (*include)[11]=true;\
    if (i13) (*include)[12]=true;\
    if (i14) (*include)[13]=true;\
	}\
	template <class Manip>\
	NAME##_cus_equal_list<Manip>::NAME##_cus_equal_list\
			(const NAME* o, const char* d, const char* c, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13, NAME##_enum i14)\
	{\
		delim = d;\
		comp = c;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(14, false);\
    if (i1 == NAME##_NULL) return;\
    (*include)[i1]=true;\
    if (i2 == NAME##_NULL) return;\
    (*include)[i2]=true;\
    if (i3 == NAME##_NULL) return;\
    (*include)[i3]=true;\
    if (i4 == NAME##_NULL) return;\
    (*include)[i4]=true;\
    if (i5 == NAME##_NULL) return;\
    (*include)[i5]=true;\
    if (i6 == NAME##_NULL) return;\
    (*include)[i6]=true;\
    if (i7 == NAME##_NULL) return;\
    (*include)[i7]=true;\
    if (i8 == NAME##_NULL) return;\
    (*include)[i8]=true;\
    if (i9 == NAME##_NULL) return;\
    (*include)[i9]=true;\
    if (i10 == NAME##_NULL) return;\
    (*include)[i10]=true;\
    if (i11 == NAME##_NULL) return;\
    (*include)[i11]=true;\
    if (i12 == NAME##_NULL) return;\
    (*include)[i12]=true;\
    if (i13 == NAME##_NULL) return;\
    (*include)[i13]=true;\
    if (i14 == NAME##_NULL) return;\
    (*include)[i14]=true;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_value_list<Manip>& obj)\
	{\
    s << obj.manip << obj.obj->I1 << obj.delim;\
    s << obj.manip << obj.obj->I2 << obj.delim;\
    s << obj.manip << obj.obj->I3 << obj.delim;\
    s << obj.manip << obj.obj->I4 << obj.delim;\
    s << obj.manip << obj.obj->I5 << obj.delim;\
    s << obj.manip << obj.obj->I6 << obj.delim;\
    s << obj.manip << obj.obj->I7 << obj.delim;\
    s << obj.manip << obj.obj->I8 << obj.delim;\
    s << obj.manip << obj.obj->I9 << obj.delim;\
    s << obj.manip << obj.obj->I10 << obj.delim;\
    s << obj.manip << obj.obj->I11 << obj.delim;\
    s << obj.manip << obj.obj->I12 << obj.delim;\
    s << obj.manip << obj.obj->I13 << obj.delim;\
    s << obj.manip << obj.obj->I14;\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_field_list<Manip>& obj)\
	{\
    s << obj.manip << '`' << obj.obj->names[0] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[1] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[2] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[3] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[4] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[5] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[6] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[7] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[8] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[9] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[10] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[11] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[12] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[13] << '`';\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_equal_list<Manip>& obj)\
	{\
    s << '`' << obj.obj->names[0] << '`' << obj.comp << obj.manip << obj.obj->I1 << obj.delim;\
    s << '`' << obj.obj->names[1] << '`' << obj.comp << obj.manip << obj.obj->I2 << obj.delim;\
    s << '`' << obj.obj->names[2] << '`' << obj.comp << obj.manip << obj.obj->I3 << obj.delim;\
    s << '`' << obj.obj->names[3] << '`' << obj.comp << obj.manip << obj.obj->I4 << obj.delim;\
    s << '`' << obj.obj->names[4] << '`' << obj.comp << obj.manip << obj.obj->I5 << obj.delim;\
    s << '`' << obj.obj->names[5] << '`' << obj.comp << obj.manip << obj.obj->I6 << obj.delim;\
    s << '`' << obj.obj->names[6] << '`' << obj.comp << obj.manip << obj.obj->I7 << obj.delim;\
    s << '`' << obj.obj->names[7] << '`' << obj.comp << obj.manip << obj.obj->I8 << obj.delim;\
    s << '`' << obj.obj->names[8] << '`' << obj.comp << obj.manip << obj.obj->I9 << obj.delim;\
    s << '`' << obj.obj->names[9] << '`' << obj.comp << obj.manip << obj.obj->I10 << obj.delim;\
    s << '`' << obj.obj->names[10] << '`' << obj.comp << obj.manip << obj.obj->I11 << obj.delim;\
    s << '`' << obj.obj->names[11] << '`' << obj.comp << obj.manip << obj.obj->I12 << obj.delim;\
    s << '`' << obj.obj->names[12] << '`' << obj.comp << obj.manip << obj.obj->I13 << obj.delim;\
    s << '`' << obj.obj->names[13] << '`' << obj.comp << obj.manip << obj.obj->I14;\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_cus_value_list<Manip>& obj)\
	{\
		bool before = false;\
    if ((*obj.include)[0]) { \
      s << obj.manip << obj.obj->I1;\
      before = true; \
     } \
    if ((*obj.include)[1]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I2;\
      before = true; \
     } \
    if ((*obj.include)[2]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I3;\
      before = true; \
     } \
    if ((*obj.include)[3]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I4;\
      before = true; \
     } \
    if ((*obj.include)[4]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I5;\
      before = true; \
     } \
    if ((*obj.include)[5]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I6;\
      before = true; \
     } \
    if ((*obj.include)[6]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I7;\
      before = true; \
     } \
    if ((*obj.include)[7]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I8;\
      before = true; \
     } \
    if ((*obj.include)[8]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I9;\
      before = true; \
     } \
    if ((*obj.include)[9]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I10;\
      before = true; \
     } \
    if ((*obj.include)[10]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I11;\
      before = true; \
     } \
    if ((*obj.include)[11]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I12;\
      before = true; \
     } \
    if ((*obj.include)[12]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I13;\
      before = true; \
     } \
    if ((*obj.include)[13]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I14;\
     } \
        (void)before;\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_cus_field_list<Manip>& obj)\
	{\
		bool before = false;\
    if ((*obj.include)[0]) { \
      s << obj.manip << '`' << obj.obj->names[0] << '`';\
      before = true; \
     } \
    if ((*obj.include)[1]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[1] << '`';\
      before = true; \
     } \
    if ((*obj.include)[2]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[2] << '`';\
      before = true; \
     } \
    if ((*obj.include)[3]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[3] << '`';\
      before = true; \
     } \
    if ((*obj.include)[4]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[4] << '`';\
      before = true; \
     } \
    if ((*obj.include)[5]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[5] << '`';\
      before = true; \
     } \
    if ((*obj.include)[6]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[6] << '`';\
      before = true; \
     } \
    if ((*obj.include)[7]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[7] << '`';\
      before = true; \
     } \
    if ((*obj.include)[8]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[8] << '`';\
      before = true; \
     } \
    if ((*obj.include)[9]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[9] << '`';\
      before = true; \
     } \
    if ((*obj.include)[10]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[10] << '`';\
      before = true; \
     } \
    if ((*obj.include)[11]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[11] << '`';\
      before = true; \
     } \
    if ((*obj.include)[12]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[12] << '`';\
      before = true; \
     } \
    if ((*obj.include)[13]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[13] << '`';\
     } \
        (void)before;\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_cus_equal_list<Manip>& obj)\
	{\
		bool before = false;\
    if ((*obj.include)[0]) { \
      s << '`' << obj.obj->names[0] << '`' << obj.comp << obj.manip << obj.obj->I1;\
      before = true; \
     } \
    if ((*obj.include)[1]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[1] << '`' << obj.comp << obj.manip << obj.obj->I2;\
      before = true; \
     } \
    if ((*obj.include)[2]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[2] << '`' << obj.comp << obj.manip << obj.obj->I3;\
      before = true; \
     } \
    if ((*obj.include)[3]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[3] << '`' << obj.comp << obj.manip << obj.obj->I4;\
      before = true; \
     } \
    if ((*obj.include)[4]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[4] << '`' << obj.comp << obj.manip << obj.obj->I5;\
      before = true; \
     } \
    if ((*obj.include)[5]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[5] << '`' << obj.comp << obj.manip << obj.obj->I6;\
      before = true; \
     } \
    if ((*obj.include)[6]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[6] << '`' << obj.comp << obj.manip << obj.obj->I7;\
      before = true; \
     } \
    if ((*obj.include)[7]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[7] << '`' << obj.comp << obj.manip << obj.obj->I8;\
      before = true; \
     } \
    if ((*obj.include)[8]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[8] << '`' << obj.comp << obj.manip << obj.obj->I9;\
      before = true; \
     } \
    if ((*obj.include)[9]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[9] << '`' << obj.comp << obj.manip << obj.obj->I10;\
      before = true; \
     } \
    if ((*obj.include)[10]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[10] << '`' << obj.comp << obj.manip << obj.obj->I11;\
      before = true; \
     } \
    if ((*obj.include)[11]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[11] << '`' << obj.comp << obj.manip << obj.obj->I12;\
      before = true; \
     } \
    if ((*obj.include)[12]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[12] << '`' << obj.comp << obj.manip << obj.obj->I13;\
      before = true; \
     } \
    if ((*obj.include)[13]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[13] << '`' << obj.comp << obj.manip << obj.obj->I14;\
     } \
        (void)before;\
		return s;\
	}\
	template <class Manip>\
	inline NAME##_value_list<Manip> NAME::value_list(const char* d, Manip m) const\
			{ return NAME##_value_list<Manip> (this, d, m); } \
	template <class Manip>\
	inline NAME##_field_list<Manip> NAME::field_list(const char* d, Manip m) const\
			{ return NAME##_field_list<Manip> (this, d, m); } \
	template <class Manip>\
	inline NAME##_equal_list<Manip> NAME::equal_list(const char* d, const char* c, Manip m) const\
			{ return NAME##_equal_list<Manip> (this, d, c, m); } \
	template <class Manip>\
	inline NAME##_cus_value_list<Manip> NAME::value_list(const char* d, Manip m,\
			bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13, bool i14) const\
			{ return NAME##_cus_value_list<Manip> (this, d, m, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14); }\
	template <class Manip>\
	inline NAME##_cus_field_list<Manip> NAME::field_list(const char* d, Manip m,\
			bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13, bool i14) const\
			{ return NAME##_cus_field_list<Manip> (this, d, m, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14); }\
	template <class Manip>\
	inline NAME##_cus_equal_list<Manip> NAME::equal_list(const char* d, const char* c, Manip m,\
			bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13, bool i14) const\
			{ return NAME##_cus_equal_list<Manip> (this, d, c, m, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14); } \
	template <class Manip>\
	inline NAME##_cus_value_list<Manip> NAME::value_list(const char* d, Manip m,\
			NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13, NAME##_enum i14) const\
			{ return NAME##_cus_value_list<Manip> (this, d, m, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14); } \
	template <class Manip>\
	inline NAME##_cus_field_list<Manip> NAME::field_list(const char* d, Manip m,\
			NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13, NAME##_enum i14) const\
			{ return NAME##_cus_field_list<Manip> (this, d, m, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14); } \
	template <class Manip>\
	inline NAME##_cus_equal_list<Manip> NAME::equal_list(const char* d, const char* c, Manip m, \
			NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13, NAME##_enum i14) const\
			{ return NAME##_cus_equal_list<Manip> (this, d, c, m, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14); } \
	template <class Manip>\
	inline NAME##_cus_value_list<Manip> NAME::value_list(const char* d, Manip m,\
			std::vector<bool> *i) const\
			{ return NAME##_cus_value_list<Manip> (this, d, m, i); }\
	template <class Manip>\
	inline NAME##_cus_field_list<Manip> NAME::field_list(const char* d, Manip m,\
			std::vector<bool> *i) const\
			{ return NAME##_cus_field_list<Manip> (this, d, m, i); }\
	template <class Manip>\
	inline NAME##_cus_equal_list<Manip> NAME::equal_list(const char* d, const char* c, Manip m,\
			std::vector<bool> *i) const\
			{ return NAME##_cus_equal_list<Manip> (this, d, c, m, i); }\
	template <class Manip>\
	inline NAME##_cus_value_list<Manip> \
	NAME::value_list(const char* d, Manip m, mysqlpp::sql_cmp_type /*sc*/) const\
			{ sql_compare_type_def_##CMP(NAME, value, NUM); }\
	template <class Manip>\
	inline NAME##_cus_field_list<Manip> \
	NAME::field_list(const char* d, Manip m, mysqlpp::sql_cmp_type /*sc*/) const\
			{ sql_compare_type_def_##CMP(NAME, field, NUM); }\
	template <class Manip>\
	inline NAME##_cus_equal_list<Manip> \
	NAME::equal_list(const char* d, const char* c, Manip m, mysqlpp::sql_cmp_type /*sc*/) const\
			{ sql_compare_type_defe_##CMP(NAME, equal, NUM); }\
	template <mysqlpp::sql_dummy_type dummy>\
	void populate_##NAME(NAME *s, const mysqlpp::Row &row)\
	{\
		mysqlpp::NoExceptions ignore_schema_mismatches(row);\
    s->I1 = row[N1].conv(T1());\
    s->I2 = row[N2].conv(T2());\
    s->I3 = row[N3].conv(T3());\
    s->I4 = row[N4].conv(T4());\
    s->I5 = row[N5].conv(T5());\
    s->I6 = row[N6].conv(T6());\
    s->I7 = row[N7].conv(T7());\
    s->I8 = row[N8].conv(T8());\
    s->I9 = row[N9].conv(T9());\
    s->I10 = row[N10].conv(T10());\
    s->I11 = row[N11].conv(T11());\
    s->I12 = row[N12].conv(T12());\
    s->I13 = row[N13].conv(T13());\
    s->I14 = row[N14].conv(T14());\
	}\
	inline NAME::NAME(const mysqlpp::Row& row) :\
	table_override_(0)\
			{ populate_##NAME<mysqlpp::sql_dummy>(this, row); }\
	inline void NAME::set(const mysqlpp::Row& row)\
	{\
		table_override_ = 0;\
		populate_##NAME<mysqlpp::sql_dummy>(this, row);\
	}\
	sql_COMPARE__##CMP(NAME, I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 )

#define sql_create_14(NAME, CMP, CONTR, T1, I1, T2, I2, T3, I3, T4, I4, T5, I5, T6, I6, T7, I7, T8, I8, T9, I9, T10, I10, T11, I11, T12, I12, T13, I13, T14, I14) \
		sql_create_complete_14(NAME, CMP, CONTR, T1, I1, #I1, T2, I2, #I2, T3, I3, #I3, T4, I4, #I4, T5, I5, #I5, T6, I6, #I6, T7, I7, #I7, T8, I8, #I8, T9, I9, #I9, T10, I10, #I10, T11, I11, #I11, T12, I12, #I12, T13, I13, #I13, T14, I14, #I14) \

// ---------------------------------------------------
//                  End Create 14
// ---------------------------------------------------

// ---------------------------------------------------
//                  Begin Create 15
// ---------------------------------------------------
#define sql_create_complete_15(NAME, CMP, CONTR, T1, I1, N1, T2, I2, N2, T3, I3, N3, T4, I4, N4, T5, I5, N5, T6, I6, N6, T7, I7, N7, T8, I8, N8, T9, I9, N9, T10, I10, N10, T11, I11, N11, T12, I12, N12, T13, I13, N13, T14, I14, N14, T15, I15, N15) \
	struct NAME; \
	enum NAME##_enum { \
    NAME##_##I1,\
    NAME##_##I2,\
    NAME##_##I3,\
    NAME##_##I4,\
    NAME##_##I5,\
    NAME##_##I6,\
    NAME##_##I7,\
    NAME##_##I8,\
    NAME##_##I9,\
    NAME##_##I10,\
    NAME##_##I11,\
    NAME##_##I12,\
    NAME##_##I13,\
    NAME##_##I14,\
    NAME##_##I15 \
	,NAME##_NULL \
	}; \
	template <class Manip>\
	class NAME##_value_list { \
	public: \
	const NAME* obj;\
	const char* delim;\
	Manip manip;\
	public: \
	NAME##_value_list (const NAME* o, const char* d, Manip m) :\
	obj(o), delim(d), manip(m) { } \
	};\
	template <class Manip>\
	class NAME##_##field_list {\
	public: \
	const NAME* obj; \
	const char* delim;\
	Manip manip;\
	public: \
	NAME##_field_list (const NAME* o, const char* d, Manip m) :\
	obj(o), delim(d), manip(m) { } \
	};\
	template <class Manip>\
	class NAME##_equal_list { \
	public: \
	const NAME* obj;\
	const char* delim;\
	const char* comp;\
	Manip manip;\
	public: \
	NAME##_equal_list (const NAME* o, const char* d, const char* c, Manip m) :\
	obj(o), delim(d), comp(c), manip(m) { }\
	};\
	template <class Manip>\
	class NAME##_cus_value_list {\
	public:\
	const NAME* obj;\
	std::vector<bool> *include;\
	bool del_vector;\
	const char* delim;\
	Manip manip;\
	public: \
	~NAME##_cus_value_list () {if (del_vector) delete include;} \
	NAME##_cus_value_list (const NAME* o, const char* d, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13, bool i14, bool i15);\
	NAME##_cus_value_list (const NAME* o, const char* d, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13, NAME##_enum i14, NAME##_enum i15); \
	NAME##_cus_value_list (const NAME* o, const char* d, Manip m ,std::vector<bool>* i) :\
	obj(o), include(i), del_vector(false), delim(d), manip(m) { }\
	};\
	template <class Manip>\
	class NAME##_cus_field_list { \
	public:\
	const NAME* obj; \
	std::vector<bool> *include; \
	bool del_vector; \
	const char* delim;\
	Manip manip;\
	public: \
	~NAME##_cus_field_list () {if (del_vector) delete include;} \
	NAME##_cus_field_list (const NAME* o, const char* d, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13, bool i14, bool i15); \
	NAME##_cus_field_list (const NAME* o, const char* d, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13, NAME##_enum i14, NAME##_enum i15); \
	NAME##_cus_field_list (const NAME* o, const char* d, Manip m, std::vector<bool> *i) :\
	obj(o), include(i), del_vector(false), delim(d), manip(m) { }\
	};\
	template <class Manip>\
	class NAME##_cus_equal_list {\
	public:\
	const NAME* obj;\
	std::vector<bool> *include;\
	bool del_vector;\
	const char* delim;\
	const char* comp;\
	Manip manip;\
	public:\
	~NAME##_##cus_equal_list () {if (del_vector) delete include;}\
	NAME##_##cus_equal_list (const NAME* o, const char* d, const char* c, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13, bool i14, bool i15); \
	NAME##_##cus_equal_list (const NAME* o, const char* d, const char* c, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13, NAME##_enum i14, NAME##_enum i15); \
	NAME##_##cus_equal_list (const NAME* o, const char* d, const char* c, Manip m, std::vector<bool> *i) :\
	obj(o), include(i), del_vector(false), delim(d), comp(c), manip(m) { }\
	};\
	template <mysqlpp::sql_dummy_type dummy> int sql_compare_##NAME(const NAME&, const NAME&);\
	struct NAME {\
    T1 I1;\
    T2 I2;\
    T3 I3;\
    T4 I4;\
    T5 I5;\
    T6 I6;\
    T7 I7;\
    T8 I8;\
    T9 I9;\
    T10 I10;\
    T11 I11;\
    T12 I12;\
    T13 I13;\
    T14 I14;\
    T15 I15; \
	NAME() : table_override_(0) { }\
	NAME(const mysqlpp::Row& row);\
	void set(const mysqlpp::Row &row);\
	sql_compare_define_##CMP(NAME, T1, I1, T2, I2, T3, I3, T4, I4, T5, I5, T6, I6, T7, I7, T8, I8, T9, I9, T10, I10, T11, I11, T12, I12, T13, I13, T14, I14, T15, I15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)\
	sql_construct_define_##CONTR(NAME, T1, I1, T2, I2, T3, I3, T4, I4, T5, I5, T6, I6, T7, I7, T8, I8, T9, I9, T10, I10, T11, I11, T12, I12, T13, I13, T14, I14, T15, I15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)\
	static const char* names[];\
	static void table(const char* t) { table_ = t; }\
	const char* table() const\
			{ return table_override_ ? table_override_ : NAME::table_; }\
	void instance_table(const char* t) { table_override_ = t; }\
	NAME##_value_list<mysqlpp::quote_type0> value_list() const {\
		return value_list(",", mysqlpp::quote);}\
	NAME##_value_list<mysqlpp::quote_type0> value_list(const char* d) const {\
		return value_list(d, mysqlpp::quote);}\
	template <class Manip>\
	NAME##_value_list<Manip> value_list(const char* d, Manip m) const;\
	NAME##_field_list<mysqlpp::do_nothing_type0> field_list() const {\
		return field_list(",", mysqlpp::do_nothing);}\
	NAME##_field_list<mysqlpp::do_nothing_type0> field_list(const char* d) const {\
		return field_list(d, mysqlpp::do_nothing);}\
	template <class Manip>\
	NAME##_field_list<Manip> field_list(const char* d, Manip m) const;\
	NAME##_equal_list<mysqlpp::quote_type0> equal_list(const char* d = ",",\
			const char* c = " = ") const\
			{ return equal_list(d, c, mysqlpp::quote); }\
	template <class Manip>\
	NAME##_equal_list<Manip> equal_list(const char* d, const char* c, Manip m) const;\
	/* cus_data */\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false, bool i15 = false) const\
			{ return value_list(",", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL, NAME##_enum i15 = NAME##_NULL) const\
			{ return value_list(",", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(std::vector<bool> *i) const\
			{ return value_list(",", mysqlpp::quote, i); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(mysqlpp::sql_cmp_type sc) const\
			{ return value_list(",", mysqlpp::quote, sc); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(const char* d, bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false, bool i15 = false) const\
			{ return value_list(d, mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(const char* d, NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL, NAME##_enum i15 = NAME##_NULL) const\
			{ return value_list(d, mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(const char* d,\
			std::vector<bool> *i) const\
			{ return value_list(d, mysqlpp::quote, i); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(const char* d,\
			mysqlpp::sql_cmp_type sc) const\
			{ return value_list(d, mysqlpp::quote, sc); }\
	template <class Manip>\
	NAME##_cus_value_list<Manip> value_list(const char* d, Manip m,\
			bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false, bool i15 = false) const;\
	template <class Manip>\
	NAME##_cus_value_list<Manip> value_list(const char* d, Manip m,\
			NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL, NAME##_enum i15 = NAME##_NULL) const;\
	template <class Manip>\
	NAME##_cus_value_list<Manip> value_list(const char* d, Manip m,\
			std::vector<bool>* i) const;\
	template <class Manip>\
	NAME##_cus_value_list<Manip> value_list(const char* d, Manip m, \
			mysqlpp::sql_cmp_type sc) const;\
	/* cus field */\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false, bool i15 = false) const \
			{ return field_list(",", mysqlpp::do_nothing, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL, NAME##_enum i15 = NAME##_NULL) const\
			{ return field_list(",", mysqlpp::do_nothing, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(std::vector<bool> *i) const\
			{ return field_list(",", mysqlpp::do_nothing, i); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(mysqlpp::sql_cmp_type sc) const\
			{ return field_list(",", mysqlpp::do_nothing, sc); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(const char* d,\
			bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false, bool i15 = false) const\
			{ return field_list(d, mysqlpp::do_nothing, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(const char* d,\
			NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL, NAME##_enum i15 = NAME##_NULL) const\
			{ return field_list(d, mysqlpp::do_nothing, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(const char* d,\
			std::vector<bool>* i) const\
			{ return field_list(d, mysqlpp::do_nothing, i); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(const char* d,\
			mysqlpp::sql_cmp_type sc) const\
			{ return field_list(d, mysqlpp::do_nothing, sc); }\
	template <class Manip>\
	NAME##_cus_field_list<Manip> field_list(const char* d, Manip m,\
			bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false, bool i15 = false) const;\
	template <class Manip>\
	NAME##_cus_field_list<Manip> field_list(const char* d, Manip m,\
			NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL, NAME##_enum i15 = NAME##_NULL) const;\
	template <class Manip>\
	NAME##_cus_field_list<Manip> field_list(const char* d, Manip m,\
			std::vector<bool> *i) const;\
	template <class Manip>\
	NAME##_cus_field_list<Manip> field_list(const char* d, Manip m,\
			mysqlpp::sql_cmp_type sc) const;\
	/* cus equal */\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false, bool i15 = false) const\
			{ return equal_list(",", " = ", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL, NAME##_enum i15 = NAME##_NULL) const\
			{ return equal_list(",", " = ", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(std::vector<bool>* i) const\
			{ return equal_list(",", " = ", mysqlpp::quote, i); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(mysqlpp::sql_cmp_type sc) const\
			{ return equal_list(",", " = ", mysqlpp::quote, sc); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false, bool i15 = false) const\
			{ return equal_list(d, " = ", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL, NAME##_enum i15 = NAME##_NULL) const\
			{ return equal_list(d, " = ", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d,\
			std::vector<bool> *i) const\
			{ return equal_list(d, " = ", mysqlpp::quote, i); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d,\
			mysqlpp::sql_cmp_type sc) const\
			{ return equal_list(d, " = ", mysqlpp::quote, sc); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, const char* c,\
			bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false, bool i15 = false) const\
			{ return equal_list(d, c, mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, const char* c,\
			NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL, NAME##_enum i15 = NAME##_NULL) const\
			{ return equal_list(d, c, mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, const char* c,\
			std::vector<bool> *i) const\
			{ return equal_list(d, c, mysqlpp::quote, i); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, const char* c,\
			mysqlpp::sql_cmp_type sc) const\
			{ return equal_list(d, c, mysqlpp::quote, sc); }\
	template <class Manip>\
	NAME##_cus_equal_list<Manip> equal_list(const char* d, const char* c, Manip m, \
						bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false, bool i15 = false) const;\
	template <class Manip>\
	NAME##_cus_equal_list<Manip> equal_list(const char* d, const char* c, Manip m, \
						NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL, NAME##_enum i15 = NAME##_NULL) const;\
	template <class Manip>\
	NAME##_cus_equal_list<Manip> equal_list(const char* d, const char* c, Manip m, \
						std::vector<bool> *i) const;\
	template <class Manip>\
	NAME##_cus_equal_list<Manip> equal_list(const char* d, const char* c, Manip m, \
						mysqlpp::sql_cmp_type sc) const;\
	private:\
	static const char* table_;\
	const char* table_override_;\
	};\
	MYSQLPP_SSQLS_CONDITIONAL_STATICS(\
		const char* NAME::names[] = {\
			    N1 ,\
    N2 ,\
    N3 ,\
    N4 ,\
    N5 ,\
    N6 ,\
    N7 ,\
    N8 ,\
    N9 ,\
    N10 ,\
    N11 ,\
    N12 ,\
    N13 ,\
    N14 ,\
    N15 \
		};\
		const char* NAME::table_ = #NAME;\
	)\
	template <class Manip>\
	NAME##_cus_value_list<Manip>::NAME##_cus_value_list\
			(const NAME* o, const char* d, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13, bool i14, bool i15)\
	{\
		delim = d;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(15, false);\
    if (i1) (*include)[0]=true;\
    if (i2) (*include)[1]=true;\
    if (i3) (*include)[2]=true;\
    if (i4) (*include)[3]=true;\
    if (i5) (*include)[4]=true;\
    if (i6) (*include)[5]=true;\
    if (i7) (*include)[6]=true;\
    if (i8) (*include)[7]=true;\
    if (i9) (*include)[8]=true;\
    if (i10) (*include)[9]=true;\
    if (i11) (*include)[10]=true;\
    if (i12) (*include)[11]=true;\
    if (i13) (*include)[12]=true;\
    if (i14) (*include)[13]=true;\
    if (i15) (*include)[14]=true;\
	}\
	template <class Manip>\
	NAME##_cus_value_list<Manip>::NAME##_cus_value_list\
			(const NAME* o, const char* d, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13, NAME##_enum i14, NAME##_enum i15)\
	{\
		delim = d;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(15, false);\
    if (i1 == NAME##_NULL) return;\
    (*include)[i1]=true;\
    if (i2 == NAME##_NULL) return;\
    (*include)[i2]=true;\
    if (i3 == NAME##_NULL) return;\
    (*include)[i3]=true;\
    if (i4 == NAME##_NULL) return;\
    (*include)[i4]=true;\
    if (i5 == NAME##_NULL) return;\
    (*include)[i5]=true;\
    if (i6 == NAME##_NULL) return;\
    (*include)[i6]=true;\
    if (i7 == NAME##_NULL) return;\
    (*include)[i7]=true;\
    if (i8 == NAME##_NULL) return;\
    (*include)[i8]=true;\
    if (i9 == NAME##_NULL) return;\
    (*include)[i9]=true;\
    if (i10 == NAME##_NULL) return;\
    (*include)[i10]=true;\
    if (i11 == NAME##_NULL) return;\
    (*include)[i11]=true;\
    if (i12 == NAME##_NULL) return;\
    (*include)[i12]=true;\
    if (i13 == NAME##_NULL) return;\
    (*include)[i13]=true;\
    if (i14 == NAME##_NULL) return;\
    (*include)[i14]=true;\
    if (i15 == NAME##_NULL) return;\
    (*include)[i15]=true;\
	}\
	template <class Manip>\
	NAME##_cus_field_list<Manip>::NAME##_cus_field_list\
			(const NAME* o, const char* d, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13, bool i14, bool i15)\
	{\
		delim = d;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(15, false);\
    if (i1) (*include)[0]=true;\
    if (i2) (*include)[1]=true;\
    if (i3) (*include)[2]=true;\
    if (i4) (*include)[3]=true;\
    if (i5) (*include)[4]=true;\
    if (i6) (*include)[5]=true;\
    if (i7) (*include)[6]=true;\
    if (i8) (*include)[7]=true;\
    if (i9) (*include)[8]=true;\
    if (i10) (*include)[9]=true;\
    if (i11) (*include)[10]=true;\
    if (i12) (*include)[11]=true;\
    if (i13) (*include)[12]=true;\
    if (i14) (*include)[13]=true;\
    if (i15) (*include)[14]=true;\
	}\
	template <class Manip>\
	NAME##_cus_field_list<Manip>::NAME##_cus_field_list\
			(const NAME* o, const char* d, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13, NAME##_enum i14, NAME##_enum i15)\
	{\
		delim = d;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(15, false);\
    if (i1 == NAME##_NULL) return;\
    (*include)[i1]=true;\
    if (i2 == NAME##_NULL) return;\
    (*include)[i2]=true;\
    if (i3 == NAME##_NULL) return;\
    (*include)[i3]=true;\
    if (i4 == NAME##_NULL) return;\
    (*include)[i4]=true;\
    if (i5 == NAME##_NULL) return;\
    (*include)[i5]=true;\
    if (i6 == NAME##_NULL) return;\
    (*include)[i6]=true;\
    if (i7 == NAME##_NULL) return;\
    (*include)[i7]=true;\
    if (i8 == NAME##_NULL) return;\
    (*include)[i8]=true;\
    if (i9 == NAME##_NULL) return;\
    (*include)[i9]=true;\
    if (i10 == NAME##_NULL) return;\
    (*include)[i10]=true;\
    if (i11 == NAME##_NULL) return;\
    (*include)[i11]=true;\
    if (i12 == NAME##_NULL) return;\
    (*include)[i12]=true;\
    if (i13 == NAME##_NULL) return;\
    (*include)[i13]=true;\
    if (i14 == NAME##_NULL) return;\
    (*include)[i14]=true;\
    if (i15 == NAME##_NULL) return;\
    (*include)[i15]=true;\
	}\
	template <class Manip>\
	NAME##_cus_equal_list<Manip>::NAME##_cus_equal_list\
			(const NAME* o, const char* d, const char* c, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13, bool i14, bool i15)\
	{\
		delim = d;\
		comp = c;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(15, false);\
    if (i1) (*include)[0]=true;\
    if (i2) (*include)[1]=true;\
    if (i3) (*include)[2]=true;\
    if (i4) (*include)[3]=true;\
    if (i5) (*include)[4]=true;\
    if (i6) (*include)[5]=true;\
    if (i7) (*include)[6]=true;\
    if (i8) (*include)[7]=true;\
    if (i9) (*include)[8]=true;\
    if (i10) (*include)[9]=true;\
    if (i11) (*include)[10]=true;\
    if (i12) (*include)[11]=true;\
    if (i13) (*include)[12]=true;\
    if (i14) (*include)[13]=true;\
    if (i15) (*include)[14]=true;\
	}\
	template <class Manip>\
	NAME##_cus_equal_list<Manip>::NAME##_cus_equal_list\
			(const NAME* o, const char* d, const char* c, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13, NAME##_enum i14, NAME##_enum i15)\
	{\
		delim = d;\
		comp = c;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(15, false);\
    if (i1 == NAME##_NULL) return;\
    (*include)[i1]=true;\
    if (i2 == NAME##_NULL) return;\
    (*include)[i2]=true;\
    if (i3 == NAME##_NULL) return;\
    (*include)[i3]=true;\
    if (i4 == NAME##_NULL) return;\
    (*include)[i4]=true;\
    if (i5 == NAME##_NULL) return;\
    (*include)[i5]=true;\
    if (i6 == NAME##_NULL) return;\
    (*include)[i6]=true;\
    if (i7 == NAME##_NULL) return;\
    (*include)[i7]=true;\
    if (i8 == NAME##_NULL) return;\
    (*include)[i8]=true;\
    if (i9 == NAME##_NULL) return;\
    (*include)[i9]=true;\
    if (i10 == NAME##_NULL) return;\
    (*include)[i10]=true;\
    if (i11 == NAME##_NULL) return;\
    (*include)[i11]=true;\
    if (i12 == NAME##_NULL) return;\
    (*include)[i12]=true;\
    if (i13 == NAME##_NULL) return;\
    (*include)[i13]=true;\
    if (i14 == NAME##_NULL) return;\
    (*include)[i14]=true;\
    if (i15 == NAME##_NULL) return;\
    (*include)[i15]=true;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_value_list<Manip>& obj)\
	{\
    s << obj.manip << obj.obj->I1 << obj.delim;\
    s << obj.manip << obj.obj->I2 << obj.delim;\
    s << obj.manip << obj.obj->I3 << obj.delim;\
    s << obj.manip << obj.obj->I4 << obj.delim;\
    s << obj.manip << obj.obj->I5 << obj.delim;\
    s << obj.manip << obj.obj->I6 << obj.delim;\
    s << obj.manip << obj.obj->I7 << obj.delim;\
    s << obj.manip << obj.obj->I8 << obj.delim;\
    s << obj.manip << obj.obj->I9 << obj.delim;\
    s << obj.manip << obj.obj->I10 << obj.delim;\
    s << obj.manip << obj.obj->I11 << obj.delim;\
    s << obj.manip << obj.obj->I12 << obj.delim;\
    s << obj.manip << obj.obj->I13 << obj.delim;\
    s << obj.manip << obj.obj->I14 << obj.delim;\
    s << obj.manip << obj.obj->I15;\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_field_list<Manip>& obj)\
	{\
    s << obj.manip << '`' << obj.obj->names[0] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[1] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[2] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[3] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[4] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[5] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[6] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[7] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[8] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[9] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[10] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[11] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[12] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[13] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[14] << '`';\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_equal_list<Manip>& obj)\
	{\
    s << '`' << obj.obj->names[0] << '`' << obj.comp << obj.manip << obj.obj->I1 << obj.delim;\
    s << '`' << obj.obj->names[1] << '`' << obj.comp << obj.manip << obj.obj->I2 << obj.delim;\
    s << '`' << obj.obj->names[2] << '`' << obj.comp << obj.manip << obj.obj->I3 << obj.delim;\
    s << '`' << obj.obj->names[3] << '`' << obj.comp << obj.manip << obj.obj->I4 << obj.delim;\
    s << '`' << obj.obj->names[4] << '`' << obj.comp << obj.manip << obj.obj->I5 << obj.delim;\
    s << '`' << obj.obj->names[5] << '`' << obj.comp << obj.manip << obj.obj->I6 << obj.delim;\
    s << '`' << obj.obj->names[6] << '`' << obj.comp << obj.manip << obj.obj->I7 << obj.delim;\
    s << '`' << obj.obj->names[7] << '`' << obj.comp << obj.manip << obj.obj->I8 << obj.delim;\
    s << '`' << obj.obj->names[8] << '`' << obj.comp << obj.manip << obj.obj->I9 << obj.delim;\
    s << '`' << obj.obj->names[9] << '`' << obj.comp << obj.manip << obj.obj->I10 << obj.delim;\
    s << '`' << obj.obj->names[10] << '`' << obj.comp << obj.manip << obj.obj->I11 << obj.delim;\
    s << '`' << obj.obj->names[11] << '`' << obj.comp << obj.manip << obj.obj->I12 << obj.delim;\
    s << '`' << obj.obj->names[12] << '`' << obj.comp << obj.manip << obj.obj->I13 << obj.delim;\
    s << '`' << obj.obj->names[13] << '`' << obj.comp << obj.manip << obj.obj->I14 << obj.delim;\
    s << '`' << obj.obj->names[14] << '`' << obj.comp << obj.manip << obj.obj->I15;\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_cus_value_list<Manip>& obj)\
	{\
		bool before = false;\
    if ((*obj.include)[0]) { \
      s << obj.manip << obj.obj->I1;\
      before = true; \
     } \
    if ((*obj.include)[1]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I2;\
      before = true; \
     } \
    if ((*obj.include)[2]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I3;\
      before = true; \
     } \
    if ((*obj.include)[3]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I4;\
      before = true; \
     } \
    if ((*obj.include)[4]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I5;\
      before = true; \
     } \
    if ((*obj.include)[5]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I6;\
      before = true; \
     } \
    if ((*obj.include)[6]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I7;\
      before = true; \
     } \
    if ((*obj.include)[7]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I8;\
      before = true; \
     } \
    if ((*obj.include)[8]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I9;\
      before = true; \
     } \
    if ((*obj.include)[9]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I10;\
      before = true; \
     } \
    if ((*obj.include)[10]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I11;\
      before = true; \
     } \
    if ((*obj.include)[11]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I12;\
      before = true; \
     } \
    if ((*obj.include)[12]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I13;\
      before = true; \
     } \
    if ((*obj.include)[13]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I14;\
      before = true; \
     } \
    if ((*obj.include)[14]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I15;\
     } \
        (void)before;\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_cus_field_list<Manip>& obj)\
	{\
		bool before = false;\
    if ((*obj.include)[0]) { \
      s << obj.manip << '`' << obj.obj->names[0] << '`';\
      before = true; \
     } \
    if ((*obj.include)[1]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[1] << '`';\
      before = true; \
     } \
    if ((*obj.include)[2]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[2] << '`';\
      before = true; \
     } \
    if ((*obj.include)[3]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[3] << '`';\
      before = true; \
     } \
    if ((*obj.include)[4]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[4] << '`';\
      before = true; \
     } \
    if ((*obj.include)[5]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[5] << '`';\
      before = true; \
     } \
    if ((*obj.include)[6]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[6] << '`';\
      before = true; \
     } \
    if ((*obj.include)[7]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[7] << '`';\
      before = true; \
     } \
    if ((*obj.include)[8]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[8] << '`';\
      before = true; \
     } \
    if ((*obj.include)[9]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[9] << '`';\
      before = true; \
     } \
    if ((*obj.include)[10]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[10] << '`';\
      before = true; \
     } \
    if ((*obj.include)[11]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[11] << '`';\
      before = true; \
     } \
    if ((*obj.include)[12]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[12] << '`';\
      before = true; \
     } \
    if ((*obj.include)[13]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[13] << '`';\
      before = true; \
     } \
    if ((*obj.include)[14]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[14] << '`';\
     } \
        (void)before;\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_cus_equal_list<Manip>& obj)\
	{\
		bool before = false;\
    if ((*obj.include)[0]) { \
      s << '`' << obj.obj->names[0] << '`' << obj.comp << obj.manip << obj.obj->I1;\
      before = true; \
     } \
    if ((*obj.include)[1]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[1] << '`' << obj.comp << obj.manip << obj.obj->I2;\
      before = true; \
     } \
    if ((*obj.include)[2]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[2] << '`' << obj.comp << obj.manip << obj.obj->I3;\
      before = true; \
     } \
    if ((*obj.include)[3]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[3] << '`' << obj.comp << obj.manip << obj.obj->I4;\
      before = true; \
     } \
    if ((*obj.include)[4]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[4] << '`' << obj.comp << obj.manip << obj.obj->I5;\
      before = true; \
     } \
    if ((*obj.include)[5]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[5] << '`' << obj.comp << obj.manip << obj.obj->I6;\
      before = true; \
     } \
    if ((*obj.include)[6]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[6] << '`' << obj.comp << obj.manip << obj.obj->I7;\
      before = true; \
     } \
    if ((*obj.include)[7]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[7] << '`' << obj.comp << obj.manip << obj.obj->I8;\
      before = true; \
     } \
    if ((*obj.include)[8]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[8] << '`' << obj.comp << obj.manip << obj.obj->I9;\
      before = true; \
     } \
    if ((*obj.include)[9]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[9] << '`' << obj.comp << obj.manip << obj.obj->I10;\
      before = true; \
     } \
    if ((*obj.include)[10]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[10] << '`' << obj.comp << obj.manip << obj.obj->I11;\
      before = true; \
     } \
    if ((*obj.include)[11]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[11] << '`' << obj.comp << obj.manip << obj.obj->I12;\
      before = true; \
     } \
    if ((*obj.include)[12]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[12] << '`' << obj.comp << obj.manip << obj.obj->I13;\
      before = true; \
     } \
    if ((*obj.include)[13]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[13] << '`' << obj.comp << obj.manip << obj.obj->I14;\
      before = true; \
     } \
    if ((*obj.include)[14]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[14] << '`' << obj.comp << obj.manip << obj.obj->I15;\
     } \
        (void)before;\
		return s;\
	}\
	template <class Manip>\
	inline NAME##_value_list<Manip> NAME::value_list(const char* d, Manip m) const\
			{ return NAME##_value_list<Manip> (this, d, m); } \
	template <class Manip>\
	inline NAME##_field_list<Manip> NAME::field_list(const char* d, Manip m) const\
			{ return NAME##_field_list<Manip> (this, d, m); } \
	template <class Manip>\
	inline NAME##_equal_list<Manip> NAME::equal_list(const char* d, const char* c, Manip m) const\
			{ return NAME##_equal_list<Manip> (this, d, c, m); } \
	template <class Manip>\
	inline NAME##_cus_value_list<Manip> NAME::value_list(const char* d, Manip m,\
			bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13, bool i14, bool i15) const\
			{ return NAME##_cus_value_list<Manip> (this, d, m, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15); }\
	template <class Manip>\
	inline NAME##_cus_field_list<Manip> NAME::field_list(const char* d, Manip m,\
			bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13, bool i14, bool i15) const\
			{ return NAME##_cus_field_list<Manip> (this, d, m, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15); }\
	template <class Manip>\
	inline NAME##_cus_equal_list<Manip> NAME::equal_list(const char* d, const char* c, Manip m,\
			bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13, bool i14, bool i15) const\
			{ return NAME##_cus_equal_list<Manip> (this, d, c, m, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15); } \
	template <class Manip>\
	inline NAME##_cus_value_list<Manip> NAME::value_list(const char* d, Manip m,\
			NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13, NAME##_enum i14, NAME##_enum i15) const\
			{ return NAME##_cus_value_list<Manip> (this, d, m, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15); } \
	template <class Manip>\
	inline NAME##_cus_field_list<Manip> NAME::field_list(const char* d, Manip m,\
			NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13, NAME##_enum i14, NAME##_enum i15) const\
			{ return NAME##_cus_field_list<Manip> (this, d, m, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15); } \
	template <class Manip>\
	inline NAME##_cus_equal_list<Manip> NAME::equal_list(const char* d, const char* c, Manip m, \
			NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13, NAME##_enum i14, NAME##_enum i15) const\
			{ return NAME##_cus_equal_list<Manip> (this, d, c, m, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15); } \
	template <class Manip>\
	inline NAME##_cus_value_list<Manip> NAME::value_list(const char* d, Manip m,\
			std::vector<bool> *i) const\
			{ return NAME##_cus_value_list<Manip> (this, d, m, i); }\
	template <class Manip>\
	inline NAME##_cus_field_list<Manip> NAME::field_list(const char* d, Manip m,\
			std::vector<bool> *i) const\
			{ return NAME##_cus_field_list<Manip> (this, d, m, i); }\
	template <class Manip>\
	inline NAME##_cus_equal_list<Manip> NAME::equal_list(const char* d, const char* c, Manip m,\
			std::vector<bool> *i) const\
			{ return NAME##_cus_equal_list<Manip> (this, d, c, m, i); }\
	template <class Manip>\
	inline NAME##_cus_value_list<Manip> \
	NAME::value_list(const char* d, Manip m, mysqlpp::sql_cmp_type /*sc*/) const\
			{ sql_compare_type_def_##CMP(NAME, value, NUM); }\
	template <class Manip>\
	inline NAME##_cus_field_list<Manip> \
	NAME::field_list(const char* d, Manip m, mysqlpp::sql_cmp_type /*sc*/) const\
			{ sql_compare_type_def_##CMP(NAME, field, NUM); }\
	template <class Manip>\
	inline NAME##_cus_equal_list<Manip> \
	NAME::equal_list(const char* d, const char* c, Manip m, mysqlpp::sql_cmp_type /*sc*/) const\
			{ sql_compare_type_defe_##CMP(NAME, equal, NUM); }\
	template <mysqlpp::sql_dummy_type dummy>\
	void populate_##NAME(NAME *s, const mysqlpp::Row &row)\
	{\
		mysqlpp::NoExceptions ignore_schema_mismatches(row);\
    s->I1 = row[N1].conv(T1());\
    s->I2 = row[N2].conv(T2());\
    s->I3 = row[N3].conv(T3());\
    s->I4 = row[N4].conv(T4());\
    s->I5 = row[N5].conv(T5());\
    s->I6 = row[N6].conv(T6());\
    s->I7 = row[N7].conv(T7());\
    s->I8 = row[N8].conv(T8());\
    s->I9 = row[N9].conv(T9());\
    s->I10 = row[N10].conv(T10());\
    s->I11 = row[N11].conv(T11());\
    s->I12 = row[N12].conv(T12());\
    s->I13 = row[N13].conv(T13());\
    s->I14 = row[N14].conv(T14());\
    s->I15 = row[N15].conv(T15());\
	}\
	inline NAME::NAME(const mysqlpp::Row& row) :\
	table_override_(0)\
			{ populate_##NAME<mysqlpp::sql_dummy>(this, row); }\
	inline void NAME::set(const mysqlpp::Row& row)\
	{\
		table_override_ = 0;\
		populate_##NAME<mysqlpp::sql_dummy>(this, row);\
	}\
	sql_COMPARE__##CMP(NAME, I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 )

#define sql_create_15(NAME, CMP, CONTR, T1, I1, T2, I2, T3, I3, T4, I4, T5, I5, T6, I6, T7, I7, T8, I8, T9, I9, T10, I10, T11, I11, T12, I12, T13, I13, T14, I14, T15, I15) \
		sql_create_complete_15(NAME, CMP, CONTR, T1, I1, #I1, T2, I2, #I2, T3, I3, #I3, T4, I4, #I4, T5, I5, #I5, T6, I6, #I6, T7, I7, #I7, T8, I8, #I8, T9, I9, #I9, T10, I10, #I10, T11, I11, #I11, T12, I12, #I12, T13, I13, #I13, T14, I14, #I14, T15, I15, #I15) \

// ---------------------------------------------------
//                  End Create 15
// ---------------------------------------------------

// ---------------------------------------------------
//                  Begin Create 16
// ---------------------------------------------------
#define sql_create_complete_16(NAME, CMP, CONTR, T1, I1, N1, T2, I2, N2, T3, I3, N3, T4, I4, N4, T5, I5, N5, T6, I6, N6, T7, I7, N7, T8, I8, N8, T9, I9, N9, T10, I10, N10, T11, I11, N11, T12, I12, N12, T13, I13, N13, T14, I14, N14, T15, I15, N15, T16, I16, N16) \
	struct NAME; \
	enum NAME##_enum { \
    NAME##_##I1,\
    NAME##_##I2,\
    NAME##_##I3,\
    NAME##_##I4,\
    NAME##_##I5,\
    NAME##_##I6,\
    NAME##_##I7,\
    NAME##_##I8,\
    NAME##_##I9,\
    NAME##_##I10,\
    NAME##_##I11,\
    NAME##_##I12,\
    NAME##_##I13,\
    NAME##_##I14,\
    NAME##_##I15,\
    NAME##_##I16 \
	,NAME##_NULL \
	}; \
	template <class Manip>\
	class NAME##_value_list { \
	public: \
	const NAME* obj;\
	const char* delim;\
	Manip manip;\
	public: \
	NAME##_value_list (const NAME* o, const char* d, Manip m) :\
	obj(o), delim(d), manip(m) { } \
	};\
	template <class Manip>\
	class NAME##_##field_list {\
	public: \
	const NAME* obj; \
	const char* delim;\
	Manip manip;\
	public: \
	NAME##_field_list (const NAME* o, const char* d, Manip m) :\
	obj(o), delim(d), manip(m) { } \
	};\
	template <class Manip>\
	class NAME##_equal_list { \
	public: \
	const NAME* obj;\
	const char* delim;\
	const char* comp;\
	Manip manip;\
	public: \
	NAME##_equal_list (const NAME* o, const char* d, const char* c, Manip m) :\
	obj(o), delim(d), comp(c), manip(m) { }\
	};\
	template <class Manip>\
	class NAME##_cus_value_list {\
	public:\
	const NAME* obj;\
	std::vector<bool> *include;\
	bool del_vector;\
	const char* delim;\
	Manip manip;\
	public: \
	~NAME##_cus_value_list () {if (del_vector) delete include;} \
	NAME##_cus_value_list (const NAME* o, const char* d, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13, bool i14, bool i15, bool i16);\
	NAME##_cus_value_list (const NAME* o, const char* d, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13, NAME##_enum i14, NAME##_enum i15, NAME##_enum i16); \
	NAME##_cus_value_list (const NAME* o, const char* d, Manip m ,std::vector<bool>* i) :\
	obj(o), include(i), del_vector(false), delim(d), manip(m) { }\
	};\
	template <class Manip>\
	class NAME##_cus_field_list { \
	public:\
	const NAME* obj; \
	std::vector<bool> *include; \
	bool del_vector; \
	const char* delim;\
	Manip manip;\
	public: \
	~NAME##_cus_field_list () {if (del_vector) delete include;} \
	NAME##_cus_field_list (const NAME* o, const char* d, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13, bool i14, bool i15, bool i16); \
	NAME##_cus_field_list (const NAME* o, const char* d, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13, NAME##_enum i14, NAME##_enum i15, NAME##_enum i16); \
	NAME##_cus_field_list (const NAME* o, const char* d, Manip m, std::vector<bool> *i) :\
	obj(o), include(i), del_vector(false), delim(d), manip(m) { }\
	};\
	template <class Manip>\
	class NAME##_cus_equal_list {\
	public:\
	const NAME* obj;\
	std::vector<bool> *include;\
	bool del_vector;\
	const char* delim;\
	const char* comp;\
	Manip manip;\
	public:\
	~NAME##_##cus_equal_list () {if (del_vector) delete include;}\
	NAME##_##cus_equal_list (const NAME* o, const char* d, const char* c, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13, bool i14, bool i15, bool i16); \
	NAME##_##cus_equal_list (const NAME* o, const char* d, const char* c, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13, NAME##_enum i14, NAME##_enum i15, NAME##_enum i16); \
	NAME##_##cus_equal_list (const NAME* o, const char* d, const char* c, Manip m, std::vector<bool> *i) :\
	obj(o), include(i), del_vector(false), delim(d), comp(c), manip(m) { }\
	};\
	template <mysqlpp::sql_dummy_type dummy> int sql_compare_##NAME(const NAME&, const NAME&);\
	struct NAME {\
    T1 I1;\
    T2 I2;\
    T3 I3;\
    T4 I4;\
    T5 I5;\
    T6 I6;\
    T7 I7;\
    T8 I8;\
    T9 I9;\
    T10 I10;\
    T11 I11;\
    T12 I12;\
    T13 I13;\
    T14 I14;\
    T15 I15;\
    T16 I16; \
	NAME() : table_override_(0) { }\
	NAME(const mysqlpp::Row& row);\
	void set(const mysqlpp::Row &row);\
	sql_compare_define_##CMP(NAME, T1, I1, T2, I2, T3, I3, T4, I4, T5, I5, T6, I6, T7, I7, T8, I8, T9, I9, T10, I10, T11, I11, T12, I12, T13, I13, T14, I14, T15, I15, T16, I16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)\
	sql_construct_define_##CONTR(NAME, T1, I1, T2, I2, T3, I3, T4, I4, T5, I5, T6, I6, T7, I7, T8, I8, T9, I9, T10, I10, T11, I11, T12, I12, T13, I13, T14, I14, T15, I15, T16, I16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)\
	static const char* names[];\
	static void table(const char* t) { table_ = t; }\
	const char* table() const\
			{ return table_override_ ? table_override_ : NAME::table_; }\
	void instance_table(const char* t) { table_override_ = t; }\
	NAME##_value_list<mysqlpp::quote_type0> value_list() const {\
		return value_list(",", mysqlpp::quote);}\
	NAME##_value_list<mysqlpp::quote_type0> value_list(const char* d) const {\
		return value_list(d, mysqlpp::quote);}\
	template <class Manip>\
	NAME##_value_list<Manip> value_list(const char* d, Manip m) const;\
	NAME##_field_list<mysqlpp::do_nothing_type0> field_list() const {\
		return field_list(",", mysqlpp::do_nothing);}\
	NAME##_field_list<mysqlpp::do_nothing_type0> field_list(const char* d) const {\
		return field_list(d, mysqlpp::do_nothing);}\
	template <class Manip>\
	NAME##_field_list<Manip> field_list(const char* d, Manip m) const;\
	NAME##_equal_list<mysqlpp::quote_type0> equal_list(const char* d = ",",\
			const char* c = " = ") const\
			{ return equal_list(d, c, mysqlpp::quote); }\
	template <class Manip>\
	NAME##_equal_list<Manip> equal_list(const char* d, const char* c, Manip m) const;\
	/* cus_data */\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false, bool i15 = false, bool i16 = false) const\
			{ return value_list(",", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL, NAME##_enum i15 = NAME##_NULL, NAME##_enum i16 = NAME##_NULL) const\
			{ return value_list(",", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(std::vector<bool> *i) const\
			{ return value_list(",", mysqlpp::quote, i); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(mysqlpp::sql_cmp_type sc) const\
			{ return value_list(",", mysqlpp::quote, sc); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(const char* d, bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false, bool i15 = false, bool i16 = false) const\
			{ return value_list(d, mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(const char* d, NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL, NAME##_enum i15 = NAME##_NULL, NAME##_enum i16 = NAME##_NULL) const\
			{ return value_list(d, mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(const char* d,\
			std::vector<bool> *i) const\
			{ return value_list(d, mysqlpp::quote, i); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(const char* d,\
			mysqlpp::sql_cmp_type sc) const\
			{ return value_list(d, mysqlpp::quote, sc); }\
	template <class Manip>\
	NAME##_cus_value_list<Manip> value_list(const char* d, Manip m,\
			bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false, bool i15 = false, bool i16 = false) const;\
	template <class Manip>\
	NAME##_cus_value_list<Manip> value_list(const char* d, Manip m,\
			NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL, NAME##_enum i15 = NAME##_NULL, NAME##_enum i16 = NAME##_NULL) const;\
	template <class Manip>\
	NAME##_cus_value_list<Manip> value_list(const char* d, Manip m,\
			std::vector<bool>* i) const;\
	template <class Manip>\
	NAME##_cus_value_list<Manip> value_list(const char* d, Manip m, \
			mysqlpp::sql_cmp_type sc) const;\
	/* cus field */\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false, bool i15 = false, bool i16 = false) const \
			{ return field_list(",", mysqlpp::do_nothing, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL, NAME##_enum i15 = NAME##_NULL, NAME##_enum i16 = NAME##_NULL) const\
			{ return field_list(",", mysqlpp::do_nothing, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(std::vector<bool> *i) const\
			{ return field_list(",", mysqlpp::do_nothing, i); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(mysqlpp::sql_cmp_type sc) const\
			{ return field_list(",", mysqlpp::do_nothing, sc); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(const char* d,\
			bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false, bool i15 = false, bool i16 = false) const\
			{ return field_list(d, mysqlpp::do_nothing, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(const char* d,\
			NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL, NAME##_enum i15 = NAME##_NULL, NAME##_enum i16 = NAME##_NULL) const\
			{ return field_list(d, mysqlpp::do_nothing, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(const char* d,\
			std::vector<bool>* i) const\
			{ return field_list(d, mysqlpp::do_nothing, i); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(const char* d,\
			mysqlpp::sql_cmp_type sc) const\
			{ return field_list(d, mysqlpp::do_nothing, sc); }\
	template <class Manip>\
	NAME##_cus_field_list<Manip> field_list(const char* d, Manip m,\
			bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false, bool i15 = false, bool i16 = false) const;\
	template <class Manip>\
	NAME##_cus_field_list<Manip> field_list(const char* d, Manip m,\
			NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL, NAME##_enum i15 = NAME##_NULL, NAME##_enum i16 = NAME##_NULL) const;\
	template <class Manip>\
	NAME##_cus_field_list<Manip> field_list(const char* d, Manip m,\
			std::vector<bool> *i) const;\
	template <class Manip>\
	NAME##_cus_field_list<Manip> field_list(const char* d, Manip m,\
			mysqlpp::sql_cmp_type sc) const;\
	/* cus equal */\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false, bool i15 = false, bool i16 = false) const\
			{ return equal_list(",", " = ", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL, NAME##_enum i15 = NAME##_NULL, NAME##_enum i16 = NAME##_NULL) const\
			{ return equal_list(",", " = ", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(std::vector<bool>* i) const\
			{ return equal_list(",", " = ", mysqlpp::quote, i); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(mysqlpp::sql_cmp_type sc) const\
			{ return equal_list(",", " = ", mysqlpp::quote, sc); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false, bool i15 = false, bool i16 = false) const\
			{ return equal_list(d, " = ", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL, NAME##_enum i15 = NAME##_NULL, NAME##_enum i16 = NAME##_NULL) const\
			{ return equal_list(d, " = ", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d,\
			std::vector<bool> *i) const\
			{ return equal_list(d, " = ", mysqlpp::quote, i); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d,\
			mysqlpp::sql_cmp_type sc) const\
			{ return equal_list(d, " = ", mysqlpp::quote, sc); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, const char* c,\
			bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false, bool i15 = false, bool i16 = false) const\
			{ return equal_list(d, c, mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, const char* c,\
			NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL, NAME##_enum i15 = NAME##_NULL, NAME##_enum i16 = NAME##_NULL) const\
			{ return equal_list(d, c, mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, const char* c,\
			std::vector<bool> *i) const\
			{ return equal_list(d, c, mysqlpp::quote, i); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, const char* c,\
			mysqlpp::sql_cmp_type sc) const\
			{ return equal_list(d, c, mysqlpp::quote, sc); }\
	template <class Manip>\
	NAME##_cus_equal_list<Manip> equal_list(const char* d, const char* c, Manip m, \
						bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false, bool i15 = false, bool i16 = false) const;\
	template <class Manip>\
	NAME##_cus_equal_list<Manip> equal_list(const char* d, const char* c, Manip m, \
						NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL, NAME##_enum i15 = NAME##_NULL, NAME##_enum i16 = NAME##_NULL) const;\
	template <class Manip>\
	NAME##_cus_equal_list<Manip> equal_list(const char* d, const char* c, Manip m, \
						std::vector<bool> *i) const;\
	template <class Manip>\
	NAME##_cus_equal_list<Manip> equal_list(const char* d, const char* c, Manip m, \
						mysqlpp::sql_cmp_type sc) const;\
	private:\
	static const char* table_;\
	const char* table_override_;\
	};\
	MYSQLPP_SSQLS_CONDITIONAL_STATICS(\
		const char* NAME::names[] = {\
			    N1 ,\
    N2 ,\
    N3 ,\
    N4 ,\
    N5 ,\
    N6 ,\
    N7 ,\
    N8 ,\
    N9 ,\
    N10 ,\
    N11 ,\
    N12 ,\
    N13 ,\
    N14 ,\
    N15 ,\
    N16 \
		};\
		const char* NAME::table_ = #NAME;\
	)\
	template <class Manip>\
	NAME##_cus_value_list<Manip>::NAME##_cus_value_list\
			(const NAME* o, const char* d, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13, bool i14, bool i15, bool i16)\
	{\
		delim = d;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(16, false);\
    if (i1) (*include)[0]=true;\
    if (i2) (*include)[1]=true;\
    if (i3) (*include)[2]=true;\
    if (i4) (*include)[3]=true;\
    if (i5) (*include)[4]=true;\
    if (i6) (*include)[5]=true;\
    if (i7) (*include)[6]=true;\
    if (i8) (*include)[7]=true;\
    if (i9) (*include)[8]=true;\
    if (i10) (*include)[9]=true;\
    if (i11) (*include)[10]=true;\
    if (i12) (*include)[11]=true;\
    if (i13) (*include)[12]=true;\
    if (i14) (*include)[13]=true;\
    if (i15) (*include)[14]=true;\
    if (i16) (*include)[15]=true;\
	}\
	template <class Manip>\
	NAME##_cus_value_list<Manip>::NAME##_cus_value_list\
			(const NAME* o, const char* d, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13, NAME##_enum i14, NAME##_enum i15, NAME##_enum i16)\
	{\
		delim = d;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(16, false);\
    if (i1 == NAME##_NULL) return;\
    (*include)[i1]=true;\
    if (i2 == NAME##_NULL) return;\
    (*include)[i2]=true;\
    if (i3 == NAME##_NULL) return;\
    (*include)[i3]=true;\
    if (i4 == NAME##_NULL) return;\
    (*include)[i4]=true;\
    if (i5 == NAME##_NULL) return;\
    (*include)[i5]=true;\
    if (i6 == NAME##_NULL) return;\
    (*include)[i6]=true;\
    if (i7 == NAME##_NULL) return;\
    (*include)[i7]=true;\
    if (i8 == NAME##_NULL) return;\
    (*include)[i8]=true;\
    if (i9 == NAME##_NULL) return;\
    (*include)[i9]=true;\
    if (i10 == NAME##_NULL) return;\
    (*include)[i10]=true;\
    if (i11 == NAME##_NULL) return;\
    (*include)[i11]=true;\
    if (i12 == NAME##_NULL) return;\
    (*include)[i12]=true;\
    if (i13 == NAME##_NULL) return;\
    (*include)[i13]=true;\
    if (i14 == NAME##_NULL) return;\
    (*include)[i14]=true;\
    if (i15 == NAME##_NULL) return;\
    (*include)[i15]=true;\
    if (i16 == NAME##_NULL) return;\
    (*include)[i16]=true;\
	}\
	template <class Manip>\
	NAME##_cus_field_list<Manip>::NAME##_cus_field_list\
			(const NAME* o, const char* d, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13, bool i14, bool i15, bool i16)\
	{\
		delim = d;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(16, false);\
    if (i1) (*include)[0]=true;\
    if (i2) (*include)[1]=true;\
    if (i3) (*include)[2]=true;\
    if (i4) (*include)[3]=true;\
    if (i5) (*include)[4]=true;\
    if (i6) (*include)[5]=true;\
    if (i7) (*include)[6]=true;\
    if (i8) (*include)[7]=true;\
    if (i9) (*include)[8]=true;\
    if (i10) (*include)[9]=true;\
    if (i11) (*include)[10]=true;\
    if (i12) (*include)[11]=true;\
    if (i13) (*include)[12]=true;\
    if (i14) (*include)[13]=true;\
    if (i15) (*include)[14]=true;\
    if (i16) (*include)[15]=true;\
	}\
	template <class Manip>\
	NAME##_cus_field_list<Manip>::NAME##_cus_field_list\
			(const NAME* o, const char* d, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13, NAME##_enum i14, NAME##_enum i15, NAME##_enum i16)\
	{\
		delim = d;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(16, false);\
    if (i1 == NAME##_NULL) return;\
    (*include)[i1]=true;\
    if (i2 == NAME##_NULL) return;\
    (*include)[i2]=true;\
    if (i3 == NAME##_NULL) return;\
    (*include)[i3]=true;\
    if (i4 == NAME##_NULL) return;\
    (*include)[i4]=true;\
    if (i5 == NAME##_NULL) return;\
    (*include)[i5]=true;\
    if (i6 == NAME##_NULL) return;\
    (*include)[i6]=true;\
    if (i7 == NAME##_NULL) return;\
    (*include)[i7]=true;\
    if (i8 == NAME##_NULL) return;\
    (*include)[i8]=true;\
    if (i9 == NAME##_NULL) return;\
    (*include)[i9]=true;\
    if (i10 == NAME##_NULL) return;\
    (*include)[i10]=true;\
    if (i11 == NAME##_NULL) return;\
    (*include)[i11]=true;\
    if (i12 == NAME##_NULL) return;\
    (*include)[i12]=true;\
    if (i13 == NAME##_NULL) return;\
    (*include)[i13]=true;\
    if (i14 == NAME##_NULL) return;\
    (*include)[i14]=true;\
    if (i15 == NAME##_NULL) return;\
    (*include)[i15]=true;\
    if (i16 == NAME##_NULL) return;\
    (*include)[i16]=true;\
	}\
	template <class Manip>\
	NAME##_cus_equal_list<Manip>::NAME##_cus_equal_list\
			(const NAME* o, const char* d, const char* c, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13, bool i14, bool i15, bool i16)\
	{\
		delim = d;\
		comp = c;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(16, false);\
    if (i1) (*include)[0]=true;\
    if (i2) (*include)[1]=true;\
    if (i3) (*include)[2]=true;\
    if (i4) (*include)[3]=true;\
    if (i5) (*include)[4]=true;\
    if (i6) (*include)[5]=true;\
    if (i7) (*include)[6]=true;\
    if (i8) (*include)[7]=true;\
    if (i9) (*include)[8]=true;\
    if (i10) (*include)[9]=true;\
    if (i11) (*include)[10]=true;\
    if (i12) (*include)[11]=true;\
    if (i13) (*include)[12]=true;\
    if (i14) (*include)[13]=true;\
    if (i15) (*include)[14]=true;\
    if (i16) (*include)[15]=true;\
	}\
	template <class Manip>\
	NAME##_cus_equal_list<Manip>::NAME##_cus_equal_list\
			(const NAME* o, const char* d, const char* c, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13, NAME##_enum i14, NAME##_enum i15, NAME##_enum i16)\
	{\
		delim = d;\
		comp = c;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(16, false);\
    if (i1 == NAME##_NULL) return;\
    (*include)[i1]=true;\
    if (i2 == NAME##_NULL) return;\
    (*include)[i2]=true;\
    if (i3 == NAME##_NULL) return;\
    (*include)[i3]=true;\
    if (i4 == NAME##_NULL) return;\
    (*include)[i4]=true;\
    if (i5 == NAME##_NULL) return;\
    (*include)[i5]=true;\
    if (i6 == NAME##_NULL) return;\
    (*include)[i6]=true;\
    if (i7 == NAME##_NULL) return;\
    (*include)[i7]=true;\
    if (i8 == NAME##_NULL) return;\
    (*include)[i8]=true;\
    if (i9 == NAME##_NULL) return;\
    (*include)[i9]=true;\
    if (i10 == NAME##_NULL) return;\
    (*include)[i10]=true;\
    if (i11 == NAME##_NULL) return;\
    (*include)[i11]=true;\
    if (i12 == NAME##_NULL) return;\
    (*include)[i12]=true;\
    if (i13 == NAME##_NULL) return;\
    (*include)[i13]=true;\
    if (i14 == NAME##_NULL) return;\
    (*include)[i14]=true;\
    if (i15 == NAME##_NULL) return;\
    (*include)[i15]=true;\
    if (i16 == NAME##_NULL) return;\
    (*include)[i16]=true;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_value_list<Manip>& obj)\
	{\
    s << obj.manip << obj.obj->I1 << obj.delim;\
    s << obj.manip << obj.obj->I2 << obj.delim;\
    s << obj.manip << obj.obj->I3 << obj.delim;\
    s << obj.manip << obj.obj->I4 << obj.delim;\
    s << obj.manip << obj.obj->I5 << obj.delim;\
    s << obj.manip << obj.obj->I6 << obj.delim;\
    s << obj.manip << obj.obj->I7 << obj.delim;\
    s << obj.manip << obj.obj->I8 << obj.delim;\
    s << obj.manip << obj.obj->I9 << obj.delim;\
    s << obj.manip << obj.obj->I10 << obj.delim;\
    s << obj.manip << obj.obj->I11 << obj.delim;\
    s << obj.manip << obj.obj->I12 << obj.delim;\
    s << obj.manip << obj.obj->I13 << obj.delim;\
    s << obj.manip << obj.obj->I14 << obj.delim;\
    s << obj.manip << obj.obj->I15 << obj.delim;\
    s << obj.manip << obj.obj->I16;\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_field_list<Manip>& obj)\
	{\
    s << obj.manip << '`' << obj.obj->names[0] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[1] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[2] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[3] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[4] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[5] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[6] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[7] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[8] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[9] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[10] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[11] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[12] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[13] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[14] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[15] << '`';\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_equal_list<Manip>& obj)\
	{\
    s << '`' << obj.obj->names[0] << '`' << obj.comp << obj.manip << obj.obj->I1 << obj.delim;\
    s << '`' << obj.obj->names[1] << '`' << obj.comp << obj.manip << obj.obj->I2 << obj.delim;\
    s << '`' << obj.obj->names[2] << '`' << obj.comp << obj.manip << obj.obj->I3 << obj.delim;\
    s << '`' << obj.obj->names[3] << '`' << obj.comp << obj.manip << obj.obj->I4 << obj.delim;\
    s << '`' << obj.obj->names[4] << '`' << obj.comp << obj.manip << obj.obj->I5 << obj.delim;\
    s << '`' << obj.obj->names[5] << '`' << obj.comp << obj.manip << obj.obj->I6 << obj.delim;\
    s << '`' << obj.obj->names[6] << '`' << obj.comp << obj.manip << obj.obj->I7 << obj.delim;\
    s << '`' << obj.obj->names[7] << '`' << obj.comp << obj.manip << obj.obj->I8 << obj.delim;\
    s << '`' << obj.obj->names[8] << '`' << obj.comp << obj.manip << obj.obj->I9 << obj.delim;\
    s << '`' << obj.obj->names[9] << '`' << obj.comp << obj.manip << obj.obj->I10 << obj.delim;\
    s << '`' << obj.obj->names[10] << '`' << obj.comp << obj.manip << obj.obj->I11 << obj.delim;\
    s << '`' << obj.obj->names[11] << '`' << obj.comp << obj.manip << obj.obj->I12 << obj.delim;\
    s << '`' << obj.obj->names[12] << '`' << obj.comp << obj.manip << obj.obj->I13 << obj.delim;\
    s << '`' << obj.obj->names[13] << '`' << obj.comp << obj.manip << obj.obj->I14 << obj.delim;\
    s << '`' << obj.obj->names[14] << '`' << obj.comp << obj.manip << obj.obj->I15 << obj.delim;\
    s << '`' << obj.obj->names[15] << '`' << obj.comp << obj.manip << obj.obj->I16;\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_cus_value_list<Manip>& obj)\
	{\
		bool before = false;\
    if ((*obj.include)[0]) { \
      s << obj.manip << obj.obj->I1;\
      before = true; \
     } \
    if ((*obj.include)[1]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I2;\
      before = true; \
     } \
    if ((*obj.include)[2]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I3;\
      before = true; \
     } \
    if ((*obj.include)[3]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I4;\
      before = true; \
     } \
    if ((*obj.include)[4]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I5;\
      before = true; \
     } \
    if ((*obj.include)[5]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I6;\
      before = true; \
     } \
    if ((*obj.include)[6]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I7;\
      before = true; \
     } \
    if ((*obj.include)[7]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I8;\
      before = true; \
     } \
    if ((*obj.include)[8]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I9;\
      before = true; \
     } \
    if ((*obj.include)[9]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I10;\
      before = true; \
     } \
    if ((*obj.include)[10]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I11;\
      before = true; \
     } \
    if ((*obj.include)[11]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I12;\
      before = true; \
     } \
    if ((*obj.include)[12]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I13;\
      before = true; \
     } \
    if ((*obj.include)[13]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I14;\
      before = true; \
     } \
    if ((*obj.include)[14]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I15;\
      before = true; \
     } \
    if ((*obj.include)[15]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I16;\
     } \
        (void)before;\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_cus_field_list<Manip>& obj)\
	{\
		bool before = false;\
    if ((*obj.include)[0]) { \
      s << obj.manip << '`' << obj.obj->names[0] << '`';\
      before = true; \
     } \
    if ((*obj.include)[1]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[1] << '`';\
      before = true; \
     } \
    if ((*obj.include)[2]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[2] << '`';\
      before = true; \
     } \
    if ((*obj.include)[3]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[3] << '`';\
      before = true; \
     } \
    if ((*obj.include)[4]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[4] << '`';\
      before = true; \
     } \
    if ((*obj.include)[5]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[5] << '`';\
      before = true; \
     } \
    if ((*obj.include)[6]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[6] << '`';\
      before = true; \
     } \
    if ((*obj.include)[7]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[7] << '`';\
      before = true; \
     } \
    if ((*obj.include)[8]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[8] << '`';\
      before = true; \
     } \
    if ((*obj.include)[9]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[9] << '`';\
      before = true; \
     } \
    if ((*obj.include)[10]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[10] << '`';\
      before = true; \
     } \
    if ((*obj.include)[11]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[11] << '`';\
      before = true; \
     } \
    if ((*obj.include)[12]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[12] << '`';\
      before = true; \
     } \
    if ((*obj.include)[13]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[13] << '`';\
      before = true; \
     } \
    if ((*obj.include)[14]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[14] << '`';\
      before = true; \
     } \
    if ((*obj.include)[15]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[15] << '`';\
     } \
        (void)before;\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_cus_equal_list<Manip>& obj)\
	{\
		bool before = false;\
    if ((*obj.include)[0]) { \
      s << '`' << obj.obj->names[0] << '`' << obj.comp << obj.manip << obj.obj->I1;\
      before = true; \
     } \
    if ((*obj.include)[1]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[1] << '`' << obj.comp << obj.manip << obj.obj->I2;\
      before = true; \
     } \
    if ((*obj.include)[2]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[2] << '`' << obj.comp << obj.manip << obj.obj->I3;\
      before = true; \
     } \
    if ((*obj.include)[3]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[3] << '`' << obj.comp << obj.manip << obj.obj->I4;\
      before = true; \
     } \
    if ((*obj.include)[4]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[4] << '`' << obj.comp << obj.manip << obj.obj->I5;\
      before = true; \
     } \
    if ((*obj.include)[5]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[5] << '`' << obj.comp << obj.manip << obj.obj->I6;\
      before = true; \
     } \
    if ((*obj.include)[6]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[6] << '`' << obj.comp << obj.manip << obj.obj->I7;\
      before = true; \
     } \
    if ((*obj.include)[7]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[7] << '`' << obj.comp << obj.manip << obj.obj->I8;\
      before = true; \
     } \
    if ((*obj.include)[8]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[8] << '`' << obj.comp << obj.manip << obj.obj->I9;\
      before = true; \
     } \
    if ((*obj.include)[9]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[9] << '`' << obj.comp << obj.manip << obj.obj->I10;\
      before = true; \
     } \
    if ((*obj.include)[10]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[10] << '`' << obj.comp << obj.manip << obj.obj->I11;\
      before = true; \
     } \
    if ((*obj.include)[11]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[11] << '`' << obj.comp << obj.manip << obj.obj->I12;\
      before = true; \
     } \
    if ((*obj.include)[12]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[12] << '`' << obj.comp << obj.manip << obj.obj->I13;\
      before = true; \
     } \
    if ((*obj.include)[13]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[13] << '`' << obj.comp << obj.manip << obj.obj->I14;\
      before = true; \
     } \
    if ((*obj.include)[14]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[14] << '`' << obj.comp << obj.manip << obj.obj->I15;\
      before = true; \
     } \
    if ((*obj.include)[15]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[15] << '`' << obj.comp << obj.manip << obj.obj->I16;\
     } \
        (void)before;\
		return s;\
	}\
	template <class Manip>\
	inline NAME##_value_list<Manip> NAME::value_list(const char* d, Manip m) const\
			{ return NAME##_value_list<Manip> (this, d, m); } \
	template <class Manip>\
	inline NAME##_field_list<Manip> NAME::field_list(const char* d, Manip m) const\
			{ return NAME##_field_list<Manip> (this, d, m); } \
	template <class Manip>\
	inline NAME##_equal_list<Manip> NAME::equal_list(const char* d, const char* c, Manip m) const\
			{ return NAME##_equal_list<Manip> (this, d, c, m); } \
	template <class Manip>\
	inline NAME##_cus_value_list<Manip> NAME::value_list(const char* d, Manip m,\
			bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13, bool i14, bool i15, bool i16) const\
			{ return NAME##_cus_value_list<Manip> (this, d, m, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16); }\
	template <class Manip>\
	inline NAME##_cus_field_list<Manip> NAME::field_list(const char* d, Manip m,\
			bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13, bool i14, bool i15, bool i16) const\
			{ return NAME##_cus_field_list<Manip> (this, d, m, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16); }\
	template <class Manip>\
	inline NAME##_cus_equal_list<Manip> NAME::equal_list(const char* d, const char* c, Manip m,\
			bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13, bool i14, bool i15, bool i16) const\
			{ return NAME##_cus_equal_list<Manip> (this, d, c, m, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16); } \
	template <class Manip>\
	inline NAME##_cus_value_list<Manip> NAME::value_list(const char* d, Manip m,\
			NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13, NAME##_enum i14, NAME##_enum i15, NAME##_enum i16) const\
			{ return NAME##_cus_value_list<Manip> (this, d, m, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16); } \
	template <class Manip>\
	inline NAME##_cus_field_list<Manip> NAME::field_list(const char* d, Manip m,\
			NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13, NAME##_enum i14, NAME##_enum i15, NAME##_enum i16) const\
			{ return NAME##_cus_field_list<Manip> (this, d, m, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16); } \
	template <class Manip>\
	inline NAME##_cus_equal_list<Manip> NAME::equal_list(const char* d, const char* c, Manip m, \
			NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13, NAME##_enum i14, NAME##_enum i15, NAME##_enum i16) const\
			{ return NAME##_cus_equal_list<Manip> (this, d, c, m, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16); } \
	template <class Manip>\
	inline NAME##_cus_value_list<Manip> NAME::value_list(const char* d, Manip m,\
			std::vector<bool> *i) const\
			{ return NAME##_cus_value_list<Manip> (this, d, m, i); }\
	template <class Manip>\
	inline NAME##_cus_field_list<Manip> NAME::field_list(const char* d, Manip m,\
			std::vector<bool> *i) const\
			{ return NAME##_cus_field_list<Manip> (this, d, m, i); }\
	template <class Manip>\
	inline NAME##_cus_equal_list<Manip> NAME::equal_list(const char* d, const char* c, Manip m,\
			std::vector<bool> *i) const\
			{ return NAME##_cus_equal_list<Manip> (this, d, c, m, i); }\
	template <class Manip>\
	inline NAME##_cus_value_list<Manip> \
	NAME::value_list(const char* d, Manip m, mysqlpp::sql_cmp_type /*sc*/) const\
			{ sql_compare_type_def_##CMP(NAME, value, NUM); }\
	template <class Manip>\
	inline NAME##_cus_field_list<Manip> \
	NAME::field_list(const char* d, Manip m, mysqlpp::sql_cmp_type /*sc*/) const\
			{ sql_compare_type_def_##CMP(NAME, field, NUM); }\
	template <class Manip>\
	inline NAME##_cus_equal_list<Manip> \
	NAME::equal_list(const char* d, const char* c, Manip m, mysqlpp::sql_cmp_type /*sc*/) const\
			{ sql_compare_type_defe_##CMP(NAME, equal, NUM); }\
	template <mysqlpp::sql_dummy_type dummy>\
	void populate_##NAME(NAME *s, const mysqlpp::Row &row)\
	{\
		mysqlpp::NoExceptions ignore_schema_mismatches(row);\
    s->I1 = row[N1].conv(T1());\
    s->I2 = row[N2].conv(T2());\
    s->I3 = row[N3].conv(T3());\
    s->I4 = row[N4].conv(T4());\
    s->I5 = row[N5].conv(T5());\
    s->I6 = row[N6].conv(T6());\
    s->I7 = row[N7].conv(T7());\
    s->I8 = row[N8].conv(T8());\
    s->I9 = row[N9].conv(T9());\
    s->I10 = row[N10].conv(T10());\
    s->I11 = row[N11].conv(T11());\
    s->I12 = row[N12].conv(T12());\
    s->I13 = row[N13].conv(T13());\
    s->I14 = row[N14].conv(T14());\
    s->I15 = row[N15].conv(T15());\
    s->I16 = row[N16].conv(T16());\
	}\
	inline NAME::NAME(const mysqlpp::Row& row) :\
	table_override_(0)\
			{ populate_##NAME<mysqlpp::sql_dummy>(this, row); }\
	inline void NAME::set(const mysqlpp::Row& row)\
	{\
		table_override_ = 0;\
		populate_##NAME<mysqlpp::sql_dummy>(this, row);\
	}\
	sql_COMPARE__##CMP(NAME, I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, 0, 0, 0, 0, 0, 0, 0, 0, 0 )

#define sql_create_16(NAME, CMP, CONTR, T1, I1, T2, I2, T3, I3, T4, I4, T5, I5, T6, I6, T7, I7, T8, I8, T9, I9, T10, I10, T11, I11, T12, I12, T13, I13, T14, I14, T15, I15, T16, I16) \
		sql_create_complete_16(NAME, CMP, CONTR, T1, I1, #I1, T2, I2, #I2, T3, I3, #I3, T4, I4, #I4, T5, I5, #I5, T6, I6, #I6, T7, I7, #I7, T8, I8, #I8, T9, I9, #I9, T10, I10, #I10, T11, I11, #I11, T12, I12, #I12, T13, I13, #I13, T14, I14, #I14, T15, I15, #I15, T16, I16, #I16) \

// ---------------------------------------------------
//                  End Create 16
// ---------------------------------------------------

// ---------------------------------------------------
//                  Begin Create 17
// ---------------------------------------------------
#define sql_create_complete_17(NAME, CMP, CONTR, T1, I1, N1, T2, I2, N2, T3, I3, N3, T4, I4, N4, T5, I5, N5, T6, I6, N6, T7, I7, N7, T8, I8, N8, T9, I9, N9, T10, I10, N10, T11, I11, N11, T12, I12, N12, T13, I13, N13, T14, I14, N14, T15, I15, N15, T16, I16, N16, T17, I17, N17) \
	struct NAME; \
	enum NAME##_enum { \
    NAME##_##I1,\
    NAME##_##I2,\
    NAME##_##I3,\
    NAME##_##I4,\
    NAME##_##I5,\
    NAME##_##I6,\
    NAME##_##I7,\
    NAME##_##I8,\
    NAME##_##I9,\
    NAME##_##I10,\
    NAME##_##I11,\
    NAME##_##I12,\
    NAME##_##I13,\
    NAME##_##I14,\
    NAME##_##I15,\
    NAME##_##I16,\
    NAME##_##I17 \
	,NAME##_NULL \
	}; \
	template <class Manip>\
	class NAME##_value_list { \
	public: \
	const NAME* obj;\
	const char* delim;\
	Manip manip;\
	public: \
	NAME##_value_list (const NAME* o, const char* d, Manip m) :\
	obj(o), delim(d), manip(m) { } \
	};\
	template <class Manip>\
	class NAME##_##field_list {\
	public: \
	const NAME* obj; \
	const char* delim;\
	Manip manip;\
	public: \
	NAME##_field_list (const NAME* o, const char* d, Manip m) :\
	obj(o), delim(d), manip(m) { } \
	};\
	template <class Manip>\
	class NAME##_equal_list { \
	public: \
	const NAME* obj;\
	const char* delim;\
	const char* comp;\
	Manip manip;\
	public: \
	NAME##_equal_list (const NAME* o, const char* d, const char* c, Manip m) :\
	obj(o), delim(d), comp(c), manip(m) { }\
	};\
	template <class Manip>\
	class NAME##_cus_value_list {\
	public:\
	const NAME* obj;\
	std::vector<bool> *include;\
	bool del_vector;\
	const char* delim;\
	Manip manip;\
	public: \
	~NAME##_cus_value_list () {if (del_vector) delete include;} \
	NAME##_cus_value_list (const NAME* o, const char* d, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13, bool i14, bool i15, bool i16, bool i17);\
	NAME##_cus_value_list (const NAME* o, const char* d, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13, NAME##_enum i14, NAME##_enum i15, NAME##_enum i16, NAME##_enum i17); \
	NAME##_cus_value_list (const NAME* o, const char* d, Manip m ,std::vector<bool>* i) :\
	obj(o), include(i), del_vector(false), delim(d), manip(m) { }\
	};\
	template <class Manip>\
	class NAME##_cus_field_list { \
	public:\
	const NAME* obj; \
	std::vector<bool> *include; \
	bool del_vector; \
	const char* delim;\
	Manip manip;\
	public: \
	~NAME##_cus_field_list () {if (del_vector) delete include;} \
	NAME##_cus_field_list (const NAME* o, const char* d, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13, bool i14, bool i15, bool i16, bool i17); \
	NAME##_cus_field_list (const NAME* o, const char* d, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13, NAME##_enum i14, NAME##_enum i15, NAME##_enum i16, NAME##_enum i17); \
	NAME##_cus_field_list (const NAME* o, const char* d, Manip m, std::vector<bool> *i) :\
	obj(o), include(i), del_vector(false), delim(d), manip(m) { }\
	};\
	template <class Manip>\
	class NAME##_cus_equal_list {\
	public:\
	const NAME* obj;\
	std::vector<bool> *include;\
	bool del_vector;\
	const char* delim;\
	const char* comp;\
	Manip manip;\
	public:\
	~NAME##_##cus_equal_list () {if (del_vector) delete include;}\
	NAME##_##cus_equal_list (const NAME* o, const char* d, const char* c, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13, bool i14, bool i15, bool i16, bool i17); \
	NAME##_##cus_equal_list (const NAME* o, const char* d, const char* c, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13, NAME##_enum i14, NAME##_enum i15, NAME##_enum i16, NAME##_enum i17); \
	NAME##_##cus_equal_list (const NAME* o, const char* d, const char* c, Manip m, std::vector<bool> *i) :\
	obj(o), include(i), del_vector(false), delim(d), comp(c), manip(m) { }\
	};\
	template <mysqlpp::sql_dummy_type dummy> int sql_compare_##NAME(const NAME&, const NAME&);\
	struct NAME {\
    T1 I1;\
    T2 I2;\
    T3 I3;\
    T4 I4;\
    T5 I5;\
    T6 I6;\
    T7 I7;\
    T8 I8;\
    T9 I9;\
    T10 I10;\
    T11 I11;\
    T12 I12;\
    T13 I13;\
    T14 I14;\
    T15 I15;\
    T16 I16;\
    T17 I17; \
	NAME() : table_override_(0) { }\
	NAME(const mysqlpp::Row& row);\
	void set(const mysqlpp::Row &row);\
	sql_compare_define_##CMP(NAME, T1, I1, T2, I2, T3, I3, T4, I4, T5, I5, T6, I6, T7, I7, T8, I8, T9, I9, T10, I10, T11, I11, T12, I12, T13, I13, T14, I14, T15, I15, T16, I16, T17, I17, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)\
	sql_construct_define_##CONTR(NAME, T1, I1, T2, I2, T3, I3, T4, I4, T5, I5, T6, I6, T7, I7, T8, I8, T9, I9, T10, I10, T11, I11, T12, I12, T13, I13, T14, I14, T15, I15, T16, I16, T17, I17, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)\
	static const char* names[];\
	static void table(const char* t) { table_ = t; }\
	const char* table() const\
			{ return table_override_ ? table_override_ : NAME::table_; }\
	void instance_table(const char* t) { table_override_ = t; }\
	NAME##_value_list<mysqlpp::quote_type0> value_list() const {\
		return value_list(",", mysqlpp::quote);}\
	NAME##_value_list<mysqlpp::quote_type0> value_list(const char* d) const {\
		return value_list(d, mysqlpp::quote);}\
	template <class Manip>\
	NAME##_value_list<Manip> value_list(const char* d, Manip m) const;\
	NAME##_field_list<mysqlpp::do_nothing_type0> field_list() const {\
		return field_list(",", mysqlpp::do_nothing);}\
	NAME##_field_list<mysqlpp::do_nothing_type0> field_list(const char* d) const {\
		return field_list(d, mysqlpp::do_nothing);}\
	template <class Manip>\
	NAME##_field_list<Manip> field_list(const char* d, Manip m) const;\
	NAME##_equal_list<mysqlpp::quote_type0> equal_list(const char* d = ",",\
			const char* c = " = ") const\
			{ return equal_list(d, c, mysqlpp::quote); }\
	template <class Manip>\
	NAME##_equal_list<Manip> equal_list(const char* d, const char* c, Manip m) const;\
	/* cus_data */\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false, bool i15 = false, bool i16 = false, bool i17 = false) const\
			{ return value_list(",", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL, NAME##_enum i15 = NAME##_NULL, NAME##_enum i16 = NAME##_NULL, NAME##_enum i17 = NAME##_NULL) const\
			{ return value_list(",", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(std::vector<bool> *i) const\
			{ return value_list(",", mysqlpp::quote, i); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(mysqlpp::sql_cmp_type sc) const\
			{ return value_list(",", mysqlpp::quote, sc); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(const char* d, bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false, bool i15 = false, bool i16 = false, bool i17 = false) const\
			{ return value_list(d, mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(const char* d, NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL, NAME##_enum i15 = NAME##_NULL, NAME##_enum i16 = NAME##_NULL, NAME##_enum i17 = NAME##_NULL) const\
			{ return value_list(d, mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(const char* d,\
			std::vector<bool> *i) const\
			{ return value_list(d, mysqlpp::quote, i); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(const char* d,\
			mysqlpp::sql_cmp_type sc) const\
			{ return value_list(d, mysqlpp::quote, sc); }\
	template <class Manip>\
	NAME##_cus_value_list<Manip> value_list(const char* d, Manip m,\
			bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false, bool i15 = false, bool i16 = false, bool i17 = false) const;\
	template <class Manip>\
	NAME##_cus_value_list<Manip> value_list(const char* d, Manip m,\
			NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL, NAME##_enum i15 = NAME##_NULL, NAME##_enum i16 = NAME##_NULL, NAME##_enum i17 = NAME##_NULL) const;\
	template <class Manip>\
	NAME##_cus_value_list<Manip> value_list(const char* d, Manip m,\
			std::vector<bool>* i) const;\
	template <class Manip>\
	NAME##_cus_value_list<Manip> value_list(const char* d, Manip m, \
			mysqlpp::sql_cmp_type sc) const;\
	/* cus field */\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false, bool i15 = false, bool i16 = false, bool i17 = false) const \
			{ return field_list(",", mysqlpp::do_nothing, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL, NAME##_enum i15 = NAME##_NULL, NAME##_enum i16 = NAME##_NULL, NAME##_enum i17 = NAME##_NULL) const\
			{ return field_list(",", mysqlpp::do_nothing, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(std::vector<bool> *i) const\
			{ return field_list(",", mysqlpp::do_nothing, i); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(mysqlpp::sql_cmp_type sc) const\
			{ return field_list(",", mysqlpp::do_nothing, sc); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(const char* d,\
			bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false, bool i15 = false, bool i16 = false, bool i17 = false) const\
			{ return field_list(d, mysqlpp::do_nothing, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(const char* d,\
			NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL, NAME##_enum i15 = NAME##_NULL, NAME##_enum i16 = NAME##_NULL, NAME##_enum i17 = NAME##_NULL) const\
			{ return field_list(d, mysqlpp::do_nothing, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(const char* d,\
			std::vector<bool>* i) const\
			{ return field_list(d, mysqlpp::do_nothing, i); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(const char* d,\
			mysqlpp::sql_cmp_type sc) const\
			{ return field_list(d, mysqlpp::do_nothing, sc); }\
	template <class Manip>\
	NAME##_cus_field_list<Manip> field_list(const char* d, Manip m,\
			bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false, bool i15 = false, bool i16 = false, bool i17 = false) const;\
	template <class Manip>\
	NAME##_cus_field_list<Manip> field_list(const char* d, Manip m,\
			NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL, NAME##_enum i15 = NAME##_NULL, NAME##_enum i16 = NAME##_NULL, NAME##_enum i17 = NAME##_NULL) const;\
	template <class Manip>\
	NAME##_cus_field_list<Manip> field_list(const char* d, Manip m,\
			std::vector<bool> *i) const;\
	template <class Manip>\
	NAME##_cus_field_list<Manip> field_list(const char* d, Manip m,\
			mysqlpp::sql_cmp_type sc) const;\
	/* cus equal */\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false, bool i15 = false, bool i16 = false, bool i17 = false) const\
			{ return equal_list(",", " = ", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL, NAME##_enum i15 = NAME##_NULL, NAME##_enum i16 = NAME##_NULL, NAME##_enum i17 = NAME##_NULL) const\
			{ return equal_list(",", " = ", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(std::vector<bool>* i) const\
			{ return equal_list(",", " = ", mysqlpp::quote, i); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(mysqlpp::sql_cmp_type sc) const\
			{ return equal_list(",", " = ", mysqlpp::quote, sc); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false, bool i15 = false, bool i16 = false, bool i17 = false) const\
			{ return equal_list(d, " = ", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL, NAME##_enum i15 = NAME##_NULL, NAME##_enum i16 = NAME##_NULL, NAME##_enum i17 = NAME##_NULL) const\
			{ return equal_list(d, " = ", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d,\
			std::vector<bool> *i) const\
			{ return equal_list(d, " = ", mysqlpp::quote, i); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d,\
			mysqlpp::sql_cmp_type sc) const\
			{ return equal_list(d, " = ", mysqlpp::quote, sc); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, const char* c,\
			bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false, bool i15 = false, bool i16 = false, bool i17 = false) const\
			{ return equal_list(d, c, mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, const char* c,\
			NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL, NAME##_enum i15 = NAME##_NULL, NAME##_enum i16 = NAME##_NULL, NAME##_enum i17 = NAME##_NULL) const\
			{ return equal_list(d, c, mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, const char* c,\
			std::vector<bool> *i) const\
			{ return equal_list(d, c, mysqlpp::quote, i); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, const char* c,\
			mysqlpp::sql_cmp_type sc) const\
			{ return equal_list(d, c, mysqlpp::quote, sc); }\
	template <class Manip>\
	NAME##_cus_equal_list<Manip> equal_list(const char* d, const char* c, Manip m, \
						bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false, bool i15 = false, bool i16 = false, bool i17 = false) const;\
	template <class Manip>\
	NAME##_cus_equal_list<Manip> equal_list(const char* d, const char* c, Manip m, \
						NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL, NAME##_enum i15 = NAME##_NULL, NAME##_enum i16 = NAME##_NULL, NAME##_enum i17 = NAME##_NULL) const;\
	template <class Manip>\
	NAME##_cus_equal_list<Manip> equal_list(const char* d, const char* c, Manip m, \
						std::vector<bool> *i) const;\
	template <class Manip>\
	NAME##_cus_equal_list<Manip> equal_list(const char* d, const char* c, Manip m, \
						mysqlpp::sql_cmp_type sc) const;\
	private:\
	static const char* table_;\
	const char* table_override_;\
	};\
	MYSQLPP_SSQLS_CONDITIONAL_STATICS(\
		const char* NAME::names[] = {\
			    N1 ,\
    N2 ,\
    N3 ,\
    N4 ,\
    N5 ,\
    N6 ,\
    N7 ,\
    N8 ,\
    N9 ,\
    N10 ,\
    N11 ,\
    N12 ,\
    N13 ,\
    N14 ,\
    N15 ,\
    N16 ,\
    N17 \
		};\
		const char* NAME::table_ = #NAME;\
	)\
	template <class Manip>\
	NAME##_cus_value_list<Manip>::NAME##_cus_value_list\
			(const NAME* o, const char* d, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13, bool i14, bool i15, bool i16, bool i17)\
	{\
		delim = d;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(17, false);\
    if (i1) (*include)[0]=true;\
    if (i2) (*include)[1]=true;\
    if (i3) (*include)[2]=true;\
    if (i4) (*include)[3]=true;\
    if (i5) (*include)[4]=true;\
    if (i6) (*include)[5]=true;\
    if (i7) (*include)[6]=true;\
    if (i8) (*include)[7]=true;\
    if (i9) (*include)[8]=true;\
    if (i10) (*include)[9]=true;\
    if (i11) (*include)[10]=true;\
    if (i12) (*include)[11]=true;\
    if (i13) (*include)[12]=true;\
    if (i14) (*include)[13]=true;\
    if (i15) (*include)[14]=true;\
    if (i16) (*include)[15]=true;\
    if (i17) (*include)[16]=true;\
	}\
	template <class Manip>\
	NAME##_cus_value_list<Manip>::NAME##_cus_value_list\
			(const NAME* o, const char* d, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13, NAME##_enum i14, NAME##_enum i15, NAME##_enum i16, NAME##_enum i17)\
	{\
		delim = d;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(17, false);\
    if (i1 == NAME##_NULL) return;\
    (*include)[i1]=true;\
    if (i2 == NAME##_NULL) return;\
    (*include)[i2]=true;\
    if (i3 == NAME##_NULL) return;\
    (*include)[i3]=true;\
    if (i4 == NAME##_NULL) return;\
    (*include)[i4]=true;\
    if (i5 == NAME##_NULL) return;\
    (*include)[i5]=true;\
    if (i6 == NAME##_NULL) return;\
    (*include)[i6]=true;\
    if (i7 == NAME##_NULL) return;\
    (*include)[i7]=true;\
    if (i8 == NAME##_NULL) return;\
    (*include)[i8]=true;\
    if (i9 == NAME##_NULL) return;\
    (*include)[i9]=true;\
    if (i10 == NAME##_NULL) return;\
    (*include)[i10]=true;\
    if (i11 == NAME##_NULL) return;\
    (*include)[i11]=true;\
    if (i12 == NAME##_NULL) return;\
    (*include)[i12]=true;\
    if (i13 == NAME##_NULL) return;\
    (*include)[i13]=true;\
    if (i14 == NAME##_NULL) return;\
    (*include)[i14]=true;\
    if (i15 == NAME##_NULL) return;\
    (*include)[i15]=true;\
    if (i16 == NAME##_NULL) return;\
    (*include)[i16]=true;\
    if (i17 == NAME##_NULL) return;\
    (*include)[i17]=true;\
	}\
	template <class Manip>\
	NAME##_cus_field_list<Manip>::NAME##_cus_field_list\
			(const NAME* o, const char* d, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13, bool i14, bool i15, bool i16, bool i17)\
	{\
		delim = d;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(17, false);\
    if (i1) (*include)[0]=true;\
    if (i2) (*include)[1]=true;\
    if (i3) (*include)[2]=true;\
    if (i4) (*include)[3]=true;\
    if (i5) (*include)[4]=true;\
    if (i6) (*include)[5]=true;\
    if (i7) (*include)[6]=true;\
    if (i8) (*include)[7]=true;\
    if (i9) (*include)[8]=true;\
    if (i10) (*include)[9]=true;\
    if (i11) (*include)[10]=true;\
    if (i12) (*include)[11]=true;\
    if (i13) (*include)[12]=true;\
    if (i14) (*include)[13]=true;\
    if (i15) (*include)[14]=true;\
    if (i16) (*include)[15]=true;\
    if (i17) (*include)[16]=true;\
	}\
	template <class Manip>\
	NAME##_cus_field_list<Manip>::NAME##_cus_field_list\
			(const NAME* o, const char* d, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13, NAME##_enum i14, NAME##_enum i15, NAME##_enum i16, NAME##_enum i17)\
	{\
		delim = d;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(17, false);\
    if (i1 == NAME##_NULL) return;\
    (*include)[i1]=true;\
    if (i2 == NAME##_NULL) return;\
    (*include)[i2]=true;\
    if (i3 == NAME##_NULL) return;\
    (*include)[i3]=true;\
    if (i4 == NAME##_NULL) return;\
    (*include)[i4]=true;\
    if (i5 == NAME##_NULL) return;\
    (*include)[i5]=true;\
    if (i6 == NAME##_NULL) return;\
    (*include)[i6]=true;\
    if (i7 == NAME##_NULL) return;\
    (*include)[i7]=true;\
    if (i8 == NAME##_NULL) return;\
    (*include)[i8]=true;\
    if (i9 == NAME##_NULL) return;\
    (*include)[i9]=true;\
    if (i10 == NAME##_NULL) return;\
    (*include)[i10]=true;\
    if (i11 == NAME##_NULL) return;\
    (*include)[i11]=true;\
    if (i12 == NAME##_NULL) return;\
    (*include)[i12]=true;\
    if (i13 == NAME##_NULL) return;\
    (*include)[i13]=true;\
    if (i14 == NAME##_NULL) return;\
    (*include)[i14]=true;\
    if (i15 == NAME##_NULL) return;\
    (*include)[i15]=true;\
    if (i16 == NAME##_NULL) return;\
    (*include)[i16]=true;\
    if (i17 == NAME##_NULL) return;\
    (*include)[i17]=true;\
	}\
	template <class Manip>\
	NAME##_cus_equal_list<Manip>::NAME##_cus_equal_list\
			(const NAME* o, const char* d, const char* c, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13, bool i14, bool i15, bool i16, bool i17)\
	{\
		delim = d;\
		comp = c;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(17, false);\
    if (i1) (*include)[0]=true;\
    if (i2) (*include)[1]=true;\
    if (i3) (*include)[2]=true;\
    if (i4) (*include)[3]=true;\
    if (i5) (*include)[4]=true;\
    if (i6) (*include)[5]=true;\
    if (i7) (*include)[6]=true;\
    if (i8) (*include)[7]=true;\
    if (i9) (*include)[8]=true;\
    if (i10) (*include)[9]=true;\
    if (i11) (*include)[10]=true;\
    if (i12) (*include)[11]=true;\
    if (i13) (*include)[12]=true;\
    if (i14) (*include)[13]=true;\
    if (i15) (*include)[14]=true;\
    if (i16) (*include)[15]=true;\
    if (i17) (*include)[16]=true;\
	}\
	template <class Manip>\
	NAME##_cus_equal_list<Manip>::NAME##_cus_equal_list\
			(const NAME* o, const char* d, const char* c, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13, NAME##_enum i14, NAME##_enum i15, NAME##_enum i16, NAME##_enum i17)\
	{\
		delim = d;\
		comp = c;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(17, false);\
    if (i1 == NAME##_NULL) return;\
    (*include)[i1]=true;\
    if (i2 == NAME##_NULL) return;\
    (*include)[i2]=true;\
    if (i3 == NAME##_NULL) return;\
    (*include)[i3]=true;\
    if (i4 == NAME##_NULL) return;\
    (*include)[i4]=true;\
    if (i5 == NAME##_NULL) return;\
    (*include)[i5]=true;\
    if (i6 == NAME##_NULL) return;\
    (*include)[i6]=true;\
    if (i7 == NAME##_NULL) return;\
    (*include)[i7]=true;\
    if (i8 == NAME##_NULL) return;\
    (*include)[i8]=true;\
    if (i9 == NAME##_NULL) return;\
    (*include)[i9]=true;\
    if (i10 == NAME##_NULL) return;\
    (*include)[i10]=true;\
    if (i11 == NAME##_NULL) return;\
    (*include)[i11]=true;\
    if (i12 == NAME##_NULL) return;\
    (*include)[i12]=true;\
    if (i13 == NAME##_NULL) return;\
    (*include)[i13]=true;\
    if (i14 == NAME##_NULL) return;\
    (*include)[i14]=true;\
    if (i15 == NAME##_NULL) return;\
    (*include)[i15]=true;\
    if (i16 == NAME##_NULL) return;\
    (*include)[i16]=true;\
    if (i17 == NAME##_NULL) return;\
    (*include)[i17]=true;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_value_list<Manip>& obj)\
	{\
    s << obj.manip << obj.obj->I1 << obj.delim;\
    s << obj.manip << obj.obj->I2 << obj.delim;\
    s << obj.manip << obj.obj->I3 << obj.delim;\
    s << obj.manip << obj.obj->I4 << obj.delim;\
    s << obj.manip << obj.obj->I5 << obj.delim;\
    s << obj.manip << obj.obj->I6 << obj.delim;\
    s << obj.manip << obj.obj->I7 << obj.delim;\
    s << obj.manip << obj.obj->I8 << obj.delim;\
    s << obj.manip << obj.obj->I9 << obj.delim;\
    s << obj.manip << obj.obj->I10 << obj.delim;\
    s << obj.manip << obj.obj->I11 << obj.delim;\
    s << obj.manip << obj.obj->I12 << obj.delim;\
    s << obj.manip << obj.obj->I13 << obj.delim;\
    s << obj.manip << obj.obj->I14 << obj.delim;\
    s << obj.manip << obj.obj->I15 << obj.delim;\
    s << obj.manip << obj.obj->I16 << obj.delim;\
    s << obj.manip << obj.obj->I17;\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_field_list<Manip>& obj)\
	{\
    s << obj.manip << '`' << obj.obj->names[0] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[1] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[2] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[3] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[4] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[5] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[6] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[7] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[8] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[9] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[10] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[11] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[12] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[13] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[14] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[15] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[16] << '`';\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_equal_list<Manip>& obj)\
	{\
    s << '`' << obj.obj->names[0] << '`' << obj.comp << obj.manip << obj.obj->I1 << obj.delim;\
    s << '`' << obj.obj->names[1] << '`' << obj.comp << obj.manip << obj.obj->I2 << obj.delim;\
    s << '`' << obj.obj->names[2] << '`' << obj.comp << obj.manip << obj.obj->I3 << obj.delim;\
    s << '`' << obj.obj->names[3] << '`' << obj.comp << obj.manip << obj.obj->I4 << obj.delim;\
    s << '`' << obj.obj->names[4] << '`' << obj.comp << obj.manip << obj.obj->I5 << obj.delim;\
    s << '`' << obj.obj->names[5] << '`' << obj.comp << obj.manip << obj.obj->I6 << obj.delim;\
    s << '`' << obj.obj->names[6] << '`' << obj.comp << obj.manip << obj.obj->I7 << obj.delim;\
    s << '`' << obj.obj->names[7] << '`' << obj.comp << obj.manip << obj.obj->I8 << obj.delim;\
    s << '`' << obj.obj->names[8] << '`' << obj.comp << obj.manip << obj.obj->I9 << obj.delim;\
    s << '`' << obj.obj->names[9] << '`' << obj.comp << obj.manip << obj.obj->I10 << obj.delim;\
    s << '`' << obj.obj->names[10] << '`' << obj.comp << obj.manip << obj.obj->I11 << obj.delim;\
    s << '`' << obj.obj->names[11] << '`' << obj.comp << obj.manip << obj.obj->I12 << obj.delim;\
    s << '`' << obj.obj->names[12] << '`' << obj.comp << obj.manip << obj.obj->I13 << obj.delim;\
    s << '`' << obj.obj->names[13] << '`' << obj.comp << obj.manip << obj.obj->I14 << obj.delim;\
    s << '`' << obj.obj->names[14] << '`' << obj.comp << obj.manip << obj.obj->I15 << obj.delim;\
    s << '`' << obj.obj->names[15] << '`' << obj.comp << obj.manip << obj.obj->I16 << obj.delim;\
    s << '`' << obj.obj->names[16] << '`' << obj.comp << obj.manip << obj.obj->I17;\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_cus_value_list<Manip>& obj)\
	{\
		bool before = false;\
    if ((*obj.include)[0]) { \
      s << obj.manip << obj.obj->I1;\
      before = true; \
     } \
    if ((*obj.include)[1]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I2;\
      before = true; \
     } \
    if ((*obj.include)[2]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I3;\
      before = true; \
     } \
    if ((*obj.include)[3]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I4;\
      before = true; \
     } \
    if ((*obj.include)[4]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I5;\
      before = true; \
     } \
    if ((*obj.include)[5]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I6;\
      before = true; \
     } \
    if ((*obj.include)[6]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I7;\
      before = true; \
     } \
    if ((*obj.include)[7]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I8;\
      before = true; \
     } \
    if ((*obj.include)[8]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I9;\
      before = true; \
     } \
    if ((*obj.include)[9]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I10;\
      before = true; \
     } \
    if ((*obj.include)[10]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I11;\
      before = true; \
     } \
    if ((*obj.include)[11]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I12;\
      before = true; \
     } \
    if ((*obj.include)[12]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I13;\
      before = true; \
     } \
    if ((*obj.include)[13]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I14;\
      before = true; \
     } \
    if ((*obj.include)[14]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I15;\
      before = true; \
     } \
    if ((*obj.include)[15]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I16;\
      before = true; \
     } \
    if ((*obj.include)[16]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I17;\
     } \
        (void)before;\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_cus_field_list<Manip>& obj)\
	{\
		bool before = false;\
    if ((*obj.include)[0]) { \
      s << obj.manip << '`' << obj.obj->names[0] << '`';\
      before = true; \
     } \
    if ((*obj.include)[1]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[1] << '`';\
      before = true; \
     } \
    if ((*obj.include)[2]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[2] << '`';\
      before = true; \
     } \
    if ((*obj.include)[3]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[3] << '`';\
      before = true; \
     } \
    if ((*obj.include)[4]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[4] << '`';\
      before = true; \
     } \
    if ((*obj.include)[5]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[5] << '`';\
      before = true; \
     } \
    if ((*obj.include)[6]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[6] << '`';\
      before = true; \
     } \
    if ((*obj.include)[7]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[7] << '`';\
      before = true; \
     } \
    if ((*obj.include)[8]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[8] << '`';\
      before = true; \
     } \
    if ((*obj.include)[9]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[9] << '`';\
      before = true; \
     } \
    if ((*obj.include)[10]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[10] << '`';\
      before = true; \
     } \
    if ((*obj.include)[11]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[11] << '`';\
      before = true; \
     } \
    if ((*obj.include)[12]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[12] << '`';\
      before = true; \
     } \
    if ((*obj.include)[13]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[13] << '`';\
      before = true; \
     } \
    if ((*obj.include)[14]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[14] << '`';\
      before = true; \
     } \
    if ((*obj.include)[15]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[15] << '`';\
      before = true; \
     } \
    if ((*obj.include)[16]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[16] << '`';\
     } \
        (void)before;\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_cus_equal_list<Manip>& obj)\
	{\
		bool before = false;\
    if ((*obj.include)[0]) { \
      s << '`' << obj.obj->names[0] << '`' << obj.comp << obj.manip << obj.obj->I1;\
      before = true; \
     } \
    if ((*obj.include)[1]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[1] << '`' << obj.comp << obj.manip << obj.obj->I2;\
      before = true; \
     } \
    if ((*obj.include)[2]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[2] << '`' << obj.comp << obj.manip << obj.obj->I3;\
      before = true; \
     } \
    if ((*obj.include)[3]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[3] << '`' << obj.comp << obj.manip << obj.obj->I4;\
      before = true; \
     } \
    if ((*obj.include)[4]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[4] << '`' << obj.comp << obj.manip << obj.obj->I5;\
      before = true; \
     } \
    if ((*obj.include)[5]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[5] << '`' << obj.comp << obj.manip << obj.obj->I6;\
      before = true; \
     } \
    if ((*obj.include)[6]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[6] << '`' << obj.comp << obj.manip << obj.obj->I7;\
      before = true; \
     } \
    if ((*obj.include)[7]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[7] << '`' << obj.comp << obj.manip << obj.obj->I8;\
      before = true; \
     } \
    if ((*obj.include)[8]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[8] << '`' << obj.comp << obj.manip << obj.obj->I9;\
      before = true; \
     } \
    if ((*obj.include)[9]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[9] << '`' << obj.comp << obj.manip << obj.obj->I10;\
      before = true; \
     } \
    if ((*obj.include)[10]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[10] << '`' << obj.comp << obj.manip << obj.obj->I11;\
      before = true; \
     } \
    if ((*obj.include)[11]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[11] << '`' << obj.comp << obj.manip << obj.obj->I12;\
      before = true; \
     } \
    if ((*obj.include)[12]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[12] << '`' << obj.comp << obj.manip << obj.obj->I13;\
      before = true; \
     } \
    if ((*obj.include)[13]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[13] << '`' << obj.comp << obj.manip << obj.obj->I14;\
      before = true; \
     } \
    if ((*obj.include)[14]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[14] << '`' << obj.comp << obj.manip << obj.obj->I15;\
      before = true; \
     } \
    if ((*obj.include)[15]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[15] << '`' << obj.comp << obj.manip << obj.obj->I16;\
      before = true; \
     } \
    if ((*obj.include)[16]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[16] << '`' << obj.comp << obj.manip << obj.obj->I17;\
     } \
        (void)before;\
		return s;\
	}\
	template <class Manip>\
	inline NAME##_value_list<Manip> NAME::value_list(const char* d, Manip m) const\
			{ return NAME##_value_list<Manip> (this, d, m); } \
	template <class Manip>\
	inline NAME##_field_list<Manip> NAME::field_list(const char* d, Manip m) const\
			{ return NAME##_field_list<Manip> (this, d, m); } \
	template <class Manip>\
	inline NAME##_equal_list<Manip> NAME::equal_list(const char* d, const char* c, Manip m) const\
			{ return NAME##_equal_list<Manip> (this, d, c, m); } \
	template <class Manip>\
	inline NAME##_cus_value_list<Manip> NAME::value_list(const char* d, Manip m,\
			bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13, bool i14, bool i15, bool i16, bool i17) const\
			{ return NAME##_cus_value_list<Manip> (this, d, m, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17); }\
	template <class Manip>\
	inline NAME##_cus_field_list<Manip> NAME::field_list(const char* d, Manip m,\
			bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13, bool i14, bool i15, bool i16, bool i17) const\
			{ return NAME##_cus_field_list<Manip> (this, d, m, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17); }\
	template <class Manip>\
	inline NAME##_cus_equal_list<Manip> NAME::equal_list(const char* d, const char* c, Manip m,\
			bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13, bool i14, bool i15, bool i16, bool i17) const\
			{ return NAME##_cus_equal_list<Manip> (this, d, c, m, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17); } \
	template <class Manip>\
	inline NAME##_cus_value_list<Manip> NAME::value_list(const char* d, Manip m,\
			NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13, NAME##_enum i14, NAME##_enum i15, NAME##_enum i16, NAME##_enum i17) const\
			{ return NAME##_cus_value_list<Manip> (this, d, m, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17); } \
	template <class Manip>\
	inline NAME##_cus_field_list<Manip> NAME::field_list(const char* d, Manip m,\
			NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13, NAME##_enum i14, NAME##_enum i15, NAME##_enum i16, NAME##_enum i17) const\
			{ return NAME##_cus_field_list<Manip> (this, d, m, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17); } \
	template <class Manip>\
	inline NAME##_cus_equal_list<Manip> NAME::equal_list(const char* d, const char* c, Manip m, \
			NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13, NAME##_enum i14, NAME##_enum i15, NAME##_enum i16, NAME##_enum i17) const\
			{ return NAME##_cus_equal_list<Manip> (this, d, c, m, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17); } \
	template <class Manip>\
	inline NAME##_cus_value_list<Manip> NAME::value_list(const char* d, Manip m,\
			std::vector<bool> *i) const\
			{ return NAME##_cus_value_list<Manip> (this, d, m, i); }\
	template <class Manip>\
	inline NAME##_cus_field_list<Manip> NAME::field_list(const char* d, Manip m,\
			std::vector<bool> *i) const\
			{ return NAME##_cus_field_list<Manip> (this, d, m, i); }\
	template <class Manip>\
	inline NAME##_cus_equal_list<Manip> NAME::equal_list(const char* d, const char* c, Manip m,\
			std::vector<bool> *i) const\
			{ return NAME##_cus_equal_list<Manip> (this, d, c, m, i); }\
	template <class Manip>\
	inline NAME##_cus_value_list<Manip> \
	NAME::value_list(const char* d, Manip m, mysqlpp::sql_cmp_type /*sc*/) const\
			{ sql_compare_type_def_##CMP(NAME, value, NUM); }\
	template <class Manip>\
	inline NAME##_cus_field_list<Manip> \
	NAME::field_list(const char* d, Manip m, mysqlpp::sql_cmp_type /*sc*/) const\
			{ sql_compare_type_def_##CMP(NAME, field, NUM); }\
	template <class Manip>\
	inline NAME##_cus_equal_list<Manip> \
	NAME::equal_list(const char* d, const char* c, Manip m, mysqlpp::sql_cmp_type /*sc*/) const\
			{ sql_compare_type_defe_##CMP(NAME, equal, NUM); }\
	template <mysqlpp::sql_dummy_type dummy>\
	void populate_##NAME(NAME *s, const mysqlpp::Row &row)\
	{\
		mysqlpp::NoExceptions ignore_schema_mismatches(row);\
    s->I1 = row[N1].conv(T1());\
    s->I2 = row[N2].conv(T2());\
    s->I3 = row[N3].conv(T3());\
    s->I4 = row[N4].conv(T4());\
    s->I5 = row[N5].conv(T5());\
    s->I6 = row[N6].conv(T6());\
    s->I7 = row[N7].conv(T7());\
    s->I8 = row[N8].conv(T8());\
    s->I9 = row[N9].conv(T9());\
    s->I10 = row[N10].conv(T10());\
    s->I11 = row[N11].conv(T11());\
    s->I12 = row[N12].conv(T12());\
    s->I13 = row[N13].conv(T13());\
    s->I14 = row[N14].conv(T14());\
    s->I15 = row[N15].conv(T15());\
    s->I16 = row[N16].conv(T16());\
    s->I17 = row[N17].conv(T17());\
	}\
	inline NAME::NAME(const mysqlpp::Row& row) :\
	table_override_(0)\
			{ populate_##NAME<mysqlpp::sql_dummy>(this, row); }\
	inline void NAME::set(const mysqlpp::Row& row)\
	{\
		table_override_ = 0;\
		populate_##NAME<mysqlpp::sql_dummy>(this, row);\
	}\
	sql_COMPARE__##CMP(NAME, I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, I17, 0, 0, 0, 0, 0, 0, 0, 0 )

#define sql_create_17(NAME, CMP, CONTR, T1, I1, T2, I2, T3, I3, T4, I4, T5, I5, T6, I6, T7, I7, T8, I8, T9, I9, T10, I10, T11, I11, T12, I12, T13, I13, T14, I14, T15, I15, T16, I16, T17, I17) \
		sql_create_complete_17(NAME, CMP, CONTR, T1, I1, #I1, T2, I2, #I2, T3, I3, #I3, T4, I4, #I4, T5, I5, #I5, T6, I6, #I6, T7, I7, #I7, T8, I8, #I8, T9, I9, #I9, T10, I10, #I10, T11, I11, #I11, T12, I12, #I12, T13, I13, #I13, T14, I14, #I14, T15, I15, #I15, T16, I16, #I16, T17, I17, #I17) \

// ---------------------------------------------------
//                  End Create 17
// ---------------------------------------------------

// ---------------------------------------------------
//                  Begin Create 18
// ---------------------------------------------------
#define sql_create_complete_18(NAME, CMP, CONTR, T1, I1, N1, T2, I2, N2, T3, I3, N3, T4, I4, N4, T5, I5, N5, T6, I6, N6, T7, I7, N7, T8, I8, N8, T9, I9, N9, T10, I10, N10, T11, I11, N11, T12, I12, N12, T13, I13, N13, T14, I14, N14, T15, I15, N15, T16, I16, N16, T17, I17, N17, T18, I18, N18) \
	struct NAME; \
	enum NAME##_enum { \
    NAME##_##I1,\
    NAME##_##I2,\
    NAME##_##I3,\
    NAME##_##I4,\
    NAME##_##I5,\
    NAME##_##I6,\
    NAME##_##I7,\
    NAME##_##I8,\
    NAME##_##I9,\
    NAME##_##I10,\
    NAME##_##I11,\
    NAME##_##I12,\
    NAME##_##I13,\
    NAME##_##I14,\
    NAME##_##I15,\
    NAME##_##I16,\
    NAME##_##I17,\
    NAME##_##I18 \
	,NAME##_NULL \
	}; \
	template <class Manip>\
	class NAME##_value_list { \
	public: \
	const NAME* obj;\
	const char* delim;\
	Manip manip;\
	public: \
	NAME##_value_list (const NAME* o, const char* d, Manip m) :\
	obj(o), delim(d), manip(m) { } \
	};\
	template <class Manip>\
	class NAME##_##field_list {\
	public: \
	const NAME* obj; \
	const char* delim;\
	Manip manip;\
	public: \
	NAME##_field_list (const NAME* o, const char* d, Manip m) :\
	obj(o), delim(d), manip(m) { } \
	};\
	template <class Manip>\
	class NAME##_equal_list { \
	public: \
	const NAME* obj;\
	const char* delim;\
	const char* comp;\
	Manip manip;\
	public: \
	NAME##_equal_list (const NAME* o, const char* d, const char* c, Manip m) :\
	obj(o), delim(d), comp(c), manip(m) { }\
	};\
	template <class Manip>\
	class NAME##_cus_value_list {\
	public:\
	const NAME* obj;\
	std::vector<bool> *include;\
	bool del_vector;\
	const char* delim;\
	Manip manip;\
	public: \
	~NAME##_cus_value_list () {if (del_vector) delete include;} \
	NAME##_cus_value_list (const NAME* o, const char* d, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13, bool i14, bool i15, bool i16, bool i17, bool i18);\
	NAME##_cus_value_list (const NAME* o, const char* d, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13, NAME##_enum i14, NAME##_enum i15, NAME##_enum i16, NAME##_enum i17, NAME##_enum i18); \
	NAME##_cus_value_list (const NAME* o, const char* d, Manip m ,std::vector<bool>* i) :\
	obj(o), include(i), del_vector(false), delim(d), manip(m) { }\
	};\
	template <class Manip>\
	class NAME##_cus_field_list { \
	public:\
	const NAME* obj; \
	std::vector<bool> *include; \
	bool del_vector; \
	const char* delim;\
	Manip manip;\
	public: \
	~NAME##_cus_field_list () {if (del_vector) delete include;} \
	NAME##_cus_field_list (const NAME* o, const char* d, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13, bool i14, bool i15, bool i16, bool i17, bool i18); \
	NAME##_cus_field_list (const NAME* o, const char* d, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13, NAME##_enum i14, NAME##_enum i15, NAME##_enum i16, NAME##_enum i17, NAME##_enum i18); \
	NAME##_cus_field_list (const NAME* o, const char* d, Manip m, std::vector<bool> *i) :\
	obj(o), include(i), del_vector(false), delim(d), manip(m) { }\
	};\
	template <class Manip>\
	class NAME##_cus_equal_list {\
	public:\
	const NAME* obj;\
	std::vector<bool> *include;\
	bool del_vector;\
	const char* delim;\
	const char* comp;\
	Manip manip;\
	public:\
	~NAME##_##cus_equal_list () {if (del_vector) delete include;}\
	NAME##_##cus_equal_list (const NAME* o, const char* d, const char* c, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13, bool i14, bool i15, bool i16, bool i17, bool i18); \
	NAME##_##cus_equal_list (const NAME* o, const char* d, const char* c, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13, NAME##_enum i14, NAME##_enum i15, NAME##_enum i16, NAME##_enum i17, NAME##_enum i18); \
	NAME##_##cus_equal_list (const NAME* o, const char* d, const char* c, Manip m, std::vector<bool> *i) :\
	obj(o), include(i), del_vector(false), delim(d), comp(c), manip(m) { }\
	};\
	template <mysqlpp::sql_dummy_type dummy> int sql_compare_##NAME(const NAME&, const NAME&);\
	struct NAME {\
    T1 I1;\
    T2 I2;\
    T3 I3;\
    T4 I4;\
    T5 I5;\
    T6 I6;\
    T7 I7;\
    T8 I8;\
    T9 I9;\
    T10 I10;\
    T11 I11;\
    T12 I12;\
    T13 I13;\
    T14 I14;\
    T15 I15;\
    T16 I16;\
    T17 I17;\
    T18 I18; \
	NAME() : table_override_(0) { }\
	NAME(const mysqlpp::Row& row);\
	void set(const mysqlpp::Row &row);\
	sql_compare_define_##CMP(NAME, T1, I1, T2, I2, T3, I3, T4, I4, T5, I5, T6, I6, T7, I7, T8, I8, T9, I9, T10, I10, T11, I11, T12, I12, T13, I13, T14, I14, T15, I15, T16, I16, T17, I17, T18, I18, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)\
	sql_construct_define_##CONTR(NAME, T1, I1, T2, I2, T3, I3, T4, I4, T5, I5, T6, I6, T7, I7, T8, I8, T9, I9, T10, I10, T11, I11, T12, I12, T13, I13, T14, I14, T15, I15, T16, I16, T17, I17, T18, I18, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)\
	static const char* names[];\
	static void table(const char* t) { table_ = t; }\
	const char* table() const\
			{ return table_override_ ? table_override_ : NAME::table_; }\
	void instance_table(const char* t) { table_override_ = t; }\
	NAME##_value_list<mysqlpp::quote_type0> value_list() const {\
		return value_list(",", mysqlpp::quote);}\
	NAME##_value_list<mysqlpp::quote_type0> value_list(const char* d) const {\
		return value_list(d, mysqlpp::quote);}\
	template <class Manip>\
	NAME##_value_list<Manip> value_list(const char* d, Manip m) const;\
	NAME##_field_list<mysqlpp::do_nothing_type0> field_list() const {\
		return field_list(",", mysqlpp::do_nothing);}\
	NAME##_field_list<mysqlpp::do_nothing_type0> field_list(const char* d) const {\
		return field_list(d, mysqlpp::do_nothing);}\
	template <class Manip>\
	NAME##_field_list<Manip> field_list(const char* d, Manip m) const;\
	NAME##_equal_list<mysqlpp::quote_type0> equal_list(const char* d = ",",\
			const char* c = " = ") const\
			{ return equal_list(d, c, mysqlpp::quote); }\
	template <class Manip>\
	NAME##_equal_list<Manip> equal_list(const char* d, const char* c, Manip m) const;\
	/* cus_data */\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false, bool i15 = false, bool i16 = false, bool i17 = false, bool i18 = false) const\
			{ return value_list(",", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL, NAME##_enum i15 = NAME##_NULL, NAME##_enum i16 = NAME##_NULL, NAME##_enum i17 = NAME##_NULL, NAME##_enum i18 = NAME##_NULL) const\
			{ return value_list(",", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(std::vector<bool> *i) const\
			{ return value_list(",", mysqlpp::quote, i); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(mysqlpp::sql_cmp_type sc) const\
			{ return value_list(",", mysqlpp::quote, sc); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(const char* d, bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false, bool i15 = false, bool i16 = false, bool i17 = false, bool i18 = false) const\
			{ return value_list(d, mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(const char* d, NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL, NAME##_enum i15 = NAME##_NULL, NAME##_enum i16 = NAME##_NULL, NAME##_enum i17 = NAME##_NULL, NAME##_enum i18 = NAME##_NULL) const\
			{ return value_list(d, mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(const char* d,\
			std::vector<bool> *i) const\
			{ return value_list(d, mysqlpp::quote, i); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(const char* d,\
			mysqlpp::sql_cmp_type sc) const\
			{ return value_list(d, mysqlpp::quote, sc); }\
	template <class Manip>\
	NAME##_cus_value_list<Manip> value_list(const char* d, Manip m,\
			bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false, bool i15 = false, bool i16 = false, bool i17 = false, bool i18 = false) const;\
	template <class Manip>\
	NAME##_cus_value_list<Manip> value_list(const char* d, Manip m,\
			NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL, NAME##_enum i15 = NAME##_NULL, NAME##_enum i16 = NAME##_NULL, NAME##_enum i17 = NAME##_NULL, NAME##_enum i18 = NAME##_NULL) const;\
	template <class Manip>\
	NAME##_cus_value_list<Manip> value_list(const char* d, Manip m,\
			std::vector<bool>* i) const;\
	template <class Manip>\
	NAME##_cus_value_list<Manip> value_list(const char* d, Manip m, \
			mysqlpp::sql_cmp_type sc) const;\
	/* cus field */\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false, bool i15 = false, bool i16 = false, bool i17 = false, bool i18 = false) const \
			{ return field_list(",", mysqlpp::do_nothing, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL, NAME##_enum i15 = NAME##_NULL, NAME##_enum i16 = NAME##_NULL, NAME##_enum i17 = NAME##_NULL, NAME##_enum i18 = NAME##_NULL) const\
			{ return field_list(",", mysqlpp::do_nothing, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(std::vector<bool> *i) const\
			{ return field_list(",", mysqlpp::do_nothing, i); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(mysqlpp::sql_cmp_type sc) const\
			{ return field_list(",", mysqlpp::do_nothing, sc); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(const char* d,\
			bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false, bool i15 = false, bool i16 = false, bool i17 = false, bool i18 = false) const\
			{ return field_list(d, mysqlpp::do_nothing, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(const char* d,\
			NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL, NAME##_enum i15 = NAME##_NULL, NAME##_enum i16 = NAME##_NULL, NAME##_enum i17 = NAME##_NULL, NAME##_enum i18 = NAME##_NULL) const\
			{ return field_list(d, mysqlpp::do_nothing, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(const char* d,\
			std::vector<bool>* i) const\
			{ return field_list(d, mysqlpp::do_nothing, i); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(const char* d,\
			mysqlpp::sql_cmp_type sc) const\
			{ return field_list(d, mysqlpp::do_nothing, sc); }\
	template <class Manip>\
	NAME##_cus_field_list<Manip> field_list(const char* d, Manip m,\
			bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false, bool i15 = false, bool i16 = false, bool i17 = false, bool i18 = false) const;\
	template <class Manip>\
	NAME##_cus_field_list<Manip> field_list(const char* d, Manip m,\
			NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL, NAME##_enum i15 = NAME##_NULL, NAME##_enum i16 = NAME##_NULL, NAME##_enum i17 = NAME##_NULL, NAME##_enum i18 = NAME##_NULL) const;\
	template <class Manip>\
	NAME##_cus_field_list<Manip> field_list(const char* d, Manip m,\
			std::vector<bool> *i) const;\
	template <class Manip>\
	NAME##_cus_field_list<Manip> field_list(const char* d, Manip m,\
			mysqlpp::sql_cmp_type sc) const;\
	/* cus equal */\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false, bool i15 = false, bool i16 = false, bool i17 = false, bool i18 = false) const\
			{ return equal_list(",", " = ", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL, NAME##_enum i15 = NAME##_NULL, NAME##_enum i16 = NAME##_NULL, NAME##_enum i17 = NAME##_NULL, NAME##_enum i18 = NAME##_NULL) const\
			{ return equal_list(",", " = ", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(std::vector<bool>* i) const\
			{ return equal_list(",", " = ", mysqlpp::quote, i); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(mysqlpp::sql_cmp_type sc) const\
			{ return equal_list(",", " = ", mysqlpp::quote, sc); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false, bool i15 = false, bool i16 = false, bool i17 = false, bool i18 = false) const\
			{ return equal_list(d, " = ", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL, NAME##_enum i15 = NAME##_NULL, NAME##_enum i16 = NAME##_NULL, NAME##_enum i17 = NAME##_NULL, NAME##_enum i18 = NAME##_NULL) const\
			{ return equal_list(d, " = ", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d,\
			std::vector<bool> *i) const\
			{ return equal_list(d, " = ", mysqlpp::quote, i); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d,\
			mysqlpp::sql_cmp_type sc) const\
			{ return equal_list(d, " = ", mysqlpp::quote, sc); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, const char* c,\
			bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false, bool i15 = false, bool i16 = false, bool i17 = false, bool i18 = false) const\
			{ return equal_list(d, c, mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, const char* c,\
			NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL, NAME##_enum i15 = NAME##_NULL, NAME##_enum i16 = NAME##_NULL, NAME##_enum i17 = NAME##_NULL, NAME##_enum i18 = NAME##_NULL) const\
			{ return equal_list(d, c, mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, const char* c,\
			std::vector<bool> *i) const\
			{ return equal_list(d, c, mysqlpp::quote, i); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, const char* c,\
			mysqlpp::sql_cmp_type sc) const\
			{ return equal_list(d, c, mysqlpp::quote, sc); }\
	template <class Manip>\
	NAME##_cus_equal_list<Manip> equal_list(const char* d, const char* c, Manip m, \
						bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false, bool i15 = false, bool i16 = false, bool i17 = false, bool i18 = false) const;\
	template <class Manip>\
	NAME##_cus_equal_list<Manip> equal_list(const char* d, const char* c, Manip m, \
						NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL, NAME##_enum i15 = NAME##_NULL, NAME##_enum i16 = NAME##_NULL, NAME##_enum i17 = NAME##_NULL, NAME##_enum i18 = NAME##_NULL) const;\
	template <class Manip>\
	NAME##_cus_equal_list<Manip> equal_list(const char* d, const char* c, Manip m, \
						std::vector<bool> *i) const;\
	template <class Manip>\
	NAME##_cus_equal_list<Manip> equal_list(const char* d, const char* c, Manip m, \
						mysqlpp::sql_cmp_type sc) const;\
	private:\
	static const char* table_;\
	const char* table_override_;\
	};\
	MYSQLPP_SSQLS_CONDITIONAL_STATICS(\
		const char* NAME::names[] = {\
			    N1 ,\
    N2 ,\
    N3 ,\
    N4 ,\
    N5 ,\
    N6 ,\
    N7 ,\
    N8 ,\
    N9 ,\
    N10 ,\
    N11 ,\
    N12 ,\
    N13 ,\
    N14 ,\
    N15 ,\
    N16 ,\
    N17 ,\
    N18 \
		};\
		const char* NAME::table_ = #NAME;\
	)\
	template <class Manip>\
	NAME##_cus_value_list<Manip>::NAME##_cus_value_list\
			(const NAME* o, const char* d, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13, bool i14, bool i15, bool i16, bool i17, bool i18)\
	{\
		delim = d;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(18, false);\
    if (i1) (*include)[0]=true;\
    if (i2) (*include)[1]=true;\
    if (i3) (*include)[2]=true;\
    if (i4) (*include)[3]=true;\
    if (i5) (*include)[4]=true;\
    if (i6) (*include)[5]=true;\
    if (i7) (*include)[6]=true;\
    if (i8) (*include)[7]=true;\
    if (i9) (*include)[8]=true;\
    if (i10) (*include)[9]=true;\
    if (i11) (*include)[10]=true;\
    if (i12) (*include)[11]=true;\
    if (i13) (*include)[12]=true;\
    if (i14) (*include)[13]=true;\
    if (i15) (*include)[14]=true;\
    if (i16) (*include)[15]=true;\
    if (i17) (*include)[16]=true;\
    if (i18) (*include)[17]=true;\
	}\
	template <class Manip>\
	NAME##_cus_value_list<Manip>::NAME##_cus_value_list\
			(const NAME* o, const char* d, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13, NAME##_enum i14, NAME##_enum i15, NAME##_enum i16, NAME##_enum i17, NAME##_enum i18)\
	{\
		delim = d;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(18, false);\
    if (i1 == NAME##_NULL) return;\
    (*include)[i1]=true;\
    if (i2 == NAME##_NULL) return;\
    (*include)[i2]=true;\
    if (i3 == NAME##_NULL) return;\
    (*include)[i3]=true;\
    if (i4 == NAME##_NULL) return;\
    (*include)[i4]=true;\
    if (i5 == NAME##_NULL) return;\
    (*include)[i5]=true;\
    if (i6 == NAME##_NULL) return;\
    (*include)[i6]=true;\
    if (i7 == NAME##_NULL) return;\
    (*include)[i7]=true;\
    if (i8 == NAME##_NULL) return;\
    (*include)[i8]=true;\
    if (i9 == NAME##_NULL) return;\
    (*include)[i9]=true;\
    if (i10 == NAME##_NULL) return;\
    (*include)[i10]=true;\
    if (i11 == NAME##_NULL) return;\
    (*include)[i11]=true;\
    if (i12 == NAME##_NULL) return;\
    (*include)[i12]=true;\
    if (i13 == NAME##_NULL) return;\
    (*include)[i13]=true;\
    if (i14 == NAME##_NULL) return;\
    (*include)[i14]=true;\
    if (i15 == NAME##_NULL) return;\
    (*include)[i15]=true;\
    if (i16 == NAME##_NULL) return;\
    (*include)[i16]=true;\
    if (i17 == NAME##_NULL) return;\
    (*include)[i17]=true;\
    if (i18 == NAME##_NULL) return;\
    (*include)[i18]=true;\
	}\
	template <class Manip>\
	NAME##_cus_field_list<Manip>::NAME##_cus_field_list\
			(const NAME* o, const char* d, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13, bool i14, bool i15, bool i16, bool i17, bool i18)\
	{\
		delim = d;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(18, false);\
    if (i1) (*include)[0]=true;\
    if (i2) (*include)[1]=true;\
    if (i3) (*include)[2]=true;\
    if (i4) (*include)[3]=true;\
    if (i5) (*include)[4]=true;\
    if (i6) (*include)[5]=true;\
    if (i7) (*include)[6]=true;\
    if (i8) (*include)[7]=true;\
    if (i9) (*include)[8]=true;\
    if (i10) (*include)[9]=true;\
    if (i11) (*include)[10]=true;\
    if (i12) (*include)[11]=true;\
    if (i13) (*include)[12]=true;\
    if (i14) (*include)[13]=true;\
    if (i15) (*include)[14]=true;\
    if (i16) (*include)[15]=true;\
    if (i17) (*include)[16]=true;\
    if (i18) (*include)[17]=true;\
	}\
	template <class Manip>\
	NAME##_cus_field_list<Manip>::NAME##_cus_field_list\
			(const NAME* o, const char* d, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13, NAME##_enum i14, NAME##_enum i15, NAME##_enum i16, NAME##_enum i17, NAME##_enum i18)\
	{\
		delim = d;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(18, false);\
    if (i1 == NAME##_NULL) return;\
    (*include)[i1]=true;\
    if (i2 == NAME##_NULL) return;\
    (*include)[i2]=true;\
    if (i3 == NAME##_NULL) return;\
    (*include)[i3]=true;\
    if (i4 == NAME##_NULL) return;\
    (*include)[i4]=true;\
    if (i5 == NAME##_NULL) return;\
    (*include)[i5]=true;\
    if (i6 == NAME##_NULL) return;\
    (*include)[i6]=true;\
    if (i7 == NAME##_NULL) return;\
    (*include)[i7]=true;\
    if (i8 == NAME##_NULL) return;\
    (*include)[i8]=true;\
    if (i9 == NAME##_NULL) return;\
    (*include)[i9]=true;\
    if (i10 == NAME##_NULL) return;\
    (*include)[i10]=true;\
    if (i11 == NAME##_NULL) return;\
    (*include)[i11]=true;\
    if (i12 == NAME##_NULL) return;\
    (*include)[i12]=true;\
    if (i13 == NAME##_NULL) return;\
    (*include)[i13]=true;\
    if (i14 == NAME##_NULL) return;\
    (*include)[i14]=true;\
    if (i15 == NAME##_NULL) return;\
    (*include)[i15]=true;\
    if (i16 == NAME##_NULL) return;\
    (*include)[i16]=true;\
    if (i17 == NAME##_NULL) return;\
    (*include)[i17]=true;\
    if (i18 == NAME##_NULL) return;\
    (*include)[i18]=true;\
	}\
	template <class Manip>\
	NAME##_cus_equal_list<Manip>::NAME##_cus_equal_list\
			(const NAME* o, const char* d, const char* c, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13, bool i14, bool i15, bool i16, bool i17, bool i18)\
	{\
		delim = d;\
		comp = c;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(18, false);\
    if (i1) (*include)[0]=true;\
    if (i2) (*include)[1]=true;\
    if (i3) (*include)[2]=true;\
    if (i4) (*include)[3]=true;\
    if (i5) (*include)[4]=true;\
    if (i6) (*include)[5]=true;\
    if (i7) (*include)[6]=true;\
    if (i8) (*include)[7]=true;\
    if (i9) (*include)[8]=true;\
    if (i10) (*include)[9]=true;\
    if (i11) (*include)[10]=true;\
    if (i12) (*include)[11]=true;\
    if (i13) (*include)[12]=true;\
    if (i14) (*include)[13]=true;\
    if (i15) (*include)[14]=true;\
    if (i16) (*include)[15]=true;\
    if (i17) (*include)[16]=true;\
    if (i18) (*include)[17]=true;\
	}\
	template <class Manip>\
	NAME##_cus_equal_list<Manip>::NAME##_cus_equal_list\
			(const NAME* o, const char* d, const char* c, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13, NAME##_enum i14, NAME##_enum i15, NAME##_enum i16, NAME##_enum i17, NAME##_enum i18)\
	{\
		delim = d;\
		comp = c;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(18, false);\
    if (i1 == NAME##_NULL) return;\
    (*include)[i1]=true;\
    if (i2 == NAME##_NULL) return;\
    (*include)[i2]=true;\
    if (i3 == NAME##_NULL) return;\
    (*include)[i3]=true;\
    if (i4 == NAME##_NULL) return;\
    (*include)[i4]=true;\
    if (i5 == NAME##_NULL) return;\
    (*include)[i5]=true;\
    if (i6 == NAME##_NULL) return;\
    (*include)[i6]=true;\
    if (i7 == NAME##_NULL) return;\
    (*include)[i7]=true;\
    if (i8 == NAME##_NULL) return;\
    (*include)[i8]=true;\
    if (i9 == NAME##_NULL) return;\
    (*include)[i9]=true;\
    if (i10 == NAME##_NULL) return;\
    (*include)[i10]=true;\
    if (i11 == NAME##_NULL) return;\
    (*include)[i11]=true;\
    if (i12 == NAME##_NULL) return;\
    (*include)[i12]=true;\
    if (i13 == NAME##_NULL) return;\
    (*include)[i13]=true;\
    if (i14 == NAME##_NULL) return;\
    (*include)[i14]=true;\
    if (i15 == NAME##_NULL) return;\
    (*include)[i15]=true;\
    if (i16 == NAME##_NULL) return;\
    (*include)[i16]=true;\
    if (i17 == NAME##_NULL) return;\
    (*include)[i17]=true;\
    if (i18 == NAME##_NULL) return;\
    (*include)[i18]=true;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_value_list<Manip>& obj)\
	{\
    s << obj.manip << obj.obj->I1 << obj.delim;\
    s << obj.manip << obj.obj->I2 << obj.delim;\
    s << obj.manip << obj.obj->I3 << obj.delim;\
    s << obj.manip << obj.obj->I4 << obj.delim;\
    s << obj.manip << obj.obj->I5 << obj.delim;\
    s << obj.manip << obj.obj->I6 << obj.delim;\
    s << obj.manip << obj.obj->I7 << obj.delim;\
    s << obj.manip << obj.obj->I8 << obj.delim;\
    s << obj.manip << obj.obj->I9 << obj.delim;\
    s << obj.manip << obj.obj->I10 << obj.delim;\
    s << obj.manip << obj.obj->I11 << obj.delim;\
    s << obj.manip << obj.obj->I12 << obj.delim;\
    s << obj.manip << obj.obj->I13 << obj.delim;\
    s << obj.manip << obj.obj->I14 << obj.delim;\
    s << obj.manip << obj.obj->I15 << obj.delim;\
    s << obj.manip << obj.obj->I16 << obj.delim;\
    s << obj.manip << obj.obj->I17 << obj.delim;\
    s << obj.manip << obj.obj->I18;\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_field_list<Manip>& obj)\
	{\
    s << obj.manip << '`' << obj.obj->names[0] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[1] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[2] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[3] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[4] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[5] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[6] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[7] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[8] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[9] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[10] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[11] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[12] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[13] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[14] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[15] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[16] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[17] << '`';\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_equal_list<Manip>& obj)\
	{\
    s << '`' << obj.obj->names[0] << '`' << obj.comp << obj.manip << obj.obj->I1 << obj.delim;\
    s << '`' << obj.obj->names[1] << '`' << obj.comp << obj.manip << obj.obj->I2 << obj.delim;\
    s << '`' << obj.obj->names[2] << '`' << obj.comp << obj.manip << obj.obj->I3 << obj.delim;\
    s << '`' << obj.obj->names[3] << '`' << obj.comp << obj.manip << obj.obj->I4 << obj.delim;\
    s << '`' << obj.obj->names[4] << '`' << obj.comp << obj.manip << obj.obj->I5 << obj.delim;\
    s << '`' << obj.obj->names[5] << '`' << obj.comp << obj.manip << obj.obj->I6 << obj.delim;\
    s << '`' << obj.obj->names[6] << '`' << obj.comp << obj.manip << obj.obj->I7 << obj.delim;\
    s << '`' << obj.obj->names[7] << '`' << obj.comp << obj.manip << obj.obj->I8 << obj.delim;\
    s << '`' << obj.obj->names[8] << '`' << obj.comp << obj.manip << obj.obj->I9 << obj.delim;\
    s << '`' << obj.obj->names[9] << '`' << obj.comp << obj.manip << obj.obj->I10 << obj.delim;\
    s << '`' << obj.obj->names[10] << '`' << obj.comp << obj.manip << obj.obj->I11 << obj.delim;\
    s << '`' << obj.obj->names[11] << '`' << obj.comp << obj.manip << obj.obj->I12 << obj.delim;\
    s << '`' << obj.obj->names[12] << '`' << obj.comp << obj.manip << obj.obj->I13 << obj.delim;\
    s << '`' << obj.obj->names[13] << '`' << obj.comp << obj.manip << obj.obj->I14 << obj.delim;\
    s << '`' << obj.obj->names[14] << '`' << obj.comp << obj.manip << obj.obj->I15 << obj.delim;\
    s << '`' << obj.obj->names[15] << '`' << obj.comp << obj.manip << obj.obj->I16 << obj.delim;\
    s << '`' << obj.obj->names[16] << '`' << obj.comp << obj.manip << obj.obj->I17 << obj.delim;\
    s << '`' << obj.obj->names[17] << '`' << obj.comp << obj.manip << obj.obj->I18;\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_cus_value_list<Manip>& obj)\
	{\
		bool before = false;\
    if ((*obj.include)[0]) { \
      s << obj.manip << obj.obj->I1;\
      before = true; \
     } \
    if ((*obj.include)[1]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I2;\
      before = true; \
     } \
    if ((*obj.include)[2]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I3;\
      before = true; \
     } \
    if ((*obj.include)[3]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I4;\
      before = true; \
     } \
    if ((*obj.include)[4]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I5;\
      before = true; \
     } \
    if ((*obj.include)[5]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I6;\
      before = true; \
     } \
    if ((*obj.include)[6]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I7;\
      before = true; \
     } \
    if ((*obj.include)[7]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I8;\
      before = true; \
     } \
    if ((*obj.include)[8]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I9;\
      before = true; \
     } \
    if ((*obj.include)[9]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I10;\
      before = true; \
     } \
    if ((*obj.include)[10]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I11;\
      before = true; \
     } \
    if ((*obj.include)[11]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I12;\
      before = true; \
     } \
    if ((*obj.include)[12]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I13;\
      before = true; \
     } \
    if ((*obj.include)[13]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I14;\
      before = true; \
     } \
    if ((*obj.include)[14]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I15;\
      before = true; \
     } \
    if ((*obj.include)[15]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I16;\
      before = true; \
     } \
    if ((*obj.include)[16]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I17;\
      before = true; \
     } \
    if ((*obj.include)[17]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I18;\
     } \
        (void)before;\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_cus_field_list<Manip>& obj)\
	{\
		bool before = false;\
    if ((*obj.include)[0]) { \
      s << obj.manip << '`' << obj.obj->names[0] << '`';\
      before = true; \
     } \
    if ((*obj.include)[1]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[1] << '`';\
      before = true; \
     } \
    if ((*obj.include)[2]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[2] << '`';\
      before = true; \
     } \
    if ((*obj.include)[3]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[3] << '`';\
      before = true; \
     } \
    if ((*obj.include)[4]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[4] << '`';\
      before = true; \
     } \
    if ((*obj.include)[5]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[5] << '`';\
      before = true; \
     } \
    if ((*obj.include)[6]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[6] << '`';\
      before = true; \
     } \
    if ((*obj.include)[7]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[7] << '`';\
      before = true; \
     } \
    if ((*obj.include)[8]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[8] << '`';\
      before = true; \
     } \
    if ((*obj.include)[9]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[9] << '`';\
      before = true; \
     } \
    if ((*obj.include)[10]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[10] << '`';\
      before = true; \
     } \
    if ((*obj.include)[11]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[11] << '`';\
      before = true; \
     } \
    if ((*obj.include)[12]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[12] << '`';\
      before = true; \
     } \
    if ((*obj.include)[13]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[13] << '`';\
      before = true; \
     } \
    if ((*obj.include)[14]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[14] << '`';\
      before = true; \
     } \
    if ((*obj.include)[15]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[15] << '`';\
      before = true; \
     } \
    if ((*obj.include)[16]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[16] << '`';\
      before = true; \
     } \
    if ((*obj.include)[17]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[17] << '`';\
     } \
        (void)before;\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_cus_equal_list<Manip>& obj)\
	{\
		bool before = false;\
    if ((*obj.include)[0]) { \
      s << '`' << obj.obj->names[0] << '`' << obj.comp << obj.manip << obj.obj->I1;\
      before = true; \
     } \
    if ((*obj.include)[1]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[1] << '`' << obj.comp << obj.manip << obj.obj->I2;\
      before = true; \
     } \
    if ((*obj.include)[2]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[2] << '`' << obj.comp << obj.manip << obj.obj->I3;\
      before = true; \
     } \
    if ((*obj.include)[3]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[3] << '`' << obj.comp << obj.manip << obj.obj->I4;\
      before = true; \
     } \
    if ((*obj.include)[4]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[4] << '`' << obj.comp << obj.manip << obj.obj->I5;\
      before = true; \
     } \
    if ((*obj.include)[5]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[5] << '`' << obj.comp << obj.manip << obj.obj->I6;\
      before = true; \
     } \
    if ((*obj.include)[6]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[6] << '`' << obj.comp << obj.manip << obj.obj->I7;\
      before = true; \
     } \
    if ((*obj.include)[7]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[7] << '`' << obj.comp << obj.manip << obj.obj->I8;\
      before = true; \
     } \
    if ((*obj.include)[8]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[8] << '`' << obj.comp << obj.manip << obj.obj->I9;\
      before = true; \
     } \
    if ((*obj.include)[9]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[9] << '`' << obj.comp << obj.manip << obj.obj->I10;\
      before = true; \
     } \
    if ((*obj.include)[10]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[10] << '`' << obj.comp << obj.manip << obj.obj->I11;\
      before = true; \
     } \
    if ((*obj.include)[11]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[11] << '`' << obj.comp << obj.manip << obj.obj->I12;\
      before = true; \
     } \
    if ((*obj.include)[12]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[12] << '`' << obj.comp << obj.manip << obj.obj->I13;\
      before = true; \
     } \
    if ((*obj.include)[13]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[13] << '`' << obj.comp << obj.manip << obj.obj->I14;\
      before = true; \
     } \
    if ((*obj.include)[14]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[14] << '`' << obj.comp << obj.manip << obj.obj->I15;\
      before = true; \
     } \
    if ((*obj.include)[15]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[15] << '`' << obj.comp << obj.manip << obj.obj->I16;\
      before = true; \
     } \
    if ((*obj.include)[16]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[16] << '`' << obj.comp << obj.manip << obj.obj->I17;\
      before = true; \
     } \
    if ((*obj.include)[17]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[17] << '`' << obj.comp << obj.manip << obj.obj->I18;\
     } \
        (void)before;\
		return s;\
	}\
	template <class Manip>\
	inline NAME##_value_list<Manip> NAME::value_list(const char* d, Manip m) const\
			{ return NAME##_value_list<Manip> (this, d, m); } \
	template <class Manip>\
	inline NAME##_field_list<Manip> NAME::field_list(const char* d, Manip m) const\
			{ return NAME##_field_list<Manip> (this, d, m); } \
	template <class Manip>\
	inline NAME##_equal_list<Manip> NAME::equal_list(const char* d, const char* c, Manip m) const\
			{ return NAME##_equal_list<Manip> (this, d, c, m); } \
	template <class Manip>\
	inline NAME##_cus_value_list<Manip> NAME::value_list(const char* d, Manip m,\
			bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13, bool i14, bool i15, bool i16, bool i17, bool i18) const\
			{ return NAME##_cus_value_list<Manip> (this, d, m, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18); }\
	template <class Manip>\
	inline NAME##_cus_field_list<Manip> NAME::field_list(const char* d, Manip m,\
			bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13, bool i14, bool i15, bool i16, bool i17, bool i18) const\
			{ return NAME##_cus_field_list<Manip> (this, d, m, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18); }\
	template <class Manip>\
	inline NAME##_cus_equal_list<Manip> NAME::equal_list(const char* d, const char* c, Manip m,\
			bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13, bool i14, bool i15, bool i16, bool i17, bool i18) const\
			{ return NAME##_cus_equal_list<Manip> (this, d, c, m, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18); } \
	template <class Manip>\
	inline NAME##_cus_value_list<Manip> NAME::value_list(const char* d, Manip m,\
			NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13, NAME##_enum i14, NAME##_enum i15, NAME##_enum i16, NAME##_enum i17, NAME##_enum i18) const\
			{ return NAME##_cus_value_list<Manip> (this, d, m, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18); } \
	template <class Manip>\
	inline NAME##_cus_field_list<Manip> NAME::field_list(const char* d, Manip m,\
			NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13, NAME##_enum i14, NAME##_enum i15, NAME##_enum i16, NAME##_enum i17, NAME##_enum i18) const\
			{ return NAME##_cus_field_list<Manip> (this, d, m, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18); } \
	template <class Manip>\
	inline NAME##_cus_equal_list<Manip> NAME::equal_list(const char* d, const char* c, Manip m, \
			NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13, NAME##_enum i14, NAME##_enum i15, NAME##_enum i16, NAME##_enum i17, NAME##_enum i18) const\
			{ return NAME##_cus_equal_list<Manip> (this, d, c, m, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18); } \
	template <class Manip>\
	inline NAME##_cus_value_list<Manip> NAME::value_list(const char* d, Manip m,\
			std::vector<bool> *i) const\
			{ return NAME##_cus_value_list<Manip> (this, d, m, i); }\
	template <class Manip>\
	inline NAME##_cus_field_list<Manip> NAME::field_list(const char* d, Manip m,\
			std::vector<bool> *i) const\
			{ return NAME##_cus_field_list<Manip> (this, d, m, i); }\
	template <class Manip>\
	inline NAME##_cus_equal_list<Manip> NAME::equal_list(const char* d, const char* c, Manip m,\
			std::vector<bool> *i) const\
			{ return NAME##_cus_equal_list<Manip> (this, d, c, m, i); }\
	template <class Manip>\
	inline NAME##_cus_value_list<Manip> \
	NAME::value_list(const char* d, Manip m, mysqlpp::sql_cmp_type /*sc*/) const\
			{ sql_compare_type_def_##CMP(NAME, value, NUM); }\
	template <class Manip>\
	inline NAME##_cus_field_list<Manip> \
	NAME::field_list(const char* d, Manip m, mysqlpp::sql_cmp_type /*sc*/) const\
			{ sql_compare_type_def_##CMP(NAME, field, NUM); }\
	template <class Manip>\
	inline NAME##_cus_equal_list<Manip> \
	NAME::equal_list(const char* d, const char* c, Manip m, mysqlpp::sql_cmp_type /*sc*/) const\
			{ sql_compare_type_defe_##CMP(NAME, equal, NUM); }\
	template <mysqlpp::sql_dummy_type dummy>\
	void populate_##NAME(NAME *s, const mysqlpp::Row &row)\
	{\
		mysqlpp::NoExceptions ignore_schema_mismatches(row);\
    s->I1 = row[N1].conv(T1());\
    s->I2 = row[N2].conv(T2());\
    s->I3 = row[N3].conv(T3());\
    s->I4 = row[N4].conv(T4());\
    s->I5 = row[N5].conv(T5());\
    s->I6 = row[N6].conv(T6());\
    s->I7 = row[N7].conv(T7());\
    s->I8 = row[N8].conv(T8());\
    s->I9 = row[N9].conv(T9());\
    s->I10 = row[N10].conv(T10());\
    s->I11 = row[N11].conv(T11());\
    s->I12 = row[N12].conv(T12());\
    s->I13 = row[N13].conv(T13());\
    s->I14 = row[N14].conv(T14());\
    s->I15 = row[N15].conv(T15());\
    s->I16 = row[N16].conv(T16());\
    s->I17 = row[N17].conv(T17());\
    s->I18 = row[N18].conv(T18());\
	}\
	inline NAME::NAME(const mysqlpp::Row& row) :\
	table_override_(0)\
			{ populate_##NAME<mysqlpp::sql_dummy>(this, row); }\
	inline void NAME::set(const mysqlpp::Row& row)\
	{\
		table_override_ = 0;\
		populate_##NAME<mysqlpp::sql_dummy>(this, row);\
	}\
	sql_COMPARE__##CMP(NAME, I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, I17, I18, 0, 0, 0, 0, 0, 0, 0 )

#define sql_create_18(NAME, CMP, CONTR, T1, I1, T2, I2, T3, I3, T4, I4, T5, I5, T6, I6, T7, I7, T8, I8, T9, I9, T10, I10, T11, I11, T12, I12, T13, I13, T14, I14, T15, I15, T16, I16, T17, I17, T18, I18) \
		sql_create_complete_18(NAME, CMP, CONTR, T1, I1, #I1, T2, I2, #I2, T3, I3, #I3, T4, I4, #I4, T5, I5, #I5, T6, I6, #I6, T7, I7, #I7, T8, I8, #I8, T9, I9, #I9, T10, I10, #I10, T11, I11, #I11, T12, I12, #I12, T13, I13, #I13, T14, I14, #I14, T15, I15, #I15, T16, I16, #I16, T17, I17, #I17, T18, I18, #I18) \

// ---------------------------------------------------
//                  End Create 18
// ---------------------------------------------------

// ---------------------------------------------------
//                  Begin Create 19
// ---------------------------------------------------
#define sql_create_complete_19(NAME, CMP, CONTR, T1, I1, N1, T2, I2, N2, T3, I3, N3, T4, I4, N4, T5, I5, N5, T6, I6, N6, T7, I7, N7, T8, I8, N8, T9, I9, N9, T10, I10, N10, T11, I11, N11, T12, I12, N12, T13, I13, N13, T14, I14, N14, T15, I15, N15, T16, I16, N16, T17, I17, N17, T18, I18, N18, T19, I19, N19) \
	struct NAME; \
	enum NAME##_enum { \
    NAME##_##I1,\
    NAME##_##I2,\
    NAME##_##I3,\
    NAME##_##I4,\
    NAME##_##I5,\
    NAME##_##I6,\
    NAME##_##I7,\
    NAME##_##I8,\
    NAME##_##I9,\
    NAME##_##I10,\
    NAME##_##I11,\
    NAME##_##I12,\
    NAME##_##I13,\
    NAME##_##I14,\
    NAME##_##I15,\
    NAME##_##I16,\
    NAME##_##I17,\
    NAME##_##I18,\
    NAME##_##I19 \
	,NAME##_NULL \
	}; \
	template <class Manip>\
	class NAME##_value_list { \
	public: \
	const NAME* obj;\
	const char* delim;\
	Manip manip;\
	public: \
	NAME##_value_list (const NAME* o, const char* d, Manip m) :\
	obj(o), delim(d), manip(m) { } \
	};\
	template <class Manip>\
	class NAME##_##field_list {\
	public: \
	const NAME* obj; \
	const char* delim;\
	Manip manip;\
	public: \
	NAME##_field_list (const NAME* o, const char* d, Manip m) :\
	obj(o), delim(d), manip(m) { } \
	};\
	template <class Manip>\
	class NAME##_equal_list { \
	public: \
	const NAME* obj;\
	const char* delim;\
	const char* comp;\
	Manip manip;\
	public: \
	NAME##_equal_list (const NAME* o, const char* d, const char* c, Manip m) :\
	obj(o), delim(d), comp(c), manip(m) { }\
	};\
	template <class Manip>\
	class NAME##_cus_value_list {\
	public:\
	const NAME* obj;\
	std::vector<bool> *include;\
	bool del_vector;\
	const char* delim;\
	Manip manip;\
	public: \
	~NAME##_cus_value_list () {if (del_vector) delete include;} \
	NAME##_cus_value_list (const NAME* o, const char* d, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13, bool i14, bool i15, bool i16, bool i17, bool i18, bool i19);\
	NAME##_cus_value_list (const NAME* o, const char* d, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13, NAME##_enum i14, NAME##_enum i15, NAME##_enum i16, NAME##_enum i17, NAME##_enum i18, NAME##_enum i19); \
	NAME##_cus_value_list (const NAME* o, const char* d, Manip m ,std::vector<bool>* i) :\
	obj(o), include(i), del_vector(false), delim(d), manip(m) { }\
	};\
	template <class Manip>\
	class NAME##_cus_field_list { \
	public:\
	const NAME* obj; \
	std::vector<bool> *include; \
	bool del_vector; \
	const char* delim;\
	Manip manip;\
	public: \
	~NAME##_cus_field_list () {if (del_vector) delete include;} \
	NAME##_cus_field_list (const NAME* o, const char* d, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13, bool i14, bool i15, bool i16, bool i17, bool i18, bool i19); \
	NAME##_cus_field_list (const NAME* o, const char* d, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13, NAME##_enum i14, NAME##_enum i15, NAME##_enum i16, NAME##_enum i17, NAME##_enum i18, NAME##_enum i19); \
	NAME##_cus_field_list (const NAME* o, const char* d, Manip m, std::vector<bool> *i) :\
	obj(o), include(i), del_vector(false), delim(d), manip(m) { }\
	};\
	template <class Manip>\
	class NAME##_cus_equal_list {\
	public:\
	const NAME* obj;\
	std::vector<bool> *include;\
	bool del_vector;\
	const char* delim;\
	const char* comp;\
	Manip manip;\
	public:\
	~NAME##_##cus_equal_list () {if (del_vector) delete include;}\
	NAME##_##cus_equal_list (const NAME* o, const char* d, const char* c, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13, bool i14, bool i15, bool i16, bool i17, bool i18, bool i19); \
	NAME##_##cus_equal_list (const NAME* o, const char* d, const char* c, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13, NAME##_enum i14, NAME##_enum i15, NAME##_enum i16, NAME##_enum i17, NAME##_enum i18, NAME##_enum i19); \
	NAME##_##cus_equal_list (const NAME* o, const char* d, const char* c, Manip m, std::vector<bool> *i) :\
	obj(o), include(i), del_vector(false), delim(d), comp(c), manip(m) { }\
	};\
	template <mysqlpp::sql_dummy_type dummy> int sql_compare_##NAME(const NAME&, const NAME&);\
	struct NAME {\
    T1 I1;\
    T2 I2;\
    T3 I3;\
    T4 I4;\
    T5 I5;\
    T6 I6;\
    T7 I7;\
    T8 I8;\
    T9 I9;\
    T10 I10;\
    T11 I11;\
    T12 I12;\
    T13 I13;\
    T14 I14;\
    T15 I15;\
    T16 I16;\
    T17 I17;\
    T18 I18;\
    T19 I19; \
	NAME() : table_override_(0) { }\
	NAME(const mysqlpp::Row& row);\
	void set(const mysqlpp::Row &row);\
	sql_compare_define_##CMP(NAME, T1, I1, T2, I2, T3, I3, T4, I4, T5, I5, T6, I6, T7, I7, T8, I8, T9, I9, T10, I10, T11, I11, T12, I12, T13, I13, T14, I14, T15, I15, T16, I16, T17, I17, T18, I18, T19, I19, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)\
	sql_construct_define_##CONTR(NAME, T1, I1, T2, I2, T3, I3, T4, I4, T5, I5, T6, I6, T7, I7, T8, I8, T9, I9, T10, I10, T11, I11, T12, I12, T13, I13, T14, I14, T15, I15, T16, I16, T17, I17, T18, I18, T19, I19, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)\
	static const char* names[];\
	static void table(const char* t) { table_ = t; }\
	const char* table() const\
			{ return table_override_ ? table_override_ : NAME::table_; }\
	void instance_table(const char* t) { table_override_ = t; }\
	NAME##_value_list<mysqlpp::quote_type0> value_list() const {\
		return value_list(",", mysqlpp::quote);}\
	NAME##_value_list<mysqlpp::quote_type0> value_list(const char* d) const {\
		return value_list(d, mysqlpp::quote);}\
	template <class Manip>\
	NAME##_value_list<Manip> value_list(const char* d, Manip m) const;\
	NAME##_field_list<mysqlpp::do_nothing_type0> field_list() const {\
		return field_list(",", mysqlpp::do_nothing);}\
	NAME##_field_list<mysqlpp::do_nothing_type0> field_list(const char* d) const {\
		return field_list(d, mysqlpp::do_nothing);}\
	template <class Manip>\
	NAME##_field_list<Manip> field_list(const char* d, Manip m) const;\
	NAME##_equal_list<mysqlpp::quote_type0> equal_list(const char* d = ",",\
			const char* c = " = ") const\
			{ return equal_list(d, c, mysqlpp::quote); }\
	template <class Manip>\
	NAME##_equal_list<Manip> equal_list(const char* d, const char* c, Manip m) const;\
	/* cus_data */\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false, bool i15 = false, bool i16 = false, bool i17 = false, bool i18 = false, bool i19 = false) const\
			{ return value_list(",", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL, NAME##_enum i15 = NAME##_NULL, NAME##_enum i16 = NAME##_NULL, NAME##_enum i17 = NAME##_NULL, NAME##_enum i18 = NAME##_NULL, NAME##_enum i19 = NAME##_NULL) const\
			{ return value_list(",", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(std::vector<bool> *i) const\
			{ return value_list(",", mysqlpp::quote, i); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(mysqlpp::sql_cmp_type sc) const\
			{ return value_list(",", mysqlpp::quote, sc); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(const char* d, bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false, bool i15 = false, bool i16 = false, bool i17 = false, bool i18 = false, bool i19 = false) const\
			{ return value_list(d, mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(const char* d, NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL, NAME##_enum i15 = NAME##_NULL, NAME##_enum i16 = NAME##_NULL, NAME##_enum i17 = NAME##_NULL, NAME##_enum i18 = NAME##_NULL, NAME##_enum i19 = NAME##_NULL) const\
			{ return value_list(d, mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(const char* d,\
			std::vector<bool> *i) const\
			{ return value_list(d, mysqlpp::quote, i); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(const char* d,\
			mysqlpp::sql_cmp_type sc) const\
			{ return value_list(d, mysqlpp::quote, sc); }\
	template <class Manip>\
	NAME##_cus_value_list<Manip> value_list(const char* d, Manip m,\
			bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false, bool i15 = false, bool i16 = false, bool i17 = false, bool i18 = false, bool i19 = false) const;\
	template <class Manip>\
	NAME##_cus_value_list<Manip> value_list(const char* d, Manip m,\
			NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL, NAME##_enum i15 = NAME##_NULL, NAME##_enum i16 = NAME##_NULL, NAME##_enum i17 = NAME##_NULL, NAME##_enum i18 = NAME##_NULL, NAME##_enum i19 = NAME##_NULL) const;\
	template <class Manip>\
	NAME##_cus_value_list<Manip> value_list(const char* d, Manip m,\
			std::vector<bool>* i) const;\
	template <class Manip>\
	NAME##_cus_value_list<Manip> value_list(const char* d, Manip m, \
			mysqlpp::sql_cmp_type sc) const;\
	/* cus field */\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false, bool i15 = false, bool i16 = false, bool i17 = false, bool i18 = false, bool i19 = false) const \
			{ return field_list(",", mysqlpp::do_nothing, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL, NAME##_enum i15 = NAME##_NULL, NAME##_enum i16 = NAME##_NULL, NAME##_enum i17 = NAME##_NULL, NAME##_enum i18 = NAME##_NULL, NAME##_enum i19 = NAME##_NULL) const\
			{ return field_list(",", mysqlpp::do_nothing, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(std::vector<bool> *i) const\
			{ return field_list(",", mysqlpp::do_nothing, i); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(mysqlpp::sql_cmp_type sc) const\
			{ return field_list(",", mysqlpp::do_nothing, sc); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(const char* d,\
			bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false, bool i15 = false, bool i16 = false, bool i17 = false, bool i18 = false, bool i19 = false) const\
			{ return field_list(d, mysqlpp::do_nothing, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(const char* d,\
			NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL, NAME##_enum i15 = NAME##_NULL, NAME##_enum i16 = NAME##_NULL, NAME##_enum i17 = NAME##_NULL, NAME##_enum i18 = NAME##_NULL, NAME##_enum i19 = NAME##_NULL) const\
			{ return field_list(d, mysqlpp::do_nothing, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(const char* d,\
			std::vector<bool>* i) const\
			{ return field_list(d, mysqlpp::do_nothing, i); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(const char* d,\
			mysqlpp::sql_cmp_type sc) const\
			{ return field_list(d, mysqlpp::do_nothing, sc); }\
	template <class Manip>\
	NAME##_cus_field_list<Manip> field_list(const char* d, Manip m,\
			bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false, bool i15 = false, bool i16 = false, bool i17 = false, bool i18 = false, bool i19 = false) const;\
	template <class Manip>\
	NAME##_cus_field_list<Manip> field_list(const char* d, Manip m,\
			NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL, NAME##_enum i15 = NAME##_NULL, NAME##_enum i16 = NAME##_NULL, NAME##_enum i17 = NAME##_NULL, NAME##_enum i18 = NAME##_NULL, NAME##_enum i19 = NAME##_NULL) const;\
	template <class Manip>\
	NAME##_cus_field_list<Manip> field_list(const char* d, Manip m,\
			std::vector<bool> *i) const;\
	template <class Manip>\
	NAME##_cus_field_list<Manip> field_list(const char* d, Manip m,\
			mysqlpp::sql_cmp_type sc) const;\
	/* cus equal */\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false, bool i15 = false, bool i16 = false, bool i17 = false, bool i18 = false, bool i19 = false) const\
			{ return equal_list(",", " = ", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL, NAME##_enum i15 = NAME##_NULL, NAME##_enum i16 = NAME##_NULL, NAME##_enum i17 = NAME##_NULL, NAME##_enum i18 = NAME##_NULL, NAME##_enum i19 = NAME##_NULL) const\
			{ return equal_list(",", " = ", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(std::vector<bool>* i) const\
			{ return equal_list(",", " = ", mysqlpp::quote, i); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(mysqlpp::sql_cmp_type sc) const\
			{ return equal_list(",", " = ", mysqlpp::quote, sc); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false, bool i15 = false, bool i16 = false, bool i17 = false, bool i18 = false, bool i19 = false) const\
			{ return equal_list(d, " = ", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL, NAME##_enum i15 = NAME##_NULL, NAME##_enum i16 = NAME##_NULL, NAME##_enum i17 = NAME##_NULL, NAME##_enum i18 = NAME##_NULL, NAME##_enum i19 = NAME##_NULL) const\
			{ return equal_list(d, " = ", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d,\
			std::vector<bool> *i) const\
			{ return equal_list(d, " = ", mysqlpp::quote, i); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d,\
			mysqlpp::sql_cmp_type sc) const\
			{ return equal_list(d, " = ", mysqlpp::quote, sc); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, const char* c,\
			bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false, bool i15 = false, bool i16 = false, bool i17 = false, bool i18 = false, bool i19 = false) const\
			{ return equal_list(d, c, mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, const char* c,\
			NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL, NAME##_enum i15 = NAME##_NULL, NAME##_enum i16 = NAME##_NULL, NAME##_enum i17 = NAME##_NULL, NAME##_enum i18 = NAME##_NULL, NAME##_enum i19 = NAME##_NULL) const\
			{ return equal_list(d, c, mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, const char* c,\
			std::vector<bool> *i) const\
			{ return equal_list(d, c, mysqlpp::quote, i); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, const char* c,\
			mysqlpp::sql_cmp_type sc) const\
			{ return equal_list(d, c, mysqlpp::quote, sc); }\
	template <class Manip>\
	NAME##_cus_equal_list<Manip> equal_list(const char* d, const char* c, Manip m, \
						bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false, bool i15 = false, bool i16 = false, bool i17 = false, bool i18 = false, bool i19 = false) const;\
	template <class Manip>\
	NAME##_cus_equal_list<Manip> equal_list(const char* d, const char* c, Manip m, \
						NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL, NAME##_enum i15 = NAME##_NULL, NAME##_enum i16 = NAME##_NULL, NAME##_enum i17 = NAME##_NULL, NAME##_enum i18 = NAME##_NULL, NAME##_enum i19 = NAME##_NULL) const;\
	template <class Manip>\
	NAME##_cus_equal_list<Manip> equal_list(const char* d, const char* c, Manip m, \
						std::vector<bool> *i) const;\
	template <class Manip>\
	NAME##_cus_equal_list<Manip> equal_list(const char* d, const char* c, Manip m, \
						mysqlpp::sql_cmp_type sc) const;\
	private:\
	static const char* table_;\
	const char* table_override_;\
	};\
	MYSQLPP_SSQLS_CONDITIONAL_STATICS(\
		const char* NAME::names[] = {\
			    N1 ,\
    N2 ,\
    N3 ,\
    N4 ,\
    N5 ,\
    N6 ,\
    N7 ,\
    N8 ,\
    N9 ,\
    N10 ,\
    N11 ,\
    N12 ,\
    N13 ,\
    N14 ,\
    N15 ,\
    N16 ,\
    N17 ,\
    N18 ,\
    N19 \
		};\
		const char* NAME::table_ = #NAME;\
	)\
	template <class Manip>\
	NAME##_cus_value_list<Manip>::NAME##_cus_value_list\
			(const NAME* o, const char* d, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13, bool i14, bool i15, bool i16, bool i17, bool i18, bool i19)\
	{\
		delim = d;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(19, false);\
    if (i1) (*include)[0]=true;\
    if (i2) (*include)[1]=true;\
    if (i3) (*include)[2]=true;\
    if (i4) (*include)[3]=true;\
    if (i5) (*include)[4]=true;\
    if (i6) (*include)[5]=true;\
    if (i7) (*include)[6]=true;\
    if (i8) (*include)[7]=true;\
    if (i9) (*include)[8]=true;\
    if (i10) (*include)[9]=true;\
    if (i11) (*include)[10]=true;\
    if (i12) (*include)[11]=true;\
    if (i13) (*include)[12]=true;\
    if (i14) (*include)[13]=true;\
    if (i15) (*include)[14]=true;\
    if (i16) (*include)[15]=true;\
    if (i17) (*include)[16]=true;\
    if (i18) (*include)[17]=true;\
    if (i19) (*include)[18]=true;\
	}\
	template <class Manip>\
	NAME##_cus_value_list<Manip>::NAME##_cus_value_list\
			(const NAME* o, const char* d, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13, NAME##_enum i14, NAME##_enum i15, NAME##_enum i16, NAME##_enum i17, NAME##_enum i18, NAME##_enum i19)\
	{\
		delim = d;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(19, false);\
    if (i1 == NAME##_NULL) return;\
    (*include)[i1]=true;\
    if (i2 == NAME##_NULL) return;\
    (*include)[i2]=true;\
    if (i3 == NAME##_NULL) return;\
    (*include)[i3]=true;\
    if (i4 == NAME##_NULL) return;\
    (*include)[i4]=true;\
    if (i5 == NAME##_NULL) return;\
    (*include)[i5]=true;\
    if (i6 == NAME##_NULL) return;\
    (*include)[i6]=true;\
    if (i7 == NAME##_NULL) return;\
    (*include)[i7]=true;\
    if (i8 == NAME##_NULL) return;\
    (*include)[i8]=true;\
    if (i9 == NAME##_NULL) return;\
    (*include)[i9]=true;\
    if (i10 == NAME##_NULL) return;\
    (*include)[i10]=true;\
    if (i11 == NAME##_NULL) return;\
    (*include)[i11]=true;\
    if (i12 == NAME##_NULL) return;\
    (*include)[i12]=true;\
    if (i13 == NAME##_NULL) return;\
    (*include)[i13]=true;\
    if (i14 == NAME##_NULL) return;\
    (*include)[i14]=true;\
    if (i15 == NAME##_NULL) return;\
    (*include)[i15]=true;\
    if (i16 == NAME##_NULL) return;\
    (*include)[i16]=true;\
    if (i17 == NAME##_NULL) return;\
    (*include)[i17]=true;\
    if (i18 == NAME##_NULL) return;\
    (*include)[i18]=true;\
    if (i19 == NAME##_NULL) return;\
    (*include)[i19]=true;\
	}\
	template <class Manip>\
	NAME##_cus_field_list<Manip>::NAME##_cus_field_list\
			(const NAME* o, const char* d, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13, bool i14, bool i15, bool i16, bool i17, bool i18, bool i19)\
	{\
		delim = d;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(19, false);\
    if (i1) (*include)[0]=true;\
    if (i2) (*include)[1]=true;\
    if (i3) (*include)[2]=true;\
    if (i4) (*include)[3]=true;\
    if (i5) (*include)[4]=true;\
    if (i6) (*include)[5]=true;\
    if (i7) (*include)[6]=true;\
    if (i8) (*include)[7]=true;\
    if (i9) (*include)[8]=true;\
    if (i10) (*include)[9]=true;\
    if (i11) (*include)[10]=true;\
    if (i12) (*include)[11]=true;\
    if (i13) (*include)[12]=true;\
    if (i14) (*include)[13]=true;\
    if (i15) (*include)[14]=true;\
    if (i16) (*include)[15]=true;\
    if (i17) (*include)[16]=true;\
    if (i18) (*include)[17]=true;\
    if (i19) (*include)[18]=true;\
	}\
	template <class Manip>\
	NAME##_cus_field_list<Manip>::NAME##_cus_field_list\
			(const NAME* o, const char* d, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13, NAME##_enum i14, NAME##_enum i15, NAME##_enum i16, NAME##_enum i17, NAME##_enum i18, NAME##_enum i19)\
	{\
		delim = d;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(19, false);\
    if (i1 == NAME##_NULL) return;\
    (*include)[i1]=true;\
    if (i2 == NAME##_NULL) return;\
    (*include)[i2]=true;\
    if (i3 == NAME##_NULL) return;\
    (*include)[i3]=true;\
    if (i4 == NAME##_NULL) return;\
    (*include)[i4]=true;\
    if (i5 == NAME##_NULL) return;\
    (*include)[i5]=true;\
    if (i6 == NAME##_NULL) return;\
    (*include)[i6]=true;\
    if (i7 == NAME##_NULL) return;\
    (*include)[i7]=true;\
    if (i8 == NAME##_NULL) return;\
    (*include)[i8]=true;\
    if (i9 == NAME##_NULL) return;\
    (*include)[i9]=true;\
    if (i10 == NAME##_NULL) return;\
    (*include)[i10]=true;\
    if (i11 == NAME##_NULL) return;\
    (*include)[i11]=true;\
    if (i12 == NAME##_NULL) return;\
    (*include)[i12]=true;\
    if (i13 == NAME##_NULL) return;\
    (*include)[i13]=true;\
    if (i14 == NAME##_NULL) return;\
    (*include)[i14]=true;\
    if (i15 == NAME##_NULL) return;\
    (*include)[i15]=true;\
    if (i16 == NAME##_NULL) return;\
    (*include)[i16]=true;\
    if (i17 == NAME##_NULL) return;\
    (*include)[i17]=true;\
    if (i18 == NAME##_NULL) return;\
    (*include)[i18]=true;\
    if (i19 == NAME##_NULL) return;\
    (*include)[i19]=true;\
	}\
	template <class Manip>\
	NAME##_cus_equal_list<Manip>::NAME##_cus_equal_list\
			(const NAME* o, const char* d, const char* c, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13, bool i14, bool i15, bool i16, bool i17, bool i18, bool i19)\
	{\
		delim = d;\
		comp = c;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(19, false);\
    if (i1) (*include)[0]=true;\
    if (i2) (*include)[1]=true;\
    if (i3) (*include)[2]=true;\
    if (i4) (*include)[3]=true;\
    if (i5) (*include)[4]=true;\
    if (i6) (*include)[5]=true;\
    if (i7) (*include)[6]=true;\
    if (i8) (*include)[7]=true;\
    if (i9) (*include)[8]=true;\
    if (i10) (*include)[9]=true;\
    if (i11) (*include)[10]=true;\
    if (i12) (*include)[11]=true;\
    if (i13) (*include)[12]=true;\
    if (i14) (*include)[13]=true;\
    if (i15) (*include)[14]=true;\
    if (i16) (*include)[15]=true;\
    if (i17) (*include)[16]=true;\
    if (i18) (*include)[17]=true;\
    if (i19) (*include)[18]=true;\
	}\
	template <class Manip>\
	NAME##_cus_equal_list<Manip>::NAME##_cus_equal_list\
			(const NAME* o, const char* d, const char* c, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13, NAME##_enum i14, NAME##_enum i15, NAME##_enum i16, NAME##_enum i17, NAME##_enum i18, NAME##_enum i19)\
	{\
		delim = d;\
		comp = c;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(19, false);\
    if (i1 == NAME##_NULL) return;\
    (*include)[i1]=true;\
    if (i2 == NAME##_NULL) return;\
    (*include)[i2]=true;\
    if (i3 == NAME##_NULL) return;\
    (*include)[i3]=true;\
    if (i4 == NAME##_NULL) return;\
    (*include)[i4]=true;\
    if (i5 == NAME##_NULL) return;\
    (*include)[i5]=true;\
    if (i6 == NAME##_NULL) return;\
    (*include)[i6]=true;\
    if (i7 == NAME##_NULL) return;\
    (*include)[i7]=true;\
    if (i8 == NAME##_NULL) return;\
    (*include)[i8]=true;\
    if (i9 == NAME##_NULL) return;\
    (*include)[i9]=true;\
    if (i10 == NAME##_NULL) return;\
    (*include)[i10]=true;\
    if (i11 == NAME##_NULL) return;\
    (*include)[i11]=true;\
    if (i12 == NAME##_NULL) return;\
    (*include)[i12]=true;\
    if (i13 == NAME##_NULL) return;\
    (*include)[i13]=true;\
    if (i14 == NAME##_NULL) return;\
    (*include)[i14]=true;\
    if (i15 == NAME##_NULL) return;\
    (*include)[i15]=true;\
    if (i16 == NAME##_NULL) return;\
    (*include)[i16]=true;\
    if (i17 == NAME##_NULL) return;\
    (*include)[i17]=true;\
    if (i18 == NAME##_NULL) return;\
    (*include)[i18]=true;\
    if (i19 == NAME##_NULL) return;\
    (*include)[i19]=true;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_value_list<Manip>& obj)\
	{\
    s << obj.manip << obj.obj->I1 << obj.delim;\
    s << obj.manip << obj.obj->I2 << obj.delim;\
    s << obj.manip << obj.obj->I3 << obj.delim;\
    s << obj.manip << obj.obj->I4 << obj.delim;\
    s << obj.manip << obj.obj->I5 << obj.delim;\
    s << obj.manip << obj.obj->I6 << obj.delim;\
    s << obj.manip << obj.obj->I7 << obj.delim;\
    s << obj.manip << obj.obj->I8 << obj.delim;\
    s << obj.manip << obj.obj->I9 << obj.delim;\
    s << obj.manip << obj.obj->I10 << obj.delim;\
    s << obj.manip << obj.obj->I11 << obj.delim;\
    s << obj.manip << obj.obj->I12 << obj.delim;\
    s << obj.manip << obj.obj->I13 << obj.delim;\
    s << obj.manip << obj.obj->I14 << obj.delim;\
    s << obj.manip << obj.obj->I15 << obj.delim;\
    s << obj.manip << obj.obj->I16 << obj.delim;\
    s << obj.manip << obj.obj->I17 << obj.delim;\
    s << obj.manip << obj.obj->I18 << obj.delim;\
    s << obj.manip << obj.obj->I19;\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_field_list<Manip>& obj)\
	{\
    s << obj.manip << '`' << obj.obj->names[0] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[1] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[2] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[3] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[4] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[5] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[6] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[7] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[8] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[9] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[10] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[11] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[12] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[13] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[14] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[15] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[16] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[17] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[18] << '`';\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_equal_list<Manip>& obj)\
	{\
    s << '`' << obj.obj->names[0] << '`' << obj.comp << obj.manip << obj.obj->I1 << obj.delim;\
    s << '`' << obj.obj->names[1] << '`' << obj.comp << obj.manip << obj.obj->I2 << obj.delim;\
    s << '`' << obj.obj->names[2] << '`' << obj.comp << obj.manip << obj.obj->I3 << obj.delim;\
    s << '`' << obj.obj->names[3] << '`' << obj.comp << obj.manip << obj.obj->I4 << obj.delim;\
    s << '`' << obj.obj->names[4] << '`' << obj.comp << obj.manip << obj.obj->I5 << obj.delim;\
    s << '`' << obj.obj->names[5] << '`' << obj.comp << obj.manip << obj.obj->I6 << obj.delim;\
    s << '`' << obj.obj->names[6] << '`' << obj.comp << obj.manip << obj.obj->I7 << obj.delim;\
    s << '`' << obj.obj->names[7] << '`' << obj.comp << obj.manip << obj.obj->I8 << obj.delim;\
    s << '`' << obj.obj->names[8] << '`' << obj.comp << obj.manip << obj.obj->I9 << obj.delim;\
    s << '`' << obj.obj->names[9] << '`' << obj.comp << obj.manip << obj.obj->I10 << obj.delim;\
    s << '`' << obj.obj->names[10] << '`' << obj.comp << obj.manip << obj.obj->I11 << obj.delim;\
    s << '`' << obj.obj->names[11] << '`' << obj.comp << obj.manip << obj.obj->I12 << obj.delim;\
    s << '`' << obj.obj->names[12] << '`' << obj.comp << obj.manip << obj.obj->I13 << obj.delim;\
    s << '`' << obj.obj->names[13] << '`' << obj.comp << obj.manip << obj.obj->I14 << obj.delim;\
    s << '`' << obj.obj->names[14] << '`' << obj.comp << obj.manip << obj.obj->I15 << obj.delim;\
    s << '`' << obj.obj->names[15] << '`' << obj.comp << obj.manip << obj.obj->I16 << obj.delim;\
    s << '`' << obj.obj->names[16] << '`' << obj.comp << obj.manip << obj.obj->I17 << obj.delim;\
    s << '`' << obj.obj->names[17] << '`' << obj.comp << obj.manip << obj.obj->I18 << obj.delim;\
    s << '`' << obj.obj->names[18] << '`' << obj.comp << obj.manip << obj.obj->I19;\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_cus_value_list<Manip>& obj)\
	{\
		bool before = false;\
    if ((*obj.include)[0]) { \
      s << obj.manip << obj.obj->I1;\
      before = true; \
     } \
    if ((*obj.include)[1]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I2;\
      before = true; \
     } \
    if ((*obj.include)[2]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I3;\
      before = true; \
     } \
    if ((*obj.include)[3]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I4;\
      before = true; \
     } \
    if ((*obj.include)[4]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I5;\
      before = true; \
     } \
    if ((*obj.include)[5]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I6;\
      before = true; \
     } \
    if ((*obj.include)[6]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I7;\
      before = true; \
     } \
    if ((*obj.include)[7]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I8;\
      before = true; \
     } \
    if ((*obj.include)[8]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I9;\
      before = true; \
     } \
    if ((*obj.include)[9]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I10;\
      before = true; \
     } \
    if ((*obj.include)[10]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I11;\
      before = true; \
     } \
    if ((*obj.include)[11]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I12;\
      before = true; \
     } \
    if ((*obj.include)[12]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I13;\
      before = true; \
     } \
    if ((*obj.include)[13]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I14;\
      before = true; \
     } \
    if ((*obj.include)[14]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I15;\
      before = true; \
     } \
    if ((*obj.include)[15]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I16;\
      before = true; \
     } \
    if ((*obj.include)[16]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I17;\
      before = true; \
     } \
    if ((*obj.include)[17]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I18;\
      before = true; \
     } \
    if ((*obj.include)[18]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I19;\
     } \
        (void)before;\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_cus_field_list<Manip>& obj)\
	{\
		bool before = false;\
    if ((*obj.include)[0]) { \
      s << obj.manip << '`' << obj.obj->names[0] << '`';\
      before = true; \
     } \
    if ((*obj.include)[1]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[1] << '`';\
      before = true; \
     } \
    if ((*obj.include)[2]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[2] << '`';\
      before = true; \
     } \
    if ((*obj.include)[3]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[3] << '`';\
      before = true; \
     } \
    if ((*obj.include)[4]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[4] << '`';\
      before = true; \
     } \
    if ((*obj.include)[5]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[5] << '`';\
      before = true; \
     } \
    if ((*obj.include)[6]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[6] << '`';\
      before = true; \
     } \
    if ((*obj.include)[7]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[7] << '`';\
      before = true; \
     } \
    if ((*obj.include)[8]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[8] << '`';\
      before = true; \
     } \
    if ((*obj.include)[9]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[9] << '`';\
      before = true; \
     } \
    if ((*obj.include)[10]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[10] << '`';\
      before = true; \
     } \
    if ((*obj.include)[11]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[11] << '`';\
      before = true; \
     } \
    if ((*obj.include)[12]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[12] << '`';\
      before = true; \
     } \
    if ((*obj.include)[13]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[13] << '`';\
      before = true; \
     } \
    if ((*obj.include)[14]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[14] << '`';\
      before = true; \
     } \
    if ((*obj.include)[15]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[15] << '`';\
      before = true; \
     } \
    if ((*obj.include)[16]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[16] << '`';\
      before = true; \
     } \
    if ((*obj.include)[17]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[17] << '`';\
      before = true; \
     } \
    if ((*obj.include)[18]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[18] << '`';\
     } \
        (void)before;\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_cus_equal_list<Manip>& obj)\
	{\
		bool before = false;\
    if ((*obj.include)[0]) { \
      s << '`' << obj.obj->names[0] << '`' << obj.comp << obj.manip << obj.obj->I1;\
      before = true; \
     } \
    if ((*obj.include)[1]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[1] << '`' << obj.comp << obj.manip << obj.obj->I2;\
      before = true; \
     } \
    if ((*obj.include)[2]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[2] << '`' << obj.comp << obj.manip << obj.obj->I3;\
      before = true; \
     } \
    if ((*obj.include)[3]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[3] << '`' << obj.comp << obj.manip << obj.obj->I4;\
      before = true; \
     } \
    if ((*obj.include)[4]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[4] << '`' << obj.comp << obj.manip << obj.obj->I5;\
      before = true; \
     } \
    if ((*obj.include)[5]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[5] << '`' << obj.comp << obj.manip << obj.obj->I6;\
      before = true; \
     } \
    if ((*obj.include)[6]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[6] << '`' << obj.comp << obj.manip << obj.obj->I7;\
      before = true; \
     } \
    if ((*obj.include)[7]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[7] << '`' << obj.comp << obj.manip << obj.obj->I8;\
      before = true; \
     } \
    if ((*obj.include)[8]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[8] << '`' << obj.comp << obj.manip << obj.obj->I9;\
      before = true; \
     } \
    if ((*obj.include)[9]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[9] << '`' << obj.comp << obj.manip << obj.obj->I10;\
      before = true; \
     } \
    if ((*obj.include)[10]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[10] << '`' << obj.comp << obj.manip << obj.obj->I11;\
      before = true; \
     } \
    if ((*obj.include)[11]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[11] << '`' << obj.comp << obj.manip << obj.obj->I12;\
      before = true; \
     } \
    if ((*obj.include)[12]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[12] << '`' << obj.comp << obj.manip << obj.obj->I13;\
      before = true; \
     } \
    if ((*obj.include)[13]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[13] << '`' << obj.comp << obj.manip << obj.obj->I14;\
      before = true; \
     } \
    if ((*obj.include)[14]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[14] << '`' << obj.comp << obj.manip << obj.obj->I15;\
      before = true; \
     } \
    if ((*obj.include)[15]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[15] << '`' << obj.comp << obj.manip << obj.obj->I16;\
      before = true; \
     } \
    if ((*obj.include)[16]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[16] << '`' << obj.comp << obj.manip << obj.obj->I17;\
      before = true; \
     } \
    if ((*obj.include)[17]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[17] << '`' << obj.comp << obj.manip << obj.obj->I18;\
      before = true; \
     } \
    if ((*obj.include)[18]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[18] << '`' << obj.comp << obj.manip << obj.obj->I19;\
     } \
        (void)before;\
		return s;\
	}\
	template <class Manip>\
	inline NAME##_value_list<Manip> NAME::value_list(const char* d, Manip m) const\
			{ return NAME##_value_list<Manip> (this, d, m); } \
	template <class Manip>\
	inline NAME##_field_list<Manip> NAME::field_list(const char* d, Manip m) const\
			{ return NAME##_field_list<Manip> (this, d, m); } \
	template <class Manip>\
	inline NAME##_equal_list<Manip> NAME::equal_list(const char* d, const char* c, Manip m) const\
			{ return NAME##_equal_list<Manip> (this, d, c, m); } \
	template <class Manip>\
	inline NAME##_cus_value_list<Manip> NAME::value_list(const char* d, Manip m,\
			bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13, bool i14, bool i15, bool i16, bool i17, bool i18, bool i19) const\
			{ return NAME##_cus_value_list<Manip> (this, d, m, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19); }\
	template <class Manip>\
	inline NAME##_cus_field_list<Manip> NAME::field_list(const char* d, Manip m,\
			bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13, bool i14, bool i15, bool i16, bool i17, bool i18, bool i19) const\
			{ return NAME##_cus_field_list<Manip> (this, d, m, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19); }\
	template <class Manip>\
	inline NAME##_cus_equal_list<Manip> NAME::equal_list(const char* d, const char* c, Manip m,\
			bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13, bool i14, bool i15, bool i16, bool i17, bool i18, bool i19) const\
			{ return NAME##_cus_equal_list<Manip> (this, d, c, m, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19); } \
	template <class Manip>\
	inline NAME##_cus_value_list<Manip> NAME::value_list(const char* d, Manip m,\
			NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13, NAME##_enum i14, NAME##_enum i15, NAME##_enum i16, NAME##_enum i17, NAME##_enum i18, NAME##_enum i19) const\
			{ return NAME##_cus_value_list<Manip> (this, d, m, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19); } \
	template <class Manip>\
	inline NAME##_cus_field_list<Manip> NAME::field_list(const char* d, Manip m,\
			NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13, NAME##_enum i14, NAME##_enum i15, NAME##_enum i16, NAME##_enum i17, NAME##_enum i18, NAME##_enum i19) const\
			{ return NAME##_cus_field_list<Manip> (this, d, m, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19); } \
	template <class Manip>\
	inline NAME##_cus_equal_list<Manip> NAME::equal_list(const char* d, const char* c, Manip m, \
			NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13, NAME##_enum i14, NAME##_enum i15, NAME##_enum i16, NAME##_enum i17, NAME##_enum i18, NAME##_enum i19) const\
			{ return NAME##_cus_equal_list<Manip> (this, d, c, m, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19); } \
	template <class Manip>\
	inline NAME##_cus_value_list<Manip> NAME::value_list(const char* d, Manip m,\
			std::vector<bool> *i) const\
			{ return NAME##_cus_value_list<Manip> (this, d, m, i); }\
	template <class Manip>\
	inline NAME##_cus_field_list<Manip> NAME::field_list(const char* d, Manip m,\
			std::vector<bool> *i) const\
			{ return NAME##_cus_field_list<Manip> (this, d, m, i); }\
	template <class Manip>\
	inline NAME##_cus_equal_list<Manip> NAME::equal_list(const char* d, const char* c, Manip m,\
			std::vector<bool> *i) const\
			{ return NAME##_cus_equal_list<Manip> (this, d, c, m, i); }\
	template <class Manip>\
	inline NAME##_cus_value_list<Manip> \
	NAME::value_list(const char* d, Manip m, mysqlpp::sql_cmp_type /*sc*/) const\
			{ sql_compare_type_def_##CMP(NAME, value, NUM); }\
	template <class Manip>\
	inline NAME##_cus_field_list<Manip> \
	NAME::field_list(const char* d, Manip m, mysqlpp::sql_cmp_type /*sc*/) const\
			{ sql_compare_type_def_##CMP(NAME, field, NUM); }\
	template <class Manip>\
	inline NAME##_cus_equal_list<Manip> \
	NAME::equal_list(const char* d, const char* c, Manip m, mysqlpp::sql_cmp_type /*sc*/) const\
			{ sql_compare_type_defe_##CMP(NAME, equal, NUM); }\
	template <mysqlpp::sql_dummy_type dummy>\
	void populate_##NAME(NAME *s, const mysqlpp::Row &row)\
	{\
		mysqlpp::NoExceptions ignore_schema_mismatches(row);\
    s->I1 = row[N1].conv(T1());\
    s->I2 = row[N2].conv(T2());\
    s->I3 = row[N3].conv(T3());\
    s->I4 = row[N4].conv(T4());\
    s->I5 = row[N5].conv(T5());\
    s->I6 = row[N6].conv(T6());\
    s->I7 = row[N7].conv(T7());\
    s->I8 = row[N8].conv(T8());\
    s->I9 = row[N9].conv(T9());\
    s->I10 = row[N10].conv(T10());\
    s->I11 = row[N11].conv(T11());\
    s->I12 = row[N12].conv(T12());\
    s->I13 = row[N13].conv(T13());\
    s->I14 = row[N14].conv(T14());\
    s->I15 = row[N15].conv(T15());\
    s->I16 = row[N16].conv(T16());\
    s->I17 = row[N17].conv(T17());\
    s->I18 = row[N18].conv(T18());\
    s->I19 = row[N19].conv(T19());\
	}\
	inline NAME::NAME(const mysqlpp::Row& row) :\
	table_override_(0)\
			{ populate_##NAME<mysqlpp::sql_dummy>(this, row); }\
	inline void NAME::set(const mysqlpp::Row& row)\
	{\
		table_override_ = 0;\
		populate_##NAME<mysqlpp::sql_dummy>(this, row);\
	}\
	sql_COMPARE__##CMP(NAME, I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, I17, I18, I19, 0, 0, 0, 0, 0, 0 )

#define sql_create_19(NAME, CMP, CONTR, T1, I1, T2, I2, T3, I3, T4, I4, T5, I5, T6, I6, T7, I7, T8, I8, T9, I9, T10, I10, T11, I11, T12, I12, T13, I13, T14, I14, T15, I15, T16, I16, T17, I17, T18, I18, T19, I19) \
		sql_create_complete_19(NAME, CMP, CONTR, T1, I1, #I1, T2, I2, #I2, T3, I3, #I3, T4, I4, #I4, T5, I5, #I5, T6, I6, #I6, T7, I7, #I7, T8, I8, #I8, T9, I9, #I9, T10, I10, #I10, T11, I11, #I11, T12, I12, #I12, T13, I13, #I13, T14, I14, #I14, T15, I15, #I15, T16, I16, #I16, T17, I17, #I17, T18, I18, #I18, T19, I19, #I19) \

// ---------------------------------------------------
//                  End Create 19
// ---------------------------------------------------

// ---------------------------------------------------
//                  Begin Create 20
// ---------------------------------------------------
#define sql_create_complete_20(NAME, CMP, CONTR, T1, I1, N1, T2, I2, N2, T3, I3, N3, T4, I4, N4, T5, I5, N5, T6, I6, N6, T7, I7, N7, T8, I8, N8, T9, I9, N9, T10, I10, N10, T11, I11, N11, T12, I12, N12, T13, I13, N13, T14, I14, N14, T15, I15, N15, T16, I16, N16, T17, I17, N17, T18, I18, N18, T19, I19, N19, T20, I20, N20) \
	struct NAME; \
	enum NAME##_enum { \
    NAME##_##I1,\
    NAME##_##I2,\
    NAME##_##I3,\
    NAME##_##I4,\
    NAME##_##I5,\
    NAME##_##I6,\
    NAME##_##I7,\
    NAME##_##I8,\
    NAME##_##I9,\
    NAME##_##I10,\
    NAME##_##I11,\
    NAME##_##I12,\
    NAME##_##I13,\
    NAME##_##I14,\
    NAME##_##I15,\
    NAME##_##I16,\
    NAME##_##I17,\
    NAME##_##I18,\
    NAME##_##I19,\
    NAME##_##I20 \
	,NAME##_NULL \
	}; \
	template <class Manip>\
	class NAME##_value_list { \
	public: \
	const NAME* obj;\
	const char* delim;\
	Manip manip;\
	public: \
	NAME##_value_list (const NAME* o, const char* d, Manip m) :\
	obj(o), delim(d), manip(m) { } \
	};\
	template <class Manip>\
	class NAME##_##field_list {\
	public: \
	const NAME* obj; \
	const char* delim;\
	Manip manip;\
	public: \
	NAME##_field_list (const NAME* o, const char* d, Manip m) :\
	obj(o), delim(d), manip(m) { } \
	};\
	template <class Manip>\
	class NAME##_equal_list { \
	public: \
	const NAME* obj;\
	const char* delim;\
	const char* comp;\
	Manip manip;\
	public: \
	NAME##_equal_list (const NAME* o, const char* d, const char* c, Manip m) :\
	obj(o), delim(d), comp(c), manip(m) { }\
	};\
	template <class Manip>\
	class NAME##_cus_value_list {\
	public:\
	const NAME* obj;\
	std::vector<bool> *include;\
	bool del_vector;\
	const char* delim;\
	Manip manip;\
	public: \
	~NAME##_cus_value_list () {if (del_vector) delete include;} \
	NAME##_cus_value_list (const NAME* o, const char* d, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13, bool i14, bool i15, bool i16, bool i17, bool i18, bool i19, bool i20);\
	NAME##_cus_value_list (const NAME* o, const char* d, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13, NAME##_enum i14, NAME##_enum i15, NAME##_enum i16, NAME##_enum i17, NAME##_enum i18, NAME##_enum i19, NAME##_enum i20); \
	NAME##_cus_value_list (const NAME* o, const char* d, Manip m ,std::vector<bool>* i) :\
	obj(o), include(i), del_vector(false), delim(d), manip(m) { }\
	};\
	template <class Manip>\
	class NAME##_cus_field_list { \
	public:\
	const NAME* obj; \
	std::vector<bool> *include; \
	bool del_vector; \
	const char* delim;\
	Manip manip;\
	public: \
	~NAME##_cus_field_list () {if (del_vector) delete include;} \
	NAME##_cus_field_list (const NAME* o, const char* d, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13, bool i14, bool i15, bool i16, bool i17, bool i18, bool i19, bool i20); \
	NAME##_cus_field_list (const NAME* o, const char* d, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13, NAME##_enum i14, NAME##_enum i15, NAME##_enum i16, NAME##_enum i17, NAME##_enum i18, NAME##_enum i19, NAME##_enum i20); \
	NAME##_cus_field_list (const NAME* o, const char* d, Manip m, std::vector<bool> *i) :\
	obj(o), include(i), del_vector(false), delim(d), manip(m) { }\
	};\
	template <class Manip>\
	class NAME##_cus_equal_list {\
	public:\
	const NAME* obj;\
	std::vector<bool> *include;\
	bool del_vector;\
	const char* delim;\
	const char* comp;\
	Manip manip;\
	public:\
	~NAME##_##cus_equal_list () {if (del_vector) delete include;}\
	NAME##_##cus_equal_list (const NAME* o, const char* d, const char* c, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13, bool i14, bool i15, bool i16, bool i17, bool i18, bool i19, bool i20); \
	NAME##_##cus_equal_list (const NAME* o, const char* d, const char* c, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13, NAME##_enum i14, NAME##_enum i15, NAME##_enum i16, NAME##_enum i17, NAME##_enum i18, NAME##_enum i19, NAME##_enum i20); \
	NAME##_##cus_equal_list (const NAME* o, const char* d, const char* c, Manip m, std::vector<bool> *i) :\
	obj(o), include(i), del_vector(false), delim(d), comp(c), manip(m) { }\
	};\
	template <mysqlpp::sql_dummy_type dummy> int sql_compare_##NAME(const NAME&, const NAME&);\
	struct NAME {\
    T1 I1;\
    T2 I2;\
    T3 I3;\
    T4 I4;\
    T5 I5;\
    T6 I6;\
    T7 I7;\
    T8 I8;\
    T9 I9;\
    T10 I10;\
    T11 I11;\
    T12 I12;\
    T13 I13;\
    T14 I14;\
    T15 I15;\
    T16 I16;\
    T17 I17;\
    T18 I18;\
    T19 I19;\
    T20 I20; \
	NAME() : table_override_(0) { }\
	NAME(const mysqlpp::Row& row);\
	void set(const mysqlpp::Row &row);\
	sql_compare_define_##CMP(NAME, T1, I1, T2, I2, T3, I3, T4, I4, T5, I5, T6, I6, T7, I7, T8, I8, T9, I9, T10, I10, T11, I11, T12, I12, T13, I13, T14, I14, T15, I15, T16, I16, T17, I17, T18, I18, T19, I19, T20, I20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)\
	sql_construct_define_##CONTR(NAME, T1, I1, T2, I2, T3, I3, T4, I4, T5, I5, T6, I6, T7, I7, T8, I8, T9, I9, T10, I10, T11, I11, T12, I12, T13, I13, T14, I14, T15, I15, T16, I16, T17, I17, T18, I18, T19, I19, T20, I20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)\
	static const char* names[];\
	static void table(const char* t) { table_ = t; }\
	const char* table() const\
			{ return table_override_ ? table_override_ : NAME::table_; }\
	void instance_table(const char* t) { table_override_ = t; }\
	NAME##_value_list<mysqlpp::quote_type0> value_list() const {\
		return value_list(",", mysqlpp::quote);}\
	NAME##_value_list<mysqlpp::quote_type0> value_list(const char* d) const {\
		return value_list(d, mysqlpp::quote);}\
	template <class Manip>\
	NAME##_value_list<Manip> value_list(const char* d, Manip m) const;\
	NAME##_field_list<mysqlpp::do_nothing_type0> field_list() const {\
		return field_list(",", mysqlpp::do_nothing);}\
	NAME##_field_list<mysqlpp::do_nothing_type0> field_list(const char* d) const {\
		return field_list(d, mysqlpp::do_nothing);}\
	template <class Manip>\
	NAME##_field_list<Manip> field_list(const char* d, Manip m) const;\
	NAME##_equal_list<mysqlpp::quote_type0> equal_list(const char* d = ",",\
			const char* c = " = ") const\
			{ return equal_list(d, c, mysqlpp::quote); }\
	template <class Manip>\
	NAME##_equal_list<Manip> equal_list(const char* d, const char* c, Manip m) const;\
	/* cus_data */\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false, bool i15 = false, bool i16 = false, bool i17 = false, bool i18 = false, bool i19 = false, bool i20 = false) const\
			{ return value_list(",", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL, NAME##_enum i15 = NAME##_NULL, NAME##_enum i16 = NAME##_NULL, NAME##_enum i17 = NAME##_NULL, NAME##_enum i18 = NAME##_NULL, NAME##_enum i19 = NAME##_NULL, NAME##_enum i20 = NAME##_NULL) const\
			{ return value_list(",", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(std::vector<bool> *i) const\
			{ return value_list(",", mysqlpp::quote, i); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(mysqlpp::sql_cmp_type sc) const\
			{ return value_list(",", mysqlpp::quote, sc); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(const char* d, bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false, bool i15 = false, bool i16 = false, bool i17 = false, bool i18 = false, bool i19 = false, bool i20 = false) const\
			{ return value_list(d, mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(const char* d, NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL, NAME##_enum i15 = NAME##_NULL, NAME##_enum i16 = NAME##_NULL, NAME##_enum i17 = NAME##_NULL, NAME##_enum i18 = NAME##_NULL, NAME##_enum i19 = NAME##_NULL, NAME##_enum i20 = NAME##_NULL) const\
			{ return value_list(d, mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(const char* d,\
			std::vector<bool> *i) const\
			{ return value_list(d, mysqlpp::quote, i); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(const char* d,\
			mysqlpp::sql_cmp_type sc) const\
			{ return value_list(d, mysqlpp::quote, sc); }\
	template <class Manip>\
	NAME##_cus_value_list<Manip> value_list(const char* d, Manip m,\
			bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false, bool i15 = false, bool i16 = false, bool i17 = false, bool i18 = false, bool i19 = false, bool i20 = false) const;\
	template <class Manip>\
	NAME##_cus_value_list<Manip> value_list(const char* d, Manip m,\
			NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL, NAME##_enum i15 = NAME##_NULL, NAME##_enum i16 = NAME##_NULL, NAME##_enum i17 = NAME##_NULL, NAME##_enum i18 = NAME##_NULL, NAME##_enum i19 = NAME##_NULL, NAME##_enum i20 = NAME##_NULL) const;\
	template <class Manip>\
	NAME##_cus_value_list<Manip> value_list(const char* d, Manip m,\
			std::vector<bool>* i) const;\
	template <class Manip>\
	NAME##_cus_value_list<Manip> value_list(const char* d, Manip m, \
			mysqlpp::sql_cmp_type sc) const;\
	/* cus field */\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false, bool i15 = false, bool i16 = false, bool i17 = false, bool i18 = false, bool i19 = false, bool i20 = false) const \
			{ return field_list(",", mysqlpp::do_nothing, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL, NAME##_enum i15 = NAME##_NULL, NAME##_enum i16 = NAME##_NULL, NAME##_enum i17 = NAME##_NULL, NAME##_enum i18 = NAME##_NULL, NAME##_enum i19 = NAME##_NULL, NAME##_enum i20 = NAME##_NULL) const\
			{ return field_list(",", mysqlpp::do_nothing, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(std::vector<bool> *i) const\
			{ return field_list(",", mysqlpp::do_nothing, i); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(mysqlpp::sql_cmp_type sc) const\
			{ return field_list(",", mysqlpp::do_nothing, sc); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(const char* d,\
			bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false, bool i15 = false, bool i16 = false, bool i17 = false, bool i18 = false, bool i19 = false, bool i20 = false) const\
			{ return field_list(d, mysqlpp::do_nothing, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(const char* d,\
			NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL, NAME##_enum i15 = NAME##_NULL, NAME##_enum i16 = NAME##_NULL, NAME##_enum i17 = NAME##_NULL, NAME##_enum i18 = NAME##_NULL, NAME##_enum i19 = NAME##_NULL, NAME##_enum i20 = NAME##_NULL) const\
			{ return field_list(d, mysqlpp::do_nothing, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(const char* d,\
			std::vector<bool>* i) const\
			{ return field_list(d, mysqlpp::do_nothing, i); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(const char* d,\
			mysqlpp::sql_cmp_type sc) const\
			{ return field_list(d, mysqlpp::do_nothing, sc); }\
	template <class Manip>\
	NAME##_cus_field_list<Manip> field_list(const char* d, Manip m,\
			bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false, bool i15 = false, bool i16 = false, bool i17 = false, bool i18 = false, bool i19 = false, bool i20 = false) const;\
	template <class Manip>\
	NAME##_cus_field_list<Manip> field_list(const char* d, Manip m,\
			NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL, NAME##_enum i15 = NAME##_NULL, NAME##_enum i16 = NAME##_NULL, NAME##_enum i17 = NAME##_NULL, NAME##_enum i18 = NAME##_NULL, NAME##_enum i19 = NAME##_NULL, NAME##_enum i20 = NAME##_NULL) const;\
	template <class Manip>\
	NAME##_cus_field_list<Manip> field_list(const char* d, Manip m,\
			std::vector<bool> *i) const;\
	template <class Manip>\
	NAME##_cus_field_list<Manip> field_list(const char* d, Manip m,\
			mysqlpp::sql_cmp_type sc) const;\
	/* cus equal */\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false, bool i15 = false, bool i16 = false, bool i17 = false, bool i18 = false, bool i19 = false, bool i20 = false) const\
			{ return equal_list(",", " = ", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL, NAME##_enum i15 = NAME##_NULL, NAME##_enum i16 = NAME##_NULL, NAME##_enum i17 = NAME##_NULL, NAME##_enum i18 = NAME##_NULL, NAME##_enum i19 = NAME##_NULL, NAME##_enum i20 = NAME##_NULL) const\
			{ return equal_list(",", " = ", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(std::vector<bool>* i) const\
			{ return equal_list(",", " = ", mysqlpp::quote, i); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(mysqlpp::sql_cmp_type sc) const\
			{ return equal_list(",", " = ", mysqlpp::quote, sc); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false, bool i15 = false, bool i16 = false, bool i17 = false, bool i18 = false, bool i19 = false, bool i20 = false) const\
			{ return equal_list(d, " = ", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL, NAME##_enum i15 = NAME##_NULL, NAME##_enum i16 = NAME##_NULL, NAME##_enum i17 = NAME##_NULL, NAME##_enum i18 = NAME##_NULL, NAME##_enum i19 = NAME##_NULL, NAME##_enum i20 = NAME##_NULL) const\
			{ return equal_list(d, " = ", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d,\
			std::vector<bool> *i) const\
			{ return equal_list(d, " = ", mysqlpp::quote, i); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d,\
			mysqlpp::sql_cmp_type sc) const\
			{ return equal_list(d, " = ", mysqlpp::quote, sc); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, const char* c,\
			bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false, bool i15 = false, bool i16 = false, bool i17 = false, bool i18 = false, bool i19 = false, bool i20 = false) const\
			{ return equal_list(d, c, mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, const char* c,\
			NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL, NAME##_enum i15 = NAME##_NULL, NAME##_enum i16 = NAME##_NULL, NAME##_enum i17 = NAME##_NULL, NAME##_enum i18 = NAME##_NULL, NAME##_enum i19 = NAME##_NULL, NAME##_enum i20 = NAME##_NULL) const\
			{ return equal_list(d, c, mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, const char* c,\
			std::vector<bool> *i) const\
			{ return equal_list(d, c, mysqlpp::quote, i); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, const char* c,\
			mysqlpp::sql_cmp_type sc) const\
			{ return equal_list(d, c, mysqlpp::quote, sc); }\
	template <class Manip>\
	NAME##_cus_equal_list<Manip> equal_list(const char* d, const char* c, Manip m, \
						bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false, bool i15 = false, bool i16 = false, bool i17 = false, bool i18 = false, bool i19 = false, bool i20 = false) const;\
	template <class Manip>\
	NAME##_cus_equal_list<Manip> equal_list(const char* d, const char* c, Manip m, \
						NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL, NAME##_enum i15 = NAME##_NULL, NAME##_enum i16 = NAME##_NULL, NAME##_enum i17 = NAME##_NULL, NAME##_enum i18 = NAME##_NULL, NAME##_enum i19 = NAME##_NULL, NAME##_enum i20 = NAME##_NULL) const;\
	template <class Manip>\
	NAME##_cus_equal_list<Manip> equal_list(const char* d, const char* c, Manip m, \
						std::vector<bool> *i) const;\
	template <class Manip>\
	NAME##_cus_equal_list<Manip> equal_list(const char* d, const char* c, Manip m, \
						mysqlpp::sql_cmp_type sc) const;\
	private:\
	static const char* table_;\
	const char* table_override_;\
	};\
	MYSQLPP_SSQLS_CONDITIONAL_STATICS(\
		const char* NAME::names[] = {\
			    N1 ,\
    N2 ,\
    N3 ,\
    N4 ,\
    N5 ,\
    N6 ,\
    N7 ,\
    N8 ,\
    N9 ,\
    N10 ,\
    N11 ,\
    N12 ,\
    N13 ,\
    N14 ,\
    N15 ,\
    N16 ,\
    N17 ,\
    N18 ,\
    N19 ,\
    N20 \
		};\
		const char* NAME::table_ = #NAME;\
	)\
	template <class Manip>\
	NAME##_cus_value_list<Manip>::NAME##_cus_value_list\
			(const NAME* o, const char* d, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13, bool i14, bool i15, bool i16, bool i17, bool i18, bool i19, bool i20)\
	{\
		delim = d;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(20, false);\
    if (i1) (*include)[0]=true;\
    if (i2) (*include)[1]=true;\
    if (i3) (*include)[2]=true;\
    if (i4) (*include)[3]=true;\
    if (i5) (*include)[4]=true;\
    if (i6) (*include)[5]=true;\
    if (i7) (*include)[6]=true;\
    if (i8) (*include)[7]=true;\
    if (i9) (*include)[8]=true;\
    if (i10) (*include)[9]=true;\
    if (i11) (*include)[10]=true;\
    if (i12) (*include)[11]=true;\
    if (i13) (*include)[12]=true;\
    if (i14) (*include)[13]=true;\
    if (i15) (*include)[14]=true;\
    if (i16) (*include)[15]=true;\
    if (i17) (*include)[16]=true;\
    if (i18) (*include)[17]=true;\
    if (i19) (*include)[18]=true;\
    if (i20) (*include)[19]=true;\
	}\
	template <class Manip>\
	NAME##_cus_value_list<Manip>::NAME##_cus_value_list\
			(const NAME* o, const char* d, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13, NAME##_enum i14, NAME##_enum i15, NAME##_enum i16, NAME##_enum i17, NAME##_enum i18, NAME##_enum i19, NAME##_enum i20)\
	{\
		delim = d;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(20, false);\
    if (i1 == NAME##_NULL) return;\
    (*include)[i1]=true;\
    if (i2 == NAME##_NULL) return;\
    (*include)[i2]=true;\
    if (i3 == NAME##_NULL) return;\
    (*include)[i3]=true;\
    if (i4 == NAME##_NULL) return;\
    (*include)[i4]=true;\
    if (i5 == NAME##_NULL) return;\
    (*include)[i5]=true;\
    if (i6 == NAME##_NULL) return;\
    (*include)[i6]=true;\
    if (i7 == NAME##_NULL) return;\
    (*include)[i7]=true;\
    if (i8 == NAME##_NULL) return;\
    (*include)[i8]=true;\
    if (i9 == NAME##_NULL) return;\
    (*include)[i9]=true;\
    if (i10 == NAME##_NULL) return;\
    (*include)[i10]=true;\
    if (i11 == NAME##_NULL) return;\
    (*include)[i11]=true;\
    if (i12 == NAME##_NULL) return;\
    (*include)[i12]=true;\
    if (i13 == NAME##_NULL) return;\
    (*include)[i13]=true;\
    if (i14 == NAME##_NULL) return;\
    (*include)[i14]=true;\
    if (i15 == NAME##_NULL) return;\
    (*include)[i15]=true;\
    if (i16 == NAME##_NULL) return;\
    (*include)[i16]=true;\
    if (i17 == NAME##_NULL) return;\
    (*include)[i17]=true;\
    if (i18 == NAME##_NULL) return;\
    (*include)[i18]=true;\
    if (i19 == NAME##_NULL) return;\
    (*include)[i19]=true;\
    if (i20 == NAME##_NULL) return;\
    (*include)[i20]=true;\
	}\
	template <class Manip>\
	NAME##_cus_field_list<Manip>::NAME##_cus_field_list\
			(const NAME* o, const char* d, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13, bool i14, bool i15, bool i16, bool i17, bool i18, bool i19, bool i20)\
	{\
		delim = d;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(20, false);\
    if (i1) (*include)[0]=true;\
    if (i2) (*include)[1]=true;\
    if (i3) (*include)[2]=true;\
    if (i4) (*include)[3]=true;\
    if (i5) (*include)[4]=true;\
    if (i6) (*include)[5]=true;\
    if (i7) (*include)[6]=true;\
    if (i8) (*include)[7]=true;\
    if (i9) (*include)[8]=true;\
    if (i10) (*include)[9]=true;\
    if (i11) (*include)[10]=true;\
    if (i12) (*include)[11]=true;\
    if (i13) (*include)[12]=true;\
    if (i14) (*include)[13]=true;\
    if (i15) (*include)[14]=true;\
    if (i16) (*include)[15]=true;\
    if (i17) (*include)[16]=true;\
    if (i18) (*include)[17]=true;\
    if (i19) (*include)[18]=true;\
    if (i20) (*include)[19]=true;\
	}\
	template <class Manip>\
	NAME##_cus_field_list<Manip>::NAME##_cus_field_list\
			(const NAME* o, const char* d, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13, NAME##_enum i14, NAME##_enum i15, NAME##_enum i16, NAME##_enum i17, NAME##_enum i18, NAME##_enum i19, NAME##_enum i20)\
	{\
		delim = d;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(20, false);\
    if (i1 == NAME##_NULL) return;\
    (*include)[i1]=true;\
    if (i2 == NAME##_NULL) return;\
    (*include)[i2]=true;\
    if (i3 == NAME##_NULL) return;\
    (*include)[i3]=true;\
    if (i4 == NAME##_NULL) return;\
    (*include)[i4]=true;\
    if (i5 == NAME##_NULL) return;\
    (*include)[i5]=true;\
    if (i6 == NAME##_NULL) return;\
    (*include)[i6]=true;\
    if (i7 == NAME##_NULL) return;\
    (*include)[i7]=true;\
    if (i8 == NAME##_NULL) return;\
    (*include)[i8]=true;\
    if (i9 == NAME##_NULL) return;\
    (*include)[i9]=true;\
    if (i10 == NAME##_NULL) return;\
    (*include)[i10]=true;\
    if (i11 == NAME##_NULL) return;\
    (*include)[i11]=true;\
    if (i12 == NAME##_NULL) return;\
    (*include)[i12]=true;\
    if (i13 == NAME##_NULL) return;\
    (*include)[i13]=true;\
    if (i14 == NAME##_NULL) return;\
    (*include)[i14]=true;\
    if (i15 == NAME##_NULL) return;\
    (*include)[i15]=true;\
    if (i16 == NAME##_NULL) return;\
    (*include)[i16]=true;\
    if (i17 == NAME##_NULL) return;\
    (*include)[i17]=true;\
    if (i18 == NAME##_NULL) return;\
    (*include)[i18]=true;\
    if (i19 == NAME##_NULL) return;\
    (*include)[i19]=true;\
    if (i20 == NAME##_NULL) return;\
    (*include)[i20]=true;\
	}\
	template <class Manip>\
	NAME##_cus_equal_list<Manip>::NAME##_cus_equal_list\
			(const NAME* o, const char* d, const char* c, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13, bool i14, bool i15, bool i16, bool i17, bool i18, bool i19, bool i20)\
	{\
		delim = d;\
		comp = c;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(20, false);\
    if (i1) (*include)[0]=true;\
    if (i2) (*include)[1]=true;\
    if (i3) (*include)[2]=true;\
    if (i4) (*include)[3]=true;\
    if (i5) (*include)[4]=true;\
    if (i6) (*include)[5]=true;\
    if (i7) (*include)[6]=true;\
    if (i8) (*include)[7]=true;\
    if (i9) (*include)[8]=true;\
    if (i10) (*include)[9]=true;\
    if (i11) (*include)[10]=true;\
    if (i12) (*include)[11]=true;\
    if (i13) (*include)[12]=true;\
    if (i14) (*include)[13]=true;\
    if (i15) (*include)[14]=true;\
    if (i16) (*include)[15]=true;\
    if (i17) (*include)[16]=true;\
    if (i18) (*include)[17]=true;\
    if (i19) (*include)[18]=true;\
    if (i20) (*include)[19]=true;\
	}\
	template <class Manip>\
	NAME##_cus_equal_list<Manip>::NAME##_cus_equal_list\
			(const NAME* o, const char* d, const char* c, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13, NAME##_enum i14, NAME##_enum i15, NAME##_enum i16, NAME##_enum i17, NAME##_enum i18, NAME##_enum i19, NAME##_enum i20)\
	{\
		delim = d;\
		comp = c;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(20, false);\
    if (i1 == NAME##_NULL) return;\
    (*include)[i1]=true;\
    if (i2 == NAME##_NULL) return;\
    (*include)[i2]=true;\
    if (i3 == NAME##_NULL) return;\
    (*include)[i3]=true;\
    if (i4 == NAME##_NULL) return;\
    (*include)[i4]=true;\
    if (i5 == NAME##_NULL) return;\
    (*include)[i5]=true;\
    if (i6 == NAME##_NULL) return;\
    (*include)[i6]=true;\
    if (i7 == NAME##_NULL) return;\
    (*include)[i7]=true;\
    if (i8 == NAME##_NULL) return;\
    (*include)[i8]=true;\
    if (i9 == NAME##_NULL) return;\
    (*include)[i9]=true;\
    if (i10 == NAME##_NULL) return;\
    (*include)[i10]=true;\
    if (i11 == NAME##_NULL) return;\
    (*include)[i11]=true;\
    if (i12 == NAME##_NULL) return;\
    (*include)[i12]=true;\
    if (i13 == NAME##_NULL) return;\
    (*include)[i13]=true;\
    if (i14 == NAME##_NULL) return;\
    (*include)[i14]=true;\
    if (i15 == NAME##_NULL) return;\
    (*include)[i15]=true;\
    if (i16 == NAME##_NULL) return;\
    (*include)[i16]=true;\
    if (i17 == NAME##_NULL) return;\
    (*include)[i17]=true;\
    if (i18 == NAME##_NULL) return;\
    (*include)[i18]=true;\
    if (i19 == NAME##_NULL) return;\
    (*include)[i19]=true;\
    if (i20 == NAME##_NULL) return;\
    (*include)[i20]=true;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_value_list<Manip>& obj)\
	{\
    s << obj.manip << obj.obj->I1 << obj.delim;\
    s << obj.manip << obj.obj->I2 << obj.delim;\
    s << obj.manip << obj.obj->I3 << obj.delim;\
    s << obj.manip << obj.obj->I4 << obj.delim;\
    s << obj.manip << obj.obj->I5 << obj.delim;\
    s << obj.manip << obj.obj->I6 << obj.delim;\
    s << obj.manip << obj.obj->I7 << obj.delim;\
    s << obj.manip << obj.obj->I8 << obj.delim;\
    s << obj.manip << obj.obj->I9 << obj.delim;\
    s << obj.manip << obj.obj->I10 << obj.delim;\
    s << obj.manip << obj.obj->I11 << obj.delim;\
    s << obj.manip << obj.obj->I12 << obj.delim;\
    s << obj.manip << obj.obj->I13 << obj.delim;\
    s << obj.manip << obj.obj->I14 << obj.delim;\
    s << obj.manip << obj.obj->I15 << obj.delim;\
    s << obj.manip << obj.obj->I16 << obj.delim;\
    s << obj.manip << obj.obj->I17 << obj.delim;\
    s << obj.manip << obj.obj->I18 << obj.delim;\
    s << obj.manip << obj.obj->I19 << obj.delim;\
    s << obj.manip << obj.obj->I20;\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_field_list<Manip>& obj)\
	{\
    s << obj.manip << '`' << obj.obj->names[0] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[1] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[2] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[3] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[4] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[5] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[6] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[7] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[8] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[9] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[10] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[11] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[12] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[13] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[14] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[15] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[16] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[17] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[18] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[19] << '`';\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_equal_list<Manip>& obj)\
	{\
    s << '`' << obj.obj->names[0] << '`' << obj.comp << obj.manip << obj.obj->I1 << obj.delim;\
    s << '`' << obj.obj->names[1] << '`' << obj.comp << obj.manip << obj.obj->I2 << obj.delim;\
    s << '`' << obj.obj->names[2] << '`' << obj.comp << obj.manip << obj.obj->I3 << obj.delim;\
    s << '`' << obj.obj->names[3] << '`' << obj.comp << obj.manip << obj.obj->I4 << obj.delim;\
    s << '`' << obj.obj->names[4] << '`' << obj.comp << obj.manip << obj.obj->I5 << obj.delim;\
    s << '`' << obj.obj->names[5] << '`' << obj.comp << obj.manip << obj.obj->I6 << obj.delim;\
    s << '`' << obj.obj->names[6] << '`' << obj.comp << obj.manip << obj.obj->I7 << obj.delim;\
    s << '`' << obj.obj->names[7] << '`' << obj.comp << obj.manip << obj.obj->I8 << obj.delim;\
    s << '`' << obj.obj->names[8] << '`' << obj.comp << obj.manip << obj.obj->I9 << obj.delim;\
    s << '`' << obj.obj->names[9] << '`' << obj.comp << obj.manip << obj.obj->I10 << obj.delim;\
    s << '`' << obj.obj->names[10] << '`' << obj.comp << obj.manip << obj.obj->I11 << obj.delim;\
    s << '`' << obj.obj->names[11] << '`' << obj.comp << obj.manip << obj.obj->I12 << obj.delim;\
    s << '`' << obj.obj->names[12] << '`' << obj.comp << obj.manip << obj.obj->I13 << obj.delim;\
    s << '`' << obj.obj->names[13] << '`' << obj.comp << obj.manip << obj.obj->I14 << obj.delim;\
    s << '`' << obj.obj->names[14] << '`' << obj.comp << obj.manip << obj.obj->I15 << obj.delim;\
    s << '`' << obj.obj->names[15] << '`' << obj.comp << obj.manip << obj.obj->I16 << obj.delim;\
    s << '`' << obj.obj->names[16] << '`' << obj.comp << obj.manip << obj.obj->I17 << obj.delim;\
    s << '`' << obj.obj->names[17] << '`' << obj.comp << obj.manip << obj.obj->I18 << obj.delim;\
    s << '`' << obj.obj->names[18] << '`' << obj.comp << obj.manip << obj.obj->I19 << obj.delim;\
    s << '`' << obj.obj->names[19] << '`' << obj.comp << obj.manip << obj.obj->I20;\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_cus_value_list<Manip>& obj)\
	{\
		bool before = false;\
    if ((*obj.include)[0]) { \
      s << obj.manip << obj.obj->I1;\
      before = true; \
     } \
    if ((*obj.include)[1]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I2;\
      before = true; \
     } \
    if ((*obj.include)[2]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I3;\
      before = true; \
     } \
    if ((*obj.include)[3]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I4;\
      before = true; \
     } \
    if ((*obj.include)[4]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I5;\
      before = true; \
     } \
    if ((*obj.include)[5]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I6;\
      before = true; \
     } \
    if ((*obj.include)[6]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I7;\
      before = true; \
     } \
    if ((*obj.include)[7]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I8;\
      before = true; \
     } \
    if ((*obj.include)[8]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I9;\
      before = true; \
     } \
    if ((*obj.include)[9]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I10;\
      before = true; \
     } \
    if ((*obj.include)[10]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I11;\
      before = true; \
     } \
    if ((*obj.include)[11]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I12;\
      before = true; \
     } \
    if ((*obj.include)[12]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I13;\
      before = true; \
     } \
    if ((*obj.include)[13]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I14;\
      before = true; \
     } \
    if ((*obj.include)[14]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I15;\
      before = true; \
     } \
    if ((*obj.include)[15]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I16;\
      before = true; \
     } \
    if ((*obj.include)[16]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I17;\
      before = true; \
     } \
    if ((*obj.include)[17]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I18;\
      before = true; \
     } \
    if ((*obj.include)[18]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I19;\
      before = true; \
     } \
    if ((*obj.include)[19]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I20;\
     } \
        (void)before;\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_cus_field_list<Manip>& obj)\
	{\
		bool before = false;\
    if ((*obj.include)[0]) { \
      s << obj.manip << '`' << obj.obj->names[0] << '`';\
      before = true; \
     } \
    if ((*obj.include)[1]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[1] << '`';\
      before = true; \
     } \
    if ((*obj.include)[2]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[2] << '`';\
      before = true; \
     } \
    if ((*obj.include)[3]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[3] << '`';\
      before = true; \
     } \
    if ((*obj.include)[4]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[4] << '`';\
      before = true; \
     } \
    if ((*obj.include)[5]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[5] << '`';\
      before = true; \
     } \
    if ((*obj.include)[6]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[6] << '`';\
      before = true; \
     } \
    if ((*obj.include)[7]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[7] << '`';\
      before = true; \
     } \
    if ((*obj.include)[8]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[8] << '`';\
      before = true; \
     } \
    if ((*obj.include)[9]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[9] << '`';\
      before = true; \
     } \
    if ((*obj.include)[10]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[10] << '`';\
      before = true; \
     } \
    if ((*obj.include)[11]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[11] << '`';\
      before = true; \
     } \
    if ((*obj.include)[12]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[12] << '`';\
      before = true; \
     } \
    if ((*obj.include)[13]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[13] << '`';\
      before = true; \
     } \
    if ((*obj.include)[14]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[14] << '`';\
      before = true; \
     } \
    if ((*obj.include)[15]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[15] << '`';\
      before = true; \
     } \
    if ((*obj.include)[16]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[16] << '`';\
      before = true; \
     } \
    if ((*obj.include)[17]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[17] << '`';\
      before = true; \
     } \
    if ((*obj.include)[18]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[18] << '`';\
      before = true; \
     } \
    if ((*obj.include)[19]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[19] << '`';\
     } \
        (void)before;\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_cus_equal_list<Manip>& obj)\
	{\
		bool before = false;\
    if ((*obj.include)[0]) { \
      s << '`' << obj.obj->names[0] << '`' << obj.comp << obj.manip << obj.obj->I1;\
      before = true; \
     } \
    if ((*obj.include)[1]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[1] << '`' << obj.comp << obj.manip << obj.obj->I2;\
      before = true; \
     } \
    if ((*obj.include)[2]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[2] << '`' << obj.comp << obj.manip << obj.obj->I3;\
      before = true; \
     } \
    if ((*obj.include)[3]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[3] << '`' << obj.comp << obj.manip << obj.obj->I4;\
      before = true; \
     } \
    if ((*obj.include)[4]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[4] << '`' << obj.comp << obj.manip << obj.obj->I5;\
      before = true; \
     } \
    if ((*obj.include)[5]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[5] << '`' << obj.comp << obj.manip << obj.obj->I6;\
      before = true; \
     } \
    if ((*obj.include)[6]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[6] << '`' << obj.comp << obj.manip << obj.obj->I7;\
      before = true; \
     } \
    if ((*obj.include)[7]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[7] << '`' << obj.comp << obj.manip << obj.obj->I8;\
      before = true; \
     } \
    if ((*obj.include)[8]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[8] << '`' << obj.comp << obj.manip << obj.obj->I9;\
      before = true; \
     } \
    if ((*obj.include)[9]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[9] << '`' << obj.comp << obj.manip << obj.obj->I10;\
      before = true; \
     } \
    if ((*obj.include)[10]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[10] << '`' << obj.comp << obj.manip << obj.obj->I11;\
      before = true; \
     } \
    if ((*obj.include)[11]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[11] << '`' << obj.comp << obj.manip << obj.obj->I12;\
      before = true; \
     } \
    if ((*obj.include)[12]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[12] << '`' << obj.comp << obj.manip << obj.obj->I13;\
      before = true; \
     } \
    if ((*obj.include)[13]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[13] << '`' << obj.comp << obj.manip << obj.obj->I14;\
      before = true; \
     } \
    if ((*obj.include)[14]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[14] << '`' << obj.comp << obj.manip << obj.obj->I15;\
      before = true; \
     } \
    if ((*obj.include)[15]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[15] << '`' << obj.comp << obj.manip << obj.obj->I16;\
      before = true; \
     } \
    if ((*obj.include)[16]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[16] << '`' << obj.comp << obj.manip << obj.obj->I17;\
      before = true; \
     } \
    if ((*obj.include)[17]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[17] << '`' << obj.comp << obj.manip << obj.obj->I18;\
      before = true; \
     } \
    if ((*obj.include)[18]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[18] << '`' << obj.comp << obj.manip << obj.obj->I19;\
      before = true; \
     } \
    if ((*obj.include)[19]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[19] << '`' << obj.comp << obj.manip << obj.obj->I20;\
     } \
        (void)before;\
		return s;\
	}\
	template <class Manip>\
	inline NAME##_value_list<Manip> NAME::value_list(const char* d, Manip m) const\
			{ return NAME##_value_list<Manip> (this, d, m); } \
	template <class Manip>\
	inline NAME##_field_list<Manip> NAME::field_list(const char* d, Manip m) const\
			{ return NAME##_field_list<Manip> (this, d, m); } \
	template <class Manip>\
	inline NAME##_equal_list<Manip> NAME::equal_list(const char* d, const char* c, Manip m) const\
			{ return NAME##_equal_list<Manip> (this, d, c, m); } \
	template <class Manip>\
	inline NAME##_cus_value_list<Manip> NAME::value_list(const char* d, Manip m,\
			bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13, bool i14, bool i15, bool i16, bool i17, bool i18, bool i19, bool i20) const\
			{ return NAME##_cus_value_list<Manip> (this, d, m, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20); }\
	template <class Manip>\
	inline NAME##_cus_field_list<Manip> NAME::field_list(const char* d, Manip m,\
			bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13, bool i14, bool i15, bool i16, bool i17, bool i18, bool i19, bool i20) const\
			{ return NAME##_cus_field_list<Manip> (this, d, m, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20); }\
	template <class Manip>\
	inline NAME##_cus_equal_list<Manip> NAME::equal_list(const char* d, const char* c, Manip m,\
			bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13, bool i14, bool i15, bool i16, bool i17, bool i18, bool i19, bool i20) const\
			{ return NAME##_cus_equal_list<Manip> (this, d, c, m, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20); } \
	template <class Manip>\
	inline NAME##_cus_value_list<Manip> NAME::value_list(const char* d, Manip m,\
			NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13, NAME##_enum i14, NAME##_enum i15, NAME##_enum i16, NAME##_enum i17, NAME##_enum i18, NAME##_enum i19, NAME##_enum i20) const\
			{ return NAME##_cus_value_list<Manip> (this, d, m, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20); } \
	template <class Manip>\
	inline NAME##_cus_field_list<Manip> NAME::field_list(const char* d, Manip m,\
			NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13, NAME##_enum i14, NAME##_enum i15, NAME##_enum i16, NAME##_enum i17, NAME##_enum i18, NAME##_enum i19, NAME##_enum i20) const\
			{ return NAME##_cus_field_list<Manip> (this, d, m, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20); } \
	template <class Manip>\
	inline NAME##_cus_equal_list<Manip> NAME::equal_list(const char* d, const char* c, Manip m, \
			NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13, NAME##_enum i14, NAME##_enum i15, NAME##_enum i16, NAME##_enum i17, NAME##_enum i18, NAME##_enum i19, NAME##_enum i20) const\
			{ return NAME##_cus_equal_list<Manip> (this, d, c, m, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20); } \
	template <class Manip>\
	inline NAME##_cus_value_list<Manip> NAME::value_list(const char* d, Manip m,\
			std::vector<bool> *i) const\
			{ return NAME##_cus_value_list<Manip> (this, d, m, i); }\
	template <class Manip>\
	inline NAME##_cus_field_list<Manip> NAME::field_list(const char* d, Manip m,\
			std::vector<bool> *i) const\
			{ return NAME##_cus_field_list<Manip> (this, d, m, i); }\
	template <class Manip>\
	inline NAME##_cus_equal_list<Manip> NAME::equal_list(const char* d, const char* c, Manip m,\
			std::vector<bool> *i) const\
			{ return NAME##_cus_equal_list<Manip> (this, d, c, m, i); }\
	template <class Manip>\
	inline NAME##_cus_value_list<Manip> \
	NAME::value_list(const char* d, Manip m, mysqlpp::sql_cmp_type /*sc*/) const\
			{ sql_compare_type_def_##CMP(NAME, value, NUM); }\
	template <class Manip>\
	inline NAME##_cus_field_list<Manip> \
	NAME::field_list(const char* d, Manip m, mysqlpp::sql_cmp_type /*sc*/) const\
			{ sql_compare_type_def_##CMP(NAME, field, NUM); }\
	template <class Manip>\
	inline NAME##_cus_equal_list<Manip> \
	NAME::equal_list(const char* d, const char* c, Manip m, mysqlpp::sql_cmp_type /*sc*/) const\
			{ sql_compare_type_defe_##CMP(NAME, equal, NUM); }\
	template <mysqlpp::sql_dummy_type dummy>\
	void populate_##NAME(NAME *s, const mysqlpp::Row &row)\
	{\
		mysqlpp::NoExceptions ignore_schema_mismatches(row);\
    s->I1 = row[N1].conv(T1());\
    s->I2 = row[N2].conv(T2());\
    s->I3 = row[N3].conv(T3());\
    s->I4 = row[N4].conv(T4());\
    s->I5 = row[N5].conv(T5());\
    s->I6 = row[N6].conv(T6());\
    s->I7 = row[N7].conv(T7());\
    s->I8 = row[N8].conv(T8());\
    s->I9 = row[N9].conv(T9());\
    s->I10 = row[N10].conv(T10());\
    s->I11 = row[N11].conv(T11());\
    s->I12 = row[N12].conv(T12());\
    s->I13 = row[N13].conv(T13());\
    s->I14 = row[N14].conv(T14());\
    s->I15 = row[N15].conv(T15());\
    s->I16 = row[N16].conv(T16());\
    s->I17 = row[N17].conv(T17());\
    s->I18 = row[N18].conv(T18());\
    s->I19 = row[N19].conv(T19());\
    s->I20 = row[N20].conv(T20());\
	}\
	inline NAME::NAME(const mysqlpp::Row& row) :\
	table_override_(0)\
			{ populate_##NAME<mysqlpp::sql_dummy>(this, row); }\
	inline void NAME::set(const mysqlpp::Row& row)\
	{\
		table_override_ = 0;\
		populate_##NAME<mysqlpp::sql_dummy>(this, row);\
	}\
	sql_COMPARE__##CMP(NAME, I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, I17, I18, I19, I20, 0, 0, 0, 0, 0 )

#define sql_create_20(NAME, CMP, CONTR, T1, I1, T2, I2, T3, I3, T4, I4, T5, I5, T6, I6, T7, I7, T8, I8, T9, I9, T10, I10, T11, I11, T12, I12, T13, I13, T14, I14, T15, I15, T16, I16, T17, I17, T18, I18, T19, I19, T20, I20) \
		sql_create_complete_20(NAME, CMP, CONTR, T1, I1, #I1, T2, I2, #I2, T3, I3, #I3, T4, I4, #I4, T5, I5, #I5, T6, I6, #I6, T7, I7, #I7, T8, I8, #I8, T9, I9, #I9, T10, I10, #I10, T11, I11, #I11, T12, I12, #I12, T13, I13, #I13, T14, I14, #I14, T15, I15, #I15, T16, I16, #I16, T17, I17, #I17, T18, I18, #I18, T19, I19, #I19, T20, I20, #I20) \

// ---------------------------------------------------
//                  End Create 20
// ---------------------------------------------------

// ---------------------------------------------------
//                  Begin Create 21
// ---------------------------------------------------
#define sql_create_complete_21(NAME, CMP, CONTR, T1, I1, N1, T2, I2, N2, T3, I3, N3, T4, I4, N4, T5, I5, N5, T6, I6, N6, T7, I7, N7, T8, I8, N8, T9, I9, N9, T10, I10, N10, T11, I11, N11, T12, I12, N12, T13, I13, N13, T14, I14, N14, T15, I15, N15, T16, I16, N16, T17, I17, N17, T18, I18, N18, T19, I19, N19, T20, I20, N20, T21, I21, N21) \
	struct NAME; \
	enum NAME##_enum { \
    NAME##_##I1,\
    NAME##_##I2,\
    NAME##_##I3,\
    NAME##_##I4,\
    NAME##_##I5,\
    NAME##_##I6,\
    NAME##_##I7,\
    NAME##_##I8,\
    NAME##_##I9,\
    NAME##_##I10,\
    NAME##_##I11,\
    NAME##_##I12,\
    NAME##_##I13,\
    NAME##_##I14,\
    NAME##_##I15,\
    NAME##_##I16,\
    NAME##_##I17,\
    NAME##_##I18,\
    NAME##_##I19,\
    NAME##_##I20,\
    NAME##_##I21 \
	,NAME##_NULL \
	}; \
	template <class Manip>\
	class NAME##_value_list { \
	public: \
	const NAME* obj;\
	const char* delim;\
	Manip manip;\
	public: \
	NAME##_value_list (const NAME* o, const char* d, Manip m) :\
	obj(o), delim(d), manip(m) { } \
	};\
	template <class Manip>\
	class NAME##_##field_list {\
	public: \
	const NAME* obj; \
	const char* delim;\
	Manip manip;\
	public: \
	NAME##_field_list (const NAME* o, const char* d, Manip m) :\
	obj(o), delim(d), manip(m) { } \
	};\
	template <class Manip>\
	class NAME##_equal_list { \
	public: \
	const NAME* obj;\
	const char* delim;\
	const char* comp;\
	Manip manip;\
	public: \
	NAME##_equal_list (const NAME* o, const char* d, const char* c, Manip m) :\
	obj(o), delim(d), comp(c), manip(m) { }\
	};\
	template <class Manip>\
	class NAME##_cus_value_list {\
	public:\
	const NAME* obj;\
	std::vector<bool> *include;\
	bool del_vector;\
	const char* delim;\
	Manip manip;\
	public: \
	~NAME##_cus_value_list () {if (del_vector) delete include;} \
	NAME##_cus_value_list (const NAME* o, const char* d, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13, bool i14, bool i15, bool i16, bool i17, bool i18, bool i19, bool i20, bool i21);\
	NAME##_cus_value_list (const NAME* o, const char* d, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13, NAME##_enum i14, NAME##_enum i15, NAME##_enum i16, NAME##_enum i17, NAME##_enum i18, NAME##_enum i19, NAME##_enum i20, NAME##_enum i21); \
	NAME##_cus_value_list (const NAME* o, const char* d, Manip m ,std::vector<bool>* i) :\
	obj(o), include(i), del_vector(false), delim(d), manip(m) { }\
	};\
	template <class Manip>\
	class NAME##_cus_field_list { \
	public:\
	const NAME* obj; \
	std::vector<bool> *include; \
	bool del_vector; \
	const char* delim;\
	Manip manip;\
	public: \
	~NAME##_cus_field_list () {if (del_vector) delete include;} \
	NAME##_cus_field_list (const NAME* o, const char* d, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13, bool i14, bool i15, bool i16, bool i17, bool i18, bool i19, bool i20, bool i21); \
	NAME##_cus_field_list (const NAME* o, const char* d, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13, NAME##_enum i14, NAME##_enum i15, NAME##_enum i16, NAME##_enum i17, NAME##_enum i18, NAME##_enum i19, NAME##_enum i20, NAME##_enum i21); \
	NAME##_cus_field_list (const NAME* o, const char* d, Manip m, std::vector<bool> *i) :\
	obj(o), include(i), del_vector(false), delim(d), manip(m) { }\
	};\
	template <class Manip>\
	class NAME##_cus_equal_list {\
	public:\
	const NAME* obj;\
	std::vector<bool> *include;\
	bool del_vector;\
	const char* delim;\
	const char* comp;\
	Manip manip;\
	public:\
	~NAME##_##cus_equal_list () {if (del_vector) delete include;}\
	NAME##_##cus_equal_list (const NAME* o, const char* d, const char* c, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13, bool i14, bool i15, bool i16, bool i17, bool i18, bool i19, bool i20, bool i21); \
	NAME##_##cus_equal_list (const NAME* o, const char* d, const char* c, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13, NAME##_enum i14, NAME##_enum i15, NAME##_enum i16, NAME##_enum i17, NAME##_enum i18, NAME##_enum i19, NAME##_enum i20, NAME##_enum i21); \
	NAME##_##cus_equal_list (const NAME* o, const char* d, const char* c, Manip m, std::vector<bool> *i) :\
	obj(o), include(i), del_vector(false), delim(d), comp(c), manip(m) { }\
	};\
	template <mysqlpp::sql_dummy_type dummy> int sql_compare_##NAME(const NAME&, const NAME&);\
	struct NAME {\
    T1 I1;\
    T2 I2;\
    T3 I3;\
    T4 I4;\
    T5 I5;\
    T6 I6;\
    T7 I7;\
    T8 I8;\
    T9 I9;\
    T10 I10;\
    T11 I11;\
    T12 I12;\
    T13 I13;\
    T14 I14;\
    T15 I15;\
    T16 I16;\
    T17 I17;\
    T18 I18;\
    T19 I19;\
    T20 I20;\
    T21 I21; \
	NAME() : table_override_(0) { }\
	NAME(const mysqlpp::Row& row);\
	void set(const mysqlpp::Row &row);\
	sql_compare_define_##CMP(NAME, T1, I1, T2, I2, T3, I3, T4, I4, T5, I5, T6, I6, T7, I7, T8, I8, T9, I9, T10, I10, T11, I11, T12, I12, T13, I13, T14, I14, T15, I15, T16, I16, T17, I17, T18, I18, T19, I19, T20, I20, T21, I21, 0, 0, 0, 0, 0, 0, 0, 0)\
	sql_construct_define_##CONTR(NAME, T1, I1, T2, I2, T3, I3, T4, I4, T5, I5, T6, I6, T7, I7, T8, I8, T9, I9, T10, I10, T11, I11, T12, I12, T13, I13, T14, I14, T15, I15, T16, I16, T17, I17, T18, I18, T19, I19, T20, I20, T21, I21, 0, 0, 0, 0, 0, 0, 0, 0)\
	static const char* names[];\
	static void table(const char* t) { table_ = t; }\
	const char* table() const\
			{ return table_override_ ? table_override_ : NAME::table_; }\
	void instance_table(const char* t) { table_override_ = t; }\
	NAME##_value_list<mysqlpp::quote_type0> value_list() const {\
		return value_list(",", mysqlpp::quote);}\
	NAME##_value_list<mysqlpp::quote_type0> value_list(const char* d) const {\
		return value_list(d, mysqlpp::quote);}\
	template <class Manip>\
	NAME##_value_list<Manip> value_list(const char* d, Manip m) const;\
	NAME##_field_list<mysqlpp::do_nothing_type0> field_list() const {\
		return field_list(",", mysqlpp::do_nothing);}\
	NAME##_field_list<mysqlpp::do_nothing_type0> field_list(const char* d) const {\
		return field_list(d, mysqlpp::do_nothing);}\
	template <class Manip>\
	NAME##_field_list<Manip> field_list(const char* d, Manip m) const;\
	NAME##_equal_list<mysqlpp::quote_type0> equal_list(const char* d = ",",\
			const char* c = " = ") const\
			{ return equal_list(d, c, mysqlpp::quote); }\
	template <class Manip>\
	NAME##_equal_list<Manip> equal_list(const char* d, const char* c, Manip m) const;\
	/* cus_data */\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false, bool i15 = false, bool i16 = false, bool i17 = false, bool i18 = false, bool i19 = false, bool i20 = false, bool i21 = false) const\
			{ return value_list(",", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20, i21); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL, NAME##_enum i15 = NAME##_NULL, NAME##_enum i16 = NAME##_NULL, NAME##_enum i17 = NAME##_NULL, NAME##_enum i18 = NAME##_NULL, NAME##_enum i19 = NAME##_NULL, NAME##_enum i20 = NAME##_NULL, NAME##_enum i21 = NAME##_NULL) const\
			{ return value_list(",", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20, i21); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(std::vector<bool> *i) const\
			{ return value_list(",", mysqlpp::quote, i); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(mysqlpp::sql_cmp_type sc) const\
			{ return value_list(",", mysqlpp::quote, sc); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(const char* d, bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false, bool i15 = false, bool i16 = false, bool i17 = false, bool i18 = false, bool i19 = false, bool i20 = false, bool i21 = false) const\
			{ return value_list(d, mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20, i21); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(const char* d, NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL, NAME##_enum i15 = NAME##_NULL, NAME##_enum i16 = NAME##_NULL, NAME##_enum i17 = NAME##_NULL, NAME##_enum i18 = NAME##_NULL, NAME##_enum i19 = NAME##_NULL, NAME##_enum i20 = NAME##_NULL, NAME##_enum i21 = NAME##_NULL) const\
			{ return value_list(d, mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20, i21); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(const char* d,\
			std::vector<bool> *i) const\
			{ return value_list(d, mysqlpp::quote, i); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(const char* d,\
			mysqlpp::sql_cmp_type sc) const\
			{ return value_list(d, mysqlpp::quote, sc); }\
	template <class Manip>\
	NAME##_cus_value_list<Manip> value_list(const char* d, Manip m,\
			bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false, bool i15 = false, bool i16 = false, bool i17 = false, bool i18 = false, bool i19 = false, bool i20 = false, bool i21 = false) const;\
	template <class Manip>\
	NAME##_cus_value_list<Manip> value_list(const char* d, Manip m,\
			NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL, NAME##_enum i15 = NAME##_NULL, NAME##_enum i16 = NAME##_NULL, NAME##_enum i17 = NAME##_NULL, NAME##_enum i18 = NAME##_NULL, NAME##_enum i19 = NAME##_NULL, NAME##_enum i20 = NAME##_NULL, NAME##_enum i21 = NAME##_NULL) const;\
	template <class Manip>\
	NAME##_cus_value_list<Manip> value_list(const char* d, Manip m,\
			std::vector<bool>* i) const;\
	template <class Manip>\
	NAME##_cus_value_list<Manip> value_list(const char* d, Manip m, \
			mysqlpp::sql_cmp_type sc) const;\
	/* cus field */\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false, bool i15 = false, bool i16 = false, bool i17 = false, bool i18 = false, bool i19 = false, bool i20 = false, bool i21 = false) const \
			{ return field_list(",", mysqlpp::do_nothing, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20, i21); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL, NAME##_enum i15 = NAME##_NULL, NAME##_enum i16 = NAME##_NULL, NAME##_enum i17 = NAME##_NULL, NAME##_enum i18 = NAME##_NULL, NAME##_enum i19 = NAME##_NULL, NAME##_enum i20 = NAME##_NULL, NAME##_enum i21 = NAME##_NULL) const\
			{ return field_list(",", mysqlpp::do_nothing, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20, i21); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(std::vector<bool> *i) const\
			{ return field_list(",", mysqlpp::do_nothing, i); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(mysqlpp::sql_cmp_type sc) const\
			{ return field_list(",", mysqlpp::do_nothing, sc); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(const char* d,\
			bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false, bool i15 = false, bool i16 = false, bool i17 = false, bool i18 = false, bool i19 = false, bool i20 = false, bool i21 = false) const\
			{ return field_list(d, mysqlpp::do_nothing, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20, i21); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(const char* d,\
			NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL, NAME##_enum i15 = NAME##_NULL, NAME##_enum i16 = NAME##_NULL, NAME##_enum i17 = NAME##_NULL, NAME##_enum i18 = NAME##_NULL, NAME##_enum i19 = NAME##_NULL, NAME##_enum i20 = NAME##_NULL, NAME##_enum i21 = NAME##_NULL) const\
			{ return field_list(d, mysqlpp::do_nothing, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20, i21); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(const char* d,\
			std::vector<bool>* i) const\
			{ return field_list(d, mysqlpp::do_nothing, i); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(const char* d,\
			mysqlpp::sql_cmp_type sc) const\
			{ return field_list(d, mysqlpp::do_nothing, sc); }\
	template <class Manip>\
	NAME##_cus_field_list<Manip> field_list(const char* d, Manip m,\
			bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false, bool i15 = false, bool i16 = false, bool i17 = false, bool i18 = false, bool i19 = false, bool i20 = false, bool i21 = false) const;\
	template <class Manip>\
	NAME##_cus_field_list<Manip> field_list(const char* d, Manip m,\
			NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL, NAME##_enum i15 = NAME##_NULL, NAME##_enum i16 = NAME##_NULL, NAME##_enum i17 = NAME##_NULL, NAME##_enum i18 = NAME##_NULL, NAME##_enum i19 = NAME##_NULL, NAME##_enum i20 = NAME##_NULL, NAME##_enum i21 = NAME##_NULL) const;\
	template <class Manip>\
	NAME##_cus_field_list<Manip> field_list(const char* d, Manip m,\
			std::vector<bool> *i) const;\
	template <class Manip>\
	NAME##_cus_field_list<Manip> field_list(const char* d, Manip m,\
			mysqlpp::sql_cmp_type sc) const;\
	/* cus equal */\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false, bool i15 = false, bool i16 = false, bool i17 = false, bool i18 = false, bool i19 = false, bool i20 = false, bool i21 = false) const\
			{ return equal_list(",", " = ", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20, i21); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL, NAME##_enum i15 = NAME##_NULL, NAME##_enum i16 = NAME##_NULL, NAME##_enum i17 = NAME##_NULL, NAME##_enum i18 = NAME##_NULL, NAME##_enum i19 = NAME##_NULL, NAME##_enum i20 = NAME##_NULL, NAME##_enum i21 = NAME##_NULL) const\
			{ return equal_list(",", " = ", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20, i21); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(std::vector<bool>* i) const\
			{ return equal_list(",", " = ", mysqlpp::quote, i); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(mysqlpp::sql_cmp_type sc) const\
			{ return equal_list(",", " = ", mysqlpp::quote, sc); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false, bool i15 = false, bool i16 = false, bool i17 = false, bool i18 = false, bool i19 = false, bool i20 = false, bool i21 = false) const\
			{ return equal_list(d, " = ", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20, i21); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL, NAME##_enum i15 = NAME##_NULL, NAME##_enum i16 = NAME##_NULL, NAME##_enum i17 = NAME##_NULL, NAME##_enum i18 = NAME##_NULL, NAME##_enum i19 = NAME##_NULL, NAME##_enum i20 = NAME##_NULL, NAME##_enum i21 = NAME##_NULL) const\
			{ return equal_list(d, " = ", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20, i21); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d,\
			std::vector<bool> *i) const\
			{ return equal_list(d, " = ", mysqlpp::quote, i); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d,\
			mysqlpp::sql_cmp_type sc) const\
			{ return equal_list(d, " = ", mysqlpp::quote, sc); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, const char* c,\
			bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false, bool i15 = false, bool i16 = false, bool i17 = false, bool i18 = false, bool i19 = false, bool i20 = false, bool i21 = false) const\
			{ return equal_list(d, c, mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20, i21); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, const char* c,\
			NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL, NAME##_enum i15 = NAME##_NULL, NAME##_enum i16 = NAME##_NULL, NAME##_enum i17 = NAME##_NULL, NAME##_enum i18 = NAME##_NULL, NAME##_enum i19 = NAME##_NULL, NAME##_enum i20 = NAME##_NULL, NAME##_enum i21 = NAME##_NULL) const\
			{ return equal_list(d, c, mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20, i21); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, const char* c,\
			std::vector<bool> *i) const\
			{ return equal_list(d, c, mysqlpp::quote, i); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, const char* c,\
			mysqlpp::sql_cmp_type sc) const\
			{ return equal_list(d, c, mysqlpp::quote, sc); }\
	template <class Manip>\
	NAME##_cus_equal_list<Manip> equal_list(const char* d, const char* c, Manip m, \
						bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false, bool i15 = false, bool i16 = false, bool i17 = false, bool i18 = false, bool i19 = false, bool i20 = false, bool i21 = false) const;\
	template <class Manip>\
	NAME##_cus_equal_list<Manip> equal_list(const char* d, const char* c, Manip m, \
						NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL, NAME##_enum i15 = NAME##_NULL, NAME##_enum i16 = NAME##_NULL, NAME##_enum i17 = NAME##_NULL, NAME##_enum i18 = NAME##_NULL, NAME##_enum i19 = NAME##_NULL, NAME##_enum i20 = NAME##_NULL, NAME##_enum i21 = NAME##_NULL) const;\
	template <class Manip>\
	NAME##_cus_equal_list<Manip> equal_list(const char* d, const char* c, Manip m, \
						std::vector<bool> *i) const;\
	template <class Manip>\
	NAME##_cus_equal_list<Manip> equal_list(const char* d, const char* c, Manip m, \
						mysqlpp::sql_cmp_type sc) const;\
	private:\
	static const char* table_;\
	const char* table_override_;\
	};\
	MYSQLPP_SSQLS_CONDITIONAL_STATICS(\
		const char* NAME::names[] = {\
			    N1 ,\
    N2 ,\
    N3 ,\
    N4 ,\
    N5 ,\
    N6 ,\
    N7 ,\
    N8 ,\
    N9 ,\
    N10 ,\
    N11 ,\
    N12 ,\
    N13 ,\
    N14 ,\
    N15 ,\
    N16 ,\
    N17 ,\
    N18 ,\
    N19 ,\
    N20 ,\
    N21 \
		};\
		const char* NAME::table_ = #NAME;\
	)\
	template <class Manip>\
	NAME##_cus_value_list<Manip>::NAME##_cus_value_list\
			(const NAME* o, const char* d, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13, bool i14, bool i15, bool i16, bool i17, bool i18, bool i19, bool i20, bool i21)\
	{\
		delim = d;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(21, false);\
    if (i1) (*include)[0]=true;\
    if (i2) (*include)[1]=true;\
    if (i3) (*include)[2]=true;\
    if (i4) (*include)[3]=true;\
    if (i5) (*include)[4]=true;\
    if (i6) (*include)[5]=true;\
    if (i7) (*include)[6]=true;\
    if (i8) (*include)[7]=true;\
    if (i9) (*include)[8]=true;\
    if (i10) (*include)[9]=true;\
    if (i11) (*include)[10]=true;\
    if (i12) (*include)[11]=true;\
    if (i13) (*include)[12]=true;\
    if (i14) (*include)[13]=true;\
    if (i15) (*include)[14]=true;\
    if (i16) (*include)[15]=true;\
    if (i17) (*include)[16]=true;\
    if (i18) (*include)[17]=true;\
    if (i19) (*include)[18]=true;\
    if (i20) (*include)[19]=true;\
    if (i21) (*include)[20]=true;\
	}\
	template <class Manip>\
	NAME##_cus_value_list<Manip>::NAME##_cus_value_list\
			(const NAME* o, const char* d, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13, NAME##_enum i14, NAME##_enum i15, NAME##_enum i16, NAME##_enum i17, NAME##_enum i18, NAME##_enum i19, NAME##_enum i20, NAME##_enum i21)\
	{\
		delim = d;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(21, false);\
    if (i1 == NAME##_NULL) return;\
    (*include)[i1]=true;\
    if (i2 == NAME##_NULL) return;\
    (*include)[i2]=true;\
    if (i3 == NAME##_NULL) return;\
    (*include)[i3]=true;\
    if (i4 == NAME##_NULL) return;\
    (*include)[i4]=true;\
    if (i5 == NAME##_NULL) return;\
    (*include)[i5]=true;\
    if (i6 == NAME##_NULL) return;\
    (*include)[i6]=true;\
    if (i7 == NAME##_NULL) return;\
    (*include)[i7]=true;\
    if (i8 == NAME##_NULL) return;\
    (*include)[i8]=true;\
    if (i9 == NAME##_NULL) return;\
    (*include)[i9]=true;\
    if (i10 == NAME##_NULL) return;\
    (*include)[i10]=true;\
    if (i11 == NAME##_NULL) return;\
    (*include)[i11]=true;\
    if (i12 == NAME##_NULL) return;\
    (*include)[i12]=true;\
    if (i13 == NAME##_NULL) return;\
    (*include)[i13]=true;\
    if (i14 == NAME##_NULL) return;\
    (*include)[i14]=true;\
    if (i15 == NAME##_NULL) return;\
    (*include)[i15]=true;\
    if (i16 == NAME##_NULL) return;\
    (*include)[i16]=true;\
    if (i17 == NAME##_NULL) return;\
    (*include)[i17]=true;\
    if (i18 == NAME##_NULL) return;\
    (*include)[i18]=true;\
    if (i19 == NAME##_NULL) return;\
    (*include)[i19]=true;\
    if (i20 == NAME##_NULL) return;\
    (*include)[i20]=true;\
    if (i21 == NAME##_NULL) return;\
    (*include)[i21]=true;\
	}\
	template <class Manip>\
	NAME##_cus_field_list<Manip>::NAME##_cus_field_list\
			(const NAME* o, const char* d, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13, bool i14, bool i15, bool i16, bool i17, bool i18, bool i19, bool i20, bool i21)\
	{\
		delim = d;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(21, false);\
    if (i1) (*include)[0]=true;\
    if (i2) (*include)[1]=true;\
    if (i3) (*include)[2]=true;\
    if (i4) (*include)[3]=true;\
    if (i5) (*include)[4]=true;\
    if (i6) (*include)[5]=true;\
    if (i7) (*include)[6]=true;\
    if (i8) (*include)[7]=true;\
    if (i9) (*include)[8]=true;\
    if (i10) (*include)[9]=true;\
    if (i11) (*include)[10]=true;\
    if (i12) (*include)[11]=true;\
    if (i13) (*include)[12]=true;\
    if (i14) (*include)[13]=true;\
    if (i15) (*include)[14]=true;\
    if (i16) (*include)[15]=true;\
    if (i17) (*include)[16]=true;\
    if (i18) (*include)[17]=true;\
    if (i19) (*include)[18]=true;\
    if (i20) (*include)[19]=true;\
    if (i21) (*include)[20]=true;\
	}\
	template <class Manip>\
	NAME##_cus_field_list<Manip>::NAME##_cus_field_list\
			(const NAME* o, const char* d, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13, NAME##_enum i14, NAME##_enum i15, NAME##_enum i16, NAME##_enum i17, NAME##_enum i18, NAME##_enum i19, NAME##_enum i20, NAME##_enum i21)\
	{\
		delim = d;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(21, false);\
    if (i1 == NAME##_NULL) return;\
    (*include)[i1]=true;\
    if (i2 == NAME##_NULL) return;\
    (*include)[i2]=true;\
    if (i3 == NAME##_NULL) return;\
    (*include)[i3]=true;\
    if (i4 == NAME##_NULL) return;\
    (*include)[i4]=true;\
    if (i5 == NAME##_NULL) return;\
    (*include)[i5]=true;\
    if (i6 == NAME##_NULL) return;\
    (*include)[i6]=true;\
    if (i7 == NAME##_NULL) return;\
    (*include)[i7]=true;\
    if (i8 == NAME##_NULL) return;\
    (*include)[i8]=true;\
    if (i9 == NAME##_NULL) return;\
    (*include)[i9]=true;\
    if (i10 == NAME##_NULL) return;\
    (*include)[i10]=true;\
    if (i11 == NAME##_NULL) return;\
    (*include)[i11]=true;\
    if (i12 == NAME##_NULL) return;\
    (*include)[i12]=true;\
    if (i13 == NAME##_NULL) return;\
    (*include)[i13]=true;\
    if (i14 == NAME##_NULL) return;\
    (*include)[i14]=true;\
    if (i15 == NAME##_NULL) return;\
    (*include)[i15]=true;\
    if (i16 == NAME##_NULL) return;\
    (*include)[i16]=true;\
    if (i17 == NAME##_NULL) return;\
    (*include)[i17]=true;\
    if (i18 == NAME##_NULL) return;\
    (*include)[i18]=true;\
    if (i19 == NAME##_NULL) return;\
    (*include)[i19]=true;\
    if (i20 == NAME##_NULL) return;\
    (*include)[i20]=true;\
    if (i21 == NAME##_NULL) return;\
    (*include)[i21]=true;\
	}\
	template <class Manip>\
	NAME##_cus_equal_list<Manip>::NAME##_cus_equal_list\
			(const NAME* o, const char* d, const char* c, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13, bool i14, bool i15, bool i16, bool i17, bool i18, bool i19, bool i20, bool i21)\
	{\
		delim = d;\
		comp = c;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(21, false);\
    if (i1) (*include)[0]=true;\
    if (i2) (*include)[1]=true;\
    if (i3) (*include)[2]=true;\
    if (i4) (*include)[3]=true;\
    if (i5) (*include)[4]=true;\
    if (i6) (*include)[5]=true;\
    if (i7) (*include)[6]=true;\
    if (i8) (*include)[7]=true;\
    if (i9) (*include)[8]=true;\
    if (i10) (*include)[9]=true;\
    if (i11) (*include)[10]=true;\
    if (i12) (*include)[11]=true;\
    if (i13) (*include)[12]=true;\
    if (i14) (*include)[13]=true;\
    if (i15) (*include)[14]=true;\
    if (i16) (*include)[15]=true;\
    if (i17) (*include)[16]=true;\
    if (i18) (*include)[17]=true;\
    if (i19) (*include)[18]=true;\
    if (i20) (*include)[19]=true;\
    if (i21) (*include)[20]=true;\
	}\
	template <class Manip>\
	NAME##_cus_equal_list<Manip>::NAME##_cus_equal_list\
			(const NAME* o, const char* d, const char* c, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13, NAME##_enum i14, NAME##_enum i15, NAME##_enum i16, NAME##_enum i17, NAME##_enum i18, NAME##_enum i19, NAME##_enum i20, NAME##_enum i21)\
	{\
		delim = d;\
		comp = c;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(21, false);\
    if (i1 == NAME##_NULL) return;\
    (*include)[i1]=true;\
    if (i2 == NAME##_NULL) return;\
    (*include)[i2]=true;\
    if (i3 == NAME##_NULL) return;\
    (*include)[i3]=true;\
    if (i4 == NAME##_NULL) return;\
    (*include)[i4]=true;\
    if (i5 == NAME##_NULL) return;\
    (*include)[i5]=true;\
    if (i6 == NAME##_NULL) return;\
    (*include)[i6]=true;\
    if (i7 == NAME##_NULL) return;\
    (*include)[i7]=true;\
    if (i8 == NAME##_NULL) return;\
    (*include)[i8]=true;\
    if (i9 == NAME##_NULL) return;\
    (*include)[i9]=true;\
    if (i10 == NAME##_NULL) return;\
    (*include)[i10]=true;\
    if (i11 == NAME##_NULL) return;\
    (*include)[i11]=true;\
    if (i12 == NAME##_NULL) return;\
    (*include)[i12]=true;\
    if (i13 == NAME##_NULL) return;\
    (*include)[i13]=true;\
    if (i14 == NAME##_NULL) return;\
    (*include)[i14]=true;\
    if (i15 == NAME##_NULL) return;\
    (*include)[i15]=true;\
    if (i16 == NAME##_NULL) return;\
    (*include)[i16]=true;\
    if (i17 == NAME##_NULL) return;\
    (*include)[i17]=true;\
    if (i18 == NAME##_NULL) return;\
    (*include)[i18]=true;\
    if (i19 == NAME##_NULL) return;\
    (*include)[i19]=true;\
    if (i20 == NAME##_NULL) return;\
    (*include)[i20]=true;\
    if (i21 == NAME##_NULL) return;\
    (*include)[i21]=true;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_value_list<Manip>& obj)\
	{\
    s << obj.manip << obj.obj->I1 << obj.delim;\
    s << obj.manip << obj.obj->I2 << obj.delim;\
    s << obj.manip << obj.obj->I3 << obj.delim;\
    s << obj.manip << obj.obj->I4 << obj.delim;\
    s << obj.manip << obj.obj->I5 << obj.delim;\
    s << obj.manip << obj.obj->I6 << obj.delim;\
    s << obj.manip << obj.obj->I7 << obj.delim;\
    s << obj.manip << obj.obj->I8 << obj.delim;\
    s << obj.manip << obj.obj->I9 << obj.delim;\
    s << obj.manip << obj.obj->I10 << obj.delim;\
    s << obj.manip << obj.obj->I11 << obj.delim;\
    s << obj.manip << obj.obj->I12 << obj.delim;\
    s << obj.manip << obj.obj->I13 << obj.delim;\
    s << obj.manip << obj.obj->I14 << obj.delim;\
    s << obj.manip << obj.obj->I15 << obj.delim;\
    s << obj.manip << obj.obj->I16 << obj.delim;\
    s << obj.manip << obj.obj->I17 << obj.delim;\
    s << obj.manip << obj.obj->I18 << obj.delim;\
    s << obj.manip << obj.obj->I19 << obj.delim;\
    s << obj.manip << obj.obj->I20 << obj.delim;\
    s << obj.manip << obj.obj->I21;\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_field_list<Manip>& obj)\
	{\
    s << obj.manip << '`' << obj.obj->names[0] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[1] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[2] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[3] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[4] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[5] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[6] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[7] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[8] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[9] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[10] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[11] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[12] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[13] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[14] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[15] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[16] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[17] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[18] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[19] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[20] << '`';\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_equal_list<Manip>& obj)\
	{\
    s << '`' << obj.obj->names[0] << '`' << obj.comp << obj.manip << obj.obj->I1 << obj.delim;\
    s << '`' << obj.obj->names[1] << '`' << obj.comp << obj.manip << obj.obj->I2 << obj.delim;\
    s << '`' << obj.obj->names[2] << '`' << obj.comp << obj.manip << obj.obj->I3 << obj.delim;\
    s << '`' << obj.obj->names[3] << '`' << obj.comp << obj.manip << obj.obj->I4 << obj.delim;\
    s << '`' << obj.obj->names[4] << '`' << obj.comp << obj.manip << obj.obj->I5 << obj.delim;\
    s << '`' << obj.obj->names[5] << '`' << obj.comp << obj.manip << obj.obj->I6 << obj.delim;\
    s << '`' << obj.obj->names[6] << '`' << obj.comp << obj.manip << obj.obj->I7 << obj.delim;\
    s << '`' << obj.obj->names[7] << '`' << obj.comp << obj.manip << obj.obj->I8 << obj.delim;\
    s << '`' << obj.obj->names[8] << '`' << obj.comp << obj.manip << obj.obj->I9 << obj.delim;\
    s << '`' << obj.obj->names[9] << '`' << obj.comp << obj.manip << obj.obj->I10 << obj.delim;\
    s << '`' << obj.obj->names[10] << '`' << obj.comp << obj.manip << obj.obj->I11 << obj.delim;\
    s << '`' << obj.obj->names[11] << '`' << obj.comp << obj.manip << obj.obj->I12 << obj.delim;\
    s << '`' << obj.obj->names[12] << '`' << obj.comp << obj.manip << obj.obj->I13 << obj.delim;\
    s << '`' << obj.obj->names[13] << '`' << obj.comp << obj.manip << obj.obj->I14 << obj.delim;\
    s << '`' << obj.obj->names[14] << '`' << obj.comp << obj.manip << obj.obj->I15 << obj.delim;\
    s << '`' << obj.obj->names[15] << '`' << obj.comp << obj.manip << obj.obj->I16 << obj.delim;\
    s << '`' << obj.obj->names[16] << '`' << obj.comp << obj.manip << obj.obj->I17 << obj.delim;\
    s << '`' << obj.obj->names[17] << '`' << obj.comp << obj.manip << obj.obj->I18 << obj.delim;\
    s << '`' << obj.obj->names[18] << '`' << obj.comp << obj.manip << obj.obj->I19 << obj.delim;\
    s << '`' << obj.obj->names[19] << '`' << obj.comp << obj.manip << obj.obj->I20 << obj.delim;\
    s << '`' << obj.obj->names[20] << '`' << obj.comp << obj.manip << obj.obj->I21;\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_cus_value_list<Manip>& obj)\
	{\
		bool before = false;\
    if ((*obj.include)[0]) { \
      s << obj.manip << obj.obj->I1;\
      before = true; \
     } \
    if ((*obj.include)[1]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I2;\
      before = true; \
     } \
    if ((*obj.include)[2]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I3;\
      before = true; \
     } \
    if ((*obj.include)[3]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I4;\
      before = true; \
     } \
    if ((*obj.include)[4]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I5;\
      before = true; \
     } \
    if ((*obj.include)[5]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I6;\
      before = true; \
     } \
    if ((*obj.include)[6]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I7;\
      before = true; \
     } \
    if ((*obj.include)[7]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I8;\
      before = true; \
     } \
    if ((*obj.include)[8]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I9;\
      before = true; \
     } \
    if ((*obj.include)[9]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I10;\
      before = true; \
     } \
    if ((*obj.include)[10]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I11;\
      before = true; \
     } \
    if ((*obj.include)[11]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I12;\
      before = true; \
     } \
    if ((*obj.include)[12]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I13;\
      before = true; \
     } \
    if ((*obj.include)[13]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I14;\
      before = true; \
     } \
    if ((*obj.include)[14]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I15;\
      before = true; \
     } \
    if ((*obj.include)[15]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I16;\
      before = true; \
     } \
    if ((*obj.include)[16]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I17;\
      before = true; \
     } \
    if ((*obj.include)[17]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I18;\
      before = true; \
     } \
    if ((*obj.include)[18]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I19;\
      before = true; \
     } \
    if ((*obj.include)[19]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I20;\
      before = true; \
     } \
    if ((*obj.include)[20]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I21;\
     } \
        (void)before;\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_cus_field_list<Manip>& obj)\
	{\
		bool before = false;\
    if ((*obj.include)[0]) { \
      s << obj.manip << '`' << obj.obj->names[0] << '`';\
      before = true; \
     } \
    if ((*obj.include)[1]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[1] << '`';\
      before = true; \
     } \
    if ((*obj.include)[2]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[2] << '`';\
      before = true; \
     } \
    if ((*obj.include)[3]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[3] << '`';\
      before = true; \
     } \
    if ((*obj.include)[4]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[4] << '`';\
      before = true; \
     } \
    if ((*obj.include)[5]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[5] << '`';\
      before = true; \
     } \
    if ((*obj.include)[6]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[6] << '`';\
      before = true; \
     } \
    if ((*obj.include)[7]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[7] << '`';\
      before = true; \
     } \
    if ((*obj.include)[8]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[8] << '`';\
      before = true; \
     } \
    if ((*obj.include)[9]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[9] << '`';\
      before = true; \
     } \
    if ((*obj.include)[10]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[10] << '`';\
      before = true; \
     } \
    if ((*obj.include)[11]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[11] << '`';\
      before = true; \
     } \
    if ((*obj.include)[12]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[12] << '`';\
      before = true; \
     } \
    if ((*obj.include)[13]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[13] << '`';\
      before = true; \
     } \
    if ((*obj.include)[14]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[14] << '`';\
      before = true; \
     } \
    if ((*obj.include)[15]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[15] << '`';\
      before = true; \
     } \
    if ((*obj.include)[16]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[16] << '`';\
      before = true; \
     } \
    if ((*obj.include)[17]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[17] << '`';\
      before = true; \
     } \
    if ((*obj.include)[18]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[18] << '`';\
      before = true; \
     } \
    if ((*obj.include)[19]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[19] << '`';\
      before = true; \
     } \
    if ((*obj.include)[20]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[20] << '`';\
     } \
        (void)before;\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_cus_equal_list<Manip>& obj)\
	{\
		bool before = false;\
    if ((*obj.include)[0]) { \
      s << '`' << obj.obj->names[0] << '`' << obj.comp << obj.manip << obj.obj->I1;\
      before = true; \
     } \
    if ((*obj.include)[1]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[1] << '`' << obj.comp << obj.manip << obj.obj->I2;\
      before = true; \
     } \
    if ((*obj.include)[2]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[2] << '`' << obj.comp << obj.manip << obj.obj->I3;\
      before = true; \
     } \
    if ((*obj.include)[3]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[3] << '`' << obj.comp << obj.manip << obj.obj->I4;\
      before = true; \
     } \
    if ((*obj.include)[4]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[4] << '`' << obj.comp << obj.manip << obj.obj->I5;\
      before = true; \
     } \
    if ((*obj.include)[5]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[5] << '`' << obj.comp << obj.manip << obj.obj->I6;\
      before = true; \
     } \
    if ((*obj.include)[6]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[6] << '`' << obj.comp << obj.manip << obj.obj->I7;\
      before = true; \
     } \
    if ((*obj.include)[7]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[7] << '`' << obj.comp << obj.manip << obj.obj->I8;\
      before = true; \
     } \
    if ((*obj.include)[8]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[8] << '`' << obj.comp << obj.manip << obj.obj->I9;\
      before = true; \
     } \
    if ((*obj.include)[9]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[9] << '`' << obj.comp << obj.manip << obj.obj->I10;\
      before = true; \
     } \
    if ((*obj.include)[10]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[10] << '`' << obj.comp << obj.manip << obj.obj->I11;\
      before = true; \
     } \
    if ((*obj.include)[11]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[11] << '`' << obj.comp << obj.manip << obj.obj->I12;\
      before = true; \
     } \
    if ((*obj.include)[12]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[12] << '`' << obj.comp << obj.manip << obj.obj->I13;\
      before = true; \
     } \
    if ((*obj.include)[13]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[13] << '`' << obj.comp << obj.manip << obj.obj->I14;\
      before = true; \
     } \
    if ((*obj.include)[14]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[14] << '`' << obj.comp << obj.manip << obj.obj->I15;\
      before = true; \
     } \
    if ((*obj.include)[15]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[15] << '`' << obj.comp << obj.manip << obj.obj->I16;\
      before = true; \
     } \
    if ((*obj.include)[16]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[16] << '`' << obj.comp << obj.manip << obj.obj->I17;\
      before = true; \
     } \
    if ((*obj.include)[17]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[17] << '`' << obj.comp << obj.manip << obj.obj->I18;\
      before = true; \
     } \
    if ((*obj.include)[18]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[18] << '`' << obj.comp << obj.manip << obj.obj->I19;\
      before = true; \
     } \
    if ((*obj.include)[19]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[19] << '`' << obj.comp << obj.manip << obj.obj->I20;\
      before = true; \
     } \
    if ((*obj.include)[20]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[20] << '`' << obj.comp << obj.manip << obj.obj->I21;\
     } \
        (void)before;\
		return s;\
	}\
	template <class Manip>\
	inline NAME##_value_list<Manip> NAME::value_list(const char* d, Manip m) const\
			{ return NAME##_value_list<Manip> (this, d, m); } \
	template <class Manip>\
	inline NAME##_field_list<Manip> NAME::field_list(const char* d, Manip m) const\
			{ return NAME##_field_list<Manip> (this, d, m); } \
	template <class Manip>\
	inline NAME##_equal_list<Manip> NAME::equal_list(const char* d, const char* c, Manip m) const\
			{ return NAME##_equal_list<Manip> (this, d, c, m); } \
	template <class Manip>\
	inline NAME##_cus_value_list<Manip> NAME::value_list(const char* d, Manip m,\
			bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13, bool i14, bool i15, bool i16, bool i17, bool i18, bool i19, bool i20, bool i21) const\
			{ return NAME##_cus_value_list<Manip> (this, d, m, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20, i21); }\
	template <class Manip>\
	inline NAME##_cus_field_list<Manip> NAME::field_list(const char* d, Manip m,\
			bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13, bool i14, bool i15, bool i16, bool i17, bool i18, bool i19, bool i20, bool i21) const\
			{ return NAME##_cus_field_list<Manip> (this, d, m, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20, i21); }\
	template <class Manip>\
	inline NAME##_cus_equal_list<Manip> NAME::equal_list(const char* d, const char* c, Manip m,\
			bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13, bool i14, bool i15, bool i16, bool i17, bool i18, bool i19, bool i20, bool i21) const\
			{ return NAME##_cus_equal_list<Manip> (this, d, c, m, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20, i21); } \
	template <class Manip>\
	inline NAME##_cus_value_list<Manip> NAME::value_list(const char* d, Manip m,\
			NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13, NAME##_enum i14, NAME##_enum i15, NAME##_enum i16, NAME##_enum i17, NAME##_enum i18, NAME##_enum i19, NAME##_enum i20, NAME##_enum i21) const\
			{ return NAME##_cus_value_list<Manip> (this, d, m, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20, i21); } \
	template <class Manip>\
	inline NAME##_cus_field_list<Manip> NAME::field_list(const char* d, Manip m,\
			NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13, NAME##_enum i14, NAME##_enum i15, NAME##_enum i16, NAME##_enum i17, NAME##_enum i18, NAME##_enum i19, NAME##_enum i20, NAME##_enum i21) const\
			{ return NAME##_cus_field_list<Manip> (this, d, m, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20, i21); } \
	template <class Manip>\
	inline NAME##_cus_equal_list<Manip> NAME::equal_list(const char* d, const char* c, Manip m, \
			NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13, NAME##_enum i14, NAME##_enum i15, NAME##_enum i16, NAME##_enum i17, NAME##_enum i18, NAME##_enum i19, NAME##_enum i20, NAME##_enum i21) const\
			{ return NAME##_cus_equal_list<Manip> (this, d, c, m, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20, i21); } \
	template <class Manip>\
	inline NAME##_cus_value_list<Manip> NAME::value_list(const char* d, Manip m,\
			std::vector<bool> *i) const\
			{ return NAME##_cus_value_list<Manip> (this, d, m, i); }\
	template <class Manip>\
	inline NAME##_cus_field_list<Manip> NAME::field_list(const char* d, Manip m,\
			std::vector<bool> *i) const\
			{ return NAME##_cus_field_list<Manip> (this, d, m, i); }\
	template <class Manip>\
	inline NAME##_cus_equal_list<Manip> NAME::equal_list(const char* d, const char* c, Manip m,\
			std::vector<bool> *i) const\
			{ return NAME##_cus_equal_list<Manip> (this, d, c, m, i); }\
	template <class Manip>\
	inline NAME##_cus_value_list<Manip> \
	NAME::value_list(const char* d, Manip m, mysqlpp::sql_cmp_type /*sc*/) const\
			{ sql_compare_type_def_##CMP(NAME, value, NUM); }\
	template <class Manip>\
	inline NAME##_cus_field_list<Manip> \
	NAME::field_list(const char* d, Manip m, mysqlpp::sql_cmp_type /*sc*/) const\
			{ sql_compare_type_def_##CMP(NAME, field, NUM); }\
	template <class Manip>\
	inline NAME##_cus_equal_list<Manip> \
	NAME::equal_list(const char* d, const char* c, Manip m, mysqlpp::sql_cmp_type /*sc*/) const\
			{ sql_compare_type_defe_##CMP(NAME, equal, NUM); }\
	template <mysqlpp::sql_dummy_type dummy>\
	void populate_##NAME(NAME *s, const mysqlpp::Row &row)\
	{\
		mysqlpp::NoExceptions ignore_schema_mismatches(row);\
    s->I1 = row[N1].conv(T1());\
    s->I2 = row[N2].conv(T2());\
    s->I3 = row[N3].conv(T3());\
    s->I4 = row[N4].conv(T4());\
    s->I5 = row[N5].conv(T5());\
    s->I6 = row[N6].conv(T6());\
    s->I7 = row[N7].conv(T7());\
    s->I8 = row[N8].conv(T8());\
    s->I9 = row[N9].conv(T9());\
    s->I10 = row[N10].conv(T10());\
    s->I11 = row[N11].conv(T11());\
    s->I12 = row[N12].conv(T12());\
    s->I13 = row[N13].conv(T13());\
    s->I14 = row[N14].conv(T14());\
    s->I15 = row[N15].conv(T15());\
    s->I16 = row[N16].conv(T16());\
    s->I17 = row[N17].conv(T17());\
    s->I18 = row[N18].conv(T18());\
    s->I19 = row[N19].conv(T19());\
    s->I20 = row[N20].conv(T20());\
    s->I21 = row[N21].conv(T21());\
	}\
	inline NAME::NAME(const mysqlpp::Row& row) :\
	table_override_(0)\
			{ populate_##NAME<mysqlpp::sql_dummy>(this, row); }\
	inline void NAME::set(const mysqlpp::Row& row)\
	{\
		table_override_ = 0;\
		populate_##NAME<mysqlpp::sql_dummy>(this, row);\
	}\
	sql_COMPARE__##CMP(NAME, I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, I17, I18, I19, I20, I21, 0, 0, 0, 0 )

#define sql_create_21(NAME, CMP, CONTR, T1, I1, T2, I2, T3, I3, T4, I4, T5, I5, T6, I6, T7, I7, T8, I8, T9, I9, T10, I10, T11, I11, T12, I12, T13, I13, T14, I14, T15, I15, T16, I16, T17, I17, T18, I18, T19, I19, T20, I20, T21, I21) \
		sql_create_complete_21(NAME, CMP, CONTR, T1, I1, #I1, T2, I2, #I2, T3, I3, #I3, T4, I4, #I4, T5, I5, #I5, T6, I6, #I6, T7, I7, #I7, T8, I8, #I8, T9, I9, #I9, T10, I10, #I10, T11, I11, #I11, T12, I12, #I12, T13, I13, #I13, T14, I14, #I14, T15, I15, #I15, T16, I16, #I16, T17, I17, #I17, T18, I18, #I18, T19, I19, #I19, T20, I20, #I20, T21, I21, #I21) \

// ---------------------------------------------------
//                  End Create 21
// ---------------------------------------------------

// ---------------------------------------------------
//                  Begin Create 22
// ---------------------------------------------------
#define sql_create_complete_22(NAME, CMP, CONTR, T1, I1, N1, T2, I2, N2, T3, I3, N3, T4, I4, N4, T5, I5, N5, T6, I6, N6, T7, I7, N7, T8, I8, N8, T9, I9, N9, T10, I10, N10, T11, I11, N11, T12, I12, N12, T13, I13, N13, T14, I14, N14, T15, I15, N15, T16, I16, N16, T17, I17, N17, T18, I18, N18, T19, I19, N19, T20, I20, N20, T21, I21, N21, T22, I22, N22) \
	struct NAME; \
	enum NAME##_enum { \
    NAME##_##I1,\
    NAME##_##I2,\
    NAME##_##I3,\
    NAME##_##I4,\
    NAME##_##I5,\
    NAME##_##I6,\
    NAME##_##I7,\
    NAME##_##I8,\
    NAME##_##I9,\
    NAME##_##I10,\
    NAME##_##I11,\
    NAME##_##I12,\
    NAME##_##I13,\
    NAME##_##I14,\
    NAME##_##I15,\
    NAME##_##I16,\
    NAME##_##I17,\
    NAME##_##I18,\
    NAME##_##I19,\
    NAME##_##I20,\
    NAME##_##I21,\
    NAME##_##I22 \
	,NAME##_NULL \
	}; \
	template <class Manip>\
	class NAME##_value_list { \
	public: \
	const NAME* obj;\
	const char* delim;\
	Manip manip;\
	public: \
	NAME##_value_list (const NAME* o, const char* d, Manip m) :\
	obj(o), delim(d), manip(m) { } \
	};\
	template <class Manip>\
	class NAME##_##field_list {\
	public: \
	const NAME* obj; \
	const char* delim;\
	Manip manip;\
	public: \
	NAME##_field_list (const NAME* o, const char* d, Manip m) :\
	obj(o), delim(d), manip(m) { } \
	};\
	template <class Manip>\
	class NAME##_equal_list { \
	public: \
	const NAME* obj;\
	const char* delim;\
	const char* comp;\
	Manip manip;\
	public: \
	NAME##_equal_list (const NAME* o, const char* d, const char* c, Manip m) :\
	obj(o), delim(d), comp(c), manip(m) { }\
	};\
	template <class Manip>\
	class NAME##_cus_value_list {\
	public:\
	const NAME* obj;\
	std::vector<bool> *include;\
	bool del_vector;\
	const char* delim;\
	Manip manip;\
	public: \
	~NAME##_cus_value_list () {if (del_vector) delete include;} \
	NAME##_cus_value_list (const NAME* o, const char* d, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13, bool i14, bool i15, bool i16, bool i17, bool i18, bool i19, bool i20, bool i21, bool i22);\
	NAME##_cus_value_list (const NAME* o, const char* d, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13, NAME##_enum i14, NAME##_enum i15, NAME##_enum i16, NAME##_enum i17, NAME##_enum i18, NAME##_enum i19, NAME##_enum i20, NAME##_enum i21, NAME##_enum i22); \
	NAME##_cus_value_list (const NAME* o, const char* d, Manip m ,std::vector<bool>* i) :\
	obj(o), include(i), del_vector(false), delim(d), manip(m) { }\
	};\
	template <class Manip>\
	class NAME##_cus_field_list { \
	public:\
	const NAME* obj; \
	std::vector<bool> *include; \
	bool del_vector; \
	const char* delim;\
	Manip manip;\
	public: \
	~NAME##_cus_field_list () {if (del_vector) delete include;} \
	NAME##_cus_field_list (const NAME* o, const char* d, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13, bool i14, bool i15, bool i16, bool i17, bool i18, bool i19, bool i20, bool i21, bool i22); \
	NAME##_cus_field_list (const NAME* o, const char* d, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13, NAME##_enum i14, NAME##_enum i15, NAME##_enum i16, NAME##_enum i17, NAME##_enum i18, NAME##_enum i19, NAME##_enum i20, NAME##_enum i21, NAME##_enum i22); \
	NAME##_cus_field_list (const NAME* o, const char* d, Manip m, std::vector<bool> *i) :\
	obj(o), include(i), del_vector(false), delim(d), manip(m) { }\
	};\
	template <class Manip>\
	class NAME##_cus_equal_list {\
	public:\
	const NAME* obj;\
	std::vector<bool> *include;\
	bool del_vector;\
	const char* delim;\
	const char* comp;\
	Manip manip;\
	public:\
	~NAME##_##cus_equal_list () {if (del_vector) delete include;}\
	NAME##_##cus_equal_list (const NAME* o, const char* d, const char* c, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13, bool i14, bool i15, bool i16, bool i17, bool i18, bool i19, bool i20, bool i21, bool i22); \
	NAME##_##cus_equal_list (const NAME* o, const char* d, const char* c, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13, NAME##_enum i14, NAME##_enum i15, NAME##_enum i16, NAME##_enum i17, NAME##_enum i18, NAME##_enum i19, NAME##_enum i20, NAME##_enum i21, NAME##_enum i22); \
	NAME##_##cus_equal_list (const NAME* o, const char* d, const char* c, Manip m, std::vector<bool> *i) :\
	obj(o), include(i), del_vector(false), delim(d), comp(c), manip(m) { }\
	};\
	template <mysqlpp::sql_dummy_type dummy> int sql_compare_##NAME(const NAME&, const NAME&);\
	struct NAME {\
    T1 I1;\
    T2 I2;\
    T3 I3;\
    T4 I4;\
    T5 I5;\
    T6 I6;\
    T7 I7;\
    T8 I8;\
    T9 I9;\
    T10 I10;\
    T11 I11;\
    T12 I12;\
    T13 I13;\
    T14 I14;\
    T15 I15;\
    T16 I16;\
    T17 I17;\
    T18 I18;\
    T19 I19;\
    T20 I20;\
    T21 I21;\
    T22 I22; \
	NAME() : table_override_(0) { }\
	NAME(const mysqlpp::Row& row);\
	void set(const mysqlpp::Row &row);\
	sql_compare_define_##CMP(NAME, T1, I1, T2, I2, T3, I3, T4, I4, T5, I5, T6, I6, T7, I7, T8, I8, T9, I9, T10, I10, T11, I11, T12, I12, T13, I13, T14, I14, T15, I15, T16, I16, T17, I17, T18, I18, T19, I19, T20, I20, T21, I21, T22, I22, 0, 0, 0, 0, 0, 0)\
	sql_construct_define_##CONTR(NAME, T1, I1, T2, I2, T3, I3, T4, I4, T5, I5, T6, I6, T7, I7, T8, I8, T9, I9, T10, I10, T11, I11, T12, I12, T13, I13, T14, I14, T15, I15, T16, I16, T17, I17, T18, I18, T19, I19, T20, I20, T21, I21, T22, I22, 0, 0, 0, 0, 0, 0)\
	static const char* names[];\
	static void table(const char* t) { table_ = t; }\
	const char* table() const\
			{ return table_override_ ? table_override_ : NAME::table_; }\
	void instance_table(const char* t) { table_override_ = t; }\
	NAME##_value_list<mysqlpp::quote_type0> value_list() const {\
		return value_list(",", mysqlpp::quote);}\
	NAME##_value_list<mysqlpp::quote_type0> value_list(const char* d) const {\
		return value_list(d, mysqlpp::quote);}\
	template <class Manip>\
	NAME##_value_list<Manip> value_list(const char* d, Manip m) const;\
	NAME##_field_list<mysqlpp::do_nothing_type0> field_list() const {\
		return field_list(",", mysqlpp::do_nothing);}\
	NAME##_field_list<mysqlpp::do_nothing_type0> field_list(const char* d) const {\
		return field_list(d, mysqlpp::do_nothing);}\
	template <class Manip>\
	NAME##_field_list<Manip> field_list(const char* d, Manip m) const;\
	NAME##_equal_list<mysqlpp::quote_type0> equal_list(const char* d = ",",\
			const char* c = " = ") const\
			{ return equal_list(d, c, mysqlpp::quote); }\
	template <class Manip>\
	NAME##_equal_list<Manip> equal_list(const char* d, const char* c, Manip m) const;\
	/* cus_data */\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false, bool i15 = false, bool i16 = false, bool i17 = false, bool i18 = false, bool i19 = false, bool i20 = false, bool i21 = false, bool i22 = false) const\
			{ return value_list(",", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20, i21, i22); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL, NAME##_enum i15 = NAME##_NULL, NAME##_enum i16 = NAME##_NULL, NAME##_enum i17 = NAME##_NULL, NAME##_enum i18 = NAME##_NULL, NAME##_enum i19 = NAME##_NULL, NAME##_enum i20 = NAME##_NULL, NAME##_enum i21 = NAME##_NULL, NAME##_enum i22 = NAME##_NULL) const\
			{ return value_list(",", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20, i21, i22); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(std::vector<bool> *i) const\
			{ return value_list(",", mysqlpp::quote, i); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(mysqlpp::sql_cmp_type sc) const\
			{ return value_list(",", mysqlpp::quote, sc); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(const char* d, bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false, bool i15 = false, bool i16 = false, bool i17 = false, bool i18 = false, bool i19 = false, bool i20 = false, bool i21 = false, bool i22 = false) const\
			{ return value_list(d, mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20, i21, i22); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(const char* d, NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL, NAME##_enum i15 = NAME##_NULL, NAME##_enum i16 = NAME##_NULL, NAME##_enum i17 = NAME##_NULL, NAME##_enum i18 = NAME##_NULL, NAME##_enum i19 = NAME##_NULL, NAME##_enum i20 = NAME##_NULL, NAME##_enum i21 = NAME##_NULL, NAME##_enum i22 = NAME##_NULL) const\
			{ return value_list(d, mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20, i21, i22); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(const char* d,\
			std::vector<bool> *i) const\
			{ return value_list(d, mysqlpp::quote, i); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(const char* d,\
			mysqlpp::sql_cmp_type sc) const\
			{ return value_list(d, mysqlpp::quote, sc); }\
	template <class Manip>\
	NAME##_cus_value_list<Manip> value_list(const char* d, Manip m,\
			bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false, bool i15 = false, bool i16 = false, bool i17 = false, bool i18 = false, bool i19 = false, bool i20 = false, bool i21 = false, bool i22 = false) const;\
	template <class Manip>\
	NAME##_cus_value_list<Manip> value_list(const char* d, Manip m,\
			NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL, NAME##_enum i15 = NAME##_NULL, NAME##_enum i16 = NAME##_NULL, NAME##_enum i17 = NAME##_NULL, NAME##_enum i18 = NAME##_NULL, NAME##_enum i19 = NAME##_NULL, NAME##_enum i20 = NAME##_NULL, NAME##_enum i21 = NAME##_NULL, NAME##_enum i22 = NAME##_NULL) const;\
	template <class Manip>\
	NAME##_cus_value_list<Manip> value_list(const char* d, Manip m,\
			std::vector<bool>* i) const;\
	template <class Manip>\
	NAME##_cus_value_list<Manip> value_list(const char* d, Manip m, \
			mysqlpp::sql_cmp_type sc) const;\
	/* cus field */\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false, bool i15 = false, bool i16 = false, bool i17 = false, bool i18 = false, bool i19 = false, bool i20 = false, bool i21 = false, bool i22 = false) const \
			{ return field_list(",", mysqlpp::do_nothing, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20, i21, i22); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL, NAME##_enum i15 = NAME##_NULL, NAME##_enum i16 = NAME##_NULL, NAME##_enum i17 = NAME##_NULL, NAME##_enum i18 = NAME##_NULL, NAME##_enum i19 = NAME##_NULL, NAME##_enum i20 = NAME##_NULL, NAME##_enum i21 = NAME##_NULL, NAME##_enum i22 = NAME##_NULL) const\
			{ return field_list(",", mysqlpp::do_nothing, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20, i21, i22); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(std::vector<bool> *i) const\
			{ return field_list(",", mysqlpp::do_nothing, i); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(mysqlpp::sql_cmp_type sc) const\
			{ return field_list(",", mysqlpp::do_nothing, sc); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(const char* d,\
			bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false, bool i15 = false, bool i16 = false, bool i17 = false, bool i18 = false, bool i19 = false, bool i20 = false, bool i21 = false, bool i22 = false) const\
			{ return field_list(d, mysqlpp::do_nothing, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20, i21, i22); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(const char* d,\
			NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL, NAME##_enum i15 = NAME##_NULL, NAME##_enum i16 = NAME##_NULL, NAME##_enum i17 = NAME##_NULL, NAME##_enum i18 = NAME##_NULL, NAME##_enum i19 = NAME##_NULL, NAME##_enum i20 = NAME##_NULL, NAME##_enum i21 = NAME##_NULL, NAME##_enum i22 = NAME##_NULL) const\
			{ return field_list(d, mysqlpp::do_nothing, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20, i21, i22); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(const char* d,\
			std::vector<bool>* i) const\
			{ return field_list(d, mysqlpp::do_nothing, i); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(const char* d,\
			mysqlpp::sql_cmp_type sc) const\
			{ return field_list(d, mysqlpp::do_nothing, sc); }\
	template <class Manip>\
	NAME##_cus_field_list<Manip> field_list(const char* d, Manip m,\
			bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false, bool i15 = false, bool i16 = false, bool i17 = false, bool i18 = false, bool i19 = false, bool i20 = false, bool i21 = false, bool i22 = false) const;\
	template <class Manip>\
	NAME##_cus_field_list<Manip> field_list(const char* d, Manip m,\
			NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL, NAME##_enum i15 = NAME##_NULL, NAME##_enum i16 = NAME##_NULL, NAME##_enum i17 = NAME##_NULL, NAME##_enum i18 = NAME##_NULL, NAME##_enum i19 = NAME##_NULL, NAME##_enum i20 = NAME##_NULL, NAME##_enum i21 = NAME##_NULL, NAME##_enum i22 = NAME##_NULL) const;\
	template <class Manip>\
	NAME##_cus_field_list<Manip> field_list(const char* d, Manip m,\
			std::vector<bool> *i) const;\
	template <class Manip>\
	NAME##_cus_field_list<Manip> field_list(const char* d, Manip m,\
			mysqlpp::sql_cmp_type sc) const;\
	/* cus equal */\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false, bool i15 = false, bool i16 = false, bool i17 = false, bool i18 = false, bool i19 = false, bool i20 = false, bool i21 = false, bool i22 = false) const\
			{ return equal_list(",", " = ", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20, i21, i22); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL, NAME##_enum i15 = NAME##_NULL, NAME##_enum i16 = NAME##_NULL, NAME##_enum i17 = NAME##_NULL, NAME##_enum i18 = NAME##_NULL, NAME##_enum i19 = NAME##_NULL, NAME##_enum i20 = NAME##_NULL, NAME##_enum i21 = NAME##_NULL, NAME##_enum i22 = NAME##_NULL) const\
			{ return equal_list(",", " = ", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20, i21, i22); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(std::vector<bool>* i) const\
			{ return equal_list(",", " = ", mysqlpp::quote, i); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(mysqlpp::sql_cmp_type sc) const\
			{ return equal_list(",", " = ", mysqlpp::quote, sc); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false, bool i15 = false, bool i16 = false, bool i17 = false, bool i18 = false, bool i19 = false, bool i20 = false, bool i21 = false, bool i22 = false) const\
			{ return equal_list(d, " = ", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20, i21, i22); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL, NAME##_enum i15 = NAME##_NULL, NAME##_enum i16 = NAME##_NULL, NAME##_enum i17 = NAME##_NULL, NAME##_enum i18 = NAME##_NULL, NAME##_enum i19 = NAME##_NULL, NAME##_enum i20 = NAME##_NULL, NAME##_enum i21 = NAME##_NULL, NAME##_enum i22 = NAME##_NULL) const\
			{ return equal_list(d, " = ", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20, i21, i22); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d,\
			std::vector<bool> *i) const\
			{ return equal_list(d, " = ", mysqlpp::quote, i); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d,\
			mysqlpp::sql_cmp_type sc) const\
			{ return equal_list(d, " = ", mysqlpp::quote, sc); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, const char* c,\
			bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false, bool i15 = false, bool i16 = false, bool i17 = false, bool i18 = false, bool i19 = false, bool i20 = false, bool i21 = false, bool i22 = false) const\
			{ return equal_list(d, c, mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20, i21, i22); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, const char* c,\
			NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL, NAME##_enum i15 = NAME##_NULL, NAME##_enum i16 = NAME##_NULL, NAME##_enum i17 = NAME##_NULL, NAME##_enum i18 = NAME##_NULL, NAME##_enum i19 = NAME##_NULL, NAME##_enum i20 = NAME##_NULL, NAME##_enum i21 = NAME##_NULL, NAME##_enum i22 = NAME##_NULL) const\
			{ return equal_list(d, c, mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20, i21, i22); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, const char* c,\
			std::vector<bool> *i) const\
			{ return equal_list(d, c, mysqlpp::quote, i); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, const char* c,\
			mysqlpp::sql_cmp_type sc) const\
			{ return equal_list(d, c, mysqlpp::quote, sc); }\
	template <class Manip>\
	NAME##_cus_equal_list<Manip> equal_list(const char* d, const char* c, Manip m, \
						bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false, bool i15 = false, bool i16 = false, bool i17 = false, bool i18 = false, bool i19 = false, bool i20 = false, bool i21 = false, bool i22 = false) const;\
	template <class Manip>\
	NAME##_cus_equal_list<Manip> equal_list(const char* d, const char* c, Manip m, \
						NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL, NAME##_enum i15 = NAME##_NULL, NAME##_enum i16 = NAME##_NULL, NAME##_enum i17 = NAME##_NULL, NAME##_enum i18 = NAME##_NULL, NAME##_enum i19 = NAME##_NULL, NAME##_enum i20 = NAME##_NULL, NAME##_enum i21 = NAME##_NULL, NAME##_enum i22 = NAME##_NULL) const;\
	template <class Manip>\
	NAME##_cus_equal_list<Manip> equal_list(const char* d, const char* c, Manip m, \
						std::vector<bool> *i) const;\
	template <class Manip>\
	NAME##_cus_equal_list<Manip> equal_list(const char* d, const char* c, Manip m, \
						mysqlpp::sql_cmp_type sc) const;\
	private:\
	static const char* table_;\
	const char* table_override_;\
	};\
	MYSQLPP_SSQLS_CONDITIONAL_STATICS(\
		const char* NAME::names[] = {\
			    N1 ,\
    N2 ,\
    N3 ,\
    N4 ,\
    N5 ,\
    N6 ,\
    N7 ,\
    N8 ,\
    N9 ,\
    N10 ,\
    N11 ,\
    N12 ,\
    N13 ,\
    N14 ,\
    N15 ,\
    N16 ,\
    N17 ,\
    N18 ,\
    N19 ,\
    N20 ,\
    N21 ,\
    N22 \
		};\
		const char* NAME::table_ = #NAME;\
	)\
	template <class Manip>\
	NAME##_cus_value_list<Manip>::NAME##_cus_value_list\
			(const NAME* o, const char* d, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13, bool i14, bool i15, bool i16, bool i17, bool i18, bool i19, bool i20, bool i21, bool i22)\
	{\
		delim = d;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(22, false);\
    if (i1) (*include)[0]=true;\
    if (i2) (*include)[1]=true;\
    if (i3) (*include)[2]=true;\
    if (i4) (*include)[3]=true;\
    if (i5) (*include)[4]=true;\
    if (i6) (*include)[5]=true;\
    if (i7) (*include)[6]=true;\
    if (i8) (*include)[7]=true;\
    if (i9) (*include)[8]=true;\
    if (i10) (*include)[9]=true;\
    if (i11) (*include)[10]=true;\
    if (i12) (*include)[11]=true;\
    if (i13) (*include)[12]=true;\
    if (i14) (*include)[13]=true;\
    if (i15) (*include)[14]=true;\
    if (i16) (*include)[15]=true;\
    if (i17) (*include)[16]=true;\
    if (i18) (*include)[17]=true;\
    if (i19) (*include)[18]=true;\
    if (i20) (*include)[19]=true;\
    if (i21) (*include)[20]=true;\
    if (i22) (*include)[21]=true;\
	}\
	template <class Manip>\
	NAME##_cus_value_list<Manip>::NAME##_cus_value_list\
			(const NAME* o, const char* d, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13, NAME##_enum i14, NAME##_enum i15, NAME##_enum i16, NAME##_enum i17, NAME##_enum i18, NAME##_enum i19, NAME##_enum i20, NAME##_enum i21, NAME##_enum i22)\
	{\
		delim = d;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(22, false);\
    if (i1 == NAME##_NULL) return;\
    (*include)[i1]=true;\
    if (i2 == NAME##_NULL) return;\
    (*include)[i2]=true;\
    if (i3 == NAME##_NULL) return;\
    (*include)[i3]=true;\
    if (i4 == NAME##_NULL) return;\
    (*include)[i4]=true;\
    if (i5 == NAME##_NULL) return;\
    (*include)[i5]=true;\
    if (i6 == NAME##_NULL) return;\
    (*include)[i6]=true;\
    if (i7 == NAME##_NULL) return;\
    (*include)[i7]=true;\
    if (i8 == NAME##_NULL) return;\
    (*include)[i8]=true;\
    if (i9 == NAME##_NULL) return;\
    (*include)[i9]=true;\
    if (i10 == NAME##_NULL) return;\
    (*include)[i10]=true;\
    if (i11 == NAME##_NULL) return;\
    (*include)[i11]=true;\
    if (i12 == NAME##_NULL) return;\
    (*include)[i12]=true;\
    if (i13 == NAME##_NULL) return;\
    (*include)[i13]=true;\
    if (i14 == NAME##_NULL) return;\
    (*include)[i14]=true;\
    if (i15 == NAME##_NULL) return;\
    (*include)[i15]=true;\
    if (i16 == NAME##_NULL) return;\
    (*include)[i16]=true;\
    if (i17 == NAME##_NULL) return;\
    (*include)[i17]=true;\
    if (i18 == NAME##_NULL) return;\
    (*include)[i18]=true;\
    if (i19 == NAME##_NULL) return;\
    (*include)[i19]=true;\
    if (i20 == NAME##_NULL) return;\
    (*include)[i20]=true;\
    if (i21 == NAME##_NULL) return;\
    (*include)[i21]=true;\
    if (i22 == NAME##_NULL) return;\
    (*include)[i22]=true;\
	}\
	template <class Manip>\
	NAME##_cus_field_list<Manip>::NAME##_cus_field_list\
			(const NAME* o, const char* d, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13, bool i14, bool i15, bool i16, bool i17, bool i18, bool i19, bool i20, bool i21, bool i22)\
	{\
		delim = d;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(22, false);\
    if (i1) (*include)[0]=true;\
    if (i2) (*include)[1]=true;\
    if (i3) (*include)[2]=true;\
    if (i4) (*include)[3]=true;\
    if (i5) (*include)[4]=true;\
    if (i6) (*include)[5]=true;\
    if (i7) (*include)[6]=true;\
    if (i8) (*include)[7]=true;\
    if (i9) (*include)[8]=true;\
    if (i10) (*include)[9]=true;\
    if (i11) (*include)[10]=true;\
    if (i12) (*include)[11]=true;\
    if (i13) (*include)[12]=true;\
    if (i14) (*include)[13]=true;\
    if (i15) (*include)[14]=true;\
    if (i16) (*include)[15]=true;\
    if (i17) (*include)[16]=true;\
    if (i18) (*include)[17]=true;\
    if (i19) (*include)[18]=true;\
    if (i20) (*include)[19]=true;\
    if (i21) (*include)[20]=true;\
    if (i22) (*include)[21]=true;\
	}\
	template <class Manip>\
	NAME##_cus_field_list<Manip>::NAME##_cus_field_list\
			(const NAME* o, const char* d, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13, NAME##_enum i14, NAME##_enum i15, NAME##_enum i16, NAME##_enum i17, NAME##_enum i18, NAME##_enum i19, NAME##_enum i20, NAME##_enum i21, NAME##_enum i22)\
	{\
		delim = d;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(22, false);\
    if (i1 == NAME##_NULL) return;\
    (*include)[i1]=true;\
    if (i2 == NAME##_NULL) return;\
    (*include)[i2]=true;\
    if (i3 == NAME##_NULL) return;\
    (*include)[i3]=true;\
    if (i4 == NAME##_NULL) return;\
    (*include)[i4]=true;\
    if (i5 == NAME##_NULL) return;\
    (*include)[i5]=true;\
    if (i6 == NAME##_NULL) return;\
    (*include)[i6]=true;\
    if (i7 == NAME##_NULL) return;\
    (*include)[i7]=true;\
    if (i8 == NAME##_NULL) return;\
    (*include)[i8]=true;\
    if (i9 == NAME##_NULL) return;\
    (*include)[i9]=true;\
    if (i10 == NAME##_NULL) return;\
    (*include)[i10]=true;\
    if (i11 == NAME##_NULL) return;\
    (*include)[i11]=true;\
    if (i12 == NAME##_NULL) return;\
    (*include)[i12]=true;\
    if (i13 == NAME##_NULL) return;\
    (*include)[i13]=true;\
    if (i14 == NAME##_NULL) return;\
    (*include)[i14]=true;\
    if (i15 == NAME##_NULL) return;\
    (*include)[i15]=true;\
    if (i16 == NAME##_NULL) return;\
    (*include)[i16]=true;\
    if (i17 == NAME##_NULL) return;\
    (*include)[i17]=true;\
    if (i18 == NAME##_NULL) return;\
    (*include)[i18]=true;\
    if (i19 == NAME##_NULL) return;\
    (*include)[i19]=true;\
    if (i20 == NAME##_NULL) return;\
    (*include)[i20]=true;\
    if (i21 == NAME##_NULL) return;\
    (*include)[i21]=true;\
    if (i22 == NAME##_NULL) return;\
    (*include)[i22]=true;\
	}\
	template <class Manip>\
	NAME##_cus_equal_list<Manip>::NAME##_cus_equal_list\
			(const NAME* o, const char* d, const char* c, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13, bool i14, bool i15, bool i16, bool i17, bool i18, bool i19, bool i20, bool i21, bool i22)\
	{\
		delim = d;\
		comp = c;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(22, false);\
    if (i1) (*include)[0]=true;\
    if (i2) (*include)[1]=true;\
    if (i3) (*include)[2]=true;\
    if (i4) (*include)[3]=true;\
    if (i5) (*include)[4]=true;\
    if (i6) (*include)[5]=true;\
    if (i7) (*include)[6]=true;\
    if (i8) (*include)[7]=true;\
    if (i9) (*include)[8]=true;\
    if (i10) (*include)[9]=true;\
    if (i11) (*include)[10]=true;\
    if (i12) (*include)[11]=true;\
    if (i13) (*include)[12]=true;\
    if (i14) (*include)[13]=true;\
    if (i15) (*include)[14]=true;\
    if (i16) (*include)[15]=true;\
    if (i17) (*include)[16]=true;\
    if (i18) (*include)[17]=true;\
    if (i19) (*include)[18]=true;\
    if (i20) (*include)[19]=true;\
    if (i21) (*include)[20]=true;\
    if (i22) (*include)[21]=true;\
	}\
	template <class Manip>\
	NAME##_cus_equal_list<Manip>::NAME##_cus_equal_list\
			(const NAME* o, const char* d, const char* c, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13, NAME##_enum i14, NAME##_enum i15, NAME##_enum i16, NAME##_enum i17, NAME##_enum i18, NAME##_enum i19, NAME##_enum i20, NAME##_enum i21, NAME##_enum i22)\
	{\
		delim = d;\
		comp = c;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(22, false);\
    if (i1 == NAME##_NULL) return;\
    (*include)[i1]=true;\
    if (i2 == NAME##_NULL) return;\
    (*include)[i2]=true;\
    if (i3 == NAME##_NULL) return;\
    (*include)[i3]=true;\
    if (i4 == NAME##_NULL) return;\
    (*include)[i4]=true;\
    if (i5 == NAME##_NULL) return;\
    (*include)[i5]=true;\
    if (i6 == NAME##_NULL) return;\
    (*include)[i6]=true;\
    if (i7 == NAME##_NULL) return;\
    (*include)[i7]=true;\
    if (i8 == NAME##_NULL) return;\
    (*include)[i8]=true;\
    if (i9 == NAME##_NULL) return;\
    (*include)[i9]=true;\
    if (i10 == NAME##_NULL) return;\
    (*include)[i10]=true;\
    if (i11 == NAME##_NULL) return;\
    (*include)[i11]=true;\
    if (i12 == NAME##_NULL) return;\
    (*include)[i12]=true;\
    if (i13 == NAME##_NULL) return;\
    (*include)[i13]=true;\
    if (i14 == NAME##_NULL) return;\
    (*include)[i14]=true;\
    if (i15 == NAME##_NULL) return;\
    (*include)[i15]=true;\
    if (i16 == NAME##_NULL) return;\
    (*include)[i16]=true;\
    if (i17 == NAME##_NULL) return;\
    (*include)[i17]=true;\
    if (i18 == NAME##_NULL) return;\
    (*include)[i18]=true;\
    if (i19 == NAME##_NULL) return;\
    (*include)[i19]=true;\
    if (i20 == NAME##_NULL) return;\
    (*include)[i20]=true;\
    if (i21 == NAME##_NULL) return;\
    (*include)[i21]=true;\
    if (i22 == NAME##_NULL) return;\
    (*include)[i22]=true;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_value_list<Manip>& obj)\
	{\
    s << obj.manip << obj.obj->I1 << obj.delim;\
    s << obj.manip << obj.obj->I2 << obj.delim;\
    s << obj.manip << obj.obj->I3 << obj.delim;\
    s << obj.manip << obj.obj->I4 << obj.delim;\
    s << obj.manip << obj.obj->I5 << obj.delim;\
    s << obj.manip << obj.obj->I6 << obj.delim;\
    s << obj.manip << obj.obj->I7 << obj.delim;\
    s << obj.manip << obj.obj->I8 << obj.delim;\
    s << obj.manip << obj.obj->I9 << obj.delim;\
    s << obj.manip << obj.obj->I10 << obj.delim;\
    s << obj.manip << obj.obj->I11 << obj.delim;\
    s << obj.manip << obj.obj->I12 << obj.delim;\
    s << obj.manip << obj.obj->I13 << obj.delim;\
    s << obj.manip << obj.obj->I14 << obj.delim;\
    s << obj.manip << obj.obj->I15 << obj.delim;\
    s << obj.manip << obj.obj->I16 << obj.delim;\
    s << obj.manip << obj.obj->I17 << obj.delim;\
    s << obj.manip << obj.obj->I18 << obj.delim;\
    s << obj.manip << obj.obj->I19 << obj.delim;\
    s << obj.manip << obj.obj->I20 << obj.delim;\
    s << obj.manip << obj.obj->I21 << obj.delim;\
    s << obj.manip << obj.obj->I22;\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_field_list<Manip>& obj)\
	{\
    s << obj.manip << '`' << obj.obj->names[0] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[1] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[2] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[3] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[4] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[5] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[6] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[7] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[8] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[9] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[10] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[11] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[12] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[13] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[14] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[15] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[16] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[17] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[18] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[19] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[20] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[21] << '`';\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_equal_list<Manip>& obj)\
	{\
    s << '`' << obj.obj->names[0] << '`' << obj.comp << obj.manip << obj.obj->I1 << obj.delim;\
    s << '`' << obj.obj->names[1] << '`' << obj.comp << obj.manip << obj.obj->I2 << obj.delim;\
    s << '`' << obj.obj->names[2] << '`' << obj.comp << obj.manip << obj.obj->I3 << obj.delim;\
    s << '`' << obj.obj->names[3] << '`' << obj.comp << obj.manip << obj.obj->I4 << obj.delim;\
    s << '`' << obj.obj->names[4] << '`' << obj.comp << obj.manip << obj.obj->I5 << obj.delim;\
    s << '`' << obj.obj->names[5] << '`' << obj.comp << obj.manip << obj.obj->I6 << obj.delim;\
    s << '`' << obj.obj->names[6] << '`' << obj.comp << obj.manip << obj.obj->I7 << obj.delim;\
    s << '`' << obj.obj->names[7] << '`' << obj.comp << obj.manip << obj.obj->I8 << obj.delim;\
    s << '`' << obj.obj->names[8] << '`' << obj.comp << obj.manip << obj.obj->I9 << obj.delim;\
    s << '`' << obj.obj->names[9] << '`' << obj.comp << obj.manip << obj.obj->I10 << obj.delim;\
    s << '`' << obj.obj->names[10] << '`' << obj.comp << obj.manip << obj.obj->I11 << obj.delim;\
    s << '`' << obj.obj->names[11] << '`' << obj.comp << obj.manip << obj.obj->I12 << obj.delim;\
    s << '`' << obj.obj->names[12] << '`' << obj.comp << obj.manip << obj.obj->I13 << obj.delim;\
    s << '`' << obj.obj->names[13] << '`' << obj.comp << obj.manip << obj.obj->I14 << obj.delim;\
    s << '`' << obj.obj->names[14] << '`' << obj.comp << obj.manip << obj.obj->I15 << obj.delim;\
    s << '`' << obj.obj->names[15] << '`' << obj.comp << obj.manip << obj.obj->I16 << obj.delim;\
    s << '`' << obj.obj->names[16] << '`' << obj.comp << obj.manip << obj.obj->I17 << obj.delim;\
    s << '`' << obj.obj->names[17] << '`' << obj.comp << obj.manip << obj.obj->I18 << obj.delim;\
    s << '`' << obj.obj->names[18] << '`' << obj.comp << obj.manip << obj.obj->I19 << obj.delim;\
    s << '`' << obj.obj->names[19] << '`' << obj.comp << obj.manip << obj.obj->I20 << obj.delim;\
    s << '`' << obj.obj->names[20] << '`' << obj.comp << obj.manip << obj.obj->I21 << obj.delim;\
    s << '`' << obj.obj->names[21] << '`' << obj.comp << obj.manip << obj.obj->I22;\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_cus_value_list<Manip>& obj)\
	{\
		bool before = false;\
    if ((*obj.include)[0]) { \
      s << obj.manip << obj.obj->I1;\
      before = true; \
     } \
    if ((*obj.include)[1]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I2;\
      before = true; \
     } \
    if ((*obj.include)[2]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I3;\
      before = true; \
     } \
    if ((*obj.include)[3]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I4;\
      before = true; \
     } \
    if ((*obj.include)[4]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I5;\
      before = true; \
     } \
    if ((*obj.include)[5]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I6;\
      before = true; \
     } \
    if ((*obj.include)[6]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I7;\
      before = true; \
     } \
    if ((*obj.include)[7]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I8;\
      before = true; \
     } \
    if ((*obj.include)[8]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I9;\
      before = true; \
     } \
    if ((*obj.include)[9]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I10;\
      before = true; \
     } \
    if ((*obj.include)[10]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I11;\
      before = true; \
     } \
    if ((*obj.include)[11]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I12;\
      before = true; \
     } \
    if ((*obj.include)[12]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I13;\
      before = true; \
     } \
    if ((*obj.include)[13]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I14;\
      before = true; \
     } \
    if ((*obj.include)[14]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I15;\
      before = true; \
     } \
    if ((*obj.include)[15]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I16;\
      before = true; \
     } \
    if ((*obj.include)[16]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I17;\
      before = true; \
     } \
    if ((*obj.include)[17]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I18;\
      before = true; \
     } \
    if ((*obj.include)[18]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I19;\
      before = true; \
     } \
    if ((*obj.include)[19]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I20;\
      before = true; \
     } \
    if ((*obj.include)[20]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I21;\
      before = true; \
     } \
    if ((*obj.include)[21]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I22;\
     } \
        (void)before;\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_cus_field_list<Manip>& obj)\
	{\
		bool before = false;\
    if ((*obj.include)[0]) { \
      s << obj.manip << '`' << obj.obj->names[0] << '`';\
      before = true; \
     } \
    if ((*obj.include)[1]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[1] << '`';\
      before = true; \
     } \
    if ((*obj.include)[2]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[2] << '`';\
      before = true; \
     } \
    if ((*obj.include)[3]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[3] << '`';\
      before = true; \
     } \
    if ((*obj.include)[4]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[4] << '`';\
      before = true; \
     } \
    if ((*obj.include)[5]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[5] << '`';\
      before = true; \
     } \
    if ((*obj.include)[6]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[6] << '`';\
      before = true; \
     } \
    if ((*obj.include)[7]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[7] << '`';\
      before = true; \
     } \
    if ((*obj.include)[8]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[8] << '`';\
      before = true; \
     } \
    if ((*obj.include)[9]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[9] << '`';\
      before = true; \
     } \
    if ((*obj.include)[10]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[10] << '`';\
      before = true; \
     } \
    if ((*obj.include)[11]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[11] << '`';\
      before = true; \
     } \
    if ((*obj.include)[12]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[12] << '`';\
      before = true; \
     } \
    if ((*obj.include)[13]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[13] << '`';\
      before = true; \
     } \
    if ((*obj.include)[14]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[14] << '`';\
      before = true; \
     } \
    if ((*obj.include)[15]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[15] << '`';\
      before = true; \
     } \
    if ((*obj.include)[16]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[16] << '`';\
      before = true; \
     } \
    if ((*obj.include)[17]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[17] << '`';\
      before = true; \
     } \
    if ((*obj.include)[18]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[18] << '`';\
      before = true; \
     } \
    if ((*obj.include)[19]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[19] << '`';\
      before = true; \
     } \
    if ((*obj.include)[20]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[20] << '`';\
      before = true; \
     } \
    if ((*obj.include)[21]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[21] << '`';\
     } \
        (void)before;\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_cus_equal_list<Manip>& obj)\
	{\
		bool before = false;\
    if ((*obj.include)[0]) { \
      s << '`' << obj.obj->names[0] << '`' << obj.comp << obj.manip << obj.obj->I1;\
      before = true; \
     } \
    if ((*obj.include)[1]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[1] << '`' << obj.comp << obj.manip << obj.obj->I2;\
      before = true; \
     } \
    if ((*obj.include)[2]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[2] << '`' << obj.comp << obj.manip << obj.obj->I3;\
      before = true; \
     } \
    if ((*obj.include)[3]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[3] << '`' << obj.comp << obj.manip << obj.obj->I4;\
      before = true; \
     } \
    if ((*obj.include)[4]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[4] << '`' << obj.comp << obj.manip << obj.obj->I5;\
      before = true; \
     } \
    if ((*obj.include)[5]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[5] << '`' << obj.comp << obj.manip << obj.obj->I6;\
      before = true; \
     } \
    if ((*obj.include)[6]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[6] << '`' << obj.comp << obj.manip << obj.obj->I7;\
      before = true; \
     } \
    if ((*obj.include)[7]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[7] << '`' << obj.comp << obj.manip << obj.obj->I8;\
      before = true; \
     } \
    if ((*obj.include)[8]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[8] << '`' << obj.comp << obj.manip << obj.obj->I9;\
      before = true; \
     } \
    if ((*obj.include)[9]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[9] << '`' << obj.comp << obj.manip << obj.obj->I10;\
      before = true; \
     } \
    if ((*obj.include)[10]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[10] << '`' << obj.comp << obj.manip << obj.obj->I11;\
      before = true; \
     } \
    if ((*obj.include)[11]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[11] << '`' << obj.comp << obj.manip << obj.obj->I12;\
      before = true; \
     } \
    if ((*obj.include)[12]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[12] << '`' << obj.comp << obj.manip << obj.obj->I13;\
      before = true; \
     } \
    if ((*obj.include)[13]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[13] << '`' << obj.comp << obj.manip << obj.obj->I14;\
      before = true; \
     } \
    if ((*obj.include)[14]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[14] << '`' << obj.comp << obj.manip << obj.obj->I15;\
      before = true; \
     } \
    if ((*obj.include)[15]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[15] << '`' << obj.comp << obj.manip << obj.obj->I16;\
      before = true; \
     } \
    if ((*obj.include)[16]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[16] << '`' << obj.comp << obj.manip << obj.obj->I17;\
      before = true; \
     } \
    if ((*obj.include)[17]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[17] << '`' << obj.comp << obj.manip << obj.obj->I18;\
      before = true; \
     } \
    if ((*obj.include)[18]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[18] << '`' << obj.comp << obj.manip << obj.obj->I19;\
      before = true; \
     } \
    if ((*obj.include)[19]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[19] << '`' << obj.comp << obj.manip << obj.obj->I20;\
      before = true; \
     } \
    if ((*obj.include)[20]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[20] << '`' << obj.comp << obj.manip << obj.obj->I21;\
      before = true; \
     } \
    if ((*obj.include)[21]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[21] << '`' << obj.comp << obj.manip << obj.obj->I22;\
     } \
        (void)before;\
		return s;\
	}\
	template <class Manip>\
	inline NAME##_value_list<Manip> NAME::value_list(const char* d, Manip m) const\
			{ return NAME##_value_list<Manip> (this, d, m); } \
	template <class Manip>\
	inline NAME##_field_list<Manip> NAME::field_list(const char* d, Manip m) const\
			{ return NAME##_field_list<Manip> (this, d, m); } \
	template <class Manip>\
	inline NAME##_equal_list<Manip> NAME::equal_list(const char* d, const char* c, Manip m) const\
			{ return NAME##_equal_list<Manip> (this, d, c, m); } \
	template <class Manip>\
	inline NAME##_cus_value_list<Manip> NAME::value_list(const char* d, Manip m,\
			bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13, bool i14, bool i15, bool i16, bool i17, bool i18, bool i19, bool i20, bool i21, bool i22) const\
			{ return NAME##_cus_value_list<Manip> (this, d, m, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20, i21, i22); }\
	template <class Manip>\
	inline NAME##_cus_field_list<Manip> NAME::field_list(const char* d, Manip m,\
			bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13, bool i14, bool i15, bool i16, bool i17, bool i18, bool i19, bool i20, bool i21, bool i22) const\
			{ return NAME##_cus_field_list<Manip> (this, d, m, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20, i21, i22); }\
	template <class Manip>\
	inline NAME##_cus_equal_list<Manip> NAME::equal_list(const char* d, const char* c, Manip m,\
			bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13, bool i14, bool i15, bool i16, bool i17, bool i18, bool i19, bool i20, bool i21, bool i22) const\
			{ return NAME##_cus_equal_list<Manip> (this, d, c, m, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20, i21, i22); } \
	template <class Manip>\
	inline NAME##_cus_value_list<Manip> NAME::value_list(const char* d, Manip m,\
			NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13, NAME##_enum i14, NAME##_enum i15, NAME##_enum i16, NAME##_enum i17, NAME##_enum i18, NAME##_enum i19, NAME##_enum i20, NAME##_enum i21, NAME##_enum i22) const\
			{ return NAME##_cus_value_list<Manip> (this, d, m, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20, i21, i22); } \
	template <class Manip>\
	inline NAME##_cus_field_list<Manip> NAME::field_list(const char* d, Manip m,\
			NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13, NAME##_enum i14, NAME##_enum i15, NAME##_enum i16, NAME##_enum i17, NAME##_enum i18, NAME##_enum i19, NAME##_enum i20, NAME##_enum i21, NAME##_enum i22) const\
			{ return NAME##_cus_field_list<Manip> (this, d, m, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20, i21, i22); } \
	template <class Manip>\
	inline NAME##_cus_equal_list<Manip> NAME::equal_list(const char* d, const char* c, Manip m, \
			NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13, NAME##_enum i14, NAME##_enum i15, NAME##_enum i16, NAME##_enum i17, NAME##_enum i18, NAME##_enum i19, NAME##_enum i20, NAME##_enum i21, NAME##_enum i22) const\
			{ return NAME##_cus_equal_list<Manip> (this, d, c, m, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20, i21, i22); } \
	template <class Manip>\
	inline NAME##_cus_value_list<Manip> NAME::value_list(const char* d, Manip m,\
			std::vector<bool> *i) const\
			{ return NAME##_cus_value_list<Manip> (this, d, m, i); }\
	template <class Manip>\
	inline NAME##_cus_field_list<Manip> NAME::field_list(const char* d, Manip m,\
			std::vector<bool> *i) const\
			{ return NAME##_cus_field_list<Manip> (this, d, m, i); }\
	template <class Manip>\
	inline NAME##_cus_equal_list<Manip> NAME::equal_list(const char* d, const char* c, Manip m,\
			std::vector<bool> *i) const\
			{ return NAME##_cus_equal_list<Manip> (this, d, c, m, i); }\
	template <class Manip>\
	inline NAME##_cus_value_list<Manip> \
	NAME::value_list(const char* d, Manip m, mysqlpp::sql_cmp_type /*sc*/) const\
			{ sql_compare_type_def_##CMP(NAME, value, NUM); }\
	template <class Manip>\
	inline NAME##_cus_field_list<Manip> \
	NAME::field_list(const char* d, Manip m, mysqlpp::sql_cmp_type /*sc*/) const\
			{ sql_compare_type_def_##CMP(NAME, field, NUM); }\
	template <class Manip>\
	inline NAME##_cus_equal_list<Manip> \
	NAME::equal_list(const char* d, const char* c, Manip m, mysqlpp::sql_cmp_type /*sc*/) const\
			{ sql_compare_type_defe_##CMP(NAME, equal, NUM); }\
	template <mysqlpp::sql_dummy_type dummy>\
	void populate_##NAME(NAME *s, const mysqlpp::Row &row)\
	{\
		mysqlpp::NoExceptions ignore_schema_mismatches(row);\
    s->I1 = row[N1].conv(T1());\
    s->I2 = row[N2].conv(T2());\
    s->I3 = row[N3].conv(T3());\
    s->I4 = row[N4].conv(T4());\
    s->I5 = row[N5].conv(T5());\
    s->I6 = row[N6].conv(T6());\
    s->I7 = row[N7].conv(T7());\
    s->I8 = row[N8].conv(T8());\
    s->I9 = row[N9].conv(T9());\
    s->I10 = row[N10].conv(T10());\
    s->I11 = row[N11].conv(T11());\
    s->I12 = row[N12].conv(T12());\
    s->I13 = row[N13].conv(T13());\
    s->I14 = row[N14].conv(T14());\
    s->I15 = row[N15].conv(T15());\
    s->I16 = row[N16].conv(T16());\
    s->I17 = row[N17].conv(T17());\
    s->I18 = row[N18].conv(T18());\
    s->I19 = row[N19].conv(T19());\
    s->I20 = row[N20].conv(T20());\
    s->I21 = row[N21].conv(T21());\
    s->I22 = row[N22].conv(T22());\
	}\
	inline NAME::NAME(const mysqlpp::Row& row) :\
	table_override_(0)\
			{ populate_##NAME<mysqlpp::sql_dummy>(this, row); }\
	inline void NAME::set(const mysqlpp::Row& row)\
	{\
		table_override_ = 0;\
		populate_##NAME<mysqlpp::sql_dummy>(this, row);\
	}\
	sql_COMPARE__##CMP(NAME, I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, I17, I18, I19, I20, I21, I22, 0, 0, 0 )

#define sql_create_22(NAME, CMP, CONTR, T1, I1, T2, I2, T3, I3, T4, I4, T5, I5, T6, I6, T7, I7, T8, I8, T9, I9, T10, I10, T11, I11, T12, I12, T13, I13, T14, I14, T15, I15, T16, I16, T17, I17, T18, I18, T19, I19, T20, I20, T21, I21, T22, I22) \
		sql_create_complete_22(NAME, CMP, CONTR, T1, I1, #I1, T2, I2, #I2, T3, I3, #I3, T4, I4, #I4, T5, I5, #I5, T6, I6, #I6, T7, I7, #I7, T8, I8, #I8, T9, I9, #I9, T10, I10, #I10, T11, I11, #I11, T12, I12, #I12, T13, I13, #I13, T14, I14, #I14, T15, I15, #I15, T16, I16, #I16, T17, I17, #I17, T18, I18, #I18, T19, I19, #I19, T20, I20, #I20, T21, I21, #I21, T22, I22, #I22) \

// ---------------------------------------------------
//                  End Create 22
// ---------------------------------------------------

// ---------------------------------------------------
//                  Begin Create 23
// ---------------------------------------------------
#define sql_create_complete_23(NAME, CMP, CONTR, T1, I1, N1, T2, I2, N2, T3, I3, N3, T4, I4, N4, T5, I5, N5, T6, I6, N6, T7, I7, N7, T8, I8, N8, T9, I9, N9, T10, I10, N10, T11, I11, N11, T12, I12, N12, T13, I13, N13, T14, I14, N14, T15, I15, N15, T16, I16, N16, T17, I17, N17, T18, I18, N18, T19, I19, N19, T20, I20, N20, T21, I21, N21, T22, I22, N22, T23, I23, N23) \
	struct NAME; \
	enum NAME##_enum { \
    NAME##_##I1,\
    NAME##_##I2,\
    NAME##_##I3,\
    NAME##_##I4,\
    NAME##_##I5,\
    NAME##_##I6,\
    NAME##_##I7,\
    NAME##_##I8,\
    NAME##_##I9,\
    NAME##_##I10,\
    NAME##_##I11,\
    NAME##_##I12,\
    NAME##_##I13,\
    NAME##_##I14,\
    NAME##_##I15,\
    NAME##_##I16,\
    NAME##_##I17,\
    NAME##_##I18,\
    NAME##_##I19,\
    NAME##_##I20,\
    NAME##_##I21,\
    NAME##_##I22,\
    NAME##_##I23 \
	,NAME##_NULL \
	}; \
	template <class Manip>\
	class NAME##_value_list { \
	public: \
	const NAME* obj;\
	const char* delim;\
	Manip manip;\
	public: \
	NAME##_value_list (const NAME* o, const char* d, Manip m) :\
	obj(o), delim(d), manip(m) { } \
	};\
	template <class Manip>\
	class NAME##_##field_list {\
	public: \
	const NAME* obj; \
	const char* delim;\
	Manip manip;\
	public: \
	NAME##_field_list (const NAME* o, const char* d, Manip m) :\
	obj(o), delim(d), manip(m) { } \
	};\
	template <class Manip>\
	class NAME##_equal_list { \
	public: \
	const NAME* obj;\
	const char* delim;\
	const char* comp;\
	Manip manip;\
	public: \
	NAME##_equal_list (const NAME* o, const char* d, const char* c, Manip m) :\
	obj(o), delim(d), comp(c), manip(m) { }\
	};\
	template <class Manip>\
	class NAME##_cus_value_list {\
	public:\
	const NAME* obj;\
	std::vector<bool> *include;\
	bool del_vector;\
	const char* delim;\
	Manip manip;\
	public: \
	~NAME##_cus_value_list () {if (del_vector) delete include;} \
	NAME##_cus_value_list (const NAME* o, const char* d, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13, bool i14, bool i15, bool i16, bool i17, bool i18, bool i19, bool i20, bool i21, bool i22, bool i23);\
	NAME##_cus_value_list (const NAME* o, const char* d, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13, NAME##_enum i14, NAME##_enum i15, NAME##_enum i16, NAME##_enum i17, NAME##_enum i18, NAME##_enum i19, NAME##_enum i20, NAME##_enum i21, NAME##_enum i22, NAME##_enum i23); \
	NAME##_cus_value_list (const NAME* o, const char* d, Manip m ,std::vector<bool>* i) :\
	obj(o), include(i), del_vector(false), delim(d), manip(m) { }\
	};\
	template <class Manip>\
	class NAME##_cus_field_list { \
	public:\
	const NAME* obj; \
	std::vector<bool> *include; \
	bool del_vector; \
	const char* delim;\
	Manip manip;\
	public: \
	~NAME##_cus_field_list () {if (del_vector) delete include;} \
	NAME##_cus_field_list (const NAME* o, const char* d, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13, bool i14, bool i15, bool i16, bool i17, bool i18, bool i19, bool i20, bool i21, bool i22, bool i23); \
	NAME##_cus_field_list (const NAME* o, const char* d, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13, NAME##_enum i14, NAME##_enum i15, NAME##_enum i16, NAME##_enum i17, NAME##_enum i18, NAME##_enum i19, NAME##_enum i20, NAME##_enum i21, NAME##_enum i22, NAME##_enum i23); \
	NAME##_cus_field_list (const NAME* o, const char* d, Manip m, std::vector<bool> *i) :\
	obj(o), include(i), del_vector(false), delim(d), manip(m) { }\
	};\
	template <class Manip>\
	class NAME##_cus_equal_list {\
	public:\
	const NAME* obj;\
	std::vector<bool> *include;\
	bool del_vector;\
	const char* delim;\
	const char* comp;\
	Manip manip;\
	public:\
	~NAME##_##cus_equal_list () {if (del_vector) delete include;}\
	NAME##_##cus_equal_list (const NAME* o, const char* d, const char* c, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13, bool i14, bool i15, bool i16, bool i17, bool i18, bool i19, bool i20, bool i21, bool i22, bool i23); \
	NAME##_##cus_equal_list (const NAME* o, const char* d, const char* c, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13, NAME##_enum i14, NAME##_enum i15, NAME##_enum i16, NAME##_enum i17, NAME##_enum i18, NAME##_enum i19, NAME##_enum i20, NAME##_enum i21, NAME##_enum i22, NAME##_enum i23); \
	NAME##_##cus_equal_list (const NAME* o, const char* d, const char* c, Manip m, std::vector<bool> *i) :\
	obj(o), include(i), del_vector(false), delim(d), comp(c), manip(m) { }\
	};\
	template <mysqlpp::sql_dummy_type dummy> int sql_compare_##NAME(const NAME&, const NAME&);\
	struct NAME {\
    T1 I1;\
    T2 I2;\
    T3 I3;\
    T4 I4;\
    T5 I5;\
    T6 I6;\
    T7 I7;\
    T8 I8;\
    T9 I9;\
    T10 I10;\
    T11 I11;\
    T12 I12;\
    T13 I13;\
    T14 I14;\
    T15 I15;\
    T16 I16;\
    T17 I17;\
    T18 I18;\
    T19 I19;\
    T20 I20;\
    T21 I21;\
    T22 I22;\
    T23 I23; \
	NAME() : table_override_(0) { }\
	NAME(const mysqlpp::Row& row);\
	void set(const mysqlpp::Row &row);\
	sql_compare_define_##CMP(NAME, T1, I1, T2, I2, T3, I3, T4, I4, T5, I5, T6, I6, T7, I7, T8, I8, T9, I9, T10, I10, T11, I11, T12, I12, T13, I13, T14, I14, T15, I15, T16, I16, T17, I17, T18, I18, T19, I19, T20, I20, T21, I21, T22, I22, T23, I23, 0, 0, 0, 0)\
	sql_construct_define_##CONTR(NAME, T1, I1, T2, I2, T3, I3, T4, I4, T5, I5, T6, I6, T7, I7, T8, I8, T9, I9, T10, I10, T11, I11, T12, I12, T13, I13, T14, I14, T15, I15, T16, I16, T17, I17, T18, I18, T19, I19, T20, I20, T21, I21, T22, I22, T23, I23, 0, 0, 0, 0)\
	static const char* names[];\
	static void table(const char* t) { table_ = t; }\
	const char* table() const\
			{ return table_override_ ? table_override_ : NAME::table_; }\
	void instance_table(const char* t) { table_override_ = t; }\
	NAME##_value_list<mysqlpp::quote_type0> value_list() const {\
		return value_list(",", mysqlpp::quote);}\
	NAME##_value_list<mysqlpp::quote_type0> value_list(const char* d) const {\
		return value_list(d, mysqlpp::quote);}\
	template <class Manip>\
	NAME##_value_list<Manip> value_list(const char* d, Manip m) const;\
	NAME##_field_list<mysqlpp::do_nothing_type0> field_list() const {\
		return field_list(",", mysqlpp::do_nothing);}\
	NAME##_field_list<mysqlpp::do_nothing_type0> field_list(const char* d) const {\
		return field_list(d, mysqlpp::do_nothing);}\
	template <class Manip>\
	NAME##_field_list<Manip> field_list(const char* d, Manip m) const;\
	NAME##_equal_list<mysqlpp::quote_type0> equal_list(const char* d = ",",\
			const char* c = " = ") const\
			{ return equal_list(d, c, mysqlpp::quote); }\
	template <class Manip>\
	NAME##_equal_list<Manip> equal_list(const char* d, const char* c, Manip m) const;\
	/* cus_data */\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false, bool i15 = false, bool i16 = false, bool i17 = false, bool i18 = false, bool i19 = false, bool i20 = false, bool i21 = false, bool i22 = false, bool i23 = false) const\
			{ return value_list(",", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20, i21, i22, i23); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL, NAME##_enum i15 = NAME##_NULL, NAME##_enum i16 = NAME##_NULL, NAME##_enum i17 = NAME##_NULL, NAME##_enum i18 = NAME##_NULL, NAME##_enum i19 = NAME##_NULL, NAME##_enum i20 = NAME##_NULL, NAME##_enum i21 = NAME##_NULL, NAME##_enum i22 = NAME##_NULL, NAME##_enum i23 = NAME##_NULL) const\
			{ return value_list(",", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20, i21, i22, i23); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(std::vector<bool> *i) const\
			{ return value_list(",", mysqlpp::quote, i); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(mysqlpp::sql_cmp_type sc) const\
			{ return value_list(",", mysqlpp::quote, sc); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(const char* d, bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false, bool i15 = false, bool i16 = false, bool i17 = false, bool i18 = false, bool i19 = false, bool i20 = false, bool i21 = false, bool i22 = false, bool i23 = false) const\
			{ return value_list(d, mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20, i21, i22, i23); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(const char* d, NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL, NAME##_enum i15 = NAME##_NULL, NAME##_enum i16 = NAME##_NULL, NAME##_enum i17 = NAME##_NULL, NAME##_enum i18 = NAME##_NULL, NAME##_enum i19 = NAME##_NULL, NAME##_enum i20 = NAME##_NULL, NAME##_enum i21 = NAME##_NULL, NAME##_enum i22 = NAME##_NULL, NAME##_enum i23 = NAME##_NULL) const\
			{ return value_list(d, mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20, i21, i22, i23); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(const char* d,\
			std::vector<bool> *i) const\
			{ return value_list(d, mysqlpp::quote, i); }\
	NAME##_cus_value_list<mysqlpp::quote_type0> value_list(const char* d,\
			mysqlpp::sql_cmp_type sc) const\
			{ return value_list(d, mysqlpp::quote, sc); }\
	template <class Manip>\
	NAME##_cus_value_list<Manip> value_list(const char* d, Manip m,\
			bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false, bool i15 = false, bool i16 = false, bool i17 = false, bool i18 = false, bool i19 = false, bool i20 = false, bool i21 = false, bool i22 = false, bool i23 = false) const;\
	template <class Manip>\
	NAME##_cus_value_list<Manip> value_list(const char* d, Manip m,\
			NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL, NAME##_enum i15 = NAME##_NULL, NAME##_enum i16 = NAME##_NULL, NAME##_enum i17 = NAME##_NULL, NAME##_enum i18 = NAME##_NULL, NAME##_enum i19 = NAME##_NULL, NAME##_enum i20 = NAME##_NULL, NAME##_enum i21 = NAME##_NULL, NAME##_enum i22 = NAME##_NULL, NAME##_enum i23 = NAME##_NULL) const;\
	template <class Manip>\
	NAME##_cus_value_list<Manip> value_list(const char* d, Manip m,\
			std::vector<bool>* i) const;\
	template <class Manip>\
	NAME##_cus_value_list<Manip> value_list(const char* d, Manip m, \
			mysqlpp::sql_cmp_type sc) const;\
	/* cus field */\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false, bool i15 = false, bool i16 = false, bool i17 = false, bool i18 = false, bool i19 = false, bool i20 = false, bool i21 = false, bool i22 = false, bool i23 = false) const \
			{ return field_list(",", mysqlpp::do_nothing, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20, i21, i22, i23); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL, NAME##_enum i15 = NAME##_NULL, NAME##_enum i16 = NAME##_NULL, NAME##_enum i17 = NAME##_NULL, NAME##_enum i18 = NAME##_NULL, NAME##_enum i19 = NAME##_NULL, NAME##_enum i20 = NAME##_NULL, NAME##_enum i21 = NAME##_NULL, NAME##_enum i22 = NAME##_NULL, NAME##_enum i23 = NAME##_NULL) const\
			{ return field_list(",", mysqlpp::do_nothing, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20, i21, i22, i23); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(std::vector<bool> *i) const\
			{ return field_list(",", mysqlpp::do_nothing, i); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(mysqlpp::sql_cmp_type sc) const\
			{ return field_list(",", mysqlpp::do_nothing, sc); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(const char* d,\
			bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false, bool i15 = false, bool i16 = false, bool i17 = false, bool i18 = false, bool i19 = false, bool i20 = false, bool i21 = false, bool i22 = false, bool i23 = false) const\
			{ return field_list(d, mysqlpp::do_nothing, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20, i21, i22, i23); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(const char* d,\
			NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL, NAME##_enum i15 = NAME##_NULL, NAME##_enum i16 = NAME##_NULL, NAME##_enum i17 = NAME##_NULL, NAME##_enum i18 = NAME##_NULL, NAME##_enum i19 = NAME##_NULL, NAME##_enum i20 = NAME##_NULL, NAME##_enum i21 = NAME##_NULL, NAME##_enum i22 = NAME##_NULL, NAME##_enum i23 = NAME##_NULL) const\
			{ return field_list(d, mysqlpp::do_nothing, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20, i21, i22, i23); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(const char* d,\
			std::vector<bool>* i) const\
			{ return field_list(d, mysqlpp::do_nothing, i); }\
	NAME##_cus_field_list<mysqlpp::do_nothing_type0> field_list(const char* d,\
			mysqlpp::sql_cmp_type sc) const\
			{ return field_list(d, mysqlpp::do_nothing, sc); }\
	template <class Manip>\
	NAME##_cus_field_list<Manip> field_list(const char* d, Manip m,\
			bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false, bool i15 = false, bool i16 = false, bool i17 = false, bool i18 = false, bool i19 = false, bool i20 = false, bool i21 = false, bool i22 = false, bool i23 = false) const;\
	template <class Manip>\
	NAME##_cus_field_list<Manip> field_list(const char* d, Manip m,\
			NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL, NAME##_enum i15 = NAME##_NULL, NAME##_enum i16 = NAME##_NULL, NAME##_enum i17 = NAME##_NULL, NAME##_enum i18 = NAME##_NULL, NAME##_enum i19 = NAME##_NULL, NAME##_enum i20 = NAME##_NULL, NAME##_enum i21 = NAME##_NULL, NAME##_enum i22 = NAME##_NULL, NAME##_enum i23 = NAME##_NULL) const;\
	template <class Manip>\
	NAME##_cus_field_list<Manip> field_list(const char* d, Manip m,\
			std::vector<bool> *i) const;\
	template <class Manip>\
	NAME##_cus_field_list<Manip> field_list(const char* d, Manip m,\
			mysqlpp::sql_cmp_type sc) const;\
	/* cus equal */\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false, bool i15 = false, bool i16 = false, bool i17 = false, bool i18 = false, bool i19 = false, bool i20 = false, bool i21 = false, bool i22 = false, bool i23 = false) const\
			{ return equal_list(",", " = ", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20, i21, i22, i23); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL, NAME##_enum i15 = NAME##_NULL, NAME##_enum i16 = NAME##_NULL, NAME##_enum i17 = NAME##_NULL, NAME##_enum i18 = NAME##_NULL, NAME##_enum i19 = NAME##_NULL, NAME##_enum i20 = NAME##_NULL, NAME##_enum i21 = NAME##_NULL, NAME##_enum i22 = NAME##_NULL, NAME##_enum i23 = NAME##_NULL) const\
			{ return equal_list(",", " = ", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20, i21, i22, i23); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(std::vector<bool>* i) const\
			{ return equal_list(",", " = ", mysqlpp::quote, i); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(mysqlpp::sql_cmp_type sc) const\
			{ return equal_list(",", " = ", mysqlpp::quote, sc); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false, bool i15 = false, bool i16 = false, bool i17 = false, bool i18 = false, bool i19 = false, bool i20 = false, bool i21 = false, bool i22 = false, bool i23 = false) const\
			{ return equal_list(d, " = ", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20, i21, i22, i23); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL, NAME##_enum i15 = NAME##_NULL, NAME##_enum i16 = NAME##_NULL, NAME##_enum i17 = NAME##_NULL, NAME##_enum i18 = NAME##_NULL, NAME##_enum i19 = NAME##_NULL, NAME##_enum i20 = NAME##_NULL, NAME##_enum i21 = NAME##_NULL, NAME##_enum i22 = NAME##_NULL, NAME##_enum i23 = NAME##_NULL) const\
			{ return equal_list(d, " = ", mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20, i21, i22, i23); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d,\
			std::vector<bool> *i) const\
			{ return equal_list(d, " = ", mysqlpp::quote, i); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d,\
			mysqlpp::sql_cmp_type sc) const\
			{ return equal_list(d, " = ", mysqlpp::quote, sc); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, const char* c,\
			bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false, bool i15 = false, bool i16 = false, bool i17 = false, bool i18 = false, bool i19 = false, bool i20 = false, bool i21 = false, bool i22 = false, bool i23 = false) const\
			{ return equal_list(d, c, mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20, i21, i22, i23); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, const char* c,\
			NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL, NAME##_enum i15 = NAME##_NULL, NAME##_enum i16 = NAME##_NULL, NAME##_enum i17 = NAME##_NULL, NAME##_enum i18 = NAME##_NULL, NAME##_enum i19 = NAME##_NULL, NAME##_enum i20 = NAME##_NULL, NAME##_enum i21 = NAME##_NULL, NAME##_enum i22 = NAME##_NULL, NAME##_enum i23 = NAME##_NULL) const\
			{ return equal_list(d, c, mysqlpp::quote, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20, i21, i22, i23); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, const char* c,\
			std::vector<bool> *i) const\
			{ return equal_list(d, c, mysqlpp::quote, i); }\
	NAME##_cus_equal_list<mysqlpp::quote_type0> equal_list(const char* d, const char* c,\
			mysqlpp::sql_cmp_type sc) const\
			{ return equal_list(d, c, mysqlpp::quote, sc); }\
	template <class Manip>\
	NAME##_cus_equal_list<Manip> equal_list(const char* d, const char* c, Manip m, \
						bool i1, bool i2 = false, bool i3 = false, bool i4 = false, bool i5 = false, bool i6 = false, bool i7 = false, bool i8 = false, bool i9 = false, bool i10 = false, bool i11 = false, bool i12 = false, bool i13 = false, bool i14 = false, bool i15 = false, bool i16 = false, bool i17 = false, bool i18 = false, bool i19 = false, bool i20 = false, bool i21 = false, bool i22 = false, bool i23 = false) const;\
	template <class Manip>\
	NAME##_cus_equal_list<Manip> equal_list(const char* d, const char* c, Manip m, \
						NAME##_enum i1, NAME##_enum i2 = NAME##_NULL, NAME##_enum i3 = NAME##_NULL, NAME##_enum i4 = NAME##_NULL, NAME##_enum i5 = NAME##_NULL, NAME##_enum i6 = NAME##_NULL, NAME##_enum i7 = NAME##_NULL, NAME##_enum i8 = NAME##_NULL, NAME##_enum i9 = NAME##_NULL, NAME##_enum i10 = NAME##_NULL, NAME##_enum i11 = NAME##_NULL, NAME##_enum i12 = NAME##_NULL, NAME##_enum i13 = NAME##_NULL, NAME##_enum i14 = NAME##_NULL, NAME##_enum i15 = NAME##_NULL, NAME##_enum i16 = NAME##_NULL, NAME##_enum i17 = NAME##_NULL, NAME##_enum i18 = NAME##_NULL, NAME##_enum i19 = NAME##_NULL, NAME##_enum i20 = NAME##_NULL, NAME##_enum i21 = NAME##_NULL, NAME##_enum i22 = NAME##_NULL, NAME##_enum i23 = NAME##_NULL) const;\
	template <class Manip>\
	NAME##_cus_equal_list<Manip> equal_list(const char* d, const char* c, Manip m, \
						std::vector<bool> *i) const;\
	template <class Manip>\
	NAME##_cus_equal_list<Manip> equal_list(const char* d, const char* c, Manip m, \
						mysqlpp::sql_cmp_type sc) const;\
	private:\
	static const char* table_;\
	const char* table_override_;\
	};\
	MYSQLPP_SSQLS_CONDITIONAL_STATICS(\
		const char* NAME::names[] = {\
			    N1 ,\
    N2 ,\
    N3 ,\
    N4 ,\
    N5 ,\
    N6 ,\
    N7 ,\
    N8 ,\
    N9 ,\
    N10 ,\
    N11 ,\
    N12 ,\
    N13 ,\
    N14 ,\
    N15 ,\
    N16 ,\
    N17 ,\
    N18 ,\
    N19 ,\
    N20 ,\
    N21 ,\
    N22 ,\
    N23 \
		};\
		const char* NAME::table_ = #NAME;\
	)\
	template <class Manip>\
	NAME##_cus_value_list<Manip>::NAME##_cus_value_list\
			(const NAME* o, const char* d, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13, bool i14, bool i15, bool i16, bool i17, bool i18, bool i19, bool i20, bool i21, bool i22, bool i23)\
	{\
		delim = d;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(23, false);\
    if (i1) (*include)[0]=true;\
    if (i2) (*include)[1]=true;\
    if (i3) (*include)[2]=true;\
    if (i4) (*include)[3]=true;\
    if (i5) (*include)[4]=true;\
    if (i6) (*include)[5]=true;\
    if (i7) (*include)[6]=true;\
    if (i8) (*include)[7]=true;\
    if (i9) (*include)[8]=true;\
    if (i10) (*include)[9]=true;\
    if (i11) (*include)[10]=true;\
    if (i12) (*include)[11]=true;\
    if (i13) (*include)[12]=true;\
    if (i14) (*include)[13]=true;\
    if (i15) (*include)[14]=true;\
    if (i16) (*include)[15]=true;\
    if (i17) (*include)[16]=true;\
    if (i18) (*include)[17]=true;\
    if (i19) (*include)[18]=true;\
    if (i20) (*include)[19]=true;\
    if (i21) (*include)[20]=true;\
    if (i22) (*include)[21]=true;\
    if (i23) (*include)[22]=true;\
	}\
	template <class Manip>\
	NAME##_cus_value_list<Manip>::NAME##_cus_value_list\
			(const NAME* o, const char* d, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13, NAME##_enum i14, NAME##_enum i15, NAME##_enum i16, NAME##_enum i17, NAME##_enum i18, NAME##_enum i19, NAME##_enum i20, NAME##_enum i21, NAME##_enum i22, NAME##_enum i23)\
	{\
		delim = d;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(23, false);\
    if (i1 == NAME##_NULL) return;\
    (*include)[i1]=true;\
    if (i2 == NAME##_NULL) return;\
    (*include)[i2]=true;\
    if (i3 == NAME##_NULL) return;\
    (*include)[i3]=true;\
    if (i4 == NAME##_NULL) return;\
    (*include)[i4]=true;\
    if (i5 == NAME##_NULL) return;\
    (*include)[i5]=true;\
    if (i6 == NAME##_NULL) return;\
    (*include)[i6]=true;\
    if (i7 == NAME##_NULL) return;\
    (*include)[i7]=true;\
    if (i8 == NAME##_NULL) return;\
    (*include)[i8]=true;\
    if (i9 == NAME##_NULL) return;\
    (*include)[i9]=true;\
    if (i10 == NAME##_NULL) return;\
    (*include)[i10]=true;\
    if (i11 == NAME##_NULL) return;\
    (*include)[i11]=true;\
    if (i12 == NAME##_NULL) return;\
    (*include)[i12]=true;\
    if (i13 == NAME##_NULL) return;\
    (*include)[i13]=true;\
    if (i14 == NAME##_NULL) return;\
    (*include)[i14]=true;\
    if (i15 == NAME##_NULL) return;\
    (*include)[i15]=true;\
    if (i16 == NAME##_NULL) return;\
    (*include)[i16]=true;\
    if (i17 == NAME##_NULL) return;\
    (*include)[i17]=true;\
    if (i18 == NAME##_NULL) return;\
    (*include)[i18]=true;\
    if (i19 == NAME##_NULL) return;\
    (*include)[i19]=true;\
    if (i20 == NAME##_NULL) return;\
    (*include)[i20]=true;\
    if (i21 == NAME##_NULL) return;\
    (*include)[i21]=true;\
    if (i22 == NAME##_NULL) return;\
    (*include)[i22]=true;\
    if (i23 == NAME##_NULL) return;\
    (*include)[i23]=true;\
	}\
	template <class Manip>\
	NAME##_cus_field_list<Manip>::NAME##_cus_field_list\
			(const NAME* o, const char* d, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13, bool i14, bool i15, bool i16, bool i17, bool i18, bool i19, bool i20, bool i21, bool i22, bool i23)\
	{\
		delim = d;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(23, false);\
    if (i1) (*include)[0]=true;\
    if (i2) (*include)[1]=true;\
    if (i3) (*include)[2]=true;\
    if (i4) (*include)[3]=true;\
    if (i5) (*include)[4]=true;\
    if (i6) (*include)[5]=true;\
    if (i7) (*include)[6]=true;\
    if (i8) (*include)[7]=true;\
    if (i9) (*include)[8]=true;\
    if (i10) (*include)[9]=true;\
    if (i11) (*include)[10]=true;\
    if (i12) (*include)[11]=true;\
    if (i13) (*include)[12]=true;\
    if (i14) (*include)[13]=true;\
    if (i15) (*include)[14]=true;\
    if (i16) (*include)[15]=true;\
    if (i17) (*include)[16]=true;\
    if (i18) (*include)[17]=true;\
    if (i19) (*include)[18]=true;\
    if (i20) (*include)[19]=true;\
    if (i21) (*include)[20]=true;\
    if (i22) (*include)[21]=true;\
    if (i23) (*include)[22]=true;\
	}\
	template <class Manip>\
	NAME##_cus_field_list<Manip>::NAME##_cus_field_list\
			(const NAME* o, const char* d, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13, NAME##_enum i14, NAME##_enum i15, NAME##_enum i16, NAME##_enum i17, NAME##_enum i18, NAME##_enum i19, NAME##_enum i20, NAME##_enum i21, NAME##_enum i22, NAME##_enum i23)\
	{\
		delim = d;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(23, false);\
    if (i1 == NAME##_NULL) return;\
    (*include)[i1]=true;\
    if (i2 == NAME##_NULL) return;\
    (*include)[i2]=true;\
    if (i3 == NAME##_NULL) return;\
    (*include)[i3]=true;\
    if (i4 == NAME##_NULL) return;\
    (*include)[i4]=true;\
    if (i5 == NAME##_NULL) return;\
    (*include)[i5]=true;\
    if (i6 == NAME##_NULL) return;\
    (*include)[i6]=true;\
    if (i7 == NAME##_NULL) return;\
    (*include)[i7]=true;\
    if (i8 == NAME##_NULL) return;\
    (*include)[i8]=true;\
    if (i9 == NAME##_NULL) return;\
    (*include)[i9]=true;\
    if (i10 == NAME##_NULL) return;\
    (*include)[i10]=true;\
    if (i11 == NAME##_NULL) return;\
    (*include)[i11]=true;\
    if (i12 == NAME##_NULL) return;\
    (*include)[i12]=true;\
    if (i13 == NAME##_NULL) return;\
    (*include)[i13]=true;\
    if (i14 == NAME##_NULL) return;\
    (*include)[i14]=true;\
    if (i15 == NAME##_NULL) return;\
    (*include)[i15]=true;\
    if (i16 == NAME##_NULL) return;\
    (*include)[i16]=true;\
    if (i17 == NAME##_NULL) return;\
    (*include)[i17]=true;\
    if (i18 == NAME##_NULL) return;\
    (*include)[i18]=true;\
    if (i19 == NAME##_NULL) return;\
    (*include)[i19]=true;\
    if (i20 == NAME##_NULL) return;\
    (*include)[i20]=true;\
    if (i21 == NAME##_NULL) return;\
    (*include)[i21]=true;\
    if (i22 == NAME##_NULL) return;\
    (*include)[i22]=true;\
    if (i23 == NAME##_NULL) return;\
    (*include)[i23]=true;\
	}\
	template <class Manip>\
	NAME##_cus_equal_list<Manip>::NAME##_cus_equal_list\
			(const NAME* o, const char* d, const char* c, Manip m, bool i1, bool i2, bool i3, bool i4, bool i5, bool i6, bool i7, bool i8, bool i9, bool i10, bool i11, bool i12, bool i13, bool i14, bool i15, bool i16, bool i17, bool i18, bool i19, bool i20, bool i21, bool i22, bool i23)\
	{\
		delim = d;\
		comp = c;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(23, false);\
    if (i1) (*include)[0]=true;\
    if (i2) (*include)[1]=true;\
    if (i3) (*include)[2]=true;\
    if (i4) (*include)[3]=true;\
    if (i5) (*include)[4]=true;\
    if (i6) (*include)[5]=true;\
    if (i7) (*include)[6]=true;\
    if (i8) (*include)[7]=true;\
    if (i9) (*include)[8]=true;\
    if (i10) (*include)[9]=true;\
    if (i11) (*include)[10]=true;\
    if (i12) (*include)[11]=true;\
    if (i13) (*include)[12]=true;\
    if (i14) (*include)[13]=true;\
    if (i15) (*include)[14]=true;\
    if (i16) (*include)[15]=true;\
    if (i17) (*include)[16]=true;\
    if (i18) (*include)[17]=true;\
    if (i19) (*include)[18]=true;\
    if (i20) (*include)[19]=true;\
    if (i21) (*include)[20]=true;\
    if (i22) (*include)[21]=true;\
    if (i23) (*include)[22]=true;\
	}\
	template <class Manip>\
	NAME##_cus_equal_list<Manip>::NAME##_cus_equal_list\
			(const NAME* o, const char* d, const char* c, Manip m, NAME##_enum i1, NAME##_enum i2, NAME##_enum i3, NAME##_enum i4, NAME##_enum i5, NAME##_enum i6, NAME##_enum i7, NAME##_enum i8, NAME##_enum i9, NAME##_enum i10, NAME##_enum i11, NAME##_enum i12, NAME##_enum i13, NAME##_enum i14, NAME##_enum i15, NAME##_enum i16, NAME##_enum i17, NAME##_enum i18, NAME##_enum i19, NAME##_enum i20, NAME##_enum i21, NAME##_enum i22, NAME##_enum i23)\
	{\
		delim = d;\
		comp = c;\
		manip = m;\
		del_vector = true;\
		obj = o;\
		include = new std::vector<bool>(23, false);\
    if (i1 == NAME##_NULL) return;\
    (*include)[i1]=true;\
    if (i2 == NAME##_NULL) return;\
    (*include)[i2]=true;\
    if (i3 == NAME##_NULL) return;\
    (*include)[i3]=true;\
    if (i4 == NAME##_NULL) return;\
    (*include)[i4]=true;\
    if (i5 == NAME##_NULL) return;\
    (*include)[i5]=true;\
    if (i6 == NAME##_NULL) return;\
    (*include)[i6]=true;\
    if (i7 == NAME##_NULL) return;\
    (*include)[i7]=true;\
    if (i8 == NAME##_NULL) return;\
    (*include)[i8]=true;\
    if (i9 == NAME##_NULL) return;\
    (*include)[i9]=true;\
    if (i10 == NAME##_NULL) return;\
    (*include)[i10]=true;\
    if (i11 == NAME##_NULL) return;\
    (*include)[i11]=true;\
    if (i12 == NAME##_NULL) return;\
    (*include)[i12]=true;\
    if (i13 == NAME##_NULL) return;\
    (*include)[i13]=true;\
    if (i14 == NAME##_NULL) return;\
    (*include)[i14]=true;\
    if (i15 == NAME##_NULL) return;\
    (*include)[i15]=true;\
    if (i16 == NAME##_NULL) return;\
    (*include)[i16]=true;\
    if (i17 == NAME##_NULL) return;\
    (*include)[i17]=true;\
    if (i18 == NAME##_NULL) return;\
    (*include)[i18]=true;\
    if (i19 == NAME##_NULL) return;\
    (*include)[i19]=true;\
    if (i20 == NAME##_NULL) return;\
    (*include)[i20]=true;\
    if (i21 == NAME##_NULL) return;\
    (*include)[i21]=true;\
    if (i22 == NAME##_NULL) return;\
    (*include)[i22]=true;\
    if (i23 == NAME##_NULL) return;\
    (*include)[i23]=true;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_value_list<Manip>& obj)\
	{\
    s << obj.manip << obj.obj->I1 << obj.delim;\
    s << obj.manip << obj.obj->I2 << obj.delim;\
    s << obj.manip << obj.obj->I3 << obj.delim;\
    s << obj.manip << obj.obj->I4 << obj.delim;\
    s << obj.manip << obj.obj->I5 << obj.delim;\
    s << obj.manip << obj.obj->I6 << obj.delim;\
    s << obj.manip << obj.obj->I7 << obj.delim;\
    s << obj.manip << obj.obj->I8 << obj.delim;\
    s << obj.manip << obj.obj->I9 << obj.delim;\
    s << obj.manip << obj.obj->I10 << obj.delim;\
    s << obj.manip << obj.obj->I11 << obj.delim;\
    s << obj.manip << obj.obj->I12 << obj.delim;\
    s << obj.manip << obj.obj->I13 << obj.delim;\
    s << obj.manip << obj.obj->I14 << obj.delim;\
    s << obj.manip << obj.obj->I15 << obj.delim;\
    s << obj.manip << obj.obj->I16 << obj.delim;\
    s << obj.manip << obj.obj->I17 << obj.delim;\
    s << obj.manip << obj.obj->I18 << obj.delim;\
    s << obj.manip << obj.obj->I19 << obj.delim;\
    s << obj.manip << obj.obj->I20 << obj.delim;\
    s << obj.manip << obj.obj->I21 << obj.delim;\
    s << obj.manip << obj.obj->I22 << obj.delim;\
    s << obj.manip << obj.obj->I23;\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_field_list<Manip>& obj)\
	{\
    s << obj.manip << '`' << obj.obj->names[0] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[1] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[2] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[3] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[4] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[5] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[6] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[7] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[8] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[9] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[10] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[11] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[12] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[13] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[14] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[15] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[16] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[17] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[18] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[19] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[20] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[21] << '`' << obj.delim;\
    s << obj.manip << '`' << obj.obj->names[22] << '`';\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_equal_list<Manip>& obj)\
	{\
    s << '`' << obj.obj->names[0] << '`' << obj.comp << obj.manip << obj.obj->I1 << obj.delim;\
    s << '`' << obj.obj->names[1] << '`' << obj.comp << obj.manip << obj.obj->I2 << obj.delim;\
    s << '`' << obj.obj->names[2] << '`' << obj.comp << obj.manip << obj.obj->I3 << obj.delim;\
    s << '`' << obj.obj->names[3] << '`' << obj.comp << obj.manip << obj.obj->I4 << obj.delim;\
    s << '`' << obj.obj->names[4] << '`' << obj.comp << obj.manip << obj.obj->I5 << obj.delim;\
    s << '`' << obj.obj->names[5] << '`' << obj.comp << obj.manip << obj.obj->I6 << obj.delim;\
    s << '`' << obj.obj->names[6] << '`' << obj.comp << obj.manip << obj.obj->I7 << obj.delim;\
    s << '`' << obj.obj->names[7] << '`' << obj.comp << obj.manip << obj.obj->I8 << obj.delim;\
    s << '`' << obj.obj->names[8] << '`' << obj.comp << obj.manip << obj.obj->I9 << obj.delim;\
    s << '`' << obj.obj->names[9] << '`' << obj.comp << obj.manip << obj.obj->I10 << obj.delim;\
    s << '`' << obj.obj->names[10] << '`' << obj.comp << obj.manip << obj.obj->I11 << obj.delim;\
    s << '`' << obj.obj->names[11] << '`' << obj.comp << obj.manip << obj.obj->I12 << obj.delim;\
    s << '`' << obj.obj->names[12] << '`' << obj.comp << obj.manip << obj.obj->I13 << obj.delim;\
    s << '`' << obj.obj->names[13] << '`' << obj.comp << obj.manip << obj.obj->I14 << obj.delim;\
    s << '`' << obj.obj->names[14] << '`' << obj.comp << obj.manip << obj.obj->I15 << obj.delim;\
    s << '`' << obj.obj->names[15] << '`' << obj.comp << obj.manip << obj.obj->I16 << obj.delim;\
    s << '`' << obj.obj->names[16] << '`' << obj.comp << obj.manip << obj.obj->I17 << obj.delim;\
    s << '`' << obj.obj->names[17] << '`' << obj.comp << obj.manip << obj.obj->I18 << obj.delim;\
    s << '`' << obj.obj->names[18] << '`' << obj.comp << obj.manip << obj.obj->I19 << obj.delim;\
    s << '`' << obj.obj->names[19] << '`' << obj.comp << obj.manip << obj.obj->I20 << obj.delim;\
    s << '`' << obj.obj->names[20] << '`' << obj.comp << obj.manip << obj.obj->I21 << obj.delim;\
    s << '`' << obj.obj->names[21] << '`' << obj.comp << obj.manip << obj.obj->I22 << obj.delim;\
    s << '`' << obj.obj->names[22] << '`' << obj.comp << obj.manip << obj.obj->I23;\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_cus_value_list<Manip>& obj)\
	{\
		bool before = false;\
    if ((*obj.include)[0]) { \
      s << obj.manip << obj.obj->I1;\
      before = true; \
     } \
    if ((*obj.include)[1]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I2;\
      before = true; \
     } \
    if ((*obj.include)[2]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I3;\
      before = true; \
     } \
    if ((*obj.include)[3]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I4;\
      before = true; \
     } \
    if ((*obj.include)[4]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I5;\
      before = true; \
     } \
    if ((*obj.include)[5]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I6;\
      before = true; \
     } \
    if ((*obj.include)[6]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I7;\
      before = true; \
     } \
    if ((*obj.include)[7]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I8;\
      before = true; \
     } \
    if ((*obj.include)[8]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I9;\
      before = true; \
     } \
    if ((*obj.include)[9]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I10;\
      before = true; \
     } \
    if ((*obj.include)[10]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I11;\
      before = true; \
     } \
    if ((*obj.include)[11]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I12;\
      before = true; \
     } \
    if ((*obj.include)[12]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I13;\
      before = true; \
     } \
    if ((*obj.include)[13]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I14;\
      before = true; \
     } \
    if ((*obj.include)[14]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I15;\
      before = true; \
     } \
    if ((*obj.include)[15]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I16;\
      before = true; \
     } \
    if ((*obj.include)[16]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I17;\
      before = true; \
     } \
    if ((*obj.include)[17]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I18;\
      before = true; \
     } \
    if ((*obj.include)[18]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I19;\
      before = true; \
     } \
    if ((*obj.include)[19]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I20;\
      before = true; \
     } \
    if ((*obj.include)[20]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I21;\
      before = true; \
     } \
    if ((*obj.include)[21]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I22;\
      before = true; \
     } \
    if ((*obj.include)[22]) { \
      if (before) s << obj.delim;\
      s << obj.manip << obj.obj->I23;\
     } \
        (void)before;\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_cus_field_list<Manip>& obj)\
	{\
		bool before = false;\
    if ((*obj.include)[0]) { \
      s << obj.manip << '`' << obj.obj->names[0] << '`';\
      before = true; \
     } \
    if ((*obj.include)[1]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[1] << '`';\
      before = true; \
     } \
    if ((*obj.include)[2]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[2] << '`';\
      before = true; \
     } \
    if ((*obj.include)[3]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[3] << '`';\
      before = true; \
     } \
    if ((*obj.include)[4]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[4] << '`';\
      before = true; \
     } \
    if ((*obj.include)[5]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[5] << '`';\
      before = true; \
     } \
    if ((*obj.include)[6]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[6] << '`';\
      before = true; \
     } \
    if ((*obj.include)[7]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[7] << '`';\
      before = true; \
     } \
    if ((*obj.include)[8]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[8] << '`';\
      before = true; \
     } \
    if ((*obj.include)[9]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[9] << '`';\
      before = true; \
     } \
    if ((*obj.include)[10]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[10] << '`';\
      before = true; \
     } \
    if ((*obj.include)[11]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[11] << '`';\
      before = true; \
     } \
    if ((*obj.include)[12]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[12] << '`';\
      before = true; \
     } \
    if ((*obj.include)[13]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[13] << '`';\
      before = true; \
     } \
    if ((*obj.include)[14]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[14] << '`';\
      before = true; \
     } \
    if ((*obj.include)[15]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[15] << '`';\
      before = true; \
     } \
    if ((*obj.include)[16]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[16] << '`';\
      before = true; \
     } \
    if ((*obj.include)[17]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[17] << '`';\
      before = true; \
     } \
    if ((*obj.include)[18]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[18] << '`';\
      before = true; \
     } \
    if ((*obj.include)[19]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[19] << '`';\
      before = true; \
     } \
    if ((*obj.include)[20]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[20] << '`';\
      before = true; \
     } \
    if ((*obj.include)[21]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[21] << '`';\
      before = true; \
     } \
    if ((*obj.include)[22]) { \
      if (before) s << obj.delim;\
      s << obj.manip << '`' << obj.obj->names[22] << '`';\
     } \
        (void)before;\
		return s;\
	}\
	template <class Manip>\
	std::ostream& operator <<(std::ostream& s, const NAME##_cus_equal_list<Manip>& obj)\
	{\
		bool before = false;\
    if ((*obj.include)[0]) { \
      s << '`' << obj.obj->names[0] << '`' << obj.comp << obj.manip << obj.obj->I1;\
      before = true; \
     } \
    if ((*obj.include)[1]) { \
      if (before) s << obj.delim;\
      s << '`' << obj.obj->names[1] << '`' << obj.comp << obj.manip << obj.obj->I2;\
      before = true; \
     } \
    if ((*obj.inc