/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool;

import java.io.IOException;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.lucene.analysis.core.LowerCaseFilterFactory;
import org.apache.lucene.analysis.core.WhitespaceTokenizerFactory;
import org.apache.lucene.analysis.custom.CustomAnalyzer;
import org.apache.lucene.analysis.miscellaneous.PerFieldAnalyzerWrapper;
import org.apache.lucene.analysis.standard.StandardAnalyzer;

public class LuceneDefaultAnalyzer {
    private static final Logger logger = LogManager.getLogger();

    private LuceneDefaultAnalyzer() {
    }

    private static Analyzer buildAnalyzer() {
        CustomAnalyzer analyzer;
        try {
            analyzer = CustomAnalyzer.builder().withTokenizer(WhitespaceTokenizerFactory.class, new String[0]).addTokenFilter(LowerCaseFilterFactory.class, new String[0]).build();
        }
        catch (IOException e) {
            logger.error("Could not build custom analyzer", (Throwable)e);
            logger.error("Falling back to standard analyzer");
            analyzer = new StandardAnalyzer();
        }
        return analyzer;
    }

    public static Analyzer buildPerFieldAnalyzer() {
        HashMap<String, KeywordAnalyzer> fieldMap = new HashMap<String, KeywordAnalyzer>();
        fieldMap.put("sender", new KeywordAnalyzer());
        return new PerFieldAnalyzerWrapper(LuceneDefaultAnalyzer.buildAnalyzer(), fieldMap);
    }
}

