/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image.publisher;

import java.util.Map;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.message.DescribeClusterResponseData;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.loader.LoaderManifest;
import org.apache.kafka.image.loader.LoaderManifestType;
import org.apache.kafka.image.publisher.MetadataPublisher;
import org.apache.kafka.metadata.ControllerRegistration;

public class ControllerRegistrationsPublisher
implements MetadataPublisher {
    private volatile Map<Integer, ControllerRegistration> controllers = Map.of();

    @Override
    public String name() {
        return "ControllerRegistrationsPublisher";
    }

    @Override
    public void onMetadataUpdate(MetadataDelta delta, MetadataImage newImage, LoaderManifest manifest) {
        if (manifest.type() == LoaderManifestType.LOG_DELTA || delta.clusterDelta() != null) {
            this.controllers = newImage.cluster().controllers();
        }
    }

    public DescribeClusterResponseData.DescribeClusterBrokerCollection describeClusterControllers(String endpointName) {
        DescribeClusterResponseData.DescribeClusterBrokerCollection results = new DescribeClusterResponseData.DescribeClusterBrokerCollection();
        for (ControllerRegistration registration : this.controllers.values()) {
            Endpoint endpoint = registration.listeners().get(endpointName);
            if (endpoint == null) continue;
            results.add((ImplicitLinkedHashCollection.Element)new DescribeClusterResponseData.DescribeClusterBroker().setBrokerId(registration.id()).setHost(endpoint.host()).setPort(endpoint.port()).setRack(null));
        }
        return results;
    }

    public Map<Integer, ControllerRegistration> controllers() {
        return this.controllers;
    }

    @Override
    public void close() {
    }
}

