/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.util;

import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.util.RelevantNodes;
import com.xmlcalabash.util.TreeWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.NamespaceReducer;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.TreeReceiver;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XPathExecutable;
import net.sf.saxon.s9api.XPathSelector;
import net.sf.saxon.s9api.XQueryCompiler;
import net.sf.saxon.s9api.XQueryEvaluator;
import net.sf.saxon.s9api.XQueryExecutable;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmNodeKind;
import net.sf.saxon.s9api.XdmSequenceIterator;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.NamespaceIterator;
import org.xml.sax.InputSource;

public class S9apiUtils {
    private static final QName vara = new QName("", "vara");
    private static final QName varb = new QName("", "varb");

    public static void writeXdmValue(XProcRuntime runtime, Vector<XdmValue> values, Destination destination, URI baseURI) throws SaxonApiException {
        S9apiUtils.writeXdmValue(runtime.getProcessor(), values, destination, baseURI);
    }

    public static void writeXdmValue(Processor proc, Vector<XdmValue> values, Destination destination, URI baseURI) throws SaxonApiException {
        try {
            Configuration config = proc.getUnderlyingConfiguration();
            PipelineConfiguration pipeConfig = config.makePipelineConfiguration();
            Receiver out = destination.getReceiver(config);
            out = new NamespaceReducer(out);
            TreeReceiver tree = new TreeReceiver(out);
            tree.setPipelineConfiguration(pipeConfig);
            if (baseURI != null) {
                tree.setSystemId(baseURI.toASCIIString());
            }
            tree.open();
            tree.startDocument(0);
            for (XdmValue value : values) {
                for (XdmItem item : value) {
                    tree.append((Item)item.getUnderlyingValue(), 0, 2);
                }
            }
            tree.endDocument();
            tree.close();
        }
        catch (XPathException err) {
            throw new SaxonApiException((Throwable)err);
        }
    }

    public static void writeXdmValue(XProcRuntime runtime, XdmItem node, Destination destination, URI baseURI) throws SaxonApiException {
        try {
            Processor proc = runtime.getProcessor();
            Configuration config = proc.getUnderlyingConfiguration();
            PipelineConfiguration pipeConfig = config.makePipelineConfiguration();
            Receiver out = destination.getReceiver(config);
            out = new NamespaceReducer(out);
            TreeReceiver tree = new TreeReceiver(out);
            tree.setPipelineConfiguration(pipeConfig);
            if (baseURI != null) {
                tree.setSystemId(baseURI.toASCIIString());
            }
            tree.open();
            tree.startDocument(0);
            tree.append((Item)node.getUnderlyingValue(), 0, 2);
            tree.endDocument();
            tree.close();
        }
        catch (XPathException err) {
            throw new SaxonApiException((Throwable)err);
        }
    }

    public static XdmNode getDocumentElement(XdmNode doc) {
        if (doc.getNodeKind() == XdmNodeKind.DOCUMENT) {
            for (XdmNode node : new RelevantNodes(doc, Axis.CHILD, true)) {
                if (node.getNodeKind() != XdmNodeKind.ELEMENT) continue;
                return node;
            }
            return null;
        }
        return doc;
    }

    public static void serialize(XProcRuntime xproc, XdmNode node, Serializer serializer) throws SaxonApiException {
        Vector<XdmNode> nodes = new Vector<XdmNode>();
        nodes.add(node);
        S9apiUtils.serialize(xproc, nodes, serializer);
    }

    public static void serialize(XProcRuntime xproc, Vector<XdmNode> nodes, Serializer serializer) throws SaxonApiException {
        Processor qtproc = xproc.getProcessor();
        XQueryCompiler xqcomp = qtproc.newXQueryCompiler();
        xqcomp.getUnderlyingStaticContext().setSchemaAware(xqcomp.getProcessor().getUnderlyingConfiguration().isLicensedFeature(4));
        XQueryExecutable xqexec = xqcomp.compile(".");
        XQueryEvaluator xqeval = xqexec.load();
        xqeval.setDestination((Destination)serializer);
        for (XdmNode node : nodes) {
            xqeval.setContextItem((XdmItem)node);
            xqeval.run();
            serializer.setOutputProperty(Serializer.Property.OMIT_XML_DECLARATION, "yes");
        }
    }

    public static boolean xpathEqual(Processor proc, XdmItem a, XdmItem b) {
        try {
            XPathCompiler c = proc.newXPathCompiler();
            c.declareVariable(vara);
            c.declareVariable(varb);
            XPathExecutable xexec = c.compile("$vara = $varb");
            XPathSelector selector = xexec.load();
            selector.setVariable(vara, (XdmValue)a);
            selector.setVariable(varb, (XdmValue)b);
            Iterator values = selector.iterator();
            XdmAtomicValue item = (XdmAtomicValue)values.next();
            boolean same = item.getBooleanValue();
            return same;
        }
        catch (SaxonApiException sae) {
            return false;
        }
    }

    public static InputSource xdmToInputSource(XProcRuntime runtime, XdmNode node) throws SaxonApiException {
        StringWriter sw = new StringWriter();
        Serializer serializer = new Serializer();
        serializer.setOutputWriter((Writer)sw);
        S9apiUtils.serialize(runtime, node, serializer);
        String serxml = sw.toString();
        StringReader sr = new StringReader(serxml);
        InputSource isource = new InputSource(sr);
        isource.setSystemId(node.getBaseURI().toASCIIString());
        return isource;
    }

    public static XdmNode removeNamespaces(XProcRuntime runtime, XdmNode node, HashSet<String> excludeNS, boolean preserveUsed) {
        return S9apiUtils.removeNamespaces(runtime.getProcessor(), node, excludeNS, preserveUsed);
    }

    public static XdmNode removeNamespaces(Processor proc, XdmNode node, HashSet<String> excludeNS, boolean preserveUsed) {
        TreeWriter tree = new TreeWriter(proc);
        tree.startDocument(node.getBaseURI());
        S9apiUtils.removeNamespacesWriter(tree, node, excludeNS, preserveUsed);
        tree.endDocument();
        return tree.getResult();
    }

    private static void removeNamespacesWriter(TreeWriter tree, XdmNode node, HashSet<String> excludeNS, boolean preserveUsed) {
        if (node.getNodeKind() == XdmNodeKind.DOCUMENT) {
            XdmSequenceIterator iter = node.axisIterator(Axis.CHILD);
            while (iter.hasNext()) {
                XdmNode cnode = (XdmNode)iter.next();
                S9apiUtils.removeNamespacesWriter(tree, cnode, excludeNS, preserveUsed);
            }
        } else if (node.getNodeKind() == XdmNodeKind.ELEMENT) {
            boolean usesDefaultNS = "".equals(node.getNodeName().getPrefix()) && !"".equals(node.getNodeName().getNamespaceURI());
            NodeInfo inode = node.getUnderlyingNode();
            NamePool pool = inode.getNamePool();
            int[] inscopeNS = NamespaceIterator.getInScopeNamespaceCodes((NodeInfo)inode);
            boolean excludeDefault = false;
            boolean changed = false;
            int[] newNS = null;
            if (inscopeNS.length > 0) {
                newNS = new int[inscopeNS.length];
                int newpos = 0;
                for (int pos = 0; pos < inscopeNS.length; ++pos) {
                    int ns = inscopeNS[pos];
                    String pfx = pool.getPrefixFromNamespaceCode(ns);
                    String uri = pool.getURIFromNamespaceCode(ns);
                    boolean delete = excludeNS.contains(uri);
                    boolean bl = excludeDefault = excludeDefault || "".equals(pfx) && delete;
                    if ("".equals(pfx) && usesDefaultNS && preserveUsed) {
                        delete = false;
                    }
                    boolean bl2 = changed = changed || delete;
                    if (delete) continue;
                    newNS[newpos++] = ns;
                }
                int[] onlyNewNS = new int[newpos];
                for (int pos = 0; pos < newpos; ++pos) {
                    onlyNewNS[pos] = newNS[pos];
                }
                newNS = onlyNewNS;
            }
            int nameCode = inode.getNameCode();
            int typeCode = inode.getTypeAnnotation() & 0xFFFFF;
            String pfx = pool.getPrefix(nameCode);
            String uri = pool.getURI(nameCode);
            if (preserveUsed) {
                if (excludeDefault && "".equals(pfx) && !usesDefaultNS) {
                    nameCode = pool.allocate("", "", pool.getLocalName(nameCode));
                }
            } else if (excludeNS.contains(uri)) {
                nameCode = pool.allocate("", "", pool.getLocalName(nameCode));
            }
            tree.addStartElement(nameCode, typeCode, newNS);
            if (!preserveUsed) {
                XdmSequenceIterator attriter = node.axisIterator(Axis.ATTRIBUTE);
                while (attriter.hasNext()) {
                    XdmNode attr = (XdmNode)attriter.next();
                    String attrns = attr.getNodeName().getNamespaceURI();
                    if (excludeNS.contains(attrns)) {
                        tree.addAttribute(new QName(attr.getNodeName().getLocalName()), attr.getStringValue());
                        continue;
                    }
                    tree.addAttribute(attr);
                }
            } else {
                tree.addAttributes(node);
            }
            XdmSequenceIterator iter = node.axisIterator(Axis.CHILD);
            while (iter.hasNext()) {
                XdmNode cnode = (XdmNode)iter.next();
                S9apiUtils.removeNamespacesWriter(tree, cnode, excludeNS, preserveUsed);
            }
            tree.addEndElement();
        } else {
            tree.addSubtree(node);
        }
    }

    public static void dumpTree(XdmNode tree, String message) {
        NodeInfo treeNode = tree.getUnderlyingNode();
        System.err.println(message);
        System.err.println("Dumping tree: " + treeNode.getSystemId() + ", " + tree.getBaseURI());
        XdmSequenceIterator iter = tree.axisIterator(Axis.CHILD);
        while (iter.hasNext()) {
            XdmNode child = (XdmNode)iter.next();
            S9apiUtils.dumpTreeNode(child, "  ");
        }
    }

    private static void dumpTreeNode(XdmNode node, String indent) {
        if (node.getNodeKind() == XdmNodeKind.ELEMENT) {
            System.err.println(indent + node.getNodeName() + ": " + node.getBaseURI());
            XdmSequenceIterator iter = node.axisIterator(Axis.CHILD);
            while (iter.hasNext()) {
                XdmNode child = (XdmNode)iter.next();
                S9apiUtils.dumpTreeNode(child, indent + "  ");
            }
        } else if (node.getNodeKind() == XdmNodeKind.TEXT) {
            System.err.println(indent + "text: ...");
        }
    }

    public static boolean xpathSyntaxError(SaxonApiException sae) {
        Throwable cause = sae.getCause();
        return cause != null && cause instanceof XPathException;
    }

    public static boolean isDocument(XdmNode doc) {
        boolean ok = true;
        if (doc.getNodeKind() == XdmNodeKind.DOCUMENT) {
            ok = S9apiUtils.isDocumentContent(doc.axisIterator(Axis.CHILD));
        } else if (doc.getNodeKind() != XdmNodeKind.ELEMENT) {
            ok = false;
        }
        return ok;
    }

    public static boolean isDocumentContent(XdmSequenceIterator iter) {
        boolean ok = true;
        int elemCount = 0;
        while (ok && iter.hasNext()) {
            XdmNode child = (XdmNode)iter.next();
            if (child.getNodeKind() == XdmNodeKind.ELEMENT) {
                ok = ok && ++elemCount == 1;
                continue;
            }
            if (child.getNodeKind() == XdmNodeKind.PROCESSING_INSTRUCTION || child.getNodeKind() == XdmNodeKind.COMMENT) continue;
            if (child.getNodeKind() == XdmNodeKind.TEXT) {
                ok = ok && "".equals(child.getStringValue().trim());
                continue;
            }
            ok = false;
        }
        return ok;
    }
}

