/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.util;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.util.S9apiUtils;
import java.util.Iterator;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.SaxonApiUncheckedException;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XPathExecutable;
import net.sf.saxon.s9api.XPathSelector;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmNodeKind;
import net.sf.saxon.s9api.XdmSequenceIterator;
import net.sf.saxon.trans.XPathException;

public class RelevantNodes
implements Iterable<XdmNode> {
    private static QName use_when = new QName("", "use-when");
    private static QName p_use_when = new QName("http://www.w3.org/ns/xproc", "use-when");
    private RelevantNodesIter iter = null;
    private XProcRuntime runtime = null;

    public RelevantNodes(XProcRuntime runtime, XdmNode start, Axis axis) {
        this.runtime = runtime;
        this.iter = new RelevantNodesIter(start, axis);
    }

    public RelevantNodes(XdmNode start, Axis axis, boolean ignore) {
        this.iter = new RelevantNodesIter(start, axis, ignore);
    }

    public RelevantNodes(XdmNode start, QName name) {
        this.iter = new RelevantNodesIter(start, Axis.CHILD, name);
    }

    @Override
    public Iterator<XdmNode> iterator() {
        return this.iter;
    }

    private class RelevantNodesIter
    implements Iterator<XdmNode> {
        private XdmSequenceIterator iter = null;
        private XdmNode next = null;
        private boolean finished = false;
        private QName onlyMatch = null;
        private boolean ignoreInfo = true;

        public RelevantNodesIter(XdmNode start, Axis axis) {
            this.iter = start.axisIterator(axis);
        }

        public RelevantNodesIter(XdmNode start, Axis axis, boolean ignore) {
            this.ignoreInfo = ignore;
            this.iter = start.axisIterator(axis);
        }

        public RelevantNodesIter(XdmNode start, Axis axis, QName name) {
            this.iter = start.axisIterator(axis);
            this.onlyMatch = name;
        }

        @Override
        public boolean hasNext() {
            if (this.next == null) {
                boolean hasNext = this.iter.hasNext();
                boolean bl = this.finished = this.finished || !hasNext;
                if (this.finished) {
                    return false;
                }
                this.next = (XdmNode)this.iter.next();
                while (this.next != null && !this.ok(this.next)) {
                    if (this.iter.hasNext()) {
                        this.next = (XdmNode)this.iter.next();
                        continue;
                    }
                    this.next = null;
                }
                return this.ok(this.next);
            }
            return true;
        }

        @Override
        public XdmNode next() {
            XdmNode r = this.next;
            this.next = null;
            return r;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported!");
        }

        private boolean ok(XdmNode node) {
            if (node == null || this.ignoreInfo && (XProcConstants.p_documentation.equals((Object)node.getNodeName()) || XProcConstants.p_pipeinfo.equals((Object)node.getNodeName()))) {
                return false;
            }
            if (node.getNodeKind() == XdmNodeKind.COMMENT || node.getNodeKind() == XdmNodeKind.PROCESSING_INSTRUCTION) {
                return false;
            }
            if (node.getNodeKind() == XdmNodeKind.TEXT) {
                return !"".equals(node.toString().trim());
            }
            if (node.getNodeKind() == XdmNodeKind.ELEMENT) {
                if ("http://www.w3.org/ns/xproc".equals(node.getNodeName().getNamespaceURI()) && node.getAttributeValue(use_when) != null || !"http://www.w3.org/ns/xproc".equals(node.getNodeName().getNamespaceURI()) && node.getAttributeValue(p_use_when) != null) {
                    String expr = node.getAttributeValue(use_when);
                    if (!"http://www.w3.org/ns/xproc".equals(node.getNodeName().getNamespaceURI())) {
                        expr = node.getAttributeValue(p_use_when);
                    }
                    return this.useWhen(node, expr);
                }
                return this.onlyMatch == null || this.onlyMatch.equals((Object)node.getNodeName());
            }
            if (node.getNodeKind() == XdmNodeKind.ATTRIBUTE) {
                return this.onlyMatch == null || this.onlyMatch.equals((Object)node.getNodeName());
            }
            return false;
        }

        private boolean useWhen(XdmNode element, String xpath) {
            boolean use = false;
            if (RelevantNodes.this.runtime == null) {
                return true;
            }
            try {
                XPathCompiler xcomp = RelevantNodes.this.runtime.getProcessor().newXPathCompiler();
                XdmSequenceIterator nsIter = element.axisIterator(Axis.NAMESPACE);
                while (nsIter.hasNext()) {
                    XdmNode ns = (XdmNode)nsIter.next();
                    xcomp.declareNamespace(ns.getNodeName().getLocalName(), ns.getStringValue());
                }
                XPathExecutable xexec = null;
                xexec = xcomp.compile(xpath);
                XPathSelector selector = xexec.load();
                try {
                    use = selector.effectiveBooleanValue();
                }
                catch (SaxonApiUncheckedException saue) {
                    Throwable sae = saue.getCause();
                    if (sae instanceof XPathException) {
                        XPathException xe = (XPathException)sae;
                        if ("http://www.w3.org/2005/xqt-errors".equals(xe.getErrorCodeNamespace()) && "XPDY0002".equals(xe.getErrorCodeLocalPart())) {
                            throw XProcException.dynamicError(26, element, "Expression refers to context when none is available: " + xpath);
                        }
                        throw saue;
                    }
                    throw saue;
                }
            }
            catch (SaxonApiException sae) {
                if (S9apiUtils.xpathSyntaxError(sae)) {
                    throw XProcException.dynamicError(23, element, sae.getCause().getMessage());
                }
                throw new XProcException(sae);
            }
            return use;
        }
    }
}

