pub mod affine;
pub mod binary;
pub mod cast;
pub mod convolution;
pub mod fill;
pub mod indexing;
mod macros;
pub mod mlx_gemm;
pub mod quantized;
pub mod random;
pub mod reduce;
pub mod sdpa;
pub mod sort;
pub mod ternary;
pub mod unary;

pub use affine::*;
pub use binary::{call_binary_contiguous, call_binary_strided};
pub use cast::{call_cast_contiguous, call_cast_strided};
pub use convolution::*;
pub use fill::*;
pub use indexing::*;
pub use mlx_gemm::{call_mlx_gemm, GemmDType};
pub use quantized::{call_quantized_matmul_mm_t, call_quantized_matmul_mv_t, GgmlDType};
pub use random::*;
pub use reduce::*;
pub use sdpa::{call_sdpa_full, call_sdpa_vector, call_sdpa_vector_2pass, SdpaDType};
pub use sort::{call_arg_sort, call_mlx_arg_sort};
pub use ternary::call_where_cond_strided;
pub use unary::*;
