// DO NOT EDIT! This test has been generated by /html/canvas/tools/gentest.py.
// OffscreenCanvas test in a worker:2d.text.measure.index-from-offset-edges.tentative
// Description:
// Note:

importScripts("/resources/testharness.js");
importScripts("/html/canvas/resources/canvas-tests.js");

test(t => {
  const canvas = new OffscreenCanvas(100, 50);
  const ctx = canvas.getContext('2d');

  function computeExpected(text, text_width, offset) {
    expected_position = 0;
    if ('left' == 'center' && offset == 0) {
      return text.length / 2;
    }
    if ('ltr' == 'ltr') {
      if (offset >= text_width) {
        return text.length;
      }
      if (offset <= -text_width) {
        return 0;
      }
      // offset must be 0.
      if ('left' == 'start' || 'left' == 'left') {
        return 0;
      } else {
        return text.length;
      }
    } else {
      if (offset >= text_width) {
        return 0;
      }
      if (offset <= -text_width) {
        return text.length;
      }
      // offset must be 0.
      if ('left' == 'start' || 'left' == 'right') {
        return 0;
      } else {
        return text.length;
      }
    }
    return expected_position;
  }

  ctx.font = '50px sans-serif';
  ctx.direction = 'ltr';
  ctx.textAlign = 'left';
  ctx.letterSpacing = '';

  // The leading and trailing '-' cause the string to always follow
  // the specified direction, even though the interior will always be ltr.
  const text = '-0123456789-';

  // Points are multiples of the string width as reported by
  // textMetrics.width.
  const kPoints = [
    -2,
    -1,
    0,
    1,
    2
  ]

  const tm = ctx.measureText(text);
  text_width = tm.width;
  for (const multiple of kPoints) {
    offset = multiple * text_width;
    tm_position = tm.getIndexFromOffset(offset);
    expected_position = computeExpected(text, text_width, offset);
    assert_equals(tm_position,
                  expected_position,
                  "for " + text + " multiple " + multiple);
  }
}, "Check that TextMetrics::getIndexFromOffset() gives correct edges when the requested point is outside the range, with direction ltr and text align left.");

test(t => {
  const canvas = new OffscreenCanvas(100, 50);
  const ctx = canvas.getContext('2d');

  function computeExpected(text, text_width, offset) {
    expected_position = 0;
    if ('left' == 'center' && offset == 0) {
      return text.length / 2;
    }
    if ('rtl' == 'ltr') {
      if (offset >= text_width) {
        return text.length;
      }
      if (offset <= -text_width) {
        return 0;
      }
      // offset must be 0.
      if ('left' == 'start' || 'left' == 'left') {
        return 0;
      } else {
        return text.length;
      }
    } else {
      if (offset >= text_width) {
        return 0;
      }
      if (offset <= -text_width) {
        return text.length;
      }
      // offset must be 0.
      if ('left' == 'start' || 'left' == 'right') {
        return 0;
      } else {
        return text.length;
      }
    }
    return expected_position;
  }

  ctx.font = '50px sans-serif';
  ctx.direction = 'rtl';
  ctx.textAlign = 'left';
  ctx.letterSpacing = '';

  // The leading and trailing '-' cause the string to always follow
  // the specified direction, even though the interior will always be ltr.
  const text = '-0123456789-';

  // Points are multiples of the string width as reported by
  // textMetrics.width.
  const kPoints = [
    -2,
    -1,
    0,
    1,
    2
  ]

  const tm = ctx.measureText(text);
  text_width = tm.width;
  for (const multiple of kPoints) {
    offset = multiple * text_width;
    tm_position = tm.getIndexFromOffset(offset);
    expected_position = computeExpected(text, text_width, offset);
    assert_equals(tm_position,
                  expected_position,
                  "for " + text + " multiple " + multiple);
  }
}, "Check that TextMetrics::getIndexFromOffset() gives correct edges when the requested point is outside the range, with direction rtl and text align left.");

test(t => {
  const canvas = new OffscreenCanvas(100, 50);
  const ctx = canvas.getContext('2d');

  function computeExpected(text, text_width, offset) {
    expected_position = 0;
    if ('center' == 'center' && offset == 0) {
      return text.length / 2;
    }
    if ('ltr' == 'ltr') {
      if (offset >= text_width) {
        return text.length;
      }
      if (offset <= -text_width) {
        return 0;
      }
      // offset must be 0.
      if ('center' == 'start' || 'center' == 'left') {
        return 0;
      } else {
        return text.length;
      }
    } else {
      if (offset >= text_width) {
        return 0;
      }
      if (offset <= -text_width) {
        return text.length;
      }
      // offset must be 0.
      if ('center' == 'start' || 'center' == 'right') {
        return 0;
      } else {
        return text.length;
      }
    }
    return expected_position;
  }

  ctx.font = '50px sans-serif';
  ctx.direction = 'ltr';
  ctx.textAlign = 'center';
  ctx.letterSpacing = '';

  // The leading and trailing '-' cause the string to always follow
  // the specified direction, even though the interior will always be ltr.
  const text = '-0123456789-';

  // Points are multiples of the string width as reported by
  // textMetrics.width.
  const kPoints = [
    -2,
    -1,
    0,
    1,
    2
  ]

  const tm = ctx.measureText(text);
  text_width = tm.width;
  for (const multiple of kPoints) {
    offset = multiple * text_width;
    tm_position = tm.getIndexFromOffset(offset);
    expected_position = computeExpected(text, text_width, offset);
    assert_equals(tm_position,
                  expected_position,
                  "for " + text + " multiple " + multiple);
  }
}, "Check that TextMetrics::getIndexFromOffset() gives correct edges when the requested point is outside the range, with direction ltr and text align center.");

test(t => {
  const canvas = new OffscreenCanvas(100, 50);
  const ctx = canvas.getContext('2d');

  function computeExpected(text, text_width, offset) {
    expected_position = 0;
    if ('center' == 'center' && offset == 0) {
      return text.length / 2;
    }
    if ('rtl' == 'ltr') {
      if (offset >= text_width) {
        return text.length;
      }
      if (offset <= -text_width) {
        return 0;
      }
      // offset must be 0.
      if ('center' == 'start' || 'center' == 'left') {
        return 0;
      } else {
        return text.length;
      }
    } else {
      if (offset >= text_width) {
        return 0;
      }
      if (offset <= -text_width) {
        return text.length;
      }
      // offset must be 0.
      if ('center' == 'start' || 'center' == 'right') {
        return 0;
      } else {
        return text.length;
      }
    }
    return expected_position;
  }

  ctx.font = '50px sans-serif';
  ctx.direction = 'rtl';
  ctx.textAlign = 'center';
  ctx.letterSpacing = '';

  // The leading and trailing '-' cause the string to always follow
  // the specified direction, even though the interior will always be ltr.
  const text = '-0123456789-';

  // Points are multiples of the string width as reported by
  // textMetrics.width.
  const kPoints = [
    -2,
    -1,
    0,
    1,
    2
  ]

  const tm = ctx.measureText(text);
  text_width = tm.width;
  for (const multiple of kPoints) {
    offset = multiple * text_width;
    tm_position = tm.getIndexFromOffset(offset);
    expected_position = computeExpected(text, text_width, offset);
    assert_equals(tm_position,
                  expected_position,
                  "for " + text + " multiple " + multiple);
  }
}, "Check that TextMetrics::getIndexFromOffset() gives correct edges when the requested point is outside the range, with direction rtl and text align center.");

test(t => {
  const canvas = new OffscreenCanvas(100, 50);
  const ctx = canvas.getContext('2d');

  function computeExpected(text, text_width, offset) {
    expected_position = 0;
    if ('right' == 'center' && offset == 0) {
      return text.length / 2;
    }
    if ('ltr' == 'ltr') {
      if (offset >= text_width) {
        return text.length;
      }
      if (offset <= -text_width) {
        return 0;
      }
      // offset must be 0.
      if ('right' == 'start' || 'right' == 'left') {
        return 0;
      } else {
        return text.length;
      }
    } else {
      if (offset >= text_width) {
        return 0;
      }
      if (offset <= -text_width) {
        return text.length;
      }
      // offset must be 0.
      if ('right' == 'start' || 'right' == 'right') {
        return 0;
      } else {
        return text.length;
      }
    }
    return expected_position;
  }

  ctx.font = '50px sans-serif';
  ctx.direction = 'ltr';
  ctx.textAlign = 'right';
  ctx.letterSpacing = '';

  // The leading and trailing '-' cause the string to always follow
  // the specified direction, even though the interior will always be ltr.
  const text = '-0123456789-';

  // Points are multiples of the string width as reported by
  // textMetrics.width.
  const kPoints = [
    -2,
    -1,
    0,
    1,
    2
  ]

  const tm = ctx.measureText(text);
  text_width = tm.width;
  for (const multiple of kPoints) {
    offset = multiple * text_width;
    tm_position = tm.getIndexFromOffset(offset);
    expected_position = computeExpected(text, text_width, offset);
    assert_equals(tm_position,
                  expected_position,
                  "for " + text + " multiple " + multiple);
  }
}, "Check that TextMetrics::getIndexFromOffset() gives correct edges when the requested point is outside the range, with direction ltr and text align right.");

test(t => {
  const canvas = new OffscreenCanvas(100, 50);
  const ctx = canvas.getContext('2d');

  function computeExpected(text, text_width, offset) {
    expected_position = 0;
    if ('right' == 'center' && offset == 0) {
      return text.length / 2;
    }
    if ('rtl' == 'ltr') {
      if (offset >= text_width) {
        return text.length;
      }
      if (offset <= -text_width) {
        return 0;
      }
      // offset must be 0.
      if ('right' == 'start' || 'right' == 'left') {
        return 0;
      } else {
        return text.length;
      }
    } else {
      if (offset >= text_width) {
        return 0;
      }
      if (offset <= -text_width) {
        return text.length;
      }
      // offset must be 0.
      if ('right' == 'start' || 'right' == 'right') {
        return 0;
      } else {
        return text.length;
      }
    }
    return expected_position;
  }

  ctx.font = '50px sans-serif';
  ctx.direction = 'rtl';
  ctx.textAlign = 'right';
  ctx.letterSpacing = '';

  // The leading and trailing '-' cause the string to always follow
  // the specified direction, even though the interior will always be ltr.
  const text = '-0123456789-';

  // Points are multiples of the string width as reported by
  // textMetrics.width.
  const kPoints = [
    -2,
    -1,
    0,
    1,
    2
  ]

  const tm = ctx.measureText(text);
  text_width = tm.width;
  for (const multiple of kPoints) {
    offset = multiple * text_width;
    tm_position = tm.getIndexFromOffset(offset);
    expected_position = computeExpected(text, text_width, offset);
    assert_equals(tm_position,
                  expected_position,
                  "for " + text + " multiple " + multiple);
  }
}, "Check that TextMetrics::getIndexFromOffset() gives correct edges when the requested point is outside the range, with direction rtl and text align right.");

test(t => {
  const canvas = new OffscreenCanvas(100, 50);
  const ctx = canvas.getContext('2d');

  function computeExpected(text, text_width, offset) {
    expected_position = 0;
    if ('start' == 'center' && offset == 0) {
      return text.length / 2;
    }
    if ('ltr' == 'ltr') {
      if (offset >= text_width) {
        return text.length;
      }
      if (offset <= -text_width) {
        return 0;
      }
      // offset must be 0.
      if ('start' == 'start' || 'start' == 'left') {
        return 0;
      } else {
        return text.length;
      }
    } else {
      if (offset >= text_width) {
        return 0;
      }
      if (offset <= -text_width) {
        return text.length;
      }
      // offset must be 0.
      if ('start' == 'start' || 'start' == 'right') {
        return 0;
      } else {
        return text.length;
      }
    }
    return expected_position;
  }

  ctx.font = '50px sans-serif';
  ctx.direction = 'ltr';
  ctx.textAlign = 'start';
  ctx.letterSpacing = '';

  // The leading and trailing '-' cause the string to always follow
  // the specified direction, even though the interior will always be ltr.
  const text = '-0123456789-';

  // Points are multiples of the string width as reported by
  // textMetrics.width.
  const kPoints = [
    -2,
    -1,
    0,
    1,
    2
  ]

  const tm = ctx.measureText(text);
  text_width = tm.width;
  for (const multiple of kPoints) {
    offset = multiple * text_width;
    tm_position = tm.getIndexFromOffset(offset);
    expected_position = computeExpected(text, text_width, offset);
    assert_equals(tm_position,
                  expected_position,
                  "for " + text + " multiple " + multiple);
  }
}, "Check that TextMetrics::getIndexFromOffset() gives correct edges when the requested point is outside the range, with direction ltr and text align start.");

test(t => {
  const canvas = new OffscreenCanvas(100, 50);
  const ctx = canvas.getContext('2d');

  function computeExpected(text, text_width, offset) {
    expected_position = 0;
    if ('start' == 'center' && offset == 0) {
      return text.length / 2;
    }
    if ('rtl' == 'ltr') {
      if (offset >= text_width) {
        return text.length;
      }
      if (offset <= -text_width) {
        return 0;
      }
      // offset must be 0.
      if ('start' == 'start' || 'start' == 'left') {
        return 0;
      } else {
        return text.length;
      }
    } else {
      if (offset >= text_width) {
        return 0;
      }
      if (offset <= -text_width) {
        return text.length;
      }
      // offset must be 0.
      if ('start' == 'start' || 'start' == 'right') {
        return 0;
      } else {
        return text.length;
      }
    }
    return expected_position;
  }

  ctx.font = '50px sans-serif';
  ctx.direction = 'rtl';
  ctx.textAlign = 'start';
  ctx.letterSpacing = '';

  // The leading and trailing '-' cause the string to always follow
  // the specified direction, even though the interior will always be ltr.
  const text = '-0123456789-';

  // Points are multiples of the string width as reported by
  // textMetrics.width.
  const kPoints = [
    -2,
    -1,
    0,
    1,
    2
  ]

  const tm = ctx.measureText(text);
  text_width = tm.width;
  for (const multiple of kPoints) {
    offset = multiple * text_width;
    tm_position = tm.getIndexFromOffset(offset);
    expected_position = computeExpected(text, text_width, offset);
    assert_equals(tm_position,
                  expected_position,
                  "for " + text + " multiple " + multiple);
  }
}, "Check that TextMetrics::getIndexFromOffset() gives correct edges when the requested point is outside the range, with direction rtl and text align start.");

test(t => {
  const canvas = new OffscreenCanvas(100, 50);
  const ctx = canvas.getContext('2d');

  function computeExpected(text, text_width, offset) {
    expected_position = 0;
    if ('end' == 'center' && offset == 0) {
      return text.length / 2;
    }
    if ('ltr' == 'ltr') {
      if (offset >= text_width) {
        return text.length;
      }
      if (offset <= -text_width) {
        return 0;
      }
      // offset must be 0.
      if ('end' == 'start' || 'end' == 'left') {
        return 0;
      } else {
        return text.length;
      }
    } else {
      if (offset >= text_width) {
        return 0;
      }
      if (offset <= -text_width) {
        return text.length;
      }
      // offset must be 0.
      if ('end' == 'start' || 'end' == 'right') {
        return 0;
      } else {
        return text.length;
      }
    }
    return expected_position;
  }

  ctx.font = '50px sans-serif';
  ctx.direction = 'ltr';
  ctx.textAlign = 'end';
  ctx.letterSpacing = '';

  // The leading and trailing '-' cause the string to always follow
  // the specified direction, even though the interior will always be ltr.
  const text = '-0123456789-';

  // Points are multiples of the string width as reported by
  // textMetrics.width.
  const kPoints = [
    -2,
    -1,
    0,
    1,
    2
  ]

  const tm = ctx.measureText(text);
  text_width = tm.width;
  for (const multiple of kPoints) {
    offset = multiple * text_width;
    tm_position = tm.getIndexFromOffset(offset);
    expected_position = computeExpected(text, text_width, offset);
    assert_equals(tm_position,
                  expected_position,
                  "for " + text + " multiple " + multiple);
  }
}, "Check that TextMetrics::getIndexFromOffset() gives correct edges when the requested point is outside the range, with direction ltr and text align end.");

test(t => {
  const canvas = new OffscreenCanvas(100, 50);
  const ctx = canvas.getContext('2d');

  function computeExpected(text, text_width, offset) {
    expected_position = 0;
    if ('end' == 'center' && offset == 0) {
      return text.length / 2;
    }
    if ('rtl' == 'ltr') {
      if (offset >= text_width) {
        return text.length;
      }
      if (offset <= -text_width) {
        return 0;
      }
      // offset must be 0.
      if ('end' == 'start' || 'end' == 'left') {
        return 0;
      } else {
        return text.length;
      }
    } else {
      if (offset >= text_width) {
        return 0;
      }
      if (offset <= -text_width) {
        return text.length;
      }
      // offset must be 0.
      if ('end' == 'start' || 'end' == 'right') {
        return 0;
      } else {
        return text.length;
      }
    }
    return expected_position;
  }

  ctx.font = '50px sans-serif';
  ctx.direction = 'rtl';
  ctx.textAlign = 'end';
  ctx.letterSpacing = '';

  // The leading and trailing '-' cause the string to always follow
  // the specified direction, even though the interior will always be ltr.
  const text = '-0123456789-';

  // Points are multiples of the string width as reported by
  // textMetrics.width.
  const kPoints = [
    -2,
    -1,
    0,
    1,
    2
  ]

  const tm = ctx.measureText(text);
  text_width = tm.width;
  for (const multiple of kPoints) {
    offset = multiple * text_width;
    tm_position = tm.getIndexFromOffset(offset);
    expected_position = computeExpected(text, text_width, offset);
    assert_equals(tm_position,
                  expected_position,
                  "for " + text + " multiple " + multiple);
  }
}, "Check that TextMetrics::getIndexFromOffset() gives correct edges when the requested point is outside the range, with direction rtl and text align end.");

done();
