/* SPDX-License-Identifier: GPL-2.0-or-later */

#include <variant/gpio.h>
#include <baseboard/variants.h>
#include <soc/gpio.h>
#include <types.h>
#include <vendorcode/google/chromeos/chromeos.h>

/* Pad configuration in ramstage */
static const struct pad_config gpio_table[] = {
	/* A0 thru A4, A9 and A10 come configured out of reset, do not touch */
	/* A0  : ESPI_IO0 ==> ESPI_SOC_D0_EC */
	/* A1  : ESPI_IO1 ==> ESPI_SOC_D1_EC */
	/* A2  : ESPI_IO2 ==> ESPI_SOC_D2_EC */
	/* A3  : ESPI_IO3 ==> ESPI_SOC_D3_EC */
	/* A4  : ESPI_CS0# ==> ESPI_SOC_CS_EC_L */
	/* A5  : ESPI_ALERT0# ==> NC */
	PAD_NC(GPP_A5, NONE),
	/* A6  : ESPI_ALERT1# ==> NC */
	PAD_NC(GPP_A6, NONE),
	/* A7  : NC */
	PAD_NC(GPP_A7, NONE),
	/* A8  : GPP_A8 ==> NC */
	PAD_NC(GPP_A8, NONE),
	/* A9  : ESPI_CLK ==> ESPI_SOC_CLK */
	/* A10 : ESPI_RESET# ==> ESPI_SOC_RST_EC_L */
	/* A11 : SSD_PERST_L */
	PAD_CFG_GPO(GPP_A11, 1, DEEP),
	/* A12 : NC */
	PAD_NC(GPP_A12, NONE),
	/* A13 : GPP_A13 ==> GSC_SOC_INT_ODL */
	PAD_CFG_GPI_APIC(GPP_A13, NONE, PLTRST, LEVEL, INVERT),
	/* A14 : USB_A0_FAULT_ODL */
	PAD_CFG_NF(GPP_A14, NONE, DEEP, NF1),
	/* A15 : NC */
	PAD_NC(GPP_A15, NONE),
	/* A16 : USB_OC3# */
	PAD_CFG_NF(GPP_A16, NONE, DEEP, NF1),
	/* A17 : NC */
	PAD_NC(GPP_A17, NONE),
	/* A18 : NC */
	PAD_NC(GPP_A18, NONE),
	/* A19 : NC */
	PAD_NC(GPP_A19, NONE),
	/* A20 : NC */
	PAD_NC(GPP_A20, NONE),
	/* A21 : USB_C1_AUX_DC_P */
	PAD_CFG_NF(GPP_A21, NONE, DEEP, NF6),
	/* A22 : USB_C1_AUX_DC_N */
	PAD_CFG_NF(GPP_A22, NONE, DEEP, NF6),
	/* A23 : GPP_A23 ==> NC */
	PAD_NC(GPP_A23, NONE),

	/* B0  : VCCIN_AUX_VID0 */
	PAD_CFG_NF(GPP_B0, NONE, DEEP, NF1),
	/* B1  : VCCIN_AUX_VID1 */
	PAD_CFG_NF(GPP_B1, NONE, DEEP, NF1),
	/* B2  : NC */
	PAD_NC(GPP_B2, NONE),
	/* B3  : IMU_INT_L */
	PAD_CFG_GPI_APIC(GPP_B3, NONE, PWROK, LEVEL, INVERT),
	/* B4  : ACC_INT_L */
	PAD_CFG_GPI_APIC(GPP_B4, NONE, PWROK, LEVEL, INVERT),
	/* B5  : GPP_B5 ==> ISH_I2C0_SENSOR_SDA */
	PAD_CFG_NF_IOSTANDBY_IGNORE(GPP_B5, NONE, DEEP, NF1),
	/* B6  : GPP_B6 ==> ISH_I2C0_SENSOR_SCL */
	PAD_CFG_NF_IOSTANDBY_IGNORE(GPP_B6, NONE, DEEP, NF1),
	/* B7  : I2C3_SDA ==> NC */
	PAD_NC(GPP_B7, NONE),
	/* B8  : I2C3_SCL ==> NC */
	PAD_NC(GPP_B8, NONE),
	/* B9  : Not available */
	PAD_NC(GPP_B9, NONE),
	/* B10 : Not available */
	PAD_NC(GPP_B10, NONE),
	/* B11 : SOC_PD0_INT# */
	PAD_CFG_NF(GPP_B11, NONE, DEEP, NF1),
	/* B12 : SLP_S0# ==> PM_SLP_S0# */
	PAD_CFG_NF(GPP_B12, NONE, DEEP, NF1),
	/* B13 : PLTRST# ==> PLT_RST_L */
	PAD_CFG_NF_LOCK(GPP_B13, NONE, NF1, LOCK_CONFIG),
	/* B14 : GPP_B14_STRAP */
	PAD_NC(GPP_B14, NONE),
	/* B15 : NC */
	PAD_NC_LOCK(GPP_B15, NONE, LOCK_CONFIG),
	/* B16  : GPP_B16 ==> I2C_TOUCHPAD_SDA */
	PAD_CFG_NF_LOCK(GPP_B16, NONE, NF2, LOCK_CONFIG),
	/* B17  : GPP_B17 ==> I2C_TOUCHPAD_SCL */
	PAD_CFG_NF_LOCK(GPP_B17, NONE, NF2, LOCK_CONFIG),
	/* B18 : GPP_B18 ==> GPP_B18_STRAP */
	PAD_NC(GPP_B18, NONE),
	/* B19 : Not available */
	PAD_NC(GPP_B19, NONE),
	/* B20 : Not available */
	PAD_NC(GPP_B20, NONE),
	/* B21 : Not available */
	PAD_NC(GPP_B21, NONE),
	/* B22 : Not available */
	PAD_NC(GPP_B22, NONE),
	/* B23 : SML1ALERT# ==> PCHHOT_ODL_STRAP */
	PAD_NC(GPP_B23, NONE),

	/* C0  : SMBCLK ==> EN_PP3300_TCHSCR_X */
	PAD_CFG_GPO(GPP_C0, 1, DEEP),
	/* C1  : SMBDATA ==> TCHSCR_RST_L */
	PAD_CFG_GPO(GPP_C1, 1, DEEP),
	/* C2  : SMBALERT# ==> GPP_C2_STRAP */
	PAD_NC(GPP_C2, NONE),
	/* C3  : EN_PP3300_UCAM_X */
	PAD_CFG_GPO_LOCK(GPP_C3, 1, LOCK_CONFIG),
	/* C4  : TCHSCR_REPORT_EN */
	PAD_CFG_GPO(GPP_C4, 0, DEEP),
	/* C5  : SML0ALERT# ==> GPP_C5_STRAP */
	PAD_NC(GPP_C5, NONE),
	/* C6  : I2C_SOC_PMC_PD_SCL */
	PAD_CFG_NF(GPP_C6, NONE, DEEP, NF1),
	/* C7  : I2C_SOC_PMC_PD_SDA */
	PAD_CFG_NF(GPP_C7, NONE, DEEP, NF1),

	/* D0  : SEN_MODE2_EC_PCH_INT_ODL */
	PAD_CFG_NF(GPP_D0, NONE, DEEP, NF1),
	/* D1  : ISH_GP1 ==> SEN_MODE2_EC_ISH_INT_ODL */
	PAD_CFG_NF(GPP_D1, NONE, DEEP, NF1),
	/* D2  : NC */
	PAD_NC_LOCK(GPP_D2, NONE, LOCK_CONFIG),
	/* D3  : ISH_GP3 ==> NC */
	PAD_NC_LOCK(GPP_D3, NONE, LOCK_CONFIG),
	/* D4  : IMGCLKOUT0 ==> BT_DISABLE_L */
	PAD_CFG_GPO(GPP_D4, 1, DEEP),
	/* D5  : SSD_CLKREQ_ODL */
	PAD_CFG_NF(GPP_D5, NONE, DEEP, NF1),
	/* D6  : SRCCLKREQ1# ==> NC */
	PAD_NC_LOCK(GPP_D6, NONE, LOCK_CONFIG),
	/* D7  : SRCCLKREQ2# ==> WLAN_CLKREQ_ODL */
	PAD_CFG_NF(GPP_D7, NONE, DEEP, NF1),
	/* D8  : SRCCLKREQ3# ==> NC */
	PAD_NC_LOCK(GPP_D8, NONE, LOCK_CONFIG),
	/* D9  : NC */
	PAD_NC_LOCK(GPP_D9, NONE, LOCK_CONFIG),
	/* D10 : ISH_SPI_CLK ==> GPP_D10_STRAP */
	PAD_NC_LOCK(GPP_D10, NONE, LOCK_CONFIG),
	/* D11 : NC */
	PAD_NC_LOCK(GPP_D11, NONE, LOCK_CONFIG),
	/* D12 : ISH_SPI_MOSI ==> GPP_D12_STRAP */
	PAD_NC_LOCK(GPP_D12, NONE, LOCK_CONFIG),
	/* D13 : UART0_ISH_RX_DBG_TX */
	PAD_CFG_NF(GPP_D13, NONE, DEEP, NF1),
	/* D14 : UART0_ISH_TX_DBG_RX */
	PAD_CFG_NF(GPP_D14, NONE, DEEP, NF1),
	/* D15 : ISH_UART0_RTS# ==> NC */
	PAD_NC_LOCK(GPP_D15, NONE, LOCK_CONFIG),
	/* D16 : ISH_UART0_CTS# ==> NC */
	PAD_NC_LOCK(GPP_D16, NONE, LOCK_CONFIG),
	/* D17 : NC */
	PAD_NC_LOCK(GPP_D17, NONE, LOCK_CONFIG),
	/* D18 : NC */
	PAD_NC_LOCK(GPP_D18, NONE, LOCK_CONFIG),
	/* D19 : I2S_MCLK1_OUT ==> CPUID */
	PAD_CFG_GPI(GPP_D19, NONE, DEEP),

	/* E0  : NC */
	PAD_NC_LOCK(GPP_E0, NONE, LOCK_CONFIG),
	/* E1  : THC0_SPI1_IO2 ==> MEM_STRAP_0 */
	PAD_CFG_GPI_LOCK(GPP_E1, NONE, LOCK_CONFIG),
	/* E2  : THC0_SPI1_IO3 ==> MEM_STRAP_1 */
	PAD_CFG_GPI_LOCK(GPP_E2, NONE, LOCK_CONFIG),
	/* E3  : PROC_GP0 ==> MEM_STRAP_2 */
	PAD_CFG_GPI(GPP_E3, NONE, DEEP),
	/* E4  : NC */
	PAD_NC(GPP_E4, NONE),
	/* E5  : NC */
	PAD_NC(GPP_E5, NONE),
	/* E6  : THC0_SPI1_RST# ==> GPP_E6_STRAP */
	PAD_NC_LOCK(GPP_E6, NONE, LOCK_CONFIG),
	/* E7  : NC */
	PAD_NC(GPP_E7, NONE),
	/* E8  : GPP_E8 ==> WLAN_DISABLE_L */
	PAD_CFG_GPO(GPP_E8, 1, DEEP),
	/* E9  : SOC_USB_OC0 */
	PAD_CFG_NF(GPP_E9, NONE, DEEP, NF1),
	/* E10 : EN_PP3300_WLAN_X */
	PAD_CFG_GPO(GPP_E10, 1, DEEP),
	/* E11 : TCHSCR_INT_ODL */
	PAD_CFG_GPI_APIC(GPP_E11, NONE, PLTRST, LEVEL, INVERT),
	/* E12 : THC0_SPI1_IO1 ==> SOC_WP_OD */
	PAD_CFG_GPI_GPIO_DRIVER_LOCK(GPP_E12, NONE, LOCK_CONFIG),
	/* E13 : THC0_SPI1_IO0 ==> NC*/
	PAD_NC_LOCK(GPP_E13, NONE, LOCK_CONFIG),
	/* E14 : DDSP_HPDA ==> EDP_HPD */
	PAD_CFG_NF(GPP_E14, NONE, DEEP, NF1),
	/* E15 : NC */
	PAD_NC(GPP_E15, NONE),
	/* E16 : NC */
	PAD_NC(GPP_E16, NONE),
	/* E17  : MEM_STRAP_3 */
	PAD_CFG_GPI_LOCK(GPP_E17, NONE, LOCK_CONFIG),
	/* E18 : NC */
	PAD_NC(GPP_E18, NONE),
	/* E19 : DDP1_CTRLDATA ==> GPP_E19_STRAP */
	PAD_NC(GPP_E19, NONE),
	/* E20 : DDP2_CTRLCLK ==> NC */
	PAD_NC(GPP_E20, NONE),
	/* E21 : DDP2_CTRLDATA ==> NC */
	PAD_NC(GPP_E21, NONE),
	/* E22 : DDPA_CTRLCLK ==> USB_C0_AUX_DC_P */
	PAD_CFG_NF(GPP_E22, NONE, DEEP, NF6),
	/* E23 : DDPA_CTRLDATA ==> USB_C0_AUX_DC_N */
	PAD_CFG_NF(GPP_E23, NONE, DEEP, NF6),

	/* F0  : CNV_BRI_DT ==> CNV_BRI_DT_STRAP */
	PAD_CFG_NF(GPP_F0, NONE, DEEP, NF1),
	/* F1  : CNV_BRI_RSP ==> CNV_BRI_RSP */
	PAD_CFG_NF(GPP_F1, UP_20K, DEEP, NF1),
	/* F2  : CNV_RGI_DT ==> CNV_RGI_DT_STRAP */
	PAD_CFG_NF(GPP_F2, NONE, DEEP, NF1),
	/* F3  : CNV_RGI_RSP ==> CNV_RGI_RSP */
	PAD_CFG_NF(GPP_F3, UP_20K, DEEP, NF1),
	/* F4  : CNV_RF_RESET# ==> CNV_RF_RST_L */
	PAD_CFG_NF(GPP_F4, NONE, DEEP, NF1),
	/* F5  : CRF_XTAL_CLKREQ ==> CNV_CLKREQ0 */
	PAD_CFG_NF(GPP_F5, NONE, DEEP, NF3),
	/* F6  : CNV_PA_BLANKING ==> NC */
	PAD_NC(GPP_F6, NONE),
	/* F7  : GPP_F7 ==> GPP_F7_STRAP */
	PAD_NC(GPP_F7, NONE),
	/* F8  : Not available */
	PAD_NC(GPP_F8, NONE),
	/* F9  : Not available */
	PAD_NC(GPP_F9, NONE),
	/* F10 : GPP_F10 ==> GPP_F10_STRAP */
	PAD_NC(GPP_F10, NONE),
	/* F11 : NC */
	PAD_NC_LOCK(GPP_F11, NONE, LOCK_CONFIG),
	/* F12 : NC */
	PAD_NC_LOCK(GPP_F12, NONE, LOCK_CONFIG),
	/* F13 : NC */
	PAD_NC(GPP_F13, NONE),
	/* F14 : GSXDIN ==> TCHPAD_INT_ODL */
	PAD_CFG_GPI_IRQ_WAKE(GPP_F14, NONE, PWROK, LEVEL, INVERT),
	/* F15 : NC */
	PAD_NC_LOCK(GPP_F15, NONE, LOCK_CONFIG),
	/* F16 : NC */
	PAD_NC_LOCK(GPP_F16, NONE, LOCK_CONFIG),
	/* F17 : THC1_SPI2_RST# ==> EC_SOC_WAKE_ODL */
	PAD_CFG_GPI_IRQ_WAKE_LOCK(GPP_F17, NONE, EDGE_SINGLE, INVERT, LOCK_CONFIG),
	/* F18 : THC1_SPI2_INT# ==> NC */
	PAD_NC(GPP_F18, NONE),
	/* F19 : Not available */
	PAD_NC(GPP_F19, NONE),
	/* F20 : Not available */
	PAD_NC(GPP_F20, NONE),
	/* F21 : Not available */
	PAD_NC(GPP_F21, NONE),
	/* F22 : NC */
	PAD_NC(GPP_F22, NONE),
	/* F23 : V1P05_CTRL ==> V1P05EXT_CTRL */
	PAD_CFG_NF(GPP_F23, NONE, DEEP, NF1),

	/* H0  : GPP_H0_STRAP */
	PAD_NC(GPP_H0, NONE),
	/* H1  : GPP_H1_STRAP */
	PAD_NC(GPP_H1, NONE),
	/* H2  : GPP_H2_STRAP */
	PAD_NC(GPP_H2, NONE),
	/* H3  : SX_EXIT_HOLDOFF# ==> WLAN_PCIE_WAKE_ODL */
	PAD_CFG_GPI_SCI_LOW_LOCK(GPP_H3, NONE, EDGE_SINGLE, LOCK_CONFIG),
	/* H4  : I2C0_SDA ==> SOC_I2C_GSC_SDA */
	PAD_CFG_NF_LOCK(GPP_H4, NONE, NF1, LOCK_CONFIG),
	/* H5  : I2C0_SCL ==> SOC_I2C_GSC_SCL */
	PAD_CFG_NF_LOCK(GPP_H5, NONE, NF1, LOCK_CONFIG),
	/* H6  : I2C1_SDA ==> SOC_I2C_TCHSCR_SDA */
	PAD_CFG_NF(GPP_H6, NONE, DEEP, NF1),
	/* H7  : I2C1_SCL ==> SOC_I2C_TCHSCR_SCL */
	PAD_CFG_NF(GPP_H7, NONE, DEEP, NF1),
	/* H8  : NC */
	PAD_NC(GPP_H8, NONE),
	/* H9  : NC */
	PAD_NC(GPP_H9, NONE),
	/* H10 : UART0_RXD ==> UART_SOC_RX_DBG_TX */
	PAD_CFG_NF(GPP_H10, NONE, DEEP, NF2),
	/* H11 : UART0_TXD ==> UART_SOC_TX_DBG_RX */
	PAD_CFG_NF(GPP_H11, NONE, DEEP, NF2),
	/* H12 : GPP_H12 ==> NC */
	PAD_NC_LOCK(GPP_H12, NONE, LOCK_CONFIG),
	/* H13 : GPP_H13 ==> NC */
	PAD_NC_LOCK(GPP_H13, NONE, LOCK_CONFIG),
	/* H14 : Not available */
	PAD_NC(GPP_H14, NONE),
	/* H15  : DDPB_CTRLCLK ==> NC */
	PAD_NC_LOCK(GPP_H15, NONE, LOCK_CONFIG),
	/* H16 : Not available */
	PAD_NC(GPP_H16, NONE),
	/* H17  : DDPB_CTRLDATA ==> PD_SOC_DBG_L */
	PAD_CFG_NF(GPP_H17, NONE, DEEP, NF1),
	/* H18 : PROC_C10_GATE# ==> CPU_C10_GATE# */
	PAD_CFG_NF(GPP_H18, NONE, DEEP, NF1),
	/* H19 : SOC_I2C_SUB_INT_ODL */
	PAD_NC(GPP_H19, NONE),
	/* H20 : IMGCLKOUT1 ==> WLAN_PERST_L */
	PAD_CFG_GPO(GPP_H20, 1, DEEP),
	/* H21 : NC */
	PAD_NC(GPP_H21, NONE),
	/* H22 : IMGCLKOUT3 ==> NC */
	PAD_NC(GPP_H22, NONE),
	/* H23 : GPP_H23 ==> X360_CS_SKU_ID */
	PAD_CFG_GPI(GPP_H23, NONE, DEEP),

	/* R0  : HDA_BCLK ==> HDA_HP_BCLK */
	PAD_CFG_NF(GPP_R0, NONE, DEEP, NF1),
	/* R1  : HDA_SYNC ==> HDA_HP_SYNC */
	PAD_CFG_NF(GPP_R1, NONE, DEEP, NF1),
	/* R2 : HDA_SDO ==> HDA_HP_SDO */
	PAD_CFG_NF(GPP_R2, NONE, DEEP, NF1),
	/* R3 : HDA_SDI0 ==> HDA_HP_SDIN0_R */
	PAD_CFG_NF(GPP_R3, NONE, DEEP, NF1),
	/* R4 : HDA_RST# ==> DMIC_UCAM_CLK */
	PAD_CFG_NF(GPP_R4, NONE, DEEP, NF3),
	/* R5 : HDA_SDI1 ==> DMIC_UCAM_DATA */
	PAD_CFG_NF(GPP_R5, NONE, DEEP, NF3),
	/* R6 : DMIC_CLK_A_1A ==> NC */
	PAD_NC(GPP_R6, NONE),
	/* R7 : DMIC_DATA_1A ==> NC */
	PAD_NC(GPP_R7, NONE),

	/* S0  : I2S_SPK_BCLK_R ==> NC */
	PAD_NC(GPP_S0, NONE),
	/* S1  : I2S_SPK_LRCK_R ==> NC */
	PAD_NC(GPP_S1, NONE),
	/* S2 : DMIC_CKL_A0 ==> NC */
	PAD_NC(GPP_S2, NONE),
	/* S3 : DMIC_DATA0 ==> NC */
	PAD_NC(GPP_S3, NONE),
	/* S4  : NC */
	PAD_NC(GPP_S4, NONE),
	/* S5  : NC */
	PAD_NC(GPP_S5, NONE),
	/* S6  : NC */
	PAD_NC(GPP_S6, NONE),
	/* S7  : NC */
	PAD_NC(GPP_S7, NONE),

	/* I5  : NC */
	PAD_NC(GPP_I5, NONE),
	/* I7  : EMMC_CMD */
	PAD_CFG_NF(GPP_I7, NONE, DEEP, NF1),
	/* I8  : EMMC_DATA0 */
	PAD_CFG_NF(GPP_I8, NONE, DEEP, NF1),
	/* I9  : EMMC_DATA1 */
	PAD_CFG_NF(GPP_I9, NONE, DEEP, NF1),
	/* I10 : EMMC_DATA2 */
	PAD_CFG_NF(GPP_I10, NONE, DEEP, NF1),
	/* I11 : EMMC_DATA3 */
	PAD_CFG_NF(GPP_I11, NONE, DEEP, NF1),
	/* I12 : EMMC_DATA4 */
	PAD_CFG_NF(GPP_I12, NONE, DEEP, NF1),
	/* I13 : EMMC_DATA5 */
	PAD_CFG_NF(GPP_I13, NONE, DEEP, NF1),
	/* I14 : EMMC_DATA6 */
	PAD_CFG_NF(GPP_I14, NONE, DEEP, NF1),
	/* I15 : EMMC_DATA7 */
	PAD_CFG_NF(GPP_I15, NONE, DEEP, NF1),
	/* I16 : EMMC_RCLK */
	PAD_CFG_NF(GPP_I16, NONE, DEEP, NF1),
	/* I17 : EMMC_CLK */
	PAD_CFG_NF(GPP_I17, NONE, DEEP, NF1),
	/* I18 : EMMC_RESET# */
	PAD_CFG_NF(GPP_I18, NONE, DEEP, NF1),

	/* GPD0  : BATLOW# ==> SOC_BATLOW_L */
	PAD_CFG_NF(GPD0, NONE, DEEP, NF1),
	/* GPD1  : ACPRESENT ==> SOC_ACPRESENT */
	PAD_CFG_NF(GPD1, NONE, DEEP, NF1),
	/* GPD2  : EC_SOC_INT_ODL */
	PAD_CFG_GPI_APIC(GPD2, NONE, PLTRST, LEVEL, INVERT),
	/* GPD3  : PWRBTN# ==> EC_SOC_PWR_BTN_ODL */
	PAD_CFG_NF(GPD3, NONE, DEEP, NF1),
	/* GPD4  : SLP_S3# ==> SLP_S3_L */
	PAD_CFG_NF(GPD4, NONE, DEEP, NF1),
	/* GPD5  : SLP_S4# ==> SLP_S4_L */
	PAD_CFG_NF(GPD5, NONE, DEEP, NF1),
	/* GPD6  : SLP_A# ==> NC */
	PAD_NC(GPD6, NONE),
	/* GPD7  : GPD7_STRAP */
	PAD_NC(GPD7, NONE),
	/* GPD8  : SUSCLK ==> PCH_SUSCLK */
	PAD_CFG_NF(GPD8, NONE, DEEP, NF1),
	/* GPD9  : NC */
	PAD_NC(GPD9, NONE),
	/* GPD10 : SLP_S5# ==> NC */
	PAD_NC(GPD10, NONE),
	/* GPD11 : NC */
	PAD_NC(GPD11, NONE),

	/* Configure the unused virtual CNVi Bluetooth UART pads to NC mode. */
	/* vCNV_BT_UART_TXD */
	PAD_NC(GPP_VGPIO_6, NONE),
	/* vCNV_BT_UART_RXD */
	PAD_NC(GPP_VGPIO_7, NONE),
	/* vCNV_BT_UART_CTS_B */
	PAD_NC(GPP_VGPIO_8, NONE),
	/* vCNV_BT_UART_RTS_B */
	PAD_NC(GPP_VGPIO_9, NONE),

	/* Configure the unused vUART for Bluetooth pads to NC mode. */
	/* vUART0_TXD */
	PAD_NC(GPP_VGPIO_18, NONE),
	/* vUART0_RXD */
	PAD_NC(GPP_VGPIO_19, NONE),
	/* vUART0_CTS_B */
	PAD_NC(GPP_VGPIO_20, NONE),
	/* vUART0_RTS_B */
	PAD_NC(GPP_VGPIO_21, NONE),

	/* Configure the virtual CNVi Bluetooth I2S GPIO Pads.*/
	/* BT_I2S_BCLK */
	PAD_CFG_NF(GPP_VGPIO_30, NONE, DEEP, NF3),
	/* BT_I2S_SYNC */
	PAD_CFG_NF(GPP_VGPIO_31, NONE, DEEP, NF3),
	/* BT_I2S_SDO */
	PAD_CFG_NF(GPP_VGPIO_32, NONE, DEEP, NF3),
	/* BT_I2S_SDI */
	PAD_CFG_NF(GPP_VGPIO_33, NONE, DEEP, NF3),
	/* SSP2_SCLK */
	PAD_CFG_NF(GPP_VGPIO_34, NONE, DEEP, NF1),
	/* SSP2_SFRM */
	PAD_CFG_NF(GPP_VGPIO_35, NONE, DEEP, NF1),
	/* SSP_TXD */
	PAD_CFG_NF(GPP_VGPIO_36, NONE, DEEP, NF1),
	/* SSP_RXD */
	PAD_CFG_NF(GPP_VGPIO_37, NONE, DEEP, NF1),
};

/* Early pad configuration in bootblock */
static const struct pad_config early_gpio_table[] = {
	/* C0  : SMBCLK ==> EN_PP3300_TCHSCR_X */
	PAD_CFG_GPO(GPP_C0, 1, DEEP),
	/* C1  : SMBDATA ==> TCHSCR_RST_L */
	PAD_CFG_GPO(GPP_C1, 1, DEEP),
	/* A13 : GPP_A13 ==> GSC_SOC_INT_ODL */
	PAD_CFG_GPI_APIC(GPP_A13, NONE, PLTRST, LEVEL, INVERT),
	/* E12 : THC0_SPI1_IO1 ==> SOC_WP_OD */
	PAD_CFG_GPI_GPIO_DRIVER(GPP_E12, NONE, DEEP),
	/* H4  : I2C0_SDA ==> SOC_I2C_GSC_SDA */
	PAD_CFG_NF(GPP_H4, NONE, DEEP, NF1),
	/* H5  : I2C0_SCL ==> SOC_I2C_GSC_SCL */
	PAD_CFG_NF(GPP_H5, NONE, DEEP, NF1),
	/* H10 : UART0_RXD ==> UART_SOC_RX_DBG_TX */
	PAD_CFG_NF(GPP_H10, NONE, DEEP, NF2),
	/* H11 : UART0_TXD ==> UART_SOC_TX_DBG_RX */
	PAD_CFG_NF(GPP_H11, NONE, DEEP, NF2),
	/* H20 : IMGCLKOUT1 ==> WLAN_PERST_L */
	PAD_CFG_GPO(GPP_H20, 0, DEEP),
};

/* Fill romstage gpio configuration */
static const struct pad_config romstage_gpio_table[] = {
};

const struct pad_config *variant_gpio_table(size_t *num)
{
	*num = ARRAY_SIZE(gpio_table);
	return gpio_table;
}

const struct pad_config *variant_gpio_override_table(size_t *num)
{
	*num = 0;
	return NULL;
}

const struct pad_config *variant_early_gpio_table(size_t *num)
{
	*num = ARRAY_SIZE(early_gpio_table);
	return early_gpio_table;
}

static const struct cros_gpio cros_gpios[] = {
	CROS_GPIO_REC_AL(CROS_GPIO_VIRTUAL, CROS_GPIO_DEVICE_NAME),
	CROS_GPIO_WP_AH(GPIO_PCH_WP, CROS_GPIO_DEVICE_NAME),
};
DECLARE_CROS_GPIOS(cros_gpios);

const struct pad_config *variant_romstage_gpio_table(size_t *num)
{
	*num = ARRAY_SIZE(romstage_gpio_table);
	return romstage_gpio_table;
}
