/*
 * Copyright (c) 2025, Mediatek Inc. All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef PCM_DEF_H
#define PCM_DEF_H

#define CTRL0_SC_26M_CK_OFF			BIT(0)
#define CTRL0_SC_VLP_BUS_CK_OFF			BIT(1)
#define CTRL0_SC_PMIF_CK_OFF			BIT(2)
#define CTRL0_SC_AXI_CK_OFF			BIT(3)
#define CTRL0_SC_AXI_MEM_CK_OFF			BIT(4)
#define CTRL0_SC_MD26M_CK_OFF			BIT(5)
#define CTRL0_SC_MD32K_CK_OFF			BIT(6)
#define CTRL0_SC_VLP_26M_CLK_SEL		BIT(7)
#define CTRL0_SC_26M_CK_SEL			BIT(8)
#define CTRL0_SC_TOP_26M_CLK_SEL		BIT(9)
#define CTRL0_SC_SYS_TIMER_CLK_32K_SEL		BIT(10)
#define CTRL0_SC_CIRQ_CLK_32K_SEL		BIT(11)
#define CTRL0_SC_AXI_DCM_DIS			BIT(12)
#define CTRL0_SC_CKSQ0_OFF			BIT(13)
#define CTRL0_SC_CKSQ1_OFF			BIT(14)
#define CTRL0_VCORE_PWR_ISO			BIT(15)
#define CTRL0_VCORE_PWR_ISO_PRE			BIT(16)
#define CTRL0_VCORE_PWR_RST_B			BIT(17)
#define CTRL0_VCORE_RESTORE_ENABLE		BIT(18)
#define CTRL0_SC_TOP_RESTORE_26M_CLK_SEL	BIT(19)
#define CTRL0_AOC_VCORE_SRAM_ISO_DIN		BIT(20)
#define CTRL0_AOC_VCORE_SRAM_LATCH_ENB		BIT(21)
#define CTRL0_AOC_VCORE_ANA_ISO			BIT(22)
#define CTRL0_AOC_VCORE_ANA_ISO_PRE		BIT(23)
#define CTRL0_AOC_VLPTOP_SRAM_ISO_DIN		BIT(24)
#define CTRL0_AOC_VLPTOP_SRAM_LATCH_ENB		BIT(25)
#define CTRL0_AOC_VCORE_IO_ISO			BIT(26)
#define CTRL0_AOC_VCORE_IO_LATCH_ENB		BIT(27)
#define CTRL0_RTFF_VCORE_SAVE			BIT(28)
#define CTRL0_RTFF_VCORE_NRESTORE		BIT(29)
#define CTRL0_RTFF_VCORE_CLK_DIS		BIT(30)

#define CTRL1_PWRAP_SLEEP_REQ			BIT(0)
#define CTRL1_IM_SLP_EN				BIT(1)
#define CTRL1_SPM_LEAVE_VCORE_OFF_REQ		BIT(2)
#define CTRL1_SPM_CK_SEL0			BIT(4)
#define CTRL1_SPM_CK_SEL1			BIT(5)
#define CTRL1_TIMER_SET				BIT(6)
#define CTRL1_TIMER_CLR				BIT(7)
#define CTRL1_SPM_LEAVE_DEEPIDLE_REQ		BIT(8)
#define CTRL1_SPM_LEAVE_SUSPEND_REQ		BIT(9)
#define CTRL1_CSYSPWRUPACK			BIT(10)
#define CTRL1_SRCCLKENO0			BIT(11)
#define CTRL1_SRCCLKENO1			BIT(12)
#define CTRL1_SRCCLKENO2			BIT(13)
#define CTRL1_SPM_APSRC_INTERNAL_ACK		BIT(14)
#define CTRL1_SPM_EMI_INTERNAL_ACK		BIT(15)
#define CTRL1_SPM_DDREN_INTERNAL_ACK		BIT(16)
#define CTRL1_SPM_INFRA_INTERNAL_ACK		BIT(17)
#define CTRL1_SPM_VRF18_INTERNAL_ACK		BIT(18)
#define CTRL1_SPM_VCORE_INTERNAL_ACK		BIT(19)
#define CTRL1_SPM_VCORE_RESTORE_ACK		BIT(20)
#define CTRL1_SPM_PMIC_INTERNAL_ACK		BIT(21)
#define CTRL1_PMIC_IRQ_REQ_EN			BIT(22)
#define CTRL1_WDT_KICK_P			BIT(23)
#define CTRL1_FORCE_DDREN_WAKE			BIT(24)
#define CTRL1_FORCE_F26M_WAKE			BIT(25)
#define CTRL1_FORCE_APSRC_WAKE			BIT(26)
#define CTRL1_FORCE_INFRA_WAKE			BIT(27)
#define CTRL1_FORCE_VRF18_WAKE			BIT(28)
#define CTRL1_FORCE_VCORE_WAKE			BIT(29)
#define CTRL1_FORCE_EMI_WAKE			BIT(30)
#define CTRL1_FORCE_PMIC_WAKE			BIT(31)


#define CTRL2_MD32PCM_IRQ_TRIG_BIT		BIT(31)

#define STA0_SRCCLKENI0				BIT(0)
#define STA0_SRCCLKENI1				BIT(1)
#define STA0_MD_SRCCLKENA			BIT(2)
#define STA0_MD_SRCCLKENA1			BIT(3)
#define STA0_MD_DDREN_REQ			BIT(4)
#define STA0_CONN_DDREN_REQ			BIT(5)
#define STA0_SSPM_SRCCLKENA			BIT(6)
#define STA0_SSPM_APSRC_REQ			BIT(7)
#define STA0_MD_STATE				BIT(8)
#define STA0_RC2SPM_SRCCLKENO_0_ACK		BIT(9)
#define STA0_MM_STATE				BIT(10)
#define STA0_SSPM_STATE				BIT(11)
#define STA0_CPUEB_STATE			BIT(12)
#define STA0_CONN_STATE				BIT(13)
#define STA0_CONN_VCORE_REQ			BIT(14)
#define STA0_CONN_SRCCLKENA			BIT(15)
#define STA0_CONN_SRCCLKENB			BIT(16)
#define STA0_CONN_APSRC_REQ			BIT(17)
#define STA0_SCP_STATE				BIT(18)
#define STA0_CSYSPWRUPREQ			BIT(19)
#define STA0_PWRAP_SLEEP_ACK			BIT(20)
#define STA0_DPM_STATE				BIT(21)
#define STA0_AUDIO_DSP_STATE			BIT(22)
#define STA0_PMIC_IRQ_ACK			BIT(23)
#define STA0_RESERVED_BIT_24			BIT(24)
#define STA0_RESERVED_BIT_25			BIT(25)
#define STA0_RESERVED_BIT_26			BIT(26)
#define STA0_DVFS_STATE				BIT(27)
#define STA0_RESERVED_BIT_28			BIT(28)
#define STA0_RESERVED_BIT_29			BIT(29)
#define STA0_SC_HW_S1_ACK_ALL			BIT(30)
#define STA0_DDREN_STATE			BIT(31)

#define R12_PCM_TIMER_B				BIT(0)
#define R12_TWAM_PMSR_DVFSRC_ALCO		BIT(1)
#define R12_KP_IRQ_B				BIT(2)
#define R12_APWDT_EVENT_B			BIT(3)
#define R12_APXGPT_EVENT_B			BIT(4)
#define R12_CONN2AP_WAKEUP_B			BIT(5)
#define R12_EINT_EVENT_B			BIT(6)
#define R12_CONN_WDT_IRQ_B			BIT(7)
#define R12_CCIF0_EVENT_B			BIT(8)
#define R12_CCIF1_EVENT_B			BIT(9)
#define R12_SSPM2SPM_WAKEUP_B			BIT(10)
#define R12_SCP2SPM_WAKEUP_B			BIT(11)
#define R12_ADSP2SPM_WAKEUP_B			BIT(12)
#define R12_PCM_WDT_WAKEUP_B			BIT(13)
#define R12_USB0_CDSC_B				BIT(14)
#define R12_USB0_POWERDWN_B			BIT(15)
#define R12_UART_EVENT_B			BIT(16)
#define R12_DEBUGTOP_FLAG_IRQ_B			BIT(17)
#define R12_SYS_TIMER_EVENT_B			BIT(18)
#define R12_EINT_EVENT_SECURE_B			BIT(19)
#define R12_AFE_IRQ_MCU_B			BIT(20)
#define R12_THERM_CTRL_EVENT_B			BIT(21)
#define R12_SYS_CIRQ_IRQ_B			BIT(22)
#define R12_PBUS_EVENT_B			BIT(23)
#define R12_CSYSPWREQ_B				BIT(24)
#define R12_MD_WDT_B				BIT(25)
#define R12_AP2AP_PEER_WAKEUP_B			BIT(26)
#define R12_SEJ_B				BIT(27)
#define R12_CPU_WAKEUP				BIT(28)
#define R12_APUSYS_WAKE_HOST_B			BIT(29)
#define R12_PCIE_WAKE_B				BIT(30)
#define R12_MSDC_WAKE_B				BIT(31)

#define EVENT_F26M_WAKE				BIT(0)
#define EVENT_F26M_SLEEP			BIT(1)
#define EVENT_INFRA_WAKE			BIT(2)
#define EVENT_INFRA_SLEEP			BIT(3)
#define EVENT_EMI_WAKE				BIT(4)
#define EVENT_EMI_SLEEP				BIT(5)
#define EVENT_APSRC_WAKE			BIT(6)
#define EVENT_APSRC_SLEEP			BIT(7)
#define EVENT_VRF18_WAKE			BIT(8)
#define EVENT_VRF18_SLEEP			BIT(9)
#define EVENT_DVFS_WAKE				BIT(10)
#define EVENT_DDREN_WAKE			BIT(11)
#define EVENT_DDREN_SLEEP			BIT(12)
#define EVENT_VCORE_WAKE			BIT(13)
#define EVENT_VCORE_SLEEP			BIT(14)
#define EVENT_PMIC_WAKE				BIT(15)
#define EVENT_PMIC_SLEEP			BIT(16)
#define EVENT_CPUEB_STATE			BIT(17)
#define EVENT_SSPM_STATE			BIT(18)
#define EVENT_DPM_STATE				BIT(19)
#define EVENT_SPM_LEAVE_VCORE_OFF_ACK		BIT(20)
#define EVENT_SW_SSPM_ADSP_SCP_MAILBOX_WAKE	BIT(21)
#define EVENT_SPM_LEAVE_SUSPEND_ACK		BIT(22)
#define EVENT_SPM_LEAVE_DEEPIDLE_ACK		BIT(23)
#define EVENT_CROSS_REQ_APU_l3			BIT(24)
#define EVENT_DFD_SOC_MTCMOS_REQ_IPIC_WAKE	BIT(25)
#define EVENT_AOVBUS_WAKE			BIT(26)
#define EVENT_AOVBUS_SLEEP			BIT(27)

enum SPM_WAKE_SRC_LIST {
	WAKE_SRC_STA1_PCM_TIMER = BIT(0),
	WAKE_SRC_STA1_TWAM_PMSR_DVFSRC = BIT(1),
	WAKE_SRC_STA1_KP_IRQ_B = BIT(2),
	WAKE_SRC_STA1_APWDT_EVENT_B = BIT(3),
	WAKE_SRC_STA1_APXGPT1_EVENT_B = BIT(4),
	WAKE_SRC_STA1_CONN2AP_SPM_WAKEUP_B = BIT(5),
	WAKE_SRC_STA1_EINT_EVENT_B = BIT(6),
	WAKE_SRC_STA1_CONN_WDT_IRQ_B = BIT(7),
	WAKE_SRC_STA1_CCIF0_EVENT_B = BIT(8),
	WAKE_SRC_STA1_CCIF1_EVENT_B = BIT(9),
	WAKE_SRC_STA1_SC_SSPM2SPM_WAKEUP_B = BIT(10),
	WAKE_SRC_STA1_SC_SCP2SPM_WAKEUP_B = BIT(11),
	WAKE_SRC_STA1_SC_ADSP2SPM_WAKEUP_B = BIT(12),
	WAKE_SRC_STA1_PCM_WDT_WAKEUP_B = BIT(13),
	WAKE_SRC_STA1_USB_CDSC_B = BIT(14),
	WAKE_SRC_STA1_USB_POWERDWN_B = BIT(15),
	WAKE_SRC_STA1_AP_UART_B = BIT(16),
	WAKE_SRC_STA1_DEBUGTOP_FLAG_IRQ_B = BIT(17),
	WAKE_SRC_STA1_SYS_TIMER_EVENT_B = BIT(18),
	WAKE_SRC_STA1_EINT_EVENT_SECURE_B = BIT(19),
	WAKE_SRC_STA1_AFE_IRQ_MCU_B = BIT(20),
	WAKE_SRC_STA1_THERM_CTRL_EVENT_B = BIT(21),
	WAKE_SRC_STA1_SYS_CIRQ_IRQ_B = BIT(22),
	WAKE_SRC_STA1_PBUS_EVENT_B = BIT(23),
	WAKE_SRC_STA1_CSYSPWREQ_B = BIT(24),
	WAKE_SRC_STA1_MD1_WDT_B = BIT(25),
	WAKE_SRC_STA1_AP2AP_PEER_WAKEUPEVENT_B = BIT(26),
	WAKE_SRC_STA1_SEJ_EVENT_B = BIT(27),
	WAKE_SRC_STA1_SPM_CPU_WAKEUPEVENT_B = BIT(28),
	WAKE_SRC_STA1_APUSYS_WAKE_HOST_B = BIT(29),
	WAKE_SRC_STA1_PCIE_B = BIT(30),
	WAKE_SRC_STA1_MSDC_B = BIT(31),
};

extern const char *wakesrc_str[32];

#endif /* PCM_DEF_H */
