/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.database.DataGridBundle;
import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.connection.throwable.info.ErrorInfo;
import com.intellij.database.csv.CsvFormat;
import com.intellij.database.csv.CsvSettingsService;
import com.intellij.database.data.types.BaseConversionGraph;
import com.intellij.database.data.types.ConversionGraph;
import com.intellij.database.data.types.DataTypeConversion;
import com.intellij.database.datagrid.CellColors;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.CsvDocumentDataHookUp;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridAppearance;
import com.intellij.database.datagrid.DataGridNotifications;
import com.intellij.database.datagrid.DataGridPomTarget;
import com.intellij.database.datagrid.DocumentDataHookUp;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.GridHelper;
import com.intellij.database.datagrid.GridHelperImpl;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridMutator;
import com.intellij.database.datagrid.GridPresentationMode;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridSelection;
import com.intellij.database.datagrid.GridUtilCore;
import com.intellij.database.datagrid.HierarchicalColumnsCollapseManager;
import com.intellij.database.datagrid.HierarchicalColumnsDataGridModel;
import com.intellij.database.datagrid.HierarchicalReader;
import com.intellij.database.datagrid.HookUpVirtualFileProvider;
import com.intellij.database.datagrid.Index;
import com.intellij.database.datagrid.IndexSet;
import com.intellij.database.datagrid.JdbcColumnDescriptor;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.MutationType;
import com.intellij.database.datagrid.NamedRow;
import com.intellij.database.datagrid.ResultView;
import com.intellij.database.datagrid.RowSortOrder;
import com.intellij.database.datagrid.SelectionModel;
import com.intellij.database.datagrid.ViewIndex;
import com.intellij.database.editor.TableEditorBase;
import com.intellij.database.extractors.BaseObjectFormatter;
import com.intellij.database.extractors.BinaryDisplayType;
import com.intellij.database.extractors.DataExtractor;
import com.intellij.database.extractors.DatabaseObjectFormatterConfig;
import com.intellij.database.extractors.FormatterCreator;
import com.intellij.database.extractors.ObjectFormatterConfig;
import com.intellij.database.extractors.ObjectFormatterUtil;
import com.intellij.database.remote.jdbc.LobInfo;
import com.intellij.database.run.actions.ChoosePasteFormatAction;
import com.intellij.database.run.actions.ShowPaginationActionKt;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.DataGridRequestPlace;
import com.intellij.database.run.ui.FloatingPagingManager;
import com.intellij.database.run.ui.HierarchicalTableResultPanel;
import com.intellij.database.run.ui.TableResultPanel;
import com.intellij.database.run.ui.grid.CellAttributesKey;
import com.intellij.database.run.ui.grid.GridPasteProvider;
import com.intellij.database.run.ui.grid.GridScrollPositionManager;
import com.intellij.database.run.ui.grid.GridTransferableData;
import com.intellij.database.run.ui.grid.editors.FormatsCache;
import com.intellij.database.run.ui.grid.editors.GridCellEditorFactoryImpl;
import com.intellij.database.run.ui.grid.editors.GridCellEditorFactoryProvider;
import com.intellij.database.run.ui.grid.editors.GridCellEditorHelper;
import com.intellij.database.run.ui.grid.editors.GridCellEditorHelperImpl;
import com.intellij.database.run.ui.grid.renderers.DefaultBooleanRendererFactory;
import com.intellij.database.run.ui.grid.renderers.DefaultNumericRendererFactory;
import com.intellij.database.run.ui.grid.renderers.DefaultTextRendererFactory;
import com.intellij.database.run.ui.grid.renderers.GridCellRendererFactories;
import com.intellij.database.run.ui.grid.renderers.GridCellRendererFactory;
import com.intellij.database.run.ui.treetable.TreeTableResultView;
import com.intellij.database.settings.DataGridAppearanceSettings;
import com.intellij.database.settings.DataGridSettings;
import com.intellij.database.util.Out;
import com.intellij.database.vfs.fragment.TableDataFragmentFile;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.marketplace.MarketplaceRequests;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.EmptyActionGroup;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginsAdvertiserDialog;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.TwoSideComponent;
import com.intellij.ui.icons.CachedImageIcon;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.textCompletion.TextCompletionProvider;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.TextTransferable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridUtil
extends GridUtilCore {
    public static final int ADDITIONAL_ROWS_COUNT = 5;
    public static final Key<Boolean> IN_EDITOR_RESULTS = Key.create((String)"IN_EDITOR_RESULTS");
    public static final Key<Boolean> IS_REFERENCED = Key.create((String)"IS_REFERENCED");
    public static final Key<Object> IN_REFERENCE = Key.create((String)"IN_REFERENCE");
    public static final Key<Set<Object>> OUT_REFERENCES = Key.create((String)"OUT_REFERENCES");
    private static final Logger LOG = Logger.getInstance(GridUtil.class);
    private static final Key<TableEditorBase> FILE_EDITOR_KEY = Key.create((String)"ResultPanel.MyTableFileEditor");
    public static final String NULL_TEXT = "null";

    public static boolean hideEditActions(@NotNull DataGrid grid, @Nullable String place) {
        if (grid == null) {
            GridUtil.$$$reportNull$$$0(0);
        }
        boolean inEditorResults = (Boolean)IN_EDITOR_RESULTS.get((UserDataHolder)grid, (Object)false);
        return "EditorToolbar".equals(place) && inEditorResults && !grid.getDataSupport().hasPendingChanges();
    }

    public static boolean hidePageActions(@NotNull DataGrid grid, @Nullable String place) {
        if (grid == null) {
            GridUtil.$$$reportNull$$$0(1);
        }
        boolean inEditorResults = (Boolean)IN_EDITOR_RESULTS.get((UserDataHolder)grid, (Object)false);
        return "EditorToolbar".equals(place) && inEditorResults && (Boolean)ShowPaginationActionKt.getSHOW_PAGINATION().get((UserDataHolder)grid, (Object)false) == false;
    }

    public static void addBottomHeader(@NotNull DataGrid grid) {
        if (grid == null) {
            GridUtil.$$$reportNull$$$0(2);
        }
        ActionManager actionManager = ActionManager.getInstance();
        ActionGroup actions = (ActionGroup)actionManager.getAction("Console.InEditorTableResult.Horizontal.Group");
        ActionToolbar toolbar = actionManager.createActionToolbar("EditorToolbar", actions, true);
        toolbar.setTargetComponent((JComponent)grid.getPanel().getComponent());
        toolbar.getComponent().setOpaque(false);
        grid.getPanel().setBottomHeaderComponent(toolbar.getComponent());
    }

    @NotNull
    public static ModelIndex<GridColumn> findColumn(@NotNull DataGrid dataGrid, @Nullable String name) {
        if (dataGrid == null) {
            GridUtil.$$$reportNull$$$0(3);
        }
        ModelIndex modelIndex = GridUtil.findColumn((GridModel)dataGrid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS), (String)name, (boolean)true);
        if (modelIndex == null) {
            GridUtil.$$$reportNull$$$0(4);
        }
        return modelIndex;
    }

    public static void focusDataGrid(DataGrid grid) {
        if (grid != null) {
            JComponent toFocus = grid.getPreferredFocusedComponent();
            IdeFocusManager.findInstanceByComponent((Component)toFocus).requestFocus((Component)toFocus, true);
        }
    }

    @NotNull
    public static DataGrid createPreviewDataGrid(@NotNull Project project, @NotNull GridDataHookUp<GridRow, GridColumn> dataHookUp, @NotNull BiConsumer<DataGrid, DataGridAppearance> configure) {
        if (project == null) {
            GridUtil.$$$reportNull$$$0(5);
        }
        if (dataHookUp == null) {
            GridUtil.$$$reportNull$$$0(6);
        }
        if (configure == null) {
            GridUtil.$$$reportNull$$$0(7);
        }
        ActionGroup popup = (ActionGroup)ActionManager.getInstance().getAction("Console.TableResult.Csv.PreviewPopupGroup");
        ActionGroup columnHeaderActions = (ActionGroup)ActionManager.getInstance().getAction("Console.TableResult.Csv.PreviewColumnHeaderPopup");
        return new TableResultPanel(project, dataHookUp, popup, null, columnHeaderActions, ActionGroup.EMPTY_GROUP, false, configure.andThen(GridUtil::configureFullSizeTable).andThen(GridUtil::disableLocalFilterByDefault));
    }

    @NotNull
    public static DataGrid createCsvPreviewDataGrid(@NotNull Project project, @NotNull DocumentDataHookUp dataHookUp) {
        if (project == null) {
            GridUtil.$$$reportNull$$$0(8);
        }
        if (dataHookUp == null) {
            GridUtil.$$$reportNull$$$0(9);
        }
        return GridUtil.createPreviewDataGrid(project, (GridDataHookUp<GridRow, GridColumn>)dataHookUp, GridUtil::configureCsvTable);
    }

    @NotNull
    public static BiConsumer<DataGrid, DataGridAppearance> configureCsvTable() {
        BiConsumer<DataGrid, DataGridAppearance> biConsumer = GridUtil::configureCsvTable;
        if (biConsumer == null) {
            GridUtil.$$$reportNull$$$0(10);
        }
        return biConsumer;
    }

    public static void configureCsvTable(@NotNull DataGrid grid, @NotNull DataGridAppearance appearance) {
        if (grid == null) {
            GridUtil.$$$reportNull$$$0(11);
        }
        if (appearance == null) {
            GridUtil.$$$reportNull$$$0(12);
        }
        GridUtil.putSettings(grid, (DataGridSettings)CsvSettingsService.getDatabaseSettings());
        GridCellEditorHelper.set((CoreGrid)grid, (GridCellEditorHelper)new GridCellEditorHelperImpl());
        GridHelper.set(grid, new GridHelperImpl());
        GridCellEditorFactoryProvider.set(grid, GridCellEditorFactoryImpl.getInstance());
        List<GridCellRendererFactory> factories = Arrays.asList(new DefaultBooleanRendererFactory(grid), new DefaultNumericRendererFactory(grid), new DefaultTextRendererFactory(grid));
        GridCellRendererFactories.set(grid, new GridCellRendererFactories(factories));
        BaseObjectFormatter formatter = new BaseObjectFormatter();
        grid.setObjectFormatterProvider(dataGrid -> formatter);
        BaseConversionGraph.set((CoreGrid)grid, (ConversionGraph)new BaseConversionGraph(new FormatsCache(), FormatterCreator.get((CoreGrid)grid), () -> grid.getObjectFormatter()));
        appearance.setResultViewShowRowNumbers(true);
        appearance.setBooleanMode(DataGridAppearanceSettings.getSettings().getBooleanMode());
    }

    public static void configureNumericEditor(@NotNull DataGrid grid, @NotNull Editor editor) {
        if (grid == null) {
            GridUtil.$$$reportNull$$$0(13);
        }
        if (editor == null) {
            GridUtil.$$$reportNull$$$0(14);
        }
        if (!(editor instanceof EditorImpl)) {
            return;
        }
        EditorImpl editorImpl = (EditorImpl)editor;
        boolean regular = !grid.getResultView().isTransposed() && grid.getPresentationMode() == GridPresentationMode.TABLE;
        int textAlignment = regular ? 1 : 0;
        int scrollbarOrientation = regular ? 0 : 1;
        editorImpl.setHorizontalTextAlignment(textAlignment);
        editorImpl.setVerticalScrollbarOrientation(scrollbarOrientation);
    }

    public static void disableLocalFilterByDefault(@NotNull DataGrid grid, @NotNull DataGridAppearance appearance) {
        if (grid == null) {
            GridUtil.$$$reportNull$$$0(15);
        }
        if (appearance == null) {
            GridUtil.$$$reportNull$$$0(16);
        }
        grid.getLocalFilterState().setEnabled(false);
    }

    public static boolean isFailedToLoad(Object value) {
        return value instanceof String && StringUtil.startsWith((CharSequence)((String)value), (CharSequence)"<failed to load>");
    }

    public static boolean showIgnoreUnsubmittedChangesYesNoDialog(@NotNull DataGrid grid) {
        if (grid == null) {
            GridUtil.$$$reportNull$$$0(17);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return true;
        }
        String title = DataGridBundle.message((String)"dialog.title.ignore.unsubmitted.changes", (Object[])new Object[0]);
        String message = DataGridBundle.message((String)"dialog.message.changes.are.submitted.data.will.be.lost.continue", (Object[])new Object[0]);
        return 0 == Messages.showYesNoDialog((Component)grid.getPanel().getComponent(), (String)message, (String)title, (Icon)AllIcons.General.NotificationWarning);
    }

    public static void showCannotApplyCellEditorChanges(@NotNull DataGrid grid) {
        if (grid == null) {
            GridUtil.$$$reportNull$$$0(18);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        String title = DataGridBundle.message((String)"dialog.title.cannot.apply.changes", (Object[])new Object[0]);
        String message = DataGridBundle.message((String)"dialog.message.this.table.read.only.changes.cannot.be.applied", (Object[])new Object[0]);
        Messages.showInfoMessage((Component)grid.getPanel().getComponent(), (String)message, (String)title);
    }

    @NotNull
    public static List<GridRow> getSelectedGridRows(@NotNull DataGrid dataGrid) {
        if (dataGrid == null) {
            GridUtil.$$$reportNull$$$0(19);
        }
        ModelIndexSet rowIndices = dataGrid.getSelectionModel().getSelectedRows();
        GridModel model2 = dataGrid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS);
        List rows = model2.getRows(rowIndices);
        List list = rows.isEmpty() ? model2.getRows() : rows;
        if (list == null) {
            GridUtil.$$$reportNull$$$0(20);
        }
        return list;
    }

    public static int min(@NotNull IndexSet<?> set) {
        OptionalInt min;
        if (set == null) {
            GridUtil.$$$reportNull$$$0(21);
        }
        return (min = set.asList().stream().mapToInt(Index::asInteger).min()).isPresent() ? min.getAsInt() : -1;
    }

    @Nullable
    public static GridMutator.RowsMutator<GridRow, GridColumn> getRowsMutator(@Nullable DataGrid grid) {
        return (GridMutator.RowsMutator)ObjectUtils.tryCast((Object)(grid == null ? null : grid.getDataHookup().getMutator()), GridMutator.RowsMutator.class);
    }

    @Nullable
    public static GridMutator.ColumnsMutator<GridRow, GridColumn> getColumnsMutator(@Nullable DataGrid grid) {
        return (GridMutator.ColumnsMutator)ObjectUtils.tryCast((Object)(grid == null ? null : grid.getDataHookup().getMutator()), GridMutator.ColumnsMutator.class);
    }

    @Nullable
    public static GridMutator.DatabaseMutator<GridRow, GridColumn> getDatabaseMutator(@Nullable DataGrid grid) {
        return (GridMutator.DatabaseMutator)ObjectUtils.tryCast((Object)(grid == null ? null : grid.getDataHookup().getMutator()), GridMutator.DatabaseMutator.class);
    }

    public static boolean isInsertedRow(@NotNull DataGrid grid, @NotNull ModelIndex<GridRow> index) {
        GridMutator.RowsMutator<GridRow, GridColumn> mutator;
        if (grid == null) {
            GridUtil.$$$reportNull$$$0(22);
        }
        if (index == null) {
            GridUtil.$$$reportNull$$$0(23);
        }
        return (mutator = GridUtil.getRowsMutator(grid)) != null && mutator.isInsertedRow(index);
    }

    @Nullable
    protected static ModelIndex<GridRow> getLastNotInsertedRow(@NotNull DataGrid grid) {
        if (grid == null) {
            GridUtil.$$$reportNull$$$0(24);
        }
        List rows = grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getRowIndices().asList();
        for (int i = rows.size() - 1; i >= 0; --i) {
            ModelIndex index = (ModelIndex)rows.get(i);
            if (GridUtil.isInsertedRow(grid, (ModelIndex<GridRow>)index)) continue;
            return index;
        }
        return null;
    }

    protected static int getInsertedRowIdx(@NotNull DataGrid grid, int relativeIndex) {
        ModelIndex<GridRow> rowIdx;
        if (grid == null) {
            GridUtil.$$$reportNull$$$0(25);
        }
        GridRow row = (rowIdx = GridUtil.getLastNotInsertedRow(grid)) == null ? null : (GridRow)grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getRow(rowIdx);
        int humanReadable = relativeIndex + 1;
        if (row == null) {
            return humanReadable;
        }
        int difference = relativeIndex - rowIdx.asInteger();
        return difference < 0 ? humanReadable : row.getRowNum() + difference;
    }

    public static void saveAndRestoreSelection(@NotNull DataGrid grid, Runnable runnable) {
        if (grid == null) {
            GridUtil.$$$reportNull$$$0(26);
        }
        GridSelection selection = grid.getSelectionModel().store();
        GridScrollPositionManager.GridScrollPosition scrollPosition = GridScrollPositionManager.get(grid.getResultView(), grid).store();
        runnable.run();
        ApplicationManager.getApplication().invokeLater(() -> {
            grid.getSelectionModel().restore(selection);
            GridScrollPositionManager.get(grid.getResultView(), grid).restore(scrollPosition);
        });
    }

    public static boolean areOnlySortedColumns(@NotNull List<ModelIndex<GridColumn>> columns, @NotNull DataGrid grid) {
        if (columns == null) {
            GridUtil.$$$reportNull$$$0(27);
        }
        if (grid == null) {
            GridUtil.$$$reportNull$$$0(28);
        }
        Set newColumns = ContainerUtil.map2Set(columns, c2 -> c2.asInteger());
        return grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getColumnIndices().asIterable().find(column -> !newColumns.contains(column.asInteger()) && grid.getSortOrder((ModelIndex<GridColumn>)column) != RowSortOrder.Type.UNSORTED) == null;
    }

    public static void scrollToLocally(@NotNull DataGrid grid, @NotNull ViewIndex<GridRow> row, @NotNull ViewIndex<GridColumn> column) {
        if (grid == null) {
            GridUtil.$$$reportNull$$$0(29);
        }
        if (row == null) {
            GridUtil.$$$reportNull$$$0(30);
        }
        if (column == null) {
            GridUtil.$$$reportNull$$$0(31);
        }
        Pair rowAndColumn = grid.getRawIndexConverter().rowAndColumn2Model().fun((Object)row.asInteger(), (Object)column.asInteger());
        grid.getSelectionModel().setSelection(ModelIndex.forRow((CoreGrid)grid, (int)((Integer)rowAndColumn.first)), ModelIndex.forColumn((CoreGrid)grid, (int)((Integer)rowAndColumn.second)));
    }

    public static void scrollToLocally(@NotNull DataGrid grid, @NotNull ViewIndex<GridRow> row) {
        if (grid == null) {
            GridUtil.$$$reportNull$$$0(32);
        }
        if (row == null) {
            GridUtil.$$$reportNull$$$0(33);
        }
        grid.getSelectionModel().setRowSelection(row.toModel((CoreGrid)grid), true);
    }

    @NotNull
    public static String getIconPath(@NotNull Icon icon) {
        if (icon == null) {
            GridUtil.$$$reportNull$$$0(34);
        }
        if (icon instanceof CachedImageIcon) {
            String path;
            CachedImageIcon cachedIcon = (CachedImageIcon)icon;
            if (ExperimentalUI.isNewUI() && (path = cachedIcon.getExpUIPath()) != null) {
                String string = path;
                if (string == null) {
                    GridUtil.$$$reportNull$$$0(35);
                }
                return string;
            }
            path = cachedIcon.getOriginalPath();
            if (path != null) {
                String string = path;
                if (string == null) {
                    GridUtil.$$$reportNull$$$0(36);
                }
                return string;
            }
        }
        LOG.warn("Don't know how to extract path for " + String.valueOf(icon));
        return "actions/stub.svg";
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public static DatabaseObjectFormatterConfig.DatabaseDisplayObjectFormatterConfig createFormatterConfig(@NotNull DataGrid grid, @NotNull ModelIndex<GridColumn> column) {
        if (grid == null) {
            GridUtil.$$$reportNull$$$0(37);
        }
        if (column == null) {
            GridUtil.$$$reportNull$$$0(38);
        }
        DatabaseObjectFormatterConfig.DatabaseDisplayObjectFormatterConfig databaseDisplayObjectFormatterConfig = Objects.requireNonNull(grid.getFormatterConfig(column));
        if (databaseDisplayObjectFormatterConfig == null) {
            GridUtil.$$$reportNull$$$0(39);
        }
        return databaseDisplayObjectFormatterConfig;
    }

    @NotNull
    public static Set<BinaryDisplayType> getAllowedTypes(@NotNull DataGrid dataGrid) {
        if (dataGrid == null) {
            GridUtil.$$$reportNull$$$0(40);
        }
        EnumSet<BinaryDisplayType> result = EnumSet.allOf(BinaryDisplayType.class);
        if (!GridUtil.isDetectTextInBinaryColumns(dataGrid)) {
            result.remove(BinaryDisplayType.TEXT);
        }
        if (!GridUtil.isDetectUUIDInBinaryColumns(dataGrid)) {
            result.remove(BinaryDisplayType.UUID);
            result.remove(BinaryDisplayType.UUID_SWAP);
        }
        EnumSet<BinaryDisplayType> enumSet = result;
        if (enumSet == null) {
            GridUtil.$$$reportNull$$$0(41);
        }
        return enumSet;
    }

    public static boolean isDetectTextInBinaryColumns(@NotNull DataGrid grid) {
        Boolean detect;
        if (grid == null) {
            GridUtil.$$$reportNull$$$0(42);
        }
        if ((detect = (Boolean)grid.getUserData(DatabaseDataKeys.DETECT_TEXT_IN_BINARY_COLUMNS)) != null) {
            return detect;
        }
        detect = GridUtil.getSetting(grid, true, DataGridSettings::isDetectTextInBinaryColumns);
        grid.putUserData(DatabaseDataKeys.DETECT_TEXT_IN_BINARY_COLUMNS, detect);
        return detect;
    }

    public static boolean isDetectUUIDInBinaryColumns(@NotNull DataGrid grid) {
        Boolean detect;
        if (grid == null) {
            GridUtil.$$$reportNull$$$0(43);
        }
        if ((detect = (Boolean)grid.getUserData(DatabaseDataKeys.DETECT_UUID_IN_BINARY_COLUMNS)) != null) {
            return detect;
        }
        detect = GridUtil.getSetting(grid, true, DataGridSettings::isDetectUUIDInBinaryColumns);
        grid.putUserData(DatabaseDataKeys.DETECT_UUID_IN_BINARY_COLUMNS, detect);
        return detect;
    }

    private static <T> T getSetting(@NotNull DataGrid grid, T defaultValue, @NotNull Function<DataGridSettings, T> function) {
        DataGridSettings settings;
        if (grid == null) {
            GridUtil.$$$reportNull$$$0(44);
        }
        if (function == null) {
            GridUtil.$$$reportNull$$$0(45);
        }
        return (settings = GridUtil.getSettings(grid)) == null ? defaultValue : function.apply(settings);
    }

    public static void globalSchemeChange(@NotNull DataGrid grid, @Nullable EditorColorsScheme scheme) {
        if (grid == null) {
            GridUtil.$$$reportNull$$$0(46);
        }
        if (scheme == null) {
            return;
        }
        grid.getColorsScheme().setDelegate(scheme);
        grid.getEditorColorsScheme().setDelegate(scheme);
    }

    public static void putSettings(@NotNull DataGrid grid, @Nullable DataGridSettings settings) {
        if (grid == null) {
            GridUtil.$$$reportNull$$$0(47);
        }
        if (settings == null) {
            return;
        }
        if (grid.getUserData(DatabaseDataKeys.DATA_GRID_SETTINGS_KEY) != null) {
            LOG.error("Settings are already put. You are overriding them");
        }
        grid.putUserData(DatabaseDataKeys.DATA_GRID_SETTINGS_KEY, settings);
    }

    @Nullable
    public static DataGridSettings getSettings(@NotNull DataGrid grid) {
        DataGridSettings result;
        if (grid == null) {
            GridUtil.$$$reportNull$$$0(48);
        }
        if ((result = (DataGridSettings)grid.getUserData(DatabaseDataKeys.DATA_GRID_SETTINGS_KEY)) == null) {
            LOG.warn(String.format("No settings for grid %s.Make sure DATA_GRID_SETTINGS_KEY set for your grid.TableResultPanel inheritors could use 'configurator' constructor parameter to pass settings", grid));
        }
        return result;
    }

    public static boolean canInsertBlob(@NotNull DataGrid grid, @NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column) {
        int type;
        if (grid == null) {
            GridUtil.$$$reportNull$$$0(49);
        }
        if (row == null) {
            GridUtil.$$$reportNull$$$0(50);
        }
        if (column == null) {
            GridUtil.$$$reportNull$$$0(51);
        }
        return (type = GridCellEditorHelper.get((CoreGrid)grid).guessJdbcTypeForEditing((CoreGrid)grid, row, column)) == -2 || type == 2004 || type == -4 || type == -3;
    }

    @Nullable
    public static TextCompletionProvider createCompletionProvider(final @NotNull DataGrid grid, @NotNull ModelIndex<GridRow> row, final @NotNull ModelIndex<GridColumn> column) {
        GridModel model2;
        GridColumn c2;
        if (grid == null) {
            GridUtil.$$$reportNull$$$0(52);
        }
        if (row == null) {
            GridUtil.$$$reportNull$$$0(53);
        }
        if (column == null) {
            GridUtil.$$$reportNull$$$0(54);
        }
        if ((c2 = (GridColumn)(model2 = grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS)).getColumn(column)) == null || !GridUtil.canComplete(grid, row, column)) {
            return null;
        }
        return new TextFieldWithAutoCompletion.StringsCompletionProvider(null, null){

            public String getPrefix(@NotNull String text, int offset) {
                if (text == null) {
                    1.$$$reportNull$$$0(0);
                }
                return text;
            }

            @NotNull
            public Collection<String> getItems(String prefix, boolean cached, CompletionParameters parameters) {
                List items = GridCellEditorHelper.get((CoreGrid)grid).getEnumValues((CoreGrid)grid, column);
                if (!items.isEmpty()) {
                    List list = items;
                    if (list == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return list;
                }
                List rows = model2.getRows();
                HashSet<String> objects = new HashSet<String>(rows.size());
                for (GridRow r : rows) {
                    Object v = c2.getValue(r);
                    if (v == null) continue;
                    String value = Objects.requireNonNullElse(grid.getObjectFormatter().objectToString(c2.getValue(r), c2, (ObjectFormatterConfig)GridUtil.createFormatterConfig(grid, (ModelIndex<GridColumn>)column)), GridUtil.NULL_TEXT);
                    objects.add(value);
                }
                HashSet<String> hashSet = objects;
                if (hashSet == null) {
                    1.$$$reportNull$$$0(2);
                }
                return hashSet;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "text";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/datagrid/GridUtil$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/datagrid/GridUtil$1";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getItems";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getPrefix";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 2 -> new IllegalStateException(string);
                };
            }
        };
    }

    private static boolean canComplete(@NotNull DataGrid grid, @NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column) {
        GridModel model2;
        GridColumn c2;
        if (grid == null) {
            GridUtil.$$$reportNull$$$0(55);
        }
        if (row == null) {
            GridUtil.$$$reportNull$$$0(56);
        }
        if (column == null) {
            GridUtil.$$$reportNull$$$0(57);
        }
        if ((c2 = (GridColumn)(model2 = grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS)).getColumn(column)) == null || GridUtil.canInsertBlob(grid, row, column)) {
            return false;
        }
        if (ObjectFormatterUtil.isNumberType((int)c2.getType())) {
            return true;
        }
        String className = c2 instanceof JdbcColumnDescriptor ? ((JdbcColumnDescriptor)c2).getJavaClassName() : null;
        return className != null && !className.equals("java.lang.Integer") || ObjectFormatterUtil.isStringType((int)c2.getType());
    }

    @Nullable
    public static DataGrid getDataGrid(DataContext dataContext) {
        FileEditor editor = (FileEditor)PlatformCoreDataKeys.FILE_EDITOR.getData(dataContext);
        if (editor instanceof TableEditorBase) {
            return ((TableEditorBase)editor).getDataGrid();
        }
        DataGrid grid = editor == null ? null : (DataGrid)editor.getUserData(DatabaseDataKeys.GRID_KEY);
        return grid != null ? grid : (DataGrid)DatabaseDataKeys.DATA_GRID_KEY.getData(dataContext);
    }

    public static boolean canInsertClob(@NotNull DataGrid grid, @NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column) {
        int type;
        if (grid == null) {
            GridUtil.$$$reportNull$$$0(58);
        }
        if (row == null) {
            GridUtil.$$$reportNull$$$0(59);
        }
        if (column == null) {
            GridUtil.$$$reportNull$$$0(60);
        }
        return (type = GridCellEditorHelper.get((CoreGrid)grid).guessJdbcTypeForEditing((CoreGrid)grid, row, column)) == 2005 || type == 2011 || type == -1 || type == -16 || type == -15 || type == 1 || type == 12 || type == -9 || type == 2009;
    }

    @NotNull
    public static LobInfo.FileBlobInfo blobFromFile(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            GridUtil.$$$reportNull$$$0(61);
        }
        return new LobInfo.FileBlobInfo(new File(virtualFile.getPath()));
    }

    public static LobInfo.FileClobInfo clobFromFile(@NotNull VirtualFile virtualFile) {
        Charset encoding;
        if (virtualFile == null) {
            GridUtil.$$$reportNull$$$0(62);
        }
        String charset = (encoding = EncodingManager.getInstance().getEncoding(virtualFile, true)) != null ? encoding.name() : null;
        File file = new File(virtualFile.getPath());
        return new LobInfo.FileClobInfo(file, charset);
    }

    @Nullable
    public static CellAttributesKey getMutationCellAttributes(@Nullable MutationType type) {
        if (type == null) {
            return null;
        }
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case MutationType.MODIFY -> CellColors.REPLACE;
            case MutationType.INSERT -> CellColors.INSERT;
            case MutationType.DELETE -> CellColors.REMOVE;
        };
    }

    @Nullable
    public static ActionCallback addRows(@NotNull DataGrid grid, int amount) {
        if (grid == null) {
            GridUtil.$$$reportNull$$$0(63);
        }
        GridMutator.RowsMutator<GridRow, GridColumn> mutator = GridUtil.getRowsMutator(grid);
        if (amount == 0 || mutator == null) {
            return null;
        }
        GridRequestSource source = GridUtil.newInsertOrCloneRowRequestSource(grid);
        if (mutator.isUpdateImmediately() && mutator.hasPendingChanges()) {
            grid.submit().doWhenDone(() -> mutator.insertRows(source, amount));
        } else {
            mutator.insertRows(source, amount);
        }
        return source.getActionCallback();
    }

    @Nullable
    public static ActionCallback addRow(@NotNull DataGrid grid) {
        if (grid == null) {
            GridUtil.$$$reportNull$$$0(64);
        }
        return GridUtil.addRows(grid, 1);
    }

    public static GridRequestSource newInsertOrCloneRowRequestSource(@NotNull DataGrid grid) {
        if (grid == null) {
            GridUtil.$$$reportNull$$$0(65);
        }
        GridRequestSource source = new GridRequestSource((GridRequestSource.RequestPlace)new DataGridRequestPlace((CoreGrid)grid));
        source.getActionCallback().doWhenDone(() -> {
            if (grid.getResultView().isEditing()) {
                return;
            }
            GridMutator.RowsMutator<GridRow, GridColumn> mutator = GridUtil.getRowsMutator(grid);
            ModelIndex row = mutator != null ? mutator.getLastInsertedRow() : ModelIndex.forRow((CoreGrid)grid, (int)-1);
            row = row != null && row.isValid((CoreGrid)grid) ? row : ModelIndex.forRow((CoreGrid)grid, (int)(grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getRowCount() - 1));
            GridUtil.scrollToLocally(grid, (ViewIndex<GridRow>)row.toView((CoreGrid)grid));
        });
        return source;
    }

    @NotNull
    @NlsSafe
    public static String extractSelectedValues(@NotNull DataGrid dataGrid, @NotNull DataExtractor extractor) {
        if (dataGrid == null) {
            GridUtil.$$$reportNull$$$0(66);
        }
        if (extractor == null) {
            GridUtil.$$$reportNull$$$0(67);
        }
        Out.Readable out = new Out.Readable();
        GridUtil.extractValues(dataGrid, extractor, (Out)out, true, true);
        String string = out.getString();
        if (string == null) {
            GridUtil.$$$reportNull$$$0(68);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    public static String extractSelectedValuesForCopy(@NotNull DataGrid dataGrid, @NotNull DataExtractor extractor) {
        if (dataGrid == null) {
            GridUtil.$$$reportNull$$$0(69);
        }
        if (extractor == null) {
            GridUtil.$$$reportNull$$$0(70);
        }
        Out.Readable out = new Out.Readable();
        GridHelper.get(dataGrid).extractValuesForCopy(dataGrid, extractor, (Out)out, true, true);
        String string = out.getString();
        if (string == null) {
            GridUtil.$$$reportNull$$$0(71);
        }
        return string;
    }

    public static void extractSelectedValues(DataGrid dataGrid, DataExtractor extractor, Out out) {
        GridUtil.extractValues(dataGrid, extractor, out, true, true);
    }

    @NotNull
    public static Out extractValues(@NotNull DataGrid dataGrid, @NotNull DataExtractor extractor, @NotNull Out out, boolean selection, boolean transpositionAllowed) {
        if (dataGrid == null) {
            GridUtil.$$$reportNull$$$0(72);
        }
        if (extractor == null) {
            GridUtil.$$$reportNull$$$0(73);
        }
        if (out == null) {
            GridUtil.$$$reportNull$$$0(74);
        }
        Out out2 = GridHelper.get(dataGrid).extractValues(dataGrid, extractor, out, selection, transpositionAllowed);
        if (out2 == null) {
            GridUtil.$$$reportNull$$$0(75);
        }
        return out2;
    }

    @NlsContexts.ColumnName
    @NotNull
    public static String getRowName(@NotNull DataGrid grid, int relativeIndex) {
        GridDataHookUp dataHookup;
        if (grid == null) {
            GridUtil.$$$reportNull$$$0(76);
        }
        boolean trueRows = (dataHookup = grid.getDataHookup()) instanceof CsvDocumentDataHookUp && ((CsvDocumentDataHookUp)dataHookup).getFormat().rowNumbers;
        ModelIndex rowIndex = trueRows ? ViewIndex.forRow((CoreGrid)grid, (int)relativeIndex).toModel((CoreGrid)grid) : ModelIndex.forRow((CoreGrid)grid, (int)relativeIndex);
        GridRow row = (GridRow)grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getRow(rowIndex);
        if (row instanceof NamedRow) {
            String string = ((NamedRow)row).name;
            if (string == null) {
                GridUtil.$$$reportNull$$$0(77);
            }
            return string;
        }
        if (row == null) {
            String string = DataGridBundle.message((String)"column.name.not.applicable", (Object[])new Object[0]);
            if (string == null) {
                GridUtil.$$$reportNull$$$0(78);
            }
            return string;
        }
        if (GridUtil.isInsertedRow(grid, (ModelIndex<GridRow>)rowIndex)) {
            String string = String.valueOf(GridUtil.getInsertedRowIdx(grid, relativeIndex));
            if (string == null) {
                GridUtil.$$$reportNull$$$0(79);
            }
            return string;
        }
        GridRow previousRow = rowIndex.asInteger() == 0 ? null : (GridRow)grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getRow(ModelIndex.forRow((CoreGrid)grid, (int)(rowIndex.asInteger() - 1)));
        String string = previousRow != null && previousRow.getRowNum() == row.getRowNum() ? "" : String.valueOf(row.getRowNum());
        if (string == null) {
            GridUtil.$$$reportNull$$$0(80);
        }
        return string;
    }

    public static void suggestPlugin(final @NotNull String id, final @Nullable Project project) {
        if (id == null) {
            GridUtil.$$$reportNull$$$0(81);
        }
        new Task.Modal(null, IdeBundle.message((String)"plugins.advertiser.task.searching.for.plugins", (Object[])new Object[0]), true){

            public void run(@NotNull ProgressIndicator indicator) {
                PluginNode descriptor;
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((descriptor = MarketplaceRequests.getInstance().getLastCompatiblePluginUpdate(PluginId.getId((String)id), null, indicator)) == null) {
                    LOG.error("Cannot find plugin " + id);
                    return;
                }
                ApplicationManager.getApplication().invokeLater(() -> {
                    try {
                        new PluginsAdvertiserDialog(project, List.of(PluginDownloader.createDownloader((IdeaPluginDescriptor)descriptor)), List.of(descriptor)).show();
                    }
                    catch (IOException e) {
                        LOG.error((Throwable)e);
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/datagrid/GridUtil$2", "run"));
            }
        }.queue();
    }

    public static void activeGridChanged(@Nullable DataGrid grid) {
        DataGrid.ActiveGridListener listener = GridUtil.activeGridListener();
        if (grid == null) {
            listener.closed();
            return;
        }
        listener.changed(grid);
    }

    public static DataGrid.ActiveGridListener activeGridListener() {
        return (DataGrid.ActiveGridListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(DataGrid.ACTIVE_GRID_CHANGED_TOPIC);
    }

    public static boolean isIntervalModifierSet(@NotNull MouseEvent e) {
        if (e == null) {
            GridUtil.$$$reportNull$$$0(82);
        }
        return 0 != (e.getModifiersEx() & 0x40);
    }

    public static boolean isExclusiveModifierSet(@NotNull MouseEvent e) {
        if (e == null) {
            GridUtil.$$$reportNull$$$0(83);
        }
        return 0 != (e.getModifiersEx() & 0x180);
    }

    public static Pair<RelativePoint, Balloon.Position> getBestPositionForBalloon(@NotNull DataGrid grid) {
        RelativePoint point;
        if (grid == null) {
            GridUtil.$$$reportNull$$$0(84);
        }
        ResultView view = grid.getResultView();
        Balloon.Position position = Balloon.Position.below;
        if (grid.getPresentationMode() == GridPresentationMode.TABLE) {
            point = JBPopupFactory.getInstance().guessBestPopupLocation(view.getComponent());
        } else if (view instanceof TreeTableResultView) {
            point = JBPopupFactory.getInstance().guessBestPopupLocation((JComponent)((TreeTableResultView)view).getComponent().getTree());
        } else {
            JBLoadingPanel component = grid.getPanel().getComponent();
            point = new RelativePoint((Component)component, new Point(component.getWidth() / 3, component.getHeight()));
            position = Balloon.Position.above;
        }
        return new Pair((Object)point, (Object)position);
    }

    @NotNull
    public static Function<Integer, ObjectFormatterConfig> getConfigProvider(@NotNull DataGrid dataGrid) {
        if (dataGrid == null) {
            GridUtil.$$$reportNull$$$0(85);
        }
        Function<Integer, ObjectFormatterConfig> function = num -> {
            ModelIndex idx = ModelIndex.forColumn((CoreGrid)dataGrid, (int)num);
            return GridUtil.createFormatterConfig(dataGrid, (ModelIndex<GridColumn>)idx);
        };
        if (function == null) {
            GridUtil.$$$reportNull$$$0(86);
        }
        return function;
    }

    @NotNull
    public static Function<Integer, ObjectFormatterConfig> getConfigProvider(@NotNull DataGrid dataGrid, boolean allowLongValues, boolean extractionMode) {
        if (dataGrid == null) {
            GridUtil.$$$reportNull$$$0(87);
        }
        Function<Integer, ObjectFormatterConfig> function = num -> {
            ModelIndex idx = ModelIndex.forColumn((CoreGrid)dataGrid, (int)num);
            DatabaseObjectFormatterConfig.DatabaseDisplayObjectFormatterConfig config = GridUtil.createFormatterConfig(dataGrid, (ModelIndex<GridColumn>)idx);
            if (allowLongValues) {
                config.allowShowBigObjects();
            }
            if (extractionMode) {
                config = config.adjustForExtraction();
            }
            return config;
        };
        if (function == null) {
            GridUtil.$$$reportNull$$$0(88);
        }
        return function;
    }

    public static boolean canMutateColumns(@Nullable DataGrid grid) {
        return grid != null && GridHelper.get(grid).canMutateColumns(grid);
    }

    public static ActionGroup getGridColumnHeaderPopupActions() {
        return (ActionGroup)ActionManager.getInstance().getAction("Console.TableResult.ColumnHeaderPopup");
    }

    public static void showErrorBalloon(@NotNull ErrorInfo errorInfo, Component component, Point point) {
        if (errorInfo == null) {
            GridUtil.$$$reportNull$$$0(89);
        }
        if (component == null || !component.isVisible() || !component.isShowing()) {
            return;
        }
        String errorText = errorInfo.getMessage();
        errorText = GridUtil.wrap(errorText, 50, "\n", true);
        errorText = StringUtil.trimLog((String)errorText, (int)200);
        errorText = StringUtil.trimTrailing((String)errorText);
        @NlsSafe StringBuilder balloonContent = new StringBuilder(errorText);
        HyperlinkListener hyperlinkListener = null;
        @NlsSafe Throwable throwable = errorInfo.getOriginalThrowable();
        if (throwable != null) {
            String errorFullText = ExceptionUtil.getThrowableText((Throwable)throwable, (String)"com.intellij.");
            String detailsLinkMessage = " <a href=\"more\">" + DataGridBundle.message((String)"message.hyperlink.click.for.more", (Object[])new Object[0]) + "</a>";
            balloonContent.append(detailsLinkMessage);
            hyperlinkListener = e -> {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && "more".equals(e.getDescription())) {
                    Messages.showIdeaMessageDialog(null, (String)errorFullText, (String)DataGridBundle.message((String)"dialog.title.query.error", (Object[])new Object[0]), (String[])new String[]{CommonBundle.getOkButtonText()}, (int)0, (Icon)Messages.getErrorIcon(), null);
                }
            };
        }
        BalloonBuilder builder = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(balloonContent.toString(), MessageType.ERROR, hyperlinkListener).setClickHandler(e -> {}, true).setShowCallout(true).setHideOnAction(true).setHideOnClickOutside(true);
        Balloon balloon = builder.createBalloon();
        balloon.show(new RelativePoint(component, point), Balloon.Position.below);
    }

    public static String wrap(@NotNull String str, int wrapLength, String newLineStr, boolean wrapLongWords) {
        if (str == null) {
            GridUtil.$$$reportNull$$$0(90);
        }
        if (newLineStr == null) {
            newLineStr = "\n";
        }
        if (wrapLength < 1) {
            wrapLength = 1;
        }
        int inputLineLength = str.length();
        int offset = 0;
        StringBuilder wrappedLine = new StringBuilder(inputLineLength + 32);
        while (inputLineLength - offset > wrapLength) {
            if (str.charAt(offset) == ' ') {
                ++offset;
                continue;
            }
            int spaceToWrapAt = str.lastIndexOf(32, wrapLength + offset);
            if (spaceToWrapAt >= offset) {
                wrappedLine.append(str, offset, spaceToWrapAt);
                wrappedLine.append(newLineStr);
                offset = spaceToWrapAt + 1;
                continue;
            }
            if (wrapLongWords) {
                wrappedLine.append(str, offset, wrapLength + offset);
                wrappedLine.append(newLineStr);
                offset += wrapLength;
                continue;
            }
            spaceToWrapAt = str.indexOf(32, wrapLength + offset);
            if (spaceToWrapAt >= 0) {
                wrappedLine.append(str, offset, spaceToWrapAt);
                wrappedLine.append(newLineStr);
                offset = spaceToWrapAt + 1;
                continue;
            }
            wrappedLine.append(str.substring(offset));
            offset = inputLineLength;
        }
        wrappedLine.append(str.substring(offset));
        return wrappedLine.toString();
    }

    @NotNull
    public static GridPasteProvider.TableDataParseResult retrieveDataFromText(@NotNull Project project, @NotNull String text, @NotNull DataGrid grid) {
        if (project == null) {
            GridUtil.$$$reportNull$$$0(91);
        }
        if (text == null) {
            GridUtil.$$$reportNull$$$0(92);
        }
        if (grid == null) {
            GridUtil.$$$reportNull$$$0(93);
        }
        GridHelper helper = GridHelper.get(grid);
        ChoosePasteFormatAction.PasteType type = ChoosePasteFormatAction.PasteType.get();
        Pair<List<String[]>, CsvFormat> res = type.getParser().parse(project, text);
        List parsed = (List)res.getFirst();
        CsvFormat format = (CsvFormat)res.getSecond();
        ArrayList<DataTypeConversion.Builder> conversions = new ArrayList<DataTypeConversion.Builder>();
        ArrayList<DataConsumer.Column> columns = new ArrayList<DataConsumer.Column>();
        for (int i = 0; i < parsed.size(); ++i) {
            String[] record = (String[])parsed.get(i);
            for (int j = 0; j < record.length; ++j) {
                String value = record[j];
                if (columns.size() <= j) {
                    columns.add(new DataConsumer.Column(j, "dummy", 12, "text", String.class.getName()));
                }
                GridColumn column = (GridColumn)columns.get(j);
                conversions.add(GridUtil.createBuilder(i, column, value, helper));
            }
        }
        return new GridPasteProvider.TableDataParseResult(new GridTransferableData(conversions, (Transferable)new TextTransferable(text), 0, 0, parsed.size()), type, format);
    }

    @NotNull
    private static DataTypeConversion.Builder createBuilder(int row, @NotNull GridColumn column, Object value, @NotNull GridHelper helper) {
        if (column == null) {
            GridUtil.$$$reportNull$$$0(94);
        }
        if (helper == null) {
            GridUtil.$$$reportNull$$$0(95);
        }
        DataTypeConversion.Builder builder = helper.createDataTypeConversionBuilder().firstColumn(column).firstRowIdx(row).firstColumnIdx(column.getColumnNumber()).firstGrid(null).value(value);
        if (builder == null) {
            GridUtil.$$$reportNull$$$0(96);
        }
        return builder;
    }

    @Nullable
    public static VirtualFile getVirtualFile(@Nullable CoreGrid<GridRow, GridColumn> grid) {
        return grid == null ? null : GridUtil.getVirtualFile(grid.getDataHookup());
    }

    @Nullable
    public static VirtualFile getVirtualFile(@Nullable GridDataHookUp<?, ?> hookup) {
        return hookup instanceof HookUpVirtualFileProvider ? ((HookUpVirtualFileProvider)hookup).getVirtualFile() : null;
    }

    @NotNull
    public static PsiElement getPsiElementForSelection(@NotNull DataGrid grid) {
        SelectionModel selectionModel;
        if (grid == null) {
            GridUtil.$$$reportNull$$$0(97);
        }
        if ((selectionModel = grid.getSelectionModel()).isSelectionEmpty()) {
            PsiElement psiElement = DataGridPomTarget.wrapDataGrid(grid.getProject(), grid);
            if (psiElement == null) {
                GridUtil.$$$reportNull$$$0(98);
            }
            return psiElement;
        }
        PsiElement psiElement = DataGridPomTarget.wrapCell(grid.getProject(), grid, (ModelIndexSet<GridRow>)selectionModel.getSelectedRows(), (ModelIndexSet<GridColumn>)selectionModel.getSelectedColumns());
        if (psiElement == null) {
            GridUtil.$$$reportNull$$$0(99);
        }
        return psiElement;
    }

    public static ActionGroup getGridPopupActions() {
        return (ActionGroup)ActionManager.getInstance().getAction("Console.TableResult.PopupGroup");
    }

    @Nullable
    public static DocumentDataHookUp getDocumentDataHookUp(@NotNull CoreGrid<GridRow, GridColumn> grid) {
        if (grid == null) {
            GridUtil.$$$reportNull$$$0(100);
        }
        return (DocumentDataHookUp)GridUtil.getHookUp(grid, DocumentDataHookUp.class);
    }

    @NotNull
    public static JComponent addGridHeaderComponent(@NotNull DataGrid dataGrid) {
        if (dataGrid == null) {
            GridUtil.$$$reportNull$$$0(101);
        }
        return GridUtil.addGridHeaderComponent(dataGrid, false, "Console.EditorTableResult.Group", "Console.TableResult.Group.Secondary");
    }

    @NotNull
    public static JComponent addGridHeaderComponent(@NotNull DataGrid dataGrid, boolean transparent, @Nullable String actionGroupName, @NotNull String secondaryActionsGroupName) {
        if (dataGrid == null) {
            GridUtil.$$$reportNull$$$0(102);
        }
        if (secondaryActionsGroupName == null) {
            GridUtil.$$$reportNull$$$0(103);
        }
        ActionManager actionManager = ActionManager.getInstance();
        EmptyActionGroup actions = actionGroupName == null ? new EmptyActionGroup() : (ActionGroup)actionManager.getAction(actionGroupName);
        ActionGroup secondaryActions = (ActionGroup)actionManager.getAction(secondaryActionsGroupName);
        return GridUtil.addGridHeaderComponent(dataGrid, transparent, (ActionGroup)actions, secondaryActions);
    }

    @NotNull
    public static JComponent addGridHeaderComponent(@NotNull DataGrid dataGrid, boolean transparent, ActionGroup actions, ActionGroup secondaryActions) {
        if (dataGrid == null) {
            GridUtil.$$$reportNull$$$0(104);
        }
        ActionManager actionManager = ActionManager.getInstance();
        ActionToolbar toolbar = actionManager.createActionToolbar("EditorToolbar", actions, true);
        ActionToolbar toolbarSecondary = actionManager.createActionToolbar("EditorToolbar", secondaryActions, true);
        toolbar.setTargetComponent((JComponent)dataGrid.getPanel().getComponent());
        toolbarSecondary.setTargetComponent((JComponent)dataGrid.getPanel().getComponent());
        toolbarSecondary.setReservePlaceAutoPopupIcon(false);
        TwoSideComponent header = new TwoSideComponent(toolbar.getComponent(), toolbarSecondary.getComponent());
        Insets insets = JBUI.CurrentTheme.Toolbar.horizontalToolbarInsets();
        JBEmptyBorder border = insets == null ? JBUI.Borders.empty((int)1, (int)0, (int)0, (int)5) : JBUI.Borders.empty((int)insets.top, (int)insets.left, (int)(insets.bottom - 1), (int)insets.right);
        header.setBorder(new CompoundBorder(JBUI.Borders.customLine((Color)JBUI.CurrentTheme.Editor.BORDER_COLOR, (int)0, (int)0, (int)1, (int)0), (Border)border));
        toolbar.getComponent().setBorder((Border)JBUI.Borders.empty());
        toolbarSecondary.getComponent().setBorder((Border)JBUI.Borders.empty());
        header.setOpaque(!transparent);
        toolbar.getComponent().setOpaque(!transparent);
        toolbarSecondary.getComponent().setOpaque(!transparent);
        dataGrid.getPanel().setTopComponent((Component)header);
        if (dataGrid.isFilteringSupported()) {
            dataGrid.getPanel().setSecondTopComponent(dataGrid.getFilterComponent().getComponent());
        }
        TwoSideComponent twoSideComponent = header;
        if (twoSideComponent == null) {
            GridUtil.$$$reportNull$$$0(105);
        }
        return twoSideComponent;
    }

    @NotNull
    public static JComponent addVerticalGridHeaderComponent(@NotNull DataGrid dataGrid, @Nullable String actionGroupName) {
        if (dataGrid == null) {
            GridUtil.$$$reportNull$$$0(106);
        }
        ActionManager actionManager = ActionManager.getInstance();
        EmptyActionGroup actions = actionGroupName == null ? new EmptyActionGroup() : (ActionGroup)actionManager.getAction(actionGroupName);
        ActionToolbar toolbar = actionManager.createActionToolbar("EditorToolbar", (ActionGroup)actions, false);
        toolbar.setTargetComponent((JComponent)dataGrid.getPanel().getComponent());
        toolbar.getComponent().setOpaque(false);
        Insets insets = toolbar.getComponent().getBorder().getBorderInsets(toolbar.getComponent());
        toolbar.getComponent().setBorder((Border)new JBEmptyBorder(0, insets.left, 0, insets.right));
        dataGrid.getPanel().setRightHeaderComponent(toolbar.getComponent());
        if (dataGrid.isFilteringSupported()) {
            dataGrid.getPanel().setSecondTopComponent(dataGrid.getFilterComponent().getComponent());
        }
        JComponent jComponent = toolbar.getComponent();
        if (jComponent == null) {
            GridUtil.$$$reportNull$$$0(107);
        }
        return jComponent;
    }

    public static FileEditor getOrCreateEditorWrapper(final @NotNull DataGrid resultPanel, @NotNull Project project, final @NotNull Supplier<@Nls String> getName) {
        JBLoadingPanel dataGridComponent;
        TableEditorBase editor;
        if (resultPanel == null) {
            GridUtil.$$$reportNull$$$0(108);
        }
        if (project == null) {
            GridUtil.$$$reportNull$$$0(109);
        }
        if (getName == null) {
            GridUtil.$$$reportNull$$$0(110);
        }
        if ((editor = (TableEditorBase)((Object)ClientProperty.get((Component)(dataGridComponent = resultPanel.getPanel().getComponent()), FILE_EDITOR_KEY))) == null) {
            editor = new TableEditorBase(project){
                private final LightVirtualFile myFile;
                {
                    super(project);
                    this.myFile = new LightVirtualFile(this.getName(), (FileType)TableDataFragmentFile.MyFileType.INSTANCE, (CharSequence)"");
                }

                @Override
                public void dispose() {
                    super.dispose();
                    this.myFile.setValid(false);
                }

                public VirtualFile getFile() {
                    return this.myFile;
                }

                @Override
                public boolean isValid() {
                    return this.myFile.isValid();
                }

                @Override
                @NotNull
                public DataGrid getDataGrid() {
                    DataGrid dataGrid = resultPanel;
                    if (dataGrid == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    return dataGrid;
                }

                @Override
                @NotNull
                public String getName() {
                    String name = (String)getName.get();
                    String string = name != null ? name : super.getName();
                    if (string == null) {
                        3.$$$reportNull$$$0(1);
                    }
                    return string;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = "com/intellij/database/datagrid/GridUtil$3";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getDataGrid";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getName";
                            break;
                        }
                    }
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                }
            };
            dataGridComponent.putClientProperty(FILE_EDITOR_KEY, (Object)editor);
            Disposer.register((Disposable)resultPanel, (Disposable)editor);
        }
        return editor;
    }

    @NlsContexts.NotificationContent
    @NotNull
    public static String getContent(@NlsContexts.NotificationContent @NotNull String content, @NotNull String path) {
        if (content == null) {
            GridUtil.$$$reportNull$$$0(111);
        }
        if (path == null) {
            GridUtil.$$$reportNull$$$0(112);
        }
        String string = content + (StringUtil.isEmpty((String)content) ? "" : " ") + GridUtil.wrapInOpenFileLink((String)path);
        if (string == null) {
            GridUtil.$$$reportNull$$$0(113);
        }
        return string;
    }

    public static void configureFullSizeTable(@NotNull DataGrid grid, @NotNull DataGridAppearance appearance) {
        if (grid == null) {
            GridUtil.$$$reportNull$$$0(114);
        }
        if (appearance == null) {
            GridUtil.$$$reportNull$$$0(115);
        }
        appearance.setResultViewAdditionalRowsCount(5);
        appearance.setResultViewSetShowHorizontalLines(true);
        appearance.setResultViewStriped(DataGridAppearanceSettings.getSettings().isStripedTable());
        appearance.setTransparentRowHeaderBackground(true);
    }

    public static void withFloatingPaging(@NotNull DataGrid grid, @NotNull DataGridAppearance appearance) {
        if (grid == null) {
            GridUtil.$$$reportNull$$$0(116);
        }
        if (appearance == null) {
            GridUtil.$$$reportNull$$$0(117);
        }
        grid.putUserData(FloatingPagingManager.AVAILABLE_FOR_GRID_TYPE, true);
    }

    @NotNull
    public static DataGrid createDataGrid(@NotNull Project project, @NotNull GridDataHookUp<GridRow, GridColumn> dataHookUp, @NotNull ActionGroup popupActions, @NotNull BiConsumer<DataGrid, DataGridAppearance> configure) {
        if (project == null) {
            GridUtil.$$$reportNull$$$0(118);
        }
        if (dataHookUp == null) {
            GridUtil.$$$reportNull$$$0(119);
        }
        if (popupActions == null) {
            GridUtil.$$$reportNull$$$0(120);
        }
        if (configure == null) {
            GridUtil.$$$reportNull$$$0(121);
        }
        return GridUtil.createDataGrid(project, dataHookUp, popupActions, configure, false);
    }

    @NotNull
    public static DataGrid createDataGrid(@NotNull Project project, @NotNull GridDataHookUp<GridRow, GridColumn> dataHookUp, @NotNull ActionGroup popupActions, @NotNull BiConsumer<DataGrid, DataGridAppearance> configure, boolean isHierarchicalGrid) {
        if (project == null) {
            GridUtil.$$$reportNull$$$0(122);
        }
        if (dataHookUp == null) {
            GridUtil.$$$reportNull$$$0(123);
        }
        if (popupActions == null) {
            GridUtil.$$$reportNull$$$0(124);
        }
        if (configure == null) {
            GridUtil.$$$reportNull$$$0(125);
        }
        if (isHierarchicalGrid) {
            return new HierarchicalTableResultPanel(project, dataHookUp, popupActions, configure);
        }
        return new TableResultPanel(project, dataHookUp, popupActions, configure);
    }

    @Nullable
    public static String getEditorTabName(@NotNull DataGrid grid) {
        VirtualFile file;
        if (grid == null) {
            GridUtil.$$$reportNull$$$0(126);
        }
        return (file = GridUtil.getVirtualFile(grid)) == null ? null : file.getNameWithoutExtension();
    }

    public static boolean collapseColumnsSubtree(@NotNull DataGrid grid, @NotNull ModelIndex<GridColumn> columnIdx, int subtreeRootDepth) {
        if (grid == null) {
            GridUtil.$$$reportNull$$$0(127);
        }
        if (columnIdx == null) {
            GridUtil.$$$reportNull$$$0(128);
        }
        return GridUtil.collapseColumnsSubtree(grid, columnIdx, subtreeRootDepth, null);
    }

    public static boolean collapseColumnsSubtree(@NotNull DataGrid grid, @NotNull ModelIndex<GridColumn> columnIdx, int subtreeRootDepth, @Nullable Runnable onCollapseCompleted) {
        GridModel model2;
        HierarchicalReader hierarchicalReader;
        if (grid == null) {
            GridUtil.$$$reportNull$$$0(129);
        }
        if (columnIdx == null) {
            GridUtil.$$$reportNull$$$0(130);
        }
        if ((hierarchicalReader = (model2 = grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS)).getHierarchicalReader()) == null) {
            return false;
        }
        GridColumn column = (GridColumn)model2.getColumn(columnIdx);
        if (column == null) {
            return false;
        }
        if (!(column instanceof HierarchicalColumnsDataGridModel.HierarchicalGridColumn)) {
            return false;
        }
        HierarchicalColumnsDataGridModel.HierarchicalGridColumn hierarchicalColumn = (HierarchicalColumnsDataGridModel.HierarchicalGridColumn)column;
        HierarchicalColumnsDataGridModel.HierarchicalGridColumn ancestor = hierarchicalReader.getAncestorAtDepth(hierarchicalColumn, subtreeRootDepth);
        if (ancestor == null || ancestor.getChildren().isEmpty()) {
            return false;
        }
        List children = hierarchicalReader.getAllLeafNodesInSubtree(ancestor);
        HierarchicalColumnsCollapseManager collapseManager = grid.getHierarchicalColumnsCollapseManager();
        if (collapseManager == null) {
            return false;
        }
        boolean shouldCollapse = !collapseManager.isColumnCollapsedSubtree(columnIdx);
        boolean shouldExpand = !shouldCollapse;
        for (ModelIndex idx : grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getColumnIndices().asIterable()) {
            GridColumn c2 = (GridColumn)model2.getColumn(idx);
            if (c2 == null || !children.contains(c2)) continue;
            if (c2.equals(column)) {
                collapseManager.setIsCollapsedSubtree(column, shouldCollapse);
                continue;
            }
            if (shouldExpand && collapseManager.isColumnCollapsedSubtree(c2)) {
                collapseManager.setIsCollapsedSubtree(c2, false);
            }
            collapseManager.setIsHiddenDueToCollapse(c2, shouldCollapse);
            if (!grid.isColumnEnabled(idx)) continue;
            grid.getResultView().setColumnEnabled((ModelIndex<GridColumn>)ModelIndex.forColumn((GridModel)model2, (int)c2.getColumnNumber()), shouldExpand);
        }
        if (onCollapseCompleted != null) {
            onCollapseCompleted.run();
        }
        grid.getResultView().columnAttributesUpdated();
        return true;
    }

    @NotNull
    public static String getText(@NotNull DataGrid grid, @NotNull ModelIndex<GridRow> rowIdx, @NotNull ModelIndex<GridColumn> columnIdx) {
        if (grid == null) {
            GridUtil.$$$reportNull$$$0(131);
        }
        if (rowIdx == null) {
            GridUtil.$$$reportNull$$$0(132);
        }
        if (columnIdx == null) {
            GridUtil.$$$reportNull$$$0(133);
        }
        return GridUtil.getText(grid, rowIdx, columnIdx, DataAccessType.DATA_WITH_MUTATIONS);
    }

    @NotNull
    public static String getText(@NotNull DataGrid grid, @NotNull ModelIndex<GridRow> rowIdx, @NotNull ModelIndex<GridColumn> columnIdx, @NotNull DataAccessType dataAccessType) {
        GridModel model2;
        GridRow row;
        if (grid == null) {
            GridUtil.$$$reportNull$$$0(134);
        }
        if (rowIdx == null) {
            GridUtil.$$$reportNull$$$0(135);
        }
        if (columnIdx == null) {
            GridUtil.$$$reportNull$$$0(136);
        }
        if (dataAccessType == null) {
            GridUtil.$$$reportNull$$$0(137);
        }
        if ((row = (GridRow)(model2 = grid.getDataModel(dataAccessType)).getRow(rowIdx)) == null) {
            return NULL_TEXT;
        }
        GridColumn column = (GridColumn)model2.getColumn(columnIdx);
        if (column == null) {
            return NULL_TEXT;
        }
        return GridUtil.getText(grid, row, column, GridUtil.createFormatterConfig(grid, columnIdx));
    }

    @NotNull
    public static String getText(@NotNull DataGrid grid, @NotNull GridRow row, @NotNull GridColumn column, @NotNull DatabaseObjectFormatterConfig.DatabaseDisplayObjectFormatterConfig config) {
        if (grid == null) {
            GridUtil.$$$reportNull$$$0(138);
        }
        if (row == null) {
            GridUtil.$$$reportNull$$$0(139);
        }
        if (column == null) {
            GridUtil.$$$reportNull$$$0(140);
        }
        if (config == null) {
            GridUtil.$$$reportNull$$$0(141);
        }
        String value = grid.getObjectFormatter().objectToString(column.getValue(row), column, (ObjectFormatterConfig)config);
        String string = Objects.requireNonNullElse(value, NULL_TEXT);
        if (string == null) {
            GridUtil.$$$reportNull$$$0(142);
        }
        return string;
    }

    @Nullable
    public static HierarchicalColumnsDataGridModel.HierarchicalGridColumn getClosestAncestorWithSelectedDirectLeaf(@NotNull DataGrid grid, @NotNull HierarchicalColumnsDataGridModel.HierarchicalGridColumn leaf) {
        if (grid == null) {
            GridUtil.$$$reportNull$$$0(143);
        }
        if (leaf == null) {
            GridUtil.$$$reportNull$$$0(144);
        }
        for (HierarchicalColumnsDataGridModel.HierarchicalGridColumn currentNode = leaf; currentNode != null; currentNode = currentNode.getParent()) {
            if (!GridUtil.isAnyDirectLeafChildSelected(grid, currentNode)) continue;
            return currentNode;
        }
        return null;
    }

    @Nullable
    public static HierarchicalColumnsDataGridModel.HierarchicalGridColumn getLastAncestorWithSelectedDirectLeaf(@NotNull DataGrid grid, @NotNull HierarchicalColumnsDataGridModel.HierarchicalGridColumn startingNode) {
        if (grid == null) {
            GridUtil.$$$reportNull$$$0(145);
        }
        if (startingNode == null) {
            GridUtil.$$$reportNull$$$0(146);
        }
        HierarchicalColumnsDataGridModel.HierarchicalGridColumn highestAncestorWithSelectedChild = null;
        for (HierarchicalColumnsDataGridModel.HierarchicalGridColumn currentNode = startingNode; currentNode != null; currentNode = currentNode.getParent()) {
            if (!GridUtil.isAnyDirectLeafChildSelected(grid, currentNode)) continue;
            highestAncestorWithSelectedChild = currentNode;
        }
        return highestAncestorWithSelectedChild;
    }

    private static boolean isAnyDirectLeafChildSelected(@NotNull DataGrid grid, @NotNull HierarchicalColumnsDataGridModel.HierarchicalGridColumn currentNode) {
        if (grid == null) {
            GridUtil.$$$reportNull$$$0(147);
        }
        if (currentNode == null) {
            GridUtil.$$$reportNull$$$0(148);
        }
        return ContainerUtil.exists((Iterable)currentNode.getChildren(), child -> {
            if (!child.isLeaf()) {
                return false;
            }
            ModelIndex childModelIdx = ModelIndex.forColumn((CoreGrid)grid, (int)child.getColumnNumber());
            return grid.getSelectionModel().isSelectedColumn(childModelIdx);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 10, 20, 35, 36, 39, 41, 68, 71, 75, 77, 78, 79, 80, 86, 88, 96, 98, 99, 105, 107, 113, 142 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 3: 
            case 19: 
            case 40: 
            case 66: 
            case 69: 
            case 72: 
            case 85: 
            case 87: 
            case 101: 
            case 102: 
            case 104: 
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataGrid";
                break;
            }
            case 4: 
            case 10: 
            case 20: 
            case 35: 
            case 36: 
            case 39: 
            case 41: 
            case 68: 
            case 71: 
            case 75: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 86: 
            case 88: 
            case 96: 
            case 98: 
            case 99: 
            case 105: 
            case 107: 
            case 113: 
            case 142: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/datagrid/GridUtil";
                break;
            }
            case 5: 
            case 8: 
            case 91: 
            case 109: 
            case 118: 
            case 122: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 9: 
            case 119: 
            case 123: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataHookUp";
                break;
            }
            case 7: 
            case 121: 
            case 125: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configure";
                break;
            }
            case 12: 
            case 16: 
            case 115: 
            case 117: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appearance";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 30: 
            case 33: 
            case 50: 
            case 53: 
            case 56: 
            case 59: 
            case 139: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 31: 
            case 38: 
            case 51: 
            case 54: 
            case 57: 
            case 60: 
            case 94: 
            case 140: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 61: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 67: 
            case 70: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extractor";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 82: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorInfo";
                break;
            }
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "secondaryActionsGroupName";
                break;
            }
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultPanel";
                break;
            }
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getName";
                break;
            }
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 112: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 120: 
            case 124: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popupActions";
                break;
            }
            case 128: 
            case 130: 
            case 133: 
            case 136: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnIdx";
                break;
            }
            case 132: 
            case 135: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowIdx";
                break;
            }
            case 137: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataAccessType";
                break;
            }
            case 141: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 144: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leaf";
                break;
            }
            case 146: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startingNode";
                break;
            }
            case 148: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/datagrid/GridUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findColumn";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "configureCsvTable";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedGridRows";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getIconPath";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "createFormatterConfig";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllowedTypes";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "extractSelectedValues";
                break;
            }
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "extractSelectedValuesForCopy";
                break;
            }
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "extractValues";
                break;
            }
            case 77: 
            case 78: 
            case 79: 
            case 80: {
                objectArray = objectArray2;
                objectArray2[1] = "getRowName";
                break;
            }
            case 86: 
            case 88: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigProvider";
                break;
            }
            case 96: {
                objectArray = objectArray2;
                objectArray2[1] = "createBuilder";
                break;
            }
            case 98: 
            case 99: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiElementForSelection";
                break;
            }
            case 105: {
                objectArray = objectArray2;
                objectArray2[1] = "addGridHeaderComponent";
                break;
            }
            case 107: {
                objectArray = objectArray2;
                objectArray2[1] = "addVerticalGridHeaderComponent";
                break;
            }
            case 113: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent";
                break;
            }
            case 142: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "hideEditActions";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "hidePageActions";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addBottomHeader";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findColumn";
                break;
            }
            case 4: 
            case 10: 
            case 20: 
            case 35: 
            case 36: 
            case 39: 
            case 41: 
            case 68: 
            case 71: 
            case 75: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 86: 
            case 88: 
            case 96: 
            case 98: 
            case 99: 
            case 105: 
            case 107: 
            case 113: 
            case 142: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createPreviewDataGrid";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createCsvPreviewDataGrid";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "configureCsvTable";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "configureNumericEditor";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "disableLocalFilterByDefault";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "showIgnoreUnsubmittedChangesYesNoDialog";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "showCannotApplyCellEditorChanges";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedGridRows";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "min";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isInsertedRow";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getLastNotInsertedRow";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getInsertedRowIdx";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "saveAndRestoreSelection";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "areOnlySortedColumns";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "scrollToLocally";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getIconPath";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "createFormatterConfig";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getAllowedTypes";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "isDetectTextInBinaryColumns";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "isDetectUUIDInBinaryColumns";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getSetting";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "globalSchemeChange";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "putSettings";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getSettings";
                break;
            }
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "canInsertBlob";
                break;
            }
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "createCompletionProvider";
                break;
            }
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "canComplete";
                break;
            }
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "canInsertClob";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "blobFromFile";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "clobFromFile";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "addRows";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "addRow";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "newInsertOrCloneRowRequestSource";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "extractSelectedValues";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "extractSelectedValuesForCopy";
                break;
            }
            case 72: 
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "extractValues";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "getRowName";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "suggestPlugin";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "isIntervalModifierSet";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "isExclusiveModifierSet";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "getBestPositionForBalloon";
                break;
            }
            case 85: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "getConfigProvider";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "showErrorBalloon";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "wrap";
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "retrieveDataFromText";
                break;
            }
            case 94: 
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "createBuilder";
                break;
            }
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "getPsiElementForSelection";
                break;
            }
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "getDocumentDataHookUp";
                break;
            }
            case 101: 
            case 102: 
            case 103: 
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "addGridHeaderComponent";
                break;
            }
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "addVerticalGridHeaderComponent";
                break;
            }
            case 108: 
            case 109: 
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateEditorWrapper";
                break;
            }
            case 111: 
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "getContent";
                break;
            }
            case 114: 
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "configureFullSizeTable";
                break;
            }
            case 116: 
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "withFloatingPaging";
                break;
            }
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: {
                objectArray = objectArray;
                objectArray[2] = "createDataGrid";
                break;
            }
            case 126: {
                objectArray = objectArray;
                objectArray[2] = "getEditorTabName";
                break;
            }
            case 127: 
            case 128: 
            case 129: 
            case 130: {
                objectArray = objectArray;
                objectArray[2] = "collapseColumnsSubtree";
                break;
            }
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: {
                objectArray = objectArray;
                objectArray[2] = "getText";
                break;
            }
            case 143: 
            case 144: {
                objectArray = objectArray;
                objectArray[2] = "getClosestAncestorWithSelectedDirectLeaf";
                break;
            }
            case 145: 
            case 146: {
                objectArray = objectArray;
                objectArray[2] = "getLastAncestorWithSelectedDirectLeaf";
                break;
            }
            case 147: 
            case 148: {
                objectArray = objectArray;
                objectArray[2] = "isAnyDirectLeafChildSelected";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 10, 20, 35, 36, 39, 41, 68, 71, 75, 77, 78, 79, 80, 86, 88, 96, 98, 99, 105, 107, 113, 142 -> new IllegalStateException(string);
        };
    }

    public static class GridRevealFileAction
    extends AnAction {
        private final String myPath;

        public GridRevealFileAction(@NotNull String path) {
            if (path == null) {
                GridRevealFileAction.$$$reportNull$$$0(0);
            }
            super(RevealFileAction.getActionName());
            this.myPath = path;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                GridRevealFileAction.$$$reportNull$$$0(1);
            }
            RevealFileAction.openFile((File)new File(this.myPath));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/datagrid/GridUtil$GridRevealFileAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class FileNotificationListener
    implements NotificationListener {
        private final String myPath;
        private final Project myProject;

        public FileNotificationListener(@NotNull Project project, @NotNull String path) {
            if (project == null) {
                FileNotificationListener.$$$reportNull$$$0(0);
            }
            if (path == null) {
                FileNotificationListener.$$$reportNull$$$0(1);
            }
            this.myPath = path;
            this.myProject = project;
        }

        public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
            if (notification == null) {
                FileNotificationListener.$$$reportNull$$$0(2);
            }
            if (event == null) {
                FileNotificationListener.$$$reportNull$$$0(3);
            }
            if (!"Open file".equals(event.getDescription()) || event.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                return;
            }
            File file = new File(this.myPath);
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
                if (virtualFile == null) {
                    DataGridNotifications.EXTRACTORS_GROUP.createNotification(DataGridBundle.message((String)"notification.content.can.t.access.file", (Object[])new Object[]{this.myPath}), NotificationType.WARNING).setDisplayId("FileNotificationListener.cant.access").notify(this.myProject);
                    return;
                }
                VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)false, (boolean)false, (VirtualFile[])new VirtualFile[]{virtualFile});
                ApplicationManager.getApplication().invokeLater(() -> FileNotificationListener.showFile(this.myProject, virtualFile));
            });
        }

        private static void showFile(@NotNull Project project, @NotNull VirtualFile virtualFile) {
            if (project == null) {
                FileNotificationListener.$$$reportNull$$$0(4);
            }
            if (virtualFile == null) {
                FileNotificationListener.$$$reportNull$$$0(5);
            }
            if (virtualFile.isDirectory()) {
                RevealFileAction.openDirectory((File)VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile));
                return;
            }
            if (SingleRootFileViewProvider.isTooLargeForIntelligence((VirtualFile)virtualFile) || virtualFile.getFileType().isBinary()) {
                RevealFileAction.openFile((File)VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile));
                return;
            }
            FileEditorManager.getInstance((Project)project).openEditor(new OpenFileDescriptor(project, virtualFile), true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "notification";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "virtualFile";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/datagrid/GridUtil$FileNotificationListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "hyperlinkUpdate";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "showFile";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

