/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XValue;
import com.jetbrains.python.console.PyConsoleIndentUtil;
import com.jetbrains.python.debugger.PyDebugSupportUtils;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.PyDebuggerException;
import com.jetbrains.python.debugger.PyFrameAccessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyDebuggerEvaluator
extends XDebuggerEvaluator {
    private final Project myProject;
    private final PyFrameAccessor myDebugProcess;

    public PyDebuggerEvaluator(@NotNull Project project, @NotNull PyFrameAccessor debugProcess) {
        if (project == null) {
            PyDebuggerEvaluator.$$$reportNull$$$0(0);
        }
        if (debugProcess == null) {
            PyDebuggerEvaluator.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myDebugProcess = debugProcess;
    }

    public void evaluate(@NotNull String expression, @NotNull XDebuggerEvaluator.XEvaluationCallback callback, @Nullable XSourcePosition expressionPosition) {
        if (expression == null) {
            PyDebuggerEvaluator.$$$reportNull$$$0(2);
        }
        if (callback == null) {
            PyDebuggerEvaluator.$$$reportNull$$$0(3);
        }
        this.doEvaluate(expression, callback, true);
    }

    private PyDebugValue getNone() {
        return new PyDebugValue("", "NoneType", null, "None", false, null, null, false, false, false, null, null, this.myDebugProcess);
    }

    private void doEvaluate(String expr, XDebuggerEvaluator.XEvaluationCallback callback, boolean doTrunc) {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            String expression = expr.trim();
            if (expression.isEmpty()) {
                callback.evaluated((XValue)this.getNone());
                return;
            }
            boolean isExpression = PyDebugSupportUtils.isExpression(this.myProject, expression);
            try {
                PyDebugValue value = this.myDebugProcess.evaluate(expression, !isExpression, doTrunc);
                if (value.isErrorOnEval()) {
                    callback.errorOccurred("{" + value.getType() + "}" + value.getValue());
                } else {
                    callback.evaluated((XValue)value);
                }
            }
            catch (PyDebuggerException e) {
                callback.errorOccurred(e.getTracebackError());
            }
        });
    }

    @Nullable
    public TextRange getExpressionRangeAtOffset(Project project, Document document, int offset, boolean sideEffectsAllowed) {
        return PyDebugSupportUtils.getExpressionRangeAtOffset(project, document, offset);
    }

    @NotNull
    public String formatTextForEvaluation(@NotNull String text) {
        if (text == null) {
            PyDebuggerEvaluator.$$$reportNull$$$0(4);
        }
        String string = PyConsoleIndentUtil.normalize(text);
        if (string == null) {
            PyDebuggerEvaluator.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/debugger/PyDebuggerEvaluator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/debugger/PyDebuggerEvaluator";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "formatTextForEvaluation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "evaluate";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "formatTextForEvaluation";
                break;
            }
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

