/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.impl.sshj;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ssh.RemoteFileObject;
import com.intellij.ssh.SftpChannelException;
import com.intellij.ssh.impl.sshj.SshjLazyLstatHolder;
import com.intellij.ssh.impl.sshj.SshjRemoteFileObjectKt;
import com.intellij.ssh.impl.sshj.UtilKt;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.schmizz.sshj.sftp.FileAttributes;
import net.schmizz.sshj.sftp.FileMode;
import net.schmizz.sshj.sftp.OpenMode;
import net.schmizz.sshj.sftp.RemoteFile;
import net.schmizz.sshj.sftp.RemoteResourceInfo;
import net.schmizz.sshj.sftp.Response;
import net.schmizz.sshj.sftp.SFTPClient;
import net.schmizz.sshj.sftp.SFTPException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B5\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fB+\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\rJ\b\u0010\u0010\u001a\u00020\nH\u0016J\b\u0010\u0011\u001a\u00020\nH\u0016J\b\u0010\u0012\u001a\u00020\nH\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0015\u001a\u00020\u0005H\u0016J\u0010\u0010\u001c\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0005H\u0016J\u001a\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00010\u001eH\u0016J\u001c\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00010\u001e2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u001eH\u0002J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020\nH\u0016J\b\u0010%\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020#2\u0006\u0010(\u001a\u00020\u0017H\u0016J!\u0010)\u001a\u00020#2\u0017\u0010*\u001a\u0013\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020#0+\u00a2\u0006\u0002\b-H\u0002J\u0010\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\nH\u0016J\b\u00101\u001a\u00020\u0017H\u0016J\u0010\u00102\u001a\u00020#2\u0006\u00103\u001a\u00020\u0005H\u0016J\b\u00104\u001a\u00020\u0014H\u0016J\u0010\u00105\u001a\u00020#2\u0006\u0010(\u001a\u00020\u0014H\u0016J\b\u00106\u001a\u00020\u0005H\u0016J\"\u00107\u001a\u0002H8\"\u0004\b\u0000\u001082\f\u00109\u001a\b\u0012\u0004\u0012\u0002H80:H\u0082\b\u00a2\u0006\u0002\u0010;J\b\u0010<\u001a\u00020#H\u0016J\b\u0010=\u001a\u00020\u0005H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0019\u00a8\u0006>"}, d2={"Lcom/intellij/ssh/impl/sshj/SshjRemoteFileObject;", "Lcom/intellij/ssh/RemoteFileObject;", "sftp", "Lnet/schmizz/sshj/sftp/SFTPClient;", "path", "", "ownerName", "fileAttributes", "Lnet/schmizz/sshj/sftp/FileAttributes;", "surelyImaginary", "", "<init>", "(Lnet/schmizz/sshj/sftp/SFTPClient;Ljava/lang/String;Ljava/lang/String;Lnet/schmizz/sshj/sftp/FileAttributes;Z)V", "(Lnet/schmizz/sshj/sftp/SFTPClient;Ljava/lang/String;Ljava/lang/String;Z)V", "lstat", "Lcom/intellij/ssh/impl/sshj/SshjLazyLstatHolder;", "exists", "isDir", "isSymbolicLink", "size", "", "name", "permissions", "", "getPermissions", "()I", "UId", "getUId", "child", "list", "", "createChildren", "remoteResourceInfos", "Lnet/schmizz/sshj/sftp/RemoteResourceInfo;", "mkdir", "", "rm", "inputStream", "Ljava/io/InputStream;", "setPermissions", "value", "updateFileAttributes", "block", "Lkotlin/Function1;", "Lnet/schmizz/sshj/sftp/FileAttributes$Builder;", "Lkotlin/ExtensionFunctionType;", "outputStream", "Ljava/io/OutputStream;", "append", "getGroupId", "moveTo", "newAbsolutePath", "getLastModifiedTime", "setLastModifiedTime", "canonicalPath", "mutableAction", "T", "handler", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "clearCachedData", "toString", "intellij.platform.ssh"})
@SourceDebugExtension(value={"SMAP\nSshjRemoteFileObject.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SshjRemoteFileObject.kt\ncom/intellij/ssh/impl/sshj/SshjRemoteFileObject\n+ 2 Util.kt\ncom/intellij/ssh/impl/sshj/UtilKt\n+ 3 SshjRemoteFileObject.kt\ncom/intellij/ssh/impl/sshj/SshjRemoteFileObjectKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,248:1\n168#1,2:312\n172#1,2:329\n168#1,2:365\n172#1,2:397\n168#1,2:482\n172#1,2:499\n168#1,2:535\n172#1,2:552\n168#1,2:588\n172#1,2:605\n36#2,3:249\n40#2,28:267\n33#2,6:306\n40#2,28:331\n33#2,6:359\n40#2,28:399\n33#2,6:427\n40#2,28:448\n33#2,6:476\n40#2,28:501\n33#2,6:529\n40#2,28:554\n33#2,6:582\n40#2,28:607\n33#2,6:635\n40#2,28:656\n233#3,15:252\n233#3,15:314\n233#3,15:367\n233#3,15:382\n233#3,15:433\n233#3,15:484\n233#3,15:537\n233#3,15:590\n233#3,15:641\n1740#4,3:295\n1563#4:298\n1634#4,3:299\n1563#4:302\n1634#4,3:303\n*S KotlinDebug\n*F\n+ 1 SshjRemoteFileObject.kt\ncom/intellij/ssh/impl/sshj/SshjRemoteFileObject\n*L\n69#1:312,2\n69#1:329,2\n81#1:365,2\n81#1:397,2\n118#1:482,2\n118#1:499,2\n130#1:535,2\n130#1:552,2\n151#1:588,2\n151#1:605,2\n41#1:249,3\n41#1:267,28\n68#1:306,6\n68#1:331,28\n74#1:359,6\n74#1:399,28\n102#1:427,6\n102#1:448,28\n117#1:476,6\n117#1:501,28\n125#1:529,6\n125#1:554,28\n150#1:582,6\n150#1:607,28\n160#1:635,6\n160#1:656,28\n42#1:252,15\n70#1:314,15\n84#1:367,15\n87#1:382,15\n103#1:433,15\n120#1:484,15\n131#1:537,15\n152#1:590,15\n161#1:641,15\n53#1:295,3\n59#1:298\n59#1:299,3\n65#1:302\n65#1:303,3\n*E\n"})
public final class SshjRemoteFileObject
implements RemoteFileObject {
    @NotNull
    private final SFTPClient sftp;
    @NotNull
    private final String path;
    @NotNull
    private final String ownerName;
    @NotNull
    private final SshjLazyLstatHolder lstat;

    private SshjRemoteFileObject(SFTPClient sftp, String path, String ownerName, FileAttributes fileAttributes, boolean surelyImaginary) {
        this.sftp = sftp;
        this.path = path;
        this.ownerName = ownerName;
        this.lstat = new SshjLazyLstatHolder(this.sftp, this.path, fileAttributes, surelyImaginary);
    }

    /* synthetic */ SshjRemoteFileObject(SFTPClient sFTPClient, String string, String string2, FileAttributes fileAttributes, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            bl = false;
        }
        this(sFTPClient, string, string2, fileAttributes, bl);
    }

    public SshjRemoteFileObject(@NotNull SFTPClient sftp, @NotNull String path, @NotNull String ownerName, boolean surelyImaginary) {
        Intrinsics.checkNotNullParameter((Object)sftp, (String)"sftp");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)ownerName, (String)"ownerName");
        this(sftp, path, ownerName, null, surelyImaginary);
    }

    public /* synthetic */ SshjRemoteFileObject(SFTPClient sFTPClient, String string, String string2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = false;
        }
        this(sFTPClient, string, string2, bl);
    }

    @Override
    public boolean exists() {
        return this.lstat.isFileExist();
    }

    @Override
    public boolean isDir() {
        return this.lstat.getOrThrow().getType() == FileMode.Type.DIRECTORY;
    }

    @Override
    public boolean isSymbolicLink() {
        return this.lstat.getOrThrow().getType() == FileMode.Type.SYMLINK;
    }

    @Override
    public long size() {
        return this.lstat.getOrThrow().getSize();
    }

    @Override
    @NotNull
    public String path() {
        return this.path;
    }

    @Override
    @NotNull
    public String name() {
        return UtilKt.posixBasename(this.path);
    }

    @Override
    public int getPermissions() {
        return this.lstat.getOrThrow().getMode().getMask();
    }

    @Override
    public int getUId() {
        return this.lstat.getOrThrow().getUID();
    }

    @Override
    @NotNull
    public RemoteFileObject child(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.child(name, null);
    }

    private final SshjRemoteFileObject child(String name, FileAttributes fileAttributes) {
        return new SshjRemoteFileObject(this.sftp, this.path + "/" + name, this.ownerName, fileAttributes, false, 16, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<RemoteFileObject> list() {
        boolean logNoSuchFileError$iv = true;
        boolean log$iv = true;
        boolean $i$f$wrapSshjSftpException = false;
        try {
            List list;
            boolean bl = false;
            boolean $i$f$measureCall = false;
            if (!UtilKt.getSSHJ_LOG().isDebugEnabled()) {
                boolean bl2 = false;
                list = this.sftp.ls(this.path);
            } else {
                List list2;
                long start$iv = System.nanoTime();
                String state$iv = "ok";
                try {
                    boolean bl3 = false;
                    list2 = this.sftp.ls(this.path);
                }
                catch (Throwable e$iv) {
                    state$iv = "exception";
                    throw e$iv;
                }
                finally {
                    long end$iv = System.nanoTime();
                    Logger logger = UtilKt.getSSHJ_LOG();
                    boolean bl4 = false;
                    logger.debug("Called " + (this + ".sftp.ls()") + " in " + SshjRemoteFileObjectKt.access$getMeasureCallDecimalFormat$p().format((double)(end$iv - start$iv) / 1000000.0) + " ms (" + state$iv + ")");
                }
                list = list2;
            }
            List dirList = $i$f$measureCall = list;
            boolean bl5 = false;
            Logger logger = UtilKt.getSSHJ_LOG();
            Intrinsics.checkNotNull((Object)dirList);
            logger.debug("list() results:\n" + CollectionsKt.joinToString$default((Iterable)dirList, (CharSequence)"\n", null, null, (int)0, null, SshjRemoteFileObject::list$lambda$5$lambda$4$lambda$3, (int)30, null));
            List ls = $i$f$measureCall;
            Intrinsics.checkNotNull((Object)ls);
            return this.createChildren(ls);
        }
        catch (SFTPException e$iv) {
            IOException it = (IOException)((Object)e$iv);
            boolean bl = false;
            String message$iv = "Failed to list files in path " + this.path;
            Response.StatusCode statusCode = e$iv.getStatusCode();
            switch (statusCode == null ? -1 : UtilKt.WhenMappings.$EnumSwitchMapping$0[statusCode.ordinal()]) {
                case 1: {
                    if (UtilKt.getSSHJ_LOG().isDebugEnabled()) {
                        UtilKt.getSSHJ_LOG().debug(message$iv, (Throwable)e$iv);
                    }
                    UtilKt.getSSHJ_LOG().info(message$iv);
                    break;
                }
                case 2: {
                    if (UtilKt.getSSHJ_LOG().isDebugEnabled()) {
                        UtilKt.getSSHJ_LOG().debug(message$iv, (Throwable)e$iv);
                    }
                    UtilKt.getSSHJ_LOG().warn(message$iv);
                    break;
                }
                default: {
                    UtilKt.getSSHJ_LOG().warn(message$iv, (Throwable)e$iv);
                }
            }
            throw SftpChannelException.Companion.create(e$iv.getStatusCode().getCode(), message$iv, e$iv);
        }
        catch (IOException e$iv) {
            IOException it = e$iv;
            boolean bl = false;
            String message$iv = "Failed to list files in path " + this.path;
            UtilKt.getSSHJ_LOG().warn(message$iv, (Throwable)e$iv);
            throw SftpChannelException.Companion.create(-1, message$iv, e$iv);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final List<RemoteFileObject> createChildren(List<? extends RemoteResourceInfo> remoteResourceInfos) {
        block7: {
            block6: {
                block8: {
                    if (!Intrinsics.areEqual((Object)this.path, (Object)"/")) break block7;
                    $this$all$iv = remoteResourceInfos;
                    $i$f$all = false;
                    if (!($this$all$iv instanceof Collection) || !((Collection)$this$all$iv).isEmpty()) break block8;
                    v0 = true;
                    break block6;
                }
                for (T element$iv : $this$all$iv) {
                    it = (RemoteResourceInfo)element$iv;
                    $i$a$-all-SshjRemoteFileObject$createChildren$isWindowsRoot$1 = false;
                    if (!it.isDirectory() || it.getName().length() != 2) ** GOTO lbl-1000
                    var9_14 = it.getName().charAt(0);
                    v1 = 'A' <= var9_14 ? var9_14 < '[' : false;
                    if (v1 && it.getName().charAt(1) == ':') {
                        v2 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v2 = false;
                    }
                    if (v2) continue;
                    v0 = false;
                    break block6;
                }
                v0 = isWindowsRoot = true;
            }
            if (isWindowsRoot) {
                $this$map$iv = remoteResourceInfos;
                $i$f$map = false;
                var5_6 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var10_19 = (RemoteResourceInfo)item$iv$iv;
                    var12_22 = destination$iv$iv;
                    $i$a$-map-SshjRemoteFileObject$createChildren$1 = false;
                    var12_22.add(new SshjRemoteFileObject(this.sftp, "/" + it.getName() + "/", this.ownerName, it.getAttributes(), false, 16, null));
                }
                return (List)destination$iv$iv;
            }
        }
        $this$map$iv = remoteResourceInfos;
        $i$f$map = false;
        $i$f$map = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            item$iv$iv = (RemoteResourceInfo)item$iv$iv;
            var12_23 = destination$iv$iv;
            $i$a$-map-SshjRemoteFileObject$createChildren$2 = false;
            v3 = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getName(...)");
            var12_23.add(this.child(v3, it.getAttributes()));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mkdir() {
        String file$iv = this.path;
        boolean logNoSuchFileError$iv = true;
        boolean log$iv = true;
        boolean $i$f$wrapSshjSftpException = false;
        boolean bl = logNoSuchFileError$iv;
        boolean log$iv$iv = log$iv;
        boolean $i$f$wrapSshjSftpException2 = false;
        try {
            boolean bl2 = false;
            SshjRemoteFileObject this_$iv = this;
            boolean $i$f$mutableAction = false;
            try {
                boolean bl3 = false;
                boolean $i$f$measureCall = false;
                if (!UtilKt.getSSHJ_LOG().isDebugEnabled()) {
                    boolean bl4 = false;
                    this.sftp.mkdir(this.path);
                } else {
                    long start$iv = System.nanoTime();
                    String state$iv = "ok";
                    try {
                        boolean bl5 = false;
                        this.sftp.mkdir(this.path);
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable e$iv) {
                        state$iv = "exception";
                        throw e$iv;
                    }
                    finally {
                        long end$iv = System.nanoTime();
                        Logger logger = UtilKt.getSSHJ_LOG();
                        boolean bl6 = false;
                        logger.debug("Called " + (this + ".mkdir()") + " in " + SshjRemoteFileObjectKt.access$getMeasureCallDecimalFormat$p().format((double)(end$iv - start$iv) / 1000000.0) + " ms (" + state$iv + ")");
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                this_$iv.lstat.clear();
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (SFTPException e$iv$iv) {
            IOException it$iv = (IOException)((Object)e$iv$iv);
            boolean bl7 = false;
            String message$iv$iv = "File " + file$iv + ": " + it$iv.getMessage();
            Response.StatusCode statusCode = e$iv$iv.getStatusCode();
            switch (statusCode == null ? -1 : UtilKt.WhenMappings.$EnumSwitchMapping$0[statusCode.ordinal()]) {
                case 1: {
                    if (UtilKt.getSSHJ_LOG().isDebugEnabled()) {
                        UtilKt.getSSHJ_LOG().debug(message$iv$iv, (Throwable)e$iv$iv);
                    }
                    UtilKt.getSSHJ_LOG().info(message$iv$iv);
                    break;
                }
                case 2: {
                    if (UtilKt.getSSHJ_LOG().isDebugEnabled()) {
                        UtilKt.getSSHJ_LOG().debug(message$iv$iv, (Throwable)e$iv$iv);
                    }
                    UtilKt.getSSHJ_LOG().warn(message$iv$iv);
                    break;
                }
                default: {
                    UtilKt.getSSHJ_LOG().warn(message$iv$iv, (Throwable)e$iv$iv);
                }
            }
            throw SftpChannelException.Companion.create(e$iv$iv.getStatusCode().getCode(), message$iv$iv, e$iv$iv);
        }
        catch (IOException e$iv$iv) {
            IOException it$iv = e$iv$iv;
            boolean bl8 = false;
            String message$iv$iv = "File " + file$iv + ": " + it$iv.getMessage();
            UtilKt.getSSHJ_LOG().warn(message$iv$iv, (Throwable)e$iv$iv);
            throw SftpChannelException.Companion.create(-1, message$iv$iv, e$iv$iv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean rm() {
        boolean bl;
        String file$iv = this.path;
        boolean logNoSuchFileError$iv = true;
        boolean log$iv = true;
        boolean $i$f$wrapSshjSftpException = false;
        boolean bl2 = logNoSuchFileError$iv;
        boolean log$iv$iv = log$iv;
        boolean $i$f$wrapSshjSftpException2 = false;
        try {
            boolean bl3;
            boolean bl4 = false;
            SshjRemoteFileObject this_$iv = this;
            boolean $i$f$mutableAction = false;
            try {
                boolean bl5;
                boolean bl6 = false;
                try {
                    block31: {
                        try {
                            boolean $i$f$measureCall = false;
                            if (!UtilKt.getSSHJ_LOG().isDebugEnabled()) {
                                boolean bl7 = false;
                                this.sftp.rm(this.path);
                                break block31;
                            }
                            long start$iv = System.nanoTime();
                            String state$iv = "ok";
                            try {
                                boolean bl8 = false;
                                this.sftp.rm(this.path);
                                Unit unit = Unit.INSTANCE;
                            }
                            catch (Throwable e$iv) {
                                state$iv = "exception";
                                throw e$iv;
                            }
                            finally {
                                long end$iv = System.nanoTime();
                                Logger logger = UtilKt.getSSHJ_LOG();
                                boolean bl9 = false;
                                logger.debug("Called " + (this + ".sftp.rm()") + " in " + SshjRemoteFileObjectKt.access$getMeasureCallDecimalFormat$p().format((double)(end$iv - start$iv) / 1000000.0) + " ms (" + state$iv + ")");
                            }
                        }
                        catch (SFTPException e) {
                            boolean $i$f$measureCall = false;
                            if (!UtilKt.getSSHJ_LOG().isDebugEnabled()) {
                                boolean bl10 = false;
                                this.sftp.rmdir(this.path);
                            }
                            long start$iv = System.nanoTime();
                            String state$iv = "ok";
                            try {
                                boolean bl11 = false;
                                this.sftp.rmdir(this.path);
                                Unit unit = Unit.INSTANCE;
                            }
                            catch (Throwable e$iv) {
                                state$iv = "exception";
                                throw e$iv;
                            }
                            finally {
                                long end$iv = System.nanoTime();
                                Logger logger = UtilKt.getSSHJ_LOG();
                                boolean bl12 = false;
                                logger.debug("Called " + (this + ".sftp.rmdir()") + " in " + SshjRemoteFileObjectKt.access$getMeasureCallDecimalFormat$p().format((double)(end$iv - start$iv) / 1000000.0) + " ms (" + state$iv + ")");
                            }
                        }
                    }
                    bl5 = true;
                }
                catch (SFTPException e) {
                    UtilKt.getSSHJ_LOG().debug(this + ".rm(): Got error " + e);
                    Response.StatusCode statusCode = e.getStatusCode();
                    switch (statusCode == null ? -1 : WhenMappings.$EnumSwitchMapping$0[statusCode.ordinal()]) {
                        case 1: 
                        case 2: {
                            break;
                        }
                        default: {
                            throw e;
                        }
                    }
                    bl5 = false;
                }
                bl3 = bl5;
            }
            finally {
                this_$iv.lstat.clear();
            }
            bl = bl3;
        }
        catch (SFTPException e$iv$iv) {
            IOException it$iv = (IOException)((Object)e$iv$iv);
            boolean bl13 = false;
            String message$iv$iv = "File " + file$iv + ": " + it$iv.getMessage();
            Response.StatusCode statusCode = e$iv$iv.getStatusCode();
            switch (statusCode == null ? -1 : UtilKt.WhenMappings.$EnumSwitchMapping$0[statusCode.ordinal()]) {
                case 1: {
                    if (UtilKt.getSSHJ_LOG().isDebugEnabled()) {
                        UtilKt.getSSHJ_LOG().debug(message$iv$iv, (Throwable)e$iv$iv);
                    }
                    UtilKt.getSSHJ_LOG().info(message$iv$iv);
                    break;
                }
                case 2: {
                    if (UtilKt.getSSHJ_LOG().isDebugEnabled()) {
                        UtilKt.getSSHJ_LOG().debug(message$iv$iv, (Throwable)e$iv$iv);
                    }
                    UtilKt.getSSHJ_LOG().warn(message$iv$iv);
                    break;
                }
                default: {
                    UtilKt.getSSHJ_LOG().warn(message$iv$iv, (Throwable)e$iv$iv);
                }
            }
            throw SftpChannelException.Companion.create(e$iv$iv.getStatusCode().getCode(), message$iv$iv, e$iv$iv);
        }
        catch (IOException e$iv$iv) {
            IOException it$iv = e$iv$iv;
            boolean bl14 = false;
            String message$iv$iv = "File " + file$iv + ": " + it$iv.getMessage();
            UtilKt.getSSHJ_LOG().warn(message$iv$iv, (Throwable)e$iv$iv);
            throw SftpChannelException.Companion.create(-1, message$iv$iv, e$iv$iv);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public InputStream inputStream() {
        FilterInputStream filterInputStream;
        String file$iv = this.path;
        boolean logNoSuchFileError$iv = true;
        boolean log$iv = true;
        boolean $i$f$wrapSshjSftpException = false;
        boolean bl = logNoSuchFileError$iv;
        boolean log$iv$iv = log$iv;
        boolean $i$f$wrapSshjSftpException2 = false;
        try {
            RemoteFile remoteFile;
            boolean bl2 = false;
            boolean $i$f$measureCall = false;
            if (!UtilKt.getSSHJ_LOG().isDebugEnabled()) {
                boolean bl3 = false;
                remoteFile = this.sftp.open(this.path);
            } else {
                RemoteFile remoteFile2;
                long start$iv = System.nanoTime();
                String state$iv = "ok";
                try {
                    boolean bl4 = false;
                    remoteFile2 = this.sftp.open(this.path);
                }
                catch (Throwable e$iv) {
                    state$iv = "exception";
                    throw e$iv;
                }
                finally {
                    long end$iv = System.nanoTime();
                    Logger logger = UtilKt.getSSHJ_LOG();
                    boolean bl5 = false;
                    logger.debug("Called " + (this + ".sftp.open()") + " in " + SshjRemoteFileObjectKt.access$getMeasureCallDecimalFormat$p().format((double)(end$iv - start$iv) / 1000000.0) + " ms (" + state$iv + ")");
                }
                remoteFile = remoteFile2;
            }
            RemoteFile file = remoteFile;
            RemoteFile.ReadAheadRemoteFileInputStream readAheadRemoteFileInputStream = new RemoteFile.ReadAheadRemoteFileInputStream(file, 10);
            filterInputStream = new FilterInputStream(file, readAheadRemoteFileInputStream){
                final /* synthetic */ RemoteFile $file;
                {
                    this.$file = $file;
                    super((InputStream)$super_call_param$1);
                }

                public void close() {
                    UtilKt.getSSHJ_LOG().debug(this + ".inputStream() is being closed");
                    super.close();
                    this.$file.close();
                }
            };
        }
        catch (SFTPException e$iv$iv) {
            IOException it$iv = (IOException)((Object)e$iv$iv);
            boolean bl6 = false;
            String message$iv$iv = "File " + file$iv + ": " + it$iv.getMessage();
            Response.StatusCode statusCode = e$iv$iv.getStatusCode();
            switch (statusCode == null ? -1 : UtilKt.WhenMappings.$EnumSwitchMapping$0[statusCode.ordinal()]) {
                case 1: {
                    if (UtilKt.getSSHJ_LOG().isDebugEnabled()) {
                        UtilKt.getSSHJ_LOG().debug(message$iv$iv, (Throwable)e$iv$iv);
                    }
                    UtilKt.getSSHJ_LOG().info(message$iv$iv);
                    break;
                }
                case 2: {
                    if (UtilKt.getSSHJ_LOG().isDebugEnabled()) {
                        UtilKt.getSSHJ_LOG().debug(message$iv$iv, (Throwable)e$iv$iv);
                    }
                    UtilKt.getSSHJ_LOG().warn(message$iv$iv);
                    break;
                }
                default: {
                    UtilKt.getSSHJ_LOG().warn(message$iv$iv, (Throwable)e$iv$iv);
                }
            }
            throw SftpChannelException.Companion.create(e$iv$iv.getStatusCode().getCode(), message$iv$iv, e$iv$iv);
        }
        catch (IOException e$iv$iv) {
            IOException it$iv = e$iv$iv;
            boolean bl7 = false;
            String message$iv$iv = "File " + file$iv + ": " + it$iv.getMessage();
            UtilKt.getSSHJ_LOG().warn(message$iv$iv, (Throwable)e$iv$iv);
            throw SftpChannelException.Companion.create(-1, message$iv$iv, e$iv$iv);
        }
        return filterInputStream;
    }

    @Override
    public void setPermissions(int value) {
        this.updateFileAttributes((Function1<? super FileAttributes.Builder, Unit>)((Function1)arg_0 -> SshjRemoteFileObject.setPermissions$lambda$22(value, arg_0)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void updateFileAttributes(Function1<? super FileAttributes.Builder, Unit> block) {
        String file$iv = this.path;
        boolean logNoSuchFileError$iv = true;
        boolean log$iv = true;
        boolean $i$f$wrapSshjSftpException = false;
        boolean bl = logNoSuchFileError$iv;
        boolean log$iv$iv = log$iv;
        boolean $i$f$wrapSshjSftpException2 = false;
        try {
            boolean bl2 = false;
            SshjRemoteFileObject this_$iv = this;
            boolean $i$f$mutableAction = false;
            try {
                boolean bl3 = false;
                FileAttributes.Builder builder = new FileAttributes.Builder();
                block.invoke((Object)builder);
                FileAttributes newAttrs = builder.build();
                boolean $i$f$measureCall = false;
                if (!UtilKt.getSSHJ_LOG().isDebugEnabled()) {
                    boolean bl4 = false;
                    this.sftp.setattr(this.path, newAttrs);
                } else {
                    long start$iv = System.nanoTime();
                    String state$iv = "ok";
                    try {
                        boolean bl5 = false;
                        this.sftp.setattr(this.path, newAttrs);
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable e$iv) {
                        state$iv = "exception";
                        throw e$iv;
                    }
                    finally {
                        long end$iv = System.nanoTime();
                        Logger logger = UtilKt.getSSHJ_LOG();
                        boolean bl6 = false;
                        logger.debug("Called " + (this + ".sftp.setattr(" + newAttrs + ")") + " in " + SshjRemoteFileObjectKt.access$getMeasureCallDecimalFormat$p().format((double)(end$iv - start$iv) / 1000000.0) + " ms (" + state$iv + ")");
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                this_$iv.lstat.clear();
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (SFTPException e$iv$iv) {
            IOException it$iv = (IOException)((Object)e$iv$iv);
            boolean bl7 = false;
            String message$iv$iv = "File " + file$iv + ": " + it$iv.getMessage();
            Response.StatusCode statusCode = e$iv$iv.getStatusCode();
            switch (statusCode == null ? -1 : UtilKt.WhenMappings.$EnumSwitchMapping$0[statusCode.ordinal()]) {
                case 1: {
                    if (UtilKt.getSSHJ_LOG().isDebugEnabled()) {
                        UtilKt.getSSHJ_LOG().debug(message$iv$iv, (Throwable)e$iv$iv);
                    }
                    UtilKt.getSSHJ_LOG().info(message$iv$iv);
                    break;
                }
                case 2: {
                    if (UtilKt.getSSHJ_LOG().isDebugEnabled()) {
                        UtilKt.getSSHJ_LOG().debug(message$iv$iv, (Throwable)e$iv$iv);
                    }
                    UtilKt.getSSHJ_LOG().warn(message$iv$iv);
                    break;
                }
                default: {
                    UtilKt.getSSHJ_LOG().warn(message$iv$iv, (Throwable)e$iv$iv);
                }
            }
            throw SftpChannelException.Companion.create(e$iv$iv.getStatusCode().getCode(), message$iv$iv, e$iv$iv);
        }
        catch (IOException e$iv$iv) {
            IOException it$iv = e$iv$iv;
            boolean bl8 = false;
            String message$iv$iv = "File " + file$iv + ": " + it$iv.getMessage();
            UtilKt.getSSHJ_LOG().warn(message$iv$iv, (Throwable)e$iv$iv);
            throw SftpChannelException.Companion.create(-1, message$iv$iv, e$iv$iv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public OutputStream outputStream(boolean append) {
        String file$iv = this.path;
        boolean logNoSuchFileError$iv = true;
        boolean log$iv = true;
        boolean $i$f$wrapSshjSftpException = false;
        boolean bl = logNoSuchFileError$iv;
        boolean log$iv$iv = log$iv;
        boolean $i$f$wrapSshjSftpException2 = false;
        try {
            FilterOutputStream filterOutputStream;
            boolean bl2 = false;
            EnumSet<Enum> enumSet = EnumSet.of((Enum)OpenMode.CREAT, (Enum)OpenMode.WRITE, (Enum)(append ? OpenMode.APPEND : OpenMode.TRUNC));
            Intrinsics.checkNotNullExpressionValue(enumSet, (String)"of(...)");
            Set mode = enumSet;
            SshjRemoteFileObject this_$iv = this;
            boolean $i$f$mutableAction = false;
            try {
                RemoteFile remoteFile;
                boolean bl3 = false;
                boolean $i$f$measureCall = false;
                if (!UtilKt.getSSHJ_LOG().isDebugEnabled()) {
                    $i$a$-measureCall-SshjRemoteFileObject$outputStream$1$1$file$2 = false;
                    remoteFile = this.sftp.open(this.path, mode);
                } else {
                    RemoteFile remoteFile2;
                    long start$iv = System.nanoTime();
                    String state$iv = "ok";
                    try {
                        $i$a$-measureCall-SshjRemoteFileObject$outputStream$1$1$file$2 = false;
                        remoteFile2 = this.sftp.open(this.path, mode);
                    }
                    catch (Throwable e$iv) {
                        state$iv = "exception";
                        throw e$iv;
                    }
                    finally {
                        long end$iv = System.nanoTime();
                        Logger logger = UtilKt.getSSHJ_LOG();
                        boolean bl4 = false;
                        logger.debug("Called " + (this + ".sftp.open(" + mode + ")") + " in " + SshjRemoteFileObjectKt.access$getMeasureCallDecimalFormat$p().format((double)(end$iv - start$iv) / 1000000.0) + " ms (" + state$iv + ")");
                    }
                    remoteFile = remoteFile2;
                }
                RemoteFile file = remoteFile;
                RemoteFile.RemoteFileOutputStream realOutputStream = new RemoteFile.RemoteFileOutputStream(file, 0L, 10);
                filterOutputStream = new FilterOutputStream(realOutputStream, file){
                    final /* synthetic */ RemoteFile.RemoteFileOutputStream $realOutputStream;
                    final /* synthetic */ RemoteFile $file;
                    {
                        this.$realOutputStream = $realOutputStream;
                        this.$file = $file;
                        super((OutputStream)$realOutputStream);
                    }

                    public void write(byte[] b, int off, int len) {
                        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
                        this.$realOutputStream.write(b, off, len);
                    }

                    public void close() {
                        UtilKt.getSSHJ_LOG().debug(this + ".outputStream() is being closed");
                        super.close();
                        this.$file.close();
                    }
                };
            }
            finally {
                this_$iv.lstat.clear();
            }
            return filterOutputStream;
        }
        catch (SFTPException e$iv$iv) {
            IOException it$iv = (IOException)((Object)e$iv$iv);
            boolean bl5 = false;
            String message$iv$iv = "File " + file$iv + ": " + it$iv.getMessage();
            Response.StatusCode statusCode = e$iv$iv.getStatusCode();
            switch (statusCode == null ? -1 : UtilKt.WhenMappings.$EnumSwitchMapping$0[statusCode.ordinal()]) {
                case 1: {
                    if (UtilKt.getSSHJ_LOG().isDebugEnabled()) {
                        UtilKt.getSSHJ_LOG().debug(message$iv$iv, (Throwable)e$iv$iv);
                    }
                    UtilKt.getSSHJ_LOG().info(message$iv$iv);
                    break;
                }
                case 2: {
                    if (UtilKt.getSSHJ_LOG().isDebugEnabled()) {
                        UtilKt.getSSHJ_LOG().debug(message$iv$iv, (Throwable)e$iv$iv);
                    }
                    UtilKt.getSSHJ_LOG().warn(message$iv$iv);
                    break;
                }
                default: {
                    UtilKt.getSSHJ_LOG().warn(message$iv$iv, (Throwable)e$iv$iv);
                }
            }
            throw SftpChannelException.Companion.create(e$iv$iv.getStatusCode().getCode(), message$iv$iv, e$iv$iv);
        }
        catch (IOException e$iv$iv) {
            IOException it$iv = e$iv$iv;
            boolean bl6 = false;
            String message$iv$iv = "File " + file$iv + ": " + it$iv.getMessage();
            UtilKt.getSSHJ_LOG().warn(message$iv$iv, (Throwable)e$iv$iv);
            throw SftpChannelException.Companion.create(-1, message$iv$iv, e$iv$iv);
        }
    }

    @Override
    public int getGroupId() {
        return this.lstat.getOrThrow().getGID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveTo(@NotNull String newAbsolutePath) {
        Intrinsics.checkNotNullParameter((Object)newAbsolutePath, (String)"newAbsolutePath");
        String file$iv = this.path + " => " + newAbsolutePath;
        boolean logNoSuchFileError$iv = true;
        boolean log$iv = true;
        boolean $i$f$wrapSshjSftpException = false;
        boolean bl = logNoSuchFileError$iv;
        boolean log$iv$iv = log$iv;
        boolean $i$f$wrapSshjSftpException2 = false;
        try {
            boolean bl2 = false;
            SshjRemoteFileObject this_$iv = this;
            boolean $i$f$mutableAction = false;
            try {
                boolean bl3 = false;
                boolean $i$f$measureCall = false;
                if (!UtilKt.getSSHJ_LOG().isDebugEnabled()) {
                    boolean bl4 = false;
                    this.sftp.rename(this.path, newAbsolutePath);
                } else {
                    long start$iv = System.nanoTime();
                    String state$iv = "ok";
                    try {
                        boolean bl5 = false;
                        this.sftp.rename(this.path, newAbsolutePath);
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable e$iv) {
                        state$iv = "exception";
                        throw e$iv;
                    }
                    finally {
                        long end$iv = System.nanoTime();
                        Logger logger = UtilKt.getSSHJ_LOG();
                        boolean bl6 = false;
                        logger.debug("Called " + (this + ".sftp.rename(" + newAbsolutePath + ")") + " in " + SshjRemoteFileObjectKt.access$getMeasureCallDecimalFormat$p().format((double)(end$iv - start$iv) / 1000000.0) + " ms (" + state$iv + ")");
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                this_$iv.lstat.clear();
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (SFTPException e$iv$iv) {
            IOException it$iv = (IOException)((Object)e$iv$iv);
            boolean bl7 = false;
            String message$iv$iv = "File " + file$iv + ": " + it$iv.getMessage();
            Response.StatusCode statusCode = e$iv$iv.getStatusCode();
            switch (statusCode == null ? -1 : UtilKt.WhenMappings.$EnumSwitchMapping$0[statusCode.ordinal()]) {
                case 1: {
                    if (UtilKt.getSSHJ_LOG().isDebugEnabled()) {
                        UtilKt.getSSHJ_LOG().debug(message$iv$iv, (Throwable)e$iv$iv);
                    }
                    UtilKt.getSSHJ_LOG().info(message$iv$iv);
                    break;
                }
                case 2: {
                    if (UtilKt.getSSHJ_LOG().isDebugEnabled()) {
                        UtilKt.getSSHJ_LOG().debug(message$iv$iv, (Throwable)e$iv$iv);
                    }
                    UtilKt.getSSHJ_LOG().warn(message$iv$iv);
                    break;
                }
                default: {
                    UtilKt.getSSHJ_LOG().warn(message$iv$iv, (Throwable)e$iv$iv);
                }
            }
            throw SftpChannelException.Companion.create(e$iv$iv.getStatusCode().getCode(), message$iv$iv, e$iv$iv);
        }
        catch (IOException e$iv$iv) {
            IOException it$iv = e$iv$iv;
            boolean bl8 = false;
            String message$iv$iv = "File " + file$iv + ": " + it$iv.getMessage();
            UtilKt.getSSHJ_LOG().warn(message$iv$iv, (Throwable)e$iv$iv);
            throw SftpChannelException.Companion.create(-1, message$iv$iv, e$iv$iv);
        }
    }

    @Override
    public long getLastModifiedTime() {
        return this.lstat.getOrThrow().getMtime();
    }

    @Override
    public void setLastModifiedTime(long value) {
        this.updateFileAttributes((Function1<? super FileAttributes.Builder, Unit>)((Function1)arg_0 -> SshjRemoteFileObject.setLastModifiedTime$lambda$35(this, value, arg_0)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public String canonicalPath() {
        String string;
        String file$iv = this.path;
        boolean logNoSuchFileError$iv = true;
        boolean log$iv = true;
        boolean $i$f$wrapSshjSftpException = false;
        boolean bl = logNoSuchFileError$iv;
        boolean log$iv$iv = log$iv;
        boolean $i$f$wrapSshjSftpException2 = false;
        try {
            String string2;
            String string3;
            boolean bl2 = false;
            boolean $i$f$measureCall = false;
            if (!UtilKt.getSSHJ_LOG().isDebugEnabled()) {
                boolean bl3 = false;
                string3 = this.sftp.canonicalize(this.path());
            } else {
                String string4;
                long start$iv = System.nanoTime();
                String state$iv = "ok";
                try {
                    boolean bl4 = false;
                    string4 = this.sftp.canonicalize(this.path());
                }
                catch (Throwable e$iv) {
                    state$iv = "exception";
                    throw e$iv;
                }
                finally {
                    long end$iv = System.nanoTime();
                    Logger logger = UtilKt.getSSHJ_LOG();
                    boolean bl5 = false;
                    logger.debug("Called " + (this + ".sftp.canonicalize()") + " in " + SshjRemoteFileObjectKt.access$getMeasureCallDecimalFormat$p().format((double)(end$iv - start$iv) / 1000000.0) + " ms (" + state$iv + ")");
                }
                string3 = string4;
            }
            String it = string2 = string3;
            boolean bl6 = false;
            UtilKt.getSSHJ_LOG().debug("Canonical path of " + this.path + " is " + it);
            string = string2;
        }
        catch (SFTPException e$iv$iv) {
            IOException it$iv = (IOException)((Object)e$iv$iv);
            boolean bl7 = false;
            String message$iv$iv = "File " + file$iv + ": " + it$iv.getMessage();
            Response.StatusCode statusCode = e$iv$iv.getStatusCode();
            switch (statusCode == null ? -1 : UtilKt.WhenMappings.$EnumSwitchMapping$0[statusCode.ordinal()]) {
                case 1: {
                    if (UtilKt.getSSHJ_LOG().isDebugEnabled()) {
                        UtilKt.getSSHJ_LOG().debug(message$iv$iv, (Throwable)e$iv$iv);
                    }
                    UtilKt.getSSHJ_LOG().info(message$iv$iv);
                    break;
                }
                case 2: {
                    if (UtilKt.getSSHJ_LOG().isDebugEnabled()) {
                        UtilKt.getSSHJ_LOG().debug(message$iv$iv, (Throwable)e$iv$iv);
                    }
                    UtilKt.getSSHJ_LOG().warn(message$iv$iv);
                    break;
                }
                default: {
                    UtilKt.getSSHJ_LOG().warn(message$iv$iv, (Throwable)e$iv$iv);
                }
            }
            throw SftpChannelException.Companion.create(e$iv$iv.getStatusCode().getCode(), message$iv$iv, e$iv$iv);
        }
        catch (IOException e$iv$iv) {
            IOException it$iv = e$iv$iv;
            boolean bl8 = false;
            String message$iv$iv = "File " + file$iv + ": " + it$iv.getMessage();
            UtilKt.getSSHJ_LOG().warn(message$iv$iv, (Throwable)e$iv$iv);
            throw SftpChannelException.Companion.create(-1, message$iv$iv, e$iv$iv);
        }
        String string5 = string;
        Intrinsics.checkNotNull((Object)string5);
        return string5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T mutableAction(Function0<? extends T> handler) {
        Object object;
        boolean $i$f$mutableAction = false;
        try {
            object = handler.invoke();
        }
        finally {
            InlineMarker.finallyStart((int)1);
            this.lstat.clear();
            InlineMarker.finallyEnd((int)1);
        }
        return (T)object;
    }

    @Override
    public void clearCachedData() {
        this.lstat.clear();
    }

    @NotNull
    public String toString() {
        return "SshjRemoteFileObject@" + UtilKt.hexId(this) + "(path " + this.path + ", owned by " + this.ownerName + ")";
    }

    private static final CharSequence list$lambda$5$lambda$4$lambda$3(RemoteResourceInfo it) {
        return it.getName() + " " + it.getAttributes();
    }

    private static final Unit setPermissions$lambda$22(int $value, FileAttributes.Builder $this$updateFileAttributes) {
        Intrinsics.checkNotNullParameter((Object)$this$updateFileAttributes, (String)"$this$updateFileAttributes");
        $this$updateFileAttributes.withPermissions($value);
        return Unit.INSTANCE;
    }

    private static final Unit setLastModifiedTime$lambda$35(SshjRemoteFileObject this$0, long $value, FileAttributes.Builder $this$updateFileAttributes) {
        Intrinsics.checkNotNullParameter((Object)$this$updateFileAttributes, (String)"$this$updateFileAttributes");
        $this$updateFileAttributes.withAtimeMtime(this$0.lstat.getOrThrow().getAtime(), $value);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Response.StatusCode.values().length];
            try {
                nArray[Response.StatusCode.NO_SUCH_FILE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Response.StatusCode.FAILURE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

