/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.highlighting;

import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.options.colors.AttributesDescriptor;
import com.intellij.openapi.options.colors.ColorDescriptor;
import com.intellij.openapi.options.colors.ColorSettingsPage;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.highlighting.MarkdownHighlighterColors;
import org.intellij.plugins.markdown.highlighting.MarkdownSyntaxHighlighter;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MarkdownColorSettingsPage
implements ColorSettingsPage {
    private static final AttributesDescriptor[] ATTRIBUTE_DESCRIPTORS = AttributeDescriptorsHolder.INSTANCE.get();

    @NotNull
    public Map<String, TextAttributesKey> getAdditionalHighlightingTagToDescriptorMap() {
        HashMap<String, TextAttributesKey> result = new HashMap<String, TextAttributesKey>();
        result.put("hh1", MarkdownHighlighterColors.HEADER_LEVEL_1);
        result.put("hh2", MarkdownHighlighterColors.HEADER_LEVEL_2);
        result.put("hh3", MarkdownHighlighterColors.HEADER_LEVEL_3);
        result.put("hh4", MarkdownHighlighterColors.HEADER_LEVEL_4);
        result.put("hh5", MarkdownHighlighterColors.HEADER_LEVEL_5);
        result.put("hh6", MarkdownHighlighterColors.HEADER_LEVEL_6);
        result.put("bold", MarkdownHighlighterColors.BOLD);
        result.put("boldm", MarkdownHighlighterColors.BOLD_MARKER);
        result.put("italic", MarkdownHighlighterColors.ITALIC);
        result.put("italicm", MarkdownHighlighterColors.ITALIC_MARKER);
        result.put("strike", MarkdownHighlighterColors.STRIKE_THROUGH);
        result.put("alink", MarkdownHighlighterColors.AUTO_LINK);
        result.put("link_def", MarkdownHighlighterColors.LINK_DEFINITION);
        result.put("link_text", MarkdownHighlighterColors.LINK_TEXT);
        result.put("link_label", MarkdownHighlighterColors.LINK_LABEL);
        result.put("link_dest", MarkdownHighlighterColors.LINK_DESTINATION);
        result.put("link_img", MarkdownHighlighterColors.IMAGE);
        result.put("link_title", MarkdownHighlighterColors.LINK_TITLE);
        result.put("code_span", MarkdownHighlighterColors.CODE_SPAN);
        result.put("code_block", MarkdownHighlighterColors.CODE_BLOCK);
        result.put("code_fence", MarkdownHighlighterColors.CODE_FENCE);
        result.put("quote", MarkdownHighlighterColors.BLOCK_QUOTE);
        result.put("ul", MarkdownHighlighterColors.UNORDERED_LIST);
        result.put("ol", MarkdownHighlighterColors.ORDERED_LIST);
        result.put("dl", MarkdownHighlighterColors.DEFINITION_LIST);
        result.put("dd", MarkdownHighlighterColors.DEFINITION);
        result.put("dt", MarkdownHighlighterColors.TERM);
        result.put("dm", MarkdownHighlighterColors.DEFINITION_LIST_MARKER);
        HashMap<String, TextAttributesKey> hashMap = result;
        if (hashMap == null) {
            MarkdownColorSettingsPage.$$$reportNull$$$0(0);
        }
        return hashMap;
    }

    public AttributesDescriptor @NotNull [] getAttributeDescriptors() {
        if (ATTRIBUTE_DESCRIPTORS == null) {
            MarkdownColorSettingsPage.$$$reportNull$$$0(1);
        }
        return ATTRIBUTE_DESCRIPTORS;
    }

    public ColorDescriptor @NotNull [] getColorDescriptors() {
        if (ColorDescriptor.EMPTY_ARRAY == null) {
            MarkdownColorSettingsPage.$$$reportNull$$$0(2);
        }
        return ColorDescriptor.EMPTY_ARRAY;
    }

    /*
     * Loose catch block
     */
    @NonNls
    @NotNull
    public String getDemoText() {
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream("SampleDocument.md"), StandardCharsets.UTF_8);
        String result = StreamUtil.readText((Reader)reader);
        String string = StringUtil.convertLineSeparators((String)result);
        ((Reader)reader).close();
        String string2 = string;
        if (string2 == null) {
            MarkdownColorSettingsPage.$$$reportNull$$$0(3);
        }
        return string2;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        ((Reader)reader).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    return "*error loading text*";
                }
            }
        }
    }

    @NotNull
    public String getDisplayName() {
        String string = MarkdownBundle.message("markdown.plugin.name", new Object[0]);
        if (string == null) {
            MarkdownColorSettingsPage.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public SyntaxHighlighter getHighlighter() {
        return new MarkdownSyntaxHighlighter();
    }

    @Nullable
    public Icon getIcon() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/intellij/plugins/markdown/highlighting/MarkdownColorSettingsPage";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalHighlightingTagToDescriptorMap";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributeDescriptors";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorDescriptors";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDemoText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static enum AttributeDescriptorsHolder {
        INSTANCE;

        private final Map<String, TextAttributesKey> myMap = new HashMap<String, TextAttributesKey>();

        private AttributeDescriptorsHolder() {
            this.put("markdown.editor.colors.text", MarkdownHighlighterColors.TEXT);
            this.put("markdown.editor.colors.bold", MarkdownHighlighterColors.BOLD);
            this.put("markdown.editor.colors.bold_marker", MarkdownHighlighterColors.BOLD_MARKER);
            this.put("markdown.editor.colors.italic", MarkdownHighlighterColors.ITALIC);
            this.put("markdown.editor.colors.italic_marker", MarkdownHighlighterColors.ITALIC_MARKER);
            this.put("markdown.editor.colors.strikethrough", MarkdownHighlighterColors.STRIKE_THROUGH);
            this.put("markdown.editor.colors.header_level_1", MarkdownHighlighterColors.HEADER_LEVEL_1);
            this.put("markdown.editor.colors.header_level_2", MarkdownHighlighterColors.HEADER_LEVEL_2);
            this.put("markdown.editor.colors.header_level_3", MarkdownHighlighterColors.HEADER_LEVEL_3);
            this.put("markdown.editor.colors.header_level_4", MarkdownHighlighterColors.HEADER_LEVEL_4);
            this.put("markdown.editor.colors.header_level_5", MarkdownHighlighterColors.HEADER_LEVEL_5);
            this.put("markdown.editor.colors.header_level_6", MarkdownHighlighterColors.HEADER_LEVEL_6);
            this.put("markdown.editor.colors.blockquote", MarkdownHighlighterColors.BLOCK_QUOTE);
            this.put("markdown.editor.colors.code_span", MarkdownHighlighterColors.CODE_SPAN);
            this.put("markdown.editor.colors.code_span_marker", MarkdownHighlighterColors.CODE_SPAN_MARKER);
            this.put("markdown.editor.colors.code_block", MarkdownHighlighterColors.CODE_BLOCK);
            this.put("markdown.editor.colors.code_fence", MarkdownHighlighterColors.CODE_FENCE);
            this.put("markdown.editor.colors.hrule", MarkdownHighlighterColors.HRULE);
            this.put("markdown.editor.colors.table_separator", MarkdownHighlighterColors.TABLE_SEPARATOR);
            this.put("markdown.editor.colors.blockquote_marker", MarkdownHighlighterColors.BLOCK_QUOTE_MARKER);
            this.put("markdown.editor.colors.list_marker", MarkdownHighlighterColors.LIST_MARKER);
            this.put("markdown.editor.colors.header_marker", MarkdownHighlighterColors.HEADER_MARKER);
            this.put("markdown.editor.colors.auto_link", MarkdownHighlighterColors.AUTO_LINK);
            this.put("markdown.editor.colors.explicit_link", MarkdownHighlighterColors.EXPLICIT_LINK);
            this.put("markdown.editor.colors.reference_link", MarkdownHighlighterColors.REFERENCE_LINK);
            this.put("markdown.editor.colors.image", MarkdownHighlighterColors.IMAGE);
            this.put("markdown.editor.colors.link_definition", MarkdownHighlighterColors.LINK_DEFINITION);
            this.put("markdown.editor.colors.link_text", MarkdownHighlighterColors.LINK_TEXT);
            this.put("markdown.editor.colors.link_label", MarkdownHighlighterColors.LINK_LABEL);
            this.put("markdown.editor.colors.link_destination", MarkdownHighlighterColors.LINK_DESTINATION);
            this.put("markdown.editor.colors.link_title", MarkdownHighlighterColors.LINK_TITLE);
            this.put("markdown.editor.colors.unordered_list", MarkdownHighlighterColors.UNORDERED_LIST);
            this.put("markdown.editor.colors.ordered_list", MarkdownHighlighterColors.ORDERED_LIST);
            this.put("markdown.editor.colors.list_item", MarkdownHighlighterColors.LIST_ITEM);
            this.put("markdown.editor.colors.html_block", MarkdownHighlighterColors.HTML_BLOCK);
            this.put("markdown.editor.colors.inline_html", MarkdownHighlighterColors.INLINE_HTML);
            this.put("markdown.editor.colors.definition_list", MarkdownHighlighterColors.DEFINITION_LIST);
            this.put("markdown.editor.colors.definition_list_marker", MarkdownHighlighterColors.DEFINITION_LIST_MARKER);
            this.put("markdown.editor.colors.definition", MarkdownHighlighterColors.DEFINITION);
            this.put("markdown.editor.colors.term", MarkdownHighlighterColors.TERM);
        }

        public AttributesDescriptor @NotNull [] get() {
            AttributesDescriptor[] result = new AttributesDescriptor[this.myMap.size()];
            int i = 0;
            for (Map.Entry<String, TextAttributesKey> entry : this.myMap.entrySet()) {
                result[i++] = new AttributesDescriptor(MarkdownBundle.message(entry.getKey(), new Object[0]), entry.getValue());
            }
            if (result == null) {
                AttributeDescriptorsHolder.$$$reportNull$$$0(0);
            }
            return result;
        }

        private void put(@NotNull String bundleKey, @NotNull TextAttributesKey attributes) {
            if (bundleKey == null) {
                AttributeDescriptorsHolder.$$$reportNull$$$0(1);
            }
            if (attributes == null) {
                AttributeDescriptorsHolder.$$$reportNull$$$0(2);
            }
            if (this.myMap.put(bundleKey, attributes) != null) {
                throw new IllegalArgumentException("Duplicated key: " + bundleKey);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/intellij/plugins/markdown/highlighting/MarkdownColorSettingsPage$AttributeDescriptorsHolder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bundleKey";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attributes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "get";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/intellij/plugins/markdown/highlighting/MarkdownColorSettingsPage$AttributeDescriptorsHolder";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "put";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

