/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.runtime.properties;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class PropertySourceMap
implements DBPPropertySource {
    private List<DBPPropertyDescriptor> props = new ArrayList<DBPPropertyDescriptor>();
    private Map<?, ?> items;

    public PropertySourceMap(Map<String, ?> map) {
        this.items = new LinkedHashMap(map);
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            this.props.add(new ItemPropertyDescriptor(entry.getKey(), entry.getValue()));
        }
    }

    @Override
    @NotNull
    public Object getEditableValue() {
        return this;
    }

    @Override
    @NotNull
    public DBPPropertyDescriptor[] getProperties() {
        return this.props.toArray(new DBPPropertyDescriptor[this.props.size()]);
    }

    @Override
    @Nullable
    public Object getPropertyValue(@Nullable DBRProgressMonitor monitor, @NotNull String id) {
        return this.items.get(id);
    }

    @Override
    public boolean isPropertySet(@NotNull String id) {
        return false;
    }

    @Override
    public boolean isPropertyResettable(@NotNull String id) {
        return false;
    }

    @Override
    public void resetPropertyValue(@Nullable DBRProgressMonitor monitor, @NotNull String id) {
    }

    @Override
    public void resetPropertyValueToDefault(@NotNull String id) {
    }

    @Override
    public void setPropertyValue(@Nullable DBRProgressMonitor monitor, @NotNull String id, @Nullable Object value) {
    }

    public String toString() {
        return "<...>";
    }

    private static class ItemPropertyDescriptor
    implements DBPPropertyDescriptor {
        private final String name;
        private final Object value;

        ItemPropertyDescriptor(String name, Object value) {
            this.name = name;
            this.value = value;
        }

        @Override
        public String getCategory() {
            return null;
        }

        @Override
        public String getDescription() {
            return null;
        }

        @Override
        public String getHint() {
            return null;
        }

        @Override
        public Class<?> getDataType() {
            return Object.class;
        }

        @Override
        public boolean isRequired() {
            return false;
        }

        @Override
        public Object getDefaultValue() {
            return null;
        }

        @Override
        public boolean isEditable(Object object) {
            return false;
        }

        @Override
        @NotNull
        public PropertyLength getLength() {
            return PropertyLength.LONG;
        }

        @Override
        @Nullable
        public String[] getFeatures() {
            return null;
        }

        @Override
        @Nullable
        public String[] getRequiredFeatures() {
            return null;
        }

        @Override
        public boolean hasFeature(@NotNull String feature) {
            return false;
        }

        @Override
        @NotNull
        public String getDisplayName() {
            return DBUtils.getObjectShortName(this.name);
        }

        @Override
        @NotNull
        public String getId() {
            return this.name;
        }
    }
}

