/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	v1 "k8s.io/api/core/v1"
	corev1 "k8s.io/client-go/applyconfigurations/core/v1"
	gentype "k8s.io/client-go/gentype"
	typedcorev1 "k8s.io/client-go/kubernetes/typed/core/v1"
)

// fakeLimitRanges implements LimitRangeInterface
type fakeLimitRanges struct {
	*gentype.FakeClientWithListAndApply[*v1.LimitRange, *v1.LimitRangeList, *corev1.LimitRangeApplyConfiguration]
	Fake *FakeCoreV1
}

func newFakeLimitRanges(fake *FakeCoreV1, namespace string) typedcorev1.LimitRangeInterface {
	return &fakeLimitRanges{
		gentype.NewFakeClientWithListAndApply[*v1.LimitRange, *v1.LimitRangeList, *corev1.LimitRangeApplyConfiguration](
			fake.Fake,
			namespace,
			v1.SchemeGroupVersion.WithResource("limitranges"),
			v1.SchemeGroupVersion.WithKind("LimitRange"),
			func() *v1.LimitRange { return &v1.LimitRange{} },
			func() *v1.LimitRangeList { return &v1.LimitRangeList{} },
			func(dst, src *v1.LimitRangeList) { dst.ListMeta = src.ListMeta },
			func(list *v1.LimitRangeList) []*v1.LimitRange { return gentype.ToPointerSlice(list.Items) },
			func(list *v1.LimitRangeList, items []*v1.LimitRange) { list.Items = gentype.FromPointerSlice(items) },
		),
		fake,
	}
}
