﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/customer-profiles/CustomerProfiles_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace CustomerProfiles {
namespace Model {

/**
 * <p>Information indicating if the Calculated Attribute is ready for use by
 * confirming all historical data has been processed and reflected.</p><p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/Readiness">AWS
 * API Reference</a></p>
 */
class Readiness {
 public:
  AWS_CUSTOMERPROFILES_API Readiness() = default;
  AWS_CUSTOMERPROFILES_API Readiness(Aws::Utils::Json::JsonView jsonValue);
  AWS_CUSTOMERPROFILES_API Readiness& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_CUSTOMERPROFILES_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>Approximately how far the Calculated Attribute creation is from
   * completion.</p>
   */
  inline int GetProgressPercentage() const { return m_progressPercentage; }
  inline bool ProgressPercentageHasBeenSet() const { return m_progressPercentageHasBeenSet; }
  inline void SetProgressPercentage(int value) {
    m_progressPercentageHasBeenSet = true;
    m_progressPercentage = value;
  }
  inline Readiness& WithProgressPercentage(int value) {
    SetProgressPercentage(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Any customer messaging.</p>
   */
  inline const Aws::String& GetMessage() const { return m_message; }
  inline bool MessageHasBeenSet() const { return m_messageHasBeenSet; }
  template <typename MessageT = Aws::String>
  void SetMessage(MessageT&& value) {
    m_messageHasBeenSet = true;
    m_message = std::forward<MessageT>(value);
  }
  template <typename MessageT = Aws::String>
  Readiness& WithMessage(MessageT&& value) {
    SetMessage(std::forward<MessageT>(value));
    return *this;
  }
  ///@}
 private:
  int m_progressPercentage{0};
  bool m_progressPercentageHasBeenSet = false;

  Aws::String m_message;
  bool m_messageHasBeenSet = false;
};

}  // namespace Model
}  // namespace CustomerProfiles
}  // namespace Aws
