﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/connectcases/model/BatchGetCaseRuleResult.h>
#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>

#include <utility>

using namespace Aws::ConnectCases::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

BatchGetCaseRuleResult::BatchGetCaseRuleResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

BatchGetCaseRuleResult& BatchGetCaseRuleResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("caseRules")) {
    Aws::Utils::Array<JsonView> caseRulesJsonList = jsonValue.GetArray("caseRules");
    for (unsigned caseRulesIndex = 0; caseRulesIndex < caseRulesJsonList.GetLength(); ++caseRulesIndex) {
      m_caseRules.push_back(caseRulesJsonList[caseRulesIndex].AsObject());
    }
    m_caseRulesHasBeenSet = true;
  }
  if (jsonValue.ValueExists("errors")) {
    Aws::Utils::Array<JsonView> errorsJsonList = jsonValue.GetArray("errors");
    for (unsigned errorsIndex = 0; errorsIndex < errorsJsonList.GetLength(); ++errorsIndex) {
      m_errors.push_back(errorsJsonList[errorsIndex].AsObject());
    }
    m_errorsHasBeenSet = true;
  }
  if (jsonValue.ValueExists("unprocessedCaseRules")) {
    Aws::Utils::Array<JsonView> unprocessedCaseRulesJsonList = jsonValue.GetArray("unprocessedCaseRules");
    for (unsigned unprocessedCaseRulesIndex = 0; unprocessedCaseRulesIndex < unprocessedCaseRulesJsonList.GetLength();
         ++unprocessedCaseRulesIndex) {
      m_unprocessedCaseRules.push_back(unprocessedCaseRulesJsonList[unprocessedCaseRulesIndex].AsString());
    }
    m_unprocessedCaseRulesHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
