﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/connect/model/ListAssociatedContactsResult.h>
#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>

#include <utility>

using namespace Aws::Connect::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

ListAssociatedContactsResult::ListAssociatedContactsResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

ListAssociatedContactsResult& ListAssociatedContactsResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("ContactSummaryList")) {
    Aws::Utils::Array<JsonView> contactSummaryListJsonList = jsonValue.GetArray("ContactSummaryList");
    for (unsigned contactSummaryListIndex = 0; contactSummaryListIndex < contactSummaryListJsonList.GetLength();
         ++contactSummaryListIndex) {
      m_contactSummaryList.push_back(contactSummaryListJsonList[contactSummaryListIndex].AsObject());
    }
    m_contactSummaryListHasBeenSet = true;
  }
  if (jsonValue.ValueExists("NextToken")) {
    m_nextToken = jsonValue.GetString("NextToken");
    m_nextTokenHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
