﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/connect/model/AgentStatusState.h>
#include <aws/core/Globals.h>
#include <aws/core/utils/EnumParseOverflowContainer.h>
#include <aws/core/utils/HashingUtils.h>

using namespace Aws::Utils;

namespace Aws {
namespace Connect {
namespace Model {
namespace AgentStatusStateMapper {

static const int ENABLED_HASH = HashingUtils::HashString("ENABLED");
static const int DISABLED_HASH = HashingUtils::HashString("DISABLED");

AgentStatusState GetAgentStatusStateForName(const Aws::String& name) {
  int hashCode = HashingUtils::HashString(name.c_str());
  if (hashCode == ENABLED_HASH) {
    return AgentStatusState::ENABLED;
  } else if (hashCode == DISABLED_HASH) {
    return AgentStatusState::DISABLED;
  }
  EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
  if (overflowContainer) {
    overflowContainer->StoreOverflow(hashCode, name);
    return static_cast<AgentStatusState>(hashCode);
  }

  return AgentStatusState::NOT_SET;
}

Aws::String GetNameForAgentStatusState(AgentStatusState enumValue) {
  switch (enumValue) {
    case AgentStatusState::NOT_SET:
      return {};
    case AgentStatusState::ENABLED:
      return "ENABLED";
    case AgentStatusState::DISABLED:
      return "DISABLED";
    default:
      EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
      if (overflowContainer) {
        return overflowContainer->RetrieveOverflow(static_cast<int>(enumValue));
      }

      return {};
  }
}

}  // namespace AgentStatusStateMapper
}  // namespace Model
}  // namespace Connect
}  // namespace Aws
