﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/connect/ConnectRequest.h>
#include <aws/connect/Connect_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Http {
class URI;
}  // namespace Http
namespace Connect {
namespace Model {

/**
 * Request to DeleteAttachedFile API<p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteAttachedFileRequest">AWS
 * API Reference</a></p>
 */
class DeleteAttachedFileRequest : public ConnectRequest {
 public:
  AWS_CONNECT_API DeleteAttachedFileRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "DeleteAttachedFile"; }

  AWS_CONNECT_API Aws::String SerializePayload() const override;

  AWS_CONNECT_API void AddQueryStringParameters(Aws::Http::URI& uri) const override;

  ///@{
  /**
   * <p>The unique identifier of the Connect instance.</p>
   */
  inline const Aws::String& GetInstanceId() const { return m_instanceId; }
  inline bool InstanceIdHasBeenSet() const { return m_instanceIdHasBeenSet; }
  template <typename InstanceIdT = Aws::String>
  void SetInstanceId(InstanceIdT&& value) {
    m_instanceIdHasBeenSet = true;
    m_instanceId = std::forward<InstanceIdT>(value);
  }
  template <typename InstanceIdT = Aws::String>
  DeleteAttachedFileRequest& WithInstanceId(InstanceIdT&& value) {
    SetInstanceId(std::forward<InstanceIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The unique identifier of the attached file resource.</p>
   */
  inline const Aws::String& GetFileId() const { return m_fileId; }
  inline bool FileIdHasBeenSet() const { return m_fileIdHasBeenSet; }
  template <typename FileIdT = Aws::String>
  void SetFileId(FileIdT&& value) {
    m_fileIdHasBeenSet = true;
    m_fileId = std::forward<FileIdT>(value);
  }
  template <typename FileIdT = Aws::String>
  DeleteAttachedFileRequest& WithFileId(FileIdT&& value) {
    SetFileId(std::forward<FileIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The resource to which the attached file is (being) uploaded to. <a
   * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_connect-cases_CreateCase.html">Cases</a>
   * are the only current supported resource.</p>  <p>This value must be a
   * valid ARN.</p>
   */
  inline const Aws::String& GetAssociatedResourceArn() const { return m_associatedResourceArn; }
  inline bool AssociatedResourceArnHasBeenSet() const { return m_associatedResourceArnHasBeenSet; }
  template <typename AssociatedResourceArnT = Aws::String>
  void SetAssociatedResourceArn(AssociatedResourceArnT&& value) {
    m_associatedResourceArnHasBeenSet = true;
    m_associatedResourceArn = std::forward<AssociatedResourceArnT>(value);
  }
  template <typename AssociatedResourceArnT = Aws::String>
  DeleteAttachedFileRequest& WithAssociatedResourceArn(AssociatedResourceArnT&& value) {
    SetAssociatedResourceArn(std::forward<AssociatedResourceArnT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_instanceId;
  bool m_instanceIdHasBeenSet = false;

  Aws::String m_fileId;
  bool m_fileIdHasBeenSet = false;

  Aws::String m_associatedResourceArn;
  bool m_associatedResourceArnHasBeenSet = false;
};

}  // namespace Model
}  // namespace Connect
}  // namespace Aws
