﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/codepipeline/model/ArtifactLocation.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace CodePipeline {
namespace Model {

ArtifactLocation::ArtifactLocation(JsonView jsonValue) { *this = jsonValue; }

ArtifactLocation& ArtifactLocation::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("type")) {
    m_type = ArtifactLocationTypeMapper::GetArtifactLocationTypeForName(jsonValue.GetString("type"));
    m_typeHasBeenSet = true;
  }
  if (jsonValue.ValueExists("s3Location")) {
    m_s3Location = jsonValue.GetObject("s3Location");
    m_s3LocationHasBeenSet = true;
  }
  return *this;
}

JsonValue ArtifactLocation::Jsonize() const {
  JsonValue payload;

  if (m_typeHasBeenSet) {
    payload.WithString("type", ArtifactLocationTypeMapper::GetNameForArtifactLocationType(m_type));
  }

  if (m_s3LocationHasBeenSet) {
    payload.WithObject("s3Location", m_s3Location.Jsonize());
  }

  return payload;
}

}  // namespace Model
}  // namespace CodePipeline
}  // namespace Aws
