﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/codecommit/model/PutRepositoryTriggersRequest.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::CodeCommit::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String PutRepositoryTriggersRequest::SerializePayload() const {
  JsonValue payload;

  if (m_repositoryNameHasBeenSet) {
    payload.WithString("repositoryName", m_repositoryName);
  }

  if (m_triggersHasBeenSet) {
    Aws::Utils::Array<JsonValue> triggersJsonList(m_triggers.size());
    for (unsigned triggersIndex = 0; triggersIndex < triggersJsonList.GetLength(); ++triggersIndex) {
      triggersJsonList[triggersIndex].AsObject(m_triggers[triggersIndex].Jsonize());
    }
    payload.WithArray("triggers", std::move(triggersJsonList));
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection PutRepositoryTriggersRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "CodeCommit_20150413.PutRepositoryTriggers"));
  return headers;
}
