﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/codecatalyst/CodeCatalyst_EXPORTS.h>
#include <aws/codecatalyst/model/IdeConfiguration.h>
#include <aws/codecatalyst/model/InstanceType.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace CodeCatalyst {
namespace Model {
class UpdateDevEnvironmentResult {
 public:
  AWS_CODECATALYST_API UpdateDevEnvironmentResult() = default;
  AWS_CODECATALYST_API UpdateDevEnvironmentResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_CODECATALYST_API UpdateDevEnvironmentResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The system-generated unique ID of the Dev Environment. </p>
   */
  inline const Aws::String& GetId() const { return m_id; }
  template <typename IdT = Aws::String>
  void SetId(IdT&& value) {
    m_idHasBeenSet = true;
    m_id = std::forward<IdT>(value);
  }
  template <typename IdT = Aws::String>
  UpdateDevEnvironmentResult& WithId(IdT&& value) {
    SetId(std::forward<IdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the space.</p>
   */
  inline const Aws::String& GetSpaceName() const { return m_spaceName; }
  template <typename SpaceNameT = Aws::String>
  void SetSpaceName(SpaceNameT&& value) {
    m_spaceNameHasBeenSet = true;
    m_spaceName = std::forward<SpaceNameT>(value);
  }
  template <typename SpaceNameT = Aws::String>
  UpdateDevEnvironmentResult& WithSpaceName(SpaceNameT&& value) {
    SetSpaceName(std::forward<SpaceNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the project in the space.</p>
   */
  inline const Aws::String& GetProjectName() const { return m_projectName; }
  template <typename ProjectNameT = Aws::String>
  void SetProjectName(ProjectNameT&& value) {
    m_projectNameHasBeenSet = true;
    m_projectName = std::forward<ProjectNameT>(value);
  }
  template <typename ProjectNameT = Aws::String>
  UpdateDevEnvironmentResult& WithProjectName(ProjectNameT&& value) {
    SetProjectName(std::forward<ProjectNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The user-specified alias for the Dev Environment.</p>
   */
  inline const Aws::String& GetAlias() const { return m_alias; }
  template <typename AliasT = Aws::String>
  void SetAlias(AliasT&& value) {
    m_aliasHasBeenSet = true;
    m_alias = std::forward<AliasT>(value);
  }
  template <typename AliasT = Aws::String>
  UpdateDevEnvironmentResult& WithAlias(AliasT&& value) {
    SetAlias(std::forward<AliasT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Information about the integrated development environment (IDE) configured for
   * the Dev Environment.</p>
   */
  inline const Aws::Vector<IdeConfiguration>& GetIdes() const { return m_ides; }
  template <typename IdesT = Aws::Vector<IdeConfiguration>>
  void SetIdes(IdesT&& value) {
    m_idesHasBeenSet = true;
    m_ides = std::forward<IdesT>(value);
  }
  template <typename IdesT = Aws::Vector<IdeConfiguration>>
  UpdateDevEnvironmentResult& WithIdes(IdesT&& value) {
    SetIdes(std::forward<IdesT>(value));
    return *this;
  }
  template <typename IdesT = IdeConfiguration>
  UpdateDevEnvironmentResult& AddIdes(IdesT&& value) {
    m_idesHasBeenSet = true;
    m_ides.emplace_back(std::forward<IdesT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon EC2 instace type to use for the Dev Environment. </p>
   */
  inline InstanceType GetInstanceType() const { return m_instanceType; }
  inline void SetInstanceType(InstanceType value) {
    m_instanceTypeHasBeenSet = true;
    m_instanceType = value;
  }
  inline UpdateDevEnvironmentResult& WithInstanceType(InstanceType value) {
    SetInstanceType(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The amount of time the Dev Environment will run without any activity detected
   * before stopping, in minutes. </p>
   */
  inline int GetInactivityTimeoutMinutes() const { return m_inactivityTimeoutMinutes; }
  inline void SetInactivityTimeoutMinutes(int value) {
    m_inactivityTimeoutMinutesHasBeenSet = true;
    m_inactivityTimeoutMinutes = value;
  }
  inline UpdateDevEnvironmentResult& WithInactivityTimeoutMinutes(int value) {
    SetInactivityTimeoutMinutes(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A user-specified idempotency token. Idempotency ensures that an API request
   * completes only once. With an idempotent request, if the original request
   * completes successfully, the subsequent retries return the result from the
   * original successful request and have no additional effect.</p>
   */
  inline const Aws::String& GetClientToken() const { return m_clientToken; }
  template <typename ClientTokenT = Aws::String>
  void SetClientToken(ClientTokenT&& value) {
    m_clientTokenHasBeenSet = true;
    m_clientToken = std::forward<ClientTokenT>(value);
  }
  template <typename ClientTokenT = Aws::String>
  UpdateDevEnvironmentResult& WithClientToken(ClientTokenT&& value) {
    SetClientToken(std::forward<ClientTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  UpdateDevEnvironmentResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_id;
  bool m_idHasBeenSet = false;

  Aws::String m_spaceName;
  bool m_spaceNameHasBeenSet = false;

  Aws::String m_projectName;
  bool m_projectNameHasBeenSet = false;

  Aws::String m_alias;
  bool m_aliasHasBeenSet = false;

  Aws::Vector<IdeConfiguration> m_ides;
  bool m_idesHasBeenSet = false;

  InstanceType m_instanceType{InstanceType::NOT_SET};
  bool m_instanceTypeHasBeenSet = false;

  int m_inactivityTimeoutMinutes{0};
  bool m_inactivityTimeoutMinutesHasBeenSet = false;

  Aws::String m_clientToken;
  bool m_clientTokenHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace CodeCatalyst
}  // namespace Aws
