﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/appmesh/model/ListVirtualServicesResult.h>
#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>

#include <utility>

using namespace Aws::AppMesh::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

ListVirtualServicesResult::ListVirtualServicesResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

ListVirtualServicesResult& ListVirtualServicesResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("nextToken")) {
    m_nextToken = jsonValue.GetString("nextToken");
    m_nextTokenHasBeenSet = true;
  }
  if (jsonValue.ValueExists("virtualServices")) {
    Aws::Utils::Array<JsonView> virtualServicesJsonList = jsonValue.GetArray("virtualServices");
    for (unsigned virtualServicesIndex = 0; virtualServicesIndex < virtualServicesJsonList.GetLength(); ++virtualServicesIndex) {
      m_virtualServices.push_back(virtualServicesJsonList[virtualServicesIndex].AsObject());
    }
    m_virtualServicesHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
