//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

extern_class!(
    /// An abstract base class that represents a machine-readable code's attributes.
    ///
    /// Subclasses encapsulate the formal specification and fields specific to a code type.
    /// Each subclass is sufficient to recreate the unique symbol exactly as seen or used with a custom parser.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/cibarcodedescriptor?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct CIBarcodeDescriptor;
);

extern_conformance!(
    unsafe impl NSCoding for CIBarcodeDescriptor {}
);

extern_conformance!(
    unsafe impl NSCopying for CIBarcodeDescriptor {}
);

unsafe impl CopyingHelper for CIBarcodeDescriptor {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for CIBarcodeDescriptor {}
);

extern_conformance!(
    unsafe impl NSSecureCoding for CIBarcodeDescriptor {}
);

impl CIBarcodeDescriptor {
    extern_methods!();
}

/// Methods declared on superclass `NSObject`.
impl CIBarcodeDescriptor {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}

/// Constants indicating the percentage of the symbol that is dedicated to error correction.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/ciqrcodeerrorcorrectionlevel?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CIQRCodeErrorCorrectionLevel(pub NSInteger);
impl CIQRCodeErrorCorrectionLevel {
    /// Indicates that approximately 20% of the symbol data is dedicated to error correction.
    #[doc(alias = "CIQRCodeErrorCorrectionLevelL")]
    pub const L: Self = Self(b'L' as _);
    /// Indicates that approximately 37% of the symbol data is dedicated to error correction.
    #[doc(alias = "CIQRCodeErrorCorrectionLevelM")]
    pub const M: Self = Self(b'M' as _);
    /// Indicates that approximately 55% of the symbol data is dedicated to error correction.
    #[doc(alias = "CIQRCodeErrorCorrectionLevelQ")]
    pub const Q: Self = Self(b'Q' as _);
    /// Indicates that approximately 65% of the symbol data is dedicated to error correction.
    #[doc(alias = "CIQRCodeErrorCorrectionLevelH")]
    pub const H: Self = Self(b'H' as _);
}

unsafe impl Encode for CIQRCodeErrorCorrectionLevel {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for CIQRCodeErrorCorrectionLevel {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// A concrete subclass of the Core Image Barcode Descriptor that represents a square QR code symbol.
    ///
    /// ISO/IEC 18004 defines versions from 1 to 40, where a higher symbol version indicates a
    /// larger data-carrying capacity.
    /// QR Codes can encode text, vCard contact information, or Uniform Resource Identifiers (URI).
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/ciqrcodedescriptor?language=objc)
    #[unsafe(super(CIBarcodeDescriptor, NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct CIQRCodeDescriptor;
);

extern_conformance!(
    unsafe impl NSCoding for CIQRCodeDescriptor {}
);

extern_conformance!(
    unsafe impl NSCopying for CIQRCodeDescriptor {}
);

unsafe impl CopyingHelper for CIQRCodeDescriptor {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for CIQRCodeDescriptor {}
);

extern_conformance!(
    unsafe impl NSSecureCoding for CIQRCodeDescriptor {}
);

impl CIQRCodeDescriptor {
    extern_methods!(
        /// The error-corrected codeword payload that comprises the QR code symbol.
        ///
        /// QR Codes are formally specified in ISO/IEC 18004:2006(E).
        /// Section 6.4.10 "Bitstream to codeword conversion" specifies the set of 8-bit codewords in the symbol
        /// immediately prior to splitting the message into blocks and applying error correction.
        ///
        /// During decode, error correction is applied and if successful, the message is re-ordered to the state immediately
        /// following "Bitstream to codeword conversion."
        ///
        /// The `errorCorrectedPayload` corresponds to this sequence of 8-bit codewords.
        #[unsafe(method(errorCorrectedPayload))]
        #[unsafe(method_family = none)]
        pub unsafe fn errorCorrectedPayload(&self) -> Retained<NSData>;

        /// The version of the QR code which corresponds to the size of the QR code symbol.
        ///
        /// ISO/IEC 18004 defines versions from 1 to 40, where a higher symbol version indicates a larger data-carrying capacity.
        /// This field is required in order to properly interpret the error corrected payload.
        #[unsafe(method(symbolVersion))]
        #[unsafe(method_family = none)]
        pub unsafe fn symbolVersion(&self) -> NSInteger;

        /// The data mask pattern for the QR code symbol.
        ///
        /// QR Codes support eight data mask patterns, which are used to avoid large black or large white areas inside the symbol body.
        /// Valid values range from 0 to 7.
        #[unsafe(method(maskPattern))]
        #[unsafe(method_family = none)]
        pub unsafe fn maskPattern(&self) -> u8;

        /// The error correction level of the QR code symbol.
        ///
        /// QR Codes support four levels of Reed-Solomon error correction.
        ///
        /// The possible error correction levels are enumerated in ``CIDataMatrixCodeECCVersion``.
        #[unsafe(method(errorCorrectionLevel))]
        #[unsafe(method_family = none)]
        pub unsafe fn errorCorrectionLevel(&self) -> CIQRCodeErrorCorrectionLevel;

        /// Initializes a QR code descriptor for the given payload and parameters.
        ///
        /// - Parameters:
        /// - errorCorrectedPayload: The data to encode in the QR code symbol.
        /// - symbolVersion: The symbol version, from 1 through 40.
        /// - maskPattern: The mask pattern to use in the QR code, from 0 to 7.
        /// - errorCorrectionLevel: The QR code's error correction level: L, M, Q, or H.
        /// - Returns:
        /// An initialized ``CIAztecCodeDescriptor`` instance
        /// or `nil` if the parameters are invalid
        #[unsafe(method(initWithPayload:symbolVersion:maskPattern:errorCorrectionLevel:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithPayload_symbolVersion_maskPattern_errorCorrectionLevel(
            this: Allocated<Self>,
            error_corrected_payload: &NSData,
            symbol_version: NSInteger,
            mask_pattern: u8,
            error_correction_level: CIQRCodeErrorCorrectionLevel,
        ) -> Option<Retained<Self>>;

        /// Creates a QR code descriptor for the given payload and parameters.
        ///
        /// - Parameters:
        /// - errorCorrectedPayload: The data to encode in the QR code symbol.
        /// - symbolVersion: The symbol version, from 1 through 40.
        /// - maskPattern: The mask pattern to use in the QR code, from 0 to 7.
        /// - errorCorrectionLevel: The QR code's error correction level: L, M, Q, or H.
        /// - Returns:
        /// An autoreleased ``CIAztecCodeDescriptor`` instance
        /// or `nil` if the parameters are invalid
        #[unsafe(method(descriptorWithPayload:symbolVersion:maskPattern:errorCorrectionLevel:))]
        #[unsafe(method_family = none)]
        pub unsafe fn descriptorWithPayload_symbolVersion_maskPattern_errorCorrectionLevel(
            error_corrected_payload: &NSData,
            symbol_version: NSInteger,
            mask_pattern: u8,
            error_correction_level: CIQRCodeErrorCorrectionLevel,
        ) -> Option<Retained<Self>>;
    );
}

/// Methods declared on superclass `NSObject`.
impl CIQRCodeDescriptor {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}

extern_class!(
    /// A concrete subclass the Core Image Barcode Descriptor that represents an Aztec code symbol.
    ///
    /// An Aztec code symbol is a 2D barcode format defined by the ISO/IEC 24778:2008 standard.
    /// It encodes data in concentric square rings around a central bullseye pattern.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/ciazteccodedescriptor?language=objc)
    #[unsafe(super(CIBarcodeDescriptor, NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct CIAztecCodeDescriptor;
);

extern_conformance!(
    unsafe impl NSCoding for CIAztecCodeDescriptor {}
);

extern_conformance!(
    unsafe impl NSCopying for CIAztecCodeDescriptor {}
);

unsafe impl CopyingHelper for CIAztecCodeDescriptor {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for CIAztecCodeDescriptor {}
);

extern_conformance!(
    unsafe impl NSSecureCoding for CIAztecCodeDescriptor {}
);

impl CIAztecCodeDescriptor {
    extern_methods!(
        /// The error-corrected payload that comprises the the Aztec code symbol.
        ///
        /// Aztec Codes are formally specified in ISO/IEC 24778:2008(E).
        ///
        /// The error corrected payload consists of the 6-, 8-, 10-, or 12-bit message codewords produced
        /// at the end of the step described in section 7.3.1.2 "Formation of data codewords", which exists
        /// immediately prior to adding error correction. These codewords have dummy bits inserted to ensure
        /// that an entire codeword isn't all 0's or all 1's. Clients will need to remove these extra bits
        /// as part of interpreting the payload.
        #[unsafe(method(errorCorrectedPayload))]
        #[unsafe(method_family = none)]
        pub unsafe fn errorCorrectedPayload(&self) -> Retained<NSData>;

        /// A Boolean value telling if the Aztec code is compact.
        ///
        /// Compact Aztec symbols use one-fewer ring in the central finder pattern than full-range
        /// Aztec symbols of the same number of data layers.
        #[unsafe(method(isCompact))]
        #[unsafe(method_family = none)]
        pub unsafe fn isCompact(&self) -> bool;

        /// The number of data layers in the Aztec code symbol.
        ///
        /// Combined with ``isCompact-property``, the number of data layers determines the number of
        /// modules in the Aztec Code symbol. Valid values range from 1 to 32. Compact symbols can have
        /// up to 4 data layers.
        ///
        /// The number of data layers also determines the number of bits in each data codeword of the message
        /// carried by the Aztec Code symbol.
        #[unsafe(method(layerCount))]
        #[unsafe(method_family = none)]
        pub unsafe fn layerCount(&self) -> NSInteger;

        /// The number of non-error-correction codewords carried by the Aztec code symbol.
        ///
        /// Used to determine the level of error correction in conjunction with the number of data layers.
        /// Valid values are 1 to 2048. Compact symbols can have up to 64 message codewords.
        ///
        /// > Note: this value can exceed the number of message codewords allowed by the number of data
        /// layers in this symbol. In this case, the actual number of message codewords is 1024 fewer than
        /// this value and the message payload is to be interpreted in an application-defined manner.
        #[unsafe(method(dataCodewordCount))]
        #[unsafe(method_family = none)]
        pub unsafe fn dataCodewordCount(&self) -> NSInteger;

        /// Initializes an Aztec code descriptor for the given payload and parameters.
        ///
        /// - Parameters:
        /// - errorCorrectedPayload: The data to encode in the Aztec code symbol.
        /// - isCompact: A Boolean indicating whether or not the Aztec code is compact.
        /// - layerCount: The number of layers in the Aztec code, from 1 to 32.
        /// - dataCodewordCount: The number of codewords in the Aztec code, from 1 to 2048.
        /// - Returns:
        /// An initialized ``CIAztecCodeDescriptor`` instance
        /// or `nil` if the parameters are invalid
        #[unsafe(method(initWithPayload:isCompact:layerCount:dataCodewordCount:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithPayload_isCompact_layerCount_dataCodewordCount(
            this: Allocated<Self>,
            error_corrected_payload: &NSData,
            is_compact: bool,
            layer_count: NSInteger,
            data_codeword_count: NSInteger,
        ) -> Option<Retained<Self>>;

        /// Creates an Aztec code descriptor for the given payload and parameters.
        ///
        /// - Parameters:
        /// - errorCorrectedPayload: The data to encode in the Aztec code symbol.
        /// - isCompact: A Boolean indicating whether or not the Aztec code is compact.
        /// - layerCount: The number of layers in the Aztec code, from 1 to 32.
        /// - dataCodewordCount: The number of codewords in the Aztec code, from 1 to 2048.
        /// - Returns:
        /// An autoreleased ``CIAztecCodeDescriptor`` instance
        /// or `nil` if the parameters are invalid
        #[unsafe(method(descriptorWithPayload:isCompact:layerCount:dataCodewordCount:))]
        #[unsafe(method_family = none)]
        pub unsafe fn descriptorWithPayload_isCompact_layerCount_dataCodewordCount(
            error_corrected_payload: &NSData,
            is_compact: bool,
            layer_count: NSInteger,
            data_codeword_count: NSInteger,
        ) -> Option<Retained<Self>>;
    );
}

/// Methods declared on superclass `NSObject`.
impl CIAztecCodeDescriptor {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}

extern_class!(
    /// A concrete subclass of Core Image Barcode Descriptor that represents a PDF417 symbol.
    ///
    /// PDF417 is a stacked linear barcode symbol format used predominantly in transport, ID cards,
    /// and inventory management. Each pattern in the code comprises 4 bars and spaces, 17 units long.
    ///
    /// Refer to the ISO/IEC 15438:2006(E) for the PDF417 symbol specification.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/cipdf417codedescriptor?language=objc)
    #[unsafe(super(CIBarcodeDescriptor, NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct CIPDF417CodeDescriptor;
);

extern_conformance!(
    unsafe impl NSCoding for CIPDF417CodeDescriptor {}
);

extern_conformance!(
    unsafe impl NSCopying for CIPDF417CodeDescriptor {}
);

unsafe impl CopyingHelper for CIPDF417CodeDescriptor {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for CIPDF417CodeDescriptor {}
);

extern_conformance!(
    unsafe impl NSSecureCoding for CIPDF417CodeDescriptor {}
);

impl CIPDF417CodeDescriptor {
    extern_methods!(
        /// The error-corrected payload containing the data encoded in the PDF417 code symbol.
        ///
        /// The first codeword indicates the number of data codewords in the errorCorrectedPayload.
        ///
        /// PDF417 codes are comprised of a start character on the left and a stop character on the right.
        /// Each row begins and ends with special characters indicating the current row as well as information
        /// about the dimensions of the PDF417 symbol. The errorCorrectedPayload represents the sequence
        /// of PDF417 codewords that make up the body of the message. The first codeword indicates the number
        /// of codewords in the message. This count includes the "count" codeword and any padding codewords,
        /// but does not include the error correction codewords. Each codeword is a 16-bit value in the range
        /// of 0...928. The sequence is to be interpreted as described in the PDF417 bar code symbology
        /// specification -- ISO/IEC 15438:2006(E).
        #[unsafe(method(errorCorrectedPayload))]
        #[unsafe(method_family = none)]
        pub unsafe fn errorCorrectedPayload(&self) -> Retained<NSData>;

        /// A boolean value telling if the PDF417 code is compact.
        ///
        /// Compact PDF417 symbols have abbreviated right-side guard bars.
        #[unsafe(method(isCompact))]
        #[unsafe(method_family = none)]
        pub unsafe fn isCompact(&self) -> bool;

        /// The number of rows in the PDF417 code symbol.
        ///
        /// Valid row count values are from 3 to 90.
        #[unsafe(method(rowCount))]
        #[unsafe(method_family = none)]
        pub unsafe fn rowCount(&self) -> NSInteger;

        /// The number of columns in the PDF417 code symbol.
        ///
        /// Valid column count values are from 1 to 30.
        /// This count excluded the columns used to indicate the symbol structure.
        #[unsafe(method(columnCount))]
        #[unsafe(method_family = none)]
        pub unsafe fn columnCount(&self) -> NSInteger;

        /// Initializes an PDF417 code descriptor for the given payload and parameters.
        ///
        /// - Parameters:
        /// - errorCorrectedPayload: The data to encode in the PDF417 code symbol.
        /// - isCompact: A Boolean indicating whether or not the PDF417 code is compact.
        /// - rowCount: The number of rows in the PDF417 code, from 3 to 90.
        /// - columnCount: The number of columns in the Aztec code, from 1 to 30.
        /// - Returns:
        /// An initialized ``CIPDF417CodeDescriptor`` instance
        /// or `nil` if the parameters are invalid
        #[unsafe(method(initWithPayload:isCompact:rowCount:columnCount:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithPayload_isCompact_rowCount_columnCount(
            this: Allocated<Self>,
            error_corrected_payload: &NSData,
            is_compact: bool,
            row_count: NSInteger,
            column_count: NSInteger,
        ) -> Option<Retained<Self>>;

        /// Creates an PDF417 code descriptor for the given payload and parameters.
        ///
        /// - Parameters:
        /// - errorCorrectedPayload: The data to encode in the PDF417 code symbol.
        /// - isCompact: A Boolean indicating whether or not the PDF417 code is compact.
        /// - rowCount: The number of rows in the PDF417 code, from 3 to 90.
        /// - columnCount: The number of columns in the Aztec code, from 1 to 30.
        /// - Returns:
        /// An autoreleased ``CIPDF417CodeDescriptor`` instance
        /// or `nil` if the parameters are invalid
        #[unsafe(method(descriptorWithPayload:isCompact:rowCount:columnCount:))]
        #[unsafe(method_family = none)]
        pub unsafe fn descriptorWithPayload_isCompact_rowCount_columnCount(
            error_corrected_payload: &NSData,
            is_compact: bool,
            row_count: NSInteger,
            column_count: NSInteger,
        ) -> Option<Retained<Self>>;
    );
}

/// Methods declared on superclass `NSObject`.
impl CIPDF417CodeDescriptor {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}

/// Constants indicating the Data Matrix code ECC version.
///
/// ECC 000 - 140 symbols offer five levels of error correction using convolutional code error correction.
/// Each successive level or error correction offers more protection for the message data but increases the
/// size of the symbol required to carry a given message. See the ISO/IEC 16022:2006 spec for other modes.
///
/// ECC 200 symbols utilize Reed-Solomon error correction.
/// The error correction capacity for any given Data Matrix symbol is fixed by the size (in rows and columns)
/// of the symbol. See Table 7 of ISO/IEC 16022:2006(E) for more details.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/cidatamatrixcodeeccversion?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CIDataMatrixCodeECCVersion(pub NSInteger);
impl CIDataMatrixCodeECCVersion {
    /// Indicates error correction using convolutional code error correction with no data protection.
    #[doc(alias = "CIDataMatrixCodeECCVersion000")]
    pub const Version000: Self = Self(0);
    /// Indicates 1/4 of the symbol is dedicated to convolutional code error correction.
    #[doc(alias = "CIDataMatrixCodeECCVersion050")]
    pub const Version050: Self = Self(50);
    /// Indicates 1/3 of the symbol is dedicated to convolutional code error correction.
    #[doc(alias = "CIDataMatrixCodeECCVersion080")]
    pub const Version080: Self = Self(80);
    /// Indicates 1/2 of the symbol is dedicated to convolutional code error correction.
    #[doc(alias = "CIDataMatrixCodeECCVersion100")]
    pub const Version100: Self = Self(100);
    /// Indicates 3/4 of the symbol is dedicated to convolutional code error correction.
    #[doc(alias = "CIDataMatrixCodeECCVersion140")]
    pub const Version140: Self = Self(140);
    /// Indicates error correction using Reed-Solomon error correction. Data protection overhead varies based on symbol size.
    #[doc(alias = "CIDataMatrixCodeECCVersion200")]
    pub const Version200: Self = Self(200);
}

unsafe impl Encode for CIDataMatrixCodeECCVersion {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for CIDataMatrixCodeECCVersion {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// A concrete subclass the Core Image Barcode Descriptor that represents an Data Matrix code symbol.
    ///
    /// A Data Matrix code symbol is a 2D barcode format defined by the ISO/IEC 16022:2006(E) standard.
    /// It encodes data in square or rectangular symbol with solid lines on the left and bottom sides
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/cidatamatrixcodedescriptor?language=objc)
    #[unsafe(super(CIBarcodeDescriptor, NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct CIDataMatrixCodeDescriptor;
);

extern_conformance!(
    unsafe impl NSCoding for CIDataMatrixCodeDescriptor {}
);

extern_conformance!(
    unsafe impl NSCopying for CIDataMatrixCodeDescriptor {}
);

unsafe impl CopyingHelper for CIDataMatrixCodeDescriptor {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for CIDataMatrixCodeDescriptor {}
);

extern_conformance!(
    unsafe impl NSSecureCoding for CIDataMatrixCodeDescriptor {}
);

impl CIDataMatrixCodeDescriptor {
    extern_methods!(
        /// The error-corrected payload containing the data encoded in the Data Matrix code symbol.
        ///
        /// DataMatrix symbols are specified bn ISO/IEC 16022:2006(E). ECC 200-type symbols will always
        /// have an even number of rows and columns.
        ///
        /// For ECC 200-type symbols, the phases of encoding data into a symbol are described in
        /// section 5.1 -- Encode procedure overview. The error corrected payload comprises the
        /// de-interleaved bits of the message described at the end of Step 1: Data encodation.
        #[unsafe(method(errorCorrectedPayload))]
        #[unsafe(method_family = none)]
        pub unsafe fn errorCorrectedPayload(&self) -> Retained<NSData>;

        /// The number of rows in the Data Matrix code symbol.
        ///
        /// Refer to ISO/IEC 16022:2006(E) for valid module row and column count combinations.
        #[unsafe(method(rowCount))]
        #[unsafe(method_family = none)]
        pub unsafe fn rowCount(&self) -> NSInteger;

        /// The number of columns in the Data Matrix code symbol.
        ///
        /// Refer to ISO/IEC 16022:2006(E) for valid module row and column count combinations.
        #[unsafe(method(columnCount))]
        #[unsafe(method_family = none)]
        pub unsafe fn columnCount(&self) -> NSInteger;

        /// The error correction version of the Data Matrix code symbol.
        ///
        /// The possible error correction version are enumerated in ``CIDataMatrixCodeECCVersion``.
        /// Any symbol with an even number of rows and columns will be ECC 200.
        #[unsafe(method(eccVersion))]
        #[unsafe(method_family = none)]
        pub unsafe fn eccVersion(&self) -> CIDataMatrixCodeECCVersion;

        /// Initializes a Data Matrix code descriptor for the given payload and parameters.
        ///
        /// - Parameters:
        /// - errorCorrectedPayload: The data to encode in the Data Matrix code symbol.
        /// - rowCount: The number of rows in the Data Matrix code symbol.
        /// - columnCount: The number of columns in the Data Matrix code symbol.
        /// - eccVersion: The ``CIDataMatrixCodeECCVersion`` for the Data Matrix code symbol.
        /// - Returns:
        /// An initialized ``CIAztecCodeDescriptor`` instance
        /// or `nil` if the parameters are invalid
        #[unsafe(method(initWithPayload:rowCount:columnCount:eccVersion:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithPayload_rowCount_columnCount_eccVersion(
            this: Allocated<Self>,
            error_corrected_payload: &NSData,
            row_count: NSInteger,
            column_count: NSInteger,
            ecc_version: CIDataMatrixCodeECCVersion,
        ) -> Option<Retained<Self>>;

        /// Creates a Data Matrix code descriptor for the given payload and parameters.
        ///
        /// - Parameters:
        /// - errorCorrectedPayload: The data to encode in the Data Matrix code symbol.
        /// - rowCount: The number of rows in the Data Matrix code symbol.
        /// - columnCount: The number of columns in the Data Matrix code symbol.
        /// - eccVersion: The ``CIDataMatrixCodeECCVersion`` for the Data Matrix code symbol.
        /// - Returns:
        /// An autoreleased ``CIAztecCodeDescriptor`` instance
        /// or `nil` if the parameters are invalid
        #[unsafe(method(descriptorWithPayload:rowCount:columnCount:eccVersion:))]
        #[unsafe(method_family = none)]
        pub unsafe fn descriptorWithPayload_rowCount_columnCount_eccVersion(
            error_corrected_payload: &NSData,
            row_count: NSInteger,
            column_count: NSInteger,
            ecc_version: CIDataMatrixCodeECCVersion,
        ) -> Option<Retained<Self>>;
    );
}

/// Methods declared on superclass `NSObject`.
impl CIDataMatrixCodeDescriptor {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}

mod private_NSUserActivityCIBarcodeDescriptor {
    pub trait Sealed {}
}

/// Category "CIBarcodeDescriptor" on [`NSUserActivity`].
#[doc(alias = "CIBarcodeDescriptor")]
pub unsafe trait NSUserActivityCIBarcodeDescriptor:
    ClassType + Sized + private_NSUserActivityCIBarcodeDescriptor::Sealed
{
    extern_methods!(
        /// The scanned code in the user activity passed in by system scanner.
        ///
        /// This property is optional. This value is present if the user activity was created from a source that detected a QR code or other code symbol.
        #[unsafe(method(detectedBarcodeDescriptor))]
        #[unsafe(method_family = none)]
        unsafe fn detectedBarcodeDescriptor(&self) -> Option<Retained<CIBarcodeDescriptor>>;
    );
}

impl private_NSUserActivityCIBarcodeDescriptor::Sealed for NSUserActivity {}
unsafe impl NSUserActivityCIBarcodeDescriptor for NSUserActivity {}
