package vcs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteVideoSummaryTask invokes the vcs.DeleteVideoSummaryTask API synchronously
func (client *Client) DeleteVideoSummaryTask(request *DeleteVideoSummaryTaskRequest) (response *DeleteVideoSummaryTaskResponse, err error) {
	response = CreateDeleteVideoSummaryTaskResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteVideoSummaryTaskWithChan invokes the vcs.DeleteVideoSummaryTask API asynchronously
func (client *Client) DeleteVideoSummaryTaskWithChan(request *DeleteVideoSummaryTaskRequest) (<-chan *DeleteVideoSummaryTaskResponse, <-chan error) {
	responseChan := make(chan *DeleteVideoSummaryTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteVideoSummaryTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteVideoSummaryTaskWithCallback invokes the vcs.DeleteVideoSummaryTask API asynchronously
func (client *Client) DeleteVideoSummaryTaskWithCallback(request *DeleteVideoSummaryTaskRequest, callback func(response *DeleteVideoSummaryTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteVideoSummaryTaskResponse
		var err error
		defer close(result)
		response, err = client.DeleteVideoSummaryTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteVideoSummaryTaskRequest is the request struct for api DeleteVideoSummaryTask
type DeleteVideoSummaryTaskRequest struct {
	*requests.RpcRequest
	CorpId string `position:"Body" name:"CorpId"`
	TaskId string `position:"Body" name:"TaskId"`
}

// DeleteVideoSummaryTaskResponse is the response struct for api DeleteVideoSummaryTask
type DeleteVideoSummaryTaskResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Data      string `json:"Data" xml:"Data"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteVideoSummaryTaskRequest creates a request to invoke DeleteVideoSummaryTask API
func CreateDeleteVideoSummaryTaskRequest() (request *DeleteVideoSummaryTaskRequest) {
	request = &DeleteVideoSummaryTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vcs", "2020-05-15", "DeleteVideoSummaryTask", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteVideoSummaryTaskResponse creates a response to parse from DeleteVideoSummaryTask response
func CreateDeleteVideoSummaryTaskResponse() (response *DeleteVideoSummaryTaskResponse) {
	response = &DeleteVideoSummaryTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
