package retailcloud

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreatePersistentVolumeClaim invokes the retailcloud.CreatePersistentVolumeClaim API synchronously
func (client *Client) CreatePersistentVolumeClaim(request *CreatePersistentVolumeClaimRequest) (response *CreatePersistentVolumeClaimResponse, err error) {
	response = CreateCreatePersistentVolumeClaimResponse()
	err = client.DoAction(request, response)
	return
}

// CreatePersistentVolumeClaimWithChan invokes the retailcloud.CreatePersistentVolumeClaim API asynchronously
func (client *Client) CreatePersistentVolumeClaimWithChan(request *CreatePersistentVolumeClaimRequest) (<-chan *CreatePersistentVolumeClaimResponse, <-chan error) {
	responseChan := make(chan *CreatePersistentVolumeClaimResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreatePersistentVolumeClaim(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreatePersistentVolumeClaimWithCallback invokes the retailcloud.CreatePersistentVolumeClaim API asynchronously
func (client *Client) CreatePersistentVolumeClaimWithCallback(request *CreatePersistentVolumeClaimRequest, callback func(response *CreatePersistentVolumeClaimResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreatePersistentVolumeClaimResponse
		var err error
		defer close(result)
		response, err = client.CreatePersistentVolumeClaim(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreatePersistentVolumeClaimRequest is the request struct for api CreatePersistentVolumeClaim
type CreatePersistentVolumeClaimRequest struct {
	*requests.RpcRequest
	AccessModes  string           `position:"Query" name:"AccessModes"`
	AppId        requests.Integer `position:"Query" name:"AppId"`
	Name         string           `position:"Query" name:"Name"`
	EnvId        requests.Integer `position:"Query" name:"EnvId"`
	StorageClass string           `position:"Query" name:"StorageClass"`
	Capacity     string           `position:"Query" name:"Capacity"`
}

// CreatePersistentVolumeClaimResponse is the response struct for api CreatePersistentVolumeClaim
type CreatePersistentVolumeClaimResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	ErrMsg    string `json:"ErrMsg" xml:"ErrMsg"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateCreatePersistentVolumeClaimRequest creates a request to invoke CreatePersistentVolumeClaim API
func CreateCreatePersistentVolumeClaimRequest() (request *CreatePersistentVolumeClaimRequest) {
	request = &CreatePersistentVolumeClaimRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("retailcloud", "2018-03-13", "CreatePersistentVolumeClaim", "", "")
	request.Method = requests.POST
	return
}

// CreateCreatePersistentVolumeClaimResponse creates a response to parse from CreatePersistentVolumeClaim response
func CreateCreatePersistentVolumeClaimResponse() (response *CreatePersistentVolumeClaimResponse) {
	response = &CreatePersistentVolumeClaimResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
