package r_kvstore

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// InitializeKvstorePermission invokes the r_kvstore.InitializeKvstorePermission API synchronously
func (client *Client) InitializeKvstorePermission(request *InitializeKvstorePermissionRequest) (response *InitializeKvstorePermissionResponse, err error) {
	response = CreateInitializeKvstorePermissionResponse()
	err = client.DoAction(request, response)
	return
}

// InitializeKvstorePermissionWithChan invokes the r_kvstore.InitializeKvstorePermission API asynchronously
func (client *Client) InitializeKvstorePermissionWithChan(request *InitializeKvstorePermissionRequest) (<-chan *InitializeKvstorePermissionResponse, <-chan error) {
	responseChan := make(chan *InitializeKvstorePermissionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.InitializeKvstorePermission(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// InitializeKvstorePermissionWithCallback invokes the r_kvstore.InitializeKvstorePermission API asynchronously
func (client *Client) InitializeKvstorePermissionWithCallback(request *InitializeKvstorePermissionRequest, callback func(response *InitializeKvstorePermissionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *InitializeKvstorePermissionResponse
		var err error
		defer close(result)
		response, err = client.InitializeKvstorePermission(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// InitializeKvstorePermissionRequest is the request struct for api InitializeKvstorePermission
type InitializeKvstorePermissionRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	SecurityToken        string           `position:"Query" name:"SecurityToken"`
	ServiceName          string           `position:"Query" name:"ServiceName"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// InitializeKvstorePermissionResponse is the response struct for api InitializeKvstorePermission
type InitializeKvstorePermissionResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateInitializeKvstorePermissionRequest creates a request to invoke InitializeKvstorePermission API
func CreateInitializeKvstorePermissionRequest() (request *InitializeKvstorePermissionRequest) {
	request = &InitializeKvstorePermissionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("R-kvstore", "2015-01-01", "InitializeKvstorePermission", "redisa", "openAPI")
	request.Method = requests.POST
	return
}

// CreateInitializeKvstorePermissionResponse creates a response to parse from InitializeKvstorePermission response
func CreateInitializeKvstorePermissionResponse() (response *InitializeKvstorePermissionResponse) {
	response = &InitializeKvstorePermissionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
