package domain

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SaveSingleTaskForModifyingDSRecord invokes the domain.SaveSingleTaskForModifyingDSRecord API synchronously
func (client *Client) SaveSingleTaskForModifyingDSRecord(request *SaveSingleTaskForModifyingDSRecordRequest) (response *SaveSingleTaskForModifyingDSRecordResponse, err error) {
	response = CreateSaveSingleTaskForModifyingDSRecordResponse()
	err = client.DoAction(request, response)
	return
}

// SaveSingleTaskForModifyingDSRecordWithChan invokes the domain.SaveSingleTaskForModifyingDSRecord API asynchronously
func (client *Client) SaveSingleTaskForModifyingDSRecordWithChan(request *SaveSingleTaskForModifyingDSRecordRequest) (<-chan *SaveSingleTaskForModifyingDSRecordResponse, <-chan error) {
	responseChan := make(chan *SaveSingleTaskForModifyingDSRecordResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SaveSingleTaskForModifyingDSRecord(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SaveSingleTaskForModifyingDSRecordWithCallback invokes the domain.SaveSingleTaskForModifyingDSRecord API asynchronously
func (client *Client) SaveSingleTaskForModifyingDSRecordWithCallback(request *SaveSingleTaskForModifyingDSRecordRequest, callback func(response *SaveSingleTaskForModifyingDSRecordResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SaveSingleTaskForModifyingDSRecordResponse
		var err error
		defer close(result)
		response, err = client.SaveSingleTaskForModifyingDSRecord(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SaveSingleTaskForModifyingDSRecordRequest is the request struct for api SaveSingleTaskForModifyingDSRecord
type SaveSingleTaskForModifyingDSRecordRequest struct {
	*requests.RpcRequest
	KeyTag       requests.Integer `position:"Query" name:"KeyTag"`
	DomainName   string           `position:"Query" name:"DomainName"`
	UserClientIp string           `position:"Query" name:"UserClientIp"`
	DigestType   requests.Integer `position:"Query" name:"DigestType"`
	Digest       string           `position:"Query" name:"Digest"`
	Lang         string           `position:"Query" name:"Lang"`
	Algorithm    requests.Integer `position:"Query" name:"Algorithm"`
}

// SaveSingleTaskForModifyingDSRecordResponse is the response struct for api SaveSingleTaskForModifyingDSRecord
type SaveSingleTaskForModifyingDSRecordResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	TaskNo    string `json:"TaskNo" xml:"TaskNo"`
}

// CreateSaveSingleTaskForModifyingDSRecordRequest creates a request to invoke SaveSingleTaskForModifyingDSRecord API
func CreateSaveSingleTaskForModifyingDSRecordRequest() (request *SaveSingleTaskForModifyingDSRecordRequest) {
	request = &SaveSingleTaskForModifyingDSRecordRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Domain", "2018-01-29", "SaveSingleTaskForModifyingDSRecord", "", "")
	request.Method = requests.POST
	return
}

// CreateSaveSingleTaskForModifyingDSRecordResponse creates a response to parse from SaveSingleTaskForModifyingDSRecord response
func CreateSaveSingleTaskForModifyingDSRecordResponse() (response *SaveSingleTaskForModifyingDSRecordResponse) {
	response = &SaveSingleTaskForModifyingDSRecordResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
