package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDcdnBlockedRegions invokes the dcdn.DescribeDcdnBlockedRegions API synchronously
func (client *Client) DescribeDcdnBlockedRegions(request *DescribeDcdnBlockedRegionsRequest) (response *DescribeDcdnBlockedRegionsResponse, err error) {
	response = CreateDescribeDcdnBlockedRegionsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDcdnBlockedRegionsWithChan invokes the dcdn.DescribeDcdnBlockedRegions API asynchronously
func (client *Client) DescribeDcdnBlockedRegionsWithChan(request *DescribeDcdnBlockedRegionsRequest) (<-chan *DescribeDcdnBlockedRegionsResponse, <-chan error) {
	responseChan := make(chan *DescribeDcdnBlockedRegionsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDcdnBlockedRegions(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDcdnBlockedRegionsWithCallback invokes the dcdn.DescribeDcdnBlockedRegions API asynchronously
func (client *Client) DescribeDcdnBlockedRegionsWithCallback(request *DescribeDcdnBlockedRegionsRequest, callback func(response *DescribeDcdnBlockedRegionsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDcdnBlockedRegionsResponse
		var err error
		defer close(result)
		response, err = client.DescribeDcdnBlockedRegions(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDcdnBlockedRegionsRequest is the request struct for api DescribeDcdnBlockedRegions
type DescribeDcdnBlockedRegionsRequest struct {
	*requests.RpcRequest
	Language string           `position:"Query" name:"Language"`
	OwnerId  requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeDcdnBlockedRegionsResponse is the response struct for api DescribeDcdnBlockedRegions
type DescribeDcdnBlockedRegionsResponse struct {
	*responses.BaseResponse
	RequestId string   `json:"RequestId" xml:"RequestId"`
	InfoList  InfoList `json:"InfoList" xml:"InfoList"`
}

// CreateDescribeDcdnBlockedRegionsRequest creates a request to invoke DescribeDcdnBlockedRegions API
func CreateDescribeDcdnBlockedRegionsRequest() (request *DescribeDcdnBlockedRegionsRequest) {
	request = &DescribeDcdnBlockedRegionsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "DescribeDcdnBlockedRegions", "", "")
	request.Method = requests.GET
	return
}

// CreateDescribeDcdnBlockedRegionsResponse creates a response to parse from DescribeDcdnBlockedRegions response
func CreateDescribeDcdnBlockedRegionsResponse() (response *DescribeDcdnBlockedRegionsResponse) {
	response = &DescribeDcdnBlockedRegionsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
