package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ReportZoneDay invokes the cloudwf.ReportZoneDay API synchronously
// api document: https://help.aliyun.com/api/cloudwf/reportzoneday.html
func (client *Client) ReportZoneDay(request *ReportZoneDayRequest) (response *ReportZoneDayResponse, err error) {
	response = CreateReportZoneDayResponse()
	err = client.DoAction(request, response)
	return
}

// ReportZoneDayWithChan invokes the cloudwf.ReportZoneDay API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/reportzoneday.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ReportZoneDayWithChan(request *ReportZoneDayRequest) (<-chan *ReportZoneDayResponse, <-chan error) {
	responseChan := make(chan *ReportZoneDayResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ReportZoneDay(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ReportZoneDayWithCallback invokes the cloudwf.ReportZoneDay API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/reportzoneday.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ReportZoneDayWithCallback(request *ReportZoneDayRequest, callback func(response *ReportZoneDayResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ReportZoneDayResponse
		var err error
		defer close(result)
		response, err = client.ReportZoneDay(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ReportZoneDayRequest is the request struct for api ReportZoneDay
type ReportZoneDayRequest struct {
	*requests.RpcRequest
	BeginDate string           `position:"Query" name:"BeginDate"`
	EndDate   string           `position:"Query" name:"EndDate"`
	Agsid     requests.Integer `position:"Query" name:"Agsid"`
}

// ReportZoneDayResponse is the response struct for api ReportZoneDay
type ReportZoneDayResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateReportZoneDayRequest creates a request to invoke ReportZoneDay API
func CreateReportZoneDayRequest() (request *ReportZoneDayRequest) {
	request = &ReportZoneDayRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "ReportZoneDay", "cloudwf", "openAPI")
	return
}

// CreateReportZoneDayResponse creates a response to parse from ReportZoneDay response
func CreateReportZoneDayResponse() (response *ReportZoneDayResponse) {
	response = &ReportZoneDayResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
