package cloudapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteAllTrafficSpecialControl invokes the cloudapi.DeleteAllTrafficSpecialControl API synchronously
// api document: https://help.aliyun.com/api/cloudapi/deletealltrafficspecialcontrol.html
func (client *Client) DeleteAllTrafficSpecialControl(request *DeleteAllTrafficSpecialControlRequest) (response *DeleteAllTrafficSpecialControlResponse, err error) {
	response = CreateDeleteAllTrafficSpecialControlResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteAllTrafficSpecialControlWithChan invokes the cloudapi.DeleteAllTrafficSpecialControl API asynchronously
// api document: https://help.aliyun.com/api/cloudapi/deletealltrafficspecialcontrol.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteAllTrafficSpecialControlWithChan(request *DeleteAllTrafficSpecialControlRequest) (<-chan *DeleteAllTrafficSpecialControlResponse, <-chan error) {
	responseChan := make(chan *DeleteAllTrafficSpecialControlResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteAllTrafficSpecialControl(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteAllTrafficSpecialControlWithCallback invokes the cloudapi.DeleteAllTrafficSpecialControl API asynchronously
// api document: https://help.aliyun.com/api/cloudapi/deletealltrafficspecialcontrol.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteAllTrafficSpecialControlWithCallback(request *DeleteAllTrafficSpecialControlRequest, callback func(response *DeleteAllTrafficSpecialControlResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteAllTrafficSpecialControlResponse
		var err error
		defer close(result)
		response, err = client.DeleteAllTrafficSpecialControl(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteAllTrafficSpecialControlRequest is the request struct for api DeleteAllTrafficSpecialControl
type DeleteAllTrafficSpecialControlRequest struct {
	*requests.RpcRequest
	TrafficControlId string `position:"Query" name:"TrafficControlId"`
	SecurityToken    string `position:"Query" name:"SecurityToken"`
}

// DeleteAllTrafficSpecialControlResponse is the response struct for api DeleteAllTrafficSpecialControl
type DeleteAllTrafficSpecialControlResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteAllTrafficSpecialControlRequest creates a request to invoke DeleteAllTrafficSpecialControl API
func CreateDeleteAllTrafficSpecialControlRequest() (request *DeleteAllTrafficSpecialControlRequest) {
	request = &DeleteAllTrafficSpecialControlRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudAPI", "2016-07-14", "DeleteAllTrafficSpecialControl", "apigateway", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteAllTrafficSpecialControlResponse creates a response to parse from DeleteAllTrafficSpecialControl response
func CreateDeleteAllTrafficSpecialControlResponse() (response *DeleteAllTrafficSpecialControlResponse) {
	response = &DeleteAllTrafficSpecialControlResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
