// { dg-do compile { target c++26 } }
// { dg-additional-options "-freflection" }
// Test reflection type traits [meta.reflection.traits].

#include <meta>
using namespace std::meta;

struct cls {
  using type = int;
  void mem_fun ();
  static void static_mem_fun ();
};
struct empty { };
using alias = cls;
struct derived : cls { };
union onion {
  onion &operator=(const cls&);
  onion &operator=(cls&&);
};
enum class Enum : short {};
enum class Enum_class { A };
class abstract_cls { virtual void fn() = 0; };
class final_cls final {};
struct ctor_cls {
  ctor_cls (int, bool) noexcept {}
};
struct trivial_cls {
  int i;
  bool b;
};
class virtual_dtor_cls {
  virtual ~virtual_dtor_cls () {}
};
int fun (bool, char) noexcept { return 0; }

static_assert (!is_function_type (^^void));
static_assert (!is_function_type (^^int));
static_assert (!is_function_type (^^const int));
static_assert (!is_function_type (^^volatile int));
static_assert (!is_function_type (^^unsigned));
static_assert (!is_function_type (^^float));
static_assert (!is_function_type (^^int&));
static_assert (!is_function_type (^^int&&));
static_assert (!is_function_type (^^int *));
static_assert (!is_function_type (^^int[1]));
static_assert (!is_function_type (^^int[]));
static_assert (!is_function_type (^^nullptr_t));
static_assert (!is_function_type (^^std::meta::info));
static_assert (!is_function_type (^^int (cls::*)));
static_assert (!is_function_type (^^int (cls::*)()));
static_assert (!is_function_type (^^cls));
static_assert (is_function_type (type_of (^^cls::mem_fun)));
static_assert (is_function_type (type_of (^^cls::static_mem_fun)));
static_assert (!is_function_type (^^empty));
static_assert (!is_function_type (^^abstract_cls));
static_assert (!is_function_type (^^final_cls));
static_assert (!is_function_type (^^ctor_cls));
static_assert (!is_function_type (^^trivial_cls));
static_assert (!is_function_type (^^virtual_dtor_cls));
static_assert (!is_function_type (^^onion));
static_assert (!is_function_type (^^Enum));
static_assert (!is_function_type (^^Enum_class));
static_assert (is_function_type (^^void ()));

static_assert (is_void_type (^^void));
static_assert (is_void_type (^^const void));
static_assert (is_void_type (^^volatile void));
static_assert (!is_void_type (^^void *));
static_assert (!is_void_type (^^int));
static_assert (!is_void_type (^^const int));
static_assert (!is_void_type (^^volatile int));
static_assert (!is_void_type (^^unsigned));
static_assert (!is_void_type (^^float));
static_assert (!is_void_type (^^int&));
static_assert (!is_void_type (^^int&&));
static_assert (!is_void_type (^^int *));
static_assert (!is_void_type (^^int[1]));
static_assert (!is_void_type (^^int[]));
static_assert (!is_void_type (^^nullptr_t));
static_assert (!is_void_type (^^std::meta::info));
static_assert (!is_void_type (^^int (cls::*)));
static_assert (!is_void_type (^^int (cls::*)()));
static_assert (!is_void_type (^^cls));
static_assert (!is_void_type (^^empty));
static_assert (!is_void_type (^^abstract_cls));
static_assert (!is_void_type (^^final_cls));
static_assert (!is_void_type (^^ctor_cls));
static_assert (!is_void_type (^^trivial_cls));
static_assert (!is_void_type (^^virtual_dtor_cls));
static_assert (!is_void_type (^^onion));
static_assert (!is_void_type (^^Enum));
static_assert (!is_void_type (^^Enum_class));
static_assert (!is_void_type (^^void ()));

static_assert (!is_null_pointer_type (^^void));
static_assert (!is_null_pointer_type (^^int));
static_assert (!is_null_pointer_type (^^const int));
static_assert (!is_null_pointer_type (^^volatile int));
static_assert (!is_null_pointer_type (^^unsigned));
static_assert (!is_null_pointer_type (^^float));
static_assert (!is_null_pointer_type (^^int&));
static_assert (!is_null_pointer_type (^^int&&));
static_assert (!is_null_pointer_type (^^int *));
static_assert (!is_null_pointer_type (^^int[1]));
static_assert (!is_null_pointer_type (^^int[]));
static_assert (is_null_pointer_type (^^nullptr_t));
static_assert (!is_null_pointer_type (^^std::meta::info));
static_assert (!is_null_pointer_type (^^int (cls::*)));
static_assert (!is_null_pointer_type (^^int (cls::*)()));
static_assert (!is_null_pointer_type (^^cls));
static_assert (!is_null_pointer_type (^^empty));
static_assert (!is_null_pointer_type (^^abstract_cls));
static_assert (!is_null_pointer_type (^^final_cls));
static_assert (!is_null_pointer_type (^^ctor_cls));
static_assert (!is_null_pointer_type (^^trivial_cls));
static_assert (!is_null_pointer_type (^^virtual_dtor_cls));
static_assert (!is_null_pointer_type (^^onion));
static_assert (!is_null_pointer_type (^^Enum));
static_assert (!is_null_pointer_type (^^Enum_class));
static_assert (!is_null_pointer_type (^^void ()));

static_assert (!is_integral_type (^^void));
static_assert (is_integral_type (^^bool));
static_assert (is_integral_type (^^wchar_t));
static_assert (is_integral_type (^^char8_t));
static_assert (is_integral_type (^^char16_t));
static_assert (is_integral_type (^^char32_t));
static_assert (is_integral_type (^^int));
static_assert (is_integral_type (^^const int));
static_assert (is_integral_type (^^volatile int));
static_assert (is_integral_type (^^unsigned));
static_assert (!is_integral_type (^^float));
static_assert (!is_integral_type (^^int&));
static_assert (!is_integral_type (^^int&&));
static_assert (!is_integral_type (^^int *));
static_assert (!is_integral_type (^^int[1]));
static_assert (!is_integral_type (^^int[]));
static_assert (!is_integral_type (^^nullptr_t));
static_assert (!is_integral_type (^^std::meta::info));
static_assert (!is_integral_type (^^int (cls::*)));
static_assert (!is_integral_type (^^int (cls::*)()));
static_assert (!is_integral_type (^^cls));
static_assert (!is_integral_type (^^empty));
static_assert (!is_integral_type (^^abstract_cls));
static_assert (!is_integral_type (^^final_cls));
static_assert (!is_integral_type (^^ctor_cls));
static_assert (!is_integral_type (^^trivial_cls));
static_assert (!is_integral_type (^^virtual_dtor_cls));
static_assert (!is_integral_type (^^onion));
static_assert (!is_integral_type (^^Enum));
static_assert (!is_integral_type (^^Enum_class));
static_assert (!is_integral_type (^^void ()));

static_assert (!is_floating_point_type (^^void));
static_assert (!is_floating_point_type (^^int));
static_assert (!is_floating_point_type (^^const int));
static_assert (!is_floating_point_type (^^volatile int));
static_assert (!is_floating_point_type (^^unsigned));
static_assert (is_floating_point_type (^^float));
static_assert (is_floating_point_type (^^double));
static_assert (is_floating_point_type (^^const double));
static_assert (!is_floating_point_type (^^int&));
static_assert (!is_floating_point_type (^^int&&));
static_assert (!is_floating_point_type (^^int *));
static_assert (!is_floating_point_type (^^int[1]));
static_assert (!is_floating_point_type (^^int[]));
static_assert (!is_floating_point_type (^^nullptr_t));
static_assert (!is_floating_point_type (^^std::meta::info));
static_assert (!is_floating_point_type (^^int (cls::*)));
static_assert (!is_floating_point_type (^^int (cls::*)()));
static_assert (!is_floating_point_type (^^cls));
static_assert (!is_floating_point_type (^^empty));
static_assert (!is_floating_point_type (^^abstract_cls));
static_assert (!is_floating_point_type (^^final_cls));
static_assert (!is_floating_point_type (^^ctor_cls));
static_assert (!is_floating_point_type (^^trivial_cls));
static_assert (!is_floating_point_type (^^virtual_dtor_cls));
static_assert (!is_floating_point_type (^^onion));
static_assert (!is_floating_point_type (^^Enum));
static_assert (!is_floating_point_type (^^Enum_class));
static_assert (!is_floating_point_type (^^void ()));

static_assert (!is_array_type (^^void));
static_assert (!is_array_type (^^int));
static_assert (!is_array_type (^^const int));
static_assert (!is_array_type (^^volatile int));
static_assert (!is_array_type (^^unsigned));
static_assert (!is_array_type (^^float));
static_assert (!is_array_type (^^int&));
static_assert (!is_array_type (^^int&&));
static_assert (!is_array_type (^^int *));
static_assert (is_array_type (^^int[1]));
static_assert (is_array_type (^^int[]));
static_assert (!is_array_type (^^nullptr_t));
static_assert (!is_array_type (^^std::meta::info));
static_assert (!is_array_type (^^int (cls::*)));
static_assert (!is_array_type (^^int (cls::*)()));
static_assert (!is_array_type (^^cls));
static_assert (!is_array_type (^^empty));
static_assert (!is_array_type (^^abstract_cls));
static_assert (!is_array_type (^^final_cls));
static_assert (!is_array_type (^^ctor_cls));
static_assert (!is_array_type (^^trivial_cls));
static_assert (!is_array_type (^^virtual_dtor_cls));
static_assert (!is_array_type (^^onion));
static_assert (!is_array_type (^^Enum));
static_assert (!is_array_type (^^Enum_class));
static_assert (!is_array_type (^^void ()));

static_assert (!is_pointer_type (^^void));
static_assert (!is_pointer_type (^^int));
static_assert (!is_pointer_type (^^const int));
static_assert (!is_pointer_type (^^volatile int));
static_assert (!is_pointer_type (^^unsigned));
static_assert (!is_pointer_type (^^float));
static_assert (!is_pointer_type (^^int&));
static_assert (!is_pointer_type (^^int&&));
static_assert (is_pointer_type (^^int *));
static_assert (is_pointer_type (^^int **));
static_assert (is_pointer_type (^^int *const *const));
static_assert (!is_pointer_type (^^int[1]));
static_assert (!is_pointer_type (^^int[]));
static_assert (!is_pointer_type (^^nullptr_t));
static_assert (!is_pointer_type (^^std::meta::info));
static_assert (!is_pointer_type (^^int (cls::*)));
static_assert (!is_pointer_type (^^int (cls::*)()));
static_assert (!is_pointer_type (^^cls));
static_assert (!is_pointer_type (^^empty));
static_assert (!is_pointer_type (^^abstract_cls));
static_assert (!is_pointer_type (^^final_cls));
static_assert (!is_pointer_type (^^ctor_cls));
static_assert (!is_pointer_type (^^trivial_cls));
static_assert (!is_pointer_type (^^virtual_dtor_cls));
static_assert (!is_pointer_type (^^onion));
static_assert (!is_pointer_type (^^Enum));
static_assert (!is_pointer_type (^^Enum_class));
static_assert (!is_pointer_type (^^void ()));

static_assert (!is_lvalue_reference_type (^^void));
static_assert (!is_lvalue_reference_type (^^int));
static_assert (!is_lvalue_reference_type (^^const int));
static_assert (!is_lvalue_reference_type (^^volatile int));
static_assert (!is_lvalue_reference_type (^^unsigned));
static_assert (!is_lvalue_reference_type (^^float));
static_assert (is_lvalue_reference_type (^^int&));
static_assert (!is_lvalue_reference_type (^^int&&));
static_assert (!is_lvalue_reference_type (^^int *));
static_assert (!is_lvalue_reference_type (^^int[1]));
static_assert (!is_lvalue_reference_type (^^int[]));
static_assert (!is_lvalue_reference_type (^^nullptr_t));
static_assert (!is_lvalue_reference_type (^^std::meta::info));
static_assert (!is_lvalue_reference_type (^^int (cls::*)));
static_assert (!is_lvalue_reference_type (^^int (cls::*)()));
static_assert (!is_lvalue_reference_type (^^cls));
static_assert (!is_lvalue_reference_type (^^empty));
static_assert (!is_lvalue_reference_type (^^abstract_cls));
static_assert (!is_lvalue_reference_type (^^final_cls));
static_assert (!is_lvalue_reference_type (^^ctor_cls));
static_assert (!is_lvalue_reference_type (^^trivial_cls));
static_assert (!is_lvalue_reference_type (^^virtual_dtor_cls));
static_assert (!is_lvalue_reference_type (^^onion));
static_assert (!is_lvalue_reference_type (^^Enum));
static_assert (!is_lvalue_reference_type (^^Enum_class));
static_assert (!is_lvalue_reference_type (^^void ()));

static_assert (!is_rvalue_reference_type (^^void));
static_assert (!is_rvalue_reference_type (^^int));
static_assert (!is_rvalue_reference_type (^^const int));
static_assert (!is_rvalue_reference_type (^^volatile int));
static_assert (!is_rvalue_reference_type (^^unsigned));
static_assert (!is_rvalue_reference_type (^^float));
static_assert (!is_rvalue_reference_type (^^int&));
static_assert (is_rvalue_reference_type (^^int&&));
static_assert (!is_rvalue_reference_type (^^int *));
static_assert (!is_rvalue_reference_type (^^int[1]));
static_assert (!is_rvalue_reference_type (^^int[]));
static_assert (!is_rvalue_reference_type (^^nullptr_t));
static_assert (!is_rvalue_reference_type (^^std::meta::info));
static_assert (!is_rvalue_reference_type (^^int (cls::*)));
static_assert (!is_rvalue_reference_type (^^int (cls::*)()));
static_assert (!is_rvalue_reference_type (^^cls));
static_assert (!is_rvalue_reference_type (^^empty));
static_assert (!is_rvalue_reference_type (^^abstract_cls));
static_assert (!is_rvalue_reference_type (^^final_cls));
static_assert (!is_rvalue_reference_type (^^ctor_cls));
static_assert (!is_rvalue_reference_type (^^trivial_cls));
static_assert (!is_rvalue_reference_type (^^virtual_dtor_cls));
static_assert (!is_rvalue_reference_type (^^onion));
static_assert (!is_rvalue_reference_type (^^Enum));
static_assert (!is_rvalue_reference_type (^^Enum_class));
static_assert (!is_rvalue_reference_type (^^void ()));

static_assert (!is_member_object_pointer_type (^^void));
static_assert (!is_member_object_pointer_type (^^int));
static_assert (!is_member_object_pointer_type (^^const int));
static_assert (!is_member_object_pointer_type (^^volatile int));
static_assert (!is_member_object_pointer_type (^^unsigned));
static_assert (!is_member_object_pointer_type (^^float));
static_assert (!is_member_object_pointer_type (^^int&));
static_assert (!is_member_object_pointer_type (^^int&&));
static_assert (!is_member_object_pointer_type (^^int *));
static_assert (!is_member_object_pointer_type (^^int[1]));
static_assert (!is_member_object_pointer_type (^^int[]));
static_assert (!is_member_object_pointer_type (^^nullptr_t));
static_assert (!is_member_object_pointer_type (^^std::meta::info));
static_assert (is_member_object_pointer_type (^^int (cls::*)));
static_assert (!is_member_object_pointer_type (^^int (cls::*)()));
static_assert (!is_member_object_pointer_type (^^cls));
static_assert (!is_member_object_pointer_type (^^empty));
static_assert (!is_member_object_pointer_type (^^abstract_cls));
static_assert (!is_member_object_pointer_type (^^final_cls));
static_assert (!is_member_object_pointer_type (^^ctor_cls));
static_assert (!is_member_object_pointer_type (^^trivial_cls));
static_assert (!is_member_object_pointer_type (^^virtual_dtor_cls));
static_assert (!is_member_object_pointer_type (^^onion));
static_assert (!is_member_object_pointer_type (^^Enum));
static_assert (!is_member_object_pointer_type (^^Enum_class));
static_assert (!is_member_object_pointer_type (^^void ()));

static_assert (!is_member_function_pointer_type (^^void));
static_assert (!is_member_function_pointer_type (^^int));
static_assert (!is_member_function_pointer_type (^^const int));
static_assert (!is_member_function_pointer_type (^^volatile int));
static_assert (!is_member_function_pointer_type (^^unsigned));
static_assert (!is_member_function_pointer_type (^^float));
static_assert (!is_member_function_pointer_type (^^int&));
static_assert (!is_member_function_pointer_type (^^int&&));
static_assert (!is_member_function_pointer_type (^^int *));
static_assert (!is_member_function_pointer_type (^^int[1]));
static_assert (!is_member_function_pointer_type (^^int[]));
static_assert (!is_member_function_pointer_type (^^nullptr_t));
static_assert (!is_member_function_pointer_type (^^std::meta::info));
static_assert (!is_member_function_pointer_type (^^int (cls::*)));
static_assert (is_member_function_pointer_type (^^int (cls::*)()));
static_assert (!is_member_function_pointer_type (^^cls));
static_assert (!is_member_function_pointer_type (^^empty));
static_assert (!is_member_function_pointer_type (^^abstract_cls));
static_assert (!is_member_function_pointer_type (^^final_cls));
static_assert (!is_member_function_pointer_type (^^ctor_cls));
static_assert (!is_member_function_pointer_type (^^trivial_cls));
static_assert (!is_member_function_pointer_type (^^virtual_dtor_cls));
static_assert (!is_member_function_pointer_type (^^onion));
static_assert (!is_member_function_pointer_type (^^Enum));
static_assert (!is_member_function_pointer_type (^^Enum_class));
static_assert (!is_member_function_pointer_type (^^void ()));

static_assert (!is_enum_type (^^void));
static_assert (!is_enum_type (^^int));
static_assert (!is_enum_type (^^const int));
static_assert (!is_enum_type (^^volatile int));
static_assert (!is_enum_type (^^unsigned));
static_assert (!is_enum_type (^^float));
static_assert (!is_enum_type (^^int&));
static_assert (!is_enum_type (^^int&&));
static_assert (!is_enum_type (^^int *));
static_assert (!is_enum_type (^^int[1]));
static_assert (!is_enum_type (^^int[]));
static_assert (!is_enum_type (^^nullptr_t));
static_assert (!is_enum_type (^^std::meta::info));
static_assert (!is_enum_type (^^int (cls::*)));
static_assert (!is_enum_type (^^int (cls::*)()));
static_assert (!is_enum_type (^^cls));
static_assert (!is_enum_type (^^empty));
static_assert (!is_enum_type (^^abstract_cls));
static_assert (!is_enum_type (^^final_cls));
static_assert (!is_enum_type (^^ctor_cls));
static_assert (!is_enum_type (^^trivial_cls));
static_assert (!is_enum_type (^^virtual_dtor_cls));
static_assert (!is_enum_type (^^onion));
static_assert (is_enum_type (^^Enum));
static_assert (is_enum_type (^^Enum_class));
static_assert (!is_enum_type (^^void ()));

static_assert (!is_union_type (^^void));
static_assert (!is_union_type (^^int));
static_assert (!is_union_type (^^const int));
static_assert (!is_union_type (^^volatile int));
static_assert (!is_union_type (^^unsigned));
static_assert (!is_union_type (^^float));
static_assert (!is_union_type (^^int&));
static_assert (!is_union_type (^^int&&));
static_assert (!is_union_type (^^int *));
static_assert (!is_union_type (^^int[1]));
static_assert (!is_union_type (^^int[]));
static_assert (!is_union_type (^^nullptr_t));
static_assert (!is_union_type (^^std::meta::info));
static_assert (!is_union_type (^^int (cls::*)));
static_assert (!is_union_type (^^int (cls::*)()));
static_assert (!is_union_type (^^cls));
static_assert (!is_union_type (^^empty));
static_assert (!is_union_type (^^abstract_cls));
static_assert (!is_union_type (^^final_cls));
static_assert (!is_union_type (^^ctor_cls));
static_assert (!is_union_type (^^trivial_cls));
static_assert (!is_union_type (^^virtual_dtor_cls));
static_assert (is_union_type (^^onion));
static_assert (!is_union_type (^^Enum));
static_assert (!is_union_type (^^Enum_class));
static_assert (!is_union_type (^^void ()));

static_assert (!is_class_type (^^void));
static_assert (!is_class_type (^^int));
static_assert (!is_class_type (^^const int));
static_assert (!is_class_type (^^volatile int));
static_assert (!is_class_type (^^unsigned));
static_assert (!is_class_type (^^float));
static_assert (!is_class_type (^^int&));
static_assert (!is_class_type (^^int&&));
static_assert (!is_class_type (^^int *));
static_assert (!is_class_type (^^int[1]));
static_assert (!is_class_type (^^int[]));
static_assert (!is_class_type (^^nullptr_t));
static_assert (!is_class_type (^^std::meta::info));
static_assert (!is_class_type (^^int (cls::*)));
static_assert (!is_class_type (^^int (cls::*)()));
static_assert (is_class_type (^^cls));
static_assert (is_class_type (^^empty));
static_assert (is_class_type (^^abstract_cls));
static_assert (is_class_type (^^final_cls));
static_assert (is_class_type (^^ctor_cls));
static_assert (is_class_type (^^trivial_cls));
static_assert (is_class_type (^^virtual_dtor_cls));
static_assert (!is_class_type (^^onion));
static_assert (!is_class_type (^^Enum));
static_assert (!is_class_type (^^Enum_class));
static_assert (!is_class_type (^^void ()));

static_assert (!is_reflection_type (^^void));
static_assert (!is_reflection_type (^^int));
static_assert (!is_reflection_type (^^const int));
static_assert (!is_reflection_type (^^volatile int));
static_assert (!is_reflection_type (^^unsigned));
static_assert (!is_reflection_type (^^float));
static_assert (!is_reflection_type (^^int&));
static_assert (!is_reflection_type (^^int&&));
static_assert (!is_reflection_type (^^int *));
static_assert (!is_reflection_type (^^int[1]));
static_assert (!is_reflection_type (^^int[]));
static_assert (!is_reflection_type (^^nullptr_t));
static_assert (is_reflection_type (^^std::meta::info));
static_assert (!is_reflection_type (^^int (cls::*)));
static_assert (!is_reflection_type (^^int (cls::*)()));
static_assert (!is_reflection_type (^^cls));
static_assert (!is_reflection_type (^^empty));
static_assert (!is_reflection_type (^^abstract_cls));
static_assert (!is_reflection_type (^^final_cls));
static_assert (!is_reflection_type (^^ctor_cls));
static_assert (!is_reflection_type (^^trivial_cls));
static_assert (!is_reflection_type (^^virtual_dtor_cls));
static_assert (!is_reflection_type (^^onion));
static_assert (!is_reflection_type (^^Enum));
static_assert (!is_reflection_type (^^Enum_class));
static_assert (!is_reflection_type (^^void ()));

static_assert (!is_reference_type (^^void));
static_assert (!is_reference_type (^^int));
static_assert (!is_reference_type (^^const int));
static_assert (!is_reference_type (^^volatile int));
static_assert (!is_reference_type (^^unsigned));
static_assert (!is_reference_type (^^float));
static_assert (is_reference_type (^^int&));
static_assert (is_reference_type (^^int&&));
static_assert (!is_reference_type (^^int *));
static_assert (!is_reference_type (^^int[1]));
static_assert (!is_reference_type (^^int[]));
static_assert (!is_reference_type (^^nullptr_t));
static_assert (!is_reference_type (^^std::meta::info));
static_assert (!is_reference_type (^^int (cls::*)));
static_assert (!is_reference_type (^^int (cls::*)()));
static_assert (!is_reference_type (^^cls));
static_assert (!is_reference_type (^^empty));
static_assert (!is_reference_type (^^abstract_cls));
static_assert (!is_reference_type (^^final_cls));
static_assert (!is_reference_type (^^ctor_cls));
static_assert (!is_reference_type (^^trivial_cls));
static_assert (!is_reference_type (^^virtual_dtor_cls));
static_assert (!is_reference_type (^^onion));
static_assert (!is_reference_type (^^Enum));
static_assert (!is_reference_type (^^Enum_class));
static_assert (!is_reference_type (^^void ()));

static_assert (!is_arithmetic_type (^^void));
static_assert (is_arithmetic_type (^^bool));
static_assert (is_arithmetic_type (^^char));
static_assert (is_arithmetic_type (^^int));
static_assert (is_arithmetic_type (^^const int));
static_assert (is_arithmetic_type (^^volatile int));
static_assert (is_arithmetic_type (^^float));
static_assert (!is_arithmetic_type (^^cls));
static_assert (!is_arithmetic_type (^^int&));
static_assert (!is_arithmetic_type (^^int&&));
static_assert (!is_arithmetic_type (^^int *));
static_assert (!is_arithmetic_type (^^int [1]));
static_assert (!is_arithmetic_type (^^int []));
static_assert (!is_arithmetic_type (^^nullptr_t));
static_assert (!is_arithmetic_type (^^std::meta::info));
static_assert (!is_arithmetic_type (^^int (cls::*)));
static_assert (!is_arithmetic_type (^^int (cls::*)()));
static_assert (!is_arithmetic_type (^^cls));
static_assert (!is_arithmetic_type (^^empty));
static_assert (!is_arithmetic_type (^^abstract_cls));
static_assert (!is_arithmetic_type (^^final_cls));
static_assert (!is_arithmetic_type (^^ctor_cls));
static_assert (!is_arithmetic_type (^^trivial_cls));
static_assert (!is_arithmetic_type (^^virtual_dtor_cls));
static_assert (!is_arithmetic_type (^^onion));
static_assert (!is_arithmetic_type (^^Enum));
static_assert (!is_arithmetic_type (^^Enum_class));
static_assert (!is_arithmetic_type (^^void ()));

static_assert (!is_object_type (^^void));
static_assert (is_object_type (^^bool));
static_assert (is_object_type (^^char));
static_assert (is_object_type (^^int));
static_assert (is_object_type (^^const int));
static_assert (is_object_type (^^volatile int));
static_assert (is_object_type (^^float));
static_assert (is_object_type (^^cls));
static_assert (!is_object_type (^^int&));
static_assert (!is_object_type (^^int&&));
static_assert (is_object_type (^^int *));
static_assert (is_object_type (^^int [1]));
static_assert (is_object_type (^^int []));
static_assert (is_object_type (^^nullptr_t));
static_assert (is_object_type (^^std::meta::info));
static_assert (is_object_type (^^int (cls::*)));
static_assert (is_object_type (^^int (cls::*)()));
static_assert (is_object_type (^^cls));
static_assert (is_object_type (^^empty));
static_assert (is_object_type (^^abstract_cls));
static_assert (is_object_type (^^final_cls));
static_assert (is_object_type (^^ctor_cls));
static_assert (is_object_type (^^trivial_cls));
static_assert (is_object_type (^^virtual_dtor_cls));
static_assert (is_object_type (^^onion));
static_assert (is_object_type (^^Enum));
static_assert (is_object_type (^^Enum_class));
static_assert (!is_object_type (^^void ()));

static_assert (!is_member_pointer_type (^^void));
static_assert (!is_member_pointer_type (^^bool));
static_assert (!is_member_pointer_type (^^char));
static_assert (!is_member_pointer_type (^^int));
static_assert (!is_member_pointer_type (^^const int));
static_assert (!is_member_pointer_type (^^volatile int));
static_assert (!is_member_pointer_type (^^float));
static_assert (!is_member_pointer_type (^^cls));
static_assert (!is_member_pointer_type (^^int&));
static_assert (!is_member_pointer_type (^^int&&));
static_assert (!is_member_pointer_type (^^int *));
static_assert (!is_member_pointer_type (^^int [1]));
static_assert (!is_member_pointer_type (^^int []));
static_assert (!is_member_pointer_type (^^nullptr_t));
static_assert (!is_member_pointer_type (^^std::meta::info));
static_assert (is_member_pointer_type (^^int (cls::*)));
static_assert (is_member_pointer_type (^^int (cls::*)()));
static_assert (!is_member_pointer_type (^^cls));
static_assert (!is_member_pointer_type (^^empty));
static_assert (!is_member_pointer_type (^^abstract_cls));
static_assert (!is_member_pointer_type (^^final_cls));
static_assert (!is_member_pointer_type (^^ctor_cls));
static_assert (!is_member_pointer_type (^^trivial_cls));
static_assert (!is_member_pointer_type (^^virtual_dtor_cls));
static_assert (!is_member_pointer_type (^^onion));
static_assert (!is_member_pointer_type (^^Enum));
static_assert (!is_member_pointer_type (^^Enum_class));
static_assert (!is_member_pointer_type (^^void ()));

static_assert (!is_scalar_type (^^void));
static_assert (is_scalar_type (^^bool));
static_assert (is_scalar_type (^^char));
static_assert (is_scalar_type (^^int));
static_assert (is_scalar_type (^^const int));
static_assert (is_scalar_type (^^volatile int));
static_assert (is_scalar_type (^^float));
static_assert (!is_scalar_type (^^cls));
static_assert (!is_scalar_type (^^int&));
static_assert (!is_scalar_type (^^int&&));
static_assert (is_scalar_type (^^int *));
static_assert (!is_scalar_type (^^int [1]));
static_assert (!is_scalar_type (^^int []));
static_assert (is_scalar_type (^^nullptr_t));
static_assert (is_scalar_type (^^std::meta::info));
static_assert (is_scalar_type (^^int (cls::*)));
static_assert (is_scalar_type (^^int (cls::*)()));
static_assert (!is_scalar_type (^^cls));
static_assert (!is_scalar_type (^^empty));
static_assert (!is_scalar_type (^^abstract_cls));
static_assert (!is_scalar_type (^^final_cls));
static_assert (!is_scalar_type (^^ctor_cls));
static_assert (!is_scalar_type (^^trivial_cls));
static_assert (!is_scalar_type (^^virtual_dtor_cls));
static_assert (!is_scalar_type (^^onion));
static_assert (is_scalar_type (^^Enum));
static_assert (is_scalar_type (^^Enum_class));
static_assert (!is_scalar_type (^^void ()));

static_assert (is_fundamental_type (^^void));
static_assert (is_fundamental_type (^^bool));
static_assert (is_fundamental_type (^^char));
static_assert (is_fundamental_type (^^int));
static_assert (is_fundamental_type (^^const int));
static_assert (is_fundamental_type (^^volatile int));
static_assert (is_fundamental_type (^^float));
static_assert (!is_fundamental_type (^^cls));
static_assert (!is_fundamental_type (^^int&));
static_assert (!is_fundamental_type (^^int&&));
static_assert (!is_fundamental_type (^^int *));
static_assert (!is_fundamental_type (^^int [1]));
static_assert (!is_fundamental_type (^^int []));
static_assert (is_fundamental_type (^^nullptr_t));
static_assert (is_fundamental_type (^^std::meta::info));
static_assert (!is_fundamental_type (^^int (cls::*)));
static_assert (!is_fundamental_type (^^int (cls::*)()));
static_assert (!is_fundamental_type (^^cls));
static_assert (!is_fundamental_type (^^empty));
static_assert (!is_fundamental_type (^^abstract_cls));
static_assert (!is_fundamental_type (^^final_cls));
static_assert (!is_fundamental_type (^^ctor_cls));
static_assert (!is_fundamental_type (^^trivial_cls));
static_assert (!is_fundamental_type (^^virtual_dtor_cls));
static_assert (!is_fundamental_type (^^onion));
static_assert (!is_fundamental_type (^^Enum));
static_assert (!is_fundamental_type (^^Enum_class));
static_assert (!is_fundamental_type (^^void ()));

static_assert (!is_compound_type (^^void));
static_assert (!is_compound_type (^^bool));
static_assert (!is_compound_type (^^char));
static_assert (!is_compound_type (^^int));
static_assert (!is_compound_type (^^const int));
static_assert (!is_compound_type (^^volatile int));
static_assert (!is_compound_type (^^float));
static_assert (is_compound_type (^^cls));
static_assert (is_compound_type (^^int&));
static_assert (is_compound_type (^^int&&));
static_assert (is_compound_type (^^int *));
static_assert (is_compound_type (^^int [1]));
static_assert (is_compound_type (^^int []));
static_assert (!is_compound_type (^^nullptr_t));
static_assert (!is_compound_type (^^std::meta::info));
static_assert (is_compound_type (^^int (cls::*)));
static_assert (is_compound_type (^^int (cls::*)()));
static_assert (is_compound_type (^^cls));
static_assert (is_compound_type (^^empty));
static_assert (is_compound_type (^^abstract_cls));
static_assert (is_compound_type (^^final_cls));
static_assert (is_compound_type (^^ctor_cls));
static_assert (is_compound_type (^^trivial_cls));
static_assert (is_compound_type (^^virtual_dtor_cls));
static_assert (is_compound_type (^^onion));
static_assert (is_compound_type (^^Enum));
static_assert (is_compound_type (^^Enum_class));
static_assert (is_compound_type (^^void ()));
