//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
#[cfg(feature = "objc2-core-foundation")]
use objc2_core_foundation::*;
use objc2_foundation::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nscelltype?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSCellType(pub NSUInteger);
impl NSCellType {
    #[doc(alias = "NSNullCellType")]
    pub const NullCellType: Self = Self(0);
    #[doc(alias = "NSTextCellType")]
    pub const TextCellType: Self = Self(1);
    #[doc(alias = "NSImageCellType")]
    pub const ImageCellType: Self = Self(2);
}

unsafe impl Encode for NSCellType {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSCellType {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nscellattribute?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSCellAttribute(pub NSUInteger);
impl NSCellAttribute {
    #[doc(alias = "NSCellDisabled")]
    pub const CellDisabled: Self = Self(0);
    #[doc(alias = "NSCellState")]
    pub const CellState: Self = Self(1);
    #[doc(alias = "NSPushInCell")]
    pub const PushInCell: Self = Self(2);
    #[doc(alias = "NSCellEditable")]
    pub const CellEditable: Self = Self(3);
    #[doc(alias = "NSChangeGrayCell")]
    pub const ChangeGrayCell: Self = Self(4);
    #[doc(alias = "NSCellHighlighted")]
    pub const CellHighlighted: Self = Self(5);
    #[doc(alias = "NSCellLightsByContents")]
    pub const CellLightsByContents: Self = Self(6);
    #[doc(alias = "NSCellLightsByGray")]
    pub const CellLightsByGray: Self = Self(7);
    #[doc(alias = "NSChangeBackgroundCell")]
    pub const ChangeBackgroundCell: Self = Self(8);
    #[doc(alias = "NSCellLightsByBackground")]
    pub const CellLightsByBackground: Self = Self(9);
    #[doc(alias = "NSCellIsBordered")]
    pub const CellIsBordered: Self = Self(10);
    #[doc(alias = "NSCellHasOverlappingImage")]
    pub const CellHasOverlappingImage: Self = Self(11);
    #[doc(alias = "NSCellHasImageHorizontal")]
    pub const CellHasImageHorizontal: Self = Self(12);
    #[doc(alias = "NSCellHasImageOnLeftOrBottom")]
    pub const CellHasImageOnLeftOrBottom: Self = Self(13);
    #[doc(alias = "NSCellChangesContents")]
    pub const CellChangesContents: Self = Self(14);
    #[doc(alias = "NSCellIsInsetButton")]
    pub const CellIsInsetButton: Self = Self(15);
    #[doc(alias = "NSCellAllowsMixedState")]
    pub const CellAllowsMixedState: Self = Self(16);
}

unsafe impl Encode for NSCellAttribute {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSCellAttribute {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nscellimageposition?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSCellImagePosition(pub NSUInteger);
impl NSCellImagePosition {
    #[doc(alias = "NSNoImage")]
    pub const NoImage: Self = Self(0);
    #[doc(alias = "NSImageOnly")]
    pub const ImageOnly: Self = Self(1);
    #[doc(alias = "NSImageLeft")]
    pub const ImageLeft: Self = Self(2);
    #[doc(alias = "NSImageRight")]
    pub const ImageRight: Self = Self(3);
    #[doc(alias = "NSImageBelow")]
    pub const ImageBelow: Self = Self(4);
    #[doc(alias = "NSImageAbove")]
    pub const ImageAbove: Self = Self(5);
    #[doc(alias = "NSImageOverlaps")]
    pub const ImageOverlaps: Self = Self(6);
    #[doc(alias = "NSImageLeading")]
    pub const ImageLeading: Self = Self(7);
    #[doc(alias = "NSImageTrailing")]
    pub const ImageTrailing: Self = Self(8);
}

unsafe impl Encode for NSCellImagePosition {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSCellImagePosition {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagescaling?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSImageScaling(pub NSUInteger);
impl NSImageScaling {
    #[doc(alias = "NSImageScaleProportionallyDown")]
    pub const ScaleProportionallyDown: Self = Self(0);
    #[doc(alias = "NSImageScaleAxesIndependently")]
    pub const ScaleAxesIndependently: Self = Self(1);
    #[doc(alias = "NSImageScaleNone")]
    pub const ScaleNone: Self = Self(2);
    #[doc(alias = "NSImageScaleProportionallyUpOrDown")]
    pub const ScaleProportionallyUpOrDown: Self = Self(3);
    #[deprecated = "Use NSImageScaleProportionallyDown instead"]
    pub const NSScaleProportionally: Self = Self(0);
    #[deprecated = "Use NSImageScaleAxesIndependently instead"]
    pub const NSScaleToFit: Self = Self(1);
    #[deprecated = "Use NSImageScaleNone instead"]
    pub const NSScaleNone: Self = Self(2);
}

unsafe impl Encode for NSImageScaling {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSImageScaling {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nscontrolstatevalue?language=objc)
// NS_TYPED_EXTENSIBLE_ENUM
pub type NSControlStateValue = NSInteger;

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nscontrolstatevaluemixed?language=objc)
pub static NSControlStateValueMixed: NSControlStateValue = -1;

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nscontrolstatevalueoff?language=objc)
pub static NSControlStateValueOff: NSControlStateValue = 0;

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nscontrolstatevalueon?language=objc)
pub static NSControlStateValueOn: NSControlStateValue = 1;

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nscellstylemask?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSCellStyleMask(pub NSUInteger);
bitflags::bitflags! {
    impl NSCellStyleMask: NSUInteger {
        #[doc(alias = "NSNoCellMask")]
        const NoCellMask = 0;
        #[doc(alias = "NSContentsCellMask")]
        const ContentsCellMask = 1;
        #[doc(alias = "NSPushInCellMask")]
        const PushInCellMask = 2;
        #[doc(alias = "NSChangeGrayCellMask")]
        const ChangeGrayCellMask = 4;
        #[doc(alias = "NSChangeBackgroundCellMask")]
        const ChangeBackgroundCellMask = 8;
    }
}

unsafe impl Encode for NSCellStyleMask {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSCellStyleMask {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nscontroltint?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSControlTint(pub NSUInteger);
impl NSControlTint {
    #[doc(alias = "NSDefaultControlTint")]
    pub const DefaultControlTint: Self = Self(0);
    #[doc(alias = "NSBlueControlTint")]
    pub const BlueControlTint: Self = Self(1);
    #[doc(alias = "NSGraphiteControlTint")]
    pub const GraphiteControlTint: Self = Self(6);
    #[doc(alias = "NSClearControlTint")]
    pub const ClearControlTint: Self = Self(7);
}

unsafe impl Encode for NSControlTint {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSControlTint {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nscontrolsize?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSControlSize(pub NSUInteger);
impl NSControlSize {
    #[doc(alias = "NSControlSizeRegular")]
    pub const Regular: Self = Self(0);
    #[doc(alias = "NSControlSizeSmall")]
    pub const Small: Self = Self(1);
    #[doc(alias = "NSControlSizeMini")]
    pub const Mini: Self = Self(2);
    #[doc(alias = "NSControlSizeLarge")]
    pub const Large: Self = Self(3);
}

unsafe impl Encode for NSControlSize {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSControlSize {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nscell?language=objc)
    #[unsafe(super(NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSCell;
);

#[cfg(feature = "NSAccessibilityProtocols")]
extern_conformance!(
    unsafe impl NSAccessibility for NSCell {}
);

#[cfg(feature = "NSAccessibilityProtocols")]
extern_conformance!(
    unsafe impl NSAccessibilityElementProtocol for NSCell {}
);

extern_conformance!(
    unsafe impl NSCoding for NSCell {}
);

extern_conformance!(
    unsafe impl NSCopying for NSCell {}
);

unsafe impl CopyingHelper for NSCell {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for NSCell {}
);

#[cfg(feature = "NSUserInterfaceItemIdentification")]
extern_conformance!(
    unsafe impl NSUserInterfaceItemIdentification for NSCell {}
);

impl NSCell {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(initTextCell:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initTextCell(this: Allocated<Self>, string: &NSString) -> Retained<Self>;

        #[cfg(feature = "NSImage")]
        #[unsafe(method(initImageCell:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initImageCell(
            this: Allocated<Self>,
            image: Option<&NSImage>,
        ) -> Retained<Self>;

        #[unsafe(method(initWithCoder:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCoder(this: Allocated<Self>, coder: &NSCoder) -> Retained<Self>;

        #[unsafe(method(prefersTrackingUntilMouseUp))]
        #[unsafe(method_family = none)]
        pub unsafe fn prefersTrackingUntilMouseUp(mtm: MainThreadMarker) -> bool;

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[unsafe(method(controlView))]
        #[unsafe(method_family = none)]
        pub unsafe fn controlView(&self) -> Option<Retained<NSView>>;

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        /// Setter for [`controlView`][Self::controlView].
        #[unsafe(method(setControlView:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setControlView(&self, control_view: Option<&NSView>);

        #[unsafe(method(type))]
        #[unsafe(method_family = none)]
        pub unsafe fn r#type(&self) -> NSCellType;

        /// Setter for [`type`][Self::type].
        #[unsafe(method(setType:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setType(&self, r#type: NSCellType);

        #[unsafe(method(state))]
        #[unsafe(method_family = none)]
        pub unsafe fn state(&self) -> NSControlStateValue;

        /// Setter for [`state`][Self::state].
        #[unsafe(method(setState:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setState(&self, state: NSControlStateValue);

        #[unsafe(method(target))]
        #[unsafe(method_family = none)]
        pub unsafe fn target(&self) -> Option<Retained<AnyObject>>;

        /// This is a [weak property][objc2::topics::weak_property].
        /// Setter for [`target`][Self::target].
        #[unsafe(method(setTarget:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setTarget(&self, target: Option<&AnyObject>);

        #[unsafe(method(action))]
        #[unsafe(method_family = none)]
        pub unsafe fn action(&self) -> Option<Sel>;

        /// Setter for [`action`][Self::action].
        #[unsafe(method(setAction:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAction(&self, action: Option<Sel>);

        #[unsafe(method(tag))]
        #[unsafe(method_family = none)]
        pub unsafe fn tag(&self) -> NSInteger;

        /// Setter for [`tag`][Self::tag].
        #[unsafe(method(setTag:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setTag(&self, tag: NSInteger);

        #[unsafe(method(title))]
        #[unsafe(method_family = none)]
        pub unsafe fn title(&self) -> Retained<NSString>;

        /// Setter for [`title`][Self::title].
        #[unsafe(method(setTitle:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setTitle(&self, title: &NSString);

        #[unsafe(method(isOpaque))]
        #[unsafe(method_family = none)]
        pub unsafe fn isOpaque(&self) -> bool;

        #[unsafe(method(isEnabled))]
        #[unsafe(method_family = none)]
        pub unsafe fn isEnabled(&self) -> bool;

        /// Setter for [`isEnabled`][Self::isEnabled].
        #[unsafe(method(setEnabled:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setEnabled(&self, enabled: bool);

        #[cfg(feature = "NSEvent")]
        #[unsafe(method(sendActionOn:))]
        #[unsafe(method_family = none)]
        pub unsafe fn sendActionOn(&self, mask: NSEventMask) -> NSInteger;

        #[unsafe(method(isContinuous))]
        #[unsafe(method_family = none)]
        pub unsafe fn isContinuous(&self) -> bool;

        /// Setter for [`isContinuous`][Self::isContinuous].
        #[unsafe(method(setContinuous:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setContinuous(&self, continuous: bool);

        #[unsafe(method(isEditable))]
        #[unsafe(method_family = none)]
        pub unsafe fn isEditable(&self) -> bool;

        /// Setter for [`isEditable`][Self::isEditable].
        #[unsafe(method(setEditable:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setEditable(&self, editable: bool);

        #[unsafe(method(isSelectable))]
        #[unsafe(method_family = none)]
        pub unsafe fn isSelectable(&self) -> bool;

        /// Setter for [`isSelectable`][Self::isSelectable].
        #[unsafe(method(setSelectable:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setSelectable(&self, selectable: bool);

        #[unsafe(method(isBordered))]
        #[unsafe(method_family = none)]
        pub unsafe fn isBordered(&self) -> bool;

        /// Setter for [`isBordered`][Self::isBordered].
        #[unsafe(method(setBordered:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setBordered(&self, bordered: bool);

        #[unsafe(method(isBezeled))]
        #[unsafe(method_family = none)]
        pub unsafe fn isBezeled(&self) -> bool;

        /// Setter for [`isBezeled`][Self::isBezeled].
        #[unsafe(method(setBezeled:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setBezeled(&self, bezeled: bool);

        #[unsafe(method(isScrollable))]
        #[unsafe(method_family = none)]
        pub unsafe fn isScrollable(&self) -> bool;

        /// Setter for [`isScrollable`][Self::isScrollable].
        #[unsafe(method(setScrollable:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setScrollable(&self, scrollable: bool);

        #[unsafe(method(isHighlighted))]
        #[unsafe(method_family = none)]
        pub unsafe fn isHighlighted(&self) -> bool;

        /// Setter for [`isHighlighted`][Self::isHighlighted].
        #[unsafe(method(setHighlighted:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setHighlighted(&self, highlighted: bool);

        #[cfg(feature = "NSText")]
        #[unsafe(method(alignment))]
        #[unsafe(method_family = none)]
        pub unsafe fn alignment(&self) -> NSTextAlignment;

        #[cfg(feature = "NSText")]
        /// Setter for [`alignment`][Self::alignment].
        #[unsafe(method(setAlignment:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAlignment(&self, alignment: NSTextAlignment);

        #[unsafe(method(wraps))]
        #[unsafe(method_family = none)]
        pub unsafe fn wraps(&self) -> bool;

        /// Setter for [`wraps`][Self::wraps].
        #[unsafe(method(setWraps:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setWraps(&self, wraps: bool);

        #[cfg(feature = "NSFont")]
        #[unsafe(method(font))]
        #[unsafe(method_family = none)]
        pub unsafe fn font(&self) -> Option<Retained<NSFont>>;

        #[cfg(feature = "NSFont")]
        /// Setter for [`font`][Self::font].
        #[unsafe(method(setFont:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setFont(&self, font: Option<&NSFont>);

        #[unsafe(method(keyEquivalent))]
        #[unsafe(method_family = none)]
        pub unsafe fn keyEquivalent(&self) -> Retained<NSString>;

        #[unsafe(method(formatter))]
        #[unsafe(method_family = none)]
        pub unsafe fn formatter(&self) -> Option<Retained<NSFormatter>>;

        /// Setter for [`formatter`][Self::formatter].
        #[unsafe(method(setFormatter:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setFormatter(&self, formatter: Option<&NSFormatter>);

        #[unsafe(method(objectValue))]
        #[unsafe(method_family = none)]
        pub unsafe fn objectValue(&self) -> Option<Retained<AnyObject>>;

        /// Setter for [`objectValue`][Self::objectValue].
        #[unsafe(method(setObjectValue:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setObjectValue(&self, object_value: Option<&AnyObject>);

        #[unsafe(method(hasValidObjectValue))]
        #[unsafe(method_family = none)]
        pub unsafe fn hasValidObjectValue(&self) -> bool;

        #[unsafe(method(stringValue))]
        #[unsafe(method_family = none)]
        pub unsafe fn stringValue(&self) -> Retained<NSString>;

        /// Setter for [`stringValue`][Self::stringValue].
        #[unsafe(method(setStringValue:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setStringValue(&self, string_value: &NSString);

        #[unsafe(method(compare:))]
        #[unsafe(method_family = none)]
        pub unsafe fn compare(&self, other_cell: &AnyObject) -> NSComparisonResult;

        #[unsafe(method(intValue))]
        #[unsafe(method_family = none)]
        pub unsafe fn intValue(&self) -> c_int;

        /// Setter for [`intValue`][Self::intValue].
        #[unsafe(method(setIntValue:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setIntValue(&self, int_value: c_int);

        #[unsafe(method(floatValue))]
        #[unsafe(method_family = none)]
        pub unsafe fn floatValue(&self) -> c_float;

        /// Setter for [`floatValue`][Self::floatValue].
        #[unsafe(method(setFloatValue:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setFloatValue(&self, float_value: c_float);

        #[unsafe(method(doubleValue))]
        #[unsafe(method_family = none)]
        pub unsafe fn doubleValue(&self) -> c_double;

        /// Setter for [`doubleValue`][Self::doubleValue].
        #[unsafe(method(setDoubleValue:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setDoubleValue(&self, double_value: c_double);

        #[unsafe(method(integerValue))]
        #[unsafe(method_family = none)]
        pub unsafe fn integerValue(&self) -> NSInteger;

        /// Setter for [`integerValue`][Self::integerValue].
        #[unsafe(method(setIntegerValue:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setIntegerValue(&self, integer_value: NSInteger);

        #[unsafe(method(takeIntValueFrom:))]
        #[unsafe(method_family = none)]
        pub unsafe fn takeIntValueFrom(&self, sender: Option<&AnyObject>);

        #[unsafe(method(takeFloatValueFrom:))]
        #[unsafe(method_family = none)]
        pub unsafe fn takeFloatValueFrom(&self, sender: Option<&AnyObject>);

        #[unsafe(method(takeDoubleValueFrom:))]
        #[unsafe(method_family = none)]
        pub unsafe fn takeDoubleValueFrom(&self, sender: Option<&AnyObject>);

        #[unsafe(method(takeStringValueFrom:))]
        #[unsafe(method_family = none)]
        pub unsafe fn takeStringValueFrom(&self, sender: Option<&AnyObject>);

        #[unsafe(method(takeObjectValueFrom:))]
        #[unsafe(method_family = none)]
        pub unsafe fn takeObjectValueFrom(&self, sender: Option<&AnyObject>);

        #[unsafe(method(takeIntegerValueFrom:))]
        #[unsafe(method_family = none)]
        pub unsafe fn takeIntegerValueFrom(&self, sender: Option<&AnyObject>);

        #[cfg(feature = "NSImage")]
        #[unsafe(method(image))]
        #[unsafe(method_family = none)]
        pub unsafe fn image(&self) -> Option<Retained<NSImage>>;

        #[cfg(feature = "NSImage")]
        /// Setter for [`image`][Self::image].
        #[unsafe(method(setImage:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setImage(&self, image: Option<&NSImage>);

        #[unsafe(method(controlSize))]
        #[unsafe(method_family = none)]
        pub unsafe fn controlSize(&self) -> NSControlSize;

        /// Setter for [`controlSize`][Self::controlSize].
        #[unsafe(method(setControlSize:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setControlSize(&self, control_size: NSControlSize);

        #[unsafe(method(representedObject))]
        #[unsafe(method_family = none)]
        pub unsafe fn representedObject(&self) -> Option<Retained<AnyObject>>;

        /// Setter for [`representedObject`][Self::representedObject].
        #[unsafe(method(setRepresentedObject:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setRepresentedObject(&self, represented_object: Option<&AnyObject>);

        #[unsafe(method(cellAttribute:))]
        #[unsafe(method_family = none)]
        pub unsafe fn cellAttribute(&self, parameter: NSCellAttribute) -> NSInteger;

        #[unsafe(method(setCellAttribute:to:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setCellAttribute_to(&self, parameter: NSCellAttribute, value: NSInteger);

        #[unsafe(method(imageRectForBounds:))]
        #[unsafe(method_family = none)]
        pub unsafe fn imageRectForBounds(&self, rect: NSRect) -> NSRect;

        #[unsafe(method(titleRectForBounds:))]
        #[unsafe(method_family = none)]
        pub unsafe fn titleRectForBounds(&self, rect: NSRect) -> NSRect;

        #[unsafe(method(drawingRectForBounds:))]
        #[unsafe(method_family = none)]
        pub unsafe fn drawingRectForBounds(&self, rect: NSRect) -> NSRect;

        #[unsafe(method(cellSize))]
        #[unsafe(method_family = none)]
        pub unsafe fn cellSize(&self) -> NSSize;

        #[unsafe(method(cellSizeForBounds:))]
        #[unsafe(method_family = none)]
        pub unsafe fn cellSizeForBounds(&self, rect: NSRect) -> NSSize;

        #[cfg(all(feature = "NSColor", feature = "NSResponder", feature = "NSView"))]
        #[unsafe(method(highlightColorWithFrame:inView:))]
        #[unsafe(method_family = none)]
        pub unsafe fn highlightColorWithFrame_inView(
            &self,
            cell_frame: NSRect,
            control_view: &NSView,
        ) -> Option<Retained<NSColor>>;

        #[unsafe(method(calcDrawInfo:))]
        #[unsafe(method_family = none)]
        pub unsafe fn calcDrawInfo(&self, rect: NSRect);

        #[cfg(all(feature = "NSResponder", feature = "NSText", feature = "NSView"))]
        #[unsafe(method(setUpFieldEditorAttributes:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setUpFieldEditorAttributes(&self, text_obj: &NSText) -> Retained<NSText>;

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[unsafe(method(drawInteriorWithFrame:inView:))]
        #[unsafe(method_family = none)]
        pub unsafe fn drawInteriorWithFrame_inView(
            &self,
            cell_frame: NSRect,
            control_view: &NSView,
        );

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[unsafe(method(drawWithFrame:inView:))]
        #[unsafe(method_family = none)]
        pub unsafe fn drawWithFrame_inView(&self, cell_frame: NSRect, control_view: &NSView);

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[unsafe(method(highlight:withFrame:inView:))]
        #[unsafe(method_family = none)]
        pub unsafe fn highlight_withFrame_inView(
            &self,
            flag: bool,
            cell_frame: NSRect,
            control_view: &NSView,
        );

        #[unsafe(method(mouseDownFlags))]
        #[unsafe(method_family = none)]
        pub unsafe fn mouseDownFlags(&self) -> NSInteger;

        #[unsafe(method(getPeriodicDelay:interval:))]
        #[unsafe(method_family = none)]
        pub unsafe fn getPeriodicDelay_interval(
            &self,
            delay: NonNull<c_float>,
            interval: NonNull<c_float>,
        );

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[unsafe(method(startTrackingAt:inView:))]
        #[unsafe(method_family = none)]
        pub unsafe fn startTrackingAt_inView(
            &self,
            start_point: NSPoint,
            control_view: &NSView,
        ) -> bool;

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[unsafe(method(continueTracking:at:inView:))]
        #[unsafe(method_family = none)]
        pub unsafe fn continueTracking_at_inView(
            &self,
            last_point: NSPoint,
            current_point: NSPoint,
            control_view: &NSView,
        ) -> bool;

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[unsafe(method(stopTracking:at:inView:mouseIsUp:))]
        #[unsafe(method_family = none)]
        pub unsafe fn stopTracking_at_inView_mouseIsUp(
            &self,
            last_point: NSPoint,
            stop_point: NSPoint,
            control_view: &NSView,
            flag: bool,
        );

        #[cfg(all(feature = "NSEvent", feature = "NSResponder", feature = "NSView"))]
        #[unsafe(method(trackMouse:inRect:ofView:untilMouseUp:))]
        #[unsafe(method_family = none)]
        pub unsafe fn trackMouse_inRect_ofView_untilMouseUp(
            &self,
            event: &NSEvent,
            cell_frame: NSRect,
            control_view: &NSView,
            flag: bool,
        ) -> bool;

        #[cfg(all(
            feature = "NSEvent",
            feature = "NSResponder",
            feature = "NSText",
            feature = "NSView"
        ))]
        #[unsafe(method(editWithFrame:inView:editor:delegate:event:))]
        #[unsafe(method_family = none)]
        pub unsafe fn editWithFrame_inView_editor_delegate_event(
            &self,
            rect: NSRect,
            control_view: &NSView,
            text_obj: &NSText,
            delegate: Option<&AnyObject>,
            event: Option<&NSEvent>,
        );

        #[cfg(all(feature = "NSResponder", feature = "NSText", feature = "NSView"))]
        #[unsafe(method(selectWithFrame:inView:editor:delegate:start:length:))]
        #[unsafe(method_family = none)]
        pub unsafe fn selectWithFrame_inView_editor_delegate_start_length(
            &self,
            rect: NSRect,
            control_view: &NSView,
            text_obj: &NSText,
            delegate: Option<&AnyObject>,
            sel_start: NSInteger,
            sel_length: NSInteger,
        );

        #[cfg(all(feature = "NSResponder", feature = "NSText", feature = "NSView"))]
        #[unsafe(method(endEditing:))]
        #[unsafe(method_family = none)]
        pub unsafe fn endEditing(&self, text_obj: &NSText);

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[unsafe(method(resetCursorRect:inView:))]
        #[unsafe(method_family = none)]
        pub unsafe fn resetCursorRect_inView(&self, cell_frame: NSRect, control_view: &NSView);

        #[cfg(feature = "NSMenu")]
        #[unsafe(method(menu))]
        #[unsafe(method_family = none)]
        pub unsafe fn menu(&self) -> Option<Retained<NSMenu>>;

        #[cfg(feature = "NSMenu")]
        /// Setter for [`menu`][Self::menu].
        #[unsafe(method(setMenu:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setMenu(&self, menu: Option<&NSMenu>);

        #[cfg(all(
            feature = "NSEvent",
            feature = "NSMenu",
            feature = "NSResponder",
            feature = "NSView"
        ))]
        #[unsafe(method(menuForEvent:inRect:ofView:))]
        #[unsafe(method_family = none)]
        pub unsafe fn menuForEvent_inRect_ofView(
            &self,
            event: &NSEvent,
            cell_frame: NSRect,
            view: &NSView,
        ) -> Option<Retained<NSMenu>>;

        #[cfg(feature = "NSMenu")]
        #[unsafe(method(defaultMenu))]
        #[unsafe(method_family = none)]
        pub unsafe fn defaultMenu(mtm: MainThreadMarker) -> Option<Retained<NSMenu>>;

        #[unsafe(method(sendsActionOnEndEditing))]
        #[unsafe(method_family = none)]
        pub unsafe fn sendsActionOnEndEditing(&self) -> bool;

        /// Setter for [`sendsActionOnEndEditing`][Self::sendsActionOnEndEditing].
        #[unsafe(method(setSendsActionOnEndEditing:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setSendsActionOnEndEditing(&self, sends_action_on_end_editing: bool);

        #[cfg(feature = "NSText")]
        #[unsafe(method(baseWritingDirection))]
        #[unsafe(method_family = none)]
        pub unsafe fn baseWritingDirection(&self) -> NSWritingDirection;

        #[cfg(feature = "NSText")]
        /// Setter for [`baseWritingDirection`][Self::baseWritingDirection].
        #[unsafe(method(setBaseWritingDirection:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setBaseWritingDirection(&self, base_writing_direction: NSWritingDirection);

        #[cfg(feature = "NSParagraphStyle")]
        #[unsafe(method(lineBreakMode))]
        #[unsafe(method_family = none)]
        pub unsafe fn lineBreakMode(&self) -> NSLineBreakMode;

        #[cfg(feature = "NSParagraphStyle")]
        /// Setter for [`lineBreakMode`][Self::lineBreakMode].
        #[unsafe(method(setLineBreakMode:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setLineBreakMode(&self, line_break_mode: NSLineBreakMode);

        #[unsafe(method(allowsUndo))]
        #[unsafe(method_family = none)]
        pub unsafe fn allowsUndo(&self) -> bool;

        /// Setter for [`allowsUndo`][Self::allowsUndo].
        #[unsafe(method(setAllowsUndo:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAllowsUndo(&self, allows_undo: bool);

        #[unsafe(method(truncatesLastVisibleLine))]
        #[unsafe(method_family = none)]
        pub unsafe fn truncatesLastVisibleLine(&self) -> bool;

        /// Setter for [`truncatesLastVisibleLine`][Self::truncatesLastVisibleLine].
        #[unsafe(method(setTruncatesLastVisibleLine:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setTruncatesLastVisibleLine(&self, truncates_last_visible_line: bool);

        #[cfg(feature = "NSUserInterfaceLayout")]
        #[unsafe(method(userInterfaceLayoutDirection))]
        #[unsafe(method_family = none)]
        pub unsafe fn userInterfaceLayoutDirection(&self) -> NSUserInterfaceLayoutDirection;

        #[cfg(feature = "NSUserInterfaceLayout")]
        /// Setter for [`userInterfaceLayoutDirection`][Self::userInterfaceLayoutDirection].
        #[unsafe(method(setUserInterfaceLayoutDirection:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setUserInterfaceLayoutDirection(
            &self,
            user_interface_layout_direction: NSUserInterfaceLayoutDirection,
        );

        #[cfg(all(
            feature = "NSResponder",
            feature = "NSText",
            feature = "NSTextView",
            feature = "NSView"
        ))]
        #[unsafe(method(fieldEditorForView:))]
        #[unsafe(method_family = none)]
        pub unsafe fn fieldEditorForView(
            &self,
            control_view: &NSView,
        ) -> Option<Retained<NSTextView>>;

        #[unsafe(method(usesSingleLineMode))]
        #[unsafe(method_family = none)]
        pub unsafe fn usesSingleLineMode(&self) -> bool;

        /// Setter for [`usesSingleLineMode`][Self::usesSingleLineMode].
        #[unsafe(method(setUsesSingleLineMode:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setUsesSingleLineMode(&self, uses_single_line_mode: bool);

        #[cfg(all(
            feature = "NSDraggingItem",
            feature = "NSResponder",
            feature = "NSView"
        ))]
        #[unsafe(method(draggingImageComponentsWithFrame:inView:))]
        #[unsafe(method_family = none)]
        pub unsafe fn draggingImageComponentsWithFrame_inView(
            &self,
            frame: NSRect,
            view: &NSView,
        ) -> Retained<NSArray<NSDraggingImageComponent>>;
    );
}

/// Methods declared on superclass `NSObject`.
impl NSCell {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}

/// NSKeyboardUI.
impl NSCell {
    extern_methods!(
        #[unsafe(method(refusesFirstResponder))]
        #[unsafe(method_family = none)]
        pub unsafe fn refusesFirstResponder(&self) -> bool;

        /// Setter for [`refusesFirstResponder`][Self::refusesFirstResponder].
        #[unsafe(method(setRefusesFirstResponder:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setRefusesFirstResponder(&self, refuses_first_responder: bool);

        #[unsafe(method(acceptsFirstResponder))]
        #[unsafe(method_family = none)]
        pub unsafe fn acceptsFirstResponder(&self) -> bool;

        #[unsafe(method(showsFirstResponder))]
        #[unsafe(method_family = none)]
        pub unsafe fn showsFirstResponder(&self) -> bool;

        /// Setter for [`showsFirstResponder`][Self::showsFirstResponder].
        #[unsafe(method(setShowsFirstResponder:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setShowsFirstResponder(&self, shows_first_responder: bool);

        #[unsafe(method(performClick:))]
        #[unsafe(method_family = none)]
        pub unsafe fn performClick(&self, sender: Option<&AnyObject>);

        #[cfg(feature = "NSGraphics")]
        #[unsafe(method(focusRingType))]
        #[unsafe(method_family = none)]
        pub unsafe fn focusRingType(&self) -> NSFocusRingType;

        #[cfg(feature = "NSGraphics")]
        /// Setter for [`focusRingType`][Self::focusRingType].
        #[unsafe(method(setFocusRingType:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setFocusRingType(&self, focus_ring_type: NSFocusRingType);

        #[cfg(feature = "NSGraphics")]
        #[unsafe(method(defaultFocusRingType))]
        #[unsafe(method_family = none)]
        pub unsafe fn defaultFocusRingType(mtm: MainThreadMarker) -> NSFocusRingType;

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[unsafe(method(drawFocusRingMaskWithFrame:inView:))]
        #[unsafe(method_family = none)]
        pub unsafe fn drawFocusRingMaskWithFrame_inView(
            &self,
            cell_frame: NSRect,
            control_view: &NSView,
        );

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[unsafe(method(focusRingMaskBoundsForFrame:inView:))]
        #[unsafe(method_family = none)]
        pub unsafe fn focusRingMaskBoundsForFrame_inView(
            &self,
            cell_frame: NSRect,
            control_view: &NSView,
        ) -> NSRect;

        #[unsafe(method(wantsNotificationForMarkedText))]
        #[unsafe(method_family = none)]
        pub unsafe fn wantsNotificationForMarkedText(&self) -> bool;
    );
}

/// NSCellAttributedStringMethods.
impl NSCell {
    extern_methods!(
        #[unsafe(method(attributedStringValue))]
        #[unsafe(method_family = none)]
        pub unsafe fn attributedStringValue(&self) -> Retained<NSAttributedString>;

        /// Setter for [`attributedStringValue`][Self::attributedStringValue].
        #[unsafe(method(setAttributedStringValue:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAttributedStringValue(&self, attributed_string_value: &NSAttributedString);

        #[unsafe(method(allowsEditingTextAttributes))]
        #[unsafe(method_family = none)]
        pub unsafe fn allowsEditingTextAttributes(&self) -> bool;

        /// Setter for [`allowsEditingTextAttributes`][Self::allowsEditingTextAttributes].
        #[unsafe(method(setAllowsEditingTextAttributes:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAllowsEditingTextAttributes(&self, allows_editing_text_attributes: bool);

        #[unsafe(method(importsGraphics))]
        #[unsafe(method_family = none)]
        pub unsafe fn importsGraphics(&self) -> bool;

        /// Setter for [`importsGraphics`][Self::importsGraphics].
        #[unsafe(method(setImportsGraphics:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setImportsGraphics(&self, imports_graphics: bool);
    );
}

/// NSCellMixedState.
impl NSCell {
    extern_methods!(
        #[unsafe(method(allowsMixedState))]
        #[unsafe(method_family = none)]
        pub unsafe fn allowsMixedState(&self) -> bool;

        /// Setter for [`allowsMixedState`][Self::allowsMixedState].
        #[unsafe(method(setAllowsMixedState:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAllowsMixedState(&self, allows_mixed_state: bool);

        #[unsafe(method(nextState))]
        #[unsafe(method_family = none)]
        pub unsafe fn nextState(&self) -> NSInteger;

        #[unsafe(method(setNextState))]
        #[unsafe(method_family = none)]
        pub unsafe fn setNextState(&self);
    );
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nscellhitresult?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSCellHitResult(pub NSUInteger);
bitflags::bitflags! {
    impl NSCellHitResult: NSUInteger {
        #[doc(alias = "NSCellHitNone")]
        const None = 0;
        #[doc(alias = "NSCellHitContentArea")]
        const ContentArea = 1<<0;
        #[doc(alias = "NSCellHitEditableTextArea")]
        const EditableTextArea = 1<<1;
        #[doc(alias = "NSCellHitTrackableArea")]
        const TrackableArea = 1<<2;
    }
}

unsafe impl Encode for NSCellHitResult {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSCellHitResult {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// NSCellHitTest.
impl NSCell {
    extern_methods!(
        #[cfg(all(feature = "NSEvent", feature = "NSResponder", feature = "NSView"))]
        #[unsafe(method(hitTestForEvent:inRect:ofView:))]
        #[unsafe(method_family = none)]
        pub unsafe fn hitTestForEvent_inRect_ofView(
            &self,
            event: &NSEvent,
            cell_frame: NSRect,
            control_view: &NSView,
        ) -> NSCellHitResult;
    );
}

/// NSCellExpansion.
impl NSCell {
    extern_methods!(
        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[unsafe(method(expansionFrameWithFrame:inView:))]
        #[unsafe(method_family = none)]
        pub unsafe fn expansionFrameWithFrame_inView(
            &self,
            cell_frame: NSRect,
            view: &NSView,
        ) -> NSRect;

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[unsafe(method(drawWithExpansionFrame:inView:))]
        #[unsafe(method_family = none)]
        pub unsafe fn drawWithExpansionFrame_inView(&self, cell_frame: NSRect, view: &NSView);
    );
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsbackgroundstyle?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSBackgroundStyle(pub NSInteger);
impl NSBackgroundStyle {
    #[doc(alias = "NSBackgroundStyleNormal")]
    pub const Normal: Self = Self(0);
    #[doc(alias = "NSBackgroundStyleEmphasized")]
    pub const Emphasized: Self = Self(1);
    #[doc(alias = "NSBackgroundStyleRaised")]
    pub const Raised: Self = Self(2);
    #[doc(alias = "NSBackgroundStyleLowered")]
    pub const Lowered: Self = Self(3);
}

unsafe impl Encode for NSBackgroundStyle {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for NSBackgroundStyle {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// NSCellBackgroundStyle.
impl NSCell {
    extern_methods!(
        #[unsafe(method(backgroundStyle))]
        #[unsafe(method_family = none)]
        pub unsafe fn backgroundStyle(&self) -> NSBackgroundStyle;

        /// Setter for [`backgroundStyle`][Self::backgroundStyle].
        #[unsafe(method(setBackgroundStyle:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setBackgroundStyle(&self, background_style: NSBackgroundStyle);

        #[unsafe(method(interiorBackgroundStyle))]
        #[unsafe(method_family = none)]
        pub unsafe fn interiorBackgroundStyle(&self) -> NSBackgroundStyle;
    );
}

#[cfg(all(
    feature = "NSGraphics",
    feature = "NSImage",
    feature = "objc2-core-foundation"
))]
#[inline]
pub unsafe extern "C-unwind" fn NSDrawThreePartImage(
    frame: NSRect,
    start_cap: Option<&NSImage>,
    center_fill: Option<&NSImage>,
    end_cap: Option<&NSImage>,
    vertical: bool,
    op: NSCompositingOperation,
    alpha_fraction: CGFloat,
    flipped: bool,
) {
    extern "C-unwind" {
        fn NSDrawThreePartImage(
            frame: NSRect,
            start_cap: Option<&NSImage>,
            center_fill: Option<&NSImage>,
            end_cap: Option<&NSImage>,
            vertical: Bool,
            op: NSCompositingOperation,
            alpha_fraction: CGFloat,
            flipped: Bool,
        );
    }
    unsafe {
        NSDrawThreePartImage(
            frame,
            start_cap,
            center_fill,
            end_cap,
            Bool::new(vertical),
            op,
            alpha_fraction,
            Bool::new(flipped),
        )
    }
}

#[cfg(all(
    feature = "NSGraphics",
    feature = "NSImage",
    feature = "objc2-core-foundation"
))]
#[inline]
pub unsafe extern "C-unwind" fn NSDrawNinePartImage(
    frame: NSRect,
    top_left_corner: Option<&NSImage>,
    top_edge_fill: Option<&NSImage>,
    top_right_corner: Option<&NSImage>,
    left_edge_fill: Option<&NSImage>,
    center_fill: Option<&NSImage>,
    right_edge_fill: Option<&NSImage>,
    bottom_left_corner: Option<&NSImage>,
    bottom_edge_fill: Option<&NSImage>,
    bottom_right_corner: Option<&NSImage>,
    op: NSCompositingOperation,
    alpha_fraction: CGFloat,
    flipped: bool,
) {
    extern "C-unwind" {
        fn NSDrawNinePartImage(
            frame: NSRect,
            top_left_corner: Option<&NSImage>,
            top_edge_fill: Option<&NSImage>,
            top_right_corner: Option<&NSImage>,
            left_edge_fill: Option<&NSImage>,
            center_fill: Option<&NSImage>,
            right_edge_fill: Option<&NSImage>,
            bottom_left_corner: Option<&NSImage>,
            bottom_edge_fill: Option<&NSImage>,
            bottom_right_corner: Option<&NSImage>,
            op: NSCompositingOperation,
            alpha_fraction: CGFloat,
            flipped: Bool,
        );
    }
    unsafe {
        NSDrawNinePartImage(
            frame,
            top_left_corner,
            top_edge_fill,
            top_right_corner,
            left_edge_fill,
            center_fill,
            right_edge_fill,
            bottom_left_corner,
            bottom_edge_fill,
            bottom_right_corner,
            op,
            alpha_fraction,
            Bool::new(flipped),
        )
    }
}

/// NSDeprecated.
impl NSCell {
    extern_methods!(
        #[deprecated = "The controlTint property is not respected on 10.14 and later. For custom cells, use +[NSColor controlAccentColor] to respect the user's preferred accent color when drawing."]
        #[unsafe(method(controlTint))]
        #[unsafe(method_family = none)]
        pub unsafe fn controlTint(&self) -> NSControlTint;

        /// Setter for [`controlTint`][Self::controlTint].
        #[deprecated = "The controlTint property is not respected on 10.14 and later. For custom cells, use +[NSColor controlAccentColor] to respect the user's preferred accent color when drawing."]
        #[unsafe(method(setControlTint:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setControlTint(&self, control_tint: NSControlTint);

        #[deprecated]
        #[unsafe(method(entryType))]
        #[unsafe(method_family = none)]
        pub unsafe fn entryType(&self) -> NSInteger;

        #[deprecated]
        #[unsafe(method(setEntryType:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setEntryType(&self, r#type: NSInteger);

        #[deprecated]
        #[unsafe(method(isEntryAcceptable:))]
        #[unsafe(method_family = none)]
        pub unsafe fn isEntryAcceptable(&self, string: &NSString) -> bool;

        #[deprecated]
        #[unsafe(method(setFloatingPointFormat:left:right:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setFloatingPointFormat_left_right(
            &self,
            auto_range: bool,
            left_digits: NSUInteger,
            right_digits: NSUInteger,
        );

        #[deprecated]
        #[unsafe(method(setMnemonicLocation:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setMnemonicLocation(&self, location: NSUInteger);

        #[deprecated]
        #[unsafe(method(mnemonicLocation))]
        #[unsafe(method_family = none)]
        pub unsafe fn mnemonicLocation(&self) -> NSUInteger;

        #[deprecated]
        #[unsafe(method(mnemonic))]
        #[unsafe(method_family = none)]
        pub unsafe fn mnemonic(&self) -> Retained<NSString>;

        #[deprecated]
        #[unsafe(method(setTitleWithMnemonic:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setTitleWithMnemonic(&self, string_with_ampersand: &NSString);
    );
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsbackgroundstylelight?language=objc)
pub static NSBackgroundStyleLight: NSBackgroundStyle =
    NSBackgroundStyle(NSBackgroundStyle::Normal.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsbackgroundstyledark?language=objc)
pub static NSBackgroundStyleDark: NSBackgroundStyle =
    NSBackgroundStyle(NSBackgroundStyle::Emphasized.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nscellstatevalue?language=objc)
pub type NSCellStateValue = NSControlStateValue;

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsmixedstate?language=objc)
pub static NSMixedState: NSControlStateValue = NSControlStateValueMixed;

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsoffstate?language=objc)
pub static NSOffState: NSControlStateValue = NSControlStateValueOff;

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsonstate?language=objc)
pub static NSOnState: NSControlStateValue = NSControlStateValueOn;

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsregularcontrolsize?language=objc)
pub static NSRegularControlSize: NSControlSize = NSControlSize(NSControlSize::Regular.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nssmallcontrolsize?language=objc)
pub static NSSmallControlSize: NSControlSize = NSControlSize(NSControlSize::Small.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsminicontrolsize?language=objc)
pub static NSMiniControlSize: NSControlSize = NSControlSize(NSControlSize::Mini.0);

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nscontroltintdidchangenotification?language=objc)
    pub static NSControlTintDidChangeNotification: &'static NSNotificationName;
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsanytype?language=objc)
#[deprecated = "Use formatters instead"]
pub const NSAnyType: c_uint = 0;
/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsinttype?language=objc)
#[deprecated = "Use formatters instead"]
pub const NSIntType: c_uint = 1;
/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nspositiveinttype?language=objc)
#[deprecated = "Use formatters instead"]
pub const NSPositiveIntType: c_uint = 2;
/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsfloattype?language=objc)
#[deprecated = "Use formatters instead"]
pub const NSFloatType: c_uint = 3;
/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nspositivefloattype?language=objc)
#[deprecated = "Use formatters instead"]
pub const NSPositiveFloatType: c_uint = 4;
/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsdoubletype?language=objc)
#[deprecated = "Use formatters instead"]
pub const NSDoubleType: c_uint = 6;
/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nspositivedoubletype?language=objc)
#[deprecated = "Use formatters instead"]
pub const NSPositiveDoubleType: c_uint = 7;
