/* automatically generated by rust-bindgen 0.72.0 */

pub const MYSQL_AUTODETECT_CHARSET_NAME: &[u8; 5] = b"auto\0";
pub const MYSQL_NAMEDPIPE: &[u8; 6] = b"MySQL\0";
pub const MYSQL_SERVICENAME: &[u8; 6] = b"MySQL\0";
pub const MYSQL_ERRMSG_SIZE: u32 = 512;
pub const MYSQL_STMT_HEADER: u32 = 4;
pub const MYSQL_LONG_DATA_HEADER: u32 = 6;
pub const MYSQL_CLIENT_reserved1: u32 = 0;
pub const MYSQL_CLIENT_reserved2: u32 = 1;
pub const MYSQL_CLIENT_AUTHENTICATION_PLUGIN: u32 = 2;
pub const MYSQL_CLIENT_TRACE_PLUGIN: u32 = 3;
pub const MYSQL_CLIENT_TELEMETRY_PLUGIN: u32 = 4;
pub const MYSQL_CLIENT_AUTHENTICATION_PLUGIN_INTERFACE_VERSION: u32 = 512;
pub const MYSQL_CLIENT_TRACE_PLUGIN_INTERFACE_VERSION: u32 = 512;
pub const MYSQL_CLIENT_TELEMETRY_PLUGIN_INTERFACE_VERSION: u32 = 512;
pub const MYSQL_CLIENT_MAX_PLUGINS: u32 = 5;
pub const MYSQL_CLIENT_PLUGIN_AUTHOR_ORACLE: &[u8; 19] = b"Oracle Corporation\0";
pub const MYSQL_USERNAME_LENGTH: u32 = 96;
pub const MYSQL_SERVER_VERSION: &[u8; 6] = b"9.1.0\0";
pub const MYSQL_BASE_VERSION: &[u8; 11] = b"mysqld-9.1\0";
pub const MYSQL_SERVER_SUFFIX_DEF: &[u8; 1] = b"\0";
pub const MYSQL_VERSION_ID: u32 = 90100;
pub const MYSQL_VERSION_MATURITY: &[u8; 11] = b"INNOVATION\0";
pub const MYSQL_PORT: u32 = 3306;
pub const MYSQL_ADMIN_PORT: u32 = 33062;
pub const MYSQL_PORT_DEFAULT: u32 = 0;
pub const MYSQL_UNIX_ADDR: &[u8; 28] = b"/var/run/mysqld/mysqld.sock\0";
pub const MYSQL_CONFIG_NAME: &[u8; 3] = b"my\0";
pub const MYSQL_PERSIST_CONFIG_NAME: &[u8; 12] = b"mysqld-auto\0";
pub const MYSQL_COMPILATION_COMMENT: &[u8; 22] = b"MySQL Community - GPL\0";
pub const MYSQL_COMPILATION_COMMENT_SERVER: &[u8; 29] = b"MySQL Community Server - GPL\0";
pub const MYSQL_RPL_GTID: u32 = 65536;
pub const MYSQL_RPL_SKIP_HEARTBEAT: u32 = 131072;
pub const MYSQL_RPL_SKIP_TAGGED_GTIDS: u32 = 4;
pub const MYSQL_TAGGED_GTIDS_VERSION_SUPPORT: u32 = 80300;
pub const MYSQL_NO_DATA: u32 = 100;
pub const MYSQL_DATA_TRUNCATED: u32 = 101;
pub type __gnuc_va_list = __builtin_va_list;
pub type va_list = __gnuc_va_list;
pub type UINT_PTR = ::std::os::raw::c_uint;
pub type HANDLE = *mut ::std::os::raw::c_void;
pub type SOCKET = UINT_PTR;
#[repr(u32)]
#[non_exhaustive]
#[doc = "Column types for MySQL\nNote: Keep include/mysql/components/services/bits/stored_program_bits.h in\nsync with this"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum enum_field_types {
    MYSQL_TYPE_DECIMAL = 0,
    MYSQL_TYPE_TINY = 1,
    MYSQL_TYPE_SHORT = 2,
    MYSQL_TYPE_LONG = 3,
    MYSQL_TYPE_FLOAT = 4,
    MYSQL_TYPE_DOUBLE = 5,
    MYSQL_TYPE_NULL = 6,
    MYSQL_TYPE_TIMESTAMP = 7,
    MYSQL_TYPE_LONGLONG = 8,
    MYSQL_TYPE_INT24 = 9,
    MYSQL_TYPE_DATE = 10,
    MYSQL_TYPE_TIME = 11,
    MYSQL_TYPE_DATETIME = 12,
    MYSQL_TYPE_YEAR = 13,
    #[doc = "< Internal to MySQL. Not used in protocol"]
    MYSQL_TYPE_NEWDATE = 14,
    MYSQL_TYPE_VARCHAR = 15,
    MYSQL_TYPE_BIT = 16,
    MYSQL_TYPE_TIMESTAMP2 = 17,
    #[doc = "< Internal to MySQL. Not used in protocol"]
    MYSQL_TYPE_DATETIME2 = 18,
    #[doc = "< Internal to MySQL. Not used in protocol"]
    MYSQL_TYPE_TIME2 = 19,
    #[doc = "< Used for replication only"]
    MYSQL_TYPE_TYPED_ARRAY = 20,
    MYSQL_TYPE_VECTOR = 242,
    MYSQL_TYPE_INVALID = 243,
    #[doc = "< Currently just a placeholder"]
    MYSQL_TYPE_BOOL = 244,
    MYSQL_TYPE_JSON = 245,
    MYSQL_TYPE_NEWDECIMAL = 246,
    MYSQL_TYPE_ENUM = 247,
    MYSQL_TYPE_SET = 248,
    MYSQL_TYPE_TINY_BLOB = 249,
    MYSQL_TYPE_MEDIUM_BLOB = 250,
    MYSQL_TYPE_LONG_BLOB = 251,
    MYSQL_TYPE_BLOB = 252,
    MYSQL_TYPE_VAR_STRING = 253,
    MYSQL_TYPE_STRING = 254,
    MYSQL_TYPE_GEOMETRY = 255,
}
#[doc = "@file include/my_list.h"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LIST {
    pub prev: *mut LIST,
    pub next: *mut LIST,
    pub data: *mut ::std::os::raw::c_void,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of LIST"][::std::mem::size_of::<LIST>() - 12usize];
    ["Alignment of LIST"][::std::mem::align_of::<LIST>() - 4usize];
    ["Offset of field: LIST::prev"][::std::mem::offset_of!(LIST, prev) - 0usize];
    ["Offset of field: LIST::next"][::std::mem::offset_of!(LIST, next) - 4usize];
    ["Offset of field: LIST::data"][::std::mem::offset_of!(LIST, data) - 8usize];
};
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum enum_compression_algorithm {
    MYSQL_UNCOMPRESSED = 1,
    MYSQL_ZLIB = 2,
    MYSQL_ZSTD = 3,
    MYSQL_INVALID = 4,
}
#[doc = "Compress context information. relating to zlib compression."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct mysql_zlib_compress_context {
    #[doc = "Compression level to use in zlib compression."]
    pub compression_level: ::std::os::raw::c_uint,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of mysql_zlib_compress_context"]
        [::std::mem::size_of::<mysql_zlib_compress_context>() - 4usize];
    ["Alignment of mysql_zlib_compress_context"]
        [::std::mem::align_of::<mysql_zlib_compress_context>() - 4usize];
    ["Offset of field: mysql_zlib_compress_context::compression_level"]
        [::std::mem::offset_of!(mysql_zlib_compress_context, compression_level) - 0usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ZSTD_CCtx_s {
    _unused: [u8; 0],
}
pub type ZSTD_CCtx = ZSTD_CCtx_s;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ZSTD_DCtx_s {
    _unused: [u8; 0],
}
pub type ZSTD_DCtx = ZSTD_DCtx_s;
#[doc = "Compress context information relating to zstd compression."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct mysql_zstd_compress_context {
    #[doc = "Pointer to compressor context."]
    pub cctx: *mut ZSTD_CCtx,
    #[doc = "Pointer to decompressor context."]
    pub dctx: *mut ZSTD_DCtx,
    #[doc = "Compression level to use in zstd compression."]
    pub compression_level: ::std::os::raw::c_uint,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of mysql_zstd_compress_context"]
        [::std::mem::size_of::<mysql_zstd_compress_context>() - 12usize];
    ["Alignment of mysql_zstd_compress_context"]
        [::std::mem::align_of::<mysql_zstd_compress_context>() - 4usize];
    ["Offset of field: mysql_zstd_compress_context::cctx"]
        [::std::mem::offset_of!(mysql_zstd_compress_context, cctx) - 0usize];
    ["Offset of field: mysql_zstd_compress_context::dctx"]
        [::std::mem::offset_of!(mysql_zstd_compress_context, dctx) - 4usize];
    ["Offset of field: mysql_zstd_compress_context::compression_level"]
        [::std::mem::offset_of!(mysql_zstd_compress_context, compression_level) - 8usize];
};
#[doc = "Compression context information.\nIt encapsulate the context information based on compression method and\npresents a generic struct."]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct mysql_compress_context {
    #[doc = "< Compression algorithm name."]
    pub algorithm: enum_compression_algorithm,
    pub u: mysql_compress_context__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union mysql_compress_context__bindgen_ty_1 {
    #[doc = "< Context information of zlib."]
    pub zlib_ctx: mysql_zlib_compress_context,
    #[doc = "< Context information of zstd."]
    pub zstd_ctx: mysql_zstd_compress_context,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of mysql_compress_context__bindgen_ty_1"]
        [::std::mem::size_of::<mysql_compress_context__bindgen_ty_1>() - 12usize];
    ["Alignment of mysql_compress_context__bindgen_ty_1"]
        [::std::mem::align_of::<mysql_compress_context__bindgen_ty_1>() - 4usize];
    ["Offset of field: mysql_compress_context__bindgen_ty_1::zlib_ctx"]
        [::std::mem::offset_of!(mysql_compress_context__bindgen_ty_1, zlib_ctx) - 0usize];
    ["Offset of field: mysql_compress_context__bindgen_ty_1::zstd_ctx"]
        [::std::mem::offset_of!(mysql_compress_context__bindgen_ty_1, zstd_ctx) - 0usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of mysql_compress_context"][::std::mem::size_of::<mysql_compress_context>() - 16usize];
    ["Alignment of mysql_compress_context"]
        [::std::mem::align_of::<mysql_compress_context>() - 4usize];
    ["Offset of field: mysql_compress_context::algorithm"]
        [::std::mem::offset_of!(mysql_compress_context, algorithm) - 0usize];
    ["Offset of field: mysql_compress_context::u"]
        [::std::mem::offset_of!(mysql_compress_context, u) - 4usize];
};
unsafe extern "C" {
    #[doc = "Get default compression level corresponding to a given compression method.\n\n@param algorithm Compression Method. Possible values are zlib or zstd.\n\n@return an unsigned int representing default compression level.\n6 is the default compression level for zlib and 3 is the\ndefault compression level for zstd."]
    pub fn mysql_default_compression_level(
        algorithm: enum_compression_algorithm,
    ) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[doc = "Initialize a compress context object to be associated with a NET object.\n\n@param cmp_ctx Pointer to compression context.\n@param algorithm Compression algorithm.\n@param compression_level Compression level corresponding to the compression\nalgorithm."]
    pub fn mysql_compress_context_init(
        cmp_ctx: *mut mysql_compress_context,
        algorithm: enum_compression_algorithm,
        compression_level: ::std::os::raw::c_uint,
    );
}
unsafe extern "C" {
    #[doc = "Deinitialize the compression context allocated.\n\n@param mysql_compress_ctx Pointer to Compression context."]
    pub fn mysql_compress_context_deinit(mysql_compress_ctx: *mut mysql_compress_context);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Vio {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NET {
    pub vio: *mut Vio,
    pub buff: *mut ::std::os::raw::c_uchar,
    pub buff_end: *mut ::std::os::raw::c_uchar,
    pub write_pos: *mut ::std::os::raw::c_uchar,
    pub read_pos: *mut ::std::os::raw::c_uchar,
    pub fd: SOCKET,
    #[doc = "Set if we are doing several queries in one\ncommand ( as in LOAD TABLE ... FROM MASTER ),\nand do not want to confuse the client with OK at the wrong time"]
    pub remain_in_buf: ::std::os::raw::c_ulong,
    #[doc = "Set if we are doing several queries in one\ncommand ( as in LOAD TABLE ... FROM MASTER ),\nand do not want to confuse the client with OK at the wrong time"]
    pub length: ::std::os::raw::c_ulong,
    #[doc = "Set if we are doing several queries in one\ncommand ( as in LOAD TABLE ... FROM MASTER ),\nand do not want to confuse the client with OK at the wrong time"]
    pub buf_length: ::std::os::raw::c_ulong,
    #[doc = "Set if we are doing several queries in one\ncommand ( as in LOAD TABLE ... FROM MASTER ),\nand do not want to confuse the client with OK at the wrong time"]
    pub where_b: ::std::os::raw::c_ulong,
    pub max_packet: ::std::os::raw::c_ulong,
    pub max_packet_size: ::std::os::raw::c_ulong,
    pub pkt_nr: ::std::os::raw::c_uint,
    pub compress_pkt_nr: ::std::os::raw::c_uint,
    pub write_timeout: ::std::os::raw::c_uint,
    pub read_timeout: ::std::os::raw::c_uint,
    pub retry_count: ::std::os::raw::c_uint,
    pub fcntl: ::std::os::raw::c_int,
    pub return_status: *mut ::std::os::raw::c_uint,
    pub reading_or_writing: ::std::os::raw::c_uchar,
    pub save_char: ::std::os::raw::c_uchar,
    pub compress: bool,
    pub last_errno: ::std::os::raw::c_uint,
    pub error: ::std::os::raw::c_uchar,
    #[doc = " Client library error message buffer. Actually belongs to struct MYSQL."]
    pub last_error: [::std::os::raw::c_char; 512usize],
    #[doc = " Client library sqlstate buffer. Set along with the error message."]
    pub sqlstate: [::std::os::raw::c_char; 6usize],
    #[doc = "Extension pointer, for the caller private use.\nAny program linking with the networking library can use this pointer,\nwhich is handy when private connection specific data needs to be\nmaintained.\nThe mysqld server process uses this pointer internally,\nto maintain the server internal instrumentation for the connection."]
    pub extension: *mut ::std::os::raw::c_void,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of NET"][::std::mem::size_of::<NET>() - 608usize];
    ["Alignment of NET"][::std::mem::align_of::<NET>() - 4usize];
    ["Offset of field: NET::vio"][::std::mem::offset_of!(NET, vio) - 0usize];
    ["Offset of field: NET::buff"][::std::mem::offset_of!(NET, buff) - 4usize];
    ["Offset of field: NET::buff_end"][::std::mem::offset_of!(NET, buff_end) - 8usize];
    ["Offset of field: NET::write_pos"][::std::mem::offset_of!(NET, write_pos) - 12usize];
    ["Offset of field: NET::read_pos"][::std::mem::offset_of!(NET, read_pos) - 16usize];
    ["Offset of field: NET::fd"][::std::mem::offset_of!(NET, fd) - 20usize];
    ["Offset of field: NET::remain_in_buf"][::std::mem::offset_of!(NET, remain_in_buf) - 24usize];
    ["Offset of field: NET::length"][::std::mem::offset_of!(NET, length) - 28usize];
    ["Offset of field: NET::buf_length"][::std::mem::offset_of!(NET, buf_length) - 32usize];
    ["Offset of field: NET::where_b"][::std::mem::offset_of!(NET, where_b) - 36usize];
    ["Offset of field: NET::max_packet"][::std::mem::offset_of!(NET, max_packet) - 40usize];
    ["Offset of field: NET::max_packet_size"]
        [::std::mem::offset_of!(NET, max_packet_size) - 44usize];
    ["Offset of field: NET::pkt_nr"][::std::mem::offset_of!(NET, pkt_nr) - 48usize];
    ["Offset of field: NET::compress_pkt_nr"]
        [::std::mem::offset_of!(NET, compress_pkt_nr) - 52usize];
    ["Offset of field: NET::write_timeout"][::std::mem::offset_of!(NET, write_timeout) - 56usize];
    ["Offset of field: NET::read_timeout"][::std::mem::offset_of!(NET, read_timeout) - 60usize];
    ["Offset of field: NET::retry_count"][::std::mem::offset_of!(NET, retry_count) - 64usize];
    ["Offset of field: NET::fcntl"][::std::mem::offset_of!(NET, fcntl) - 68usize];
    ["Offset of field: NET::return_status"][::std::mem::offset_of!(NET, return_status) - 72usize];
    ["Offset of field: NET::reading_or_writing"]
        [::std::mem::offset_of!(NET, reading_or_writing) - 76usize];
    ["Offset of field: NET::save_char"][::std::mem::offset_of!(NET, save_char) - 77usize];
    ["Offset of field: NET::compress"][::std::mem::offset_of!(NET, compress) - 78usize];
    ["Offset of field: NET::last_errno"][::std::mem::offset_of!(NET, last_errno) - 80usize];
    ["Offset of field: NET::error"][::std::mem::offset_of!(NET, error) - 84usize];
    ["Offset of field: NET::last_error"][::std::mem::offset_of!(NET, last_error) - 85usize];
    ["Offset of field: NET::sqlstate"][::std::mem::offset_of!(NET, sqlstate) - 597usize];
    ["Offset of field: NET::extension"][::std::mem::offset_of!(NET, extension) - 604usize];
};
#[repr(u32)]
#[non_exhaustive]
#[doc = "We want levels to be in growing order of hardness (because we use number\ncomparisons).\n\n@note ::SHUTDOWN_DEFAULT does not respect the growing property, but it's ok."]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum mysql_enum_shutdown_level {
    SHUTDOWN_DEFAULT = 0,
    #[doc = " Wait for existing connections to finish"]
    SHUTDOWN_WAIT_CONNECTIONS = 1,
    #[doc = " Wait for existing transactons to finish"]
    SHUTDOWN_WAIT_TRANSACTIONS = 2,
    #[doc = " Wait for existing updates to finish (=> no partial MyISAM update)"]
    SHUTDOWN_WAIT_UPDATES = 8,
    #[doc = " Flush InnoDB buffers and other storage engines' buffers"]
    SHUTDOWN_WAIT_ALL_BUFFERS = 16,
    #[doc = " Don't flush InnoDB buffers, flush other storage engines' buffers"]
    SHUTDOWN_WAIT_CRITICAL_BUFFERS = 17,
    #[doc = " Query level of the KILL command"]
    KILL_QUERY = 254,
    #[doc = " Connection level of the KILL command"]
    KILL_CONNECTION = 255,
}
#[repr(u32)]
#[non_exhaustive]
#[doc = " @}"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum enum_resultset_metadata {
    #[doc = " No metadata will be sent."]
    RESULTSET_METADATA_NONE = 0,
    #[doc = " The server will send all metadata."]
    RESULTSET_METADATA_FULL = 1,
}
#[repr(u32)]
#[non_exhaustive]
#[doc = " options for ::mysql_options()"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum enum_mysql_set_option {
    MYSQL_OPTION_MULTI_STATEMENTS_ON = 0,
    MYSQL_OPTION_MULTI_STATEMENTS_OFF = 1,
}
#[repr(u32)]
#[non_exhaustive]
#[doc = "Type of state change information that the server can include in the Ok\npacket.\n\n@note\n- session_state_type shouldn't go past 255 (i.e. 1-byte boundary).\n- Modify the definition of ::SESSION_TRACK_END when a new member is added."]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum enum_session_state_type {
    #[doc = "< Session system variables"]
    SESSION_TRACK_SYSTEM_VARIABLES = 0,
    #[doc = "< Current schema"]
    SESSION_TRACK_SCHEMA = 1,
    #[doc = "< track session state changes"]
    SESSION_TRACK_STATE_CHANGE = 2,
    #[doc = "< See also: session_track_gtids"]
    SESSION_TRACK_GTIDS = 3,
    #[doc = "< Transaction chistics"]
    SESSION_TRACK_TRANSACTION_CHARACTERISTICS = 4,
    #[doc = "< Transaction state"]
    SESSION_TRACK_TRANSACTION_STATE = 5,
}
unsafe extern "C" {
    pub fn mysql_errno_to_sqlstate(
        mysql_errno: ::std::os::raw::c_uint,
    ) -> *const ::std::os::raw::c_char;
}
#[repr(u32)]
#[non_exhaustive]
#[doc = "Describes the current state of Asynchronous connection phase state machine\n\n@startuml\n[*] --> CONNECT_STAGE_INVALID\n[*] --> CONNECT_STAGE_NOT_STARTED\n\nCONNECT_STAGE_NOT_STARTED --> CONNECT_STAGE_NET_BEGIN_CONNECT\nCONNECT_STAGE_NOT_STARTED --> CONNECT_STAGE_COMPLETE\n\nCONNECT_STAGE_NET_BEGIN_CONNECT --> CONNECT_STAGE_NET_WAIT_CONNECT\nCONNECT_STAGE_NET_BEGIN_CONNECT --> CONNECT_STAGE_NET_COMPLETE_CONNECT\nCONNECT_STAGE_NET_BEGIN_CONNECT --> STATE_MACHINE_FAILED\n\nCONNECT_STAGE_NET_WAIT_CONNECT --> CONNECT_STAGE_NET_COMPLETE_CONNECT\nCONNECT_STAGE_NET_WAIT_CONNECT --> STATE_MACHINE_FAILED\n\nCONNECT_STAGE_NET_COMPLETE_CONNECT --> STATE_MACHINE_FAILED\nCONNECT_STAGE_NET_COMPLETE_CONNECT --> CONNECT_STAGE_READ_GREETING\n\nCONNECT_STAGE_READ_GREETING --> STATE_MACHINE_FAILED\nCONNECT_STAGE_READ_GREETING --> CONNECT_STAGE_PARSE_HANDSHAKE\n\nCONNECT_STAGE_PARSE_HANDSHAKE --> STATE_MACHINE_FAILED\nCONNECT_STAGE_PARSE_HANDSHAKE --> CONNECT_STAGE_ESTABLISH_SSL\n\nCONNECT_STAGE_ESTABLISH_SSL --> STATE_MACHINE_FAILED\nCONNECT_STAGE_ESTABLISH_SSL --> CONNECT_STAGE_AUTHENTICATE\n\nCONNECT_STAGE_AUTHENTICATE --> STATE_MACHINE_FAILED\nCONNECT_STAGE_AUTHENTICATE --> CONNECT_STAGE_AUTH_BEGIN\n\nCONNECT_STAGE_AUTH_BEGIN --> STATE_MACHINE_FAILED\nCONNECT_STAGE_AUTH_BEGIN --> CONNECT_STAGE_AUTH_RUN_FIRST_AUTHENTICATE_USER\n\nCONNECT_STAGE_AUTH_RUN_FIRST_AUTHENTICATE_USER --> CONNECT_STAGE_AUTH_HANDLE_FIRST_AUTHENTICATE_USER\n\nCONNECT_STAGE_AUTH_HANDLE_FIRST_AUTHENTICATE_USER --> STATE_MACHINE_FAILED\nCONNECT_STAGE_AUTH_HANDLE_FIRST_AUTHENTICATE_USER --> CONNECT_STAGE_AUTH_READ_CHANGE_USER_RESULT\n\nCONNECT_STAGE_AUTH_READ_CHANGE_USER_RESULT --> CONNECT_STAGE_AUTH_HANDLE_CHANGE_USER_REQUEST\n\nCONNECT_STAGE_AUTH_HANDLE_CHANGE_USER_REQUEST --> STATE_MACHINE_FAILED\nCONNECT_STAGE_AUTH_HANDLE_CHANGE_USER_REQUEST --> CONNECT_STAGE_AUTH_RUN_SECOND_AUTHENTICATE_USER\nCONNECT_STAGE_AUTH_HANDLE_CHANGE_USER_REQUEST --> CONNECT_STAGE_AUTH_INIT_MULTI_AUTH\nCONNECT_STAGE_AUTH_HANDLE_CHANGE_USER_REQUEST --> CONNECT_STAGE_AUTH_FINISH_AUTH\n\nCONNECT_STAGE_AUTH_RUN_SECOND_AUTHENTICATE_USER --> STATE_MACHINE_FAILED\nCONNECT_STAGE_AUTH_RUN_SECOND_AUTHENTICATE_USER --> CONNECT_STAGE_AUTH_HANDLE_SECOND_AUTHENTICATE_USER\n\nCONNECT_STAGE_AUTH_HANDLE_SECOND_AUTHENTICATE_USER --> STATE_MACHINE_FAILED\nCONNECT_STAGE_AUTH_HANDLE_SECOND_AUTHENTICATE_USER --> CONNECT_STAGE_AUTH_INIT_MULTI_AUTH\nCONNECT_STAGE_AUTH_HANDLE_SECOND_AUTHENTICATE_USER --> CONNECT_STAGE_AUTH_FINISH_AUTH\n\nCONNECT_STAGE_AUTH_INIT_MULTI_AUTH --> STATE_MACHINE_FAILED\nCONNECT_STAGE_AUTH_INIT_MULTI_AUTH --> CONNECT_STAGE_AUTH_DO_MULTI_PLUGIN_AUTH\n\nCONNECT_STAGE_AUTH_DO_MULTI_PLUGIN_AUTH --> STATE_MACHINE_FAILED\nCONNECT_STAGE_AUTH_DO_MULTI_PLUGIN_AUTH --> CONNECT_STAGE_AUTH_HANDLE_MULTI_AUTH_RESPONSE\n\nCONNECT_STAGE_AUTH_HANDLE_MULTI_AUTH_RESPONSE --> STATE_MACHINE_FAILED\nCONNECT_STAGE_AUTH_HANDLE_MULTI_AUTH_RESPONSE --> CONNECT_STAGE_AUTH_INIT_MULTI_AUTH\nCONNECT_STAGE_AUTH_HANDLE_MULTI_AUTH_RESPONSE --> CONNECT_STAGE_AUTH_FINISH_AUTH\n\nCONNECT_STAGE_AUTH_FINISH_AUTH --> STATE_MACHINE_FAILED\nCONNECT_STAGE_AUTH_FINISH_AUTH --> CONNECT_STAGE_PREP_SELECT_DATABASE\n\nCONNECT_STAGE_PREP_SELECT_DATABASE --> CONNECT_STAGE_COMPLETE\nCONNECT_STAGE_PREP_SELECT_DATABASE --> CONNECT_STAGE_PREP_INIT_COMMANDS\n\nCONNECT_STAGE_PREP_INIT_COMMANDS --> CONNECT_STAGE_COMPLETE\nCONNECT_STAGE_PREP_INIT_COMMANDS --> CONNECT_STAGE_SEND_ONE_INIT_COMMAND\n\nCONNECT_STAGE_SEND_ONE_INIT_COMMAND --> CONNECT_STAGE_SEND_ONE_INIT_COMMAND\nCONNECT_STAGE_SEND_ONE_INIT_COMMAND --> STATE_MACHINE_FAILED\nCONNECT_STAGE_SEND_ONE_INIT_COMMAND --> CONNECT_STAGE_COMPLETE\n\nSTATE_MACHINE_FAILED --> [*]\nCONNECT_STAGE_COMPLETE --> [*]\nCONNECT_STAGE_INVALID --> [*]\n@enduml"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum connect_stage {
    #[doc = " MYSQL not valid or an unknown state"]
    CONNECT_STAGE_INVALID = 0,
    #[doc = " not connected"]
    CONNECT_STAGE_NOT_STARTED = 1,
    #[doc = " begin connection to the server"]
    CONNECT_STAGE_NET_BEGIN_CONNECT = 2,
    #[doc = " wait for connection to be established"]
    CONNECT_STAGE_NET_WAIT_CONNECT = 3,
    #[doc = " init the local data structures post connect"]
    CONNECT_STAGE_NET_COMPLETE_CONNECT = 4,
    #[doc = " read the first packet"]
    CONNECT_STAGE_READ_GREETING = 5,
    #[doc = " parse the first packet"]
    CONNECT_STAGE_PARSE_HANDSHAKE = 6,
    #[doc = " tls establishment"]
    CONNECT_STAGE_ESTABLISH_SSL = 7,
    #[doc = " authentication phase"]
    CONNECT_STAGE_AUTHENTICATE = 8,
    #[doc = " determine the plugin to use"]
    CONNECT_STAGE_AUTH_BEGIN = 9,
    #[doc = " run first auth plugin"]
    CONNECT_STAGE_AUTH_RUN_FIRST_AUTHENTICATE_USER = 10,
    #[doc = " handle the result of the first auth plugin run"]
    CONNECT_STAGE_AUTH_HANDLE_FIRST_AUTHENTICATE_USER = 11,
    #[doc = " read the implied changed user auth, if any"]
    CONNECT_STAGE_AUTH_READ_CHANGE_USER_RESULT = 12,
    #[doc = " Check if server asked to use a different authentication plugin"]
    CONNECT_STAGE_AUTH_HANDLE_CHANGE_USER_REQUEST = 13,
    #[doc = " Start the authentication process again with the plugin which\nserver asked for"]
    CONNECT_STAGE_AUTH_RUN_SECOND_AUTHENTICATE_USER = 14,
    #[doc = " Start multi factor authentication"]
    CONNECT_STAGE_AUTH_INIT_MULTI_AUTH = 15,
    #[doc = " Final cleanup"]
    CONNECT_STAGE_AUTH_FINISH_AUTH = 16,
    #[doc = " Now read the results of the second plugin run"]
    CONNECT_STAGE_AUTH_HANDLE_SECOND_AUTHENTICATE_USER = 17,
    #[doc = " Invoke client plugins multi-auth authentication method"]
    CONNECT_STAGE_AUTH_DO_MULTI_PLUGIN_AUTH = 18,
    #[doc = " Handle response from client plugins authentication method"]
    CONNECT_STAGE_AUTH_HANDLE_MULTI_AUTH_RESPONSE = 19,
    #[doc = " Authenticated, set initial database if specified"]
    CONNECT_STAGE_PREP_SELECT_DATABASE = 20,
    #[doc = " Prepare to send a sequence of init commands."]
    CONNECT_STAGE_PREP_INIT_COMMANDS = 21,
    #[doc = " Send an init command.  This is called once per init command until\nthey've all been run (or a failure occurs)"]
    CONNECT_STAGE_SEND_ONE_INIT_COMMAND = 22,
    #[doc = " Connected or no async connect in progress"]
    CONNECT_STAGE_COMPLETE = 23,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct st_mysql_client_plugin {
    pub type_: ::std::os::raw::c_int,
    pub interface_version: ::std::os::raw::c_uint,
    pub name: *const ::std::os::raw::c_char,
    pub author: *const ::std::os::raw::c_char,
    pub desc: *const ::std::os::raw::c_char,
    pub version: [::std::os::raw::c_uint; 3usize],
    pub license: *const ::std::os::raw::c_char,
    pub mysql_api: *mut ::std::os::raw::c_void,
    pub init: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut ::std::os::raw::c_char,
            arg2: usize,
            arg3: ::std::os::raw::c_int,
            arg4: va_list,
        ) -> ::std::os::raw::c_int,
    >,
    pub deinit: ::std::option::Option<unsafe extern "C" fn() -> ::std::os::raw::c_int>,
    pub options: ::std::option::Option<
        unsafe extern "C" fn(
            option: *const ::std::os::raw::c_char,
            arg1: *const ::std::os::raw::c_void,
        ) -> ::std::os::raw::c_int,
    >,
    pub get_options: ::std::option::Option<
        unsafe extern "C" fn(
            option: *const ::std::os::raw::c_char,
            arg1: *mut ::std::os::raw::c_void,
        ) -> ::std::os::raw::c_int,
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of st_mysql_client_plugin"][::std::mem::size_of::<st_mysql_client_plugin>() - 56usize];
    ["Alignment of st_mysql_client_plugin"]
        [::std::mem::align_of::<st_mysql_client_plugin>() - 4usize];
    ["Offset of field: st_mysql_client_plugin::type_"]
        [::std::mem::offset_of!(st_mysql_client_plugin, type_) - 0usize];
    ["Offset of field: st_mysql_client_plugin::interface_version"]
        [::std::mem::offset_of!(st_mysql_client_plugin, interface_version) - 4usize];
    ["Offset of field: st_mysql_client_plugin::name"]
        [::std::mem::offset_of!(st_mysql_client_plugin, name) - 8usize];
    ["Offset of field: st_mysql_client_plugin::author"]
        [::std::mem::offset_of!(st_mysql_client_plugin, author) - 12usize];
    ["Offset of field: st_mysql_client_plugin::desc"]
        [::std::mem::offset_of!(st_mysql_client_plugin, desc) - 16usize];
    ["Offset of field: st_mysql_client_plugin::version"]
        [::std::mem::offset_of!(st_mysql_client_plugin, version) - 20usize];
    ["Offset of field: st_mysql_client_plugin::license"]
        [::std::mem::offset_of!(st_mysql_client_plugin, license) - 32usize];
    ["Offset of field: st_mysql_client_plugin::mysql_api"]
        [::std::mem::offset_of!(st_mysql_client_plugin, mysql_api) - 36usize];
    ["Offset of field: st_mysql_client_plugin::init"]
        [::std::mem::offset_of!(st_mysql_client_plugin, init) - 40usize];
    ["Offset of field: st_mysql_client_plugin::deinit"]
        [::std::mem::offset_of!(st_mysql_client_plugin, deinit) - 44usize];
    ["Offset of field: st_mysql_client_plugin::options"]
        [::std::mem::offset_of!(st_mysql_client_plugin, options) - 48usize];
    ["Offset of field: st_mysql_client_plugin::get_options"]
        [::std::mem::offset_of!(st_mysql_client_plugin, get_options) - 52usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MYSQL_PLUGIN_VIO_INFO {
    pub protocol: MYSQL_PLUGIN_VIO_INFO__bindgen_ty_1,
    #[doc = "< it's set, if the protocol is SOCKET or TCP"]
    pub socket: ::std::os::raw::c_int,
    pub is_tls_established: bool,
    #[doc = "< it's set, if the protocol is PIPE or MEMORY"]
    pub handle: HANDLE,
}
pub const MYSQL_PLUGIN_VIO_INFO_MYSQL_VIO_INVALID: MYSQL_PLUGIN_VIO_INFO__bindgen_ty_1 =
    MYSQL_PLUGIN_VIO_INFO__bindgen_ty_1::MYSQL_VIO_INVALID;
pub const MYSQL_PLUGIN_VIO_INFO_MYSQL_VIO_TCP: MYSQL_PLUGIN_VIO_INFO__bindgen_ty_1 =
    MYSQL_PLUGIN_VIO_INFO__bindgen_ty_1::MYSQL_VIO_TCP;
pub const MYSQL_PLUGIN_VIO_INFO_MYSQL_VIO_SOCKET: MYSQL_PLUGIN_VIO_INFO__bindgen_ty_1 =
    MYSQL_PLUGIN_VIO_INFO__bindgen_ty_1::MYSQL_VIO_SOCKET;
pub const MYSQL_PLUGIN_VIO_INFO_MYSQL_VIO_PIPE: MYSQL_PLUGIN_VIO_INFO__bindgen_ty_1 =
    MYSQL_PLUGIN_VIO_INFO__bindgen_ty_1::MYSQL_VIO_PIPE;
pub const MYSQL_PLUGIN_VIO_INFO_MYSQL_VIO_MEMORY: MYSQL_PLUGIN_VIO_INFO__bindgen_ty_1 =
    MYSQL_PLUGIN_VIO_INFO__bindgen_ty_1::MYSQL_VIO_MEMORY;
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum MYSQL_PLUGIN_VIO_INFO__bindgen_ty_1 {
    MYSQL_VIO_INVALID = 0,
    MYSQL_VIO_TCP = 1,
    MYSQL_VIO_SOCKET = 2,
    MYSQL_VIO_PIPE = 3,
    MYSQL_VIO_MEMORY = 4,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of MYSQL_PLUGIN_VIO_INFO"][::std::mem::size_of::<MYSQL_PLUGIN_VIO_INFO>() - 16usize];
    ["Alignment of MYSQL_PLUGIN_VIO_INFO"]
        [::std::mem::align_of::<MYSQL_PLUGIN_VIO_INFO>() - 4usize];
    ["Offset of field: MYSQL_PLUGIN_VIO_INFO::protocol"]
        [::std::mem::offset_of!(MYSQL_PLUGIN_VIO_INFO, protocol) - 0usize];
    ["Offset of field: MYSQL_PLUGIN_VIO_INFO::socket"]
        [::std::mem::offset_of!(MYSQL_PLUGIN_VIO_INFO, socket) - 4usize];
    ["Offset of field: MYSQL_PLUGIN_VIO_INFO::is_tls_established"]
        [::std::mem::offset_of!(MYSQL_PLUGIN_VIO_INFO, is_tls_established) - 8usize];
    ["Offset of field: MYSQL_PLUGIN_VIO_INFO::handle"]
        [::std::mem::offset_of!(MYSQL_PLUGIN_VIO_INFO, handle) - 12usize];
};
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum net_async_status {
    NET_ASYNC_COMPLETE = 0,
    NET_ASYNC_NOT_READY = 1,
    NET_ASYNC_ERROR = 2,
    NET_ASYNC_COMPLETE_NO_MORE_RESULTS = 3,
}
#[doc = "Provides plugin access to communication channel"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MYSQL_PLUGIN_VIO {
    #[doc = "Plugin provides a pointer reference and this function sets it to the\ncontents of any incoming packet. Returns the packet length, or -1 if\nthe plugin should terminate."]
    pub read_packet: ::std::option::Option<
        unsafe extern "C" fn(
            vio: *mut MYSQL_PLUGIN_VIO,
            buf: *mut *mut ::std::os::raw::c_uchar,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "Plugin provides a buffer with data and the length and this\nfunction sends it as a packet. Returns 0 on success, 1 on failure."]
    pub write_packet: ::std::option::Option<
        unsafe extern "C" fn(
            vio: *mut MYSQL_PLUGIN_VIO,
            packet: *const ::std::os::raw::c_uchar,
            packet_len: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "Fills in a MYSQL_PLUGIN_VIO_INFO structure, providing the information\nabout the connection."]
    pub info: ::std::option::Option<
        unsafe extern "C" fn(vio: *mut MYSQL_PLUGIN_VIO, info: *mut MYSQL_PLUGIN_VIO_INFO),
    >,
    #[doc = "Non blocking version of read_packet. This function points buf to starting\nposition of incoming packet. When this function returns NET_ASYNC_NOT_READY\nplugin should call this function again until all incoming packets are read.\nIf return code is NET_ASYNC_COMPLETE, plugin can do further processing of\nread packets."]
    pub read_packet_nonblocking: ::std::option::Option<
        unsafe extern "C" fn(
            vio: *mut MYSQL_PLUGIN_VIO,
            buf: *mut *mut ::std::os::raw::c_uchar,
            result: *mut ::std::os::raw::c_int,
        ) -> net_async_status,
    >,
    #[doc = "Non blocking version of write_packet. Sends data available in pkt of length\npkt_len to server in asynchronous way."]
    pub write_packet_nonblocking: ::std::option::Option<
        unsafe extern "C" fn(
            vio: *mut MYSQL_PLUGIN_VIO,
            pkt: *const ::std::os::raw::c_uchar,
            pkt_len: ::std::os::raw::c_int,
            result: *mut ::std::os::raw::c_int,
        ) -> net_async_status,
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of MYSQL_PLUGIN_VIO"][::std::mem::size_of::<MYSQL_PLUGIN_VIO>() - 20usize];
    ["Alignment of MYSQL_PLUGIN_VIO"][::std::mem::align_of::<MYSQL_PLUGIN_VIO>() - 4usize];
    ["Offset of field: MYSQL_PLUGIN_VIO::read_packet"]
        [::std::mem::offset_of!(MYSQL_PLUGIN_VIO, read_packet) - 0usize];
    ["Offset of field: MYSQL_PLUGIN_VIO::write_packet"]
        [::std::mem::offset_of!(MYSQL_PLUGIN_VIO, write_packet) - 4usize];
    ["Offset of field: MYSQL_PLUGIN_VIO::info"]
        [::std::mem::offset_of!(MYSQL_PLUGIN_VIO, info) - 8usize];
    ["Offset of field: MYSQL_PLUGIN_VIO::read_packet_nonblocking"]
        [::std::mem::offset_of!(MYSQL_PLUGIN_VIO, read_packet_nonblocking) - 12usize];
    ["Offset of field: MYSQL_PLUGIN_VIO::write_packet_nonblocking"]
        [::std::mem::offset_of!(MYSQL_PLUGIN_VIO, write_packet_nonblocking) - 16usize];
};
unsafe extern "C" {
    #[doc = "loads a plugin and initializes it\n\n@param mysql  MYSQL structure.\n@param name   a name of the plugin to load\n@param type   type of plugin that should be loaded, -1 to disable type check\n@param argc   number of arguments to pass to the plugin initialization\nfunction\n@param ...    arguments for the plugin initialization function\n\n@retval\na pointer to the loaded plugin, or NULL in case of a failure"]
    pub fn mysql_load_plugin(
        mysql: *mut MYSQL,
        name: *const ::std::os::raw::c_char,
        type_: ::std::os::raw::c_int,
        argc: ::std::os::raw::c_int,
        ...
    ) -> *mut st_mysql_client_plugin;
}
unsafe extern "C" {
    #[doc = "loads a plugin and initializes it, taking va_list as an argument\n\nThis is the same as mysql_load_plugin, but take va_list instead of\na list of arguments.\n\n@param mysql  MYSQL structure.\n@param name   a name of the plugin to load\n@param type   type of plugin that should be loaded, -1 to disable type check\n@param argc   number of arguments to pass to the plugin initialization\nfunction\n@param args   arguments for the plugin initialization function\n\n@retval\na pointer to the loaded plugin, or NULL in case of a failure"]
    pub fn mysql_load_plugin_v(
        mysql: *mut MYSQL,
        name: *const ::std::os::raw::c_char,
        type_: ::std::os::raw::c_int,
        argc: ::std::os::raw::c_int,
        args: va_list,
    ) -> *mut st_mysql_client_plugin;
}
unsafe extern "C" {
    #[doc = "finds an already loaded plugin by name, or loads it, if necessary\n\n@param mysql  MYSQL structure.\n@param name   a name of the plugin to load\n@param type   type of plugin that should be loaded\n\n@retval\na pointer to the plugin, or NULL in case of a failure"]
    pub fn mysql_client_find_plugin(
        mysql: *mut MYSQL,
        name: *const ::std::os::raw::c_char,
        type_: ::std::os::raw::c_int,
    ) -> *mut st_mysql_client_plugin;
}
unsafe extern "C" {
    #[doc = "adds a plugin structure to the list of loaded plugins\n\nThis is useful if an application has the necessary functionality\n(for example, a special load data handler) statically linked into\nthe application binary. It can use this function to register the plugin\ndirectly, avoiding the need to factor it out into a shared object.\n\n@param mysql  MYSQL structure. It is only used for error reporting\n@param plugin an st_mysql_client_plugin structure to register\n\n@retval\na pointer to the plugin, or NULL in case of a failure"]
    pub fn mysql_client_register_plugin(
        mysql: *mut MYSQL,
        plugin: *mut st_mysql_client_plugin,
    ) -> *mut st_mysql_client_plugin;
}
unsafe extern "C" {
    #[doc = "set plugin options\n\nCan be used to set extra options and affect behavior for a plugin.\nThis function may be called multiple times to set several options\n\n@param plugin an st_mysql_client_plugin structure\n@param option a string which specifies the option to set\n@param value  value for the option.\n\n@retval 0 on success, 1 in case of failure"]
    pub fn mysql_plugin_options(
        plugin: *mut st_mysql_client_plugin,
        option: *const ::std::os::raw::c_char,
        value: *const ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    #[doc = "get plugin options\n\nCan be used to get options from a plugin.\nThis function may be called multiple times to get several options\n\n@param plugin an st_mysql_client_plugin structure\n@param option a string which specifies the option to get\n@param[out] value  value for the option.\n\n@retval 0 on success, 1 in case of failure"]
    pub fn mysql_plugin_get_option(
        plugin: *mut st_mysql_client_plugin,
        option: *const ::std::os::raw::c_char,
        value: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
#[repr(i32)]
#[non_exhaustive]
#[doc = "@file include/mysql_time.h\nTime declarations shared between the server and client API:\nyou should not add anything to this header unless it's used\n(and hence should be visible) in mysql.h.\nIf you're looking for a place to add new time-related declaration,\nit's most likely my_time.h. See also \"C API Handling of Date\nand Time Values\" chapter in documentation."]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum enum_mysql_timestamp_type {
    MYSQL_TIMESTAMP_NONE = -2,
    MYSQL_TIMESTAMP_ERROR = -1,
    #[doc = " Stores year, month and day components."]
    MYSQL_TIMESTAMP_DATE = 0,
    #[doc = "Stores all date and time components.\nValue is in UTC for `TIMESTAMP` type.\nValue is in local time zone for `DATETIME` type."]
    MYSQL_TIMESTAMP_DATETIME = 1,
    #[doc = " Stores hour, minute, second and microsecond."]
    MYSQL_TIMESTAMP_TIME = 2,
    #[doc = "A temporary type for `DATETIME` or `TIMESTAMP` types equipped with time\nzone information. After the time zone information is reconciled, the type is\nconverted to MYSQL_TIMESTAMP_DATETIME."]
    MYSQL_TIMESTAMP_DATETIME_TZ = 3,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MYSQL_TIME {
    pub year: ::std::os::raw::c_uint,
    pub month: ::std::os::raw::c_uint,
    pub day: ::std::os::raw::c_uint,
    pub hour: ::std::os::raw::c_uint,
    pub minute: ::std::os::raw::c_uint,
    pub second: ::std::os::raw::c_uint,
    #[doc = "< microseconds"]
    pub second_part: ::std::os::raw::c_ulong,
    pub neg: bool,
    pub time_type: enum_mysql_timestamp_type,
    #[doc = " The time zone displacement, specified in seconds."]
    pub time_zone_displacement: ::std::os::raw::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of MYSQL_TIME"][::std::mem::size_of::<MYSQL_TIME>() - 40usize];
    ["Alignment of MYSQL_TIME"][::std::mem::align_of::<MYSQL_TIME>() - 4usize];
    ["Offset of field: MYSQL_TIME::year"][::std::mem::offset_of!(MYSQL_TIME, year) - 0usize];
    ["Offset of field: MYSQL_TIME::month"][::std::mem::offset_of!(MYSQL_TIME, month) - 4usize];
    ["Offset of field: MYSQL_TIME::day"][::std::mem::offset_of!(MYSQL_TIME, day) - 8usize];
    ["Offset of field: MYSQL_TIME::hour"][::std::mem::offset_of!(MYSQL_TIME, hour) - 12usize];
    ["Offset of field: MYSQL_TIME::minute"][::std::mem::offset_of!(MYSQL_TIME, minute) - 16usize];
    ["Offset of field: MYSQL_TIME::second"][::std::mem::offset_of!(MYSQL_TIME, second) - 20usize];
    ["Offset of field: MYSQL_TIME::second_part"]
        [::std::mem::offset_of!(MYSQL_TIME, second_part) - 24usize];
    ["Offset of field: MYSQL_TIME::neg"][::std::mem::offset_of!(MYSQL_TIME, neg) - 28usize];
    ["Offset of field: MYSQL_TIME::time_type"]
        [::std::mem::offset_of!(MYSQL_TIME, time_type) - 32usize];
    ["Offset of field: MYSQL_TIME::time_zone_displacement"]
        [::std::mem::offset_of!(MYSQL_TIME, time_zone_displacement) - 36usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MYSQL_FIELD {
    pub name: *mut ::std::os::raw::c_char,
    pub org_name: *mut ::std::os::raw::c_char,
    pub table: *mut ::std::os::raw::c_char,
    pub org_table: *mut ::std::os::raw::c_char,
    pub db: *mut ::std::os::raw::c_char,
    pub catalog: *mut ::std::os::raw::c_char,
    pub def: *mut ::std::os::raw::c_char,
    pub length: ::std::os::raw::c_ulong,
    pub max_length: ::std::os::raw::c_ulong,
    pub name_length: ::std::os::raw::c_uint,
    pub org_name_length: ::std::os::raw::c_uint,
    pub table_length: ::std::os::raw::c_uint,
    pub org_table_length: ::std::os::raw::c_uint,
    pub db_length: ::std::os::raw::c_uint,
    pub catalog_length: ::std::os::raw::c_uint,
    pub def_length: ::std::os::raw::c_uint,
    pub flags: ::std::os::raw::c_uint,
    pub decimals: ::std::os::raw::c_uint,
    pub charsetnr: ::std::os::raw::c_uint,
    pub type_: enum_field_types,
    pub extension: *mut ::std::os::raw::c_void,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of MYSQL_FIELD"][::std::mem::size_of::<MYSQL_FIELD>() - 84usize];
    ["Alignment of MYSQL_FIELD"][::std::mem::align_of::<MYSQL_FIELD>() - 4usize];
    ["Offset of field: MYSQL_FIELD::name"][::std::mem::offset_of!(MYSQL_FIELD, name) - 0usize];
    ["Offset of field: MYSQL_FIELD::org_name"]
        [::std::mem::offset_of!(MYSQL_FIELD, org_name) - 4usize];
    ["Offset of field: MYSQL_FIELD::table"][::std::mem::offset_of!(MYSQL_FIELD, table) - 8usize];
    ["Offset of field: MYSQL_FIELD::org_table"]
        [::std::mem::offset_of!(MYSQL_FIELD, org_table) - 12usize];
    ["Offset of field: MYSQL_FIELD::db"][::std::mem::offset_of!(MYSQL_FIELD, db) - 16usize];
    ["Offset of field: MYSQL_FIELD::catalog"]
        [::std::mem::offset_of!(MYSQL_FIELD, catalog) - 20usize];
    ["Offset of field: MYSQL_FIELD::def"][::std::mem::offset_of!(MYSQL_FIELD, def) - 24usize];
    ["Offset of field: MYSQL_FIELD::length"][::std::mem::offset_of!(MYSQL_FIELD, length) - 28usize];
    ["Offset of field: MYSQL_FIELD::max_length"]
        [::std::mem::offset_of!(MYSQL_FIELD, max_length) - 32usize];
    ["Offset of field: MYSQL_FIELD::name_length"]
        [::std::mem::offset_of!(MYSQL_FIELD, name_length) - 36usize];
    ["Offset of field: MYSQL_FIELD::org_name_length"]
        [::std::mem::offset_of!(MYSQL_FIELD, org_name_length) - 40usize];
    ["Offset of field: MYSQL_FIELD::table_length"]
        [::std::mem::offset_of!(MYSQL_FIELD, table_length) - 44usize];
    ["Offset of field: MYSQL_FIELD::org_table_length"]
        [::std::mem::offset_of!(MYSQL_FIELD, org_table_length) - 48usize];
    ["Offset of field: MYSQL_FIELD::db_length"]
        [::std::mem::offset_of!(MYSQL_FIELD, db_length) - 52usize];
    ["Offset of field: MYSQL_FIELD::catalog_length"]
        [::std::mem::offset_of!(MYSQL_FIELD, catalog_length) - 56usize];
    ["Offset of field: MYSQL_FIELD::def_length"]
        [::std::mem::offset_of!(MYSQL_FIELD, def_length) - 60usize];
    ["Offset of field: MYSQL_FIELD::flags"][::std::mem::offset_of!(MYSQL_FIELD, flags) - 64usize];
    ["Offset of field: MYSQL_FIELD::decimals"]
        [::std::mem::offset_of!(MYSQL_FIELD, decimals) - 68usize];
    ["Offset of field: MYSQL_FIELD::charsetnr"]
        [::std::mem::offset_of!(MYSQL_FIELD, charsetnr) - 72usize];
    ["Offset of field: MYSQL_FIELD::type_"][::std::mem::offset_of!(MYSQL_FIELD, type_) - 76usize];
    ["Offset of field: MYSQL_FIELD::extension"]
        [::std::mem::offset_of!(MYSQL_FIELD, extension) - 80usize];
};
pub type MYSQL_ROW = *mut *mut ::std::os::raw::c_char;
pub type MYSQL_FIELD_OFFSET = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MYSQL_ROWS {
    pub next: *mut MYSQL_ROWS,
    pub data: MYSQL_ROW,
    pub length: ::std::os::raw::c_ulong,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of MYSQL_ROWS"][::std::mem::size_of::<MYSQL_ROWS>() - 12usize];
    ["Alignment of MYSQL_ROWS"][::std::mem::align_of::<MYSQL_ROWS>() - 4usize];
    ["Offset of field: MYSQL_ROWS::next"][::std::mem::offset_of!(MYSQL_ROWS, next) - 0usize];
    ["Offset of field: MYSQL_ROWS::data"][::std::mem::offset_of!(MYSQL_ROWS, data) - 4usize];
    ["Offset of field: MYSQL_ROWS::length"][::std::mem::offset_of!(MYSQL_ROWS, length) - 8usize];
};
pub type MYSQL_ROW_OFFSET = *mut MYSQL_ROWS;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MEM_ROOT {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MYSQL_DATA {
    pub data: *mut MYSQL_ROWS,
    pub alloc: *mut MEM_ROOT,
    pub rows: u64,
    pub fields: ::std::os::raw::c_uint,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of MYSQL_DATA"][::std::mem::size_of::<MYSQL_DATA>() - 24usize];
    ["Alignment of MYSQL_DATA"][::std::mem::align_of::<MYSQL_DATA>() - 8usize];
    ["Offset of field: MYSQL_DATA::data"][::std::mem::offset_of!(MYSQL_DATA, data) - 0usize];
    ["Offset of field: MYSQL_DATA::alloc"][::std::mem::offset_of!(MYSQL_DATA, alloc) - 4usize];
    ["Offset of field: MYSQL_DATA::rows"][::std::mem::offset_of!(MYSQL_DATA, rows) - 8usize];
    ["Offset of field: MYSQL_DATA::fields"][::std::mem::offset_of!(MYSQL_DATA, fields) - 16usize];
};
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum mysql_option {
    MYSQL_OPT_CONNECT_TIMEOUT = 0,
    MYSQL_OPT_COMPRESS = 1,
    MYSQL_OPT_NAMED_PIPE = 2,
    MYSQL_INIT_COMMAND = 3,
    MYSQL_READ_DEFAULT_FILE = 4,
    MYSQL_READ_DEFAULT_GROUP = 5,
    MYSQL_SET_CHARSET_DIR = 6,
    MYSQL_SET_CHARSET_NAME = 7,
    MYSQL_OPT_LOCAL_INFILE = 8,
    MYSQL_OPT_PROTOCOL = 9,
    MYSQL_SHARED_MEMORY_BASE_NAME = 10,
    MYSQL_OPT_READ_TIMEOUT = 11,
    MYSQL_OPT_WRITE_TIMEOUT = 12,
    MYSQL_OPT_USE_RESULT = 13,
    MYSQL_REPORT_DATA_TRUNCATION = 14,
    MYSQL_OPT_RECONNECT = 15,
    MYSQL_PLUGIN_DIR = 16,
    MYSQL_DEFAULT_AUTH = 17,
    MYSQL_OPT_BIND = 18,
    MYSQL_OPT_SSL_KEY = 19,
    MYSQL_OPT_SSL_CERT = 20,
    MYSQL_OPT_SSL_CA = 21,
    MYSQL_OPT_SSL_CAPATH = 22,
    MYSQL_OPT_SSL_CIPHER = 23,
    MYSQL_OPT_SSL_CRL = 24,
    MYSQL_OPT_SSL_CRLPATH = 25,
    MYSQL_OPT_CONNECT_ATTR_RESET = 26,
    MYSQL_OPT_CONNECT_ATTR_ADD = 27,
    MYSQL_OPT_CONNECT_ATTR_DELETE = 28,
    MYSQL_SERVER_PUBLIC_KEY = 29,
    MYSQL_ENABLE_CLEARTEXT_PLUGIN = 30,
    MYSQL_OPT_CAN_HANDLE_EXPIRED_PASSWORDS = 31,
    MYSQL_OPT_MAX_ALLOWED_PACKET = 32,
    MYSQL_OPT_NET_BUFFER_LENGTH = 33,
    MYSQL_OPT_TLS_VERSION = 34,
    MYSQL_OPT_SSL_MODE = 35,
    MYSQL_OPT_GET_SERVER_PUBLIC_KEY = 36,
    MYSQL_OPT_RETRY_COUNT = 37,
    MYSQL_OPT_OPTIONAL_RESULTSET_METADATA = 38,
    MYSQL_OPT_SSL_FIPS_MODE = 39,
    MYSQL_OPT_TLS_CIPHERSUITES = 40,
    MYSQL_OPT_COMPRESSION_ALGORITHMS = 41,
    MYSQL_OPT_ZSTD_COMPRESSION_LEVEL = 42,
    MYSQL_OPT_LOAD_DATA_LOCAL_DIR = 43,
    MYSQL_OPT_USER_PASSWORD = 44,
    MYSQL_OPT_SSL_SESSION_DATA = 45,
    MYSQL_OPT_TLS_SNI_SERVERNAME = 46,
}
#[doc = "@todo remove the \"extension\", move st_mysql_options completely\nout of mysql.h"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct st_mysql_options_extention {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct st_mysql_options {
    pub connect_timeout: ::std::os::raw::c_uint,
    pub read_timeout: ::std::os::raw::c_uint,
    pub write_timeout: ::std::os::raw::c_uint,
    pub port: ::std::os::raw::c_uint,
    pub protocol: ::std::os::raw::c_uint,
    pub client_flag: ::std::os::raw::c_ulong,
    pub host: *mut ::std::os::raw::c_char,
    pub user: *mut ::std::os::raw::c_char,
    pub password: *mut ::std::os::raw::c_char,
    pub unix_socket: *mut ::std::os::raw::c_char,
    pub db: *mut ::std::os::raw::c_char,
    pub init_commands: *mut Init_commands_array,
    pub my_cnf_file: *mut ::std::os::raw::c_char,
    pub my_cnf_group: *mut ::std::os::raw::c_char,
    pub charset_dir: *mut ::std::os::raw::c_char,
    pub charset_name: *mut ::std::os::raw::c_char,
    pub ssl_key: *mut ::std::os::raw::c_char,
    pub ssl_cert: *mut ::std::os::raw::c_char,
    pub ssl_ca: *mut ::std::os::raw::c_char,
    pub ssl_capath: *mut ::std::os::raw::c_char,
    pub ssl_cipher: *mut ::std::os::raw::c_char,
    pub shared_memory_base_name: *mut ::std::os::raw::c_char,
    pub max_allowed_packet: ::std::os::raw::c_ulong,
    pub compress: bool,
    pub named_pipe: bool,
    #[doc = "The local address to bind when connecting to remote server."]
    pub bind_address: *mut ::std::os::raw::c_char,
    pub report_data_truncation: bool,
    pub local_infile_init: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut *mut ::std::os::raw::c_void,
            arg2: *const ::std::os::raw::c_char,
            arg3: *mut ::std::os::raw::c_void,
        ) -> ::std::os::raw::c_int,
    >,
    pub local_infile_read: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut ::std::os::raw::c_void,
            arg2: *mut ::std::os::raw::c_char,
            arg3: ::std::os::raw::c_uint,
        ) -> ::std::os::raw::c_int,
    >,
    pub local_infile_end:
        ::std::option::Option<unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void)>,
    pub local_infile_error: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut ::std::os::raw::c_void,
            arg2: *mut ::std::os::raw::c_char,
            arg3: ::std::os::raw::c_uint,
        ) -> ::std::os::raw::c_int,
    >,
    pub local_infile_userdata: *mut ::std::os::raw::c_void,
    pub extension: *mut st_mysql_options_extention,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of st_mysql_options"][::std::mem::size_of::<st_mysql_options>() - 128usize];
    ["Alignment of st_mysql_options"][::std::mem::align_of::<st_mysql_options>() - 4usize];
    ["Offset of field: st_mysql_options::connect_timeout"]
        [::std::mem::offset_of!(st_mysql_options, connect_timeout) - 0usize];
    ["Offset of field: st_mysql_options::read_timeout"]
        [::std::mem::offset_of!(st_mysql_options, read_timeout) - 4usize];
    ["Offset of field: st_mysql_options::write_timeout"]
        [::std::mem::offset_of!(st_mysql_options, write_timeout) - 8usize];
    ["Offset of field: st_mysql_options::port"]
        [::std::mem::offset_of!(st_mysql_options, port) - 12usize];
    ["Offset of field: st_mysql_options::protocol"]
        [::std::mem::offset_of!(st_mysql_options, protocol) - 16usize];
    ["Offset of field: st_mysql_options::client_flag"]
        [::std::mem::offset_of!(st_mysql_options, client_flag) - 20usize];
    ["Offset of field: st_mysql_options::host"]
        [::std::mem::offset_of!(st_mysql_options, host) - 24usize];
    ["Offset of field: st_mysql_options::user"]
        [::std::mem::offset_of!(st_mysql_options, user) - 28usize];
    ["Offset of field: st_mysql_options::password"]
        [::std::mem::offset_of!(st_mysql_options, password) - 32usize];
    ["Offset of field: st_mysql_options::unix_socket"]
        [::std::mem::offset_of!(st_mysql_options, unix_socket) - 36usize];
    ["Offset of field: st_mysql_options::db"]
        [::std::mem::offset_of!(st_mysql_options, db) - 40usize];
    ["Offset of field: st_mysql_options::init_commands"]
        [::std::mem::offset_of!(st_mysql_options, init_commands) - 44usize];
    ["Offset of field: st_mysql_options::my_cnf_file"]
        [::std::mem::offset_of!(st_mysql_options, my_cnf_file) - 48usize];
    ["Offset of field: st_mysql_options::my_cnf_group"]
        [::std::mem::offset_of!(st_mysql_options, my_cnf_group) - 52usize];
    ["Offset of field: st_mysql_options::charset_dir"]
        [::std::mem::offset_of!(st_mysql_options, charset_dir) - 56usize];
    ["Offset of field: st_mysql_options::charset_name"]
        [::std::mem::offset_of!(st_mysql_options, charset_name) - 60usize];
    ["Offset of field: st_mysql_options::ssl_key"]
        [::std::mem::offset_of!(st_mysql_options, ssl_key) - 64usize];
    ["Offset of field: st_mysql_options::ssl_cert"]
        [::std::mem::offset_of!(st_mysql_options, ssl_cert) - 68usize];
    ["Offset of field: st_mysql_options::ssl_ca"]
        [::std::mem::offset_of!(st_mysql_options, ssl_ca) - 72usize];
    ["Offset of field: st_mysql_options::ssl_capath"]
        [::std::mem::offset_of!(st_mysql_options, ssl_capath) - 76usize];
    ["Offset of field: st_mysql_options::ssl_cipher"]
        [::std::mem::offset_of!(st_mysql_options, ssl_cipher) - 80usize];
    ["Offset of field: st_mysql_options::shared_memory_base_name"]
        [::std::mem::offset_of!(st_mysql_options, shared_memory_base_name) - 84usize];
    ["Offset of field: st_mysql_options::max_allowed_packet"]
        [::std::mem::offset_of!(st_mysql_options, max_allowed_packet) - 88usize];
    ["Offset of field: st_mysql_options::compress"]
        [::std::mem::offset_of!(st_mysql_options, compress) - 92usize];
    ["Offset of field: st_mysql_options::named_pipe"]
        [::std::mem::offset_of!(st_mysql_options, named_pipe) - 93usize];
    ["Offset of field: st_mysql_options::bind_address"]
        [::std::mem::offset_of!(st_mysql_options, bind_address) - 96usize];
    ["Offset of field: st_mysql_options::report_data_truncation"]
        [::std::mem::offset_of!(st_mysql_options, report_data_truncation) - 100usize];
    ["Offset of field: st_mysql_options::local_infile_init"]
        [::std::mem::offset_of!(st_mysql_options, local_infile_init) - 104usize];
    ["Offset of field: st_mysql_options::local_infile_read"]
        [::std::mem::offset_of!(st_mysql_options, local_infile_read) - 108usize];
    ["Offset of field: st_mysql_options::local_infile_end"]
        [::std::mem::offset_of!(st_mysql_options, local_infile_end) - 112usize];
    ["Offset of field: st_mysql_options::local_infile_error"]
        [::std::mem::offset_of!(st_mysql_options, local_infile_error) - 116usize];
    ["Offset of field: st_mysql_options::local_infile_userdata"]
        [::std::mem::offset_of!(st_mysql_options, local_infile_userdata) - 120usize];
    ["Offset of field: st_mysql_options::extension"]
        [::std::mem::offset_of!(st_mysql_options, extension) - 124usize];
};
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum mysql_status {
    MYSQL_STATUS_READY = 0,
    MYSQL_STATUS_GET_RESULT = 1,
    MYSQL_STATUS_USE_RESULT = 2,
    MYSQL_STATUS_STATEMENT_GET_RESULT = 3,
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum mysql_protocol_type {
    MYSQL_PROTOCOL_DEFAULT = 0,
    MYSQL_PROTOCOL_TCP = 1,
    MYSQL_PROTOCOL_SOCKET = 2,
    MYSQL_PROTOCOL_PIPE = 3,
    MYSQL_PROTOCOL_MEMORY = 4,
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum mysql_ssl_mode {
    SSL_MODE_DISABLED = 1,
    SSL_MODE_PREFERRED = 2,
    SSL_MODE_REQUIRED = 3,
    SSL_MODE_VERIFY_CA = 4,
    SSL_MODE_VERIFY_IDENTITY = 5,
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum mysql_ssl_fips_mode {
    SSL_FIPS_MODE_OFF = 0,
    SSL_FIPS_MODE_ON = 1,
    SSL_FIPS_MODE_STRICT = 2,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct character_set {
    pub number: ::std::os::raw::c_uint,
    pub state: ::std::os::raw::c_uint,
    pub csname: *const ::std::os::raw::c_char,
    pub name: *const ::std::os::raw::c_char,
    pub comment: *const ::std::os::raw::c_char,
    pub dir: *const ::std::os::raw::c_char,
    pub mbminlen: ::std::os::raw::c_uint,
    pub mbmaxlen: ::std::os::raw::c_uint,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of character_set"][::std::mem::size_of::<character_set>() - 32usize];
    ["Alignment of character_set"][::std::mem::align_of::<character_set>() - 4usize];
    ["Offset of field: character_set::number"]
        [::std::mem::offset_of!(character_set, number) - 0usize];
    ["Offset of field: character_set::state"]
        [::std::mem::offset_of!(character_set, state) - 4usize];
    ["Offset of field: character_set::csname"]
        [::std::mem::offset_of!(character_set, csname) - 8usize];
    ["Offset of field: character_set::name"][::std::mem::offset_of!(character_set, name) - 12usize];
    ["Offset of field: character_set::comment"]
        [::std::mem::offset_of!(character_set, comment) - 16usize];
    ["Offset of field: character_set::dir"][::std::mem::offset_of!(character_set, dir) - 20usize];
    ["Offset of field: character_set::mbminlen"]
        [::std::mem::offset_of!(character_set, mbminlen) - 24usize];
    ["Offset of field: character_set::mbmaxlen"]
        [::std::mem::offset_of!(character_set, mbmaxlen) - 28usize];
};
pub type MY_CHARSET_INFO = character_set;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MYSQL_METHODS {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MYSQL {
    pub net: NET,
    pub connector_fd: *mut ::std::os::raw::c_uchar,
    pub host: *mut ::std::os::raw::c_char,
    pub user: *mut ::std::os::raw::c_char,
    pub passwd: *mut ::std::os::raw::c_char,
    pub unix_socket: *mut ::std::os::raw::c_char,
    pub server_version: *mut ::std::os::raw::c_char,
    pub host_info: *mut ::std::os::raw::c_char,
    pub info: *mut ::std::os::raw::c_char,
    pub db: *mut ::std::os::raw::c_char,
    pub charset: *mut CHARSET_INFO,
    pub fields: *mut MYSQL_FIELD,
    pub field_alloc: *mut MEM_ROOT,
    pub affected_rows: u64,
    pub insert_id: u64,
    pub extra_info: u64,
    pub thread_id: ::std::os::raw::c_ulong,
    pub packet_length: ::std::os::raw::c_ulong,
    pub port: ::std::os::raw::c_uint,
    pub client_flag: ::std::os::raw::c_ulong,
    pub server_capabilities: ::std::os::raw::c_ulong,
    pub protocol_version: ::std::os::raw::c_uint,
    pub field_count: ::std::os::raw::c_uint,
    pub server_status: ::std::os::raw::c_uint,
    pub server_language: ::std::os::raw::c_uint,
    pub warning_count: ::std::os::raw::c_uint,
    pub options: st_mysql_options,
    pub status: mysql_status,
    pub resultset_metadata: enum_resultset_metadata,
    pub free_me: bool,
    pub reconnect: bool,
    pub scramble: [::std::os::raw::c_char; 21usize],
    pub stmts: *mut LIST,
    pub methods: *const MYSQL_METHODS,
    pub thd: *mut ::std::os::raw::c_void,
    pub unbuffered_fetch_owner: *mut bool,
    pub extension: *mut ::std::os::raw::c_void,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of MYSQL"][::std::mem::size_of::<MYSQL>() - 904usize];
    ["Alignment of MYSQL"][::std::mem::align_of::<MYSQL>() - 8usize];
    ["Offset of field: MYSQL::net"][::std::mem::offset_of!(MYSQL, net) - 0usize];
    ["Offset of field: MYSQL::connector_fd"]
        [::std::mem::offset_of!(MYSQL, connector_fd) - 608usize];
    ["Offset of field: MYSQL::host"][::std::mem::offset_of!(MYSQL, host) - 612usize];
    ["Offset of field: MYSQL::user"][::std::mem::offset_of!(MYSQL, user) - 616usize];
    ["Offset of field: MYSQL::passwd"][::std::mem::offset_of!(MYSQL, passwd) - 620usize];
    ["Offset of field: MYSQL::unix_socket"][::std::mem::offset_of!(MYSQL, unix_socket) - 624usize];
    ["Offset of field: MYSQL::server_version"]
        [::std::mem::offset_of!(MYSQL, server_version) - 628usize];
    ["Offset of field: MYSQL::host_info"][::std::mem::offset_of!(MYSQL, host_info) - 632usize];
    ["Offset of field: MYSQL::info"][::std::mem::offset_of!(MYSQL, info) - 636usize];
    ["Offset of field: MYSQL::db"][::std::mem::offset_of!(MYSQL, db) - 640usize];
    ["Offset of field: MYSQL::charset"][::std::mem::offset_of!(MYSQL, charset) - 644usize];
    ["Offset of field: MYSQL::fields"][::std::mem::offset_of!(MYSQL, fields) - 648usize];
    ["Offset of field: MYSQL::field_alloc"][::std::mem::offset_of!(MYSQL, field_alloc) - 652usize];
    ["Offset of field: MYSQL::affected_rows"]
        [::std::mem::offset_of!(MYSQL, affected_rows) - 656usize];
    ["Offset of field: MYSQL::insert_id"][::std::mem::offset_of!(MYSQL, insert_id) - 664usize];
    ["Offset of field: MYSQL::extra_info"][::std::mem::offset_of!(MYSQL, extra_info) - 672usize];
    ["Offset of field: MYSQL::thread_id"][::std::mem::offset_of!(MYSQL, thread_id) - 680usize];
    ["Offset of field: MYSQL::packet_length"]
        [::std::mem::offset_of!(MYSQL, packet_length) - 684usize];
    ["Offset of field: MYSQL::port"][::std::mem::offset_of!(MYSQL, port) - 688usize];
    ["Offset of field: MYSQL::client_flag"][::std::mem::offset_of!(MYSQL, client_flag) - 692usize];
    ["Offset of field: MYSQL::server_capabilities"]
        [::std::mem::offset_of!(MYSQL, server_capabilities) - 696usize];
    ["Offset of field: MYSQL::protocol_version"]
        [::std::mem::offset_of!(MYSQL, protocol_version) - 700usize];
    ["Offset of field: MYSQL::field_count"][::std::mem::offset_of!(MYSQL, field_count) - 704usize];
    ["Offset of field: MYSQL::server_status"]
        [::std::mem::offset_of!(MYSQL, server_status) - 708usize];
    ["Offset of field: MYSQL::server_language"]
        [::std::mem::offset_of!(MYSQL, server_language) - 712usize];
    ["Offset of field: MYSQL::warning_count"]
        [::std::mem::offset_of!(MYSQL, warning_count) - 716usize];
    ["Offset of field: MYSQL::options"][::std::mem::offset_of!(MYSQL, options) - 720usize];
    ["Offset of field: MYSQL::status"][::std::mem::offset_of!(MYSQL, status) - 848usize];
    ["Offset of field: MYSQL::resultset_metadata"]
        [::std::mem::offset_of!(MYSQL, resultset_metadata) - 852usize];
    ["Offset of field: MYSQL::free_me"][::std::mem::offset_of!(MYSQL, free_me) - 856usize];
    ["Offset of field: MYSQL::reconnect"][::std::mem::offset_of!(MYSQL, reconnect) - 857usize];
    ["Offset of field: MYSQL::scramble"][::std::mem::offset_of!(MYSQL, scramble) - 858usize];
    ["Offset of field: MYSQL::stmts"][::std::mem::offset_of!(MYSQL, stmts) - 880usize];
    ["Offset of field: MYSQL::methods"][::std::mem::offset_of!(MYSQL, methods) - 884usize];
    ["Offset of field: MYSQL::thd"][::std::mem::offset_of!(MYSQL, thd) - 888usize];
    ["Offset of field: MYSQL::unbuffered_fetch_owner"]
        [::std::mem::offset_of!(MYSQL, unbuffered_fetch_owner) - 892usize];
    ["Offset of field: MYSQL::extension"][::std::mem::offset_of!(MYSQL, extension) - 896usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MYSQL_RES {
    pub row_count: u64,
    pub fields: *mut MYSQL_FIELD,
    pub data: *mut MYSQL_DATA,
    pub data_cursor: *mut MYSQL_ROWS,
    pub lengths: *mut ::std::os::raw::c_ulong,
    pub handle: *mut MYSQL,
    pub methods: *const MYSQL_METHODS,
    pub row: MYSQL_ROW,
    pub current_row: MYSQL_ROW,
    pub field_alloc: *mut MEM_ROOT,
    pub field_count: ::std::os::raw::c_uint,
    pub current_field: ::std::os::raw::c_uint,
    pub eof: bool,
    pub unbuffered_fetch_cancelled: bool,
    pub metadata: enum_resultset_metadata,
    pub extension: *mut ::std::os::raw::c_void,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of MYSQL_RES"][::std::mem::size_of::<MYSQL_RES>() - 64usize];
    ["Alignment of MYSQL_RES"][::std::mem::align_of::<MYSQL_RES>() - 8usize];
    ["Offset of field: MYSQL_RES::row_count"]
        [::std::mem::offset_of!(MYSQL_RES, row_count) - 0usize];
    ["Offset of field: MYSQL_RES::fields"][::std::mem::offset_of!(MYSQL_RES, fields) - 8usize];
    ["Offset of field: MYSQL_RES::data"][::std::mem::offset_of!(MYSQL_RES, data) - 12usize];
    ["Offset of field: MYSQL_RES::data_cursor"]
        [::std::mem::offset_of!(MYSQL_RES, data_cursor) - 16usize];
    ["Offset of field: MYSQL_RES::lengths"][::std::mem::offset_of!(MYSQL_RES, lengths) - 20usize];
    ["Offset of field: MYSQL_RES::handle"][::std::mem::offset_of!(MYSQL_RES, handle) - 24usize];
    ["Offset of field: MYSQL_RES::methods"][::std::mem::offset_of!(MYSQL_RES, methods) - 28usize];
    ["Offset of field: MYSQL_RES::row"][::std::mem::offset_of!(MYSQL_RES, row) - 32usize];
    ["Offset of field: MYSQL_RES::current_row"]
        [::std::mem::offset_of!(MYSQL_RES, current_row) - 36usize];
    ["Offset of field: MYSQL_RES::field_alloc"]
        [::std::mem::offset_of!(MYSQL_RES, field_alloc) - 40usize];
    ["Offset of field: MYSQL_RES::field_count"]
        [::std::mem::offset_of!(MYSQL_RES, field_count) - 44usize];
    ["Offset of field: MYSQL_RES::current_field"]
        [::std::mem::offset_of!(MYSQL_RES, current_field) - 48usize];
    ["Offset of field: MYSQL_RES::eof"][::std::mem::offset_of!(MYSQL_RES, eof) - 52usize];
    ["Offset of field: MYSQL_RES::unbuffered_fetch_cancelled"]
        [::std::mem::offset_of!(MYSQL_RES, unbuffered_fetch_cancelled) - 53usize];
    ["Offset of field: MYSQL_RES::metadata"][::std::mem::offset_of!(MYSQL_RES, metadata) - 56usize];
    ["Offset of field: MYSQL_RES::extension"]
        [::std::mem::offset_of!(MYSQL_RES, extension) - 60usize];
};
#[doc = "Struct for information about a replication stream.\n\n@sa mysql_binlog_open()\n@sa mysql_binlog_fetch()\n@sa mysql_binlog_close()"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MYSQL_RPL {
    pub file_name_length: usize,
    #[doc = " Length of the 'file_name' or 0"]
    pub file_name: *const ::std::os::raw::c_char,
    #[doc = " Filename of the binary log to read"]
    pub start_position: u64,
    #[doc = " Position in the binary log to"]
    pub server_id: ::std::os::raw::c_uint,
    #[doc = " Server ID to use when identifying"]
    pub flags: ::std::os::raw::c_uint,
    #[doc = " Size of gtid set data"]
    pub gtid_set_encoded_size: usize,
    pub fix_gtid_set: ::std::option::Option<
        unsafe extern "C" fn(rpl: *mut MYSQL_RPL, packet_gtid_set: *mut ::std::os::raw::c_uchar),
    >,
    pub gtid_set_arg: *mut ::std::os::raw::c_void,
    #[doc = " GTID set data or an argument for"]
    pub size: ::std::os::raw::c_ulong,
    #[doc = " Size of the packet returned by"]
    pub buffer: *const ::std::os::raw::c_uchar,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of MYSQL_RPL"][::std::mem::size_of::<MYSQL_RPL>() - 48usize];
    ["Alignment of MYSQL_RPL"][::std::mem::align_of::<MYSQL_RPL>() - 8usize];
    ["Offset of field: MYSQL_RPL::file_name_length"]
        [::std::mem::offset_of!(MYSQL_RPL, file_name_length) - 0usize];
    ["Offset of field: MYSQL_RPL::file_name"]
        [::std::mem::offset_of!(MYSQL_RPL, file_name) - 4usize];
    ["Offset of field: MYSQL_RPL::start_position"]
        [::std::mem::offset_of!(MYSQL_RPL, start_position) - 8usize];
    ["Offset of field: MYSQL_RPL::server_id"]
        [::std::mem::offset_of!(MYSQL_RPL, server_id) - 16usize];
    ["Offset of field: MYSQL_RPL::flags"][::std::mem::offset_of!(MYSQL_RPL, flags) - 20usize];
    ["Offset of field: MYSQL_RPL::gtid_set_encoded_size"]
        [::std::mem::offset_of!(MYSQL_RPL, gtid_set_encoded_size) - 24usize];
    ["Offset of field: MYSQL_RPL::fix_gtid_set"]
        [::std::mem::offset_of!(MYSQL_RPL, fix_gtid_set) - 28usize];
    ["Offset of field: MYSQL_RPL::gtid_set_arg"]
        [::std::mem::offset_of!(MYSQL_RPL, gtid_set_arg) - 32usize];
    ["Offset of field: MYSQL_RPL::size"][::std::mem::offset_of!(MYSQL_RPL, size) - 36usize];
    ["Offset of field: MYSQL_RPL::buffer"][::std::mem::offset_of!(MYSQL_RPL, buffer) - 40usize];
};
unsafe extern "stdcall" {
    pub fn mysql_server_init(
        argc: ::std::os::raw::c_int,
        argv: *mut *mut ::std::os::raw::c_char,
        groups: *mut *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "stdcall" {
    pub fn mysql_server_end();
}
unsafe extern "stdcall" {
    pub fn mysql_thread_init() -> bool;
}
unsafe extern "stdcall" {
    pub fn mysql_thread_end();
}
unsafe extern "stdcall" {
    pub fn mysql_num_rows(res: *mut MYSQL_RES) -> u64;
}
unsafe extern "stdcall" {
    pub fn mysql_num_fields(res: *mut MYSQL_RES) -> ::std::os::raw::c_uint;
}
unsafe extern "stdcall" {
    pub fn mysql_eof(res: *mut MYSQL_RES) -> bool;
}
unsafe extern "stdcall" {
    pub fn mysql_fetch_field_direct(
        res: *mut MYSQL_RES,
        fieldnr: ::std::os::raw::c_uint,
    ) -> *mut MYSQL_FIELD;
}
unsafe extern "stdcall" {
    pub fn mysql_fetch_fields(res: *mut MYSQL_RES) -> *mut MYSQL_FIELD;
}
unsafe extern "stdcall" {
    pub fn mysql_row_tell(res: *mut MYSQL_RES) -> MYSQL_ROW_OFFSET;
}
unsafe extern "stdcall" {
    pub fn mysql_field_tell(res: *mut MYSQL_RES) -> MYSQL_FIELD_OFFSET;
}
unsafe extern "stdcall" {
    pub fn mysql_result_metadata(result: *mut MYSQL_RES) -> enum_resultset_metadata;
}
unsafe extern "stdcall" {
    pub fn mysql_field_count(mysql: *mut MYSQL) -> ::std::os::raw::c_uint;
}
unsafe extern "stdcall" {
    pub fn mysql_affected_rows(mysql: *mut MYSQL) -> u64;
}
unsafe extern "stdcall" {
    pub fn mysql_insert_id(mysql: *mut MYSQL) -> u64;
}
unsafe extern "stdcall" {
    pub fn mysql_errno(mysql: *mut MYSQL) -> ::std::os::raw::c_uint;
}
unsafe extern "stdcall" {
    pub fn mysql_error(mysql: *mut MYSQL) -> *const ::std::os::raw::c_char;
}
unsafe extern "stdcall" {
    pub fn mysql_sqlstate(mysql: *mut MYSQL) -> *const ::std::os::raw::c_char;
}
unsafe extern "stdcall" {
    pub fn mysql_warning_count(mysql: *mut MYSQL) -> ::std::os::raw::c_uint;
}
unsafe extern "stdcall" {
    pub fn mysql_info(mysql: *mut MYSQL) -> *const ::std::os::raw::c_char;
}
unsafe extern "stdcall" {
    pub fn mysql_thread_id(mysql: *mut MYSQL) -> ::std::os::raw::c_ulong;
}
unsafe extern "stdcall" {
    pub fn mysql_character_set_name(mysql: *mut MYSQL) -> *const ::std::os::raw::c_char;
}
unsafe extern "stdcall" {
    pub fn mysql_set_character_set(
        mysql: *mut MYSQL,
        csname: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "stdcall" {
    pub fn mysql_init(mysql: *mut MYSQL) -> *mut MYSQL;
}
unsafe extern "stdcall" {
    pub fn mysql_ssl_set(
        mysql: *mut MYSQL,
        key: *const ::std::os::raw::c_char,
        cert: *const ::std::os::raw::c_char,
        ca: *const ::std::os::raw::c_char,
        capath: *const ::std::os::raw::c_char,
        cipher: *const ::std::os::raw::c_char,
    ) -> bool;
}
unsafe extern "stdcall" {
    pub fn mysql_get_ssl_cipher(mysql: *mut MYSQL) -> *const ::std::os::raw::c_char;
}
unsafe extern "stdcall" {
    pub fn mysql_get_ssl_session_reused(mysql: *mut MYSQL) -> bool;
}
unsafe extern "stdcall" {
    pub fn mysql_get_ssl_session_data(
        mysql: *mut MYSQL,
        n_ticket: ::std::os::raw::c_uint,
        out_len: *mut ::std::os::raw::c_uint,
    ) -> *mut ::std::os::raw::c_void;
}
unsafe extern "stdcall" {
    pub fn mysql_free_ssl_session_data(
        mysql: *mut MYSQL,
        data: *mut ::std::os::raw::c_void,
    ) -> bool;
}
unsafe extern "stdcall" {
    pub fn mysql_change_user(
        mysql: *mut MYSQL,
        user: *const ::std::os::raw::c_char,
        passwd: *const ::std::os::raw::c_char,
        db: *const ::std::os::raw::c_char,
    ) -> bool;
}
unsafe extern "stdcall" {
    pub fn mysql_real_connect(
        mysql: *mut MYSQL,
        host: *const ::std::os::raw::c_char,
        user: *const ::std::os::raw::c_char,
        passwd: *const ::std::os::raw::c_char,
        db: *const ::std::os::raw::c_char,
        port: ::std::os::raw::c_uint,
        unix_socket: *const ::std::os::raw::c_char,
        clientflag: ::std::os::raw::c_ulong,
    ) -> *mut MYSQL;
}
unsafe extern "stdcall" {
    pub fn mysql_select_db(
        mysql: *mut MYSQL,
        db: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "stdcall" {
    pub fn mysql_query(
        mysql: *mut MYSQL,
        q: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "stdcall" {
    pub fn mysql_send_query(
        mysql: *mut MYSQL,
        q: *const ::std::os::raw::c_char,
        length: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "stdcall" {
    pub fn mysql_real_query(
        mysql: *mut MYSQL,
        q: *const ::std::os::raw::c_char,
        length: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "stdcall" {
    pub fn mysql_store_result(mysql: *mut MYSQL) -> *mut MYSQL_RES;
}
unsafe extern "stdcall" {
    pub fn mysql_use_result(mysql: *mut MYSQL) -> *mut MYSQL_RES;
}
unsafe extern "stdcall" {
    pub fn mysql_real_connect_nonblocking(
        mysql: *mut MYSQL,
        host: *const ::std::os::raw::c_char,
        user: *const ::std::os::raw::c_char,
        passwd: *const ::std::os::raw::c_char,
        db: *const ::std::os::raw::c_char,
        port: ::std::os::raw::c_uint,
        unix_socket: *const ::std::os::raw::c_char,
        clientflag: ::std::os::raw::c_ulong,
    ) -> net_async_status;
}
unsafe extern "stdcall" {
    pub fn mysql_send_query_nonblocking(
        mysql: *mut MYSQL,
        query: *const ::std::os::raw::c_char,
        length: ::std::os::raw::c_ulong,
    ) -> net_async_status;
}
unsafe extern "stdcall" {
    pub fn mysql_real_query_nonblocking(
        mysql: *mut MYSQL,
        query: *const ::std::os::raw::c_char,
        length: ::std::os::raw::c_ulong,
    ) -> net_async_status;
}
unsafe extern "stdcall" {
    pub fn mysql_store_result_nonblocking(
        mysql: *mut MYSQL,
        result: *mut *mut MYSQL_RES,
    ) -> net_async_status;
}
unsafe extern "stdcall" {
    pub fn mysql_next_result_nonblocking(mysql: *mut MYSQL) -> net_async_status;
}
unsafe extern "stdcall" {
    pub fn mysql_select_db_nonblocking(
        mysql: *mut MYSQL,
        db: *const ::std::os::raw::c_char,
        error: *mut bool,
    ) -> net_async_status;
}
unsafe extern "stdcall" {
    pub fn mysql_get_character_set_info(mysql: *mut MYSQL, charset: *mut MY_CHARSET_INFO);
}
unsafe extern "stdcall" {
    pub fn mysql_session_track_get_first(
        mysql: *mut MYSQL,
        type_: enum_session_state_type,
        data: *mut *const ::std::os::raw::c_char,
        length: *mut usize,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "stdcall" {
    pub fn mysql_session_track_get_next(
        mysql: *mut MYSQL,
        type_: enum_session_state_type,
        data: *mut *const ::std::os::raw::c_char,
        length: *mut usize,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn mysql_set_local_infile_handler(
        mysql: *mut MYSQL,
        local_infile_init: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *mut *mut ::std::os::raw::c_void,
                arg2: *const ::std::os::raw::c_char,
                arg3: *mut ::std::os::raw::c_void,
            ) -> ::std::os::raw::c_int,
        >,
        local_infile_read: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *mut ::std::os::raw::c_void,
                arg2: *mut ::std::os::raw::c_char,
                arg3: ::std::os::raw::c_uint,
            ) -> ::std::os::raw::c_int,
        >,
        local_infile_end: ::std::option::Option<
            unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void),
        >,
        local_infile_error: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *mut ::std::os::raw::c_void,
                arg2: *mut ::std::os::raw::c_char,
                arg3: ::std::os::raw::c_uint,
            ) -> ::std::os::raw::c_int,
        >,
        arg1: *mut ::std::os::raw::c_void,
    );
}
unsafe extern "C" {
    pub fn mysql_set_local_infile_default(mysql: *mut MYSQL);
}
unsafe extern "stdcall" {
    pub fn mysql_shutdown(
        mysql: *mut MYSQL,
        shutdown_level: mysql_enum_shutdown_level,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "stdcall" {
    pub fn mysql_dump_debug_info(mysql: *mut MYSQL) -> ::std::os::raw::c_int;
}
unsafe extern "stdcall" {
    pub fn mysql_refresh(
        mysql: *mut MYSQL,
        refresh_options: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "stdcall" {
    pub fn mysql_kill(mysql: *mut MYSQL, pid: ::std::os::raw::c_ulong) -> ::std::os::raw::c_int;
}
unsafe extern "stdcall" {
    pub fn mysql_set_server_option(
        mysql: *mut MYSQL,
        option: enum_mysql_set_option,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "stdcall" {
    pub fn mysql_ping(mysql: *mut MYSQL) -> ::std::os::raw::c_int;
}
unsafe extern "stdcall" {
    pub fn mysql_stat(mysql: *mut MYSQL) -> *const ::std::os::raw::c_char;
}
unsafe extern "stdcall" {
    pub fn mysql_get_server_info(mysql: *mut MYSQL) -> *const ::std::os::raw::c_char;
}
unsafe extern "stdcall" {
    pub fn mysql_get_client_info() -> *const ::std::os::raw::c_char;
}
unsafe extern "stdcall" {
    pub fn mysql_get_client_version() -> ::std::os::raw::c_ulong;
}
unsafe extern "stdcall" {
    pub fn mysql_get_host_info(mysql: *mut MYSQL) -> *const ::std::os::raw::c_char;
}
unsafe extern "stdcall" {
    pub fn mysql_get_server_version(mysql: *mut MYSQL) -> ::std::os::raw::c_ulong;
}
unsafe extern "stdcall" {
    pub fn mysql_get_proto_info(mysql: *mut MYSQL) -> ::std::os::raw::c_uint;
}
unsafe extern "stdcall" {
    pub fn mysql_list_dbs(mysql: *mut MYSQL, wild: *const ::std::os::raw::c_char)
        -> *mut MYSQL_RES;
}
unsafe extern "stdcall" {
    pub fn mysql_list_tables(
        mysql: *mut MYSQL,
        wild: *const ::std::os::raw::c_char,
    ) -> *mut MYSQL_RES;
}
unsafe extern "stdcall" {
    pub fn mysql_list_processes(mysql: *mut MYSQL) -> *mut MYSQL_RES;
}
unsafe extern "stdcall" {
    pub fn mysql_options(
        mysql: *mut MYSQL,
        option: mysql_option,
        arg: *const ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "stdcall" {
    pub fn mysql_options4(
        mysql: *mut MYSQL,
        option: mysql_option,
        arg1: *const ::std::os::raw::c_void,
        arg2: *const ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "stdcall" {
    pub fn mysql_get_option(
        mysql: *mut MYSQL,
        option: mysql_option,
        arg: *const ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "stdcall" {
    pub fn mysql_free_result(result: *mut MYSQL_RES);
}
unsafe extern "stdcall" {
    pub fn mysql_free_result_nonblocking(result: *mut MYSQL_RES) -> net_async_status;
}
unsafe extern "stdcall" {
    pub fn mysql_data_seek(result: *mut MYSQL_RES, offset: u64);
}
unsafe extern "stdcall" {
    pub fn mysql_row_seek(result: *mut MYSQL_RES, offset: MYSQL_ROW_OFFSET) -> MYSQL_ROW_OFFSET;
}
unsafe extern "stdcall" {
    pub fn mysql_field_seek(
        result: *mut MYSQL_RES,
        offset: MYSQL_FIELD_OFFSET,
    ) -> MYSQL_FIELD_OFFSET;
}
unsafe extern "stdcall" {
    pub fn mysql_fetch_row(result: *mut MYSQL_RES) -> MYSQL_ROW;
}
unsafe extern "stdcall" {
    pub fn mysql_fetch_row_nonblocking(
        res: *mut MYSQL_RES,
        row: *mut MYSQL_ROW,
    ) -> net_async_status;
}
unsafe extern "stdcall" {
    pub fn mysql_fetch_lengths(result: *mut MYSQL_RES) -> *mut ::std::os::raw::c_ulong;
}
unsafe extern "stdcall" {
    pub fn mysql_fetch_field(result: *mut MYSQL_RES) -> *mut MYSQL_FIELD;
}
unsafe extern "stdcall" {
    pub fn mysql_list_fields(
        mysql: *mut MYSQL,
        table: *const ::std::os::raw::c_char,
        wild: *const ::std::os::raw::c_char,
    ) -> *mut MYSQL_RES;
}
unsafe extern "stdcall" {
    pub fn mysql_escape_string(
        to: *mut ::std::os::raw::c_char,
        from: *const ::std::os::raw::c_char,
        from_length: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_ulong;
}
unsafe extern "stdcall" {
    pub fn mysql_hex_string(
        to: *mut ::std::os::raw::c_char,
        from: *const ::std::os::raw::c_char,
        from_length: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_ulong;
}
unsafe extern "stdcall" {
    pub fn mysql_real_escape_string(
        mysql: *mut MYSQL,
        to: *mut ::std::os::raw::c_char,
        from: *const ::std::os::raw::c_char,
        length: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_ulong;
}
unsafe extern "stdcall" {
    pub fn mysql_real_escape_string_quote(
        mysql: *mut MYSQL,
        to: *mut ::std::os::raw::c_char,
        from: *const ::std::os::raw::c_char,
        length: ::std::os::raw::c_ulong,
        quote: ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_ulong;
}
unsafe extern "stdcall" {
    pub fn mysql_debug(debug: *const ::std::os::raw::c_char);
}
unsafe extern "stdcall" {
    pub fn mysql_thread_safe() -> ::std::os::raw::c_uint;
}
unsafe extern "stdcall" {
    pub fn mysql_read_query_result(mysql: *mut MYSQL) -> bool;
}
unsafe extern "stdcall" {
    pub fn mysql_reset_connection(mysql: *mut MYSQL) -> ::std::os::raw::c_int;
}
unsafe extern "stdcall" {
    pub fn mysql_reset_connection_nonblocking(mysql: *mut MYSQL) -> net_async_status;
}
unsafe extern "stdcall" {
    pub fn mysql_binlog_open(mysql: *mut MYSQL, rpl: *mut MYSQL_RPL) -> ::std::os::raw::c_int;
}
unsafe extern "stdcall" {
    pub fn mysql_binlog_fetch(mysql: *mut MYSQL, rpl: *mut MYSQL_RPL) -> ::std::os::raw::c_int;
}
unsafe extern "stdcall" {
    pub fn mysql_binlog_close(mysql: *mut MYSQL, rpl: *mut MYSQL_RPL);
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum enum_mysql_stmt_state {
    MYSQL_STMT_INIT_DONE = 1,
    MYSQL_STMT_PREPARE_DONE = 2,
    MYSQL_STMT_EXECUTE_DONE = 3,
    MYSQL_STMT_FETCH_DONE = 4,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MYSQL_BIND {
    pub length: *mut ::std::os::raw::c_ulong,
    pub is_null: *mut bool,
    pub buffer: *mut ::std::os::raw::c_void,
    pub error: *mut bool,
    pub row_ptr: *mut ::std::os::raw::c_uchar,
    pub store_param_func:
        ::std::option::Option<unsafe extern "C" fn(net: *mut NET, param: *mut MYSQL_BIND)>,
    pub fetch_result: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut MYSQL_BIND,
            arg2: *mut MYSQL_FIELD,
            row: *mut *mut ::std::os::raw::c_uchar,
        ),
    >,
    pub skip_result: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut MYSQL_BIND,
            arg2: *mut MYSQL_FIELD,
            row: *mut *mut ::std::os::raw::c_uchar,
        ),
    >,
    pub buffer_length: ::std::os::raw::c_ulong,
    pub offset: ::std::os::raw::c_ulong,
    pub length_value: ::std::os::raw::c_ulong,
    pub param_number: ::std::os::raw::c_uint,
    pub pack_length: ::std::os::raw::c_uint,
    pub buffer_type: enum_field_types,
    pub error_value: bool,
    pub is_unsigned: bool,
    pub long_data_used: bool,
    pub is_null_value: bool,
    pub extension: *mut ::std::os::raw::c_void,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of MYSQL_BIND"][::std::mem::size_of::<MYSQL_BIND>() - 64usize];
    ["Alignment of MYSQL_BIND"][::std::mem::align_of::<MYSQL_BIND>() - 4usize];
    ["Offset of field: MYSQL_BIND::length"][::std::mem::offset_of!(MYSQL_BIND, length) - 0usize];
    ["Offset of field: MYSQL_BIND::is_null"][::std::mem::offset_of!(MYSQL_BIND, is_null) - 4usize];
    ["Offset of field: MYSQL_BIND::buffer"][::std::mem::offset_of!(MYSQL_BIND, buffer) - 8usize];
    ["Offset of field: MYSQL_BIND::error"][::std::mem::offset_of!(MYSQL_BIND, error) - 12usize];
    ["Offset of field: MYSQL_BIND::row_ptr"][::std::mem::offset_of!(MYSQL_BIND, row_ptr) - 16usize];
    ["Offset of field: MYSQL_BIND::store_param_func"]
        [::std::mem::offset_of!(MYSQL_BIND, store_param_func) - 20usize];
    ["Offset of field: MYSQL_BIND::fetch_result"]
        [::std::mem::offset_of!(MYSQL_BIND, fetch_result) - 24usize];
    ["Offset of field: MYSQL_BIND::skip_result"]
        [::std::mem::offset_of!(MYSQL_BIND, skip_result) - 28usize];
    ["Offset of field: MYSQL_BIND::buffer_length"]
        [::std::mem::offset_of!(MYSQL_BIND, buffer_length) - 32usize];
    ["Offset of field: MYSQL_BIND::offset"][::std::mem::offset_of!(MYSQL_BIND, offset) - 36usize];
    ["Offset of field: MYSQL_BIND::length_value"]
        [::std::mem::offset_of!(MYSQL_BIND, length_value) - 40usize];
    ["Offset of field: MYSQL_BIND::param_number"]
        [::std::mem::offset_of!(MYSQL_BIND, param_number) - 44usize];
    ["Offset of field: MYSQL_BIND::pack_length"]
        [::std::mem::offset_of!(MYSQL_BIND, pack_length) - 48usize];
    ["Offset of field: MYSQL_BIND::buffer_type"]
        [::std::mem::offset_of!(MYSQL_BIND, buffer_type) - 52usize];
    ["Offset of field: MYSQL_BIND::error_value"]
        [::std::mem::offset_of!(MYSQL_BIND, error_value) - 56usize];
    ["Offset of field: MYSQL_BIND::is_unsigned"]
        [::std::mem::offset_of!(MYSQL_BIND, is_unsigned) - 57usize];
    ["Offset of field: MYSQL_BIND::long_data_used"]
        [::std::mem::offset_of!(MYSQL_BIND, long_data_used) - 58usize];
    ["Offset of field: MYSQL_BIND::is_null_value"]
        [::std::mem::offset_of!(MYSQL_BIND, is_null_value) - 59usize];
    ["Offset of field: MYSQL_BIND::extension"]
        [::std::mem::offset_of!(MYSQL_BIND, extension) - 60usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MYSQL_STMT_EXT {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MYSQL_STMT {
    pub mem_root: *mut MEM_ROOT,
    pub list: LIST,
    pub mysql: *mut MYSQL,
    pub params: *mut MYSQL_BIND,
    pub bind: *mut MYSQL_BIND,
    pub fields: *mut MYSQL_FIELD,
    pub result: MYSQL_DATA,
    pub data_cursor: *mut MYSQL_ROWS,
    pub read_row_func: ::std::option::Option<
        unsafe extern "C" fn(
            stmt: *mut MYSQL_STMT,
            row: *mut *mut ::std::os::raw::c_uchar,
        ) -> ::std::os::raw::c_int,
    >,
    pub affected_rows: u64,
    pub insert_id: u64,
    pub stmt_id: ::std::os::raw::c_ulong,
    pub flags: ::std::os::raw::c_ulong,
    pub prefetch_rows: ::std::os::raw::c_ulong,
    pub server_status: ::std::os::raw::c_uint,
    pub last_errno: ::std::os::raw::c_uint,
    pub param_count: ::std::os::raw::c_uint,
    pub field_count: ::std::os::raw::c_uint,
    pub state: enum_mysql_stmt_state,
    pub last_error: [::std::os::raw::c_char; 512usize],
    pub sqlstate: [::std::os::raw::c_char; 6usize],
    pub send_types_to_server: bool,
    pub bind_param_done: bool,
    pub bind_result_done: ::std::os::raw::c_uchar,
    pub unbuffered_fetch_cancelled: bool,
    pub update_max_length: bool,
    pub extension: *mut MYSQL_STMT_EXT,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of MYSQL_STMT"][::std::mem::size_of::<MYSQL_STMT>() - 640usize];
    ["Alignment of MYSQL_STMT"][::std::mem::align_of::<MYSQL_STMT>() - 8usize];
    ["Offset of field: MYSQL_STMT::mem_root"]
        [::std::mem::offset_of!(MYSQL_STMT, mem_root) - 0usize];
    ["Offset of field: MYSQL_STMT::list"][::std::mem::offset_of!(MYSQL_STMT, list) - 4usize];
    ["Offset of field: MYSQL_STMT::mysql"][::std::mem::offset_of!(MYSQL_STMT, mysql) - 16usize];
    ["Offset of field: MYSQL_STMT::params"][::std::mem::offset_of!(MYSQL_STMT, params) - 20usize];
    ["Offset of field: MYSQL_STMT::bind"][::std::mem::offset_of!(MYSQL_STMT, bind) - 24usize];
    ["Offset of field: MYSQL_STMT::fields"][::std::mem::offset_of!(MYSQL_STMT, fields) - 28usize];
    ["Offset of field: MYSQL_STMT::result"][::std::mem::offset_of!(MYSQL_STMT, result) - 32usize];
    ["Offset of field: MYSQL_STMT::data_cursor"]
        [::std::mem::offset_of!(MYSQL_STMT, data_cursor) - 56usize];
    ["Offset of field: MYSQL_STMT::read_row_func"]
        [::std::mem::offset_of!(MYSQL_STMT, read_row_func) - 60usize];
    ["Offset of field: MYSQL_STMT::affected_rows"]
        [::std::mem::offset_of!(MYSQL_STMT, affected_rows) - 64usize];
    ["Offset of field: MYSQL_STMT::insert_id"]
        [::std::mem::offset_of!(MYSQL_STMT, insert_id) - 72usize];
    ["Offset of field: MYSQL_STMT::stmt_id"][::std::mem::offset_of!(MYSQL_STMT, stmt_id) - 80usize];
    ["Offset of field: MYSQL_STMT::flags"][::std::mem::offset_of!(MYSQL_STMT, flags) - 84usize];
    ["Offset of field: MYSQL_STMT::prefetch_rows"]
        [::std::mem::offset_of!(MYSQL_STMT, prefetch_rows) - 88usize];
    ["Offset of field: MYSQL_STMT::server_status"]
        [::std::mem::offset_of!(MYSQL_STMT, server_status) - 92usize];
    ["Offset of field: MYSQL_STMT::last_errno"]
        [::std::mem::offset_of!(MYSQL_STMT, last_errno) - 96usize];
    ["Offset of field: MYSQL_STMT::param_count"]
        [::std::mem::offset_of!(MYSQL_STMT, param_count) - 100usize];
    ["Offset of field: MYSQL_STMT::field_count"]
        [::std::mem::offset_of!(MYSQL_STMT, field_count) - 104usize];
    ["Offset of field: MYSQL_STMT::state"][::std::mem::offset_of!(MYSQL_STMT, state) - 108usize];
    ["Offset of field: MYSQL_STMT::last_error"]
        [::std::mem::offset_of!(MYSQL_STMT, last_error) - 112usize];
    ["Offset of field: MYSQL_STMT::sqlstate"]
        [::std::mem::offset_of!(MYSQL_STMT, sqlstate) - 624usize];
    ["Offset of field: MYSQL_STMT::send_types_to_server"]
        [::std::mem::offset_of!(MYSQL_STMT, send_types_to_server) - 630usize];
    ["Offset of field: MYSQL_STMT::bind_param_done"]
        [::std::mem::offset_of!(MYSQL_STMT, bind_param_done) - 631usize];
    ["Offset of field: MYSQL_STMT::bind_result_done"]
        [::std::mem::offset_of!(MYSQL_STMT, bind_result_done) - 632usize];
    ["Offset of field: MYSQL_STMT::unbuffered_fetch_cancelled"]
        [::std::mem::offset_of!(MYSQL_STMT, unbuffered_fetch_cancelled) - 633usize];
    ["Offset of field: MYSQL_STMT::update_max_length"]
        [::std::mem::offset_of!(MYSQL_STMT, update_max_length) - 634usize];
    ["Offset of field: MYSQL_STMT::extension"]
        [::std::mem::offset_of!(MYSQL_STMT, extension) - 636usize];
};
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum enum_stmt_attr_type {
    STMT_ATTR_UPDATE_MAX_LENGTH = 0,
    STMT_ATTR_CURSOR_TYPE = 1,
    STMT_ATTR_PREFETCH_ROWS = 2,
}
unsafe extern "stdcall" {
    pub fn mysql_bind_param(
        mysql: *mut MYSQL,
        n_params: ::std::os::raw::c_uint,
        binds: *mut MYSQL_BIND,
        names: *mut *const ::std::os::raw::c_char,
    ) -> bool;
}
unsafe extern "stdcall" {
    pub fn mysql_stmt_init(mysql: *mut MYSQL) -> *mut MYSQL_STMT;
}
unsafe extern "stdcall" {
    pub fn mysql_stmt_prepare(
        stmt: *mut MYSQL_STMT,
        query: *const ::std::os::raw::c_char,
        length: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "stdcall" {
    pub fn mysql_stmt_execute(stmt: *mut MYSQL_STMT) -> ::std::os::raw::c_int;
}
unsafe extern "stdcall" {
    pub fn mysql_stmt_fetch(stmt: *mut MYSQL_STMT) -> ::std::os::raw::c_int;
}
unsafe extern "stdcall" {
    pub fn mysql_stmt_fetch_column(
        stmt: *mut MYSQL_STMT,
        bind_arg: *mut MYSQL_BIND,
        column: ::std::os::raw::c_uint,
        offset: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "stdcall" {
    pub fn mysql_stmt_store_result(stmt: *mut MYSQL_STMT) -> ::std::os::raw::c_int;
}
unsafe extern "stdcall" {
    pub fn mysql_stmt_param_count(stmt: *mut MYSQL_STMT) -> ::std::os::raw::c_ulong;
}
unsafe extern "stdcall" {
    pub fn mysql_stmt_attr_set(
        stmt: *mut MYSQL_STMT,
        attr_type: enum_stmt_attr_type,
        attr: *const ::std::os::raw::c_void,
    ) -> bool;
}
unsafe extern "stdcall" {
    pub fn mysql_stmt_attr_get(
        stmt: *mut MYSQL_STMT,
        attr_type: enum_stmt_attr_type,
        attr: *mut ::std::os::raw::c_void,
    ) -> bool;
}
unsafe extern "stdcall" {
    pub fn mysql_stmt_bind_param(stmt: *mut MYSQL_STMT, bnd: *mut MYSQL_BIND) -> bool;
}
unsafe extern "stdcall" {
    pub fn mysql_stmt_bind_named_param(
        stmt: *mut MYSQL_STMT,
        binds: *mut MYSQL_BIND,
        n_params: ::std::os::raw::c_uint,
        names: *mut *const ::std::os::raw::c_char,
    ) -> bool;
}
unsafe extern "stdcall" {
    pub fn mysql_stmt_bind_result(stmt: *mut MYSQL_STMT, bnd: *mut MYSQL_BIND) -> bool;
}
unsafe extern "stdcall" {
    pub fn mysql_stmt_close(stmt: *mut MYSQL_STMT) -> bool;
}
unsafe extern "stdcall" {
    pub fn mysql_stmt_reset(stmt: *mut MYSQL_STMT) -> bool;
}
unsafe extern "stdcall" {
    pub fn mysql_stmt_free_result(stmt: *mut MYSQL_STMT) -> bool;
}
unsafe extern "stdcall" {
    pub fn mysql_stmt_send_long_data(
        stmt: *mut MYSQL_STMT,
        param_number: ::std::os::raw::c_uint,
        data: *const ::std::os::raw::c_char,
        length: ::std::os::raw::c_ulong,
    ) -> bool;
}
unsafe extern "stdcall" {
    pub fn mysql_stmt_result_metadata(stmt: *mut MYSQL_STMT) -> *mut MYSQL_RES;
}
unsafe extern "stdcall" {
    pub fn mysql_stmt_param_metadata(stmt: *mut MYSQL_STMT) -> *mut MYSQL_RES;
}
unsafe extern "stdcall" {
    pub fn mysql_stmt_errno(stmt: *mut MYSQL_STMT) -> ::std::os::raw::c_uint;
}
unsafe extern "stdcall" {
    pub fn mysql_stmt_error(stmt: *mut MYSQL_STMT) -> *const ::std::os::raw::c_char;
}
unsafe extern "stdcall" {
    pub fn mysql_stmt_sqlstate(stmt: *mut MYSQL_STMT) -> *const ::std::os::raw::c_char;
}
unsafe extern "stdcall" {
    pub fn mysql_stmt_row_seek(stmt: *mut MYSQL_STMT, offset: MYSQL_ROW_OFFSET)
        -> MYSQL_ROW_OFFSET;
}
unsafe extern "stdcall" {
    pub fn mysql_stmt_row_tell(stmt: *mut MYSQL_STMT) -> MYSQL_ROW_OFFSET;
}
unsafe extern "stdcall" {
    pub fn mysql_stmt_data_seek(stmt: *mut MYSQL_STMT, offset: u64);
}
unsafe extern "stdcall" {
    pub fn mysql_stmt_num_rows(stmt: *mut MYSQL_STMT) -> u64;
}
unsafe extern "stdcall" {
    pub fn mysql_stmt_affected_rows(stmt: *mut MYSQL_STMT) -> u64;
}
unsafe extern "stdcall" {
    pub fn mysql_stmt_insert_id(stmt: *mut MYSQL_STMT) -> u64;
}
unsafe extern "stdcall" {
    pub fn mysql_stmt_field_count(stmt: *mut MYSQL_STMT) -> ::std::os::raw::c_uint;
}
unsafe extern "stdcall" {
    pub fn mysql_commit(mysql: *mut MYSQL) -> bool;
}
unsafe extern "stdcall" {
    pub fn mysql_rollback(mysql: *mut MYSQL) -> bool;
}
unsafe extern "stdcall" {
    pub fn mysql_autocommit(mysql: *mut MYSQL, auto_mode: bool) -> bool;
}
unsafe extern "stdcall" {
    pub fn mysql_more_results(mysql: *mut MYSQL) -> bool;
}
unsafe extern "stdcall" {
    pub fn mysql_next_result(mysql: *mut MYSQL) -> ::std::os::raw::c_int;
}
unsafe extern "stdcall" {
    pub fn mysql_stmt_next_result(stmt: *mut MYSQL_STMT) -> ::std::os::raw::c_int;
}
unsafe extern "stdcall" {
    pub fn mysql_close(sock: *mut MYSQL);
}
unsafe extern "stdcall" {
    pub fn mysql_reset_server_public_key();
}
unsafe extern "stdcall" {
    pub fn mysql_real_connect_dns_srv(
        mysql: *mut MYSQL,
        dns_srv_name: *const ::std::os::raw::c_char,
        user: *const ::std::os::raw::c_char,
        passwd: *const ::std::os::raw::c_char,
        db: *const ::std::os::raw::c_char,
        client_flag: ::std::os::raw::c_ulong,
    ) -> *mut MYSQL;
}
unsafe extern "stdcall" {
    pub fn mysql_get_connect_nonblocking_stage(mysql: *mut MYSQL) -> connect_stage;
}
pub type __builtin_va_list = *mut ::std::os::raw::c_char;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Init_commands_array {
    pub _address: u8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CHARSET_INFO {
    pub _address: u8,
}
