/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.items;

import java.util.Iterator;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.items.Item;
import org.openhab.core.types.State;
import org.openhab.core.types.UnDefType;

@NonNullByDefault
public interface GroupFunction {
    public static final String EQUALITY = "EQUALITY";
    public static final String AND = "AND";
    public static final String OR = "OR";
    public static final String NAND = "NAND";
    public static final String NOR = "NOR";
    public static final String XOR = "XOR";
    public static final String COUNT = "COUNT";
    public static final String AVG = "AVG";
    public static final String MEDIAN = "MEDIAN";
    public static final String SUM = "SUM";
    public static final String MIN = "MIN";
    public static final String MAX = "MAX";
    public static final String LATEST = "LATEST";
    public static final String EARLIEST = "EARLIEST";
    public static final String DEFAULT = "EQUALITY";
    public static final Set<String> VALID_FUNCTIONS = Set.of("EQUALITY", "AND", "OR", "NAND", "NOR", "XOR", "COUNT", "AVG", "MEDIAN", "SUM", "MIN", "MAX", "LATEST", "EARLIEST");

    public State calculate(@Nullable Set<Item> var1);

    public <T extends State> @Nullable T getStateAs(@Nullable Set<Item> var1, Class<T> var2);

    public State[] getParameters();

    public static class Equality
    implements GroupFunction {
        @Override
        public State calculate(@Nullable Set<Item> items) {
            if (items == null || items.isEmpty()) {
                return UnDefType.UNDEF;
            }
            Iterator<Item> it = items.iterator();
            State state = it.next().getState();
            while (it.hasNext()) {
                if (state.equals(it.next().getState())) continue;
                return UnDefType.UNDEF;
            }
            return state;
        }

        @Override
        public <T extends State> @Nullable T getStateAs(@Nullable Set<Item> items, Class<T> stateClass) {
            State state = this.calculate(items);
            if (stateClass.isInstance(state)) {
                return (T)((State)stateClass.cast(state));
            }
            return null;
        }

        @Override
        public State[] getParameters() {
            return new State[0];
        }
    }
}

