/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.elab.BooleanElaborator;
import net.sf.saxon.expr.elab.BooleanEvaluator;
import net.sf.saxon.expr.elab.Elaborator;
import net.sf.saxon.expr.elab.ItemEvaluator;
import net.sf.saxon.expr.elab.PullEvaluator;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.DocumentNodeTest;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.Affinity;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UType;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.SequenceType;

public final class InstanceOfExpression
extends UnaryExpression {
    ItemType targetType;
    int targetCardinality;

    public InstanceOfExpression(Expression source, SequenceType target) {
        super(source);
        this.targetType = target.getPrimaryType();
        if (this.targetType == null) {
            throw new IllegalArgumentException("Primary item type must not be null");
        }
        this.targetCardinality = target.getCardinality();
    }

    @Override
    protected OperandRole getOperandRole() {
        return this.targetType instanceof DocumentNodeTest ? OperandRole.ABSORB : OperandRole.INSPECT;
    }

    public ItemType getRequiredItemType() {
        return this.targetType;
    }

    public int getRequiredCardinality() {
        return this.targetCardinality;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        this.getOperand().typeCheck(visitor, contextInfo);
        Expression operand = this.getBaseExpression();
        if (operand instanceof Literal) {
            Literal lit = Literal.makeLiteral(this.evaluateItem(visitor.getStaticContext().makeEarlyEvaluationContext()), this);
            ExpressionTool.copyLocationInfo(this, lit);
            return lit;
        }
        if (Cardinality.subsumes(this.targetCardinality, operand.getCardinality())) {
            TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
            Affinity relation = th.relationship(operand.getItemType(), this.targetType);
            if (relation == Affinity.SAME_TYPE || relation == Affinity.SUBSUMED_BY) {
                Literal lit = Literal.makeLiteral(BooleanValue.TRUE, this);
                ExpressionTool.copyLocationInfo(this, lit);
                return lit;
            }
            if (!(relation != Affinity.DISJOINT || Cardinality.allowsZero(this.targetCardinality) && Cardinality.allowsZero(operand.getCardinality()))) {
                Literal lit = Literal.makeLiteral(BooleanValue.FALSE, this);
                ExpressionTool.copyLocationInfo(this, lit);
                return lit;
            }
        } else if ((this.targetCardinality & operand.getCardinality()) == 0) {
            Literal lit = Literal.makeLiteral(BooleanValue.FALSE, this);
            ExpressionTool.copyLocationInfo(this, lit);
            return lit;
        }
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        Expression e = super.optimize(visitor, contextInfo);
        if (e != this) {
            return e;
        }
        if (Cardinality.subsumes(this.targetCardinality, this.getBaseExpression().getCardinality())) {
            TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
            Affinity relation = th.relationship(this.getBaseExpression().getItemType(), this.targetType);
            if (relation == Affinity.SAME_TYPE || relation == Affinity.SUBSUMED_BY) {
                return Literal.makeLiteral(BooleanValue.TRUE, this);
            }
            if (!(relation != Affinity.DISJOINT || Cardinality.allowsZero(this.targetCardinality) && Cardinality.allowsZero(this.getBaseExpression().getCardinality()))) {
                return Literal.makeLiteral(BooleanValue.FALSE, this);
            }
        }
        return this;
    }

    @Override
    public int getImplementationMethod() {
        return 1;
    }

    @Override
    public boolean equals(Object other) {
        return super.equals(other) && this.targetType == ((InstanceOfExpression)other).targetType && this.targetCardinality == ((InstanceOfExpression)other).targetCardinality;
    }

    @Override
    protected int computeHashCode() {
        return super.computeHashCode() ^ this.targetType.hashCode() ^ this.targetCardinality;
    }

    @Override
    protected int computeCardinality() {
        return 16384;
    }

    @Override
    public Expression copy(RebindingMap rebindings) {
        InstanceOfExpression exp = new InstanceOfExpression(this.getBaseExpression().copy(rebindings), SequenceType.makeSequenceType(this.targetType, this.targetCardinality));
        ExpressionTool.copyLocationInfo(this, exp);
        return exp;
    }

    @Override
    public ItemType getItemType() {
        return BuiltInAtomicType.BOOLEAN;
    }

    @Override
    public UType getStaticUType(UType contextItemType) {
        return UType.BOOLEAN;
    }

    @Override
    public BooleanValue evaluateItem(XPathContext context) throws XPathException {
        return BooleanValue.get(this.effectiveBooleanValue(context));
    }

    @Override
    public boolean effectiveBooleanValue(XPathContext context) throws XPathException {
        return this.makeElaborator().elaborateForBoolean().eval(context);
    }

    @Override
    public String getExpressionName() {
        return "instance";
    }

    @Override
    public void export(ExpressionPresenter out) throws XPathException {
        out.startElement("instance", this);
        SequenceType st = SequenceType.makeSequenceType(this.targetType, this.targetCardinality);
        out.emitAttribute("of", st.toAlphaCode());
        this.getBaseExpression().export(out);
        out.endElement();
    }

    @Override
    public String toString() {
        String occ = Cardinality.getOccurrenceIndicator(this.targetCardinality);
        return "(" + this.getBaseExpression().toString() + " instance of " + this.targetType.toString() + occ + ")";
    }

    @Override
    public String toShortString() {
        String occ = Cardinality.getOccurrenceIndicator(this.targetCardinality);
        return this.getBaseExpression().toShortString() + " instance of " + this.targetType.toString() + occ;
    }

    @Override
    public String getStreamerName() {
        return "InstanceOf";
    }

    @Override
    public Elaborator getElaborator() {
        return new InstanceOfElaborator();
    }

    public static class InstanceOfElaborator
    extends BooleanElaborator {
        @Override
        public BooleanEvaluator elaborateForBoolean() {
            InstanceOfExpression exp = (InstanceOfExpression)this.getExpression();
            TypeHierarchy th = this.getConfiguration().getTypeHierarchy();
            Expression arg = exp.getBaseExpression();
            int requiredCardinality = exp.getRequiredCardinality();
            boolean allowsMany = Cardinality.allowsMany(requiredCardinality);
            boolean allowsZero = Cardinality.allowsZero(requiredCardinality);
            ItemType requiredType = exp.getRequiredItemType();
            if (requiredCardinality == 16384 && !Cardinality.allowsMany(arg.getCardinality())) {
                ItemEvaluator itemEval = arg.makeElaborator().elaborateForItem();
                return context -> {
                    Item item = itemEval.eval(context);
                    return item != null && requiredType.matches(item, th);
                };
            }
            PullEvaluator argPull = arg.makeElaborator().elaborateForPull();
            boolean itemTypeOK = th.isSubType(arg.getItemType(), requiredType);
            return context -> {
                Item item;
                SequenceIterator iter = argPull.iterate(context);
                int count = 0;
                while ((item = iter.next()) != null) {
                    ++count;
                    if (!itemTypeOK && !requiredType.matches(item, th)) {
                        iter.close();
                        return false;
                    }
                    if (allowsMany || count != 2) continue;
                    iter.close();
                    return false;
                }
                return allowsZero || count != 0;
            };
        }
    }
}

