/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.contrib.demo;

import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.User32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinUser;

public class WindowHooks {
    private static volatile boolean quit;
    private static WinUser.LowLevelMouseProc mouseProc;
    private static WinUser.HHOOK mouseHook;
    private static WinUser.LowLevelKeyboardProc keyboardProc;
    private static WinUser.HHOOK keyboardHook;

    public static void main(String[] args) {
        int result;
        final User32 lib = User32.INSTANCE;
        WinDef.HMODULE hMod = Kernel32.INSTANCE.GetModuleHandle(null);
        keyboardProc = new WinUser.LowLevelKeyboardProc(){

            @Override
            public WinDef.LRESULT callback(int nCode, WinDef.WPARAM wParam, WinUser.KBDLLHOOKSTRUCT info) {
                if (nCode >= 0) {
                    switch (wParam.intValue()) {
                        case 256: 
                        case 257: 
                        case 260: 
                        case 261: {
                            System.err.println("in callback, key=" + info.vkCode);
                            if (info.vkCode != 81) break;
                            quit = true;
                        }
                    }
                }
                Pointer ptr = info.getPointer();
                long peer = Pointer.nativeValue(ptr);
                return lib.CallNextHookEx(keyboardHook, nCode, wParam, new WinDef.LPARAM(peer));
            }
        };
        keyboardHook = lib.SetWindowsHookEx(13, keyboardProc, hMod, 0);
        System.out.println("Keyboard hook installed, type anywhere, 'q' to quit");
        mouseProc = new WinUser.LowLevelMouseProc(){

            @Override
            public WinDef.LRESULT callback(int nCode, WinDef.WPARAM wParam, WinUser.MSLLHOOKSTRUCT lParam) {
                if (nCode >= 0) {
                    switch (wParam.intValue()) {
                        case 512: {
                            System.out.println("Mouse moved!");
                            break;
                        }
                        case 513: {
                            System.out.println("Left button down!");
                            break;
                        }
                        case 514: {
                            System.out.println("Left button up!");
                            break;
                        }
                        case 516: {
                            System.out.println("Right button down!");
                            break;
                        }
                        case 517: {
                            System.out.println("Right button up!");
                            break;
                        }
                        case 519: {
                            System.out.println("Middle button down!");
                            break;
                        }
                        case 520: {
                            System.out.println("Middle button up!");
                        }
                    }
                }
                return lib.CallNextHookEx(mouseHook, nCode, wParam, new WinDef.LPARAM(Pointer.nativeValue(lParam.getPointer())));
            }
        };
        mouseHook = User32.INSTANCE.SetWindowsHookEx(14, mouseProc, hMod, 0);
        new Thread(){

            @Override
            public void run() {
                while (!quit) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (Exception exception) {}
                }
                System.err.println("unhook and exit");
                lib.UnhookWindowsHookEx(keyboardHook);
                lib.UnhookWindowsHookEx(mouseHook);
                System.exit(0);
            }
        }.start();
        WinUser.MSG msg = new WinUser.MSG();
        while ((result = lib.GetMessage(msg, null, 0, 0)) != 0) {
            if (result == -1) {
                System.err.println("error in get message");
                break;
            }
            System.err.println("got message");
            lib.TranslateMessage(msg);
            lib.DispatchMessage(msg);
        }
        lib.UnhookWindowsHookEx(keyboardHook);
        lib.UnhookWindowsHookEx(mouseHook);
    }
}

