// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/iam/v3beta/principal_access_boundary_policy_resources.proto

package iampb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// An effect to describe the access relationship.
type PrincipalAccessBoundaryPolicyRule_Effect int32

const (
	// Effect unspecified.
	PrincipalAccessBoundaryPolicyRule_EFFECT_UNSPECIFIED PrincipalAccessBoundaryPolicyRule_Effect = 0
	// Allows access to the resources in this rule.
	PrincipalAccessBoundaryPolicyRule_ALLOW PrincipalAccessBoundaryPolicyRule_Effect = 1
)

// Enum value maps for PrincipalAccessBoundaryPolicyRule_Effect.
var (
	PrincipalAccessBoundaryPolicyRule_Effect_name = map[int32]string{
		0: "EFFECT_UNSPECIFIED",
		1: "ALLOW",
	}
	PrincipalAccessBoundaryPolicyRule_Effect_value = map[string]int32{
		"EFFECT_UNSPECIFIED": 0,
		"ALLOW":              1,
	}
)

func (x PrincipalAccessBoundaryPolicyRule_Effect) Enum() *PrincipalAccessBoundaryPolicyRule_Effect {
	p := new(PrincipalAccessBoundaryPolicyRule_Effect)
	*p = x
	return p
}

func (x PrincipalAccessBoundaryPolicyRule_Effect) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PrincipalAccessBoundaryPolicyRule_Effect) Descriptor() protoreflect.EnumDescriptor {
	return file_google_iam_v3beta_principal_access_boundary_policy_resources_proto_enumTypes[0].Descriptor()
}

func (PrincipalAccessBoundaryPolicyRule_Effect) Type() protoreflect.EnumType {
	return &file_google_iam_v3beta_principal_access_boundary_policy_resources_proto_enumTypes[0]
}

func (x PrincipalAccessBoundaryPolicyRule_Effect) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PrincipalAccessBoundaryPolicyRule_Effect.Descriptor instead.
func (PrincipalAccessBoundaryPolicyRule_Effect) EnumDescriptor() ([]byte, []int) {
	return file_google_iam_v3beta_principal_access_boundary_policy_resources_proto_rawDescGZIP(), []int{2, 0}
}

// An IAM principal access boundary policy resource.
type PrincipalAccessBoundaryPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. The resource name of the principal access boundary policy.
	//
	// The following format is supported:
	// `organizations/{organization_id}/locations/{location}/principalAccessBoundaryPolicies/{policy_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The globally unique ID of the principal access boundary
	// policy.
	Uid string `protobuf:"bytes,2,opt,name=uid,proto3" json:"uid,omitempty"`
	// Optional. The etag for the principal access boundary.
	// If this is provided on update, it must match the server's etag.
	Etag string `protobuf:"bytes,3,opt,name=etag,proto3" json:"etag,omitempty"`
	// Optional. The description of the principal access boundary policy. Must be
	// less than or equal to 63 characters.
	DisplayName string `protobuf:"bytes,4,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Optional. User defined annotations. See
	// https://google.aip.dev/148#annotations for more details such as format and
	// size limitations
	Annotations map[string]string `protobuf:"bytes,5,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. The time when the principal access boundary policy was
	// created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time when the principal access boundary policy was most
	// recently updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Optional. The details for the principal access boundary policy.
	Details *PrincipalAccessBoundaryPolicyDetails `protobuf:"bytes,8,opt,name=details,proto3" json:"details,omitempty"`
}

func (x *PrincipalAccessBoundaryPolicy) Reset() {
	*x = PrincipalAccessBoundaryPolicy{}
	mi := &file_google_iam_v3beta_principal_access_boundary_policy_resources_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PrincipalAccessBoundaryPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PrincipalAccessBoundaryPolicy) ProtoMessage() {}

func (x *PrincipalAccessBoundaryPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_iam_v3beta_principal_access_boundary_policy_resources_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PrincipalAccessBoundaryPolicy.ProtoReflect.Descriptor instead.
func (*PrincipalAccessBoundaryPolicy) Descriptor() ([]byte, []int) {
	return file_google_iam_v3beta_principal_access_boundary_policy_resources_proto_rawDescGZIP(), []int{0}
}

func (x *PrincipalAccessBoundaryPolicy) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *PrincipalAccessBoundaryPolicy) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *PrincipalAccessBoundaryPolicy) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *PrincipalAccessBoundaryPolicy) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *PrincipalAccessBoundaryPolicy) GetAnnotations() map[string]string {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *PrincipalAccessBoundaryPolicy) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *PrincipalAccessBoundaryPolicy) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *PrincipalAccessBoundaryPolicy) GetDetails() *PrincipalAccessBoundaryPolicyDetails {
	if x != nil {
		return x.Details
	}
	return nil
}

// Principal access boundary policy details
type PrincipalAccessBoundaryPolicyDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A list of principal access boundary policy rules. The number of
	// rules in a policy is limited to 500.
	Rules []*PrincipalAccessBoundaryPolicyRule `protobuf:"bytes,1,rep,name=rules,proto3" json:"rules,omitempty"`
	// Optional.
	// The version number (for example, `1` or `latest`) that indicates which
	// permissions are able to be blocked by the policy. If empty, the PAB policy
	// version will be set to the most recent version number at the time of the
	// policy's creation.
	EnforcementVersion string `protobuf:"bytes,4,opt,name=enforcement_version,json=enforcementVersion,proto3" json:"enforcement_version,omitempty"`
}

func (x *PrincipalAccessBoundaryPolicyDetails) Reset() {
	*x = PrincipalAccessBoundaryPolicyDetails{}
	mi := &file_google_iam_v3beta_principal_access_boundary_policy_resources_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PrincipalAccessBoundaryPolicyDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PrincipalAccessBoundaryPolicyDetails) ProtoMessage() {}

func (x *PrincipalAccessBoundaryPolicyDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_iam_v3beta_principal_access_boundary_policy_resources_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PrincipalAccessBoundaryPolicyDetails.ProtoReflect.Descriptor instead.
func (*PrincipalAccessBoundaryPolicyDetails) Descriptor() ([]byte, []int) {
	return file_google_iam_v3beta_principal_access_boundary_policy_resources_proto_rawDescGZIP(), []int{1}
}

func (x *PrincipalAccessBoundaryPolicyDetails) GetRules() []*PrincipalAccessBoundaryPolicyRule {
	if x != nil {
		return x.Rules
	}
	return nil
}

func (x *PrincipalAccessBoundaryPolicyDetails) GetEnforcementVersion() string {
	if x != nil {
		return x.EnforcementVersion
	}
	return ""
}

// Principal access boundary policy rule that defines the resource boundary.
type PrincipalAccessBoundaryPolicyRule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The description of the principal access boundary policy rule.
	// Must be less than or equal to 256 characters.
	Description string `protobuf:"bytes,1,opt,name=description,proto3" json:"description,omitempty"`
	// Required. A list of Resource Manager resources. If a resource is listed in
	// the rule, then the rule applies for that resource and its descendants. The
	// number of resources in a policy is limited to 500 across all rules in the
	// policy.
	//
	// The following resource types are supported:
	//
	// * Organizations, such as
	// `//cloudresourcemanager.googleapis.com/organizations/123`.
	//   - Folders, such as `//cloudresourcemanager.googleapis.com/folders/123`.
	//   - Projects, such as `//cloudresourcemanager.googleapis.com/projects/123`
	//     or `//cloudresourcemanager.googleapis.com/projects/my-project-id`.
	Resources []string `protobuf:"bytes,2,rep,name=resources,proto3" json:"resources,omitempty"`
	// Required. The access relationship of principals to the resources in this
	// rule.
	Effect PrincipalAccessBoundaryPolicyRule_Effect `protobuf:"varint,3,opt,name=effect,proto3,enum=google.iam.v3beta.PrincipalAccessBoundaryPolicyRule_Effect" json:"effect,omitempty"`
}

func (x *PrincipalAccessBoundaryPolicyRule) Reset() {
	*x = PrincipalAccessBoundaryPolicyRule{}
	mi := &file_google_iam_v3beta_principal_access_boundary_policy_resources_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PrincipalAccessBoundaryPolicyRule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PrincipalAccessBoundaryPolicyRule) ProtoMessage() {}

func (x *PrincipalAccessBoundaryPolicyRule) ProtoReflect() protoreflect.Message {
	mi := &file_google_iam_v3beta_principal_access_boundary_policy_resources_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PrincipalAccessBoundaryPolicyRule.ProtoReflect.Descriptor instead.
func (*PrincipalAccessBoundaryPolicyRule) Descriptor() ([]byte, []int) {
	return file_google_iam_v3beta_principal_access_boundary_policy_resources_proto_rawDescGZIP(), []int{2}
}

func (x *PrincipalAccessBoundaryPolicyRule) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *PrincipalAccessBoundaryPolicyRule) GetResources() []string {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *PrincipalAccessBoundaryPolicyRule) GetEffect() PrincipalAccessBoundaryPolicyRule_Effect {
	if x != nil {
		return x.Effect
	}
	return PrincipalAccessBoundaryPolicyRule_EFFECT_UNSPECIFIED
}

var File_google_iam_v3beta_principal_access_boundary_policy_resources_proto protoreflect.FileDescriptor

var file_google_iam_v3beta_principal_access_boundary_policy_resources_proto_rawDesc = []byte{
	0x0a, 0x42, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x69, 0x61, 0x6d, 0x2f, 0x76, 0x33, 0x62,
	0x65, 0x74, 0x61, 0x2f, 0x70, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x5f, 0x61, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x5f, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x5f, 0x70, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x11, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d,
	0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69,
	0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x22, 0x8d, 0x06, 0x0a, 0x1d, 0x50, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x41,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1d, 0x0a, 0x03,
	0x75, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0b, 0xe0, 0x41, 0x03, 0xe2, 0x8c,
	0xcf, 0xd7, 0x08, 0x02, 0x08, 0x01, 0x52, 0x03, 0x75, 0x69, 0x64, 0x12, 0x17, 0x0a, 0x04, 0x65,
	0x74, 0x61, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04,
	0x65, 0x74, 0x61, 0x67, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x68, 0x0a, 0x0b,
	0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76,
	0x33, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x50, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x41,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x56, 0x0a, 0x07, 0x64, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x2e,
	0x50, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42,
	0x6f, 0x75, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x44, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x64, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x73, 0x1a, 0x3e, 0x0a, 0x10, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02,
	0x38, 0x01, 0x3a, 0xec, 0x01, 0xea, 0x41, 0xe8, 0x01, 0x0a, 0x30, 0x69, 0x61, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72,
	0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x6f, 0x75,
	0x6e, 0x64, 0x61, 0x72, 0x79, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x74, 0x6f, 0x72, 0x67,
	0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6f, 0x72, 0x67, 0x61,
	0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x70,
	0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x6f,
	0x75, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x2f, 0x7b,
	0x70, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x5f, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x7d, 0x2a, 0x1f, 0x70, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x41, 0x63, 0x63, 0x65,
	0x73, 0x73, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69,
	0x65, 0x73, 0x32, 0x1d, 0x70, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x41, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x22, 0xad, 0x01, 0x0a, 0x24, 0x50, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x41,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x4f, 0x0a, 0x05, 0x72, 0x75,
	0x6c, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x50, 0x72,
	0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x6f, 0x75,
	0x6e, 0x64, 0x61, 0x72, 0x79, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x75, 0x6c, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x12, 0x34, 0x0a, 0x13, 0x65,
	0x6e, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x12, 0x65,
	0x6e, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x22, 0xf4, 0x01, 0x0a, 0x21, 0x50, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x41,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x52, 0x75, 0x6c, 0x65, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x21,
	0x0a, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x12, 0x58, 0x0a, 0x06, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76,
	0x33, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x50, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x41,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x52, 0x75, 0x6c, 0x65, 0x2e, 0x45, 0x66, 0x66, 0x65, 0x63, 0x74, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x06, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x22, 0x2b, 0x0a, 0x06, 0x45,
	0x66, 0x66, 0x65, 0x63, 0x74, 0x12, 0x16, 0x0a, 0x12, 0x45, 0x46, 0x46, 0x45, 0x43, 0x54, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a,
	0x05, 0x41, 0x4c, 0x4c, 0x4f, 0x57, 0x10, 0x01, 0x42, 0xa9, 0x01, 0x0a, 0x15, 0x63, 0x6f, 0x6d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x33, 0x62, 0x65,
	0x74, 0x61, 0x42, 0x2b, 0x50, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x41, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50,
	0x01, 0x5a, 0x2d, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x69, 0x61, 0x6d, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x33,
	0x62, 0x65, 0x74, 0x61, 0x2f, 0x69, 0x61, 0x6d, 0x70, 0x62, 0x3b, 0x69, 0x61, 0x6d, 0x70, 0x62,
	0xaa, 0x02, 0x17, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x49, 0x61, 0x6d, 0x2e, 0x56, 0x33, 0x42, 0x65, 0x74, 0x61, 0xca, 0x02, 0x17, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x49, 0x61, 0x6d, 0x5c, 0x56, 0x33,
	0x62, 0x65, 0x74, 0x61, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_iam_v3beta_principal_access_boundary_policy_resources_proto_rawDescOnce sync.Once
	file_google_iam_v3beta_principal_access_boundary_policy_resources_proto_rawDescData = file_google_iam_v3beta_principal_access_boundary_policy_resources_proto_rawDesc
)

func file_google_iam_v3beta_principal_access_boundary_policy_resources_proto_rawDescGZIP() []byte {
	file_google_iam_v3beta_principal_access_boundary_policy_resources_proto_rawDescOnce.Do(func() {
		file_google_iam_v3beta_principal_access_boundary_policy_resources_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_iam_v3beta_principal_access_boundary_policy_resources_proto_rawDescData)
	})
	return file_google_iam_v3beta_principal_access_boundary_policy_resources_proto_rawDescData
}

var file_google_iam_v3beta_principal_access_boundary_policy_resources_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_iam_v3beta_principal_access_boundary_policy_resources_proto_msgTypes = make([]protoimpl.MessageInfo, 4)
var file_google_iam_v3beta_principal_access_boundary_policy_resources_proto_goTypes = []any{
	(PrincipalAccessBoundaryPolicyRule_Effect)(0), // 0: google.iam.v3beta.PrincipalAccessBoundaryPolicyRule.Effect
	(*PrincipalAccessBoundaryPolicy)(nil),         // 1: google.iam.v3beta.PrincipalAccessBoundaryPolicy
	(*PrincipalAccessBoundaryPolicyDetails)(nil),  // 2: google.iam.v3beta.PrincipalAccessBoundaryPolicyDetails
	(*PrincipalAccessBoundaryPolicyRule)(nil),     // 3: google.iam.v3beta.PrincipalAccessBoundaryPolicyRule
	nil,                           // 4: google.iam.v3beta.PrincipalAccessBoundaryPolicy.AnnotationsEntry
	(*timestamppb.Timestamp)(nil), // 5: google.protobuf.Timestamp
}
var file_google_iam_v3beta_principal_access_boundary_policy_resources_proto_depIdxs = []int32{
	4, // 0: google.iam.v3beta.PrincipalAccessBoundaryPolicy.annotations:type_name -> google.iam.v3beta.PrincipalAccessBoundaryPolicy.AnnotationsEntry
	5, // 1: google.iam.v3beta.PrincipalAccessBoundaryPolicy.create_time:type_name -> google.protobuf.Timestamp
	5, // 2: google.iam.v3beta.PrincipalAccessBoundaryPolicy.update_time:type_name -> google.protobuf.Timestamp
	2, // 3: google.iam.v3beta.PrincipalAccessBoundaryPolicy.details:type_name -> google.iam.v3beta.PrincipalAccessBoundaryPolicyDetails
	3, // 4: google.iam.v3beta.PrincipalAccessBoundaryPolicyDetails.rules:type_name -> google.iam.v3beta.PrincipalAccessBoundaryPolicyRule
	0, // 5: google.iam.v3beta.PrincipalAccessBoundaryPolicyRule.effect:type_name -> google.iam.v3beta.PrincipalAccessBoundaryPolicyRule.Effect
	6, // [6:6] is the sub-list for method output_type
	6, // [6:6] is the sub-list for method input_type
	6, // [6:6] is the sub-list for extension type_name
	6, // [6:6] is the sub-list for extension extendee
	0, // [0:6] is the sub-list for field type_name
}

func init() { file_google_iam_v3beta_principal_access_boundary_policy_resources_proto_init() }
func file_google_iam_v3beta_principal_access_boundary_policy_resources_proto_init() {
	if File_google_iam_v3beta_principal_access_boundary_policy_resources_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_iam_v3beta_principal_access_boundary_policy_resources_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   4,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_iam_v3beta_principal_access_boundary_policy_resources_proto_goTypes,
		DependencyIndexes: file_google_iam_v3beta_principal_access_boundary_policy_resources_proto_depIdxs,
		EnumInfos:         file_google_iam_v3beta_principal_access_boundary_policy_resources_proto_enumTypes,
		MessageInfos:      file_google_iam_v3beta_principal_access_boundary_policy_resources_proto_msgTypes,
	}.Build()
	File_google_iam_v3beta_principal_access_boundary_policy_resources_proto = out.File
	file_google_iam_v3beta_principal_access_boundary_policy_resources_proto_rawDesc = nil
	file_google_iam_v3beta_principal_access_boundary_policy_resources_proto_goTypes = nil
	file_google_iam_v3beta_principal_access_boundary_policy_resources_proto_depIdxs = nil
}
