# Generated YAML Output

```{note}
The generated YAML output summarizes elements of the CLib API in YAML format
and serves for illustration purposes. The YAML source code generator may be used to
generate diagnostic output as well as a starting point for the creation of additional
generated language interfaces.
```

The YAML source generator generates YAML descriptions that correspond to individual
CLib modules generated from [specification files](sec-sourcegen-specifications). Each
output file contains mappings of CLib function names to implementation details
of individual [recipes](sec-sourcegen-recipes).

**Example:** Using the same input as in the [](clib-extensions) example, the YAML source
generator documents the CLib getter for molecular weights as follows:

```yaml
thermo_getMolecularWeights:
  brief: Copy the vector of molecular weights into array weights.
  what: getter
  declaration: int32_t thermo_getMolecularWeights(int32_t handle, int32_t weightsLen, double* weights)
  parameters:
    handle: Handle to queried Phase object.
    weightsLen: Length of array reserved for weights.
    weights: Output array of molecular weights (kg/kmol)
  wraps: void Phase::getMolecularWeights(double*)
  uses:
  - size_t Phase::nSpecies()
```

Individual YAML fields represent the following:

- `brief`: Brief Doxygen docstring obtained from C++.
- `what`: Type of recipe, as detected or defined in the corresponding
  [](sec-sourcegen-function-types).
- `declaration`: Full CLib function signature.
- `parameters`: Mapping of CLib function arguments to respective docstrings.
- `returns`: Docstring of value returned by CLib function.
- `wraps`: Full signature of C++ function/method/variable implemented by CLib (if
  applicable).
- `uses`: List of auxiliary C++ methods used by the CLib function (if applicable).

## YAML Output Generation

YAML output is generated by running the following command from the root folder of the
Cantera source code:

```bash
scons doxygen && sourcegen --api=yaml --output=build/yaml
```

Generated YAML files are placed in the output folder `build/yaml`. Note that this
step requires installation of sourcegen via
`python -m pip install -e interfaces/sourcegen`.

## YAML Source Generator Overview

The YAML source generator is located in the `interfaces/sourcegen/src/sourcegen/yaml`
folder. While the overall configuration follows available [](sourcegen-config), the
YAML source generator introduces additional configuration options, as detailed below.

### Configuration

The configuration file `config.yaml` contains configuration options specific to the YAML
interface. These options are common across all sourcegen variants and are based on the
names of YAML configuration files.

- `ignore_files`: A list of configuration files.
   Files listed here will be completely ignored during source generation.
- `ignore_funcs`: A mapping of configuration file names to lists of recipe names.
   Functions listed in those files will not be scaffolded.

### Implementation Details

- **Templates for Scaffolding:** Templates, powered by
  [Jinja](https://jinja.palletsprojects.com), are used to scaffold elements of the YAML
  output. The following files define these templates:

    - `templates.yaml`: Defines YAML code blocks within the output files.
    - `template_output.yaml.j2`: Defines the template for output files.

- **Source Code:** The implementation of the YAML source generator is contained in
  `generator.py`.

## Extending the YAML API

The YAML source generator relies on data used for the [](clib-extensions) and does not
require additional configuration.
