/*
 * Copyright (c) 2018, 2025, Oracle and/or its affiliates. All rights reserved.
 * 
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * The contents of this file are subject to the terms of either the Universal Permissive License
 * v 1.0 as shown at https://oss.oracle.com/licenses/upl
 *
 * or the following license:
 *
 * Redistribution and use in source and binary forms, with or without modification, are permitted
 * provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice, this list of conditions
 * and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other materials provided with
 * the distribution.
 * 
 * 3. Neither the name of the copyright holder nor the names of its contributors may be used to
 * endorse or promote products derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY
 * WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package org.openjdk.jmc.agent.test.util;

import java.util.Arrays;

import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;

public class TestVisitor extends ClassVisitor {

	public TestVisitor() {
		super(Opcodes.ASM5);
	}

	@Override
	public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
		System.out.println("Visiting class: " + name); //$NON-NLS-1$
		System.out.println("Class Major Version: " + version); //$NON-NLS-1$
		System.out.println("Super class: " + superName); //$NON-NLS-1$
		System.out.println("Signature: " + signature); //$NON-NLS-1$
		System.out.println("Interfaces: " + Arrays.toString(interfaces)); //$NON-NLS-1$

		super.visit(version, access, name, signature, superName, interfaces);
	}

	@Override
	public void visitOuterClass(String owner, String name, String desc) {
		System.out.println("Outer class: " + owner); //$NON-NLS-1$
		super.visitOuterClass(owner, name, desc);
	}

	@Override
	public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
		System.out.println("Annotation: " + desc); //$NON-NLS-1$
		return super.visitAnnotation(desc, visible);
	}

	@Override
	public void visitAttribute(Attribute attr) {
		System.out.println("Class Attribute: " + attr.type); //$NON-NLS-1$
		super.visitAttribute(attr);
	}

	@Override
	public void visitInnerClass(String name, String outerName, String innerName, int access) {
		System.out.println("Inner Class: " + innerName + " defined in " + outerName); //$NON-NLS-1$ //$NON-NLS-2$
		super.visitInnerClass(name, outerName, innerName, access);
	}

	@Override
	public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
		System.out.println("Field: " + name + " " + desc + " value:" + value); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
		return super.visitField(access, name, desc, signature, value);
	}

	@Override
	public void visitEnd() {
		System.out.println("Visit ended"); //$NON-NLS-1$
		super.visitEnd();
	}

	@Override
	public MethodVisitor visitMethod(
		int access, String name, String descriptor, String signature, String[] exceptions) {
		System.out.println("Method: " + name + descriptor); //$NON-NLS-1$
		return super.visitMethod(access, name, descriptor, signature, exceptions);
	}

	@Override
	public void visitSource(String source, String debug) {
		System.out.println("Source: " + source); //$NON-NLS-1$
		super.visitSource(source, debug);
	}

}
