/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.oops;

import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.oops.ConstantPoolCache;
import sun.jvm.hotspot.oops.IntField;
import sun.jvm.hotspot.oops.Metadata;
import sun.jvm.hotspot.oops.MetadataVisitor;
import sun.jvm.hotspot.oops.NamedFieldIdentifier;
import sun.jvm.hotspot.oops.OopField;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.CIntegerField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.types.WrongTypeException;
import sun.jvm.hotspot.utilities.Assert;

public class ConstantPoolCacheEntry {
    private static long size;
    private static long baseOffset;
    private static CIntegerField indices;
    private static AddressField f1;
    private static CIntegerField f2;
    private static CIntegerField flags;
    private ConstantPoolCache cp;
    private long offset;
    static NamedFieldIdentifier f1FieldName;
    static NamedFieldIdentifier f2FieldName;
    static NamedFieldIdentifier flagsFieldName;

    private static synchronized void initialize(TypeDataBase db) throws WrongTypeException {
        Type type = db.lookupType("ConstantPoolCacheEntry");
        size = type.getSize();
        indices = type.getCIntegerField("_indices");
        f1 = type.getAddressField("_f1");
        f2 = type.getCIntegerField("_f2");
        flags = type.getCIntegerField("_flags");
        type = db.lookupType("ConstantPoolCache");
        baseOffset = type.getSize();
    }

    ConstantPoolCacheEntry(ConstantPoolCache cp, int index) {
        this.cp = cp;
        this.offset = baseOffset + (long)index * size;
    }

    public int getConstantPoolIndex() {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that((this.getIndices() & 0xFFFFL) != 0L, "must be main entry");
        }
        return (int)(this.getIndices() & 0xFFFFL);
    }

    private long getIndices() {
        return this.cp.getAddress().getCIntegerAt(indices.getOffset() + this.offset, indices.getSize(), indices.isUnsigned());
    }

    public Metadata getF1() {
        return Metadata.instantiateWrapperFor(this.cp.getAddress().getAddressAt(f1.getOffset() + this.offset));
    }

    public int getF2() {
        return this.cp.getAddress().getJIntAt(f1.getOffset() + this.offset);
    }

    public int getFlags() {
        return this.cp.getAddress().getJIntAt(flags.getOffset() + this.offset);
    }

    public void iterateFields(MetadataVisitor visitor) {
        visitor.doOop(new OopField(f1FieldName, f1.getOffset() + this.offset, true), true);
        visitor.doInt(new IntField(f2FieldName, f2.getOffset() + this.offset, true), true);
        visitor.doInt(new IntField(flagsFieldName, flags.getOffset() + this.offset, true), true);
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                ConstantPoolCacheEntry.initialize(VM.getVM().getTypeDataBase());
            }
        });
        f1FieldName = new NamedFieldIdentifier("_f1");
        f2FieldName = new NamedFieldIdentifier("_f2");
        flagsFieldName = new NamedFieldIdentifier("_flags");
    }
}

