// Copyright 2025 The Go Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated by generate.go. DO NOT EDIT.

package stdlib

var PackageSymbols = map[string][]Symbol{
	"archive/tar": {
		{"(*Header).FileInfo", Method, 1},
		{"(*Reader).Next", Method, 0},
		{"(*Reader).Read", Method, 0},
		{"(*Writer).AddFS", Method, 22},
		{"(*Writer).Close", Method, 0},
		{"(*Writer).Flush", Method, 0},
		{"(*Writer).Write", Method, 0},
		{"(*Writer).WriteHeader", Method, 0},
		{"(Format).String", Method, 10},
		{"ErrFieldTooLong", Var, 0},
		{"ErrHeader", Var, 0},
		{"ErrInsecurePath", Var, 20},
		{"ErrWriteAfterClose", Var, 0},
		{"ErrWriteTooLong", Var, 0},
		{"FileInfoHeader", Func, 1},
		{"FileInfoNames", Type, 23},
		{"Format", Type, 10},
		{"FormatGNU", Const, 10},
		{"FormatPAX", Const, 10},
		{"FormatUSTAR", Const, 10},
		{"FormatUnknown", Const, 10},
		{"Header", Type, 0},
		{"Header.AccessTime", Field, 0},
		{"Header.ChangeTime", Field, 0},
		{"Header.Devmajor", Field, 0},
		{"Header.Devminor", Field, 0},
		{"Header.Format", Field, 10},
		{"Header.Gid", Field, 0},
		{"Header.Gname", Field, 0},
		{"Header.Linkname", Field, 0},
		{"Header.ModTime", Field, 0},
		{"Header.Mode", Field, 0},
		{"Header.Name", Field, 0},
		{"Header.PAXRecords", Field, 10},
		{"Header.Size", Field, 0},
		{"Header.Typeflag", Field, 0},
		{"Header.Uid", Field, 0},
		{"Header.Uname", Field, 0},
		{"Header.Xattrs", Field, 3},
		{"NewReader", Func, 0},
		{"NewWriter", Func, 0},
		{"Reader", Type, 0},
		{"TypeBlock", Const, 0},
		{"TypeChar", Const, 0},
		{"TypeCont", Const, 0},
		{"TypeDir", Const, 0},
		{"TypeFifo", Const, 0},
		{"TypeGNULongLink", Const, 1},
		{"TypeGNULongName", Const, 1},
		{"TypeGNUSparse", Const, 3},
		{"TypeLink", Const, 0},
		{"TypeReg", Const, 0},
		{"TypeRegA", Const, 0},
		{"TypeSymlink", Const, 0},
		{"TypeXGlobalHeader", Const, 0},
		{"TypeXHeader", Const, 0},
		{"Writer", Type, 0},
	},
	"archive/zip": {
		{"(*File).DataOffset", Method, 2},
		{"(*File).FileInfo", Method, 0},
		{"(*File).ModTime", Method, 0},
		{"(*File).Mode", Method, 0},
		{"(*File).Open", Method, 0},
		{"(*File).OpenRaw", Method, 17},
		{"(*File).SetModTime", Method, 0},
		{"(*File).SetMode", Method, 0},
		{"(*FileHeader).FileInfo", Method, 0},
		{"(*FileHeader).ModTime", Method, 0},
		{"(*FileHeader).Mode", Method, 0},
		{"(*FileHeader).SetModTime", Method, 0},
		{"(*FileHeader).SetMode", Method, 0},
		{"(*ReadCloser).Close", Method, 0},
		{"(*ReadCloser).Open", Method, 16},
		{"(*ReadCloser).RegisterDecompressor", Method, 6},
		{"(*Reader).Open", Method, 16},
		{"(*Reader).RegisterDecompressor", Method, 6},
		{"(*Writer).AddFS", Method, 22},
		{"(*Writer).Close", Method, 0},
		{"(*Writer).Copy", Method, 17},
		{"(*Writer).Create", Method, 0},
		{"(*Writer).CreateHeader", Method, 0},
		{"(*Writer).CreateRaw", Method, 17},
		{"(*Writer).Flush", Method, 4},
		{"(*Writer).RegisterCompressor", Method, 6},
		{"(*Writer).SetComment", Method, 10},
		{"(*Writer).SetOffset", Method, 5},
		{"Compressor", Type, 2},
		{"Decompressor", Type, 2},
		{"Deflate", Const, 0},
		{"ErrAlgorithm", Var, 0},
		{"ErrChecksum", Var, 0},
		{"ErrFormat", Var, 0},
		{"ErrInsecurePath", Var, 20},
		{"File", Type, 0},
		{"File.FileHeader", Field, 0},
		{"FileHeader", Type, 0},
		{"FileHeader.CRC32", Field, 0},
		{"FileHeader.Comment", Field, 0},
		{"FileHeader.CompressedSize", Field, 0},
		{"FileHeader.CompressedSize64", Field, 1},
		{"FileHeader.CreatorVersion", Field, 0},
		{"FileHeader.ExternalAttrs", Field, 0},
		{"FileHeader.Extra", Field, 0},
		{"FileHeader.Flags", Field, 0},
		{"FileHeader.Method", Field, 0},
		{"FileHeader.Modified", Field, 10},
		{"FileHeader.ModifiedDate", Field, 0},
		{"FileHeader.ModifiedTime", Field, 0},
		{"FileHeader.Name", Field, 0},
		{"FileHeader.NonUTF8", Field, 10},
		{"FileHeader.ReaderVersion", Field, 0},
		{"FileHeader.UncompressedSize", Field, 0},
		{"FileHeader.UncompressedSize64", Field, 1},
		{"FileInfoHeader", Func, 0},
		{"NewReader", Func, 0},
		{"NewWriter", Func, 0},
		{"OpenReader", Func, 0},
		{"ReadCloser", Type, 0},
		{"ReadCloser.Reader", Field, 0},
		{"Reader", Type, 0},
		{"Reader.Comment", Field, 0},
		{"Reader.File", Field, 0},
		{"RegisterCompressor", Func, 2},
		{"RegisterDecompressor", Func, 2},
		{"Store", Const, 0},
		{"Writer", Type, 0},
	},
	"bufio": {
		{"(*Reader).Buffered", Method, 0},
		{"(*Reader).Discard", Method, 5},
		{"(*Reader).Peek", Method, 0},
		{"(*Reader).Read", Method, 0},
		{"(*Reader).ReadByte", Method, 0},
		{"(*Reader).ReadBytes", Method, 0},
		{"(*Reader).ReadLine", Method, 0},
		{"(*Reader).ReadRune", Method, 0},
		{"(*Reader).ReadSlice", Method, 0},
		{"(*Reader).ReadString", Method, 0},
		{"(*Reader).Reset", Method, 2},
		{"(*Reader).Size", Method, 10},
		{"(*Reader).UnreadByte", Method, 0},
		{"(*Reader).UnreadRune", Method, 0},
		{"(*Reader).WriteTo", Method, 1},
		{"(*Scanner).Buffer", Method, 6},
		{"(*Scanner).Bytes", Method, 1},
		{"(*Scanner).Err", Method, 1},
		{"(*Scanner).Scan", Method, 1},
		{"(*Scanner).Split", Method, 1},
		{"(*Scanner).Text", Method, 1},
		{"(*Writer).Available", Method, 0},
		{"(*Writer).AvailableBuffer", Method, 18},
		{"(*Writer).Buffered", Method, 0},
		{"(*Writer).Flush", Method, 0},
		{"(*Writer).ReadFrom", Method, 1},
		{"(*Writer).Reset", Method, 2},
		{"(*Writer).Size", Method, 10},
		{"(*Writer).Write", Method, 0},
		{"(*Writer).WriteByte", Method, 0},
		{"(*Writer).WriteRune", Method, 0},
		{"(*Writer).WriteString", Method, 0},
		{"(ReadWriter).Available", Method, 0},
		{"(ReadWriter).AvailableBuffer", Method, 18},
		{"(ReadWriter).Discard", Method, 5},
		{"(ReadWriter).Flush", Method, 0},
		{"(ReadWriter).Peek", Method, 0},
		{"(ReadWriter).Read", Method, 0},
		{"(ReadWriter).ReadByte", Method, 0},
		{"(ReadWriter).ReadBytes", Method, 0},
		{"(ReadWriter).ReadFrom", Method, 1},
		{"(ReadWriter).ReadLine", Method, 0},
		{"(ReadWriter).ReadRune", Method, 0},
		{"(ReadWriter).ReadSlice", Method, 0},
		{"(ReadWriter).ReadString", Method, 0},
		{"(ReadWriter).UnreadByte", Method, 0},
		{"(ReadWriter).UnreadRune", Method, 0},
		{"(ReadWriter).Write", Method, 0},
		{"(ReadWriter).WriteByte", Method, 0},
		{"(ReadWriter).WriteRune", Method, 0},
		{"(ReadWriter).WriteString", Method, 0},
		{"(ReadWriter).WriteTo", Method, 1},
		{"ErrAdvanceTooFar", Var, 1},
		{"ErrBadReadCount", Var, 15},
		{"ErrBufferFull", Var, 0},
		{"ErrFinalToken", Var, 6},
		{"ErrInvalidUnreadByte", Var, 0},
		{"ErrInvalidUnreadRune", Var, 0},
		{"ErrNegativeAdvance", Var, 1},
		{"ErrNegativeCount", Var, 0},
		{"ErrTooLong", Var, 1},
		{"MaxScanTokenSize", Const, 1},
		{"NewReadWriter", Func, 0},
		{"NewReader", Func, 0},
		{"NewReaderSize", Func, 0},
		{"NewScanner", Func, 1},
		{"NewWriter", Func, 0},
		{"NewWriterSize", Func, 0},
		{"ReadWriter", Type, 0},
		{"ReadWriter.Reader", Field, 0},
		{"ReadWriter.Writer", Field, 0},
		{"Reader", Type, 0},
		{"ScanBytes", Func, 1},
		{"ScanLines", Func, 1},
		{"ScanRunes", Func, 1},
		{"ScanWords", Func, 1},
		{"Scanner", Type, 1},
		{"SplitFunc", Type, 1},
		{"Writer", Type, 0},
	},
	"bytes": {
		{"(*Buffer).Available", Method, 21},
		{"(*Buffer).AvailableBuffer", Method, 21},
		{"(*Buffer).Bytes", Method, 0},
		{"(*Buffer).Cap", Method, 5},
		{"(*Buffer).Grow", Method, 1},
		{"(*Buffer).Len", Method, 0},
		{"(*Buffer).Next", Method, 0},
		{"(*Buffer).Read", Method, 0},
		{"(*Buffer).ReadByte", Method, 0},
		{"(*Buffer).ReadBytes", Method, 0},
		{"(*Buffer).ReadFrom", Method, 0},
		{"(*Buffer).ReadRune", Method, 0},
		{"(*Buffer).ReadString", Method, 0},
		{"(*Buffer).Reset", Method, 0},
		{"(*Buffer).String", Method, 0},
		{"(*Buffer).Truncate", Method, 0},
		{"(*Buffer).UnreadByte", Method, 0},
		{"(*Buffer).UnreadRune", Method, 0},
		{"(*Buffer).Write", Method, 0},
		{"(*Buffer).WriteByte", Method, 0},
		{"(*Buffer).WriteRune", Method, 0},
		{"(*Buffer).WriteString", Method, 0},
		{"(*Buffer).WriteTo", Method, 0},
		{"(*Reader).Len", Method, 0},
		{"(*Reader).Read", Method, 0},
		{"(*Reader).ReadAt", Method, 0},
		{"(*Reader).ReadByte", Method, 0},
		{"(*Reader).ReadRune", Method, 0},
		{"(*Reader).Reset", Method, 7},
		{"(*Reader).Seek", Method, 0},
		{"(*Reader).Size", Method, 5},
		{"(*Reader).UnreadByte", Method, 0},
		{"(*Reader).UnreadRune", Method, 0},
		{"(*Reader).WriteTo", Method, 1},
		{"Buffer", Type, 0},
		{"Clone", Func, 20},
		{"Compare", Func, 0},
		{"Contains", Func, 0},
		{"ContainsAny", Func, 7},
		{"ContainsFunc", Func, 21},
		{"ContainsRune", Func, 7},
		{"Count", Func, 0},
		{"Cut", Func, 18},
		{"CutPrefix", Func, 20},
		{"CutSuffix", Func, 20},
		{"Equal", Func, 0},
		{"EqualFold", Func, 0},
		{"ErrTooLarge", Var, 0},
		{"Fields", Func, 0},
		{"FieldsFunc", Func, 0},
		{"FieldsFuncSeq", Func, 24},
		{"FieldsSeq", Func, 24},
		{"HasPrefix", Func, 0},
		{"HasSuffix", Func, 0},
		{"Index", Func, 0},
		{"IndexAny", Func, 0},
		{"IndexByte", Func, 0},
		{"IndexFunc", Func, 0},
		{"IndexRune", Func, 0},
		{"Join", Func, 0},
		{"LastIndex", Func, 0},
		{"LastIndexAny", Func, 0},
		{"LastIndexByte", Func, 5},
		{"LastIndexFunc", Func, 0},
		{"Lines", Func, 24},
		{"Map", Func, 0},
		{"MinRead", Const, 0},
		{"NewBuffer", Func, 0},
		{"NewBufferString", Func, 0},
		{"NewReader", Func, 0},
		{"Reader", Type, 0},
		{"Repeat", Func, 0},
		{"Replace", Func, 0},
		{"ReplaceAll", Func, 12},
		{"Runes", Func, 0},
		{"Split", Func, 0},
		{"SplitAfter", Func, 0},
		{"SplitAfterN", Func, 0},
		{"SplitAfterSeq", Func, 24},
		{"SplitN", Func, 0},
		{"SplitSeq", Func, 24},
		{"Title", Func, 0},
		{"ToLower", Func, 0},
		{"ToLowerSpecial", Func, 0},
		{"ToTitle", Func, 0},
		{"ToTitleSpecial", Func, 0},
		{"ToUpper", Func, 0},
		{"ToUpperSpecial", Func, 0},
		{"ToValidUTF8", Func, 13},
		{"Trim", Func, 0},
		{"TrimFunc", Func, 0},
		{"TrimLeft", Func, 0},
		{"TrimLeftFunc", Func, 0},
		{"TrimPrefix", Func, 1},
		{"TrimRight", Func, 0},
		{"TrimRightFunc", Func, 0},
		{"TrimSpace", Func, 0},
		{"TrimSuffix", Func, 1},
	},
	"cmp": {
		{"Compare", Func, 21},
		{"Less", Func, 21},
		{"Or", Func, 22},
		{"Ordered", Type, 21},
	},
	"compress/bzip2": {
		{"(StructuralError).Error", Method, 0},
		{"NewReader", Func, 0},
		{"StructuralError", Type, 0},
	},
	"compress/flate": {
		{"(*ReadError).Error", Method, 0},
		{"(*WriteError).Error", Method, 0},
		{"(*Writer).Close", Method, 0},
		{"(*Writer).Flush", Method, 0},
		{"(*Writer).Reset", Method, 2},
		{"(*Writer).Write", Method, 0},
		{"(CorruptInputError).Error", Method, 0},
		{"(InternalError).Error", Method, 0},
		{"BestCompression", Const, 0},
		{"BestSpeed", Const, 0},
		{"CorruptInputError", Type, 0},
		{"DefaultCompression", Const, 0},
		{"HuffmanOnly", Const, 7},
		{"InternalError", Type, 0},
		{"NewReader", Func, 0},
		{"NewReaderDict", Func, 0},
		{"NewWriter", Func, 0},
		{"NewWriterDict", Func, 0},
		{"NoCompression", Const, 0},
		{"ReadError", Type, 0},
		{"ReadError.Err", Field, 0},
		{"ReadError.Offset", Field, 0},
		{"Reader", Type, 0},
		{"Resetter", Type, 4},
		{"WriteError", Type, 0},
		{"WriteError.Err", Field, 0},
		{"WriteError.Offset", Field, 0},
		{"Writer", Type, 0},
	},
	"compress/gzip": {
		{"(*Reader).Close", Method, 0},
		{"(*Reader).Multistream", Method, 4},
		{"(*Reader).Read", Method, 0},
		{"(*Reader).Reset", Method, 3},
		{"(*Writer).Close", Method, 0},
		{"(*Writer).Flush", Method, 1},
		{"(*Writer).Reset", Method, 2},
		{"(*Writer).Write", Method, 0},
		{"BestCompression", Const, 0},
		{"BestSpeed", Const, 0},
		{"DefaultCompression", Const, 0},
		{"ErrChecksum", Var, 0},
		{"ErrHeader", Var, 0},
		{"Header", Type, 0},
		{"Header.Comment", Field, 0},
		{"Header.Extra", Field, 0},
		{"Header.ModTime", Field, 0},
		{"Header.Name", Field, 0},
		{"Header.OS", Field, 0},
		{"HuffmanOnly", Const, 8},
		{"NewReader", Func, 0},
		{"NewWriter", Func, 0},
		{"NewWriterLevel", Func, 0},
		{"NoCompression", Const, 0},
		{"Reader", Type, 0},
		{"Reader.Header", Field, 0},
		{"Writer", Type, 0},
		{"Writer.Header", Field, 0},
	},
	"compress/lzw": {
		{"(*Reader).Close", Method, 17},
		{"(*Reader).Read", Method, 17},
		{"(*Reader).Reset", Method, 17},
		{"(*Writer).Close", Method, 17},
		{"(*Writer).Reset", Method, 17},
		{"(*Writer).Write", Method, 17},
		{"LSB", Const, 0},
		{"MSB", Const, 0},
		{"NewReader", Func, 0},
		{"NewWriter", Func, 0},
		{"Order", Type, 0},
		{"Reader", Type, 17},
		{"Writer", Type, 17},
	},
	"compress/zlib": {
		{"(*Writer).Close", Method, 0},
		{"(*Writer).Flush", Method, 0},
		{"(*Writer).Reset", Method, 2},
		{"(*Writer).Write", Method, 0},
		{"BestCompression", Const, 0},
		{"BestSpeed", Const, 0},
		{"DefaultCompression", Const, 0},
		{"ErrChecksum", Var, 0},
		{"ErrDictionary", Var, 0},
		{"ErrHeader", Var, 0},
		{"HuffmanOnly", Const, 8},
		{"NewReader", Func, 0},
		{"NewReaderDict", Func, 0},
		{"NewWriter", Func, 0},
		{"NewWriterLevel", Func, 0},
		{"NewWriterLevelDict", Func, 0},
		{"NoCompression", Const, 0},
		{"Resetter", Type, 4},
		{"Writer", Type, 0},
	},
	"container/heap": {
		{"Fix", Func, 2},
		{"Init", Func, 0},
		{"Interface", Type, 0},
		{"Pop", Func, 0},
		{"Push", Func, 0},
		{"Remove", Func, 0},
	},
	"container/list": {
		{"(*Element).Next", Method, 0},
		{"(*Element).Prev", Method, 0},
		{"(*List).Back", Method, 0},
		{"(*List).Front", Method, 0},
		{"(*List).Init", Method, 0},
		{"(*List).InsertAfter", Method, 0},
		{"(*List).InsertBefore", Method, 0},
		{"(*List).Len", Method, 0},
		{"(*List).MoveAfter", Method, 2},
		{"(*List).MoveBefore", Method, 2},
		{"(*List).MoveToBack", Method, 0},
		{"(*List).MoveToFront", Method, 0},
		{"(*List).PushBack", Method, 0},
		{"(*List).PushBackList", Method, 0},
		{"(*List).PushFront", Method, 0},
		{"(*List).PushFrontList", Method, 0},
		{"(*List).Remove", Method, 0},
		{"Element", Type, 0},
		{"Element.Value", Field, 0},
		{"List", Type, 0},
		{"New", Func, 0},
	},
	"container/ring": {
		{"(*Ring).Do", Method, 0},
		{"(*Ring).Len", Method, 0},
		{"(*Ring).Link", Method, 0},
		{"(*Ring).Move", Method, 0},
		{"(*Ring).Next", Method, 0},
		{"(*Ring).Prev", Method, 0},
		{"(*Ring).Unlink", Method, 0},
		{"New", Func, 0},
		{"Ring", Type, 0},
		{"Ring.Value", Field, 0},
	},
	"context": {
		{"AfterFunc", Func, 21},
		{"Background", Func, 7},
		{"CancelCauseFunc", Type, 20},
		{"CancelFunc", Type, 7},
		{"Canceled", Var, 7},
		{"Cause", Func, 20},
		{"Context", Type, 7},
		{"DeadlineExceeded", Var, 7},
		{"TODO", Func, 7},
		{"WithCancel", Func, 7},
		{"WithCancelCause", Func, 20},
		{"WithDeadline", Func, 7},
		{"WithDeadlineCause", Func, 21},
		{"WithTimeout", Func, 7},
		{"WithTimeoutCause", Func, 21},
		{"WithValue", Func, 7},
		{"WithoutCancel", Func, 21},
	},
	"crypto": {
		{"(Hash).Available", Method, 0},
		{"(Hash).HashFunc", Method, 4},
		{"(Hash).New", Method, 0},
		{"(Hash).Size", Method, 0},
		{"(Hash).String", Method, 15},
		{"BLAKE2b_256", Const, 9},
		{"BLAKE2b_384", Const, 9},
		{"BLAKE2b_512", Const, 9},
		{"BLAKE2s_256", Const, 9},
		{"Decrypter", Type, 5},
		{"DecrypterOpts", Type, 5},
		{"Hash", Type, 0},
		{"MD4", Const, 0},
		{"MD5", Const, 0},
		{"MD5SHA1", Const, 0},
		{"PrivateKey", Type, 0},
		{"PublicKey", Type, 2},
		{"RIPEMD160", Const, 0},
		{"RegisterHash", Func, 0},
		{"SHA1", Const, 0},
		{"SHA224", Const, 0},
		{"SHA256", Const, 0},
		{"SHA384", Const, 0},
		{"SHA3_224", Const, 4},
		{"SHA3_256", Const, 4},
		{"SHA3_384", Const, 4},
		{"SHA3_512", Const, 4},
		{"SHA512", Const, 0},
		{"SHA512_224", Const, 5},
		{"SHA512_256", Const, 5},
		{"Signer", Type, 4},
		{"SignerOpts", Type, 4},
	},
	"crypto/aes": {
		{"(KeySizeError).Error", Method, 0},
		{"BlockSize", Const, 0},
		{"KeySizeError", Type, 0},
		{"NewCipher", Func, 0},
	},
	"crypto/cipher": {
		{"(StreamReader).Read", Method, 0},
		{"(StreamWriter).Close", Method, 0},
		{"(StreamWriter).Write", Method, 0},
		{"AEAD", Type, 2},
		{"Block", Type, 0},
		{"BlockMode", Type, 0},
		{"NewCBCDecrypter", Func, 0},
		{"NewCBCEncrypter", Func, 0},
		{"NewCFBDecrypter", Func, 0},
		{"NewCFBEncrypter", Func, 0},
		{"NewCTR", Func, 0},
		{"NewGCM", Func, 2},
		{"NewGCMWithNonceSize", Func, 5},
		{"NewGCMWithRandomNonce", Func, 24},
		{"NewGCMWithTagSize", Func, 11},
		{"NewOFB", Func, 0},
		{"Stream", Type, 0},
		{"StreamReader", Type, 0},
		{"StreamReader.R", Field, 0},
		{"StreamReader.S", Field, 0},
		{"StreamWriter", Type, 0},
		{"StreamWriter.Err", Field, 0},
		{"StreamWriter.S", Field, 0},
		{"StreamWriter.W", Field, 0},
	},
	"crypto/des": {
		{"(KeySizeError).Error", Method, 0},
		{"BlockSize", Const, 0},
		{"KeySizeError", Type, 0},
		{"NewCipher", Func, 0},
		{"NewTripleDESCipher", Func, 0},
	},
	"crypto/dsa": {
		{"ErrInvalidPublicKey", Var, 0},
		{"GenerateKey", Func, 0},
		{"GenerateParameters", Func, 0},
		{"L1024N160", Const, 0},
		{"L2048N224", Const, 0},
		{"L2048N256", Const, 0},
		{"L3072N256", Const, 0},
		{"ParameterSizes", Type, 0},
		{"Parameters", Type, 0},
		{"Parameters.G", Field, 0},
		{"Parameters.P", Field, 0},
		{"Parameters.Q", Field, 0},
		{"PrivateKey", Type, 0},
		{"PrivateKey.PublicKey", Field, 0},
		{"PrivateKey.X", Field, 0},
		{"PublicKey", Type, 0},
		{"PublicKey.Parameters", Field, 0},
		{"PublicKey.Y", Field, 0},
		{"Sign", Func, 0},
		{"Verify", Func, 0},
	},
	"crypto/ecdh": {
		{"(*PrivateKey).Bytes", Method, 20},
		{"(*PrivateKey).Curve", Method, 20},
		{"(*PrivateKey).ECDH", Method, 20},
		{"(*PrivateKey).Equal", Method, 20},
		{"(*PrivateKey).Public", Method, 20},
		{"(*PrivateKey).PublicKey", Method, 20},
		{"(*PublicKey).Bytes", Method, 20},
		{"(*PublicKey).Curve", Method, 20},
		{"(*PublicKey).Equal", Method, 20},
		{"Curve", Type, 20},
		{"P256", Func, 20},
		{"P384", Func, 20},
		{"P521", Func, 20},
		{"PrivateKey", Type, 20},
		{"PublicKey", Type, 20},
		{"X25519", Func, 20},
	},
	"crypto/ecdsa": {
		{"(*PrivateKey).ECDH", Method, 20},
		{"(*PrivateKey).Equal", Method, 15},
		{"(*PrivateKey).Public", Method, 4},
		{"(*PrivateKey).Sign", Method, 4},
		{"(*PublicKey).ECDH", Method, 20},
		{"(*PublicKey).Equal", Method, 15},
		{"(PrivateKey).Add", Method, 0},
		{"(PrivateKey).Double", Method, 0},
		{"(PrivateKey).IsOnCurve", Method, 0},
		{"(PrivateKey).Params", Method, 0},
		{"(PrivateKey).ScalarBaseMult", Method, 0},
		{"(PrivateKey).ScalarMult", Method, 0},
		{"(PublicKey).Add", Method, 0},
		{"(PublicKey).Double", Method, 0},
		{"(PublicKey).IsOnCurve", Method, 0},
		{"(PublicKey).Params", Method, 0},
		{"(PublicKey).ScalarBaseMult", Method, 0},
		{"(PublicKey).ScalarMult", Method, 0},
		{"GenerateKey", Func, 0},
		{"PrivateKey", Type, 0},
		{"PrivateKey.D", Field, 0},
		{"PrivateKey.PublicKey", Field, 0},
		{"PublicKey", Type, 0},
		{"PublicKey.Curve", Field, 0},
		{"PublicKey.X", Field, 0},
		{"PublicKey.Y", Field, 0},
		{"Sign", Func, 0},
		{"SignASN1", Func, 15},
		{"Verify", Func, 0},
		{"VerifyASN1", Func, 15},
	},
	"crypto/ed25519": {
		{"(*Options).HashFunc", Method, 20},
		{"(PrivateKey).Equal", Method, 15},
		{"(PrivateKey).Public", Method, 13},
		{"(PrivateKey).Seed", Method, 13},
		{"(PrivateKey).Sign", Method, 13},
		{"(PublicKey).Equal", Method, 15},
		{"GenerateKey", Func, 13},
		{"NewKeyFromSeed", Func, 13},
		{"Options", Type, 20},
		{"Options.Context", Field, 20},
		{"Options.Hash", Field, 20},
		{"PrivateKey", Type, 13},
		{"PrivateKeySize", Const, 13},
		{"PublicKey", Type, 13},
		{"PublicKeySize", Const, 13},
		{"SeedSize", Const, 13},
		{"Sign", Func, 13},
		{"SignatureSize", Const, 13},
		{"Verify", Func, 13},
		{"VerifyWithOptions", Func, 20},
	},
	"crypto/elliptic": {
		{"(*CurveParams).Add", Method, 0},
		{"(*CurveParams).Double", Method, 0},
		{"(*CurveParams).IsOnCurve", Method, 0},
		{"(*CurveParams).Params", Method, 0},
		{"(*CurveParams).ScalarBaseMult", Method, 0},
		{"(*CurveParams).ScalarMult", Method, 0},
		{"Curve", Type, 0},
		{"CurveParams", Type, 0},
		{"CurveParams.B", Field, 0},
		{"CurveParams.BitSize", Field, 0},
		{"CurveParams.Gx", Field, 0},
		{"CurveParams.Gy", Field, 0},
		{"CurveParams.N", Field, 0},
		{"CurveParams.Name", Field, 5},
		{"CurveParams.P", Field, 0},
		{"GenerateKey", Func, 0},
		{"Marshal", Func, 0},
		{"MarshalCompressed", Func, 15},
		{"P224", Func, 0},
		{"P256", Func, 0},
		{"P384", Func, 0},
		{"P521", Func, 0},
		{"Unmarshal", Func, 0},
		{"UnmarshalCompressed", Func, 15},
	},
	"crypto/fips140": {
		{"Enabled", Func, 24},
	},
	"crypto/hkdf": {
		{"Expand", Func, 24},
		{"Extract", Func, 24},
		{"Key", Func, 24},
	},
	"crypto/hmac": {
		{"Equal", Func, 1},
		{"New", Func, 0},
	},
	"crypto/md5": {
		{"BlockSize", Const, 0},
		{"New", Func, 0},
		{"Size", Const, 0},
		{"Sum", Func, 2},
	},
	"crypto/mlkem": {
		{"(*DecapsulationKey1024).Bytes", Method, 24},
		{"(*DecapsulationKey1024).Decapsulate", Method, 24},
		{"(*DecapsulationKey1024).EncapsulationKey", Method, 24},
		{"(*DecapsulationKey768).Bytes", Method, 24},
		{"(*DecapsulationKey768).Decapsulate", Method, 24},
		{"(*DecapsulationKey768).EncapsulationKey", Method, 24},
		{"(*EncapsulationKey1024).Bytes", Method, 24},
		{"(*EncapsulationKey1024).Encapsulate", Method, 24},
		{"(*EncapsulationKey768).Bytes", Method, 24},
		{"(*EncapsulationKey768).Encapsulate", Method, 24},
		{"CiphertextSize1024", Const, 24},
		{"CiphertextSize768", Const, 24},
		{"DecapsulationKey1024", Type, 24},
		{"DecapsulationKey768", Type, 24},
		{"EncapsulationKey1024", Type, 24},
		{"EncapsulationKey768", Type, 24},
		{"EncapsulationKeySize1024", Const, 24},
		{"EncapsulationKeySize768", Const, 24},
		{"GenerateKey1024", Func, 24},
		{"GenerateKey768", Func, 24},
		{"NewDecapsulationKey1024", Func, 24},
		{"NewDecapsulationKey768", Func, 24},
		{"NewEncapsulationKey1024", Func, 24},
		{"NewEncapsulationKey768", Func, 24},
		{"SeedSize", Const, 24},
		{"SharedKeySize", Const, 24},
	},
	"crypto/pbkdf2": {
		{"Key", Func, 24},
	},
	"crypto/rand": {
		{"Int", Func, 0},
		{"Prime", Func, 0},
		{"Read", Func, 0},
		{"Reader", Var, 0},
		{"Text", Func, 24},
	},
	"crypto/rc4": {
		{"(*Cipher).Reset", Method, 0},
		{"(*Cipher).XORKeyStream", Method, 0},
		{"(KeySizeError).Error", Method, 0},
		{"Cipher", Type, 0},
		{"KeySizeError", Type, 0},
		{"NewCipher", Func, 0},
	},
	"crypto/rsa": {
		{"(*PSSOptions).HashFunc", Method, 4},
		{"(*PrivateKey).Decrypt", Method, 5},
		{"(*PrivateKey).Equal", Method, 15},
		{"(*PrivateKey).Precompute", Method, 0},
		{"(*PrivateKey).Public", Method, 4},
		{"(*PrivateKey).Sign", Method, 4},
		{"(*PrivateKey).Size", Method, 11},
		{"(*PrivateKey).Validate", Method, 0},
		{"(*PublicKey).Equal", Method, 15},
		{"(*PublicKey).Size", Method, 11},
		{"CRTValue", Type, 0},
		{"CRTValue.Coeff", Field, 0},
		{"CRTValue.Exp", Field, 0},
		{"CRTValue.R", Field, 0},
		{"DecryptOAEP", Func, 0},
		{"DecryptPKCS1v15", Func, 0},
		{"DecryptPKCS1v15SessionKey", Func, 0},
		{"EncryptOAEP", Func, 0},
		{"EncryptPKCS1v15", Func, 0},
		{"ErrDecryption", Var, 0},
		{"ErrMessageTooLong", Var, 0},
		{"ErrVerification", Var, 0},
		{"GenerateKey", Func, 0},
		{"GenerateMultiPrimeKey", Func, 0},
		{"OAEPOptions", Type, 5},
		{"OAEPOptions.Hash", Field, 5},
		{"OAEPOptions.Label", Field, 5},
		{"OAEPOptions.MGFHash", Field, 20},
		{"PKCS1v15DecryptOptions", Type, 5},
		{"PKCS1v15DecryptOptions.SessionKeyLen", Field, 5},
		{"PSSOptions", Type, 2},
		{"PSSOptions.Hash", Field, 4},
		{"PSSOptions.SaltLength", Field, 2},
		{"PSSSaltLengthAuto", Const, 2},
		{"PSSSaltLengthEqualsHash", Const, 2},
		{"PrecomputedValues", Type, 0},
		{"PrecomputedValues.CRTValues", Field, 0},
		{"PrecomputedValues.Dp", Field, 0},
		{"PrecomputedValues.Dq", Field, 0},
		{"PrecomputedValues.Qinv", Field, 0},
		{"PrivateKey", Type, 0},
		{"PrivateKey.D", Field, 0},
		{"PrivateKey.Precomputed", Field, 0},
		{"PrivateKey.Primes", Field, 0},
		{"PrivateKey.PublicKey", Field, 0},
		{"PublicKey", Type, 0},
		{"PublicKey.E", Field, 0},
		{"PublicKey.N", Field, 0},
		{"SignPKCS1v15", Func, 0},
		{"SignPSS", Func, 2},
		{"VerifyPKCS1v15", Func, 0},
		{"VerifyPSS", Func, 2},
	},
	"crypto/sha1": {
		{"BlockSize", Const, 0},
		{"New", Func, 0},
		{"Size", Const, 0},
		{"Sum", Func, 2},
	},
	"crypto/sha256": {
		{"BlockSize", Const, 0},
		{"New", Func, 0},
		{"New224", Func, 0},
		{"Size", Const, 0},
		{"Size224", Const, 0},
		{"Sum224", Func, 2},
		{"Sum256", Func, 2},
	},
	"crypto/sha3": {
		{"(*SHA3).AppendBinary", Method, 24},
		{"(*SHA3).BlockSize", Method, 24},
		{"(*SHA3).MarshalBinary", Method, 24},
		{"(*SHA3).Reset", Method, 24},
		{"(*SHA3).Size", Method, 24},
		{"(*SHA3).Sum", Method, 24},
		{"(*SHA3).UnmarshalBinary", Method, 24},
		{"(*SHA3).Write", Method, 24},
		{"(*SHAKE).AppendBinary", Method, 24},
		{"(*SHAKE).BlockSize", Method, 24},
		{"(*SHAKE).MarshalBinary", Method, 24},
		{"(*SHAKE).Read", Method, 24},
		{"(*SHAKE).Reset", Method, 24},
		{"(*SHAKE).UnmarshalBinary", Method, 24},
		{"(*SHAKE).Write", Method, 24},
		{"New224", Func, 24},
		{"New256", Func, 24},
		{"New384", Func, 24},
		{"New512", Func, 24},
		{"NewCSHAKE128", Func, 24},
		{"NewCSHAKE256", Func, 24},
		{"NewSHAKE128", Func, 24},
		{"NewSHAKE256", Func, 24},
		{"SHA3", Type, 24},
		{"SHAKE", Type, 24},
		{"Sum224", Func, 24},
		{"Sum256", Func, 24},
		{"Sum384", Func, 24},
		{"Sum512", Func, 24},
		{"SumSHAKE128", Func, 24},
		{"SumSHAKE256", Func, 24},
	},
	"crypto/sha512": {
		{"BlockSize", Const, 0},
		{"New", Func, 0},
		{"New384", Func, 0},
		{"New512_224", Func, 5},
		{"New512_256", Func, 5},
		{"Size", Const, 0},
		{"Size224", Const, 5},
		{"Size256", Const, 5},
		{"Size384", Const, 0},
		{"Sum384", Func, 2},
		{"Sum512", Func, 2},
		{"Sum512_224", Func, 5},
		{"Sum512_256", Func, 5},
	},
	"crypto/subtle": {
		{"ConstantTimeByteEq", Func, 0},
		{"ConstantTimeCompare", Func, 0},
		{"ConstantTimeCopy", Func, 0},
		{"ConstantTimeEq", Func, 0},
		{"ConstantTimeLessOrEq", Func, 2},
		{"ConstantTimeSelect", Func, 0},
		{"WithDataIndependentTiming", Func, 24},
		{"XORBytes", Func, 20},
	},
	"crypto/tls": {
		{"(*CertificateRequestInfo).Context", Method, 17},
		{"(*CertificateRequestInfo).SupportsCertificate", Method, 14},
		{"(*CertificateVerificationError).Error", Method, 20},
		{"(*CertificateVerificationError).Unwrap", Method, 20},
		{"(*ClientHelloInfo).Context", Method, 17},
		{"(*ClientHelloInfo).SupportsCertificate", Method, 14},
		{"(*ClientSessionState).ResumptionState", Method, 21},
		{"(*Config).BuildNameToCertificate", Method, 0},
		{"(*Config).Clone", Method, 8},
		{"(*Config).DecryptTicket", Method, 21},
		{"(*Config).EncryptTicket", Method, 21},
		{"(*Config).SetSessionTicketKeys", Method, 5},
		{"(*Conn).Close", Method, 0},
		{"(*Conn).CloseWrite", Method, 8},
		{"(*Conn).ConnectionState", Method, 0},
		{"(*Conn).Handshake", Method, 0},
		{"(*Conn).HandshakeContext", Method, 17},
		{"(*Conn).LocalAddr", Method, 0},
		{"(*Conn).NetConn", Method, 18},
		{"(*Conn).OCSPResponse", Method, 0},
		{"(*Conn).Read", Method, 0},
		{"(*Conn).RemoteAddr", Method, 0},
		{"(*Conn).SetDeadline", Method, 0},
		{"(*Conn).SetReadDeadline", Method, 0},
		{"(*Conn).SetWriteDeadline", Method, 0},
		{"(*Conn).VerifyHostname", Method, 0},
		{"(*Conn).Write", Method, 0},
		{"(*ConnectionState).ExportKeyingMaterial", Method, 11},
		{"(*Dialer).Dial", Method, 15},
		{"(*Dialer).DialContext", Method, 15},
		{"(*ECHRejectionError).Error", Method, 23},
		{"(*QUICConn).Close", Method, 21},
		{"(*QUICConn).ConnectionState", Method, 21},
		{"(*QUICConn).HandleData", Method, 21},
		{"(*QUICConn).NextEvent", Method, 21},
		{"(*QUICConn).SendSessionTicket", Method, 21},
		{"(*QUICConn).SetTransportParameters", Method, 21},
		{"(*QUICConn).Start", Method, 21},
		{"(*QUICConn).StoreSession", Method, 23},
		{"(*SessionState).Bytes", Method, 21},
		{"(AlertError).Error", Method, 21},
		{"(ClientAuthType).String", Method, 15},
		{"(CurveID).String", Method, 15},
		{"(QUICEncryptionLevel).String", Method, 21},
		{"(RecordHeaderError).Error", Method, 6},
		{"(SignatureScheme).String", Method, 15},
		{"AlertError", Type, 21},
		{"Certificate", Type, 0},
		{"Certificate.Certificate", Field, 0},
		{"Certificate.Leaf", Field, 0},
		{"Certificate.OCSPStaple", Field, 0},
		{"Certificate.PrivateKey", Field, 0},
		{"Certificate.SignedCertificateTimestamps", Field, 5},
		{"Certificate.SupportedSignatureAlgorithms", Field, 14},
		{"CertificateRequestInfo", Type, 8},
		{"CertificateRequestInfo.AcceptableCAs", Field, 8},
		{"CertificateRequestInfo.SignatureSchemes", Field, 8},
		{"CertificateRequestInfo.Version", Field, 14},
		{"CertificateVerificationError", Type, 20},
		{"CertificateVerificationError.Err", Field, 20},
		{"CertificateVerificationError.UnverifiedCertificates", Field, 20},
		{"CipherSuite", Type, 14},
		{"CipherSuite.ID", Field, 14},
		{"CipherSuite.Insecure", Field, 14},
		{"CipherSuite.Name", Field, 14},
		{"CipherSuite.SupportedVersions", Field, 14},
		{"CipherSuiteName", Func, 14},
		{"CipherSuites", Func, 14},
		{"Client", Func, 0},
		{"ClientAuthType", Type, 0},
		{"ClientHelloInfo", Type, 4},
		{"ClientHelloInfo.CipherSuites", Field, 4},
		{"ClientHelloInfo.Conn", Field, 8},
		{"ClientHelloInfo.Extensions", Field, 24},
		{"ClientHelloInfo.ServerName", Field, 4},
		{"ClientHelloInfo.SignatureSchemes", Field, 8},
		{"ClientHelloInfo.SupportedCurves", Field, 4},
		{"ClientHelloInfo.SupportedPoints", Field, 4},
		{"ClientHelloInfo.SupportedProtos", Field, 8},
		{"ClientHelloInfo.SupportedVersions", Field, 8},
		{"ClientSessionCache", Type, 3},
		{"ClientSessionState", Type, 3},
		{"Config", Type, 0},
		{"Config.Certificates", Field, 0},
		{"Config.CipherSuites", Field, 0},
		{"Config.ClientAuth", Field, 0},
		{"Config.ClientCAs", Field, 0},
		{"Config.ClientSessionCache", Field, 3},
		{"Config.CurvePreferences", Field, 3},
		{"Config.DynamicRecordSizingDisabled", Field, 7},
		{"Config.EncryptedClientHelloConfigList", Field, 23},
		{"Config.EncryptedClientHelloKeys", Field, 24},
		{"Config.EncryptedClientHelloRejectionVerify", Field, 23},
		{"Config.GetCertificate", Field, 4},
		{"Config.GetClientCertificate", Field, 8},
		{"Config.GetConfigForClient", Field, 8},
		{"Config.InsecureSkipVerify", Field, 0},
		{"Config.KeyLogWriter", Field, 8},
		{"Config.MaxVersion", Field, 2},
		{"Config.MinVersion", Field, 2},
		{"Config.NameToCertificate", Field, 0},
		{"Config.NextProtos", Field, 0},
		{"Config.PreferServerCipherSuites", Field, 1},
		{"Config.Rand", Field, 0},
		{"Config.Renegotiation", Field, 7},
		{"Config.RootCAs", Field, 0},
		{"Config.ServerName", Field, 0},
		{"Config.SessionTicketKey", Field, 1},
		{"Config.SessionTicketsDisabled", Field, 1},
		{"Config.Time", Field, 0},
		{"Config.UnwrapSession", Field, 21},
		{"Config.VerifyConnection", Field, 15},
		{"Config.VerifyPeerCertificate", Field, 8},
		{"Config.WrapSession", Field, 21},
		{"Conn", Type, 0},
		{"ConnectionState", Type, 0},
		{"ConnectionState.CipherSuite", Field, 0},
		{"ConnectionState.DidResume", Field, 1},
		{"ConnectionState.ECHAccepted", Field, 23},
		{"ConnectionState.HandshakeComplete", Field, 0},
		{"ConnectionState.NegotiatedProtocol", Field, 0},
		{"ConnectionState.NegotiatedProtocolIsMutual", Field, 0},
		{"ConnectionState.OCSPResponse", Field, 5},
		{"ConnectionState.PeerCertificates", Field, 0},
		{"ConnectionState.ServerName", Field, 0},
		{"ConnectionState.SignedCertificateTimestamps", Field, 5},
		{"ConnectionState.TLSUnique", Field, 4},
		{"ConnectionState.VerifiedChains", Field, 0},
		{"ConnectionState.Version", Field, 3},
		{"CurveID", Type, 3},
		{"CurveP256", Const, 3},
		{"CurveP384", Const, 3},
		{"CurveP521", Const, 3},
		{"Dial", Func, 0},
		{"DialWithDialer", Func, 3},
		{"Dialer", Type, 15},
		{"Dialer.Config", Field, 15},
		{"Dialer.NetDialer", Field, 15},
		{"ECDSAWithP256AndSHA256", Const, 8},
		{"ECDSAWithP384AndSHA384", Const, 8},
		{"ECDSAWithP521AndSHA512", Const, 8},
		{"ECDSAWithSHA1", Const, 10},
		{"ECHRejectionError", Type, 23},
		{"ECHRejectionError.RetryConfigList", Field, 23},
		{"Ed25519", Const, 13},
		{"EncryptedClientHelloKey", Type, 24},
		{"EncryptedClientHelloKey.Config", Field, 24},
		{"EncryptedClientHelloKey.PrivateKey", Field, 24},
		{"EncryptedClientHelloKey.SendAsRetry", Field, 24},
		{"InsecureCipherSuites", Func, 14},
		{"Listen", Func, 0},
		{"LoadX509KeyPair", Func, 0},
		{"NewLRUClientSessionCache", Func, 3},
		{"NewListener", Func, 0},
		{"NewResumptionState", Func, 21},
		{"NoClientCert", Const, 0},
		{"PKCS1WithSHA1", Const, 8},
		{"PKCS1WithSHA256", Const, 8},
		{"PKCS1WithSHA384", Const, 8},
		{"PKCS1WithSHA512", Const, 8},
		{"PSSWithSHA256", Const, 8},
		{"PSSWithSHA384", Const, 8},
		{"PSSWithSHA512", Const, 8},
		{"ParseSessionState", Func, 21},
		{"QUICClient", Func, 21},
		{"QUICConfig", Type, 21},
		{"QUICConfig.EnableSessionEvents", Field, 23},
		{"QUICConfig.TLSConfig", Field, 21},
		{"QUICConn", Type, 21},
		{"QUICEncryptionLevel", Type, 21},
		{"QUICEncryptionLevelApplication", Const, 21},
		{"QUICEncryptionLevelEarly", Const, 21},
		{"QUICEncryptionLevelHandshake", Const, 21},
		{"QUICEncryptionLevelInitial", Const, 21},
		{"QUICEvent", Type, 21},
		{"QUICEvent.Data", Field, 21},
		{"QUICEvent.Kind", Field, 21},
		{"QUICEvent.Level", Field, 21},
		{"QUICEvent.SessionState", Field, 23},
		{"QUICEvent.Suite", Field, 21},
		{"QUICEventKind", Type, 21},
		{"QUICHandshakeDone", Const, 21},
		{"QUICNoEvent", Const, 21},
		{"QUICRejectedEarlyData", Const, 21},
		{"QUICResumeSession", Const, 23},
		{"QUICServer", Func, 21},
		{"QUICSessionTicketOptions", Type, 21},
		{"QUICSessionTicketOptions.EarlyData", Field, 21},
		{"QUICSessionTicketOptions.Extra", Field, 23},
		{"QUICSetReadSecret", Const, 21},
		{"QUICSetWriteSecret", Const, 21},
		{"QUICStoreSession", Const, 23},
		{"QUICTransportParameters", Const, 21},
		{"QUICTransportParametersRequired", Const, 21},
		{"QUICWriteData", Const, 21},
		{"RecordHeaderError", Type, 6},
		{"RecordHeaderError.Conn", Field, 12},
		{"RecordHeaderError.Msg", Field, 6},
		{"RecordHeaderError.RecordHeader", Field, 6},
		{"RenegotiateFreelyAsClient", Const, 7},
		{"RenegotiateNever", Const, 7},
		{"RenegotiateOnceAsClient", Const, 7},
		{"RenegotiationSupport", Type, 7},
		{"RequestClientCert", Const, 0},
		{"RequireAndVerifyClientCert", Const, 0},
		{"RequireAnyClientCert", Const, 0},
		{"Server", Func, 0},
		{"SessionState", Type, 21},
		{"SessionState.EarlyData", Field, 21},
		{"SessionState.Extra", Field, 21},
		{"SignatureScheme", Type, 8},
		{"TLS_AES_128_GCM_SHA256", Const, 12},
		{"TLS_AES_256_GCM_SHA384", Const, 12},
		{"TLS_CHACHA20_POLY1305_SHA256", Const, 12},
		{"TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA", Const, 2},
		{"TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256", Const, 8},
		{"TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", Const, 2},
		{"TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA", Const, 2},
		{"TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", Const, 5},
		{"TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305", Const, 8},
		{"TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256", Const, 14},
		{"TLS_ECDHE_ECDSA_WITH_RC4_128_SHA", Const, 2},
		{"TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA", Const, 0},
		{"TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA", Const, 0},
		{"TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256", Const, 8},
		{"TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", Const, 2},
		{"TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA", Const, 1},
		{"TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384", Const, 5},
		{"TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305", Const, 8},
		{"TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256", Const, 14},
		{"TLS_ECDHE_RSA_WITH_RC4_128_SHA", Const, 0},
		{"TLS_FALLBACK_SCSV", Const, 4},
		{"TLS_RSA_WITH_3DES_EDE_CBC_SHA", Const, 0},
		{"TLS_RSA_WITH_AES_128_CBC_SHA", Const, 0},
		{"TLS_RSA_WITH_AES_128_CBC_SHA256", Const, 8},
		{"TLS_RSA_WITH_AES_128_GCM_SHA256", Const, 6},
		{"TLS_RSA_WITH_AES_256_CBC_SHA", Const, 1},
		{"TLS_RSA_WITH_AES_256_GCM_SHA384", Const, 6},
		{"TLS_RSA_WITH_RC4_128_SHA", Const, 0},
		{"VerifyClientCertIfGiven", Const, 0},
		{"VersionName", Func, 21},
		{"VersionSSL30", Const, 2},
		{"VersionTLS10", Const, 2},
		{"VersionTLS11", Const, 2},
		{"VersionTLS12", Const, 2},
		{"VersionTLS13", Const, 12},
		{"X25519", Const, 8},
		{"X25519MLKEM768", Const, 24},
		{"X509KeyPair", Func, 0},
	},
	"crypto/x509": {
		{"(*CertPool).AddCert", Method, 0},
		{"(*CertPool).AddCertWithConstraint", Method, 22},
		{"(*CertPool).AppendCertsFromPEM", Method, 0},
		{"(*CertPool).Clone", Method, 19},
		{"(*CertPool).Equal", Method, 19},
		{"(*CertPool).Subjects", Method, 0},
		{"(*Certificate).CheckCRLSignature", Method, 0},
		{"(*Certificate).CheckSignature", Method, 0},
		{"(*Certificate).CheckSignatureFrom", Method, 0},
		{"(*Certificate).CreateCRL", Method, 0},
		{"(*Certificate).Equal", Method, 0},
		{"(*Certificate).Verify", Method, 0},
		{"(*Certificate).VerifyHostname", Method, 0},
		{"(*CertificateRequest).CheckSignature", Method, 5},
		{"(*OID).UnmarshalBinary", Method, 23},
		{"(*OID).UnmarshalText", Method, 23},
		{"(*RevocationList).CheckSignatureFrom", Method, 19},
		{"(CertificateInvalidError).Error", Method, 0},
		{"(ConstraintViolationError).Error", Method, 0},
		{"(HostnameError).Error", Method, 0},
		{"(InsecureAlgorithmError).Error", Method, 6},
		{"(OID).AppendBinary", Method, 24},
		{"(OID).AppendText", Method, 24},
		{"(OID).Equal", Method, 22},
		{"(OID).EqualASN1OID", Method, 22},
		{"(OID).MarshalBinary", Method, 23},
		{"(OID).MarshalText", Method, 23},
		{"(OID).String", Method, 22},
		{"(PublicKeyAlgorithm).String", Method, 10},
		{"(SignatureAlgorithm).String", Method, 6},
		{"(SystemRootsError).Error", Method, 1},
		{"(SystemRootsError).Unwrap", Method, 16},
		{"(UnhandledCriticalExtension).Error", Method, 0},
		{"(UnknownAuthorityError).Error", Method, 0},
		{"CANotAuthorizedForExtKeyUsage", Const, 10},
		{"CANotAuthorizedForThisName", Const, 0},
		{"CertPool", Type, 0},
		{"Certificate", Type, 0},
		{"Certificate.AuthorityKeyId", Field, 0},
		{"Certificate.BasicConstraintsValid", Field, 0},
		{"Certificate.CRLDistributionPoints", Field, 2},
		{"Certificate.DNSNames", Field, 0},
		{"Certificate.EmailAddresses", Field, 0},
		{"Certificate.ExcludedDNSDomains", Field, 9},
		{"Certificate.ExcludedEmailAddresses", Field, 10},
		{"Certificate.ExcludedIPRanges", Field, 10},
		{"Certificate.ExcludedURIDomains", Field, 10},
		{"Certificate.ExtKeyUsage", Field, 0},
		{"Certificate.Extensions", Field, 2},
		{"Certificate.ExtraExtensions", Field, 2},
		{"Certificate.IPAddresses", Field, 1},
		{"Certificate.InhibitAnyPolicy", Field, 24},
		{"Certificate.InhibitAnyPolicyZero", Field, 24},
		{"Certificate.InhibitPolicyMapping", Field, 24},
		{"Certificate.InhibitPolicyMappingZero", Field, 24},
		{"Certificate.IsCA", Field, 0},
		{"Certificate.Issuer", Field, 0},
		{"Certificate.IssuingCertificateURL", Field, 2},
		{"Certificate.KeyUsage", Field, 0},
		{"Certificate.MaxPathLen", Field, 0},
		{"Certificate.MaxPathLenZero", Field, 4},
		{"Certificate.NotAfter", Field, 0},
		{"Certificate.NotBefore", Field, 0},
		{"Certificate.OCSPServer", Field, 2},
		{"Certificate.PermittedDNSDomains", Field, 0},
		{"Certificate.PermittedDNSDomainsCritical", Field, 0},
		{"Certificate.PermittedEmailAddresses", Field, 10},
		{"Certificate.PermittedIPRanges", Field, 10},
		{"Certificate.PermittedURIDomains", Field, 10},
		{"Certificate.Policies", Field, 22},
		{"Certificate.PolicyIdentifiers", Field, 0},
		{"Certificate.PolicyMappings", Field, 24},
		{"Certificate.PublicKey", Field, 0},
		{"Certificate.PublicKeyAlgorithm", Field, 0},
		{"Certificate.Raw", Field, 0},
		{"Certificate.RawIssuer", Field, 0},
		{"Certificate.RawSubject", Field, 0},
		{"Certificate.RawSubjectPublicKeyInfo", Field, 0},
		{"Certificate.RawTBSCertificate", Field, 0},
		{"Certificate.RequireExplicitPolicy", Field, 24},
		{"Certificate.RequireExplicitPolicyZero", Field, 24},
		{"Certificate.SerialNumber", Field, 0},
		{"Certificate.Signature", Field, 0},
		{"Certificate.SignatureAlgorithm", Field, 0},
		{"Certificate.Subject", Field, 0},
		{"Certificate.SubjectKeyId", Field, 0},
		{"Certificate.URIs", Field, 10},
		{"Certificate.UnhandledCriticalExtensions", Field, 5},
		{"Certificate.UnknownExtKeyUsage", Field, 0},
		{"Certificate.Version", Field, 0},
		{"CertificateInvalidError", Type, 0},
		{"CertificateInvalidError.Cert", Field, 0},
		{"CertificateInvalidError.Detail", Field, 10},
		{"CertificateInvalidError.Reason", Field, 0},
		{"CertificateRequest", Type, 3},
		{"CertificateRequest.Attributes", Field, 3},
		{"CertificateRequest.DNSNames", Field, 3},
		{"CertificateRequest.EmailAddresses", Field, 3},
		{"CertificateRequest.Extensions", Field, 3},
		{"CertificateRequest.ExtraExtensions", Field, 3},
		{"CertificateRequest.IPAddresses", Field, 3},
		{"CertificateRequest.PublicKey", Field, 3},
		{"CertificateRequest.PublicKeyAlgorithm", Field, 3},
		{"CertificateRequest.Raw", Field, 3},
		{"CertificateRequest.RawSubject", Field, 3},
		{"CertificateRequest.RawSubjectPublicKeyInfo", Field, 3},
		{"CertificateRequest.RawTBSCertificateRequest", Field, 3},
		{"CertificateRequest.Signature", Field, 3},
		{"CertificateRequest.SignatureAlgorithm", Field, 3},
		{"CertificateRequest.Subject", Field, 3},
		{"CertificateRequest.URIs", Field, 10},
		{"CertificateRequest.Version", Field, 3},
		{"ConstraintViolationError", Type, 0},
		{"CreateCertificate", Func, 0},
		{"CreateCertificateRequest", Func, 3},
		{"CreateRevocationList", Func, 15},
		{"DSA", Const, 0},
		{"DSAWithSHA1", Const, 0},
		{"DSAWithSHA256", Const, 0},
		{"DecryptPEMBlock", Func, 1},
		{"ECDSA", Const, 1},
		{"ECDSAWithSHA1", Const, 1},
		{"ECDSAWithSHA256", Const, 1},
		{"ECDSAWithSHA384", Const, 1},
		{"ECDSAWithSHA512", Const, 1},
		{"Ed25519", Const, 13},
		{"EncryptPEMBlock", Func, 1},
		{"ErrUnsupportedAlgorithm", Var, 0},
		{"Expired", Const, 0},
		{"ExtKeyUsage", Type, 0},
		{"ExtKeyUsageAny", Const, 0},
		{"ExtKeyUsageClientAuth", Const, 0},
		{"ExtKeyUsageCodeSigning", Const, 0},
		{"ExtKeyUsageEmailProtection", Const, 0},
		{"ExtKeyUsageIPSECEndSystem", Const, 1},
		{"ExtKeyUsageIPSECTunnel", Const, 1},
		{"ExtKeyUsageIPSECUser", Const, 1},
		{"ExtKeyUsageMicrosoftCommercialCodeSigning", Const, 10},
		{"ExtKeyUsageMicrosoftKernelCodeSigning", Const, 10},
		{"ExtKeyUsageMicrosoftServerGatedCrypto", Const, 1},
		{"ExtKeyUsageNetscapeServerGatedCrypto", Const, 1},
		{"ExtKeyUsageOCSPSigning", Const, 0},
		{"ExtKeyUsageServerAuth", Const, 0},
		{"ExtKeyUsageTimeStamping", Const, 0},
		{"HostnameError", Type, 0},
		{"HostnameError.Certificate", Field, 0},
		{"HostnameError.Host", Field, 0},
		{"IncompatibleUsage", Const, 1},
		{"IncorrectPasswordError", Var, 1},
		{"InsecureAlgorithmError", Type, 6},
		{"InvalidReason", Type, 0},
		{"IsEncryptedPEMBlock", Func, 1},
		{"KeyUsage", Type, 0},
		{"KeyUsageCRLSign", Const, 0},
		{"KeyUsageCertSign", Const, 0},
		{"KeyUsageContentCommitment", Const, 0},
		{"KeyUsageDataEncipherment", Const, 0},
		{"KeyUsageDecipherOnly", Const, 0},
		{"KeyUsageDigitalSignature", Const, 0},
		{"KeyUsageEncipherOnly", Const, 0},
		{"KeyUsageKeyAgreement", Const, 0},
		{"KeyUsageKeyEncipherment", Const, 0},
		{"MD2WithRSA", Const, 0},
		{"MD5WithRSA", Const, 0},
		{"MarshalECPrivateKey", Func, 2},
		{"MarshalPKCS1PrivateKey", Func, 0},
		{"MarshalPKCS1PublicKey", Func, 10},
		{"MarshalPKCS8PrivateKey", Func, 10},
		{"MarshalPKIXPublicKey", Func, 0},
		{"NameConstraintsWithoutSANs", Const, 10},
		{"NameMismatch", Const, 8},
		{"NewCertPool", Func, 0},
		{"NoValidChains", Const, 24},
		{"NotAuthorizedToSign", Const, 0},
		{"OID", Type, 22},
		{"OIDFromInts", Func, 22},
		{"PEMCipher", Type, 1},
		{"PEMCipher3DES", Const, 1},
		{"PEMCipherAES128", Const, 1},
		{"PEMCipherAES192", Const, 1},
		{"PEMCipherAES256", Const, 1},
		{"PEMCipherDES", Const, 1},
		{"ParseCRL", Func, 0},
		{"ParseCertificate", Func, 0},
		{"ParseCertificateRequest", Func, 3},
		{"ParseCertificates", Func, 0},
		{"ParseDERCRL", Func, 0},
		{"ParseECPrivateKey", Func, 1},
		{"ParseOID", Func, 23},
		{"ParsePKCS1PrivateKey", Func, 0},
		{"ParsePKCS1PublicKey", Func, 10},
		{"ParsePKCS8PrivateKey", Func, 0},
		{"ParsePKIXPublicKey", Func, 0},
		{"ParseRevocationList", Func, 19},
		{"PolicyMapping", Type, 24},
		{"PolicyMapping.IssuerDomainPolicy", Field, 24},
		{"PolicyMapping.SubjectDomainPolicy", Field, 24},
		{"PublicKeyAlgorithm", Type, 0},
		{"PureEd25519", Const, 13},
		{"RSA", Const, 0},
		{"RevocationList", Type, 15},
		{"RevocationList.AuthorityKeyId", Field, 19},
		{"RevocationList.Extensions", Field, 19},
		{"RevocationList.ExtraExtensions", Field, 15},
		{"RevocationList.Issuer", Field, 19},
		{"RevocationList.NextUpdate", Field, 15},
		{"RevocationList.Number", Field, 15},
		{"RevocationList.Raw", Field, 19},
		{"RevocationList.RawIssuer", Field, 19},
		{"RevocationList.RawTBSRevocationList", Field, 19},
		{"RevocationList.RevokedCertificateEntries", Field, 21},
		{"RevocationList.RevokedCertificates", Field, 15},
		{"RevocationList.Signature", Field, 19},
		{"RevocationList.SignatureAlgorithm", Field, 15},
		{"RevocationList.ThisUpdate", Field, 15},
		{"RevocationListEntry", Type, 21},
		{"RevocationListEntry.Extensions", Field, 21},
		{"RevocationListEntry.ExtraExtensions", Field, 21},
		{"RevocationListEntry.Raw", Field, 21},
		{"RevocationListEntry.ReasonCode", Field, 21},
		{"RevocationListEntry.RevocationTime", Field, 21},
		{"RevocationListEntry.SerialNumber", Field, 21},
		{"SHA1WithRSA", Const, 0},
		{"SHA256WithRSA", Const, 0},
		{"SHA256WithRSAPSS", Const, 8},
		{"SHA384WithRSA", Const, 0},
		{"SHA384WithRSAPSS", Const, 8},
		{"SHA512WithRSA", Const, 0},
		{"SHA512WithRSAPSS", Const, 8},
		{"SetFallbackRoots", Func, 20},
		{"SignatureAlgorithm", Type, 0},
		{"SystemCertPool", Func, 7},
		{"SystemRootsError", Type, 1},
		{"SystemRootsError.Err", Field, 7},
		{"TooManyConstraints", Const, 10},
		{"TooManyIntermediates", Const, 0},
		{"UnconstrainedName", Const, 10},
		{"UnhandledCriticalExtension", Type, 0},
		{"UnknownAuthorityError", Type, 0},
		{"UnknownAuthorityError.Cert", Field, 8},
		{"UnknownPublicKeyAlgorithm", Const, 0},
		{"UnknownSignatureAlgorithm", Const, 0},
		{"VerifyOptions", Type, 0},
		{"VerifyOptions.CertificatePolicies", Field, 24},
		{"VerifyOptions.CurrentTime", Field, 0},
		{"VerifyOptions.DNSName", Field, 0},
		{"VerifyOptions.Intermediates", Field, 0},
		{"VerifyOptions.KeyUsages", Field, 1},
		{"VerifyOptions.MaxConstraintComparisions", Field, 10},
		{"VerifyOptions.Roots", Field, 0},
	},
	"crypto/x509/pkix": {
		{"(*CertificateList).HasExpired", Method, 0},
		{"(*Name).FillFromRDNSequence", Method, 0},
		{"(Name).String", Method, 10},
		{"(Name).ToRDNSequence", Method, 0},
		{"(RDNSequence).String", Method, 10},
		{"AlgorithmIdentifier", Type, 0},
		{"AlgorithmIdentifier.Algorithm", Field, 0},
		{"AlgorithmIdentifier.Parameters", Field, 0},
		{"AttributeTypeAndValue", Type, 0},
		{"AttributeTypeAndValue.Type", Field, 0},
		{"AttributeTypeAndValue.Value", Field, 0},
		{"AttributeTypeAndValueSET", Type, 3},
		{"AttributeTypeAndValueSET.Type", Field, 3},
		{"AttributeTypeAndValueSET.Value", Field, 3},
		{"CertificateList", Type, 0},
		{"CertificateList.SignatureAlgorithm", Field, 0},
		{"CertificateList.SignatureValue", Field, 0},
		{"CertificateList.TBSCertList", Field, 0},
		{"Extension", Type, 0},
		{"Extension.Critical", Field, 0},
		{"Extension.Id", Field, 0},
		{"Extension.Value", Field, 0},
		{"Name", Type, 0},
		{"Name.CommonName", Field, 0},
		{"Name.Country", Field, 0},
		{"Name.ExtraNames", Field, 5},
		{"Name.Locality", Field, 0},
		{"Name.Names", Field, 0},
		{"Name.Organization", Field, 0},
		{"Name.OrganizationalUnit", Field, 0},
		{"Name.PostalCode", Field, 0},
		{"Name.Province", Field, 0},
		{"Name.SerialNumber", Field, 0},
		{"Name.StreetAddress", Field, 0},
		{"RDNSequence", Type, 0},
		{"RelativeDistinguishedNameSET", Type, 0},
		{"RevokedCertificate", Type, 0},
		{"RevokedCertificate.Extensions", Field, 0},
		{"RevokedCertificate.RevocationTime", Field, 0},
		{"RevokedCertificate.SerialNumber", Field, 0},
		{"TBSCertificateList", Type, 0},
		{"TBSCertificateList.Extensions", Field, 0},
		{"TBSCertificateList.Issuer", Field, 0},
		{"TBSCertificateList.NextUpdate", Field, 0},
		{"TBSCertificateList.Raw", Field, 0},
		{"TBSCertificateList.RevokedCertificates", Field, 0},
		{"TBSCertificateList.Signature", Field, 0},
		{"TBSCertificateList.ThisUpdate", Field, 0},
		{"TBSCertificateList.Version", Field, 0},
	},
	"database/sql": {
		{"(*ColumnType).DatabaseTypeName", Method, 8},
		{"(*ColumnType).DecimalSize", Method, 8},
		{"(*ColumnType).Length", Method, 8},
		{"(*ColumnType).Name", Method, 8},
		{"(*ColumnType).Nullable", Method, 8},
		{"(*ColumnType).ScanType", Method, 8},
		{"(*Conn).BeginTx", Method, 9},
		{"(*Conn).Close", Method, 9},
		{"(*Conn).ExecContext", Method, 9},
		{"(*Conn).PingContext", Method, 9},
		{"(*Conn).PrepareContext", Method, 9},
		{"(*Conn).QueryContext", Method, 9},
		{"(*Conn).QueryRowContext", Method, 9},
		{"(*Conn).Raw", Method, 13},
		{"(*DB).Begin", Method, 0},
		{"(*DB).BeginTx", Method, 8},
		{"(*DB).Close", Method, 0},
		{"(*DB).Conn", Method, 9},
		{"(*DB).Driver", Method, 0},
		{"(*DB).Exec", Method, 0},
		{"(*DB).ExecContext", Method, 8},
		{"(*DB).Ping", Method, 1},
		{"(*DB).PingContext", Method, 8},
		{"(*DB).Prepare", Method, 0},
		{"(*DB).PrepareContext", Method, 8},
		{"(*DB).Query", Method, 0},
		{"(*DB).QueryContext", Method, 8},
		{"(*DB).QueryRow", Method, 0},
		{"(*DB).QueryRowContext", Method, 8},
		{"(*DB).SetConnMaxIdleTime", Method, 15},
		{"(*DB).SetConnMaxLifetime", Method, 6},
		{"(*DB).SetMaxIdleConns", Method, 1},
		{"(*DB).SetMaxOpenConns", Method, 2},
		{"(*DB).Stats", Method, 5},
		{"(*Null).Scan", Method, 22},
		{"(*NullBool).Scan", Method, 0},
		{"(*NullByte).Scan", Method, 17},
		{"(*NullFloat64).Scan", Method, 0},
		{"(*NullInt16).Scan", Method, 17},
		{"(*NullInt32).Scan", Method, 13},
		{"(*NullInt64).Scan", Method, 0},
		{"(*NullString).Scan", Method, 0},
		{"(*NullTime).Scan", Method, 13},
		{"(*Row).Err", Method, 15},
		{"(*Row).Scan", Method, 0},
		{"(*Rows).Close", Method, 0},
		{"(*Rows).ColumnTypes", Method, 8},
		{"(*Rows).Columns", Method, 0},
		{"(*Rows).Err", Method, 0},
		{"(*Rows).Next", Method, 0},
		{"(*Rows).NextResultSet", Method, 8},
		{"(*Rows).Scan", Method, 0},
		{"(*Stmt).Close", Method, 0},
		{"(*Stmt).Exec", Method, 0},
		{"(*Stmt).ExecContext", Method, 8},
		{"(*Stmt).Query", Method, 0},
		{"(*Stmt).QueryContext", Method, 8},
		{"(*Stmt).QueryRow", Method, 0},
		{"(*Stmt).QueryRowContext", Method, 8},
		{"(*Tx).Commit", Method, 0},
		{"(*Tx).Exec", Method, 0},
		{"(*Tx).ExecContext", Method, 8},
		{"(*Tx).Prepare", Method, 0},
		{"(*Tx).PrepareContext", Method, 8},
		{"(*Tx).Query", Method, 0},
		{"(*Tx).QueryContext", Method, 8},
		{"(*Tx).QueryRow", Method, 0},
		{"(*Tx).QueryRowContext", Method, 8},
		{"(*Tx).Rollback", Method, 0},
		{"(*Tx).Stmt", Method, 0},
		{"(*Tx).StmtContext", Method, 8},
		{"(IsolationLevel).String", Method, 11},
		{"(Null).Value", Method, 22},
		{"(NullBool).Value", Method, 0},
		{"(NullByte).Value", Method, 17},
		{"(NullFloat64).Value", Method, 0},
		{"(NullInt16).Value", Method, 17},
		{"(NullInt32).Value", Method, 13},
		{"(NullInt64).Value", Method, 0},
		{"(NullString).Value", Method, 0},
		{"(NullTime).Value", Method, 13},
		{"ColumnType", Type, 8},
		{"Conn", Type, 9},
		{"DB", Type, 0},
		{"DBStats", Type, 5},
		{"DBStats.Idle", Field, 11},
		{"DBStats.InUse", Field, 11},
		{"DBStats.MaxIdleClosed", Field, 11},
		{"DBStats.MaxIdleTimeClosed", Field, 15},
		{"DBStats.MaxLifetimeClosed", Field, 11},
		{"DBStats.MaxOpenConnections", Field, 11},
		{"DBStats.OpenConnections", Field, 5},
		{"DBStats.WaitCount", Field, 11},
		{"DBStats.WaitDuration", Field, 11},
		{"Drivers", Func, 4},
		{"ErrConnDone", Var, 9},
		{"ErrNoRows", Var, 0},
		{"ErrTxDone", Var, 0},
		{"IsolationLevel", Type, 8},
		{"LevelDefault", Const, 8},
		{"LevelLinearizable", Const, 8},
		{"LevelReadCommitted", Const, 8},
		{"LevelReadUncommitted", Const, 8},
		{"LevelRepeatableRead", Const, 8},
		{"LevelSerializable", Const, 8},
		{"LevelSnapshot", Const, 8},
		{"LevelWriteCommitted", Const, 8},
		{"Named", Func, 8},
		{"NamedArg", Type, 8},
		{"NamedArg.Name", Field, 8},
		{"NamedArg.Value", Field, 8},
		{"Null", Type, 22},
		{"Null.V", Field, 22},
		{"Null.Valid", Field, 22},
		{"NullBool", Type, 0},
		{"NullBool.Bool", Field, 0},
		{"NullBool.Valid", Field, 0},
		{"NullByte", Type, 17},
		{"NullByte.Byte", Field, 17},
		{"NullByte.Valid", Field, 17},
		{"NullFloat64", Type, 0},
		{"NullFloat64.Float64", Field, 0},
		{"NullFloat64.Valid", Field, 0},
		{"NullInt16", Type, 17},
		{"NullInt16.Int16", Field, 17},
		{"NullInt16.Valid", Field, 17},
		{"NullInt32", Type, 13},
		{"NullInt32.Int32", Field, 13},
		{"NullInt32.Valid", Field, 13},
		{"NullInt64", Type, 0},
		{"NullInt64.Int64", Field, 0},
		{"NullInt64.Valid", Field, 0},
		{"NullString", Type, 0},
		{"NullString.String", Field, 0},
		{"NullString.Valid", Field, 0},
		{"NullTime", Type, 13},
		{"NullTime.Time", Field, 13},
		{"NullTime.Valid", Field, 13},
		{"Open", Func, 0},
		{"OpenDB", Func, 10},
		{"Out", Type, 9},
		{"Out.Dest", Field, 9},
		{"Out.In", Field, 9},
		{"RawBytes", Type, 0},
		{"Register", Func, 0},
		{"Result", Type, 0},
		{"Row", Type, 0},
		{"Rows", Type, 0},
		{"Scanner", Type, 0},
		{"Stmt", Type, 0},
		{"Tx", Type, 0},
		{"TxOptions", Type, 8},
		{"TxOptions.Isolation", Field, 8},
		{"TxOptions.ReadOnly", Field, 8},
	},
	"database/sql/driver": {
		{"(NotNull).ConvertValue", Method, 0},
		{"(Null).ConvertValue", Method, 0},
		{"(RowsAffected).LastInsertId", Method, 0},
		{"(RowsAffected).RowsAffected", Method, 0},
		{"Bool", Var, 0},
		{"ColumnConverter", Type, 0},
		{"Conn", Type, 0},
		{"ConnBeginTx", Type, 8},
		{"ConnPrepareContext", Type, 8},
		{"Connector", Type, 10},
		{"DefaultParameterConverter", Var, 0},
		{"Driver", Type, 0},
		{"DriverContext", Type, 10},
		{"ErrBadConn", Var, 0},
		{"ErrRemoveArgument", Var, 9},
		{"ErrSkip", Var, 0},
		{"Execer", Type, 0},
		{"ExecerContext", Type, 8},
		{"Int32", Var, 0},
		{"IsScanValue", Func, 0},
		{"IsValue", Func, 0},
		{"IsolationLevel", Type, 8},
		{"NamedValue", Type, 8},
		{"NamedValue.Name", Field, 8},
		{"NamedValue.Ordinal", Field, 8},
		{"NamedValue.Value", Field, 8},
		{"NamedValueChecker", Type, 9},
		{"NotNull", Type, 0},
		{"NotNull.Converter", Field, 0},
		{"Null", Type, 0},
		{"Null.Converter", Field, 0},
		{"Pinger", Type, 8},
		{"Queryer", Type, 1},
		{"QueryerContext", Type, 8},
		{"Result", Type, 0},
		{"ResultNoRows", Var, 0},
		{"Rows", Type, 0},
		{"RowsAffected", Type, 0},
		{"RowsColumnTypeDatabaseTypeName", Type, 8},
		{"RowsColumnTypeLength", Type, 8},
		{"RowsColumnTypeNullable", Type, 8},
		{"RowsColumnTypePrecisionScale", Type, 8},
		{"RowsColumnTypeScanType", Type, 8},
		{"RowsNextResultSet", Type, 8},
		{"SessionResetter", Type, 10},
		{"Stmt", Type, 0},
		{"StmtExecContext", Type, 8},
		{"StmtQueryContext", Type, 8},
		{"String", Var, 0},
		{"Tx", Type, 0},
		{"TxOptions", Type, 8},
		{"TxOptions.Isolation", Field, 8},
		{"TxOptions.ReadOnly", Field, 8},
		{"Validator", Type, 15},
		{"Value", Type, 0},
		{"ValueConverter", Type, 0},
		{"Valuer", Type, 0},
	},
	"debug/buildinfo": {
		{"BuildInfo", Type, 18},
		{"Read", Func, 18},
		{"ReadFile", Func, 18},
	},
	"debug/dwarf": {
		{"(*AddrType).Basic", Method, 0},
		{"(*AddrType).Common", Method, 0},
		{"(*AddrType).Size", Method, 0},
		{"(*AddrType).String", Method, 0},
		{"(*ArrayType).Common", Method, 0},
		{"(*ArrayType).Size", Method, 0},
		{"(*ArrayType).String", Method, 0},
		{"(*BasicType).Basic", Method, 0},
		{"(*BasicType).Common", Method, 0},
		{"(*BasicType).Size", Method, 0},
		{"(*BasicType).String", Method, 0},
		{"(*BoolType).Basic", Method, 0},
		{"(*BoolType).Common", Method, 0},
		{"(*BoolType).Size", Method, 0},
		{"(*BoolType).String", Method, 0},
		{"(*CharType).Basic", Method, 0},
		{"(*CharType).Common", Method, 0},
		{"(*CharType).Size", Method, 0},
		{"(*CharType).String", Method, 0},
		{"(*CommonType).Common", Method, 0},
		{"(*CommonType).Size", Method, 0},
		{"(*ComplexType).Basic", Method, 0},
		{"(*ComplexType).Common", Method, 0},
		{"(*ComplexType).Size", Method, 0},
		{"(*ComplexType).String", Method, 0},
		{"(*Data).AddSection", Method, 14},
		{"(*Data).AddTypes", Method, 3},
		{"(*Data).LineReader", Method, 5},
		{"(*Data).Ranges", Method, 7},
		{"(*Data).Reader", Method, 0},
		{"(*Data).Type", Method, 0},
		{"(*DotDotDotType).Common", Method, 0},
		{"(*DotDotDotType).Size", Method, 0},
		{"(*DotDotDotType).String", Method, 0},
		{"(*Entry).AttrField", Method, 5},
		{"(*Entry).Val", Method, 0},
		{"(*EnumType).Common", Method, 0},
		{"(*EnumType).Size", Method, 0},
		{"(*EnumType).String", Method, 0},
		{"(*FloatType).Basic", Method, 0},
		{"(*FloatType).Common", Method, 0},
		{"(*FloatType).Size", Method, 0},
		{"(*FloatType).String", Method, 0},
		{"(*FuncType).Common", Method, 0},
		{"(*FuncType).Size", Method, 0},
		{"(*FuncType).String", Method, 0},
		{"(*IntType).Basic", Method, 0},
		{"(*IntType).Common", Method, 0},
		{"(*IntType).Size", Method, 0},
		{"(*IntType).String", Method, 0},
		{"(*LineReader).Files", Method, 14},
		{"(*LineReader).Next", Method, 5},
		{"(*LineReader).Reset", Method, 5},
		{"(*LineReader).Seek", Method, 5},
		{"(*LineReader).SeekPC", Method, 5},
		{"(*LineReader).Tell", Method, 5},
		{"(*PtrType).Common", Method, 0},
		{"(*PtrType).Size", Method, 0},
		{"(*PtrType).String", Method, 0},
		{"(*QualType).Common", Method, 0},
		{"(*QualType).Size", Method, 0},
		{"(*QualType).String", Method, 0},
		{"(*Reader).AddressSize", Method, 5},
		{"(*Reader).ByteOrder", Method, 14},
		{"(*Reader).Next", Method, 0},
		{"(*Reader).Seek", Method, 0},
		{"(*Reader).SeekPC", Method, 7},
		{"(*Reader).SkipChildren", Method, 0},
		{"(*StructType).Common", Method, 0},
		{"(*StructType).Defn", Method, 0},
		{"(*StructType).Size", Method, 0},
		{"(*StructType).String", Method, 0},
		{"(*TypedefType).Common", Method, 0},
		{"(*TypedefType).Size", Method, 0},
		{"(*TypedefType).String", Method, 0},
		{"(*UcharType).Basic", Method, 0},
		{"(*UcharType).Common", Method, 0},
		{"(*UcharType).Size", Method, 0},
		{"(*UcharType).String", Method, 0},
		{"(*UintType).Basic", Method, 0},
		{"(*UintType).Common", Method, 0},
		{"(*UintType).Size", Method, 0},
		{"(*UintType).String", Method, 0},
		{"(*UnspecifiedType).Basic", Method, 4},
		{"(*UnspecifiedType).Common", Method, 4},
		{"(*UnspecifiedType).Size", Method, 4},
		{"(*UnspecifiedType).String", Method, 4},
		{"(*UnsupportedType).Common", Method, 13},
		{"(*UnsupportedType).Size", Method, 13},
		{"(*UnsupportedType).String", Method, 13},
		{"(*VoidType).Common", Method, 0},
		{"(*VoidType).Size", Method, 0},
		{"(*VoidType).String", Method, 0},
		{"(Attr).GoString", Method, 0},
		{"(Attr).String", Method, 0},
		{"(Class).GoString", Method, 5},
		{"(Class).String", Method, 5},
		{"(DecodeError).Error", Method, 0},
		{"(Tag).GoString", Method, 0},
		{"(Tag).String", Method, 0},
		{"AddrType", Type, 0},
		{"AddrType.BasicType", Field, 0},
		{"ArrayType", Type, 0},
		{"ArrayType.CommonType", Field, 0},
		{"ArrayType.Count", Field, 0},
		{"ArrayType.StrideBitSize", Field, 0},
		{"ArrayType.Type", Field, 0},
		{"Attr", Type, 0},
		{"AttrAbstractOrigin", Const, 0},
		{"AttrAccessibility", Const, 0},
		{"AttrAddrBase", Const, 14},
		{"AttrAddrClass", Const, 0},
		{"AttrAlignment", Const, 14},
		{"AttrAllocated", Const, 0},
		{"AttrArtificial", Const, 0},
		{"AttrAssociated", Const, 0},
		{"AttrBaseTypes", Const, 0},
		{"AttrBinaryScale", Const, 14},
		{"AttrBitOffset", Const, 0},
		{"AttrBitSize", Const, 0},
		{"AttrByteSize", Const, 0},
		{"AttrCallAllCalls", Const, 14},
		{"AttrCallAllSourceCalls", Const, 14},
		{"AttrCallAllTailCalls", Const, 14},
		{"AttrCallColumn", Const, 0},
		{"AttrCallDataLocation", Const, 14},
		{"AttrCallDataValue", Const, 14},
		{"AttrCallFile", Const, 0},
		{"AttrCallLine", Const, 0},
		{"AttrCallOrigin", Const, 14},
		{"AttrCallPC", Const, 14},
		{"AttrCallParameter", Const, 14},
		{"AttrCallReturnPC", Const, 14},
		{"AttrCallTailCall", Const, 14},
		{"AttrCallTarget", Const, 14},
		{"AttrCallTargetClobbered", Const, 14},
		{"AttrCallValue", Const, 14},
		{"AttrCalling", Const, 0},
		{"AttrCommonRef", Const, 0},
		{"AttrCompDir", Const, 0},
		{"AttrConstExpr", Const, 14},
		{"AttrConstValue", Const, 0},
		{"AttrContainingType", Const, 0},
		{"AttrCount", Const, 0},
		{"AttrDataBitOffset", Const, 14},
		{"AttrDataLocation", Const, 0},
		{"AttrDataMemberLoc", Const, 0},
		{"AttrDecimalScale", Const, 14},
		{"AttrDecimalSign", Const, 14},
		{"AttrDeclColumn", Const, 0},
		{"AttrDeclFile", Const, 0},
		{"AttrDeclLine", Const, 0},
		{"AttrDeclaration", Const, 0},
		{"AttrDefaultValue", Const, 0},
		{"AttrDefaulted", Const, 14},
		{"AttrDeleted", Const, 14},
		{"AttrDescription", Const, 0},
		{"AttrDigitCount", Const, 14},
		{"AttrDiscr", Const, 0},
		{"AttrDiscrList", Const, 0},
		{"AttrDiscrValue", Const, 0},
		{"AttrDwoName", Const, 14},
		{"AttrElemental", Const, 14},
		{"AttrEncoding", Const, 0},
		{"AttrEndianity", Const, 14},
		{"AttrEntrypc", Const, 0},
		{"AttrEnumClass", Const, 14},
		{"AttrExplicit", Const, 14},
		{"AttrExportSymbols", Const, 14},
		{"AttrExtension", Const, 0},
		{"AttrExternal", Const, 0},
		{"AttrFrameBase", Const, 0},
		{"AttrFriend", Const, 0},
		{"AttrHighpc", Const, 0},
		{"AttrIdentifierCase", Const, 0},
		{"AttrImport", Const, 0},
		{"AttrInline", Const, 0},
		{"AttrIsOptional", Const, 0},
		{"AttrLanguage", Const, 0},
		{"AttrLinkageName", Const, 14},
		{"AttrLocation", Const, 0},
		{"AttrLoclistsBase", Const, 14},
		{"AttrLowerBound", Const, 0},
		{"AttrLowpc", Const, 0},
		{"AttrMacroInfo", Const, 0},
		{"AttrMacros", Const, 14},
		{"AttrMainSubprogram", Const, 14},
		{"AttrMutable", Const, 14},
		{"AttrName", Const, 0},
		{"AttrNamelistItem", Const, 0},
		{"AttrNoreturn", Const, 14},
		{"AttrObjectPointer", Const, 14},
		{"AttrOrdering", Const, 0},
		{"AttrPictureString", Const, 14},
		{"AttrPriority", Const, 0},
		{"AttrProducer", Const, 0},
		{"AttrPrototyped", Const, 0},
		{"AttrPure", Const, 14},
		{"AttrRanges", Const, 0},
		{"AttrRank", Const, 14},
		{"AttrRecursive", Const, 14},
		{"AttrReference", Const, 14},
		{"AttrReturnAddr", Const, 0},
		{"AttrRnglistsBase", Const, 14},
		{"AttrRvalueReference", Const, 14},
		{"AttrSegment", Const, 0},
		{"AttrSibling", Const, 0},
		{"AttrSignature", Const, 14},
		{"AttrSmall", Const, 14},
		{"AttrSpecification", Const, 0},
		{"AttrStartScope", Const, 0},
		{"AttrStaticLink", Const, 0},
		{"AttrStmtList", Const, 0},
		{"AttrStrOffsetsBase", Const, 14},
		{"AttrStride", Const, 0},
		{"AttrStrideSize", Const, 0},
		{"AttrStringLength", Const, 0},
		{"AttrStringLengthBitSize", Const, 14},
		{"AttrStringLengthByteSize", Const, 14},
		{"AttrThreadsScaled", Const, 14},
		{"AttrTrampoline", Const, 0},
		{"AttrType", Const, 0},
		{"AttrUpperBound", Const, 0},
		{"AttrUseLocation", Const, 0},
		{"AttrUseUTF8", Const, 0},
		{"AttrVarParam", Const, 0},
		{"AttrVirtuality", Const, 0},
		{"AttrVisibility", Const, 0},
		{"AttrVtableElemLoc", Const, 0},
		{"BasicType", Type, 0},
		{"BasicType.BitOffset", Field, 0},
		{"BasicType.BitSize", Field, 0},
		{"BasicType.CommonType", Field, 0},
		{"BasicType.DataBitOffset", Field, 18},
		{"BoolType", Type, 0},
		{"BoolType.BasicType", Field, 0},
		{"CharType", Type, 0},
		{"CharType.BasicType", Field, 0},
		{"Class", Type, 5},
		{"ClassAddrPtr", Const, 14},
		{"ClassAddress", Const, 5},
		{"ClassBlock", Const, 5},
		{"ClassConstant", Const, 5},
		{"ClassExprLoc", Const, 5},
		{"ClassFlag", Const, 5},
		{"ClassLinePtr", Const, 5},
		{"ClassLocList", Const, 14},
		{"ClassLocListPtr", Const, 5},
		{"ClassMacPtr", Const, 5},
		{"ClassRangeListPtr", Const, 5},
		{"ClassReference", Const, 5},
		{"ClassReferenceAlt", Const, 5},
		{"ClassReferenceSig", Const, 5},
		{"ClassRngList", Const, 14},
		{"ClassRngListsPtr", Const, 14},
		{"ClassStrOffsetsPtr", Const, 14},
		{"ClassString", Const, 5},
		{"ClassStringAlt", Const, 5},
		{"ClassUnknown", Const, 6},
		{"CommonType", Type, 0},
		{"CommonType.ByteSize", Field, 0},
		{"CommonType.Name", Field, 0},
		{"ComplexType", Type, 0},
		{"ComplexType.BasicType", Field, 0},
		{"Data", Type, 0},
		{"DecodeError", Type, 0},
		{"DecodeError.Err", Field, 0},
		{"DecodeError.Name", Field, 0},
		{"DecodeError.Offset", Field, 0},
		{"DotDotDotType", Type, 0},
		{"DotDotDotType.CommonType", Field, 0},
		{"Entry", Type, 0},
		{"Entry.Children", Field, 0},
		{"Entry.Field", Field, 0},
		{"Entry.Offset", Field, 0},
		{"Entry.Tag", Field, 0},
		{"EnumType", Type, 0},
		{"EnumType.CommonType", Field, 0},
		{"EnumType.EnumName", Field, 0},
		{"EnumType.Val", Field, 0},
		{"EnumValue", Type, 0},
		{"EnumValue.Name", Field, 0},
		{"EnumValue.Val", Field, 0},
		{"ErrUnknownPC", Var, 5},
		{"Field", Type, 0},
		{"Field.Attr", Field, 0},
		{"Field.Class", Field, 5},
		{"Field.Val", Field, 0},
		{"FloatType", Type, 0},
		{"FloatType.BasicType", Field, 0},
		{"FuncType", Type, 0},
		{"FuncType.CommonType", Field, 0},
		{"FuncType.ParamType", Field, 0},
		{"FuncType.ReturnType", Field, 0},
		{"IntType", Type, 0},
		{"IntType.BasicType", Field, 0},
		{"LineEntry", Type, 5},
		{"LineEntry.Address", Field, 5},
		{"LineEntry.BasicBlock", Field, 5},
		{"LineEntry.Column", Field, 5},
		{"LineEntry.Discriminator", Field, 5},
		{"LineEntry.EndSequence", Field, 5},
		{"LineEntry.EpilogueBegin", Field, 5},
		{"LineEntry.File", Field, 5},
		{"LineEntry.ISA", Field, 5},
		{"LineEntry.IsStmt", Field, 5},
		{"LineEntry.Line", Field, 5},
		{"LineEntry.OpIndex", Field, 5},
		{"LineEntry.PrologueEnd", Field, 5},
		{"LineFile", Type, 5},
		{"LineFile.Length", Field, 5},
		{"LineFile.Mtime", Field, 5},
		{"LineFile.Name", Field, 5},
		{"LineReader", Type, 5},
		{"LineReaderPos", Type, 5},
		{"New", Func, 0},
		{"Offset", Type, 0},
		{"PtrType", Type, 0},
		{"PtrType.CommonType", Field, 0},
		{"PtrType.Type", Field, 0},
		{"QualType", Type, 0},
		{"QualType.CommonType", Field, 0},
		{"QualType.Qual", Field, 0},
		{"QualType.Type", Field, 0},
		{"Reader", Type, 0},
		{"StructField", Type, 0},
		{"StructField.BitOffset", Field, 0},
		{"StructField.BitSize", Field, 0},
		{"StructField.ByteOffset", Field, 0},
		{"StructField.ByteSize", Field, 0},
		{"StructField.DataBitOffset", Field, 18},
		{"StructField.Name", Field, 0},
		{"StructField.Type", Field, 0},
		{"StructType", Type, 0},
		{"StructType.CommonType", Field, 0},
		{"StructType.Field", Field, 0},
		{"StructType.Incomplete", Field, 0},
		{"StructType.Kind", Field, 0},
		{"StructType.StructName", Field, 0},
		{"Tag", Type, 0},
		{"TagAccessDeclaration", Const, 0},
		{"TagArrayType", Const, 0},
		{"TagAtomicType", Const, 14},
		{"TagBaseType", Const, 0},
		{"TagCallSite", Const, 14},
		{"TagCallSiteParameter", Const, 14},
		{"TagCatchDwarfBlock", Const, 0},
		{"TagClassType", Const, 0},
		{"TagCoarrayType", Const, 14},
		{"TagCommonDwarfBlock", Const, 0},
		{"TagCommonInclusion", Const, 0},
		{"TagCompileUnit", Const, 0},
		{"TagCondition", Const, 3},
		{"TagConstType", Const, 0},
		{"TagConstant", Const, 0},
		{"TagDwarfProcedure", Const, 0},
		{"TagDynamicType", Const, 14},
		{"TagEntryPoint", Const, 0},
		{"TagEnumerationType", Const, 0},
		{"TagEnumerator", Const, 0},
		{"TagFileType", Const, 0},
		{"TagFormalParameter", Const, 0},
		{"TagFriend", Const, 0},
		{"TagGenericSubrange", Const, 14},
		{"TagImmutableType", Const, 14},
		{"TagImportedDeclaration", Const, 0},
		{"TagImportedModule", Const, 0},
		{"TagImportedUnit", Const, 0},
		{"TagInheritance", Const, 0},
		{"TagInlinedSubroutine", Const, 0},
		{"TagInterfaceType", Const, 0},
		{"TagLabel", Const, 0},
		{"TagLexDwarfBlock", Const, 0},
		{"TagMember", Const, 0},
		{"TagModule", Const, 0},
		{"TagMutableType", Const, 0},
		{"TagNamelist", Const, 0},
		{"TagNamelistItem", Const, 0},
		{"TagNamespace", Const, 0},
		{"TagPackedType", Const, 0},
		{"TagPartialUnit", Const, 0},
		{"TagPointerType", Const, 0},
		{"TagPtrToMemberType", Const, 0},
		{"TagReferenceType", Const, 0},
		{"TagRestrictType", Const, 0},
		{"TagRvalueReferenceType", Const, 3},
		{"TagSetType", Const, 0},
		{"TagSharedType", Const, 3},
		{"TagSkeletonUnit", Const, 14},
		{"TagStringType", Const, 0},
		{"TagStructType", Const, 0},
		{"TagSubprogram", Const, 0},
		{"TagSubrangeType", Const, 0},
		{"TagSubroutineType", Const, 0},
		{"TagTemplateAlias", Const, 3},
		{"TagTemplateTypeParameter", Const, 0},
		{"TagTemplateValueParameter", Const, 0},
		{"TagThrownType", Const, 0},
		{"TagTryDwarfBlock", Const, 0},
		{"TagTypeUnit", Const, 3},
		{"TagTypedef", Const, 0},
		{"TagUnionType", Const, 0},
		{"TagUnspecifiedParameters", Const, 0},
		{"TagUnspecifiedType", Const, 0},
		{"TagVariable", Const, 0},
		{"TagVariant", Const, 0},
		{"TagVariantPart", Const, 0},
		{"TagVolatileType", Const, 0},
		{"TagWithStmt", Const, 0},
		{"Type", Type, 0},
		{"TypedefType", Type, 0},
		{"TypedefType.CommonType", Field, 0},
		{"TypedefType.Type", Field, 0},
		{"UcharType", Type, 0},
		{"UcharType.BasicType", Field, 0},
		{"UintType", Type, 0},
		{"UintType.BasicType", Field, 0},
		{"UnspecifiedType", Type, 4},
		{"UnspecifiedType.BasicType", Field, 4},
		{"UnsupportedType", Type, 13},
		{"UnsupportedType.CommonType", Field, 13},
		{"UnsupportedType.Tag", Field, 13},
		{"VoidType", Type, 0},
		{"VoidType.CommonType", Field, 0},
	},
	"debug/elf": {
		{"(*File).Close", Method, 0},
		{"(*File).DWARF", Method, 0},
		{"(*File).DynString", Method, 1},
		{"(*File).DynValue", Method, 21},
		{"(*File).DynamicSymbols", Method, 4},
		{"(*File).DynamicVersionNeeds", Method, 24},
		{"(*File).DynamicVersions", Method, 24},
		{"(*File).ImportedLibraries", Method, 0},
		{"(*File).ImportedSymbols", Method, 0},
		{"(*File).Section", Method, 0},
		{"(*File).SectionByType", Method, 0},
		{"(*File).Symbols", Method, 0},
		{"(*FormatError).Error", Method, 0},
		{"(*Prog).Open", Method, 0},
		{"(*Section).Data", Method, 0},
		{"(*Section).Open", Method, 0},
		{"(Class).GoString", Method, 0},
		{"(Class).String", Method, 0},
		{"(CompressionType).GoString", Method, 6},
		{"(CompressionType).String", Method, 6},
		{"(Data).GoString", Method, 0},
		{"(Data).String", Method, 0},
		{"(DynFlag).GoString", Method, 0},
		{"(DynFlag).String", Method, 0},
		{"(DynFlag1).GoString", Method, 21},
		{"(DynFlag1).String", Method, 21},
		{"(DynTag).GoString", Method, 0},
		{"(DynTag).String", Method, 0},
		{"(Machine).GoString", Method, 0},
		{"(Machine).String", Method, 0},
		{"(NType).GoString", Method, 0},
		{"(NType).String", Method, 0},
		{"(OSABI).GoString", Method, 0},
		{"(OSABI).String", Method, 0},
		{"(Prog).ReadAt", Method, 0},
		{"(ProgFlag).GoString", Method, 0},
		{"(ProgFlag).String", Method, 0},
		{"(ProgType).GoString", Method, 0},
		{"(ProgType).String", Method, 0},
		{"(R_386).GoString", Method, 0},
		{"(R_386).String", Method, 0},
		{"(R_390).GoString", Method, 7},
		{"(R_390).String", Method, 7},
		{"(R_AARCH64).GoString", Method, 4},
		{"(R_AARCH64).String", Method, 4},
		{"(R_ALPHA).GoString", Method, 0},
		{"(R_ALPHA).String", Method, 0},
		{"(R_ARM).GoString", Method, 0},
		{"(R_ARM).String", Method, 0},
		{"(R_LARCH).GoString", Method, 19},
		{"(R_LARCH).String", Method, 19},
		{"(R_MIPS).GoString", Method, 6},
		{"(R_MIPS).String", Method, 6},
		{"(R_PPC).GoString", Method, 0},
		{"(R_PPC).String", Method, 0},
		{"(R_PPC64).GoString", Method, 5},
		{"(R_PPC64).String", Method, 5},
		{"(R_RISCV).GoString", Method, 11},
		{"(R_RISCV).String", Method, 11},
		{"(R_SPARC).GoString", Method, 0},
		{"(R_SPARC).String", Method, 0},
		{"(R_X86_64).GoString", Method, 0},
		{"(R_X86_64).String", Method, 0},
		{"(Section).ReadAt", Method, 0},
		{"(SectionFlag).GoString", Method, 0},
		{"(SectionFlag).String", Method, 0},
		{"(SectionIndex).GoString", Method, 0},
		{"(SectionIndex).String", Method, 0},
		{"(SectionType).GoString", Method, 0},
		{"(SectionType).String", Method, 0},
		{"(SymBind).GoString", Method, 0},
		{"(SymBind).String", Method, 0},
		{"(SymType).GoString", Method, 0},
		{"(SymType).String", Method, 0},
		{"(SymVis).GoString", Method, 0},
		{"(SymVis).String", Method, 0},
		{"(Type).GoString", Method, 0},
		{"(Type).String", Method, 0},
		{"(Version).GoString", Method, 0},
		{"(Version).String", Method, 0},
		{"(VersionIndex).Index", Method, 24},
		{"(VersionIndex).IsHidden", Method, 24},
		{"ARM_MAGIC_TRAMP_NUMBER", Const, 0},
		{"COMPRESS_HIOS", Const, 6},
		{"COMPRESS_HIPROC", Const, 6},
		{"COMPRESS_LOOS", Const, 6},
		{"COMPRESS_LOPROC", Const, 6},
		{"COMPRESS_ZLIB", Const, 6},
		{"COMPRESS_ZSTD", Const, 21},
		{"Chdr32", Type, 6},
		{"Chdr32.Addralign", Field, 6},
		{"Chdr32.Size", Field, 6},
		{"Chdr32.Type", Field, 6},
		{"Chdr64", Type, 6},
		{"Chdr64.Addralign", Field, 6},
		{"Chdr64.Size", Field, 6},
		{"Chdr64.Type", Field, 6},
		{"Class", Type, 0},
		{"CompressionType", Type, 6},
		{"DF_1_CONFALT", Const, 21},
		{"DF_1_DIRECT", Const, 21},
		{"DF_1_DISPRELDNE", Const, 21},
		{"DF_1_DISPRELPND", Const, 21},
		{"DF_1_EDITED", Const, 21},
		{"DF_1_ENDFILTEE", Const, 21},
		{"DF_1_GLOBAL", Const, 21},
		{"DF_1_GLOBAUDIT", Const, 21},
		{"DF_1_GROUP", Const, 21},
		{"DF_1_IGNMULDEF", Const, 21},
		{"DF_1_INITFIRST", Const, 21},
		{"DF_1_INTERPOSE", Const, 21},
		{"DF_1_KMOD", Const, 21},
		{"DF_1_LOADFLTR", Const, 21},
		{"DF_1_NOCOMMON", Const, 21},
		{"DF_1_NODEFLIB", Const, 21},
		{"DF_1_NODELETE", Const, 21},
		{"DF_1_NODIRECT", Const, 21},
		{"DF_1_NODUMP", Const, 21},
		{"DF_1_NOHDR", Const, 21},
		{"DF_1_NOKSYMS", Const, 21},
		{"DF_1_NOOPEN", Const, 21},
		{"DF_1_NORELOC", Const, 21},
		{"DF_1_NOW", Const, 21},
		{"DF_1_ORIGIN", Const, 21},
		{"DF_1_PIE", Const, 21},
		{"DF_1_SINGLETON", Const, 21},
		{"DF_1_STUB", Const, 21},
		{"DF_1_SYMINTPOSE", Const, 21},
		{"DF_1_TRANS", Const, 21},
		{"DF_1_WEAKFILTER", Const, 21},
		{"DF_BIND_NOW", Const, 0},
		{"DF_ORIGIN", Const, 0},
		{"DF_STATIC_TLS", Const, 0},
		{"DF_SYMBOLIC", Const, 0},
		{"DF_TEXTREL", Const, 0},
		{"DT_ADDRRNGHI", Const, 16},
		{"DT_ADDRRNGLO", Const, 16},
		{"DT_AUDIT", Const, 16},
		{"DT_AUXILIARY", Const, 16},
		{"DT_BIND_NOW", Const, 0},
		{"DT_CHECKSUM", Const, 16},
		{"DT_CONFIG", Const, 16},
		{"DT_DEBUG", Const, 0},
		{"DT_DEPAUDIT", Const, 16},
		{"DT_ENCODING", Const, 0},
		{"DT_FEATURE", Const, 16},
		{"DT_FILTER", Const, 16},
		{"DT_FINI", Const, 0},
		{"DT_FINI_ARRAY", Const, 0},
		{"DT_FINI_ARRAYSZ", Const, 0},
		{"DT_FLAGS", Const, 0},
		{"DT_FLAGS_1", Const, 16},
		{"DT_GNU_CONFLICT", Const, 16},
		{"DT_GNU_CONFLICTSZ", Const, 16},
		{"DT_GNU_HASH", Const, 16},
		{"DT_GNU_LIBLIST", Const, 16},
		{"DT_GNU_LIBLISTSZ", Const, 16},
		{"DT_GNU_PRELINKED", Const, 16},
		{"DT_HASH", Const, 0},
		{"DT_HIOS", Const, 0},
		{"DT_HIPROC", Const, 0},
		{"DT_INIT", Const, 0},
		{"DT_INIT_ARRAY", Const, 0},
		{"DT_INIT_ARRAYSZ", Const, 0},
		{"DT_JMPREL", Const, 0},
		{"DT_LOOS", Const, 0},
		{"DT_LOPROC", Const, 0},
		{"DT_MIPS_AUX_DYNAMIC", Const, 16},
		{"DT_MIPS_BASE_ADDRESS", Const, 16},
		{"DT_MIPS_COMPACT_SIZE", Const, 16},
		{"DT_MIPS_CONFLICT", Const, 16},
		{"DT_MIPS_CONFLICTNO", Const, 16},
		{"DT_MIPS_CXX_FLAGS", Const, 16},
		{"DT_MIPS_DELTA_CLASS", Const, 16},
		{"DT_MIPS_DELTA_CLASSSYM", Const, 16},
		{"DT_MIPS_DELTA_CLASSSYM_NO", Const, 16},
		{"DT_MIPS_DELTA_CLASS_NO", Const, 16},
		{"DT_MIPS_DELTA_INSTANCE", Const, 16},
		{"DT_MIPS_DELTA_INSTANCE_NO", Const, 16},
		{"DT_MIPS_DELTA_RELOC", Const, 16},
		{"DT_MIPS_DELTA_RELOC_NO", Const, 16},
		{"DT_MIPS_DELTA_SYM", Const, 16},
		{"DT_MIPS_DELTA_SYM_NO", Const, 16},
		{"DT_MIPS_DYNSTR_ALIGN", Const, 16},
		{"DT_MIPS_FLAGS", Const, 16},
		{"DT_MIPS_GOTSYM", Const, 16},
		{"DT_MIPS_GP_VALUE", Const, 16},
		{"DT_MIPS_HIDDEN_GOTIDX", Const, 16},
		{"DT_MIPS_HIPAGENO", Const, 16},
		{"DT_MIPS_ICHECKSUM", Const, 16},
		{"DT_MIPS_INTERFACE", Const, 16},
		{"DT_MIPS_INTERFACE_SIZE", Const, 16},
		{"DT_MIPS_IVERSION", Const, 16},
		{"DT_MIPS_LIBLIST", Const, 16},
		{"DT_MIPS_LIBLISTNO", Const, 16},
		{"DT_MIPS_LOCALPAGE_GOTIDX", Const, 16},
		{"DT_MIPS_LOCAL_GOTIDX", Const, 16},
		{"DT_MIPS_LOCAL_GOTNO", Const, 16},
		{"DT_MIPS_MSYM", Const, 16},
		{"DT_MIPS_OPTIONS", Const, 16},
		{"DT_MIPS_PERF_SUFFIX", Const, 16},
		{"DT_MIPS_PIXIE_INIT", Const, 16},
		{"DT_MIPS_PLTGOT", Const, 16},
		{"DT_MIPS_PROTECTED_GOTIDX", Const, 16},
		{"DT_MIPS_RLD_MAP", Const, 16},
		{"DT_MIPS_RLD_MAP_REL", Const, 16},
		{"DT_MIPS_RLD_TEXT_RESOLVE_ADDR", Const, 16},
		{"DT_MIPS_RLD_VERSION", Const, 16},
		{"DT_MIPS_RWPLT", Const, 16},
		{"DT_MIPS_SYMBOL_LIB", Const, 16},
		{"DT_MIPS_SYMTABNO", Const, 16},
		{"DT_MIPS_TIME_STAMP", Const, 16},
		{"DT_MIPS_UNREFEXTNO", Const, 16},
		{"DT_MOVEENT", Const, 16},
		{"DT_MOVESZ", Const, 16},
		{"DT_MOVETAB", Const, 16},
		{"DT_NEEDED", Const, 0},
		{"DT_NULL", Const, 0},
		{"DT_PLTGOT", Const, 0},
		{"DT_PLTPAD", Const, 16},
		{"DT_PLTPADSZ", Const, 16},
		{"DT_PLTREL", Const, 0},
		{"DT_PLTRELSZ", Const, 0},
		{"DT_POSFLAG_1", Const, 16},
		{"DT_PPC64_GLINK", Const, 16},
		{"DT_PPC64_OPD", Const, 16},
		{"DT_PPC64_OPDSZ", Const, 16},
		{"DT_PPC64_OPT", Const, 16},
		{"DT_PPC_GOT", Const, 16},
		{"DT_PPC_OPT", Const, 16},
		{"DT_PREINIT_ARRAY", Const, 0},
		{"DT_PREINIT_ARRAYSZ", Const, 0},
		{"DT_REL", Const, 0},
		{"DT_RELA", Const, 0},
		{"DT_RELACOUNT", Const, 16},
		{"DT_RELAENT", Const, 0},
		{"DT_RELASZ", Const, 0},
		{"DT_RELCOUNT", Const, 16},
		{"DT_RELENT", Const, 0},
		{"DT_RELSZ", Const, 0},
		{"DT_RPATH", Const, 0},
		{"DT_RUNPATH", Const, 0},
		{"DT_SONAME", Const, 0},
		{"DT_SPARC_REGISTER", Const, 16},
		{"DT_STRSZ", Const, 0},
		{"DT_STRTAB", Const, 0},
		{"DT_SYMBOLIC", Const, 0},
		{"DT_SYMENT", Const, 0},
		{"DT_SYMINENT", Const, 16},
		{"DT_SYMINFO", Const, 16},
		{"DT_SYMINSZ", Const, 16},
		{"DT_SYMTAB", Const, 0},
		{"DT_SYMTAB_SHNDX", Const, 16},
		{"DT_TEXTREL", Const, 0},
		{"DT_TLSDESC_GOT", Const, 16},
		{"DT_TLSDESC_PLT", Const, 16},
		{"DT_USED", Const, 16},
		{"DT_VALRNGHI", Const, 16},
		{"DT_VALRNGLO", Const, 16},
		{"DT_VERDEF", Const, 16},
		{"DT_VERDEFNUM", Const, 16},
		{"DT_VERNEED", Const, 0},
		{"DT_VERNEEDNUM", Const, 0},
		{"DT_VERSYM", Const, 0},
		{"Data", Type, 0},
		{"Dyn32", Type, 0},
		{"Dyn32.Tag", Field, 0},
		{"Dyn32.Val", Field, 0},
		{"Dyn64", Type, 0},
		{"Dyn64.Tag", Field, 0},
		{"Dyn64.Val", Field, 0},
		{"DynFlag", Type, 0},
		{"DynFlag1", Type, 21},
		{"DynTag", Type, 0},
		{"DynamicVersion", Type, 24},
		{"DynamicVersion.Deps", Field, 24},
		{"DynamicVersion.Flags", Field, 24},
		{"DynamicVersion.Index", Field, 24},
		{"DynamicVersion.Name", Field, 24},
		{"DynamicVersionDep", Type, 24},
		{"DynamicVersionDep.Dep", Field, 24},
		{"DynamicVersionDep.Flags", Field, 24},
		{"DynamicVersionDep.Index", Field, 24},
		{"DynamicVersionFlag", Type, 24},
		{"DynamicVersionNeed", Type, 24},
		{"DynamicVersionNeed.Name", Field, 24},
		{"DynamicVersionNeed.Needs", Field, 24},
		{"EI_ABIVERSION", Const, 0},
		{"EI_CLASS", Const, 0},
		{"EI_DATA", Const, 0},
		{"EI_NIDENT", Const, 0},
		{"EI_OSABI", Const, 0},
		{"EI_PAD", Const, 0},
		{"EI_VERSION", Const, 0},
		{"ELFCLASS32", Const, 0},
		{"ELFCLASS64", Const, 0},
		{"ELFCLASSNONE", Const, 0},
		{"ELFDATA2LSB", Const, 0},
		{"ELFDATA2MSB", Const, 0},
		{"ELFDATANONE", Const, 0},
		{"ELFMAG", Const, 0},
		{"ELFOSABI_86OPEN", Const, 0},
		{"ELFOSABI_AIX", Const, 0},
		{"ELFOSABI_ARM", Const, 0},
		{"ELFOSABI_AROS", Const, 11},
		{"ELFOSABI_CLOUDABI", Const, 11},
		{"ELFOSABI_FENIXOS", Const, 11},
		{"ELFOSABI_FREEBSD", Const, 0},
		{"ELFOSABI_HPUX", Const, 0},
		{"ELFOSABI_HURD", Const, 0},
		{"ELFOSABI_IRIX", Const, 0},
		{"ELFOSABI_LINUX", Const, 0},
		{"ELFOSABI_MODESTO", Const, 0},
		{"ELFOSABI_NETBSD", Const, 0},
		{"ELFOSABI_NONE", Const, 0},
		{"ELFOSABI_NSK", Const, 0},
		{"ELFOSABI_OPENBSD", Const, 0},
		{"ELFOSABI_OPENVMS", Const, 0},
		{"ELFOSABI_SOLARIS", Const, 0},
		{"ELFOSABI_STANDALONE", Const, 0},
		{"ELFOSABI_TRU64", Const, 0},
		{"EM_386", Const, 0},
		{"EM_486", Const, 0},
		{"EM_56800EX", Const, 11},
		{"EM_68HC05", Const, 11},
		{"EM_68HC08", Const, 11},
		{"EM_68HC11", Const, 11},
		{"EM_68HC12", Const, 0},
		{"EM_68HC16", Const, 11},
		{"EM_68K", Const, 0},
		{"EM_78KOR", Const, 11},
		{"EM_8051", Const, 11},
		{"EM_860", Const, 0},
		{"EM_88K", Const, 0},
		{"EM_960", Const, 0},
		{"EM_AARCH64", Const, 4},
		{"EM_ALPHA", Const, 0},
		{"EM_ALPHA_STD", Const, 0},
		{"EM_ALTERA_NIOS2", Const, 11},
		{"EM_AMDGPU", Const, 11},
		{"EM_ARC", Const, 0},
		{"EM_ARCA", Const, 11},
		{"EM_ARC_COMPACT", Const, 11},
		{"EM_ARC_COMPACT2", Const, 11},
		{"EM_ARM", Const, 0},
		{"EM_AVR", Const, 11},
		{"EM_AVR32", Const, 11},
		{"EM_BA1", Const, 11},
		{"EM_BA2", Const, 11},
		{"EM_BLACKFIN", Const, 11},
		{"EM_BPF", Const, 11},
		{"EM_C166", Const, 11},
		{"EM_CDP", Const, 11},
		{"EM_CE", Const, 11},
		{"EM_CLOUDSHIELD", Const, 11},
		{"EM_COGE", Const, 11},
		{"EM_COLDFIRE", Const, 0},
		{"EM_COOL", Const, 11},
		{"EM_COREA_1ST", Const, 11},
		{"EM_COREA_2ND", Const, 11},
		{"EM_CR", Const, 11},
		{"EM_CR16", Const, 11},
		{"EM_CRAYNV2", Const, 11},
		{"EM_CRIS", Const, 11},
		{"EM_CRX", Const, 11},
		{"EM_CSR_KALIMBA", Const, 11},
		{"EM_CUDA", Const, 11},
		{"EM_CYPRESS_M8C", Const, 11},
		{"EM_D10V", Const, 11},
		{"EM_D30V", Const, 11},
		{"EM_DSP24", Const, 11},
		{"EM_DSPIC30F", Const, 11},
		{"EM_DXP", Const, 11},
		{"EM_ECOG1", Const, 11},
		{"EM_ECOG16", Const, 11},
		{"EM_ECOG1X", Const, 11},
		{"EM_ECOG2", Const, 11},
		{"EM_ETPU", Const, 11},
		{"EM_EXCESS", Const, 11},
		{"EM_F2MC16", Const, 11},
		{"EM_FIREPATH", Const, 11},
		{"EM_FR20", Const, 0},
		{"EM_FR30", Const, 11},
		{"EM_FT32", Const, 11},
		{"EM_FX66", Const, 11},
		{"EM_H8S", Const, 0},
		{"EM_H8_300", Const, 0},
		{"EM_H8_300H", Const, 0},
		{"EM_H8_500", Const, 0},
		{"EM_HUANY", Const, 11},
		{"EM_IA_64", Const, 0},
		{"EM_INTEL205", Const, 11},
		{"EM_INTEL206", Const, 11},
		{"EM_INTEL207", Const, 11},
		{"EM_INTEL208", Const, 11},
		{"EM_INTEL209", Const, 11},
		{"EM_IP2K", Const, 11},
		{"EM_JAVELIN", Const, 11},
		{"EM_K10M", Const, 11},
		{"EM_KM32", Const, 11},
		{"EM_KMX16", Const, 11},
		{"EM_KMX32", Const, 11},
		{"EM_KMX8", Const, 11},
		{"EM_KVARC", Const, 11},
		{"EM_L10M", Const, 11},
		{"EM_LANAI", Const, 11},
		{"EM_LATTICEMICO32", Const, 11},
		{"EM_LOONGARCH", Const, 19},
		{"EM_M16C", Const, 11},
		{"EM_M32", Const, 0},
		{"EM_M32C", Const, 11},
		{"EM_M32R", Const, 11},
		{"EM_MANIK", Const, 11},
		{"EM_MAX", Const, 11},
		{"EM_MAXQ30", Const, 11},
		{"EM_MCHP_PIC", Const, 11},
		{"EM_MCST_ELBRUS", Const, 11},
		{"EM_ME16", Const, 0},
		{"EM_METAG", Const, 11},
		{"EM_MICROBLAZE", Const, 11},
		{"EM_MIPS", Const, 0},
		{"EM_MIPS_RS3_LE", Const, 0},
		{"EM_MIPS_RS4_BE", Const, 0},
		{"EM_MIPS_X", Const, 0},
		{"EM_MMA", Const, 0},
		{"EM_MMDSP_PLUS", Const, 11},
		{"EM_MMIX", Const, 11},
		{"EM_MN10200", Const, 11},
		{"EM_MN10300", Const, 11},
		{"EM_MOXIE", Const, 11},
		{"EM_MSP430", Const, 11},
		{"EM_NCPU", Const, 0},
		{"EM_NDR1", Const, 0},
		{"EM_NDS32", Const, 11},
		{"EM_NONE", Const, 0},
		{"EM_NORC", Const, 11},
		{"EM_NS32K", Const, 11},
		{"EM_OPEN8", Const, 11},
		{"EM_OPENRISC", Const, 11},
		{"EM_PARISC", Const, 0},
		{"EM_PCP", Const, 0},
		{"EM_PDP10", Const, 11},
		{"EM_PDP11", Const, 11},
		{"EM_PDSP", Const, 11},
		{"EM_PJ", Const, 11},
		{"EM_PPC", Const, 0},
		{"EM_PPC64", Const, 0},
		{"EM_PRISM", Const, 11},
		{"EM_QDSP6", Const, 11},
		{"EM_R32C", Const, 11},
		{"EM_RCE", Const, 0},
		{"EM_RH32", Const, 0},
		{"EM_RISCV", Const, 11},
		{"EM_RL78", Const, 11},
		{"EM_RS08", Const, 11},
		{"EM_RX", Const, 11},
		{"EM_S370", Const, 0},
		{"EM_S390", Const, 0},
		{"EM_SCORE7", Const, 11},
		{"EM_SEP", Const, 11},
		{"EM_SE_C17", Const, 11},
		{"EM_SE_C33", Const, 11},
		{"EM_SH", Const, 0},
		{"EM_SHARC", Const, 11},
		{"EM_SLE9X", Const, 11},
		{"EM_SNP1K", Const, 11},
		{"EM_SPARC", Const, 0},
		{"EM_SPARC32PLUS", Const, 0},
		{"EM_SPARCV9", Const, 0},
		{"EM_ST100", Const, 0},
		{"EM_ST19", Const, 11},
		{"EM_ST200", Const, 11},
		{"EM_ST7", Const, 11},
		{"EM_ST9PLUS", Const, 11},
		{"EM_STARCORE", Const, 0},
		{"EM_STM8", Const, 11},
		{"EM_STXP7X", Const, 11},
		{"EM_SVX", Const, 11},
		{"EM_TILE64", Const, 11},
		{"EM_TILEGX", Const, 11},
		{"EM_TILEPRO", Const, 11},
		{"EM_TINYJ", Const, 0},
		{"EM_TI_ARP32", Const, 11},
		{"EM_TI_C2000", Const, 11},
		{"EM_TI_C5500", Const, 11},
		{"EM_TI_C6000", Const, 11},
		{"EM_TI_PRU", Const, 11},
		{"EM_TMM_GPP", Const, 11},
		{"EM_TPC", Const, 11},
		{"EM_TRICORE", Const, 0},
		{"EM_TRIMEDIA", Const, 11},
		{"EM_TSK3000", Const, 11},
		{"EM_UNICORE", Const, 11},
		{"EM_V800", Const, 0},
		{"EM_V850", Const, 11},
		{"EM_VAX", Const, 11},
		{"EM_VIDEOCORE", Const, 11},
		{"EM_VIDEOCORE3", Const, 11},
		{"EM_VIDEOCORE5", Const, 11},
		{"EM_VISIUM", Const, 11},
		{"EM_VPP500", Const, 0},
		{"EM_X86_64", Const, 0},
		{"EM_XCORE", Const, 11},
		{"EM_XGATE", Const, 11},
		{"EM_XIMO16", Const, 11},
		{"EM_XTENSA", Const, 11},
		{"EM_Z80", Const, 11},
		{"EM_ZSP", Const, 11},
		{"ET_CORE", Const, 0},
		{"ET_DYN", Const, 0},
		{"ET_EXEC", Const, 0},
		{"ET_HIOS", Const, 0},
		{"ET_HIPROC", Const, 0},
		{"ET_LOOS", Const, 0},
		{"ET_LOPROC", Const, 0},
		{"ET_NONE", Const, 0},
		{"ET_REL", Const, 0},
		{"EV_CURRENT", Const, 0},
		{"EV_NONE", Const, 0},
		{"ErrNoSymbols", Var, 4},
		{"File", Type, 0},
		{"File.FileHeader", Field, 0},
		{"File.Progs", Field, 0},
		{"File.Sections", Field, 0},
		{"FileHeader", Type, 0},
		{"FileHeader.ABIVersion", Field, 0},
		{"FileHeader.ByteOrder", Field, 0},
		{"FileHeader.Class", Field, 0},
		{"FileHeader.Data", Field, 0},
		{"FileHeader.Entry", Field, 1},
		{"FileHeader.Machine", Field, 0},
		{"FileHeader.OSABI", Field, 0},
		{"FileHeader.Type", Field, 0},
		{"FileHeader.Version", Field, 0},
		{"FormatError", Type, 0},
		{"Header32", Type, 0},
		{"Header32.Ehsize", Field, 0},
		{"Header32.Entry", Field, 0},
		{"Header32.Flags", Field, 0},
		{"Header32.Ident", Field, 0},
		{"Header32.Machine", Field, 0},
		{"Header32.Phentsize", Field, 0},
		{"Header32.Phnum", Field, 0},
		{"Header32.Phoff", Field, 0},
		{"Header32.Shentsize", Field, 0},
		{"Header32.Shnum", Field, 0},
		{"Header32.Shoff", Field, 0},
		{"Header32.Shstrndx", Field, 0},
		{"Header32.Type", Field, 0},
		{"Header32.Version", Field, 0},
		{"Header64", Type, 0},
		{"Header64.Ehsize", Field, 0},
		{"Header64.Entry", Field, 0},
		{"Header64.Flags", Field, 0},
		{"Header64.Ident", Field, 0},
		{"Header64.Machine", Field, 0},
		{"Header64.Phentsize", Field, 0},
		{"Header64.Phnum", Field, 0},
		{"Header64.Phoff", Field, 0},
		{"Header64.Shentsize", Field, 0},
		{"Header64.Shnum", Field, 0},
		{"Header64.Shoff", Field, 0},
		{"Header64.Shstrndx", Field, 0},
		{"Header64.Type", Field, 0},
		{"Header64.Version", Field, 0},
		{"ImportedSymbol", Type, 0},
		{"ImportedSymbol.Library", Field, 0},
		{"ImportedSymbol.Name", Field, 0},
		{"ImportedSymbol.Version", Field, 0},
		{"Machine", Type, 0},
		{"NT_FPREGSET", Const, 0},
		{"NT_PRPSINFO", Const, 0},
		{"NT_PRSTATUS", Const, 0},
		{"NType", Type, 0},
		{"NewFile", Func, 0},
		{"OSABI", Type, 0},
		{"Open", Func, 0},
		{"PF_MASKOS", Const, 0},
		{"PF_MASKPROC", Const, 0},
		{"PF_R", Const, 0},
		{"PF_W", Const, 0},
		{"PF_X", Const, 0},
		{"PT_AARCH64_ARCHEXT", Const, 16},
		{"PT_AARCH64_UNWIND", Const, 16},
		{"PT_ARM_ARCHEXT", Const, 16},
		{"PT_ARM_EXIDX", Const, 16},
		{"PT_DYNAMIC", Const, 0},
		{"PT_GNU_EH_FRAME", Const, 16},
		{"PT_GNU_MBIND_HI", Const, 16},
		{"PT_GNU_MBIND_LO", Const, 16},
		{"PT_GNU_PROPERTY", Const, 16},
		{"PT_GNU_RELRO", Const, 16},
		{"PT_GNU_STACK", Const, 16},
		{"PT_HIOS", Const, 0},
		{"PT_HIPROC", Const, 0},
		{"PT_INTERP", Const, 0},
		{"PT_LOAD", Const, 0},
		{"PT_LOOS", Const, 0},
		{"PT_LOPROC", Const, 0},
		{"PT_MIPS_ABIFLAGS", Const, 16},
		{"PT_MIPS_OPTIONS", Const, 16},
		{"PT_MIPS_REGINFO", Const, 16},
		{"PT_MIPS_RTPROC", Const, 16},
		{"PT_NOTE", Const, 0},
		{"PT_NULL", Const, 0},
		{"PT_OPENBSD_BOOTDATA", Const, 16},
		{"PT_OPENBSD_NOBTCFI", Const, 23},
		{"PT_OPENBSD_RANDOMIZE", Const, 16},
		{"PT_OPENBSD_WXNEEDED", Const, 16},
		{"PT_PAX_FLAGS", Const, 16},
		{"PT_PHDR", Const, 0},
		{"PT_S390_PGSTE", Const, 16},
		{"PT_SHLIB", Const, 0},
		{"PT_SUNWSTACK", Const, 16},
		{"PT_SUNW_EH_FRAME", Const, 16},
		{"PT_TLS", Const, 0},
		{"Prog", Type, 0},
		{"Prog.ProgHeader", Field, 0},
		{"Prog.ReaderAt", Field, 0},
		{"Prog32", Type, 0},
		{"Prog32.Align", Field, 0},
		{"Prog32.Filesz", Field, 0},
		{"Prog32.Flags", Field, 0},
		{"Prog32.Memsz", Field, 0},
		{"Prog32.Off", Field, 0},
		{"Prog32.Paddr", Field, 0},
		{"Prog32.Type", Field, 0},
		{"Prog32.Vaddr", Field, 0},
		{"Prog64", Type, 0},
		{"Prog64.Align", Field, 0},
		{"Prog64.Filesz", Field, 0},
		{"Prog64.Flags", Field, 0},
		{"Prog64.Memsz", Field, 0},
		{"Prog64.Off", Field, 0},
		{"Prog64.Paddr", Field, 0},
		{"Prog64.Type", Field, 0},
		{"Prog64.Vaddr", Field, 0},
		{"ProgFlag", Type, 0},
		{"ProgHeader", Type, 0},
		{"ProgHeader.Align", Field, 0},
		{"ProgHeader.Filesz", Field, 0},
		{"ProgHeader.Flags", Field, 0},
		{"ProgHeader.Memsz", Field, 0},
		{"ProgHeader.Off", Field, 0},
		{"ProgHeader.Paddr", Field, 0},
		{"ProgHeader.Type", Field, 0},
		{"ProgHeader.Vaddr", Field, 0},
		{"ProgType", Type, 0},
		{"R_386", Type, 0},
		{"R_386_16", Const, 10},
		{"R_386_32", Const, 0},
		{"R_386_32PLT", Const, 10},
		{"R_386_8", Const, 10},
		{"R_386_COPY", Const, 0},
		{"R_386_GLOB_DAT", Const, 0},
		{"R_386_GOT32", Const, 0},
		{"R_386_GOT32X", Const, 10},
		{"R_386_GOTOFF", Const, 0},
		{"R_386_GOTPC", Const, 0},
		{"R_386_IRELATIVE", Const, 10},
		{"R_386_JMP_SLOT", Const, 0},
		{"R_386_NONE", Const, 0},
		{"R_386_PC16", Const, 10},
		{"R_386_PC32", Const, 0},
		{"R_386_PC8", Const, 10},
		{"R_386_PLT32", Const, 0},
		{"R_386_RELATIVE", Const, 0},
		{"R_386_SIZE32", Const, 10},
		{"R_386_TLS_DESC", Const, 10},
		{"R_386_TLS_DESC_CALL", Const, 10},
		{"R_386_TLS_DTPMOD32", Const, 0},
		{"R_386_TLS_DTPOFF32", Const, 0},
		{"R_386_TLS_GD", Const, 0},
		{"R_386_TLS_GD_32", Const, 0},
		{"R_386_TLS_GD_CALL", Const, 0},
		{"R_386_TLS_GD_POP", Const, 0},
		{"R_386_TLS_GD_PUSH", Const, 0},
		{"R_386_TLS_GOTDESC", Const, 10},
		{"R_386_TLS_GOTIE", Const, 0},
		{"R_386_TLS_IE", Const, 0},
		{"R_386_TLS_IE_32", Const, 0},
		{"R_386_TLS_LDM", Const, 0},
		{"R_386_TLS_LDM_32", Const, 0},
		{"R_386_TLS_LDM_CALL", Const, 0},
		{"R_386_TLS_LDM_POP", Const, 0},
		{"R_386_TLS_LDM_PUSH", Const, 0},
		{"R_386_TLS_LDO_32", Const, 0},
		{"R_386_TLS_LE", Const, 0},
		{"R_386_TLS_LE_32", Const, 0},
		{"R_386_TLS_TPOFF", Const, 0},
		{"R_386_TLS_TPOFF32", Const, 0},
		{"R_390", Type, 7},
		{"R_390_12", Const, 7},
		{"R_390_16", Const, 7},
		{"R_390_20", Const, 7},
		{"R_390_32", Const, 7},
		{"R_390_64", Const, 7},
		{"R_390_8", Const, 7},
		{"R_390_COPY", Const, 7},
		{"R_390_GLOB_DAT", Const, 7},
		{"R_390_GOT12", Const, 7},
		{"R_390_GOT16", Const, 7},
		{"R_390_GOT20", Const, 7},
		{"R_390_GOT32", Const, 7},
		{"R_390_GOT64", Const, 7},
		{"R_390_GOTENT", Const, 7},
		{"R_390_GOTOFF", Const, 7},
		{"R_390_GOTOFF16", Const, 7},
		{"R_390_GOTOFF64", Const, 7},
		{"R_390_GOTPC", Const, 7},
		{"R_390_GOTPCDBL", Const, 7},
		{"R_390_GOTPLT12", Const, 7},
		{"R_390_GOTPLT16", Const, 7},
		{"R_390_GOTPLT20", Const, 7},
		{"R_390_GOTPLT32", Const, 7},
		{"R_390_GOTPLT64", Const, 7},
		{"R_390_GOTPLTENT", Const, 7},
		{"R_390_GOTPLTOFF16", Const, 7},
		{"R_390_GOTPLTOFF32", Const, 7},
		{"R_390_GOTPLTOFF64", Const, 7},
		{"R_390_JMP_SLOT", Const, 7},
		{"R_390_NONE", Const, 7},
		{"R_390_PC16", Const, 7},
		{"R_390_PC16DBL", Const, 7},
		{"R_390_PC32", Const, 7},
		{"R_390_PC32DBL", Const, 7},
		{"R_390_PC64", Const, 7},
		{"R_390_PLT16DBL", Const, 7},
		{"R_390_PLT32", Const, 7},
		{"R_390_PLT32DBL", Const, 7},
		{"R_390_PLT64", Const, 7},
		{"R_390_RELATIVE", Const, 7},
		{"R_390_TLS_DTPMOD", Const, 7},
		{"R_390_TLS_DTPOFF", Const, 7},
		{"R_390_TLS_GD32", Const, 7},
		{"R_390_TLS_GD64", Const, 7},
		{"R_390_TLS_GDCALL", Const, 7},
		{"R_390_TLS_GOTIE12", Const, 7},
		{"R_390_TLS_GOTIE20", Const, 7},
		{"R_390_TLS_GOTIE32", Const, 7},
		{"R_390_TLS_GOTIE64", Const, 7},
		{"R_390_TLS_IE32", Const, 7},
		{"R_390_TLS_IE64", Const, 7},
		{"R_390_TLS_IEENT", Const, 7},
		{"R_390_TLS_LDCALL", Const, 7},
		{"R_390_TLS_LDM32", Const, 7},
		{"R_390_TLS_LDM64", Const, 7},
		{"R_390_TLS_LDO32", Const, 7},
		{"R_390_TLS_LDO64", Const, 7},
		{"R_390_TLS_LE32", Const, 7},
		{"R_390_TLS_LE64", Const, 7},
		{"R_390_TLS_LOAD", Const, 7},
		{"R_390_TLS_TPOFF", Const, 7},
		{"R_AARCH64", Type, 4},
		{"R_AARCH64_ABS16", Const, 4},
		{"R_AARCH64_ABS32", Const, 4},
		{"R_AARCH64_ABS64", Const, 4},
		{"R_AARCH64_ADD_ABS_LO12_NC", Const, 4},
		{"R_AARCH64_ADR_GOT_PAGE", Const, 4},
		{"R_AARCH64_ADR_PREL_LO21", Const, 4},
		{"R_AARCH64_ADR_PREL_PG_HI21", Const, 4},
		{"R_AARCH64_ADR_PREL_PG_HI21_NC", Const, 4},
		{"R_AARCH64_CALL26", Const, 4},
		{"R_AARCH64_CONDBR19", Const, 4},
		{"R_AARCH64_COPY", Const, 4},
		{"R_AARCH64_GLOB_DAT", Const, 4},
		{"R_AARCH64_GOT_LD_PREL19", Const, 4},
		{"R_AARCH64_IRELATIVE", Const, 4},
		{"R_AARCH64_JUMP26", Const, 4},
		{"R_AARCH64_JUMP_SLOT", Const, 4},
		{"R_AARCH64_LD64_GOTOFF_LO15", Const, 10},
		{"R_AARCH64_LD64_GOTPAGE_LO15", Const, 10},
		{"R_AARCH64_LD64_GOT_LO12_NC", Const, 4},
		{"R_AARCH64_LDST128_ABS_LO12_NC", Const, 4},
		{"R_AARCH64_LDST16_ABS_LO12_NC", Const, 4},
		{"R_AARCH64_LDST32_ABS_LO12_NC", Const, 4},
		{"R_AARCH64_LDST64_ABS_LO12_NC", Const, 4},
		{"R_AARCH64_LDST8_ABS_LO12_NC", Const, 4},
		{"R_AARCH64_LD_PREL_LO19", Const, 4},
		{"R_AARCH64_MOVW_SABS_G0", Const, 4},
		{"R_AARCH64_MOVW_SABS_G1", Const, 4},
		{"R_AARCH64_MOVW_SABS_G2", Const, 4},
		{"R_AARCH64_MOVW_UABS_G0", Const, 4},
		{"R_AARCH64_MOVW_UABS_G0_NC", Const, 4},
		{"R_AARCH64_MOVW_UABS_G1", Const, 4},
		{"R_AARCH64_MOVW_UABS_G1_NC", Const, 4},
		{"R_AARCH64_MOVW_UABS_G2", Const, 4},
		{"R_AARCH64_MOVW_UABS_G2_NC", Const, 4},
		{"R_AARCH64_MOVW_UABS_G3", Const, 4},
		{"R_AARCH64_NONE", Const, 4},
		{"R_AARCH64_NULL", Const, 4},
		{"R_AARCH64_P32_ABS16", Const, 4},
		{"R_AARCH64_P32_ABS32", Const, 4},
		{"R_AARCH64_P32_ADD_ABS_LO12_NC", Const, 4},
		{"R_AARCH64_P32_ADR_GOT_PAGE", Const, 4},
		{"R_AARCH64_P32_ADR_PREL_LO21", Const, 4},
		{"R_AARCH64_P32_ADR_PREL_PG_HI21", Const, 4},
		{"R_AARCH64_P32_CALL26", Const, 4},
		{"R_AARCH64_P32_CONDBR19", Const, 4},
		{"R_AARCH64_P32_COPY", Const, 4},
		{"R_AARCH64_P32_GLOB_DAT", Const, 4},
		{"R_AARCH64_P32_GOT_LD_PREL19", Const, 4},
		{"R_AARCH64_P32_IRELATIVE", Const, 4},
		{"R_AARCH64_P32_JUMP26", Const, 4},
		{"R_AARCH64_P32_JUMP_SLOT", Const, 4},
		{"R_AARCH64_P32_LD32_GOT_LO12_NC", Const, 4},
		{"R_AARCH64_P32_LDST128_ABS_LO12_NC", Const, 4},
		{"R_AARCH64_P32_LDST16_ABS_LO12_NC", Const, 4},
		{"R_AARCH64_P32_LDST32_ABS_LO12_NC", Const, 4},
		{"R_AARCH64_P32_LDST64_ABS_LO12_NC", Const, 4},
		{"R_AARCH64_P32_LDST8_ABS_LO12_NC", Const, 4},
		{"R_AARCH64_P32_LD_PREL_LO19", Const, 4},
		{"R_AARCH64_P32_MOVW_SABS_G0", Const, 4},
		{"R_AARCH64_P32_MOVW_UABS_G0", Const, 4},
		{"R_AARCH64_P32_MOVW_UABS_G0_NC", Const, 4},
		{"R_AARCH64_P32_MOVW_UABS_G1", Const, 4},
		{"R_AARCH64_P32_PREL16", Const, 4},
		{"R_AARCH64_P32_PREL32", Const, 4},
		{"R_AARCH64_P32_RELATIVE", Const, 4},
		{"R_AARCH64_P32_TLSDESC", Const, 4},
		{"R_AARCH64_P32_TLSDESC_ADD_LO12_NC", Const, 4},
		{"R_AARCH64_P32_TLSDESC_ADR_PAGE21", Const, 4},
		{"R_AARCH64_P32_TLSDESC_ADR_PREL21", Const, 4},
		{"R_AARCH64_P32_TLSDESC_CALL", Const, 4},
		{"R_AARCH64_P32_TLSDESC_LD32_LO12_NC", Const, 4},
		{"R_AARCH64_P32_TLSDESC_LD_PREL19", Const, 4},
		{"R_AARCH64_P32_TLSGD_ADD_LO12_NC", Const, 4},
		{"R_AARCH64_P32_TLSGD_ADR_PAGE21", Const, 4},
		{"R_AARCH64_P32_TLSIE_ADR_GOTTPREL_PAGE21", Const, 4},
		{"R_AARCH64_P32_TLSIE_LD32_GOTTPREL_LO12_NC", Const, 4},
		{"R_AARCH64_P32_TLSIE_LD_GOTTPREL_PREL19", Const, 4},
		{"R_AARCH64_P32_TLSLE_ADD_TPREL_HI12", Const, 4},
		{"R_AARCH64_P32_TLSLE_ADD_TPREL_LO12", Const, 4},
		{"R_AARCH64_P32_TLSLE_ADD_TPREL_LO12_NC", Const, 4},
		{"R_AARCH64_P32_TLSLE_MOVW_TPREL_G0", Const, 4},
		{"R_AARCH64_P32_TLSLE_MOVW_TPREL_G0_NC", Const, 4},
		{"R_AARCH64_P32_TLSLE_MOVW_TPREL_G1", Const, 4},
		{"R_AARCH64_P32_TLS_DTPMOD", Const, 4},
		{"R_AARCH64_P32_TLS_DTPREL", Const, 4},
		{"R_AARCH64_P32_TLS_TPREL", Const, 4},
		{"R_AARCH64_P32_TSTBR14", Const, 4},
		{"R_AARCH64_PREL16", Const, 4},
		{"R_AARCH64_PREL32", Const, 4},
		{"R_AARCH64_PREL64", Const, 4},
		{"R_AARCH64_RELATIVE", Const, 4},
		{"R_AARCH64_TLSDESC", Const, 4},
		{"R_AARCH64_TLSDESC_ADD", Const, 4},
		{"R_AARCH64_TLSDESC_ADD_LO12_NC", Const, 4},
		{"R_AARCH64_TLSDESC_ADR_PAGE21", Const, 4},
		{"R_AARCH64_TLSDESC_ADR_PREL21", Const, 4},
		{"R_AARCH64_TLSDESC_CALL", Const, 4},
		{"R_AARCH64_TLSDESC_LD64_LO12_NC", Const, 4},
		{"R_AARCH64_TLSDESC_LDR", Const, 4},
		{"R_AARCH64_TLSDESC_LD_PREL19", Const, 4},
		{"R_AARCH64_TLSDESC_OFF_G0_NC", Const, 4},
		{"R_AARCH64_TLSDESC_OFF_G1", Const, 4},
		{"R_AARCH64_TLSGD_ADD_LO12_NC", Const, 4},
		{"R_AARCH64_TLSGD_ADR_PAGE21", Const, 4},
		{"R_AARCH64_TLSGD_ADR_PREL21", Const, 10},
		{"R_AARCH64_TLSGD_MOVW_G0_NC", Const, 10},
		{"R_AARCH64_TLSGD_MOVW_G1", Const, 10},
		{"R_AARCH64_TLSIE_ADR_GOTTPREL_PAGE21", Const, 4},
		{"R_AARCH64_TLSIE_LD64_GOTTPREL_LO12_NC", Const, 4},
		{"R_AARCH64_TLSIE_LD_GOTTPREL_PREL19", Const, 4},
		{"R_AARCH64_TLSIE_MOVW_GOTTPREL_G0_NC", Const, 4},
		{"R_AARCH64_TLSIE_MOVW_GOTTPREL_G1", Const, 4},
		{"R_AARCH64_TLSLD_ADR_PAGE21", Const, 10},
		{"R_AARCH64_TLSLD_ADR_PREL21", Const, 10},
		{"R_AARCH64_TLSLD_LDST128_DTPREL_LO12", Const, 10},
		{"R_AARCH64_TLSLD_LDST128_DTPREL_LO12_NC", Const, 10},
		{"R_AARCH64_TLSLE_ADD_TPREL_HI12", Const, 4},
		{"R_AARCH64_TLSLE_ADD_TPREL_LO12", Const, 4},
		{"R_AARCH64_TLSLE_ADD_TPREL_LO12_NC", Const, 4},
		{"R_AARCH64_TLSLE_LDST128_TPREL_LO12", Const, 10},
		{"R_AARCH64_TLSLE_LDST128_TPREL_LO12_NC", Const, 10},
		{"R_AARCH64_TLSLE_MOVW_TPREL_G0", Const, 4},
		{"R_AARCH64_TLSLE_MOVW_TPREL_G0_NC", Const, 4},
		{"R_AARCH64_TLSLE_MOVW_TPREL_G1", Const, 4},
		{"R_AARCH64_TLSLE_MOVW_TPREL_G1_NC", Const, 4},
		{"R_AARCH64_TLSLE_MOVW_TPREL_G2", Const, 4},
		{"R_AARCH64_TLS_DTPMOD64", Const, 4},
		{"R_AARCH64_TLS_DTPREL64", Const, 4},
		{"R_AARCH64_TLS_TPREL64", Const, 4},
		{"R_AARCH64_TSTBR14", Const, 4},
		{"R_ALPHA", Type, 0},
		{"R_ALPHA_BRADDR", Const, 0},
		{"R_ALPHA_COPY", Const, 0},
		{"R_ALPHA_GLOB_DAT", Const, 0},
		{"R_ALPHA_GPDISP", Const, 0},
		{"R_ALPHA_GPREL32", Const, 0},
		{"R_ALPHA_GPRELHIGH", Const, 0},
		{"R_ALPHA_GPRELLOW", Const, 0},
		{"R_ALPHA_GPVALUE", Const, 0},
		{"R_ALPHA_HINT", Const, 0},
		{"R_ALPHA_IMMED_BR_HI32", Const, 0},
		{"R_ALPHA_IMMED_GP_16", Const, 0},
		{"R_ALPHA_IMMED_GP_HI32", Const, 0},
		{"R_ALPHA_IMMED_LO32", Const, 0},
		{"R_ALPHA_IMMED_SCN_HI32", Const, 0},
		{"R_ALPHA_JMP_SLOT", Const, 0},
		{"R_ALPHA_LITERAL", Const, 0},
		{"R_ALPHA_LITUSE", Const, 0},
		{"R_ALPHA_NONE", Const, 0},
		{"R_ALPHA_OP_PRSHIFT", Const, 0},
		{"R_ALPHA_OP_PSUB", Const, 0},
		{"R_ALPHA_OP_PUSH", Const, 0},
		{"R_ALPHA_OP_STORE", Const, 0},
		{"R_ALPHA_REFLONG", Const, 0},
		{"R_ALPHA_REFQUAD", Const, 0},
		{"R_ALPHA_RELATIVE", Const, 0},
		{"R_ALPHA_SREL16", Const, 0},
		{"R_ALPHA_SREL32", Const, 0},
		{"R_ALPHA_SREL64", Const, 0},
		{"R_ARM", Type, 0},
		{"R_ARM_ABS12", Const, 0},
		{"R_ARM_ABS16", Const, 0},
		{"R_ARM_ABS32", Const, 0},
		{"R_ARM_ABS32_NOI", Const, 10},
		{"R_ARM_ABS8", Const, 0},
		{"R_ARM_ALU_PCREL_15_8", Const, 10},
		{"R_ARM_ALU_PCREL_23_15", Const, 10},
		{"R_ARM_ALU_PCREL_7_0", Const, 10},
		{"R_ARM_ALU_PC_G0", Const, 10},
		{"R_ARM_ALU_PC_G0_NC", Const, 10},
		{"R_ARM_ALU_PC_G1", Const, 10},
		{"R_ARM_ALU_PC_G1_NC", Const, 10},
		{"R_ARM_ALU_PC_G2", Const, 10},
		{"R_ARM_ALU_SBREL_19_12_NC", Const, 10},
		{"R_ARM_ALU_SBREL_27_20_CK", Const, 10},
		{"R_ARM_ALU_SB_G0", Const, 10},
		{"R_ARM_ALU_SB_G0_NC", Const, 10},
		{"R_ARM_ALU_SB_G1", Const, 10},
		{"R_ARM_ALU_SB_G1_NC", Const, 10},
		{"R_ARM_ALU_SB_G2", Const, 10},
		{"R_ARM_AMP_VCALL9", Const, 0},
		{"R_ARM_BASE_ABS", Const, 10},
		{"R_ARM_CALL", Const, 10},
		{"R_ARM_COPY", Const, 0},
		{"R_ARM_GLOB_DAT", Const, 0},
		{"R_ARM_GNU_VTENTRY", Const, 0},
		{"R_ARM_GNU_VTINHERIT", Const, 0},
		{"R_ARM_GOT32", Const, 0},
		{"R_ARM_GOTOFF", Const, 0},
		{"R_ARM_GOTOFF12", Const, 10},
		{"R_ARM_GOTPC", Const, 0},
		{"R_ARM_GOTRELAX", Const, 10},
		{"R_ARM_GOT_ABS", Const, 10},
		{"R_ARM_GOT_BREL12", Const, 10},
		{"R_ARM_GOT_PREL", Const, 10},
		{"R_ARM_IRELATIVE", Const, 10},
		{"R_ARM_JUMP24", Const, 10},
		{"R_ARM_JUMP_SLOT", Const, 0},
		{"R_ARM_LDC_PC_G0", Const, 10},
		{"R_ARM_LDC_PC_G1", Const, 10},
		{"R_ARM_LDC_PC_G2", Const, 10},
		{"R_ARM_LDC_SB_G0", Const, 10},
		{"R_ARM_LDC_SB_G1", Const, 10},
		{"R_ARM_LDC_SB_G2", Const, 10},
		{"R_ARM_LDRS_PC_G0", Const, 10},
		{"R_ARM_LDRS_PC_G1", Const, 10},
		{"R_ARM_LDRS_PC_G2", Const, 10},
		{"R_ARM_LDRS_SB_G0", Const, 10},
		{"R_ARM_LDRS_SB_G1", Const, 10},
		{"R_ARM_LDRS_SB_G2", Const, 10},
		{"R_ARM_LDR_PC_G1", Const, 10},
		{"R_ARM_LDR_PC_G2", Const, 10},
		{"R_ARM_LDR_SBREL_11_10_NC", Const, 10},
		{"R_ARM_LDR_SB_G0", Const, 10},
		{"R_ARM_LDR_SB_G1", Const, 10},
		{"R_ARM_LDR_SB_G2", Const, 10},
		{"R_ARM_ME_TOO", Const, 10},
		{"R_ARM_MOVT_ABS", Const, 10},
		{"R_ARM_MOVT_BREL", Const, 10},
		{"R_ARM_MOVT_PREL", Const, 10},
		{"R_ARM_MOVW_ABS_NC", Const, 10},
		{"R_ARM_MOVW_BREL", Const, 10},
		{"R_ARM_MOVW_BREL_NC", Const, 10},
		{"R_ARM_MOVW_PREL_NC", Const, 10},
		{"R_ARM_NONE", Const, 0},
		{"R_ARM_PC13", Const, 0},
		{"R_ARM_PC24", Const, 0},
		{"R_ARM_PLT32", Const, 0},
		{"R_ARM_PLT32_ABS", Const, 10},
		{"R_ARM_PREL31", Const, 10},
		{"R_ARM_PRIVATE_0", Const, 10},
		{"R_ARM_PRIVATE_1", Const, 10},
		{"R_ARM_PRIVATE_10", Const, 10},
		{"R_ARM_PRIVATE_11", Const, 10},
		{"R_ARM_PRIVATE_12", Const, 10},
		{"R_ARM_PRIVATE_13", Const, 10},
		{"R_ARM_PRIVATE_14", Const, 10},
		{"R_ARM_PRIVATE_15", Const, 10},
		{"R_ARM_PRIVATE_2", Const, 10},
		{"R_ARM_PRIVATE_3", Const, 10},
		{"R_ARM_PRIVATE_4", Const, 10},
		{"R_ARM_PRIVATE_5", Const, 10},
		{"R_ARM_PRIVATE_6", Const, 10},
		{"R_ARM_PRIVATE_7", Const, 10},
		{"R_ARM_PRIVATE_8", Const, 10},
		{"R_ARM_PRIVATE_9", Const, 10},
		{"R_ARM_RABS32", Const, 0},
		{"R_ARM_RBASE", Const, 0},
		{"R_ARM_REL32", Const, 0},
		{"R_ARM_REL32_NOI", Const, 10},
		{"R_ARM_RELATIVE", Const, 0},
		{"R_ARM_RPC24", Const, 0},
		{"R_ARM_RREL32", Const, 0},
		{"R_ARM_RSBREL32", Const, 0},
		{"R_ARM_RXPC25", Const, 10},
		{"R_ARM_SBREL31", Const, 10},
		{"R_ARM_SBREL32", Const, 0},
		{"R_ARM_SWI24", Const, 0},
		{"R_ARM_TARGET1", Const, 10},
		{"R_ARM_TARGET2", Const, 10},
		{"R_ARM_THM_ABS5", Const, 0},
		{"R_ARM_THM_ALU_ABS_G0_NC", Const, 10},
		{"R_ARM_THM_ALU_ABS_G1_NC", Const, 10},
		{"R_ARM_THM_ALU_ABS_G2_NC", Const, 10},
		{"R_ARM_THM_ALU_ABS_G3", Const, 10},
		{"R_ARM_THM_ALU_PREL_11_0", Const, 10},
		{"R_ARM_THM_GOT_BREL12", Const, 10},
		{"R_ARM_THM_JUMP11", Const, 10},
		{"R_ARM_THM_JUMP19", Const, 10},
		{"R_ARM_THM_JUMP24", Const, 10},
		{"R_ARM_THM_JUMP6", Const, 10},
		{"R_ARM_THM_JUMP8", Const, 10},
		{"R_ARM_THM_MOVT_ABS", Const, 10},
		{"R_ARM_THM_MOVT_BREL", Const, 10},
		{"R_ARM_THM_MOVT_PREL", Const, 10},
		{"R_ARM_THM_MOVW_ABS_NC", Const, 10},
		{"R_ARM_THM_MOVW_BREL", Const, 10},
		{"R_ARM_THM_MOVW_BREL_NC", Const, 10},
		{"R_ARM_THM_MOVW_PREL_NC", Const, 10},
		{"R_ARM_THM_PC12", Const, 10},
		{"R_ARM_THM_PC22", Const, 0},
		{"R_ARM_THM_PC8", Const, 0},
		{"R_ARM_THM_RPC22", Const, 0},
		{"R_ARM_THM_SWI8", Const, 0},
		{"R_ARM_THM_TLS_CALL", Const, 10},
		{"R_ARM_THM_TLS_DESCSEQ16", Const, 10},
		{"R_ARM_THM_TLS_DESCSEQ32", Const, 10},
		{"R_ARM_THM_XPC22", Const, 0},
		{"R_ARM_TLS_CALL", Const, 10},
		{"R_ARM_TLS_DESCSEQ", Const, 10},
		{"R_ARM_TLS_DTPMOD32", Const, 10},
		{"R_ARM_TLS_DTPOFF32", Const, 10},
		{"R_ARM_TLS_GD32", Const, 10},
		{"R_ARM_TLS_GOTDESC", Const, 10},
		{"R_ARM_TLS_IE12GP", Const, 10},
		{"R_ARM_TLS_IE32", Const, 10},
		{"R_ARM_TLS_LDM32", Const, 10},
		{"R_ARM_TLS_LDO12", Const, 10},
		{"R_ARM_TLS_LDO32", Const, 10},
		{"R_ARM_TLS_LE12", Const, 10},
		{"R_ARM_TLS_LE32", Const, 10},
		{"R_ARM_TLS_TPOFF32", Const, 10},
		{"R_ARM_V4BX", Const, 10},
		{"R_ARM_XPC25", Const, 0},
		{"R_INFO", Func, 0},
		{"R_INFO32", Func, 0},
		{"R_LARCH", Type, 19},
		{"R_LARCH_32", Const, 19},
		{"R_LARCH_32_PCREL", Const, 20},
		{"R_LARCH_64", Const, 19},
		{"R_LARCH_64_PCREL", Const, 22},
		{"R_LARCH_ABS64_HI12", Const, 20},
		{"R_LARCH_ABS64_LO20", Const, 20},
		{"R_LARCH_ABS_HI20", Const, 20},
		{"R_LARCH_ABS_LO12", Const, 20},
		{"R_LARCH_ADD16", Const, 19},
		{"R_LARCH_ADD24", Const, 19},
		{"R_LARCH_ADD32", Const, 19},
		{"R_LARCH_ADD6", Const, 22},
		{"R_LARCH_ADD64", Const, 19},
		{"R_LARCH_ADD8", Const, 19},
		{"R_LARCH_ADD_ULEB128", Const, 22},
		{"R_LARCH_ALIGN", Const, 22},
		{"R_LARCH_B16", Const, 20},
		{"R_LARCH_B21", Const, 20},
		{"R_LARCH_B26", Const, 20},
		{"R_LARCH_CFA", Const, 22},
		{"R_LARCH_COPY", Const, 19},
		{"R_LARCH_DELETE", Const, 22},
		{"R_LARCH_GNU_VTENTRY", Const, 20},
		{"R_LARCH_GNU_VTINHERIT", Const, 20},
		{"R_LARCH_GOT64_HI12", Const, 20},
		{"R_LARCH_GOT64_LO20", Const, 20},
		{"R_LARCH_GOT64_PC_HI12", Const, 20},
		{"R_LARCH_GOT64_PC_LO20", Const, 20},
		{"R_LARCH_GOT_HI20", Const, 20},
		{"R_LARCH_GOT_LO12", Const, 20},
		{"R_LARCH_GOT_PC_HI20", Const, 20},
		{"R_LARCH_GOT_PC_LO12", Const, 20},
		{"R_LARCH_IRELATIVE", Const, 19},
		{"R_LARCH_JUMP_SLOT", Const, 19},
		{"R_LARCH_MARK_LA", Const, 19},
		{"R_LARCH_MARK_PCREL", Const, 19},
		{"R_LARCH_NONE", Const, 19},
		{"R_LARCH_PCALA64_HI12", Const, 20},
		{"R_LARCH_PCALA64_LO20", Const, 20},
		{"R_LARCH_PCALA_HI20", Const, 20},
		{"R_LARCH_PCALA_LO12", Const, 20},
		{"R_LARCH_PCREL20_S2", Const, 22},
		{"R_LARCH_RELATIVE", Const, 19},
		{"R_LARCH_RELAX", Const, 20},
		{"R_LARCH_SOP_ADD", Const, 19},
		{"R_LARCH_SOP_AND", Const, 19},
		{"R_LARCH_SOP_ASSERT", Const, 19},
		{"R_LARCH_SOP_IF_ELSE", Const, 19},
		{"R_LARCH_SOP_NOT", Const, 19},
		{"R_LARCH_SOP_POP_32_S_0_10_10_16_S2", Const, 19},
		{"R_LARCH_SOP_POP_32_S_0_5_10_16_S2", Const, 19},
		{"R_LARCH_SOP_POP_32_S_10_12", Const, 19},
		{"R_LARCH_SOP_POP_32_S_10_16", Const, 19},
		{"R_LARCH_SOP_POP_32_S_10_16_S2", Const, 19},
		{"R_LARCH_SOP_POP_32_S_10_5", Const, 19},
		{"R_LARCH_SOP_POP_32_S_5_20", Const, 19},
		{"R_LARCH_SOP_POP_32_U", Const, 19},
		{"R_LARCH_SOP_POP_32_U_10_12", Const, 19},
		{"R_LARCH_SOP_PUSH_ABSOLUTE", Const, 19},
		{"R_LARCH_SOP_PUSH_DUP", Const, 19},
		{"R_LARCH_SOP_PUSH_GPREL", Const, 19},
		{"R_LARCH_SOP_PUSH_PCREL", Const, 19},
		{"R_LARCH_SOP_PUSH_PLT_PCREL", Const, 19},
		{"R_LARCH_SOP_PUSH_TLS_GD", Const, 19},
		{"R_LARCH_SOP_PUSH_TLS_GOT", Const, 19},
		{"R_LARCH_SOP_PUSH_TLS_TPREL", Const, 19},
		{"R_LARCH_SOP_SL", Const, 19},
		{"R_LARCH_SOP_SR", Const, 19},
		{"R_LARCH_SOP_SUB", Const, 19},
		{"R_LARCH_SUB16", Const, 19},
		{"R_LARCH_SUB24", Const, 19},
		{"R_LARCH_SUB32", Const, 19},
		{"R_LARCH_SUB6", Const, 22},
		{"R_LARCH_SUB64", Const, 19},
		{"R_LARCH_SUB8", Const, 19},
		{"R_LARCH_SUB_ULEB128", Const, 22},
		{"R_LARCH_TLS_DTPMOD32", Const, 19},
		{"R_LARCH_TLS_DTPMOD64", Const, 19},
		{"R_LARCH_TLS_DTPREL32", Const, 19},
		{"R_LARCH_TLS_DTPREL64", Const, 19},
		{"R_LARCH_TLS_GD_HI20", Const, 20},
		{"R_LARCH_TLS_GD_PC_HI20", Const, 20},
		{"R_LARCH_TLS_IE64_HI12", Const, 20},
		{"R_LARCH_TLS_IE64_LO20", Const, 20},
		{"R_LARCH_TLS_IE64_PC_HI12", Const, 20},
		{"R_LARCH_TLS_IE64_PC_LO20", Const, 20},
		{"R_LARCH_TLS_IE_HI20", Const, 20},
		{"R_LARCH_TLS_IE_LO12", Const, 20},
		{"R_LARCH_TLS_IE_PC_HI20", Const, 20},
		{"R_LARCH_TLS_IE_PC_LO12", Const, 20},
		{"R_LARCH_TLS_LD_HI20", Const, 20},
		{"R_LARCH_TLS_LD_PC_HI20", Const, 20},
		{"R_LARCH_TLS_LE64_HI12", Const, 20},
		{"R_LARCH_TLS_LE64_LO20", Const, 20},
		{"R_LARCH_TLS_LE_HI20", Const, 20},
		{"R_LARCH_TLS_LE_LO12", Const, 20},
		{"R_LARCH_TLS_TPREL32", Const, 19},
		{"R_LARCH_TLS_TPREL64", Const, 19},
		{"R_MIPS", Type, 6},
		{"R_MIPS_16", Const, 6},
		{"R_MIPS_26", Const, 6},
		{"R_MIPS_32", Const, 6},
		{"R_MIPS_64", Const, 6},
		{"R_MIPS_ADD_IMMEDIATE", Const, 6},
		{"R_MIPS_CALL16", Const, 6},
		{"R_MIPS_CALL_HI16", Const, 6},
		{"R_MIPS_CALL_LO16", Const, 6},
		{"R_MIPS_DELETE", Const, 6},
		{"R_MIPS_GOT16", Const, 6},
		{"R_MIPS_GOT_DISP", Const, 6},
		{"R_MIPS_GOT_HI16", Const, 6},
		{"R_MIPS_GOT_LO16", Const, 6},
		{"R_MIPS_GOT_OFST", Const, 6},
		{"R_MIPS_GOT_PAGE", Const, 6},
		{"R_MIPS_GPREL16", Const, 6},
		{"R_MIPS_GPREL32", Const, 6},
		{"R_MIPS_HI16", Const, 6},
		{"R_MIPS_HIGHER", Const, 6},
		{"R_MIPS_HIGHEST", Const, 6},
		{"R_MIPS_INSERT_A", Const, 6},
		{"R_MIPS_INSERT_B", Const, 6},
		{"R_MIPS_JALR", Const, 6},
		{"R_MIPS_LITERAL", Const, 6},
		{"R_MIPS_LO16", Const, 6},
		{"R_MIPS_NONE", Const, 6},
		{"R_MIPS_PC16", Const, 6},
		{"R_MIPS_PC32", Const, 22},
		{"R_MIPS_PJUMP", Const, 6},
		{"R_MIPS_REL16", Const, 6},
		{"R_MIPS_REL32", Const, 6},
		{"R_MIPS_RELGOT", Const, 6},
		{"R_MIPS_SCN_DISP", Const, 6},
		{"R_MIPS_SHIFT5", Const, 6},
		{"R_MIPS_SHIFT6", Const, 6},
		{"R_MIPS_SUB", Const, 6},
		{"R_MIPS_TLS_DTPMOD32", Const, 6},
		{"R_MIPS_TLS_DTPMOD64", Const, 6},
		{"R_MIPS_TLS_DTPREL32", Const, 6},
		{"R_MIPS_TLS_DTPREL64", Const, 6},
		{"R_MIPS_TLS_DTPREL_HI16", Const, 6},
		{"R_MIPS_TLS_DTPREL_LO16", Const, 6},
		{"R_MIPS_TLS_GD", Const, 6},
		{"R_MIPS_TLS_GOTTPREL", Const, 6},
		{"R_MIPS_TLS_LDM", Const, 6},
		{"R_MIPS_TLS_TPREL32", Const, 6},
		{"R_MIPS_TLS_TPREL64", Const, 6},
		{"R_MIPS_TLS_TPREL_HI16", Const, 6},
		{"R_MIPS_TLS_TPREL_LO16", Const, 6},
		{"R_PPC", Type, 0},
		{"R_PPC64", Type, 5},
		{"R_PPC64_ADDR14", Const, 5},
		{"R_PPC64_ADDR14_BRNTAKEN", Const, 5},
		{"R_PPC64_ADDR14_BRTAKEN", Const, 5},
		{"R_PPC64_ADDR16", Const, 5},
		{"R_PPC64_ADDR16_DS", Const, 5},
		{"R_PPC64_ADDR16_HA", Const, 5},
		{"R_PPC64_ADDR16_HI", Const, 5},
		{"R_PPC64_ADDR16_HIGH", Const, 10},
		{"R_PPC64_ADDR16_HIGHA", Const, 10},
		{"R_PPC64_ADDR16_HIGHER", Const, 5},
		{"R_PPC64_ADDR16_HIGHER34", Const, 20},
		{"R_PPC64_ADDR16_HIGHERA", Const, 5},
		{"R_PPC64_ADDR16_HIGHERA34", Const, 20},
		{"R_PPC64_ADDR16_HIGHEST", Const, 5},
		{"R_PPC64_ADDR16_HIGHEST34", Const, 20},
		{"R_PPC64_ADDR16_HIGHESTA", Const, 5},
		{"R_PPC64_ADDR16_HIGHESTA34", Const, 20},
		{"R_PPC64_ADDR16_LO", Const, 5},
		{"R_PPC64_ADDR16_LO_DS", Const, 5},
		{"R_PPC64_ADDR24", Const, 5},
		{"R_PPC64_ADDR32", Const, 5},
		{"R_PPC64_ADDR64", Const, 5},
		{"R_PPC64_ADDR64_LOCAL", Const, 10},
		{"R_PPC64_COPY", Const, 20},
		{"R_PPC64_D28", Const, 20},
		{"R_PPC64_D34", Const, 20},
		{"R_PPC64_D34_HA30", Const, 20},
		{"R_PPC64_D34_HI30", Const, 20},
		{"R_PPC64_D34_LO", Const, 20},
		{"R_PPC64_DTPMOD64", Const, 5},
		{"R_PPC64_DTPREL16", Const, 5},
		{"R_PPC64_DTPREL16_DS", Const, 5},
		{"R_PPC64_DTPREL16_HA", Const, 5},
		{"R_PPC64_DTPREL16_HI", Const, 5},
		{"R_PPC64_DTPREL16_HIGH", Const, 10},
		{"R_PPC64_DTPREL16_HIGHA", Const, 10},
		{"R_PPC64_DTPREL16_HIGHER", Const, 5},
		{"R_PPC64_DTPREL16_HIGHERA", Const, 5},
		{"R_PPC64_DTPREL16_HIGHEST", Const, 5},
		{"R_PPC64_DTPREL16_HIGHESTA", Const, 5},
		{"R_PPC64_DTPREL16_LO", Const, 5},
		{"R_PPC64_DTPREL16_LO_DS", Const, 5},
		{"R_PPC64_DTPREL34", Const, 20},
		{"R_PPC64_DTPREL64", Const, 5},
		{"R_PPC64_ENTRY", Const, 10},
		{"R_PPC64_GLOB_DAT", Const, 20},
		{"R_PPC64_GNU_VTENTRY", Const, 20},
		{"R_PPC64_GNU_VTINHERIT", Const, 20},
		{"R_PPC64_GOT16", Const, 5},
		{"R_PPC64_GOT16_DS", Const, 5},
		{"R_PPC64_GOT16_HA", Const, 5},
		{"R_PPC64_GOT16_HI", Const, 5},
		{"R_PPC64_GOT16_LO", Const, 5},
		{"R_PPC64_GOT16_LO_DS", Const, 5},
		{"R_PPC64_GOT_DTPREL16_DS", Const, 5},
		{"R_PPC64_GOT_DTPREL16_HA", Const, 5},
		{"R_PPC64_GOT_DTPREL16_HI", Const, 5},
		{"R_PPC64_GOT_DTPREL16_LO_DS", Const, 5},
		{"R_PPC64_GOT_DTPREL_PCREL34", Const, 20},
		{"R_PPC64_GOT_PCREL34", Const, 20},
		{"R_PPC64_GOT_TLSGD16", Const, 5},
		{"R_PPC64_GOT_TLSGD16_HA", Const, 5},
		{"R_PPC64_GOT_TLSGD16_HI", Const, 5},
		{"R_PPC64_GOT_TLSGD16_LO", Const, 5},
		{"R_PPC64_GOT_TLSGD_PCREL34", Const, 20},
		{"R_PPC64_GOT_TLSLD16", Const, 5},
		{"R_PPC64_GOT_TLSLD16_HA", Const, 5},
		{"R_PPC64_GOT_TLSLD16_HI", Const, 5},
		{"R_PPC64_GOT_TLSLD16_LO", Const, 5},
		{"R_PPC64_GOT_TLSLD_PCREL34", Const, 20},
		{"R_PPC64_GOT_TPREL16_DS", Const, 5},
		{"R_PPC64_GOT_TPREL16_HA", Const, 5},
		{"R_PPC64_GOT_TPREL16_HI", Const, 5},
		{"R_PPC64_GOT_TPREL16_LO_DS", Const, 5},
		{"R_PPC64_GOT_TPREL_PCREL34", Const, 20},
		{"R_PPC64_IRELATIVE", Const, 10},
		{"R_PPC64_JMP_IREL", Const, 10},
		{"R_PPC64_JMP_SLOT", Const, 5},
		{"R_PPC64_NONE", Const, 5},
		{"R_PPC64_PCREL28", Const, 20},
		{"R_PPC64_PCREL34", Const, 20},
		{"R_PPC64_PCREL_OPT", Const, 20},
		{"R_PPC64_PLT16_HA", Const, 20},
		{"R_PPC64_PLT16_HI", Const, 20},
		{"R_PPC64_PLT16_LO", Const, 20},
		{"R_PPC64_PLT16_LO_DS", Const, 10},
		{"R_PPC64_PLT32", Const, 20},
		{"R_PPC64_PLT64", Const, 20},
		{"R_PPC64_PLTCALL", Const, 20},
		{"R_PPC64_PLTCALL_NOTOC", Const, 20},
		{"R_PPC64_PLTGOT16", Const, 10},
		{"R_PPC64_PLTGOT16_DS", Const, 10},
		{"R_PPC64_PLTGOT16_HA", Const, 10},
		{"R_PPC64_PLTGOT16_HI", Const, 10},
		{"R_PPC64_PLTGOT16_LO", Const, 10},
		{"R_PPC64_PLTGOT_LO_DS", Const, 10},
		{"R_PPC64_PLTREL32", Const, 20},
		{"R_PPC64_PLTREL64", Const, 20},
		{"R_PPC64_PLTSEQ", Const, 20},
		{"R_PPC64_PLTSEQ_NOTOC", Const, 20},
		{"R_PPC64_PLT_PCREL34", Const, 20},
		{"R_PPC64_PLT_PCREL34_NOTOC", Const, 20},
		{"R_PPC64_REL14", Const, 5},
		{"R_PPC64_REL14_BRNTAKEN", Const, 5},
		{"R_PPC64_REL14_BRTAKEN", Const, 5},
		{"R_PPC64_REL16", Const, 5},
		{"R_PPC64_REL16DX_HA", Const, 10},
		{"R_PPC64_REL16_HA", Const, 5},
		{"R_PPC64_REL16_HI", Const, 5},
		{"R_PPC64_REL16_HIGH", Const, 20},
		{"R_PPC64_REL16_HIGHA", Const, 20},
		{"R_PPC64_REL16_HIGHER", Const, 20},
		{"R_PPC64_REL16_HIGHER34", Const, 20},
		{"R_PPC64_REL16_HIGHERA", Const, 20},
		{"R_PPC64_REL16_HIGHERA34", Const, 20},
		{"R_PPC64_REL16_HIGHEST", Const, 20},
		{"R_PPC64_REL16_HIGHEST34", Const, 20},
		{"R_PPC64_REL16_HIGHESTA", Const, 20},
		{"R_PPC64_REL16_HIGHESTA34", Const, 20},
		{"R_PPC64_REL16_LO", Const, 5},
		{"R_PPC64_REL24", Const, 5},
		{"R_PPC64_REL24_NOTOC", Const, 10},
		{"R_PPC64_REL24_P9NOTOC", Const, 21},
		{"R_PPC64_REL30", Const, 20},
		{"R_PPC64_REL32", Const, 5},
		{"R_PPC64_REL64", Const, 5},
		{"R_PPC64_RELATIVE", Const, 18},
		{"R_PPC64_SECTOFF", Const, 20},
		{"R_PPC64_SECTOFF_DS", Const, 10},
		{"R_PPC64_SECTOFF_HA", Const, 20},
		{"R_PPC64_SECTOFF_HI", Const, 20},
		{"R_PPC64_SECTOFF_LO", Const, 20},
		{"R_PPC64_SECTOFF_LO_DS", Const, 10},
		{"R_PPC64_TLS", Const, 5},
		{"R_PPC64_TLSGD", Const, 5},
		{"R_PPC64_TLSLD", Const, 5},
		{"R_PPC64_TOC", Const, 5},
		{"R_PPC64_TOC16", Const, 5},
		{"R_PPC64_TOC16_DS", Const, 5},
		{"R_PPC64_TOC16_HA", Const, 5},
		{"R_PPC64_TOC16_HI", Const, 5},
		{"R_PPC64_TOC16_LO", Const, 5},
		{"R_PPC64_TOC16_LO_DS", Const, 5},
		{"R_PPC64_TOCSAVE", Const, 10},
		{"R_PPC64_TPREL16", Const, 5},
		{"R_PPC64_TPREL16_DS", Const, 5},
		{"R_PPC64_TPREL16_HA", Const, 5},
		{"R_PPC64_TPREL16_HI", Const, 5},
		{"R_PPC64_TPREL16_HIGH", Const, 10},
		{"R_PPC64_TPREL16_HIGHA", Const, 10},
		{"R_PPC64_TPREL16_HIGHER", Const, 5},
		{"R_PPC64_TPREL16_HIGHERA", Const, 5},
		{"R_PPC64_TPREL16_HIGHEST", Const, 5},
		{"R_PPC64_TPREL16_HIGHESTA", Const, 5},
		{"R_PPC64_TPREL16_LO", Const, 5},
		{"R_PPC64_TPREL16_LO_DS", Const, 5},
		{"R_PPC64_TPREL34", Const, 20},
		{"R_PPC64_TPREL64", Const, 5},
		{"R_PPC64_UADDR16", Const, 20},
		{"R_PPC64_UADDR32", Const, 20},
		{"R_PPC64_UADDR64", Const, 20},
		{"R_PPC_ADDR14", Const, 0},
		{"R_PPC_ADDR14_BRNTAKEN", Const, 0},
		{"R_PPC_ADDR14_BRTAKEN", Const, 0},
		{"R_PPC_ADDR16", Const, 0},
		{"R_PPC_ADDR16_HA", Const, 0},
		{"R_PPC_ADDR16_HI", Const, 0},
		{"R_PPC_ADDR16_LO", Const, 0},
		{"R_PPC_ADDR24", Const, 0},
		{"R_PPC_ADDR32", Const, 0},
		{"R_PPC_COPY", Const, 0},
		{"R_PPC_DTPMOD32", Const, 0},
		{"R_PPC_DTPREL16", Const, 0},
		{"R_PPC_DTPREL16_HA", Const, 0},
		{"R_PPC_DTPREL16_HI", Const, 0},
		{"R_PPC_DTPREL16_LO", Const, 0},
		{"R_PPC_DTPREL32", Const, 0},
		{"R_PPC_EMB_BIT_FLD", Const, 0},
		{"R_PPC_EMB_MRKREF", Const, 0},
		{"R_PPC_EMB_NADDR16", Const, 0},
		{"R_PPC_EMB_NADDR16_HA", Const, 0},
		{"R_PPC_EMB_NADDR16_HI", Const, 0},
		{"R_PPC_EMB_NADDR16_LO", Const, 0},
		{"R_PPC_EMB_NADDR32", Const, 0},
		{"R_PPC_EMB_RELSDA", Const, 0},
		{"R_PPC_EMB_RELSEC16", Const, 0},
		{"R_PPC_EMB_RELST_HA", Const, 0},
		{"R_PPC_EMB_RELST_HI", Const, 0},
		{"R_PPC_EMB_RELST_LO", Const, 0},
		{"R_PPC_EMB_SDA21", Const, 0},
		{"R_PPC_EMB_SDA2I16", Const, 0},
		{"R_PPC_EMB_SDA2REL", Const, 0},
		{"R_PPC_EMB_SDAI16", Const, 0},
		{"R_PPC_GLOB_DAT", Const, 0},
		{"R_PPC_GOT16", Const, 0},
		{"R_PPC_GOT16_HA", Const, 0},
		{"R_PPC_GOT16_HI", Const, 0},
		{"R_PPC_GOT16_LO", Const, 0},
		{"R_PPC_GOT_TLSGD16", Const, 0},
		{"R_PPC_GOT_TLSGD16_HA", Const, 0},
		{"R_PPC_GOT_TLSGD16_HI", Const, 0},
		{"R_PPC_GOT_TLSGD16_LO", Const, 0},
		{"R_PPC_GOT_TLSLD16", Const, 0},
		{"R_PPC_GOT_TLSLD16_HA", Const, 0},
		{"R_PPC_GOT_TLSLD16_HI", Const, 0},
		{"R_PPC_GOT_TLSLD16_LO", Const, 0},
		{"R_PPC_GOT_TPREL16", Const, 0},
		{"R_PPC_GOT_TPREL16_HA", Const, 0},
		{"R_PPC_GOT_TPREL16_HI", Const, 0},
		{"R_PPC_GOT_TPREL16_LO", Const, 0},
		{"R_PPC_JMP_SLOT", Const, 0},
		{"R_PPC_LOCAL24PC", Const, 0},
		{"R_PPC_NONE", Const, 0},
		{"R_PPC_PLT16_HA", Const, 0},
		{"R_PPC_PLT16_HI", Const, 0},
		{"R_PPC_PLT16_LO", Const, 0},
		{"R_PPC_PLT32", Const, 0},
		{"R_PPC_PLTREL24", Const, 0},
		{"R_PPC_PLTREL32", Const, 0},
		{"R_PPC_REL14", Const, 0},
		{"R_PPC_REL14_BRNTAKEN", Const, 0},
		{"R_PPC_REL14_BRTAKEN", Const, 0},
		{"R_PPC_REL24", Const, 0},
		{"R_PPC_REL32", Const, 0},
		{"R_PPC_RELATIVE", Const, 0},
		{"R_PPC_SDAREL16", Const, 0},
		{"R_PPC_SECTOFF", Const, 0},
		{"R_PPC_SECTOFF_HA", Const, 0},
		{"R_PPC_SECTOFF_HI", Const, 0},
		{"R_PPC_SECTOFF_LO", Const, 0},
		{"R_PPC_TLS", Const, 0},
		{"R_PPC_TPREL16", Const, 0},
		{"R_PPC_TPREL16_HA", Const, 0},
		{"R_PPC_TPREL16_HI", Const, 0},
		{"R_PPC_TPREL16_LO", Const, 0},
		{"R_PPC_TPREL32", Const, 0},
		{"R_PPC_UADDR16", Const, 0},
		{"R_PPC_UADDR32", Const, 0},
		{"R_RISCV", Type, 11},
		{"R_RISCV_32", Const, 11},
		{"R_RISCV_32_PCREL", Const, 12},
		{"R_RISCV_64", Const, 11},
		{"R_RISCV_ADD16", Const, 11},
		{"R_RISCV_ADD32", Const, 11},
		{"R_RISCV_ADD64", Const, 11},
		{"R_RISCV_ADD8", Const, 11},
		{"R_RISCV_ALIGN", Const, 11},
		{"R_RISCV_BRANCH", Const, 11},
		{"R_RISCV_CALL", Const, 11},
		{"R_RISCV_CALL_PLT", Const, 11},
		{"R_RISCV_COPY", Const, 11},
		{"R_RISCV_GNU_VTENTRY", Const, 11},
		{"R_RISCV_GNU_VTINHERIT", Const, 11},
		{"R_RISCV_GOT_HI20", Const, 11},
		{"R_RISCV_GPREL_I", Const, 11},
		{"R_RISCV_GPREL_S", Const, 11},
		{"R_RISCV_HI20", Const, 11},
		{"R_RISCV_JAL", Const, 11},
		{"R_RISCV_JUMP_SLOT", Const, 11},
		{"R_RISCV_LO12_I", Const, 11},
		{"R_RISCV_LO12_S", Const, 11},
		{"R_RISCV_NONE", Const, 11},
		{"R_RISCV_PCREL_HI20", Const, 11},
		{"R_RISCV_PCREL_LO12_I", Const, 11},
		{"R_RISCV_PCREL_LO12_S", Const, 11},
		{"R_RISCV_RELATIVE", Const, 11},
		{"R_RISCV_RELAX", Const, 11},
		{"R_RISCV_RVC_BRANCH", Const, 11},
		{"R_RISCV_RVC_JUMP", Const, 11},
		{"R_RISCV_RVC_LUI", Const, 11},
		{"R_RISCV_SET16", Const, 11},
		{"R_RISCV_SET32", Const, 11},
		{"R_RISCV_SET6", Const, 11},
		{"R_RISCV_SET8", Const, 11},
		{"R_RISCV_SUB16", Const, 11},
		{"R_RISCV_SUB32", Const, 11},
		{"R_RISCV_SUB6", Const, 11},
		{"R_RISCV_SUB64", Const, 11},
		{"R_RISCV_SUB8", Const, 11},
		{"R_RISCV_TLS_DTPMOD32", Const, 11},
		{"R_RISCV_TLS_DTPMOD64", Const, 11},
		{"R_RISCV_TLS_DTPREL32", Const, 11},
		{"R_RISCV_TLS_DTPREL64", Const, 11},
		{"R_RISCV_TLS_GD_HI20", Const, 11},
		{"R_RISCV_TLS_GOT_HI20", Const, 11},
		{"R_RISCV_TLS_TPREL32", Const, 11},
		{"R_RISCV_TLS_TPREL64", Const, 11},
		{"R_RISCV_TPREL_ADD", Const, 11},
		{"R_RISCV_TPREL_HI20", Const, 11},
		{"R_RISCV_TPREL_I", Const, 11},
		{"R_RISCV_TPREL_LO12_I", Const, 11},
		{"R_RISCV_TPREL_LO12_S", Const, 11},
		{"R_RISCV_TPREL_S", Const, 11},
		{"R_SPARC", Type, 0},
		{"R_SPARC_10", Const, 0},
		{"R_SPARC_11", Const, 0},
		{"R_SPARC_13", Const, 0},
		{"R_SPARC_16", Const, 0},
		{"R_SPARC_22", Const, 0},
		{"R_SPARC_32", Const, 0},
		{"R_SPARC_5", Const, 0},
		{"R_SPARC_6", Const, 0},
		{"R_SPARC_64", Const, 0},
		{"R_SPARC_7", Const, 0},
		{"R_SPARC_8", Const, 0},
		{"R_SPARC_COPY", Const, 0},
		{"R_SPARC_DISP16", Const, 0},
		{"R_SPARC_DISP32", Const, 0},
		{"R_SPARC_DISP64", Const, 0},
		{"R_SPARC_DISP8", Const, 0},
		{"R_SPARC_GLOB_DAT", Const, 0},
		{"R_SPARC_GLOB_JMP", Const, 0},
		{"R_SPARC_GOT10", Const, 0},
		{"R_SPARC_GOT13", Const, 0},
		{"R_SPARC_GOT22", Const, 0},
		{"R_SPARC_H44", Const, 0},
		{"R_SPARC_HH22", Const, 0},
		{"R_SPARC_HI22", Const, 0},
		{"R_SPARC_HIPLT22", Const, 0},
		{"R_SPARC_HIX22", Const, 0},
		{"R_SPARC_HM10", Const, 0},
		{"R_SPARC_JMP_SLOT", Const, 0},
		{"R_SPARC_L44", Const, 0},
		{"R_SPARC_LM22", Const, 0},
		{"R_SPARC_LO10", Const, 0},
		{"R_SPARC_LOPLT10", Const, 0},
		{"R_SPARC_LOX10", Const, 0},
		{"R_SPARC_M44", Const, 0},
		{"R_SPARC_NONE", Const, 0},
		{"R_SPARC_OLO10", Const, 0},
		{"R_SPARC_PC10", Const, 0},
		{"R_SPARC_PC22", Const, 0},
		{"R_SPARC_PCPLT10", Const, 0},
		{"R_SPARC_PCPLT22", Const, 0},
		{"R_SPARC_PCPLT32", Const, 0},
		{"R_SPARC_PC_HH22", Const, 0},
		{"R_SPARC_PC_HM10", Const, 0},
		{"R_SPARC_PC_LM22", Const, 0},
		{"R_SPARC_PLT32", Const, 0},
		{"R_SPARC_PLT64", Const, 0},
		{"R_SPARC_REGISTER", Const, 0},
		{"R_SPARC_RELATIVE", Const, 0},
		{"R_SPARC_UA16", Const, 0},
		{"R_SPARC_UA32", Const, 0},
		{"R_SPARC_UA64", Const, 0},
		{"R_SPARC_WDISP16", Const, 0},
		{"R_SPARC_WDISP19", Const, 0},
		{"R_SPARC_WDISP22", Const, 0},
		{"R_SPARC_WDISP30", Const, 0},
		{"R_SPARC_WPLT30", Const, 0},
		{"R_SYM32", Func, 0},
		{"R_SYM64", Func, 0},
		{"R_TYPE32", Func, 0},
		{"R_TYPE64", Func, 0},
		{"R_X86_64", Type, 0},
		{"R_X86_64_16", Const, 0},
		{"R_X86_64_32", Const, 0},
		{"R_X86_64_32S", Const, 0},
		{"R_X86_64_64", Const, 0},
		{"R_X86_64_8", Const, 0},
		{"R_X86_64_COPY", Const, 0},
		{"R_X86_64_DTPMOD64", Const, 0},
		{"R_X86_64_DTPOFF32", Const, 0},
		{"R_X86_64_DTPOFF64", Const, 0},
		{"R_X86_64_GLOB_DAT", Const, 0},
		{"R_X86_64_GOT32", Const, 0},
		{"R_X86_64_GOT64", Const, 10},
		{"R_X86_64_GOTOFF64", Const, 10},
		{"R_X86_64_GOTPC32", Const, 10},
		{"R_X86_64_GOTPC32_TLSDESC", Const, 10},
		{"R_X86_64_GOTPC64", Const, 10},
		{"R_X86_64_GOTPCREL", Const, 0},
		{"R_X86_64_GOTPCREL64", Const, 10},
		{"R_X86_64_GOTPCRELX", Const, 10},
		{"R_X86_64_GOTPLT64", Const, 10},
		{"R_X86_64_GOTTPOFF", Const, 0},
		{"R_X86_64_IRELATIVE", Const, 10},
		{"R_X86_64_JMP_SLOT", Const, 0},
		{"R_X86_64_NONE", Const, 0},
		{"R_X86_64_PC16", Const, 0},
		{"R_X86_64_PC32", Const, 0},
		{"R_X86_64_PC32_BND", Const, 10},
		{"R_X86_64_PC64", Const, 10},
		{"R_X86_64_PC8", Const, 0},
		{"R_X86_64_PLT32", Const, 0},
		{"R_X86_64_PLT32_BND", Const, 10},
		{"R_X86_64_PLTOFF64", Const, 10},
		{"R_X86_64_RELATIVE", Const, 0},
		{"R_X86_64_RELATIVE64", Const, 10},
		{"R_X86_64_REX_GOTPCRELX", Const, 10},
		{"R_X86_64_SIZE32", Const, 10},
		{"R_X86_64_SIZE64", Const, 10},
		{"R_X86_64_TLSDESC", Const, 10},
		{"R_X86_64_TLSDESC_CALL", Const, 10},
		{"R_X86_64_TLSGD", Const, 0},
		{"R_X86_64_TLSLD", Const, 0},
		{"R_X86_64_TPOFF32", Const, 0},
		{"R_X86_64_TPOFF64", Const, 0},
		{"Rel32", Type, 0},
		{"Rel32.Info", Field, 0},
		{"Rel32.Off", Field, 0},
		{"Rel64", Type, 0},
		{"Rel64.Info", Field, 0},
		{"Rel64.Off", Field, 0},
		{"Rela32", Type, 0},
		{"Rela32.Addend", Field, 0},
		{"Rela32.Info", Field, 0},
		{"Rela32.Off", Field, 0},
		{"Rela64", Type, 0},
		{"Rela64.Addend", Field, 0},
		{"Rela64.Info", Field, 0},
		{"Rela64.Off", Field, 0},
		{"SHF_ALLOC", Const, 0},
		{"SHF_COMPRESSED", Const, 6},
		{"SHF_EXECINSTR", Const, 0},
		{"SHF_GROUP", Const, 0},
		{"SHF_INFO_LINK", Const, 0},
		{"SHF_LINK_ORDER", Const, 0},
		{"SHF_MASKOS", Const, 0},
		{"SHF_MASKPROC", Const, 0},
		{"SHF_MERGE", Const, 0},
		{"SHF_OS_NONCONFORMING", Const, 0},
		{"SHF_STRINGS", Const, 0},
		{"SHF_TLS", Const, 0},
		{"SHF_WRITE", Const, 0},
		{"SHN_ABS", Const, 0},
		{"SHN_COMMON", Const, 0},
		{"SHN_HIOS", Const, 0},
		{"SHN_HIPROC", Const, 0},
		{"SHN_HIRESERVE", Const, 0},
		{"SHN_LOOS", Const, 0},
		{"SHN_LOPROC", Const, 0},
		{"SHN_LORESERVE", Const, 0},
		{"SHN_UNDEF", Const, 0},
		{"SHN_XINDEX", Const, 0},
		{"SHT_DYNAMIC", Const, 0},
		{"SHT_DYNSYM", Const, 0},
		{"SHT_FINI_ARRAY", Const, 0},
		{"SHT_GNU_ATTRIBUTES", Const, 0},
		{"SHT_GNU_HASH", Const, 0},
		{"SHT_GNU_LIBLIST", Const, 0},
		{"SHT_GNU_VERDEF", Const, 0},
		{"SHT_GNU_VERNEED", Const, 0},
		{"SHT_GNU_VERSYM", Const, 0},
		{"SHT_GROUP", Const, 0},
		{"SHT_HASH", Const, 0},
		{"SHT_HIOS", Const, 0},
		{"SHT_HIPROC", Const, 0},
		{"SHT_HIUSER", Const, 0},
		{"SHT_INIT_ARRAY", Const, 0},
		{"SHT_LOOS", Const, 0},
		{"SHT_LOPROC", Const, 0},
		{"SHT_LOUSER", Const, 0},
		{"SHT_MIPS_ABIFLAGS", Const, 17},
		{"SHT_NOBITS", Const, 0},
		{"SHT_NOTE", Const, 0},
		{"SHT_NULL", Const, 0},
		{"SHT_PREINIT_ARRAY", Const, 0},
		{"SHT_PROGBITS", Const, 0},
		{"SHT_REL", Const, 0},
		{"SHT_RELA", Const, 0},
		{"SHT_SHLIB", Const, 0},
		{"SHT_STRTAB", Const, 0},
		{"SHT_SYMTAB", Const, 0},
		{"SHT_SYMTAB_SHNDX", Const, 0},
		{"STB_GLOBAL", Const, 0},
		{"STB_HIOS", Const, 0},
		{"STB_HIPROC", Const, 0},
		{"STB_LOCAL", Const, 0},
		{"STB_LOOS", Const, 0},
		{"STB_LOPROC", Const, 0},
		{"STB_WEAK", Const, 0},
		{"STT_COMMON", Const, 0},
		{"STT_FILE", Const, 0},
		{"STT_FUNC", Const, 0},
		{"STT_GNU_IFUNC", Const, 23},
		{"STT_HIOS", Const, 0},
		{"STT_HIPROC", Const, 0},
		{"STT_LOOS", Const, 0},
		{"STT_LOPROC", Const, 0},
		{"STT_NOTYPE", Const, 0},
		{"STT_OBJECT", Const, 0},
		{"STT_RELC", Const, 23},
		{"STT_SECTION", Const, 0},
		{"STT_SRELC", Const, 23},
		{"STT_TLS", Const, 0},
		{"STV_DEFAULT", Const, 0},
		{"STV_HIDDEN", Const, 0},
		{"STV_INTERNAL", Const, 0},
		{"STV_PROTECTED", Const, 0},
		{"ST_BIND", Func, 0},
		{"ST_INFO", Func, 0},
		{"ST_TYPE", Func, 0},
		{"ST_VISIBILITY", Func, 0},
		{"Section", Type, 0},
		{"Section.ReaderAt", Field, 0},
		{"Section.SectionHeader", Field, 0},
		{"Section32", Type, 0},
		{"Section32.Addr", Field, 0},
		{"Section32.Addralign", Field, 0},
		{"Section32.Entsize", Field, 0},
		{"Section32.Flags", Field, 0},
		{"Section32.Info", Field, 0},
		{"Section32.Link", Field, 0},
		{"Section32.Name", Field, 0},
		{"Section32.Off", Field, 0},
		{"Section32.Size", Field, 0},
		{"Section32.Type", Field, 0},
		{"Section64", Type, 0},
		{"Section64.Addr", Field, 0},
		{"Section64.Addralign", Field, 0},
		{"Section64.Entsize", Field, 0},
		{"Section64.Flags", Field, 0},
		{"Section64.Info", Field, 0},
		{"Section64.Link", Field, 0},
		{"Section64.Name", Field, 0},
		{"Section64.Off", Field, 0},
		{"Section64.Size", Field, 0},
		{"Section64.Type", Field, 0},
		{"SectionFlag", Type, 0},
		{"SectionHeader", Type, 0},
		{"SectionHeader.Addr", Field, 0},
		{"SectionHeader.Addralign", Field, 0},
		{"SectionHeader.Entsize", Field, 0},
		{"SectionHeader.FileSize", Field, 6},
		{"SectionHeader.Flags", Field, 0},
		{"SectionHeader.Info", Field, 0},
		{"SectionHeader.Link", Field, 0},
		{"SectionHeader.Name", Field, 0},
		{"SectionHeader.Offset", Field, 0},
		{"SectionHeader.Size", Field, 0},
		{"SectionHeader.Type", Field, 0},
		{"SectionIndex", Type, 0},
		{"SectionType", Type, 0},
		{"Sym32", Type, 0},
		{"Sym32.Info", Field, 0},
		{"Sym32.Name", Field, 0},
		{"Sym32.Other", Field, 0},
		{"Sym32.Shndx", Field, 0},
		{"Sym32.Size", Field, 0},
		{"Sym32.Value", Field, 0},
		{"Sym32Size", Const, 0},
		{"Sym64", Type, 0},
		{"Sym64.Info", Field, 0},
		{"Sym64.Name", Field, 0},
		{"Sym64.Other", Field, 0},
		{"Sym64.Shndx", Field, 0},
		{"Sym64.Size", Field, 0},
		{"Sym64.Value", Field, 0},
		{"Sym64Size", Const, 0},
		{"SymBind", Type, 0},
		{"SymType", Type, 0},
		{"SymVis", Type, 0},
		{"Symbol", Type, 0},
		{"Symbol.HasVersion", Field, 24},
		{"Symbol.Info", Field, 0},
		{"Symbol.Library", Field, 13},
		{"Symbol.Name", Field, 0},
		{"Symbol.Other", Field, 0},
		{"Symbol.Section", Field, 0},
		{"Symbol.Size", Field, 0},
		{"Symbol.Value", Field, 0},
		{"Symbol.Version", Field, 13},
		{"Symbol.VersionIndex", Field, 24},
		{"Type", Type, 0},
		{"VER_FLG_BASE", Const, 24},
		{"VER_FLG_INFO", Const, 24},
		{"VER_FLG_WEAK", Const, 24},
		{"Version", Type, 0},
		{"VersionIndex", Type, 24},
	},
	"debug/gosym": {
		{"(*DecodingError).Error", Method, 0},
		{"(*LineTable).LineToPC", Method, 0},
		{"(*LineTable).PCToLine", Method, 0},
		{"(*Sym).BaseName", Method, 0},
		{"(*Sym).PackageName", Method, 0},
		{"(*Sym).ReceiverName", Method, 0},
		{"(*Sym).Static", Method, 0},
		{"(*Table).LineToPC", Method, 0},
		{"(*Table).LookupFunc", Method, 0},
		{"(*Table).LookupSym", Method, 0},
		{"(*Table).PCToFunc", Method, 0},
		{"(*Table).PCToLine", Method, 0},
		{"(*Table).SymByAddr", Method, 0},
		{"(*UnknownLineError).Error", Method, 0},
		{"(Func).BaseName", Method, 0},
		{"(Func).PackageName", Method, 0},
		{"(Func).ReceiverName", Method, 0},
		{"(Func).Static", Method, 0},
		{"(UnknownFileError).Error", Method, 0},
		{"DecodingError", Type, 0},
		{"Func", Type, 0},
		{"Func.End", Field, 0},
		{"Func.Entry", Field, 0},
		{"Func.FrameSize", Field, 0},
		{"Func.LineTable", Field, 0},
		{"Func.Locals", Field, 0},
		{"Func.Obj", Field, 0},
		{"Func.Params", Field, 0},
		{"Func.Sym", Field, 0},
		{"LineTable", Type, 0},
		{"LineTable.Data", Field, 0},
		{"LineTable.Line", Field, 0},
		{"LineTable.PC", Field, 0},
		{"NewLineTable", Func, 0},
		{"NewTable", Func, 0},
		{"Obj", Type, 0},
		{"Obj.Funcs", Field, 0},
		{"Obj.Paths", Field, 0},
		{"Sym", Type, 0},
		{"Sym.Func", Field, 0},
		{"Sym.GoType", Field, 0},
		{"Sym.Name", Field, 0},
		{"Sym.Type", Field, 0},
		{"Sym.Value", Field, 0},
		{"Table", Type, 0},
		{"Table.Files", Field, 0},
		{"Table.Funcs", Field, 0},
		{"Table.Objs", Field, 0},
		{"Table.Syms", Field, 0},
		{"UnknownFileError", Type, 0},
		{"UnknownLineError", Type, 0},
		{"UnknownLineError.File", Field, 0},
		{"UnknownLineError.Line", Field, 0},
	},
	"debug/macho": {
		{"(*FatFile).Close", Method, 3},
		{"(*File).Close", Method, 0},
		{"(*File).DWARF", Method, 0},
		{"(*File).ImportedLibraries", Method, 0},
		{"(*File).ImportedSymbols", Method, 0},
		{"(*File).Section", Method, 0},
		{"(*File).Segment", Method, 0},
		{"(*FormatError).Error", Method, 0},
		{"(*Section).Data", Method, 0},
		{"(*Section).Open", Method, 0},
		{"(*Segment).Data", Method, 0},
		{"(*Segment).Open", Method, 0},
		{"(Cpu).GoString", Method, 0},
		{"(Cpu).String", Method, 0},
		{"(Dylib).Raw", Method, 0},
		{"(Dysymtab).Raw", Method, 0},
		{"(FatArch).Close", Method, 3},
		{"(FatArch).DWARF", Method, 3},
		{"(FatArch).ImportedLibraries", Method, 3},
		{"(FatArch).ImportedSymbols", Method, 3},
		{"(FatArch).Section", Method, 3},
		{"(FatArch).Segment", Method, 3},
		{"(LoadBytes).Raw", Method, 0},
		{"(LoadCmd).GoString", Method, 0},
		{"(LoadCmd).String", Method, 0},
		{"(RelocTypeARM).GoString", Method, 10},
		{"(RelocTypeARM).String", Method, 10},
		{"(RelocTypeARM64).GoString", Method, 10},
		{"(RelocTypeARM64).String", Method, 10},
		{"(RelocTypeGeneric).GoString", Method, 10},
		{"(RelocTypeGeneric).String", Method, 10},
		{"(RelocTypeX86_64).GoString", Method, 10},
		{"(RelocTypeX86_64).String", Method, 10},
		{"(Rpath).Raw", Method, 10},
		{"(Section).ReadAt", Method, 0},
		{"(Segment).Raw", Method, 0},
		{"(Segment).ReadAt", Method, 0},
		{"(Symtab).Raw", Method, 0},
		{"(Type).GoString", Method, 10},
		{"(Type).String", Method, 10},
		{"ARM64_RELOC_ADDEND", Const, 10},
		{"ARM64_RELOC_BRANCH26", Const, 10},
		{"ARM64_RELOC_GOT_LOAD_PAGE21", Const, 10},
		{"ARM64_RELOC_GOT_LOAD_PAGEOFF12", Const, 10},
		{"ARM64_RELOC_PAGE21", Const, 10},
		{"ARM64_RELOC_PAGEOFF12", Const, 10},
		{"ARM64_RELOC_POINTER_TO_GOT", Const, 10},
		{"ARM64_RELOC_SUBTRACTOR", Const, 10},
		{"ARM64_RELOC_TLVP_LOAD_PAGE21", Const, 10},
		{"ARM64_RELOC_TLVP_LOAD_PAGEOFF12", Const, 10},
		{"ARM64_RELOC_UNSIGNED", Const, 10},
		{"ARM_RELOC_BR24", Const, 10},
		{"ARM_RELOC_HALF", Const, 10},
		{"ARM_RELOC_HALF_SECTDIFF", Const, 10},
		{"ARM_RELOC_LOCAL_SECTDIFF", Const, 10},
		{"ARM_RELOC_PAIR", Const, 10},
		{"ARM_RELOC_PB_LA_PTR", Const, 10},
		{"ARM_RELOC_SECTDIFF", Const, 10},
		{"ARM_RELOC_VANILLA", Const, 10},
		{"ARM_THUMB_32BIT_BRANCH", Const, 10},
		{"ARM_THUMB_RELOC_BR22", Const, 10},
		{"Cpu", Type, 0},
		{"Cpu386", Const, 0},
		{"CpuAmd64", Const, 0},
		{"CpuArm", Const, 3},
		{"CpuArm64", Const, 11},
		{"CpuPpc", Const, 3},
		{"CpuPpc64", Const, 3},
		{"Dylib", Type, 0},
		{"Dylib.CompatVersion", Field, 0},
		{"Dylib.CurrentVersion", Field, 0},
		{"Dylib.LoadBytes", Field, 0},
		{"Dylib.Name", Field, 0},
		{"Dylib.Time", Field, 0},
		{"DylibCmd", Type, 0},
		{"DylibCmd.Cmd", Field, 0},
		{"DylibCmd.CompatVersion", Field, 0},
		{"DylibCmd.CurrentVersion", Field, 0},
		{"DylibCmd.Len", Field, 0},
		{"DylibCmd.Name", Field, 0},
		{"DylibCmd.Time", Field, 0},
		{"Dysymtab", Type, 0},
		{"Dysymtab.DysymtabCmd", Field, 0},
		{"Dysymtab.IndirectSyms", Field, 0},
		{"Dysymtab.LoadBytes", Field, 0},
		{"DysymtabCmd", Type, 0},
		{"DysymtabCmd.Cmd", Field, 0},
		{"DysymtabCmd.Extrefsymoff", Field, 0},
		{"DysymtabCmd.Extreloff", Field, 0},
		{"DysymtabCmd.Iextdefsym", Field, 0},
		{"DysymtabCmd.Ilocalsym", Field, 0},
		{"DysymtabCmd.Indirectsymoff", Field, 0},
		{"DysymtabCmd.Iundefsym", Field, 0},
		{"DysymtabCmd.Len", Field, 0},
		{"DysymtabCmd.Locreloff", Field, 0},
		{"DysymtabCmd.Modtaboff", Field, 0},
		{"DysymtabCmd.Nextdefsym", Field, 0},
		{"DysymtabCmd.Nextrefsyms", Field, 0},
		{"DysymtabCmd.Nextrel", Field, 0},
		{"DysymtabCmd.Nindirectsyms", Field, 0},
		{"DysymtabCmd.Nlocalsym", Field, 0},
		{"DysymtabCmd.Nlocrel", Field, 0},
		{"DysymtabCmd.Nmodtab", Field, 0},
		{"DysymtabCmd.Ntoc", Field, 0},
		{"DysymtabCmd.Nundefsym", Field, 0},
		{"DysymtabCmd.Tocoffset", Field, 0},
		{"ErrNotFat", Var, 3},
		{"FatArch", Type, 3},
		{"FatArch.FatArchHeader", Field, 3},
		{"FatArch.File", Field, 3},
		{"FatArchHeader", Type, 3},
		{"FatArchHeader.Align", Field, 3},
		{"FatArchHeader.Cpu", Field, 3},
		{"FatArchHeader.Offset", Field, 3},
		{"FatArchHeader.Size", Field, 3},
		{"FatArchHeader.SubCpu", Field, 3},
		{"FatFile", Type, 3},
		{"FatFile.Arches", Field, 3},
		{"FatFile.Magic", Field, 3},
		{"File", Type, 0},
		{"File.ByteOrder", Field, 0},
		{"File.Dysymtab", Field, 0},
		{"File.FileHeader", Field, 0},
		{"File.Loads", Field, 0},
		{"File.Sections", Field, 0},
		{"File.Symtab", Field, 0},
		{"FileHeader", Type, 0},
		{"FileHeader.Cmdsz", Field, 0},
		{"FileHeader.Cpu", Field, 0},
		{"FileHeader.Flags", Field, 0},
		{"FileHeader.Magic", Field, 0},
		{"FileHeader.Ncmd", Field, 0},
		{"FileHeader.SubCpu", Field, 0},
		{"FileHeader.Type", Field, 0},
		{"FlagAllModsBound", Const, 10},
		{"FlagAllowStackExecution", Const, 10},
		{"FlagAppExtensionSafe", Const, 10},
		{"FlagBindAtLoad", Const, 10},
		{"FlagBindsToWeak", Const, 10},
		{"FlagCanonical", Const, 10},
		{"FlagDeadStrippableDylib", Const, 10},
		{"FlagDyldLink", Const, 10},
		{"FlagForceFlat", Const, 10},
		{"FlagHasTLVDescriptors", Const, 10},
		{"FlagIncrLink", Const, 10},
		{"FlagLazyInit", Const, 10},
		{"FlagNoFixPrebinding", Const, 10},
		{"FlagNoHeapExecution", Const, 10},
		{"FlagNoMultiDefs", Const, 10},
		{"FlagNoReexportedDylibs", Const, 10},
		{"FlagNoUndefs", Const, 10},
		{"FlagPIE", Const, 10},
		{"FlagPrebindable", Const, 10},
		{"FlagPrebound", Const, 10},
		{"FlagRootSafe", Const, 10},
		{"FlagSetuidSafe", Const, 10},
		{"FlagSplitSegs", Const, 10},
		{"FlagSubsectionsViaSymbols", Const, 10},
		{"FlagTwoLevel", Const, 10},
		{"FlagWeakDefines", Const, 10},
		{"FormatError", Type, 0},
		{"GENERIC_RELOC_LOCAL_SECTDIFF", Const, 10},
		{"GENERIC_RELOC_PAIR", Const, 10},
		{"GENERIC_RELOC_PB_LA_PTR", Const, 10},
		{"GENERIC_RELOC_SECTDIFF", Const, 10},
		{"GENERIC_RELOC_TLV", Const, 10},
		{"GENERIC_RELOC_VANILLA", Const, 10},
		{"Load", Type, 0},
		{"LoadBytes", Type, 0},
		{"LoadCmd", Type, 0},
		{"LoadCmdDylib", Const, 0},
		{"LoadCmdDylinker", Const, 0},
		{"LoadCmdDysymtab", Const, 0},
		{"LoadCmdRpath", Const, 10},
		{"LoadCmdSegment", Const, 0},
		{"LoadCmdSegment64", Const, 0},
		{"LoadCmdSymtab", Const, 0},
		{"LoadCmdThread", Const, 0},
		{"LoadCmdUnixThread", Const, 0},
		{"Magic32", Const, 0},
		{"Magic64", Const, 0},
		{"MagicFat", Const, 3},
		{"NewFatFile", Func, 3},
		{"NewFile", Func, 0},
		{"Nlist32", Type, 0},
		{"Nlist32.Desc", Field, 0},
		{"Nlist32.Name", Field, 0},
		{"Nlist32.Sect", Field, 0},
		{"Nlist32.Type", Field, 0},
		{"Nlist32.Value", Field, 0},
		{"Nlist64", Type, 0},
		{"Nlist64.Desc", Field, 0},
		{"Nlist64.Name", Field, 0},
		{"Nlist64.Sect", Field, 0},
		{"Nlist64.Type", Field, 0},
		{"Nlist64.Value", Field, 0},
		{"Open", Func, 0},
		{"OpenFat", Func, 3},
		{"Regs386", Type, 0},
		{"Regs386.AX", Field, 0},
		{"Regs386.BP", Field, 0},
		{"Regs386.BX", Field, 0},
		{"Regs386.CS", Field, 0},
		{"Regs386.CX", Field, 0},
		{"Regs386.DI", Field, 0},
		{"Regs386.DS", Field, 0},
		{"Regs386.DX", Field, 0},
		{"Regs386.ES", Field, 0},
		{"Regs386.FLAGS", Field, 0},
		{"Regs386.FS", Field, 0},
		{"Regs386.GS", Field, 0},
		{"Regs386.IP", Field, 0},
		{"Regs386.SI", Field, 0},
		{"Regs386.SP", Field, 0},
		{"Regs386.SS", Field, 0},
		{"RegsAMD64", Type, 0},
		{"RegsAMD64.AX", Field, 0},
		{"RegsAMD64.BP", Field, 0},
		{"RegsAMD64.BX", Field, 0},
		{"RegsAMD64.CS", Field, 0},
		{"RegsAMD64.CX", Field, 0},
		{"RegsAMD64.DI", Field, 0},
		{"RegsAMD64.DX", Field, 0},
		{"RegsAMD64.FLAGS", Field, 0},
		{"RegsAMD64.FS", Field, 0},
		{"RegsAMD64.GS", Field, 0},
		{"RegsAMD64.IP", Field, 0},
		{"RegsAMD64.R10", Field, 0},
		{"RegsAMD64.R11", Field, 0},
		{"RegsAMD64.R12", Field, 0},
		{"RegsAMD64.R13", Field, 0},
		{"RegsAMD64.R14", Field, 0},
		{"RegsAMD64.R15", Field, 0},
		{"RegsAMD64.R8", Field, 0},
		{"RegsAMD64.R9", Field, 0},
		{"RegsAMD64.SI", Field, 0},
		{"RegsAMD64.SP", Field, 0},
		{"Reloc", Type, 10},
		{"Reloc.Addr", Field, 10},
		{"Reloc.Extern", Field, 10},
		{"Reloc.Len", Field, 10},
		{"Reloc.Pcrel", Field, 10},
		{"Reloc.Scattered", Field, 10},
		{"Reloc.Type", Field, 10},
		{"Reloc.Value", Field, 10},
		{"RelocTypeARM", Type, 10},
		{"RelocTypeARM64", Type, 10},
		{"RelocTypeGeneric", Type, 10},
		{"RelocTypeX86_64", Type, 10},
		{"Rpath", Type, 10},
		{"Rpath.LoadBytes", Field, 10},
		{"Rpath.Path", Field, 10},
		{"RpathCmd", Type, 10},
		{"RpathCmd.Cmd", Field, 10},
		{"RpathCmd.Len", Field, 10},
		{"RpathCmd.Path", Field, 10},
		{"Section", Type, 0},
		{"Section.ReaderAt", Field, 0},
		{"Section.Relocs", Field, 10},
		{"Section.SectionHeader", Field, 0},
		{"Section32", Type, 0},
		{"Section32.Addr", Field, 0},
		{"Section32.Align", Field, 0},
		{"Section32.Flags", Field, 0},
		{"Section32.Name", Field, 0},
		{"Section32.Nreloc", Field, 0},
		{"Section32.Offset", Field, 0},
		{"Section32.Reloff", Field, 0},
		{"Section32.Reserve1", Field, 0},
		{"Section32.Reserve2", Field, 0},
		{"Section32.Seg", Field, 0},
		{"Section32.Size", Field, 0},
		{"Section64", Type, 0},
		{"Section64.Addr", Field, 0},
		{"Section64.Align", Field, 0},
		{"Section64.Flags", Field, 0},
		{"Section64.Name", Field, 0},
		{"Section64.Nreloc", Field, 0},
		{"Section64.Offset", Field, 0},
		{"Section64.Reloff", Field, 0},
		{"Section64.Reserve1", Field, 0},
		{"Section64.Reserve2", Field, 0},
		{"Section64.Reserve3", Field, 0},
		{"Section64.Seg", Field, 0},
		{"Section64.Size", Field, 0},
		{"SectionHeader", Type, 0},
		{"SectionHeader.Addr", Field, 0},
		{"SectionHeader.Align", Field, 0},
		{"SectionHeader.Flags", Field, 0},
		{"SectionHeader.Name", Field, 0},
		{"SectionHeader.Nreloc", Field, 0},
		{"SectionHeader.Offset", Field, 0},
		{"SectionHeader.Reloff", Field, 0},
		{"SectionHeader.Seg", Field, 0},
		{"SectionHeader.Size", Field, 0},
		{"Segment", Type, 0},
		{"Segment.LoadBytes", Field, 0},
		{"Segment.ReaderAt", Field, 0},
		{"Segment.SegmentHeader", Field, 0},
		{"Segment32", Type, 0},
		{"Segment32.Addr", Field, 0},
		{"Segment32.Cmd", Field, 0},
		{"Segment32.Filesz", Field, 0},
		{"Segment32.Flag", Field, 0},
		{"Segment32.Len", Field, 0},
		{"Segment32.Maxprot", Field, 0},
		{"Segment32.Memsz", Field, 0},
		{"Segment32.Name", Field, 0},
		{"Segment32.Nsect", Field, 0},
		{"Segment32.Offset", Field, 0},
		{"Segment32.Prot", Field, 0},
		{"Segment64", Type, 0},
		{"Segment64.Addr", Field, 0},
		{"Segment64.Cmd", Field, 0},
		{"Segment64.Filesz", Field, 0},
		{"Segment64.Flag", Field, 0},
		{"Segment64.Len", Field, 0},
		{"Segment64.Maxprot", Field, 0},
		{"Segment64.Memsz", Field, 0},
		{"Segment64.Name", Field, 0},
		{"Segment64.Nsect", Field, 0},
		{"Segment64.Offset", Field, 0},
		{"Segment64.Prot", Field, 0},
		{"SegmentHeader", Type, 0},
		{"SegmentHeader.Addr", Field, 0},
		{"SegmentHeader.Cmd", Field, 0},
		{"SegmentHeader.Filesz", Field, 0},
		{"SegmentHeader.Flag", Field, 0},
		{"SegmentHeader.Len", Field, 0},
		{"SegmentHeader.Maxprot", Field, 0},
		{"SegmentHeader.Memsz", Field, 0},
		{"SegmentHeader.Name", Field, 0},
		{"SegmentHeader.Nsect", Field, 0},
		{"SegmentHeader.Offset", Field, 0},
		{"SegmentHeader.Prot", Field, 0},
		{"Symbol", Type, 0},
		{"Symbol.Desc", Field, 0},
		{"Symbol.Name", Field, 0},
		{"Symbol.Sect", Field, 0},
		{"Symbol.Type", Field, 0},
		{"Symbol.Value", Field, 0},
		{"Symtab", Type, 0},
		{"Symtab.LoadBytes", Field, 0},
		{"Symtab.Syms", Field, 0},
		{"Symtab.SymtabCmd", Field, 0},
		{"SymtabCmd", Type, 0},
		{"SymtabCmd.Cmd", Field, 0},
		{"SymtabCmd.Len", Field, 0},
		{"SymtabCmd.Nsyms", Field, 0},
		{"SymtabCmd.Stroff", Field, 0},
		{"SymtabCmd.Strsize", Field, 0},
		{"SymtabCmd.Symoff", Field, 0},
		{"Thread", Type, 0},
		{"Thread.Cmd", Field, 0},
		{"Thread.Data", Field, 0},
		{"Thread.Len", Field, 0},
		{"Thread.Type", Field, 0},
		{"Type", Type, 0},
		{"TypeBundle", Const, 3},
		{"TypeDylib", Const, 3},
		{"TypeExec", Const, 0},
		{"TypeObj", Const, 0},
		{"X86_64_RELOC_BRANCH", Const, 10},
		{"X86_64_RELOC_GOT", Const, 10},
		{"X86_64_RELOC_GOT_LOAD", Const, 10},
		{"X86_64_RELOC_SIGNED", Const, 10},
		{"X86_64_RELOC_SIGNED_1", Const, 10},
		{"X86_64_RELOC_SIGNED_2", Const, 10},
		{"X86_64_RELOC_SIGNED_4", Const, 10},
		{"X86_64_RELOC_SUBTRACTOR", Const, 10},
		{"X86_64_RELOC_TLV", Const, 10},
		{"X86_64_RELOC_UNSIGNED", Const, 10},
	},
	"debug/pe": {
		{"(*COFFSymbol).FullName", Method, 8},
		{"(*File).COFFSymbolReadSectionDefAux", Method, 19},
		{"(*File).Close", Method, 0},
		{"(*File).DWARF", Method, 0},
		{"(*File).ImportedLibraries", Method, 0},
		{"(*File).ImportedSymbols", Method, 0},
		{"(*File).Section", Method, 0},
		{"(*FormatError).Error", Method, 0},
		{"(*Section).Data", Method, 0},
		{"(*Section).Open", Method, 0},
		{"(Section).ReadAt", Method, 0},
		{"(StringTable).String", Method, 8},
		{"COFFSymbol", Type, 1},
		{"COFFSymbol.Name", Field, 1},
		{"COFFSymbol.NumberOfAuxSymbols", Field, 1},
		{"COFFSymbol.SectionNumber", Field, 1},
		{"COFFSymbol.StorageClass", Field, 1},
		{"COFFSymbol.Type", Field, 1},
		{"COFFSymbol.Value", Field, 1},
		{"COFFSymbolAuxFormat5", Type, 19},
		{"COFFSymbolAuxFormat5.Checksum", Field, 19},
		{"COFFSymbolAuxFormat5.NumLineNumbers", Field, 19},
		{"COFFSymbolAuxFormat5.NumRelocs", Field, 19},
		{"COFFSymbolAuxFormat5.SecNum", Field, 19},
		{"COFFSymbolAuxFormat5.Selection", Field, 19},
		{"COFFSymbolAuxFormat5.Size", Field, 19},
		{"COFFSymbolSize", Const, 1},
		{"DataDirectory", Type, 3},
		{"DataDirectory.Size", Field, 3},
		{"DataDirectory.VirtualAddress", Field, 3},
		{"File", Type, 0},
		{"File.COFFSymbols", Field, 8},
		{"File.FileHeader", Field, 0},
		{"File.OptionalHeader", Field, 3},
		{"File.Sections", Field, 0},
		{"File.StringTable", Field, 8},
		{"File.Symbols", Field, 1},
		{"FileHeader", Type, 0},
		{"FileHeader.Characteristics", Field, 0},
		{"FileHeader.Machine", Field, 0},
		{"FileHeader.NumberOfSections", Field, 0},
		{"FileHeader.NumberOfSymbols", Field, 0},
		{"FileHeader.PointerToSymbolTable", Field, 0},
		{"FileHeader.SizeOfOptionalHeader", Field, 0},
		{"FileHeader.TimeDateStamp", Field, 0},
		{"FormatError", Type, 0},
		{"IMAGE_COMDAT_SELECT_ANY", Const, 19},
		{"IMAGE_COMDAT_SELECT_ASSOCIATIVE", Const, 19},
		{"IMAGE_COMDAT_SELECT_EXACT_MATCH", Const, 19},
		{"IMAGE_COMDAT_SELECT_LARGEST", Const, 19},
		{"IMAGE_COMDAT_SELECT_NODUPLICATES", Const, 19},
		{"IMAGE_COMDAT_SELECT_SAME_SIZE", Const, 19},
		{"IMAGE_DIRECTORY_ENTRY_ARCHITECTURE", Const, 11},
		{"IMAGE_DIRECTORY_ENTRY_BASERELOC", Const, 11},
		{"IMAGE_DIRECTORY_ENTRY_BOUND_IMPORT", Const, 11},
		{"IMAGE_DIRECTORY_ENTRY_COM_DESCRIPTOR", Const, 11},
		{"IMAGE_DIRECTORY_ENTRY_DEBUG", Const, 11},
		{"IMAGE_DIRECTORY_ENTRY_DELAY_IMPORT", Const, 11},
		{"IMAGE_DIRECTORY_ENTRY_EXCEPTION", Const, 11},
		{"IMAGE_DIRECTORY_ENTRY_EXPORT", Const, 11},
		{"IMAGE_DIRECTORY_ENTRY_GLOBALPTR", Const, 11},
		{"IMAGE_DIRECTORY_ENTRY_IAT", Const, 11},
		{"IMAGE_DIRECTORY_ENTRY_IMPORT", Const, 11},
		{"IMAGE_DIRECTORY_ENTRY_LOAD_CONFIG", Const, 11},
		{"IMAGE_DIRECTORY_ENTRY_RESOURCE", Const, 11},
		{"IMAGE_DIRECTORY_ENTRY_SECURITY", Const, 11},
		{"IMAGE_DIRECTORY_ENTRY_TLS", Const, 11},
		{"IMAGE_DLLCHARACTERISTICS_APPCONTAINER", Const, 15},
		{"IMAGE_DLLCHARACTERISTICS_DYNAMIC_BASE", Const, 15},
		{"IMAGE_DLLCHARACTERISTICS_FORCE_INTEGRITY", Const, 15},
		{"IMAGE_DLLCHARACTERISTICS_GUARD_CF", Const, 15},
		{"IMAGE_DLLCHARACTERISTICS_HIGH_ENTROPY_VA", Const, 15},
		{"IMAGE_DLLCHARACTERISTICS_NO_BIND", Const, 15},
		{"IMAGE_DLLCHARACTERISTICS_NO_ISOLATION", Const, 15},
		{"IMAGE_DLLCHARACTERISTICS_NO_SEH", Const, 15},
		{"IMAGE_DLLCHARACTERISTICS_NX_COMPAT", Const, 15},
		{"IMAGE_DLLCHARACTERISTICS_TERMINAL_SERVER_AWARE", Const, 15},
		{"IMAGE_DLLCHARACTERISTICS_WDM_DRIVER", Const, 15},
		{"IMAGE_FILE_32BIT_MACHINE", Const, 15},
		{"IMAGE_FILE_AGGRESIVE_WS_TRIM", Const, 15},
		{"IMAGE_FILE_BYTES_REVERSED_HI", Const, 15},
		{"IMAGE_FILE_BYTES_REVERSED_LO", Const, 15},
		{"IMAGE_FILE_DEBUG_STRIPPED", Const, 15},
		{"IMAGE_FILE_DLL", Const, 15},
		{"IMAGE_FILE_EXECUTABLE_IMAGE", Const, 15},
		{"IMAGE_FILE_LARGE_ADDRESS_AWARE", Const, 15},
		{"IMAGE_FILE_LINE_NUMS_STRIPPED", Const, 15},
		{"IMAGE_FILE_LOCAL_SYMS_STRIPPED", Const, 15},
		{"IMAGE_FILE_MACHINE_AM33", Const, 0},
		{"IMAGE_FILE_MACHINE_AMD64", Const, 0},
		{"IMAGE_FILE_MACHINE_ARM", Const, 0},
		{"IMAGE_FILE_MACHINE_ARM64", Const, 11},
		{"IMAGE_FILE_MACHINE_ARMNT", Const, 12},
		{"IMAGE_FILE_MACHINE_EBC", Const, 0},
		{"IMAGE_FILE_MACHINE_I386", Const, 0},
		{"IMAGE_FILE_MACHINE_IA64", Const, 0},
		{"IMAGE_FILE_MACHINE_LOONGARCH32", Const, 19},
		{"IMAGE_FILE_MACHINE_LOONGARCH64", Const, 19},
		{"IMAGE_FILE_MACHINE_M32R", Const, 0},
		{"IMAGE_FILE_MACHINE_MIPS16", Const, 0},
		{"IMAGE_FILE_MACHINE_MIPSFPU", Const, 0},
		{"IMAGE_FILE_MACHINE_MIPSFPU16", Const, 0},
		{"IMAGE_FILE_MACHINE_POWERPC", Const, 0},
		{"IMAGE_FILE_MACHINE_POWERPCFP", Const, 0},
		{"IMAGE_FILE_MACHINE_R4000", Const, 0},
		{"IMAGE_FILE_MACHINE_RISCV128", Const, 20},
		{"IMAGE_FILE_MACHINE_RISCV32", Const, 20},
		{"IMAGE_FILE_MACHINE_RISCV64", Const, 20},
		{"IMAGE_FILE_MACHINE_SH3", Const, 0},
		{"IMAGE_FILE_MACHINE_SH3DSP", Const, 0},
		{"IMAGE_FILE_MACHINE_SH4", Const, 0},
		{"IMAGE_FILE_MACHINE_SH5", Const, 0},
		{"IMAGE_FILE_MACHINE_THUMB", Const, 0},
		{"IMAGE_FILE_MACHINE_UNKNOWN", Const, 0},
		{"IMAGE_FILE_MACHINE_WCEMIPSV2", Const, 0},
		{"IMAGE_FILE_NET_RUN_FROM_SWAP", Const, 15},
		{"IMAGE_FILE_RELOCS_STRIPPED", Const, 15},
		{"IMAGE_FILE_REMOVABLE_RUN_FROM_SWAP", Const, 15},
		{"IMAGE_FILE_SYSTEM", Const, 15},
		{"IMAGE_FILE_UP_SYSTEM_ONLY", Const, 15},
		{"IMAGE_SCN_CNT_CODE", Const, 19},
		{"IMAGE_SCN_CNT_INITIALIZED_DATA", Const, 19},
		{"IMAGE_SCN_CNT_UNINITIALIZED_DATA", Const, 19},
		{"IMAGE_SCN_LNK_COMDAT", Const, 19},
		{"IMAGE_SCN_MEM_DISCARDABLE", Const, 19},
		{"IMAGE_SCN_MEM_EXECUTE", Const, 19},
		{"IMAGE_SCN_MEM_READ", Const, 19},
		{"IMAGE_SCN_MEM_WRITE", Const, 19},
		{"IMAGE_SUBSYSTEM_EFI_APPLICATION", Const, 15},
		{"IMAGE_SUBSYSTEM_EFI_BOOT_SERVICE_DRIVER", Const, 15},
		{"IMAGE_SUBSYSTEM_EFI_ROM", Const, 15},
		{"IMAGE_SUBSYSTEM_EFI_RUNTIME_DRIVER", Const, 15},
		{"IMAGE_SUBSYSTEM_NATIVE", Const, 15},
		{"IMAGE_SUBSYSTEM_NATIVE_WINDOWS", Const, 15},
		{"IMAGE_SUBSYSTEM_OS2_CUI", Const, 15},
		{"IMAGE_SUBSYSTEM_POSIX_CUI", Const, 15},
		{"IMAGE_SUBSYSTEM_UNKNOWN", Const, 15},
		{"IMAGE_SUBSYSTEM_WINDOWS_BOOT_APPLICATION", Const, 15},
		{"IMAGE_SUBSYSTEM_WINDOWS_CE_GUI", Const, 15},
		{"IMAGE_SUBSYSTEM_WINDOWS_CUI", Const, 15},
		{"IMAGE_SUBSYSTEM_WINDOWS_GUI", Const, 15},
		{"IMAGE_SUBSYSTEM_XBOX", Const, 15},
		{"ImportDirectory", Type, 0},
		{"ImportDirectory.FirstThunk", Field, 0},
		{"ImportDirectory.ForwarderChain", Field, 0},
		{"ImportDirectory.Name", Field, 0},
		{"ImportDirectory.OriginalFirstThunk", Field, 0},
		{"ImportDirectory.TimeDateStamp", Field, 0},
		{"NewFile", Func, 0},
		{"Open", Func, 0},
		{"OptionalHeader32", Type, 3},
		{"OptionalHeader32.AddressOfEntryPoint", Field, 3},
		{"OptionalHeader32.BaseOfCode", Field, 3},
		{"OptionalHeader32.BaseOfData", Field, 3},
		{"OptionalHeader32.CheckSum", Field, 3},
		{"OptionalHeader32.DataDirectory", Field, 3},
		{"OptionalHeader32.DllCharacteristics", Field, 3},
		{"OptionalHeader32.FileAlignment", Field, 3},
		{"OptionalHeader32.ImageBase", Field, 3},
		{"OptionalHeader32.LoaderFlags", Field, 3},
		{"OptionalHeader32.Magic", Field, 3},
		{"OptionalHeader32.MajorImageVersion", Field, 3},
		{"OptionalHeader32.MajorLinkerVersion", Field, 3},
		{"OptionalHeader32.MajorOperatingSystemVersion", Field, 3},
		{"OptionalHeader32.MajorSubsystemVersion", Field, 3},
		{"OptionalHeader32.MinorImageVersion", Field, 3},
		{"OptionalHeader32.MinorLinkerVersion", Field, 3},
		{"OptionalHeader32.MinorOperatingSystemVersion", Field, 3},
		{"OptionalHeader32.MinorSubsystemVersion", Field, 3},
		{"OptionalHeader32.NumberOfRvaAndSizes", Field, 3},
		{"OptionalHeader32.SectionAlignment", Field, 3},
		{"OptionalHeader32.SizeOfCode", Field, 3},
		{"OptionalHeader32.SizeOfHeaders", Field, 3},
		{"OptionalHeader32.SizeOfHeapCommit", Field, 3},
		{"OptionalHeader32.SizeOfHeapReserve", Field, 3},
		{"OptionalHeader32.SizeOfImage", Field, 3},
		{"OptionalHeader32.SizeOfInitializedData", Field, 3},
		{"OptionalHeader32.SizeOfStackCommit", Field, 3},
		{"OptionalHeader32.SizeOfStackReserve", Field, 3},
		{"OptionalHeader32.SizeOfUninitializedData", Field, 3},
		{"OptionalHeader32.Subsystem", Field, 3},
		{"OptionalHeader32.Win32VersionValue", Field, 3},
		{"OptionalHeader64", Type, 3},
		{"OptionalHeader64.AddressOfEntryPoint", Field, 3},
		{"OptionalHeader64.BaseOfCode", Field, 3},
		{"OptionalHeader64.CheckSum", Field, 3},
		{"OptionalHeader64.DataDirectory", Field, 3},
		{"OptionalHeader64.DllCharacteristics", Field, 3},
		{"OptionalHeader64.FileAlignment", Field, 3},
		{"OptionalHeader64.ImageBase", Field, 3},
		{"OptionalHeader64.LoaderFlags", Field, 3},
		{"OptionalHeader64.Magic", Field, 3},
		{"OptionalHeader64.MajorImageVersion", Field, 3},
		{"OptionalHeader64.MajorLinkerVersion", Field, 3},
		{"OptionalHeader64.MajorOperatingSystemVersion", Field, 3},
		{"OptionalHeader64.MajorSubsystemVersion", Field, 3},
		{"OptionalHeader64.MinorImageVersion", Field, 3},
		{"OptionalHeader64.MinorLinkerVersion", Field, 3},
		{"OptionalHeader64.MinorOperatingSystemVersion", Field, 3},
		{"OptionalHeader64.MinorSubsystemVersion", Field, 3},
		{"OptionalHeader64.NumberOfRvaAndSizes", Field, 3},
		{"OptionalHeader64.SectionAlignment", Field, 3},
		{"OptionalHeader64.SizeOfCode", Field, 3},
		{"OptionalHeader64.SizeOfHeaders", Field, 3},
		{"OptionalHeader64.SizeOfHeapCommit", Field, 3},
		{"OptionalHeader64.SizeOfHeapReserve", Field, 3},
		{"OptionalHeader64.SizeOfImage", Field, 3},
		{"OptionalHeader64.SizeOfInitializedData", Field, 3},
		{"OptionalHeader64.SizeOfStackCommit", Field, 3},
		{"OptionalHeader64.SizeOfStackReserve", Field, 3},
		{"OptionalHeader64.SizeOfUninitializedData", Field, 3},
		{"OptionalHeader64.Subsystem", Field, 3},
		{"OptionalHeader64.Win32VersionValue", Field, 3},
		{"Reloc", Type, 8},
		{"Reloc.SymbolTableIndex", Field, 8},
		{"Reloc.Type", Field, 8},
		{"Reloc.VirtualAddress", Field, 8},
		{"Section", Type, 0},
		{"Section.ReaderAt", Field, 0},
		{"Section.Relocs", Field, 8},
		{"Section.SectionHeader", Field, 0},
		{"SectionHeader", Type, 0},
		{"SectionHeader.Characteristics", Field, 0},
		{"SectionHeader.Name", Field, 0},
		{"SectionHeader.NumberOfLineNumbers", Field, 0},
		{"SectionHeader.NumberOfRelocations", Field, 0},
		{"SectionHeader.Offset", Field, 0},
		{"SectionHeader.PointerToLineNumbers", Field, 0},
		{"SectionHeader.PointerToRelocations", Field, 0},
		{"SectionHeader.Size", Field, 0},
		{"SectionHeader.VirtualAddress", Field, 0},
		{"SectionHeader.VirtualSize", Field, 0},
		{"SectionHeader32", Type, 0},
		{"SectionHeader32.Characteristics", Field, 0},
		{"SectionHeader32.Name", Field, 0},
		{"SectionHeader32.NumberOfLineNumbers", Field, 0},
		{"SectionHeader32.NumberOfRelocations", Field, 0},
		{"SectionHeader32.PointerToLineNumbers", Field, 0},
		{"SectionHeader32.PointerToRawData", Field, 0},
		{"SectionHeader32.PointerToRelocations", Field, 0},
		{"SectionHeader32.SizeOfRawData", Field, 0},
		{"SectionHeader32.VirtualAddress", Field, 0},
		{"SectionHeader32.VirtualSize", Field, 0},
		{"StringTable", Type, 8},
		{"Symbol", Type, 1},
		{"Symbol.Name", Field, 1},
		{"Symbol.SectionNumber", Field, 1},
		{"Symbol.StorageClass", Field, 1},
		{"Symbol.Type", Field, 1},
		{"Symbol.Value", Field, 1},
	},
	"debug/plan9obj": {
		{"(*File).Close", Method, 3},
		{"(*File).Section", Method, 3},
		{"(*File).Symbols", Method, 3},
		{"(*Section).Data", Method, 3},
		{"(*Section).Open", Method, 3},
		{"(Section).ReadAt", Method, 3},
		{"ErrNoSymbols", Var, 18},
		{"File", Type, 3},
		{"File.FileHeader", Field, 3},
		{"File.Sections", Field, 3},
		{"FileHeader", Type, 3},
		{"FileHeader.Bss", Field, 3},
		{"FileHeader.Entry", Field, 3},
		{"FileHeader.HdrSize", Field, 4},
		{"FileHeader.LoadAddress", Field, 4},
		{"FileHeader.Magic", Field, 3},
		{"FileHeader.PtrSize", Field, 3},
		{"Magic386", Const, 3},
		{"Magic64", Const, 3},
		{"MagicAMD64", Const, 3},
		{"MagicARM", Const, 3},
		{"NewFile", Func, 3},
		{"Open", Func, 3},
		{"Section", Type, 3},
		{"Section.ReaderAt", Field, 3},
		{"Section.SectionHeader", Field, 3},
		{"SectionHeader", Type, 3},
		{"SectionHeader.Name", Field, 3},
		{"SectionHeader.Offset", Field, 3},
		{"SectionHeader.Size", Field, 3},
		{"Sym", Type, 3},
		{"Sym.Name", Field, 3},
		{"Sym.Type", Field, 3},
		{"Sym.Value", Field, 3},
	},
	"embed": {
		{"(FS).Open", Method, 16},
		{"(FS).ReadDir", Method, 16},
		{"(FS).ReadFile", Method, 16},
		{"FS", Type, 16},
	},
	"encoding": {
		{"BinaryAppender", Type, 24},
		{"BinaryMarshaler", Type, 2},
		{"BinaryUnmarshaler", Type, 2},
		{"TextAppender", Type, 24},
		{"TextMarshaler", Type, 2},
		{"TextUnmarshaler", Type, 2},
	},
	"encoding/ascii85": {
		{"(CorruptInputError).Error", Method, 0},
		{"CorruptInputError", Type, 0},
		{"Decode", Func, 0},
		{"Encode", Func, 0},
		{"MaxEncodedLen", Func, 0},
		{"NewDecoder", Func, 0},
		{"NewEncoder", Func, 0},
	},
	"encoding/asn1": {
		{"(BitString).At", Method, 0},
		{"(BitString).RightAlign", Method, 0},
		{"(ObjectIdentifier).Equal", Method, 0},
		{"(ObjectIdentifier).String", Method, 3},
		{"(StructuralError).Error", Method, 0},
		{"(SyntaxError).Error", Method, 0},
		{"BitString", Type, 0},
		{"BitString.BitLength", Field, 0},
		{"BitString.Bytes", Field, 0},
		{"ClassApplication", Const, 6},
		{"ClassContextSpecific", Const, 6},
		{"ClassPrivate", Const, 6},
		{"ClassUniversal", Const, 6},
		{"Enumerated", Type, 0},
		{"Flag", Type, 0},
		{"Marshal", Func, 0},
		{"MarshalWithParams", Func, 10},
		{"NullBytes", Var, 9},
		{"NullRawValue", Var, 9},
		{"ObjectIdentifier", Type, 0},
		{"RawContent", Type, 0},
		{"RawValue", Type, 0},
		{"RawValue.Bytes", Field, 0},
		{"RawValue.Class", Field, 0},
		{"RawValue.FullBytes", Field, 0},
		{"RawValue.IsCompound", Field, 0},
		{"RawValue.Tag", Field, 0},
		{"StructuralError", Type, 0},
		{"StructuralError.Msg", Field, 0},
		{"SyntaxError", Type, 0},
		{"SyntaxError.Msg", Field, 0},
		{"TagBMPString", Const, 14},
		{"TagBitString", Const, 6},
		{"TagBoolean", Const, 6},
		{"TagEnum", Const, 6},
		{"TagGeneralString", Const, 6},
		{"TagGeneralizedTime", Const, 6},
		{"TagIA5String", Const, 6},
		{"TagInteger", Const, 6},
		{"TagNull", Const, 9},
		{"TagNumericString", Const, 10},
		{"TagOID", Const, 6},
		{"TagOctetString", Const, 6},
		{"TagPrintableString", Const, 6},
		{"TagSequence", Const, 6},
		{"TagSet", Const, 6},
		{"TagT61String", Const, 6},
		{"TagUTCTime", Const, 6},
		{"TagUTF8String", Const, 6},
		{"Unmarshal", Func, 0},
		{"UnmarshalWithParams", Func, 0},
	},
	"encoding/base32": {
		{"(*Encoding).AppendDecode", Method, 22},
		{"(*Encoding).AppendEncode", Method, 22},
		{"(*Encoding).Decode", Method, 0},
		{"(*Encoding).DecodeString", Method, 0},
		{"(*Encoding).DecodedLen", Method, 0},
		{"(*Encoding).Encode", Method, 0},
		{"(*Encoding).EncodeToString", Method, 0},
		{"(*Encoding).EncodedLen", Method, 0},
		{"(CorruptInputError).Error", Method, 0},
		{"(Encoding).WithPadding", Method, 9},
		{"CorruptInputError", Type, 0},
		{"Encoding", Type, 0},
		{"HexEncoding", Var, 0},
		{"NewDecoder", Func, 0},
		{"NewEncoder", Func, 0},
		{"NewEncoding", Func, 0},
		{"NoPadding", Const, 9},
		{"StdEncoding", Var, 0},
		{"StdPadding", Const, 9},
	},
	"encoding/base64": {
		{"(*Encoding).AppendDecode", Method, 22},
		{"(*Encoding).AppendEncode", Method, 22},
		{"(*Encoding).Decode", Method, 0},
		{"(*Encoding).DecodeString", Method, 0},
		{"(*Encoding).DecodedLen", Method, 0},
		{"(*Encoding).Encode", Method, 0},
		{"(*Encoding).EncodeToString", Method, 0},
		{"(*Encoding).EncodedLen", Method, 0},
		{"(CorruptInputError).Error", Method, 0},
		{"(Encoding).Strict", Method, 8},
		{"(Encoding).WithPadding", Method, 5},
		{"CorruptInputError", Type, 0},
		{"Encoding", Type, 0},
		{"NewDecoder", Func, 0},
		{"NewEncoder", Func, 0},
		{"NewEncoding", Func, 0},
		{"NoPadding", Const, 5},
		{"RawStdEncoding", Var, 5},
		{"RawURLEncoding", Var, 5},
		{"StdEncoding", Var, 0},
		{"StdPadding", Const, 5},
		{"URLEncoding", Var, 0},
	},
	"encoding/binary": {
		{"Append", Func, 23},
		{"AppendByteOrder", Type, 19},
		{"AppendUvarint", Func, 19},
		{"AppendVarint", Func, 19},
		{"BigEndian", Var, 0},
		{"ByteOrder", Type, 0},
		{"Decode", Func, 23},
		{"Encode", Func, 23},
		{"LittleEndian", Var, 0},
		{"MaxVarintLen16", Const, 0},
		{"MaxVarintLen32", Const, 0},
		{"MaxVarintLen64", Const, 0},
		{"NativeEndian", Var, 21},
		{"PutUvarint", Func, 0},
		{"PutVarint", Func, 0},
		{"Read", Func, 0},
		{"ReadUvarint", Func, 0},
		{"ReadVarint", Func, 0},
		{"Size", Func, 0},
		{"Uvarint", Func, 0},
		{"Varint", Func, 0},
		{"Write", Func, 0},
	},
	"encoding/csv": {
		{"(*ParseError).Error", Method, 0},
		{"(*ParseError).Unwrap", Method, 13},
		{"(*Reader).FieldPos", Method, 17},
		{"(*Reader).InputOffset", Method, 19},
		{"(*Reader).Read", Method, 0},
		{"(*Reader).ReadAll", Method, 0},
		{"(*Writer).Error", Method, 1},
		{"(*Writer).Flush", Method, 0},
		{"(*Writer).Write", Method, 0},
		{"(*Writer).WriteAll", Method, 0},
		{"ErrBareQuote", Var, 0},
		{"ErrFieldCount", Var, 0},
		{"ErrQuote", Var, 0},
		{"ErrTrailingComma", Var, 0},
		{"NewReader", Func, 0},
		{"NewWriter", Func, 0},
		{"ParseError", Type, 0},
		{"ParseError.Column", Field, 0},
		{"ParseError.Err", Field, 0},
		{"ParseError.Line", Field, 0},
		{"ParseError.StartLine", Field, 10},
		{"Reader", Type, 0},
		{"Reader.Comma", Field, 0},
		{"Reader.Comment", Field, 0},
		{"Reader.FieldsPerRecord", Field, 0},
		{"Reader.LazyQuotes", Field, 0},
		{"Reader.ReuseRecord", Field, 9},
		{"Reader.TrailingComma", Field, 0},
		{"Reader.TrimLeadingSpace", Field, 0},
		{"Writer", Type, 0},
		{"Writer.Comma", Field, 0},
		{"Writer.UseCRLF", Field, 0},
	},
	"encoding/gob": {
		{"(*Decoder).Decode", Method, 0},
		{"(*Decoder).DecodeValue", Method, 0},
		{"(*Encoder).Encode", Method, 0},
		{"(*Encoder).EncodeValue", Method, 0},
		{"CommonType", Type, 0},
		{"CommonType.Id", Field, 0},
		{"CommonType.Name", Field, 0},
		{"Decoder", Type, 0},
		{"Encoder", Type, 0},
		{"GobDecoder", Type, 0},
		{"GobEncoder", Type, 0},
		{"NewDecoder", Func, 0},
		{"NewEncoder", Func, 0},
		{"Register", Func, 0},
		{"RegisterName", Func, 0},
	},
	"encoding/hex": {
		{"(InvalidByteError).Error", Method, 0},
		{"AppendDecode", Func, 22},
		{"AppendEncode", Func, 22},
		{"Decode", Func, 0},
		{"DecodeString", Func, 0},
		{"DecodedLen", Func, 0},
		{"Dump", Func, 0},
		{"Dumper", Func, 0},
		{"Encode", Func, 0},
		{"EncodeToString", Func, 0},
		{"EncodedLen", Func, 0},
		{"ErrLength", Var, 0},
		{"InvalidByteError", Type, 0},
		{"NewDecoder", Func, 10},
		{"NewEncoder", Func, 10},
	},
	"encoding/json": {
		{"(*Decoder).Buffered", Method, 1},
		{"(*Decoder).Decode", Method, 0},
		{"(*Decoder).DisallowUnknownFields", Method, 10},
		{"(*Decoder).InputOffset", Method, 14},
		{"(*Decoder).More", Method, 5},
		{"(*Decoder).Token", Method, 5},
		{"(*Decoder).UseNumber", Method, 1},
		{"(*Encoder).Encode", Method, 0},
		{"(*Encoder).SetEscapeHTML", Method, 7},
		{"(*Encoder).SetIndent", Method, 7},
		{"(*InvalidUTF8Error).Error", Method, 0},
		{"(*InvalidUnmarshalError).Error", Method, 0},
		{"(*MarshalerError).Error", Method, 0},
		{"(*MarshalerError).Unwrap", Method, 13},
		{"(*RawMessage).MarshalJSON", Method, 0},
		{"(*RawMessage).UnmarshalJSON", Method, 0},
		{"(*SyntaxError).Error", Method, 0},
		{"(*UnmarshalFieldError).Error", Method, 0},
		{"(*UnmarshalTypeError).Error", Method, 0},
		{"(*UnsupportedTypeError).Error", Method, 0},
		{"(*UnsupportedValueError).Error", Method, 0},
		{"(Delim).String", Method, 5},
		{"(Number).Float64", Method, 1},
		{"(Number).Int64", Method, 1},
		{"(Number).String", Method, 1},
		{"(RawMessage).MarshalJSON", Method, 8},
		{"Compact", Func, 0},
		{"Decoder", Type, 0},
		{"Delim", Type, 5},
		{"Encoder", Type, 0},
		{"HTMLEscape", Func, 0},
		{"Indent", Func, 0},
		{"InvalidUTF8Error", Type, 0},
		{"InvalidUTF8Error.S", Field, 0},
		{"InvalidUnmarshalError", Type, 0},
		{"InvalidUnmarshalError.Type", Field, 0},
		{"Marshal", Func, 0},
		{"MarshalIndent", Func, 0},
		{"Marshaler", Type, 0},
		{"MarshalerError", Type, 0},
		{"MarshalerError.Err", Field, 0},
		{"MarshalerError.Type", Field, 0},
		{"NewDecoder", Func, 0},
		{"NewEncoder", Func, 0},
		{"Number", Type, 1},
		{"RawMessage", Type, 0},
		{"SyntaxError", Type, 0},
		{"SyntaxError.Offset", Field, 0},
		{"Token", Type, 5},
		{"Unmarshal", Func, 0},
		{"UnmarshalFieldError", Type, 0},
		{"UnmarshalFieldError.Field", Field, 0},
		{"UnmarshalFieldError.Key", Field, 0},
		{"UnmarshalFieldError.Type", Field, 0},
		{"UnmarshalTypeError", Type, 0},
		{"UnmarshalTypeError.Field", Field, 8},
		{"UnmarshalTypeError.Offset", Field, 5},
		{"UnmarshalTypeError.Struct", Field, 8},
		{"UnmarshalTypeError.Type", Field, 0},
		{"UnmarshalTypeError.Value", Field, 0},
		{"Unmarshaler", Type, 0},
		{"UnsupportedTypeError", Type, 0},
		{"UnsupportedTypeError.Type", Field, 0},
		{"UnsupportedValueError", Type, 0},
		{"UnsupportedValueError.Str", Field, 0},
		{"UnsupportedValueError.Value", Field, 0},
		{"Valid", Func, 9},
	},
	"encoding/pem": {
		{"Block", Type, 0},
		{"Block.Bytes", Field, 0},
		{"Block.Headers", Field, 0},
		{"Block.Type", Field, 0},
		{"Decode", Func, 0},
		{"Encode", Func, 0},
		{"EncodeToMemory", Func, 0},
	},
	"encoding/xml": {
		{"(*Decoder).Decode", Method, 0},
		{"(*Decoder).DecodeElement", Method, 0},
		{"(*Decoder).InputOffset", Method, 4},
		{"(*Decoder).InputPos", Method, 19},
		{"(*Decoder).RawToken", Method, 0},
		{"(*Decoder).Skip", Method, 0},
		{"(*Decoder).Token", Method, 0},
		{"(*Encoder).Close", Method, 20},
		{"(*Encoder).Encode", Method, 0},
		{"(*Encoder).EncodeElement", Method, 2},
		{"(*Encoder).EncodeToken", Method, 2},
		{"(*Encoder).Flush", Method, 2},
		{"(*Encoder).Indent", Method, 1},
		{"(*SyntaxError).Error", Method, 0},
		{"(*TagPathError).Error", Method, 0},
		{"(*UnsupportedTypeError).Error", Method, 0},
		{"(CharData).Copy", Method, 0},
		{"(Comment).Copy", Method, 0},
		{"(Directive).Copy", Method, 0},
		{"(ProcInst).Copy", Method, 0},
		{"(StartElement).Copy", Method, 0},
		{"(StartElement).End", Method, 2},
		{"(UnmarshalError).Error", Method, 0},
		{"Attr", Type, 0},
		{"Attr.Name", Field, 0},
		{"Attr.Value", Field, 0},
		{"CharData", Type, 0},
		{"Comment", Type, 0},
		{"CopyToken", Func, 0},
		{"Decoder", Type, 0},
		{"Decoder.AutoClose", Field, 0},
		{"Decoder.CharsetReader", Field, 0},
		{"Decoder.DefaultSpace", Field, 1},
		{"Decoder.Entity", Field, 0},
		{"Decoder.Strict", Field, 0},
		{"Directive", Type, 0},
		{"Encoder", Type, 0},
		{"EndElement", Type, 0},
		{"EndElement.Name", Field, 0},
		{"Escape", Func, 0},
		{"EscapeText", Func, 1},
		{"HTMLAutoClose", Var, 0},
		{"HTMLEntity", Var, 0},
		{"Header", Const, 0},
		{"Marshal", Func, 0},
		{"MarshalIndent", Func, 0},
		{"Marshaler", Type, 2},
		{"MarshalerAttr", Type, 2},
		{"Name", Type, 0},
		{"Name.Local", Field, 0},
		{"Name.Space", Field, 0},
		{"NewDecoder", Func, 0},
		{"NewEncoder", Func, 0},
		{"NewTokenDecoder", Func, 10},
		{"ProcInst", Type, 0},
		{"ProcInst.Inst", Field, 0},
		{"ProcInst.Target", Field, 0},
		{"StartElement", Type, 0},
		{"StartElement.Attr", Field, 0},
		{"StartElement.Name", Field, 0},
		{"SyntaxError", Type, 0},
		{"SyntaxError.Line", Field, 0},
		{"SyntaxError.Msg", Field, 0},
		{"TagPathError", Type, 0},
		{"TagPathError.Field1", Field, 0},
		{"TagPathError.Field2", Field, 0},
		{"TagPathError.Struct", Field, 0},
		{"TagPathError.Tag1", Field, 0},
		{"TagPathError.Tag2", Field, 0},
		{"Token", Type, 0},
		{"TokenReader", Type, 10},
		{"Unmarshal", Func, 0},
		{"UnmarshalError", Type, 0},
		{"Unmarshaler", Type, 2},
		{"UnmarshalerAttr", Type, 2},
		{"UnsupportedTypeError", Type, 0},
		{"UnsupportedTypeError.Type", Field, 0},
	},
	"errors": {
		{"As", Func, 13},
		{"ErrUnsupported", Var, 21},
		{"Is", Func, 13},
		{"Join", Func, 20},
		{"New", Func, 0},
		{"Unwrap", Func, 13},
	},
	"expvar": {
		{"(*Float).Add", Method, 0},
		{"(*Float).Set", Method, 0},
		{"(*Float).String", Method, 0},
		{"(*Float).Value", Method, 8},
		{"(*Int).Add", Method, 0},
		{"(*Int).Set", Method, 0},
		{"(*Int).String", Method, 0},
		{"(*Int).Value", Method, 8},
		{"(*Map).Add", Method, 0},
		{"(*Map).AddFloat", Method, 0},
		{"(*Map).Delete", Method, 12},
		{"(*Map).Do", Method, 0},
		{"(*Map).Get", Method, 0},
		{"(*Map).Init", Method, 0},
		{"(*Map).Set", Method, 0},
		{"(*Map).String", Method, 0},
		{"(*String).Set", Method, 0},
		{"(*String).String", Method, 0},
		{"(*String).Value", Method, 8},
		{"(Func).String", Method, 0},
		{"(Func).Value", Method, 8},
		{"Do", Func, 0},
		{"Float", Type, 0},
		{"Func", Type, 0},
		{"Get", Func, 0},
		{"Handler", Func, 8},
		{"Int", Type, 0},
		{"KeyValue", Type, 0},
		{"KeyValue.Key", Field, 0},
		{"KeyValue.Value", Field, 0},
		{"Map", Type, 0},
		{"NewFloat", Func, 0},
		{"NewInt", Func, 0},
		{"NewMap", Func, 0},
		{"NewString", Func, 0},
		{"Publish", Func, 0},
		{"String", Type, 0},
		{"Var", Type, 0},
	},
	"flag": {
		{"(*FlagSet).Arg", Method, 0},
		{"(*FlagSet).Args", Method, 0},
		{"(*FlagSet).Bool", Method, 0},
		{"(*FlagSet).BoolFunc", Method, 21},
		{"(*FlagSet).BoolVar", Method, 0},
		{"(*FlagSet).Duration", Method, 0},
		{"(*FlagSet).DurationVar", Method, 0},
		{"(*FlagSet).ErrorHandling", Method, 10},
		{"(*FlagSet).Float64", Method, 0},
		{"(*FlagSet).Float64Var", Method, 0},
		{"(*FlagSet).Func", Method, 16},
		{"(*FlagSet).Init", Method, 0},
		{"(*FlagSet).Int", Method, 0},
		{"(*FlagSet).Int64", Method, 0},
		{"(*FlagSet).Int64Var", Method, 0},
		{"(*FlagSet).IntVar", Method, 0},
		{"(*FlagSet).Lookup", Method, 0},
		{"(*FlagSet).NArg", Method, 0},
		{"(*FlagSet).NFlag", Method, 0},
		{"(*FlagSet).Name", Method, 10},
		{"(*FlagSet).Output", Method, 10},
		{"(*FlagSet).Parse", Method, 0},
		{"(*FlagSet).Parsed", Method, 0},
		{"(*FlagSet).PrintDefaults", Method, 0},
		{"(*FlagSet).Set", Method, 0},
		{"(*FlagSet).SetOutput", Method, 0},
		{"(*FlagSet).String", Method, 0},
		{"(*FlagSet).StringVar", Method, 0},
		{"(*FlagSet).TextVar", Method, 19},
		{"(*FlagSet).Uint", Method, 0},
		{"(*FlagSet).Uint64", Method, 0},
		{"(*FlagSet).Uint64Var", Method, 0},
		{"(*FlagSet).UintVar", Method, 0},
		{"(*FlagSet).Var", Method, 0},
		{"(*FlagSet).Visit", Method, 0},
		{"(*FlagSet).VisitAll", Method, 0},
		{"Arg", Func, 0},
		{"Args", Func, 0},
		{"Bool", Func, 0},
		{"BoolFunc", Func, 21},
		{"BoolVar", Func, 0},
		{"CommandLine", Var, 2},
		{"ContinueOnError", Const, 0},
		{"Duration", Func, 0},
		{"DurationVar", Func, 0},
		{"ErrHelp", Var, 0},
		{"ErrorHandling", Type, 0},
		{"ExitOnError", Const, 0},
		{"Flag", Type, 0},
		{"Flag.DefValue", Field, 0},
		{"Flag.Name", Field, 0},
		{"Flag.Usage", Field, 0},
		{"Flag.Value", Field, 0},
		{"FlagSet", Type, 0},
		{"FlagSet.Usage", Field, 0},
		{"Float64", Func, 0},
		{"Float64Var", Func, 0},
		{"Func", Func, 16},
		{"Getter", Type, 2},
		{"Int", Func, 0},
		{"Int64", Func, 0},
		{"Int64Var", Func, 0},
		{"IntVar", Func, 0},
		{"Lookup", Func, 0},
		{"NArg", Func, 0},
		{"NFlag", Func, 0},
		{"NewFlagSet", Func, 0},
		{"PanicOnError", Const, 0},
		{"Parse", Func, 0},
		{"Parsed", Func, 0},
		{"PrintDefaults", Func, 0},
		{"Set", Func, 0},
		{"String", Func, 0},
		{"StringVar", Func, 0},
		{"TextVar", Func, 19},
		{"Uint", Func, 0},
		{"Uint64", Func, 0},
		{"Uint64Var", Func, 0},
		{"UintVar", Func, 0},
		{"UnquoteUsage", Func, 5},
		{"Usage", Var, 0},
		{"Value", Type, 0},
		{"Var", Func, 0},
		{"Visit", Func, 0},
		{"VisitAll", Func, 0},
	},
	"fmt": {
		{"Append", Func, 19},
		{"Appendf", Func, 19},
		{"Appendln", Func, 19},
		{"Errorf", Func, 0},
		{"FormatString", Func, 20},
		{"Formatter", Type, 0},
		{"Fprint", Func, 0},
		{"Fprintf", Func, 0},
		{"Fprintln", Func, 0},
		{"Fscan", Func, 0},
		{"Fscanf", Func, 0},
		{"Fscanln", Func, 0},
		{"GoStringer", Type, 0},
		{"Print", Func, 0},
		{"Printf", Func, 0},
		{"Println", Func, 0},
		{"Scan", Func, 0},
		{"ScanState", Type, 0},
		{"Scanf", Func, 0},
		{"Scanln", Func, 0},
		{"Scanner", Type, 0},
		{"Sprint", Func, 0},
		{"Sprintf", Func, 0},
		{"Sprintln", Func, 0},
		{"Sscan", Func, 0},
		{"Sscanf", Func, 0},
		{"Sscanln", Func, 0},
		{"State", Type, 0},
		{"Stringer", Type, 0},
	},
	"go/ast": {
		{"(*ArrayType).End", Method, 0},
		{"(*ArrayType).Pos", Method, 0},
		{"(*AssignStmt).End", Method, 0},
		{"(*AssignStmt).Pos", Method, 0},
		{"(*BadDecl).End", Method, 0},
		{"(*BadDecl).Pos", Method, 0},
		{"(*BadExpr).End", Method, 0},
		{"(*BadExpr).Pos", Method, 0},
		{"(*BadStmt).End", Method, 0},
		{"(*BadStmt).Pos", Method, 0},
		{"(*BasicLit).End", Method, 0},
		{"(*BasicLit).Pos", Method, 0},
		{"(*BinaryExpr).End", Method, 0},
		{"(*BinaryExpr).Pos", Method, 0},
		{"(*BlockStmt).End", Method, 0},
		{"(*BlockStmt).Pos", Method, 0},
		{"(*BranchStmt).End", Method, 0},
		{"(*BranchStmt).Pos", Method, 0},
		{"(*CallExpr).End", Method, 0},
		{"(*CallExpr).Pos", Method, 0},
		{"(*CaseClause).End", Method, 0},
		{"(*CaseClause).Pos", Method, 0},
		{"(*ChanType).End", Method, 0},
		{"(*ChanType).Pos", Method, 0},
		{"(*CommClause).End", Method, 0},
		{"(*CommClause).Pos", Method, 0},
		{"(*Comment).End", Method, 0},
		{"(*Comment).Pos", Method, 0},
		{"(*CommentGroup).End", Method, 0},
		{"(*CommentGroup).Pos", Method, 0},
		{"(*CommentGroup).Text", Method, 0},
		{"(*CompositeLit).End", Method, 0},
		{"(*CompositeLit).Pos", Method, 0},
		{"(*DeclStmt).End", Method, 0},
		{"(*DeclStmt).Pos", Method, 0},
		{"(*DeferStmt).End", Method, 0},
		{"(*DeferStmt).Pos", Method, 0},
		{"(*Ellipsis).End", Method, 0},
		{"(*Ellipsis).Pos", Method, 0},
		{"(*EmptyStmt).End", Method, 0},
		{"(*EmptyStmt).Pos", Method, 0},
		{"(*ExprStmt).End", Method, 0},
		{"(*ExprStmt).Pos", Method, 0},
		{"(*Field).End", Method, 0},
		{"(*Field).Pos", Method, 0},
		{"(*FieldList).End", Method, 0},
		{"(*FieldList).NumFields", Method, 0},
		{"(*FieldList).Pos", Method, 0},
		{"(*File).End", Method, 0},
		{"(*File).Pos", Method, 0},
		{"(*ForStmt).End", Method, 0},
		{"(*ForStmt).Pos", Method, 0},
		{"(*FuncDecl).End", Method, 0},
		{"(*FuncDecl).Pos", Method, 0},
		{"(*FuncLit).End", Method, 0},
		{"(*FuncLit).Pos", Method, 0},
		{"(*FuncType).End", Method, 0},
		{"(*FuncType).Pos", Method, 0},
		{"(*GenDecl).End", Method, 0},
		{"(*GenDecl).Pos", Method, 0},
		{"(*GoStmt).End", Method, 0},
		{"(*GoStmt).Pos", Method, 0},
		{"(*Ident).End", Method, 0},
		{"(*Ident).IsExported", Method, 0},
		{"(*Ident).Pos", Method, 0},
		{"(*Ident).String", Method, 0},
		{"(*IfStmt).End", Method, 0},
		{"(*IfStmt).Pos", Method, 0},
		{"(*ImportSpec).End", Method, 0},
		{"(*ImportSpec).Pos", Method, 0},
		{"(*IncDecStmt).End", Method, 0},
		{"(*IncDecStmt).Pos", Method, 0},
		{"(*IndexExpr).End", Method, 0},
		{"(*IndexExpr).Pos", Method, 0},
		{"(*IndexListExpr).End", Method, 18},
		{"(*IndexListExpr).Pos", Method, 18},
		{"(*InterfaceType).End", Method, 0},
		{"(*InterfaceType).Pos", Method, 0},
		{"(*KeyValueExpr).End", Method, 0},
		{"(*KeyValueExpr).Pos", Method, 0},
		{"(*LabeledStmt).End", Method, 0},
		{"(*LabeledStmt).Pos", Method, 0},
		{"(*MapType).End", Method, 0},
		{"(*MapType).Pos", Method, 0},
		{"(*Object).Pos", Method, 0},
		{"(*Package).End", Method, 0},
		{"(*Package).Pos", Method, 0},
		{"(*ParenExpr).End", Method, 0},
		{"(*ParenExpr).Pos", Method, 0},
		{"(*RangeStmt).End", Method, 0},
		{"(*RangeStmt).Pos", Method, 0},
		{"(*ReturnStmt).End", Method, 0},
		{"(*ReturnStmt).Pos", Method, 0},
		{"(*Scope).Insert", Method, 0},
		{"(*Scope).Lookup", Method, 0},
		{"(*Scope).String", Method, 0},
		{"(*SelectStmt).End", Method, 0},
		{"(*SelectStmt).Pos", Method, 0},
		{"(*SelectorExpr).End", Method, 0},
		{"(*SelectorExpr).Pos", Method, 0},
		{"(*SendStmt).End", Method, 0},
		{"(*SendStmt).Pos", Method, 0},
		{"(*SliceExpr).End", Method, 0},
		{"(*SliceExpr).Pos", Method, 0},
		{"(*StarExpr).End", Method, 0},
		{"(*StarExpr).Pos", Method, 0},
		{"(*StructType).End", Method, 0},
		{"(*StructType).Pos", Method, 0},
		{"(*SwitchStmt).End", Method, 0},
		{"(*SwitchStmt).Pos", Method, 0},
		{"(*TypeAssertExpr).End", Method, 0},
		{"(*TypeAssertExpr).Pos", Method, 0},
		{"(*TypeSpec).End", Method, 0},
		{"(*TypeSpec).Pos", Method, 0},
		{"(*TypeSwitchStmt).End", Method, 0},
		{"(*TypeSwitchStmt).Pos", Method, 0},
		{"(*UnaryExpr).End", Method, 0},
		{"(*UnaryExpr).Pos", Method, 0},
		{"(*ValueSpec).End", Method, 0},
		{"(*ValueSpec).Pos", Method, 0},
		{"(CommentMap).Comments", Method, 1},
		{"(CommentMap).Filter", Method, 1},
		{"(CommentMap).String", Method, 1},
		{"(CommentMap).Update", Method, 1},
		{"(ObjKind).String", Method, 0},
		{"ArrayType", Type, 0},
		{"ArrayType.Elt", Field, 0},
		{"ArrayType.Lbrack", Field, 0},
		{"ArrayType.Len", Field, 0},
		{"AssignStmt", Type, 0},
		{"AssignStmt.Lhs", Field, 0},
		{"AssignStmt.Rhs", Field, 0},
		{"AssignStmt.Tok", Field, 0},
		{"AssignStmt.TokPos", Field, 0},
		{"Bad", Const, 0},
		{"BadDecl", Type, 0},
		{"BadDecl.From", Field, 0},
		{"BadDecl.To", Field, 0},
		{"BadExpr", Type, 0},
		{"BadExpr.From", Field, 0},
		{"BadExpr.To", Field, 0},
		{"BadStmt", Type, 0},
		{"BadStmt.From", Field, 0},
		{"BadStmt.To", Field, 0},
		{"BasicLit", Type, 0},
		{"BasicLit.Kind", Field, 0},
		{"BasicLit.Value", Field, 0},
		{"BasicLit.ValuePos", Field, 0},
		{"BinaryExpr", Type, 0},
		{"BinaryExpr.Op", Field, 0},
		{"BinaryExpr.OpPos", Field, 0},
		{"BinaryExpr.X", Field, 0},
		{"BinaryExpr.Y", Field, 0},
		{"BlockStmt", Type, 0},
		{"BlockStmt.Lbrace", Field, 0},
		{"BlockStmt.List", Field, 0},
		{"BlockStmt.Rbrace", Field, 0},
		{"BranchStmt", Type, 0},
		{"BranchStmt.Label", Field, 0},
		{"BranchStmt.Tok", Field, 0},
		{"BranchStmt.TokPos", Field, 0},
		{"CallExpr", Type, 0},
		{"CallExpr.Args", Field, 0},
		{"CallExpr.Ellipsis", Field, 0},
		{"CallExpr.Fun", Field, 0},
		{"CallExpr.Lparen", Field, 0},
		{"CallExpr.Rparen", Field, 0},
		{"CaseClause", Type, 0},
		{"CaseClause.Body", Field, 0},
		{"CaseClause.Case", Field, 0},
		{"CaseClause.Colon", Field, 0},
		{"CaseClause.List", Field, 0},
		{"ChanDir", Type, 0},
		{"ChanType", Type, 0},
		{"ChanType.Arrow", Field, 1},
		{"ChanType.Begin", Field, 0},
		{"ChanType.Dir", Field, 0},
		{"ChanType.Value", Field, 0},
		{"CommClause", Type, 0},
		{"CommClause.Body", Field, 0},
		{"CommClause.Case", Field, 0},
		{"CommClause.Colon", Field, 0},
		{"CommClause.Comm", Field, 0},
		{"Comment", Type, 0},
		{"Comment.Slash", Field, 0},
		{"Comment.Text", Field, 0},
		{"CommentGroup", Type, 0},
		{"CommentGroup.List", Field, 0},
		{"CommentMap", Type, 1},
		{"CompositeLit", Type, 0},
		{"CompositeLit.Elts", Field, 0},
		{"CompositeLit.Incomplete", Field, 11},
		{"CompositeLit.Lbrace", Field, 0},
		{"CompositeLit.Rbrace", Field, 0},
		{"CompositeLit.Type", Field, 0},
		{"Con", Const, 0},
		{"Decl", Type, 0},
		{"DeclStmt", Type, 0},
		{"DeclStmt.Decl", Field, 0},
		{"DeferStmt", Type, 0},
		{"DeferStmt.Call", Field, 0},
		{"DeferStmt.Defer", Field, 0},
		{"Ellipsis", Type, 0},
		{"Ellipsis.Ellipsis", Field, 0},
		{"Ellipsis.Elt", Field, 0},
		{"EmptyStmt", Type, 0},
		{"EmptyStmt.Implicit", Field, 5},
		{"EmptyStmt.Semicolon", Field, 0},
		{"Expr", Type, 0},
		{"ExprStmt", Type, 0},
		{"ExprStmt.X", Field, 0},
		{"Field", Type, 0},
		{"Field.Comment", Field, 0},
		{"Field.Doc", Field, 0},
		{"Field.Names", Field, 0},
		{"Field.Tag", Field, 0},
		{"Field.Type", Field, 0},
		{"FieldFilter", Type, 0},
		{"FieldList", Type, 0},
		{"FieldList.Closing", Field, 0},
		{"FieldList.List", Field, 0},
		{"FieldList.Opening", Field, 0},
		{"File", Type, 0},
		{"File.Comments", Field, 0},
		{"File.Decls", Field, 0},
		{"File.Doc", Field, 0},
		{"File.FileEnd", Field, 20},
		{"File.FileStart", Field, 20},
		{"File.GoVersion", Field, 21},
		{"File.Imports", Field, 0},
		{"File.Name", Field, 0},
		{"File.Package", Field, 0},
		{"File.Scope", Field, 0},
		{"File.Unresolved", Field, 0},
		{"FileExports", Func, 0},
		{"Filter", Type, 0},
		{"FilterDecl", Func, 0},
		{"FilterFile", Func, 0},
		{"FilterFuncDuplicates", Const, 0},
		{"FilterImportDuplicates", Const, 0},
		{"FilterPackage", Func, 0},
		{"FilterUnassociatedComments", Const, 0},
		{"ForStmt", Type, 0},
		{"ForStmt.Body", Field, 0},
		{"ForStmt.Cond", Field, 0},
		{"ForStmt.For", Field, 0},
		{"ForStmt.Init", Field, 0},
		{"ForStmt.Post", Field, 0},
		{"Fprint", Func, 0},
		{"Fun", Const, 0},
		{"FuncDecl", Type, 0},
		{"FuncDecl.Body", Field, 0},
		{"FuncDecl.Doc", Field, 0},
		{"FuncDecl.Name", Field, 0},
		{"FuncDecl.Recv", Field, 0},
		{"FuncDecl.Type", Field, 0},
		{"FuncLit", Type, 0},
		{"FuncLit.Body", Field, 0},
		{"FuncLit.Type", Field, 0},
		{"FuncType", Type, 0},
		{"FuncType.Func", Field, 0},
		{"FuncType.Params", Field, 0},
		{"FuncType.Results", Field, 0},
		{"FuncType.TypeParams", Field, 18},
		{"GenDecl", Type, 0},
		{"GenDecl.Doc", Field, 0},
		{"GenDecl.Lparen", Field, 0},
		{"GenDecl.Rparen", Field, 0},
		{"GenDecl.Specs", Field, 0},
		{"GenDecl.Tok", Field, 0},
		{"GenDecl.TokPos", Field, 0},
		{"GoStmt", Type, 0},
		{"GoStmt.Call", Field, 0},
		{"GoStmt.Go", Field, 0},
		{"Ident", Type, 0},
		{"Ident.Name", Field, 0},
		{"Ident.NamePos", Field, 0},
		{"Ident.Obj", Field, 0},
		{"IfStmt", Type, 0},
		{"IfStmt.Body", Field, 0},
		{"IfStmt.Cond", Field, 0},
		{"IfStmt.Else", Field, 0},
		{"IfStmt.If", Field, 0},
		{"IfStmt.Init", Field, 0},
		{"ImportSpec", Type, 0},
		{"ImportSpec.Comment", Field, 0},
		{"ImportSpec.Doc", Field, 0},
		{"ImportSpec.EndPos", Field, 0},
		{"ImportSpec.Name", Field, 0},
		{"ImportSpec.Path", Field, 0},
		{"Importer", Type, 0},
		{"IncDecStmt", Type, 0},
		{"IncDecStmt.Tok", Field, 0},
		{"IncDecStmt.TokPos", Field, 0},
		{"IncDecStmt.X", Field, 0},
		{"IndexExpr", Type, 0},
		{"IndexExpr.Index", Field, 0},
		{"IndexExpr.Lbrack", Field, 0},
		{"IndexExpr.Rbrack", Field, 0},
		{"IndexExpr.X", Field, 0},
		{"IndexListExpr", Type, 18},
		{"IndexListExpr.Indices", Field, 18},
		{"IndexListExpr.Lbrack", Field, 18},
		{"IndexListExpr.Rbrack", Field, 18},
		{"IndexListExpr.X", Field, 18},
		{"Inspect", Func, 0},
		{"InterfaceType", Type, 0},
		{"InterfaceType.Incomplete", Field, 0},
		{"InterfaceType.Interface", Field, 0},
		{"InterfaceType.Methods", Field, 0},
		{"IsExported", Func, 0},
		{"IsGenerated", Func, 21},
		{"KeyValueExpr", Type, 0},
		{"KeyValueExpr.Colon", Field, 0},
		{"KeyValueExpr.Key", Field, 0},
		{"KeyValueExpr.Value", Field, 0},
		{"LabeledStmt", Type, 0},
		{"LabeledStmt.Colon", Field, 0},
		{"LabeledStmt.Label", Field, 0},
		{"LabeledStmt.Stmt", Field, 0},
		{"Lbl", Const, 0},
		{"MapType", Type, 0},
		{"MapType.Key", Field, 0},
		{"MapType.Map", Field, 0},
		{"MapType.Value", Field, 0},
		{"MergeMode", Type, 0},
		{"MergePackageFiles", Func, 0},
		{"NewCommentMap", Func, 1},
		{"NewIdent", Func, 0},
		{"NewObj", Func, 0},
		{"NewPackage", Func, 0},
		{"NewScope", Func, 0},
		{"Node", Type, 0},
		{"NotNilFilter", Func, 0},
		{"ObjKind", Type, 0},
		{"Object", Type, 0},
		{"Object.Data", Field, 0},
		{"Object.Decl", Field, 0},
		{"Object.Kind", Field, 0},
		{"Object.Name", Field, 0},
		{"Object.Type", Field, 0},
		{"Package", Type, 0},
		{"Package.Files", Field, 0},
		{"Package.Imports", Field, 0},
		{"Package.Name", Field, 0},
		{"Package.Scope", Field, 0},
		{"PackageExports", Func, 0},
		{"ParenExpr", Type, 0},
		{"ParenExpr.Lparen", Field, 0},
		{"ParenExpr.Rparen", Field, 0},
		{"ParenExpr.X", Field, 0},
		{"Pkg", Const, 0},
		{"Preorder", Func, 23},
		{"Print", Func, 0},
		{"RECV", Const, 0},
		{"RangeStmt", Type, 0},
		{"RangeStmt.Body", Field, 0},
		{"RangeStmt.For", Field, 0},
		{"RangeStmt.Key", Field, 0},
		{"RangeStmt.Range", Field, 20},
		{"RangeStmt.Tok", Field, 0},
		{"RangeStmt.TokPos", Field, 0},
		{"RangeStmt.Value", Field, 0},
		{"RangeStmt.X", Field, 0},
		{"ReturnStmt", Type, 0},
		{"ReturnStmt.Results", Field, 0},
		{"ReturnStmt.Return", Field, 0},
		{"SEND", Const, 0},
		{"Scope", Type, 0},
		{"Scope.Objects", Field, 0},
		{"Scope.Outer", Field, 0},
		{"SelectStmt", Type, 0},
		{"SelectStmt.Body", Field, 0},
		{"SelectStmt.Select", Field, 0},
		{"SelectorExpr", Type, 0},
		{"SelectorExpr.Sel", Field, 0},
		{"SelectorExpr.X", Field, 0},
		{"SendStmt", Type, 0},
		{"SendStmt.Arrow", Field, 0},
		{"SendStmt.Chan", Field, 0},
		{"SendStmt.Value", Field, 0},
		{"SliceExpr", Type, 0},
		{"SliceExpr.High", Field, 0},
		{"SliceExpr.Lbrack", Field, 0},
		{"SliceExpr.Low", Field, 0},
		{"SliceExpr.Max", Field, 2},
		{"SliceExpr.Rbrack", Field, 0},
		{"SliceExpr.Slice3", Field, 2},
		{"SliceExpr.X", Field, 0},
		{"SortImports", Func, 0},
		{"Spec", Type, 0},
		{"StarExpr", Type, 0},
		{"StarExpr.Star", Field, 0},
		{"StarExpr.X", Field, 0},
		{"Stmt", Type, 0},
		{"StructType", Type, 0},
		{"StructType.Fields", Field, 0},
		{"StructType.Incomplete", Field, 0},
		{"StructType.Struct", Field, 0},
		{"SwitchStmt", Type, 0},
		{"SwitchStmt.Body", Field, 0},
		{"SwitchStmt.Init", Field, 0},
		{"SwitchStmt.Switch", Field, 0},
		{"SwitchStmt.Tag", Field, 0},
		{"Typ", Const, 0},
		{"TypeAssertExpr", Type, 0},
		{"TypeAssertExpr.Lparen", Field, 2},
		{"TypeAssertExpr.Rparen", Field, 2},
		{"TypeAssertExpr.Type", Field, 0},
		{"TypeAssertExpr.X", Field, 0},
		{"TypeSpec", Type, 0},
		{"TypeSpec.Assign", Field, 9},
		{"TypeSpec.Comment", Field, 0},
		{"TypeSpec.Doc", Field, 0},
		{"TypeSpec.Name", Field, 0},
		{"TypeSpec.Type", Field, 0},
		{"TypeSpec.TypeParams", Field, 18},
		{"TypeSwitchStmt", Type, 0},
		{"TypeSwitchStmt.Assign", Field, 0},
		{"TypeSwitchStmt.Body", Field, 0},
		{"TypeSwitchStmt.Init", Field, 0},
		{"TypeSwitchStmt.Switch", Field, 0},
		{"UnaryExpr", Type, 0},
		{"UnaryExpr.Op", Field, 0},
		{"UnaryExpr.OpPos", Field, 0},
		{"UnaryExpr.X", Field, 0},
		{"Unparen", Func, 22},
		{"ValueSpec", Type, 0},
		{"ValueSpec.Comment", Field, 0},
		{"ValueSpec.Doc", Field, 0},
		{"ValueSpec.Names", Field, 0},
		{"ValueSpec.Type", Field, 0},
		{"ValueSpec.Values", Field, 0},
		{"Var", Const, 0},
		{"Visitor", Type, 0},
		{"Walk", Func, 0},
	},
	"go/build": {
		{"(*Context).Import", Method, 0},
		{"(*Context).ImportDir", Method, 0},
		{"(*Context).MatchFile", Method, 2},
		{"(*Context).SrcDirs", Method, 0},
		{"(*MultiplePackageError).Error", Method, 4},
		{"(*NoGoError).Error", Method, 0},
		{"(*Package).IsCommand", Method, 0},
		{"AllowBinary", Const, 0},
		{"ArchChar", Func, 0},
		{"Context", Type, 0},
		{"Context.BuildTags", Field, 0},
		{"Context.CgoEnabled", Field, 0},
		{"Context.Compiler", Field, 0},
		{"Context.Dir", Field, 14},
		{"Context.GOARCH", Field, 0},
		{"Context.GOOS", Field, 0},
		{"Context.GOPATH", Field, 0},
		{"Context.GOROOT", Field, 0},
		{"Context.HasSubdir", Field, 0},
		{"Context.InstallSuffix", Field, 1},
		{"Context.IsAbsPath", Field, 0},
		{"Context.IsDir", Field, 0},
		{"Context.JoinPath", Field, 0},
		{"Context.OpenFile", Field, 0},
		{"Context.ReadDir", Field, 0},
		{"Context.ReleaseTags", Field, 1},
		{"Context.SplitPathList", Field, 0},
		{"Context.ToolTags", Field, 17},
		{"Context.UseAllFiles", Field, 0},
		{"Default", Var, 0},
		{"Directive", Type, 21},
		{"Directive.Pos", Field, 21},
		{"Directive.Text", Field, 21},
		{"FindOnly", Const, 0},
		{"IgnoreVendor", Const, 6},
		{"Import", Func, 0},
		{"ImportComment", Const, 4},
		{"ImportDir", Func, 0},
		{"ImportMode", Type, 0},
		{"IsLocalImport", Func, 0},
		{"MultiplePackageError", Type, 4},
		{"MultiplePackageError.Dir", Field, 4},
		{"MultiplePackageError.Files", Field, 4},
		{"MultiplePackageError.Packages", Field, 4},
		{"NoGoError", Type, 0},
		{"NoGoError.Dir", Field, 0},
		{"Package", Type, 0},
		{"Package.AllTags", Field, 2},
		{"Package.BinDir", Field, 0},
		{"Package.BinaryOnly", Field, 7},
		{"Package.CFiles", Field, 0},
		{"Package.CXXFiles", Field, 2},
		{"Package.CgoCFLAGS", Field, 0},
		{"Package.CgoCPPFLAGS", Field, 2},
		{"Package.CgoCXXFLAGS", Field, 2},
		{"Package.CgoFFLAGS", Field, 7},
		{"Package.CgoFiles", Field, 0},
		{"Package.CgoLDFLAGS", Field, 0},
		{"Package.CgoPkgConfig", Field, 0},
		{"Package.ConflictDir", Field, 2},
		{"Package.Dir", Field, 0},
		{"Package.Directives", Field, 21},
		{"Package.Doc", Field, 0},
		{"Package.EmbedPatternPos", Field, 16},
		{"Package.EmbedPatterns", Field, 16},
		{"Package.FFiles", Field, 7},
		{"Package.GoFiles", Field, 0},
		{"Package.Goroot", Field, 0},
		{"Package.HFiles", Field, 0},
		{"Package.IgnoredGoFiles", Field, 1},
		{"Package.IgnoredOtherFiles", Field, 16},
		{"Package.ImportComment", Field, 4},
		{"Package.ImportPath", Field, 0},
		{"Package.ImportPos", Field, 0},
		{"Package.Imports", Field, 0},
		{"Package.InvalidGoFiles", Field, 6},
		{"Package.MFiles", Field, 3},
		{"Package.Name", Field, 0},
		{"Package.PkgObj", Field, 0},
		{"Package.PkgRoot", Field, 0},
		{"Package.PkgTargetRoot", Field, 5},
		{"Package.Root", Field, 0},
		{"Package.SFiles", Field, 0},
		{"Package.SrcRoot", Field, 0},
		{"Package.SwigCXXFiles", Field, 1},
		{"Package.SwigFiles", Field, 1},
		{"Package.SysoFiles", Field, 0},
		{"Package.TestDirectives", Field, 21},
		{"Package.TestEmbedPatternPos", Field, 16},
		{"Package.TestEmbedPatterns", Field, 16},
		{"Package.TestGoFiles", Field, 0},
		{"Package.TestImportPos", Field, 0},
		{"Package.TestImports", Field, 0},
		{"Package.XTestDirectives", Field, 21},
		{"Package.XTestEmbedPatternPos", Field, 16},
		{"Package.XTestEmbedPatterns", Field, 16},
		{"Package.XTestGoFiles", Field, 0},
		{"Package.XTestImportPos", Field, 0},
		{"Package.XTestImports", Field, 0},
		{"ToolDir", Var, 0},
	},
	"go/build/constraint": {
		{"(*AndExpr).Eval", Method, 16},
		{"(*AndExpr).String", Method, 16},
		{"(*NotExpr).Eval", Method, 16},
		{"(*NotExpr).String", Method, 16},
		{"(*OrExpr).Eval", Method, 16},
		{"(*OrExpr).String", Method, 16},
		{"(*SyntaxError).Error", Method, 16},
		{"(*TagExpr).Eval", Method, 16},
		{"(*TagExpr).String", Method, 16},
		{"AndExpr", Type, 16},
		{"AndExpr.X", Field, 16},
		{"AndExpr.Y", Field, 16},
		{"Expr", Type, 16},
		{"GoVersion", Func, 21},
		{"IsGoBuild", Func, 16},
		{"IsPlusBuild", Func, 16},
		{"NotExpr", Type, 16},
		{"NotExpr.X", Field, 16},
		{"OrExpr", Type, 16},
		{"OrExpr.X", Field, 16},
		{"OrExpr.Y", Field, 16},
		{"Parse", Func, 16},
		{"PlusBuildLines", Func, 16},
		{"SyntaxError", Type, 16},
		{"SyntaxError.Err", Field, 16},
		{"SyntaxError.Offset", Field, 16},
		{"TagExpr", Type, 16},
		{"TagExpr.Tag", Field, 16},
	},
	"go/constant": {
		{"(Kind).String", Method, 18},
		{"BinaryOp", Func, 5},
		{"BitLen", Func, 5},
		{"Bool", Const, 5},
		{"BoolVal", Func, 5},
		{"Bytes", Func, 5},
		{"Compare", Func, 5},
		{"Complex", Const, 5},
		{"Denom", Func, 5},
		{"Float", Const, 5},
		{"Float32Val", Func, 5},
		{"Float64Val", Func, 5},
		{"Imag", Func, 5},
		{"Int", Const, 5},
		{"Int64Val", Func, 5},
		{"Kind", Type, 5},
		{"Make", Func, 13},
		{"MakeBool", Func, 5},
		{"MakeFloat64", Func, 5},
		{"MakeFromBytes", Func, 5},
		{"MakeFromLiteral", Func, 5},
		{"MakeImag", Func, 5},
		{"MakeInt64", Func, 5},
		{"MakeString", Func, 5},
		{"MakeUint64", Func, 5},
		{"MakeUnknown", Func, 5},
		{"Num", Func, 5},
		{"Real", Func, 5},
		{"Shift", Func, 5},
		{"Sign", Func, 5},
		{"String", Const, 5},
		{"StringVal", Func, 5},
		{"ToComplex", Func, 6},
		{"ToFloat", Func, 6},
		{"ToInt", Func, 6},
		{"Uint64Val", Func, 5},
		{"UnaryOp", Func, 5},
		{"Unknown", Const, 5},
		{"Val", Func, 13},
		{"Value", Type, 5},
	},
	"go/doc": {
		{"(*Package).Filter", Method, 0},
		{"(*Package).HTML", Method, 19},
		{"(*Package).Markdown", Method, 19},
		{"(*Package).Parser", Method, 19},
		{"(*Package).Printer", Method, 19},
		{"(*Package).Synopsis", Method, 19},
		{"(*Package).Text", Method, 19},
		{"AllDecls", Const, 0},
		{"AllMethods", Const, 0},
		{"Example", Type, 0},
		{"Example.Code", Field, 0},
		{"Example.Comments", Field, 0},
		{"Example.Doc", Field, 0},
		{"Example.EmptyOutput", Field, 1},
		{"Example.Name", Field, 0},
		{"Example.Order", Field, 1},
		{"Example.Output", Field, 0},
		{"Example.Play", Field, 1},
		{"Example.Suffix", Field, 14},
		{"Example.Unordered", Field, 7},
		{"Examples", Func, 0},
		{"Filter", Type, 0},
		{"Func", Type, 0},
		{"Func.Decl", Field, 0},
		{"Func.Doc", Field, 0},
		{"Func.Examples", Field, 14},
		{"Func.Level", Field, 0},
		{"Func.Name", Field, 0},
		{"Func.Orig", Field, 0},
		{"Func.Recv", Field, 0},
		{"IllegalPrefixes", Var, 1},
		{"IsPredeclared", Func, 8},
		{"Mode", Type, 0},
		{"New", Func, 0},
		{"NewFromFiles", Func, 14},
		{"Note", Type, 1},
		{"Note.Body", Field, 1},
		{"Note.End", Field, 1},
		{"Note.Pos", Field, 1},
		{"Note.UID", Field, 1},
		{"Package", Type, 0},
		{"Package.Bugs", Field, 0},
		{"Package.Consts", Field, 0},
		{"Package.Doc", Field, 0},
		{"Package.Examples", Field, 14},
		{"Package.Filenames", Field, 0},
		{"Package.Funcs", Field, 0},
		{"Package.ImportPath", Field, 0},
		{"Package.Imports", Field, 0},
		{"Package.Name", Field, 0},
		{"Package.Notes", Field, 1},
		{"Package.Types", Field, 0},
		{"Package.Vars", Field, 0},
		{"PreserveAST", Const, 12},
		{"Synopsis", Func, 0},
		{"ToHTML", Func, 0},
		{"ToText", Func, 0},
		{"Type", Type, 0},
		{"Type.Consts", Field, 0},
		{"Type.Decl", Field, 0},
		{"Type.Doc", Field, 0},
		{"Type.Examples", Field, 14},
		{"Type.Funcs", Field, 0},
		{"Type.Methods", Field, 0},
		{"Type.Name", Field, 0},
		{"Type.Vars", Field, 0},
		{"Value", Type, 0},
		{"Value.Decl", Field, 0},
		{"Value.Doc", Field, 0},
		{"Value.Names", Field, 0},
	},
	"go/doc/comment": {
		{"(*DocLink).DefaultURL", Method, 19},
		{"(*Heading).DefaultID", Method, 19},
		{"(*List).BlankBefore", Method, 19},
		{"(*List).BlankBetween", Method, 19},
		{"(*Parser).Parse", Method, 19},
		{"(*Printer).Comment", Method, 19},
		{"(*Printer).HTML", Method, 19},
		{"(*Printer).Markdown", Method, 19},
		{"(*Printer).Text", Method, 19},
		{"Block", Type, 19},
		{"Code", Type, 19},
		{"Code.Text", Field, 19},
		{"DefaultLookupPackage", Func, 19},
		{"Doc", Type, 19},
		{"Doc.Content", Field, 19},
		{"Doc.Links", Field, 19},
		{"DocLink", Type, 19},
		{"DocLink.ImportPath", Field, 19},
		{"DocLink.Name", Field, 19},
		{"DocLink.Recv", Field, 19},
		{"DocLink.Text", Field, 19},
		{"Heading", Type, 19},
		{"Heading.Text", Field, 19},
		{"Italic", Type, 19},
		{"Link", Type, 19},
		{"Link.Auto", Field, 19},
		{"Link.Text", Field, 19},
		{"Link.URL", Field, 19},
		{"LinkDef", Type, 19},
		{"LinkDef.Text", Field, 19},
		{"LinkDef.URL", Field, 19},
		{"LinkDef.Used", Field, 19},
		{"List", Type, 19},
		{"List.ForceBlankBefore", Field, 19},
		{"List.ForceBlankBetween", Field, 19},
		{"List.Items", Field, 19},
		{"ListItem", Type, 19},
		{"ListItem.Content", Field, 19},
		{"ListItem.Number", Field, 19},
		{"Paragraph", Type, 19},
		{"Paragraph.Text", Field, 19},
		{"Parser", Type, 19},
		{"Parser.LookupPackage", Field, 19},
		{"Parser.LookupSym", Field, 19},
		{"Parser.Words", Field, 19},
		{"Plain", Type, 19},
		{"Printer", Type, 19},
		{"Printer.DocLinkBaseURL", Field, 19},
		{"Printer.DocLinkURL", Field, 19},
		{"Printer.HeadingID", Field, 19},
		{"Printer.HeadingLevel", Field, 19},
		{"Printer.TextCodePrefix", Field, 19},
		{"Printer.TextPrefix", Field, 19},
		{"Printer.TextWidth", Field, 19},
		{"Text", Type, 19},
	},
	"go/format": {
		{"Node", Func, 1},
		{"Source", Func, 1},
	},
	"go/importer": {
		{"Default", Func, 5},
		{"For", Func, 5},
		{"ForCompiler", Func, 12},
		{"Lookup", Type, 5},
	},
	"go/parser": {
		{"AllErrors", Const, 1},
		{"DeclarationErrors", Const, 0},
		{"ImportsOnly", Const, 0},
		{"Mode", Type, 0},
		{"PackageClauseOnly", Const, 0},
		{"ParseComments", Const, 0},
		{"ParseDir", Func, 0},
		{"ParseExpr", Func, 0},
		{"ParseExprFrom", Func, 5},
		{"ParseFile", Func, 0},
		{"SkipObjectResolution", Const, 17},
		{"SpuriousErrors", Const, 0},
		{"Trace", Const, 0},
	},
	"go/printer": {
		{"(*Config).Fprint", Method, 0},
		{"CommentedNode", Type, 0},
		{"CommentedNode.Comments", Field, 0},
		{"CommentedNode.Node", Field, 0},
		{"Config", Type, 0},
		{"Config.Indent", Field, 1},
		{"Config.Mode", Field, 0},
		{"Config.Tabwidth", Field, 0},
		{"Fprint", Func, 0},
		{"Mode", Type, 0},
		{"RawFormat", Const, 0},
		{"SourcePos", Const, 0},
		{"TabIndent", Const, 0},
		{"UseSpaces", Const, 0},
	},
	"go/scanner": {
		{"(*ErrorList).Add", Method, 0},
		{"(*ErrorList).RemoveMultiples", Method, 0},
		{"(*ErrorList).Reset", Method, 0},
		{"(*Scanner).Init", Method, 0},
		{"(*Scanner).Scan", Method, 0},
		{"(Error).Error", Method, 0},
		{"(ErrorList).Err", Method, 0},
		{"(ErrorList).Error", Method, 0},
		{"(ErrorList).Len", Method, 0},
		{"(ErrorList).Less", Method, 0},
		{"(ErrorList).Sort", Method, 0},
		{"(ErrorList).Swap", Method, 0},
		{"Error", Type, 0},
		{"Error.Msg", Field, 0},
		{"Error.Pos", Field, 0},
		{"ErrorHandler", Type, 0},
		{"ErrorList", Type, 0},
		{"Mode", Type, 0},
		{"PrintError", Func, 0},
		{"ScanComments", Const, 0},
		{"Scanner", Type, 0},
		{"Scanner.ErrorCount", Field, 0},
	},
	"go/token": {
		{"(*File).AddLine", Method, 0},
		{"(*File).AddLineColumnInfo", Method, 11},
		{"(*File).AddLineInfo", Method, 0},
		{"(*File).Base", Method, 0},
		{"(*File).Line", Method, 0},
		{"(*File).LineCount", Method, 0},
		{"(*File).LineStart", Method, 12},
		{"(*File).Lines", Method, 21},
		{"(*File).MergeLine", Method, 2},
		{"(*File).Name", Method, 0},
		{"(*File).Offset", Method, 0},
		{"(*File).Pos", Method, 0},
		{"(*File).Position", Method, 0},
		{"(*File).PositionFor", Method, 4},
		{"(*File).SetLines", Method, 0},
		{"(*File).SetLinesForContent", Method, 0},
		{"(*File).Size", Method, 0},
		{"(*FileSet).AddFile", Method, 0},
		{"(*FileSet).Base", Method, 0},
		{"(*FileSet).File", Method, 0},
		{"(*FileSet).Iterate", Method, 0},
		{"(*FileSet).Position", Method, 0},
		{"(*FileSet).PositionFor", Method, 4},
		{"(*FileSet).Read", Method, 0},
		{"(*FileSet).RemoveFile", Method, 20},
		{"(*FileSet).Write", Method, 0},
		{"(*Position).IsValid", Method, 0},
		{"(Pos).IsValid", Method, 0},
		{"(Position).String", Method, 0},
		{"(Token).IsKeyword", Method, 0},
		{"(Token).IsLiteral", Method, 0},
		{"(Token).IsOperator", Method, 0},
		{"(Token).Precedence", Method, 0},
		{"(Token).String", Method, 0},
		{"ADD", Const, 0},
		{"ADD_ASSIGN", Const, 0},
		{"AND", Const, 0},
		{"AND_ASSIGN", Const, 0},
		{"AND_NOT", Const, 0},
		{"AND_NOT_ASSIGN", Const, 0},
		{"ARROW", Const, 0},
		{"ASSIGN", Const, 0},
		{"BREAK", Const, 0},
		{"CASE", Const, 0},
		{"CHAN", Const, 0},
		{"CHAR", Const, 0},
		{"COLON", Const, 0},
		{"COMMA", Const, 0},
		{"COMMENT", Const, 0},
		{"CONST", Const, 0},
		{"CONTINUE", Const, 0},
		{"DEC", Const, 0},
		{"DEFAULT", Const, 0},
		{"DEFER", Const, 0},
		{"DEFINE", Const, 0},
		{"ELLIPSIS", Const, 0},
		{"ELSE", Const, 0},
		{"EOF", Const, 0},
		{"EQL", Const, 0},
		{"FALLTHROUGH", Const, 0},
		{"FLOAT", Const, 0},
		{"FOR", Const, 0},
		{"FUNC", Const, 0},
		{"File", Type, 0},
		{"FileSet", Type, 0},
		{"GEQ", Const, 0},
		{"GO", Const, 0},
		{"GOTO", Const, 0},
		{"GTR", Const, 0},
		{"HighestPrec", Const, 0},
		{"IDENT", Const, 0},
		{"IF", Const, 0},
		{"ILLEGAL", Const, 0},
		{"IMAG", Const, 0},
		{"IMPORT", Const, 0},
		{"INC", Const, 0},
		{"INT", Const, 0},
		{"INTERFACE", Const, 0},
		{"IsExported", Func, 13},
		{"IsIdentifier", Func, 13},
		{"IsKeyword", Func, 13},
		{"LAND", Const, 0},
		{"LBRACE", Const, 0},
		{"LBRACK", Const, 0},
		{"LEQ", Const, 0},
		{"LOR", Const, 0},
		{"LPAREN", Const, 0},
		{"LSS", Const, 0},
		{"Lookup", Func, 0},
		{"LowestPrec", Const, 0},
		{"MAP", Const, 0},
		{"MUL", Const, 0},
		{"MUL_ASSIGN", Const, 0},
		{"NEQ", Const, 0},
		{"NOT", Const, 0},
		{"NewFileSet", Func, 0},
		{"NoPos", Const, 0},
		{"OR", Const, 0},
		{"OR_ASSIGN", Const, 0},
		{"PACKAGE", Const, 0},
		{"PERIOD", Const, 0},
		{"Pos", Type, 0},
		{"Position", Type, 0},
		{"Position.Column", Field, 0},
		{"Position.Filename", Field, 0},
		{"Position.Line", Field, 0},
		{"Position.Offset", Field, 0},
		{"QUO", Const, 0},
		{"QUO_ASSIGN", Const, 0},
		{"RANGE", Const, 0},
		{"RBRACE", Const, 0},
		{"RBRACK", Const, 0},
		{"REM", Const, 0},
		{"REM_ASSIGN", Const, 0},
		{"RETURN", Const, 0},
		{"RPAREN", Const, 0},
		{"SELECT", Const, 0},
		{"SEMICOLON", Const, 0},
		{"SHL", Const, 0},
		{"SHL_ASSIGN", Const, 0},
		{"SHR", Const, 0},
		{"SHR_ASSIGN", Const, 0},
		{"STRING", Const, 0},
		{"STRUCT", Const, 0},
		{"SUB", Const, 0},
		{"SUB_ASSIGN", Const, 0},
		{"SWITCH", Const, 0},
		{"TILDE", Const, 18},
		{"TYPE", Const, 0},
		{"Token", Type, 0},
		{"UnaryPrec", Const, 0},
		{"VAR", Const, 0},
		{"XOR", Const, 0},
		{"XOR_ASSIGN", Const, 0},
	},
	"go/types": {
		{"(*Alias).Obj", Method, 22},
		{"(*Alias).Origin", Method, 23},
		{"(*Alias).Rhs", Method, 23},
		{"(*Alias).SetTypeParams", Method, 23},
		{"(*Alias).String", Method, 22},
		{"(*Alias).TypeArgs", Method, 23},
		{"(*Alias).TypeParams", Method, 23},
		{"(*Alias).Underlying", Method, 22},
		{"(*ArgumentError).Error", Method, 18},
		{"(*ArgumentError).Unwrap", Method, 18},
		{"(*Array).Elem", Method, 5},
		{"(*Array).Len", Method, 5},
		{"(*Array).String", Method, 5},
		{"(*Array).Underlying", Method, 5},
		{"(*Basic).Info", Method, 5},
		{"(*Basic).Kind", Method, 5},
		{"(*Basic).Name", Method, 5},
		{"(*Basic).String", Method, 5},
		{"(*Basic).Underlying", Method, 5},
		{"(*Builtin).Exported", Method, 5},
		{"(*Builtin).Id", Method, 5},
		{"(*Builtin).Name", Method, 5},
		{"(*Builtin).Parent", Method, 5},
		{"(*Builtin).Pkg", Method, 5},
		{"(*Builtin).Pos", Method, 5},
		{"(*Builtin).String", Method, 5},
		{"(*Builtin).Type", Method, 5},
		{"(*Chan).Dir", Method, 5},
		{"(*Chan).Elem", Method, 5},
		{"(*Chan).String", Method, 5},
		{"(*Chan).Underlying", Method, 5},
		{"(*Checker).Files", Method, 5},
		{"(*Config).Check", Method, 5},
		{"(*Const).Exported", Method, 5},
		{"(*Const).Id", Method, 5},
		{"(*Const).Name", Method, 5},
		{"(*Const).Parent", Method, 5},
		{"(*Const).Pkg", Method, 5},
		{"(*Const).Pos", Method, 5},
		{"(*Const).String", Method, 5},
		{"(*Const).Type", Method, 5},
		{"(*Const).Val", Method, 5},
		{"(*Func).Exported", Method, 5},
		{"(*Func).FullName", Method, 5},
		{"(*Func).Id", Method, 5},
		{"(*Func).Name", Method, 5},
		{"(*Func).Origin", Method, 19},
		{"(*Func).Parent", Method, 5},
		{"(*Func).Pkg", Method, 5},
		{"(*Func).Pos", Method, 5},
		{"(*Func).Scope", Method, 5},
		{"(*Func).Signature", Method, 23},
		{"(*Func).String", Method, 5},
		{"(*Func).Type", Method, 5},
		{"(*Info).ObjectOf", Method, 5},
		{"(*Info).PkgNameOf", Method, 22},
		{"(*Info).TypeOf", Method, 5},
		{"(*Initializer).String", Method, 5},
		{"(*Interface).Complete", Method, 5},
		{"(*Interface).Embedded", Method, 5},
		{"(*Interface).EmbeddedType", Method, 11},
		{"(*Interface).EmbeddedTypes", Method, 24},
		{"(*Interface).Empty", Method, 5},
		{"(*Interface).ExplicitMethod", Method, 5},
		{"(*Interface).ExplicitMethods", Method, 24},
		{"(*Interface).IsComparable", Method, 18},
		{"(*Interface).IsImplicit", Method, 18},
		{"(*Interface).IsMethodSet", Method, 18},
		{"(*Interface).MarkImplicit", Method, 18},
		{"(*Interface).Method", Method, 5},
		{"(*Interface).Methods", Method, 24},
		{"(*Interface).NumEmbeddeds", Method, 5},
		{"(*Interface).NumExplicitMethods", Method, 5},
		{"(*Interface).NumMethods", Method, 5},
		{"(*Interface).String", Method, 5},
		{"(*Interface).Underlying", Method, 5},
		{"(*Label).Exported", Method, 5},
		{"(*Label).Id", Method, 5},
		{"(*Label).Name", Method, 5},
		{"(*Label).Parent", Method, 5},
		{"(*Label).Pkg", Method, 5},
		{"(*Label).Pos", Method, 5},
		{"(*Label).String", Method, 5},
		{"(*Label).Type", Method, 5},
		{"(*Map).Elem", Method, 5},
		{"(*Map).Key", Method, 5},
		{"(*Map).String", Method, 5},
		{"(*Map).Underlying", Method, 5},
		{"(*MethodSet).At", Method, 5},
		{"(*MethodSet).Len", Method, 5},
		{"(*MethodSet).Lookup", Method, 5},
		{"(*MethodSet).Methods", Method, 24},
		{"(*MethodSet).String", Method, 5},
		{"(*Named).AddMethod", Method, 5},
		{"(*Named).Method", Method, 5},
		{"(*Named).Methods", Method, 24},
		{"(*Named).NumMethods", Method, 5},
		{"(*Named).Obj", Method, 5},
		{"(*Named).Origin", Method, 18},
		{"(*Named).SetTypeParams", Method, 18},
		{"(*Named).SetUnderlying", Method, 5},
		{"(*Named).String", Method, 5},
		{"(*Named).TypeArgs", Method, 18},
		{"(*Named).TypeParams", Method, 18},
		{"(*Named).Underlying", Method, 5},
		{"(*Nil).Exported", Method, 5},
		{"(*Nil).Id", Method, 5},
		{"(*Nil).Name", Method, 5},
		{"(*Nil).Parent", Method, 5},
		{"(*Nil).Pkg", Method, 5},
		{"(*Nil).Pos", Method, 5},
		{"(*Nil).String", Method, 5},
		{"(*Nil).Type", Method, 5},
		{"(*Package).Complete", Method, 5},
		{"(*Package).GoVersion", Method, 21},
		{"(*Package).Imports", Method, 5},
		{"(*Package).MarkComplete", Method, 5},
		{"(*Package).Name", Method, 5},
		{"(*Package).Path", Method, 5},
		{"(*Package).Scope", Method, 5},
		{"(*Package).SetImports", Method, 5},
		{"(*Package).SetName", Method, 6},
		{"(*Package).String", Method, 5},
		{"(*PkgName).Exported", Method, 5},
		{"(*PkgName).Id", Method, 5},
		{"(*PkgName).Imported", Method, 5},
		{"(*PkgName).Name", Method, 5},
		{"(*PkgName).Parent", Method, 5},
		{"(*PkgName).Pkg", Method, 5},
		{"(*PkgName).Pos", Method, 5},
		{"(*PkgName).String", Method, 5},
		{"(*PkgName).Type", Method, 5},
		{"(*Pointer).Elem", Method, 5},
		{"(*Pointer).String", Method, 5},
		{"(*Pointer).Underlying", Method, 5},
		{"(*Scope).Child", Method, 5},
		{"(*Scope).Children", Method, 24},
		{"(*Scope).Contains", Method, 5},
		{"(*Scope).End", Method, 5},
		{"(*Scope).Innermost", Method, 5},
		{"(*Scope).Insert", Method, 5},
		{"(*Scope).Len", Method, 5},
		{"(*Scope).Lookup", Method, 5},
		{"(*Scope).LookupParent", Method, 5},
		{"(*Scope).Names", Method, 5},
		{"(*Scope).NumChildren", Method, 5},
		{"(*Scope).Parent", Method, 5},
		{"(*Scope).Pos", Method, 5},
		{"(*Scope).String", Method, 5},
		{"(*Scope).WriteTo", Method, 5},
		{"(*Selection).Index", Method, 5},
		{"(*Selection).Indirect", Method, 5},
		{"(*Selection).Kind", Method, 5},
		{"(*Selection).Obj", Method, 5},
		{"(*Selection).Recv", Method, 5},
		{"(*Selection).String", Method, 5},
		{"(*Selection).Type", Method, 5},
		{"(*Signature).Params", Method, 5},
		{"(*Signature).Recv", Method, 5},
		{"(*Signature).RecvTypeParams", Method, 18},
		{"(*Signature).Results", Method, 5},
		{"(*Signature).String", Method, 5},
		{"(*Signature).TypeParams", Method, 18},
		{"(*Signature).Underlying", Method, 5},
		{"(*Signature).Variadic", Method, 5},
		{"(*Slice).Elem", Method, 5},
		{"(*Slice).String", Method, 5},
		{"(*Slice).Underlying", Method, 5},
		{"(*StdSizes).Alignof", Method, 5},
		{"(*StdSizes).Offsetsof", Method, 5},
		{"(*StdSizes).Sizeof", Method, 5},
		{"(*Struct).Field", Method, 5},
		{"(*Struct).Fields", Method, 24},
		{"(*Struct).NumFields", Method, 5},
		{"(*Struct).String", Method, 5},
		{"(*Struct).Tag", Method, 5},
		{"(*Struct).Underlying", Method, 5},
		{"(*Term).String", Method, 18},
		{"(*Term).Tilde", Method, 18},
		{"(*Term).Type", Method, 18},
		{"(*Tuple).At", Method, 5},
		{"(*Tuple).Len", Method, 5},
		{"(*Tuple).String", Method, 5},
		{"(*Tuple).Underlying", Method, 5},
		{"(*Tuple).Variables", Method, 24},
		{"(*TypeList).At", Method, 18},
		{"(*TypeList).Len", Method, 18},
		{"(*TypeList).Types", Method, 24},
		{"(*TypeName).Exported", Method, 5},
		{"(*TypeName).Id", Method, 5},
		{"(*TypeName).IsAlias", Method, 9},
		{"(*TypeName).Name", Method, 5},
		{"(*TypeName).Parent", Method, 5},
		{"(*TypeName).Pkg", Method, 5},
		{"(*TypeName).Pos", Method, 5},
		{"(*TypeName).String", Method, 5},
		{"(*TypeName).Type", Method, 5},
		{"(*TypeParam).Constraint", Method, 18},
		{"(*TypeParam).Index", Method, 18},
		{"(*TypeParam).Obj", Method, 18},
		{"(*TypeParam).SetConstraint", Method, 18},
		{"(*TypeParam).String", Method, 18},
		{"(*TypeParam).Underlying", Method, 18},
		{"(*TypeParamList).At", Method, 18},
		{"(*TypeParamList).Len", Method, 18},
		{"(*TypeParamList).TypeParams", Method, 24},
		{"(*Union).Len", Method, 18},
		{"(*Union).String", Method, 18},
		{"(*Union).Term", Method, 18},
		{"(*Union).Terms", Method, 24},
		{"(*Union).Underlying", Method, 18},
		{"(*Var).Anonymous", Method, 5},
		{"(*Var).Embedded", Method, 11},
		{"(*Var).Exported", Method, 5},
		{"(*Var).Id", Method, 5},
		{"(*Var).IsField", Method, 5},
		{"(*Var).Name", Method, 5},
		{"(*Var).Origin", Method, 19},
		{"(*Var).Parent", Method, 5},
		{"(*Var).Pkg", Method, 5},
		{"(*Var).Pos", Method, 5},
		{"(*Var).String", Method, 5},
		{"(*Var).Type", Method, 5},
		{"(Checker).ObjectOf", Method, 5},
		{"(Checker).PkgNameOf", Method, 22},
		{"(Checker).TypeOf", Method, 5},
		{"(Error).Error", Method, 5},
		{"(TypeAndValue).Addressable", Method, 5},
		{"(TypeAndValue).Assignable", Method, 5},
		{"(TypeAndValue).HasOk", Method, 5},
		{"(TypeAndValue).IsBuiltin", Method, 5},
		{"(TypeAndValue).IsNil", Method, 5},
		{"(TypeAndValue).IsType", Method, 5},
		{"(TypeAndValue).IsValue", Method, 5},
		{"(TypeAndValue).IsVoid", Method, 5},
		{"Alias", Type, 22},
		{"ArgumentError", Type, 18},
		{"ArgumentError.Err", Field, 18},
		{"ArgumentError.Index", Field, 18},
		{"Array", Type, 5},
		{"AssertableTo", Func, 5},
		{"AssignableTo", Func, 5},
		{"Basic", Type, 5},
		{"BasicInfo", Type, 5},
		{"BasicKind", Type, 5},
		{"Bool", Const, 5},
		{"Builtin", Type, 5},
		{"Byte", Const, 5},
		{"Chan", Type, 5},
		{"ChanDir", Type, 5},
		{"CheckExpr", Func, 13},
		{"Checker", Type, 5},
		{"Checker.Info", Field, 5},
		{"Comparable", Func, 5},
		{"Complex128", Const, 5},
		{"Complex64", Const, 5},
		{"Config", Type, 5},
		{"Config.Context", Field, 18},
		{"Config.DisableUnusedImportCheck", Field, 5},
		{"Config.Error", Field, 5},
		{"Config.FakeImportC", Field, 5},
		{"Config.GoVersion", Field, 18},
		{"Config.IgnoreFuncBodies", Field, 5},
		{"Config.Importer", Field, 5},
		{"Config.Sizes", Field, 5},
		{"Const", Type, 5},
		{"Context", Type, 18},
		{"ConvertibleTo", Func, 5},
		{"DefPredeclaredTestFuncs", Func, 5},
		{"Default", Func, 8},
		{"Error", Type, 5},
		{"Error.Fset", Field, 5},
		{"Error.Msg", Field, 5},
		{"Error.Pos", Field, 5},
		{"Error.Soft", Field, 5},
		{"Eval", Func, 5},
		{"ExprString", Func, 5},
		{"FieldVal", Const, 5},
		{"Float32", Const, 5},
		{"Float64", Const, 5},
		{"Func", Type, 5},
		{"Id", Func, 5},
		{"Identical", Func, 5},
		{"IdenticalIgnoreTags", Func, 8},
		{"Implements", Func, 5},
		{"ImportMode", Type, 6},
		{"Importer", Type, 5},
		{"ImporterFrom", Type, 6},
		{"Info", Type, 5},
		{"Info.Defs", Field, 5},
		{"Info.FileVersions", Field, 22},
		{"Info.Implicits", Field, 5},
		{"Info.InitOrder", Field, 5},
		{"Info.Instances", Field, 18},
		{"Info.Scopes", Field, 5},
		{"Info.Selections", Field, 5},
		{"Info.Types", Field, 5},
		{"Info.Uses", Field, 5},
		{"Initializer", Type, 5},
		{"Initializer.Lhs", Field, 5},
		{"Initializer.Rhs", Field, 5},
		{"Instance", Type, 18},
		{"Instance.Type", Field, 18},
		{"Instance.TypeArgs", Field, 18},
		{"Instantiate", Func, 18},
		{"Int", Const, 5},
		{"Int16", Const, 5},
		{"Int32", Const, 5},
		{"Int64", Const, 5},
		{"Int8", Const, 5},
		{"Interface", Type, 5},
		{"Invalid", Const, 5},
		{"IsBoolean", Const, 5},
		{"IsComplex", Const, 5},
		{"IsConstType", Const, 5},
		{"IsFloat", Const, 5},
		{"IsInteger", Const, 5},
		{"IsInterface", Func, 5},
		{"IsNumeric", Const, 5},
		{"IsOrdered", Const, 5},
		{"IsString", Const, 5},
		{"IsUnsigned", Const, 5},
		{"IsUntyped", Const, 5},
		{"Label", Type, 5},
		{"LookupFieldOrMethod", Func, 5},
		{"Map", Type, 5},
		{"MethodExpr", Const, 5},
		{"MethodSet", Type, 5},
		{"MethodVal", Const, 5},
		{"MissingMethod", Func, 5},
		{"Named", Type, 5},
		{"NewAlias", Func, 22},
		{"NewArray", Func, 5},
		{"NewChan", Func, 5},
		{"NewChecker", Func, 5},
		{"NewConst", Func, 5},
		{"NewContext", Func, 18},
		{"NewField", Func, 5},
		{"NewFunc", Func, 5},
		{"NewInterface", Func, 5},
		{"NewInterfaceType", Func, 11},
		{"NewLabel", Func, 5},
		{"NewMap", Func, 5},
		{"NewMethodSet", Func, 5},
		{"NewNamed", Func, 5},
		{"NewPackage", Func, 5},
		{"NewParam", Func, 5},
		{"NewPkgName", Func, 5},
		{"NewPointer", Func, 5},
		{"NewScope", Func, 5},
		{"NewSignature", Func, 5},
		{"NewSignatureType", Func, 18},
		{"NewSlice", Func, 5},
		{"NewStruct", Func, 5},
		{"NewTerm", Func, 18},
		{"NewTuple", Func, 5},
		{"NewTypeName", Func, 5},
		{"NewTypeParam", Func, 18},
		{"NewUnion", Func, 18},
		{"NewVar", Func, 5},
		{"Nil", Type, 5},
		{"Object", Type, 5},
		{"ObjectString", Func, 5},
		{"Package", Type, 5},
		{"PkgName", Type, 5},
		{"Pointer", Type, 5},
		{"Qualifier", Type, 5},
		{"RecvOnly", Const, 5},
		{"RelativeTo", Func, 5},
		{"Rune", Const, 5},
		{"Satisfies", Func, 20},
		{"Scope", Type, 5},
		{"Selection", Type, 5},
		{"SelectionKind", Type, 5},
		{"SelectionString", Func, 5},
		{"SendOnly", Const, 5},
		{"SendRecv", Const, 5},
		{"Signature", Type, 5},
		{"Sizes", Type, 5},
		{"SizesFor", Func, 9},
		{"Slice", Type, 5},
		{"StdSizes", Type, 5},
		{"StdSizes.MaxAlign", Field, 5},
		{"StdSizes.WordSize", Field, 5},
		{"String", Const, 5},
		{"Struct", Type, 5},
		{"Term", Type, 18},
		{"Tuple", Type, 5},
		{"Typ", Var, 5},
		{"Type", Type, 5},
		{"TypeAndValue", Type, 5},
		{"TypeAndValue.Type", Field, 5},
		{"TypeAndValue.Value", Field, 5},
		{"TypeList", Type, 18},
		{"TypeName", Type, 5},
		{"TypeParam", Type, 18},
		{"TypeParamList", Type, 18},
		{"TypeString", Func, 5},
		{"Uint", Const, 5},
		{"Uint16", Const, 5},
		{"Uint32", Const, 5},
		{"Uint64", Const, 5},
		{"Uint8", Const, 5},
		{"Uintptr", Const, 5},
		{"Unalias", Func, 22},
		{"Union", Type, 18},
		{"Universe", Var, 5},
		{"Unsafe", Var, 5},
		{"UnsafePointer", Const, 5},
		{"UntypedBool", Const, 5},
		{"UntypedComplex", Const, 5},
		{"UntypedFloat", Const, 5},
		{"UntypedInt", Const, 5},
		{"UntypedNil", Const, 5},
		{"UntypedRune", Const, 5},
		{"UntypedString", Const, 5},
		{"Var", Type, 5},
		{"WriteExpr", Func, 5},
		{"WriteSignature", Func, 5},
		{"WriteType", Func, 5},
	},
	"go/version": {
		{"Compare", Func, 22},
		{"IsValid", Func, 22},
		{"Lang", Func, 22},
	},
	"hash": {
		{"Hash", Type, 0},
		{"Hash32", Type, 0},
		{"Hash64", Type, 0},
	},
	"hash/adler32": {
		{"Checksum", Func, 0},
		{"New", Func, 0},
		{"Size", Const, 0},
	},
	"hash/crc32": {
		{"Castagnoli", Const, 0},
		{"Checksum", Func, 0},
		{"ChecksumIEEE", Func, 0},
		{"IEEE", Const, 0},
		{"IEEETable", Var, 0},
		{"Koopman", Const, 0},
		{"MakeTable", Func, 0},
		{"New", Func, 0},
		{"NewIEEE", Func, 0},
		{"Size", Const, 0},
		{"Table", Type, 0},
		{"Update", Func, 0},
	},
	"hash/crc64": {
		{"Checksum", Func, 0},
		{"ECMA", Const, 0},
		{"ISO", Const, 0},
		{"MakeTable", Func, 0},
		{"New", Func, 0},
		{"Size", Const, 0},
		{"Table", Type, 0},
		{"Update", Func, 0},
	},
	"hash/fnv": {
		{"New128", Func, 9},
		{"New128a", Func, 9},
		{"New32", Func, 0},
		{"New32a", Func, 0},
		{"New64", Func, 0},
		{"New64a", Func, 0},
	},
	"hash/maphash": {
		{"(*Hash).BlockSize", Method, 14},
		{"(*Hash).Reset", Method, 14},
		{"(*Hash).Seed", Method, 14},
		{"(*Hash).SetSeed", Method, 14},
		{"(*Hash).Size", Method, 14},
		{"(*Hash).Sum", Method, 14},
		{"(*Hash).Sum64", Method, 14},
		{"(*Hash).Write", Method, 14},
		{"(*Hash).WriteByte", Method, 14},
		{"(*Hash).WriteString", Method, 14},
		{"Bytes", Func, 19},
		{"Comparable", Func, 24},
		{"Hash", Type, 14},
		{"MakeSeed", Func, 14},
		{"Seed", Type, 14},
		{"String", Func, 19},
		{"WriteComparable", Func, 24},
	},
	"html": {
		{"EscapeString", Func, 0},
		{"UnescapeString", Func, 0},
	},
	"html/template": {
		{"(*Error).Error", Method, 0},
		{"(*Template).AddParseTree", Method, 0},
		{"(*Template).Clone", Method, 0},
		{"(*Template).DefinedTemplates", Method, 6},
		{"(*Template).Delims", Method, 0},
		{"(*Template).Execute", Method, 0},
		{"(*Template).ExecuteTemplate", Method, 0},
		{"(*Template).Funcs", Method, 0},
		{"(*Template).Lookup", Method, 0},
		{"(*Template).Name", Method, 0},
		{"(*Template).New", Method, 0},
		{"(*Template).Option", Method, 5},
		{"(*Template).Parse", Method, 0},
		{"(*Template).ParseFS", Method, 16},
		{"(*Template).ParseFiles", Method, 0},
		{"(*Template).ParseGlob", Method, 0},
		{"(*Template).Templates", Method, 0},
		{"CSS", Type, 0},
		{"ErrAmbigContext", Const, 0},
		{"ErrBadHTML", Const, 0},
		{"ErrBranchEnd", Const, 0},
		{"ErrEndContext", Const, 0},
		{"ErrJSTemplate", Const, 21},
		{"ErrNoSuchTemplate", Const, 0},
		{"ErrOutputContext", Const, 0},
		{"ErrPartialCharset", Const, 0},
		{"ErrPartialEscape", Const, 0},
		{"ErrPredefinedEscaper", Const, 9},
		{"ErrRangeLoopReentry", Const, 0},
		{"ErrSlashAmbig", Const, 0},
		{"Error", Type, 0},
		{"Error.Description", Field, 0},
		{"Error.ErrorCode", Field, 0},
		{"Error.Line", Field, 0},
		{"Error.Name", Field, 0},
		{"Error.Node", Field, 4},
		{"ErrorCode", Type, 0},
		{"FuncMap", Type, 0},
		{"HTML", Type, 0},
		{"HTMLAttr", Type, 0},
		{"HTMLEscape", Func, 0},
		{"HTMLEscapeString", Func, 0},
		{"HTMLEscaper", Func, 0},
		{"IsTrue", Func, 6},
		{"JS", Type, 0},
		{"JSEscape", Func, 0},
		{"JSEscapeString", Func, 0},
		{"JSEscaper", Func, 0},
		{"JSStr", Type, 0},
		{"Must", Func, 0},
		{"New", Func, 0},
		{"OK", Const, 0},
		{"ParseFS", Func, 16},
		{"ParseFiles", Func, 0},
		{"ParseGlob", Func, 0},
		{"Srcset", Type, 10},
		{"Template", Type, 0},
		{"Template.Tree", Field, 2},
		{"URL", Type, 0},
		{"URLQueryEscaper", Func, 0},
	},
	"image": {
		{"(*Alpha).AlphaAt", Method, 4},
		{"(*Alpha).At", Method, 0},
		{"(*Alpha).Bounds", Method, 0},
		{"(*Alpha).ColorModel", Method, 0},
		{"(*Alpha).Opaque", Method, 0},
		{"(*Alpha).PixOffset", Method, 0},
		{"(*Alpha).RGBA64At", Method, 17},
		{"(*Alpha).Set", Method, 0},
		{"(*Alpha).SetAlpha", Method, 0},
		{"(*Alpha).SetRGBA64", Method, 17},
		{"(*Alpha).SubImage", Method, 0},
		{"(*Alpha16).Alpha16At", Method, 4},
		{"(*Alpha16).At", Method, 0},
		{"(*Alpha16).Bounds", Method, 0},
		{"(*Alpha16).ColorModel", Method, 0},
		{"(*Alpha16).Opaque", Method, 0},
		{"(*Alpha16).PixOffset", Method, 0},
		{"(*Alpha16).RGBA64At", Method, 17},
		{"(*Alpha16).Set", Method, 0},
		{"(*Alpha16).SetAlpha16", Method, 0},
		{"(*Alpha16).SetRGBA64", Method, 17},
		{"(*Alpha16).SubImage", Method, 0},
		{"(*CMYK).At", Method, 5},
		{"(*CMYK).Bounds", Method, 5},
		{"(*CMYK).CMYKAt", Method, 5},
		{"(*CMYK).ColorModel", Method, 5},
		{"(*CMYK).Opaque", Method, 5},
		{"(*CMYK).PixOffset", Method, 5},
		{"(*CMYK).RGBA64At", Method, 17},
		{"(*CMYK).Set", Method, 5},
		{"(*CMYK).SetCMYK", Method, 5},
		{"(*CMYK).SetRGBA64", Method, 17},
		{"(*CMYK).SubImage", Method, 5},
		{"(*Gray).At", Method, 0},
		{"(*Gray).Bounds", Method, 0},
		{"(*Gray).ColorModel", Method, 0},
		{"(*Gray).GrayAt", Method, 4},
		{"(*Gray).Opaque", Method, 0},
		{"(*Gray).PixOffset", Method, 0},
		{"(*Gray).RGBA64At", Method, 17},
		{"(*Gray).Set", Method, 0},
		{"(*Gray).SetGray", Method, 0},
		{"(*Gray).SetRGBA64", Method, 17},
		{"(*Gray).SubImage", Method, 0},
		{"(*Gray16).At", Method, 0},
		{"(*Gray16).Bounds", Method, 0},
		{"(*Gray16).ColorModel", Method, 0},
		{"(*Gray16).Gray16At", Method, 4},
		{"(*Gray16).Opaque", Method, 0},
		{"(*Gray16).PixOffset", Method, 0},
		{"(*Gray16).RGBA64At", Method, 17},
		{"(*Gray16).Set", Method, 0},
		{"(*Gray16).SetGray16", Method, 0},
		{"(*Gray16).SetRGBA64", Method, 17},
		{"(*Gray16).SubImage", Method, 0},
		{"(*NRGBA).At", Method, 0},
		{"(*NRGBA).Bounds", Method, 0},
		{"(*NRGBA).ColorModel", Method, 0},
		{"(*NRGBA).NRGBAAt", Method, 4},
		{"(*NRGBA).Opaque", Method, 0},
		{"(*NRGBA).PixOffset", Method, 0},
		{"(*NRGBA).RGBA64At", Method, 17},
		{"(*NRGBA).Set", Method, 0},
		{"(*NRGBA).SetNRGBA", Method, 0},
		{"(*NRGBA).SetRGBA64", Method, 17},
		{"(*NRGBA).SubImage", Method, 0},
		{"(*NRGBA64).At", Method, 0},
		{"(*NRGBA64).Bounds", Method, 0},
		{"(*NRGBA64).ColorModel", Method, 0},
		{"(*NRGBA64).NRGBA64At", Method, 4},
		{"(*NRGBA64).Opaque", Method, 0},
		{"(*NRGBA64).PixOffset", Method, 0},
		{"(*NRGBA64).RGBA64At", Method, 17},
		{"(*NRGBA64).Set", Method, 0},
		{"(*NRGBA64).SetNRGBA64", Method, 0},
		{"(*NRGBA64).SetRGBA64", Method, 17},
		{"(*NRGBA64).SubImage", Method, 0},
		{"(*NYCbCrA).AOffset", Method, 6},
		{"(*NYCbCrA).At", Method, 6},
		{"(*NYCbCrA).Bounds", Method, 6},
		{"(*NYCbCrA).COffset", Method, 6},
		{"(*NYCbCrA).ColorModel", Method, 6},
		{"(*NYCbCrA).NYCbCrAAt", Method, 6},
		{"(*NYCbCrA).Opaque", Method, 6},
		{"(*NYCbCrA).RGBA64At", Method, 17},
		{"(*NYCbCrA).SubImage", Method, 6},
		{"(*NYCbCrA).YCbCrAt", Method, 6},
		{"(*NYCbCrA).YOffset", Method, 6},
		{"(*Paletted).At", Method, 0},
		{"(*Paletted).Bounds", Method, 0},
		{"(*Paletted).ColorIndexAt", Method, 0},
		{"(*Paletted).ColorModel", Method, 0},
		{"(*Paletted).Opaque", Method, 0},
		{"(*Paletted).PixOffset", Method, 0},
		{"(*Paletted).RGBA64At", Method, 17},
		{"(*Paletted).Set", Method, 0},
		{"(*Paletted).SetColorIndex", Method, 0},
		{"(*Paletted).SetRGBA64", Method, 17},
		{"(*Paletted).SubImage", Method, 0},
		{"(*RGBA).At", Method, 0},
		{"(*RGBA).Bounds", Method, 0},
		{"(*RGBA).ColorModel", Method, 0},
		{"(*RGBA).Opaque", Method, 0},
		{"(*RGBA).PixOffset", Method, 0},
		{"(*RGBA).RGBA64At", Method, 17},
		{"(*RGBA).RGBAAt", Method, 4},
		{"(*RGBA).Set", Method, 0},
		{"(*RGBA).SetRGBA", Method, 0},
		{"(*RGBA).SetRGBA64", Method, 17},
		{"(*RGBA).SubImage", Method, 0},
		{"(*RGBA64).At", Method, 0},
		{"(*RGBA64).Bounds", Method, 0},
		{"(*RGBA64).ColorModel", Method, 0},
		{"(*RGBA64).Opaque", Method, 0},
		{"(*RGBA64).PixOffset", Method, 0},
		{"(*RGBA64).RGBA64At", Method, 4},
		{"(*RGBA64).Set", Method, 0},
		{"(*RGBA64).SetRGBA64", Method, 0},
		{"(*RGBA64).SubImage", Method, 0},
		{"(*Uniform).At", Method, 0},
		{"(*Uniform).Bounds", Method, 0},
		{"(*Uniform).ColorModel", Method, 0},
		{"(*Uniform).Convert", Method, 0},
		{"(*Uniform).Opaque", Method, 0},
		{"(*Uniform).RGBA", Method, 0},
		{"(*Uniform).RGBA64At", Method, 17},
		{"(*YCbCr).At", Method, 0},
		{"(*YCbCr).Bounds", Method, 0},
		{"(*YCbCr).COffset", Method, 0},
		{"(*YCbCr).ColorModel", Method, 0},
		{"(*YCbCr).Opaque", Method, 0},
		{"(*YCbCr).RGBA64At", Method, 17},
		{"(*YCbCr).SubImage", Method, 0},
		{"(*YCbCr).YCbCrAt", Method, 4},
		{"(*YCbCr).YOffset", Method, 0},
		{"(Point).Add", Method, 0},
		{"(Point).Div", Method, 0},
		{"(Point).Eq", Method, 0},
		{"(Point).In", Method, 0},
		{"(Point).Mod", Method, 0},
		{"(Point).Mul", Method, 0},
		{"(Point).String", Method, 0},
		{"(Point).Sub", Method, 0},
		{"(Rectangle).Add", Method, 0},
		{"(Rectangle).At", Method, 5},
		{"(Rectangle).Bounds", Method, 5},
		{"(Rectangle).Canon", Method, 0},
		{"(Rectangle).ColorModel", Method, 5},
		{"(Rectangle).Dx", Method, 0},
		{"(Rectangle).Dy", Method, 0},
		{"(Rectangle).Empty", Method, 0},
		{"(Rectangle).Eq", Method, 0},
		{"(Rectangle).In", Method, 0},
		{"(Rectangle).Inset", Method, 0},
		{"(Rectangle).Intersect", Method, 0},
		{"(Rectangle).Overlaps", Method, 0},
		{"(Rectangle).RGBA64At", Method, 17},
		{"(Rectangle).Size", Method, 0},
		{"(Rectangle).String", Method, 0},
		{"(Rectangle).Sub", Method, 0},
		{"(Rectangle).Union", Method, 0},
		{"(YCbCrSubsampleRatio).String", Method, 0},
		{"Alpha", Type, 0},
		{"Alpha.Pix", Field, 0},
		{"Alpha.Rect", Field, 0},
		{"Alpha.Stride", Field, 0},
		{"Alpha16", Type, 0},
		{"Alpha16.Pix", Field, 0},
		{"Alpha16.Rect", Field, 0},
		{"Alpha16.Stride", Field, 0},
		{"Black", Var, 0},
		{"CMYK", Type, 5},
		{"CMYK.Pix", Field, 5},
		{"CMYK.Rect", Field, 5},
		{"CMYK.Stride", Field, 5},
		{"Config", Type, 0},
		{"Config.ColorModel", Field, 0},
		{"Config.Height", Field, 0},
		{"Config.Width", Field, 0},
		{"Decode", Func, 0},
		{"DecodeConfig", Func, 0},
		{"ErrFormat", Var, 0},
		{"Gray", Type, 0},
		{"Gray.Pix", Field, 0},
		{"Gray.Rect", Field, 0},
		{"Gray.Stride", Field, 0},
		{"Gray16", Type, 0},
		{"Gray16.Pix", Field, 0},
		{"Gray16.Rect", Field, 0},
		{"Gray16.Stride", Field, 0},
		{"Image", Type, 0},
		{"NRGBA", Type, 0},
		{"NRGBA.Pix", Field, 0},
		{"NRGBA.Rect", Field, 0},
		{"NRGBA.Stride", Field, 0},
		{"NRGBA64", Type, 0},
		{"NRGBA64.Pix", Field, 0},
		{"NRGBA64.Rect", Field, 0},
		{"NRGBA64.Stride", Field, 0},
		{"NYCbCrA", Type, 6},
		{"NYCbCrA.A", Field, 6},
		{"NYCbCrA.AStride", Field, 6},
		{"NYCbCrA.YCbCr", Field, 6},
		{"NewAlpha", Func, 0},
		{"NewAlpha16", Func, 0},
		{"NewCMYK", Func, 5},
		{"NewGray", Func, 0},
		{"NewGray16", Func, 0},
		{"NewNRGBA", Func, 0},
		{"NewNRGBA64", Func, 0},
		{"NewNYCbCrA", Func, 6},
		{"NewPaletted", Func, 0},
		{"NewRGBA", Func, 0},
		{"NewRGBA64", Func, 0},
		{"NewUniform", Func, 0},
		{"NewYCbCr", Func, 0},
		{"Opaque", Var, 0},
		{"Paletted", Type, 0},
		{"Paletted.Palette", Field, 0},
		{"Paletted.Pix", Field, 0},
		{"Paletted.Rect", Field, 0},
		{"Paletted.Stride", Field, 0},
		{"PalettedImage", Type, 0},
		{"Point", Type, 0},
		{"Point.X", Field, 0},
		{"Point.Y", Field, 0},
		{"Pt", Func, 0},
		{"RGBA", Type, 0},
		{"RGBA.Pix", Field, 0},
		{"RGBA.Rect", Field, 0},
		{"RGBA.Stride", Field, 0},
		{"RGBA64", Type, 0},
		{"RGBA64.Pix", Field, 0},
		{"RGBA64.Rect", Field, 0},
		{"RGBA64.Stride", Field, 0},
		{"RGBA64Image", Type, 17},
		{"Rect", Func, 0},
		{"Rectangle", Type, 0},
		{"Rectangle.Max", Field, 0},
		{"Rectangle.Min", Field, 0},
		{"RegisterFormat", Func, 0},
		{"Transparent", Var, 0},
		{"Uniform", Type, 0},
		{"Uniform.C", Field, 0},
		{"White", Var, 0},
		{"YCbCr", Type, 0},
		{"YCbCr.CStride", Field, 0},
		{"YCbCr.Cb", Field, 0},
		{"YCbCr.Cr", Field, 0},
		{"YCbCr.Rect", Field, 0},
		{"YCbCr.SubsampleRatio", Field, 0},
		{"YCbCr.Y", Field, 0},
		{"YCbCr.YStride", Field, 0},
		{"YCbCrSubsampleRatio", Type, 0},
		{"YCbCrSubsampleRatio410", Const, 5},
		{"YCbCrSubsampleRatio411", Const, 5},
		{"YCbCrSubsampleRatio420", Const, 0},
		{"YCbCrSubsampleRatio422", Const, 0},
		{"YCbCrSubsampleRatio440", Const, 1},
		{"YCbCrSubsampleRatio444", Const, 0},
		{"ZP", Var, 0},
		{"ZR", Var, 0},
	},
	"image/color": {
		{"(Alpha).RGBA", Method, 0},
		{"(Alpha16).RGBA", Method, 0},
		{"(CMYK).RGBA", Method, 5},
		{"(Gray).RGBA", Method, 0},
		{"(Gray16).RGBA", Method, 0},
		{"(NRGBA).RGBA", Method, 0},
		{"(NRGBA64).RGBA", Method, 0},
		{"(NYCbCrA).RGBA", Method, 6},
		{"(Palette).Convert", Method, 0},
		{"(Palette).Index", Method, 0},
		{"(RGBA).RGBA", Method, 0},
		{"(RGBA64).RGBA", Method, 0},
		{"(YCbCr).RGBA", Method, 0},
		{"Alpha", Type, 0},
		{"Alpha.A", Field, 0},
		{"Alpha16", Type, 0},
		{"Alpha16.A", Field, 0},
		{"Alpha16Model", Var, 0},
		{"AlphaModel", Var, 0},
		{"Black", Var, 0},
		{"CMYK", Type, 5},
		{"CMYK.C", Field, 5},
		{"CMYK.K", Field, 5},
		{"CMYK.M", Field, 5},
		{"CMYK.Y", Field, 5},
		{"CMYKModel", Var, 5},
		{"CMYKToRGB", Func, 5},
		{"Color", Type, 0},
		{"Gray", Type, 0},
		{"Gray.Y", Field, 0},
		{"Gray16", Type, 0},
		{"Gray16.Y", Field, 0},
		{"Gray16Model", Var, 0},
		{"GrayModel", Var, 0},
		{"Model", Type, 0},
		{"ModelFunc", Func, 0},
		{"NRGBA", Type, 0},
		{"NRGBA.A", Field, 0},
		{"NRGBA.B", Field, 0},
		{"NRGBA.G", Field, 0},
		{"NRGBA.R", Field, 0},
		{"NRGBA64", Type, 0},
		{"NRGBA64.A", Field, 0},
		{"NRGBA64.B", Field, 0},
		{"NRGBA64.G", Field, 0},
		{"NRGBA64.R", Field, 0},
		{"NRGBA64Model", Var, 0},
		{"NRGBAModel", Var, 0},
		{"NYCbCrA", Type, 6},
		{"NYCbCrA.A", Field, 6},
		{"NYCbCrA.YCbCr", Field, 6},
		{"NYCbCrAModel", Var, 6},
		{"Opaque", Var, 0},
		{"Palette", Type, 0},
		{"RGBA", Type, 0},
		{"RGBA.A", Field, 0},
		{"RGBA.B", Field, 0},
		{"RGBA.G", Field, 0},
		{"RGBA.R", Field, 0},
		{"RGBA64", Type, 0},
		{"RGBA64.A", Field, 0},
		{"RGBA64.B", Field, 0},
		{"RGBA64.G", Field, 0},
		{"RGBA64.R", Field, 0},
		{"RGBA64Model", Var, 0},
		{"RGBAModel", Var, 0},
		{"RGBToCMYK", Func, 5},
		{"RGBToYCbCr", Func, 0},
		{"Transparent", Var, 0},
		{"White", Var, 0},
		{"YCbCr", Type, 0},
		{"YCbCr.Cb", Field, 0},
		{"YCbCr.Cr", Field, 0},
		{"YCbCr.Y", Field, 0},
		{"YCbCrModel", Var, 0},
		{"YCbCrToRGB", Func, 0},
	},
	"image/color/palette": {
		{"Plan9", Var, 2},
		{"WebSafe", Var, 2},
	},
	"image/draw": {
		{"(Op).Draw", Method, 2},
		{"Draw", Func, 0},
		{"DrawMask", Func, 0},
		{"Drawer", Type, 2},
		{"FloydSteinberg", Var, 2},
		{"Image", Type, 0},
		{"Op", Type, 0},
		{"Over", Const, 0},
		{"Quantizer", Type, 2},
		{"RGBA64Image", Type, 17},
		{"Src", Const, 0},
	},
	"image/gif": {
		{"Decode", Func, 0},
		{"DecodeAll", Func, 0},
		{"DecodeConfig", Func, 0},
		{"DisposalBackground", Const, 5},
		{"DisposalNone", Const, 5},
		{"DisposalPrevious", Const, 5},
		{"Encode", Func, 2},
		{"EncodeAll", Func, 2},
		{"GIF", Type, 0},
		{"GIF.BackgroundIndex", Field, 5},
		{"GIF.Config", Field, 5},
		{"GIF.Delay", Field, 0},
		{"GIF.Disposal", Field, 5},
		{"GIF.Image", Field, 0},
		{"GIF.LoopCount", Field, 0},
		{"Options", Type, 2},
		{"Options.Drawer", Field, 2},
		{"Options.NumColors", Field, 2},
		{"Options.Quantizer", Field, 2},
	},
	"image/jpeg": {
		{"(FormatError).Error", Method, 0},
		{"(UnsupportedError).Error", Method, 0},
		{"Decode", Func, 0},
		{"DecodeConfig", Func, 0},
		{"DefaultQuality", Const, 0},
		{"Encode", Func, 0},
		{"FormatError", Type, 0},
		{"Options", Type, 0},
		{"Options.Quality", Field, 0},
		{"Reader", Type, 0},
		{"UnsupportedError", Type, 0},
	},
	"image/png": {
		{"(*Encoder).Encode", Method, 4},
		{"(FormatError).Error", Method, 0},
		{"(UnsupportedError).Error", Method, 0},
		{"BestCompression", Const, 4},
		{"BestSpeed", Const, 4},
		{"CompressionLevel", Type, 4},
		{"Decode", Func, 0},
		{"DecodeConfig", Func, 0},
		{"DefaultCompression", Const, 4},
		{"Encode", Func, 0},
		{"Encoder", Type, 4},
		{"Encoder.BufferPool", Field, 9},
		{"Encoder.CompressionLevel", Field, 4},
		{"EncoderBuffer", Type, 9},
		{"EncoderBufferPool", Type, 9},
		{"FormatError", Type, 0},
		{"NoCompression", Const, 4},
		{"UnsupportedError", Type, 0},
	},
	"index/suffixarray": {
		{"(*Index).Bytes", Method, 0},
		{"(*Index).FindAllIndex", Method, 0},
		{"(*Index).Lookup", Method, 0},
		{"(*Index).Read", Method, 0},
		{"(*Index).Write", Method, 0},
		{"Index", Type, 0},
		{"New", Func, 0},
	},
	"io": {
		{"(*LimitedReader).Read", Method, 0},
		{"(*OffsetWriter).Seek", Method, 20},
		{"(*OffsetWriter).Write", Method, 20},
		{"(*OffsetWriter).WriteAt", Method, 20},
		{"(*PipeReader).Close", Method, 0},
		{"(*PipeReader).CloseWithError", Method, 0},
		{"(*PipeReader).Read", Method, 0},
		{"(*PipeWriter).Close", Method, 0},
		{"(*PipeWriter).CloseWithError", Method, 0},
		{"(*PipeWriter).Write", Method, 0},
		{"(*SectionReader).Outer", Method, 22},
		{"(*SectionReader).Read", Method, 0},
		{"(*SectionReader).ReadAt", Method, 0},
		{"(*SectionReader).Seek", Method, 0},
		{"(*SectionReader).Size", Method, 0},
		{"ByteReader", Type, 0},
		{"ByteScanner", Type, 0},
		{"ByteWriter", Type, 1},
		{"Closer", Type, 0},
		{"Copy", Func, 0},
		{"CopyBuffer", Func, 5},
		{"CopyN", Func, 0},
		{"Discard", Var, 16},
		{"EOF", Var, 0},
		{"ErrClosedPipe", Var, 0},
		{"ErrNoProgress", Var, 1},
		{"ErrShortBuffer", Var, 0},
		{"ErrShortWrite", Var, 0},
		{"ErrUnexpectedEOF", Var, 0},
		{"LimitReader", Func, 0},
		{"LimitedReader", Type, 0},
		{"LimitedReader.N", Field, 0},
		{"LimitedReader.R", Field, 0},
		{"MultiReader", Func, 0},
		{"MultiWriter", Func, 0},
		{"NewOffsetWriter", Func, 20},
		{"NewSectionReader", Func, 0},
		{"NopCloser", Func, 16},
		{"OffsetWriter", Type, 20},
		{"Pipe", Func, 0},
		{"PipeReader", Type, 0},
		{"PipeWriter", Type, 0},
		{"ReadAll", Func, 16},
		{"ReadAtLeast", Func, 0},
		{"ReadCloser", Type, 0},
		{"ReadFull", Func, 0},
		{"ReadSeekCloser", Type, 16},
		{"ReadSeeker", Type, 0},
		{"ReadWriteCloser", Type, 0},
		{"ReadWriteSeeker", Type, 0},
		{"ReadWriter", Type, 0},
		{"Reader", Type, 0},
		{"ReaderAt", Type, 0},
		{"ReaderFrom", Type, 0},
		{"RuneReader", Type, 0},
		{"RuneScanner", Type, 0},
		{"SectionReader", Type, 0},
		{"SeekCurrent", Const, 7},
		{"SeekEnd", Const, 7},
		{"SeekStart", Const, 7},
		{"Seeker", Type, 0},
		{"StringWriter", Type, 12},
		{"TeeReader", Func, 0},
		{"WriteCloser", Type, 0},
		{"WriteSeeker", Type, 0},
		{"WriteString", Func, 0},
		{"Writer", Type, 0},
		{"WriterAt", Type, 0},
		{"WriterTo", Type, 0},
	},
	"io/fs": {
		{"(*PathError).Error", Method, 16},
		{"(*PathError).Timeout", Method, 16},
		{"(*PathError).Unwrap", Method, 16},
		{"(FileMode).IsDir", Method, 16},
		{"(FileMode).IsRegular", Method, 16},
		{"(FileMode).Perm", Method, 16},
		{"(FileMode).String", Method, 16},
		{"(FileMode).Type", Method, 16},
		{"DirEntry", Type, 16},
		{"ErrClosed", Var, 16},
		{"ErrExist", Var, 16},
		{"ErrInvalid", Var, 16},
		{"ErrNotExist", Var, 16},
		{"ErrPermission", Var, 16},
		{"FS", Type, 16},
		{"File", Type, 16},
		{"FileInfo", Type, 16},
		{"FileInfoToDirEntry", Func, 17},
		{"FileMode", Type, 16},
		{"FormatDirEntry", Func, 21},
		{"FormatFileInfo", Func, 21},
		{"Glob", Func, 16},
		{"GlobFS", Type, 16},
		{"ModeAppend", Const, 16},
		{"ModeCharDevice", Const, 16},
		{"ModeDevice", Const, 16},
		{"ModeDir", Const, 16},
		{"ModeExclusive", Const, 16},
		{"ModeIrregular", Const, 16},
		{"ModeNamedPipe", Const, 16},
		{"ModePerm", Const, 16},
		{"ModeSetgid", Const, 16},
		{"ModeSetuid", Const, 16},
		{"ModeSocket", Const, 16},
		{"ModeSticky", Const, 16},
		{"ModeSymlink", Const, 16},
		{"ModeTemporary", Const, 16},
		{"ModeType", Const, 16},
		{"PathError", Type, 16},
		{"PathError.Err", Field, 16},
		{"PathError.Op", Field, 16},
		{"PathError.Path", Field, 16},
		{"ReadDir", Func, 16},
		{"ReadDirFS", Type, 16},
		{"ReadDirFile", Type, 16},
		{"ReadFile", Func, 16},
		{"ReadFileFS", Type, 16},
		{"SkipAll", Var, 20},
		{"SkipDir", Var, 16},
		{"Stat", Func, 16},
		{"StatFS", Type, 16},
		{"Sub", Func, 16},
		{"SubFS", Type, 16},
		{"ValidPath", Func, 16},
		{"WalkDir", Func, 16},
		{"WalkDirFunc", Type, 16},
	},
	"io/ioutil": {
		{"Discard", Var, 0},
		{"NopCloser", Func, 0},
		{"ReadAll", Func, 0},
		{"ReadDir", Func, 0},
		{"ReadFile", Func, 0},
		{"TempDir", Func, 0},
		{"TempFile", Func, 0},
		{"WriteFile", Func, 0},
	},
	"iter": {
		{"Pull", Func, 23},
		{"Pull2", Func, 23},
		{"Seq", Type, 23},
		{"Seq2", Type, 23},
	},
	"log": {
		{"(*Logger).Fatal", Method, 0},
		{"(*Logger).Fatalf", Method, 0},
		{"(*Logger).Fatalln", Method, 0},
		{"(*Logger).Flags", Method, 0},
		{"(*Logger).Output", Method, 0},
		{"(*Logger).Panic", Method, 0},
		{"(*Logger).Panicf", Method, 0},
		{"(*Logger).Panicln", Method, 0},
		{"(*Logger).Prefix", Method, 0},
		{"(*Logger).Print", Method, 0},
		{"(*Logger).Printf", Method, 0},
		{"(*Logger).Println", Method, 0},
		{"(*Logger).SetFlags", Method, 0},
		{"(*Logger).SetOutput", Method, 5},
		{"(*Logger).SetPrefix", Method, 0},
		{"(*Logger).Writer", Method, 12},
		{"Default", Func, 16},
		{"Fatal", Func, 0},
		{"Fatalf", Func, 0},
		{"Fatalln", Func, 0},
		{"Flags", Func, 0},
		{"LUTC", Const, 5},
		{"Ldate", Const, 0},
		{"Llongfile", Const, 0},
		{"Lmicroseconds", Const, 0},
		{"Lmsgprefix", Const, 14},
		{"Logger", Type, 0},
		{"Lshortfile", Const, 0},
		{"LstdFlags", Const, 0},
		{"Ltime", Const, 0},
		{"New", Func, 0},
		{"Output", Func, 5},
		{"Panic", Func, 0},
		{"Panicf", Func, 0},
		{"Panicln", Func, 0},
		{"Prefix", Func, 0},
		{"Print", Func, 0},
		{"Printf", Func, 0},
		{"Println", Func, 0},
		{"SetFlags", Func, 0},
		{"SetOutput", Func, 0},
		{"SetPrefix", Func, 0},
		{"Writer", Func, 13},
	},
	"log/slog": {
		{"(*JSONHandler).Enabled", Method, 21},
		{"(*JSONHandler).Handle", Method, 21},
		{"(*JSONHandler).WithAttrs", Method, 21},
		{"(*JSONHandler).WithGroup", Method, 21},
		{"(*Level).UnmarshalJSON", Method, 21},
		{"(*Level).UnmarshalText", Method, 21},
		{"(*LevelVar).AppendText", Method, 24},
		{"(*LevelVar).Level", Method, 21},
		{"(*LevelVar).MarshalText", Method, 21},
		{"(*LevelVar).Set", Method, 21},
		{"(*LevelVar).String", Method, 21},
		{"(*LevelVar).UnmarshalText", Method, 21},
		{"(*Logger).Debug", Method, 21},
		{"(*Logger).DebugContext", Method, 21},
		{"(*Logger).Enabled", Method, 21},
		{"(*Logger).Error", Method, 21},
		{"(*Logger).ErrorContext", Method, 21},
		{"(*Logger).Handler", Method, 21},
		{"(*Logger).Info", Method, 21},
		{"(*Logger).InfoContext", Method, 21},
		{"(*Logger).Log", Method, 21},
		{"(*Logger).LogAttrs", Method, 21},
		{"(*Logger).Warn", Method, 21},
		{"(*Logger).WarnContext", Method, 21},
		{"(*Logger).With", Method, 21},
		{"(*Logger).WithGroup", Method, 21},
		{"(*Record).Add", Method, 21},
		{"(*Record).AddAttrs", Method, 21},
		{"(*TextHandler).Enabled", Method, 21},
		{"(*TextHandler).Handle", Method, 21},
		{"(*TextHandler).WithAttrs", Method, 21},
		{"(*TextHandler).WithGroup", Method, 21},
		{"(Attr).Equal", Method, 21},
		{"(Attr).String", Method, 21},
		{"(Kind).String", Method, 21},
		{"(Level).AppendText", Method, 24},
		{"(Level).Level", Method, 21},
		{"(Level).MarshalJSON", Method, 21},
		{"(Level).MarshalText", Method, 21},
		{"(Level).String", Method, 21},
		{"(Record).Attrs", Method, 21},
		{"(Record).Clone", Method, 21},
		{"(Record).NumAttrs", Method, 21},
		{"(Value).Any", Method, 21},
		{"(Value).Bool", Method, 21},
		{"(Value).Duration", Method, 21},
		{"(Value).Equal", Method, 21},
		{"(Value).Float64", Method, 21},
		{"(Value).Group", Method, 21},
		{"(Value).Int64", Method, 21},
		{"(Value).Kind", Method, 21},
		{"(Value).LogValuer", Method, 21},
		{"(Value).Resolve", Method, 21},
		{"(Value).String", Method, 21},
		{"(Value).Time", Method, 21},
		{"(Value).Uint64", Method, 21},
		{"Any", Func, 21},
		{"AnyValue", Func, 21},
		{"Attr", Type, 21},
		{"Attr.Key", Field, 21},
		{"Attr.Value", Field, 21},
		{"Bool", Func, 21},
		{"BoolValue", Func, 21},
		{"Debug", Func, 21},
		{"DebugContext", Func, 21},
		{"Default", Func, 21},
		{"DiscardHandler", Var, 24},
		{"Duration", Func, 21},
		{"DurationValue", Func, 21},
		{"Error", Func, 21},
		{"ErrorContext", Func, 21},
		{"Float64", Func, 21},
		{"Float64Value", Func, 21},
		{"Group", Func, 21},
		{"GroupValue", Func, 21},
		{"Handler", Type, 21},
		{"HandlerOptions", Type, 21},
		{"HandlerOptions.AddSource", Field, 21},
		{"HandlerOptions.Level", Field, 21},
		{"HandlerOptions.ReplaceAttr", Field, 21},
		{"Info", Func, 21},
		{"InfoContext", Func, 21},
		{"Int", Func, 21},
		{"Int64", Func, 21},
		{"Int64Value", Func, 21},
		{"IntValue", Func, 21},
		{"JSONHandler", Type, 21},
		{"Kind", Type, 21},
		{"KindAny", Const, 21},
		{"KindBool", Const, 21},
		{"KindDuration", Const, 21},
		{"KindFloat64", Const, 21},
		{"KindGroup", Const, 21},
		{"KindInt64", Const, 21},
		{"KindLogValuer", Const, 21},
		{"KindString", Const, 21},
		{"KindTime", Const, 21},
		{"KindUint64", Const, 21},
		{"Level", Type, 21},
		{"LevelDebug", Const, 21},
		{"LevelError", Const, 21},
		{"LevelInfo", Const, 21},
		{"LevelKey", Const, 21},
		{"LevelVar", Type, 21},
		{"LevelWarn", Const, 21},
		{"Leveler", Type, 21},
		{"Log", Func, 21},
		{"LogAttrs", Func, 21},
		{"LogValuer", Type, 21},
		{"Logger", Type, 21},
		{"MessageKey", Const, 21},
		{"New", Func, 21},
		{"NewJSONHandler", Func, 21},
		{"NewLogLogger", Func, 21},
		{"NewRecord", Func, 21},
		{"NewTextHandler", Func, 21},
		{"Record", Type, 21},
		{"Record.Level", Field, 21},
		{"Record.Message", Field, 21},
		{"Record.PC", Field, 21},
		{"Record.Time", Field, 21},
		{"SetDefault", Func, 21},
		{"SetLogLoggerLevel", Func, 22},
		{"Source", Type, 21},
		{"Source.File", Field, 21},
		{"Source.Function", Field, 21},
		{"Source.Line", Field, 21},
		{"SourceKey", Const, 21},
		{"String", Func, 21},
		{"StringValue", Func, 21},
		{"TextHandler", Type, 21},
		{"Time", Func, 21},
		{"TimeKey", Const, 21},
		{"TimeValue", Func, 21},
		{"Uint64", Func, 21},
		{"Uint64Value", Func, 21},
		{"Value", Type, 21},
		{"Warn", Func, 21},
		{"WarnContext", Func, 21},
		{"With", Func, 21},
	},
	"log/syslog": {
		{"(*Writer).Alert", Method, 0},
		{"(*Writer).Close", Method, 0},
		{"(*Writer).Crit", Method, 0},
		{"(*Writer).Debug", Method, 0},
		{"(*Writer).Emerg", Method, 0},
		{"(*Writer).Err", Method, 0},
		{"(*Writer).Info", Method, 0},
		{"(*Writer).Notice", Method, 0},
		{"(*Writer).Warning", Method, 0},
		{"(*Writer).Write", Method, 0},
		{"Dial", Func, 0},
		{"LOG_ALERT", Const, 0},
		{"LOG_AUTH", Const, 1},
		{"LOG_AUTHPRIV", Const, 1},
		{"LOG_CRIT", Const, 0},
		{"LOG_CRON", Const, 1},
		{"LOG_DAEMON", Const, 1},
		{"LOG_DEBUG", Const, 0},
		{"LOG_EMERG", Const, 0},
		{"LOG_ERR", Const, 0},
		{"LOG_FTP", Const, 1},
		{"LOG_INFO", Const, 0},
		{"LOG_KERN", Const, 1},
		{"LOG_LOCAL0", Const, 1},
		{"LOG_LOCAL1", Const, 1},
		{"LOG_LOCAL2", Const, 1},
		{"LOG_LOCAL3", Const, 1},
		{"LOG_LOCAL4", Const, 1},
		{"LOG_LOCAL5", Const, 1},
		{"LOG_LOCAL6", Const, 1},
		{"LOG_LOCAL7", Const, 1},
		{"LOG_LPR", Const, 1},
		{"LOG_MAIL", Const, 1},
		{"LOG_NEWS", Const, 1},
		{"LOG_NOTICE", Const, 0},
		{"LOG_SYSLOG", Const, 1},
		{"LOG_USER", Const, 1},
		{"LOG_UUCP", Const, 1},
		{"LOG_WARNING", Const, 0},
		{"New", Func, 0},
		{"NewLogger", Func, 0},
		{"Priority", Type, 0},
		{"Writer", Type, 0},
	},
	"maps": {
		{"All", Func, 23},
		{"Clone", Func, 21},
		{"Collect", Func, 23},
		{"Copy", Func, 21},
		{"DeleteFunc", Func, 21},
		{"Equal", Func, 21},
		{"EqualFunc", Func, 21},
		{"Insert", Func, 23},
		{"Keys", Func, 23},
		{"Values", Func, 23},
	},
	"math": {
		{"Abs", Func, 0},
		{"Acos", Func, 0},
		{"Acosh", Func, 0},
		{"Asin", Func, 0},
		{"Asinh", Func, 0},
		{"Atan", Func, 0},
		{"Atan2", Func, 0},
		{"Atanh", Func, 0},
		{"Cbrt", Func, 0},
		{"Ceil", Func, 0},
		{"Copysign", Func, 0},
		{"Cos", Func, 0},
		{"Cosh", Func, 0},
		{"Dim", Func, 0},
		{"E", Const, 0},
		{"Erf", Func, 0},
		{"Erfc", Func, 0},
		{"Erfcinv", Func, 10},
		{"Erfinv", Func, 10},
		{"Exp", Func, 0},
		{"Exp2", Func, 0},
		{"Expm1", Func, 0},
		{"FMA", Func, 14},
		{"Float32bits", Func, 0},
		{"Float32frombits", Func, 0},
		{"Float64bits", Func, 0},
		{"Float64frombits", Func, 0},
		{"Floor", Func, 0},
		{"Frexp", Func, 0},
		{"Gamma", Func, 0},
		{"Hypot", Func, 0},
		{"Ilogb", Func, 0},
		{"Inf", Func, 0},
		{"IsInf", Func, 0},
		{"IsNaN", Func, 0},
		{"J0", Func, 0},
		{"J1", Func, 0},
		{"Jn", Func, 0},
		{"Ldexp", Func, 0},
		{"Lgamma", Func, 0},
		{"Ln10", Const, 0},
		{"Ln2", Const, 0},
		{"Log", Func, 0},
		{"Log10", Func, 0},
		{"Log10E", Const, 0},
		{"Log1p", Func, 0},
		{"Log2", Func, 0},
		{"Log2E", Const, 0},
		{"Logb", Func, 0},
		{"Max", Func, 0},
		{"MaxFloat32", Const, 0},
		{"MaxFloat64", Const, 0},
		{"MaxInt", Const, 17},
		{"MaxInt16", Const, 0},
		{"MaxInt32", Const, 0},
		{"MaxInt64", Const, 0},
		{"MaxInt8", Const, 0},
		{"MaxUint", Const, 17},
		{"MaxUint16", Const, 0},
		{"MaxUint32", Const, 0},
		{"MaxUint64", Const, 0},
		{"MaxUint8", Const, 0},
		{"Min", Func, 0},
		{"MinInt", Const, 17},
		{"MinInt16", Const, 0},
		{"MinInt32", Const, 0},
		{"MinInt64", Const, 0},
		{"MinInt8", Const, 0},
		{"Mod", Func, 0},
		{"Modf", Func, 0},
		{"NaN", Func, 0},
		{"Nextafter", Func, 0},
		{"Nextafter32", Func, 4},
		{"Phi", Const, 0},
		{"Pi", Const, 0},
		{"Pow", Func, 0},
		{"Pow10", Func, 0},
		{"Remainder", Func, 0},
		{"Round", Func, 10},
		{"RoundToEven", Func, 10},
		{"Signbit", Func, 0},
		{"Sin", Func, 0},
		{"Sincos", Func, 0},
		{"Sinh", Func, 0},
		{"SmallestNonzeroFloat32", Const, 0},
		{"SmallestNonzeroFloat64", Const, 0},
		{"Sqrt", Func, 0},
		{"Sqrt2", Const, 0},
		{"SqrtE", Const, 0},
		{"SqrtPhi", Const, 0},
		{"SqrtPi", Const, 0},
		{"Tan", Func, 0},
		{"Tanh", Func, 0},
		{"Trunc", Func, 0},
		{"Y0", Func, 0},
		{"Y1", Func, 0},
		{"Yn", Func, 0},
	},
	"math/big": {
		{"(*Float).Abs", Method, 5},
		{"(*Float).Acc", Method, 5},
		{"(*Float).Add", Method, 5},
		{"(*Float).Append", Method, 5},
		{"(*Float).AppendText", Method, 24},
		{"(*Float).Cmp", Method, 5},
		{"(*Float).Copy", Method, 5},
		{"(*Float).Float32", Method, 5},
		{"(*Float).Float64", Method, 5},
		{"(*Float).Format", Method, 5},
		{"(*Float).GobDecode", Method, 7},
		{"(*Float).GobEncode", Method, 7},
		{"(*Float).Int", Method, 5},
		{"(*Float).Int64", Method, 5},
		{"(*Float).IsInf", Method, 5},
		{"(*Float).IsInt", Method, 5},
		{"(*Float).MantExp", Method, 5},
		{"(*Float).MarshalText", Method, 6},
		{"(*Float).MinPrec", Method, 5},
		{"(*Float).Mode", Method, 5},
		{"(*Float).Mul", Method, 5},
		{"(*Float).Neg", Method, 5},
		{"(*Float).Parse", Method, 5},
		{"(*Float).Prec", Method, 5},
		{"(*Float).Quo", Method, 5},
		{"(*Float).Rat", Method, 5},
		{"(*Float).Scan", Method, 8},
		{"(*Float).Set", Method, 5},
		{"(*Float).SetFloat64", Method, 5},
		{"(*Float).SetInf", Method, 5},
		{"(*Float).SetInt", Method, 5},
		{"(*Float).SetInt64", Method, 5},
		{"(*Float).SetMantExp", Method, 5},
		{"(*Float).SetMode", Method, 5},
		{"(*Float).SetPrec", Method, 5},
		{"(*Float).SetRat", Method, 5},
		{"(*Float).SetString", Method, 5},
		{"(*Float).SetUint64", Method, 5},
		{"(*Float).Sign", Method, 5},
		{"(*Float).Signbit", Method, 5},
		{"(*Float).Sqrt", Method, 10},
		{"(*Float).String", Method, 5},
		{"(*Float).Sub", Method, 5},
		{"(*Float).Text", Method, 5},
		{"(*Float).Uint64", Method, 5},
		{"(*Float).UnmarshalText", Method, 6},
		{"(*Int).Abs", Method, 0},
		{"(*Int).Add", Method, 0},
		{"(*Int).And", Method, 0},
		{"(*Int).AndNot", Method, 0},
		{"(*Int).Append", Method, 6},
		{"(*Int).AppendText", Method, 24},
		{"(*Int).Binomial", Method, 0},
		{"(*Int).Bit", Method, 0},
		{"(*Int).BitLen", Method, 0},
		{"(*Int).Bits", Method, 0},
		{"(*Int).Bytes", Method, 0},
		{"(*Int).Cmp", Method, 0},
		{"(*Int).CmpAbs", Method, 10},
		{"(*Int).Div", Method, 0},
		{"(*Int).DivMod", Method, 0},
		{"(*Int).Exp", Method, 0},
		{"(*Int).FillBytes", Method, 15},
		{"(*Int).Float64", Method, 21},
		{"(*Int).Format", Method, 0},
		{"(*Int).GCD", Method, 0},
		{"(*Int).GobDecode", Method, 0},
		{"(*Int).GobEncode", Method, 0},
		{"(*Int).Int64", Method, 0},
		{"(*Int).IsInt64", Method, 9},
		{"(*Int).IsUint64", Method, 9},
		{"(*Int).Lsh", Method, 0},
		{"(*Int).MarshalJSON", Method, 1},
		{"(*Int).MarshalText", Method, 3},
		{"(*Int).Mod", Method, 0},
		{"(*Int).ModInverse", Method, 0},
		{"(*Int).ModSqrt", Method, 5},
		{"(*Int).Mul", Method, 0},
		{"(*Int).MulRange", Method, 0},
		{"(*Int).Neg", Method, 0},
		{"(*Int).Not", Method, 0},
		{"(*Int).Or", Method, 0},
		{"(*Int).ProbablyPrime", Method, 0},
		{"(*Int).Quo", Method, 0},
		{"(*Int).QuoRem", Method, 0},
		{"(*Int).Rand", Method, 0},
		{"(*Int).Rem", Method, 0},
		{"(*Int).Rsh", Method, 0},
		{"(*Int).Scan", Method, 0},
		{"(*Int).Set", Method, 0},
		{"(*Int).SetBit", Method, 0},
		{"(*Int).SetBits", Method, 0},
		{"(*Int).SetBytes", Method, 0},
		{"(*Int).SetInt64", Method, 0},
		{"(*Int).SetString", Method, 0},
		{"(*Int).SetUint64", Method, 1},
		{"(*Int).Sign", Method, 0},
		{"(*Int).Sqrt", Method, 8},
		{"(*Int).String", Method, 0},
		{"(*Int).Sub", Method, 0},
		{"(*Int).Text", Method, 6},
		{"(*Int).TrailingZeroBits", Method, 13},
		{"(*Int).Uint64", Method, 1},
		{"(*Int).UnmarshalJSON", Method, 1},
		{"(*Int).UnmarshalText", Method, 3},
		{"(*Int).Xor", Method, 0},
		{"(*Rat).Abs", Method, 0},
		{"(*Rat).Add", Method, 0},
		{"(*Rat).AppendText", Method, 24},
		{"(*Rat).Cmp", Method, 0},
		{"(*Rat).Denom", Method, 0},
		{"(*Rat).Float32", Method, 4},
		{"(*Rat).Float64", Method, 1},
		{"(*Rat).FloatPrec", Method, 22},
		{"(*Rat).FloatString", Method, 0},
		{"(*Rat).GobDecode", Method, 0},
		{"(*Rat).GobEncode", Method, 0},
		{"(*Rat).Inv", Method, 0},
		{"(*Rat).IsInt", Method, 0},
		{"(*Rat).MarshalText", Method, 3},
		{"(*Rat).Mul", Method, 0},
		{"(*Rat).Neg", Method, 0},
		{"(*Rat).Num", Method, 0},
		{"(*Rat).Quo", Method, 0},
		{"(*Rat).RatString", Method, 0},
		{"(*Rat).Scan", Method, 0},
		{"(*Rat).Set", Method, 0},
		{"(*Rat).SetFloat64", Method, 1},
		{"(*Rat).SetFrac", Method, 0},
		{"(*Rat).SetFrac64", Method, 0},
		{"(*Rat).SetInt", Method, 0},
		{"(*Rat).SetInt64", Method, 0},
		{"(*Rat).SetString", Method, 0},
		{"(*Rat).SetUint64", Method, 13},
		{"(*Rat).Sign", Method, 0},
		{"(*Rat).String", Method, 0},
		{"(*Rat).Sub", Method, 0},
		{"(*Rat).UnmarshalText", Method, 3},
		{"(Accuracy).String", Method, 5},
		{"(ErrNaN).Error", Method, 5},
		{"(RoundingMode).String", Method, 5},
		{"Above", Const, 5},
		{"Accuracy", Type, 5},
		{"AwayFromZero", Const, 5},
		{"Below", Const, 5},
		{"ErrNaN", Type, 5},
		{"Exact", Const, 5},
		{"Float", Type, 5},
		{"Int", Type, 0},
		{"Jacobi", Func, 5},
		{"MaxBase", Const, 0},
		{"MaxExp", Const, 5},
		{"MaxPrec", Const, 5},
		{"MinExp", Const, 5},
		{"NewFloat", Func, 5},
		{"NewInt", Func, 0},
		{"NewRat", Func, 0},
		{"ParseFloat", Func, 5},
		{"Rat", Type, 0},
		{"RoundingMode", Type, 5},
		{"ToNearestAway", Const, 5},
		{"ToNearestEven", Const, 5},
		{"ToNegativeInf", Const, 5},
		{"ToPositiveInf", Const, 5},
		{"ToZero", Const, 5},
		{"Word", Type, 0},
	},
	"math/bits": {
		{"Add", Func, 12},
		{"Add32", Func, 12},
		{"Add64", Func, 12},
		{"Div", Func, 12},
		{"Div32", Func, 12},
		{"Div64", Func, 12},
		{"LeadingZeros", Func, 9},
		{"LeadingZeros16", Func, 9},
		{"LeadingZeros32", Func, 9},
		{"LeadingZeros64", Func, 9},
		{"LeadingZeros8", Func, 9},
		{"Len", Func, 9},
		{"Len16", Func, 9},
		{"Len32", Func, 9},
		{"Len64", Func, 9},
		{"Len8", Func, 9},
		{"Mul", Func, 12},
		{"Mul32", Func, 12},
		{"Mul64", Func, 12},
		{"OnesCount", Func, 9},
		{"OnesCount16", Func, 9},
		{"OnesCount32", Func, 9},
		{"OnesCount64", Func, 9},
		{"OnesCount8", Func, 9},
		{"Rem", Func, 14},
		{"Rem32", Func, 14},
		{"Rem64", Func, 14},
		{"Reverse", Func, 9},
		{"Reverse16", Func, 9},
		{"Reverse32", Func, 9},
		{"Reverse64", Func, 9},
		{"Reverse8", Func, 9},
		{"ReverseBytes", Func, 9},
		{"ReverseBytes16", Func, 9},
		{"ReverseBytes32", Func, 9},
		{"ReverseBytes64", Func, 9},
		{"RotateLeft", Func, 9},
		{"RotateLeft16", Func, 9},
		{"RotateLeft32", Func, 9},
		{"RotateLeft64", Func, 9},
		{"RotateLeft8", Func, 9},
		{"Sub", Func, 12},
		{"Sub32", Func, 12},
		{"Sub64", Func, 12},
		{"TrailingZeros", Func, 9},
		{"TrailingZeros16", Func, 9},
		{"TrailingZeros32", Func, 9},
		{"TrailingZeros64", Func, 9},
		{"TrailingZeros8", Func, 9},
		{"UintSize", Const, 9},
	},
	"math/cmplx": {
		{"Abs", Func, 0},
		{"Acos", Func, 0},
		{"Acosh", Func, 0},
		{"Asin", Func, 0},
		{"Asinh", Func, 0},
		{"Atan", Func, 0},
		{"Atanh", Func, 0},
		{"Conj", Func, 0},
		{"Cos", Func, 0},
		{"Cosh", Func, 0},
		{"Cot", Func, 0},
		{"Exp", Func, 0},
		{"Inf", Func, 0},
		{"IsInf", Func, 0},
		{"IsNaN", Func, 0},
		{"Log", Func, 0},
		{"Log10", Func, 0},
		{"NaN", Func, 0},
		{"Phase", Func, 0},
		{"Polar", Func, 0},
		{"Pow", Func, 0},
		{"Rect", Func, 0},
		{"Sin", Func, 0},
		{"Sinh", Func, 0},
		{"Sqrt", Func, 0},
		{"Tan", Func, 0},
		{"Tanh", Func, 0},
	},
	"math/rand": {
		{"(*Rand).ExpFloat64", Method, 0},
		{"(*Rand).Float32", Method, 0},
		{"(*Rand).Float64", Method, 0},
		{"(*Rand).Int", Method, 0},
		{"(*Rand).Int31", Method, 0},
		{"(*Rand).Int31n", Method, 0},
		{"(*Rand).Int63", Method, 0},
		{"(*Rand).Int63n", Method, 0},
		{"(*Rand).Intn", Method, 0},
		{"(*Rand).NormFloat64", Method, 0},
		{"(*Rand).Perm", Method, 0},
		{"(*Rand).Read", Method, 6},
		{"(*Rand).Seed", Method, 0},
		{"(*Rand).Shuffle", Method, 10},
		{"(*Rand).Uint32", Method, 0},
		{"(*Rand).Uint64", Method, 8},
		{"(*Zipf).Uint64", Method, 0},
		{"ExpFloat64", Func, 0},
		{"Float32", Func, 0},
		{"Float64", Func, 0},
		{"Int", Func, 0},
		{"Int31", Func, 0},
		{"Int31n", Func, 0},
		{"Int63", Func, 0},
		{"Int63n", Func, 0},
		{"Intn", Func, 0},
		{"New", Func, 0},
		{"NewSource", Func, 0},
		{"NewZipf", Func, 0},
		{"NormFloat64", Func, 0},
		{"Perm", Func, 0},
		{"Rand", Type, 0},
		{"Read", Func, 6},
		{"Seed", Func, 0},
		{"Shuffle", Func, 10},
		{"Source", Type, 0},
		{"Source64", Type, 8},
		{"Uint32", Func, 0},
		{"Uint64", Func, 8},
		{"Zipf", Type, 0},
	},
	"math/rand/v2": {
		{"(*ChaCha8).AppendBinary", Method, 24},
		{"(*ChaCha8).MarshalBinary", Method, 22},
		{"(*ChaCha8).Read", Method, 23},
		{"(*ChaCha8).Seed", Method, 22},
		{"(*ChaCha8).Uint64", Method, 22},
		{"(*ChaCha8).UnmarshalBinary", Method, 22},
		{"(*PCG).AppendBinary", Method, 24},
		{"(*PCG).MarshalBinary", Method, 22},
		{"(*PCG).Seed", Method, 22},
		{"(*PCG).Uint64", Method, 22},
		{"(*PCG).UnmarshalBinary", Method, 22},
		{"(*Rand).ExpFloat64", Method, 22},
		{"(*Rand).Float32", Method, 22},
		{"(*Rand).Float64", Method, 22},
		{"(*Rand).Int", Method, 22},
		{"(*Rand).Int32", Method, 22},
		{"(*Rand).Int32N", Method, 22},
		{"(*Rand).Int64", Method, 22},
		{"(*Rand).Int64N", Method, 22},
		{"(*Rand).IntN", Method, 22},
		{"(*Rand).NormFloat64", Method, 22},
		{"(*Rand).Perm", Method, 22},
		{"(*Rand).Shuffle", Method, 22},
		{"(*Rand).Uint", Method, 23},
		{"(*Rand).Uint32", Method, 22},
		{"(*Rand).Uint32N", Method, 22},
		{"(*Rand).Uint64", Method, 22},
		{"(*Rand).Uint64N", Method, 22},
		{"(*Rand).UintN", Method, 22},
		{"(*Zipf).Uint64", Method, 22},
		{"ChaCha8", Type, 22},
		{"ExpFloat64", Func, 22},
		{"Float32", Func, 22},
		{"Float64", Func, 22},
		{"Int", Func, 22},
		{"Int32", Func, 22},
		{"Int32N", Func, 22},
		{"Int64", Func, 22},
		{"Int64N", Func, 22},
		{"IntN", Func, 22},
		{"N", Func, 22},
		{"New", Func, 22},
		{"NewChaCha8", Func, 22},
		{"NewPCG", Func, 22},
		{"NewZipf", Func, 22},
		{"NormFloat64", Func, 22},
		{"PCG", Type, 22},
		{"Perm", Func, 22},
		{"Rand", Type, 22},
		{"Shuffle", Func, 22},
		{"Source", Type, 22},
		{"Uint", Func, 23},
		{"Uint32", Func, 22},
		{"Uint32N", Func, 22},
		{"Uint64", Func, 22},
		{"Uint64N", Func, 22},
		{"UintN", Func, 22},
		{"Zipf", Type, 22},
	},
	"mime": {
		{"(*WordDecoder).Decode", Method, 5},
		{"(*WordDecoder).DecodeHeader", Method, 5},
		{"(WordEncoder).Encode", Method, 5},
		{"AddExtensionType", Func, 0},
		{"BEncoding", Const, 5},
		{"ErrInvalidMediaParameter", Var, 9},
		{"ExtensionsByType", Func, 5},
		{"FormatMediaType", Func, 0},
		{"ParseMediaType", Func, 0},
		{"QEncoding", Const, 5},
		{"TypeByExtension", Func, 0},
		{"WordDecoder", Type, 5},
		{"WordDecoder.CharsetReader", Field, 5},
		{"WordEncoder", Type, 5},
	},
	"mime/multipart": {
		{"(*FileHeader).Open", Method, 0},
		{"(*Form).RemoveAll", Method, 0},
		{"(*Part).Close", Method, 0},
		{"(*Part).FileName", Method, 0},
		{"(*Part).FormName", Method, 0},
		{"(*Part).Read", Method, 0},
		{"(*Reader).NextPart", Method, 0},
		{"(*Reader).NextRawPart", Method, 14},
		{"(*Reader).ReadForm", Method, 0},
		{"(*Writer).Boundary", Method, 0},
		{"(*Writer).Close", Method, 0},
		{"(*Writer).CreateFormField", Method, 0},
		{"(*Writer).CreateFormFile", Method, 0},
		{"(*Writer).CreatePart", Method, 0},
		{"(*Writer).FormDataContentType", Method, 0},
		{"(*Writer).SetBoundary", Method, 1},
		{"(*Writer).WriteField", Method, 0},
		{"ErrMessageTooLarge", Var, 9},
		{"File", Type, 0},
		{"FileHeader", Type, 0},
		{"FileHeader.Filename", Field, 0},
		{"FileHeader.Header", Field, 0},
		{"FileHeader.Size", Field, 9},
		{"Form", Type, 0},
		{"Form.File", Field, 0},
		{"Form.Value", Field, 0},
		{"NewReader", Func, 0},
		{"NewWriter", Func, 0},
		{"Part", Type, 0},
		{"Part.Header", Field, 0},
		{"Reader", Type, 0},
		{"Writer", Type, 0},
	},
	"mime/quotedprintable": {
		{"(*Reader).Read", Method, 5},
		{"(*Writer).Close", Method, 5},
		{"(*Writer).Write", Method, 5},
		{"NewReader", Func, 5},
		{"NewWriter", Func, 5},
		{"Reader", Type, 5},
		{"Writer", Type, 5},
		{"Writer.Binary", Field, 5},
	},
	"net": {
		{"(*AddrError).Error", Method, 0},
		{"(*AddrError).Temporary", Method, 0},
		{"(*AddrError).Timeout", Method, 0},
		{"(*Buffers).Read", Method, 8},
		{"(*Buffers).WriteTo", Method, 8},
		{"(*DNSConfigError).Error", Method, 0},
		{"(*DNSConfigError).Temporary", Method, 0},
		{"(*DNSConfigError).Timeout", Method, 0},
		{"(*DNSConfigError).Unwrap", Method, 13},
		{"(*DNSError).Error", Method, 0},
		{"(*DNSError).Temporary", Method, 0},
		{"(*DNSError).Timeout", Method, 0},
		{"(*DNSError).Unwrap", Method, 23},
		{"(*Dialer).Dial", Method, 1},
		{"(*Dialer).DialContext", Method, 7},
		{"(*Dialer).MultipathTCP", Method, 21},
		{"(*Dialer).SetMultipathTCP", Method, 21},
		{"(*IP).UnmarshalText", Method, 2},
		{"(*IPAddr).Network", Method, 0},
		{"(*IPAddr).String", Method, 0},
		{"(*IPConn).Close", Method, 0},
		{"(*IPConn).File", Method, 0},
		{"(*IPConn).LocalAddr", Method, 0},
		{"(*IPConn).Read", Method, 0},
		{"(*IPConn).ReadFrom", Method, 0},
		{"(*IPConn).ReadFromIP", Method, 0},
		{"(*IPConn).ReadMsgIP", Method, 1},
		{"(*IPConn).RemoteAddr", Method, 0},
		{"(*IPConn).SetDeadline", Method, 0},
		{"(*IPConn).SetReadBuffer", Method, 0},
		{"(*IPConn).SetReadDeadline", Method, 0},
		{"(*IPConn).SetWriteBuffer", Method, 0},
		{"(*IPConn).SetWriteDeadline", Method, 0},
		{"(*IPConn).SyscallConn", Method, 9},
		{"(*IPConn).Write", Method, 0},
		{"(*IPConn).WriteMsgIP", Method, 1},
		{"(*IPConn).WriteTo", Method, 0},
		{"(*IPConn).WriteToIP", Method, 0},
		{"(*IPNet).Contains", Method, 0},
		{"(*IPNet).Network", Method, 0},
		{"(*IPNet).String", Method, 0},
		{"(*Interface).Addrs", Method, 0},
		{"(*Interface).MulticastAddrs", Method, 0},
		{"(*ListenConfig).Listen", Method, 11},
		{"(*ListenConfig).ListenPacket", Method, 11},
		{"(*ListenConfig).MultipathTCP", Method, 21},
		{"(*ListenConfig).SetMultipathTCP", Method, 21},
		{"(*OpError).Error", Method, 0},
		{"(*OpError).Temporary", Method, 0},
		{"(*OpError).Timeout", Method, 0},
		{"(*OpError).Unwrap", Method, 13},
		{"(*ParseError).Error", Method, 0},
		{"(*ParseError).Temporary", Method, 17},
		{"(*ParseError).Timeout", Method, 17},
		{"(*Resolver).LookupAddr", Method, 8},
		{"(*Resolver).LookupCNAME", Method, 8},
		{"(*Resolver).LookupHost", Method, 8},
		{"(*Resolver).LookupIP", Method, 15},
		{"(*Resolver).LookupIPAddr", Method, 8},
		{"(*Resolver).LookupMX", Method, 8},
		{"(*Resolver).LookupNS", Method, 8},
		{"(*Resolver).LookupNetIP", Method, 18},
		{"(*Resolver).LookupPort", Method, 8},
		{"(*Resolver).LookupSRV", Method, 8},
		{"(*Resolver).LookupTXT", Method, 8},
		{"(*TCPAddr).AddrPort", Method, 18},
		{"(*TCPAddr).Network", Method, 0},
		{"(*TCPAddr).String", Method, 0},
		{"(*TCPConn).Close", Method, 0},
		{"(*TCPConn).CloseRead", Method, 0},
		{"(*TCPConn).CloseWrite", Method, 0},
		{"(*TCPConn).File", Method, 0},
		{"(*TCPConn).LocalAddr", Method, 0},
		{"(*TCPConn).MultipathTCP", Method, 21},
		{"(*TCPConn).Read", Method, 0},
		{"(*TCPConn).ReadFrom", Method, 0},
		{"(*TCPConn).RemoteAddr", Method, 0},
		{"(*TCPConn).SetDeadline", Method, 0},
		{"(*TCPConn).SetKeepAlive", Method, 0},
		{"(*TCPConn).SetKeepAliveConfig", Method, 23},
		{"(*TCPConn).SetKeepAlivePeriod", Method, 2},
		{"(*TCPConn).SetLinger", Method, 0},
		{"(*TCPConn).SetNoDelay", Method, 0},
		{"(*TCPConn).SetReadBuffer", Method, 0},
		{"(*TCPConn).SetReadDeadline", Method, 0},
		{"(*TCPConn).SetWriteBuffer", Method, 0},
		{"(*TCPConn).SetWriteDeadline", Method, 0},
		{"(*TCPConn).SyscallConn", Method, 9},
		{"(*TCPConn).Write", Method, 0},
		{"(*TCPConn).WriteTo", Method, 22},
		{"(*TCPListener).Accept", Method, 0},
		{"(*TCPListener).AcceptTCP", Method, 0},
		{"(*TCPListener).Addr", Method, 0},
		{"(*TCPListener).Close", Method, 0},
		{"(*TCPListener).File", Method, 0},
		{"(*TCPListener).SetDeadline", Method, 0},
		{"(*TCPListener).SyscallConn", Method, 10},
		{"(*UDPAddr).AddrPort", Method, 18},
		{"(*UDPAddr).Network", Method, 0},
		{"(*UDPAddr).String", Method, 0},
		{"(*UDPConn).Close", Method, 0},
		{"(*UDPConn).File", Method, 0},
		{"(*UDPConn).LocalAddr", Method, 0},
		{"(*UDPConn).Read", Method, 0},
		{"(*UDPConn).ReadFrom", Method, 0},
		{"(*UDPConn).ReadFromUDP", Method, 0},
		{"(*UDPConn).ReadFromUDPAddrPort", Method, 18},
		{"(*UDPConn).ReadMsgUDP", Method, 1},
		{"(*UDPConn).ReadMsgUDPAddrPort", Method, 18},
		{"(*UDPConn).RemoteAddr", Method, 0},
		{"(*UDPConn).SetDeadline", Method, 0},
		{"(*UDPConn).SetReadBuffer", Method, 0},
		{"(*UDPConn).SetReadDeadline", Method, 0},
		{"(*UDPConn).SetWriteBuffer", Method, 0},
		{"(*UDPConn).SetWriteDeadline", Method, 0},
		{"(*UDPConn).SyscallConn", Method, 9},
		{"(*UDPConn).Write", Method, 0},
		{"(*UDPConn).WriteMsgUDP", Method, 1},
		{"(*UDPConn).WriteMsgUDPAddrPort", Method, 18},
		{"(*UDPConn).WriteTo", Method, 0},
		{"(*UDPConn).WriteToUDP", Method, 0},
		{"(*UDPConn).WriteToUDPAddrPort", Method, 18},
		{"(*UnixAddr).Network", Method, 0},
		{"(*UnixAddr).String", Method, 0},
		{"(*UnixConn).Close", Method, 0},
		{"(*UnixConn).CloseRead", Method, 1},
		{"(*UnixConn).CloseWrite", Method, 1},
		{"(*UnixConn).File", Method, 0},
		{"(*UnixConn).LocalAddr", Method, 0},
		{"(*UnixConn).Read", Method, 0},
		{"(*UnixConn).ReadFrom", Method, 0},
		{"(*UnixConn).ReadFromUnix", Method, 0},
		{"(*UnixConn).ReadMsgUnix", Method, 0},
		{"(*UnixConn).RemoteAddr", Method, 0},
		{"(*UnixConn).SetDeadline", Method, 0},
		{"(*UnixConn).SetReadBuffer", Method, 0},
		{"(*UnixConn).SetReadDeadline", Method, 0},
		{"(*UnixConn).SetWriteBuffer", Method, 0},
		{"(*UnixConn).SetWriteDeadline", Method, 0},
		{"(*UnixConn).SyscallConn", Method, 9},
		{"(*UnixConn).Write", Method, 0},
		{"(*UnixConn).WriteMsgUnix", Method, 0},
		{"(*UnixConn).WriteTo", Method, 0},
		{"(*UnixConn).WriteToUnix", Method, 0},
		{"(*UnixListener).Accept", Method, 0},
		{"(*UnixListener).AcceptUnix", Method, 0},
		{"(*UnixListener).Addr", Method, 0},
		{"(*UnixListener).Close", Method, 0},
		{"(*UnixListener).File", Method, 0},
		{"(*UnixListener).SetDeadline", Method, 0},
		{"(*UnixListener).SetUnlinkOnClose", Method, 8},
		{"(*UnixListener).SyscallConn", Method, 10},
		{"(Flags).String", Method, 0},
		{"(HardwareAddr).String", Method, 0},
		{"(IP).AppendText", Method, 24},
		{"(IP).DefaultMask", Method, 0},
		{"(IP).Equal", Method, 0},
		{"(IP).IsGlobalUnicast", Method, 0},
		{"(IP).IsInterfaceLocalMulticast", Method, 0},
		{"(IP).IsLinkLocalMulticast", Method, 0},
		{"(IP).IsLinkLocalUnicast", Method, 0},
		{"(IP).IsLoopback", Method, 0},
		{"(IP).IsMulticast", Method, 0},
		{"(IP).IsPrivate", Method, 17},
		{"(IP).IsUnspecified", Method, 0},
		{"(IP).MarshalText", Method, 2},
		{"(IP).Mask", Method, 0},
		{"(IP).String", Method, 0},
		{"(IP).To16", Method, 0},
		{"(IP).To4", Method, 0},
		{"(IPMask).Size", Method, 0},
		{"(IPMask).String", Method, 0},
		{"(InvalidAddrError).Error", Method, 0},
		{"(InvalidAddrError).Temporary", Method, 0},
		{"(InvalidAddrError).Timeout", Method, 0},
		{"(UnknownNetworkError).Error", Method, 0},
		{"(UnknownNetworkError).Temporary", Method, 0},
		{"(UnknownNetworkError).Timeout", Method, 0},
		{"Addr", Type, 0},
		{"AddrError", Type, 0},
		{"AddrError.Addr", Field, 0},
		{"AddrError.Err", Field, 0},
		{"Buffers", Type, 8},
		{"CIDRMask", Func, 0},
		{"Conn", Type, 0},
		{"DNSConfigError", Type, 0},
		{"DNSConfigError.Err", Field, 0},
		{"DNSError", Type, 0},
		{"DNSError.Err", Field, 0},
		{"DNSError.IsNotFound", Field, 13},
		{"DNSError.IsTemporary", Field, 6},
		{"DNSError.IsTimeout", Field, 0},
		{"DNSError.Name", Field, 0},
		{"DNSError.Server", Field, 0},
		{"DNSError.UnwrapErr", Field, 23},
		{"DefaultResolver", Var, 8},
		{"Dial", Func, 0},
		{"DialIP", Func, 0},
		{"DialTCP", Func, 0},
		{"DialTimeout", Func, 0},
		{"DialUDP", Func, 0},
		{"DialUnix", Func, 0},
		{"Dialer", Type, 1},
		{"Dialer.Cancel", Field, 6},
		{"Dialer.Control", Field, 11},
		{"Dialer.ControlContext", Field, 20},
		{"Dialer.Deadline", Field, 1},
		{"Dialer.DualStack", Field, 2},
		{"Dialer.FallbackDelay", Field, 5},
		{"Dialer.KeepAlive", Field, 3},
		{"Dialer.KeepAliveConfig", Field, 23},
		{"Dialer.LocalAddr", Field, 1},
		{"Dialer.Resolver", Field, 8},
		{"Dialer.Timeout", Field, 1},
		{"ErrClosed", Var, 16},
		{"ErrWriteToConnected", Var, 0},
		{"Error", Type, 0},
		{"FileConn", Func, 0},
		{"FileListener", Func, 0},
		{"FilePacketConn", Func, 0},
		{"FlagBroadcast", Const, 0},
		{"FlagLoopback", Const, 0},
		{"FlagMulticast", Const, 0},
		{"FlagPointToPoint", Const, 0},
		{"FlagRunning", Const, 20},
		{"FlagUp", Const, 0},
		{"Flags", Type, 0},
		{"HardwareAddr", Type, 0},
		{"IP", Type, 0},
		{"IPAddr", Type, 0},
		{"IPAddr.IP", Field, 0},
		{"IPAddr.Zone", Field, 1},
		{"IPConn", Type, 0},
		{"IPMask", Type, 0},
		{"IPNet", Type, 0},
		{"IPNet.IP", Field, 0},
		{"IPNet.Mask", Field, 0},
		{"IPv4", Func, 0},
		{"IPv4Mask", Func, 0},
		{"IPv4allrouter", Var, 0},
		{"IPv4allsys", Var, 0},
		{"IPv4bcast", Var, 0},
		{"IPv4len", Const, 0},
		{"IPv4zero", Var, 0},
		{"IPv6interfacelocalallnodes", Var, 0},
		{"IPv6len", Const, 0},
		{"IPv6linklocalallnodes", Var, 0},
		{"IPv6linklocalallrouters", Var, 0},
		{"IPv6loopback", Var, 0},
		{"IPv6unspecified", Var, 0},
		{"IPv6zero", Var, 0},
		{"Interface", Type, 0},
		{"Interface.Flags", Field, 0},
		{"Interface.HardwareAddr", Field, 0},
		{"Interface.Index", Field, 0},
		{"Interface.MTU", Field, 0},
		{"Interface.Name", Field, 0},
		{"InterfaceAddrs", Func, 0},
		{"InterfaceByIndex", Func, 0},
		{"InterfaceByName", Func, 0},
		{"Interfaces", Func, 0},
		{"InvalidAddrError", Type, 0},
		{"JoinHostPort", Func, 0},
		{"KeepAliveConfig", Type, 23},
		{"KeepAliveConfig.Count", Field, 23},
		{"KeepAliveConfig.Enable", Field, 23},
		{"KeepAliveConfig.Idle", Field, 23},
		{"KeepAliveConfig.Interval", Field, 23},
		{"Listen", Func, 0},
		{"ListenConfig", Type, 11},
		{"ListenConfig.Control", Field, 11},
		{"ListenConfig.KeepAlive", Field, 13},
		{"ListenConfig.KeepAliveConfig", Field, 23},
		{"ListenIP", Func, 0},
		{"ListenMulticastUDP", Func, 0},
		{"ListenPacket", Func, 0},
		{"ListenTCP", Func, 0},
		{"ListenUDP", Func, 0},
		{"ListenUnix", Func, 0},
		{"ListenUnixgram", Func, 0},
		{"Listener", Type, 0},
		{"LookupAddr", Func, 0},
		{"LookupCNAME", Func, 0},
		{"LookupHost", Func, 0},
		{"LookupIP", Func, 0},
		{"LookupMX", Func, 0},
		{"LookupNS", Func, 1},
		{"LookupPort", Func, 0},
		{"LookupSRV", Func, 0},
		{"LookupTXT", Func, 0},
		{"MX", Type, 0},
		{"MX.Host", Field, 0},
		{"MX.Pref", Field, 0},
		{"NS", Type, 1},
		{"NS.Host", Field, 1},
		{"OpError", Type, 0},
		{"OpError.Addr", Field, 0},
		{"OpError.Err", Field, 0},
		{"OpError.Net", Field, 0},
		{"OpError.Op", Field, 0},
		{"OpError.Source", Field, 5},
		{"PacketConn", Type, 0},
		{"ParseCIDR", Func, 0},
		{"ParseError", Type, 0},
		{"ParseError.Text", Field, 0},
		{"ParseError.Type", Field, 0},
		{"ParseIP", Func, 0},
		{"ParseMAC", Func, 0},
		{"Pipe", Func, 0},
		{"ResolveIPAddr", Func, 0},
		{"ResolveTCPAddr", Func, 0},
		{"ResolveUDPAddr", Func, 0},
		{"ResolveUnixAddr", Func, 0},
		{"Resolver", Type, 8},
		{"Resolver.Dial", Field, 9},
		{"Resolver.PreferGo", Field, 8},
		{"Resolver.StrictErrors", Field, 9},
		{"SRV", Type, 0},
		{"SRV.Port", Field, 0},
		{"SRV.Priority", Field, 0},
		{"SRV.Target", Field, 0},
		{"SRV.Weight", Field, 0},
		{"SplitHostPort", Func, 0},
		{"TCPAddr", Type, 0},
		{"TCPAddr.IP", Field, 0},
		{"TCPAddr.Port", Field, 0},
		{"TCPAddr.Zone", Field, 1},
		{"TCPAddrFromAddrPort", Func, 18},
		{"TCPConn", Type, 0},
		{"TCPListener", Type, 0},
		{"UDPAddr", Type, 0},
		{"UDPAddr.IP", Field, 0},
		{"UDPAddr.Port", Field, 0},
		{"UDPAddr.Zone", Field, 1},
		{"UDPAddrFromAddrPort", Func, 18},
		{"UDPConn", Type, 0},
		{"UnixAddr", Type, 0},
		{"UnixAddr.Name", Field, 0},
		{"UnixAddr.Net", Field, 0},
		{"UnixConn", Type, 0},
		{"UnixListener", Type, 0},
		{"UnknownNetworkError", Type, 0},
	},
	"net/http": {
		{"(*Client).CloseIdleConnections", Method, 12},
		{"(*Client).Do", Method, 0},
		{"(*Client).Get", Method, 0},
		{"(*Client).Head", Method, 0},
		{"(*Client).Post", Method, 0},
		{"(*Client).PostForm", Method, 0},
		{"(*Cookie).String", Method, 0},
		{"(*Cookie).Valid", Method, 18},
		{"(*MaxBytesError).Error", Method, 19},
		{"(*ProtocolError).Error", Method, 0},
		{"(*ProtocolError).Is", Method, 21},
		{"(*Protocols).SetHTTP1", Method, 24},
		{"(*Protocols).SetHTTP2", Method, 24},
		{"(*Protocols).SetUnencryptedHTTP2", Method, 24},
		{"(*Request).AddCookie", Method, 0},
		{"(*Request).BasicAuth", Method, 4},
		{"(*Request).Clone", Method, 13},
		{"(*Request).Context", Method, 7},
		{"(*Request).Cookie", Method, 0},
		{"(*Request).Cookies", Method, 0},
		{"(*Request).CookiesNamed", Method, 23},
		{"(*Request).FormFile", Method, 0},
		{"(*Request).FormValue", Method, 0},
		{"(*Request).MultipartReader", Method, 0},
		{"(*Request).ParseForm", Method, 0},
		{"(*Request).ParseMultipartForm", Method, 0},
		{"(*Request).PathValue", Method, 22},
		{"(*Request).PostFormValue", Method, 1},
		{"(*Request).ProtoAtLeast", Method, 0},
		{"(*Request).Referer", Method, 0},
		{"(*Request).SetBasicAuth", Method, 0},
		{"(*Request).SetPathValue", Method, 22},
		{"(*Request).UserAgent", Method, 0},
		{"(*Request).WithContext", Method, 7},
		{"(*Request).Write", Method, 0},
		{"(*Request).WriteProxy", Method, 0},
		{"(*Response).Cookies", Method, 0},
		{"(*Response).Location", Method, 0},
		{"(*Response).ProtoAtLeast", Method, 0},
		{"(*Response).Write", Method, 0},
		{"(*ResponseController).EnableFullDuplex", Method, 21},
		{"(*ResponseController).Flush", Method, 20},
		{"(*ResponseController).Hijack", Method, 20},
		{"(*ResponseController).SetReadDeadline", Method, 20},
		{"(*ResponseController).SetWriteDeadline", Method, 20},
		{"(*ServeMux).Handle", Method, 0},
		{"(*ServeMux).HandleFunc", Method, 0},
		{"(*ServeMux).Handler", Method, 1},
		{"(*ServeMux).ServeHTTP", Method, 0},
		{"(*Server).Close", Method, 8},
		{"(*Server).ListenAndServe", Method, 0},
		{"(*Server).ListenAndServeTLS", Method, 0},
		{"(*Server).RegisterOnShutdown", Method, 9},
		{"(*Server).Serve", Method, 0},
		{"(*Server).ServeTLS", Method, 9},
		{"(*Server).SetKeepAlivesEnabled", Method, 3},
		{"(*Server).Shutdown", Method, 8},
		{"(*Transport).CancelRequest", Method, 1},
		{"(*Transport).Clone", Method, 13},
		{"(*Transport).CloseIdleConnections", Method, 0},
		{"(*Transport).RegisterProtocol", Method, 0},
		{"(*Transport).RoundTrip", Method, 0},
		{"(ConnState).String", Method, 3},
		{"(Dir).Open", Method, 0},
		{"(HandlerFunc).ServeHTTP", Method, 0},
		{"(Header).Add", Method, 0},
		{"(Header).Clone", Method, 13},
		{"(Header).Del", Method, 0},
		{"(Header).Get", Method, 0},
		{"(Header).Set", Method, 0},
		{"(Header).Values", Method, 14},
		{"(Header).Write", Method, 0},
		{"(Header).WriteSubset", Method, 0},
		{"(Protocols).HTTP1", Method, 24},
		{"(Protocols).HTTP2", Method, 24},
		{"(Protocols).String", Method, 24},
		{"(Protocols).UnencryptedHTTP2", Method, 24},
		{"AllowQuerySemicolons", Func, 17},
		{"CanonicalHeaderKey", Func, 0},
		{"Client", Type, 0},
		{"Client.CheckRedirect", Field, 0},
		{"Client.Jar", Field, 0},
		{"Client.Timeout", Field, 3},
		{"Client.Transport", Field, 0},
		{"CloseNotifier", Type, 1},
		{"ConnState", Type, 3},
		{"Cookie", Type, 0},
		{"Cookie.Domain", Field, 0},
		{"Cookie.Expires", Field, 0},
		{"Cookie.HttpOnly", Field, 0},
		{"Cookie.MaxAge", Field, 0},
		{"Cookie.Name", Field, 0},
		{"Cookie.Partitioned", Field, 23},
		{"Cookie.Path", Field, 0},
		{"Cookie.Quoted", Field, 23},
		{"Cookie.Raw", Field, 0},
		{"Cookie.RawExpires", Field, 0},
		{"Cookie.SameSite", Field, 11},
		{"Cookie.Secure", Field, 0},
		{"Cookie.Unparsed", Field, 0},
		{"Cookie.Value", Field, 0},
		{"CookieJar", Type, 0},
		{"DefaultClient", Var, 0},
		{"DefaultMaxHeaderBytes", Const, 0},
		{"DefaultMaxIdleConnsPerHost", Const, 0},
		{"DefaultServeMux", Var, 0},
		{"DefaultTransport", Var, 0},
		{"DetectContentType", Func, 0},
		{"Dir", Type, 0},
		{"ErrAbortHandler", Var, 8},
		{"ErrBodyNotAllowed", Var, 0},
		{"ErrBodyReadAfterClose", Var, 0},
		{"ErrContentLength", Var, 0},
		{"ErrHandlerTimeout", Var, 0},
		{"ErrHeaderTooLong", Var, 0},
		{"ErrHijacked", Var, 0},
		{"ErrLineTooLong", Var, 0},
		{"ErrMissingBoundary", Var, 0},
		{"ErrMissingContentLength", Var, 0},
		{"ErrMissingFile", Var, 0},
		{"ErrNoCookie", Var, 0},
		{"ErrNoLocation", Var, 0},
		{"ErrNotMultipart", Var, 0},
		{"ErrNotSupported", Var, 0},
		{"ErrSchemeMismatch", Var, 21},
		{"ErrServerClosed", Var, 8},
		{"ErrShortBody", Var, 0},
		{"ErrSkipAltProtocol", Var, 6},
		{"ErrUnexpectedTrailer", Var, 0},
		{"ErrUseLastResponse", Var, 7},
		{"ErrWriteAfterFlush", Var, 0},
		{"Error", Func, 0},
		{"FS", Func, 16},
		{"File", Type, 0},
		{"FileServer", Func, 0},
		{"FileServerFS", Func, 22},
		{"FileSystem", Type, 0},
		{"Flusher", Type, 0},
		{"Get", Func, 0},
		{"HTTP2Config", Type, 24},
		{"HTTP2Config.CountError", Field, 24},
		{"HTTP2Config.MaxConcurrentStreams", Field, 24},
		{"HTTP2Config.MaxDecoderHeaderTableSize", Field, 24},
		{"HTTP2Config.MaxEncoderHeaderTableSize", Field, 24},
		{"HTTP2Config.MaxReadFrameSize", Field, 24},
		{"HTTP2Config.MaxReceiveBufferPerConnection", Field, 24},
		{"HTTP2Config.MaxReceiveBufferPerStream", Field, 24},
		{"HTTP2Config.PermitProhibitedCipherSuites", Field, 24},
		{"HTTP2Config.PingTimeout", Field, 24},
		{"HTTP2Config.SendPingTimeout", Field, 24},
		{"HTTP2Config.WriteByteTimeout", Field, 24},
		{"Handle", Func, 0},
		{"HandleFunc", Func, 0},
		{"Handler", Type, 0},
		{"HandlerFunc", Type, 0},
		{"Head", Func, 0},
		{"Header", Type, 0},
		{"Hijacker", Type, 0},
		{"ListenAndServe", Func, 0},
		{"ListenAndServeTLS", Func, 0},
		{"LocalAddrContextKey", Var, 7},
		{"MaxBytesError", Type, 19},
		{"MaxBytesError.Limit", Field, 19},
		{"MaxBytesHandler", Func, 18},
		{"MaxBytesReader", Func, 0},
		{"MethodConnect", Const, 6},
		{"MethodDelete", Const, 6},
		{"MethodGet", Const, 6},
		{"MethodHead", Const, 6},
		{"MethodOptions", Const, 6},
		{"MethodPatch", Const, 6},
		{"MethodPost", Const, 6},
		{"MethodPut", Const, 6},
		{"MethodTrace", Const, 6},
		{"NewFileTransport", Func, 0},
		{"NewFileTransportFS", Func, 22},
		{"NewRequest", Func, 0},
		{"NewRequestWithContext", Func, 13},
		{"NewResponseController", Func, 20},
		{"NewServeMux", Func, 0},
		{"NoBody", Var, 8},
		{"NotFound", Func, 0},
		{"NotFoundHandler", Func, 0},
		{"ParseCookie", Func, 23},
		{"ParseHTTPVersion", Func, 0},
		{"ParseSetCookie", Func, 23},
		{"ParseTime", Func, 1},
		{"Post", Func, 0},
		{"PostForm", Func, 0},
		{"ProtocolError", Type, 0},
		{"ProtocolError.ErrorString", Field, 0},
		{"Protocols", Type, 24},
		{"ProxyFromEnvironment", Func, 0},
		{"ProxyURL", Func, 0},
		{"PushOptions", Type, 8},
		{"PushOptions.Header", Field, 8},
		{"PushOptions.Method", Field, 8},
		{"Pusher", Type, 8},
		{"ReadRequest", Func, 0},
		{"ReadResponse", Func, 0},
		{"Redirect", Func, 0},
		{"RedirectHandler", Func, 0},
		{"Request", Type, 0},
		{"Request.Body", Field, 0},
		{"Request.Cancel", Field, 5},
		{"Request.Close", Field, 0},
		{"Request.ContentLength", Field, 0},
		{"Request.Form", Field, 0},
		{"Request.GetBody", Field, 8},
		{"Request.Header", Field, 0},
		{"Request.Host", Field, 0},
		{"Request.Method", Field, 0},
		{"Request.MultipartForm", Field, 0},
		{"Request.Pattern", Field, 23},
		{"Request.PostForm", Field, 1},
		{"Request.Proto", Field, 0},
		{"Request.ProtoMajor", Field, 0},
		{"Request.ProtoMinor", Field, 0},
		{"Request.RemoteAddr", Field, 0},
		{"Request.RequestURI", Field, 0},
		{"Request.Response", Field, 7},
		{"Request.TLS", Field, 0},
		{"Request.Trailer", Field, 0},
		{"Request.TransferEncoding", Field, 0},
		{"Request.URL", Field, 0},
		{"Response", Type, 0},
		{"Response.Body", Field, 0},
		{"Response.Close", Field, 0},
		{"Response.ContentLength", Field, 0},
		{"Response.Header", Field, 0},
		{"Response.Proto", Field, 0},
		{"Response.ProtoMajor", Field, 0},
		{"Response.ProtoMinor", Field, 0},
		{"Response.Request", Field, 0},
		{"Response.Status", Field, 0},
		{"Response.StatusCode", Field, 0},
		{"Response.TLS", Field, 3},
		{"Response.Trailer", Field, 0},
		{"Response.TransferEncoding", Field, 0},
		{"Response.Uncompressed", Field, 7},
		{"ResponseController", Type, 20},
		{"ResponseWriter", Type, 0},
		{"RoundTripper", Type, 0},
		{"SameSite", Type, 11},
		{"SameSiteDefaultMode", Const, 11},
		{"SameSiteLaxMode", Const, 11},
		{"SameSiteNoneMode", Const, 13},
		{"SameSiteStrictMode", Const, 11},
		{"Serve", Func, 0},
		{"ServeContent", Func, 0},
		{"ServeFile", Func, 0},
		{"ServeFileFS", Func, 22},
		{"ServeMux", Type, 0},
		{"ServeTLS", Func, 9},
		{"Server", Type, 0},
		{"Server.Addr", Field, 0},
		{"Server.BaseContext", Field, 13},
		{"Server.ConnContext", Field, 13},
		{"Server.ConnState", Field, 3},
		{"Server.DisableGeneralOptionsHandler", Field, 20},
		{"Server.ErrorLog", Field, 3},
		{"Server.HTTP2", Field, 24},
		{"Server.Handler", Field, 0},
		{"Server.IdleTimeout", Field, 8},
		{"Server.MaxHeaderBytes", Field, 0},
		{"Server.Protocols", Field, 24},
		{"Server.ReadHeaderTimeout", Field, 8},
		{"Server.ReadTimeout", Field, 0},
		{"Server.TLSConfig", Field, 0},
		{"Server.TLSNextProto", Field, 1},
		{"Server.WriteTimeout", Field, 0},
		{"ServerContextKey", Var, 7},
		{"SetCookie", Func, 0},
		{"StateActive", Const, 3},
		{"StateClosed", Const, 3},
		{"StateHijacked", Const, 3},
		{"StateIdle", Const, 3},
		{"StateNew", Const, 3},
		{"StatusAccepted", Const, 0},
		{"StatusAlreadyReported", Const, 7},
		{"StatusBadGateway", Const, 0},
		{"StatusBadRequest", Const, 0},
		{"StatusConflict", Const, 0},
		{"StatusContinue", Const, 0},
		{"StatusCreated", Const, 0},
		{"StatusEarlyHints", Const, 13},
		{"StatusExpectationFailed", Const, 0},
		{"StatusFailedDependency", Const, 7},
		{"StatusForbidden", Const, 0},
		{"StatusFound", Const, 0},
		{"StatusGatewayTimeout", Const, 0},
		{"StatusGone", Const, 0},
		{"StatusHTTPVersionNotSupported", Const, 0},
		{"StatusIMUsed", Const, 7},
		{"StatusInsufficientStorage", Const, 7},
		{"StatusInternalServerError", Const, 0},
		{"StatusLengthRequired", Const, 0},
		{"StatusLocked", Const, 7},
		{"StatusLoopDetected", Const, 7},
		{"StatusMethodNotAllowed", Const, 0},
		{"StatusMisdirectedRequest", Const, 11},
		{"StatusMovedPermanently", Const, 0},
		{"StatusMultiStatus", Const, 7},
		{"StatusMultipleChoices", Const, 0},
		{"StatusNetworkAuthenticationRequired", Const, 6},
		{"StatusNoContent", Const, 0},
		{"StatusNonAuthoritativeInfo", Const, 0},
		{"StatusNotAcceptable", Const, 0},
		{"StatusNotExtended", Const, 7},
		{"StatusNotFound", Const, 0},
		{"StatusNotImplemented", Const, 0},
		{"StatusNotModified", Const, 0},
		{"StatusOK", Const, 0},
		{"StatusPartialContent", Const, 0},
		{"StatusPaymentRequired", Const, 0},
		{"StatusPermanentRedirect", Const, 7},
		{"StatusPreconditionFailed", Const, 0},
		{"StatusPreconditionRequired", Const, 6},
		{"StatusProcessing", Const, 7},
		{"StatusProxyAuthRequired", Const, 0},
		{"StatusRequestEntityTooLarge", Const, 0},
		{"StatusRequestHeaderFieldsTooLarge", Const, 6},
		{"StatusRequestTimeout", Const, 0},
		{"StatusRequestURITooLong", Const, 0},
		{"StatusRequestedRangeNotSatisfiable", Const, 0},
		{"StatusResetContent", Const, 0},
		{"StatusSeeOther", Const, 0},
		{"StatusServiceUnavailable", Const, 0},
		{"StatusSwitchingProtocols", Const, 0},
		{"StatusTeapot", Const, 0},
		{"StatusTemporaryRedirect", Const, 0},
		{"StatusText", Func, 0},
		{"StatusTooEarly", Const, 12},
		{"StatusTooManyRequests", Const, 6},
		{"StatusUnauthorized", Const, 0},
		{"StatusUnavailableForLegalReasons", Const, 6},
		{"StatusUnprocessableEntity", Const, 7},
		{"StatusUnsupportedMediaType", Const, 0},
		{"StatusUpgradeRequired", Const, 7},
		{"StatusUseProxy", Const, 0},
		{"StatusVariantAlsoNegotiates", Const, 7},
		{"StripPrefix", Func, 0},
		{"TimeFormat", Const, 0},
		{"TimeoutHandler", Func, 0},
		{"TrailerPrefix", Const, 8},
		{"Transport", Type, 0},
		{"Transport.Dial", Field, 0},
		{"Transport.DialContext", Field, 7},
		{"Transport.DialTLS", Field, 4},
		{"Transport.DialTLSContext", Field, 14},
		{"Transport.DisableCompression", Field, 0},
		{"Transport.DisableKeepAlives", Field, 0},
		{"Transport.ExpectContinueTimeout", Field, 6},
		{"Transport.ForceAttemptHTTP2", Field, 13},
		{"Transport.GetProxyConnectHeader", Field, 16},
		{"Transport.HTTP2", Field, 24},
		{"Transport.IdleConnTimeout", Field, 7},
		{"Transport.MaxConnsPerHost", Field, 11},
		{"Transport.MaxIdleConns", Field, 7},
		{"Transport.MaxIdleConnsPerHost", Field, 0},
		{"Transport.MaxResponseHeaderBytes", Field, 7},
		{"Transport.OnProxyConnectResponse", Field, 20},
		{"Transport.Protocols", Field, 24},
		{"Transport.Proxy", Field, 0},
		{"Transport.ProxyConnectHeader", Field, 8},
		{"Transport.ReadBufferSize", Field, 13},
		{"Transport.ResponseHeaderTimeout", Field, 1},
		{"Transport.TLSClientConfig", Field, 0},
		{"Transport.TLSHandshakeTimeout", Field, 3},
		{"Transport.TLSNextProto", Field, 6},
		{"Transport.WriteBufferSize", Field, 13},
	},
	"net/http/cgi": {
		{"(*Handler).ServeHTTP", Method, 0},
		{"Handler", Type, 0},
		{"Handler.Args", Field, 0},
		{"Handler.Dir", Field, 0},
		{"Handler.Env", Field, 0},
		{"Handler.InheritEnv", Field, 0},
		{"Handler.Logger", Field, 0},
		{"Handler.Path", Field, 0},
		{"Handler.PathLocationHandler", Field, 0},
		{"Handler.Root", Field, 0},
		{"Handler.Stderr", Field, 7},
		{"Request", Func, 0},
		{"RequestFromMap", Func, 0},
		{"Serve", Func, 0},
	},
	"net/http/cookiejar": {
		{"(*Jar).Cookies", Method, 1},
		{"(*Jar).SetCookies", Method, 1},
		{"Jar", Type, 1},
		{"New", Func, 1},
		{"Options", Type, 1},
		{"Options.PublicSuffixList", Field, 1},
		{"PublicSuffixList", Type, 1},
	},
	"net/http/fcgi": {
		{"ErrConnClosed", Var, 5},
		{"ErrRequestAborted", Var, 5},
		{"ProcessEnv", Func, 9},
		{"Serve", Func, 0},
	},
	"net/http/httptest": {
		{"(*ResponseRecorder).Flush", Method, 0},
		{"(*ResponseRecorder).Header", Method, 0},
		{"(*ResponseRecorder).Result", Method, 7},
		{"(*ResponseRecorder).Write", Method, 0},
		{"(*ResponseRecorder).WriteHeader", Method, 0},
		{"(*ResponseRecorder).WriteString", Method, 6},
		{"(*Server).Certificate", Method, 9},
		{"(*Server).Client", Method, 9},
		{"(*Server).Close", Method, 0},
		{"(*Server).CloseClientConnections", Method, 0},
		{"(*Server).Start", Method, 0},
		{"(*Server).StartTLS", Method, 0},
		{"DefaultRemoteAddr", Const, 0},
		{"NewRecorder", Func, 0},
		{"NewRequest", Func, 7},
		{"NewRequestWithContext", Func, 23},
		{"NewServer", Func, 0},
		{"NewTLSServer", Func, 0},
		{"NewUnstartedServer", Func, 0},
		{"ResponseRecorder", Type, 0},
		{"ResponseRecorder.Body", Field, 0},
		{"ResponseRecorder.Code", Field, 0},
		{"ResponseRecorder.Flushed", Field, 0},
		{"ResponseRecorder.HeaderMap", Field, 0},
		{"Server", Type, 0},
		{"Server.Config", Field, 0},
		{"Server.EnableHTTP2", Field, 14},
		{"Server.Listener", Field, 0},
		{"Server.TLS", Field, 0},
		{"Server.URL", Field, 0},
	},
	"net/http/httptrace": {
		{"ClientTrace", Type, 7},
		{"ClientTrace.ConnectDone", Field, 7},
		{"ClientTrace.ConnectStart", Field, 7},
		{"ClientTrace.DNSDone", Field, 7},
		{"ClientTrace.DNSStart", Field, 7},
		{"ClientTrace.GetConn", Field, 7},
		{"ClientTrace.Got100Continue", Field, 7},
		{"ClientTrace.Got1xxResponse", Field, 11},
		{"ClientTrace.GotConn", Field, 7},
		{"ClientTrace.GotFirstResponseByte", Field, 7},
		{"ClientTrace.PutIdleConn", Field, 7},
		{"ClientTrace.TLSHandshakeDone", Field, 8},
		{"ClientTrace.TLSHandshakeStart", Field, 8},
		{"ClientTrace.Wait100Continue", Field, 7},
		{"ClientTrace.WroteHeaderField", Field, 11},
		{"ClientTrace.WroteHeaders", Field, 7},
		{"ClientTrace.WroteRequest", Field, 7},
		{"ContextClientTrace", Func, 7},
		{"DNSDoneInfo", Type, 7},
		{"DNSDoneInfo.Addrs", Field, 7},
		{"DNSDoneInfo.Coalesced", Field, 7},
		{"DNSDoneInfo.Err", Field, 7},
		{"DNSStartInfo", Type, 7},
		{"DNSStartInfo.Host", Field, 7},
		{"GotConnInfo", Type, 7},
		{"GotConnInfo.Conn", Field, 7},
		{"GotConnInfo.IdleTime", Field, 7},
		{"GotConnInfo.Reused", Field, 7},
		{"GotConnInfo.WasIdle", Field, 7},
		{"WithClientTrace", Func, 7},
		{"WroteRequestInfo", Type, 7},
		{"WroteRequestInfo.Err", Field, 7},
	},
	"net/http/httputil": {
		{"(*ClientConn).Close", Method, 0},
		{"(*ClientConn).Do", Method, 0},
		{"(*ClientConn).Hijack", Method, 0},
		{"(*ClientConn).Pending", Method, 0},
		{"(*ClientConn).Read", Method, 0},
		{"(*ClientConn).Write", Method, 0},
		{"(*ProxyRequest).SetURL", Method, 20},
		{"(*ProxyRequest).SetXForwarded", Method, 20},
		{"(*ReverseProxy).ServeHTTP", Method, 0},
		{"(*ServerConn).Close", Method, 0},
		{"(*ServerConn).Hijack", Method, 0},
		{"(*ServerConn).Pending", Method, 0},
		{"(*ServerConn).Read", Method, 0},
		{"(*ServerConn).Write", Method, 0},
		{"BufferPool", Type, 6},
		{"ClientConn", Type, 0},
		{"DumpRequest", Func, 0},
		{"DumpRequestOut", Func, 0},
		{"DumpResponse", Func, 0},
		{"ErrClosed", Var, 0},
		{"ErrLineTooLong", Var, 0},
		{"ErrPersistEOF", Var, 0},
		{"ErrPipeline", Var, 0},
		{"NewChunkedReader", Func, 0},
		{"NewChunkedWriter", Func, 0},
		{"NewClientConn", Func, 0},
		{"NewProxyClientConn", Func, 0},
		{"NewServerConn", Func, 0},
		{"NewSingleHostReverseProxy", Func, 0},
		{"ProxyRequest", Type, 20},
		{"ProxyRequest.In", Field, 20},
		{"ProxyRequest.Out", Field, 20},
		{"ReverseProxy", Type, 0},
		{"ReverseProxy.BufferPool", Field, 6},
		{"ReverseProxy.Director", Field, 0},
		{"ReverseProxy.ErrorHandler", Field, 11},
		{"ReverseProxy.ErrorLog", Field, 4},
		{"ReverseProxy.FlushInterval", Field, 0},
		{"ReverseProxy.ModifyResponse", Field, 8},
		{"ReverseProxy.Rewrite", Field, 20},
		{"ReverseProxy.Transport", Field, 0},
		{"ServerConn", Type, 0},
	},
	"net/http/pprof": {
		{"Cmdline", Func, 0},
		{"Handler", Func, 0},
		{"Index", Func, 0},
		{"Profile", Func, 0},
		{"Symbol", Func, 0},
		{"Trace", Func, 5},
	},
	"net/mail": {
		{"(*Address).String", Method, 0},
		{"(*AddressParser).Parse", Method, 5},
		{"(*AddressParser).ParseList", Method, 5},
		{"(Header).AddressList", Method, 0},
		{"(Header).Date", Method, 0},
		{"(Header).Get", Method, 0},
		{"Address", Type, 0},
		{"Address.Address", Field, 0},
		{"Address.Name", Field, 0},
		{"AddressParser", Type, 5},
		{"AddressParser.WordDecoder", Field, 5},
		{"ErrHeaderNotPresent", Var, 0},
		{"Header", Type, 0},
		{"Message", Type, 0},
		{"Message.Body", Field, 0},
		{"Message.Header", Field, 0},
		{"ParseAddress", Func, 1},
		{"ParseAddressList", Func, 1},
		{"ParseDate", Func, 8},
		{"ReadMessage", Func, 0},
	},
	"net/netip": {
		{"(*Addr).UnmarshalBinary", Method, 18},
		{"(*Addr).UnmarshalText", Method, 18},
		{"(*AddrPort).UnmarshalBinary", Method, 18},
		{"(*AddrPort).UnmarshalText", Method, 18},
		{"(*Prefix).UnmarshalBinary", Method, 18},
		{"(*Prefix).UnmarshalText", Method, 18},
		{"(Addr).AppendBinary", Method, 24},
		{"(Addr).AppendText", Method, 24},
		{"(Addr).AppendTo", Method, 18},
		{"(Addr).As16", Method, 18},
		{"(Addr).As4", Method, 18},
		{"(Addr).AsSlice", Method, 18},
		{"(Addr).BitLen", Method, 18},
		{"(Addr).Compare", Method, 18},
		{"(Addr).Is4", Method, 18},
		{"(Addr).Is4In6", Method, 18},
		{"(Addr).Is6", Method, 18},
		{"(Addr).IsGlobalUnicast", Method, 18},
		{"(Addr).IsInterfaceLocalMulticast", Method, 18},
		{"(Addr).IsLinkLocalMulticast", Method, 18},
		{"(Addr).IsLinkLocalUnicast", Method, 18},
		{"(Addr).IsLoopback", Method, 18},
		{"(Addr).IsMulticast", Method, 18},
		{"(Addr).IsPrivate", Method, 18},
		{"(Addr).IsUnspecified", Method, 18},
		{"(Addr).IsValid", Method, 18},
		{"(Addr).Less", Method, 18},
		{"(Addr).MarshalBinary", Method, 18},
		{"(Addr).MarshalText", Method, 18},
		{"(Addr).Next", Method, 18},
		{"(Addr).Prefix", Method, 18},
		{"(Addr).Prev", Method, 18},
		{"(Addr).String", Method, 18},
		{"(Addr).StringExpanded", Method, 18},
		{"(Addr).Unmap", Method, 18},
		{"(Addr).WithZone", Method, 18},
		{"(Addr).Zone", Method, 18},
		{"(AddrPort).Addr", Method, 18},
		{"(AddrPort).AppendBinary", Method, 24},
		{"(AddrPort).AppendText", Method, 24},
		{"(AddrPort).AppendTo", Method, 18},
		{"(AddrPort).Compare", Method, 22},
		{"(AddrPort).IsValid", Method, 18},
		{"(AddrPort).MarshalBinary", Method, 18},
		{"(AddrPort).MarshalText", Method, 18},
		{"(AddrPort).Port", Method, 18},
		{"(AddrPort).String", Method, 18},
		{"(Prefix).Addr", Method, 18},
		{"(Prefix).AppendBinary", Method, 24},
		{"(Prefix).AppendText", Method, 24},
		{"(Prefix).AppendTo", Method, 18},
		{"(Prefix).Bits", Method, 18},
		{"(Prefix).Contains", Method, 18},
		{"(Prefix).IsSingleIP", Method, 18},
		{"(Prefix).IsValid", Method, 18},
		{"(Prefix).MarshalBinary", Method, 18},
		{"(Prefix).MarshalText", Method, 18},
		{"(Prefix).Masked", Method, 18},
		{"(Prefix).Overlaps", Method, 18},
		{"(Prefix).String", Method, 18},
		{"Addr", Type, 18},
		{"AddrFrom16", Func, 18},
		{"AddrFrom4", Func, 18},
		{"AddrFromSlice", Func, 18},
		{"AddrPort", Type, 18},
		{"AddrPortFrom", Func, 18},
		{"IPv4Unspecified", Func, 18},
		{"IPv6LinkLocalAllNodes", Func, 18},
		{"IPv6LinkLocalAllRouters", Func, 20},
		{"IPv6Loopback", Func, 20},
		{"IPv6Unspecified", Func, 18},
		{"MustParseAddr", Func, 18},
		{"MustParseAddrPort", Func, 18},
		{"MustParsePrefix", Func, 18},
		{"ParseAddr", Func, 18},
		{"ParseAddrPort", Func, 18},
		{"ParsePrefix", Func, 18},
		{"Prefix", Type, 18},
		{"PrefixFrom", Func, 18},
	},
	"net/rpc": {
		{"(*Client).Call", Method, 0},
		{"(*Client).Close", Method, 0},
		{"(*Client).Go", Method, 0},
		{"(*Server).Accept", Method, 0},
		{"(*Server).HandleHTTP", Method, 0},
		{"(*Server).Register", Method, 0},
		{"(*Server).RegisterName", Method, 0},
		{"(*Server).ServeCodec", Method, 0},
		{"(*Server).ServeConn", Method, 0},
		{"(*Server).ServeHTTP", Method, 0},
		{"(*Server).ServeRequest", Method, 0},
		{"(ServerError).Error", Method, 0},
		{"Accept", Func, 0},
		{"Call", Type, 0},
		{"Call.Args", Field, 0},
		{"Call.Done", Field, 0},
		{"Call.Error", Field, 0},
		{"Call.Reply", Field, 0},
		{"Call.ServiceMethod", Field, 0},
		{"Client", Type, 0},
		{"ClientCodec", Type, 0},
		{"DefaultDebugPath", Const, 0},
		{"DefaultRPCPath", Const, 0},
		{"DefaultServer", Var, 0},
		{"Dial", Func, 0},
		{"DialHTTP", Func, 0},
		{"DialHTTPPath", Func, 0},
		{"ErrShutdown", Var, 0},
		{"HandleHTTP", Func, 0},
		{"NewClient", Func, 0},
		{"NewClientWithCodec", Func, 0},
		{"NewServer", Func, 0},
		{"Register", Func, 0},
		{"RegisterName", Func, 0},
		{"Request", Type, 0},
		{"Request.Seq", Field, 0},
		{"Request.ServiceMethod", Field, 0},
		{"Response", Type, 0},
		{"Response.Error", Field, 0},
		{"Response.Seq", Field, 0},
		{"Response.ServiceMethod", Field, 0},
		{"ServeCodec", Func, 0},
		{"ServeConn", Func, 0},
		{"ServeRequest", Func, 0},
		{"Server", Type, 0},
		{"ServerCodec", Type, 0},
		{"ServerError", Type, 0},
	},
	"net/rpc/jsonrpc": {
		{"Dial", Func, 0},
		{"NewClient", Func, 0},
		{"NewClientCodec", Func, 0},
		{"NewServerCodec", Func, 0},
		{"ServeConn", Func, 0},
	},
	"net/smtp": {
		{"(*Client).Auth", Method, 0},
		{"(*Client).Close", Method, 2},
		{"(*Client).Data", Method, 0},
		{"(*Client).Extension", Method, 0},
		{"(*Client).Hello", Method, 1},
		{"(*Client).Mail", Method, 0},
		{"(*Client).Noop", Method, 10},
		{"(*Client).Quit", Method, 0},
		{"(*Client).Rcpt", Method, 0},
		{"(*Client).Reset", Method, 0},
		{"(*Client).StartTLS", Method, 0},
		{"(*Client).TLSConnectionState", Method, 5},
		{"(*Client).Verify", Method, 0},
		{"Auth", Type, 0},
		{"CRAMMD5Auth", Func, 0},
		{"Client", Type, 0},
		{"Client.Text", Field, 0},
		{"Dial", Func, 0},
		{"NewClient", Func, 0},
		{"PlainAuth", Func, 0},
		{"SendMail", Func, 0},
		{"ServerInfo", Type, 0},
		{"ServerInfo.Auth", Field, 0},
		{"ServerInfo.Name", Field, 0},
		{"ServerInfo.TLS", Field, 0},
	},
	"net/textproto": {
		{"(*Conn).Close", Method, 0},
		{"(*Conn).Cmd", Method, 0},
		{"(*Conn).DotReader", Method, 0},
		{"(*Conn).DotWriter", Method, 0},
		{"(*Conn).EndRequest", Method, 0},
		{"(*Conn).EndResponse", Method, 0},
		{"(*Conn).Next", Method, 0},
		{"(*Conn).PrintfLine", Method, 0},
		{"(*Conn).ReadCodeLine", Method, 0},
		{"(*Conn).ReadContinuedLine", Method, 0},
		{"(*Conn).ReadContinuedLineBytes", Method, 0},
		{"(*Conn).ReadDotBytes", Method, 0},
		{"(*Conn).ReadDotLines", Method, 0},
		{"(*Conn).ReadLine", Method, 0},
		{"(*Conn).ReadLineBytes", Method, 0},
		{"(*Conn).ReadMIMEHeader", Method, 0},
		{"(*Conn).ReadResponse", Method, 0},
		{"(*Conn).StartRequest", Method, 0},
		{"(*Conn).StartResponse", Method, 0},
		{"(*Error).Error", Method, 0},
		{"(*Pipeline).EndRequest", Method, 0},
		{"(*Pipeline).EndResponse", Method, 0},
		{"(*Pipeline).Next", Method, 0},
		{"(*Pipeline).StartRequest", Method, 0},
		{"(*Pipeline).StartResponse", Method, 0},
		{"(*Reader).DotReader", Method, 0},
		{"(*Reader).ReadCodeLine", Method, 0},
		{"(*Reader).ReadContinuedLine", Method, 0},
		{"(*Reader).ReadContinuedLineBytes", Method, 0},
		{"(*Reader).ReadDotBytes", Method, 0},
		{"(*Reader).ReadDotLines", Method, 0},
		{"(*Reader).ReadLine", Method, 0},
		{"(*Reader).ReadLineBytes", Method, 0},
		{"(*Reader).ReadMIMEHeader", Method, 0},
		{"(*Reader).ReadResponse", Method, 0},
		{"(*Writer).DotWriter", Method, 0},
		{"(*Writer).PrintfLine", Method, 0},
		{"(MIMEHeader).Add", Method, 0},
		{"(MIMEHeader).Del", Method, 0},
		{"(MIMEHeader).Get", Method, 0},
		{"(MIMEHeader).Set", Method, 0},
		{"(MIMEHeader).Values", Method, 14},
		{"(ProtocolError).Error", Method, 0},
		{"CanonicalMIMEHeaderKey", Func, 0},
		{"Conn", Type, 0},
		{"Conn.Pipeline", Field, 0},
		{"Conn.Reader", Field, 0},
		{"Conn.Writer", Field, 0},
		{"Dial", Func, 0},
		{"Error", Type, 0},
		{"Error.Code", Field, 0},
		{"Error.Msg", Field, 0},
		{"MIMEHeader", Type, 0},
		{"NewConn", Func, 0},
		{"NewReader", Func, 0},
		{"NewWriter", Func, 0},
		{"Pipeline", Type, 0},
		{"ProtocolError", Type, 0},
		{"Reader", Type, 0},
		{"Reader.R", Field, 0},
		{"TrimBytes", Func, 1},
		{"TrimString", Func, 1},
		{"Writer", Type, 0},
		{"Writer.W", Field, 0},
	},
	"net/url": {
		{"(*Error).Error", Method, 0},
		{"(*Error).Temporary", Method, 6},
		{"(*Error).Timeout", Method, 6},
		{"(*Error).Unwrap", Method, 13},
		{"(*URL).AppendBinary", Method, 24},
		{"(*URL).EscapedFragment", Method, 15},
		{"(*URL).EscapedPath", Method, 5},
		{"(*URL).Hostname", Method, 8},
		{"(*URL).IsAbs", Method, 0},
		{"(*URL).JoinPath", Method, 19},
		{"(*URL).MarshalBinary", Method, 8},
		{"(*URL).Parse", Method, 0},
		{"(*URL).Port", Method, 8},
		{"(*URL).Query", Method, 0},
		{"(*URL).Redacted", Method, 15},
		{"(*URL).RequestURI", Method, 0},
		{"(*URL).ResolveReference", Method, 0},
		{"(*URL).String", Method, 0},
		{"(*URL).UnmarshalBinary", Method, 8},
		{"(*Userinfo).Password", Method, 0},
		{"(*Userinfo).String", Method, 0},
		{"(*Userinfo).Username", Method, 0},
		{"(EscapeError).Error", Method, 0},
		{"(InvalidHostError).Error", Method, 6},
		{"(Values).Add", Method, 0},
		{"(Values).Del", Method, 0},
		{"(Values).Encode", Method, 0},
		{"(Values).Get", Method, 0},
		{"(Values).Has", Method, 17},
		{"(Values).Set", Method, 0},
		{"Error", Type, 0},
		{"Error.Err", Field, 0},
		{"Error.Op", Field, 0},
		{"Error.URL", Field, 0},
		{"EscapeError", Type, 0},
		{"InvalidHostError", Type, 6},
		{"JoinPath", Func, 19},
		{"Parse", Func, 0},
		{"ParseQuery", Func, 0},
		{"ParseRequestURI", Func, 0},
		{"PathEscape", Func, 8},
		{"PathUnescape", Func, 8},
		{"QueryEscape", Func, 0},
		{"QueryUnescape", Func, 0},
		{"URL", Type, 0},
		{"URL.ForceQuery", Field, 7},
		{"URL.Fragment", Field, 0},
		{"URL.Host", Field, 0},
		{"URL.OmitHost", Field, 19},
		{"URL.Opaque", Field, 0},
		{"URL.Path", Field, 0},
		{"URL.RawFragment", Field, 15},
		{"URL.RawPath", Field, 5},
		{"URL.RawQuery", Field, 0},
		{"URL.Scheme", Field, 0},
		{"URL.User", Field, 0},
		{"User", Func, 0},
		{"UserPassword", Func, 0},
		{"Userinfo", Type, 0},
		{"Values", Type, 0},
	},
	"os": {
		{"(*File).Chdir", Method, 0},
		{"(*File).Chmod", Method, 0},
		{"(*File).Chown", Method, 0},
		{"(*File).Close", Method, 0},
		{"(*File).Fd", Method, 0},
		{"(*File).Name", Method, 0},
		{"(*File).Read", Method, 0},
		{"(*File).ReadAt", Method, 0},
		{"(*File).ReadDir", Method, 16},
		{"(*File).ReadFrom", Method, 15},
		{"(*File).Readdir", Method, 0},
		{"(*File).Readdirnames", Method, 0},
		{"(*File).Seek", Method, 0},
		{"(*File).SetDeadline", Method, 10},
		{"(*File).SetReadDeadline", Method, 10},
		{"(*File).SetWriteDeadline", Method, 10},
		{"(*File).Stat", Method, 0},
		{"(*File).Sync", Method, 0},
		{"(*File).SyscallConn", Method, 12},
		{"(*File).Truncate", Method, 0},
		{"(*File).Write", Method, 0},
		{"(*File).WriteAt", Method, 0},
		{"(*File).WriteString", Method, 0},
		{"(*File).WriteTo", Method, 22},
		{"(*LinkError).Error", Method, 0},
		{"(*LinkError).Unwrap", Method, 13},
		{"(*PathError).Error", Method, 0},
		{"(*PathError).Timeout", Method, 10},
		{"(*PathError).Unwrap", Method, 13},
		{"(*Process).Kill", Method, 0},
		{"(*Process).Release", Method, 0},
		{"(*Process).Signal", Method, 0},
		{"(*Process).Wait", Method, 0},
		{"(*ProcessState).ExitCode", Method, 12},
		{"(*ProcessState).Exited", Method, 0},
		{"(*ProcessState).Pid", Method, 0},
		{"(*ProcessState).String", Method, 0},
		{"(*ProcessState).Success", Method, 0},
		{"(*ProcessState).Sys", Method, 0},
		{"(*ProcessState).SysUsage", Method, 0},
		{"(*ProcessState).SystemTime", Method, 0},
		{"(*ProcessState).UserTime", Method, 0},
		{"(*Root).Close", Method, 24},
		{"(*Root).Create", Method, 24},
		{"(*Root).FS", Method, 24},
		{"(*Root).Lstat", Method, 24},
		{"(*Root).Mkdir", Method, 24},
		{"(*Root).Name", Method, 24},
		{"(*Root).Open", Method, 24},
		{"(*Root).OpenFile", Method, 24},
		{"(*Root).OpenRoot", Method, 24},
		{"(*Root).Remove", Method, 24},
		{"(*Root).Stat", Method, 24},
		{"(*SyscallError).Error", Method, 0},
		{"(*SyscallError).Timeout", Method, 10},
		{"(*SyscallError).Unwrap", Method, 13},
		{"(FileMode).IsDir", Method, 0},
		{"(FileMode).IsRegular", Method, 1},
		{"(FileMode).Perm", Method, 0},
		{"(FileMode).String", Method, 0},
		{"Args", Var, 0},
		{"Chdir", Func, 0},
		{"Chmod", Func, 0},
		{"Chown", Func, 0},
		{"Chtimes", Func, 0},
		{"Clearenv", Func, 0},
		{"CopyFS", Func, 23},
		{"Create", Func, 0},
		{"CreateTemp", Func, 16},
		{"DevNull", Const, 0},
		{"DirEntry", Type, 16},
		{"DirFS", Func, 16},
		{"Environ", Func, 0},
		{"ErrClosed", Var, 8},
		{"ErrDeadlineExceeded", Var, 15},
		{"ErrExist", Var, 0},
		{"ErrInvalid", Var, 0},
		{"ErrNoDeadline", Var, 10},
		{"ErrNotExist", Var, 0},
		{"ErrPermission", Var, 0},
		{"ErrProcessDone", Var, 16},
		{"Executable", Func, 8},
		{"Exit", Func, 0},
		{"Expand", Func, 0},
		{"ExpandEnv", Func, 0},
		{"File", Type, 0},
		{"FileInfo", Type, 0},
		{"FileMode", Type, 0},
		{"FindProcess", Func, 0},
		{"Getegid", Func, 0},
		{"Getenv", Func, 0},
		{"Geteuid", Func, 0},
		{"Getgid", Func, 0},
		{"Getgroups", Func, 0},
		{"Getpagesize", Func, 0},
		{"Getpid", Func, 0},
		{"Getppid", Func, 0},
		{"Getuid", Func, 0},
		{"Getwd", Func, 0},
		{"Hostname", Func, 0},
		{"Interrupt", Var, 0},
		{"IsExist", Func, 0},
		{"IsNotExist", Func, 0},
		{"IsPathSeparator", Func, 0},
		{"IsPermission", Func, 0},
		{"IsTimeout", Func, 10},
		{"Kill", Var, 0},
		{"Lchown", Func, 0},
		{"Link", Func, 0},
		{"LinkError", Type, 0},
		{"LinkError.Err", Field, 0},
		{"LinkError.New", Field, 0},
		{"LinkError.Old", Field, 0},
		{"LinkError.Op", Field, 0},
		{"LookupEnv", Func, 5},
		{"Lstat", Func, 0},
		{"Mkdir", Func, 0},
		{"MkdirAll", Func, 0},
		{"MkdirTemp", Func, 16},
		{"ModeAppend", Const, 0},
		{"ModeCharDevice", Const, 0},
		{"ModeDevice", Const, 0},
		{"ModeDir", Const, 0},
		{"ModeExclusive", Const, 0},
		{"ModeIrregular", Const, 11},
		{"ModeNamedPipe", Const, 0},
		{"ModePerm", Const, 0},
		{"ModeSetgid", Const, 0},
		{"ModeSetuid", Const, 0},
		{"ModeSocket", Const, 0},
		{"ModeSticky", Const, 0},
		{"ModeSymlink", Const, 0},
		{"ModeTemporary", Const, 0},
		{"ModeType", Const, 0},
		{"NewFile", Func, 0},
		{"NewSyscallError", Func, 0},
		{"O_APPEND", Const, 0},
		{"O_CREATE", Const, 0},
		{"O_EXCL", Const, 0},
		{"O_RDONLY", Const, 0},
		{"O_RDWR", Const, 0},
		{"O_SYNC", Const, 0},
		{"O_TRUNC", Const, 0},
		{"O_WRONLY", Const, 0},
		{"Open", Func, 0},
		{"OpenFile", Func, 0},
		{"OpenInRoot", Func, 24},
		{"OpenRoot", Func, 24},
		{"PathError", Type, 0},
		{"PathError.Err", Field, 0},
		{"PathError.Op", Field, 0},
		{"PathError.Path", Field, 0},
		{"PathListSeparator", Const, 0},
		{"PathSeparator", Const, 0},
		{"Pipe", Func, 0},
		{"ProcAttr", Type, 0},
		{"ProcAttr.Dir", Field, 0},
		{"ProcAttr.Env", Field, 0},
		{"ProcAttr.Files", Field, 0},
		{"ProcAttr.Sys", Field, 0},
		{"Process", Type, 0},
		{"Process.Pid", Field, 0},
		{"ProcessState", Type, 0},
		{"ReadDir", Func, 16},
		{"ReadFile", Func, 16},
		{"Readlink", Func, 0},
		{"Remove", Func, 0},
		{"RemoveAll", Func, 0},
		{"Rename", Func, 0},
		{"Root", Type, 24},
		{"SEEK_CUR", Const, 0},
		{"SEEK_END", Const, 0},
		{"SEEK_SET", Const, 0},
		{"SameFile", Func, 0},
		{"Setenv", Func, 0},
		{"Signal", Type, 0},
		{"StartProcess", Func, 0},
		{"Stat", Func, 0},
		{"Stderr", Var, 0},
		{"Stdin", Var, 0},
		{"Stdout", Var, 0},
		{"Symlink", Func, 0},
		{"SyscallError", Type, 0},
		{"SyscallError.Err", Field, 0},
		{"SyscallError.Syscall", Field, 0},
		{"TempDir", Func, 0},
		{"Truncate", Func, 0},
		{"Unsetenv", Func, 4},
		{"UserCacheDir", Func, 11},
		{"UserConfigDir", Func, 13},
		{"UserHomeDir", Func, 12},
		{"WriteFile", Func, 16},
	},
	"os/exec": {
		{"(*Cmd).CombinedOutput", Method, 0},
		{"(*Cmd).Environ", Method, 19},
		{"(*Cmd).Output", Method, 0},
		{"(*Cmd).Run", Method, 0},
		{"(*Cmd).Start", Method, 0},
		{"(*Cmd).StderrPipe", Method, 0},
		{"(*Cmd).StdinPipe", Method, 0},
		{"(*Cmd).StdoutPipe", Method, 0},
		{"(*Cmd).String", Method, 13},
		{"(*Cmd).Wait", Method, 0},
		{"(*Error).Error", Method, 0},
		{"(*Error).Unwrap", Method, 13},
		{"(*ExitError).Error", Method, 0},
		{"(ExitError).ExitCode", Method, 12},
		{"(ExitError).Exited", Method, 0},
		{"(ExitError).Pid", Method, 0},
		{"(ExitError).String", Method, 0},
		{"(ExitError).Success", Method, 0},
		{"(ExitError).Sys", Method, 0},
		{"(ExitError).SysUsage", Method, 0},
		{"(ExitError).SystemTime", Method, 0},
		{"(ExitError).UserTime", Method, 0},
		{"Cmd", Type, 0},
		{"Cmd.Args", Field, 0},
		{"Cmd.Cancel", Field, 20},
		{"Cmd.Dir", Field, 0},
		{"Cmd.Env", Field, 0},
		{"Cmd.Err", Field, 19},
		{"Cmd.ExtraFiles", Field, 0},
		{"Cmd.Path", Field, 0},
		{"Cmd.Process", Field, 0},
		{"Cmd.ProcessState", Field, 0},
		{"Cmd.Stderr", Field, 0},
		{"Cmd.Stdin", Field, 0},
		{"Cmd.Stdout", Field, 0},
		{"Cmd.SysProcAttr", Field, 0},
		{"Cmd.WaitDelay", Field, 20},
		{"Command", Func, 0},
		{"CommandContext", Func, 7},
		{"ErrDot", Var, 19},
		{"ErrNotFound", Var, 0},
		{"ErrWaitDelay", Var, 20},
		{"Error", Type, 0},
		{"Error.Err", Field, 0},
		{"Error.Name", Field, 0},
		{"ExitError", Type, 0},
		{"ExitError.ProcessState", Field, 0},
		{"ExitError.Stderr", Field, 6},
		{"LookPath", Func, 0},
	},
	"os/signal": {
		{"Ignore", Func, 5},
		{"Ignored", Func, 11},
		{"Notify", Func, 0},
		{"NotifyContext", Func, 16},
		{"Reset", Func, 5},
		{"Stop", Func, 1},
	},
	"os/user": {
		{"(*User).GroupIds", Method, 7},
		{"(UnknownGroupError).Error", Method, 7},
		{"(UnknownGroupIdError).Error", Method, 7},
		{"(UnknownUserError).Error", Method, 0},
		{"(UnknownUserIdError).Error", Method, 0},
		{"Current", Func, 0},
		{"Group", Type, 7},
		{"Group.Gid", Field, 7},
		{"Group.Name", Field, 7},
		{"Lookup", Func, 0},
		{"LookupGroup", Func, 7},
		{"LookupGroupId", Func, 7},
		{"LookupId", Func, 0},
		{"UnknownGroupError", Type, 7},
		{"UnknownGroupIdError", Type, 7},
		{"UnknownUserError", Type, 0},
		{"UnknownUserIdError", Type, 0},
		{"User", Type, 0},
		{"User.Gid", Field, 0},
		{"User.HomeDir", Field, 0},
		{"User.Name", Field, 0},
		{"User.Uid", Field, 0},
		{"User.Username", Field, 0},
	},
	"path": {
		{"Base", Func, 0},
		{"Clean", Func, 0},
		{"Dir", Func, 0},
		{"ErrBadPattern", Var, 0},
		{"Ext", Func, 0},
		{"IsAbs", Func, 0},
		{"Join", Func, 0},
		{"Match", Func, 0},
		{"Split", Func, 0},
	},
	"path/filepath": {
		{"Abs", Func, 0},
		{"Base", Func, 0},
		{"Clean", Func, 0},
		{"Dir", Func, 0},
		{"ErrBadPattern", Var, 0},
		{"EvalSymlinks", Func, 0},
		{"Ext", Func, 0},
		{"FromSlash", Func, 0},
		{"Glob", Func, 0},
		{"HasPrefix", Func, 0},
		{"IsAbs", Func, 0},
		{"IsLocal", Func, 20},
		{"Join", Func, 0},
		{"ListSeparator", Const, 0},
		{"Localize", Func, 23},
		{"Match", Func, 0},
		{"Rel", Func, 0},
		{"Separator", Const, 0},
		{"SkipAll", Var, 20},
		{"SkipDir", Var, 0},
		{"Split", Func, 0},
		{"SplitList", Func, 0},
		{"ToSlash", Func, 0},
		{"VolumeName", Func, 0},
		{"Walk", Func, 0},
		{"WalkDir", Func, 16},
		{"WalkFunc", Type, 0},
	},
	"plugin": {
		{"(*Plugin).Lookup", Method, 8},
		{"Open", Func, 8},
		{"Plugin", Type, 8},
		{"Symbol", Type, 8},
	},
	"reflect": {
		{"(*MapIter).Key", Method, 12},
		{"(*MapIter).Next", Method, 12},
		{"(*MapIter).Reset", Method, 18},
		{"(*MapIter).Value", Method, 12},
		{"(*ValueError).Error", Method, 0},
		{"(ChanDir).String", Method, 0},
		{"(Kind).String", Method, 0},
		{"(Method).IsExported", Method, 17},
		{"(StructField).IsExported", Method, 17},
		{"(StructTag).Get", Method, 0},
		{"(StructTag).Lookup", Method, 7},
		{"(Value).Addr", Method, 0},
		{"(Value).Bool", Method, 0},
		{"(Value).Bytes", Method, 0},
		{"(Value).Call", Method, 0},
		{"(Value).CallSlice", Method, 0},
		{"(Value).CanAddr", Method, 0},
		{"(Value).CanComplex", Method, 18},
		{"(Value).CanConvert", Method, 17},
		{"(Value).CanFloat", Method, 18},
		{"(Value).CanInt", Method, 18},
		{"(Value).CanInterface", Method, 0},
		{"(Value).CanSet", Method, 0},
		{"(Value).CanUint", Method, 18},
		{"(Value).Cap", Method, 0},
		{"(Value).Clear", Method, 21},
		{"(Value).Close", Method, 0},
		{"(Value).Comparable", Method, 20},
		{"(Value).Complex", Method, 0},
		{"(Value).Convert", Method, 1},
		{"(Value).Elem", Method, 0},
		{"(Value).Equal", Method, 20},
		{"(Value).Field", Method, 0},
		{"(Value).FieldByIndex", Method, 0},
		{"(Value).FieldByIndexErr", Method, 18},
		{"(Value).FieldByName", Method, 0},
		{"(Value).FieldByNameFunc", Method, 0},
		{"(Value).Float", Method, 0},
		{"(Value).Grow", Method, 20},
		{"(Value).Index", Method, 0},
		{"(Value).Int", Method, 0},
		{"(Value).Interface", Method, 0},
		{"(Value).InterfaceData", Method, 0},
		{"(Value).IsNil", Method, 0},
		{"(Value).IsValid", Method, 0},
		{"(Value).IsZero", Method, 13},
		{"(Value).Kind", Method, 0},
		{"(Value).Len", Method, 0},
		{"(Value).MapIndex", Method, 0},
		{"(Value).MapKeys", Method, 0},
		{"(Value).MapRange", Method, 12},
		{"(Value).Method", Method, 0},
		{"(Value).MethodByName", Method, 0},
		{"(Value).NumField", Method, 0},
		{"(Value).NumMethod", Method, 0},
		{"(Value).OverflowComplex", Method, 0},
		{"(Value).OverflowFloat", Method, 0},
		{"(Value).OverflowInt", Method, 0},
		{"(Value).OverflowUint", Method, 0},
		{"(Value).Pointer", Method, 0},
		{"(Value).Recv", Method, 0},
		{"(Value).Send", Method, 0},
		{"(Value).Seq", Method, 23},
		{"(Value).Seq2", Method, 23},
		{"(Value).Set", Method, 0},
		{"(Value).SetBool", Method, 0},
		{"(Value).SetBytes", Method, 0},
		{"(Value).SetCap", Method, 2},
		{"(Value).SetComplex", Method, 0},
		{"(Value).SetFloat", Method, 0},
		{"(Value).SetInt", Method, 0},
		{"(Value).SetIterKey", Method, 18},
		{"(Value).SetIterValue", Method, 18},
		{"(Value).SetLen", Method, 0},
		{"(Value).SetMapIndex", Method, 0},
		{"(Value).SetPointer", Method, 0},
		{"(Value).SetString", Method, 0},
		{"(Value).SetUint", Method, 0},
		{"(Value).SetZero", Method, 20},
		{"(Value).Slice", Method, 0},
		{"(Value).Slice3", Method, 2},
		{"(Value).String", Method, 0},
		{"(Value).TryRecv", Method, 0},
		{"(Value).TrySend", Method, 0},
		{"(Value).Type", Method, 0},
		{"(Value).Uint", Method, 0},
		{"(Value).UnsafeAddr", Method, 0},
		{"(Value).UnsafePointer", Method, 18},
		{"Append", Func, 0},
		{"AppendSlice", Func, 0},
		{"Array", Const, 0},
		{"ArrayOf", Func, 5},
		{"Bool", Const, 0},
		{"BothDir", Const, 0},
		{"Chan", Const, 0},
		{"ChanDir", Type, 0},
		{"ChanOf", Func, 1},
		{"Complex128", Const, 0},
		{"Complex64", Const, 0},
		{"Copy", Func, 0},
		{"DeepEqual", Func, 0},
		{"Float32", Const, 0},
		{"Float64", Const, 0},
		{"Func", Const, 0},
		{"FuncOf", Func, 5},
		{"Indirect", Func, 0},
		{"Int", Const, 0},
		{"Int16", Const, 0},
		{"Int32", Const, 0},
		{"Int64", Const, 0},
		{"Int8", Const, 0},
		{"Interface", Const, 0},
		{"Invalid", Const, 0},
		{"Kind", Type, 0},
		{"MakeChan", Func, 0},
		{"MakeFunc", Func, 1},
		{"MakeMap", Func, 0},
		{"MakeMapWithSize", Func, 9},
		{"MakeSlice", Func, 0},
		{"Map", Const, 0},
		{"MapIter", Type, 12},
		{"MapOf", Func, 1},
		{"Method", Type, 0},
		{"Method.Func", Field, 0},
		{"Method.Index", Field, 0},
		{"Method.Name", Field, 0},
		{"Method.PkgPath", Field, 0},
		{"Method.Type", Field, 0},
		{"New", Func, 0},
		{"NewAt", Func, 0},
		{"Pointer", Const, 18},
		{"PointerTo", Func, 18},
		{"Ptr", Const, 0},
		{"PtrTo", Func, 0},
		{"RecvDir", Const, 0},
		{"Select", Func, 1},
		{"SelectCase", Type, 1},
		{"SelectCase.Chan", Field, 1},
		{"SelectCase.Dir", Field, 1},
		{"SelectCase.Send", Field, 1},
		{"SelectDefault", Const, 1},
		{"SelectDir", Type, 1},
		{"SelectRecv", Const, 1},
		{"SelectSend", Const, 1},
		{"SendDir", Const, 0},
		{"Slice", Const, 0},
		{"SliceAt", Func, 23},
		{"SliceHeader", Type, 0},
		{"SliceHeader.Cap", Field, 0},
		{"SliceHeader.Data", Field, 0},
		{"SliceHeader.Len", Field, 0},
		{"SliceOf", Func, 1},
		{"String", Const, 0},
		{"StringHeader", Type, 0},
		{"StringHeader.Data", Field, 0},
		{"StringHeader.Len", Field, 0},
		{"Struct", Const, 0},
		{"StructField", Type, 0},
		{"StructField.Anonymous", Field, 0},
		{"StructField.Index", Field, 0},
		{"StructField.Name", Field, 0},
		{"StructField.Offset", Field, 0},
		{"StructField.PkgPath", Field, 0},
		{"StructField.Tag", Field, 0},
		{"StructField.Type", Field, 0},
		{"StructOf", Func, 7},
		{"StructTag", Type, 0},
		{"Swapper", Func, 8},
		{"Type", Type, 0},
		{"TypeFor", Func, 22},
		{"TypeOf", Func, 0},
		{"Uint", Const, 0},
		{"Uint16", Const, 0},
		{"Uint32", Const, 0},
		{"Uint64", Const, 0},
		{"Uint8", Const, 0},
		{"Uintptr", Const, 0},
		{"UnsafePointer", Const, 0},
		{"Value", Type, 0},
		{"ValueError", Type, 0},
		{"ValueError.Kind", Field, 0},
		{"ValueError.Method", Field, 0},
		{"ValueOf", Func, 0},
		{"VisibleFields", Func, 17},
		{"Zero", Func, 0},
	},
	"regexp": {
		{"(*Regexp).AppendText", Method, 24},
		{"(*Regexp).Copy", Method, 6},
		{"(*Regexp).Expand", Method, 0},
		{"(*Regexp).ExpandString", Method, 0},
		{"(*Regexp).Find", Method, 0},
		{"(*Regexp).FindAll", Method, 0},
		{"(*Regexp).FindAllIndex", Method, 0},
		{"(*Regexp).FindAllString", Method, 0},
		{"(*Regexp).FindAllStringIndex", Method, 0},
		{"(*Regexp).FindAllStringSubmatch", Method, 0},
		{"(*Regexp).FindAllStringSubmatchIndex", Method, 0},
		{"(*Regexp).FindAllSubmatch", Method, 0},
		{"(*Regexp).FindAllSubmatchIndex", Method, 0},
		{"(*Regexp).FindIndex", Method, 0},
		{"(*Regexp).FindReaderIndex", Method, 0},
		{"(*Regexp).FindReaderSubmatchIndex", Method, 0},
		{"(*Regexp).FindString", Method, 0},
		{"(*Regexp).FindStringIndex", Method, 0},
		{"(*Regexp).FindStringSubmatch", Method, 0},
		{"(*Regexp).FindStringSubmatchIndex", Method, 0},
		{"(*Regexp).FindSubmatch", Method, 0},
		{"(*Regexp).FindSubmatchIndex", Method, 0},
		{"(*Regexp).LiteralPrefix", Method, 0},
		{"(*Regexp).Longest", Method, 1},
		{"(*Regexp).MarshalText", Method, 21},
		{"(*Regexp).Match", Method, 0},
		{"(*Regexp).MatchReader", Method, 0},
		{"(*Regexp).MatchString", Method, 0},
		{"(*Regexp).NumSubexp", Method, 0},
		{"(*Regexp).ReplaceAll", Method, 0},
		{"(*Regexp).ReplaceAllFunc", Method, 0},
		{"(*Regexp).ReplaceAllLiteral", Method, 0},
		{"(*Regexp).ReplaceAllLiteralString", Method, 0},
		{"(*Regexp).ReplaceAllString", Method, 0},
		{"(*Regexp).ReplaceAllStringFunc", Method, 0},
		{"(*Regexp).Split", Method, 1},
		{"(*Regexp).String", Method, 0},
		{"(*Regexp).SubexpIndex", Method, 15},
		{"(*Regexp).SubexpNames", Method, 0},
		{"(*Regexp).UnmarshalText", Method, 21},
		{"Compile", Func, 0},
		{"CompilePOSIX", Func, 0},
		{"Match", Func, 0},
		{"MatchReader", Func, 0},
		{"MatchString", Func, 0},
		{"MustCompile", Func, 0},
		{"MustCompilePOSIX", Func, 0},
		{"QuoteMeta", Func, 0},
		{"Regexp", Type, 0},
	},
	"regexp/syntax": {
		{"(*Error).Error", Method, 0},
		{"(*Inst).MatchEmptyWidth", Method, 0},
		{"(*Inst).MatchRune", Method, 0},
		{"(*Inst).MatchRunePos", Method, 3},
		{"(*Inst).String", Method, 0},
		{"(*Prog).Prefix", Method, 0},
		{"(*Prog).StartCond", Method, 0},
		{"(*Prog).String", Method, 0},
		{"(*Regexp).CapNames", Method, 0},
		{"(*Regexp).Equal", Method, 0},
		{"(*Regexp).MaxCap", Method, 0},
		{"(*Regexp).Simplify", Method, 0},
		{"(*Regexp).String", Method, 0},
		{"(ErrorCode).String", Method, 0},
		{"(InstOp).String", Method, 3},
		{"(Op).String", Method, 11},
		{"ClassNL", Const, 0},
		{"Compile", Func, 0},
		{"DotNL", Const, 0},
		{"EmptyBeginLine", Const, 0},
		{"EmptyBeginText", Const, 0},
		{"EmptyEndLine", Const, 0},
		{"EmptyEndText", Const, 0},
		{"EmptyNoWordBoundary", Const, 0},
		{"EmptyOp", Type, 0},
		{"EmptyOpContext", Func, 0},
		{"EmptyWordBoundary", Const, 0},
		{"ErrInternalError", Const, 0},
		{"ErrInvalidCharClass", Const, 0},
		{"ErrInvalidCharRange", Const, 0},
		{"ErrInvalidEscape", Const, 0},
		{"ErrInvalidNamedCapture", Const, 0},
		{"ErrInvalidPerlOp", Const, 0},
		{"ErrInvalidRepeatOp", Const, 0},
		{"ErrInvalidRepeatSize", Const, 0},
		{"ErrInvalidUTF8", Const, 0},
		{"ErrLarge", Const, 20},
		{"ErrMissingBracket", Const, 0},
		{"ErrMissingParen", Const, 0},
		{"ErrMissingRepeatArgument", Const, 0},
		{"ErrNestingDepth", Const, 19},
		{"ErrTrailingBackslash", Const, 0},
		{"ErrUnexpectedParen", Const, 1},
		{"Error", Type, 0},
		{"Error.Code", Field, 0},
		{"Error.Expr", Field, 0},
		{"ErrorCode", Type, 0},
		{"Flags", Type, 0},
		{"FoldCase", Const, 0},
		{"Inst", Type, 0},
		{"Inst.Arg", Field, 0},
		{"Inst.Op", Field, 0},
		{"Inst.Out", Field, 0},
		{"Inst.Rune", Field, 0},
		{"InstAlt", Const, 0},
		{"InstAltMatch", Const, 0},
		{"InstCapture", Const, 0},
		{"InstEmptyWidth", Const, 0},
		{"InstFail", Const, 0},
		{"InstMatch", Const, 0},
		{"InstNop", Const, 0},
		{"InstOp", Type, 0},
		{"InstRune", Const, 0},
		{"InstRune1", Const, 0},
		{"InstRuneAny", Const, 0},
		{"InstRuneAnyNotNL", Const, 0},
		{"IsWordChar", Func, 0},
		{"Literal", Const, 0},
		{"MatchNL", Const, 0},
		{"NonGreedy", Const, 0},
		{"OneLine", Const, 0},
		{"Op", Type, 0},
		{"OpAlternate", Const, 0},
		{"OpAnyChar", Const, 0},
		{"OpAnyCharNotNL", Const, 0},
		{"OpBeginLine", Const, 0},
		{"OpBeginText", Const, 0},
		{"OpCapture", Const, 0},
		{"OpCharClass", Const, 0},
		{"OpConcat", Const, 0},
		{"OpEmptyMatch", Const, 0},
		{"OpEndLine", Const, 0},
		{"OpEndText", Const, 0},
		{"OpLiteral", Const, 0},
		{"OpNoMatch", Const, 0},
		{"OpNoWordBoundary", Const, 0},
		{"OpPlus", Const, 0},
		{"OpQuest", Const, 0},
		{"OpRepeat", Const, 0},
		{"OpStar", Const, 0},
		{"OpWordBoundary", Const, 0},
		{"POSIX", Const, 0},
		{"Parse", Func, 0},
		{"Perl", Const, 0},
		{"PerlX", Const, 0},
		{"Prog", Type, 0},
		{"Prog.Inst", Field, 0},
		{"Prog.NumCap", Field, 0},
		{"Prog.Start", Field, 0},
		{"Regexp", Type, 0},
		{"Regexp.Cap", Field, 0},
		{"Regexp.Flags", Field, 0},
		{"Regexp.Max", Field, 0},
		{"Regexp.Min", Field, 0},
		{"Regexp.Name", Field, 0},
		{"Regexp.Op", Field, 0},
		{"Regexp.Rune", Field, 0},
		{"Regexp.Rune0", Field, 0},
		{"Regexp.Sub", Field, 0},
		{"Regexp.Sub0", Field, 0},
		{"Simple", Const, 0},
		{"UnicodeGroups", Const, 0},
		{"WasDollar", Const, 0},
	},
	"runtime": {
		{"(*BlockProfileRecord).Stack", Method, 1},
		{"(*Frames).Next", Method, 7},
		{"(*Func).Entry", Method, 0},
		{"(*Func).FileLine", Method, 0},
		{"(*Func).Name", Method, 0},
		{"(*MemProfileRecord).InUseBytes", Method, 0},
		{"(*MemProfileRecord).InUseObjects", Method, 0},
		{"(*MemProfileRecord).Stack", Method, 0},
		{"(*PanicNilError).Error", Method, 21},
		{"(*PanicNilError).RuntimeError", Method, 21},
		{"(*Pinner).Pin", Method, 21},
		{"(*Pinner).Unpin", Method, 21},
		{"(*StackRecord).Stack", Method, 0},
		{"(*TypeAssertionError).Error", Method, 0},
		{"(*TypeAssertionError).RuntimeError", Method, 0},
		{"(Cleanup).Stop", Method, 24},
		{"AddCleanup", Func, 24},
		{"BlockProfile", Func, 1},
		{"BlockProfileRecord", Type, 1},
		{"BlockProfileRecord.Count", Field, 1},
		{"BlockProfileRecord.Cycles", Field, 1},
		{"BlockProfileRecord.StackRecord", Field, 1},
		{"Breakpoint", Func, 0},
		{"CPUProfile", Func, 0},
		{"Caller", Func, 0},
		{"Callers", Func, 0},
		{"CallersFrames", Func, 7},
		{"Cleanup", Type, 24},
		{"Compiler", Const, 0},
		{"Error", Type, 0},
		{"Frame", Type, 7},
		{"Frame.Entry", Field, 7},
		{"Frame.File", Field, 7},
		{"Frame.Func", Field, 7},
		{"Frame.Function", Field, 7},
		{"Frame.Line", Field, 7},
		{"Frame.PC", Field, 7},
		{"Frames", Type, 7},
		{"Func", Type, 0},
		{"FuncForPC", Func, 0},
		{"GC", Func, 0},
		{"GOARCH", Const, 0},
		{"GOMAXPROCS", Func, 0},
		{"GOOS", Const, 0},
		{"GOROOT", Func, 0},
		{"Goexit", Func, 0},
		{"GoroutineProfile", Func, 0},
		{"Gosched", Func, 0},
		{"KeepAlive", Func, 7},
		{"LockOSThread", Func, 0},
		{"MemProfile", Func, 0},
		{"MemProfileRate", Var, 0},
		{"MemProfileRecord", Type, 0},
		{"MemProfileRecord.AllocBytes", Field, 0},
		{"MemProfileRecord.AllocObjects", Field, 0},
		{"MemProfileRecord.FreeBytes", Field, 0},
		{"MemProfileRecord.FreeObjects", Field, 0},
		{"MemProfileRecord.Stack0", Field, 0},
		{"MemStats", Type, 0},
		{"MemStats.Alloc", Field, 0},
		{"MemStats.BuckHashSys", Field, 0},
		{"MemStats.BySize", Field, 0},
		{"MemStats.DebugGC", Field, 0},
		{"MemStats.EnableGC", Field, 0},
		{"MemStats.Frees", Field, 0},
		{"MemStats.GCCPUFraction", Field, 5},
		{"MemStats.GCSys", Field, 2},
		{"MemStats.HeapAlloc", Field, 0},
		{"MemStats.HeapIdle", Field, 0},
		{"MemStats.HeapInuse", Field, 0},
		{"MemStats.HeapObjects", Field, 0},
		{"MemStats.HeapReleased", Field, 0},
		{"MemStats.HeapSys", Field, 0},
		{"MemStats.LastGC", Field, 0},
		{"MemStats.Lookups", Field, 0},
		{"MemStats.MCacheInuse", Field, 0},
		{"MemStats.MCacheSys", Field, 0},
		{"MemStats.MSpanInuse", Field, 0},
		{"MemStats.MSpanSys", Field, 0},
		{"MemStats.Mallocs", Field, 0},
		{"MemStats.NextGC", Field, 0},
		{"MemStats.NumForcedGC", Field, 8},
		{"MemStats.NumGC", Field, 0},
		{"MemStats.OtherSys", Field, 2},
		{"MemStats.PauseEnd", Field, 4},
		{"MemStats.PauseNs", Field, 0},
		{"MemStats.PauseTotalNs", Field, 0},
		{"MemStats.StackInuse", Field, 0},
		{"MemStats.StackSys", Field, 0},
		{"MemStats.Sys", Field, 0},
		{"MemStats.TotalAlloc", Field, 0},
		{"MutexProfile", Func, 8},
		{"NumCPU", Func, 0},
		{"NumCgoCall", Func, 0},
		{"NumGoroutine", Func, 0},
		{"PanicNilError", Type, 21},
		{"Pinner", Type, 21},
		{"ReadMemStats", Func, 0},
		{"ReadTrace", Func, 5},
		{"SetBlockProfileRate", Func, 1},
		{"SetCPUProfileRate", Func, 0},
		{"SetCgoTraceback", Func, 7},
		{"SetFinalizer", Func, 0},
		{"SetMutexProfileFraction", Func, 8},
		{"Stack", Func, 0},
		{"StackRecord", Type, 0},
		{"StackRecord.Stack0", Field, 0},
		{"StartTrace", Func, 5},
		{"StopTrace", Func, 5},
		{"ThreadCreateProfile", Func, 0},
		{"TypeAssertionError", Type, 0},
		{"UnlockOSThread", Func, 0},
		{"Version", Func, 0},
	},
	"runtime/cgo": {
		{"(Handle).Delete", Method, 17},
		{"(Handle).Value", Method, 17},
		{"Handle", Type, 17},
		{"Incomplete", Type, 20},
		{"NewHandle", Func, 17},
	},
	"runtime/coverage": {
		{"ClearCounters", Func, 20},
		{"WriteCounters", Func, 20},
		{"WriteCountersDir", Func, 20},
		{"WriteMeta", Func, 20},
		{"WriteMetaDir", Func, 20},
	},
	"runtime/debug": {
		{"(*BuildInfo).String", Method, 18},
		{"BuildInfo", Type, 12},
		{"BuildInfo.Deps", Field, 12},
		{"BuildInfo.GoVersion", Field, 18},
		{"BuildInfo.Main", Field, 12},
		{"BuildInfo.Path", Field, 12},
		{"BuildInfo.Settings", Field, 18},
		{"BuildSetting", Type, 18},
		{"BuildSetting.Key", Field, 18},
		{"BuildSetting.Value", Field, 18},
		{"CrashOptions", Type, 23},
		{"FreeOSMemory", Func, 1},
		{"GCStats", Type, 1},
		{"GCStats.LastGC", Field, 1},
		{"GCStats.NumGC", Field, 1},
		{"GCStats.Pause", Field, 1},
		{"GCStats.PauseEnd", Field, 4},
		{"GCStats.PauseQuantiles", Field, 1},
		{"GCStats.PauseTotal", Field, 1},
		{"Module", Type, 12},
		{"Module.Path", Field, 12},
		{"Module.Replace", Field, 12},
		{"Module.Sum", Field, 12},
		{"Module.Version", Field, 12},
		{"ParseBuildInfo", Func, 18},
		{"PrintStack", Func, 0},
		{"ReadBuildInfo", Func, 12},
		{"ReadGCStats", Func, 1},
		{"SetCrashOutput", Func, 23},
		{"SetGCPercent", Func, 1},
		{"SetMaxStack", Func, 2},
		{"SetMaxThreads", Func, 2},
		{"SetMemoryLimit", Func, 19},
		{"SetPanicOnFault", Func, 3},
		{"SetTraceback", Func, 6},
		{"Stack", Func, 0},
		{"WriteHeapDump", Func, 3},
	},
	"runtime/metrics": {
		{"(Value).Float64", Method, 16},
		{"(Value).Float64Histogram", Method, 16},
		{"(Value).Kind", Method, 16},
		{"(Value).Uint64", Method, 16},
		{"All", Func, 16},
		{"Description", Type, 16},
		{"Description.Cumulative", Field, 16},
		{"Description.Description", Field, 16},
		{"Description.Kind", Field, 16},
		{"Description.Name", Field, 16},
		{"Float64Histogram", Type, 16},
		{"Float64Histogram.Buckets", Field, 16},
		{"Float64Histogram.Counts", Field, 16},
		{"KindBad", Const, 16},
		{"KindFloat64", Const, 16},
		{"KindFloat64Histogram", Const, 16},
		{"KindUint64", Const, 16},
		{"Read", Func, 16},
		{"Sample", Type, 16},
		{"Sample.Name", Field, 16},
		{"Sample.Value", Field, 16},
		{"Value", Type, 16},
		{"ValueKind", Type, 16},
	},
	"runtime/pprof": {
		{"(*Profile).Add", Method, 0},
		{"(*Profile).Count", Method, 0},
		{"(*Profile).Name", Method, 0},
		{"(*Profile).Remove", Method, 0},
		{"(*Profile).WriteTo", Method, 0},
		{"Do", Func, 9},
		{"ForLabels", Func, 9},
		{"Label", Func, 9},
		{"LabelSet", Type, 9},
		{"Labels", Func, 9},
		{"Lookup", Func, 0},
		{"NewProfile", Func, 0},
		{"Profile", Type, 0},
		{"Profiles", Func, 0},
		{"SetGoroutineLabels", Func, 9},
		{"StartCPUProfile", Func, 0},
		{"StopCPUProfile", Func, 0},
		{"WithLabels", Func, 9},
		{"WriteHeapProfile", Func, 0},
	},
	"runtime/trace": {
		{"(*Region).End", Method, 11},
		{"(*Task).End", Method, 11},
		{"IsEnabled", Func, 11},
		{"Log", Func, 11},
		{"Logf", Func, 11},
		{"NewTask", Func, 11},
		{"Region", Type, 11},
		{"Start", Func, 5},
		{"StartRegion", Func, 11},
		{"Stop", Func, 5},
		{"Task", Type, 11},
		{"WithRegion", Func, 11},
	},
	"slices": {
		{"All", Func, 23},
		{"AppendSeq", Func, 23},
		{"Backward", Func, 23},
		{"BinarySearch", Func, 21},
		{"BinarySearchFunc", Func, 21},
		{"Chunk", Func, 23},
		{"Clip", Func, 21},
		{"Clone", Func, 21},
		{"Collect", Func, 23},
		{"Compact", Func, 21},
		{"CompactFunc", Func, 21},
		{"Compare", Func, 21},
		{"CompareFunc", Func, 21},
		{"Concat", Func, 22},
		{"Contains", Func, 21},
		{"ContainsFunc", Func, 21},
		{"Delete", Func, 21},
		{"DeleteFunc", Func, 21},
		{"Equal", Func, 21},
		{"EqualFunc", Func, 21},
		{"Grow", Func, 21},
		{"Index", Func, 21},
		{"IndexFunc", Func, 21},
		{"Insert", Func, 21},
		{"IsSorted", Func, 21},
		{"IsSortedFunc", Func, 21},
		{"Max", Func, 21},
		{"MaxFunc", Func, 21},
		{"Min", Func, 21},
		{"MinFunc", Func, 21},
		{"Repeat", Func, 23},
		{"Replace", Func, 21},
		{"Reverse", Func, 21},
		{"Sort", Func, 21},
		{"SortFunc", Func, 21},
		{"SortStableFunc", Func, 21},
		{"Sorted", Func, 23},
		{"SortedFunc", Func, 23},
		{"SortedStableFunc", Func, 23},
		{"Values", Func, 23},
	},
	"sort": {
		{"(Float64Slice).Len", Method, 0},
		{"(Float64Slice).Less", Method, 0},
		{"(Float64Slice).Search", Method, 0},
		{"(Float64Slice).Sort", Method, 0},
		{"(Float64Slice).Swap", Method, 0},
		{"(IntSlice).Len", Method, 0},
		{"(IntSlice).Less", Method, 0},
		{"(IntSlice).Search", Method, 0},
		{"(IntSlice).Sort", Method, 0},
		{"(IntSlice).Swap", Method, 0},
		{"(StringSlice).Len", Method, 0},
		{"(StringSlice).Less", Method, 0},
		{"(StringSlice).Search", Method, 0},
		{"(StringSlice).Sort", Method, 0},
		{"(StringSlice).Swap", Method, 0},
		{"Find", Func, 19},
		{"Float64Slice", Type, 0},
		{"Float64s", Func, 0},
		{"Float64sAreSorted", Func, 0},
		{"IntSlice", Type, 0},
		{"Interface", Type, 0},
		{"Ints", Func, 0},
		{"IntsAreSorted", Func, 0},
		{"IsSorted", Func, 0},
		{"Reverse", Func, 1},
		{"Search", Func, 0},
		{"SearchFloat64s", Func, 0},
		{"SearchInts", Func, 0},
		{"SearchStrings", Func, 0},
		{"Slice", Func, 8},
		{"SliceIsSorted", Func, 8},
		{"SliceStable", Func, 8},
		{"Sort", Func, 0},
		{"Stable", Func, 2},
		{"StringSlice", Type, 0},
		{"Strings", Func, 0},
		{"StringsAreSorted", Func, 0},
	},
	"strconv": {
		{"(*NumError).Error", Method, 0},
		{"(*NumError).Unwrap", Method, 14},
		{"AppendBool", Func, 0},
		{"AppendFloat", Func, 0},
		{"AppendInt", Func, 0},
		{"AppendQuote", Func, 0},
		{"AppendQuoteRune", Func, 0},
		{"AppendQuoteRuneToASCII", Func, 0},
		{"AppendQuoteRuneToGraphic", Func, 6},
		{"AppendQuoteToASCII", Func, 0},
		{"AppendQuoteToGraphic", Func, 6},
		{"AppendUint", Func, 0},
		{"Atoi", Func, 0},
		{"CanBackquote", Func, 0},
		{"ErrRange", Var, 0},
		{"ErrSyntax", Var, 0},
		{"FormatBool", Func, 0},
		{"FormatComplex", Func, 15},
		{"FormatFloat", Func, 0},
		{"FormatInt", Func, 0},
		{"FormatUint", Func, 0},
		{"IntSize", Const, 0},
		{"IsGraphic", Func, 6},
		{"IsPrint", Func, 0},
		{"Itoa", Func, 0},
		{"NumError", Type, 0},
		{"NumError.Err", Field, 0},
		{"NumError.Func", Field, 0},
		{"NumError.Num", Field, 0},
		{"ParseBool", Func, 0},
		{"ParseComplex", Func, 15},
		{"ParseFloat", Func, 0},
		{"ParseInt", Func, 0},
		{"ParseUint", Func, 0},
		{"Quote", Func, 0},
		{"QuoteRune", Func, 0},
		{"QuoteRuneToASCII", Func, 0},
		{"QuoteRuneToGraphic", Func, 6},
		{"QuoteToASCII", Func, 0},
		{"QuoteToGraphic", Func, 6},
		{"QuotedPrefix", Func, 17},
		{"Unquote", Func, 0},
		{"UnquoteChar", Func, 0},
	},
	"strings": {
		{"(*Builder).Cap", Method, 12},
		{"(*Builder).Grow", Method, 10},
		{"(*Builder).Len", Method, 10},
		{"(*Builder).Reset", Method, 10},
		{"(*Builder).String", Method, 10},
		{"(*Builder).Write", Method, 10},
		{"(*Builder).WriteByte", Method, 10},
		{"(*Builder).WriteRune", Method, 10},
		{"(*Builder).WriteString", Method, 10},
		{"(*Reader).Len", Method, 0},
		{"(*Reader).Read", Method, 0},
		{"(*Reader).ReadAt", Method, 0},
		{"(*Reader).ReadByte", Method, 0},
		{"(*Reader).ReadRune", Method, 0},
		{"(*Reader).Reset", Method, 7},
		{"(*Reader).Seek", Method, 0},
		{"(*Reader).Size", Method, 5},
		{"(*Reader).UnreadByte", Method, 0},
		{"(*Reader).UnreadRune", Method, 0},
		{"(*Reader).WriteTo", Method, 1},
		{"(*Replacer).Replace", Method, 0},
		{"(*Replacer).WriteString", Method, 0},
		{"Builder", Type, 10},
		{"Clone", Func, 18},
		{"Compare", Func, 5},
		{"Contains", Func, 0},
		{"ContainsAny", Func, 0},
		{"ContainsFunc", Func, 21},
		{"ContainsRune", Func, 0},
		{"Count", Func, 0},
		{"Cut", Func, 18},
		{"CutPrefix", Func, 20},
		{"CutSuffix", Func, 20},
		{"EqualFold", Func, 0},
		{"Fields", Func, 0},
		{"FieldsFunc", Func, 0},
		{"FieldsFuncSeq", Func, 24},
		{"FieldsSeq", Func, 24},
		{"HasPrefix", Func, 0},
		{"HasSuffix", Func, 0},
		{"Index", Func, 0},
		{"IndexAny", Func, 0},
		{"IndexByte", Func, 2},
		{"IndexFunc", Func, 0},
		{"IndexRune", Func, 0},
		{"Join", Func, 0},
		{"LastIndex", Func, 0},
		{"LastIndexAny", Func, 0},
		{"LastIndexByte", Func, 5},
		{"LastIndexFunc", Func, 0},
		{"Lines", Func, 24},
		{"Map", Func, 0},
		{"NewReader", Func, 0},
		{"NewReplacer", Func, 0},
		{"Reader", Type, 0},
		{"Repeat", Func, 0},
		{"Replace", Func, 0},
		{"ReplaceAll", Func, 12},
		{"Replacer", Type, 0},
		{"Split", Func, 0},
		{"SplitAfter", Func, 0},
		{"SplitAfterN", Func, 0},
		{"SplitAfterSeq", Func, 24},
		{"SplitN", Func, 0},
		{"SplitSeq", Func, 24},
		{"Title", Func, 0},
		{"ToLower", Func, 0},
		{"ToLowerSpecial", Func, 0},
		{"ToTitle", Func, 0},
		{"ToTitleSpecial", Func, 0},
		{"ToUpper", Func, 0},
		{"ToUpperSpecial", Func, 0},
		{"ToValidUTF8", Func, 13},
		{"Trim", Func, 0},
		{"TrimFunc", Func, 0},
		{"TrimLeft", Func, 0},
		{"TrimLeftFunc", Func, 0},
		{"TrimPrefix", Func, 1},
		{"TrimRight", Func, 0},
		{"TrimRightFunc", Func, 0},
		{"TrimSpace", Func, 0},
		{"TrimSuffix", Func, 1},
	},
	"structs": {
		{"HostLayout", Type, 23},
	},
	"sync": {
		{"(*Cond).Broadcast", Method, 0},
		{"(*Cond).Signal", Method, 0},
		{"(*Cond).Wait", Method, 0},
		{"(*Map).Clear", Method, 23},
		{"(*Map).CompareAndDelete", Method, 20},
		{"(*Map).CompareAndSwap", Method, 20},
		{"(*Map).Delete", Method, 9},
		{"(*Map).Load", Method, 9},
		{"(*Map).LoadAndDelete", Method, 15},
		{"(*Map).LoadOrStore", Method, 9},
		{"(*Map).Range", Method, 9},
		{"(*Map).Store", Method, 9},
		{"(*Map).Swap", Method, 20},
		{"(*Mutex).Lock", Method, 0},
		{"(*Mutex).TryLock", Method, 18},
		{"(*Mutex).Unlock", Method, 0},
		{"(*Once).Do", Method, 0},
		{"(*Pool).Get", Method, 3},
		{"(*Pool).Put", Method, 3},
		{"(*RWMutex).Lock", Method, 0},
		{"(*RWMutex).RLock", Method, 0},
		{"(*RWMutex).RLocker", Method, 0},
		{"(*RWMutex).RUnlock", Method, 0},
		{"(*RWMutex).TryLock", Method, 18},
		{"(*RWMutex).TryRLock", Method, 18},
		{"(*RWMutex).Unlock", Method, 0},
		{"(*WaitGroup).Add", Method, 0},
		{"(*WaitGroup).Done", Method, 0},
		{"(*WaitGroup).Wait", Method, 0},
		{"Cond", Type, 0},
		{"Cond.L", Field, 0},
		{"Locker", Type, 0},
		{"Map", Type, 9},
		{"Mutex", Type, 0},
		{"NewCond", Func, 0},
		{"Once", Type, 0},
		{"OnceFunc", Func, 21},
		{"OnceValue", Func, 21},
		{"OnceValues", Func, 21},
		{"Pool", Type, 3},
		{"Pool.New", Field, 3},
		{"RWMutex", Type, 0},
		{"WaitGroup", Type, 0},
	},
	"sync/atomic": {
		{"(*Bool).CompareAndSwap", Method, 19},
		{"(*Bool).Load", Method, 19},
		{"(*Bool).Store", Method, 19},
		{"(*Bool).Swap", Method, 19},
		{"(*Int32).Add", Method, 19},
		{"(*Int32).And", Method, 23},
		{"(*Int32).CompareAndSwap", Method, 19},
		{"(*Int32).Load", Method, 19},
		{"(*Int32).Or", Method, 23},
		{"(*Int32).Store", Method, 19},
		{"(*Int32).Swap", Method, 19},
		{"(*Int64).Add", Method, 19},
		{"(*Int64).And", Method, 23},
		{"(*Int64).CompareAndSwap", Method, 19},
		{"(*Int64).Load", Method, 19},
		{"(*Int64).Or", Method, 23},
		{"(*Int64).Store", Method, 19},
		{"(*Int64).Swap", Method, 19},
		{"(*Pointer).CompareAndSwap", Method, 19},
		{"(*Pointer).Load", Method, 19},
		{"(*Pointer).Store", Method, 19},
		{"(*Pointer).Swap", Method, 19},
		{"(*Uint32).Add", Method, 19},
		{"(*Uint32).And", Method, 23},
		{"(*Uint32).CompareAndSwap", Method, 19},
		{"(*Uint32).Load", Method, 19},
		{"(*Uint32).Or", Method, 23},
		{"(*Uint32).Store", Method, 19},
		{"(*Uint32).Swap", Method, 19},
		{"(*Uint64).Add", Method, 19},
		{"(*Uint64).And", Method, 23},
		{"(*Uint64).CompareAndSwap", Method, 19},
		{"(*Uint64).Load", Method, 19},
		{"(*Uint64).Or", Method, 23},
		{"(*Uint64).Store", Method, 19},
		{"(*Uint64).Swap", Method, 19},
		{"(*Uintptr).Add", Method, 19},
		{"(*Uintptr).And", Method, 23},
		{"(*Uintptr).CompareAndSwap", Method, 19},
		{"(*Uintptr).Load", Method, 19},
		{"(*Uintptr).Or", Method, 23},
		{"(*Uintptr).Store", Method, 19},
		{"(*Uintptr).Swap", Method, 19},
		{"(*Value).CompareAndSwap", Method, 17},
		{"(*Value).Load", Method, 4},
		{"(*Value).Store", Method, 4},
		{"(*Value).Swap", Method, 17},
		{"AddInt32", Func, 0},
		{"AddInt64", Func, 0},
		{"AddUint32", Func, 0},
		{"AddUint64", Func, 0},
		{"AddUintptr", Func, 0},
		{"AndInt32", Func, 23},
		{"AndInt64", Func, 23},
		{"AndUint32", Func, 23},
		{"AndUint64", Func, 23},
		{"AndUintptr", Func, 23},
		{"Bool", Type, 19},
		{"CompareAndSwapInt32", Func, 0},
		{"CompareAndSwapInt64", Func, 0},
		{"CompareAndSwapPointer", Func, 0},
		{"CompareAndSwapUint32", Func, 0},
		{"CompareAndSwapUint64", Func, 0},
		{"CompareAndSwapUintptr", Func, 0},
		{"Int32", Type, 19},
		{"Int64", Type, 19},
		{"LoadInt32", Func, 0},
		{"LoadInt64", Func, 0},
		{"LoadPointer", Func, 0},
		{"LoadUint32", Func, 0},
		{"LoadUint64", Func, 0},
		{"LoadUintptr", Func, 0},
		{"OrInt32", Func, 23},
		{"OrInt64", Func, 23},
		{"OrUint32", Func, 23},
		{"OrUint64", Func, 23},
		{"OrUintptr", Func, 23},
		{"Pointer", Type, 19},
		{"StoreInt32", Func, 0},
		{"StoreInt64", Func, 0},
		{"StorePointer", Func, 0},
		{"StoreUint32", Func, 0},
		{"StoreUint64", Func, 0},
		{"StoreUintptr", Func, 0},
		{"SwapInt32", Func, 2},
		{"SwapInt64", Func, 2},
		{"SwapPointer", Func, 2},
		{"SwapUint32", Func, 2},
		{"SwapUint64", Func, 2},
		{"SwapUintptr", Func, 2},
		{"Uint32", Type, 19},
		{"Uint64", Type, 19},
		{"Uintptr", Type, 19},
		{"Value", Type, 4},
	},
	"syscall": {
		{"(*Cmsghdr).SetLen", Method, 0},
		{"(*DLL).FindProc", Method, 0},
		{"(*DLL).MustFindProc", Method, 0},
		{"(*DLL).Release", Method, 0},
		{"(*DLLError).Error", Method, 0},
		{"(*DLLError).Unwrap", Method, 16},
		{"(*Filetime).Nanoseconds", Method, 0},
		{"(*Iovec).SetLen", Method, 0},
		{"(*LazyDLL).Handle", Method, 0},
		{"(*LazyDLL).Load", Method, 0},
		{"(*LazyDLL).NewProc", Method, 0},
		{"(*LazyProc).Addr", Method, 0},
		{"(*LazyProc).Call", Method, 0},
		{"(*LazyProc).Find", Method, 0},
		{"(*Msghdr).SetControllen", Method, 0},
		{"(*Proc).Addr", Method, 0},
		{"(*Proc).Call", Method, 0},
		{"(*PtraceRegs).PC", Method, 0},
		{"(*PtraceRegs).SetPC", Method, 0},
		{"(*RawSockaddrAny).Sockaddr", Method, 0},
		{"(*SID).Copy", Method, 0},
		{"(*SID).Len", Method, 0},
		{"(*SID).LookupAccount", Method, 0},
		{"(*SID).String", Method, 0},
		{"(*Timespec).Nano", Method, 0},
		{"(*Timespec).Unix", Method, 0},
		{"(*Timeval).Nano", Method, 0},
		{"(*Timeval).Nanoseconds", Method, 0},
		{"(*Timeval).Unix", Method, 0},
		{"(Errno).Error", Method, 0},
		{"(Errno).Is", Method, 13},
		{"(Errno).Temporary", Method, 0},
		{"(Errno).Timeout", Method, 0},
		{"(Signal).Signal", Method, 0},
		{"(Signal).String", Method, 0},
		{"(Token).Close", Method, 0},
		{"(Token).GetTokenPrimaryGroup", Method, 0},
		{"(Token).GetTokenUser", Method, 0},
		{"(Token).GetUserProfileDirectory", Method, 0},
		{"(WaitStatus).Continued", Method, 0},
		{"(WaitStatus).CoreDump", Method, 0},
		{"(WaitStatus).ExitStatus", Method, 0},
		{"(WaitStatus).Exited", Method, 0},
		{"(WaitStatus).Signal", Method, 0},
		{"(WaitStatus).Signaled", Method, 0},
		{"(WaitStatus).StopSignal", Method, 0},
		{"(WaitStatus).Stopped", Method, 0},
		{"(WaitStatus).TrapCause", Method, 0},
		{"AF_ALG", Const, 0},
		{"AF_APPLETALK", Const, 0},
		{"AF_ARP", Const, 0},
		{"AF_ASH", Const, 0},
		{"AF_ATM", Const, 0},
		{"AF_ATMPVC", Const, 0},
		{"AF_ATMSVC", Const, 0},
		{"AF_AX25", Const, 0},
		{"AF_BLUETOOTH", Const, 0},
		{"AF_BRIDGE", Const, 0},
		{"AF_CAIF", Const, 0},
		{"AF_CAN", Const, 0},
		{"AF_CCITT", Const, 0},
		{"AF_CHAOS", Const, 0},
		{"AF_CNT", Const, 0},
		{"AF_COIP", Const, 0},
		{"AF_DATAKIT", Const, 0},
		{"AF_DECnet", Const, 0},
		{"AF_DLI", Const, 0},
		{"AF_E164", Const, 0},
		{"AF_ECMA", Const, 0},
		{"AF_ECONET", Const, 0},
		{"AF_ENCAP", Const, 1},
		{"AF_FILE", Const, 0},
		{"AF_HYLINK", Const, 0},
		{"AF_IEEE80211", Const, 0},
		{"AF_IEEE802154", Const, 0},
		{"AF_IMPLINK", Const, 0},
		{"AF_INET", Const, 0},
		{"AF_INET6", Const, 0},
		{"AF_INET6_SDP", Const, 3},
		{"AF_INET_SDP", Const, 3},
		{"AF_IPX", Const, 0},
		{"AF_IRDA", Const, 0},
		{"AF_ISDN", Const, 0},
		{"AF_ISO", Const, 0},
		{"AF_IUCV", Const, 0},
		{"AF_KEY", Const, 0},
		{"AF_LAT", Const, 0},
		{"AF_LINK", Const, 0},
		{"AF_LLC", Const, 0},
		{"AF_LOCAL", Const, 0},
		{"AF_MAX", Const, 0},
		{"AF_MPLS", Const, 1},
		{"AF_NATM", Const, 0},
		{"AF_NDRV", Const, 0},
		{"AF_NETBEUI", Const, 0},
		{"AF_NETBIOS", Const, 0},
		{"AF_NETGRAPH", Const, 0},
		{"AF_NETLINK", Const, 0},
		{"AF_NETROM", Const, 0},
		{"AF_NS", Const, 0},
		{"AF_OROUTE", Const, 1},
		{"AF_OSI", Const, 0},
		{"AF_PACKET", Const, 0},
		{"AF_PHONET", Const, 0},
		{"AF_PPP", Const, 0},
		{"AF_PPPOX", Const, 0},
		{"AF_PUP", Const, 0},
		{"AF_RDS", Const, 0},
		{"AF_RESERVED_36", Const, 0},
		{"AF_ROSE", Const, 0},
		{"AF_ROUTE", Const, 0},
		{"AF_RXRPC", Const, 0},
		{"AF_SCLUSTER", Const, 0},
		{"AF_SECURITY", Const, 0},
		{"AF_SIP", Const, 0},
		{"AF_SLOW", Const, 0},
		{"AF_SNA", Const, 0},
		{"AF_SYSTEM", Const, 0},
		{"AF_TIPC", Const, 0},
		{"AF_UNIX", Const, 0},
		{"AF_UNSPEC", Const, 0},
		{"AF_UTUN", Const, 16},
		{"AF_VENDOR00", Const, 0},
		{"AF_VENDOR01", Const, 0},
		{"AF_VENDOR02", Const, 0},
		{"AF_VENDOR03", Const, 0},
		{"AF_VENDOR04", Const, 0},
		{"AF_VENDOR05", Const, 0},
		{"AF_VENDOR06", Const, 0},
		{"AF_VENDOR07", Const, 0},
		{"AF_VENDOR08", Const, 0},
		{"AF_VENDOR09", Const, 0},
		{"AF_VENDOR10", Const, 0},
		{"AF_VENDOR11", Const, 0},
		{"AF_VENDOR12", Const, 0},
		{"AF_VENDOR13", Const, 0},
		{"AF_VENDOR14", Const, 0},
		{"AF_VENDOR15", Const, 0},
		{"AF_VENDOR16", Const, 0},
		{"AF_VENDOR17", Const, 0},
		{"AF_VENDOR18", Const, 0},
		{"AF_VENDOR19", Const, 0},
		{"AF_VENDOR20", Const, 0},
		{"AF_VENDOR21", Const, 0},
		{"AF_VENDOR22", Const, 0},
		{"AF_VENDOR23", Const, 0},
		{"AF_VENDOR24", Const, 0},
		{"AF_VENDOR25", Const, 0},
		{"AF_VENDOR26", Const, 0},
		{"AF_VENDOR27", Const, 0},
		{"AF_VENDOR28", Const, 0},
		{"AF_VENDOR29", Const, 0},
		{"AF_VENDOR30", Const, 0},
		{"AF_VENDOR31", Const, 0},
		{"AF_VENDOR32", Const, 0},
		{"AF_VENDOR33", Const, 0},
		{"AF_VENDOR34", Const, 0},
		{"AF_VENDOR35", Const, 0},
		{"AF_VENDOR36", Const, 0},
		{"AF_VENDOR37", Const, 0},
		{"AF_VENDOR38", Const, 0},
		{"AF_VENDOR39", Const, 0},
		{"AF_VENDOR40", Const, 0},
		{"AF_VENDOR41", Const, 0},
		{"AF_VENDOR42", Const, 0},
		{"AF_VENDOR43", Const, 0},
		{"AF_VENDOR44", Const, 0},
		{"AF_VENDOR45", Const, 0},
		{"AF_VENDOR46", Const, 0},
		{"AF_VENDOR47", Const, 0},
		{"AF_WANPIPE", Const, 0},
		{"AF_X25", Const, 0},
		{"AI_CANONNAME", Const, 1},
		{"AI_NUMERICHOST", Const, 1},
		{"AI_PASSIVE", Const, 1},
		{"APPLICATION_ERROR", Const, 0},
		{"ARPHRD_ADAPT", Const, 0},
		{"ARPHRD_APPLETLK", Const, 0},
		{"ARPHRD_ARCNET", Const, 0},
		{"ARPHRD_ASH", Const, 0},
		{"ARPHRD_ATM", Const, 0},
		{"ARPHRD_AX25", Const, 0},
		{"ARPHRD_BIF", Const, 0},
		{"ARPHRD_CHAOS", Const, 0},
		{"ARPHRD_CISCO", Const, 0},
		{"ARPHRD_CSLIP", Const, 0},
		{"ARPHRD_CSLIP6", Const, 0},
		{"ARPHRD_DDCMP", Const, 0},
		{"ARPHRD_DLCI", Const, 0},
		{"ARPHRD_ECONET", Const, 0},
		{"ARPHRD_EETHER", Const, 0},
		{"ARPHRD_ETHER", Const, 0},
		{"ARPHRD_EUI64", Const, 0},
		{"ARPHRD_FCAL", Const, 0},
		{"ARPHRD_FCFABRIC", Const, 0},
		{"ARPHRD_FCPL", Const, 0},
		{"ARPHRD_FCPP", Const, 0},
		{"ARPHRD_FDDI", Const, 0},
		{"ARPHRD_FRAD", Const, 0},
		{"ARPHRD_FRELAY", Const, 1},
		{"ARPHRD_HDLC", Const, 0},
		{"ARPHRD_HIPPI", Const, 0},
		{"ARPHRD_HWX25", Const, 0},
		{"ARPHRD_IEEE1394", Const, 0},
		{"ARPHRD_IEEE802", Const, 0},
		{"ARPHRD_IEEE80211", Const, 0},
		{"ARPHRD_IEEE80211_PRISM", Const, 0},
		{"ARPHRD_IEEE80211_RADIOTAP", Const, 0},
		{"ARPHRD_IEEE802154", Const, 0},
		{"ARPHRD_IEEE802154_PHY", Const, 0},
		{"ARPHRD_IEEE802_TR", Const, 0},
		{"ARPHRD_INFINIBAND", Const, 0},
		{"ARPHRD_IPDDP", Const, 0},
		{"ARPHRD_IPGRE", Const, 0},
		{"ARPHRD_IRDA", Const, 0},
		{"ARPHRD_LAPB", Const, 0},
		{"ARPHRD_LOCALTLK", Const, 0},
		{"ARPHRD_LOOPBACK", Const, 0},
		{"ARPHRD_METRICOM", Const, 0},
		{"ARPHRD_NETROM", Const, 0},
		{"ARPHRD_NONE", Const, 0},
		{"ARPHRD_PIMREG", Const, 0},
		{"ARPHRD_PPP", Const, 0},
		{"ARPHRD_PRONET", Const, 0},
		{"ARPHRD_RAWHDLC", Const, 0},
		{"ARPHRD_ROSE", Const, 0},
		{"ARPHRD_RSRVD", Const, 0},
		{"ARPHRD_SIT", Const, 0},
		{"ARPHRD_SKIP", Const, 0},
		{"ARPHRD_SLIP", Const, 0},
		{"ARPHRD_SLIP6", Const, 0},
		{"ARPHRD_STRIP", Const, 1},
		{"ARPHRD_TUNNEL", Const, 0},
		{"ARPHRD_TUNNEL6", Const, 0},
		{"ARPHRD_VOID", Const, 0},
		{"ARPHRD_X25", Const, 0},
		{"AUTHTYPE_CLIENT", Const, 0},
		{"AUTHTYPE_SERVER", Const, 0},
		{"Accept", Func, 0},
		{"Accept4", Func, 1},
		{"AcceptEx", Func, 0},
		{"Access", Func, 0},
		{"Acct", Func, 0},
		{"AddrinfoW", Type, 1},
		{"AddrinfoW.Addr", Field, 1},
		{"AddrinfoW.Addrlen", Field, 1},
		{"AddrinfoW.Canonname", Field, 1},
		{"AddrinfoW.Family", Field, 1},
		{"AddrinfoW.Flags", Field, 1},
		{"AddrinfoW.Next", Field, 1},
		{"AddrinfoW.Protocol", Field, 1},
		{"AddrinfoW.Socktype", Field, 1},
		{"Adjtime", Func, 0},
		{"Adjtimex", Func, 0},
		{"AllThreadsSyscall", Func, 16},
		{"AllThreadsSyscall6", Func, 16},
		{"AttachLsf", Func, 0},
		{"B0", Const, 0},
		{"B1000000", Const, 0},
		{"B110", Const, 0},
		{"B115200", Const, 0},
		{"B1152000", Const, 0},
		{"B1200", Const, 0},
		{"B134", Const, 0},
		{"B14400", Const, 1},
		{"B150", Const, 0},
		{"B1500000", Const, 0},
		{"B1800", Const, 0},
		{"B19200", Const, 0},
		{"B200", Const, 0},
		{"B2000000", Const, 0},
		{"B230400", Const, 0},
		{"B2400", Const, 0},
		{"B2500000", Const, 0},
		{"B28800", Const, 1},
		{"B300", Const, 0},
		{"B3000000", Const, 0},
		{"B3500000", Const, 0},
		{"B38400", Const, 0},
		{"B4000000", Const, 0},
		{"B460800", Const, 0},
		{"B4800", Const, 0},
		{"B50", Const, 0},
		{"B500000", Const, 0},
		{"B57600", Const, 0},
		{"B576000", Const, 0},
		{"B600", Const, 0},
		{"B7200", Const, 1},
		{"B75", Const, 0},
		{"B76800", Const, 1},
		{"B921600", Const, 0},
		{"B9600", Const, 0},
		{"BASE_PROTOCOL", Const, 2},
		{"BIOCFEEDBACK", Const, 0},
		{"BIOCFLUSH", Const, 0},
		{"BIOCGBLEN", Const, 0},
		{"BIOCGDIRECTION", Const, 0},
		{"BIOCGDIRFILT", Const, 1},
		{"BIOCGDLT", Const, 0},
		{"BIOCGDLTLIST", Const, 0},
		{"BIOCGETBUFMODE", Const, 0},
		{"BIOCGETIF", Const, 0},
		{"BIOCGETZMAX", Const, 0},
		{"BIOCGFEEDBACK", Const, 1},
		{"BIOCGFILDROP", Const, 1},
		{"BIOCGHDRCMPLT", Const, 0},
		{"BIOCGRSIG", Const, 0},
		{"BIOCGRTIMEOUT", Const, 0},
		{"BIOCGSEESENT", Const, 0},
		{"BIOCGSTATS", Const, 0},
		{"BIOCGSTATSOLD", Const, 1},
		{"BIOCGTSTAMP", Const, 1},
		{"BIOCIMMEDIATE", Const, 0},
		{"BIOCLOCK", Const, 0},
		{"BIOCPROMISC", Const, 0},
		{"BIOCROTZBUF", Const, 0},
		{"BIOCSBLEN", Const, 0},
		{"BIOCSDIRECTION", Const, 0},
		{"BIOCSDIRFILT", Const, 1},
		{"BIOCSDLT", Const, 0},
		{"BIOCSETBUFMODE", Const, 0},
		{"BIOCSETF", Const, 0},
		{"BIOCSETFNR", Const, 0},
		{"BIOCSETIF", Const, 0},
		{"BIOCSETWF", Const, 0},
		{"BIOCSETZBUF", Const, 0},
		{"BIOCSFEEDBACK", Const, 1},
		{"BIOCSFILDROP", Const, 1},
		{"BIOCSHDRCMPLT", Const, 0},
		{"BIOCSRSIG", Const, 0},
		{"BIOCSRTIMEOUT", Const, 0},
		{"BIOCSSEESENT", Const, 0},
		{"BIOCSTCPF", Const, 1},
		{"BIOCSTSTAMP", Const, 1},
		{"BIOCSUDPF", Const, 1},
		{"BIOCVERSION", Const, 0},
		{"BPF_A", Const, 0},
		{"BPF_ABS", Const, 0},
		{"BPF_ADD", Const, 0},
		{"BPF_ALIGNMENT", Const, 0},
		{"BPF_ALIGNMENT32", Const, 1},
		{"BPF_ALU", Const, 0},
		{"BPF_AND", Const, 0},
		{"BPF_B", Const, 0},
		{"BPF_BUFMODE_BUFFER", Const, 0},
		{"BPF_BUFMODE_ZBUF", Const, 0},
		{"BPF_DFLTBUFSIZE", Const, 1},
		{"BPF_DIRECTION_IN", Const, 1},
		{"BPF_DIRECTION_OUT", Const, 1},
		{"BPF_DIV", Const, 0},
		{"BPF_H", Const, 0},
		{"BPF_IMM", Const, 0},
		{"BPF_IND", Const, 0},
		{"BPF_JA", Const, 0},
		{"BPF_JEQ", Const, 0},
		{"BPF_JGE", Const, 0},
		{"BPF_JGT", Const, 0},
		{"BPF_JMP", Const, 0},
		{"BPF_JSET", Const, 0},
		{"BPF_K", Const, 0},
		{"BPF_LD", Const, 0},
		{"BPF_LDX", Const, 0},
		{"BPF_LEN", Const, 0},
		{"BPF_LSH", Const, 0},
		{"BPF_MAJOR_VERSION", Const, 0},
		{"BPF_MAXBUFSIZE", Const, 0},
		{"BPF_MAXINSNS", Const, 0},
		{"BPF_MEM", Const, 0},
		{"BPF_MEMWORDS", Const, 0},
		{"BPF_MINBUFSIZE", Const, 0},
		{"BPF_MINOR_VERSION", Const, 0},
		{"BPF_MISC", Const, 0},
		{"BPF_MSH", Const, 0},
		{"BPF_MUL", Const, 0},
		{"BPF_NEG", Const, 0},
		{"BPF_OR", Const, 0},
		{"BPF_RELEASE", Const, 0},
		{"BPF_RET", Const, 0},
		{"BPF_RSH", Const, 0},
		{"BPF_ST", Const, 0},
		{"BPF_STX", Const, 0},
		{"BPF_SUB", Const, 0},
		{"BPF_TAX", Const, 0},
		{"BPF_TXA", Const, 0},
		{"BPF_T_BINTIME", Const, 1},
		{"BPF_T_BINTIME_FAST", Const, 1},
		{"BPF_T_BINTIME_MONOTONIC", Const, 1},
		{"BPF_T_BINTIME_MONOTONIC_FAST", Const, 1},
		{"BPF_T_FAST", Const, 1},
		{"BPF_T_FLAG_MASK", Const, 1},
		{"BPF_T_FORMAT_MASK", Const, 1},
		{"BPF_T_MICROTIME", Const, 1},
		{"BPF_T_MICROTIME_FAST", Const, 1},
		{"BPF_T_MICROTIME_MONOTONIC", Const, 1},
		{"BPF_T_MICROTIME_MONOTONIC_FAST", Const, 1},
		{"BPF_T_MONOTONIC", Const, 1},
		{"BPF_T_MONOTONIC_FAST", Const, 1},
		{"BPF_T_NANOTIME", Const, 1},
		{"BPF_T_NANOTIME_FAST", Const, 1},
		{"BPF_T_NANOTIME_MONOTONIC", Const, 1},
		{"BPF_T_NANOTIME_MONOTONIC_FAST", Const, 1},
		{"BPF_T_NONE", Const, 1},
		{"BPF_T_NORMAL", Const, 1},
		{"BPF_W", Const, 0},
		{"BPF_X", Const, 0},
		{"BRKINT", Const, 0},
		{"Bind", Func, 0},
		{"BindToDevice", Func, 0},
		{"BpfBuflen", Func, 0},
		{"BpfDatalink", Func, 0},
		{"BpfHdr", Type, 0},
		{"BpfHdr.Caplen", Field, 0},
		{"BpfHdr.Datalen", Field, 0},
		{"BpfHdr.Hdrlen", Field, 0},
		{"BpfHdr.Pad_cgo_0", Field, 0},
		{"BpfHdr.Tstamp", Field, 0},
		{"BpfHeadercmpl", Func, 0},
		{"BpfInsn", Type, 0},
		{"BpfInsn.Code", Field, 0},
		{"BpfInsn.Jf", Field, 0},
		{"BpfInsn.Jt", Field, 0},
		{"BpfInsn.K", Field, 0},
		{"BpfInterface", Func, 0},
		{"BpfJump", Func, 0},
		{"BpfProgram", Type, 0},
		{"BpfProgram.Insns", Field, 0},
		{"BpfProgram.Len", Field, 0},
		{"BpfProgram.Pad_cgo_0", Field, 0},
		{"BpfStat", Type, 0},
		{"BpfStat.Capt", Field, 2},
		{"BpfStat.Drop", Field, 0},
		{"BpfStat.Padding", Field, 2},
		{"BpfStat.Recv", Field, 0},
		{"BpfStats", Func, 0},
		{"BpfStmt", Func, 0},
		{"BpfTimeout", Func, 0},
		{"BpfTimeval", Type, 2},
		{"BpfTimeval.Sec", Field, 2},
		{"BpfTimeval.Usec", Field, 2},
		{"BpfVersion", Type, 0},
		{"BpfVersion.Major", Field, 0},
		{"BpfVersion.Minor", Field, 0},
		{"BpfZbuf", Type, 0},
		{"BpfZbuf.Bufa", Field, 0},
		{"BpfZbuf.Bufb", Field, 0},
		{"BpfZbuf.Buflen", Field, 0},
		{"BpfZbufHeader", Type, 0},
		{"BpfZbufHeader.Kernel_gen", Field, 0},
		{"BpfZbufHeader.Kernel_len", Field, 0},
		{"BpfZbufHeader.User_gen", Field, 0},
		{"BpfZbufHeader.X_bzh_pad", Field, 0},
		{"ByHandleFileInformation", Type, 0},
		{"ByHandleFileInformation.CreationTime", Field, 0},
		{"ByHandleFileInformation.FileAttributes", Field, 0},
		{"ByHandleFileInformation.FileIndexHigh", Field, 0},
		{"ByHandleFileInformation.FileIndexLow", Field, 0},
		{"ByHandleFileInformation.FileSizeHigh", Field, 0},
		{"ByHandleFileInformation.FileSizeLow", Field, 0},
		{"ByHandleFileInformation.LastAccessTime", Field, 0},
		{"ByHandleFileInformation.LastWriteTime", Field, 0},
		{"ByHandleFileInformation.NumberOfLinks", Field, 0},
		{"ByHandleFileInformation.VolumeSerialNumber", Field, 0},
		{"BytePtrFromString", Func, 1},
		{"ByteSliceFromString", Func, 1},
		{"CCR0_FLUSH", Const, 1},
		{"CERT_CHAIN_POLICY_AUTHENTICODE", Const, 0},
		{"CERT_CHAIN_POLICY_AUTHENTICODE_TS", Const, 0},
		{"CERT_CHAIN_POLICY_BASE", Const, 0},
		{"CERT_CHAIN_POLICY_BASIC_CONSTRAINTS", Const, 0},
		{"CERT_CHAIN_POLICY_EV", Const, 0},
		{"CERT_CHAIN_POLICY_MICROSOFT_ROOT", Const, 0},
		{"CERT_CHAIN_POLICY_NT_AUTH", Const, 0},
		{"CERT_CHAIN_POLICY_SSL", Const, 0},
		{"CERT_E_CN_NO_MATCH", Const, 0},
		{"CERT_E_EXPIRED", Const, 0},
		{"CERT_E_PURPOSE", Const, 0},
		{"CERT_E_ROLE", Const, 0},
		{"CERT_E_UNTRUSTEDROOT", Const, 0},
		{"CERT_STORE_ADD_ALWAYS", Const, 0},
		{"CERT_STORE_DEFER_CLOSE_UNTIL_LAST_FREE_FLAG", Const, 0},
		{"CERT_STORE_PROV_MEMORY", Const, 0},
		{"CERT_TRUST_HAS_EXCLUDED_NAME_CONSTRAINT", Const, 0},
		{"CERT_TRUST_HAS_NOT_DEFINED_NAME_CONSTRAINT", Const, 0},
		{"CERT_TRUST_HAS_NOT_PERMITTED_NAME_CONSTRAINT", Const, 0},
		{"CERT_TRUST_HAS_NOT_SUPPORTED_CRITICAL_EXT", Const, 0},
		{"CERT_TRUST_HAS_NOT_SUPPORTED_NAME_CONSTRAINT", Const, 0},
		{"CERT_TRUST_INVALID_BASIC_CONSTRAINTS", Const, 0},
		{"CERT_TRUST_INVALID_EXTENSION", Const, 0},
		{"CERT_TRUST_INVALID_NAME_CONSTRAINTS", Const, 0},
		{"CERT_TRUST_INVALID_POLICY_CONSTRAINTS", Const, 0},
		{"CERT_TRUST_IS_CYCLIC", Const, 0},
		{"CERT_TRUST_IS_EXPLICIT_DISTRUST", Const, 0},
		{"CERT_TRUST_IS_NOT_SIGNATURE_VALID", Const, 0},
		{"CERT_TRUST_IS_NOT_TIME_VALID", Const, 0},
		{"CERT_TRUST_IS_NOT_VALID_FOR_USAGE", Const, 0},
		{"CERT_TRUST_IS_OFFLINE_REVOCATION", Const, 0},
		{"CERT_TRUST_IS_REVOKED", Const, 0},
		{"CERT_TRUST_IS_UNTRUSTED_ROOT", Const, 0},
		{"CERT_TRUST_NO_ERROR", Const, 0},
		{"CERT_TRUST_NO_ISSUANCE_CHAIN_POLICY", Const, 0},
		{"CERT_TRUST_REVOCATION_STATUS_UNKNOWN", Const, 0},
		{"CFLUSH", Const, 1},
		{"CLOCAL", Const, 0},
		{"CLONE_CHILD_CLEARTID", Const, 2},
		{"CLONE_CHILD_SETTID", Const, 2},
		{"CLONE_CLEAR_SIGHAND", Const, 20},
		{"CLONE_CSIGNAL", Const, 3},
		{"CLONE_DETACHED", Const, 2},
		{"CLONE_FILES", Const, 2},
		{"CLONE_FS", Const, 2},
		{"CLONE_INTO_CGROUP", Const, 20},
		{"CLONE_IO", Const, 2},
		{"CLONE_NEWCGROUP", Const, 20},
		{"CLONE_NEWIPC", Const, 2},
		{"CLONE_NEWNET", Const, 2},
		{"CLONE_NEWNS", Const, 2},
		{"CLONE_NEWPID", Const, 2},
		{"CLONE_NEWTIME", Const, 20},
		{"CLONE_NEWUSER", Const, 2},
		{"CLONE_NEWUTS", Const, 2},
		{"CLONE_PARENT", Const, 2},
		{"CLONE_PARENT_SETTID", Const, 2},
		{"CLONE_PID", Const, 3},
		{"CLONE_PIDFD", Const, 20},
		{"CLONE_PTRACE", Const, 2},
		{"CLONE_SETTLS", Const, 2},
		{"CLONE_SIGHAND", Const, 2},
		{"CLONE_SYSVSEM", Const, 2},
		{"CLONE_THREAD", Const, 2},
		{"CLONE_UNTRACED", Const, 2},
		{"CLONE_VFORK", Const, 2},
		{"CLONE_VM", Const, 2},
		{"CPUID_CFLUSH", Const, 1},
		{"CREAD", Const, 0},
		{"CREATE_ALWAYS", Const, 0},
		{"CREATE_NEW", Const, 0},
		{"CREATE_NEW_PROCESS_GROUP", Const, 1},
		{"CREATE_UNICODE_ENVIRONMENT", Const, 0},
		{"CRYPT_DEFAULT_CONTAINER_OPTIONAL", Const, 0},
		{"CRYPT_DELETEKEYSET", Const, 0},
		{"CRYPT_MACHINE_KEYSET", Const, 0},
		{"CRYPT_NEWKEYSET", Const, 0},
		{"CRYPT_SILENT", Const, 0},
		{"CRYPT_VERIFYCONTEXT", Const, 0},
		{"CS5", Const, 0},
		{"CS6", Const, 0},
		{"CS7", Const, 0},
		{"CS8", Const, 0},
		{"CSIZE", Const, 0},
		{"CSTART", Const, 1},
		{"CSTATUS", Const, 1},
		{"CSTOP", Const, 1},
		{"CSTOPB", Const, 0},
		{"CSUSP", Const, 1},
		{"CTL_MAXNAME", Const, 0},
		{"CTL_NET", Const, 0},
		{"CTL_QUERY", Const, 1},
		{"CTRL_BREAK_EVENT", Const, 1},
		{"CTRL_CLOSE_EVENT", Const, 14},
		{"CTRL_C_EVENT", Const, 1},
		{"CTRL_LOGOFF_EVENT", Const, 14},
		{"CTRL_SHUTDOWN_EVENT", Const, 14},
		{"CancelIo", Func, 0},
		{"CancelIoEx", Func, 1},
		{"CertAddCertificateContextToStore", Func, 0},
		{"CertChainContext", Type, 0},
		{"CertChainContext.ChainCount", Field, 0},
		{"CertChainContext.Chains", Field, 0},
		{"CertChainContext.HasRevocationFreshnessTime", Field, 0},
		{"CertChainContext.LowerQualityChainCount", Field, 0},
		{"CertChainContext.LowerQualityChains", Field, 0},
		{"CertChainContext.RevocationFreshnessTime", Field, 0},
		{"CertChainContext.Size", Field, 0},
		{"CertChainContext.TrustStatus", Field, 0},
		{"CertChainElement", Type, 0},
		{"CertChainElement.ApplicationUsage", Field, 0},
		{"CertChainElement.CertContext", Field, 0},
		{"CertChainElement.ExtendedErrorInfo", Field, 0},
		{"CertChainElement.IssuanceUsage", Field, 0},
		{"CertChainElement.RevocationInfo", Field, 0},
		{"CertChainElement.Size", Field, 0},
		{"CertChainElement.TrustStatus", Field, 0},
		{"CertChainPara", Type, 0},
		{"CertChainPara.CacheResync", Field, 0},
		{"CertChainPara.CheckRevocationFreshnessTime", Field, 0},
		{"CertChainPara.RequestedUsage", Field, 0},
		{"CertChainPara.RequstedIssuancePolicy", Field, 0},
		{"CertChainPara.RevocationFreshnessTime", Field, 0},
		{"CertChainPara.Size", Field, 0},
		{"CertChainPara.URLRetrievalTimeout", Field, 0},
		{"CertChainPolicyPara", Type, 0},
		{"CertChainPolicyPara.ExtraPolicyPara", Field, 0},
		{"CertChainPolicyPara.Flags", Field, 0},
		{"CertChainPolicyPara.Size", Field, 0},
		{"CertChainPolicyStatus", Type, 0},
		{"CertChainPolicyStatus.ChainIndex", Field, 0},
		{"CertChainPolicyStatus.ElementIndex", Field, 0},
		{"CertChainPolicyStatus.Error", Field, 0},
		{"CertChainPolicyStatus.ExtraPolicyStatus", Field, 0},
		{"CertChainPolicyStatus.Size", Field, 0},
		{"CertCloseStore", Func, 0},
		{"CertContext", Type, 0},
		{"CertContext.CertInfo", Field, 0},
		{"CertContext.EncodedCert", Field, 0},
		{"CertContext.EncodingType", Field, 0},
		{"CertContext.Length", Field, 0},
		{"CertContext.Store", Field, 0},
		{"CertCreateCertificateContext", Func, 0},
		{"CertEnhKeyUsage", Type, 0},
		{"CertEnhKeyUsage.Length", Field, 0},
		{"CertEnhKeyUsage.UsageIdentifiers", Field, 0},
		{"CertEnumCertificatesInStore", Func, 0},
		{"CertFreeCertificateChain", Func, 0},
		{"CertFreeCertificateContext", Func, 0},
		{"CertGetCertificateChain", Func, 0},
		{"CertInfo", Type, 11},
		{"CertOpenStore", Func, 0},
		{"CertOpenSystemStore", Func, 0},
		{"CertRevocationCrlInfo", Type, 11},
		{"CertRevocationInfo", Type, 0},
		{"CertRevocationInfo.CrlInfo", Field, 0},
		{"CertRevocationInfo.FreshnessTime", Field, 0},
		{"CertRevocationInfo.HasFreshnessTime", Field, 0},
		{"CertRevocationInfo.OidSpecificInfo", Field, 0},
		{"CertRevocationInfo.RevocationOid", Field, 0},
		{"CertRevocationInfo.RevocationResult", Field, 0},
		{"CertRevocationInfo.Size", Field, 0},
		{"CertSimpleChain", Type, 0},
		{"CertSimpleChain.Elements", Field, 0},
		{"CertSimpleChain.HasRevocationFreshnessTime", Field, 0},
		{"CertSimpleChain.NumElements", Field, 0},
		{"CertSimpleChain.RevocationFreshnessTime", Field, 0},
		{"CertSimpleChain.Size", Field, 0},
		{"CertSimpleChain.TrustListInfo", Field, 0},
		{"CertSimpleChain.TrustStatus", Field, 0},
		{"CertTrustListInfo", Type, 11},
		{"CertTrustStatus", Type, 0},
		{"CertTrustStatus.ErrorStatus", Field, 0},
		{"CertTrustStatus.InfoStatus", Field, 0},
		{"CertUsageMatch", Type, 0},
		{"CertUsageMatch.Type", Field, 0},
		{"CertUsageMatch.Usage", Field, 0},
		{"CertVerifyCertificateChainPolicy", Func, 0},
		{"Chdir", Func, 0},
		{"CheckBpfVersion", Func, 0},
		{"Chflags", Func, 0},
		{"Chmod", Func, 0},
		{"Chown", Func, 0},
		{"Chroot", Func, 0},
		{"Clearenv", Func, 0},
		{"Close", Func, 0},
		{"CloseHandle", Func, 0},
		{"CloseOnExec", Func, 0},
		{"Closesocket", Func, 0},
		{"CmsgLen", Func, 0},
		{"CmsgSpace", Func, 0},
		{"Cmsghdr", Type, 0},
		{"Cmsghdr.Len", Field, 0},
		{"Cmsghdr.Level", Field, 0},
		{"Cmsghdr.Type", Field, 0},
		{"Cmsghdr.X__cmsg_data", Field, 0},
		{"CommandLineToArgv", Func, 0},
		{"ComputerName", Func, 0},
		{"Conn", Type, 9},
		{"Connect", Func, 0},
		{"ConnectEx", Func, 1},
		{"ConvertSidToStringSid", Func, 0},
		{"ConvertStringSidToSid", Func, 0},
		{"CopySid", Func, 0},
		{"Creat", Func, 0},
		{"CreateDirectory", Func, 0},
		{"CreateFile", Func, 0},
		{"CreateFileMapping", Func, 0},
		{"CreateHardLink", Func, 4},
		{"CreateIoCompletionPort", Func, 0},
		{"CreatePipe", Func, 0},
		{"CreateProcess", Func, 0},
		{"CreateProcessAsUser", Func, 10},
		{"CreateSymbolicLink", Func, 4},
		{"CreateToolhelp32Snapshot", Func, 4},
		{"Credential", Type, 0},
		{"Credential.Gid", Field, 0},
		{"Credential.Groups", Field, 0},
		{"Credential.NoSetGroups", Field, 9},
		{"Credential.Uid", Field, 0},
		{"CryptAcquireContext", Func, 0},
		{"CryptGenRandom", Func, 0},
		{"CryptReleaseContext", Func, 0},
		{"DIOCBSFLUSH", Const, 1},
		{"DIOCOSFPFLUSH", Const, 1},
		{"DLL", Type, 0},
		{"DLL.Handle", Field, 0},
		{"DLL.Name", Field, 0},
		{"DLLError", Type, 0},
		{"DLLError.Err", Field, 0},
		{"DLLError.Msg", Field, 0},
		{"DLLError.ObjName", Field, 0},
		{"DLT_A429", Const, 0},
		{"DLT_A653_ICM", Const, 0},
		{"DLT_AIRONET_HEADER", Const, 0},
		{"DLT_AOS", Const, 1},
		{"DLT_APPLE_IP_OVER_IEEE1394", Const, 0},
		{"DLT_ARCNET", Const, 0},
		{"DLT_ARCNET_LINUX", Const, 0},
		{"DLT_ATM_CLIP", Const, 0},
		{"DLT_ATM_RFC1483", Const, 0},
		{"DLT_AURORA", Const, 0},
		{"DLT_AX25", Const, 0},
		{"DLT_AX25_KISS", Const, 0},
		{"DLT_BACNET_MS_TP", Const, 0},
		{"DLT_BLUETOOTH_HCI_H4", Const, 0},
		{"DLT_BLUETOOTH_HCI_H4_WITH_PHDR", Const, 0},
		{"DLT_CAN20B", Const, 0},
		{"DLT_CAN_SOCKETCAN", Const, 1},
		{"DLT_CHAOS", Const, 0},
		{"DLT_CHDLC", Const, 0},
		{"DLT_CISCO_IOS", Const, 0},
		{"DLT_C_HDLC", Const, 0},
		{"DLT_C_HDLC_WITH_DIR", Const, 0},
		{"DLT_DBUS", Const, 1},
		{"DLT_DECT", Const, 1},
		{"DLT_DOCSIS", Const, 0},
		{"DLT_DVB_CI", Const, 1},
		{"DLT_ECONET", Const, 0},
		{"DLT_EN10MB", Const, 0},
		{"DLT_EN3MB", Const, 0},
		{"DLT_ENC", Const, 0},
		{"DLT_ERF", Const, 0},
		{"DLT_ERF_ETH", Const, 0},
		{"DLT_ERF_POS", Const, 0},
		{"DLT_FC_2", Const, 1},
		{"DLT_FC_2_WITH_FRAME_DELIMS", Const, 1},
		{"DLT_FDDI", Const, 0},
		{"DLT_FLEXRAY", Const, 0},
		{"DLT_FRELAY", Const, 0},
		{"DLT_FRELAY_WITH_DIR", Const, 0},
		{"DLT_GCOM_SERIAL", Const, 0},
		{"DLT_GCOM_T1E1", Const, 0},
		{"DLT_GPF_F", Const, 0},
		{"DLT_GPF_T", Const, 0},
		{"DLT_GPRS_LLC", Const, 0},
		{"DLT_GSMTAP_ABIS", Const, 1},
		{"DLT_GSMTAP_UM", Const, 1},
		{"DLT_HDLC", Const, 1},
		{"DLT_HHDLC", Const, 0},
		{"DLT_HIPPI", Const, 1},
		{"DLT_IBM_SN", Const, 0},
		{"DLT_IBM_SP", Const, 0},
		{"DLT_IEEE802", Const, 0},
		{"DLT_IEEE802_11", Const, 0},
		{"DLT_IEEE802_11_RADIO", Const, 0},
		{"DLT_IEEE802_11_RADIO_AVS", Const, 0},
		{"DLT_IEEE802_15_4", Const, 0},
		{"DLT_IEEE802_15_4_LINUX", Const, 0},
		{"DLT_IEEE802_15_4_NOFCS", Const, 1},
		{"DLT_IEEE802_15_4_NONASK_PHY", Const, 0},
		{"DLT_IEEE802_16_MAC_CPS", Const, 0},
		{"DLT_IEEE802_16_MAC_CPS_RADIO", Const, 0},
		{"DLT_IPFILTER", Const, 0},
		{"DLT_IPMB", Const, 0},
		{"DLT_IPMB_LINUX", Const, 0},
		{"DLT_IPNET", Const, 1},
		{"DLT_IPOIB", Const, 1},
		{"DLT_IPV4", Const, 1},
		{"DLT_IPV6", Const, 1},
		{"DLT_IP_OVER_FC", Const, 0},
		{"DLT_JUNIPER_ATM1", Const, 0},
		{"DLT_JUNIPER_ATM2", Const, 0},
		{"DLT_JUNIPER_ATM_CEMIC", Const, 1},
		{"DLT_JUNIPER_CHDLC", Const, 0},
		{"DLT_JUNIPER_ES", Const, 0},
		{"DLT_JUNIPER_ETHER", Const, 0},
		{"DLT_JUNIPER_FIBRECHANNEL", Const, 1},
		{"DLT_JUNIPER_FRELAY", Const, 0},
		{"DLT_JUNIPER_GGSN", Const, 0},
		{"DLT_JUNIPER_ISM", Const, 0},
		{"DLT_JUNIPER_MFR", Const, 0},
		{"DLT_JUNIPER_MLFR", Const, 0},
		{"DLT_JUNIPER_MLPPP", Const, 0},
		{"DLT_JUNIPER_MONITOR", Const, 0},
		{"DLT_JUNIPER_PIC_PEER", Const, 0},
		{"DLT_JUNIPER_PPP", Const, 0},
		{"DLT_JUNIPER_PPPOE", Const, 0},
		{"DLT_JUNIPER_PPPOE_ATM", Const, 0},
		{"DLT_JUNIPER_SERVICES", Const, 0},
		{"DLT_JUNIPER_SRX_E2E", Const, 1},
		{"DLT_JUNIPER_ST", Const, 0},
		{"DLT_JUNIPER_VP", Const, 0},
		{"DLT_JUNIPER_VS", Const, 1},
		{"DLT_LAPB_WITH_DIR", Const, 0},
		{"DLT_LAPD", Const, 0},
		{"DLT_LIN", Const, 0},
		{"DLT_LINUX_EVDEV", Const, 1},
		{"DLT_LINUX_IRDA", Const, 0},
		{"DLT_LINUX_LAPD", Const, 0},
		{"DLT_LINUX_PPP_WITHDIRECTION", Const, 0},
		{"DLT_LINUX_SLL", Const, 0},
		{"DLT_LOOP", Const, 0},
		{"DLT_LTALK", Const, 0},
		{"DLT_MATCHING_MAX", Const, 1},
		{"DLT_MATCHING_MIN", Const, 1},
		{"DLT_MFR", Const, 0},
		{"DLT_MOST", Const, 0},
		{"DLT_MPEG_2_TS", Const, 1},
		{"DLT_MPLS", Const, 1},
		{"DLT_MTP2", Const, 0},
		{"DLT_MTP2_WITH_PHDR", Const, 0},
		{"DLT_MTP3", Const, 0},
		{"DLT_MUX27010", Const, 1},
		{"DLT_NETANALYZER", Const, 1},
		{"DLT_NETANALYZER_TRANSPARENT", Const, 1},
		{"DLT_NFC_LLCP", Const, 1},
		{"DLT_NFLOG", Const, 1},
		{"DLT_NG40", Const, 1},
		{"DLT_NULL", Const, 0},
		{"DLT_PCI_EXP", Const, 0},
		{"DLT_PFLOG", Const, 0},
		{"DLT_PFSYNC", Const, 0},
		{"DLT_PPI", Const, 0},
		{"DLT_PPP", Const, 0},
		{"DLT_PPP_BSDOS", Const, 0},
		{"DLT_PPP_ETHER", Const, 0},
		{"DLT_PPP_PPPD", Const, 0},
		{"DLT_PPP_SERIAL", Const, 0},
		{"DLT_PPP_WITH_DIR", Const, 0},
		{"DLT_PPP_WITH_DIRECTION", Const, 0},
		{"DLT_PRISM_HEADER", Const, 0},
		{"DLT_PRONET", Const, 0},
		{"DLT_RAIF1", Const, 0},
		{"DLT_RAW", Const, 0},
		{"DLT_RAWAF_MASK", Const, 1},
		{"DLT_RIO", Const, 0},
		{"DLT_SCCP", Const, 0},
		{"DLT_SITA", Const, 0},
		{"DLT_SLIP", Const, 0},
		{"DLT_SLIP_BSDOS", Const, 0},
		{"DLT_STANAG_5066_D_PDU", Const, 1},
		{"DLT_SUNATM", Const, 0},
		{"DLT_SYMANTEC_FIREWALL", Const, 0},
		{"DLT_TZSP", Const, 0},
		{"DLT_USB", Const, 0},
		{"DLT_USB_LINUX", Const, 0},
		{"DLT_USB_LINUX_MMAPPED", Const, 1},
		{"DLT_USER0", Const, 0},
		{"DLT_USER1", Const, 0},
		{"DLT_USER10", Const, 0},
		{"DLT_USER11", Const, 0},
		{"DLT_USER12", Const, 0},
		{"DLT_USER13", Const, 0},
		{"DLT_USER14", Const, 0},
		{"DLT_USER15", Const, 0},
		{"DLT_USER2", Const, 0},
		{"DLT_USER3", Const, 0},
		{"DLT_USER4", Const, 0},
		{"DLT_USER5", Const, 0},
		{"DLT_USER6", Const, 0},
		{"DLT_USER7", Const, 0},
		{"DLT_USER8", Const, 0},
		{"DLT_USER9", Const, 0},
		{"DLT_WIHART", Const, 1},
		{"DLT_X2E_SERIAL", Const, 0},
		{"DLT_X2E_XORAYA", Const, 0},
		{"DNSMXData", Type, 0},
		{"DNSMXData.NameExchange", Field, 0},
		{"DNSMXData.Pad", Field, 0},
		{"DNSMXData.Preference", Field, 0},
		{"DNSPTRData", Type, 0},
		{"DNSPTRData.Host", Field, 0},
		{"DNSRecord", Type, 0},
		{"DNSRecord.Data", Field, 0},
		{"DNSRecord.Dw", Field, 0},
		{"DNSRecord.Length", Field, 0},
		{"DNSRecord.Name", Field, 0},
		{"DNSRecord.Next", Field, 0},
		{"DNSRecord.Reserved", Field, 0},
		{"DNSRecord.Ttl", Field, 0},
		{"DNSRecord.Type", Field, 0},
		{"DNSSRVData", Type, 0},
		{"DNSSRVData.Pad", Field, 0},
		{"DNSSRVData.Port", Field, 0},
		{"DNSSRVData.Priority", Field, 0},
		{"DNSSRVData.Target", Field, 0},
		{"DNSSRVData.Weight", Field, 0},
		{"DNSTXTData", Type, 0},
		{"DNSTXTData.StringArray", Field, 0},
		{"DNSTXTData.StringCount", Field, 0},
		{"DNS_INFO_NO_RECORDS", Const, 4},
		{"DNS_TYPE_A", Const, 0},
		{"DNS_TYPE_A6", Const, 0},
		{"DNS_TYPE_AAAA", Const, 0},
		{"DNS_TYPE_ADDRS", Const, 0},
		{"DNS_TYPE_AFSDB", Const, 0},
		{"DNS_TYPE_ALL", Const, 0},
		{"DNS_TYPE_ANY", Const, 0},
		{"DNS_TYPE_ATMA", Const, 0},
		{"DNS_TYPE_AXFR", Const, 0},
		{"DNS_TYPE_CERT", Const, 0},
		{"DNS_TYPE_CNAME", Const, 0},
		{"DNS_TYPE_DHCID", Const, 0},
		{"DNS_TYPE_DNAME", Const, 0},
		{"DNS_TYPE_DNSKEY", Const, 0},
		{"DNS_TYPE_DS", Const, 0},
		{"DNS_TYPE_EID", Const, 0},
		{"DNS_TYPE_GID", Const, 0},
		{"DNS_TYPE_GPOS", Const, 0},
		{"DNS_TYPE_HINFO", Const, 0},
		{"DNS_TYPE_ISDN", Const, 0},
		{"DNS_TYPE_IXFR", Const, 0},
		{"DNS_TYPE_KEY", Const, 0},
		{"DNS_TYPE_KX", Const, 0},
		{"DNS_TYPE_LOC", Const, 0},
		{"DNS_TYPE_MAILA", Const, 0},
		{"DNS_TYPE_MAILB", Const, 0},
		{"DNS_TYPE_MB", Const, 0},
		{"DNS_TYPE_MD", Const, 0},
		{"DNS_TYPE_MF", Const, 0},
		{"DNS_TYPE_MG", Const, 0},
		{"DNS_TYPE_MINFO", Const, 0},
		{"DNS_TYPE_MR", Const, 0},
		{"DNS_TYPE_MX", Const, 0},
		{"DNS_TYPE_NAPTR", Const, 0},
		{"DNS_TYPE_NBSTAT", Const, 0},
		{"DNS_TYPE_NIMLOC", Const, 0},
		{"DNS_TYPE_NS", Const, 0},
		{"DNS_TYPE_NSAP", Const, 0},
		{"DNS_TYPE_NSAPPTR", Const, 0},
		{"DNS_TYPE_NSEC", Const, 0},
		{"DNS_TYPE_NULL", Const, 0},
		{"DNS_TYPE_NXT", Const, 0},
		{"DNS_TYPE_OPT", Const, 0},
		{"DNS_TYPE_PTR", Const, 0},
		{"DNS_TYPE_PX", Const, 0},
		{"DNS_TYPE_RP", Const, 0},
		{"DNS_TYPE_RRSIG", Const, 0},
		{"DNS_TYPE_RT", Const, 0},
		{"DNS_TYPE_SIG", Const, 0},
		{"DNS_TYPE_SINK", Const, 0},
		{"DNS_TYPE_SOA", Const, 0},
		{"DNS_TYPE_SRV", Const, 0},
		{"DNS_TYPE_TEXT", Const, 0},
		{"DNS_TYPE_TKEY", Const, 0},
		{"DNS_TYPE_TSIG", Const, 0},
		{"DNS_TYPE_UID", Const, 0},
		{"DNS_TYPE_UINFO", Const, 0},
		{"DNS_TYPE_UNSPEC", Const, 0},
		{"DNS_TYPE_WINS", Const, 0},
		{"DNS_TYPE_WINSR", Const, 0},
		{"DNS_TYPE_WKS", Const, 0},
		{"DNS_TYPE_X25", Const, 0},
		{"DT_BLK", Const, 0},
		{"DT_CHR", Const, 0},
		{"DT_DIR", Const, 0},
		{"DT_FIFO", Const, 0},
		{"DT_LNK", Const, 0},
		{"DT_REG", Const, 0},
		{"DT_SOCK", Const, 0},
		{"DT_UNKNOWN", Const, 0},
		{"DT_WHT", Const, 0},
		{"DUPLICATE_CLOSE_SOURCE", Const, 0},
		{"DUPLICATE_SAME_ACCESS", Const, 0},
		{"DeleteFile", Func, 0},
		{"DetachLsf", Func, 0},
		{"DeviceIoControl", Func, 4},
		{"Dirent", Type, 0},
		{"Dirent.Fileno", Field, 0},
		{"Dirent.Ino", Field, 0},
		{"Dirent.Name", Field, 0},
		{"Dirent.Namlen", Field, 0},
		{"Dirent.Off", Field, 0},
		{"Dirent.Pad0", Field, 12},
		{"Dirent.Pad1", Field, 12},
		{"Dirent.Pad_cgo_0", Field, 0},
		{"Dirent.Reclen", Field, 0},
		{"Dirent.Seekoff", Field, 0},
		{"Dirent.Type", Field, 0},
		{"Dirent.X__d_padding", Field, 3},
		{"DnsNameCompare", Func, 4},
		{"DnsQuery", Func, 0},
		{"DnsRecordListFree", Func, 0},
		{"DnsSectionAdditional", Const, 4},
		{"DnsSectionAnswer", Const, 4},
		{"DnsSectionAuthority", Const, 4},
		{"DnsSectionQuestion", Const, 4},
		{"Dup", Func, 0},
		{"Dup2", Func, 0},
		{"Dup3", Func, 2},
		{"DuplicateHandle", Func, 0},
		{"E2BIG", Const, 0},
		{"EACCES", Const, 0},
		{"EADDRINUSE", Const, 0},
		{"EADDRNOTAVAIL", Const, 0},
		{"EADV", Const, 0},
		{"EAFNOSUPPORT", Const, 0},
		{"EAGAIN", Const, 0},
		{"EALREADY", Const, 0},
		{"EAUTH", Const, 0},
		{"EBADARCH", Const, 0},
		{"EBADE", Const, 0},
		{"EBADEXEC", Const, 0},
		{"EBADF", Const, 0},
		{"EBADFD", Const, 0},
		{"EBADMACHO", Const, 0},
		{"EBADMSG", Const, 0},
		{"EBADR", Const, 0},
		{"EBADRPC", Const, 0},
		{"EBADRQC", Const, 0},
		{"EBADSLT", Const, 0},
		{"EBFONT", Const, 0},
		{"EBUSY", Const, 0},
		{"ECANCELED", Const, 0},
		{"ECAPMODE", Const, 1},
		{"ECHILD", Const, 0},
		{"ECHO", Const, 0},
		{"ECHOCTL", Const, 0},
		{"ECHOE", Const, 0},
		{"ECHOK", Const, 0},
		{"ECHOKE", Const, 0},
		{"ECHONL", Const, 0},
		{"ECHOPRT", Const, 0},
		{"ECHRNG", Const, 0},
		{"ECOMM", Const, 0},
		{"ECONNABORTED", Const, 0},
		{"ECONNREFUSED", Const, 0},
		{"ECONNRESET", Const, 0},
		{"EDEADLK", Const, 0},
		{"EDEADLOCK", Const, 0},
		{"EDESTADDRREQ", Const, 0},
		{"EDEVERR", Const, 0},
		{"EDOM", Const, 0},
		{"EDOOFUS", Const, 0},
		{"EDOTDOT", Const, 0},
		{"EDQUOT", Const, 0},
		{"EEXIST", Const, 0},
		{"EFAULT", Const, 0},
		{"EFBIG", Const, 0},
		{"EFER_LMA", Const, 1},
		{"EFER_LME", Const, 1},
		{"EFER_NXE", Const, 1},
		{"EFER_SCE", Const, 1},
		{"EFTYPE", Const, 0},
		{"EHOSTDOWN", Const, 0},
		{"EHOSTUNREACH", Const, 0},
		{"EHWPOISON", Const, 0},
		{"EIDRM", Const, 0},
		{"EILSEQ", Const, 0},
		{"EINPROGRESS", Const, 0},
		{"EINTR", Const, 0},
		{"EINVAL", Const, 0},
		{"EIO", Const, 0},
		{"EIPSEC", Const, 1},
		{"EISCONN", Const, 0},
		{"EISDIR", Const, 0},
		{"EISNAM", Const, 0},
		{"EKEYEXPIRED", Const, 0},
		{"EKEYREJECTED", Const, 0},
		{"EKEYREVOKED", Const, 0},
		{"EL2HLT", Const, 0},
		{"EL2NSYNC", Const, 0},
		{"EL3HLT", Const, 0},
		{"EL3RST", Const, 0},
		{"ELAST", Const, 0},
		{"ELF_NGREG", Const, 0},
		{"ELF_PRARGSZ", Const, 0},
		{"ELIBACC", Const, 0},
		{"ELIBBAD", Const, 0},
		{"ELIBEXEC", Const, 0},
		{"ELIBMAX", Const, 0},
		{"ELIBSCN", Const, 0},
		{"ELNRNG", Const, 0},
		{"ELOOP", Const, 0},
		{"EMEDIUMTYPE", Const, 0},
		{"EMFILE", Const, 0},
		{"EMLINK", Const, 0},
		{"EMSGSIZE", Const, 0},
		{"EMT_TAGOVF", Const, 1},
		{"EMULTIHOP", Const, 0},
		{"EMUL_ENABLED", Const, 1},
		{"EMUL_LINUX", Const, 1},
		{"EMUL_LINUX32", Const, 1},
		{"EMUL_MAXID", Const, 1},
		{"EMUL_NATIVE", Const, 1},
		{"ENAMETOOLONG", Const, 0},
		{"ENAVAIL", Const, 0},
		{"ENDRUNDISC", Const, 1},
		{"ENEEDAUTH", Const, 0},
		{"ENETDOWN", Const, 0},
		{"ENETRESET", Const, 0},
		{"ENETUNREACH", Const, 0},
		{"ENFILE", Const, 0},
		{"ENOANO", Const, 0},
		{"ENOATTR", Const, 0},
		{"ENOBUFS", Const, 0},
		{"ENOCSI", Const, 0},
		{"ENODATA", Const, 0},
		{"ENODEV", Const, 0},
		{"ENOENT", Const, 0},
		{"ENOEXEC", Const, 0},
		{"ENOKEY", Const, 0},
		{"ENOLCK", Const, 0},
		{"ENOLINK", Const, 0},
		{"ENOMEDIUM", Const, 0},
		{"ENOMEM", Const, 0},
		{"ENOMSG", Const, 0},
		{"ENONET", Const, 0},
		{"ENOPKG", Const, 0},
		{"ENOPOLICY", Const, 0},
		{"ENOPROTOOPT", Const, 0},
		{"ENOSPC", Const, 0},
		{"ENOSR", Const, 0},
		{"ENOSTR", Const, 0},
		{"ENOSYS", Const, 0},
		{"ENOTBLK", Const, 0},
		{"ENOTCAPABLE", Const, 0},
		{"ENOTCONN", Const, 0},
		{"ENOTDIR", Const, 0},
		{"ENOTEMPTY", Const, 0},
		{"ENOTNAM", Const, 0},
		{"ENOTRECOVERABLE", Const, 0},
		{"ENOTSOCK", Const, 0},
		{"ENOTSUP", Const, 0},
		{"ENOTTY", Const, 0},
		{"ENOTUNIQ", Const, 0},
		{"ENXIO", Const, 0},
		{"EN_SW_CTL_INF", Const, 1},
		{"EN_SW_CTL_PREC", Const, 1},
		{"EN_SW_CTL_ROUND", Const, 1},
		{"EN_SW_DATACHAIN", Const, 1},
		{"EN_SW_DENORM", Const, 1},
		{"EN_SW_INVOP", Const, 1},
		{"EN_SW_OVERFLOW", Const, 1},
		{"EN_SW_PRECLOSS", Const, 1},
		{"EN_SW_UNDERFLOW", Const, 1},
		{"EN_SW_ZERODIV", Const, 1},
		{"EOPNOTSUPP", Const, 0},
		{"EOVERFLOW", Const, 0},
		{"EOWNERDEAD", Const, 0},
		{"EPERM", Const, 0},
		{"EPFNOSUPPORT", Const, 0},
		{"EPIPE", Const, 0},
		{"EPOLLERR", Const, 0},
		{"EPOLLET", Const, 0},
		{"EPOLLHUP", Const, 0},
		{"EPOLLIN", Const, 0},
		{"EPOLLMSG", Const, 0},
		{"EPOLLONESHOT", Const, 0},
		{"EPOLLOUT", Const, 0},
		{"EPOLLPRI", Const, 0},
		{"EPOLLRDBAND", Const, 0},
		{"EPOLLRDHUP", Const, 0},
		{"EPOLLRDNORM", Const, 0},
		{"EPOLLWRBAND", Const, 0},
		{"EPOLLWRNORM", Const, 0},
		{"EPOLL_CLOEXEC", Const, 0},
		{"EPOLL_CTL_ADD", Const, 0},
		{"EPOLL_CTL_DEL", Const, 0},
		{"EPOLL_CTL_MOD", Const, 0},
		{"EPOLL_NONBLOCK", Const, 0},
		{"EPROCLIM", Const, 0},
		{"EPROCUNAVAIL", Const, 0},
		{"EPROGMISMATCH", Const, 0},
		{"EPROGUNAVAIL", Const, 0},
		{"EPROTO", Const, 0},
		{"EPROTONOSUPPORT", Const, 0},
		{"EPROTOTYPE", Const, 0},
		{"EPWROFF", Const, 0},
		{"EQFULL", Const, 16},
		{"ERANGE", Const, 0},
		{"EREMCHG", Const, 0},
		{"EREMOTE", Const, 0},
		{"EREMOTEIO", Const, 0},
		{"ERESTART", Const, 0},
		{"ERFKILL", Const, 0},
		{"EROFS", Const, 0},
		{"ERPCMISMATCH", Const, 0},
		{"ERROR_ACCESS_DENIED", Const, 0},
		{"ERROR_ALREADY_EXISTS", Const, 0},
		{"ERROR_BROKEN_PIPE", Const, 0},
		{"ERROR_BUFFER_OVERFLOW", Const, 0},
		{"ERROR_DIR_NOT_EMPTY", Const, 8},
		{"ERROR_ENVVAR_NOT_FOUND", Const, 0},
		{"ERROR_FILE_EXISTS", Const, 0},
		{"ERROR_FILE_NOT_FOUND", Const, 0},
		{"ERROR_HANDLE_EOF", Const, 2},
		{"ERROR_INSUFFICIENT_BUFFER", Const, 0},
		{"ERROR_IO_PENDING", Const, 0},
		{"ERROR_MOD_NOT_FOUND", Const, 0},
		{"ERROR_MORE_DATA", Const, 3},
		{"ERROR_NETNAME_DELETED", Const, 3},
		{"ERROR_NOT_FOUND", Const, 1},
		{"ERROR_NO_MORE_FILES", Const, 0},
		{"ERROR_OPERATION_ABORTED", Const, 0},
		{"ERROR_PATH_NOT_FOUND", Const, 0},
		{"ERROR_PRIVILEGE_NOT_HELD", Const, 4},
		{"ERROR_PROC_NOT_FOUND", Const, 0},
		{"ESHLIBVERS", Const, 0},
		{"ESHUTDOWN", Const, 0},
		{"ESOCKTNOSUPPORT", Const, 0},
		{"ESPIPE", Const, 0},
		{"ESRCH", Const, 0},
		{"ESRMNT", Const, 0},
		{"ESTALE", Const, 0},
		{"ESTRPIPE", Const, 0},
		{"ETHERCAP_JUMBO_MTU", Const, 1},
		{"ETHERCAP_VLAN_HWTAGGING", Const, 1},
		{"ETHERCAP_VLAN_MTU", Const, 1},
		{"ETHERMIN", Const, 1},
		{"ETHERMTU", Const, 1},
		{"ETHERMTU_JUMBO", Const, 1},
		{"ETHERTYPE_8023", Const, 1},
		{"ETHERTYPE_AARP", Const, 1},
		{"ETHERTYPE_ACCTON", Const, 1},
		{"ETHERTYPE_AEONIC", Const, 1},
		{"ETHERTYPE_ALPHA", Const, 1},
		{"ETHERTYPE_AMBER", Const, 1},
		{"ETHERTYPE_AMOEBA", Const, 1},
		{"ETHERTYPE_AOE", Const, 1},
		{"ETHERTYPE_APOLLO", Const, 1},
		{"ETHERTYPE_APOLLODOMAIN", Const, 1},
		{"ETHERTYPE_APPLETALK", Const, 1},
		{"ETHERTYPE_APPLITEK", Const, 1},
		{"ETHERTYPE_ARGONAUT", Const, 1},
		{"ETHERTYPE_ARP", Const, 1},
		{"ETHERTYPE_AT", Const, 1},
		{"ETHERTYPE_ATALK", Const, 1},
		{"ETHERTYPE_ATOMIC", Const, 1},
		{"ETHERTYPE_ATT", Const, 1},
		{"ETHERTYPE_ATTSTANFORD", Const, 1},
		{"ETHERTYPE_AUTOPHON", Const, 1},
		{"ETHERTYPE_AXIS", Const, 1},
		{"ETHERTYPE_BCLOOP", Const, 1},
		{"ETHERTYPE_BOFL", Const, 1},
		{"ETHERTYPE_CABLETRON", Const, 1},
		{"ETHERTYPE_CHAOS", Const, 1},
		{"ETHERTYPE_COMDESIGN", Const, 1},
		{"ETHERTYPE_COMPUGRAPHIC", Const, 1},
		{"ETHERTYPE_COUNTERPOINT", Const, 1},
		{"ETHERTYPE_CRONUS", Const, 1},
		{"ETHERTYPE_CRONUSVLN", Const, 1},
		{"ETHERTYPE_DCA", Const, 1},
		{"ETHERTYPE_DDE", Const, 1},
		{"ETHERTYPE_DEBNI", Const, 1},
		{"ETHERTYPE_DECAM", Const, 1},
		{"ETHERTYPE_DECCUST", Const, 1},
		{"ETHERTYPE_DECDIAG", Const, 1},
		{"ETHERTYPE_DECDNS", Const, 1},
		{"ETHERTYPE_DECDTS", Const, 1},
		{"ETHERTYPE_DECEXPER", Const, 1},
		{"ETHERTYPE_DECLAST", Const, 1},
		{"ETHERTYPE_DECLTM", Const, 1},
		{"ETHERTYPE_DECMUMPS", Const, 1},
		{"ETHERTYPE_DECNETBIOS", Const, 1},
		{"ETHERTYPE_DELTACON", Const, 1},
		{"ETHERTYPE_DIDDLE", Const, 1},
		{"ETHERTYPE_DLOG1", Const, 1},
		{"ETHERTYPE_DLOG2", Const, 1},
		{"ETHERTYPE_DN", Const, 1},
		{"ETHERTYPE_DOGFIGHT", Const, 1},
		{"ETHERTYPE_DSMD", Const, 1},
		{"ETHERTYPE_ECMA", Const, 1},
		{"ETHERTYPE_ENCRYPT", Const, 1},
		{"ETHERTYPE_ES", Const, 1},
		{"ETHERTYPE_EXCELAN", Const, 1},
		{"ETHERTYPE_EXPERDATA", Const, 1},
		{"ETHERTYPE_FLIP", Const, 1},
		{"ETHERTYPE_FLOWCONTROL", Const, 1},
		{"ETHERTYPE_FRARP", Const, 1},
		{"ETHERTYPE_GENDYN", Const, 1},
		{"ETHERTYPE_HAYES", Const, 1},
		{"ETHERTYPE_HIPPI_FP", Const, 1},
		{"ETHERTYPE_HITACHI", Const, 1},
		{"ETHERTYPE_HP", Const, 1},
		{"ETHERTYPE_IEEEPUP", Const, 1},
		{"ETHERTYPE_IEEEPUPAT", Const, 1},
		{"ETHERTYPE_IMLBL", Const, 1},
		{"ETHERTYPE_IMLBLDIAG", Const, 1},
		{"ETHERTYPE_IP", Const, 1},
		{"ETHERTYPE_IPAS", Const, 1},
		{"ETHERTYPE_IPV6", Const, 1},
		{"ETHERTYPE_IPX", Const, 1},
		{"ETHERTYPE_IPXNEW", Const, 1},
		{"ETHERTYPE_KALPANA", Const, 1},
		{"ETHERTYPE_LANBRIDGE", Const, 1},
		{"ETHERTYPE_LANPROBE", Const, 1},
		{"ETHERTYPE_LAT", Const, 1},
		{"ETHERTYPE_LBACK", Const, 1},
		{"ETHERTYPE_LITTLE", Const, 1},
		{"ETHERTYPE_LLDP", Const, 1},
		{"ETHERTYPE_LOGICRAFT", Const, 1},
		{"ETHERTYPE_LOOPBACK", Const, 1},
		{"ETHERTYPE_MATRA", Const, 1},
		{"ETHERTYPE_MAX", Const, 1},
		{"ETHERTYPE_MERIT", Const, 1},
		{"ETHERTYPE_MICP", Const, 1},
		{"ETHERTYPE_MOPDL", Const, 1},
		{"ETHERTYPE_MOPRC", Const, 1},
		{"ETHERTYPE_MOTOROLA", Const, 1},
		{"ETHERTYPE_MPLS", Const, 1},
		{"ETHERTYPE_MPLS_MCAST", Const, 1},
		{"ETHERTYPE_MUMPS", Const, 1},
		{"ETHERTYPE_NBPCC", Const, 1},
		{"ETHERTYPE_NBPCLAIM", Const, 1},
		{"ETHERTYPE_NBPCLREQ", Const, 1},
		{"ETHERTYPE_NBPCLRSP", Const, 1},
		{"ETHERTYPE_NBPCREQ", Const, 1},
		{"ETHERTYPE_NBPCRSP", Const, 1},
		{"ETHERTYPE_NBPDG", Const, 1},
		{"ETHERTYPE_NBPDGB", Const, 1},
		{"ETHERTYPE_NBPDLTE", Const, 1},
		{"ETHERTYPE_NBPRAR", Const, 1},
		{"ETHERTYPE_NBPRAS", Const, 1},
		{"ETHERTYPE_NBPRST", Const, 1},
		{"ETHERTYPE_NBPSCD", Const, 1},
		{"ETHERTYPE_NBPVCD", Const, 1},
		{"ETHERTYPE_NBS", Const, 1},
		{"ETHERTYPE_NCD", Const, 1},
		{"ETHERTYPE_NESTAR", Const, 1},
		{"ETHERTYPE_NETBEUI", Const, 1},
		{"ETHERTYPE_NOVELL", Const, 1},
		{"ETHERTYPE_NS", Const, 1},
		{"ETHERTYPE_NSAT", Const, 1},
		{"ETHERTYPE_NSCOMPAT", Const, 1},
		{"ETHERTYPE_NTRAILER", Const, 1},
		{"ETHERTYPE_OS9", Const, 1},
		{"ETHERTYPE_OS9NET", Const, 1},
		{"ETHERTYPE_PACER", Const, 1},
		{"ETHERTYPE_PAE", Const, 1},
		{"ETHERTYPE_PCS", Const, 1},
		{"ETHERTYPE_PLANNING", Const, 1},
		{"ETHERTYPE_PPP", Const, 1},
		{"ETHERTYPE_PPPOE", Const, 1},
		{"ETHERTYPE_PPPOEDISC", Const, 1},
		{"ETHERTYPE_PRIMENTS", Const, 1},
		{"ETHERTYPE_PUP", Const, 1},
		{"ETHERTYPE_PUPAT", Const, 1},
		{"ETHERTYPE_QINQ", Const, 1},
		{"ETHERTYPE_RACAL", Const, 1},
		{"ETHERTYPE_RATIONAL", Const, 1},
		{"ETHERTYPE_RAWFR", Const, 1},
		{"ETHERTYPE_RCL", Const, 1},
		{"ETHERTYPE_RDP", Const, 1},
		{"ETHERTYPE_RETIX", Const, 1},
		{"ETHERTYPE_REVARP", Const, 1},
		{"ETHERTYPE_SCA", Const, 1},
		{"ETHERTYPE_SECTRA", Const, 1},
		{"ETHERTYPE_SECUREDATA", Const, 1},
		{"ETHERTYPE_SGITW", Const, 1},
		{"ETHERTYPE_SG_BOUNCE", Const, 1},
		{"ETHERTYPE_SG_DIAG", Const, 1},
		{"ETHERTYPE_SG_NETGAMES", Const, 1},
		{"ETHERTYPE_SG_RESV", Const, 1},
		{"ETHERTYPE_SIMNET", Const, 1},
		{"ETHERTYPE_SLOW", Const, 1},
		{"ETHERTYPE_SLOWPROTOCOLS", Const, 1},
		{"ETHERTYPE_SNA", Const, 1},
		{"ETHERTYPE_SNMP", Const, 1},
		{"ETHERTYPE_SONIX", Const, 1},
		{"ETHERTYPE_SPIDER", Const, 1},
		{"ETHERTYPE_SPRITE", Const, 1},
		{"ETHERTYPE_STP", Const, 1},
		{"ETHERTYPE_TALARIS", Const, 1},
		{"ETHERTYPE_TALARISMC", Const, 1},
		{"ETHERTYPE_TCPCOMP", Const, 1},
		{"ETHERTYPE_TCPSM", Const, 1},
		{"ETHERTYPE_TEC", Const, 1},
		{"ETHERTYPE_TIGAN", Const, 1},
		{"ETHERTYPE_TRAIL", Const, 1},
		{"ETHERTYPE_TRANSETHER", Const, 1},
		{"ETHERTYPE_TYMSHARE", Const, 1},
		{"ETHERTYPE_UBBST", Const, 1},
		{"ETHERTYPE_UBDEBUG", Const, 1},
		{"ETHERTYPE_UBDIAGLOOP", Const, 1},
		{"ETHERTYPE_UBDL", Const, 1},
		{"ETHERTYPE_UBNIU", Const, 1},
		{"ETHERTYPE_UBNMC", Const, 1},
		{"ETHERTYPE_VALID", Const, 1},
		{"ETHERTYPE_VARIAN", Const, 1},
		{"ETHERTYPE_VAXELN", Const, 1},
		{"ETHERTYPE_VEECO", Const, 1},
		{"ETHERTYPE_VEXP", Const, 1},
		{"ETHERTYPE_VGLAB", Const, 1},
		{"ETHERTYPE_VINES", Const, 1},
		{"ETHERTYPE_VINESECHO", Const, 1},
		{"ETHERTYPE_VINESLOOP", Const, 1},
		{"ETHERTYPE_VITAL", Const, 1},
		{"ETHERTYPE_VLAN", Const, 1},
		{"ETHERTYPE_VLTLMAN", Const, 1},
		{"ETHERTYPE_VPROD", Const, 1},
		{"ETHERTYPE_VURESERVED", Const, 1},
		{"ETHERTYPE_WATERLOO", Const, 1},
		{"ETHERTYPE_WELLFLEET", Const, 1},
		{"ETHERTYPE_X25", Const, 1},
		{"ETHERTYPE_X75", Const, 1},
		{"ETHERTYPE_XNSSM", Const, 1},
		{"ETHERTYPE_XTP", Const, 1},
		{"ETHER_ADDR_LEN", Const, 1},
		{"ETHER_ALIGN", Const, 1},
		{"ETHER_CRC_LEN", Const, 1},
		{"ETHER_CRC_POLY_BE", Const, 1},
		{"ETHER_CRC_POLY_LE", Const, 1},
		{"ETHER_HDR_LEN", Const, 1},
		{"ETHER_MAX_DIX_LEN", Const, 1},
		{"ETHER_MAX_LEN", Const, 1},
		{"ETHER_MAX_LEN_JUMBO", Const, 1},
		{"ETHER_MIN_LEN", Const, 1},
		{"ETHER_PPPOE_ENCAP_LEN", Const, 1},
		{"ETHER_TYPE_LEN", Const, 1},
		{"ETHER_VLAN_ENCAP_LEN", Const, 1},
		{"ETH_P_1588", Const, 0},
		{"ETH_P_8021Q", Const, 0},
		{"ETH_P_802_2", Const, 0},
		{"ETH_P_802_3", Const, 0},
		{"ETH_P_AARP", Const, 0},
		{"ETH_P_ALL", Const, 0},
		{"ETH_P_AOE", Const, 0},
		{"ETH_P_ARCNET", Const, 0},
		{"ETH_P_ARP", Const, 0},
		{"ETH_P_ATALK", Const, 0},
		{"ETH_P_ATMFATE", Const, 0},
		{"ETH_P_ATMMPOA", Const, 0},
		{"ETH_P_AX25", Const, 0},
		{"ETH_P_BPQ", Const, 0},
		{"ETH_P_CAIF", Const, 0},
		{"ETH_P_CAN", Const, 0},
		{"ETH_P_CONTROL", Const, 0},
		{"ETH_P_CUST", Const, 0},
		{"ETH_P_DDCMP", Const, 0},
		{"ETH_P_DEC", Const, 0},
		{"ETH_P_DIAG", Const, 0},
		{"ETH_P_DNA_DL", Const, 0},
		{"ETH_P_DNA_RC", Const, 0},
		{"ETH_P_DNA_RT", Const, 0},
		{"ETH_P_DSA", Const, 0},
		{"ETH_P_ECONET", Const, 0},
		{"ETH_P_EDSA", Const, 0},
		{"ETH_P_FCOE", Const, 0},
		{"ETH_P_FIP", Const, 0},
		{"ETH_P_HDLC", Const, 0},
		{"ETH_P_IEEE802154", Const, 0},
		{"ETH_P_IEEEPUP", Const, 0},
		{"ETH_P_IEEEPUPAT", Const, 0},
		{"ETH_P_IP", Const, 0},
		{"ETH_P_IPV6", Const, 0},
		{"ETH_P_IPX", Const, 0},
		{"ETH_P_IRDA", Const, 0},
		{"ETH_P_LAT", Const, 0},
		{"ETH_P_LINK_CTL", Const, 0},
		{"ETH_P_LOCALTALK", Const, 0},
		{"ETH_P_LOOP", Const, 0},
		{"ETH_P_MOBITEX", Const, 0},
		{"ETH_P_MPLS_MC", Const, 0},
		{"ETH_P_MPLS_UC", Const, 0},
		{"ETH_P_PAE", Const, 0},
		{"ETH_P_PAUSE", Const, 0},
		{"ETH_P_PHONET", Const, 0},
		{"ETH_P_PPPTALK", Const, 0},
		{"ETH_P_PPP_DISC", Const, 0},
		{"ETH_P_PPP_MP", Const, 0},
		{"ETH_P_PPP_SES", Const, 0},
		{"ETH_P_PUP", Const, 0},
		{"ETH_P_PUPAT", Const, 0},
		{"ETH_P_RARP", Const, 0},
		{"ETH_P_SCA", Const, 0},
		{"ETH_P_SLOW", Const, 0},
		{"ETH_P_SNAP", Const, 0},
		{"ETH_P_TEB", Const, 0},
		{"ETH_P_TIPC", Const, 0},
		{"ETH_P_TRAILER", Const, 0},
		{"ETH_P_TR_802_2", Const, 0},
		{"ETH_P_WAN_PPP", Const, 0},
		{"ETH_P_WCCP", Const, 0},
		{"ETH_P_X25", Const, 0},
		{"ETIME", Const, 0},
		{"ETIMEDOUT", Const, 0},
		{"ETOOMANYREFS", Const, 0},
		{"ETXTBSY", Const, 0},
		{"EUCLEAN", Const, 0},
		{"EUNATCH", Const, 0},
		{"EUSERS", Const, 0},
		{"EVFILT_AIO", Const, 0},
		{"EVFILT_FS", Const, 0},
		{"EVFILT_LIO", Const, 0},
		{"EVFILT_MACHPORT", Const, 0},
		{"EVFILT_PROC", Const, 0},
		{"EVFILT_READ", Const, 0},
		{"EVFILT_SIGNAL", Const, 0},
		{"EVFILT_SYSCOUNT", Const, 0},
		{"EVFILT_THREADMARKER", Const, 0},
		{"EVFILT_TIMER", Const, 0},
		{"EVFILT_USER", Const, 0},
		{"EVFILT_VM", Const, 0},
		{"EVFILT_VNODE", Const, 0},
		{"EVFILT_WRITE", Const, 0},
		{"EV_ADD", Const, 0},
		{"EV_CLEAR", Const, 0},
		{"EV_DELETE", Const, 0},
		{"EV_DISABLE", Const, 0},
		{"EV_DISPATCH", Const, 0},
		{"EV_DROP", Const, 3},
		{"EV_ENABLE", Const, 0},
		{"EV_EOF", Const, 0},
		{"EV_ERROR", Const, 0},
		{"EV_FLAG0", Const, 0},
		{"EV_FLAG1", Const, 0},
		{"EV_ONESHOT", Const, 0},
		{"EV_OOBAND", Const, 0},
		{"EV_POLL", Const, 0},
		{"EV_RECEIPT", Const, 0},
		{"EV_SYSFLAGS", Const, 0},
		{"EWINDOWS", Const, 0},
		{"EWOULDBLOCK", Const, 0},
		{"EXDEV", Const, 0},
		{"EXFULL", Const, 0},
		{"EXTA", Const, 0},
		{"EXTB", Const, 0},
		{"EXTPROC", Const, 0},
		{"Environ", Func, 0},
		{"EpollCreate", Func, 0},
		{"EpollCreate1", Func, 0},
		{"EpollCtl", Func, 0},
		{"EpollEvent", Type, 0},
		{"EpollEvent.Events", Field, 0},
		{"EpollEvent.Fd", Field, 0},
		{"EpollEvent.Pad", Field, 0},
		{"EpollEvent.PadFd", Field, 0},
		{"EpollWait", Func, 0},
		{"Errno", Type, 0},
		{"EscapeArg", Func, 0},
		{"Exchangedata", Func, 0},
		{"Exec", Func, 0},
		{"Exit", Func, 0},
		{"ExitProcess", Func, 0},
		{"FD_CLOEXEC", Const, 0},
		{"FD_SETSIZE", Const, 0},
		{"FILE_ACTION_ADDED", Const, 0},
		{"FILE_ACTION_MODIFIED", Const, 0},
		{"FILE_ACTION_REMOVED", Const, 0},
		{"FILE_ACTION_RENAMED_NEW_NAME", Const, 0},
		{"FILE_ACTION_RENAMED_OLD_NAME", Const, 0},
		{"FILE_APPEND_DATA", Const, 0},
		{"FILE_ATTRIBUTE_ARCHIVE", Const, 0},
		{"FILE_ATTRIBUTE_DIRECTORY", Const, 0},
		{"FILE_ATTRIBUTE_HIDDEN", Const, 0},
		{"FILE_ATTRIBUTE_NORMAL", Const, 0},
		{"FILE_ATTRIBUTE_READONLY", Const, 0},
		{"FILE_ATTRIBUTE_REPARSE_POINT", Const, 4},
		{"FILE_ATTRIBUTE_SYSTEM", Const, 0},
		{"FILE_BEGIN", Const, 0},
		{"FILE_CURRENT", Const, 0},
		{"FILE_END", Const, 0},
		{"FILE_FLAG_BACKUP_SEMANTICS", Const, 0},
		{"FILE_FLAG_OPEN_REPARSE_POINT", Const, 4},
		{"FILE_FLAG_OVERLAPPED", Const, 0},
		{"FILE_LIST_DIRECTORY", Const, 0},
		{"FILE_MAP_COPY", Const, 0},
		{"FILE_MAP_EXECUTE", Const, 0},
		{"FILE_MAP_READ", Const, 0},
		{"FILE_MAP_WRITE", Const, 0},
		{"FILE_NOTIFY_CHANGE_ATTRIBUTES", Const, 0},
		{"FILE_NOTIFY_CHANGE_CREATION", Const, 0},
		{"FILE_NOTIFY_CHANGE_DIR_NAME", Const, 0},
		{"FILE_NOTIFY_CHANGE_FILE_NAME", Const, 0},
		{"FILE_NOTIFY_CHANGE_LAST_ACCESS", Const, 0},
		{"FILE_NOTIFY_CHANGE_LAST_WRITE", Const, 0},
		{"FILE_NOTIFY_CHANGE_SIZE", Const, 0},
		{"FILE_SHARE_DELETE", Const, 0},
		{"FILE_SHARE_READ", Const, 0},
		{"FILE_SHARE_WRITE", Const, 0},
		{"FILE_SKIP_COMPLETION_PORT_ON_SUCCESS", Const, 2},
		{"FILE_SKIP_SET_EVENT_ON_HANDLE", Const, 2},
		{"FILE_TYPE_CHAR", Const, 0},
		{"FILE_TYPE_DISK", Const, 0},
		{"FILE_TYPE_PIPE", Const, 0},
		{"FILE_TYPE_REMOTE", Const, 0},
		{"FILE_TYPE_UNKNOWN", Const, 0},
		{"FILE_WRITE_ATTRIBUTES", Const, 0},
		{"FLUSHO", Const, 0},
		{"FORMAT_MESSAGE_ALLOCATE_BUFFER", Const, 0},
		{"FORMAT_MESSAGE_ARGUMENT_ARRAY", Const, 0},
		{"FORMAT_MESSAGE_FROM_HMODULE", Const, 0},
		{"FORMAT_MESSAGE_FROM_STRING", Const, 0},
		{"FORMAT_MESSAGE_FROM_SYSTEM", Const, 0},
		{"FORMAT_MESSAGE_IGNORE_INSERTS", Const, 0},
		{"FORMAT_MESSAGE_MAX_WIDTH_MASK", Const, 0},
		{"FSCTL_GET_REPARSE_POINT", Const, 4},
		{"F_ADDFILESIGS", Const, 0},
		{"F_ADDSIGS", Const, 0},
		{"F_ALLOCATEALL", Const, 0},
		{"F_ALLOCATECONTIG", Const, 0},
		{"F_CANCEL", Const, 0},
		{"F_CHKCLEAN", Const, 0},
		{"F_CLOSEM", Const, 1},
		{"F_DUP2FD", Const, 0},
		{"F_DUP2FD_CLOEXEC", Const, 1},
		{"F_DUPFD", Const, 0},
		{"F_DUPFD_CLOEXEC", Const, 0},
		{"F_EXLCK", Const, 0},
		{"F_FINDSIGS", Const, 16},
		{"F_FLUSH_DATA", Const, 0},
		{"F_FREEZE_FS", Const, 0},
		{"F_FSCTL", Const, 1},
		{"F_FSDIRMASK", Const, 1},
		{"F_FSIN", Const, 1},
		{"F_FSINOUT", Const, 1},
		{"F_FSOUT", Const, 1},
		{"F_FSPRIV", Const, 1},
		{"F_FSVOID", Const, 1},
		{"F_FULLFSYNC", Const, 0},
		{"F_GETCODEDIR", Const, 16},
		{"F_GETFD", Const, 0},
		{"F_GETFL", Const, 0},
		{"F_GETLEASE", Const, 0},
		{"F_GETLK", Const, 0},
		{"F_GETLK64", Const, 0},
		{"F_GETLKPID", Const, 0},
		{"F_GETNOSIGPIPE", Const, 0},
		{"F_GETOWN", Const, 0},
		{"F_GETOWN_EX", Const, 0},
		{"F_GETPATH", Const, 0},
		{"F_GETPATH_MTMINFO", Const, 0},
		{"F_GETPIPE_SZ", Const, 0},
		{"F_GETPROTECTIONCLASS", Const, 0},
		{"F_GETPROTECTIONLEVEL", Const, 16},
		{"F_GETSIG", Const, 0},
		{"F_GLOBAL_NOCACHE", Const, 0},
		{"F_LOCK", Const, 0},
		{"F_LOG2PHYS", Const, 0},
		{"F_LOG2PHYS_EXT", Const, 0},
		{"F_MARKDEPENDENCY", Const, 0},
		{"F_MAXFD", Const, 1},
		{"F_NOCACHE", Const, 0},
		{"F_NODIRECT", Const, 0},
		{"F_NOTIFY", Const, 0},
		{"F_OGETLK", Const, 0},
		{"F_OK", Const, 0},
		{"F_OSETLK", Const, 0},
		{"F_OSETLKW", Const, 0},
		{"F_PARAM_MASK", Const, 1},
		{"F_PARAM_MAX", Const, 1},
		{"F_PATHPKG_CHECK", Const, 0},
		{"F_PEOFPOSMODE", Const, 0},
		{"F_PREALLOCATE", Const, 0},
		{"F_RDADVISE", Const, 0},
		{"F_RDAHEAD", Const, 0},
		{"F_RDLCK", Const, 0},
		{"F_READAHEAD", Const, 0},
		{"F_READBOOTSTRAP", Const, 0},
		{"F_SETBACKINGSTORE", Const, 0},
		{"F_SETFD", Const, 0},
		{"F_SETFL", Const, 0},
		{"F_SETLEASE", Const, 0},
		{"F_SETLK", Const, 0},
		{"F_SETLK64", Const, 0},
		{"F_SETLKW", Const, 0},
		{"F_SETLKW64", Const, 0},
		{"F_SETLKWTIMEOUT", Const, 16},
		{"F_SETLK_REMOTE", Const, 0},
		{"F_SETNOSIGPIPE", Const, 0},
		{"F_SETOWN", Const, 0},
		{"F_SETOWN_EX", Const, 0},
		{"F_SETPIPE_SZ", Const, 0},
		{"F_SETPROTECTIONCLASS", Const, 0},
		{"F_SETSIG", Const, 0},
		{"F_SETSIZE", Const, 0},
		{"F_SHLCK", Const, 0},
		{"F_SINGLE_WRITER", Const, 16},
		{"F_TEST", Const, 0},
		{"F_THAW_FS", Const, 0},
		{"F_TLOCK", Const, 0},
		{"F_TRANSCODEKEY", Const, 16},
		{"F_ULOCK", Const, 0},
		{"F_UNLCK", Const, 0},
		{"F_UNLCKSYS", Const, 0},
		{"F_VOLPOSMODE", Const, 0},
		{"F_WRITEBOOTSTRAP", Const, 0},
		{"F_WRLCK", Const, 0},
		{"Faccessat", Func, 0},
		{"Fallocate", Func, 0},
		{"Fbootstraptransfer_t", Type, 0},
		{"Fbootstraptransfer_t.Buffer", Field, 0},
		{"Fbootstraptransfer_t.Length", Field, 0},
		{"Fbootstraptransfer_t.Offset", Field, 0},
		{"Fchdir", Func, 0},
		{"Fchflags", Func, 0},
		{"Fchmod", Func, 0},
		{"Fchmodat", Func, 0},
		{"Fchown", Func, 0},
		{"Fchownat", Func, 0},
		{"FcntlFlock", Func, 3},
		{"FdSet", Type, 0},
		{"FdSet.Bits", Field, 0},
		{"FdSet.X__fds_bits", Field, 0},
		{"Fdatasync", Func, 0},
		{"FileNotifyInformation", Type, 0},
		{"FileNotifyInformation.Action", Field, 0},
		{"FileNotifyInformation.FileName", Field, 0},
		{"FileNotifyInformation.FileNameLength", Field, 0},
		{"FileNotifyInformation.NextEntryOffset", Field, 0},
		{"Filetime", Type, 0},
		{"Filetime.HighDateTime", Field, 0},
		{"Filetime.LowDateTime", Field, 0},
		{"FindClose", Func, 0},
		{"FindFirstFile", Func, 0},
		{"FindNextFile", Func, 0},
		{"Flock", Func, 0},
		{"Flock_t", Type, 0},
		{"Flock_t.Len", Field, 0},
		{"Flock_t.Pad_cgo_0", Field, 0},
		{"Flock_t.Pad_cgo_1", Field, 3},
		{"Flock_t.Pid", Field, 0},
		{"Flock_t.Start", Field, 0},
		{"Flock_t.Sysid", Field, 0},
		{"Flock_t.Type", Field, 0},
		{"Flock_t.Whence", Field, 0},
		{"FlushBpf", Func, 0},
		{"FlushFileBuffers", Func, 0},
		{"FlushViewOfFile", Func, 0},
		{"ForkExec", Func, 0},
		{"ForkLock", Var, 0},
		{"FormatMessage", Func, 0},
		{"Fpathconf", Func, 0},
		{"FreeAddrInfoW", Func, 1},
		{"FreeEnvironmentStrings", Func, 0},
		{"FreeLibrary", Func, 0},
		{"Fsid", Type, 0},
		{"Fsid.Val", Field, 0},
		{"Fsid.X__fsid_val", Field, 2},
		{"Fsid.X__val", Field, 0},
		{"Fstat", Func, 0},
		{"Fstatat", Func, 12},
		{"Fstatfs", Func, 0},
		{"Fstore_t", Type, 0},
		{"Fstore_t.Bytesalloc", Field, 0},
		{"Fstore_t.Flags", Field, 0},
		{"Fstore_t.Length", Field, 0},
		{"Fstore_t.Offset", Field, 0},
		{"Fstore_t.Posmode", Field, 0},
		{"Fsync", Func, 0},
		{"Ftruncate", Func, 0},
		{"FullPath", Func, 4},
		{"Futimes", Func, 0},
		{"Futimesat", Func, 0},
		{"GENERIC_ALL", Const, 0},
		{"GENERIC_EXECUTE", Const, 0},
		{"GENERIC_READ", Const, 0},
		{"GENERIC_WRITE", Const, 0},
		{"GUID", Type, 1},
		{"GUID.Data1", Field, 1},
		{"GUID.Data2", Field, 1},
		{"GUID.Data3", Field, 1},
		{"GUID.Data4", Field, 1},
		{"GetAcceptExSockaddrs", Func, 0},
		{"GetAdaptersInfo", Func, 0},
		{"GetAddrInfoW", Func, 1},
		{"GetCommandLine", Func, 0},
		{"GetComputerName", Func, 0},
		{"GetConsoleMode", Func, 1},
		{"GetCurrentDirectory", Func, 0},
		{"GetCurrentProcess", Func, 0},
		{"GetEnvironmentStrings", Func, 0},
		{"GetEnvironmentVariable", Func, 0},
		{"GetExitCodeProcess", Func, 0},
		{"GetFileAttributes", Func, 0},
		{"GetFileAttributesEx", Func, 0},
		{"GetFileExInfoStandard", Const, 0},
		{"GetFileExMaxInfoLevel", Const, 0},
		{"GetFileInformationByHandle", Func, 0},
		{"GetFileType", Func, 0},
		{"GetFullPathName", Func, 0},
		{"GetHostByName", Func, 0},
		{"GetIfEntry", Func, 0},
		{"GetLastError", Func, 0},
		{"GetLengthSid", Func, 0},
		{"GetLongPathName", Func, 0},
		{"GetProcAddress", Func, 0},
		{"GetProcessTimes", Func, 0},
		{"GetProtoByName", Func, 0},
		{"GetQueuedCompletionStatus", Func, 0},
		{"GetServByName", Func, 0},
		{"GetShortPathName", Func, 0},
		{"GetStartupInfo", Func, 0},
		{"GetStdHandle", Func, 0},
		{"GetSystemTimeAsFileTime", Func, 0},
		{"GetTempPath", Func, 0},
		{"GetTimeZoneInformation", Func, 0},
		{"GetTokenInformation", Func, 0},
		{"GetUserNameEx", Func, 0},
		{"GetUserProfileDirectory", Func, 0},
		{"GetVersion", Func, 0},
		{"Getcwd", Func, 0},
		{"Getdents", Func, 0},
		{"Getdirentries", Func, 0},
		{"Getdtablesize", Func, 0},
		{"Getegid", Func, 0},
		{"Getenv", Func, 0},
		{"Geteuid", Func, 0},
		{"Getfsstat", Func, 0},
		{"Getgid", Func, 0},
		{"Getgroups", Func, 0},
		{"Getpagesize", Func, 0},
		{"Getpeername", Func, 0},
		{"Getpgid", Func, 0},
		{"Getpgrp", Func, 0},
		{"Getpid", Func, 0},
		{"Getppid", Func, 0},
		{"Getpriority", Func, 0},
		{"Getrlimit", Func, 0},
		{"Getrusage", Func, 0},
		{"Getsid", Func, 0},
		{"Getsockname", Func, 0},
		{"Getsockopt", Func, 1},
		{"GetsockoptByte", Func, 0},
		{"GetsockoptICMPv6Filter", Func, 2},
		{"GetsockoptIPMreq", Func, 0},
		{"GetsockoptIPMreqn", Func, 0},
		{"GetsockoptIPv6MTUInfo", Func, 2},
		{"GetsockoptIPv6Mreq", Func, 0},
		{"GetsockoptInet4Addr", Func, 0},
		{"GetsockoptInt", Func, 0},
		{"GetsockoptUcred", Func, 1},
		{"Gettid", Func, 0},
		{"Gettimeofday", Func, 0},
		{"Getuid", Func, 0},
		{"Getwd", Func, 0},
		{"Getxattr", Func, 1},
		{"HANDLE_FLAG_INHERIT", Const, 0},
		{"HKEY_CLASSES_ROOT", Const, 0},
		{"HKEY_CURRENT_CONFIG", Const, 0},
		{"HKEY_CURRENT_USER", Const, 0},
		{"HKEY_DYN_DATA", Const, 0},
		{"HKEY_LOCAL_MACHINE", Const, 0},
		{"HKEY_PERFORMANCE_DATA", Const, 0},
		{"HKEY_USERS", Const, 0},
		{"HUPCL", Const, 0},
		{"Handle", Type, 0},
		{"Hostent", Type, 0},
		{"Hostent.AddrList", Field, 0},
		{"Hostent.AddrType", Field, 0},
		{"Hostent.Aliases", Field, 0},
		{"Hostent.Length", Field, 0},
		{"Hostent.Name", Field, 0},
		{"ICANON", Const, 0},
		{"ICMP6_FILTER", Const, 2},
		{"ICMPV6_FILTER", Const, 2},
		{"ICMPv6Filter", Type, 2},
		{"ICMPv6Filter.Data", Field, 2},
		{"ICMPv6Filter.Filt", Field, 2},
		{"ICRNL", Const, 0},
		{"IEXTEN", Const, 0},
		{"IFAN_ARRIVAL", Const, 1},
		{"IFAN_DEPARTURE", Const, 1},
		{"IFA_ADDRESS", Const, 0},
		{"IFA_ANYCAST", Const, 0},
		{"IFA_BROADCAST", Const, 0},
		{"IFA_CACHEINFO", Const, 0},
		{"IFA_F_DADFAILED", Const, 0},
		{"IFA_F_DEPRECATED", Const, 0},
		{"IFA_F_HOMEADDRESS", Const, 0},
		{"IFA_F_NODAD", Const, 0},
		{"IFA_F_OPTIMISTIC", Const, 0},
		{"IFA_F_PERMANENT", Const, 0},
		{"IFA_F_SECONDARY", Const, 0},
		{"IFA_F_TEMPORARY", Const, 0},
		{"IFA_F_TENTATIVE", Const, 0},
		{"IFA_LABEL", Const, 0},
		{"IFA_LOCAL", Const, 0},
		{"IFA_MAX", Const, 0},
		{"IFA_MULTICAST", Const, 0},
		{"IFA_ROUTE", Const, 1},
		{"IFA_UNSPEC", Const, 0},
		{"IFF_ALLMULTI", Const, 0},
		{"IFF_ALTPHYS", Const, 0},
		{"IFF_AUTOMEDIA", Const, 0},
		{"IFF_BROADCAST", Const, 0},
		{"IFF_CANTCHANGE", Const, 0},
		{"IFF_CANTCONFIG", Const, 1},
		{"IFF_DEBUG", Const, 0},
		{"IFF_DRV_OACTIVE", Const, 0},
		{"IFF_DRV_RUNNING", Const, 0},
		{"IFF_DYING", Const, 0},
		{"IFF_DYNAMIC", Const, 0},
		{"IFF_LINK0", Const, 0},
		{"IFF_LINK1", Const, 0},
		{"IFF_LINK2", Const, 0},
		{"IFF_LOOPBACK", Const, 0},
		{"IFF_MASTER", Const, 0},
		{"IFF_MONITOR", Const, 0},
		{"IFF_MULTICAST", Const, 0},
		{"IFF_NOARP", Const, 0},
		{"IFF_NOTRAILERS", Const, 0},
		{"IFF_NO_PI", Const, 0},
		{"IFF_OACTIVE", Const, 0},
		{"IFF_ONE_QUEUE", Const, 0},
		{"IFF_POINTOPOINT", Const, 0},
		{"IFF_POINTTOPOINT", Const, 0},
		{"IFF_PORTSEL", Const, 0},
		{"IFF_PPROMISC", Const, 0},
		{"IFF_PROMISC", Const, 0},
		{"IFF_RENAMING", Const, 0},
		{"IFF_RUNNING", Const, 0},
		{"IFF_SIMPLEX", Const, 0},
		{"IFF_SLAVE", Const, 0},
		{"IFF_SMART", Const, 0},
		{"IFF_STATICARP", Const, 0},
		{"IFF_TAP", Const, 0},
		{"IFF_TUN", Const, 0},
		{"IFF_TUN_EXCL", Const, 0},
		{"IFF_UP", Const, 0},
		{"IFF_VNET_HDR", Const, 0},
		{"IFLA_ADDRESS", Const, 0},
		{"IFLA_BROADCAST", Const, 0},
		{"IFLA_COST", Const, 0},
		{"IFLA_IFALIAS", Const, 0},
		{"IFLA_IFNAME", Const, 0},
		{"IFLA_LINK", Const, 0},
		{"IFLA_LINKINFO", Const, 0},
		{"IFLA_LINKMODE", Const, 0},
		{"IFLA_MAP", Const, 0},
		{"IFLA_MASTER", Const, 0},
		{"IFLA_MAX", Const, 0},
		{"IFLA_MTU", Const, 0},
		{"IFLA_NET_NS_PID", Const, 0},
		{"IFLA_OPERSTATE", Const, 0},
		{"IFLA_PRIORITY", Const, 0},
		{"IFLA_PROTINFO", Const, 0},
		{"IFLA_QDISC", Const, 0},
		{"IFLA_STATS", Const, 0},
		{"IFLA_TXQLEN", Const, 0},
		{"IFLA_UNSPEC", Const, 0},
		{"IFLA_WEIGHT", Const, 0},
		{"IFLA_WIRELESS", Const, 0},
		{"IFNAMSIZ", Const, 0},
		{"IFT_1822", Const, 0},
		{"IFT_A12MPPSWITCH", Const, 0},
		{"IFT_AAL2", Const, 0},
		{"IFT_AAL5", Const, 0},
		{"IFT_ADSL", Const, 0},
		{"IFT_AFLANE8023", Const, 0},
		{"IFT_AFLANE8025", Const, 0},
		{"IFT_ARAP", Const, 0},
		{"IFT_ARCNET", Const, 0},
		{"IFT_ARCNETPLUS", Const, 0},
		{"IFT_ASYNC", Const, 0},
		{"IFT_ATM", Const, 0},
		{"IFT_ATMDXI", Const, 0},
		{"IFT_ATMFUNI", Const, 0},
		{"IFT_ATMIMA", Const, 0},
		{"IFT_ATMLOGICAL", Const, 0},
		{"IFT_ATMRADIO", Const, 0},
		{"IFT_ATMSUBINTERFACE", Const, 0},
		{"IFT_ATMVCIENDPT", Const, 0},
		{"IFT_ATMVIRTUAL", Const, 0},
		{"IFT_BGPPOLICYACCOUNTING", Const, 0},
		{"IFT_BLUETOOTH", Const, 1},
		{"IFT_BRIDGE", Const, 0},
		{"IFT_BSC", Const, 0},
		{"IFT_CARP", Const, 0},
		{"IFT_CCTEMUL", Const, 0},
		{"IFT_CELLULAR", Const, 0},
		{"IFT_CEPT", Const, 0},
		{"IFT_CES", Const, 0},
		{"IFT_CHANNEL", Const, 0},
		{"IFT_CNR", Const, 0},
		{"IFT_COFFEE", Const, 0},
		{"IFT_COMPOSITELINK", Const, 0},
		{"IFT_DCN", Const, 0},
		{"IFT_DIGITALPOWERLINE", Const, 0},
		{"IFT_DIGITALWRAPPEROVERHEADCHANNEL", Const, 0},
		{"IFT_DLSW", Const, 0},
		{"IFT_DOCSCABLEDOWNSTREAM", Const, 0},
		{"IFT_DOCSCABLEMACLAYER", Const, 0},
		{"IFT_DOCSCABLEUPSTREAM", Const, 0},
		{"IFT_DOCSCABLEUPSTREAMCHANNEL", Const, 1},
		{"IFT_DS0", Const, 0},
		{"IFT_DS0BUNDLE", Const, 0},
		{"IFT_DS1FDL", Const, 0},
		{"IFT_DS3", Const, 0},
		{"IFT_DTM", Const, 0},
		{"IFT_DUMMY", Const, 1},
		{"IFT_DVBASILN", Const, 0},
		{"IFT_DVBASIOUT", Const, 0},
		{"IFT_DVBRCCDOWNSTREAM", Const, 0},
		{"IFT_DVBRCCMACLAYER", Const, 0},
		{"IFT_DVBRCCUPSTREAM", Const, 0},
		{"IFT_ECONET", Const, 1},
		{"IFT_ENC", Const, 0},
		{"IFT_EON", Const, 0},
		{"IFT_EPLRS", Const, 0},
		{"IFT_ESCON", Const, 0},
		{"IFT_ETHER", Const, 0},
		{"IFT_FAITH", Const, 0},
		{"IFT_FAST", Const, 0},
		{"IFT_FASTETHER", Const, 0},
		{"IFT_FASTETHERFX", Const, 0},
		{"IFT_FDDI", Const, 0},
		{"IFT_FIBRECHANNEL", Const, 0},
		{"IFT_FRAMERELAYINTERCONNECT", Const, 0},
		{"IFT_FRAMERELAYMPI", Const, 0},
		{"IFT_FRDLCIENDPT", Const, 0},
		{"IFT_FRELAY", Const, 0},
		{"IFT_FRELAYDCE", Const, 0},
		{"IFT_FRF16MFRBUNDLE", Const, 0},
		{"IFT_FRFORWARD", Const, 0},
		{"IFT_G703AT2MB", Const, 0},
		{"IFT_G703AT64K", Const, 0},
		{"IFT_GIF", Const, 0},
		{"IFT_GIGABITETHERNET", Const, 0},
		{"IFT_GR303IDT", Const, 0},
		{"IFT_GR303RDT", Const, 0},
		{"IFT_H323GATEKEEPER", Const, 0},
		{"IFT_H323PROXY", Const, 0},
		{"IFT_HDH1822", Const, 0},
		{"IFT_HDLC", Const, 0},
		{"IFT_HDSL2", Const, 0},
		{"IFT_HIPERLAN2", Const, 0},
		{"IFT_HIPPI", Const, 0},
		{"IFT_HIPPIINTERFACE", Const, 0},
		{"IFT_HOSTPAD", Const, 0},
		{"IFT_HSSI", Const, 0},
		{"IFT_HY", Const, 0},
		{"IFT_IBM370PARCHAN", Const, 0},
		{"IFT_IDSL", Const, 0},
		{"IFT_IEEE1394", Const, 0},
		{"IFT_IEEE80211", Const, 0},
		{"IFT_IEEE80212", Const, 0},
		{"IFT_IEEE8023ADLAG", Const, 0},
		{"IFT_IFGSN", Const, 0},
		{"IFT_IMT", Const, 0},
		{"IFT_INFINIBAND", Const, 1},
		{"IFT_INTERLEAVE", Const, 0},
		{"IFT_IP", Const, 0},
		{"IFT_IPFORWARD", Const, 0},
		{"IFT_IPOVERATM", Const, 0},
		{"IFT_IPOVERCDLC", Const, 0},
		{"IFT_IPOVERCLAW", Const, 0},
		{"IFT_IPSWITCH", Const, 0},
		{"IFT_IPXIP", Const, 0},
		{"IFT_ISDN", Const, 0},
		{"IFT_ISDNBASIC", Const, 0},
		{"IFT_ISDNPRIMARY", Const, 0},
		{"IFT_ISDNS", Const, 0},
		{"IFT_ISDNU", Const, 0},
		{"IFT_ISO88022LLC", Const, 0},
		{"IFT_ISO88023", Const, 0},
		{"IFT_ISO88024", Const, 0},
		{"IFT_ISO88025", Const, 0},
		{"IFT_ISO88025CRFPINT", Const, 0},
		{"IFT_ISO88025DTR", Const, 0},
		{"IFT_ISO88025FIBER", Const, 0},
		{"IFT_ISO88026", Const, 0},
		{"IFT_ISUP", Const, 0},
		{"IFT_L2VLAN", Const, 0},
		{"IFT_L3IPVLAN", Const, 0},
		{"IFT_L3IPXVLAN", Const, 0},
		{"IFT_LAPB", Const, 0},
		{"IFT_LAPD", Const, 0},
		{"IFT_LAPF", Const, 0},
		{"IFT_LINEGROUP", Const, 1},
		{"IFT_LOCALTALK", Const, 0},
		{"IFT_LOOP", Const, 0},
		{"IFT_MEDIAMAILOVERIP", Const, 0},
		{"IFT_MFSIGLINK", Const, 0},
		{"IFT_MIOX25", Const, 0},
		{"IFT_MODEM", Const, 0},
		{"IFT_MPC", Const, 0},
		{"IFT_MPLS", Const, 0},
		{"IFT_MPLSTUNNEL", Const, 0},
		{"IFT_MSDSL", Const, 0},
		{"IFT_MVL", Const, 0},
		{"IFT_MYRINET", Const, 0},
		{"IFT_NFAS", Const, 0},
		{"IFT_NSIP", Const, 0},
		{"IFT_OPTICALCHANNEL", Const, 0},
		{"IFT_OPTICALTRANSPORT", Const, 0},
		{"IFT_OTHER", Const, 0},
		{"IFT_P10", Const, 0},
		{"IFT_P80", Const, 0},
		{"IFT_PARA", Const, 0},
		{"IFT_PDP", Const, 0},
		{"IFT_PFLOG", Const, 0},
		{"IFT_PFLOW", Const, 1},
		{"IFT_PFSYNC", Const, 0},
		{"IFT_PLC", Const, 0},
		{"IFT_PON155", Const, 1},
		{"IFT_PON622", Const, 1},
		{"IFT_POS", Const, 0},
		{"IFT_PPP", Const, 0},
		{"IFT_PPPMULTILINKBUNDLE", Const, 0},
		{"IFT_PROPATM", Const, 1},
		{"IFT_PROPBWAP2MP", Const, 0},
		{"IFT_PROPCNLS", Const, 0},
		{"IFT_PROPDOCSWIRELESSDOWNSTREAM", Const, 0},
		{"IFT_PROPDOCSWIRELESSMACLAYER", Const, 0},
		{"IFT_PROPDOCSWIRELESSUPSTREAM", Const, 0},
		{"IFT_PROPMUX", Const, 0},
		{"IFT_PROPVIRTUAL", Const, 0},
		{"IFT_PROPWIRELESSP2P", Const, 0},
		{"IFT_PTPSERIAL", Const, 0},
		{"IFT_PVC", Const, 0},
		{"IFT_Q2931", Const, 1},
		{"IFT_QLLC", Const, 0},
		{"IFT_RADIOMAC", Const, 0},
		{"IFT_RADSL", Const, 0},
		{"IFT_REACHDSL", Const, 0},
		{"IFT_RFC1483", Const, 0},
		{"IFT_RS232", Const, 0},
		{"IFT_RSRB", Const, 0},
		{"IFT_SDLC", Const, 0},
		{"IFT_SDSL", Const, 0},
		{"IFT_SHDSL", Const, 0},
		{"IFT_SIP", Const, 0},
		{"IFT_SIPSIG", Const, 1},
		{"IFT_SIPTG", Const, 1},
		{"IFT_SLIP", Const, 0},
		{"IFT_SMDSDXI", Const, 0},
		{"IFT_SMDSICIP", Const, 0},
		{"IFT_SONET", Const, 0},
		{"IFT_SONETOVERHEADCHANNEL", Const, 0},
		{"IFT_SONETPATH", Const, 0},
		{"IFT_SONETVT", Const, 0},
		{"IFT_SRP", Const, 0},
		{"IFT_SS7SIGLINK", Const, 0},
		{"IFT_STACKTOSTACK", Const, 0},
		{"IFT_STARLAN", Const, 0},
		{"IFT_STF", Const, 0},
		{"IFT_T1", Const, 0},
		{"IFT_TDLC", Const, 0},
		{"IFT_TELINK", Const, 1},
		{"IFT_TERMPAD", Const, 0},
		{"IFT_TR008", Const, 0},
		{"IFT_TRANSPHDLC", Const, 0},
		{"IFT_TUNNEL", Const, 0},
		{"IFT_ULTRA", Const, 0},
		{"IFT_USB", Const, 0},
		{"IFT_V11", Const, 0},
		{"IFT_V35", Const, 0},
		{"IFT_V36", Const, 0},
		{"IFT_V37", Const, 0},
		{"IFT_VDSL", Const, 0},
		{"IFT_VIRTUALIPADDRESS", Const, 0},
		{"IFT_VIRTUALTG", Const, 1},
		{"IFT_VOICEDID", Const, 1},
		{"IFT_VOICEEM", Const, 0},
		{"IFT_VOICEEMFGD", Const, 1},
		{"IFT_VOICEENCAP", Const, 0},
		{"IFT_VOICEFGDEANA", Const, 1},
		{"IFT_VOICEFXO", Const, 0},
		{"IFT_VOICEFXS", Const, 0},
		{"IFT_VOICEOVERATM", Const, 0},
		{"IFT_VOICEOVERCABLE", Const, 1},
		{"IFT_VOICEOVERFRAMERELAY", Const, 0},
		{"IFT_VOICEOVERIP", Const, 0},
		{"IFT_X213", Const, 0},
		{"IFT_X25", Const, 0},
		{"IFT_X25DDN", Const, 0},
		{"IFT_X25HUNTGROUP", Const, 0},
		{"IFT_X25MLP", Const, 0},
		{"IFT_X25PLE", Const, 0},
		{"IFT_XETHER", Const, 0},
		{"IGNBRK", Const, 0},
		{"IGNCR", Const, 0},
		{"IGNORE", Const, 0},
		{"IGNPAR", Const, 0},
		{"IMAXBEL", Const, 0},
		{"INFINITE", Const, 0},
		{"INLCR", Const, 0},
		{"INPCK", Const, 0},
		{"INVALID_FILE_ATTRIBUTES", Const, 0},
		{"IN_ACCESS", Const, 0},
		{"IN_ALL_EVENTS", Const, 0},
		{"IN_ATTRIB", Const, 0},
		{"IN_CLASSA_HOST", Const, 0},
		{"IN_CLASSA_MAX", Const, 0},
		{"IN_CLASSA_NET", Const, 0},
		{"IN_CLASSA_NSHIFT", Const, 0},
		{"IN_CLASSB_HOST", Const, 0},
		{"IN_CLASSB_MAX", Const, 0},
		{"IN_CLASSB_NET", Const, 0},
		{"IN_CLASSB_NSHIFT", Const, 0},
		{"IN_CLASSC_HOST", Const, 0},
		{"IN_CLASSC_NET", Const, 0},
		{"IN_CLASSC_NSHIFT", Const, 0},
		{"IN_CLASSD_HOST", Const, 0},
		{"IN_CLASSD_NET", Const, 0},
		{"IN_CLASSD_NSHIFT", Const, 0},
		{"IN_CLOEXEC", Const, 0},
		{"IN_CLOSE", Const, 0},
		{"IN_CLOSE_NOWRITE", Const, 0},
		{"IN_CLOSE_WRITE", Const, 0},
		{"IN_CREATE", Const, 0},
		{"IN_DELETE", Const, 0},
		{"IN_DELETE_SELF", Const, 0},
		{"IN_DONT_FOLLOW", Const, 0},
		{"IN_EXCL_UNLINK", Const, 0},
		{"IN_IGNORED", Const, 0},
		{"IN_ISDIR", Const, 0},
		{"IN_LINKLOCALNETNUM", Const, 0},
		{"IN_LOOPBACKNET", Const, 0},
		{"IN_MASK_ADD", Const, 0},
		{"IN_MODIFY", Const, 0},
		{"IN_MOVE", Const, 0},
		{"IN_MOVED_FROM", Const, 0},
		{"IN_MOVED_TO", Const, 0},
		{"IN_MOVE_SELF", Const, 0},
		{"IN_NONBLOCK", Const, 0},
		{"IN_ONESHOT", Const, 0},
		{"IN_ONLYDIR", Const, 0},
		{"IN_OPEN", Const, 0},
		{"IN_Q_OVERFLOW", Const, 0},
		{"IN_RFC3021_HOST", Const, 1},
		{"IN_RFC3021_MASK", Const, 1},
		{"IN_RFC3021_NET", Const, 1},
		{"IN_RFC3021_NSHIFT", Const, 1},
		{"IN_UNMOUNT", Const, 0},
		{"IOC_IN", Const, 1},
		{"IOC_INOUT", Const, 1},
		{"IOC_OUT", Const, 1},
		{"IOC_VENDOR", Const, 3},
		{"IOC_WS2", Const, 1},
		{"IO_REPARSE_TAG_SYMLINK", Const, 4},
		{"IPMreq", Type, 0},
		{"IPMreq.Interface", Field, 0},
		{"IPMreq.Multiaddr", Field, 0},
		{"IPMreqn", Type, 0},
		{"IPMreqn.Address", Field, 0},
		{"IPMreqn.Ifindex", Field, 0},
		{"IPMreqn.Multiaddr", Field, 0},
		{"IPPROTO_3PC", Const, 0},
		{"IPPROTO_ADFS", Const, 0},
		{"IPPROTO_AH", Const, 0},
		{"IPPROTO_AHIP", Const, 0},
		{"IPPROTO_APES", Const, 0},
		{"IPPROTO_ARGUS", Const, 0},
		{"IPPROTO_AX25", Const, 0},
		{"IPPROTO_BHA", Const, 0},
		{"IPPROTO_BLT", Const, 0},
		{"IPPROTO_BRSATMON", Const, 0},
		{"IPPROTO_CARP", Const, 0},
		{"IPPROTO_CFTP", Const, 0},
		{"IPPROTO_CHAOS", Const, 0},
		{"IPPROTO_CMTP", Const, 0},
		{"IPPROTO_COMP", Const, 0},
		{"IPPROTO_CPHB", Const, 0},
		{"IPPROTO_CPNX", Const, 0},
		{"IPPROTO_DCCP", Const, 0},
		{"IPPROTO_DDP", Const, 0},
		{"IPPROTO_DGP", Const, 0},
		{"IPPROTO_DIVERT", Const, 0},
		{"IPPROTO_DIVERT_INIT", Const, 3},
		{"IPPROTO_DIVERT_RESP", Const, 3},
		{"IPPROTO_DONE", Const, 0},
		{"IPPROTO_DSTOPTS", Const, 0},
		{"IPPROTO_EGP", Const, 0},
		{"IPPROTO_EMCON", Const, 0},
		{"IPPROTO_ENCAP", Const, 0},
		{"IPPROTO_EON", Const, 0},
		{"IPPROTO_ESP", Const, 0},
		{"IPPROTO_ETHERIP", Const, 0},
		{"IPPROTO_FRAGMENT", Const, 0},
		{"IPPROTO_GGP", Const, 0},
		{"IPPROTO_GMTP", Const, 0},
		{"IPPROTO_GRE", Const, 0},
		{"IPPROTO_HELLO", Const, 0},
		{"IPPROTO_HMP", Const, 0},
		{"IPPROTO_HOPOPTS", Const, 0},
		{"IPPROTO_ICMP", Const, 0},
		{"IPPROTO_ICMPV6", Const, 0},
		{"IPPROTO_IDP", Const, 0},
		{"IPPROTO_IDPR", Const, 0},
		{"IPPROTO_IDRP", Const, 0},
		{"IPPROTO_IGMP", Const, 0},
		{"IPPROTO_IGP", Const, 0},
		{"IPPROTO_IGRP", Const, 0},
		{"IPPROTO_IL", Const, 0},
		{"IPPROTO_INLSP", Const, 0},
		{"IPPROTO_INP", Const, 0},
		{"IPPROTO_IP", Const, 0},
		{"IPPROTO_IPCOMP", Const, 0},
		{"IPPROTO_IPCV", Const, 0},
		{"IPPROTO_IPEIP", Const, 0},
		{"IPPROTO_IPIP", Const, 0},
		{"IPPROTO_IPPC", Const, 0},
		{"IPPROTO_IPV4", Const, 0},
		{"IPPROTO_IPV6", Const, 0},
		{"IPPROTO_IPV6_ICMP", Const, 1},
		{"IPPROTO_IRTP", Const, 0},
		{"IPPROTO_KRYPTOLAN", Const, 0},
		{"IPPROTO_LARP", Const, 0},
		{"IPPROTO_LEAF1", Const, 0},
		{"IPPROTO_LEAF2", Const, 0},
		{"IPPROTO_MAX", Const, 0},
		{"IPPROTO_MAXID", Const, 0},
		{"IPPROTO_MEAS", Const, 0},
		{"IPPROTO_MH", Const, 1},
		{"IPPROTO_MHRP", Const, 0},
		{"IPPROTO_MICP", Const, 0},
		{"IPPROTO_MOBILE", Const, 0},
		{"IPPROTO_MPLS", Const, 1},
		{"IPPROTO_MTP", Const, 0},
		{"IPPROTO_MUX", Const, 0},
		{"IPPROTO_ND", Const, 0},
		{"IPPROTO_NHRP", Const, 0},
		{"IPPROTO_NONE", Const, 0},
		{"IPPROTO_NSP", Const, 0},
		{"IPPROTO_NVPII", Const, 0},
		{"IPPROTO_OLD_DIVERT", Const, 0},
		{"IPPROTO_OSPFIGP", Const, 0},
		{"IPPROTO_PFSYNC", Const, 0},
		{"IPPROTO_PGM", Const, 0},
		{"IPPROTO_PIGP", Const, 0},
		{"IPPROTO_PIM", Const, 0},
		{"IPPROTO_PRM", Const, 0},
		{"IPPROTO_PUP", Const, 0},
		{"IPPROTO_PVP", Const, 0},
		{"IPPROTO_RAW", Const, 0},
		{"IPPROTO_RCCMON", Const, 0},
		{"IPPROTO_RDP", Const, 0},
		{"IPPROTO_ROUTING", Const, 0},
		{"IPPROTO_RSVP", Const, 0},
		{"IPPROTO_RVD", Const, 0},
		{"IPPROTO_SATEXPAK", Const, 0},
		{"IPPROTO_SATMON", Const, 0},
		{"IPPROTO_SCCSP", Const, 0},
		{"IPPROTO_SCTP", Const, 0},
		{"IPPROTO_SDRP", Const, 0},
		{"IPPROTO_SEND", Const, 1},
		{"IPPROTO_SEP", Const, 0},
		{"IPPROTO_SKIP", Const, 0},
		{"IPPROTO_SPACER", Const, 0},
		{"IPPROTO_SRPC", Const, 0},
		{"IPPROTO_ST", Const, 0},
		{"IPPROTO_SVMTP", Const, 0},
		{"IPPROTO_SWIPE", Const, 0},
		{"IPPROTO_TCF", Const, 0},
		{"IPPROTO_TCP", Const, 0},
		{"IPPROTO_TLSP", Const, 0},
		{"IPPROTO_TP", Const, 0},
		{"IPPROTO_TPXX", Const, 0},
		{"IPPROTO_TRUNK1", Const, 0},
		{"IPPROTO_TRUNK2", Const, 0},
		{"IPPROTO_TTP", Const, 0},
		{"IPPROTO_UDP", Const, 0},
		{"IPPROTO_UDPLITE", Const, 0},
		{"IPPROTO_VINES", Const, 0},
		{"IPPROTO_VISA", Const, 0},
		{"IPPROTO_VMTP", Const, 0},
		{"IPPROTO_VRRP", Const, 1},
		{"IPPROTO_WBEXPAK", Const, 0},
		{"IPPROTO_WBMON", Const, 0},
		{"IPPROTO_WSN", Const, 0},
		{"IPPROTO_XNET", Const, 0},
		{"IPPROTO_XTP", Const, 0},
		{"IPV6_2292DSTOPTS", Const, 0},
		{"IPV6_2292HOPLIMIT", Const, 0},
		{"IPV6_2292HOPOPTS", Const, 0},
		{"IPV6_2292NEXTHOP", Const, 0},
		{"IPV6_2292PKTINFO", Const, 0},
		{"IPV6_2292PKTOPTIONS", Const, 0},
		{"IPV6_2292RTHDR", Const, 0},
		{"IPV6_ADDRFORM", Const, 0},
		{"IPV6_ADD_MEMBERSHIP", Const, 0},
		{"IPV6_AUTHHDR", Const, 0},
		{"IPV6_AUTH_LEVEL", Const, 1},
		{"IPV6_AUTOFLOWLABEL", Const, 0},
		{"IPV6_BINDANY", Const, 0},
		{"IPV6_BINDV6ONLY", Const, 0},
		{"IPV6_BOUND_IF", Const, 0},
		{"IPV6_CHECKSUM", Const, 0},
		{"IPV6_DEFAULT_MULTICAST_HOPS", Const, 0},
		{"IPV6_DEFAULT_MULTICAST_LOOP", Const, 0},
		{"IPV6_DEFHLIM", Const, 0},
		{"IPV6_DONTFRAG", Const, 0},
		{"IPV6_DROP_MEMBERSHIP", Const, 0},
		{"IPV6_DSTOPTS", Const, 0},
		{"IPV6_ESP_NETWORK_LEVEL", Const, 1},
		{"IPV6_ESP_TRANS_LEVEL", Const, 1},
		{"IPV6_FAITH", Const, 0},
		{"IPV6_FLOWINFO_MASK", Const, 0},
		{"IPV6_FLOWLABEL_MASK", Const, 0},
		{"IPV6_FRAGTTL", Const, 0},
		{"IPV6_FW_ADD", Const, 0},
		{"IPV6_FW_DEL", Const, 0},
		{"IPV6_FW_FLUSH", Const, 0},
		{"IPV6_FW_GET", Const, 0},
		{"IPV6_FW_ZERO", Const, 0},
		{"IPV6_HLIMDEC", Const, 0},
		{"IPV6_HOPLIMIT", Const, 0},
		{"IPV6_HOPOPTS", Const, 0},
		{"IPV6_IPCOMP_LEVEL", Const, 1},
		{"IPV6_IPSEC_POLICY", Const, 0},
		{"IPV6_JOIN_ANYCAST", Const, 0},
		{"IPV6_JOIN_GROUP", Const, 0},
		{"IPV6_LEAVE_ANYCAST", Const, 0},
		{"IPV6_LEAVE_GROUP", Const, 0},
		{"IPV6_MAXHLIM", Const, 0},
		{"IPV6_MAXOPTHDR", Const, 0},
		{"IPV6_MAXPACKET", Const, 0},
		{"IPV6_MAX_GROUP_SRC_FILTER", Const, 0},
		{"IPV6_MAX_MEMBERSHIPS", Const, 0},
		{"IPV6_MAX_SOCK_SRC_FILTER", Const, 0},
		{"IPV6_MIN_MEMBERSHIPS", Const, 0},
		{"IPV6_MMTU", Const, 0},
		{"IPV6_MSFILTER", Const, 0},
		{"IPV6_MTU", Const, 0},
		{"IPV6_MTU_DISCOVER", Const, 0},
		{"IPV6_MULTICAST_HOPS", Const, 0},
		{"IPV6_MULTICAST_IF", Const, 0},
		{"IPV6_MULTICAST_LOOP", Const, 0},
		{"IPV6_NEXTHOP", Const, 0},
		{"IPV6_OPTIONS", Const, 1},
		{"IPV6_PATHMTU", Const, 0},
		{"IPV6_PIPEX", Const, 1},
		{"IPV6_PKTINFO", Const, 0},
		{"IPV6_PMTUDISC_DO", Const, 0},
		{"IPV6_PMTUDISC_DONT", Const, 0},
		{"IPV6_PMTUDISC_PROBE", Const, 0},
		{"IPV6_PMTUDISC_WANT", Const, 0},
		{"IPV6_PORTRANGE", Const, 0},
		{"IPV6_PORTRANGE_DEFAULT", Const, 0},
		{"IPV6_PORTRANGE_HIGH", Const, 0},
		{"IPV6_PORTRANGE_LOW", Const, 0},
		{"IPV6_PREFER_TEMPADDR", Const, 0},
		{"IPV6_RECVDSTOPTS", Const, 0},
		{"IPV6_RECVDSTPORT", Const, 3},
		{"IPV6_RECVERR", Const, 0},
		{"IPV6_RECVHOPLIMIT", Const, 0},
		{"IPV6_RECVHOPOPTS", Const, 0},
		{"IPV6_RECVPATHMTU", Const, 0},
		{"IPV6_RECVPKTINFO", Const, 0},
		{"IPV6_RECVRTHDR", Const, 0},
		{"IPV6_RECVTCLASS", Const, 0},
		{"IPV6_ROUTER_ALERT", Const, 0},
		{"IPV6_RTABLE", Const, 1},
		{"IPV6_RTHDR", Const, 0},
		{"IPV6_RTHDRDSTOPTS", Const, 0},
		{"IPV6_RTHDR_LOOSE", Const, 0},
		{"IPV6_RTHDR_STRICT", Const, 0},
		{"IPV6_RTHDR_TYPE_0", Const, 0},
		{"IPV6_RXDSTOPTS", Const, 0},
		{"IPV6_RXHOPOPTS", Const, 0},
		{"IPV6_SOCKOPT_RESERVED1", Const, 0},
		{"IPV6_TCLASS", Const, 0},
		{"IPV6_UNICAST_HOPS", Const, 0},
		{"IPV6_USE_MIN_MTU", Const, 0},
		{"IPV6_V6ONLY", Const, 0},
		{"IPV6_VERSION", Const, 0},
		{"IPV6_VERSION_MASK", Const, 0},
		{"IPV6_XFRM_POLICY", Const, 0},
		{"IP_ADD_MEMBERSHIP", Const, 0},
		{"IP_ADD_SOURCE_MEMBERSHIP", Const, 0},
		{"IP_AUTH_LEVEL", Const, 1},
		{"IP_BINDANY", Const, 0},
		{"IP_BLOCK_SOURCE", Const, 0},
		{"IP_BOUND_IF", Const, 0},
		{"IP_DEFAULT_MULTICAST_LOOP", Const, 0},
		{"IP_DEFAULT_MULTICAST_TTL", Const, 0},
		{"IP_DF", Const, 0},
		{"IP_DIVERTFL", Const, 3},
		{"IP_DONTFRAG", Const, 0},
		{"IP_DROP_MEMBERSHIP", Const, 0},
		{"IP_DROP_SOURCE_MEMBERSHIP", Const, 0},
		{"IP_DUMMYNET3", Const, 0},
		{"IP_DUMMYNET_CONFIGURE", Const, 0},
		{"IP_DUMMYNET_DEL", Const, 0},
		{"IP_DUMMYNET_FLUSH", Const, 0},
		{"IP_DUMMYNET_GET", Const, 0},
		{"IP_EF", Const, 1},
		{"IP_ERRORMTU", Const, 1},
		{"IP_ESP_NETWORK_LEVEL", Const, 1},
		{"IP_ESP_TRANS_LEVEL", Const, 1},
		{"IP_FAITH", Const, 0},
		{"IP_FREEBIND", Const, 0},
		{"IP_FW3", Const, 0},
		{"IP_FW_ADD", Const, 0},
		{"IP_FW_DEL", Const, 0},
		{"IP_FW_FLUSH", Const, 0},
		{"IP_FW_GET", Const, 0},
		{"IP_FW_NAT_CFG", Const, 0},
		{"IP_FW_NAT_DEL", Const, 0},
		{"IP_FW_NAT_GET_CONFIG", Const, 0},
		{"IP_FW_NAT_GET_LOG", Const, 0},
		{"IP_FW_RESETLOG", Const, 0},
		{"IP_FW_TABLE_ADD", Const, 0},
		{"IP_FW_TABLE_DEL", Const, 0},
		{"IP_FW_TABLE_FLUSH", Const, 0},
		{"IP_FW_TABLE_GETSIZE", Const, 0},
		{"IP_FW_TABLE_LIST", Const, 0},
		{"IP_FW_ZERO", Const, 0},
		{"IP_HDRINCL", Const, 0},
		{"IP_IPCOMP_LEVEL", Const, 1},
		{"IP_IPSECFLOWINFO", Const, 1},
		{"IP_IPSEC_LOCAL_AUTH", Const, 1},
		{"IP_IPSEC_LOCAL_CRED", Const, 1},
		{"IP_IPSEC_LOCAL_ID", Const, 1},
		{"IP_IPSEC_POLICY", Const, 0},
		{"IP_IPSEC_REMOTE_AUTH", Const, 1},
		{"IP_IPSEC_REMOTE_CRED", Const, 1},
		{"IP_IPSEC_REMOTE_ID", Const, 1},
		{"IP_MAXPACKET", Const, 0},
		{"IP_MAX_GROUP_SRC_FILTER", Const, 0},
		{"IP_MAX_MEMBERSHIPS", Const, 0},
		{"IP_MAX_SOCK_MUTE_FILTER", Const, 0},
		{"IP_MAX_SOCK_SRC_FILTER", Const, 0},
		{"IP_MAX_SOURCE_FILTER", Const, 0},
		{"IP_MF", Const, 0},
		{"IP_MINFRAGSIZE", Const, 1},
		{"IP_MINTTL", Const, 0},
		{"IP_MIN_MEMBERSHIPS", Const, 0},
		{"IP_MSFILTER", Const, 0},
		{"IP_MSS", Const, 0},
		{"IP_MTU", Const, 0},
		{"IP_MTU_DISCOVER", Const, 0},
		{"IP_MULTICAST_IF", Const, 0},
		{"IP_MULTICAST_IFINDEX", Const, 0},
		{"IP_MULTICAST_LOOP", Const, 0},
		{"IP_MULTICAST_TTL", Const, 0},
		{"IP_MULTICAST_VIF", Const, 0},
		{"IP_NAT__XXX", Const, 0},
		{"IP_OFFMASK", Const, 0},
		{"IP_OLD_FW_ADD", Const, 0},
		{"IP_OLD_FW_DEL", Const, 0},
		{"IP_OLD_FW_FLUSH", Const, 0},
		{"IP_OLD_FW_GET", Const, 0},
		{"IP_OLD_FW_RESETLOG", Const, 0},
		{"IP_OLD_FW_ZERO", Const, 0},
		{"IP_ONESBCAST", Const, 0},
		{"IP_OPTIONS", Const, 0},
		{"IP_ORIGDSTADDR", Const, 0},
		{"IP_PASSSEC", Const, 0},
		{"IP_PIPEX", Const, 1},
		{"IP_PKTINFO", Const, 0},
		{"IP_PKTOPTIONS", Const, 0},
		{"IP_PMTUDISC", Const, 0},
		{"IP_PMTUDISC_DO", Const, 0},
		{"IP_PMTUDISC_DONT", Const, 0},
		{"IP_PMTUDISC_PROBE", Const, 0},
		{"IP_PMTUDISC_WANT", Const, 0},
		{"IP_PORTRANGE", Const, 0},
		{"IP_PORTRANGE_DEFAULT", Const, 0},
		{"IP_PORTRANGE_HIGH", Const, 0},
		{"IP_PORTRANGE_LOW", Const, 0},
		{"IP_RECVDSTADDR", Const, 0},
		{"IP_RECVDSTPORT", Const, 1},
		{"IP_RECVERR", Const, 0},
		{"IP_RECVIF", Const, 0},
		{"IP_RECVOPTS", Const, 0},
		{"IP_RECVORIGDSTADDR", Const, 0},
		{"IP_RECVPKTINFO", Const, 0},
		{"IP_RECVRETOPTS", Const, 0},
		{"IP_RECVRTABLE", Const, 1},
		{"IP_RECVTOS", Const, 0},
		{"IP_RECVTTL", Const, 0},
		{"IP_RETOPTS", Const, 0},
		{"IP_RF", Const, 0},
		{"IP_ROUTER_ALERT", Const, 0},
		{"IP_RSVP_OFF", Const, 0},
		{"IP_RSVP_ON", Const, 0},
		{"IP_RSVP_VIF_OFF", Const, 0},
		{"IP_RSVP_VIF_ON", Const, 0},
		{"IP_RTABLE", Const, 1},
		{"IP_SENDSRCADDR", Const, 0},
		{"IP_STRIPHDR", Const, 0},
		{"IP_TOS", Const, 0},
		{"IP_TRAFFIC_MGT_BACKGROUND", Const, 0},
		{"IP_TRANSPARENT", Const, 0},
		{"IP_TTL", Const, 0},
		{"IP_UNBLOCK_SOURCE", Const, 0},
		{"IP_XFRM_POLICY", Const, 0},
		{"IPv6MTUInfo", Type, 2},
		{"IPv6MTUInfo.Addr", Field, 2},
		{"IPv6MTUInfo.Mtu", Field, 2},
		{"IPv6Mreq", Type, 0},
		{"IPv6Mreq.Interface", Field, 0},
		{"IPv6Mreq.Multiaddr", Field, 0},
		{"ISIG", Const, 0},
		{"ISTRIP", Const, 0},
		{"IUCLC", Const, 0},
		{"IUTF8", Const, 0},
		{"IXANY", Const, 0},
		{"IXOFF", Const, 0},
		{"IXON", Const, 0},
		{"IfAddrmsg", Type, 0},
		{"IfAddrmsg.Family", Field, 0},
		{"IfAddrmsg.Flags", Field, 0},
		{"IfAddrmsg.Index", Field, 0},
		{"IfAddrmsg.Prefixlen", Field, 0},
		{"IfAddrmsg.Scope", Field, 0},
		{"IfAnnounceMsghdr", Type, 1},
		{"IfAnnounceMsghdr.Hdrlen", Field, 2},
		{"IfAnnounceMsghdr.Index", Field, 1},
		{"IfAnnounceMsghdr.Msglen", Field, 1},
		{"IfAnnounceMsghdr.Name", Field, 1},
		{"IfAnnounceMsghdr.Type", Field, 1},
		{"IfAnnounceMsghdr.Version", Field, 1},
		{"IfAnnounceMsghdr.What", Field, 1},
		{"IfData", Type, 0},
		{"IfData.Addrlen", Field, 0},
		{"IfData.Baudrate", Field, 0},
		{"IfData.Capabilities", Field, 2},
		{"IfData.Collisions", Field, 0},
		{"IfData.Datalen", Field, 0},
		{"IfData.Epoch", Field, 0},
		{"IfData.Hdrlen", Field, 0},
		{"IfData.Hwassist", Field, 0},
		{"IfData.Ibytes", Field, 0},
		{"IfData.Ierrors", Field, 0},
		{"IfData.Imcasts", Field, 0},
		{"IfData.Ipackets", Field, 0},
		{"IfData.Iqdrops", Field, 0},
		{"IfData.Lastchange", Field, 0},
		{"IfData.Link_state", Field, 0},
		{"IfData.Mclpool", Field, 2},
		{"IfData.Metric", Field, 0},
		{"IfData.Mtu", Field, 0},
		{"IfData.Noproto", Field, 0},
		{"IfData.Obytes", Field, 0},
		{"IfData.Oerrors", Field, 0},
		{"IfData.Omcasts", Field, 0},
		{"IfData.Opackets", Field, 0},
		{"IfData.Pad", Field, 2},
		{"IfData.Pad_cgo_0", Field, 2},
		{"IfData.Pad_cgo_1", Field, 2},
		{"IfData.Physical", Field, 0},
		{"IfData.Recvquota", Field, 0},
		{"IfData.Recvtiming", Field, 0},
		{"IfData.Reserved1", Field, 0},
		{"IfData.Reserved2", Field, 0},
		{"IfData.Spare_char1", Field, 0},
		{"IfData.Spare_char2", Field, 0},
		{"IfData.Type", Field, 0},
		{"IfData.Typelen", Field, 0},
		{"IfData.Unused1", Field, 0},
		{"IfData.Unused2", Field, 0},
		{"IfData.Xmitquota", Field, 0},
		{"IfData.Xmittiming", Field, 0},
		{"IfInfomsg", Type, 0},
		{"IfInfomsg.Change", Field, 0},
		{"IfInfomsg.Family", Field, 0},
		{"IfInfomsg.Flags", Field, 0},
		{"IfInfomsg.Index", Field, 0},
		{"IfInfomsg.Type", Field, 0},
		{"IfInfomsg.X__ifi_pad", Field, 0},
		{"IfMsghdr", Type, 0},
		{"IfMsghdr.Addrs", Field, 0},
		{"IfMsghdr.Data", Field, 0},
		{"IfMsghdr.Flags", Field, 0},
		{"IfMsghdr.Hdrlen", Field, 2},
		{"IfMsghdr.Index", Field, 0},
		{"IfMsghdr.Msglen", Field, 0},
		{"IfMsghdr.Pad1", Field, 2},
		{"IfMsghdr.Pad2", Field, 2},
		{"IfMsghdr.Pad_cgo_0", Field, 0},
		{"IfMsghdr.Pad_cgo_1", Field, 2},
		{"IfMsghdr.Tableid", Field, 2},
		{"IfMsghdr.Type", Field, 0},
		{"IfMsghdr.Version", Field, 0},
		{"IfMsghdr.Xflags", Field, 2},
		{"IfaMsghdr", Type, 0},
		{"IfaMsghdr.Addrs", Field, 0},
		{"IfaMsghdr.Flags", Field, 0},
		{"IfaMsghdr.Hdrlen", Field, 2},
		{"IfaMsghdr.Index", Field, 0},
		{"IfaMsghdr.Metric", Field, 0},
		{"IfaMsghdr.Msglen", Field, 0},
		{"IfaMsghdr.Pad1", Field, 2},
		{"IfaMsghdr.Pad2", Field, 2},
		{"IfaMsghdr.Pad_cgo_0", Field, 0},
		{"IfaMsghdr.Tableid", Field, 2},
		{"IfaMsghdr.Type", Field, 0},
		{"IfaMsghdr.Version", Field, 0},
		{"IfmaMsghdr", Type, 0},
		{"IfmaMsghdr.Addrs", Field, 0},
		{"IfmaMsghdr.Flags", Field, 0},
		{"IfmaMsghdr.Index", Field, 0},
		{"IfmaMsghdr.Msglen", Field, 0},
		{"IfmaMsghdr.Pad_cgo_0", Field, 0},
		{"IfmaMsghdr.Type", Field, 0},
		{"IfmaMsghdr.Version", Field, 0},
		{"IfmaMsghdr2", Type, 0},
		{"IfmaMsghdr2.Addrs", Field, 0},
		{"IfmaMsghdr2.Flags", Field, 0},
		{"IfmaMsghdr2.Index", Field, 0},
		{"IfmaMsghdr2.Msglen", Field, 0},
		{"IfmaMsghdr2.Pad_cgo_0", Field, 0},
		{"IfmaMsghdr2.Refcount", Field, 0},
		{"IfmaMsghdr2.Type", Field, 0},
		{"IfmaMsghdr2.Version", Field, 0},
		{"ImplementsGetwd", Const, 0},
		{"Inet4Pktinfo", Type, 0},
		{"Inet4Pktinfo.Addr", Field, 0},
		{"Inet4Pktinfo.Ifindex", Field, 0},
		{"Inet4Pktinfo.Spec_dst", Field, 0},
		{"Inet6Pktinfo", Type, 0},
		{"Inet6Pktinfo.Addr", Field, 0},
		{"Inet6Pktinfo.Ifindex", Field, 0},
		{"InotifyAddWatch", Func, 0},
		{"InotifyEvent", Type, 0},
		{"InotifyEvent.Cookie", Field, 0},
		{"InotifyEvent.Len", Field, 0},
		{"InotifyEvent.Mask", Field, 0},
		{"InotifyEvent.Name", Field, 0},
		{"InotifyEvent.Wd", Field, 0},
		{"InotifyInit", Func, 0},
		{"InotifyInit1", Func, 0},
		{"InotifyRmWatch", Func, 0},
		{"InterfaceAddrMessage", Type, 0},
		{"InterfaceAddrMessage.Data", Field, 0},
		{"InterfaceAddrMessage.Header", Field, 0},
		{"InterfaceAnnounceMessage", Type, 1},
		{"InterfaceAnnounceMessage.Header", Field, 1},
		{"InterfaceInfo", Type, 0},
		{"InterfaceInfo.Address", Field, 0},
		{"InterfaceInfo.BroadcastAddress", Field, 0},
		{"InterfaceInfo.Flags", Field, 0},
		{"InterfaceInfo.Netmask", Field, 0},
		{"InterfaceMessage", Type, 0},
		{"InterfaceMessage.Data", Field, 0},
		{"InterfaceMessage.Header", Field, 0},
		{"InterfaceMulticastAddrMessage", Type, 0},
		{"InterfaceMulticastAddrMessage.Data", Field, 0},
		{"InterfaceMulticastAddrMessage.Header", Field, 0},
		{"InvalidHandle", Const, 0},
		{"Ioperm", Func, 0},
		{"Iopl", Func, 0},
		{"Iovec", Type, 0},
		{"Iovec.Base", Field, 0},
		{"Iovec.Len", Field, 0},
		{"IpAdapterInfo", Type, 0},
		{"IpAdapterInfo.AdapterName", Field, 0},
		{"IpAdapterInfo.Address", Field, 0},
		{"IpAdapterInfo.AddressLength", Field, 0},
		{"IpAdapterInfo.ComboIndex", Field, 0},
		{"IpAdapterInfo.CurrentIpAddress", Field, 0},
		{"IpAdapterInfo.Description", Field, 0},
		{"IpAdapterInfo.DhcpEnabled", Field, 0},
		{"IpAdapterInfo.DhcpServer", Field, 0},
		{"IpAdapterInfo.GatewayList", Field, 0},
		{"IpAdapterInfo.HaveWins", Field, 0},
		{"IpAdapterInfo.Index", Field, 0},
		{"IpAdapterInfo.IpAddressList", Field, 0},
		{"IpAdapterInfo.LeaseExpires", Field, 0},
		{"IpAdapterInfo.LeaseObtained", Field, 0},
		{"IpAdapterInfo.Next", Field, 0},
		{"IpAdapterInfo.PrimaryWinsServer", Field, 0},
		{"IpAdapterInfo.SecondaryWinsServer", Field, 0},
		{"IpAdapterInfo.Type", Field, 0},
		{"IpAddrString", Type, 0},
		{"IpAddrString.Context", Field, 0},
		{"IpAddrString.IpAddress", Field, 0},
		{"IpAddrString.IpMask", Field, 0},
		{"IpAddrString.Next", Field, 0},
		{"IpAddressString", Type, 0},
		{"IpAddressString.String", Field, 0},
		{"IpMaskString", Type, 0},
		{"IpMaskString.String", Field, 2},
		{"Issetugid", Func, 0},
		{"KEY_ALL_ACCESS", Const, 0},
		{"KEY_CREATE_LINK", Const, 0},
		{"KEY_CREATE_SUB_KEY", Const, 0},
		{"KEY_ENUMERATE_SUB_KEYS", Const, 0},
		{"KEY_EXECUTE", Const, 0},
		{"KEY_NOTIFY", Const, 0},
		{"KEY_QUERY_VALUE", Const, 0},
		{"KEY_READ", Const, 0},
		{"KEY_SET_VALUE", Const, 0},
		{"KEY_WOW64_32KEY", Const, 0},
		{"KEY_WOW64_64KEY", Const, 0},
		{"KEY_WRITE", Const, 0},
		{"Kevent", Func, 0},
		{"Kevent_t", Type, 0},
		{"Kevent_t.Data", Field, 0},
		{"Kevent_t.Fflags", Field, 0},
		{"Kevent_t.Filter", Field, 0},
		{"Kevent_t.Flags", Field, 0},
		{"Kevent_t.Ident", Field, 0},
		{"Kevent_t.Pad_cgo_0", Field, 2},
		{"Kevent_t.Udata", Field, 0},
		{"Kill", Func, 0},
		{"Klogctl", Func, 0},
		{"Kqueue", Func, 0},
		{"LANG_ENGLISH", Const, 0},
		{"LAYERED_PROTOCOL", Const, 2},
		{"LCNT_OVERLOAD_FLUSH", Const, 1},
		{"LINUX_REBOOT_CMD_CAD_OFF", Const, 0},
		{"LINUX_REBOOT_CMD_CAD_ON", Const, 0},
		{"LINUX_REBOOT_CMD_HALT", Const, 0},
		{"LINUX_REBOOT_CMD_KEXEC", Const, 0},
		{"LINUX_REBOOT_CMD_POWER_OFF", Const, 0},
		{"LINUX_REBOOT_CMD_RESTART", Const, 0},
		{"LINUX_REBOOT_CMD_RESTART2", Const, 0},
		{"LINUX_REBOOT_CMD_SW_SUSPEND", Const, 0},
		{"LINUX_REBOOT_MAGIC1", Const, 0},
		{"LINUX_REBOOT_MAGIC2", Const, 0},
		{"LOCK_EX", Const, 0},
		{"LOCK_NB", Const, 0},
		{"LOCK_SH", Const, 0},
		{"LOCK_UN", Const, 0},
		{"LazyDLL", Type, 0},
		{"LazyDLL.Name", Field, 0},
		{"LazyProc", Type, 0},
		{"LazyProc.Name", Field, 0},
		{"Lchown", Func, 0},
		{"Linger", Type, 0},
		{"Linger.Linger", Field, 0},
		{"Linger.Onoff", Field, 0},
		{"Link", Func, 0},
		{"Listen", Func, 0},
		{"Listxattr", Func, 1},
		{"LoadCancelIoEx", Func, 1},
		{"LoadConnectEx", Func, 1},
		{"LoadCreateSymbolicLink", Func, 4},
		{"LoadDLL", Func, 0},
		{"LoadGetAddrInfo", Func, 1},
		{"LoadLibrary", Func, 0},
		{"LoadSetFileCompletionNotificationModes", Func, 2},
		{"LocalFree", Func, 0},
		{"Log2phys_t", Type, 0},
		{"Log2phys_t.Contigbytes", Field, 0},
		{"Log2phys_t.Devoffset", Field, 0},
		{"Log2phys_t.Flags", Field, 0},
		{"LookupAccountName", Func, 0},
		{"LookupAccountSid", Func, 0},
		{"LookupSID", Func, 0},
		{"LsfJump", Func, 0},
		{"LsfSocket", Func, 0},
		{"LsfStmt", Func, 0},
		{"Lstat", Func, 0},
		{"MADV_AUTOSYNC", Const, 1},
		{"MADV_CAN_REUSE", Const, 0},
		{"MADV_CORE", Const, 1},
		{"MADV_DOFORK", Const, 0},
		{"MADV_DONTFORK", Const, 0},
		{"MADV_DONTNEED", Const, 0},
		{"MADV_FREE", Const, 0},
		{"MADV_FREE_REUSABLE", Const, 0},
		{"MADV_FREE_REUSE", Const, 0},
		{"MADV_HUGEPAGE", Const, 0},
		{"MADV_HWPOISON", Const, 0},
		{"MADV_MERGEABLE", Const, 0},
		{"MADV_NOCORE", Const, 1},
		{"MADV_NOHUGEPAGE", Const, 0},
		{"MADV_NORMAL", Const, 0},
		{"MADV_NOSYNC", Const, 1},
		{"MADV_PROTECT", Const, 1},
		{"MADV_RANDOM", Const, 0},
		{"MADV_REMOVE", Const, 0},
		{"MADV_SEQUENTIAL", Const, 0},
		{"MADV_SPACEAVAIL", Const, 3},
		{"MADV_UNMERGEABLE", Const, 0},
		{"MADV_WILLNEED", Const, 0},
		{"MADV_ZERO_WIRED_PAGES", Const, 0},
		{"MAP_32BIT", Const, 0},
		{"MAP_ALIGNED_SUPER", Const, 3},
		{"MAP_ALIGNMENT_16MB", Const, 3},
		{"MAP_ALIGNMENT_1TB", Const, 3},
		{"MAP_ALIGNMENT_256TB", Const, 3},
		{"MAP_ALIGNMENT_4GB", Const, 3},
		{"MAP_ALIGNMENT_64KB", Const, 3},
		{"MAP_ALIGNMENT_64PB", Const, 3},
		{"MAP_ALIGNMENT_MASK", Const, 3},
		{"MAP_ALIGNMENT_SHIFT", Const, 3},
		{"MAP_ANON", Const, 0},
		{"MAP_ANONYMOUS", Const, 0},
		{"MAP_COPY", Const, 0},
		{"MAP_DENYWRITE", Const, 0},
		{"MAP_EXECUTABLE", Const, 0},
		{"MAP_FILE", Const, 0},
		{"MAP_FIXED", Const, 0},
		{"MAP_FLAGMASK", Const, 3},
		{"MAP_GROWSDOWN", Const, 0},
		{"MAP_HASSEMAPHORE", Const, 0},
		{"MAP_HUGETLB", Const, 0},
		{"MAP_INHERIT", Const, 3},
		{"MAP_INHERIT_COPY", Const, 3},
		{"MAP_INHERIT_DEFAULT", Const, 3},
		{"MAP_INHERIT_DONATE_COPY", Const, 3},
		{"MAP_INHERIT_NONE", Const, 3},
		{"MAP_INHERIT_SHARE", Const, 3},
		{"MAP_JIT", Const, 0},
		{"MAP_LOCKED", Const, 0},
		{"MAP_NOCACHE", Const, 0},
		{"MAP_NOCORE", Const, 1},
		{"MAP_NOEXTEND", Const, 0},
		{"MAP_NONBLOCK", Const, 0},
		{"MAP_NORESERVE", Const, 0},
		{"MAP_NOSYNC", Const, 1},
		{"MAP_POPULATE", Const, 0},
		{"MAP_PREFAULT_READ", Const, 1},
		{"MAP_PRIVATE", Const, 0},
		{"MAP_RENAME", Const, 0},
		{"MAP_RESERVED0080", Const, 0},
		{"MAP_RESERVED0100", Const, 1},
		{"MAP_SHARED", Const, 0},
		{"MAP_STACK", Const, 0},
		{"MAP_TRYFIXED", Const, 3},
		{"MAP_TYPE", Const, 0},
		{"MAP_WIRED", Const, 3},
		{"MAXIMUM_REPARSE_DATA_BUFFER_SIZE", Const, 4},
		{"MAXLEN_IFDESCR", Const, 0},
		{"MAXLEN_PHYSADDR", Const, 0},
		{"MAX_ADAPTER_ADDRESS_LENGTH", Const, 0},
		{"MAX_ADAPTER_DESCRIPTION_LENGTH", Const, 0},
		{"MAX_ADAPTER_NAME_LENGTH", Const, 0},
		{"MAX_COMPUTERNAME_LENGTH", Const, 0},
		{"MAX_INTERFACE_NAME_LEN", Const, 0},
		{"MAX_LONG_PATH", Const, 0},
		{"MAX_PATH", Const, 0},
		{"MAX_PROTOCOL_CHAIN", Const, 2},
		{"MCL_CURRENT", Const, 0},
		{"MCL_FUTURE", Const, 0},
		{"MNT_DETACH", Const, 0},
		{"MNT_EXPIRE", Const, 0},
		{"MNT_FORCE", Const, 0},
		{"MSG_BCAST", Const, 1},
		{"MSG_CMSG_CLOEXEC", Const, 0},
		{"MSG_COMPAT", Const, 0},
		{"MSG_CONFIRM", Const, 0},
		{"MSG_CONTROLMBUF", Const, 1},
		{"MSG_CTRUNC", Const, 0},
		{"MSG_DONTROUTE", Const, 0},
		{"MSG_DONTWAIT", Const, 0},
		{"MSG_EOF", Const, 0},
		{"MSG_EOR", Const, 0},
		{"MSG_ERRQUEUE", Const, 0},
		{"MSG_FASTOPEN", Const, 1},
		{"MSG_FIN", Const, 0},
		{"MSG_FLUSH", Const, 0},
		{"MSG_HAVEMORE", Const, 0},
		{"MSG_HOLD", Const, 0},
		{"MSG_IOVUSRSPACE", Const, 1},
		{"MSG_LENUSRSPACE", Const, 1},
		{"MSG_MCAST", Const, 1},
		{"MSG_MORE", Const, 0},
		{"MSG_NAMEMBUF", Const, 1},
		{"MSG_NBIO", Const, 0},
		{"MSG_NEEDSA", Const, 0},
		{"MSG_NOSIGNAL", Const, 0},
		{"MSG_NOTIFICATION", Const, 0},
		{"MSG_OOB", Const, 0},
		{"MSG_PEEK", Const, 0},
		{"MSG_PROXY", Const, 0},
		{"MSG_RCVMORE", Const, 0},
		{"MSG_RST", Const, 0},
		{"MSG_SEND", Const, 0},
		{"MSG_SYN", Const, 0},
		{"MSG_TRUNC", Const, 0},
		{"MSG_TRYHARD", Const, 0},
		{"MSG_USERFLAGS", Const, 1},
		{"MSG_WAITALL", Const, 0},
		{"MSG_WAITFORONE", Const, 0},
		{"MSG_WAITSTREAM", Const, 0},
		{"MS_ACTIVE", Const, 0},
		{"MS_ASYNC", Const, 0},
		{"MS_BIND", Const, 0},
		{"MS_DEACTIVATE", Const, 0},
		{"MS_DIRSYNC", Const, 0},
		{"MS_INVALIDATE", Const, 0},
		{"MS_I_VERSION", Const, 0},
		{"MS_KERNMOUNT", Const, 0},
		{"MS_KILLPAGES", Const, 0},
		{"MS_MANDLOCK", Const, 0},
		{"MS_MGC_MSK", Const, 0},
		{"MS_MGC_VAL", Const, 0},
		{"MS_MOVE", Const, 0},
		{"MS_NOATIME", Const, 0},
		{"MS_NODEV", Const, 0},
		{"MS_NODIRATIME", Const, 0},
		{"MS_NOEXEC", Const, 0},
		{"MS_NOSUID", Const, 0},
		{"MS_NOUSER", Const, 0},
		{"MS_POSIXACL", Const, 0},
		{"MS_PRIVATE", Const, 0},
		{"MS_RDONLY", Const, 0},
		{"MS_REC", Const, 0},
		{"MS_RELATIME", Const, 0},
		{"MS_REMOUNT", Const, 0},
		{"MS_RMT_MASK", Const, 0},
		{"MS_SHARED", Const, 0},
		{"MS_SILENT", Const, 0},
		{"MS_SLAVE", Const, 0},
		{"MS_STRICTATIME", Const, 0},
		{"MS_SYNC", Const, 0},
		{"MS_SYNCHRONOUS", Const, 0},
		{"MS_UNBINDABLE", Const, 0},
		{"Madvise", Func, 0},
		{"MapViewOfFile", Func, 0},
		{"MaxTokenInfoClass", Const, 0},
		{"Mclpool", Type, 2},
		{"Mclpool.Alive", Field, 2},
		{"Mclpool.Cwm", Field, 2},
		{"Mclpool.Grown", Field, 2},
		{"Mclpool.Hwm", Field, 2},
		{"Mclpool.Lwm", Field, 2},
		{"MibIfRow", Type, 0},
		{"MibIfRow.AdminStatus", Field, 0},
		{"MibIfRow.Descr", Field, 0},
		{"MibIfRow.DescrLen", Field, 0},
		{"MibIfRow.InDiscards", Field, 0},
		{"MibIfRow.InErrors", Field, 0},
		{"MibIfRow.InNUcastPkts", Field, 0},
		{"MibIfRow.InOctets", Field, 0},
		{"MibIfRow.InUcastPkts", Field, 0},
		{"MibIfRow.InUnknownProtos", Field, 0},
		{"MibIfRow.Index", Field, 0},
		{"MibIfRow.LastChange", Field, 0},
		{"MibIfRow.Mtu", Field, 0},
		{"MibIfRow.Name", Field, 0},
		{"MibIfRow.OperStatus", Field, 0},
		{"MibIfRow.OutDiscards", Field, 0},
		{"MibIfRow.OutErrors", Field, 0},
		{"MibIfRow.OutNUcastPkts", Field, 0},
		{"MibIfRow.OutOctets", Field, 0},
		{"MibIfRow.OutQLen", Field, 0},
		{"MibIfRow.OutUcastPkts", Field, 0},
		{"MibIfRow.PhysAddr", Field, 0},
		{"MibIfRow.PhysAddrLen", Field, 0},
		{"MibIfRow.Speed", Field, 0},
		{"MibIfRow.Type", Field, 0},
		{"Mkdir", Func, 0},
		{"Mkdirat", Func, 0},
		{"Mkfifo", Func, 0},
		{"Mknod", Func, 0},
		{"Mknodat", Func, 0},
		{"Mlock", Func, 0},
		{"Mlockall", Func, 0},
		{"Mmap", Func, 0},
		{"Mount", Func, 0},
		{"MoveFile", Func, 0},
		{"Mprotect", Func, 0},
		{"Msghdr", Type, 0},
		{"Msghdr.Control", Field, 0},
		{"Msghdr.Controllen", Field, 0},
		{"Msghdr.Flags", Field, 0},
		{"Msghdr.Iov", Field, 0},
		{"Msghdr.Iovlen", Field, 0},
		{"Msghdr.Name", Field, 0},
		{"Msghdr.Namelen", Field, 0},
		{"Msghdr.Pad_cgo_0", Field, 0},
		{"Msghdr.Pad_cgo_1", Field, 0},
		{"Munlock", Func, 0},
		{"Munlockall", Func, 0},
		{"Munmap", Func, 0},
		{"MustLoadDLL", Func, 0},
		{"NAME_MAX", Const, 0},
		{"NETLINK_ADD_MEMBERSHIP", Const, 0},
		{"NETLINK_AUDIT", Const, 0},
		{"NETLINK_BROADCAST_ERROR", Const, 0},
		{"NETLINK_CONNECTOR", Const, 0},
		{"NETLINK_DNRTMSG", Const, 0},
		{"NETLINK_DROP_MEMBERSHIP", Const, 0},
		{"NETLINK_ECRYPTFS", Const, 0},
		{"NETLINK_FIB_LOOKUP", Const, 0},
		{"NETLINK_FIREWALL", Const, 0},
		{"NETLINK_GENERIC", Const, 0},
		{"NETLINK_INET_DIAG", Const, 0},
		{"NETLINK_IP6_FW", Const, 0},
		{"NETLINK_ISCSI", Const, 0},
		{"NETLINK_KOBJECT_UEVENT", Const, 0},
		{"NETLINK_NETFILTER", Const, 0},
		{"NETLINK_NFLOG", Const, 0},
		{"NETLINK_NO_ENOBUFS", Const, 0},
		{"NETLINK_PKTINFO", Const, 0},
		{"NETLINK_RDMA", Const, 0},
		{"NETLINK_ROUTE", Const, 0},
		{"NETLINK_SCSITRANSPORT", Const, 0},
		{"NETLINK_SELINUX", Const, 0},
		{"NETLINK_UNUSED", Const, 0},
		{"NETLINK_USERSOCK", Const, 0},
		{"NETLINK_XFRM", Const, 0},
		{"NET_RT_DUMP", Const, 0},
		{"NET_RT_DUMP2", Const, 0},
		{"NET_RT_FLAGS", Const, 0},
		{"NET_RT_IFLIST", Const, 0},
		{"NET_RT_IFLIST2", Const, 0},
		{"NET_RT_IFLISTL", Const, 1},
		{"NET_RT_IFMALIST", Const, 0},
		{"NET_RT_MAXID", Const, 0},
		{"NET_RT_OIFLIST", Const, 1},
		{"NET_RT_OOIFLIST", Const, 1},
		{"NET_RT_STAT", Const, 0},
		{"NET_RT_STATS", Const, 1},
		{"NET_RT_TABLE", Const, 1},
		{"NET_RT_TRASH", Const, 0},
		{"NLA_ALIGNTO", Const, 0},
		{"NLA_F_NESTED", Const, 0},
		{"NLA_F_NET_BYTEORDER", Const, 0},
		{"NLA_HDRLEN", Const, 0},
		{"NLMSG_ALIGNTO", Const, 0},
		{"NLMSG_DONE", Const, 0},
		{"NLMSG_ERROR", Const, 0},
		{"NLMSG_HDRLEN", Const, 0},
		{"NLMSG_MIN_TYPE", Const, 0},
		{"NLMSG_NOOP", Const, 0},
		{"NLMSG_OVERRUN", Const, 0},
		{"NLM_F_ACK", Const, 0},
		{"NLM_F_APPEND", Const, 0},
		{"NLM_F_ATOMIC", Const, 0},
		{"NLM_F_CREATE", Const, 0},
		{"NLM_F_DUMP", Const, 0},
		{"NLM_F_ECHO", Const, 0},
		{"NLM_F_EXCL", Const, 0},
		{"NLM_F_MATCH", Const, 0},
		{"NLM_F_MULTI", Const, 0},
		{"NLM_F_REPLACE", Const, 0},
		{"NLM_F_REQUEST", Const, 0},
		{"NLM_F_ROOT", Const, 0},
		{"NOFLSH", Const, 0},
		{"NOTE_ABSOLUTE", Const, 0},
		{"NOTE_ATTRIB", Const, 0},
		{"NOTE_BACKGROUND", Const, 16},
		{"NOTE_CHILD", Const, 0},
		{"NOTE_CRITICAL", Const, 16},
		{"NOTE_DELETE", Const, 0},
		{"NOTE_EOF", Const, 1},
		{"NOTE_EXEC", Const, 0},
		{"NOTE_EXIT", Const, 0},
		{"NOTE_EXITSTATUS", Const, 0},
		{"NOTE_EXIT_CSERROR", Const, 16},
		{"NOTE_EXIT_DECRYPTFAIL", Const, 16},
		{"NOTE_EXIT_DETAIL", Const, 16},
		{"NOTE_EXIT_DETAIL_MASK", Const, 16},
		{"NOTE_EXIT_MEMORY", Const, 16},
		{"NOTE_EXIT_REPARENTED", Const, 16},
		{"NOTE_EXTEND", Const, 0},
		{"NOTE_FFAND", Const, 0},
		{"NOTE_FFCOPY", Const, 0},
		{"NOTE_FFCTRLMASK", Const, 0},
		{"NOTE_FFLAGSMASK", Const, 0},
		{"NOTE_FFNOP", Const, 0},
		{"NOTE_FFOR", Const, 0},
		{"NOTE_FORK", Const, 0},
		{"NOTE_LEEWAY", Const, 16},
		{"NOTE_LINK", Const, 0},
		{"NOTE_LOWAT", Const, 0},
		{"NOTE_NONE", Const, 0},
		{"NOTE_NSECONDS", Const, 0},
		{"NOTE_PCTRLMASK", Const, 0},
		{"NOTE_PDATAMASK", Const, 0},
		{"NOTE_REAP", Const, 0},
		{"NOTE_RENAME", Const, 0},
		{"NOTE_RESOURCEEND", Const, 0},
		{"NOTE_REVOKE", Const, 0},
		{"NOTE_SECONDS", Const, 0},
		{"NOTE_SIGNAL", Const, 0},
		{"NOTE_TRACK", Const, 0},
		{"NOTE_TRACKERR", Const, 0},
		{"NOTE_TRIGGER", Const, 0},
		{"NOTE_TRUNCATE", Const, 1},
		{"NOTE_USECONDS", Const, 0},
		{"NOTE_VM_ERROR", Const, 0},
		{"NOTE_VM_PRESSURE", Const, 0},
		{"NOTE_VM_PRESSURE_SUDDEN_TERMINATE", Const, 0},
		{"NOTE_VM_PRESSURE_TERMINATE", Const, 0},
		{"NOTE_WRITE", Const, 0},
		{"NameCanonical", Const, 0},
		{"NameCanonicalEx", Const, 0},
		{"NameDisplay", Const, 0},
		{"NameDnsDomain", Const, 0},
		{"NameFullyQualifiedDN", Const, 0},
		{"NameSamCompatible", Const, 0},
		{"NameServicePrincipal", Const, 0},
		{"NameUniqueId", Const, 0},
		{"NameUnknown", Const, 0},
		{"NameUserPrincipal", Const, 0},
		{"Nanosleep", Func, 0},
		{"NetApiBufferFree", Func, 0},
		{"NetGetJoinInformation", Func, 2},
		{"NetSetupDomainName", Const, 2},
		{"NetSetupUnjoined", Const, 2},
		{"NetSetupUnknownStatus", Const, 2},
		{"NetSetupWorkgroupName", Const, 2},
		{"NetUserGetInfo", Func, 0},
		{"NetlinkMessage", Type, 0},
		{"NetlinkMessage.Data", Field, 0},
		{"NetlinkMessage.Header", Field, 0},
		{"NetlinkRIB", Func, 0},
		{"NetlinkRouteAttr", Type, 0},
		{"NetlinkRouteAttr.Attr", Field, 0},
		{"NetlinkRouteAttr.Value", Field, 0},
		{"NetlinkRouteRequest", Type, 0},
		{"NetlinkRouteRequest.Data", Field, 0},
		{"NetlinkRouteRequest.Header", Field, 0},
		{"NewCallback", Func, 0},
		{"NewCallbackCDecl", Func, 3},
		{"NewLazyDLL", Func, 0},
		{"NlAttr", Type, 0},
		{"NlAttr.Len", Field, 0},
		{"NlAttr.Type", Field, 0},
		{"NlMsgerr", Type, 0},
		{"NlMsgerr.Error", Field, 0},
		{"NlMsgerr.Msg", Field, 0},
		{"NlMsghdr", Type, 0},
		{"NlMsghdr.Flags", Field, 0},
		{"NlMsghdr.Len", Field, 0},
		{"NlMsghdr.Pid", Field, 0},
		{"NlMsghdr.Seq", Field, 0},
		{"NlMsghdr.Type", Field, 0},
		{"NsecToFiletime", Func, 0},
		{"NsecToTimespec", Func, 0},
		{"NsecToTimeval", Func, 0},
		{"Ntohs", Func, 0},
		{"OCRNL", Const, 0},
		{"OFDEL", Const, 0},
		{"OFILL", Const, 0},
		{"OFIOGETBMAP", Const, 1},
		{"OID_PKIX_KP_SERVER_AUTH", Var, 0},
		{"OID_SERVER_GATED_CRYPTO", Var, 0},
		{"OID_SGC_NETSCAPE", Var, 0},
		{"OLCUC", Const, 0},
		{"ONLCR", Const, 0},
		{"ONLRET", Const, 0},
		{"ONOCR", Const, 0},
		{"ONOEOT", Const, 1},
		{"OPEN_ALWAYS", Const, 0},
		{"OPEN_EXISTING", Const, 0},
		{"OPOST", Const, 0},
		{"O_ACCMODE", Const, 0},
		{"O_ALERT", Const, 0},
		{"O_ALT_IO", Const, 1},
		{"O_APPEND", Const, 0},
		{"O_ASYNC", Const, 0},
		{"O_CLOEXEC", Const, 0},
		{"O_CREAT", Const, 0},
		{"O_DIRECT", Const, 0},
		{"O_DIRECTORY", Const, 0},
		{"O_DP_GETRAWENCRYPTED", Const, 16},
		{"O_DSYNC", Const, 0},
		{"O_EVTONLY", Const, 0},
		{"O_EXCL", Const, 0},
		{"O_EXEC", Const, 0},
		{"O_EXLOCK", Const, 0},
		{"O_FSYNC", Const, 0},
		{"O_LARGEFILE", Const, 0},
		{"O_NDELAY", Const, 0},
		{"O_NOATIME", Const, 0},
		{"O_NOCTTY", Const, 0},
		{"O_NOFOLLOW", Const, 0},
		{"O_NONBLOCK", Const, 0},
		{"O_NOSIGPIPE", Const, 1},
		{"O_POPUP", Const, 0},
		{"O_RDONLY", Const, 0},
		{"O_RDWR", Const, 0},
		{"O_RSYNC", Const, 0},
		{"O_SHLOCK", Const, 0},
		{"O_SYMLINK", Const, 0},
		{"O_SYNC", Const, 0},
		{"O_TRUNC", Const, 0},
		{"O_TTY_INIT", Const, 0},
		{"O_WRONLY", Const, 0},
		{"Open", Func, 0},
		{"OpenCurrentProcessToken", Func, 0},
		{"OpenProcess", Func, 0},
		{"OpenProcessToken", Func, 0},
		{"Openat", Func, 0},
		{"Overlapped", Type, 0},
		{"Overlapped.HEvent", Field, 0},
		{"Overlapped.Internal", Field, 0},
		{"Overlapped.InternalHigh", Field, 0},
		{"Overlapped.Offset", Field, 0},
		{"Overlapped.OffsetHigh", Field, 0},
		{"PACKET_ADD_MEMBERSHIP", Const, 0},
		{"PACKET_BROADCAST", Const, 0},
		{"PACKET_DROP_MEMBERSHIP", Const, 0},
		{"PACKET_FASTROUTE", Const, 0},
		{"PACKET_HOST", Const, 0},
		{"PACKET_LOOPBACK", Const, 0},
		{"PACKET_MR_ALLMULTI", Const, 0},
		{"PACKET_MR_MULTICAST", Const, 0},
		{"PACKET_MR_PROMISC", Const, 0},
		{"PACKET_MULTICAST", Const, 0},
		{"PACKET_OTHERHOST", Const, 0},
		{"PACKET_OUTGOING", Const, 0},
		{"PACKET_RECV_OUTPUT", Const, 0},
		{"PACKET_RX_RING", Const, 0},
		{"PACKET_STATISTICS", Const, 0},
		{"PAGE_EXECUTE_READ", Const, 0},
		{"PAGE_EXECUTE_READWRITE", Const, 0},
		{"PAGE_EXECUTE_WRITECOPY", Const, 0},
		{"PAGE_READONLY", Const, 0},
		{"PAGE_READWRITE", Const, 0},
		{"PAGE_WRITECOPY", Const, 0},
		{"PARENB", Const, 0},
		{"PARMRK", Const, 0},
		{"PARODD", Const, 0},
		{"PENDIN", Const, 0},
		{"PFL_HIDDEN", Const, 2},
		{"PFL_MATCHES_PROTOCOL_ZERO", Const, 2},
		{"PFL_MULTIPLE_PROTO_ENTRIES", Const, 2},
		{"PFL_NETWORKDIRECT_PROVIDER", Const, 2},
		{"PFL_RECOMMENDED_PROTO_ENTRY", Const, 2},
		{"PF_FLUSH", Const, 1},
		{"PKCS_7_ASN_ENCODING", Const, 0},
		{"PMC5_PIPELINE_FLUSH", Const, 1},
		{"PRIO_PGRP", Const, 2},
		{"PRIO_PROCESS", Const, 2},
		{"PRIO_USER", Const, 2},
		{"PRI_IOFLUSH", Const, 1},
		{"PROCESS_QUERY_INFORMATION", Const, 0},
		{"PROCESS_TERMINATE", Const, 2},
		{"PROT_EXEC", Const, 0},
		{"PROT_GROWSDOWN", Const, 0},
		{"PROT_GROWSUP", Const, 0},
		{"PROT_NONE", Const, 0},
		{"PROT_READ", Const, 0},
		{"PROT_WRITE", Const, 0},
		{"PROV_DH_SCHANNEL", Const, 0},
		{"PROV_DSS", Const, 0},
		{"PROV_DSS_DH", Const, 0},
		{"PROV_EC_ECDSA_FULL", Const, 0},
		{"PROV_EC_ECDSA_SIG", Const, 0},
		{"PROV_EC_ECNRA_FULL", Const, 0},
		{"PROV_EC_ECNRA_SIG", Const, 0},
		{"PROV_FORTEZZA", Const, 0},
		{"PROV_INTEL_SEC", Const, 0},
		{"PROV_MS_EXCHANGE", Const, 0},
		{"PROV_REPLACE_OWF", Const, 0},
		{"PROV_RNG", Const, 0},
		{"PROV_RSA_AES", Const, 0},
		{"PROV_RSA_FULL", Const, 0},
		{"PROV_RSA_SCHANNEL", Const, 0},
		{"PROV_RSA_SIG", Const, 0},
		{"PROV_SPYRUS_LYNKS", Const, 0},
		{"PROV_SSL", Const, 0},
		{"PR_CAPBSET_DROP", Const, 0},
		{"PR_CAPBSET_READ", Const, 0},
		{"PR_CLEAR_SECCOMP_FILTER", Const, 0},
		{"PR_ENDIAN_BIG", Const, 0},
		{"PR_ENDIAN_LITTLE", Const, 0},
		{"PR_ENDIAN_PPC_LITTLE", Const, 0},
		{"PR_FPEMU_NOPRINT", Const, 0},
		{"PR_FPEMU_SIGFPE", Const, 0},
		{"PR_FP_EXC_ASYNC", Const, 0},
		{"PR_FP_EXC_DISABLED", Const, 0},
		{"PR_FP_EXC_DIV", Const, 0},
		{"PR_FP_EXC_INV", Const, 0},
		{"PR_FP_EXC_NONRECOV", Const, 0},
		{"PR_FP_EXC_OVF", Const, 0},
		{"PR_FP_EXC_PRECISE", Const, 0},
		{"PR_FP_EXC_RES", Const, 0},
		{"PR_FP_EXC_SW_ENABLE", Const, 0},
		{"PR_FP_EXC_UND", Const, 0},
		{"PR_GET_DUMPABLE", Const, 0},
		{"PR_GET_ENDIAN", Const, 0},
		{"PR_GET_FPEMU", Const, 0},
		{"PR_GET_FPEXC", Const, 0},
		{"PR_GET_KEEPCAPS", Const, 0},
		{"PR_GET_NAME", Const, 0},
		{"PR_GET_PDEATHSIG", Const, 0},
		{"PR_GET_SECCOMP", Const, 0},
		{"PR_GET_SECCOMP_FILTER", Const, 0},
		{"PR_GET_SECUREBITS", Const, 0},
		{"PR_GET_TIMERSLACK", Const, 0},
		{"PR_GET_TIMING", Const, 0},
		{"PR_GET_TSC", Const, 0},
		{"PR_GET_UNALIGN", Const, 0},
		{"PR_MCE_KILL", Const, 0},
		{"PR_MCE_KILL_CLEAR", Const, 0},
		{"PR_MCE_KILL_DEFAULT", Const, 0},
		{"PR_MCE_KILL_EARLY", Const, 0},
		{"PR_MCE_KILL_GET", Const, 0},
		{"PR_MCE_KILL_LATE", Const, 0},
		{"PR_MCE_KILL_SET", Const, 0},
		{"PR_SECCOMP_FILTER_EVENT", Const, 0},
		{"PR_SECCOMP_FILTER_SYSCALL", Const, 0},
		{"PR_SET_DUMPABLE", Const, 0},
		{"PR_SET_ENDIAN", Const, 0},
		{"PR_SET_FPEMU", Const, 0},
		{"PR_SET_FPEXC", Const, 0},
		{"PR_SET_KEEPCAPS", Const, 0},
		{"PR_SET_NAME", Const, 0},
		{"PR_SET_PDEATHSIG", Const, 0},
		{"PR_SET_PTRACER", Const, 0},
		{"PR_SET_SECCOMP", Const, 0},
		{"PR_SET_SECCOMP_FILTER", Const, 0},
		{"PR_SET_SECUREBITS", Const, 0},
		{"PR_SET_TIMERSLACK", Const, 0},
		{"PR_SET_TIMING", Const, 0},
		{"PR_SET_TSC", Const, 0},
		{"PR_SET_UNALIGN", Const, 0},
		{"PR_TASK_PERF_EVENTS_DISABLE", Const, 0},
		{"PR_TASK_PERF_EVENTS_ENABLE", Const, 0},
		{"PR_TIMING_STATISTICAL", Const, 0},
		{"PR_TIMING_TIMESTAMP", Const, 0},
		{"PR_TSC_ENABLE", Const, 0},
		{"PR_TSC_SIGSEGV", Const, 0},
		{"PR_UNALIGN_NOPRINT", Const, 0},
		{"PR_UNALIGN_SIGBUS", Const, 0},
		{"PTRACE_ARCH_PRCTL", Const, 0},
		{"PTRACE_ATTACH", Const, 0},
		{"PTRACE_CONT", Const, 0},
		{"PTRACE_DETACH", Const, 0},
		{"PTRACE_EVENT_CLONE", Const, 0},
		{"PTRACE_EVENT_EXEC", Const, 0},
		{"PTRACE_EVENT_EXIT", Const, 0},
		{"PTRACE_EVENT_FORK", Const, 0},
		{"PTRACE_EVENT_VFORK", Const, 0},
		{"PTRACE_EVENT_VFORK_DONE", Const, 0},
		{"PTRACE_GETCRUNCHREGS", Const, 0},
		{"PTRACE_GETEVENTMSG", Const, 0},
		{"PTRACE_GETFPREGS", Const, 0},
		{"PTRACE_GETFPXREGS", Const, 0},
		{"PTRACE_GETHBPREGS", Const, 0},
		{"PTRACE_GETREGS", Const, 0},
		{"PTRACE_GETREGSET", Const, 0},
		{"PTRACE_GETSIGINFO", Const, 0},
		{"PTRACE_GETVFPREGS", Const, 0},
		{"PTRACE_GETWMMXREGS", Const, 0},
		{"PTRACE_GET_THREAD_AREA", Const, 0},
		{"PTRACE_KILL", Const, 0},
		{"PTRACE_OLDSETOPTIONS", Const, 0},
		{"PTRACE_O_MASK", Const, 0},
		{"PTRACE_O_TRACECLONE", Const, 0},
		{"PTRACE_O_TRACEEXEC", Const, 0},
		{"PTRACE_O_TRACEEXIT", Const, 0},
		{"PTRACE_O_TRACEFORK", Const, 0},
		{"PTRACE_O_TRACESYSGOOD", Const, 0},
		{"PTRACE_O_TRACEVFORK", Const, 0},
		{"PTRACE_O_TRACEVFORKDONE", Const, 0},
		{"PTRACE_PEEKDATA", Const, 0},
		{"PTRACE_PEEKTEXT", Const, 0},
		{"PTRACE_PEEKUSR", Const, 0},
		{"PTRACE_POKEDATA", Const, 0},
		{"PTRACE_POKETEXT", Const, 0},
		{"PTRACE_POKEUSR", Const, 0},
		{"PTRACE_SETCRUNCHREGS", Const, 0},
		{"PTRACE_SETFPREGS", Const, 0},
		{"PTRACE_SETFPXREGS", Const, 0},
		{"PTRACE_SETHBPREGS", Const, 0},
		{"PTRACE_SETOPTIONS", Const, 0},
		{"PTRACE_SETREGS", Const, 0},
		{"PTRACE_SETREGSET", Const, 0},
		{"PTRACE_SETSIGINFO", Const, 0},
		{"PTRACE_SETVFPREGS", Const, 0},
		{"PTRACE_SETWMMXREGS", Const, 0},
		{"PTRACE_SET_SYSCALL", Const, 0},
		{"PTRACE_SET_THREAD_AREA", Const, 0},
		{"PTRACE_SINGLEBLOCK", Const, 0},
		{"PTRACE_SINGLESTEP", Const, 0},
		{"PTRACE_SYSCALL", Const, 0},
		{"PTRACE_SYSEMU", Const, 0},
		{"PTRACE_SYSEMU_SINGLESTEP", Const, 0},
		{"PTRACE_TRACEME", Const, 0},
		{"PT_ATTACH", Const, 0},
		{"PT_ATTACHEXC", Const, 0},
		{"PT_CONTINUE", Const, 0},
		{"PT_DATA_ADDR", Const, 0},
		{"PT_DENY_ATTACH", Const, 0},
		{"PT_DETACH", Const, 0},
		{"PT_FIRSTMACH", Const, 0},
		{"PT_FORCEQUOTA", Const, 0},
		{"PT_KILL", Const, 0},
		{"PT_MASK", Const, 1},
		{"PT_READ_D", Const, 0},
		{"PT_READ_I", Const, 0},
		{"PT_READ_U", Const, 0},
		{"PT_SIGEXC", Const, 0},
		{"PT_STEP", Const, 0},
		{"PT_TEXT_ADDR", Const, 0},
		{"PT_TEXT_END_ADDR", Const, 0},
		{"PT_THUPDATE", Const, 0},
		{"PT_TRACE_ME", Const, 0},
		{"PT_WRITE_D", Const, 0},
		{"PT_WRITE_I", Const, 0},
		{"PT_WRITE_U", Const, 0},
		{"ParseDirent", Func, 0},
		{"ParseNetlinkMessage", Func, 0},
		{"ParseNetlinkRouteAttr", Func, 0},
		{"ParseRoutingMessage", Func, 0},
		{"ParseRoutingSockaddr", Func, 0},
		{"ParseSocketControlMessage", Func, 0},
		{"ParseUnixCredentials", Func, 0},
		{"ParseUnixRights", Func, 0},
		{"PathMax", Const, 0},
		{"Pathconf", Func, 0},
		{"Pause", Func, 0},
		{"Pipe", Func, 0},
		{"Pipe2", Func, 1},
		{"PivotRoot", Func, 0},
		{"Pointer", Type, 11},
		{"PostQueuedCompletionStatus", Func, 0},
		{"Pread", Func, 0},
		{"Proc", Type, 0},
		{"Proc.Dll", Field, 0},
		{"Proc.Name", Field, 0},
		{"ProcAttr", Type, 0},
		{"ProcAttr.Dir", Field, 0},
		{"ProcAttr.Env", Field, 0},
		{"ProcAttr.Files", Field, 0},
		{"ProcAttr.Sys", Field, 0},
		{"Process32First", Func, 4},
		{"Process32Next", Func, 4},
		{"ProcessEntry32", Type, 4},
		{"ProcessEntry32.DefaultHeapID", Field, 4},
		{"ProcessEntry32.ExeFile", Field, 4},
		{"ProcessEntry32.Flags", Field, 4},
		{"ProcessEntry32.ModuleID", Field, 4},
		{"ProcessEntry32.ParentProcessID", Field, 4},
		{"ProcessEntry32.PriClassBase", Field, 4},
		{"ProcessEntry32.ProcessID", Field, 4},
		{"ProcessEntry32.Size", Field, 4},
		{"ProcessEntry32.Threads", Field, 4},
		{"ProcessEntry32.Usage", Field, 4},
		{"ProcessInformation", Type, 0},
		{"ProcessInformation.Process", Field, 0},
		{"ProcessInformation.ProcessId", Field, 0},
		{"ProcessInformation.Thread", Field, 0},
		{"ProcessInformation.ThreadId", Field, 0},
		{"Protoent", Type, 0},
		{"Protoent.Aliases", Field, 0},
		{"Protoent.Name", Field, 0},
		{"Protoent.Proto", Field, 0},
		{"PtraceAttach", Func, 0},
		{"PtraceCont", Func, 0},
		{"PtraceDetach", Func, 0},
		{"PtraceGetEventMsg", Func, 0},
		{"PtraceGetRegs", Func, 0},
		{"PtracePeekData", Func, 0},
		{"PtracePeekText", Func, 0},
		{"PtracePokeData", Func, 0},
		{"PtracePokeText", Func, 0},
		{"PtraceRegs", Type, 0},
		{"PtraceRegs.Cs", Field, 0},
		{"PtraceRegs.Ds", Field, 0},
		{"PtraceRegs.Eax", Field, 0},
		{"PtraceRegs.Ebp", Field, 0},
		{"PtraceRegs.Ebx", Field, 0},
		{"PtraceRegs.Ecx", Field, 0},
		{"PtraceRegs.Edi", Field, 0},
		{"PtraceRegs.Edx", Field, 0},
		{"PtraceRegs.Eflags", Field, 0},
		{"PtraceRegs.Eip", Field, 0},
		{"PtraceRegs.Es", Field, 0},
		{"PtraceRegs.Esi", Field, 0},
		{"PtraceRegs.Esp", Field, 0},
		{"PtraceRegs.Fs", Field, 0},
		{"PtraceRegs.Fs_base", Field, 0},
		{"PtraceRegs.Gs", Field, 0},
		{"PtraceRegs.Gs_base", Field, 0},
		{"PtraceRegs.Orig_eax", Field, 0},
		{"PtraceRegs.Orig_rax", Field, 0},
		{"PtraceRegs.R10", Field, 0},
		{"PtraceRegs.R11", Field, 0},
		{"PtraceRegs.R12", Field, 0},
		{"PtraceRegs.R13", Field, 0},
		{"PtraceRegs.R14", Field, 0},
		{"PtraceRegs.R15", Field, 0},
		{"PtraceRegs.R8", Field, 0},
		{"PtraceRegs.R9", Field, 0},
		{"PtraceRegs.Rax", Field, 0},
		{"PtraceRegs.Rbp", Field, 0},
		{"PtraceRegs.Rbx", Field, 0},
		{"PtraceRegs.Rcx", Field, 0},
		{"PtraceRegs.Rdi", Field, 0},
		{"PtraceRegs.Rdx", Field, 0},
		{"PtraceRegs.Rip", Field, 0},
		{"PtraceRegs.Rsi", Field, 0},
		{"PtraceRegs.Rsp", Field, 0},
		{"PtraceRegs.Ss", Field, 0},
		{"PtraceRegs.Uregs", Field, 0},
		{"PtraceRegs.Xcs", Field, 0},
		{"PtraceRegs.Xds", Field, 0},
		{"PtraceRegs.Xes", Field, 0},
		{"PtraceRegs.Xfs", Field, 0},
		{"PtraceRegs.Xgs", Field, 0},
		{"PtraceRegs.Xss", Field, 0},
		{"PtraceSetOptions", Func, 0},
		{"PtraceSetRegs", Func, 0},
		{"PtraceSingleStep", Func, 0},
		{"PtraceSyscall", Func, 1},
		{"Pwrite", Func, 0},
		{"REG_BINARY", Const, 0},
		{"REG_DWORD", Const, 0},
		{"REG_DWORD_BIG_ENDIAN", Const, 0},
		{"REG_DWORD_LITTLE_ENDIAN", Const, 0},
		{"REG_EXPAND_SZ", Const, 0},
		{"REG_FULL_RESOURCE_DESCRIPTOR", Const, 0},
		{"REG_LINK", Const, 0},
		{"REG_MULTI_SZ", Const, 0},
		{"REG_NONE", Const, 0},
		{"REG_QWORD", Const, 0},
		{"REG_QWORD_LITTLE_ENDIAN", Const, 0},
		{"REG_RESOURCE_LIST", Const, 0},
		{"REG_RESOURCE_REQUIREMENTS_LIST", Const, 0},
		{"REG_SZ", Const, 0},
		{"RLIMIT_AS", Const, 0},
		{"RLIMIT_CORE", Const, 0},
		{"RLIMIT_CPU", Const, 0},
		{"RLIMIT_CPU_USAGE_MONITOR", Const, 16},
		{"RLIMIT_DATA", Const, 0},
		{"RLIMIT_FSIZE", Const, 0},
		{"RLIMIT_NOFILE", Const, 0},
		{"RLIMIT_STACK", Const, 0},
		{"RLIM_INFINITY", Const, 0},
		{"RTAX_ADVMSS", Const, 0},
		{"RTAX_AUTHOR", Const, 0},
		{"RTAX_BRD", Const, 0},
		{"RTAX_CWND", Const, 0},
		{"RTAX_DST", Const, 0},
		{"RTAX_FEATURES", Const, 0},
		{"RTAX_FEATURE_ALLFRAG", Const, 0},
		{"RTAX_FEATURE_ECN", Const, 0},
		{"RTAX_FEATURE_SACK", Const, 0},
		{"RTAX_FEATURE_TIMESTAMP", Const, 0},
		{"RTAX_GATEWAY", Const, 0},
		{"RTAX_GENMASK", Const, 0},
		{"RTAX_HOPLIMIT", Const, 0},
		{"RTAX_IFA", Const, 0},
		{"RTAX_IFP", Const, 0},
		{"RTAX_INITCWND", Const, 0},
		{"RTAX_INITRWND", Const, 0},
		{"RTAX_LABEL", Const, 1},
		{"RTAX_LOCK", Const, 0},
		{"RTAX_MAX", Const, 0},
		{"RTAX_MTU", Const, 0},
		{"RTAX_NETMASK", Const, 0},
		{"RTAX_REORDERING", Const, 0},
		{"RTAX_RTO_MIN", Const, 0},
		{"RTAX_RTT", Const, 0},
		{"RTAX_RTTVAR", Const, 0},
		{"RTAX_SRC", Const, 1},
		{"RTAX_SRCMASK", Const, 1},
		{"RTAX_SSTHRESH", Const, 0},
		{"RTAX_TAG", Const, 1},
		{"RTAX_UNSPEC", Const, 0},
		{"RTAX_WINDOW", Const, 0},
		{"RTA_ALIGNTO", Const, 0},
		{"RTA_AUTHOR", Const, 0},
		{"RTA_BRD", Const, 0},
		{"RTA_CACHEINFO", Const, 0},
		{"RTA_DST", Const, 0},
		{"RTA_FLOW", Const, 0},
		{"RTA_GATEWAY", Const, 0},
		{"RTA_GENMASK", Const, 0},
		{"RTA_IFA", Const, 0},
		{"RTA_IFP", Const, 0},
		{"RTA_IIF", Const, 0},
		{"RTA_LABEL", Const, 1},
		{"RTA_MAX", Const, 0},
		{"RTA_METRICS", Const, 0},
		{"RTA_MULTIPATH", Const, 0},
		{"RTA_NETMASK", Const, 0},
		{"RTA_OIF", Const, 0},
		{"RTA_PREFSRC", Const, 0},
		{"RTA_PRIORITY", Const, 0},
		{"RTA_SRC", Const, 0},
		{"RTA_SRCMASK", Const, 1},
		{"RTA_TABLE", Const, 0},
		{"RTA_TAG", Const, 1},
		{"RTA_UNSPEC", Const, 0},
		{"RTCF_DIRECTSRC", Const, 0},
		{"RTCF_DOREDIRECT", Const, 0},
		{"RTCF_LOG", Const, 0},
		{"RTCF_MASQ", Const, 0},
		{"RTCF_NAT", Const, 0},
		{"RTCF_VALVE", Const, 0},
		{"RTF_ADDRCLASSMASK", Const, 0},
		{"RTF_ADDRCONF", Const, 0},
		{"RTF_ALLONLINK", Const, 0},
		{"RTF_ANNOUNCE", Const, 1},
		{"RTF_BLACKHOLE", Const, 0},
		{"RTF_BROADCAST", Const, 0},
		{"RTF_CACHE", Const, 0},
		{"RTF_CLONED", Const, 1},
		{"RTF_CLONING", Const, 0},
		{"RTF_CONDEMNED", Const, 0},
		{"RTF_DEFAULT", Const, 0},
		{"RTF_DELCLONE", Const, 0},
		{"RTF_DONE", Const, 0},
		{"RTF_DYNAMIC", Const, 0},
		{"RTF_FLOW", Const, 0},
		{"RTF_FMASK", Const, 0},
		{"RTF_GATEWAY", Const, 0},
		{"RTF_GWFLAG_COMPAT", Const, 3},
		{"RTF_HOST", Const, 0},
		{"RTF_IFREF", Const, 0},
		{"RTF_IFSCOPE", Const, 0},
		{"RTF_INTERFACE", Const, 0},
		{"RTF_IRTT", Const, 0},
		{"RTF_LINKRT", Const, 0},
		{"RTF_LLDATA", Const, 0},
		{"RTF_LLINFO", Const, 0},
		{"RTF_LOCAL", Const, 0},
		{"RTF_MASK", Const, 1},
		{"RTF_MODIFIED", Const, 0},
		{"RTF_MPATH", Const, 1},
		{"RTF_MPLS", Const, 1},
		{"RTF_MSS", Const, 0},
		{"RTF_MTU", Const, 0},
		{"RTF_MULTICAST", Const, 0},
		{"RTF_NAT", Const, 0},
		{"RTF_NOFORWARD", Const, 0},
		{"RTF_NONEXTHOP", Const, 0},
		{"RTF_NOPMTUDISC", Const, 0},
		{"RTF_PERMANENT_ARP", Const, 1},
		{"RTF_PINNED", Const, 0},
		{"RTF_POLICY", Const, 0},
		{"RTF_PRCLONING", Const, 0},
		{"RTF_PROTO1", Const, 0},
		{"RTF_PROTO2", Const, 0},
		{"RTF_PROTO3", Const, 0},
		{"RTF_PROXY", Const, 16},
		{"RTF_REINSTATE", Const, 0},
		{"RTF_REJECT", Const, 0},
		{"RTF_RNH_LOCKED", Const, 0},
		{"RTF_ROUTER", Const, 16},
		{"RTF_SOURCE", Const, 1},
		{"RTF_SRC", Const, 1},
		{"RTF_STATIC", Const, 0},
		{"RTF_STICKY", Const, 0},
		{"RTF_THROW", Const, 0},
		{"RTF_TUNNEL", Const, 1},
		{"RTF_UP", Const, 0},
		{"RTF_USETRAILERS", Const, 1},
		{"RTF_WASCLONED", Const, 0},
		{"RTF_WINDOW", Const, 0},
		{"RTF_XRESOLVE", Const, 0},
		{"RTM_ADD", Const, 0},
		{"RTM_BASE", Const, 0},
		{"RTM_CHANGE", Const, 0},
		{"RTM_CHGADDR", Const, 1},
		{"RTM_DELACTION", Const, 0},
		{"RTM_DELADDR", Const, 0},
		{"RTM_DELADDRLABEL", Const, 0},
		{"RTM_DELETE", Const, 0},
		{"RTM_DELLINK", Const, 0},
		{"RTM_DELMADDR", Const, 0},
		{"RTM_DELNEIGH", Const, 0},
		{"RTM_DELQDISC", Const, 0},
		{"RTM_DELROUTE", Const, 0},
		{"RTM_DELRULE", Const, 0},
		{"RTM_DELTCLASS", Const, 0},
		{"RTM_DELTFILTER", Const, 0},
		{"RTM_DESYNC", Const, 1},
		{"RTM_F_CLONED", Const, 0},
		{"RTM_F_EQUALIZE", Const, 0},
		{"RTM_F_NOTIFY", Const, 0},
		{"RTM_F_PREFIX", Const, 0},
		{"RTM_GET", Const, 0},
		{"RTM_GET2", Const, 0},
		{"RTM_GETACTION", Const, 0},
		{"RTM_GETADDR", Const, 0},
		{"RTM_GETADDRLABEL", Const, 0},
		{"RTM_GETANYCAST", Const, 0},
		{"RTM_GETDCB", Const, 0},
		{"RTM_GETLINK", Const, 0},
		{"RTM_GETMULTICAST", Const, 0},
		{"RTM_GETNEIGH", Const, 0},
		{"RTM_GETNEIGHTBL", Const, 0},
		{"RTM_GETQDISC", Const, 0},
		{"RTM_GETROUTE", Const, 0},
		{"RTM_GETRULE", Const, 0},
		{"RTM_GETTCLASS", Const, 0},
		{"RTM_GETTFILTER", Const, 0},
		{"RTM_IEEE80211", Const, 0},
		{"RTM_IFANNOUNCE", Const, 0},
		{"RTM_IFINFO", Const, 0},
		{"RTM_IFINFO2", Const, 0},
		{"RTM_LLINFO_UPD", Const, 1},
		{"RTM_LOCK", Const, 0},
		{"RTM_LOSING", Const, 0},
		{"RTM_MAX", Const, 0},
		{"RTM_MAXSIZE", Const, 1},
		{"RTM_MISS", Const, 0},
		{"RTM_NEWACTION", Const, 0},
		{"RTM_NEWADDR", Const, 0},
		{"RTM_NEWADDRLABEL", Const, 0},
		{"RTM_NEWLINK", Const, 0},
		{"RTM_NEWMADDR", Const, 0},
		{"RTM_NEWMADDR2", Const, 0},
		{"RTM_NEWNDUSEROPT", Const, 0},
		{"RTM_NEWNEIGH", Const, 0},
		{"RTM_NEWNEIGHTBL", Const, 0},
		{"RTM_NEWPREFIX", Const, 0},
		{"RTM_NEWQDISC", Const, 0},
		{"RTM_NEWROUTE", Const, 0},
		{"RTM_NEWRULE", Const, 0},
		{"RTM_NEWTCLASS", Const, 0},
		{"RTM_NEWTFILTER", Const, 0},
		{"RTM_NR_FAMILIES", Const, 0},
		{"RTM_NR_MSGTYPES", Const, 0},
		{"RTM_OIFINFO", Const, 1},
		{"RTM_OLDADD", Const, 0},
		{"RTM_OLDDEL", Const, 0},
		{"RTM_OOIFINFO", Const, 1},
		{"RTM_REDIRECT", Const, 0},
		{"RTM_RESOLVE", Const, 0},
		{"RTM_RTTUNIT", Const, 0},
		{"RTM_SETDCB", Const, 0},
		{"RTM_SETGATE", Const, 1},
		{"RTM_SETLINK", Const, 0},
		{"RTM_SETNEIGHTBL", Const, 0},
		{"RTM_VERSION", Const, 0},
		{"RTNH_ALIGNTO", Const, 0},
		{"RTNH_F_DEAD", Const, 0},
		{"RTNH_F_ONLINK", Const, 0},
		{"RTNH_F_PERVASIVE", Const, 0},
		{"RTNLGRP_IPV4_IFADDR", Const, 1},
		{"RTNLGRP_IPV4_MROUTE", Const, 1},
		{"RTNLGRP_IPV4_ROUTE", Const, 1},
		{"RTNLGRP_IPV4_RULE", Const, 1},
		{"RTNLGRP_IPV6_IFADDR", Const, 1},
		{"RTNLGRP_IPV6_IFINFO", Const, 1},
		{"RTNLGRP_IPV6_MROUTE", Const, 1},
		{"RTNLGRP_IPV6_PREFIX", Const, 1},
		{"RTNLGRP_IPV6_ROUTE", Const, 1},
		{"RTNLGRP_IPV6_RULE", Const, 1},
		{"RTNLGRP_LINK", Const, 1},
		{"RTNLGRP_ND_USEROPT", Const, 1},
		{"RTNLGRP_NEIGH", Const, 1},
		{"RTNLGRP_NONE", Const, 1},
		{"RTNLGRP_NOTIFY", Const, 1},
		{"RTNLGRP_TC", Const, 1},
		{"RTN_ANYCAST", Const, 0},
		{"RTN_BLACKHOLE", Const, 0},
		{"RTN_BROADCAST", Const, 0},
		{"RTN_LOCAL", Const, 0},
		{"RTN_MAX", Const, 0},
		{"RTN_MULTICAST", Const, 0},
		{"RTN_NAT", Const, 0},
		{"RTN_PROHIBIT", Const, 0},
		{"RTN_THROW", Const, 0},
		{"RTN_UNICAST", Const, 0},
		{"RTN_UNREACHABLE", Const, 0},
		{"RTN_UNSPEC", Const, 0},
		{"RTN_XRESOLVE", Const, 0},
		{"RTPROT_BIRD", Const, 0},
		{"RTPROT_BOOT", Const, 0},
		{"RTPROT_DHCP", Const, 0},
		{"RTPROT_DNROUTED", Const, 0},
		{"RTPROT_GATED", Const, 0},
		{"RTPROT_KERNEL", Const, 0},
		{"RTPROT_MRT", Const, 0},
		{"RTPROT_NTK", Const, 0},
		{"RTPROT_RA", Const, 0},
		{"RTPROT_REDIRECT", Const, 0},
		{"RTPROT_STATIC", Const, 0},
		{"RTPROT_UNSPEC", Const, 0},
		{"RTPROT_XORP", Const, 0},
		{"RTPROT_ZEBRA", Const, 0},
		{"RTV_EXPIRE", Const, 0},
		{"RTV_HOPCOUNT", Const, 0},
		{"RTV_MTU", Const, 0},
		{"RTV_RPIPE", Const, 0},
		{"RTV_RTT", Const, 0},
		{"RTV_RTTVAR", Const, 0},
		{"RTV_SPIPE", Const, 0},
		{"RTV_SSTHRESH", Const, 0},
		{"RTV_WEIGHT", Const, 0},
		{"RT_CACHING_CONTEXT", Const, 1},
		{"RT_CLASS_DEFAULT", Const, 0},
		{"RT_CLASS_LOCAL", Const, 0},
		{"RT_CLASS_MAIN", Const, 0},
		{"RT_CLASS_MAX", Const, 0},
		{"RT_CLASS_UNSPEC", Const, 0},
		{"RT_DEFAULT_FIB", Const, 1},
		{"RT_NORTREF", Const, 1},
		{"RT_SCOPE_HOST", Const, 0},
		{"RT_SCOPE_LINK", Const, 0},
		{"RT_SCOPE_NOWHERE", Const, 0},
		{"RT_SCOPE_SITE", Const, 0},
		{"RT_SCOPE_UNIVERSE", Const, 0},
		{"RT_TABLEID_MAX", Const, 1},
		{"RT_TABLE_COMPAT", Const, 0},
		{"RT_TABLE_DEFAULT", Const, 0},
		{"RT_TABLE_LOCAL", Const, 0},
		{"RT_TABLE_MAIN", Const, 0},
		{"RT_TABLE_MAX", Const, 0},
		{"RT_TABLE_UNSPEC", Const, 0},
		{"RUSAGE_CHILDREN", Const, 0},
		{"RUSAGE_SELF", Const, 0},
		{"RUSAGE_THREAD", Const, 0},
		{"Radvisory_t", Type, 0},
		{"Radvisory_t.Count", Field, 0},
		{"Radvisory_t.Offset", Field, 0},
		{"Radvisory_t.Pad_cgo_0", Field, 0},
		{"RawConn", Type, 9},
		{"RawSockaddr", Type, 0},
		{"RawSockaddr.Data", Field, 0},
		{"RawSockaddr.Family", Field, 0},
		{"RawSockaddr.Len", Field, 0},
		{"RawSockaddrAny", Type, 0},
		{"RawSockaddrAny.Addr", Field, 0},
		{"RawSockaddrAny.Pad", Field, 0},
		{"RawSockaddrDatalink", Type, 0},
		{"RawSockaddrDatalink.Alen", Field, 0},
		{"RawSockaddrDatalink.Data", Field, 0},
		{"RawSockaddrDatalink.Family", Field, 0},
		{"RawSockaddrDatalink.Index", Field, 0},
		{"RawSockaddrDatalink.Len", Field, 0},
		{"RawSockaddrDatalink.Nlen", Field, 0},
		{"RawSockaddrDatalink.Pad_cgo_0", Field, 2},
		{"RawSockaddrDatalink.Slen", Field, 0},
		{"RawSockaddrDatalink.Type", Field, 0},
		{"RawSockaddrInet4", Type, 0},
		{"RawSockaddrInet4.Addr", Field, 0},
		{"RawSockaddrInet4.Family", Field, 0},
		{"RawSockaddrInet4.Len", Field, 0},
		{"RawSockaddrInet4.Port", Field, 0},
		{"RawSockaddrInet4.Zero", Field, 0},
		{"RawSockaddrInet6", Type, 0},
		{"RawSockaddrInet6.Addr", Field, 0},
		{"RawSockaddrInet6.Family", Field, 0},
		{"RawSockaddrInet6.Flowinfo", Field, 0},
		{"RawSockaddrInet6.Len", Field, 0},
		{"RawSockaddrInet6.Port", Field, 0},
		{"RawSockaddrInet6.Scope_id", Field, 0},
		{"RawSockaddrLinklayer", Type, 0},
		{"RawSockaddrLinklayer.Addr", Field, 0},
		{"RawSockaddrLinklayer.Family", Field, 0},
		{"RawSockaddrLinklayer.Halen", Field, 0},
		{"RawSockaddrLinklayer.Hatype", Field, 0},
		{"RawSockaddrLinklayer.Ifindex", Field, 0},
		{"RawSockaddrLinklayer.Pkttype", Field, 0},
		{"RawSockaddrLinklayer.Protocol", Field, 0},
		{"RawSockaddrNetlink", Type, 0},
		{"RawSockaddrNetlink.Family", Field, 0},
		{"RawSockaddrNetlink.Groups", Field, 0},
		{"RawSockaddrNetlink.Pad", Field, 0},
		{"RawSockaddrNetlink.Pid", Field, 0},
		{"RawSockaddrUnix", Type, 0},
		{"RawSockaddrUnix.Family", Field, 0},
		{"RawSockaddrUnix.Len", Field, 0},
		{"RawSockaddrUnix.Pad_cgo_0", Field, 2},
		{"RawSockaddrUnix.Path", Field, 0},
		{"RawSyscall", Func, 0},
		{"RawSyscall6", Func, 0},
		{"Read", Func, 0},
		{"ReadConsole", Func, 1},
		{"ReadDirectoryChanges", Func, 0},
		{"ReadDirent", Func, 0},
		{"ReadFile", Func, 0},
		{"Readlink", Func, 0},
		{"Reboot", Func, 0},
		{"Recvfrom", Func, 0},
		{"Recvmsg", Func, 0},
		{"RegCloseKey", Func, 0},
		{"RegEnumKeyEx", Func, 0},
		{"RegOpenKeyEx", Func, 0},
		{"RegQueryInfoKey", Func, 0},
		{"RegQueryValueEx", Func, 0},
		{"RemoveDirectory", Func, 0},
		{"Removexattr", Func, 1},
		{"Rename", Func, 0},
		{"Renameat", Func, 0},
		{"Revoke", Func, 0},
		{"Rlimit", Type, 0},
		{"Rlimit.Cur", Field, 0},
		{"Rlimit.Max", Field, 0},
		{"Rmdir", Func, 0},
		{"RouteMessage", Type, 0},
		{"RouteMessage.Data", Field, 0},
		{"RouteMessage.Header", Field, 0},
		{"RouteRIB", Func, 0},
		{"RoutingMessage", Type, 0},
		{"RtAttr", Type, 0},
		{"RtAttr.Len", Field, 0},
		{"RtAttr.Type", Field, 0},
		{"RtGenmsg", Type, 0},
		{"RtGenmsg.Family", Field, 0},
		{"RtMetrics", Type, 0},
		{"RtMetrics.Expire", Field, 0},
		{"RtMetrics.Filler", Field, 0},
		{"RtMetrics.Hopcount", Field, 0},
		{"RtMetrics.Locks", Field, 0},
		{"RtMetrics.Mtu", Field, 0},
		{"RtMetrics.Pad", Field, 3},
		{"RtMetrics.Pksent", Field, 0},
		{"RtMetrics.Recvpipe", Field, 0},
		{"RtMetrics.Refcnt", Field, 2},
		{"RtMetrics.Rtt", Field, 0},
		{"RtMetrics.Rttvar", Field, 0},
		{"RtMetrics.Sendpipe", Field, 0},
		{"RtMetrics.Ssthresh", Field, 0},
		{"RtMetrics.Weight", Field, 0},
		{"RtMsg", Type, 0},
		{"RtMsg.Dst_len", Field, 0},
		{"RtMsg.Family", Field, 0},
		{"RtMsg.Flags", Field, 0},
		{"RtMsg.Protocol", Field, 0},
		{"RtMsg.Scope", Field, 0},
		{"RtMsg.Src_len", Field, 0},
		{"RtMsg.Table", Field, 0},
		{"RtMsg.Tos", Field, 0},
		{"RtMsg.Type", Field, 0},
		{"RtMsghdr", Type, 0},
		{"RtMsghdr.Addrs", Field, 0},
		{"RtMsghdr.Errno", Field, 0},
		{"RtMsghdr.Flags", Field, 0},
		{"RtMsghdr.Fmask", Field, 0},
		{"RtMsghdr.Hdrlen", Field, 2},
		{"RtMsghdr.Index", Field, 0},
		{"RtMsghdr.Inits", Field, 0},
		{"RtMsghdr.Mpls", Field, 2},
		{"RtMsghdr.Msglen", Field, 0},
		{"RtMsghdr.Pad_cgo_0", Field, 0},
		{"RtMsghdr.Pad_cgo_1", Field, 2},
		{"RtMsghdr.Pid", Field, 0},
		{"RtMsghdr.Priority", Field, 2},
		{"RtMsghdr.Rmx", Field, 0},
		{"RtMsghdr.Seq", Field, 0},
		{"RtMsghdr.Tableid", Field, 2},
		{"RtMsghdr.Type", Field, 0},
		{"RtMsghdr.Use", Field, 0},
		{"RtMsghdr.Version", Field, 0},
		{"RtNexthop", Type, 0},
		{"RtNexthop.Flags", Field, 0},
		{"RtNexthop.Hops", Field, 0},
		{"RtNexthop.Ifindex", Field, 0},
		{"RtNexthop.Len", Field, 0},
		{"Rusage", Type, 0},
		{"Rusage.CreationTime", Field, 0},
		{"Rusage.ExitTime", Field, 0},
		{"Rusage.Idrss", Field, 0},
		{"Rusage.Inblock", Field, 0},
		{"Rusage.Isrss", Field, 0},
		{"Rusage.Ixrss", Field, 0},
		{"Rusage.KernelTime", Field, 0},
		{"Rusage.Majflt", Field, 0},
		{"Rusage.Maxrss", Field, 0},
		{"Rusage.Minflt", Field, 0},
		{"Rusage.Msgrcv", Field, 0},
		{"Rusage.Msgsnd", Field, 0},
		{"Rusage.Nivcsw", Field, 0},
		{"Rusage.Nsignals", Field, 0},
		{"Rusage.Nswap", Field, 0},
		{"Rusage.Nvcsw", Field, 0},
		{"Rusage.Oublock", Field, 0},
		{"Rusage.Stime", Field, 0},
		{"Rusage.UserTime", Field, 0},
		{"Rusage.Utime", Field, 0},
		{"SCM_BINTIME", Const, 0},
		{"SCM_CREDENTIALS", Const, 0},
		{"SCM_CREDS", Const, 0},
		{"SCM_RIGHTS", Const, 0},
		{"SCM_TIMESTAMP", Const, 0},
		{"SCM_TIMESTAMPING", Const, 0},
		{"SCM_TIMESTAMPNS", Const, 0},
		{"SCM_TIMESTAMP_MONOTONIC", Const, 0},
		{"SHUT_RD", Const, 0},
		{"SHUT_RDWR", Const, 0},
		{"SHUT_WR", Const, 0},
		{"SID", Type, 0},
		{"SIDAndAttributes", Type, 0},
		{"SIDAndAttributes.Attributes", Field, 0},
		{"SIDAndAttributes.Sid", Field, 0},
		{"SIGABRT", Const, 0},
		{"SIGALRM", Const, 0},
		{"SIGBUS", Const, 0},
		{"SIGCHLD", Const, 0},
		{"SIGCLD", Const, 0},
		{"SIGCONT", Const, 0},
		{"SIGEMT", Const, 0},
		{"SIGFPE", Const, 0},
		{"SIGHUP", Const, 0},
		{"SIGILL", Const, 0},
		{"SIGINFO", Const, 0},
		{"SIGINT", Const, 0},
		{"SIGIO", Const, 0},
		{"SIGIOT", Const, 0},
		{"SIGKILL", Const, 0},
		{"SIGLIBRT", Const, 1},
		{"SIGLWP", Const, 0},
		{"SIGPIPE", Const, 0},
		{"SIGPOLL", Const, 0},
		{"SIGPROF", Const, 0},
		{"SIGPWR", Const, 0},
		{"SIGQUIT", Const, 0},
		{"SIGSEGV", Const, 0},
		{"SIGSTKFLT", Const, 0},
		{"SIGSTOP", Const, 0},
		{"SIGSYS", Const, 0},
		{"SIGTERM", Const, 0},
		{"SIGTHR", Const, 0},
		{"SIGTRAP", Const, 0},
		{"SIGTSTP", Const, 0},
		{"SIGTTIN", Const, 0},
		{"SIGTTOU", Const, 0},
		{"SIGUNUSED", Const, 0},
		{"SIGURG", Const, 0},
		{"SIGUSR1", Const, 0},
		{"SIGUSR2", Const, 0},
		{"SIGVTALRM", Const, 0},
		{"SIGWINCH", Const, 0},
		{"SIGXCPU", Const, 0},
		{"SIGXFSZ", Const, 0},
		{"SIOCADDDLCI", Const, 0},
		{"SIOCADDMULTI", Const, 0},
		{"SIOCADDRT", Const, 0},
		{"SIOCAIFADDR", Const, 0},
		{"SIOCAIFGROUP", Const, 0},
		{"SIOCALIFADDR", Const, 0},
		{"SIOCARPIPLL", Const, 0},
		{"SIOCATMARK", Const, 0},
		{"SIOCAUTOADDR", Const, 0},
		{"SIOCAUTONETMASK", Const, 0},
		{"SIOCBRDGADD", Const, 1},
		{"SIOCBRDGADDS", Const, 1},
		{"SIOCBRDGARL", Const, 1},
		{"SIOCBRDGDADDR", Const, 1},
		{"SIOCBRDGDEL", Const, 1},
		{"SIOCBRDGDELS", Const, 1},
		{"SIOCBRDGFLUSH", Const, 1},
		{"SIOCBRDGFRL", Const, 1},
		{"SIOCBRDGGCACHE", Const, 1},
		{"SIOCBRDGGFD", Const, 1},
		{"SIOCBRDGGHT", Const, 1},
		{"SIOCBRDGGIFFLGS", Const, 1},
		{"SIOCBRDGGMA", Const, 1},
		{"SIOCBRDGGPARAM", Const, 1},
		{"SIOCBRDGGPRI", Const, 1},
		{"SIOCBRDGGRL", Const, 1},
		{"SIOCBRDGGSIFS", Const, 1},
		{"SIOCBRDGGTO", Const, 1},
		{"SIOCBRDGIFS", Const, 1},
		{"SIOCBRDGRTS", Const, 1},
		{"SIOCBRDGSADDR", Const, 1},
		{"SIOCBRDGSCACHE", Const, 1},
		{"SIOCBRDGSFD", Const, 1},
		{"SIOCBRDGSHT", Const, 1},
		{"SIOCBRDGSIFCOST", Const, 1},
		{"SIOCBRDGSIFFLGS", Const, 1},
		{"SIOCBRDGSIFPRIO", Const, 1},
		{"SIOCBRDGSMA", Const, 1},
		{"SIOCBRDGSPRI", Const, 1},
		{"SIOCBRDGSPROTO", Const, 1},
		{"SIOCBRDGSTO", Const, 1},
		{"SIOCBRDGSTXHC", Const, 1},
		{"SIOCDARP", Const, 0},
		{"SIOCDELDLCI", Const, 0},
		{"SIOCDELMULTI", Const, 0},
		{"SIOCDELRT", Const, 0},
		{"SIOCDEVPRIVATE", Const, 0},
		{"SIOCDIFADDR", Const, 0},
		{"SIOCDIFGROUP", Const, 0},
		{"SIOCDIFPHYADDR", Const, 0},
		{"SIOCDLIFADDR", Const, 0},
		{"SIOCDRARP", Const, 0},
		{"SIOCGARP", Const, 0},
		{"SIOCGDRVSPEC", Const, 0},
		{"SIOCGETKALIVE", Const, 1},
		{"SIOCGETLABEL", Const, 1},
		{"SIOCGETPFLOW", Const, 1},
		{"SIOCGETPFSYNC", Const, 1},
		{"SIOCGETSGCNT", Const, 0},
		{"SIOCGETVIFCNT", Const, 0},
		{"SIOCGETVLAN", Const, 0},
		{"SIOCGHIWAT", Const, 0},
		{"SIOCGIFADDR", Const, 0},
		{"SIOCGIFADDRPREF", Const, 1},
		{"SIOCGIFALIAS", Const, 1},
		{"SIOCGIFALTMTU", Const, 0},
		{"SIOCGIFASYNCMAP", Const, 0},
		{"SIOCGIFBOND", Const, 0},
		{"SIOCGIFBR", Const, 0},
		{"SIOCGIFBRDADDR", Const, 0},
		{"SIOCGIFCAP", Const, 0},
		{"SIOCGIFCONF", Const, 0},
		{"SIOCGIFCOUNT", Const, 0},
		{"SIOCGIFDATA", Const, 1},
		{"SIOCGIFDESCR", Const, 0},
		{"SIOCGIFDEVMTU", Const, 0},
		{"SIOCGIFDLT", Const, 1},
		{"SIOCGIFDSTADDR", Const, 0},
		{"SIOCGIFENCAP", Const, 0},
		{"SIOCGIFFIB", Const, 1},
		{"SIOCGIFFLAGS", Const, 0},
		{"SIOCGIFGATTR", Const, 1},
		{"SIOCGIFGENERIC", Const, 0},
		{"SIOCGIFGMEMB", Const, 0},
		{"SIOCGIFGROUP", Const, 0},
		{"SIOCGIFHARDMTU", Const, 3},
		{"SIOCGIFHWADDR", Const, 0},
		{"SIOCGIFINDEX", Const, 0},
		{"SIOCGIFKPI", Const, 0},
		{"SIOCGIFMAC", Const, 0},
		{"SIOCGIFMAP", Const, 0},
		{"SIOCGIFMEDIA", Const, 0},
		{"SIOCGIFMEM", Const, 0},
		{"SIOCGIFMETRIC", Const, 0},
		{"SIOCGIFMTU", Const, 0},
		{"SIOCGIFNAME", Const, 0},
		{"SIOCGIFNETMASK", Const, 0},
		{"SIOCGIFPDSTADDR", Const, 0},
		{"SIOCGIFPFLAGS", Const, 0},
		{"SIOCGIFPHYS", Const, 0},
		{"SIOCGIFPRIORITY", Const, 1},
		{"SIOCGIFPSRCADDR", Const, 0},
		{"SIOCGIFRDOMAIN", Const, 1},
		{"SIOCGIFRTLABEL", Const, 1},
		{"SIOCGIFSLAVE", Const, 0},
		{"SIOCGIFSTATUS", Const, 0},
		{"SIOCGIFTIMESLOT", Const, 1},
		{"SIOCGIFTXQLEN", Const, 0},
		{"SIOCGIFVLAN", Const, 0},
		{"SIOCGIFWAKEFLAGS", Const, 0},
		{"SIOCGIFXFLAGS", Const, 1},
		{"SIOCGLIFADDR", Const, 0},
		{"SIOCGLIFPHYADDR", Const, 0},
		{"SIOCGLIFPHYRTABLE", Const, 1},
		{"SIOCGLIFPHYTTL", Const, 3},
		{"SIOCGLINKSTR", Const, 1},
		{"SIOCGLOWAT", Const, 0},
		{"SIOCGPGRP", Const, 0},
		{"SIOCGPRIVATE_0", Const, 0},
		{"SIOCGPRIVATE_1", Const, 0},
		{"SIOCGRARP", Const, 0},
		{"SIOCGSPPPPARAMS", Const, 3},
		{"SIOCGSTAMP", Const, 0},
		{"SIOCGSTAMPNS", Const, 0},
		{"SIOCGVH", Const, 1},
		{"SIOCGVNETID", Const, 3},
		{"SIOCIFCREATE", Const, 0},
		{"SIOCIFCREATE2", Const, 0},
		{"SIOCIFDESTROY", Const, 0},
		{"SIOCIFGCLONERS", Const, 0},
		{"SIOCINITIFADDR", Const, 1},
		{"SIOCPROTOPRIVATE", Const, 0},
		{"SIOCRSLVMULTI", Const, 0},
		{"SIOCRTMSG", Const, 0},
		{"SIOCSARP", Const, 0},
		{"SIOCSDRVSPEC", Const, 0},
		{"SIOCSETKALIVE", Const, 1},
		{"SIOCSETLABEL", Const, 1},
		{"SIOCSETPFLOW", Const, 1},
		{"SIOCSETPFSYNC", Const, 1},
		{"SIOCSETVLAN", Const, 0},
		{"SIOCSHIWAT", Const, 0},
		{"SIOCSIFADDR", Const, 0},
		{"SIOCSIFADDRPREF", Const, 1},
		{"SIOCSIFALTMTU", Const, 0},
		{"SIOCSIFASYNCMAP", Const, 0},
		{"SIOCSIFBOND", Const, 0},
		{"SIOCSIFBR", Const, 0},
		{"SIOCSIFBRDADDR", Const, 0},
		{"SIOCSIFCAP", Const, 0},
		{"SIOCSIFDESCR", Const, 0},
		{"SIOCSIFDSTADDR", Const, 0},
		{"SIOCSIFENCAP", Const, 0},
		{"SIOCSIFFIB", Const, 1},
		{"SIOCSIFFLAGS", Const, 0},
		{"SIOCSIFGATTR", Const, 1},
		{"SIOCSIFGENERIC", Const, 0},
		{"SIOCSIFHWADDR", Const, 0},
		{"SIOCSIFHWBROADCAST", Const, 0},
		{"SIOCSIFKPI", Const, 0},
		{"SIOCSIFLINK", Const, 0},
		{"SIOCSIFLLADDR", Const, 0},
		{"SIOCSIFMAC", Const, 0},
		{"SIOCSIFMAP", Const, 0},
		{"SIOCSIFMEDIA", Const, 0},
		{"SIOCSIFMEM", Const, 0},
		{"SIOCSIFMETRIC", Const, 0},
		{"SIOCSIFMTU", Const, 0},
		{"SIOCSIFNAME", Const, 0},
		{"SIOCSIFNETMASK", Const, 0},
		{"SIOCSIFPFLAGS", Const, 0},
		{"SIOCSIFPHYADDR", Const, 0},
		{"SIOCSIFPHYS", Const, 0},
		{"SIOCSIFPRIORITY", Const, 1},
		{"SIOCSIFRDOMAIN", Const, 1},
		{"SIOCSIFRTLABEL", Const, 1},
		{"SIOCSIFRVNET", Const, 0},
		{"SIOCSIFSLAVE", Const, 0},
		{"SIOCSIFTIMESLOT", Const, 1},
		{"SIOCSIFTXQLEN", Const, 0},
		{"SIOCSIFVLAN", Const, 0},
		{"SIOCSIFVNET", Const, 0},
		{"SIOCSIFXFLAGS", Const, 1},
		{"SIOCSLIFPHYADDR", Const, 0},
		{"SIOCSLIFPHYRTABLE", Const, 1},
		{"SIOCSLIFPHYTTL", Const, 3},
		{"SIOCSLINKSTR", Const, 1},
		{"SIOCSLOWAT", Const, 0},
		{"SIOCSPGRP", Const, 0},
		{"SIOCSRARP", Const, 0},
		{"SIOCSSPPPPARAMS", Const, 3},
		{"SIOCSVH", Const, 1},
		{"SIOCSVNETID", Const, 3},
		{"SIOCZIFDATA", Const, 1},
		{"SIO_GET_EXTENSION_FUNCTION_POINTER", Const, 1},
		{"SIO_GET_INTERFACE_LIST", Const, 0},
		{"SIO_KEEPALIVE_VALS", Const, 3},
		{"SIO_UDP_CONNRESET", Const, 4},
		{"SOCK_CLOEXEC", Const, 0},
		{"SOCK_DCCP", Const, 0},
		{"SOCK_DGRAM", Const, 0},
		{"SOCK_FLAGS_MASK", Const, 1},
		{"SOCK_MAXADDRLEN", Const, 0},
		{"SOCK_NONBLOCK", Const, 0},
		{"SOCK_NOSIGPIPE", Const, 1},
		{"SOCK_PACKET", Const, 0},
		{"SOCK_RAW", Const, 0},
		{"SOCK_RDM", Const, 0},
		{"SOCK_SEQPACKET", Const, 0},
		{"SOCK_STREAM", Const, 0},
		{"SOL_AAL", Const, 0},
		{"SOL_ATM", Const, 0},
		{"SOL_DECNET", Const, 0},
		{"SOL_ICMPV6", Const, 0},
		{"SOL_IP", Const, 0},
		{"SOL_IPV6", Const, 0},
		{"SOL_IRDA", Const, 0},
		{"SOL_PACKET", Const, 0},
		{"SOL_RAW", Const, 0},
		{"SOL_SOCKET", Const, 0},
		{"SOL_TCP", Const, 0},
		{"SOL_X25", Const, 0},
		{"SOMAXCONN", Const, 0},
		{"SO_ACCEPTCONN", Const, 0},
		{"SO_ACCEPTFILTER", Const, 0},
		{"SO_ATTACH_FILTER", Const, 0},
		{"SO_BINDANY", Const, 1},
		{"SO_BINDTODEVICE", Const, 0},
		{"SO_BINTIME", Const, 0},
		{"SO_BROADCAST", Const, 0},
		{"SO_BSDCOMPAT", Const, 0},
		{"SO_DEBUG", Const, 0},
		{"SO_DETACH_FILTER", Const, 0},
		{"SO_DOMAIN", Const, 0},
		{"SO_DONTROUTE", Const, 0},
		{"SO_DONTTRUNC", Const, 0},
		{"SO_ERROR", Const, 0},
		{"SO_KEEPALIVE", Const, 0},
		{"SO_LABEL", Const, 0},
		{"SO_LINGER", Const, 0},
		{"SO_LINGER_SEC", Const, 0},
		{"SO_LISTENINCQLEN", Const, 0},
		{"SO_LISTENQLEN", Const, 0},
		{"SO_LISTENQLIMIT", Const, 0},
		{"SO_MARK", Const, 0},
		{"SO_NETPROC", Const, 1},
		{"SO_NKE", Const, 0},
		{"SO_NOADDRERR", Const, 0},
		{"SO_NOHEADER", Const, 1},
		{"SO_NOSIGPIPE", Const, 0},
		{"SO_NOTIFYCONFLICT", Const, 0},
		{"SO_NO_CHECK", Const, 0},
		{"SO_NO_DDP", Const, 0},
		{"SO_NO_OFFLOAD", Const, 0},
		{"SO_NP_EXTENSIONS", Const, 0},
		{"SO_NREAD", Const, 0},
		{"SO_NUMRCVPKT", Const, 16},
		{"SO_NWRITE", Const, 0},
		{"SO_OOBINLINE", Const, 0},
		{"SO_OVERFLOWED", Const, 1},
		{"SO_PASSCRED", Const, 0},
		{"SO_PASSSEC", Const, 0},
		{"SO_PEERCRED", Const, 0},
		{"SO_PEERLABEL", Const, 0},
		{"SO_PEERNAME", Const, 0},
		{"SO_PEERSEC", Const, 0},
		{"SO_PRIORITY", Const, 0},
		{"SO_PROTOCOL", Const, 0},
		{"SO_PROTOTYPE", Const, 1},
		{"SO_RANDOMPORT", Const, 0},
		{"SO_RCVBUF", Const, 0},
		{"SO_RCVBUFFORCE", Const, 0},
		{"SO_RCVLOWAT", Const, 0},
		{"SO_RCVTIMEO", Const, 0},
		{"SO_RESTRICTIONS", Const, 0},
		{"SO_RESTRICT_DENYIN", Const, 0},
		{"SO_RESTRICT_DENYOUT", Const, 0},
		{"SO_RESTRICT_DENYSET", Const, 0},
		{"SO_REUSEADDR", Const, 0},
		{"SO_REUSEPORT", Const, 0},
		{"SO_REUSESHAREUID", Const, 0},
		{"SO_RTABLE", Const, 1},
		{"SO_RXQ_OVFL", Const, 0},
		{"SO_SECURITY_AUTHENTICATION", Const, 0},
		{"SO_SECURITY_ENCRYPTION_NETWORK", Const, 0},
		{"SO_SECURITY_ENCRYPTION_TRANSPORT", Const, 0},
		{"SO_SETFIB", Const, 0},
		{"SO_SNDBUF", Const, 0},
		{"SO_SNDBUFFORCE", Const, 0},
		{"SO_SNDLOWAT", Const, 0},
		{"SO_SNDTIMEO", Const, 0},
		{"SO_SPLICE", Const, 1},
		{"SO_TIMESTAMP", Const, 0},
		{"SO_TIMESTAMPING", Const, 0},
		{"SO_TIMESTAMPNS", Const, 0},
		{"SO_TIMESTAMP_MONOTONIC", Const, 0},
		{"SO_TYPE", Const, 0},
		{"SO_UPCALLCLOSEWAIT", Const, 0},
		{"SO_UPDATE_ACCEPT_CONTEXT", Const, 0},
		{"SO_UPDATE_CONNECT_CONTEXT", Const, 1},
		{"SO_USELOOPBACK", Const, 0},
		{"SO_USER_COOKIE", Const, 1},
		{"SO_VENDOR", Const, 3},
		{"SO_WANTMORE", Const, 0},
		{"SO_WANTOOBFLAG", Const, 0},
		{"SSLExtraCertChainPolicyPara", Type, 0},
		{"SSLExtraCertChainPolicyPara.AuthType", Field, 0},
		{"SSLExtraCertChainPolicyPara.Checks", Field, 0},
		{"SSLExtraCertChainPolicyPara.ServerName", Field, 0},
		{"SSLExtraCertChainPolicyPara.Size", Field, 0},
		{"STANDARD_RIGHTS_ALL", Const, 0},
		{"STANDARD_RIGHTS_EXECUTE", Const, 0},
		{"STANDARD_RIGHTS_READ", Const, 0},
		{"STANDARD_RIGHTS_REQUIRED", Const, 0},
		{"STANDARD_RIGHTS_WRITE", Const, 0},
		{"STARTF_USESHOWWINDOW", Const, 0},
		{"STARTF_USESTDHANDLES", Const, 0},
		{"STD_ERROR_HANDLE", Const, 0},
		{"STD_INPUT_HANDLE", Const, 0},
		{"STD_OUTPUT_HANDLE", Const, 0},
		{"SUBLANG_ENGLISH_US", Const, 0},
		{"SW_FORCEMINIMIZE", Const, 0},
		{"SW_HIDE", Const, 0},
		{"SW_MAXIMIZE", Const, 0},
		{"SW_MINIMIZE", Const, 0},
		{"SW_NORMAL", Const, 0},
		{"SW_RESTORE", Const, 0},
		{"SW_SHOW", Const, 0},
		{"SW_SHOWDEFAULT", Const, 0},
		{"SW_SHOWMAXIMIZED", Const, 0},
		{"SW_SHOWMINIMIZED", Const, 0},
		{"SW_SHOWMINNOACTIVE", Const, 0},
		{"SW_SHOWNA", Const, 0},
		{"SW_SHOWNOACTIVATE", Const, 0},
		{"SW_SHOWNORMAL", Const, 0},
		{"SYMBOLIC_LINK_FLAG_DIRECTORY", Const, 4},
		{"SYNCHRONIZE", Const, 0},
		{"SYSCTL_VERSION", Const, 1},
		{"SYSCTL_VERS_0", Const, 1},
		{"SYSCTL_VERS_1", Const, 1},
		{"SYSCTL_VERS_MASK", Const, 1},
		{"SYS_ABORT2", Const, 0},
		{"SYS_ACCEPT", Const, 0},
		{"SYS_ACCEPT4", Const, 0},
		{"SYS_ACCEPT_NOCANCEL", Const, 0},
		{"SYS_ACCESS", Const, 0},
		{"SYS_ACCESS_EXTENDED", Const, 0},
		{"SYS_ACCT", Const, 0},
		{"SYS_ADD_KEY", Const, 0},
		{"SYS_ADD_PROFIL", Const, 0},
		{"SYS_ADJFREQ", Const, 1},
		{"SYS_ADJTIME", Const, 0},
		{"SYS_ADJTIMEX", Const, 0},
		{"SYS_AFS_SYSCALL", Const, 0},
		{"SYS_AIO_CANCEL", Const, 0},
		{"SYS_AIO_ERROR", Const, 0},
		{"SYS_AIO_FSYNC", Const, 0},
		{"SYS_AIO_MLOCK", Const, 14},
		{"SYS_AIO_READ", Const, 0},
		{"SYS_AIO_RETURN", Const, 0},
		{"SYS_AIO_SUSPEND", Const, 0},
		{"SYS_AIO_SUSPEND_NOCANCEL", Const, 0},
		{"SYS_AIO_WAITCOMPLETE", Const, 14},
		{"SYS_AIO_WRITE", Const, 0},
		{"SYS_ALARM", Const, 0},
		{"SYS_ARCH_PRCTL", Const, 0},
		{"SYS_ARM_FADVISE64_64", Const, 0},
		{"SYS_ARM_SYNC_FILE_RANGE", Const, 0},
		{"SYS_ATGETMSG", Const, 0},
		{"SYS_ATPGETREQ", Const, 0},
		{"SYS_ATPGETRSP", Const, 0},
		{"SYS_ATPSNDREQ", Const, 0},
		{"SYS_ATPSNDRSP", Const, 0},
		{"SYS_ATPUTMSG", Const, 0},
		{"SYS_ATSOCKET", Const, 0},
		{"SYS_AUDIT", Const, 0},
		{"SYS_AUDITCTL", Const, 0},
		{"SYS_AUDITON", Const, 0},
		{"SYS_AUDIT_SESSION_JOIN", Const, 0},
		{"SYS_AUDIT_SESSION_PORT", Const, 0},
		{"SYS_AUDIT_SESSION_SELF", Const, 0},
		{"SYS_BDFLUSH", Const, 0},
		{"SYS_BIND", Const, 0},
		{"SYS_BINDAT", Const, 3},
		{"SYS_BREAK", Const, 0},
		{"SYS_BRK", Const, 0},
		{"SYS_BSDTHREAD_CREATE", Const, 0},
		{"SYS_BSDTHREAD_REGISTER", Const, 0},
		{"SYS_BSDTHREAD_TERMINATE", Const, 0},
		{"SYS_CAPGET", Const, 0},
		{"SYS_CAPSET", Const, 0},
		{"SYS_CAP_ENTER", Const, 0},
		{"SYS_CAP_FCNTLS_GET", Const, 1},
		{"SYS_CAP_FCNTLS_LIMIT", Const, 1},
		{"SYS_CAP_GETMODE", Const, 0},
		{"SYS_CAP_GETRIGHTS", Const, 0},
		{"SYS_CAP_IOCTLS_GET", Const, 1},
		{"SYS_CAP_IOCTLS_LIMIT", Const, 1},
		{"SYS_CAP_NEW", Const, 0},
		{"SYS_CAP_RIGHTS_GET", Const, 1},
		{"SYS_CAP_RIGHTS_LIMIT", Const, 1},
		{"SYS_CHDIR", Const, 0},
		{"SYS_CHFLAGS", Const, 0},
		{"SYS_CHFLAGSAT", Const, 3},
		{"SYS_CHMOD", Const, 0},
		{"SYS_CHMOD_EXTENDED", Const, 0},
		{"SYS_CHOWN", Const, 0},
		{"SYS_CHOWN32", Const, 0},
		{"SYS_CHROOT", Const, 0},
		{"SYS_CHUD", Const, 0},
		{"SYS_CLOCK_ADJTIME", Const, 0},
		{"SYS_CLOCK_GETCPUCLOCKID2", Const, 1},
		{"SYS_CLOCK_GETRES", Const, 0},
		{"SYS_CLOCK_GETTIME", Const, 0},
		{"SYS_CLOCK_NANOSLEEP", Const, 0},
		{"SYS_CLOCK_SETTIME", Const, 0},
		{"SYS_CLONE", Const, 0},
		{"SYS_CLOSE", Const, 0},
		{"SYS_CLOSEFROM", Const, 0},
		{"SYS_CLOSE_NOCANCEL", Const, 0},
		{"SYS_CONNECT", Const, 0},
		{"SYS_CONNECTAT", Const, 3},
		{"SYS_CONNECT_NOCANCEL", Const, 0},
		{"SYS_COPYFILE", Const, 0},
		{"SYS_CPUSET", Const, 0},
		{"SYS_CPUSET_GETAFFINITY", Const, 0},
		{"SYS_CPUSET_GETID", Const, 0},
		{"SYS_CPUSET_SETAFFINITY", Const, 0},
		{"SYS_CPUSET_SETID", Const, 0},
		{"SYS_CREAT", Const, 0},
		{"SYS_CREATE_MODULE", Const, 0},
		{"SYS_CSOPS", Const, 0},
		{"SYS_CSOPS_AUDITTOKEN", Const, 16},
		{"SYS_DELETE", Const, 0},
		{"SYS_DELETE_MODULE", Const, 0},
		{"SYS_DUP", Const, 0},
		{"SYS_DUP2", Const, 0},
		{"SYS_DUP3", Const, 0},
		{"SYS_EACCESS", Const, 0},
		{"SYS_EPOLL_CREATE", Const, 0},
		{"SYS_EPOLL_CREATE1", Const, 0},
		{"SYS_EPOLL_CTL", Const, 0},
		{"SYS_EPOLL_CTL_OLD", Const, 0},
		{"SYS_EPOLL_PWAIT", Const, 0},
		{"SYS_EPOLL_WAIT", Const, 0},
		{"SYS_EPOLL_WAIT_OLD", Const, 0},
		{"SYS_EVENTFD", Const, 0},
		{"SYS_EVENTFD2", Const, 0},
		{"SYS_EXCHANGEDATA", Const, 0},
		{"SYS_EXECVE", Const, 0},
		{"SYS_EXIT", Const, 0},
		{"SYS_EXIT_GROUP", Const, 0},
		{"SYS_EXTATTRCTL", Const, 0},
		{"SYS_EXTATTR_DELETE_FD", Const, 0},
		{"SYS_EXTATTR_DELETE_FILE", Const, 0},
		{"SYS_EXTATTR_DELETE_LINK", Const, 0},
		{"SYS_EXTATTR_GET_FD", Const, 0},
		{"SYS_EXTATTR_GET_FILE", Const, 0},
		{"SYS_EXTATTR_GET_LINK", Const, 0},
		{"SYS_EXTATTR_LIST_FD", Const, 0},
		{"SYS_EXTATTR_LIST_FILE", Const, 0},
		{"SYS_EXTATTR_LIST_LINK", Const, 0},
		{"SYS_EXTATTR_SET_FD", Const, 0},
		{"SYS_EXTATTR_SET_FILE", Const, 0},
		{"SYS_EXTATTR_SET_LINK", Const, 0},
		{"SYS_FACCESSAT", Const, 0},
		{"SYS_FADVISE64", Const, 0},
		{"SYS_FADVISE64_64", Const, 0},
		{"SYS_FALLOCATE", Const, 0},
		{"SYS_FANOTIFY_INIT", Const, 0},
		{"SYS_FANOTIFY_MARK", Const, 0},
		{"SYS_FCHDIR", Const, 0},
		{"SYS_FCHFLAGS", Const, 0},
		{"SYS_FCHMOD", Const, 0},
		{"SYS_FCHMODAT", Const, 0},
		{"SYS_FCHMOD_EXTENDED", Const, 0},
		{"SYS_FCHOWN", Const, 0},
		{"SYS_FCHOWN32", Const, 0},
		{"SYS_FCHOWNAT", Const, 0},
		{"SYS_FCHROOT", Const, 1},
		{"SYS_FCNTL", Const, 0},
		{"SYS_FCNTL64", Const, 0},
		{"SYS_FCNTL_NOCANCEL", Const, 0},
		{"SYS_FDATASYNC", Const, 0},
		{"SYS_FEXECVE", Const, 0},
		{"SYS_FFCLOCK_GETCOUNTER", Const, 0},
		{"SYS_FFCLOCK_GETESTIMATE", Const, 0},
		{"SYS_FFCLOCK_SETESTIMATE", Const, 0},
		{"SYS_FFSCTL", Const, 0},
		{"SYS_FGETATTRLIST", Const, 0},
		{"SYS_FGETXATTR", Const, 0},
		{"SYS_FHOPEN", Const, 0},
		{"SYS_FHSTAT", Const, 0},
		{"SYS_FHSTATFS", Const, 0},
		{"SYS_FILEPORT_MAKEFD", Const, 0},
		{"SYS_FILEPORT_MAKEPORT", Const, 0},
		{"SYS_FKTRACE", Const, 1},
		{"SYS_FLISTXATTR", Const, 0},
		{"SYS_FLOCK", Const, 0},
		{"SYS_FORK", Const, 0},
		{"SYS_FPATHCONF", Const, 0},
		{"SYS_FREEBSD6_FTRUNCATE", Const, 0},
		{"SYS_FREEBSD6_LSEEK", Const, 0},
		{"SYS_FREEBSD6_MMAP", Const, 0},
		{"SYS_FREEBSD6_PREAD", Const, 0},
		{"SYS_FREEBSD6_PWRITE", Const, 0},
		{"SYS_FREEBSD6_TRUNCATE", Const, 0},
		{"SYS_FREMOVEXATTR", Const, 0},
		{"SYS_FSCTL", Const, 0},
		{"SYS_FSETATTRLIST", Const, 0},
		{"SYS_FSETXATTR", Const, 0},
		{"SYS_FSGETPATH", Const, 0},
		{"SYS_FSTAT", Const, 0},
		{"SYS_FSTAT64", Const, 0},
		{"SYS_FSTAT64_EXTENDED", Const, 0},
		{"SYS_FSTATAT", Const, 0},
		{"SYS_FSTATAT64", Const, 0},
		{"SYS_FSTATFS", Const, 0},
		{"SYS_FSTATFS64", Const, 0},
		{"SYS_FSTATV", Const, 0},
		{"SYS_FSTATVFS1", Const, 1},
		{"SYS_FSTAT_EXTENDED", Const, 0},
		{"SYS_FSYNC", Const, 0},
		{"SYS_FSYNC_NOCANCEL", Const, 0},
		{"SYS_FSYNC_RANGE", Const, 1},
		{"SYS_FTIME", Const, 0},
		{"SYS_FTRUNCATE", Const, 0},
		{"SYS_FTRUNCATE64", Const, 0},
		{"SYS_FUTEX", Const, 0},
		{"SYS_FUTIMENS", Const, 1},
		{"SYS_FUTIMES", Const, 0},
		{"SYS_FUTIMESAT", Const, 0},
		{"SYS_GETATTRLIST", Const, 0},
		{"SYS_GETAUDIT", Const, 0},
		{"SYS_GETAUDIT_ADDR", Const, 0},
		{"SYS_GETAUID", Const, 0},
		{"SYS_GETCONTEXT", Const, 0},
		{"SYS_GETCPU", Const, 0},
		{"SYS_GETCWD", Const, 0},
		{"SYS_GETDENTS", Const, 0},
		{"SYS_GETDENTS64", Const, 0},
		{"SYS_GETDIRENTRIES", Const, 0},
		{"SYS_GETDIRENTRIES64", Const, 0},
		{"SYS_GETDIRENTRIESATTR", Const, 0},
		{"SYS_GETDTABLECOUNT", Const, 1},
		{"SYS_GETDTABLESIZE", Const, 0},
		{"SYS_GETEGID", Const, 0},
		{"SYS_GETEGID32", Const, 0},
		{"SYS_GETEUID", Const, 0},
		{"SYS_GETEUID32", Const, 0},
		{"SYS_GETFH", Const, 0},
		{"SYS_GETFSSTAT", Const, 0},
		{"SYS_GETFSSTAT64", Const, 0},
		{"SYS_GETGID", Const, 0},
		{"SYS_GETGID32", Const, 0},
		{"SYS_GETGROUPS", Const, 0},
		{"SYS_GETGROUPS32", Const, 0},
		{"SYS_GETHOSTUUID", Const, 0},
		{"SYS_GETITIMER", Const, 0},
		{"SYS_GETLCID", Const, 0},
		{"SYS_GETLOGIN", Const, 0},
		{"SYS_GETLOGINCLASS", Const, 0},
		{"SYS_GETPEERNAME", Const, 0},
		{"SYS_GETPGID", Const, 0},
		{"SYS_GETPGRP", Const, 0},
		{"SYS_GETPID", Const, 0},
		{"SYS_GETPMSG", Const, 0},
		{"SYS_GETPPID", Const, 0},
		{"SYS_GETPRIORITY", Const, 0},
		{"SYS_GETRESGID", Const, 0},
		{"SYS_GETRESGID32", Const, 0},
		{"SYS_GETRESUID", Const, 0},
		{"SYS_GETRESUID32", Const, 0},
		{"SYS_GETRLIMIT", Const, 0},
		{"SYS_GETRTABLE", Const, 1},
		{"SYS_GETRUSAGE", Const, 0},
		{"SYS_GETSGROUPS", Const, 0},
		{"SYS_GETSID", Const, 0},
		{"SYS_GETSOCKNAME", Const, 0},
		{"SYS_GETSOCKOPT", Const, 0},
		{"SYS_GETTHRID", Const, 1},
		{"SYS_GETTID", Const, 0},
		{"SYS_GETTIMEOFDAY", Const, 0},
		{"SYS_GETUID", Const, 0},
		{"SYS_GETUID32", Const, 0},
		{"SYS_GETVFSSTAT", Const, 1},
		{"SYS_GETWGROUPS", Const, 0},
		{"SYS_GETXATTR", Const, 0},
		{"SYS_GET_KERNEL_SYMS", Const, 0},
		{"SYS_GET_MEMPOLICY", Const, 0},
		{"SYS_GET_ROBUST_LIST", Const, 0},
		{"SYS_GET_THREAD_AREA", Const, 0},
		{"SYS_GSSD_SYSCALL", Const, 14},
		{"SYS_GTTY", Const, 0},
		{"SYS_IDENTITYSVC", Const, 0},
		{"SYS_IDLE", Const, 0},
		{"SYS_INITGROUPS", Const, 0},
		{"SYS_INIT_MODULE", Const, 0},
		{"SYS_INOTIFY_ADD_WATCH", Const, 0},
		{"SYS_INOTIFY_INIT", Const, 0},
		{"SYS_INOTIFY_INIT1", Const, 0},
		{"SYS_INOTIFY_RM_WATCH", Const, 0},
		{"SYS_IOCTL", Const, 0},
		{"SYS_IOPERM", Const, 0},
		{"SYS_IOPL", Const, 0},
		{"SYS_IOPOLICYSYS", Const, 0},
		{"SYS_IOPRIO_GET", Const, 0},
		{"SYS_IOPRIO_SET", Const, 0},
		{"SYS_IO_CANCEL", Const, 0},
		{"SYS_IO_DESTROY", Const, 0},
		{"SYS_IO_GETEVENTS", Const, 0},
		{"SYS_IO_SETUP", Const, 0},
		{"SYS_IO_SUBMIT", Const, 0},
		{"SYS_IPC", Const, 0},
		{"SYS_ISSETUGID", Const, 0},
		{"SYS_JAIL", Const, 0},
		{"SYS_JAIL_ATTACH", Const, 0},
		{"SYS_JAIL_GET", Const, 0},
		{"SYS_JAIL_REMOVE", Const, 0},
		{"SYS_JAIL_SET", Const, 0},
		{"SYS_KAS_INFO", Const, 16},
		{"SYS_KDEBUG_TRACE", Const, 0},
		{"SYS_KENV", Const, 0},
		{"SYS_KEVENT", Const, 0},
		{"SYS_KEVENT64", Const, 0},
		{"SYS_KEXEC_LOAD", Const, 0},
		{"SYS_KEYCTL", Const, 0},
		{"SYS_KILL", Const, 0},
		{"SYS_KLDFIND", Const, 0},
		{"SYS_KLDFIRSTMOD", Const, 0},
		{"SYS_KLDLOAD", Const, 0},
		{"SYS_KLDNEXT", Const, 0},
		{"SYS_KLDSTAT", Const, 0},
		{"SYS_KLDSYM", Const, 0},
		{"SYS_KLDUNLOAD", Const, 0},
		{"SYS_KLDUNLOADF", Const, 0},
		{"SYS_KMQ_NOTIFY", Const, 14},
		{"SYS_KMQ_OPEN", Const, 14},
		{"SYS_KMQ_SETATTR", Const, 14},
		{"SYS_KMQ_TIMEDRECEIVE", Const, 14},
		{"SYS_KMQ_TIMEDSEND", Const, 14},
		{"SYS_KMQ_UNLINK", Const, 14},
		{"SYS_KQUEUE", Const, 0},
		{"SYS_KQUEUE1", Const, 1},
		{"SYS_KSEM_CLOSE", Const, 14},
		{"SYS_KSEM_DESTROY", Const, 14},
		{"SYS_KSEM_GETVALUE", Const, 14},
		{"SYS_KSEM_INIT", Const, 14},
		{"SYS_KSEM_OPEN", Const, 14},
		{"SYS_KSEM_POST", Const, 14},
		{"SYS_KSEM_TIMEDWAIT", Const, 14},
		{"SYS_KSEM_TRYWAIT", Const, 14},
		{"SYS_KSEM_UNLINK", Const, 14},
		{"SYS_KSEM_WAIT", Const, 14},
		{"SYS_KTIMER_CREATE", Const, 0},
		{"SYS_KTIMER_DELETE", Const, 0},
		{"SYS_KTIMER_GETOVERRUN", Const, 0},
		{"SYS_KTIMER_GETTIME", Const, 0},
		{"SYS_KTIMER_SETTIME", Const, 0},
		{"SYS_KTRACE", Const, 0},
		{"SYS_LCHFLAGS", Const, 0},
		{"SYS_LCHMOD", Const, 0},
		{"SYS_LCHOWN", Const, 0},
		{"SYS_LCHOWN32", Const, 0},
		{"SYS_LEDGER", Const, 16},
		{"SYS_LGETFH", Const, 0},
		{"SYS_LGETXATTR", Const, 0},
		{"SYS_LINK", Const, 0},
		{"SYS_LINKAT", Const, 0},
		{"SYS_LIO_LISTIO", Const, 0},
		{"SYS_LISTEN", Const, 0},
		{"SYS_LISTXATTR", Const, 0},
		{"SYS_LLISTXATTR", Const, 0},
		{"SYS_LOCK", Const, 0},
		{"SYS_LOOKUP_DCOOKIE", Const, 0},
		{"SYS_LPATHCONF", Const, 0},
		{"SYS_LREMOVEXATTR", Const, 0},
		{"SYS_LSEEK", Const, 0},
		{"SYS_LSETXATTR", Const, 0},
		{"SYS_LSTAT", Const, 0},
		{"SYS_LSTAT64", Const, 0},
		{"SYS_LSTAT64_EXTENDED", Const, 0},
		{"SYS_LSTATV", Const, 0},
		{"SYS_LSTAT_EXTENDED", Const, 0},
		{"SYS_LUTIMES", Const, 0},
		{"SYS_MAC_SYSCALL", Const, 0},
		{"SYS_MADVISE", Const, 0},
		{"SYS_MADVISE1", Const, 0},
		{"SYS_MAXSYSCALL", Const, 0},
		{"SYS_MBIND", Const, 0},
		{"SYS_MIGRATE_PAGES", Const, 0},
		{"SYS_MINCORE", Const, 0},
		{"SYS_MINHERIT", Const, 0},
		{"SYS_MKCOMPLEX", Const, 0},
		{"SYS_MKDIR", Const, 0},
		{"SYS_MKDIRAT", Const, 0},
		{"SYS_MKDIR_EXTENDED", Const, 0},
		{"SYS_MKFIFO", Const, 0},
		{"SYS_MKFIFOAT", Const, 0},
		{"SYS_MKFIFO_EXTENDED", Const, 0},
		{"SYS_MKNOD", Const, 0},
		{"SYS_MKNODAT", Const, 0},
		{"SYS_MLOCK", Const, 0},
		{"SYS_MLOCKALL", Const, 0},
		{"SYS_MMAP", Const, 0},
		{"SYS_MMAP2", Const, 0},
		{"SYS_MODCTL", Const, 1},
		{"SYS_MODFIND", Const, 0},
		{"SYS_MODFNEXT", Const, 0},
		{"SYS_MODIFY_LDT", Const, 0},
		{"SYS_MODNEXT", Const, 0},
		{"SYS_MODSTAT", Const, 0},
		{"SYS_MODWATCH", Const, 0},
		{"SYS_MOUNT", Const, 0},
		{"SYS_MOVE_PAGES", Const, 0},
		{"SYS_MPROTECT", Const, 0},
		{"SYS_MPX", Const, 0},
		{"SYS_MQUERY", Const, 1},
		{"SYS_MQ_GETSETATTR", Const, 0},
		{"SYS_MQ_NOTIFY", Const, 0},
		{"SYS_MQ_OPEN", Const, 0},
		{"SYS_MQ_TIMEDRECEIVE", Const, 0},
		{"SYS_MQ_TIMEDSEND", Const, 0},
		{"SYS_MQ_UNLINK", Const, 0},
		{"SYS_MREMAP", Const, 0},
		{"SYS_MSGCTL", Const, 0},
		{"SYS_MSGGET", Const, 0},
		{"SYS_MSGRCV", Const, 0},
		{"SYS_MSGRCV_NOCANCEL", Const, 0},
		{"SYS_MSGSND", Const, 0},
		{"SYS_MSGSND_NOCANCEL", Const, 0},
		{"SYS_MSGSYS", Const, 0},
		{"SYS_MSYNC", Const, 0},
		{"SYS_MSYNC_NOCANCEL", Const, 0},
		{"SYS_MUNLOCK", Const, 0},
		{"SYS_MUNLOCKALL", Const, 0},
		{"SYS_MUNMAP", Const, 0},
		{"SYS_NAME_TO_HANDLE_AT", Const, 0},
		{"SYS_NANOSLEEP", Const, 0},
		{"SYS_NEWFSTATAT", Const, 0},
		{"SYS_NFSCLNT", Const, 0},
		{"SYS_NFSSERVCTL", Const, 0},
		{"SYS_NFSSVC", Const, 0},
		{"SYS_NFSTAT", Const, 0},
		{"SYS_NICE", Const, 0},
		{"SYS_NLM_SYSCALL", Const, 14},
		{"SYS_NLSTAT", Const, 0},
		{"SYS_NMOUNT", Const, 0},
		{"SYS_NSTAT", Const, 0},
		{"SYS_NTP_ADJTIME", Const, 0},
		{"SYS_NTP_GETTIME", Const, 0},
		{"SYS_NUMA_GETAFFINITY", Const, 14},
		{"SYS_NUMA_SETAFFINITY", Const, 14},
		{"SYS_OABI_SYSCALL_BASE", Const, 0},
		{"SYS_OBREAK", Const, 0},
		{"SYS_OLDFSTAT", Const, 0},
		{"SYS_OLDLSTAT", Const, 0},
		{"SYS_OLDOLDUNAME", Const, 0},
		{"SYS_OLDSTAT", Const, 0},
		{"SYS_OLDUNAME", Const, 0},
		{"SYS_OPEN", Const, 0},
		{"SYS_OPENAT", Const, 0},
		{"SYS_OPENBSD_POLL", Const, 0},
		{"SYS_OPEN_BY_HANDLE_AT", Const, 0},
		{"SYS_OPEN_DPROTECTED_NP", Const, 16},
		{"SYS_OPEN_EXTENDED", Const, 0},
		{"SYS_OPEN_NOCANCEL", Const, 0},
		{"SYS_OVADVISE", Const, 0},
		{"SYS_PACCEPT", Const, 1},
		{"SYS_PATHCONF", Const, 0},
		{"SYS_PAUSE", Const, 0},
		{"SYS_PCICONFIG_IOBASE", Const, 0},
		{"SYS_PCICONFIG_READ", Const, 0},
		{"SYS_PCICONFIG_WRITE", Const, 0},
		{"SYS_PDFORK", Const, 0},
		{"SYS_PDGETPID", Const, 0},
		{"SYS_PDKILL", Const, 0},
		{"SYS_PERF_EVENT_OPEN", Const, 0},
		{"SYS_PERSONALITY", Const, 0},
		{"SYS_PID_HIBERNATE", Const, 0},
		{"SYS_PID_RESUME", Const, 0},
		{"SYS_PID_SHUTDOWN_SOCKETS", Const, 0},
		{"SYS_PID_SUSPEND", Const, 0},
		{"SYS_PIPE", Const, 0},
		{"SYS_PIPE2", Const, 0},
		{"SYS_PIVOT_ROOT", Const, 0},
		{"SYS_PMC_CONTROL", Const, 1},
		{"SYS_PMC_GET_INFO", Const, 1},
		{"SYS_POLL", Const, 0},
		{"SYS_POLLTS", Const, 1},
		{"SYS_POLL_NOCANCEL", Const, 0},
		{"SYS_POSIX_FADVISE", Const, 0},
		{"SYS_POSIX_FALLOCATE", Const, 0},
		{"SYS_POSIX_OPENPT", Const, 0},
		{"SYS_POSIX_SPAWN", Const, 0},
		{"SYS_PPOLL", Const, 0},
		{"SYS_PRCTL", Const, 0},
		{"SYS_PREAD", Const, 0},
		{"SYS_PREAD64", Const, 0},
		{"SYS_PREADV", Const, 0},
		{"SYS_PREAD_NOCANCEL", Const, 0},
		{"SYS_PRLIMIT64", Const, 0},
		{"SYS_PROCCTL", Const, 3},
		{"SYS_PROCESS_POLICY", Const, 0},
		{"SYS_PROCESS_VM_READV", Const, 0},
		{"SYS_PROCESS_VM_WRITEV", Const, 0},
		{"SYS_PROC_INFO", Const, 0},
		{"SYS_PROF", Const, 0},
		{"SYS_PROFIL", Const, 0},
		{"SYS_PSELECT", Const, 0},
		{"SYS_PSELECT6", Const, 0},
		{"SYS_PSET_ASSIGN", Const, 1},
		{"SYS_PSET_CREATE", Const, 1},
		{"SYS_PSET_DESTROY", Const, 1},
		{"SYS_PSYNCH_CVBROAD", Const, 0},
		{"SYS_PSYNCH_CVCLRPREPOST", Const, 0},
		{"SYS_PSYNCH_CVSIGNAL", Const, 0},
		{"SYS_PSYNCH_CVWAIT", Const, 0},
		{"SYS_PSYNCH_MUTEXDROP", Const, 0},
		{"SYS_PSYNCH_MUTEXWAIT", Const, 0},
		{"SYS_PSYNCH_RW_DOWNGRADE", Const, 0},
		{"SYS_PSYNCH_RW_LONGRDLOCK", Const, 0},
		{"SYS_PSYNCH_RW_RDLOCK", Const, 0},
		{"SYS_PSYNCH_RW_UNLOCK", Const, 0},
		{"SYS_PSYNCH_RW_UNLOCK2", Const, 0},
		{"SYS_PSYNCH_RW_UPGRADE", Const, 0},
		{"SYS_PSYNCH_RW_WRLOCK", Const, 0},
		{"SYS_PSYNCH_RW_YIELDWRLOCK", Const, 0},
		{"SYS_PTRACE", Const, 0},
		{"SYS_PUTPMSG", Const, 0},
		{"SYS_PWRITE", Const, 0},
		{"SYS_PWRITE64", Const, 0},
		{"SYS_PWRITEV", Const, 0},
		{"SYS_PWRITE_NOCANCEL", Const, 0},
		{"SYS_QUERY_MODULE", Const, 0},
		{"SYS_QUOTACTL", Const, 0},
		{"SYS_RASCTL", Const, 1},
		{"SYS_RCTL_ADD_RULE", Const, 0},
		{"SYS_RCTL_GET_LIMITS", Const, 0},
		{"SYS_RCTL_GET_RACCT", Const, 0},
		{"SYS_RCTL_GET_RULES", Const, 0},
		{"SYS_RCTL_REMOVE_RULE", Const, 0},
		{"SYS_READ", Const, 0},
		{"SYS_READAHEAD", Const, 0},
		{"SYS_READDIR", Const, 0},
		{"SYS_READLINK", Const, 0},
		{"SYS_READLINKAT", Const, 0},
		{"SYS_READV", Const, 0},
		{"SYS_READV_NOCANCEL", Const, 0},
		{"SYS_READ_NOCANCEL", Const, 0},
		{"SYS_REBOOT", Const, 0},
		{"SYS_RECV", Const, 0},
		{"SYS_RECVFROM", Const, 0},
		{"SYS_RECVFROM_NOCANCEL", Const, 0},
		{"SYS_RECVMMSG", Const, 0},
		{"SYS_RECVMSG", Const, 0},
		{"SYS_RECVMSG_NOCANCEL", Const, 0},
		{"SYS_REMAP_FILE_PAGES", Const, 0},
		{"SYS_REMOVEXATTR", Const, 0},
		{"SYS_RENAME", Const, 0},
		{"SYS_RENAMEAT", Const, 0},
		{"SYS_REQUEST_KEY", Const, 0},
		{"SYS_RESTART_SYSCALL", Const, 0},
		{"SYS_REVOKE", Const, 0},
		{"SYS_RFORK", Const, 0},
		{"SYS_RMDIR", Const, 0},
		{"SYS_RTPRIO", Const, 0},
		{"SYS_RTPRIO_THREAD", Const, 0},
		{"SYS_RT_SIGACTION", Const, 0},
		{"SYS_RT_SIGPENDING", Const, 0},
		{"SYS_RT_SIGPROCMASK", Const, 0},
		{"SYS_RT_SIGQUEUEINFO", Const, 0},
		{"SYS_RT_SIGRETURN", Const, 0},
		{"SYS_RT_SIGSUSPEND", Const, 0},
		{"SYS_RT_SIGTIMEDWAIT", Const, 0},
		{"SYS_RT_TGSIGQUEUEINFO", Const, 0},
		{"SYS_SBRK", Const, 0},
		{"SYS_SCHED_GETAFFINITY", Const, 0},
		{"SYS_SCHED_GETPARAM", Const, 0},
		{"SYS_SCHED_GETSCHEDULER", Const, 0},
		{"SYS_SCHED_GET_PRIORITY_MAX", Const, 0},
		{"SYS_SCHED_GET_PRIORITY_MIN", Const, 0},
		{"SYS_SCHED_RR_GET_INTERVAL", Const, 0},
		{"SYS_SCHED_SETAFFINITY", Const, 0},
		{"SYS_SCHED_SETPARAM", Const, 0},
		{"SYS_SCHED_SETSCHEDULER", Const, 0},
		{"SYS_SCHED_YIELD", Const, 0},
		{"SYS_SCTP_GENERIC_RECVMSG", Const, 0},
		{"SYS_SCTP_GENERIC_SENDMSG", Const, 0},
		{"SYS_SCTP_GENERIC_SENDMSG_IOV", Const, 0},
		{"SYS_SCTP_PEELOFF", Const, 0},
		{"SYS_SEARCHFS", Const, 0},
		{"SYS_SECURITY", Const, 0},
		{"SYS_SELECT", Const, 0},
		{"SYS_SELECT_NOCANCEL", Const, 0},
		{"SYS_SEMCONFIG", Const, 1},
		{"SYS_SEMCTL", Const, 0},
		{"SYS_SEMGET", Const, 0},
		{"SYS_SEMOP", Const, 0},
		{"SYS_SEMSYS", Const, 0},
		{"SYS_SEMTIMEDOP", Const, 0},
		{"SYS_SEM_CLOSE", Const, 0},
		{"SYS_SEM_DESTROY", Const, 0},
		{"SYS_SEM_GETVALUE", Const, 0},
		{"SYS_SEM_INIT", Const, 0},
		{"SYS_SEM_OPEN", Const, 0},
		{"SYS_SEM_POST", Const, 0},
		{"SYS_SEM_TRYWAIT", Const, 0},
		{"SYS_SEM_UNLINK", Const, 0},
		{"SYS_SEM_WAIT", Const, 0},
		{"SYS_SEM_WAIT_NOCANCEL", Const, 0},
		{"SYS_SEND", Const, 0},
		{"SYS_SENDFILE", Const, 0},
		{"SYS_SENDFILE64", Const, 0},
		{"SYS_SENDMMSG", Const, 0},
		{"SYS_SENDMSG", Const, 0},
		{"SYS_SENDMSG_NOCANCEL", Const, 0},
		{"SYS_SENDTO", Const, 0},
		{"SYS_SENDTO_NOCANCEL", Const, 0},
		{"SYS_SETATTRLIST", Const, 0},
		{"SYS_SETAUDIT", Const, 0},
		{"SYS_SETAUDIT_ADDR", Const, 0},
		{"SYS_SETAUID", Const, 0},
		{"SYS_SETCONTEXT", Const, 0},
		{"SYS_SETDOMAINNAME", Const, 0},
		{"SYS_SETEGID", Const, 0},
		{"SYS_SETEUID", Const, 0},
		{"SYS_SETFIB", Const, 0},
		{"SYS_SETFSGID", Const, 0},
		{"SYS_SETFSGID32", Const, 0},
		{"SYS_SETFSUID", Const, 0},
		{"SYS_SETFSUID32", Const, 0},
		{"SYS_SETGID", Const, 0},
		{"SYS_SETGID32", Const, 0},
		{"SYS_SETGROUPS", Const, 0},
		{"SYS_SETGROUPS32", Const, 0},
		{"SYS_SETHOSTNAME", Const, 0},
		{"SYS_SETITIMER", Const, 0},
		{"SYS_SETLCID", Const, 0},
		{"SYS_SETLOGIN", Const, 0},
		{"SYS_SETLOGINCLASS", Const, 0},
		{"SYS_SETNS", Const, 0},
		{"SYS_SETPGID", Const, 0},
		{"SYS_SETPRIORITY", Const, 0},
		{"SYS_SETPRIVEXEC", Const, 0},
		{"SYS_SETREGID", Const, 0},
		{"SYS_SETREGID32", Const, 0},
		{"SYS_SETRESGID", Const, 0},
		{"SYS_SETRESGID32", Const, 0},
		{"SYS_SETRESUID", Const, 0},
		{"SYS_SETRESUID32", Const, 0},
		{"SYS_SETREUID", Const, 0},
		{"SYS_SETREUID32", Const, 0},
		{"SYS_SETRLIMIT", Const, 0},
		{"SYS_SETRTABLE", Const, 1},
		{"SYS_SETSGROUPS", Const, 0},
		{"SYS_SETSID", Const, 0},
		{"SYS_SETSOCKOPT", Const, 0},
		{"SYS_SETTID", Const, 0},
		{"SYS_SETTID_WITH_PID", Const, 0},
		{"SYS_SETTIMEOFDAY", Const, 0},
		{"SYS_SETUID", Const, 0},
		{"SYS_SETUID32", Const, 0},
		{"SYS_SETWGROUPS", Const, 0},
		{"SYS_SETXATTR", Const, 0},
		{"SYS_SET_MEMPOLICY", Const, 0},
		{"SYS_SET_ROBUST_LIST", Const, 0},
		{"SYS_SET_THREAD_AREA", Const, 0},
		{"SYS_SET_TID_ADDRESS", Const, 0},
		{"SYS_SGETMASK", Const, 0},
		{"SYS_SHARED_REGION_CHECK_NP", Const, 0},
		{"SYS_SHARED_REGION_MAP_AND_SLIDE_NP", Const, 0},
		{"SYS_SHMAT", Const, 0},
		{"SYS_SHMCTL", Const, 0},
		{"SYS_SHMDT", Const, 0},
		{"SYS_SHMGET", Const, 0},
		{"SYS_SHMSYS", Const, 0},
		{"SYS_SHM_OPEN", Const, 0},
		{"SYS_SHM_UNLINK", Const, 0},
		{"SYS_SHUTDOWN", Const, 0},
		{"SYS_SIGACTION", Const, 0},
		{"SYS_SIGALTSTACK", Const, 0},
		{"SYS_SIGNAL", Const, 0},
		{"SYS_SIGNALFD", Const, 0},
		{"SYS_SIGNALFD4", Const, 0},
		{"SYS_SIGPENDING", Const, 0},
		{"SYS_SIGPROCMASK", Const, 0},
		{"SYS_SIGQUEUE", Const, 0},
		{"SYS_SIGQUEUEINFO", Const, 1},
		{"SYS_SIGRETURN", Const, 0},
		{"SYS_SIGSUSPEND", Const, 0},
		{"SYS_SIGSUSPEND_NOCANCEL", Const, 0},
		{"SYS_SIGTIMEDWAIT", Const, 0},
		{"SYS_SIGWAIT", Const, 0},
		{"SYS_SIGWAITINFO", Const, 0},
		{"SYS_SOCKET", Const, 0},
		{"SYS_SOCKETCALL", Const, 0},
		{"SYS_SOCKETPAIR", Const, 0},
		{"SYS_SPLICE", Const, 0},
		{"SYS_SSETMASK", Const, 0},
		{"SYS_SSTK", Const, 0},
		{"SYS_STACK_SNAPSHOT", Const, 0},
		{"SYS_STAT", Const, 0},
		{"SYS_STAT64", Const, 0},
		{"SYS_STAT64_EXTENDED", Const, 0},
		{"SYS_STATFS", Const, 0},
		{"SYS_STATFS64", Const, 0},
		{"SYS_STATV", Const, 0},
		{"SYS_STATVFS1", Const, 1},
		{"SYS_STAT_EXTENDED", Const, 0},
		{"SYS_STIME", Const, 0},
		{"SYS_STTY", Const, 0},
		{"SYS_SWAPCONTEXT", Const, 0},
		{"SYS_SWAPCTL", Const, 1},
		{"SYS_SWAPOFF", Const, 0},
		{"SYS_SWAPON", Const, 0},
		{"SYS_SYMLINK", Const, 0},
		{"SYS_SYMLINKAT", Const, 0},
		{"SYS_SYNC", Const, 0},
		{"SYS_SYNCFS", Const, 0},
		{"SYS_SYNC_FILE_RANGE", Const, 0},
		{"SYS_SYSARCH", Const, 0},
		{"SYS_SYSCALL", Const, 0},
		{"SYS_SYSCALL_BASE", Const, 0},
		{"SYS_SYSFS", Const, 0},
		{"SYS_SYSINFO", Const, 0},
		{"SYS_SYSLOG", Const, 0},
		{"SYS_TEE", Const, 0},
		{"SYS_TGKILL", Const, 0},
		{"SYS_THREAD_SELFID", Const, 0},
		{"SYS_THR_CREATE", Const, 0},
		{"SYS_THR_EXIT", Const, 0},
		{"SYS_THR_KILL", Const, 0},
		{"SYS_THR_KILL2", Const, 0},
		{"SYS_THR_NEW", Const, 0},
		{"SYS_THR_SELF", Const, 0},
		{"SYS_THR_SET_NAME", Const, 0},
		{"SYS_THR_SUSPEND", Const, 0},
		{"SYS_THR_WAKE", Const, 0},
		{"SYS_TIME", Const, 0},
		{"SYS_TIMERFD_CREATE", Const, 0},
		{"SYS_TIMERFD_GETTIME", Const, 0},
		{"SYS_TIMERFD_SETTIME", Const, 0},
		{"SYS_TIMER_CREATE", Const, 0},
		{"SYS_TIMER_DELETE", Const, 0},
		{"SYS_TIMER_GETOVERRUN", Const, 0},
		{"SYS_TIMER_GETTIME", Const, 0},
		{"SYS_TIMER_SETTIME", Const, 0},
		{"SYS_TIMES", Const, 0},
		{"SYS_TKILL", Const, 0},
		{"SYS_TRUNCATE", Const, 0},
		{"SYS_TRUNCATE64", Const, 0},
		{"SYS_TUXCALL", Const, 0},
		{"SYS_UGETRLIMIT", Const, 0},
		{"SYS_ULIMIT", Const, 0},
		{"SYS_UMASK", Const, 0},
		{"SYS_UMASK_EXTENDED", Const, 0},
		{"SYS_UMOUNT", Const, 0},
		{"SYS_UMOUNT2", Const, 0},
		{"SYS_UNAME", Const, 0},
		{"SYS_UNDELETE", Const, 0},
		{"SYS_UNLINK", Const, 0},
		{"SYS_UNLINKAT", Const, 0},
		{"SYS_UNMOUNT", Const, 0},
		{"SYS_UNSHARE", Const, 0},
		{"SYS_USELIB", Const, 0},
		{"SYS_USTAT", Const, 0},
		{"SYS_UTIME", Const, 0},
		{"SYS_UTIMENSAT", Const, 0},
		{"SYS_UTIMES", Const, 0},
		{"SYS_UTRACE", Const, 0},
		{"SYS_UUIDGEN", Const, 0},
		{"SYS_VADVISE", Const, 1},
		{"SYS_VFORK", Const, 0},
		{"SYS_VHANGUP", Const, 0},
		{"SYS_VM86", Const, 0},
		{"SYS_VM86OLD", Const, 0},
		{"SYS_VMSPLICE", Const, 0},
		{"SYS_VM_PRESSURE_MONITOR", Const, 0},
		{"SYS_VSERVER", Const, 0},
		{"SYS_WAIT4", Const, 0},
		{"SYS_WAIT4_NOCANCEL", Const, 0},
		{"SYS_WAIT6", Const, 1},
		{"SYS_WAITEVENT", Const, 0},
		{"SYS_WAITID", Const, 0},
		{"SYS_WAITID_NOCANCEL", Const, 0},
		{"SYS_WAITPID", Const, 0},
		{"SYS_WATCHEVENT", Const, 0},
		{"SYS_WORKQ_KERNRETURN", Const, 0},
		{"SYS_WORKQ_OPEN", Const, 0},
		{"SYS_WRITE", Const, 0},
		{"SYS_WRITEV", Const, 0},
		{"SYS_WRITEV_NOCANCEL", Const, 0},
		{"SYS_WRITE_NOCANCEL", Const, 0},
		{"SYS_YIELD", Const, 0},
		{"SYS__LLSEEK", Const, 0},
		{"SYS__LWP_CONTINUE", Const, 1},
		{"SYS__LWP_CREATE", Const, 1},
		{"SYS__LWP_CTL", Const, 1},
		{"SYS__LWP_DETACH", Const, 1},
		{"SYS__LWP_EXIT", Const, 1},
		{"SYS__LWP_GETNAME", Const, 1},
		{"SYS__LWP_GETPRIVATE", Const, 1},
		{"SYS__LWP_KILL", Const, 1},
		{"SYS__LWP_PARK", Const, 1},
		{"SYS__LWP_SELF", Const, 1},
		{"SYS__LWP_SETNAME", Const, 1},
		{"SYS__LWP_SETPRIVATE", Const, 1},
		{"SYS__LWP_SUSPEND", Const, 1},
		{"SYS__LWP_UNPARK", Const, 1},
		{"SYS__LWP_UNPARK_ALL", Const, 1},
		{"SYS__LWP_WAIT", Const, 1},
		{"SYS__LWP_WAKEUP", Const, 1},
		{"SYS__NEWSELECT", Const, 0},
		{"SYS__PSET_BIND", Const, 1},
		{"SYS__SCHED_GETAFFINITY", Const, 1},
		{"SYS__SCHED_GETPARAM", Const, 1},
		{"SYS__SCHED_SETAFFINITY", Const, 1},
		{"SYS__SCHED_SETPARAM", Const, 1},
		{"SYS__SYSCTL", Const, 0},
		{"SYS__UMTX_LOCK", Const, 0},
		{"SYS__UMTX_OP", Const, 0},
		{"SYS__UMTX_UNLOCK", Const, 0},
		{"SYS___ACL_ACLCHECK_FD", Const, 0},
		{"SYS___ACL_ACLCHECK_FILE", Const, 0},
		{"SYS___ACL_ACLCHECK_LINK", Const, 0},
		{"SYS___ACL_DELETE_FD", Const, 0},
		{"SYS___ACL_DELETE_FILE", Const, 0},
		{"SYS___ACL_DELETE_LINK", Const, 0},
		{"SYS___ACL_GET_FD", Const, 0},
		{"SYS___ACL_GET_FILE", Const, 0},
		{"SYS___ACL_GET_LINK", Const, 0},
		{"SYS___ACL_SET_FD", Const, 0},
		{"SYS___ACL_SET_FILE", Const, 0},
		{"SYS___ACL_SET_LINK", Const, 0},
		{"SYS___CAP_RIGHTS_GET", Const, 14},
		{"SYS___CLONE", Const, 1},
		{"SYS___DISABLE_THREADSIGNAL", Const, 0},
		{"SYS___GETCWD", Const, 0},
		{"SYS___GETLOGIN", Const, 1},
		{"SYS___GET_TCB", Const, 1},
		{"SYS___MAC_EXECVE", Const, 0},
		{"SYS___MAC_GETFSSTAT", Const, 0},
		{"SYS___MAC_GET_FD", Const, 0},
		{"SYS___MAC_GET_FILE", Const, 0},
		{"SYS___MAC_GET_LCID", Const, 0},
		{"SYS___MAC_GET_LCTX", Const, 0},
		{"SYS___MAC_GET_LINK", Const, 0},
		{"SYS___MAC_GET_MOUNT", Const, 0},
		{"SYS___MAC_GET_PID", Const, 0},
		{"SYS___MAC_GET_PROC", Const, 0},
		{"SYS___MAC_MOUNT", Const, 0},
		{"SYS___MAC_SET_FD", Const, 0},
		{"SYS___MAC_SET_FILE", Const, 0},
		{"SYS___MAC_SET_LCTX", Const, 0},
		{"SYS___MAC_SET_LINK", Const, 0},
		{"SYS___MAC_SET_PROC", Const, 0},
		{"SYS___MAC_SYSCALL", Const, 0},
		{"SYS___OLD_SEMWAIT_SIGNAL", Const, 0},
		{"SYS___OLD_SEMWAIT_SIGNAL_NOCANCEL", Const, 0},
		{"SYS___POSIX_CHOWN", Const, 1},
		{"SYS___POSIX_FCHOWN", Const, 1},
		{"SYS___POSIX_LCHOWN", Const, 1},
		{"SYS___POSIX_RENAME", Const, 1},
		{"SYS___PTHREAD_CANCELED", Const, 0},
		{"SYS___PTHREAD_CHDIR", Const, 0},
		{"SYS___PTHREAD_FCHDIR", Const, 0},
		{"SYS___PTHREAD_KILL", Const, 0},
		{"SYS___PTHREAD_MARKCANCEL", Const, 0},
		{"SYS___PTHREAD_SIGMASK", Const, 0},
		{"SYS___QUOTACTL", Const, 1},
		{"SYS___SEMCTL", Const, 1},
		{"SYS___SEMWAIT_SIGNAL", Const, 0},
		{"SYS___SEMWAIT_SIGNAL_NOCANCEL", Const, 0},
		{"SYS___SETLOGIN", Const, 1},
		{"SYS___SETUGID", Const, 0},
		{"SYS___SET_TCB", Const, 1},
		{"SYS___SIGACTION_SIGTRAMP", Const, 1},
		{"SYS___SIGTIMEDWAIT", Const, 1},
		{"SYS___SIGWAIT", Const, 0},
		{"SYS___SIGWAIT_NOCANCEL", Const, 0},
		{"SYS___SYSCTL", Const, 0},
		{"SYS___TFORK", Const, 1},
		{"SYS___THREXIT", Const, 1},
		{"SYS___THRSIGDIVERT", Const, 1},
		{"SYS___THRSLEEP", Const, 1},
		{"SYS___THRWAKEUP", Const, 1},
		{"S_ARCH1", Const, 1},
		{"S_ARCH2", Const, 1},
		{"S_BLKSIZE", Const, 0},
		{"S_IEXEC", Const, 0},
		{"S_IFBLK", Const, 0},
		{"S_IFCHR", Const, 0},
		{"S_IFDIR", Const, 0},
		{"S_IFIFO", Const, 0},
		{"S_IFLNK", Const, 0},
		{"S_IFMT", Const, 0},
		{"S_IFREG", Const, 0},
		{"S_IFSOCK", Const, 0},
		{"S_IFWHT", Const, 0},
		{"S_IREAD", Const, 0},
		{"S_IRGRP", Const, 0},
		{"S_IROTH", Const, 0},
		{"S_IRUSR", Const, 0},
		{"S_IRWXG", Const, 0},
		{"S_IRWXO", Const, 0},
		{"S_IRWXU", Const, 0},
		{"S_ISGID", Const, 0},
		{"S_ISTXT", Const, 0},
		{"S_ISUID", Const, 0},
		{"S_ISVTX", Const, 0},
		{"S_IWGRP", Const, 0},
		{"S_IWOTH", Const, 0},
		{"S_IWRITE", Const, 0},
		{"S_IWUSR", Const, 0},
		{"S_IXGRP", Const, 0},
		{"S_IXOTH", Const, 0},
		{"S_IXUSR", Const, 0},
		{"S_LOGIN_SET", Const, 1},
		{"SecurityAttributes", Type, 0},
		{"SecurityAttributes.InheritHandle", Field, 0},
		{"SecurityAttributes.Length", Field, 0},
		{"SecurityAttributes.SecurityDescriptor", Field, 0},
		{"Seek", Func, 0},
		{"Select", Func, 0},
		{"Sendfile", Func, 0},
		{"Sendmsg", Func, 0},
		{"SendmsgN", Func, 3},
		{"Sendto", Func, 0},
		{"Servent", Type, 0},
		{"Servent.Aliases", Field, 0},
		{"Servent.Name", Field, 0},
		{"Servent.Port", Field, 0},
		{"Servent.Proto", Field, 0},
		{"SetBpf", Func, 0},
		{"SetBpfBuflen", Func, 0},
		{"SetBpfDatalink", Func, 0},
		{"SetBpfHeadercmpl", Func, 0},
		{"SetBpfImmediate", Func, 0},
		{"SetBpfInterface", Func, 0},
		{"SetBpfPromisc", Func, 0},
		{"SetBpfTimeout", Func, 0},
		{"SetCurrentDirectory", Func, 0},
		{"SetEndOfFile", Func, 0},
		{"SetEnvironmentVariable", Func, 0},
		{"SetFileAttributes", Func, 0},
		{"SetFileCompletionNotificationModes", Func, 2},
		{"SetFilePointer", Func, 0},
		{"SetFileTime", Func, 0},
		{"SetHandleInformation", Func, 0},
		{"SetKevent", Func, 0},
		{"SetLsfPromisc", Func, 0},
		{"SetNonblock", Func, 0},
		{"Setdomainname", Func, 0},
		{"Setegid", Func, 0},
		{"Setenv", Func, 0},
		{"Seteuid", Func, 0},
		{"Setfsgid", Func, 0},
		{"Setfsuid", Func, 0},
		{"Setgid", Func, 0},
		{"Setgroups", Func, 0},
		{"Sethostname", Func, 0},
		{"Setlogin", Func, 0},
		{"Setpgid", Func, 0},
		{"Setpriority", Func, 0},
		{"Setprivexec", Func, 0},
		{"Setregid", Func, 0},
		{"Setresgid", Func, 0},
		{"Setresuid", Func, 0},
		{"Setreuid", Func, 0},
		{"Setrlimit", Func, 0},
		{"Setsid", Func, 0},
		{"Setsockopt", Func, 0},
		{"SetsockoptByte", Func, 0},
		{"SetsockoptICMPv6Filter", Func, 2},
		{"SetsockoptIPMreq", Func, 0},
		{"SetsockoptIPMreqn", Func, 0},
		{"SetsockoptIPv6Mreq", Func, 0},
		{"SetsockoptInet4Addr", Func, 0},
		{"SetsockoptInt", Func, 0},
		{"SetsockoptLinger", Func, 0},
		{"SetsockoptString", Func, 0},
		{"SetsockoptTimeval", Func, 0},
		{"Settimeofday", Func, 0},
		{"Setuid", Func, 0},
		{"Setxattr", Func, 1},
		{"Shutdown", Func, 0},
		{"SidTypeAlias", Const, 0},
		{"SidTypeComputer", Const, 0},
		{"SidTypeDeletedAccount", Const, 0},
		{"SidTypeDomain", Const, 0},
		{"SidTypeGroup", Const, 0},
		{"SidTypeInvalid", Const, 0},
		{"SidTypeLabel", Const, 0},
		{"SidTypeUnknown", Const, 0},
		{"SidTypeUser", Const, 0},
		{"SidTypeWellKnownGroup", Const, 0},
		{"Signal", Type, 0},
		{"SizeofBpfHdr", Const, 0},
		{"SizeofBpfInsn", Const, 0},
		{"SizeofBpfProgram", Const, 0},
		{"SizeofBpfStat", Const, 0},
		{"SizeofBpfVersion", Const, 0},
		{"SizeofBpfZbuf", Const, 0},
		{"SizeofBpfZbufHeader", Const, 0},
		{"SizeofCmsghdr", Const, 0},
		{"SizeofICMPv6Filter", Const, 2},
		{"SizeofIPMreq", Const, 0},
		{"SizeofIPMreqn", Const, 0},
		{"SizeofIPv6MTUInfo", Const, 2},
		{"SizeofIPv6Mreq", Const, 0},
		{"SizeofIfAddrmsg", Const, 0},
		{"SizeofIfAnnounceMsghdr", Const, 1},
		{"SizeofIfData", Const, 0},
		{"SizeofIfInfomsg", Const, 0},
		{"SizeofIfMsghdr", Const, 0},
		{"SizeofIfaMsghdr", Const, 0},
		{"SizeofIfmaMsghdr", Const, 0},
		{"SizeofIfmaMsghdr2", Const, 0},
		{"SizeofInet4Pktinfo", Const, 0},
		{"SizeofInet6Pktinfo", Const, 0},
		{"SizeofInotifyEvent", Const, 0},
		{"SizeofLinger", Const, 0},
		{"SizeofMsghdr", Const, 0},
		{"SizeofNlAttr", Const, 0},
		{"SizeofNlMsgerr", Const, 0},
		{"SizeofNlMsghdr", Const, 0},
		{"SizeofRtAttr", Const, 0},
		{"SizeofRtGenmsg", Const, 0},
		{"SizeofRtMetrics", Const, 0},
		{"SizeofRtMsg", Const, 0},
		{"SizeofRtMsghdr", Const, 0},
		{"SizeofRtNexthop", Const, 0},
		{"SizeofSockFilter", Const, 0},
		{"SizeofSockFprog", Const, 0},
		{"SizeofSockaddrAny", Const, 0},
		{"SizeofSockaddrDatalink", Const, 0},
		{"SizeofSockaddrInet4", Const, 0},
		{"SizeofSockaddrInet6", Const, 0},
		{"SizeofSockaddrLinklayer", Const, 0},
		{"SizeofSockaddrNetlink", Const, 0},
		{"SizeofSockaddrUnix", Const, 0},
		{"SizeofTCPInfo", Const, 1},
		{"SizeofUcred", Const, 0},
		{"SlicePtrFromStrings", Func, 1},
		{"SockFilter", Type, 0},
		{"SockFilter.Code", Field, 0},
		{"SockFilter.Jf", Field, 0},
		{"SockFilter.Jt", Field, 0},
		{"SockFilter.K", Field, 0},
		{"SockFprog", Type, 0},
		{"SockFprog.Filter", Field, 0},
		{"SockFprog.Len", Field, 0},
		{"SockFprog.Pad_cgo_0", Field, 0},
		{"Sockaddr", Type, 0},
		{"SockaddrDatalink", Type, 0},
		{"SockaddrDatalink.Alen", Field, 0},
		{"SockaddrDatalink.Data", Field, 0},
		{"SockaddrDatalink.Family", Field, 0},
		{"SockaddrDatalink.Index", Field, 0},
		{"SockaddrDatalink.Len", Field, 0},
		{"SockaddrDatalink.Nlen", Field, 0},
		{"SockaddrDatalink.Slen", Field, 0},
		{"SockaddrDatalink.Type", Field, 0},
		{"SockaddrGen", Type, 0},
		{"SockaddrInet4", Type, 0},
		{"SockaddrInet4.Addr", Field, 0},
		{"SockaddrInet4.Port", Field, 0},
		{"SockaddrInet6", Type, 0},
		{"SockaddrInet6.Addr", Field, 0},
		{"SockaddrInet6.Port", Field, 0},
		{"SockaddrInet6.ZoneId", Field, 0},
		{"SockaddrLinklayer", Type, 0},
		{"SockaddrLinklayer.Addr", Field, 0},
		{"SockaddrLinklayer.Halen", Field, 0},
		{"SockaddrLinklayer.Hatype", Field, 0},
		{"SockaddrLinklayer.Ifindex", Field, 0},
		{"SockaddrLinklayer.Pkttype", Field, 0},
		{"SockaddrLinklayer.Protocol", Field, 0},
		{"SockaddrNetlink", Type, 0},
		{"SockaddrNetlink.Family", Field, 0},
		{"SockaddrNetlink.Groups", Field, 0},
		{"SockaddrNetlink.Pad", Field, 0},
		{"SockaddrNetlink.Pid", Field, 0},
		{"SockaddrUnix", Type, 0},
		{"SockaddrUnix.Name", Field, 0},
		{"Socket", Func, 0},
		{"SocketControlMessage", Type, 0},
		{"SocketControlMessage.Data", Field, 0},
		{"SocketControlMessage.Header", Field, 0},
		{"SocketDisableIPv6", Var, 0},
		{"Socketpair", Func, 0},
		{"Splice", Func, 0},
		{"StartProcess", Func, 0},
		{"StartupInfo", Type, 0},
		{"StartupInfo.Cb", Field, 0},
		{"StartupInfo.Desktop", Field, 0},
		{"StartupInfo.FillAttribute", Field, 0},
		{"StartupInfo.Flags", Field, 0},
		{"StartupInfo.ShowWindow", Field, 0},
		{"StartupInfo.StdErr", Field, 0},
		{"StartupInfo.StdInput", Field, 0},
		{"StartupInfo.StdOutput", Field, 0},
		{"StartupInfo.Title", Field, 0},
		{"StartupInfo.X", Field, 0},
		{"StartupInfo.XCountChars", Field, 0},
		{"StartupInfo.XSize", Field, 0},
		{"StartupInfo.Y", Field, 0},
		{"StartupInfo.YCountChars", Field, 0},
		{"StartupInfo.YSize", Field, 0},
		{"Stat", Func, 0},
		{"Stat_t", Type, 0},
		{"Stat_t.Atim", Field, 0},
		{"Stat_t.Atim_ext", Field, 12},
		{"Stat_t.Atimespec", Field, 0},
		{"Stat_t.Birthtimespec", Field, 0},
		{"Stat_t.Blksize", Field, 0},
		{"Stat_t.Blocks", Field, 0},
		{"Stat_t.Btim_ext", Field, 12},
		{"Stat_t.Ctim", Field, 0},
		{"Stat_t.Ctim_ext", Field, 12},
		{"Stat_t.Ctimespec", Field, 0},
		{"Stat_t.Dev", Field, 0},
		{"Stat_t.Flags", Field, 0},
		{"Stat_t.Gen", Field, 0},
		{"Stat_t.Gid", Field, 0},
		{"Stat_t.Ino", Field, 0},
		{"Stat_t.Lspare", Field, 0},
		{"Stat_t.Lspare0", Field, 2},
		{"Stat_t.Lspare1", Field, 2},
		{"Stat_t.Mode", Field, 0},
		{"Stat_t.Mtim", Field, 0},
		{"Stat_t.Mtim_ext", Field, 12},
		{"Stat_t.Mtimespec", Field, 0},
		{"Stat_t.Nlink", Field, 0},
		{"Stat_t.Pad_cgo_0", Field, 0},
		{"Stat_t.Pad_cgo_1", Field, 0},
		{"Stat_t.Pad_cgo_2", Field, 0},
		{"Stat_t.Padding0", Field, 12},
		{"Stat_t.Padding1", Field, 12},
		{"Stat_t.Qspare", Field, 0},
		{"Stat_t.Rdev", Field, 0},
		{"Stat_t.Size", Field, 0},
		{"Stat_t.Spare", Field, 2},
		{"Stat_t.Uid", Field, 0},
		{"Stat_t.X__pad0", Field, 0},
		{"Stat_t.X__pad1", Field, 0},
		{"Stat_t.X__pad2", Field, 0},
		{"Stat_t.X__st_birthtim", Field, 2},
		{"Stat_t.X__st_ino", Field, 0},
		{"Stat_t.X__unused", Field, 0},
		{"Statfs", Func, 0},
		{"Statfs_t", Type, 0},
		{"Statfs_t.Asyncreads", Field, 0},
		{"Statfs_t.Asyncwrites", Field, 0},
		{"Statfs_t.Bavail", Field, 0},
		{"Statfs_t.Bfree", Field, 0},
		{"Statfs_t.Blocks", Field, 0},
		{"Statfs_t.Bsize", Field, 0},
		{"Statfs_t.Charspare", Field, 0},
		{"Statfs_t.F_asyncreads", Field, 2},
		{"Statfs_t.F_asyncwrites", Field, 2},
		{"Statfs_t.F_bavail", Field, 2},
		{"Statfs_t.F_bfree", Field, 2},
		{"Statfs_t.F_blocks", Field, 2},
		{"Statfs_t.F_bsize", Field, 2},
		{"Statfs_t.F_ctime", Field, 2},
		{"Statfs_t.F_favail", Field, 2},
		{"Statfs_t.F_ffree", Field, 2},
		{"Statfs_t.F_files", Field, 2},
		{"Statfs_t.F_flags", Field, 2},
		{"Statfs_t.F_fsid", Field, 2},
		{"Statfs_t.F_fstypename", Field, 2},
		{"Statfs_t.F_iosize", Field, 2},
		{"Statfs_t.F_mntfromname", Field, 2},
		{"Statfs_t.F_mntfromspec", Field, 3},
		{"Statfs_t.F_mntonname", Field, 2},
		{"Statfs_t.F_namemax", Field, 2},
		{"Statfs_t.F_owner", Field, 2},
		{"Statfs_t.F_spare", Field, 2},
		{"Statfs_t.F_syncreads", Field, 2},
		{"Statfs_t.F_syncwrites", Field, 2},
		{"Statfs_t.Ffree", Field, 0},
		{"Statfs_t.Files", Field, 0},
		{"Statfs_t.Flags", Field, 0},
		{"Statfs_t.Frsize", Field, 0},
		{"Statfs_t.Fsid", Field, 0},
		{"Statfs_t.Fssubtype", Field, 0},
		{"Statfs_t.Fstypename", Field, 0},
		{"Statfs_t.Iosize", Field, 0},
		{"Statfs_t.Mntfromname", Field, 0},
		{"Statfs_t.Mntonname", Field, 0},
		{"Statfs_t.Mount_info", Field, 2},
		{"Statfs_t.Namelen", Field, 0},
		{"Statfs_t.Namemax", Field, 0},
		{"Statfs_t.Owner", Field, 0},
		{"Statfs_t.Pad_cgo_0", Field, 0},
		{"Statfs_t.Pad_cgo_1", Field, 2},
		{"Statfs_t.Reserved", Field, 0},
		{"Statfs_t.Spare", Field, 0},
		{"Statfs_t.Syncreads", Field, 0},
		{"Statfs_t.Syncwrites", Field, 0},
		{"Statfs_t.Type", Field, 0},
		{"Statfs_t.Version", Field, 0},
		{"Stderr", Var, 0},
		{"Stdin", Var, 0},
		{"Stdout", Var, 0},
		{"StringBytePtr", Func, 0},
		{"StringByteSlice", Func, 0},
		{"StringSlicePtr", Func, 0},
		{"StringToSid", Func, 0},
		{"StringToUTF16", Func, 0},
		{"StringToUTF16Ptr", Func, 0},
		{"Symlink", Func, 0},
		{"Sync", Func, 0},
		{"SyncFileRange", Func, 0},
		{"SysProcAttr", Type, 0},
		{"SysProcAttr.AdditionalInheritedHandles", Field, 17},
		{"SysProcAttr.AmbientCaps", Field, 9},
		{"SysProcAttr.CgroupFD", Field, 20},
		{"SysProcAttr.Chroot", Field, 0},
		{"SysProcAttr.Cloneflags", Field, 2},
		{"SysProcAttr.CmdLine", Field, 0},
		{"SysProcAttr.CreationFlags", Field, 1},
		{"SysProcAttr.Credential", Field, 0},
		{"SysProcAttr.Ctty", Field, 1},
		{"SysProcAttr.Foreground", Field, 5},
		{"SysProcAttr.GidMappings", Field, 4},
		{"SysProcAttr.GidMappingsEnableSetgroups", Field, 5},
		{"SysProcAttr.HideWindow", Field, 0},
		{"SysProcAttr.Jail", Field, 21},
		{"SysProcAttr.NoInheritHandles", Field, 16},
		{"SysProcAttr.Noctty", Field, 0},
		{"SysProcAttr.ParentProcess", Field, 17},
		{"SysProcAttr.Pdeathsig", Field, 0},
		{"SysProcAttr.Pgid", Field, 5},
		{"SysProcAttr.PidFD", Field, 22},
		{"SysProcAttr.ProcessAttributes", Field, 13},
		{"SysProcAttr.Ptrace", Field, 0},
		{"SysProcAttr.Setctty", Field, 0},
		{"SysProcAttr.Setpgid", Field, 0},
		{"SysProcAttr.Setsid", Field, 0},
		{"SysProcAttr.ThreadAttributes", Field, 13},
		{"SysProcAttr.Token", Field, 10},
		{"SysProcAttr.UidMappings", Field, 4},
		{"SysProcAttr.Unshareflags", Field, 7},
		{"SysProcAttr.UseCgroupFD", Field, 20},
		{"SysProcIDMap", Type, 4},
		{"SysProcIDMap.ContainerID", Field, 4},
		{"SysProcIDMap.HostID", Field, 4},
		{"SysProcIDMap.Size", Field, 4},
		{"Syscall", Func, 0},
		{"Syscall12", Func, 0},
		{"Syscall15", Func, 0},
		{"Syscall18", Func, 12},
		{"Syscall6", Func, 0},
		{"Syscall9", Func, 0},
		{"SyscallN", Func, 18},
		{"Sysctl", Func, 0},
		{"SysctlUint32", Func, 0},
		{"Sysctlnode", Type, 2},
		{"Sysctlnode.Flags", Field, 2},
		{"Sysctlnode.Name", Field, 2},
		{"Sysctlnode.Num", Field, 2},
		{"Sysctlnode.Un", Field, 2},
		{"Sysctlnode.Ver", Field, 2},
		{"Sysctlnode.X__rsvd", Field, 2},
		{"Sysctlnode.X_sysctl_desc", Field, 2},
		{"Sysctlnode.X_sysctl_func", Field, 2},
		{"Sysctlnode.X_sysctl_parent", Field, 2},
		{"Sysctlnode.X_sysctl_size", Field, 2},
		{"Sysinfo", Func, 0},
		{"Sysinfo_t", Type, 0},
		{"Sysinfo_t.Bufferram", Field, 0},
		{"Sysinfo_t.Freehigh", Field, 0},
		{"Sysinfo_t.Freeram", Field, 0},
		{"Sysinfo_t.Freeswap", Field, 0},
		{"Sysinfo_t.Loads", Field, 0},
		{"Sysinfo_t.Pad", Field, 0},
		{"Sysinfo_t.Pad_cgo_0", Field, 0},
		{"Sysinfo_t.Pad_cgo_1", Field, 0},
		{"Sysinfo_t.Procs", Field, 0},
		{"Sysinfo_t.Sharedram", Field, 0},
		{"Sysinfo_t.Totalhigh", Field, 0},
		{"Sysinfo_t.Totalram", Field, 0},
		{"Sysinfo_t.Totalswap", Field, 0},
		{"Sysinfo_t.Unit", Field, 0},
		{"Sysinfo_t.Uptime", Field, 0},
		{"Sysinfo_t.X_f", Field, 0},
		{"Systemtime", Type, 0},
		{"Systemtime.Day", Field, 0},
		{"Systemtime.DayOfWeek", Field, 0},
		{"Systemtime.Hour", Field, 0},
		{"Systemtime.Milliseconds", Field, 0},
		{"Systemtime.Minute", Field, 0},
		{"Systemtime.Month", Field, 0},
		{"Systemtime.Second", Field, 0},
		{"Systemtime.Year", Field, 0},
		{"TCGETS", Const, 0},
		{"TCIFLUSH", Const, 1},
		{"TCIOFLUSH", Const, 1},
		{"TCOFLUSH", Const, 1},
		{"TCPInfo", Type, 1},
		{"TCPInfo.Advmss", Field, 1},
		{"TCPInfo.Ato", Field, 1},
		{"TCPInfo.Backoff", Field, 1},
		{"TCPInfo.Ca_state", Field, 1},
		{"TCPInfo.Fackets", Field, 1},
		{"TCPInfo.Last_ack_recv", Field, 1},
		{"TCPInfo.Last_ack_sent", Field, 1},
		{"TCPInfo.Last_data_recv", Field, 1},
		{"TCPInfo.Last_data_sent", Field, 1},
		{"TCPInfo.Lost", Field, 1},
		{"TCPInfo.Options", Field, 1},
		{"TCPInfo.Pad_cgo_0", Field, 1},
		{"TCPInfo.Pmtu", Field, 1},
		{"TCPInfo.Probes", Field, 1},
		{"TCPInfo.Rcv_mss", Field, 1},
		{"TCPInfo.Rcv_rtt", Field, 1},
		{"TCPInfo.Rcv_space", Field, 1},
		{"TCPInfo.Rcv_ssthresh", Field, 1},
		{"TCPInfo.Reordering", Field, 1},
		{"TCPInfo.Retrans", Field, 1},
		{"TCPInfo.Retransmits", Field, 1},
		{"TCPInfo.Rto", Field, 1},
		{"TCPInfo.Rtt", Field, 1},
		{"TCPInfo.Rttvar", Field, 1},
		{"TCPInfo.Sacked", Field, 1},
		{"TCPInfo.Snd_cwnd", Field, 1},
		{"TCPInfo.Snd_mss", Field, 1},
		{"TCPInfo.Snd_ssthresh", Field, 1},
		{"TCPInfo.State", Field, 1},
		{"TCPInfo.Total_retrans", Field, 1},
		{"TCPInfo.Unacked", Field, 1},
		{"TCPKeepalive", Type, 3},
		{"TCPKeepalive.Interval", Field, 3},
		{"TCPKeepalive.OnOff", Field, 3},
		{"TCPKeepalive.Time", Field, 3},
		{"TCP_CA_NAME_MAX", Const, 0},
		{"TCP_CONGCTL", Const, 1},
		{"TCP_CONGESTION", Const, 0},
		{"TCP_CONNECTIONTIMEOUT", Const, 0},
		{"TCP_CORK", Const, 0},
		{"TCP_DEFER_ACCEPT", Const, 0},
		{"TCP_ENABLE_ECN", Const, 16},
		{"TCP_INFO", Const, 0},
		{"TCP_KEEPALIVE", Const, 0},
		{"TCP_KEEPCNT", Const, 0},
		{"TCP_KEEPIDLE", Const, 0},
		{"TCP_KEEPINIT", Const, 1},
		{"TCP_KEEPINTVL", Const, 0},
		{"TCP_LINGER2", Const, 0},
		{"TCP_MAXBURST", Const, 0},
		{"TCP_MAXHLEN", Const, 0},
		{"TCP_MAXOLEN", Const, 0},
		{"TCP_MAXSEG", Const, 0},
		{"TCP_MAXWIN", Const, 0},
		{"TCP_MAX_SACK", Const, 0},
		{"TCP_MAX_WINSHIFT", Const, 0},
		{"TCP_MD5SIG", Const, 0},
		{"TCP_MD5SIG_MAXKEYLEN", Const, 0},
		{"TCP_MINMSS", Const, 0},
		{"TCP_MINMSSOVERLOAD", Const, 0},
		{"TCP_MSS", Const, 0},
		{"TCP_NODELAY", Const, 0},
		{"TCP_NOOPT", Const, 0},
		{"TCP_NOPUSH", Const, 0},
		{"TCP_NOTSENT_LOWAT", Const, 16},
		{"TCP_NSTATES", Const, 1},
		{"TCP_QUICKACK", Const, 0},
		{"TCP_RXT_CONNDROPTIME", Const, 0},
		{"TCP_RXT_FINDROP", Const, 0},
		{"TCP_SACK_ENABLE", Const, 1},
		{"TCP_SENDMOREACKS", Const, 16},
		{"TCP_SYNCNT", Const, 0},
		{"TCP_VENDOR", Const, 3},
		{"TCP_WINDOW_CLAMP", Const, 0},
		{"TCSAFLUSH", Const, 1},
		{"TCSETS", Const, 0},
		{"TF_DISCONNECT", Const, 0},
		{"TF_REUSE_SOCKET", Const, 0},
		{"TF_USE_DEFAULT_WORKER", Const, 0},
		{"TF_USE_KERNEL_APC", Const, 0},
		{"TF_USE_SYSTEM_THREAD", Const, 0},
		{"TF_WRITE_BEHIND", Const, 0},
		{"TH32CS_INHERIT", Const, 4},
		{"TH32CS_SNAPALL", Const, 4},
		{"TH32CS_SNAPHEAPLIST", Const, 4},
		{"TH32CS_SNAPMODULE", Const, 4},
		{"TH32CS_SNAPMODULE32", Const, 4},
		{"TH32CS_SNAPPROCESS", Const, 4},
		{"TH32CS_SNAPTHREAD", Const, 4},
		{"TIME_ZONE_ID_DAYLIGHT", Const, 0},
		{"TIME_ZONE_ID_STANDARD", Const, 0},
		{"TIME_ZONE_ID_UNKNOWN", Const, 0},
		{"TIOCCBRK", Const, 0},
		{"TIOCCDTR", Const, 0},
		{"TIOCCONS", Const, 0},
		{"TIOCDCDTIMESTAMP", Const, 0},
		{"TIOCDRAIN", Const, 0},
		{"TIOCDSIMICROCODE", Const, 0},
		{"TIOCEXCL", Const, 0},
		{"TIOCEXT", Const, 0},
		{"TIOCFLAG_CDTRCTS", Const, 1},
		{"TIOCFLAG_CLOCAL", Const, 1},
		{"TIOCFLAG_CRTSCTS", Const, 1},
		{"TIOCFLAG_MDMBUF", Const, 1},
		{"TIOCFLAG_PPS", Const, 1},
		{"TIOCFLAG_SOFTCAR", Const, 1},
		{"TIOCFLUSH", Const, 0},
		{"TIOCGDEV", Const, 0},
		{"TIOCGDRAINWAIT", Const, 0},
		{"TIOCGETA", Const, 0},
		{"TIOCGETD", Const, 0},
		{"TIOCGFLAGS", Const, 1},
		{"TIOCGICOUNT", Const, 0},
		{"TIOCGLCKTRMIOS", Const, 0},
		{"TIOCGLINED", Const, 1},
		{"TIOCGPGRP", Const, 0},
		{"TIOCGPTN", Const, 0},
		{"TIOCGQSIZE", Const, 1},
		{"TIOCGRANTPT", Const, 1},
		{"TIOCGRS485", Const, 0},
		{"TIOCGSERIAL", Const, 0},
		{"TIOCGSID", Const, 0},
		{"TIOCGSIZE", Const, 1},
		{"TIOCGSOFTCAR", Const, 0},
		{"TIOCGTSTAMP", Const, 1},
		{"TIOCGWINSZ", Const, 0},
		{"TIOCINQ", Const, 0},
		{"TIOCIXOFF", Const, 0},
		{"TIOCIXON", Const, 0},
		{"TIOCLINUX", Const, 0},
		{"TIOCMBIC", Const, 0},
		{"TIOCMBIS", Const, 0},
		{"TIOCMGDTRWAIT", Const, 0},
		{"TIOCMGET", Const, 0},
		{"TIOCMIWAIT", Const, 0},
		{"TIOCMODG", Const, 0},
		{"TIOCMODS", Const, 0},
		{"TIOCMSDTRWAIT", Const, 0},
		{"TIOCMSET", Const, 0},
		{"TIOCM_CAR", Const, 0},
		{"TIOCM_CD", Const, 0},
		{"TIOCM_CTS", Const, 0},
		{"TIOCM_DCD", Const, 0},
		{"TIOCM_DSR", Const, 0},
		{"TIOCM_DTR", Const, 0},
		{"TIOCM_LE", Const, 0},
		{"TIOCM_RI", Const, 0},
		{"TIOCM_RNG", Const, 0},
		{"TIOCM_RTS", Const, 0},
		{"TIOCM_SR", Const, 0},
		{"TIOCM_ST", Const, 0},
		{"TIOCNOTTY", Const, 0},
		{"TIOCNXCL", Const, 0},
		{"TIOCOUTQ", Const, 0},
		{"TIOCPKT", Const, 0},
		{"TIOCPKT_DATA", Const, 0},
		{"TIOCPKT_DOSTOP", Const, 0},
		{"TIOCPKT_FLUSHREAD", Const, 0},
		{"TIOCPKT_FLUSHWRITE", Const, 0},
		{"TIOCPKT_IOCTL", Const, 0},
		{"TIOCPKT_NOSTOP", Const, 0},
		{"TIOCPKT_START", Const, 0},
		{"TIOCPKT_STOP", Const, 0},
		{"TIOCPTMASTER", Const, 0},
		{"TIOCPTMGET", Const, 1},
		{"TIOCPTSNAME", Const, 1},
		{"TIOCPTYGNAME", Const, 0},
		{"TIOCPTYGRANT", Const, 0},
		{"TIOCPTYUNLK", Const, 0},
		{"TIOCRCVFRAME", Const, 1},
		{"TIOCREMOTE", Const, 0},
		{"TIOCSBRK", Const, 0},
		{"TIOCSCONS", Const, 0},
		{"TIOCSCTTY", Const, 0},
		{"TIOCSDRAINWAIT", Const, 0},
		{"TIOCSDTR", Const, 0},
		{"TIOCSERCONFIG", Const, 0},
		{"TIOCSERGETLSR", Const, 0},
		{"TIOCSERGETMULTI", Const, 0},
		{"TIOCSERGSTRUCT", Const, 0},
		{"TIOCSERGWILD", Const, 0},
		{"TIOCSERSETMULTI", Const, 0},
		{"TIOCSERSWILD", Const, 0},
		{"TIOCSER_TEMT", Const, 0},
		{"TIOCSETA", Const, 0},
		{"TIOCSETAF", Const, 0},
		{"TIOCSETAW", Const, 0},
		{"TIOCSETD", Const, 0},
		{"TIOCSFLAGS", Const, 1},
		{"TIOCSIG", Const, 0},
		{"TIOCSLCKTRMIOS", Const, 0},
		{"TIOCSLINED", Const, 1},
		{"TIOCSPGRP", Const, 0},
		{"TIOCSPTLCK", Const, 0},
		{"TIOCSQSIZE", Const, 1},
		{"TIOCSRS485", Const, 0},
		{"TIOCSSERIAL", Const, 0},
		{"TIOCSSIZE", Const, 1},
		{"TIOCSSOFTCAR", Const, 0},
		{"TIOCSTART", Const, 0},
		{"TIOCSTAT", Const, 0},
		{"TIOCSTI", Const, 0},
		{"TIOCSTOP", Const, 0},
		{"TIOCSTSTAMP", Const, 1},
		{"TIOCSWINSZ", Const, 0},
		{"TIOCTIMESTAMP", Const, 0},
		{"TIOCUCNTL", Const, 0},
		{"TIOCVHANGUP", Const, 0},
		{"TIOCXMTFRAME", Const, 1},
		{"TOKEN_ADJUST_DEFAULT", Const, 0},
		{"TOKEN_ADJUST_GROUPS", Const, 0},
		{"TOKEN_ADJUST_PRIVILEGES", Const, 0},
		{"TOKEN_ADJUST_SESSIONID", Const, 11},
		{"TOKEN_ALL_ACCESS", Const, 0},
		{"TOKEN_ASSIGN_PRIMARY", Const, 0},
		{"TOKEN_DUPLICATE", Const, 0},
		{"TOKEN_EXECUTE", Const, 0},
		{"TOKEN_IMPERSONATE", Const, 0},
		{"TOKEN_QUERY", Const, 0},
		{"TOKEN_QUERY_SOURCE", Const, 0},
		{"TOKEN_READ", Const, 0},
		{"TOKEN_WRITE", Const, 0},
		{"TOSTOP", Const, 0},
		{"TRUNCATE_EXISTING", Const, 0},
		{"TUNATTACHFILTER", Const, 0},
		{"TUNDETACHFILTER", Const, 0},
		{"TUNGETFEATURES", Const, 0},
		{"TUNGETIFF", Const, 0},
		{"TUNGETSNDBUF", Const, 0},
		{"TUNGETVNETHDRSZ", Const, 0},
		{"TUNSETDEBUG", Const, 0},
		{"TUNSETGROUP", Const, 0},
		{"TUNSETIFF", Const, 0},
		{"TUNSETLINK", Const, 0},
		{"TUNSETNOCSUM", Const, 0},
		{"TUNSETOFFLOAD", Const, 0},
		{"TUNSETOWNER", Const, 0},
		{"TUNSETPERSIST", Const, 0},
		{"TUNSETSNDBUF", Const, 0},
		{"TUNSETTXFILTER", Const, 0},
		{"TUNSETVNETHDRSZ", Const, 0},
		{"Tee", Func, 0},
		{"TerminateProcess", Func, 0},
		{"Termios", Type, 0},
		{"Termios.Cc", Field, 0},
		{"Termios.Cflag", Field, 0},
		{"Termios.Iflag", Field, 0},
		{"Termios.Ispeed", Field, 0},
		{"Termios.Lflag", Field, 0},
		{"Termios.Line", Field, 0},
		{"Termios.Oflag", Field, 0},
		{"Termios.Ospeed", Field, 0},
		{"Termios.Pad_cgo_0", Field, 0},
		{"Tgkill", Func, 0},
		{"Time", Func, 0},
		{"Time_t", Type, 0},
		{"Times", Func, 0},
		{"Timespec", Type, 0},
		{"Timespec.Nsec", Field, 0},
		{"Timespec.Pad_cgo_0", Field, 2},
		{"Timespec.Sec", Field, 0},
		{"TimespecToNsec", Func, 0},
		{"Timeval", Type, 0},
		{"Timeval.Pad_cgo_0", Field, 0},
		{"Timeval.Sec", Field, 0},
		{"Timeval.Usec", Field, 0},
		{"Timeval32", Type, 0},
		{"Timeval32.Sec", Field, 0},
		{"Timeval32.Usec", Field, 0},
		{"TimevalToNsec", Func, 0},
		{"Timex", Type, 0},
		{"Timex.Calcnt", Field, 0},
		{"Timex.Constant", Field, 0},
		{"Timex.Errcnt", Field, 0},
		{"Timex.Esterror", Field, 0},
		{"Timex.Freq", Field, 0},
		{"Timex.Jitcnt", Field, 0},
		{"Timex.Jitter", Field, 0},
		{"Timex.Maxerror", Field, 0},
		{"Timex.Modes", Field, 0},
		{"Timex.Offset", Field, 0},
		{"Timex.Pad_cgo_0", Field, 0},
		{"Timex.Pad_cgo_1", Field, 0},
		{"Timex.Pad_cgo_2", Field, 0},
		{"Timex.Pad_cgo_3", Field, 0},
		{"Timex.Ppsfreq", Field, 0},
		{"Timex.Precision", Field, 0},
		{"Timex.Shift", Field, 0},
		{"Timex.Stabil", Field, 0},
		{"Timex.Status", Field, 0},
		{"Timex.Stbcnt", Field, 0},
		{"Timex.Tai", Field, 0},
		{"Timex.Tick", Field, 0},
		{"Timex.Time", Field, 0},
		{"Timex.Tolerance", Field, 0},
		{"Timezoneinformation", Type, 0},
		{"Timezoneinformation.Bias", Field, 0},
		{"Timezoneinformation.DaylightBias", Field, 0},
		{"Timezoneinformation.DaylightDate", Field, 0},
		{"Timezoneinformation.DaylightName", Field, 0},
		{"Timezoneinformation.StandardBias", Field, 0},
		{"Timezoneinformation.StandardDate", Field, 0},
		{"Timezoneinformation.StandardName", Field, 0},
		{"Tms", Type, 0},
		{"Tms.Cstime", Field, 0},
		{"Tms.Cutime", Field, 0},
		{"Tms.Stime", Field, 0},
		{"Tms.Utime", Field, 0},
		{"Token", Type, 0},
		{"TokenAccessInformation", Const, 0},
		{"TokenAuditPolicy", Const, 0},
		{"TokenDefaultDacl", Const, 0},
		{"TokenElevation", Const, 0},
		{"TokenElevationType", Const, 0},
		{"TokenGroups", Const, 0},
		{"TokenGroupsAndPrivileges", Const, 0},
		{"TokenHasRestrictions", Const, 0},
		{"TokenImpersonationLevel", Const, 0},
		{"TokenIntegrityLevel", Const, 0},
		{"TokenLinkedToken", Const, 0},
		{"TokenLogonSid", Const, 0},
		{"TokenMandatoryPolicy", Const, 0},
		{"TokenOrigin", Const, 0},
		{"TokenOwner", Const, 0},
		{"TokenPrimaryGroup", Const, 0},
		{"TokenPrivileges", Const, 0},
		{"TokenRestrictedSids", Const, 0},
		{"TokenSandBoxInert", Const, 0},
		{"TokenSessionId", Const, 0},
		{"TokenSessionReference", Const, 0},
		{"TokenSource", Const, 0},
		{"TokenStatistics", Const, 0},
		{"TokenType", Const, 0},
		{"TokenUIAccess", Const, 0},
		{"TokenUser", Const, 0},
		{"TokenVirtualizationAllowed", Const, 0},
		{"TokenVirtualizationEnabled", Const, 0},
		{"Tokenprimarygroup", Type, 0},
		{"Tokenprimarygroup.PrimaryGroup", Field, 0},
		{"Tokenuser", Type, 0},
		{"Tokenuser.User", Field, 0},
		{"TranslateAccountName", Func, 0},
		{"TranslateName", Func, 0},
		{"TransmitFile", Func, 0},
		{"TransmitFileBuffers", Type, 0},
		{"TransmitFileBuffers.Head", Field, 0},
		{"TransmitFileBuffers.HeadLength", Field, 0},
		{"TransmitFileBuffers.Tail", Field, 0},
		{"TransmitFileBuffers.TailLength", Field, 0},
		{"Truncate", Func, 0},
		{"UNIX_PATH_MAX", Const, 12},
		{"USAGE_MATCH_TYPE_AND", Const, 0},
		{"USAGE_MATCH_TYPE_OR", Const, 0},
		{"UTF16FromString", Func, 1},
		{"UTF16PtrFromString", Func, 1},
		{"UTF16ToString", Func, 0},
		{"Ucred", Type, 0},
		{"Ucred.Gid", Field, 0},
		{"Ucred.Pid", Field, 0},
		{"Ucred.Uid", Field, 0},
		{"Umask", Func, 0},
		{"Uname", Func, 0},
		{"Undelete", Func, 0},
		{"UnixCredentials", Func, 0},
		{"UnixRights", Func, 0},
		{"Unlink", Func, 0},
		{"Unlinkat", Func, 0},
		{"UnmapViewOfFile", Func, 0},
		{"Unmount", Func, 0},
		{"Unsetenv", Func, 4},
		{"Unshare", Func, 0},
		{"UserInfo10", Type, 0},
		{"UserInfo10.Comment", Field, 0},
		{"UserInfo10.FullName", Field, 0},
		{"UserInfo10.Name", Field, 0},
		{"UserInfo10.UsrComment", Field, 0},
		{"Ustat", Func, 0},
		{"Ustat_t", Type, 0},
		{"Ustat_t.Fname", Field, 0},
		{"Ustat_t.Fpack", Field, 0},
		{"Ustat_t.Pad_cgo_0", Field, 0},
		{"Ustat_t.Pad_cgo_1", Field, 0},
		{"Ustat_t.Tfree", Field, 0},
		{"Ustat_t.Tinode", Field, 0},
		{"Utimbuf", Type, 0},
		{"Utimbuf.Actime", Field, 0},
		{"Utimbuf.Modtime", Field, 0},
		{"Utime", Func, 0},
		{"Utimes", Func, 0},
		{"UtimesNano", Func, 1},
		{"Utsname", Type, 0},
		{"Utsname.Domainname", Field, 0},
		{"Utsname.Machine", Field, 0},
		{"Utsname.Nodename", Field, 0},
		{"Utsname.Release", Field, 0},
		{"Utsname.Sysname", Field, 0},
		{"Utsname.Version", Field, 0},
		{"VDISCARD", Const, 0},
		{"VDSUSP", Const, 1},
		{"VEOF", Const, 0},
		{"VEOL", Const, 0},
		{"VEOL2", Const, 0},
		{"VERASE", Const, 0},
		{"VERASE2", Const, 1},
		{"VINTR", Const, 0},
		{"VKILL", Const, 0},
		{"VLNEXT", Const, 0},
		{"VMIN", Const, 0},
		{"VQUIT", Const, 0},
		{"VREPRINT", Const, 0},
		{"VSTART", Const, 0},
		{"VSTATUS", Const, 1},
		{"VSTOP", Const, 0},
		{"VSUSP", Const, 0},
		{"VSWTC", Const, 0},
		{"VT0", Const, 1},
		{"VT1", Const, 1},
		{"VTDLY", Const, 1},
		{"VTIME", Const, 0},
		{"VWERASE", Const, 0},
		{"VirtualLock", Func, 0},
		{"VirtualUnlock", Func, 0},
		{"WAIT_ABANDONED", Const, 0},
		{"WAIT_FAILED", Const, 0},
		{"WAIT_OBJECT_0", Const, 0},
		{"WAIT_TIMEOUT", Const, 0},
		{"WALL", Const, 0},
		{"WALLSIG", Const, 1},
		{"WALTSIG", Const, 1},
		{"WCLONE", Const, 0},
		{"WCONTINUED", Const, 0},
		{"WCOREFLAG", Const, 0},
		{"WEXITED", Const, 0},
		{"WLINUXCLONE", Const, 0},
		{"WNOHANG", Const, 0},
		{"WNOTHREAD", Const, 0},
		{"WNOWAIT", Const, 0},
		{"WNOZOMBIE", Const, 1},
		{"WOPTSCHECKED", Const, 1},
		{"WORDSIZE", Const, 0},
		{"WSABuf", Type, 0},
		{"WSABuf.Buf", Field, 0},
		{"WSABuf.Len", Field, 0},
		{"WSACleanup", Func, 0},
		{"WSADESCRIPTION_LEN", Const, 0},
		{"WSAData", Type, 0},
		{"WSAData.Description", Field, 0},
		{"WSAData.HighVersion", Field, 0},
		{"WSAData.MaxSockets", Field, 0},
		{"WSAData.MaxUdpDg", Field, 0},
		{"WSAData.SystemStatus", Field, 0},
		{"WSAData.VendorInfo", Field, 0},
		{"WSAData.Version", Field, 0},
		{"WSAEACCES", Const, 2},
		{"WSAECONNABORTED", Const, 9},
		{"WSAECONNRESET", Const, 3},
		{"WSAENOPROTOOPT", Const, 23},
		{"WSAEnumProtocols", Func, 2},
		{"WSAID_CONNECTEX", Var, 1},
		{"WSAIoctl", Func, 0},
		{"WSAPROTOCOL_LEN", Const, 2},
		{"WSAProtocolChain", Type, 2},
		{"WSAProtocolChain.ChainEntries", Field, 2},
		{"WSAProtocolChain.ChainLen", Field, 2},
		{"WSAProtocolInfo", Type, 2},
		{"WSAProtocolInfo.AddressFamily", Field, 2},
		{"WSAProtocolInfo.CatalogEntryId", Field, 2},
		{"WSAProtocolInfo.MaxSockAddr", Field, 2},
		{"WSAProtocolInfo.MessageSize", Field, 2},
		{"WSAProtocolInfo.MinSockAddr", Field, 2},
		{"WSAProtocolInfo.NetworkByteOrder", Field, 2},
		{"WSAProtocolInfo.Protocol", Field, 2},
		{"WSAProtocolInfo.ProtocolChain", Field, 2},
		{"WSAProtocolInfo.ProtocolMaxOffset", Field, 2},
		{"WSAProtocolInfo.ProtocolName", Field, 2},
		{"WSAProtocolInfo.ProviderFlags", Field, 2},
		{"WSAProtocolInfo.ProviderId", Field, 2},
		{"WSAProtocolInfo.ProviderReserved", Field, 2},
		{"WSAProtocolInfo.SecurityScheme", Field, 2},
		{"WSAProtocolInfo.ServiceFlags1", Field, 2},
		{"WSAProtocolInfo.ServiceFlags2", Field, 2},
		{"WSAProtocolInfo.ServiceFlags3", Field, 2},
		{"WSAProtocolInfo.ServiceFlags4", Field, 2},
		{"WSAProtocolInfo.SocketType", Field, 2},
		{"WSAProtocolInfo.Version", Field, 2},
		{"WSARecv", Func, 0},
		{"WSARecvFrom", Func, 0},
		{"WSASYS_STATUS_LEN", Const, 0},
		{"WSASend", Func, 0},
		{"WSASendTo", Func, 0},
		{"WSASendto", Func, 0},
		{"WSAStartup", Func, 0},
		{"WSTOPPED", Const, 0},
		{"WTRAPPED", Const, 1},
		{"WUNTRACED", Const, 0},
		{"Wait4", Func, 0},
		{"WaitForSingleObject", Func, 0},
		{"WaitStatus", Type, 0},
		{"WaitStatus.ExitCode", Field, 0},
		{"Win32FileAttributeData", Type, 0},
		{"Win32FileAttributeData.CreationTime", Field, 0},
		{"Win32FileAttributeData.FileAttributes", Field, 0},
		{"Win32FileAttributeData.FileSizeHigh", Field, 0},
		{"Win32FileAttributeData.FileSizeLow", Field, 0},
		{"Win32FileAttributeData.LastAccessTime", Field, 0},
		{"Win32FileAttributeData.LastWriteTime", Field, 0},
		{"Win32finddata", Type, 0},
		{"Win32finddata.AlternateFileName", Field, 0},
		{"Win32finddata.CreationTime", Field, 0},
		{"Win32finddata.FileAttributes", Field, 0},
		{"Win32finddata.FileName", Field, 0},
		{"Win32finddata.FileSizeHigh", Field, 0},
		{"Win32finddata.FileSizeLow", Field, 0},
		{"Win32finddata.LastAccessTime", Field, 0},
		{"Win32finddata.LastWriteTime", Field, 0},
		{"Win32finddata.Reserved0", Field, 0},
		{"Win32finddata.Reserved1", Field, 0},
		{"Write", Func, 0},
		{"WriteConsole", Func, 1},
		{"WriteFile", Func, 0},
		{"X509_ASN_ENCODING", Const, 0},
		{"XCASE", Const, 0},
		{"XP1_CONNECTIONLESS", Const, 2},
		{"XP1_CONNECT_DATA", Const, 2},
		{"XP1_DISCONNECT_DATA", Const, 2},
		{"XP1_EXPEDITED_DATA", Const, 2},
		{"XP1_GRACEFUL_CLOSE", Const, 2},
		{"XP1_GUARANTEED_DELIVERY", Const, 2},
		{"XP1_GUARANTEED_ORDER", Const, 2},
		{"XP1_IFS_HANDLES", Const, 2},
		{"XP1_MESSAGE_ORIENTED", Const, 2},
		{"XP1_MULTIPOINT_CONTROL_PLANE", Const, 2},
		{"XP1_MULTIPOINT_DATA_PLANE", Const, 2},
		{"XP1_PARTIAL_MESSAGE", Const, 2},
		{"XP1_PSEUDO_STREAM", Const, 2},
		{"XP1_QOS_SUPPORTED", Const, 2},
		{"XP1_SAN_SUPPORT_SDP", Const, 2},
		{"XP1_SUPPORT_BROADCAST", Const, 2},
		{"XP1_SUPPORT_MULTIPOINT", Const, 2},
		{"XP1_UNI_RECV", Const, 2},
		{"XP1_UNI_SEND", Const, 2},
	},
	"syscall/js": {
		{"CopyBytesToGo", Func, 0},
		{"CopyBytesToJS", Func, 0},
		{"Error", Type, 0},
		{"Func", Type, 0},
		{"FuncOf", Func, 0},
		{"Global", Func, 0},
		{"Null", Func, 0},
		{"Type", Type, 0},
		{"TypeBoolean", Const, 0},
		{"TypeFunction", Const, 0},
		{"TypeNull", Const, 0},
		{"TypeNumber", Const, 0},
		{"TypeObject", Const, 0},
		{"TypeString", Const, 0},
		{"TypeSymbol", Const, 0},
		{"TypeUndefined", Const, 0},
		{"Undefined", Func, 0},
		{"Value", Type, 0},
		{"ValueError", Type, 0},
		{"ValueOf", Func, 0},
	},
	"testing": {
		{"(*B).Chdir", Method, 24},
		{"(*B).Cleanup", Method, 14},
		{"(*B).Context", Method, 24},
		{"(*B).Elapsed", Method, 20},
		{"(*B).Error", Method, 0},
		{"(*B).Errorf", Method, 0},
		{"(*B).Fail", Method, 0},
		{"(*B).FailNow", Method, 0},
		{"(*B).Failed", Method, 0},
		{"(*B).Fatal", Method, 0},
		{"(*B).Fatalf", Method, 0},
		{"(*B).Helper", Method, 9},
		{"(*B).Log", Method, 0},
		{"(*B).Logf", Method, 0},
		{"(*B).Loop", Method, 24},
		{"(*B).Name", Method, 8},
		{"(*B).ReportAllocs", Method, 1},
		{"(*B).ReportMetric", Method, 13},
		{"(*B).ResetTimer", Method, 0},
		{"(*B).Run", Method, 7},
		{"(*B).RunParallel", Method, 3},
		{"(*B).SetBytes", Method, 0},
		{"(*B).SetParallelism", Method, 3},
		{"(*B).Setenv", Method, 17},
		{"(*B).Skip", Method, 1},
		{"(*B).SkipNow", Method, 1},
		{"(*B).Skipf", Method, 1},
		{"(*B).Skipped", Method, 1},
		{"(*B).StartTimer", Method, 0},
		{"(*B).StopTimer", Method, 0},
		{"(*B).TempDir", Method, 15},
		{"(*F).Add", Method, 18},
		{"(*F).Chdir", Method, 24},
		{"(*F).Cleanup", Method, 18},
		{"(*F).Context", Method, 24},
		{"(*F).Error", Method, 18},
		{"(*F).Errorf", Method, 18},
		{"(*F).Fail", Method, 18},
		{"(*F).FailNow", Method, 18},
		{"(*F).Failed", Method, 18},
		{"(*F).Fatal", Method, 18},
		{"(*F).Fatalf", Method, 18},
		{"(*F).Fuzz", Method, 18},
		{"(*F).Helper", Method, 18},
		{"(*F).Log", Method, 18},
		{"(*F).Logf", Method, 18},
		{"(*F).Name", Method, 18},
		{"(*F).Setenv", Method, 18},
		{"(*F).Skip", Method, 18},
		{"(*F).SkipNow", Method, 18},
		{"(*F).Skipf", Method, 18},
		{"(*F).Skipped", Method, 18},
		{"(*F).TempDir", Method, 18},
		{"(*M).Run", Method, 4},
		{"(*PB).Next", Method, 3},
		{"(*T).Chdir", Method, 24},
		{"(*T).Cleanup", Method, 14},
		{"(*T).Context", Method, 24},
		{"(*T).Deadline", Method, 15},
		{"(*T).Error", Method, 0},
		{"(*T).Errorf", Method, 0},
		{"(*T).Fail", Method, 0},
		{"(*T).FailNow", Method, 0},
		{"(*T).Failed", Method, 0},
		{"(*T).Fatal", Method, 0},
		{"(*T).Fatalf", Method, 0},
		{"(*T).Helper", Method, 9},
		{"(*T).Log", Method, 0},
		{"(*T).Logf", Method, 0},
		{"(*T).Name", Method, 8},
		{"(*T).Parallel", Method, 0},
		{"(*T).Run", Method, 7},
		{"(*T).Setenv", Method, 17},
		{"(*T).Skip", Method, 1},
		{"(*T).SkipNow", Method, 1},
		{"(*T).Skipf", Method, 1},
		{"(*T).Skipped", Method, 1},
		{"(*T).TempDir", Method, 15},
		{"(BenchmarkResult).AllocedBytesPerOp", Method, 1},
		{"(BenchmarkResult).AllocsPerOp", Method, 1},
		{"(BenchmarkResult).MemString", Method, 1},
		{"(BenchmarkResult).NsPerOp", Method, 0},
		{"(BenchmarkResult).String", Method, 0},
		{"AllocsPerRun", Func, 1},
		{"B", Type, 0},
		{"B.N", Field, 0},
		{"Benchmark", Func, 0},
		{"BenchmarkResult", Type, 0},
		{"BenchmarkResult.Bytes", Field, 0},
		{"BenchmarkResult.Extra", Field, 13},
		{"BenchmarkResult.MemAllocs", Field, 1},
		{"BenchmarkResult.MemBytes", Field, 1},
		{"BenchmarkResult.N", Field, 0},
		{"BenchmarkResult.T", Field, 0},
		{"Cover", Type, 2},
		{"Cover.Blocks", Field, 2},
		{"Cover.Counters", Field, 2},
		{"Cover.CoveredPackages", Field, 2},
		{"Cover.Mode", Field, 2},
		{"CoverBlock", Type, 2},
		{"CoverBlock.Col0", Field, 2},
		{"CoverBlock.Col1", Field, 2},
		{"CoverBlock.Line0", Field, 2},
		{"CoverBlock.Line1", Field, 2},
		{"CoverBlock.Stmts", Field, 2},
		{"CoverMode", Func, 8},
		{"Coverage", Func, 4},
		{"F", Type, 18},
		{"Init", Func, 13},
		{"InternalBenchmark", Type, 0},
		{"InternalBenchmark.F", Field, 0},
		{"InternalBenchmark.Name", Field, 0},
		{"InternalExample", Type, 0},
		{"InternalExample.F", Field, 0},
		{"InternalExample.Name", Field, 0},
		{"InternalExample.Output", Field, 0},
		{"InternalExample.Unordered", Field, 7},
		{"InternalFuzzTarget", Type, 18},
		{"InternalFuzzTarget.Fn", Field, 18},
		{"InternalFuzzTarget.Name", Field, 18},
		{"InternalTest", Type, 0},
		{"InternalTest.F", Field, 0},
		{"InternalTest.Name", Field, 0},
		{"M", Type, 4},
		{"Main", Func, 0},
		{"MainStart", Func, 4},
		{"PB", Type, 3},
		{"RegisterCover", Func, 2},
		{"RunBenchmarks", Func, 0},
		{"RunExamples", Func, 0},
		{"RunTests", Func, 0},
		{"Short", Func, 0},
		{"T", Type, 0},
		{"TB", Type, 2},
		{"Testing", Func, 21},
		{"Verbose", Func, 1},
	},
	"testing/fstest": {
		{"(MapFS).Glob", Method, 16},
		{"(MapFS).Open", Method, 16},
		{"(MapFS).ReadDir", Method, 16},
		{"(MapFS).ReadFile", Method, 16},
		{"(MapFS).Stat", Method, 16},
		{"(MapFS).Sub", Method, 16},
		{"MapFS", Type, 16},
		{"MapFile", Type, 16},
		{"MapFile.Data", Field, 16},
		{"MapFile.ModTime", Field, 16},
		{"MapFile.Mode", Field, 16},
		{"MapFile.Sys", Field, 16},
		{"TestFS", Func, 16},
	},
	"testing/iotest": {
		{"DataErrReader", Func, 0},
		{"ErrReader", Func, 16},
		{"ErrTimeout", Var, 0},
		{"HalfReader", Func, 0},
		{"NewReadLogger", Func, 0},
		{"NewWriteLogger", Func, 0},
		{"OneByteReader", Func, 0},
		{"TestReader", Func, 16},
		{"TimeoutReader", Func, 0},
		{"TruncateWriter", Func, 0},
	},
	"testing/quick": {
		{"(*CheckEqualError).Error", Method, 0},
		{"(*CheckError).Error", Method, 0},
		{"(SetupError).Error", Method, 0},
		{"Check", Func, 0},
		{"CheckEqual", Func, 0},
		{"CheckEqualError", Type, 0},
		{"CheckEqualError.CheckError", Field, 0},
		{"CheckEqualError.Out1", Field, 0},
		{"CheckEqualError.Out2", Field, 0},
		{"CheckError", Type, 0},
		{"CheckError.Count", Field, 0},
		{"CheckError.In", Field, 0},
		{"Config", Type, 0},
		{"Config.MaxCount", Field, 0},
		{"Config.MaxCountScale", Field, 0},
		{"Config.Rand", Field, 0},
		{"Config.Values", Field, 0},
		{"Generator", Type, 0},
		{"SetupError", Type, 0},
		{"Value", Func, 0},
	},
	"testing/slogtest": {
		{"Run", Func, 22},
		{"TestHandler", Func, 21},
	},
	"text/scanner": {
		{"(*Position).IsValid", Method, 0},
		{"(*Scanner).Init", Method, 0},
		{"(*Scanner).IsValid", Method, 0},
		{"(*Scanner).Next", Method, 0},
		{"(*Scanner).Peek", Method, 0},
		{"(*Scanner).Pos", Method, 0},
		{"(*Scanner).Scan", Method, 0},
		{"(*Scanner).TokenText", Method, 0},
		{"(Position).String", Method, 0},
		{"(Scanner).String", Method, 0},
		{"Char", Const, 0},
		{"Comment", Const, 0},
		{"EOF", Const, 0},
		{"Float", Const, 0},
		{"GoTokens", Const, 0},
		{"GoWhitespace", Const, 0},
		{"Ident", Const, 0},
		{"Int", Const, 0},
		{"Position", Type, 0},
		{"Position.Column", Field, 0},
		{"Position.Filename", Field, 0},
		{"Position.Line", Field, 0},
		{"Position.Offset", Field, 0},
		{"RawString", Const, 0},
		{"ScanChars", Const, 0},
		{"ScanComments", Const, 0},
		{"ScanFloats", Const, 0},
		{"ScanIdents", Const, 0},
		{"ScanInts", Const, 0},
		{"ScanRawStrings", Const, 0},
		{"ScanStrings", Const, 0},
		{"Scanner", Type, 0},
		{"Scanner.Error", Field, 0},
		{"Scanner.ErrorCount", Field, 0},
		{"Scanner.IsIdentRune", Field, 4},
		{"Scanner.Mode", Field, 0},
		{"Scanner.Position", Field, 0},
		{"Scanner.Whitespace", Field, 0},
		{"SkipComments", Const, 0},
		{"String", Const, 0},
		{"TokenString", Func, 0},
	},
	"text/tabwriter": {
		{"(*Writer).Flush", Method, 0},
		{"(*Writer).Init", Method, 0},
		{"(*Writer).Write", Method, 0},
		{"AlignRight", Const, 0},
		{"Debug", Const, 0},
		{"DiscardEmptyColumns", Const, 0},
		{"Escape", Const, 0},
		{"FilterHTML", Const, 0},
		{"NewWriter", Func, 0},
		{"StripEscape", Const, 0},
		{"TabIndent", Const, 0},
		{"Writer", Type, 0},
	},
	"text/template": {
		{"(*Template).AddParseTree", Method, 0},
		{"(*Template).Clone", Method, 0},
		{"(*Template).DefinedTemplates", Method, 5},
		{"(*Template).Delims", Method, 0},
		{"(*Template).Execute", Method, 0},
		{"(*Template).ExecuteTemplate", Method, 0},
		{"(*Template).Funcs", Method, 0},
		{"(*Template).Lookup", Method, 0},
		{"(*Template).Name", Method, 0},
		{"(*Template).New", Method, 0},
		{"(*Template).Option", Method, 5},
		{"(*Template).Parse", Method, 0},
		{"(*Template).ParseFS", Method, 16},
		{"(*Template).ParseFiles", Method, 0},
		{"(*Template).ParseGlob", Method, 0},
		{"(*Template).Templates", Method, 0},
		{"(ExecError).Error", Method, 6},
		{"(ExecError).Unwrap", Method, 13},
		{"(Template).Copy", Method, 2},
		{"(Template).ErrorContext", Method, 1},
		{"ExecError", Type, 6},
		{"ExecError.Err", Field, 6},
		{"ExecError.Name", Field, 6},
		{"FuncMap", Type, 0},
		{"HTMLEscape", Func, 0},
		{"HTMLEscapeString", Func, 0},
		{"HTMLEscaper", Func, 0},
		{"IsTrue", Func, 6},
		{"JSEscape", Func, 0},
		{"JSEscapeString", Func, 0},
		{"JSEscaper", Func, 0},
		{"Must", Func, 0},
		{"New", Func, 0},
		{"ParseFS", Func, 16},
		{"ParseFiles", Func, 0},
		{"ParseGlob", Func, 0},
		{"Template", Type, 0},
		{"Template.Tree", Field, 0},
		{"URLQueryEscaper", Func, 0},
	},
	"text/template/parse": {
		{"(*ActionNode).Copy", Method, 0},
		{"(*ActionNode).String", Method, 0},
		{"(*BoolNode).Copy", Method, 0},
		{"(*BoolNode).String", Method, 0},
		{"(*BranchNode).Copy", Method, 4},
		{"(*BranchNode).String", Method, 0},
		{"(*BreakNode).Copy", Method, 18},
		{"(*BreakNode).String", Method, 18},
		{"(*ChainNode).Add", Method, 1},
		{"(*ChainNode).Copy", Method, 1},
		{"(*ChainNode).String", Method, 1},
		{"(*CommandNode).Copy", Method, 0},
		{"(*CommandNode).String", Method, 0},
		{"(*CommentNode).Copy", Method, 16},
		{"(*CommentNode).String", Method, 16},
		{"(*ContinueNode).Copy", Method, 18},
		{"(*ContinueNode).String", Method, 18},
		{"(*DotNode).Copy", Method, 0},
		{"(*DotNode).String", Method, 0},
		{"(*DotNode).Type", Method, 0},
		{"(*FieldNode).Copy", Method, 0},
		{"(*FieldNode).String", Method, 0},
		{"(*IdentifierNode).Copy", Method, 0},
		{"(*IdentifierNode).SetPos", Method, 1},
		{"(*IdentifierNode).SetTree", Method, 4},
		{"(*IdentifierNode).String", Method, 0},
		{"(*IfNode).Copy", Method, 0},
		{"(*IfNode).String", Method, 0},
		{"(*ListNode).Copy", Method, 0},
		{"(*ListNode).CopyList", Method, 0},
		{"(*ListNode).String", Method, 0},
		{"(*NilNode).Copy", Method, 1},
		{"(*NilNode).String", Method, 1},
		{"(*NilNode).Type", Method, 1},
		{"(*NumberNode).Copy", Method, 0},
		{"(*NumberNode).String", Method, 0},
		{"(*PipeNode).Copy", Method, 0},
		{"(*PipeNode).CopyPipe", Method, 0},
		{"(*PipeNode).String", Method, 0},
		{"(*RangeNode).Copy", Method, 0},
		{"(*RangeNode).String", Method, 0},
		{"(*StringNode).Copy", Method, 0},
		{"(*StringNode).String", Method, 0},
		{"(*TemplateNode).Copy", Method, 0},
		{"(*TemplateNode).String", Method, 0},
		{"(*TextNode).Copy", Method, 0},
		{"(*TextNode).String", Method, 0},
		{"(*Tree).Copy", Method, 2},
		{"(*Tree).ErrorContext", Method, 1},
		{"(*Tree).Parse", Method, 0},
		{"(*VariableNode).Copy", Method, 0},
		{"(*VariableNode).String", Method, 0},
		{"(*WithNode).Copy", Method, 0},
		{"(*WithNode).String", Method, 0},
		{"(ActionNode).Position", Method, 1},
		{"(ActionNode).Type", Method, 0},
		{"(BoolNode).Position", Method, 1},
		{"(BoolNode).Type", Method, 0},
		{"(BranchNode).Position", Method, 1},
		{"(BranchNode).Type", Method, 0},
		{"(BreakNode).Position", Method, 18},
		{"(BreakNode).Type", Method, 18},
		{"(ChainNode).Position", Method, 1},
		{"(ChainNode).Type", Method, 1},
		{"(CommandNode).Position", Method, 1},
		{"(CommandNode).Type", Method, 0},
		{"(CommentNode).Position", Method, 16},
		{"(CommentNode).Type", Method, 16},
		{"(ContinueNode).Position", Method, 18},
		{"(ContinueNode).Type", Method, 18},
		{"(DotNode).Position", Method, 1},
		{"(FieldNode).Position", Method, 1},
		{"(FieldNode).Type", Method, 0},
		{"(IdentifierNode).Position", Method, 1},
		{"(IdentifierNode).Type", Method, 0},
		{"(IfNode).Position", Method, 1},
		{"(IfNode).Type", Method, 0},
		{"(ListNode).Position", Method, 1},
		{"(ListNode).Type", Method, 0},
		{"(NilNode).Position", Method, 1},
		{"(NodeType).Type", Method, 0},
		{"(NumberNode).Position", Method, 1},
		{"(NumberNode).Type", Method, 0},
		{"(PipeNode).Position", Method, 1},
		{"(PipeNode).Type", Method, 0},
		{"(Pos).Position", Method, 1},
		{"(RangeNode).Position", Method, 1},
		{"(RangeNode).Type", Method, 0},
		{"(StringNode).Position", Method, 1},
		{"(StringNode).Type", Method, 0},
		{"(TemplateNode).Position", Method, 1},
		{"(TemplateNode).Type", Method, 0},
		{"(TextNode).Position", Method, 1},
		{"(TextNode).Type", Method, 0},
		{"(VariableNode).Position", Method, 1},
		{"(VariableNode).Type", Method, 0},
		{"(WithNode).Position", Method, 1},
		{"(WithNode).Type", Method, 0},
		{"ActionNode", Type, 0},
		{"ActionNode.Line", Field, 0},
		{"ActionNode.NodeType", Field, 0},
		{"ActionNode.Pipe", Field, 0},
		{"ActionNode.Pos", Field, 1},
		{"BoolNode", Type, 0},
		{"BoolNode.NodeType", Field, 0},
		{"BoolNode.Pos", Field, 1},
		{"BoolNode.True", Field, 0},
		{"BranchNode", Type, 0},
		{"BranchNode.ElseList", Field, 0},
		{"BranchNode.Line", Field, 0},
		{"BranchNode.List", Field, 0},
		{"BranchNode.NodeType", Field, 0},
		{"BranchNode.Pipe", Field, 0},
		{"BranchNode.Pos", Field, 1},
		{"BreakNode", Type, 18},
		{"BreakNode.Line", Field, 18},
		{"BreakNode.NodeType", Field, 18},
		{"BreakNode.Pos", Field, 18},
		{"ChainNode", Type, 1},
		{"ChainNode.Field", Field, 1},
		{"ChainNode.Node", Field, 1},
		{"ChainNode.NodeType", Field, 1},
		{"ChainNode.Pos", Field, 1},
		{"CommandNode", Type, 0},
		{"CommandNode.Args", Field, 0},
		{"CommandNode.NodeType", Field, 0},
		{"CommandNode.Pos", Field, 1},
		{"CommentNode", Type, 16},
		{"CommentNode.NodeType", Field, 16},
		{"CommentNode.Pos", Field, 16},
		{"CommentNode.Text", Field, 16},
		{"ContinueNode", Type, 18},
		{"ContinueNode.Line", Field, 18},
		{"ContinueNode.NodeType", Field, 18},
		{"ContinueNode.Pos", Field, 18},
		{"DotNode", Type, 0},
		{"DotNode.NodeType", Field, 4},
		{"DotNode.Pos", Field, 1},
		{"FieldNode", Type, 0},
		{"FieldNode.Ident", Field, 0},
		{"FieldNode.NodeType", Field, 0},
		{"FieldNode.Pos", Field, 1},
		{"IdentifierNode", Type, 0},
		{"IdentifierNode.Ident", Field, 0},
		{"IdentifierNode.NodeType", Field, 0},
		{"IdentifierNode.Pos", Field, 1},
		{"IfNode", Type, 0},
		{"IfNode.BranchNode", Field, 0},
		{"IsEmptyTree", Func, 0},
		{"ListNode", Type, 0},
		{"ListNode.NodeType", Field, 0},
		{"ListNode.Nodes", Field, 0},
		{"ListNode.Pos", Field, 1},
		{"Mode", Type, 16},
		{"New", Func, 0},
		{"NewIdentifier", Func, 0},
		{"NilNode", Type, 1},
		{"NilNode.NodeType", Field, 4},
		{"NilNode.Pos", Field, 1},
		{"Node", Type, 0},
		{"NodeAction", Const, 0},
		{"NodeBool", Const, 0},
		{"NodeBreak", Const, 18},
		{"NodeChain", Const, 1},
		{"NodeCommand", Const, 0},
		{"NodeComment", Const, 16},
		{"NodeContinue", Const, 18},
		{"NodeDot", Const, 0},
		{"NodeField", Const, 0},
		{"NodeIdentifier", Const, 0},
		{"NodeIf", Const, 0},
		{"NodeList", Const, 0},
		{"NodeNil", Const, 1},
		{"NodeNumber", Const, 0},
		{"NodePipe", Const, 0},
		{"NodeRange", Const, 0},
		{"NodeString", Const, 0},
		{"NodeTemplate", Const, 0},
		{"NodeText", Const, 0},
		{"NodeType", Type, 0},
		{"NodeVariable", Const, 0},
		{"NodeWith", Const, 0},
		{"NumberNode", Type, 0},
		{"NumberNode.Complex128", Field, 0},
		{"NumberNode.Float64", Field, 0},
		{"NumberNode.Int64", Field, 0},
		{"NumberNode.IsComplex", Field, 0},
		{"NumberNode.IsFloat", Field, 0},
		{"NumberNode.IsInt", Field, 0},
		{"NumberNode.IsUint", Field, 0},
		{"NumberNode.NodeType", Field, 0},
		{"NumberNode.Pos", Field, 1},
		{"NumberNode.Text", Field, 0},
		{"NumberNode.Uint64", Field, 0},
		{"Parse", Func, 0},
		{"ParseComments", Const, 16},
		{"PipeNode", Type, 0},
		{"PipeNode.Cmds", Field, 0},
		{"PipeNode.Decl", Field, 0},
		{"PipeNode.IsAssign", Field, 11},
		{"PipeNode.Line", Field, 0},
		{"PipeNode.NodeType", Field, 0},
		{"PipeNode.Pos", Field, 1},
		{"Pos", Type, 1},
		{"RangeNode", Type, 0},
		{"RangeNode.BranchNode", Field, 0},
		{"SkipFuncCheck", Const, 17},
		{"StringNode", Type, 0},
		{"StringNode.NodeType", Field, 0},
		{"StringNode.Pos", Field, 1},
		{"StringNode.Quoted", Field, 0},
		{"StringNode.Text", Field, 0},
		{"TemplateNode", Type, 0},
		{"TemplateNode.Line", Field, 0},
		{"TemplateNode.Name", Field, 0},
		{"TemplateNode.NodeType", Field, 0},
		{"TemplateNode.Pipe", Field, 0},
		{"TemplateNode.Pos", Field, 1},
		{"TextNode", Type, 0},
		{"TextNode.NodeType", Field, 0},
		{"TextNode.Pos", Field, 1},
		{"TextNode.Text", Field, 0},
		{"Tree", Type, 0},
		{"Tree.Mode", Field, 16},
		{"Tree.Name", Field, 0},
		{"Tree.ParseName", Field, 1},
		{"Tree.Root", Field, 0},
		{"VariableNode", Type, 0},
		{"VariableNode.Ident", Field, 0},
		{"VariableNode.NodeType", Field, 0},
		{"VariableNode.Pos", Field, 1},
		{"WithNode", Type, 0},
		{"WithNode.BranchNode", Field, 0},
	},
	"time": {
		{"(*Location).String", Method, 0},
		{"(*ParseError).Error", Method, 0},
		{"(*Ticker).Reset", Method, 15},
		{"(*Ticker).Stop", Method, 0},
		{"(*Time).GobDecode", Method, 0},
		{"(*Time).UnmarshalBinary", Method, 2},
		{"(*Time).UnmarshalJSON", Method, 0},
		{"(*Time).UnmarshalText", Method, 2},
		{"(*Timer).Reset", Method, 1},
		{"(*Timer).Stop", Method, 0},
		{"(Duration).Abs", Method, 19},
		{"(Duration).Hours", Method, 0},
		{"(Duration).Microseconds", Method, 13},
		{"(Duration).Milliseconds", Method, 13},
		{"(Duration).Minutes", Method, 0},
		{"(Duration).Nanoseconds", Method, 0},
		{"(Duration).Round", Method, 9},
		{"(Duration).Seconds", Method, 0},
		{"(Duration).String", Method, 0},
		{"(Duration).Truncate", Method, 9},
		{"(Month).String", Method, 0},
		{"(Time).Add", Method, 0},
		{"(Time).AddDate", Method, 0},
		{"(Time).After", Method, 0},
		{"(Time).AppendBinary", Method, 24},
		{"(Time).AppendFormat", Method, 5},
		{"(Time).AppendText", Method, 24},
		{"(Time).Before", Method, 0},
		{"(Time).Clock", Method, 0},
		{"(Time).Compare", Method, 20},
		{"(Time).Date", Method, 0},
		{"(Time).Day", Method, 0},
		{"(Time).Equal", Method, 0},
		{"(Time).Format", Method, 0},
		{"(Time).GoString", Method, 17},
		{"(Time).GobEncode", Method, 0},
		{"(Time).Hour", Method, 0},
		{"(Time).ISOWeek", Method, 0},
		{"(Time).In", Method, 0},
		{"(Time).IsDST", Method, 17},
		{"(Time).IsZero", Method, 0},
		{"(Time).Local", Method, 0},
		{"(Time).Location", Method, 0},
		{"(Time).MarshalBinary", Method, 2},
		{"(Time).MarshalJSON", Method, 0},
		{"(Time).MarshalText", Method, 2},
		{"(Time).Minute", Method, 0},
		{"(Time).Month", Method, 0},
		{"(Time).Nanosecond", Method, 0},
		{"(Time).Round", Method, 1},
		{"(Time).Second", Method, 0},
		{"(Time).String", Method, 0},
		{"(Time).Sub", Method, 0},
		{"(Time).Truncate", Method, 1},
		{"(Time).UTC", Method, 0},
		{"(Time).Unix", Method, 0},
		{"(Time).UnixMicro", Method, 17},
		{"(Time).UnixMilli", Method, 17},
		{"(Time).UnixNano", Method, 0},
		{"(Time).Weekday", Method, 0},
		{"(Time).Year", Method, 0},
		{"(Time).YearDay", Method, 1},
		{"(Time).Zone", Method, 0},
		{"(Time).ZoneBounds", Method, 19},
		{"(Weekday).String", Method, 0},
		{"ANSIC", Const, 0},
		{"After", Func, 0},
		{"AfterFunc", Func, 0},
		{"April", Const, 0},
		{"August", Const, 0},
		{"Date", Func, 0},
		{"DateOnly", Const, 20},
		{"DateTime", Const, 20},
		{"December", Const, 0},
		{"Duration", Type, 0},
		{"February", Const, 0},
		{"FixedZone", Func, 0},
		{"Friday", Const, 0},
		{"Hour", Const, 0},
		{"January", Const, 0},
		{"July", Const, 0},
		{"June", Const, 0},
		{"Kitchen", Const, 0},
		{"Layout", Const, 17},
		{"LoadLocation", Func, 0},
		{"LoadLocationFromTZData", Func, 10},
		{"Local", Var, 0},
		{"Location", Type, 0},
		{"March", Const, 0},
		{"May", Const, 0},
		{"Microsecond", Const, 0},
		{"Millisecond", Const, 0},
		{"Minute", Const, 0},
		{"Monday", Const, 0},
		{"Month", Type, 0},
		{"Nanosecond", Const, 0},
		{"NewTicker", Func, 0},
		{"NewTimer", Func, 0},
		{"November", Const, 0},
		{"Now", Func, 0},
		{"October", Const, 0},
		{"Parse", Func, 0},
		{"ParseDuration", Func, 0},
		{"ParseError", Type, 0},
		{"ParseError.Layout", Field, 0},
		{"ParseError.LayoutElem", Field, 0},
		{"ParseError.Message", Field, 0},
		{"ParseError.Value", Field, 0},
		{"ParseError.ValueElem", Field, 0},
		{"ParseInLocation", Func, 1},
		{"RFC1123", Const, 0},
		{"RFC1123Z", Const, 0},
		{"RFC3339", Const, 0},
		{"RFC3339Nano", Const, 0},
		{"RFC822", Const, 0},
		{"RFC822Z", Const, 0},
		{"RFC850", Const, 0},
		{"RubyDate", Const, 0},
		{"Saturday", Const, 0},
		{"Second", Const, 0},
		{"September", Const, 0},
		{"Since", Func, 0},
		{"Sleep", Func, 0},
		{"Stamp", Const, 0},
		{"StampMicro", Const, 0},
		{"StampMilli", Const, 0},
		{"StampNano", Const, 0},
		{"Sunday", Const, 0},
		{"Thursday", Const, 0},
		{"Tick", Func, 0},
		{"Ticker", Type, 0},
		{"Ticker.C", Field, 0},
		{"Time", Type, 0},
		{"TimeOnly", Const, 20},
		{"Timer", Type, 0},
		{"Timer.C", Field, 0},
		{"Tuesday", Const, 0},
		{"UTC", Var, 0},
		{"Unix", Func, 0},
		{"UnixDate", Const, 0},
		{"UnixMicro", Func, 17},
		{"UnixMilli", Func, 17},
		{"Until", Func, 8},
		{"Wednesday", Const, 0},
		{"Weekday", Type, 0},
	},
	"unicode": {
		{"(SpecialCase).ToLower", Method, 0},
		{"(SpecialCase).ToTitle", Method, 0},
		{"(SpecialCase).ToUpper", Method, 0},
		{"ASCII_Hex_Digit", Var, 0},
		{"Adlam", Var, 7},
		{"Ahom", Var, 5},
		{"Anatolian_Hieroglyphs", Var, 5},
		{"Arabic", Var, 0},
		{"Armenian", Var, 0},
		{"Avestan", Var, 0},
		{"AzeriCase", Var, 0},
		{"Balinese", Var, 0},
		{"Bamum", Var, 0},
		{"Bassa_Vah", Var, 4},
		{"Batak", Var, 0},
		{"Bengali", Var, 0},
		{"Bhaiksuki", Var, 7},
		{"Bidi_Control", Var, 0},
		{"Bopomofo", Var, 0},
		{"Brahmi", Var, 0},
		{"Braille", Var, 0},
		{"Buginese", Var, 0},
		{"Buhid", Var, 0},
		{"C", Var, 0},
		{"Canadian_Aboriginal", Var, 0},
		{"Carian", Var, 0},
		{"CaseRange", Type, 0},
		{"CaseRange.Delta", Field, 0},
		{"CaseRange.Hi", Field, 0},
		{"CaseRange.Lo", Field, 0},
		{"CaseRanges", Var, 0},
		{"Categories", Var, 0},
		{"Caucasian_Albanian", Var, 4},
		{"Cc", Var, 0},
		{"Cf", Var, 0},
		{"Chakma", Var, 1},
		{"Cham", Var, 0},
		{"Cherokee", Var, 0},
		{"Chorasmian", Var, 16},
		{"Co", Var, 0},
		{"Common", Var, 0},
		{"Coptic", Var, 0},
		{"Cs", Var, 0},
		{"Cuneiform", Var, 0},
		{"Cypriot", Var, 0},
		{"Cypro_Minoan", Var, 21},
		{"Cyrillic", Var, 0},
		{"Dash", Var, 0},
		{"Deprecated", Var, 0},
		{"Deseret", Var, 0},
		{"Devanagari", Var, 0},
		{"Diacritic", Var, 0},
		{"Digit", Var, 0},
		{"Dives_Akuru", Var, 16},
		{"Dogra", Var, 13},
		{"Duployan", Var, 4},
		{"Egyptian_Hieroglyphs", Var, 0},
		{"Elbasan", Var, 4},
		{"Elymaic", Var, 14},
		{"Ethiopic", Var, 0},
		{"Extender", Var, 0},
		{"FoldCategory", Var, 0},
		{"FoldScript", Var, 0},
		{"Georgian", Var, 0},
		{"Glagolitic", Var, 0},
		{"Gothic", Var, 0},
		{"Grantha", Var, 4},
		{"GraphicRanges", Var, 0},
		{"Greek", Var, 0},
		{"Gujarati", Var, 0},
		{"Gunjala_Gondi", Var, 13},
		{"Gurmukhi", Var, 0},
		{"Han", Var, 0},
		{"Hangul", Var, 0},
		{"Hanifi_Rohingya", Var, 13},
		{"Hanunoo", Var, 0},
		{"Hatran", Var, 5},
		{"Hebrew", Var, 0},
		{"Hex_Digit", Var, 0},
		{"Hiragana", Var, 0},
		{"Hyphen", Var, 0},
		{"IDS_Binary_Operator", Var, 0},
		{"IDS_Trinary_Operator", Var, 0},
		{"Ideographic", Var, 0},
		{"Imperial_Aramaic", Var, 0},
		{"In", Func, 2},
		{"Inherited", Var, 0},
		{"Inscriptional_Pahlavi", Var, 0},
		{"Inscriptional_Parthian", Var, 0},
		{"Is", Func, 0},
		{"IsControl", Func, 0},
		{"IsDigit", Func, 0},
		{"IsGraphic", Func, 0},
		{"IsLetter", Func, 0},
		{"IsLower", Func, 0},
		{"IsMark", Func, 0},
		{"IsNumber", Func, 0},
		{"IsOneOf", Func, 0},
		{"IsPrint", Func, 0},
		{"IsPunct", Func, 0},
		{"IsSpace", Func, 0},
		{"IsSymbol", Func, 0},
		{"IsTitle", Func, 0},
		{"IsUpper", Func, 0},
		{"Javanese", Var, 0},
		{"Join_Control", Var, 0},
		{"Kaithi", Var, 0},
		{"Kannada", Var, 0},
		{"Katakana", Var, 0},
		{"Kawi", Var, 21},
		{"Kayah_Li", Var, 0},
		{"Kharoshthi", Var, 0},
		{"Khitan_Small_Script", Var, 16},
		{"Khmer", Var, 0},
		{"Khojki", Var, 4},
		{"Khudawadi", Var, 4},
		{"L", Var, 0},
		{"Lao", Var, 0},
		{"Latin", Var, 0},
		{"Lepcha", Var, 0},
		{"Letter", Var, 0},
		{"Limbu", Var, 0},
		{"Linear_A", Var, 4},
		{"Linear_B", Var, 0},
		{"Lisu", Var, 0},
		{"Ll", Var, 0},
		{"Lm", Var, 0},
		{"Lo", Var, 0},
		{"Logical_Order_Exception", Var, 0},
		{"Lower", Var, 0},
		{"LowerCase", Const, 0},
		{"Lt", Var, 0},
		{"Lu", Var, 0},
		{"Lycian", Var, 0},
		{"Lydian", Var, 0},
		{"M", Var, 0},
		{"Mahajani", Var, 4},
		{"Makasar", Var, 13},
		{"Malayalam", Var, 0},
		{"Mandaic", Var, 0},
		{"Manichaean", Var, 4},
		{"Marchen", Var, 7},
		{"Mark", Var, 0},
		{"Masaram_Gondi", Var, 10},
		{"MaxASCII", Const, 0},
		{"MaxCase", Const, 0},
		{"MaxLatin1", Const, 0},
		{"MaxRune", Const, 0},
		{"Mc", Var, 0},
		{"Me", Var, 0},
		{"Medefaidrin", Var, 13},
		{"Meetei_Mayek", Var, 0},
		{"Mende_Kikakui", Var, 4},
		{"Meroitic_Cursive", Var, 1},
		{"Meroitic_Hieroglyphs", Var, 1},
		{"Miao", Var, 1},
		{"Mn", Var, 0},
		{"Modi", Var, 4},
		{"Mongolian", Var, 0},
		{"Mro", Var, 4},
		{"Multani", Var, 5},
		{"Myanmar", Var, 0},
		{"N", Var, 0},
		{"Nabataean", Var, 4},
		{"Nag_Mundari", Var, 21},
		{"Nandinagari", Var, 14},
		{"Nd", Var, 0},
		{"New_Tai_Lue", Var, 0},
		{"Newa", Var, 7},
		{"Nko", Var, 0},
		{"Nl", Var, 0},
		{"No", Var, 0},
		{"Noncharacter_Code_Point", Var, 0},
		{"Number", Var, 0},
		{"Nushu", Var, 10},
		{"Nyiakeng_Puachue_Hmong", Var, 14},
		{"Ogham", Var, 0},
		{"Ol_Chiki", Var, 0},
		{"Old_Hungarian", Var, 5},
		{"Old_Italic", Var, 0},
		{"Old_North_Arabian", Var, 4},
		{"Old_Permic", Var, 4},
		{"Old_Persian", Var, 0},
		{"Old_Sogdian", Var, 13},
		{"Old_South_Arabian", Var, 0},
		{"Old_Turkic", Var, 0},
		{"Old_Uyghur", Var, 21},
		{"Oriya", Var, 0},
		{"Osage", Var, 7},
		{"Osmanya", Var, 0},
		{"Other", Var, 0},
		{"Other_Alphabetic", Var, 0},
		{"Other_Default_Ignorable_Code_Point", Var, 0},
		{"Other_Grapheme_Extend", Var, 0},
		{"Other_ID_Continue", Var, 0},
		{"Other_ID_Start", Var, 0},
		{"Other_Lowercase", Var, 0},
		{"Other_Math", Var, 0},
		{"Other_Uppercase", Var, 0},
		{"P", Var, 0},
		{"Pahawh_Hmong", Var, 4},
		{"Palmyrene", Var, 4},
		{"Pattern_Syntax", Var, 0},
		{"Pattern_White_Space", Var, 0},
		{"Pau_Cin_Hau", Var, 4},
		{"Pc", Var, 0},
		{"Pd", Var, 0},
		{"Pe", Var, 0},
		{"Pf", Var, 0},
		{"Phags_Pa", Var, 0},
		{"Phoenician", Var, 0},
		{"Pi", Var, 0},
		{"Po", Var, 0},
		{"Prepended_Concatenation_Mark", Var, 7},
		{"PrintRanges", Var, 0},
		{"Properties", Var, 0},
		{"Ps", Var, 0},
		{"Psalter_Pahlavi", Var, 4},
		{"Punct", Var, 0},
		{"Quotation_Mark", Var, 0},
		{"Radical", Var, 0},
		{"Range16", Type, 0},
		{"Range16.Hi", Field, 0},
		{"Range16.Lo", Field, 0},
		{"Range16.Stride", Field, 0},
		{"Range32", Type, 0},
		{"Range32.Hi", Field, 0},
		{"Range32.Lo", Field, 0},
		{"Range32.Stride", Field, 0},
		{"RangeTable", Type, 0},
		{"RangeTable.LatinOffset", Field, 1},
		{"RangeTable.R16", Field, 0},
		{"RangeTable.R32", Field, 0},
		{"Regional_Indicator", Var, 10},
		{"Rejang", Var, 0},
		{"ReplacementChar", Const, 0},
		{"Runic", Var, 0},
		{"S", Var, 0},
		{"STerm", Var, 0},
		{"Samaritan", Var, 0},
		{"Saurashtra", Var, 0},
		{"Sc", Var, 0},
		{"Scripts", Var, 0},
		{"Sentence_Terminal", Var, 7},
		{"Sharada", Var, 1},
		{"Shavian", Var, 0},
		{"Siddham", Var, 4},
		{"SignWriting", Var, 5},
		{"SimpleFold", Func, 0},
		{"Sinhala", Var, 0},
		{"Sk", Var, 0},
		{"Sm", Var, 0},
		{"So", Var, 0},
		{"Soft_Dotted", Var, 0},
		{"Sogdian", Var, 13},
		{"Sora_Sompeng", Var, 1},
		{"Soyombo", Var, 10},
		{"Space", Var, 0},
		{"SpecialCase", Type, 0},
		{"Sundanese", Var, 0},
		{"Syloti_Nagri", Var, 0},
		{"Symbol", Var, 0},
		{"Syriac", Var, 0},
		{"Tagalog", Var, 0},
		{"Tagbanwa", Var, 0},
		{"Tai_Le", Var, 0},
		{"Tai_Tham", Var, 0},
		{"Tai_Viet", Var, 0},
		{"Takri", Var, 1},
		{"Tamil", Var, 0},
		{"Tangsa", Var, 21},
		{"Tangut", Var, 7},
		{"Telugu", Var, 0},
		{"Terminal_Punctuation", Var, 0},
		{"Thaana", Var, 0},
		{"Thai", Var, 0},
		{"Tibetan", Var, 0},
		{"Tifinagh", Var, 0},
		{"Tirhuta", Var, 4},
		{"Title", Var, 0},
		{"TitleCase", Const, 0},
		{"To", Func, 0},
		{"ToLower", Func, 0},
		{"ToTitle", Func, 0},
		{"ToUpper", Func, 0},
		{"Toto", Var, 21},
		{"TurkishCase", Var, 0},
		{"Ugaritic", Var, 0},
		{"Unified_Ideograph", Var, 0},
		{"Upper", Var, 0},
		{"UpperCase", Const, 0},
		{"UpperLower", Const, 0},
		{"Vai", Var, 0},
		{"Variation_Selector", Var, 0},
		{"Version", Const, 0},
		{"Vithkuqi", Var, 21},
		{"Wancho", Var, 14},
		{"Warang_Citi", Var, 4},
		{"White_Space", Var, 0},
		{"Yezidi", Var, 16},
		{"Yi", Var, 0},
		{"Z", Var, 0},
		{"Zanabazar_Square", Var, 10},
		{"Zl", Var, 0},
		{"Zp", Var, 0},
		{"Zs", Var, 0},
	},
	"unicode/utf16": {
		{"AppendRune", Func, 20},
		{"Decode", Func, 0},
		{"DecodeRune", Func, 0},
		{"Encode", Func, 0},
		{"EncodeRune", Func, 0},
		{"IsSurrogate", Func, 0},
		{"RuneLen", Func, 23},
	},
	"unicode/utf8": {
		{"AppendRune", Func, 18},
		{"DecodeLastRune", Func, 0},
		{"DecodeLastRuneInString", Func, 0},
		{"DecodeRune", Func, 0},
		{"DecodeRuneInString", Func, 0},
		{"EncodeRune", Func, 0},
		{"FullRune", Func, 0},
		{"FullRuneInString", Func, 0},
		{"MaxRune", Const, 0},
		{"RuneCount", Func, 0},
		{"RuneCountInString", Func, 0},
		{"RuneError", Const, 0},
		{"RuneLen", Func, 0},
		{"RuneSelf", Const, 0},
		{"RuneStart", Func, 0},
		{"UTFMax", Const, 0},
		{"Valid", Func, 0},
		{"ValidRune", Func, 1},
		{"ValidString", Func, 0},
	},
	"unique": {
		{"(Handle).Value", Method, 23},
		{"Handle", Type, 23},
		{"Make", Func, 23},
	},
	"unsafe": {
		{"Add", Func, 0},
		{"Alignof", Func, 0},
		{"Offsetof", Func, 0},
		{"Pointer", Type, 0},
		{"Sizeof", Func, 0},
		{"Slice", Func, 0},
		{"SliceData", Func, 0},
		{"String", Func, 0},
		{"StringData", Func, 0},
	},
	"weak": {
		{"(Pointer).Value", Method, 24},
		{"Make", Func, 24},
		{"Pointer", Type, 24},
	},
}
